# Function defined to select bodies by name

def onClickSelect(ag):
	#Empty list for adding bodies of interest.
	body_list = []
	
	# Selection by Name
	for body in ExtAPI.DataModel.GeoData.Bodies: 	# body loop using for statement
		if body.Name == "Solid": 					# condition to check the name of the body
			body_list.append(body) 						# Adding body to the list
	
	sel = ExtAPI.SelectionManager.CreateSelectionInfo(SelectionTypeEnum.GeometryEntities) # Create selection info object
	sel.Entities = body_list # Adding entities from the list
	ExtAPI.SelectionManager.AddSelection(sel) # Adding the selection info object to the selection manager
	ExtAPI.Graphics.Redraw() # Redraw graphics window for the latest selection
	return True
