# Function defined to add custom feature to tree
# This function is called when user clicks on tool bar entry

import units
def createPriFeature(ag):
    ExtAPI.CreateFeature("PriFeature") # Custom Feature name from simdata tag of XML
    
    
def isBoxDetailsVisible(geometry_feature, property):
    if geometry_feature.Properties["Primitive Object"].Value == "Box":
        return True
    else:
        return False
        
def isSphereDetailsVisible(geometry_feature, property):
    if geometry_feature.Properties["Primitive Object"].Value == "Sphere":
        return True
    else:
        return False
    
def isCylinderDetailsVisible(geometry_feature, property):
    if geometry_feature.Properties["Primitive Object"].Value == "Cylinder":
        return True
    else:
        return False
        

# This function is called when user clicks on generate button after adding custom feature to tree
def generatePriFeature(feature,fct):

    # Following code is used to write messages to log file
    ExtAPI.Log.WriteMessage("Generating PriFeature...")
    ExtAPI.Log.WriteMessage("........................")
        
    # Collect all property values in meter unit
    fromUnit, toUnit = ExtAPI.DataModel.CurrentUnitFromQuantityName("Length"), "m"
    
    builder = ExtAPI.DataModel.GeometryBuilder
    bodies = []
    
    # Access custom feature properties using names defined for them
    primitive_option = feature.Properties["Primitive Object"].Value
    
    # Get different properties of Sphere
    if primitive_option == "Sphere":
        radius = units.ConvertUnit(feature.Properties["Sphere Details/Radius"].Value, fromUnit, toUnit)
        ExtAPI.Log.WriteMessage("Sphere Radius : "+ radius.ToString())
    
        # Use CreateSphere from Solid object and generate body
        sphere_generator = builder.Primitives.Solid.CreateSphere([0.,0.,0.],radius)
        body = sphere_generator.Generate()
    
    # Get different properties of Box
    box_properties = feature.Properties["Box Details"]
    if primitive_option == "Box":
        length= units.ConvertUnit(box_properties.Properties["Length"].Value, fromUnit, toUnit)
        width = units.ConvertUnit(box_properties.Properties["Width"].Value, fromUnit, toUnit)
        thickness = units.ConvertUnit(box_properties.Properties["Thickness"].Value, fromUnit, toUnit)
        
        ExtAPI.Log.WriteMessage("Box Length: " + length.ToString() + "; Box Width: " + width.ToString() + "; Box Thickness: " + thickness.ToString())
        
        # Use CreateBox from Solid object and generate body
        box_generator = builder.Primitives.Solid.CreateBox([0.,0.,0.],[length,width,thickness])
        body = box_generator.Generate()
    
    # Get different properties of Cylinder
    cylinder_properties = feature.Properties["Cylinder Details"]
    if primitive_option == "Cylinder":
        height= units.ConvertUnit(cylinder_properties.Properties["Height"].Value, fromUnit, toUnit)
        radius = units.ConvertUnit(cylinder_properties.Properties["Radius"].Value, fromUnit, toUnit)
        ExtAPI.Log.WriteMessage("Cylinder Height: " + height.ToString() + "; Cylinder Radius: " + radius.ToString())

        # Use CreateCylinder from Solid object and generate body
        cylinder_generator = builder.Primitives.Solid.CreateCylinder([0.,0.,0.],[0.,0.,height],radius)
        body = cylinder_generator.Generate()
        
    # Add generated bodies to the bodies list
    bodies.Add(body)
    
    # Add bodies list to feature bodies and assign the material type to bodies
    feature.Bodies = bodies
    feature.MaterialType = MaterialTypeEnum.Freeze

    return True