﻿import units

def createMyFeature(arg):
    ExtAPI.CreateFeature("OctaFeature")

def generateOctagonGeom(feature,fct):

    # This command writes messages to log file...
    ExtAPI.Log.WriteMessage("Generating MyFeature...")    
    
    # Collect all property values in meter unit
    fromUnit, toUnit = ExtAPI.DataModel.CurrentUnitFromQuantityName("Length"), "m"
    
    # Get span of the Octagon from "Span" property and convert it to present unit system
    span = units.ConvertUnit(feature.Properties["Span"].Value, fromUnit, toUnit)
    
    # Calculate side length of octagon
    # The area of a regular octagon of side length l is given by : area = 2(1+sqrt(2)) * (a*a)
    side_length = span/(1+sqrt(2))
    side_length = side_length/sqrt(2)
    
    # Declare variables...
    bodies=[]
    temporary_bodies=[]
    builder = ExtAPI.DataModel.GeometryBuilder
        
    ExtAPI.Log.WriteMessage("Operations.Extrude")
    # Create sheet from polygon (note that we will not end the polygon with start point)
    polygon_generator = builder.Primitives.Sheet.CreatePolygon([0.,0.,side_length, 0.,0.,span-side_length, side_length,0.,span, span-side_length,0.,span, span,0.,span-side_length, span,0.,side_length, span-side_length,0.,0., side_length,0.,0.])
    # Generate the sheet body
    polygon_body = polygon_generator.Generate()
    # Add Extrude operation to sheet body
    extrude = builder.Operations.CreateExtrudeOperation([0.,1.,0.],span*1.5)
    temporary_bodies.Add(extrude.ApplyTo(polygon_body)[0])

    ExtAPI.Log.WriteMessage("Operations.Revolve")
    # Add Revolve operation to sheet body
    revolve = builder.Operations.CreateRevolveOperation([span,0.,0.],[0.,0.,1.])
    temporary_bodies.Add(revolve.ApplyTo(polygon_body)[0])

    ExtAPI.Log.WriteMessage("Operations.Union")
	# Add Union operation to for solid bodies to unite them...
    union = builder.Operations.CreateUnionOperation()
    bodies.Add(union.ApplyTo(temporary_bodies)[0])

	# Add resultant body to feature
    feature.Bodies = bodies
    feature.MaterialType = MaterialTypeEnum.Freeze #Assign material type to the body. Different options are Add, Cut, Freeze

    return True
