
import units

def createMyFeature(ag):
    ExtAPI.CreateFeature("BoxFeature")

def generateBoxGeometry(feature,fct):
    ExtAPI.Log.WriteMessage("Generating MyFeature...")
    
    # Collect all property values in meter unit
    fromUnit, toUnit = ExtAPI.DataModel.CurrentUnitFromQuantityName("Length"), "m"
    
    #Get Length width and Thickness of the Box
    Length= units.ConvertUnit(feature.Properties["Length"].Value, fromUnit, toUnit)
    Thickness = units.ConvertUnit(feature.Properties["Thickness"].Value, fromUnit, toUnit)
    Width = units.ConvertUnit(feature.Properties["Width"].Value, fromUnit, toUnit)
    ExtAPI.Log.WriteMessage(Length.ToString())
    ExtAPI.Log.WriteMessage(Thickness.ToString())
    ExtAPI.Log.WriteMessage(Width.ToString())
    
    bodies=[]
    builder = ExtAPI.DataModel.GeometryBuilder
    try:
        #Creating Box
        ExtAPI.Log.WriteMessage("Primitives.Solid.Box")
        boxGen = builder.Primitives.Solid.CreateBox([0.,0.,0.],[Length,Width,Thickness])
        bBox = boxGen.Generate()
        bodies.Add(bBox)
    except:
        pass

    feature.Bodies = bodies
    feature.MaterialType = MaterialTypeEnum.Freeze

    return True
