﻿def CreateLayerStrain(analysis):
    analysis.CreateResultObject("LayerStrain", ExtAPI.ExtensionManager.CurrentExtension)

def CreateShellStress(analysis):
    analysis.CreateResultObject("ShellStress", ExtAPI.ExtensionManager.CurrentExtension)

def CreateContactResult(analysis):
    analysis.CreateResultObject("ContactResult", ExtAPI.ExtensionManager.CurrentExtension)


def CreateLayerStressElem(analysis):
    analysis.CreateResultObject("LayerStressElem", ExtAPI.ExtensionManager.CurrentExtension)
    
def EvaluateLayerStressElem(result, stepInfo, collector):
    result.Controller.EvaluateLayerStressElem(result, stepInfo, collector)

def EvaluateShell(result, stepInfo, collector):
    result.Controller.EvaluateShell(result, stepInfo, collector)

def EvaluateContact(result, stepInfo, collector):
    result.Controller.EvaluateContact(result, stepInfo, collector)


class ActResController:

    def __init__(self, api, result):
        pass

    def EvaluateLayerStressElem(self, result, stepInfo, collector):
        reader = result.Analysis.GetResultsData()
        
        # get the layer number and set up the reader
        reader.Layer = result.Properties["Layer"].Value
        
        # get the LayeredSolidStressStyle
        stressStyle_value = result.Properties["StressStyle"].Value
        stress_style = self.stressStyle(stressStyle_value)
        reader.LayeredSolidStressStyle = stress_style
        
        #get the shell stress orientation
        orientation_value = result.Properties["Orientation"].Value
        shell_orientation = self.shellStressOrientation(orientation_value)
        
        reader.CurrentResultSet = stepInfo.Set
        
        if(self.hasPosition(stress_style)):
            ExtAPI.Log.WriteError("No position are available for elemental result.")
        elif (stress_style == StressStyle.Bending):
            stress_result = reader.GetResult("BENDING_STRESS")
            stress_result.SelectComponents([shell_orientation])
        elif (stress_style == StressStyle.Membrane):
            stress_result = reader.GetResult("MEMBRANE_STRESS")
            stress_result.SelectComponents([shell_orientation])
        
        values = stress_result.GetElementValues(collector.Ids,False)
        collector.SetAllValues(values)
    
    def EvaluateShell(self, result, stepInfo, collector):
        # create a result reader
        reader = result.Analysis.GetResultsData()
        
        # get the LayeredSolidStressStyle
        stressStyle_value = result.Properties["StressStyle"].Value
        stress_style = self.stressStyle(stressStyle_value)
        reader.LayeredSolidStressStyle = stress_style
        
        # get the shell position
        position_value = result.Properties["Position"].Value
        shell_position = self.position(position_value)
        
        # set up the reader
        reader.ShellPosition = shell_position
        
        reader.CurrentResultSet = stepInfo.Set
        stress_result = reader.GetResult("S")
        stress_result.SelectComponents(["Y"])
        
        values = stress_result.GetElementValues(collector.Ids,False)
        collector.SetAllValues(values)

    def hasPosition(self, stressStyle):
        return (stressStyle == StressStyle.TopAndBottom or stressStyle == StressStyle.Top or stressStyle == StressStyle.Bottom)
       
    def shellStressOrientation(self,argument):
        switcher = {
            "Longitudinal":"_LONGITUDINAL",
            "Transverse":"_TRANSVERSE",
            "InPlanShear":"_IN_PLANE_SHEAR"
            }
        return switcher.get(argument, "_LONGITUDINAL")
        
    def stressStyle(self,argument):
        switcher = {
            "Top":StressStyle.Top,
            "Bottom":StressStyle.Bottom,
            "Top/Bottom":StressStyle.TopAndBottom,
            "Membrane":StressStyle.Membrane,
            "Bending":StressStyle.Bending
            }
        return switcher.get(argument, StressStyle.TopAndBottom)
    
    def position(self,argument):
        """equivalent to a switch/case"""
        switcher = {
            "Top":ShellPosition.Top,
            "Bottom":ShellPosition.Bottom,
            "Middle":ShellPosition.Middle,
            "Top/Bottom":ShellPosition.TopAndBottom
            }
        return switcher.get(argument, "Top/Bottom")
    
    
    def EvaluateContact(self, result, stepInfo, collector):
        #get the contact result type
        type_value = result.Properties["Type"].Value
        [contact_type,contact_comp] = self.contactType(type_value)
        
        reader = result.Analysis.GetResultsData()
        
        #set the result collector with the contact elements
        mesh = reader.CreateMeshData()
        contElemIds = mesh.ContactElementIds
        collector.SetAllIds(contElemIds)
        
        reader.CurrentResultSet = stepInfo.Set
        contact_result = reader.GetResult(contact_type)
        contact_result.SelectComponents([contact_comp])
        
        values = contact_result.GetElementValues(contElemIds,False)
        collector.SetAllValues(values)
    
    def contactType(self,argument):
        switcher = {
            "Pressure":["CONT","PRES"],
            "Penetration":["CONT","PENE"],
            "Gap":["CONT","GAP"],
            "Frictional Stress":["CONT","SFRI"],
            "Sliding Distance":["CONT","SLID"],
            "Status":["CONT","STAT"],
            "Fluid Pressure":["CONT","FPRS"],
            }
        return switcher.get(argument, ["CONT","PRES"])
    