import graphics

def CreateCoupling(analysis):
    analysis.CreateLoadObject("Coupling", ExtAPI.ExtensionManager.CurrentExtension)

#-------------------------------
#   Callbacks
#-------------------------------

def OnValidateReverse(load, prop):
    ShowCoupling(load)

def OnValidateScoping(load, prop):
    ShowCoupling(load)

def IsValidScoping(load, prop):

    if not prop.Controller.isvalid(load, prop):
        return False

    selection = prop.Value
    if selection == None: return False
    if selection.Ids.Count != 1: return False
    return True
    
def IsValidCoupledScoping(load, prop):

    sProp = load.Properties["Source"]
    tProp = load.Properties["Target"]

    if not IsValidScoping(load, sProp):
        return False
    if not IsValidScoping(load, tProp): 
        return False

    sIds = sProp.Value.Ids
    tIds = tProp.Value.Ids

    try:    
        mesh = load.Analysis.MeshData
        sNum = mesh.MeshRegionById(sIds[0]).NodeCount
        tNum = mesh.MeshRegionById(tIds[0]).NodeCount
        if sNum == 0 or tNum == 0: return False
    except: 
        return False
    
    
    return sNum == tNum
    
#-------------------------------
#   Show / Hide
#-------------------------------

graphicsContext = {}
def getContext(entity):
     global graphicsContext
     if entity.Id in graphicsContext : return graphicsContext[entity.Id]
     else : return None

def setContext(entity, context):
     global graphicsContext
     graphicsContext[entity.Id] = context

def delContext(entity):
    context = getContext(entity)
    if context != None : context.Visible = False
    context = None
    setContext(entity, None)

def ShowCoupling(load):
    delContext(load)
    ctxCoupling = ExtAPI.Graphics.CreateAndOpenDraw3DContext()

    sourceColor = load.Color
    targetColor = 0x00FF00
    lineColor   = 0x0000FF

    sProp = load.Properties["Source"] ; sSel = sProp.Value
    tProp = load.Properties["Target"] ; tSel = tProp.Value

    ctxCoupling.LineWeight = 1.5
    if sSel != None:
        ctxCoupling.Color = sourceColor
        for id in sSel.Ids:
            graphics.DrawGeoEntity(ExtAPI, load.Analysis.GeoData, id, ctxCoupling)
    if tSel != None:
        ctxCoupling.Color = targetColor
        for id in tSel.Ids:
            graphics.DrawGeoEntity(ExtAPI, load.Analysis.GeoData, id, ctxCoupling)

    if IsValidSelections(load):

        ctxCoupling.Color = lineColor
        ctxCoupling.LineWeight = 1.5

        mesh = load.Analysis.MeshData
        sList, tList = GetListNodes(load)

        for sId, tId in zip(sList, tList):
            sNode = mesh.NodeById(sId)
            tNode = mesh.NodeById(tId)
            ctxCoupling.DrawPolyline([sNode.X,sNode.Y,sNode.Z,tNode.X,tNode.Y,tNode.Z])
        
    ctxCoupling.Close()
    ctxCoupling.Visible = True
    setContext(load, ctxCoupling)

def HideCoupling(load):
    delContext(load)

#-------------------------------
#   Commands
#-------------------------------
    
def SolveCmd(load, solverData, s):
    s.WriteLine("! Coupling - CP")
    sList, tList = GetListNodes(load)
    for sId, tId in zip(sList, tList):
        s.WriteLine("CP,NEXT,ALL,{0},{1}", sId, tId)

#-------------------------------
#   Utils
#-------------------------------

def IsValidSelections(load):
    return load.Properties["Source"].IsValid and load.Properties["Target"].IsValid

def GetListNodes(load):

    if IsValidSelections(load):

        sProp = load.Properties["Source"] ; sIds = sProp.Value.Ids
        tProp = load.Properties["Target"] ; tIds = tProp.Value.Ids

        geometry = ExtAPI.DataModel.GeoData
        mesh = load.Analysis.MeshData

        sList = GetSubListNodes(geometry, mesh, sIds[0])
        tList = GetSubListNodes(geometry, mesh, tIds[0])

        rev = False
        r = load.Properties["Reverse"].Value
        if r == "Yes": rev = True

        sList = sorted(sList, key=sList.get)
        tList = sorted(tList, key=tList.get, reverse=rev)

    return (sList, tList)

def GetSubListNodes(geometry, mesh, refId):

    entity = geometry.GeoEntityById(refId)
    region = mesh.MeshRegionById(refId)

    result = {}
    pt = System.Array.CreateInstance(System.Double, 3)

    for nodeId in region.NodeIds:
        node = mesh.NodeById(nodeId)
        pt[0], pt[1], pt[2] = (node.X, node.Y, node.Z)
        result[nodeId] = entity.ParamAtPoint(pt)

    return result

