import clr
clr.AddReference("Ans.Core")

def update(task):
    container = task.InternalObject
    context = ExtAPI.DataModel.Context
    activeDir = container.GetActiveDirectory()
    extensionDir = ExtAPI.ExtensionManager.CurrentExtension.InstallDir
    exeName = "ExampleAddinExternalSolver.exe"
    solverPath = System.IO.Path.Combine(extensionDir, exeName)
    
    monitor = context.ProgressMonitor
    monitor.BeginTask("Data Sqaures Solver", 3, None)
    monitor.TaskDetails = "Preparing solver input..."
    System.Threading.Thread.Sleep(2000)
    monitor.UpdateTask(1, None)
    
    #get param values
    inputValue = task.Properties["Inputs"].Properties["Input"].Value
      
    #prep i/o file paths
    
    inputFileName = "input.txt"
    outputFileName = "output.txt"
    dpInputFile = System.IO.Path.Combine(activeDir, inputFileName)
    dpOutputFile = System.IO.Path.Combine(activeDir, outputFileName)
    
    #write input file
    f = open(dpInputFile, "w")
    f.write('input='+inputValue.ToString(System.Globalization.NumberFormatInfo.InvariantInfo))
    f.close()
    
    monitor.UpdateTask(1, None)
    
    monitor.TaskDetails = "Executing Solver..."
    System.Threading.Thread.Sleep(2000)
    
    #run exe
    
    runInMono = Ansys.Utilities.ApplicationConfiguration.DefaultConfiguration.IsRuntimeMono
    monoPath = "mono"
    monoArgs = System.String.Format("{0} \"{1}\" \"{2}\"", solverPath, dpInputFile, dpOutputFile)
    info = None
    if runInMono:
        info = System.Diagnostics.ProcessStartInfo(monoPath, monoArgs)
    else:
        info = System.Diagnostics.ProcessStartInfo(solverPath, System.String.Format("\"{0}\" \"{1}\"", dpInputFile, dpOutputFile))
    info.CreateNoWindow = True
    info.WindowStyle = System.Diagnostics.ProcessWindowStyle.Minimized
    p = System.Diagnostics.Process.Start(info)
    p.WaitForExit()
    
    monitor.UpdateTask(1, None)
    
    monitor.TaskDetails = "Retrieving results from solver..."
    System.Threading.Thread.Sleep(2000)
    
    #read output file
    
    outputValue = None
    f = open(dpOutputFile, "r")
    currLine = f.readline()
    while currLine != "":
        valuePair = currLine.split('=')
        outputValue = System.Double.Parse(valuePair[1], System.Globalization.NumberFormatInfo.InvariantInfo)
        currLine = f.readline()
    f.close()
    
    monitor.UpdateTask(1, None)
    
    #set output value
    
    if outputValue == None:
        raise Exception("Error in update - no output value detected!")
    else:
        task.Properties["Outputs"].Properties["Output"].Value = outputValue
    monitor.TaskDetails = "Solve completed..."
    System.Threading.Thread.Sleep(2000)
    monitor.EndTask(None)

def createJobInput(task, inputFilePaths):
    ExtAPI.Log.WriteMessage('creating job input')
    inputFilePath = inputFilePaths[0]
    #get param values
    inputValue = task.Properties["Inputs"].Properties["Input"].Value
    
    #write input file
    ExtAPI.Log.WriteMessage("Writing input value ("+str(inputValue)+") to file (" + inputFilePath + ")")
    f = open(inputFilePath, "w")
    f.write('input='+inputValue.ToString(System.Globalization.NumberFormatInfo.InvariantInfo))
    f.close()
def reconnectJob(task, outputFilePaths):
    ExtAPI.Log.WriteMessage('reconnecting job')
    outputValue = None
    outputFilePath = outputFilePaths[0] #I know we only have one specified based on our definition...so work off of the first entry
    f = open(outputFilePath, "r")
    currLine = f.readline()
    while currLine != "":
        valuePair = currLine.split('=')
        outputValue = System.Double.Parse(valuePair[1], System.Globalization.NumberFormatInfo.InvariantInfo)
        currLine = f.readline()
    f.close()    
    #set output value
    ExtAPI.Log.WriteMessage("Retrieved value (" + str(outputValue) + ") from file (" + outputFilePath + ")")
    if outputValue == None:
        raise Exception("Error in update - no output value detected!")
    else:
        task.Properties["Outputs"].Properties["Output"].Value = outputValue
def getJobStatus(task, outputFiles):
    ExtAPI.Log.WriteMessage('checking job status')
    outputFilePath = outputFiles[0]
    finished = System.IO.File.Exists(outputFilePath)
    return finished
def cancelJob(task, inputFiles, outputFiles):
    #nothing to do...just print a message for now.
    ExtAPI.Log.WriteMessage('performing cancellation clean up')
import clr
clr.AddReference("Ans.ProjectSchematic")
clr.AddReference("ReportUtility.Interop")
import Ansys.ReportUtility.Interop
import Ansys.ProjectSchematic
def status(task):
    status = Ansys.ProjectSchematic.Queries.ComponentState(Ansys.ProjectSchematic.State.Unfulfilled, "This is unfulfilled!")
    return None
def report(task, report):
    root = report.GetRootSection()
    section = Ansys.ReportUtility.Interop.ReportSection("My Custom ACT Task Report Content")
    text = Ansys.ReportUtility.Interop.ReportText("", "Sample text from the data squares component")
    section.AddChild(text)
    root.AddChild(section)
def reset(task):
    task.Properties["Inputs"].Properties["Input"].Value = 0
    task.Properties["Outputs"].Properties["Output"].Value = 0
