import units
import math

def CreatePressureVesselDM(ag):
    ExtAPI.ExtensionManager.CurrentExtension.UpdateAttributes()
    geoData = ExtAPI.ExtensionManager.CurrentExtension.Attributes["geoData"]

    feat = ExtAPI.CreateFeature("PressureVessel")

    feat.Properties["Radius"].Value = geoData["Radius"]
    feat.Properties["Height"].Value = geoData["Height"]
    feat.Properties["Width"].Value = geoData["Width"]   

def GeneratePressureVesselDM(feature,fct):
    radius = feature.Properties["Radius"].Value
    height = feature.Properties["Height"].Value
    width = feature.Properties["Width"].Value
    
    builder = ExtAPI.DataModel.GeometryBuilder    
    
    bodies = []

    points = []
    for i in range(0,100,10):
        points.extend([radius*sin(i*math.pi/180),-width*cos(i*math.pi/180),0.])
        
    curve = builder.Primitives.Wire.CreateBCurve(points)
    curve_generated = curve.Generate()    
    
    revolve1 = builder.Operations.CreateRevolveOperation([0.,0.,0.], [0.,1.,0.])
    bodies.Add(revolve1.ApplyTo(curve_generated)[0])

    lateralface = builder.Primitives.Wire.CreatePolyline([radius,0.,0.,radius,height,0.])
    lateralface_generated = lateralface.Generate()
    
    revolve2 = builder.Operations.CreateRevolveOperation([0.,0.,0.], [0.,1.,0.])
    bodies.Add(revolve2.ApplyTo(lateralface_generated)[0])
    
    union = builder.Operations.CreateUnionOperation()
    union.ApplyTo(bodies)

    
    plane = builder.Primitives.Sheet.CreatePolygon([2*radius,2*height,0.,-2*radius,2*height,0.,-2*radius,-2*height,0.,2*radius,-2*height,0.])
    plane_generated = plane.Generate()
        
    builder.Operations.Tools.Imprint(bodies[0],[plane_generated])   

    feature.Bodies = bodies
    feature.MaterialType = MaterialTypeEnum.Freeze

    return True