﻿import clr
import os

import System
from System.Collections.Generic import Dictionary
from System.Collections.Generic import List

dumpstream = None


def update(task):

    radius = task.Properties["GeometryProperties/Radius"]
    height = task.Properties["GeometryProperties/Height"]
    width = task.Properties["GeometryProperties/Width"]

    my_attribute=System.Collections.Generic.Dictionary[str, object]()
    my_attribute.Add("Radius", radius.DisplayString)
    my_attribute.Add("Height", height.DisplayString)
    my_attribute.Add("Width", width.DisplayString)

    # Following are two ways to access the extension
    extension = task.Extension
    extension.UpdateAttributes()
    ExtAPI.ExtensionManager.CurrentExtension.Attributes["geoData"] = my_attribute

    string = """ExtAPI.ExtensionManager.GetExtensionByName("DebuggerDemo").GetModule().CreatePressureVesselDM("")"""

    geoSystem = GetSystem(Name="SYS")
    geometry1 = geoSystem.GetContainer(ComponentName="Geometry")

    geometry1.Edit()
    geometry1.SendCommand(Language = "Python", Command = string)
    geometry1.Update()
    geometry1.Exit()



def edit(task):
    global api
    system1 = GetSystem(Name="SYS")
    modelComponent1 = system1.GetComponent(Name="Model")
    modelComponent1.Refresh()
    model1 = system1.GetContainer(ComponentName="Model")
    model1.Edit(Interactive=True)

    api=Ansys.ACT.Core.ApplicationRepository.GetLastRegisteredRemoteApplication()

    callback = System.Action(run)
    ACT.ExecuteCallback(callback)

def delete(task):
    ExtAPI.ExtensionManager.CurrentExtension.UpdateAttributes()
    ExtAPI.ExtensionManager.CurrentExtension.Attributes["geoData"] = None

def reset(task):
    ExtAPI.ExtensionManager.CurrentExtension.UpdateAttributes()
    ExtAPI.ExtensionManager.CurrentExtension.Attributes["geoData"] = None


def isPositive(task, property):
    return property.Value > 0

class ResultController():

    def __init__(self, api, result):
        dumpLog("initialize the custom result")
        pass

    def evaluate(self, result, stepInfo, collector):
        values_list = []
        ids_list = []
        with result.Analysis.GetResultsData() as reader:
            reader.ShellPosition = ShellPosition.Top
            reader.CurrentResultSet = stepInfo.Set
            stress_result = reader.GetResult("S")
            stress_result.SelectComponents(["X"])
            for id in collector.Ids:
                values = stress_result.GetElementValues(id)
                collector.SetValues(id, values)
                values_list.append(values)
                ids_list.append(id)







def dumpLog(line):
    '''This function will be used to write in an output log file.'''
    global dumpstream

    extension = ExtAPI.ExtensionManager.CurrentExtension
    extension_directory = extension.InstallDir

    ExtAPI.Extension.UpdateAttributes()
    outFile = ExtAPI.Extension.Attributes["LogFile"]
    if outFile==None:
        outFile = os.path.join(extension_directory,"Output.log")
        ExtAPI.Extension.SetAttributeValueWithSync("LogFile", outFile)
    dumpstream = open(outFile, 'a')
    dumpstream.write(line+"\n")
    dumpstream.close()