import os

def init(context):
    ExtAPI.Log.WriteMessage("Init DemoLoads...")

def CreateDemoLoad(analysis):
    analysis.CreateLoadObject("DemoLoad", ExtAPI.ExtensionManager.CurrentExtension)
    
def StringOptions_DL(load,prop):
    prop.ClearOptions()
    prop.AddOption("X")
    prop.AddOption("Y")
    prop.AddOption("Z")

def GetPreCommands_DL(load, stream):
    stream.Write("/COM, **************************************************" + "\n")
    stream.Write("/COM, Load properties from DemoLoad getprecommands event" + "\n")
    stream.Write("/COM, Text Property = " + load.Properties["Text"].ValueString + "\n")
    stream.Write("/COM, SelectDynamic Property = " + load.Properties["SelectDynamic"].ValueString + "\n")
    stream.Write("/COM, SelectStatic Property = " + load.Properties["SelectStatic"].ValueString + "\n")
    stream.Write("/COM, Double Property = " + load.Properties["Double"].ValueString + "\n")
    stream.Write("/COM, FileName Property = " + load.Properties["FileName"].ValueString + "\n")
    stream.Write("/COM, **************************************************" + "\n")

def GetSolveCommands_DL(load, solverData, stream):
    stream.Write("/COM, **************************************************" + "\n")
    stream.Write("/COM, Load properties from DemoLoad getsolvecommands event" + "\n")
    stream.Write("/COM, Text Property = " + load.Properties["Text"].ValueString + "\n")
    stream.Write("/COM, SelectDynamic Property = " + load.Properties["SelectDynamic"].ValueString + "\n")
    stream.Write("/COM, SelectStatic Property = " + load.Properties["SelectStatic"].ValueString + "\n")
    stream.Write("/COM, Double Property = " + load.Properties["Double"].ValueString + "\n")
    stream.Write("/COM, FileName Property = " + load.Properties["FileName"].ValueString + "\n")
    stream.Write("/COM, **************************************************" + "\n")
    
def GetNodalValuesForDisplay_DL(load, nodeIds):
    dval = load.Properties["Double"].Value
    coordselect = load.Properties["SelectDynamic"].ValueString
    mesh = load.Analysis.MeshData
    values = []
    for id in nodeIds:
        node = mesh.NodeById(id)
        dispval = float(0.0)
        if coordselect == "X":
            dispval = node.X * float(dval)
        elif coordselect == "Y":
            dispval = node.Y * float(dval)
        elif coordselect == "Z":
            dispval = node.Z * float(dval)
        else: 
            dispval = float(0.0)
        values.Add(dispval)
    return values
