﻿import units

wps_stress = {}
eigenvalues = {}
    
def init(context):
    ExtAPI.Log.WriteMessage("Init Demoresult Extension...")
    
def Create_WPS_Result(analysis):
    ExtAPI.Log.WriteMessage("Launch Create_WPS_Result...")
    analysis.CreateResultObject("Worst Principal Stress", ExtAPI.ExtensionManager.CurrentExtension)

# This function evaluates the specific result (i.e. the Absolute principal stress) on each element required by the geometry selection
# The input data "step" represents the step on which we have to evaluate the result
def WPS_Eval(result,step):
    global wps_stress
    analysis = result.Analysis
    ExtAPI.Log.WriteMessage("Launch evaluation of the WPS result: ")
    # Reader initialization
    reader = analysis.GetResultsData()
    reader.CurrentResultSet = step
    # Get the stress result from the reader
    stress = reader.GetResult("S")

    # Define which component of the stress tensor you want to work with.
    stress.SelectComponents(["X","Y","Z","XY","XZ","YZ"])
    # Unit sytem management:
    # First get the unit system that was used during the resolution
    # Second compute the coefficient to be used so that the final result will be returned in the SI unit system
    unit_stress = stress.GetComponentInfo("X").Unit
    conv_stress = units.ConvertUnit(1.,unit_stress,"Pa","Stress")
    
    # Get the selected geometry 
    propGeo = result.Properties["Geometry"]
    refIds = propGeo.Value.Ids
    # Get the mesh of the model
    mesh = analysis.MeshData
    #Loop on the list of the selected geometrical entities
    for refId in refIds:
        # Get mesh information for each geometrical entity
        meshRegion = mesh.MeshRegionById(refId)
        elementIds = meshRegion.ElementIds
        # Loop on the elements related to the current geometrical entity
        for elementId in elementIds:
            # Get the stress tensor related to the current element
            tensor = stress.GetElementValues(elementId)
            # Get element information
            element = mesh.ElementById(elementId)
            nodeIds = element.CornerNodeIds
                
            wps_stress[elementId] = []
            # Loop on the nodes of the current element to compute the Von-Mises stress on the element nodes
            for i in range(0,nodeIds.Count):
                local_wps = WPS(tensor[6*i:6*(i+1)])
                    
                #  Final stress result has to be returned in theSI unit system
                local_wps = local_wps * conv_stress
                wps_stress[elementId].Add(local_wps)

# This function returns the values array. This array will be used by Mechanical to make the display available                 
def WPS_GetValue(result,elementId):
    global wps_stress
    if elementId in wps_stress:
        values = wps_stress[elementId]
    else:
        values = []
        mesh = result.Analysis.MeshData
        element = mesh.ElementById(elementId)
        nodeIds = element.CornerNodeIds
        for id in nodeIds:
            values.Add(System.Double.MaxValue)
    return values

# This function computes the absolute principal stress from the stress tensor
# The Von-Mises stess is computed based on the three eigenvalues of the stress tensor 
def WPS(tensor):

    # Computation of the eigenvalues 
    eigenvalues = EigenValues(tensor)
    
    # Extraction of the worst principal stress
    wplocal_stress = eigenvalues[0]
    if abs(eigenvalues[1])>abs(wplocal_stress):
        wplocal_stress = eigenvalues[1]
    if abs(eigenvalues[2])>abs(wplocal_stress):
        wplocal_stress = eigenvalues[2]    
    
    # Return the worst value of the three principal stresses S1, S2, S3
    return wplocal_stress


# This function computes the three eigenvalues of one [3*3] symetric tensor
EPSILON = 1e-4
def EigenValues(tensor):
    global eigenvalues
    
    eigenvalues = []
    
    a = tensor[0]
    b = tensor[1]
    c = tensor[2]
    d = tensor[3]
    e = tensor[4]
    f = tensor[5]
    
    if ((abs(d)>EPSILON) or (abs(e)>EPSILON) or (abs(f)>EPSILON)):
        # Polynomial reduction
        A = -(a+b+c)
        B = a*b+a*c+b*c-d*d-e*e-f*f
        C = d*d*c+f*f*a+e*e*b-2*d*e*f-a*b*c

        p = B-A*A/3
        q = C-A*B/3+2*A*A*A/27
        if (q<0):
            R = -sqrt(fabs(p)/3)
        else:
            R = sqrt(fabs(p)/3)
    
        phi = acos(q/(2*R*R*R))

        S1=-2*R*cos(phi/3)-A/3
        S2=-2*R*cos(phi/3+2*3.1415927/3)-A/3
        S3=-2*R*cos(phi/3+4*3.1415927/3)-A/3
    else:
        S1 = a
        S2 = b
        S3 = c
       
    eigenvalues.Add(S1)
    eigenvalues.Add(S2)
    eigenvalues.Add(S3)
        
    return eigenvalues    