import os
import solver
solver.ExtAPI = ExtAPI
import clr
import units
import Ansys.ACT.Interfaces.Post

clr.AddReference("Ansys.ACT.Core")

def CreateValuesLoad(analysis):
    analysis.CreateLoadObject("Values", ExtAPI.ExtensionManager.CurrentExtension)

def CreateValuesResult(analysis):
    analysis.CreateResultObject("Values", ExtAPI.ExtensionManager.CurrentExtension)

if ExtAPI.Extension.ApplicationContext.Name=="Mechanical":
    initValues = {}
    sol = None
    solbystep = SerializableDictionary[int,dict]()
    values = {}
    steps = []
    res = [0.]
    dScal = [0.]
    dVec = [0., 0., 0.]

def WriteInitialValues(load,filename):
    global initValues    
    propEx = load.Properties["Expression"]
    exp = propEx.Value
    if exp=="": 
        return None
    vexp = compile(exp,'','eval')
    values = []
    propGeo = load.Properties["Geometry"]
    refIds = propGeo.Value.Ids
    mesh = load.Analysis.MeshData
    for refId in refIds:
        meshRegion = mesh.MeshRegionById(refId)
        nodeIds = meshRegion.NodeIds
        for nodeId in nodeIds:
            node = mesh.NodeById(nodeId)
            x = node.X
            y = node.Y
            z = node.Z
            v = 0.
            try:
                v = eval(vexp)
                v = float(v)
            finally:
                initValues.Add(nodeId,v)

def NodeValues(load,nodeIds):
    propEx = load.Properties["Expression"]
    exp = propEx.Value
    if exp=="": 
        return None
    try:
        vexp = compile(exp,'','eval')
    except: 
        return None
    values = []
    mesh = load.Analysis.MeshData
    for id in nodeIds:
        node = mesh.NodeById(id)
        x = node.X
        y = node.Y
        z = node.Z
        v = 0.
        try:
            v = eval(vexp)
            v = float(v)
        finally:
            values.Add(v)
    return values

def Solve(s,fct):
    global steps
    global initValues
    global sol
    global solbystep
    global values
    
    solbystep = SerializableDictionary[int,dict]()
    solbystepTmp = {}
    
    f = open("solve.out","w")
    f.write("SolverEngine version 1.0\n\n\n")
    try:
    
        maxIter = int(s.Properties["MaxIter"].Value)
        f.write("Max. iteration : %d\n" % (maxIter))
    
        mesh = s.Analysis.MeshData
        
        numEdges = 0
        geo = ExtAPI.DataModel.GeoData
        nodeIds = []
        for asm in geo.Assemblies:
            for part in asm.Parts:
                for body in part.Bodies:
                    for edge in body.Edges:
                        numEdges = numEdges + 1
                        ids = mesh.MeshRegionById(edge.Id).NodeIds
                        nodeIds.extend(ids)
        steps = []
        stepsTmp = []
        f.write("Num. edges : %d\n" % (numEdges))
        sol = solver.SolverEngine(mesh,initValues,nodeIds)
        initValues = sol.Run(maxIter,f,stepsTmp,solbystepTmp,fct,0,50)
        nodeIds = mesh.NodeIds
        sol = solver.SolverEngine(mesh,initValues,nodeIds)
        values = sol.Run(maxIter,f,steps,solbystep,fct,50,100)
        # ExtAPI.Log.WriteMessage('--------- After sol.Run, solbystep={0}'.format(solbystep))
    
        initValues = {}

    except StandardError, e:
        ExtAPI.Log.WriteError(str(e))
        f.write("Error:\n")
        f.write(e.message+"\n")
        f.close()
        return False

    f.close()

    return True

class DemonstrationSolverReader(Ansys.ACT.Interfaces.Post.ICustomResultReader):

    def __init__(self,infos):
        self.infos = infos
        self.step = None

    def GetCurrentStep(self):
        return self.step

    def SetCurrentStep(self,step):
        if step.DefineBy == StepDefineByEnum.Time:
            minimumTimeDelta = None
            for stepIx, time in enumerate(steps):
                delta = abs(time - step.Time)
                if minimumTimeDelta == None or delta < minimumTimeDelta:
                    minimumTimeDelta = delta
                    self.step = stepIx + 1
        else:
            self.step = step.Set

    def GetStepValues(self):
        global steps
        return steps

    def GetResultNames(self):
        return ["U","SOLU","ETEST"]

    def GetResultLocation(self,resultName):
        if resultName=="ETEST":
            return ResultLocationEnum.Element
        return ResultLocationEnum.Node

    def GetResultType(self,resultName):
        if resultName=="U":
            return ResultTypeEnum.Vector
        return ResultTypeEnum.Scalar

    def GetComponentNames(self,resultName):
        return ["Temp"]

    def GetComponentUnit(self,resultName,componentName):
        if resultName=="U":
            return "Length"
        return "Temperature"

    def GetValues(self,resultName,collector):
        global values
        global solbystep
        global dVec
        global dScal
        
        if resultName=="U":
            dVec[0] = 0.
            dVec[1] = 0.
            dVec[2] = 0.
            ExtAPI.Log.WriteMessage('---------- Read step #{0}'.format(self.step))
            for id in collector.Ids:
                values = solbystep[self.step]
                
                if id in values:
                    dVec[0] = values[id]
                    collector.SetValues(id, dVec)
        elif resultName=="ETEST":
            for id in collector.Ids:
                dScal[0] = float(id)
                collector.SetValues(id, dScal)
        else:
            for id in collector.Ids:
                values = solbystep[self.step]
                if id in values:
                    dScal[0] = values[id]
                    collector.SetValues(id, dScal)

def GetReader(solver):
    return ["DemonstrationSolverReader","Test1","Test2"]

def GetSteps(solver):
    global steps
    return steps


def GetValue(result,nodeId):
    global values
    global res
    # ExtAPI.Log.WriteMessage('GetValue, nodeId={1}, values={0}'.format(values, nodeId))
    if nodeId in values:
        res[0] = values[nodeId]
    else:
        # ExtAPI.Log.WriteError('Pas de valeur pour nodeId={0}'.format(nodeId))
        res[0] = System.Double.MaxValue
    return res
    
def StartEval(result,istep):
    global values
    global solbystep
    # ExtAPI.Log.WriteMessage('starteval, values={0}'.format(values))
    if istep in solbystep:
        values = solbystep[istep]
        if values==None:
            values = {}
    else:
        values = {}
    
def Save(folder):
    global solbystep
    fm = System.Runtime.Serialization.Formatters.Binary.BinaryFormatter()
    try:
        stream = System.IO.StreamWriter(os.path.join(folder,"sol.res"),False)
    except:
        return
    try:
        fm.Serialize(stream.BaseStream,solbystep)
    finally:
        stream.Close()
    
def Load(folder):
    global solbystep
    # ExtAPI.Log.WriteMessage("Num nodes: "+ExtAPI.DataModel.MeshDataByName("Global").NodeCount.ToString())
    if folder==None:
        return
    binder = Ansys.ACT.Core.ActSerializationBinder()
    fm = System.Runtime.Serialization.Formatters.Binary.BinaryFormatter()
    fm.Binder = binder
    try:
        stream = System.IO.StreamReader(os.path.join(folder,"sol.res"))
    except:
        return
    try:
        solbystep = fm.Deserialize(stream.BaseStream)
    finally:
        stream.Close()
