import os
import datetime
clr.AddReference("Ans.UI.Toolkit")
clr.AddReference("Ans.UI.Toolkit.Base")
from Ansys.UI.Toolkit import *

def init(context):
    ExtAPI.Log.WriteMessage("Init ExtToolbarSample ...")

def OnClickTB1Button1(analysis):
    LogButtonClicked(1, 1, analysis)

def OnClickTB1Button2(analysis):
    LogButtonClicked(1, 2, analysis)

def OnClickTB1Button3(analysis):
    LogButtonClicked(1, 3, analysis) 

def OnClickTB2Button1(analysis):
    LogButtonClicked(2, 1, analysis)

def OnClickTB2Button2(analysis):
    LogButtonClicked(2, 2, analysis) 

def OnClickTB2Button3(analysis):
    LogButtonClicked(2, 3, analysis)     

def LogButtonClicked(toolbarId, buttonId, analysis):
    now = datetime.datetime.now()
    outFile = SetUserOutput("ExtToolbarSample.log", analysis)
    f = open(outFile,'a')    
    f.write("*.*.*.*.*.*.*.*\n")
    f.write(str(now)+"\n")
    f.write("Toolbar "+toolbarId.ToString()+" - Button "+buttonId.ToString()+" Clicked. \n")
    f.write("*.*.*.*.*.*.*.*\n")
    f.close()
    MessageBox.Show("Toolbar "+toolbarId.ToString()+" - Button "+buttonId.ToString()+" Clicked.") 
    
def SetUserOutput(filename, analysis):
    solverDir = analysis.WorkingDir
    return os.path.join(solverDir,filename)
