﻿clr.AddReference("Ans.UI.Toolkit")
clr.AddReference("Ans.UI.Toolkit.Base")
from Ansys.UI.Toolkit import *
import datetime
import os

def OnTraverseButton1(analysis):
    ExtAPI.Log.WriteMessage("TraverseExtension - Traverse Geometry")
    MessageBox.Show("Traverse Geometry")
    traversegeometry(analysis)
    
def OnTraverseButton2(analysis):
    ExtAPI.Log.WriteMessage("TraverseExtension - Traverse Mesh")
    MessageBox.Show("Traverse Mesh")
    traversemesh(analysis) 
    
def OnTraverseButton3(analysis):
    ExtAPI.Log.WriteMessage("TraverseExtension - Element Counter")
    MessageBox.Show("Element Counter")
    elementcounter(analysis)
              
def OnTraverseButton4(analysis):
    ExtAPI.Log.WriteMessage("TraverseExtension - Solution Details")
    MessageBox.Show("Solution Details")
    solutiondetails(analysis)
    
def OnTraverseButton5(analysis):
    ExtAPI.Log.WriteMessage("TraverseExtension - Solution Details")
    MessageBox.Show("Min Max Results")
    minmaxresults(analysis)    

def SetUserOutput(analysis, filename):
    solverDir = analysis.WorkingDir
    return os.path.join(solverDir,filename)

def traversemesh(analysis):
    now = datetime.datetime.now()
    outFile = SetUserOutput(analysis, "SolutionDetails.log")
    f = open(outFile,'a')    
    f.write("*.*.*.*.*.*.*.*\n")
    f.write(str(now)+"\n")
    # --- IMesh Interface
    # +++ Properties and Methods
    # +++ MeshRegion   
    # +++ Node   
    # +++ Element   
    # +++ Nodes   
    # +++ Elements   
    # +++ NumNodes   
    # +++ NumElements   
    mesh = analysis.MeshData
    elementids = mesh.ElementIds
    # --- IElement Interface
    # +++ Properties and Methods
    # +++ Id   
    # +++ Type   
    # +++ Nodes
    for elementid in elementids:
        element = mesh.ElementById(elementid)
        nodeids = element.NodeIds
        # --- INode Interface
        # +++ Properties and Methods
        # +++ Id   
        # +++ X   
        # +++ Y   
        # +++ Z   
        # +++ Elements
        for nodeid in nodeids:
            node = mesh.NodeById(nodeid)
            nodex = node.X
            nodey = node.Y
            nodez = node.Z
            try:
                f.write("      Element: "+elementid.ToString()+"  Node: "+nodeid.ToString()+", X = "+nodex.ToString()+", Y = "+nodey.ToString()+", Z = "+nodez.ToString()+"\n")
            except:
                continue
    f.close()
    return

def elementcounter(analysis):
    geometry = analysis.GeoData
    mesh = analysis.MeshData
    selectedids = ExtAPI.SelectionManager.CurrentSelection.Ids
    if selectedids.Count == 0:
        MessageBox.Show("Nothing Selected!")
    else:
        for selectedid in selectedids:
            entity = geometry.GeoEntityById(selectedid)
            meshregion = mesh.MeshRegionById(selectedid)
            try:
                numelem = meshregion.ElementCount
                MessageBox.Show("Entity of type: "+entity.Type.ToString()+
                                " contains "+numelem.ToString()+
                                " elements.")                
            except:
                MessageBox.Show("The mesh is empty!")
                return
    return

def traversegeometry(analysis):
    now = datetime.datetime.now()
    outFile = SetUserOutput(analysis, "SolutionDetails.log")
    f = open(outFile,'a')    
    f.write("*.*.*.*.*.*.*.*\n")
    f.write(str(now)+"\n")
    # --- IGeometry Interface
    # +++ Properties and Methods
    # +++    Assemblies
    # +++    CellFromRefId
    # +++    SelectedRefIds
    geometry = analysis.GeoData
    assemblies = geometry.Assemblies
    assemblies_count = assemblies.Count
    # --- IGeoAssembly Interface
    # +++ Properties and Methods
    # +++    Name
    # +++    Parts
    for assembly in assemblies:
        assembly_name = assembly.Name
        parts = assembly.Parts
        parts_count = parts.Count
        # --- IGeoPart Interface
        # +++ Properties and Methods
        # +++    Name
        # +++    Bodies
        for part in parts:
            part_name = part.Name
            bodies = part.Bodies
            bodies_count = bodies.Count
            # --- IGeoBody Interface
            # +++ Properties and Methods
            # +++    Name
            # +++    Vertices
            # +++    Edges
            # +++    Faces
            # +++    Shells
            # +++    Material
            for body in bodies:
                faces = body.Faces
                faces_count = faces.Count
                # --- IGeoFace Interface
                # +++ Properties and Methods
                # +++    Body
                # +++    Shell
                # +++    Vertices
                # +++    Edges
                # +++    Loops
                # +++    Area
                # +++    SurfaceType
                # +++    PointAtParam
                # +++    PointsAtParams
                for face in faces:
                    edges = face.Edges
                    edges_count = edges.Count
                    # --- IGeoEdge Interface
                    # +++ Properties and Methods
                    # +++    Faces
                    # +++    Vertices
                    # +++    StartVertex
                    # +++    EndVertex
                    # +++    Length
                    # +++    CurveType
                    # +++    Extents
                    # +++    IsParamReversed
                    # +++    ParamAtPoint
                    # +++    PointAtParam
                    # +++    PointsAtParams
                    for edge in edges:
                        vertices = edge.Vertices
                        vertices_count = vertices.Count
                        # --- IGeoVertex Interface
                        # +++ Properties and Methods
                        # +++ Edges   
                        # +++ Faces   
                        # +++ Bodies   
                        # +++ X   
                        # +++ Y   
                        # +++ Z
                        for vertex in vertices:
                            xcoord = vertex.X
                            ycoord = vertex.Y
                            zcoord = vertex.Z
                            try:
                                f.write("      Vertex: "+vertex.ToString()+", X = "+xcoord.ToString()+", Y = "+ycoord.ToString()+", Z = "+zcoord.ToString()+"\n")
                            except:
                                continue
    f.close()
    return

def solutiondetails(analysis):
    now = datetime.datetime.now()
    outFile = SetUserOutput(analysis, "SolutionDetails.log")
    f = open(outFile,'a')    
    f.write("*.*.*.*.*.*.*.*\n")
    f.write(str(now)+"\n")
    # Simulation API
    f.write("\n");
    f.write("########################################\n");
    f.write("   Simulation API\n");
    f.write("########################################\n");
    f.write("Analysis name: "+analysis.Name+"\n")
    f.write("   Solver: "+analysis.SolverName+"\n")
    objects = analysis.DataObjects.Names
    for objName in objects:
        f.write("   Object name: "+objName+"\n")
        sim = analysis.DataObjects.GetByName(objName)
        f.write("      Type: "+sim.Type+"\n");
        properties = sim.PropertyNames;
        for prop in properties:
            p = sim.PropertyValue(prop)
            try:
                f.write("      Property name: "+prop+", value: "+p.ToString()+"\n")
            except:
                continue
    f.close()
    return
    
def minmaxresults(analysis):
    now = datetime.datetime.now()
    outFile = SetUserOutput(analysis, "SolutionDetails.log")
    f = open(outFile,'a')    
    f.write("*.*.*.*.*.*.*.*\n")
    f.write(str(now)+"\n")
    #
    # Get the element ids 
    #
    meshObj = analysis.MeshData
    elementids = meshObj.ElementIds
    nodeids = meshObj.NodeIds
    #  
    # Get the results reader
    #
    reader = analysis.GetResultsData()
    reader.CurrentResultSet = int(1) 
    #
    # Get the displacement result object
    displacement = reader.GetResult("U")
    
    num = 0
    for nodeid in nodeids: 
        #
        # Get the component displacements (X Y Z) for this node
        #     
        dispvals = displacement.GetNodeValues(nodeid)
        #
        # Determine if the component diplacement (X Y Z) is min or max
        #
        if num == 0:
            maxdispx = dispvals[0]
            mindispx = dispvals[0]
            maxdispy = dispvals[1]
            mindispy = dispvals[1]
            maxdispz = dispvals[2]
            mindispz = dispvals[2]
        
        num += 1
        
        if dispvals[0] > maxdispx:
            maxdispx = dispvals[0]
        if dispvals[1] > maxdispy:
            maxdispy = dispvals[1]
        if dispvals[2] > maxdispz:
            maxdispz = dispvals[2]
        if dispvals[0] < mindispx:
            mindispx = dispvals[0]
        if dispvals[1] < mindispy:
            mindispy = dispvals[1]
        if dispvals[2] < mindispz:
            mindispz = dispvals[2]
    
    # Get the stress result object
    stress = reader.GetResult("S")
    
    num = 0
    for elementid in elementids:  
        element = meshObj.ElementById(elementid)
        #
        # Get the SXX stress component
        #
        stressval = stress.GetElementValues(elementid)
        #
        # Get the primary node ids for this element
        #
        nodeids = element.CornerNodeIds
        for i in range(nodeids.Count): 
            #
            # Get the SXX stress component at node "nodeid"
            #
            SXX = stressval[i]
            #
            # Determine if the SXX stress component is min or max
            #
            if num == 0:
                maxsxx = SXX
                minsxx = SXX
            
            if SXX > maxsxx:
                maxsxx = SXX
            if SXX < minsxx:
                minsxx = SXX
                
            num += 1
    #
    # Write the results to the output
    #
    f.write("Max U,X:Y:Z = "+maxdispx.ToString()+" : "+maxdispy.ToString()+" : "+maxdispz.ToString()+"\n")
    f.write("Min U,X:Y:Z = "+mindispx.ToString()+" : "+mindispy.ToString()+" : "+mindispz.ToString()+"\n")
    f.write("Max SXX = "+maxsxx.ToString()+"\n")
    f.write("Min SXX = "+minsxx.ToString()+"\n")
    f.close()
    

