# ----------------------------------------------
# Callbacks
# ----------------------------------------------
    
oDesign = None
oProject = None   
    
def OnUpdate1(step):
    global oDesign, oProject
    oProject = oDesktop.NewProject()
    oProject.InsertDesign("HFSS", "HFSSDesign1", "DrivenModal", "")
    oDesign = oProject.SetActiveDesign("HFSSDesign1")
    oEditor = oDesign.SetActiveEditor("3D Modeler")
    
    width = step.Properties["dim/width"].Value
    height = step.Properties["dim/height"].Value
    offset = step.Properties["offset/offset"].Value

    oEditor.CreateRectangle(
        [
            "NAME:RectangleParameters",
            "IsCovered:="       , True,
            "XStart:="      , "0mm",
            "YStart:="      , "0mm",
            "ZStart:="      , "0mm",
            "Width:="       , str(width)+"mm",
            "Height:="      , str(height)+"mm",
            "WhichAxis:="       , "Z"
        ], 
        [
            "NAME:Attributes",
            "Name:="        , "Rectangle1",
            "Flags:="       , "",
            "Color:="       , "(128 255 255)",
            "Transparency:="    , 0.800000011920929,
            "PartCoordinateSystem:=", "Global",
            "UDMId:="       , "",
            "MaterialValue:="   , "\"vacuum\"",
            "SolveInside:="     , True
        ])
    oEditor.DuplicateAlongLine(
        [
            "NAME:Selections",
            "Selections:="      , "Rectangle1",
            "NewPartsModelFlag:="   , "Model"
        ], 
        [
            "NAME:DuplicateToAlongLineParameters",
            "CreateNewObjects:="    , True,
            "XComponent:="      , "0mm",
            "YComponent:="      , str(height+offset)+"mm",
            "ZComponent:="      , "0mm",
            "NumClones:="       , "2"
        ], 
        [
            "NAME:Options",
            "DuplicateAssignments:=", False
        ])
 
def OnReset1(step):
    global oProject
    oDesktop.CloseProject(oProject.GetName())
 
def OnUpdate2(step):
    global oDesign
    oModule = oDesign.GetModule("BoundarySetup")

    width = step.PreviousStep.Properties["dim/width"].Value
    height = step.PreviousStep.Properties["dim/height"].Value
    offset = step.PreviousStep.Properties["offset/offset"].Value
    
    resistance = step.Properties["bc/resistance"].Value
    reactance = step.Properties["bc/reactance"].Value
    
    oModule.AssignPerfectE(
        [
            "NAME:PerfE1",
            "Objects:="     , ["Rectangle1_1","Rectangle1"],
            "InfGroundPlane:="  , False
        ])
    oEditor = oDesign.SetActiveEditor("3D Modeler")
    oEditor.CreateRectangle(
        [
            "NAME:RectangleParameters",
            "IsCovered:="       , True,
            "XStart:="      , "0mm",
            "YStart:="      , str(height)+"mm",
            "ZStart:="      , "0mm",
            "Width:="       , str(width)+"mm",
            "Height:="      , str(offset)+"mm",
            "WhichAxis:="       , "Z"
        ], 
        [
            "NAME:Attributes",
            "Name:="        , "Rectangle2",
            "Flags:="       , "",
            "Color:="       , "(128 255 255)",
            "Transparency:="    , 0.800000011920929,
            "PartCoordinateSystem:=", "Global",
            "UDMId:="       , "",
            "MaterialValue:="   , "\"vacuum\"",
            "SolveInside:="     , True
        ])
    oModule.AssignLumpedPort(
        [
            "NAME:1",
            "Objects:="     , ["Rectangle2"],
            "RenormalizeAllTerminals:=", True,
            "DoDeembed:="       , False,
            [
                "NAME:Modes",
                [
                    "NAME:Mode1",
                    "ModeNum:="     , 1,
                    "UseIntLine:="      , True,
                    [
                        "NAME:IntLine",
                        "Start:="       , [str(width/2.)+"mm",str(height)+"mm","0mm"],
                        "End:="         , [str(width/2.)+"mm",str(height+offset)+"mm","0mm"]
                    ],
                    "AlignmentGroup:="  , 0,
                    "CharImp:="     , "Zpi",
                    "RenormImp:="       , "50ohm"
                ]
            ],
            "ShowReporterFilter:="  , False,
            "ReporterFilter:="  , [True],
            "FullResistance:="  , str(resistance)+"ohm",
            "FullReactance:="   , str(reactance)+"ohm"
        ])

