import units

def CreateDeck(ag):
    ExtAPI.CreateFeature("Deck")
    
def CreateSupport(ag):
    ExtAPI.CreateFeature("Support")

def GenerateDeck(feature,fct):
    length = feature.Properties["Length"].Value
    length = units.ConvertUnit(length, ExtAPI.DataModel.CurrentUnitFromQuantityName("Length"), "m") 
    width = feature.Properties["Width"].Value
    width = units.ConvertUnit(width, ExtAPI.DataModel.CurrentUnitFromQuantityName("Length"), "m") 
    num = feature.Properties["Beams"].Value
    
    builder = ExtAPI.DataModel.GeometryBuilder
    
    bodies = []
    
    boxGen = builder.Primitives.Solid.CreateBox([0.,-width/2.,-0.3],[length,width/2.,0.])
    bodies.Add(boxGen.Generate())    
            
    w = (length-0.1*num)/(num-1.)+0.1
    for i in range(num-1):
        beamGen = builder.Primitives.Solid.CreateBox([i*w,-width/2.,-0.6],[i*w+0.1,width/2.,-0.3])
        bodies.Add(beamGen.Generate())
    
    beamGen = builder.Primitives.Solid.CreateBox([length-0.1,-width/2.,-0.6],[length,width/2.,-0.3])
    bodies.Add(beamGen.Generate())

    beamGen = builder.Primitives.Solid.CreateBox([0.,-width/2.,-1.],[length,-width/2.+0.2,-0.6])
    bodies.Add(beamGen.Generate())
    beamGen = builder.Primitives.Solid.CreateBox([0.,width/2.-0.2,-1.],[length,width/2.,-0.6])
    bodies.Add(beamGen.Generate())
    
    feature.Bodies = bodies
    feature.MaterialType = MaterialTypeEnum.Add

    return True
    
def GenerateSupport(feature,fct):
    length = feature.Properties["Length"].Value
    length = units.ConvertUnit(length, ExtAPI.DataModel.CurrentUnitFromQuantityName("Length"), "m") 
    height = feature.Properties["Height"].Value
    height = units.ConvertUnit(height, ExtAPI.DataModel.CurrentUnitFromQuantityName("Length"), "m") 
    width = feature.Properties["Width"].Value
    width = units.ConvertUnit(width, ExtAPI.DataModel.CurrentUnitFromQuantityName("Length"), "m") 
    num = feature.Properties["Number"].Value
    
    builder = ExtAPI.DataModel.GeometryBuilder
    
    bodies = []
    
    w = (length-2.*num)/(num+1.)+2.
    for i in range(num):
        beamGen = builder.Primitives.Solid.CreateBox([(i+1)*w,-width/2.,-1.-height],[(i+1)*w+2.,width/2.,-1.])
        bodies.Add(beamGen.Generate())
    
    beamGen = builder.Primitives.Solid.CreateBox([0.,-width/2.,-5.],[2.,width/2.,-1.])
    bodies.Add(beamGen.Generate())

    beamGen = builder.Primitives.Solid.CreateBox([length-2.,-width/2.,-5.],[length,width/2.,-1.])
    bodies.Add(beamGen.Generate())
    
    feature.Bodies = bodies
    feature.MaterialType = MaterialTypeEnum.Freeze

    return True
    
def UpdateDeck(step):
    deck = ExtAPI.CreateFeature("Deck")
    deck.Properties["Length"].Value = step.Properties["Deck/Length"].Value
    deck.Properties["Width"].Value = step.Properties["Deck/Width"].Value
    deck.Properties["Beams"].Value = step.Properties["Deck/Beams"].Value
    ExtAPI.DataModel.FeatureManager.Generate()
    
def UpdateSupports(step):
    supports = ExtAPI.CreateFeature("Support")
    supports.Properties["Length"].Value = step.PreviousStep.Properties["Deck/Length"].Value
    supports.Properties["Width"].Value = step.PreviousStep.Properties["Deck/Width"].Value+6
    supports.Properties["Height"].Value = step.Properties["Supports/Height"].Value
    supports.Properties["Number"].Value = step.Properties["Supports/Number"].Value
    ExtAPI.DataModel.FeatureManager.Generate()
