def IsLocationValid(step, prop):
    if prop.Value==None:
        return False
    if prop.Value.Ids.Count!=1:
        prop.StateMessage = "Select only one edge."
        return False
    return True

def CreateMeshControls(step):
    model = ExtAPI.DataModel.Project.Model
    mesh = model.Mesh
    sizing = mesh.AddSizing()
    sel = step.Properties["Sizing/Location"].Value
    entity = ExtAPI.DataModel.GeoData.GeoEntityById(sel.Ids[0])
    len = entity.Length
    ids = []
    for part in ExtAPI.DataModel.GeoData.Assemblies[0].Parts:
        for body in part.Bodies:
            for edge in  body.Edges:
                if abs(edge.Length-len)/len<1.e-6:
                    ids.Add(edge.Id)
    sel = ExtAPI.SelectionManager.CreateSelectionInfo(SelectionTypeEnum.GeometryEntities)
    sel.Ids = ids
    sizing.Location = sel
    sizing.Type = SizingType.NumberOfDivisions
    sizing.NumberOfDivisions = step.Properties["Sizing/Ndiv"].Value
    step.Attributes.SetValue("sizing", sizing)
    mesh.GenerateMesh()

def RemoveControls(step):
    sizing = step.Attributes["sizing"]
    sizing.Delete()

def IsLocationFSValid(step, prop):
    if prop.Value==None:
        return False
    if prop.Value.Ids.Count!=1:
        prop.StateMessage = "Select only one face."
        return False
    return True

def RefreshLoads(step):
    model = ExtAPI.DataModel.Project.Model
    step.Properties["Mesh/Nodes"].Value = model.Mesh.Nodes.ToString()
    step.Properties["Mesh/Elements"].Value = model.Mesh.Elements.ToString()
    panel = step.UserInterface.GetComponent("Properties")
    panel.UpdateData()
    panel.Refresh()
    
def CreateLoads(step):
    model = ExtAPI.DataModel.Project.Model
    analysis = model.Analyses[0]
    support = analysis.AddFixedSupport()
    sel = step.Properties["FixedSupport/Location"].Value
    entity = ExtAPI.DataModel.GeoData.GeoEntityById(sel.Ids[0])
    area = entity.Area
    ids = []
    for part in ExtAPI.DataModel.GeoData.Assemblies[0].Parts:
        for body in part.Bodies:
            for face in  body.Faces:
                if abs(face.Area-area)/area<1.e-6:
                    ids.Add(face.Id)
    sel = ExtAPI.SelectionManager.CreateSelectionInfo(SelectionTypeEnum.GeometryEntities)
    sel.Ids = ids
    support.Location = sel
    loads = []
    loads.Add(support)
    step.Attributes.SetValue("loads", loads)
    
    loads.Add(analysis.AddEarthGravity())
    res = analysis.Solution.AddTotalDeformation()
    step.Attributes.SetValue("res", res)
    loads.Add(res)
    analysis.Solve(True)
    ExtAPI.Extension.SetAttributeValueWithSync("result", res.Maximum.ToString())

def RemoveLoads(step):
    loads = step.Attributes["loads"]
    for load in loads:
        load.Delete()
    
def RefreshResults(step):
    model = ExtAPI.DataModel.Project.Model
    res = step.PreviousStep.Attributes["res"]
    step.Properties["Res"].Value = res.Maximum.ToString()
    panel = step.UserInterface.GetComponent("Properties")
    panel.UpdateData()
    panel.Refresh()
    
