import units

def createBox(xa, ya, za, xb, yb, zb):
    win = Window.ActiveWindow
    context = win.ActiveContext
    part = context.ActivePart

    lengthX = xb - xa
    lengthY = yb - ya
    lengthZ = zb - za
    xa = xa + lengthX * 0.5
    ya = ya + lengthY * 0.5

    p = Geometry.PointUV.Create(0, 0)
    body = Modeler.Body.ExtrudeProfile(Geometry.RectangleProfile(Geometry.Plane.PlaneXY, lengthX, lengthY, p, 0), lengthZ)
    designBody = DesignBody.Create(part, "body", body)

    translation = Geometry.Matrix.CreateTranslation(Geometry.Vector.Create(xa, ya, za))
    designBody.Transform(translation)


def UpdateDeckSC(step):
    length = step.Properties["Deck/Length"].Value
    width = step.Properties["Deck/Width"].Value
    num = step.Properties["Deck/Beams"].Value

    createBox(0., -width/2., -0.3, length,width/2., 0.)

    w = (length-0.1*num)/(num-1.)+0.1
    for i in range(num-1):
        createBox(i*w,-width/2.,-0.6, i*w+0.1,width/2.,-0.3)

    createBox(length-0.1, -width/2., -0.6, length, width/2., -0.3)

    createBox(0., -width/2., -1., length, -width/2.+0.2, -0.6)
    createBox(0., width/2.-0.2, -1., length,width/2., -0.6)

    return True


def UpdateSupportsSC(step):
    length = step.PreviousStep.Properties["Deck/Length"].Value
    width = step.PreviousStep.Properties["Deck/Width"].Value
    height = step.Properties["Supports/Height"].Value
    num = step.Properties["Supports/Number"].Value

    w = (length-2.*num)/(num+1.)+2.
    for i in range(num):
        createBox((i+1)*w, -width/2., -1.-height, (i+1)*w+2., width/2.,-1.)

    beamGen = createBox(0., -width/2., -5., 2., width/2., -1.)
    beamGen = createBox(length-2., -width/2.,-5., length,width/2., -1.)

    return True
