# Callback to create the load that will show a body-body view.
def CreateDoubleBodyView(analysis):
    
    # Use the analysis to create the load.
    load = analysis.CreateLoadObject("DoubleBodyView", "Template12-BodyView")
    
    # Get the named selections that will be assinged to the scoping properties of this load
    selections = Model.NamedSelections.Children
    
    # Assign the named selections to the scoping properties
    load.Properties["Scoping1"].Value = [sel for sel in selections if sel.Name == "Body 1"][0] 
    load.Properties["Scoping2"].Value = [sel for sel in selections if sel.Name == "Body 2"][0] 

#Callback to create the load that will show a body-ground view.
def CreateSingleBodyView(analysis):

    # Use the analysis to create the load.
    load = analysis.CreateLoadObject("SingleBodyView", "Template12-BodyView")

    # Get the named selections that will be assinged to the scoping property of this load
    selections = Model.NamedSelections.Children

    # Assign the named selection to the scoping property
    load.Properties["Scoping1"].Value = [sel for sel in selections if sel.Name == "Body 1"][0] 

"""
       Function associated to the OnDrawBodyViews callback.
       Control if and what to show the body views.
    
       Keyword arguments:
       load     -- the load bound containing the Scoping property.
       view1    -- the view that controls the pane caption and the selection to be show in the body view pane
       view2    -- the view that controls the pane caption and the selection to be show in the body view second pane

       Return value: 
       Boolean  -- Value that decides whether to show the body view or not.
"""
def OnDrawBodyViewsDouble(load, view1, view2):
    # Set the pane captions
    view1.Name = "Body 1"
    view2.Name = "Body 2"

    # Set the selections
    view1.Selection = load.Properties["Scoping1"].Value
    view2.Selection = load.Properties["Scoping2"].Value

    #return true to show the body views
    return True

"""
       Function associated to the OnDrawBodyViews callback.
       Control if and what to show the body view.
    
       Keyword arguments:
       load     -- the load bound containing the Scoping property.
       view1    -- the view that controls the pane name and the selection to be show in the body view pane
       view2    -- the view that controls the pane name and the selection to be show in the body view second pane

       Return value: 
       Boolean  -- Value that decides whether to show the body view or not.
"""
def OnDrawBodyViewsBodySingle(load, view1, view2):
    # Set only view1's name, so this body view is treated as body-ground
    view1.Name = "Body 1"

    # Set the selection
    view1.Selection = load.Properties["Scoping1"].Value

    #return true to show the body view
    return True
