import os

def Solve(s,fct):
    
    f = open("solve.out","w")
    f.write("SolverEngine version 1.0\n\n\n")
    try:
        # The function magnitudes can be accessed here in the onSolve callback
        # For example, if there was an acceleration added, you would access the function in this way
        acc = ExtAPI.Application.InvokeUIThread(GetAccelerationLoadsFormulas, s)

        # Write out the magnitude to the solver output file
        for mag in acc:
            f.write("Acceleration Magnitude : " + mag)

    except StandardError, e:
        f.write("Error:\n");
        f.write(e.message+"\n");
        f.close()
        return False

    f.close()
    
    return True

# Get the acceleration magnitude from the native object
def GetAccelerationLoadsFormulas(solver):
    # Get the analysis from the solver
    analysis = solver.Analysis

    # Get the Accelration object from the analysis's children
    accLoads = analysis.GetChildren(DataModelObjectCategory.Acceleration, True)

    formulas = []
    for acc in accLoads:
        # Get the acceleration's magnitude and append it to this list
        formulas.append(acc.Magnitude.Output.Formula)

    # Return the list to the onSolve callback
    return formulas