import System
import clr
clr.AddReference("Ans.ProjectSchematic")
import Ansys.ProjectSchematic

systemHandler = None

def update(task):
    ExtAPI.Log.WriteMessage("Updating task " + task.Name)
def initialize(context):
    global systemHandler
    systemHandler = System.EventHandler[Ansys.ProjectSchematic.Events.SystemFullyCreatedEventArgs](handleSystemCreation)
    Ansys.ProjectSchematic.Events.SchematicEventSource.GetEventSource().SystemFullyCreated += systemHandler
    ExtAPI.Log.WriteMessage("Initializing CaptionChanger extension...")
def handleSystemCreation(sender, args):
    system = args.System
    if system.Name.StartsWith("CAPTN"):
        taskGroup = ExtAPI.DataModel.GetTaskGroupById(system.Name)
        task1 = taskGroup.Tasks[0]
        actDir = task1.ActiveDirectory
        taskGroup.Caption = actDir.split(os.path.sep)[-2]
def terminate(context):
    ExtAPI.Log.WriteMessage("Terminating CaptionChanger extension...")
    global systemHandler
    if systemHandler != None:
        Ansys.ProjectSchematic.Events.SchematicEventSource.GetEventSource().SystemFullyCreated -= systemHandler
