import System
import clr
clr.AddReference("Ans.Core")
import Ansys.Core

class MyCommand(Ansys.Core.Commands.ICommand):
    def Execute(self, context):
        ExtAPI.Log.WriteMessage("Command executing...")
        import clr
        clr.AddReference("Ans.Core")
        import Ansys.Core
        monitor = context.ProgressMonitor
        monitor.BeginTask("Command Example", 1, None)
        while monitor.ProgressStatus == Ansys.Core.ProgressMonitoring.ProgressStatus.Running:
            ExtAPI.Log.WriteMessage('...working...')
            System.Threading.Thread.Sleep(1000)
        ExtAPI.Log.WriteMessage('Command cancelled...')
def MyCommandCreator():
    return MyCommand()
def click(context):
    cmd = None
    try:
        cmd = ExtAPI.DataModel.Context.Session.CommandManager.GetRegisteredCommand("ACT.MyCommand")
    except:
        print ''
    if cmd == None:
        spec = Ansys.Core.Commands.CommandSpec(MyCommandCreator, "MyCommand", "ACT")
        ExtAPI.DataModel.Context.Session.CommandManager.Register(spec)
    monitor = Ansys.UI.ProgressMonitor()
    monitor.CanAbort = True
    monitor.CanInterrupt = True
    t = System.Threading.Thread(System.Threading.ParameterizedThreadStart(canceller))
    ExtAPI.Log.WriteMessage("Starting canceller...")
    t.Start(monitor)
    ExtAPI.Log.WriteMessage("Invoking command...")
    #res = ACT.MyCommand.InvokeAsync(monitor, ExtAPI.DataModel.Context)
    ACT.MyCommand(progressMonitor=monitor)
def canceller(monitor):
    ExtAPI.Log.WriteMessage("Canceller started...")
    System.Threading.Thread.Sleep(6000)
    ExtAPI.Log.WriteMessage("Canceller issuing cancel...")
    monitor.Cancel()
    ExtAPI.Log.WriteMessage("Canceller stopping...")
