import clr
import os
clr.AddReference("Ans.Utilities")
clr.AddReference("Ans.UI.Toolkit")
clr.AddReference("Ans.UI.toolkit.Base")
import System
import sys
import subprocess
import shutil
global myres
import math
import time

from Ansys.Utilities import *
from System.IO import *
from System.Diagnostics import *
from Ansys.UI.Toolkit import *

def updateGeometry(task):
    icemgeoAddinPath = task.Extension.InstallDir
    installPath = ApplicationConfiguration.DefaultConfiguration.WorkbenchInstallRootDirectoryPath
    activeDir = task.ActiveDirectory
    #geom replay contents
    geomReplayContents = """
    #create geometry
    #starting here
    ic_geo_new_family GEOM
    ic_boco_set_part_color GEOM
    #create small box
    ic_vid_object box8 GEOM 00 {0 0 0} 20 5 5
    ic_set_dormant_pickable point 0 {}
    ic_set_dormant_pickable curve 0 {}
    #create small box
    ic_vid_object box8 GEOM 00 {10  2 1} $inp1 1 $inp2
    ic_set_dormant_pickable point 0 {}
    ic_set_dormant_pickable curve 0 {}
    #create boundary condition
    ic_geo_set_part surface box8.GEOM.00.S5 INLET 0
    ic_geo_set_part surface box8.GEOM.00.S6 OUTLET 0
    #save tetin file
    """
    #Create the replay file in the project dir
    replayFileName = "create_geom.rpl"
    replayFilePath = Path.Combine(activeDir, replayFileName)
    #Assembling the replay file with correct storage location
    dim1 = task.Properties["Inputs"].Properties["dim1"].Value
    dim2 = task.Properties["Inputs"].Properties["dim2"].Value
    CreateRPLFile = open(replayFilePath,'w')
    CreateRPLFile.write("set inp1 " + str(dim1) + '\n')
    CreateRPLFile.write("set inp2 " + str(dim2) + '\n')
    CreateRPLFile.write(geomReplayContents + '\n')
    #Define the path for the tin file to save and write to the replay file
    geoFileName = "channel.tin"
    destinationPath = Path.Combine(activeDir, geoFileName)
    #Write the save command to the rpl file
    strReplace=destinationPath.replace('\\','/')
    CreateRPLFile.write("ic_save_tetin " + strReplace + " 0 0 {} {} 0 0 1"+'\n')
    CreateRPLFile.close()
    #Launch icem
    icemBin = Path.Combine(installPath, Path.Combine("icemcfd", Path.Combine("win64_amd","bin")))
    icemExeName = "icemcfd.bat"
    icemExePath = Path.Combine(icemBin, icemExeName)
    if File.Exists(icemExePath) == True:
        info = ProcessStartInfo(icemExePath)
        info.Arguments = System.String.Format("-batch -script \"{0}\"", replayFilePath)
        Process.Start(info).WaitForExit()
    #Register the .tin file 
    geoFile = None
    isRegistered = IsFileRegistered(FilePath=destinationPath)
    if isRegistered == True:
         geoFile = GetRegisteredFile(destinationPath)
    else:
         geoFile = task.RegisterFile(destinationPath)
    #Transfer file downstreams
    geoRefs = task.OutputData
    geoSet = geoRefs["CustomGeometry"]
    geoData = geoSet[0]
    geoData.TransferFile = geoFile  
def updateMesh(task):
    #Calculate Paths
    installPath = ApplicationConfiguration.DefaultConfiguration.WorkbenchInstallRootDirectoryPath
    icemmeshAddinPath = task.Extension.InstallDir
    activeDir = task.ActiveDirectory
    cfxFormattedActiveDir = activeDir.replace('\\','/')
    #Obtain upstream data
    upstreamData = task.InputData["CustomGeometry"]
    geoFileRef = None
    upstreamDataCount = upstreamData.Count
    if upstreamDataCount > 0:
        geoFileRef = upstreamData[0]
    replayContents = """ic_boco_solver 
    ic_boco_clear_icons 
    ic_csystem_display all 0
    ic_csystem_set_current global
    ic_boco_nastran_csystem reset
    ic_geo_set_modified 0
    ic_csystem_display all 0
    ic_csystem_set_current global
    ic_boco_nastran_csystem reset
    ic_undo_group_begin 
    ic_undo_group_end 
    ic_undo_group_begin 
    ic_geo_new_family BODY
    ic_boco_set_part_color BODY
    ic_geo_create_volume {5 3.98477615118805 1.5} {} BODY
    ic_undo_group_end 
    ic_undo_group_begin 
    ic_undo_group_end 
    ic_undo_group_begin 
    ic_set_meshing_params global 0 gref 1.0 gmax 1 gfast 0 gedgec 0.2 gnat 0 gcgap 1 gnatref 10
    ic_undo_group_end 
    ic_undo_group_begin 
    ic_geo_set_family_params INLET no_crv_inf prism 0 emax 0.1 ehgt 0.0 hrat 0 nlay 0 erat 0 ewid 0 emin 0.0 edev 0.0 split_wall 0 internal_wall 0
    ic_undo_group_end 
    ic_geo_params_blank_done part 1
    ic_undo_group_begin 
    ic_run_tetra ./ ./tetra_mesh.uns run_cutter 1 delete_auto 1 run_smoother 0 fix_holes 1 n_processors 1 in_process 1 log ./tetra_cmd.log
    ic_geo_set_modified 1
    ic_uns_update_family_type visible {INLET GEOM OUTLET ORFN BODY} {!NODE !LINE_2 TRI_3 !TETRA_4} update 0
    ic_boco_solver 
    ic_uns_update_family_type visible {INLET GEOM OUTLET ORFN BODY} {!NODE !LINE_2 TRI_3 !TETRA_4} update 0
    ic_boco_clear_icons 
    ic_csystem_display all 0
    ic_csystem_set_current global
    ic_boco_nastran_csystem reset
    ic_uns_diagnostic diag_type single quiet 1
    ic_smooth_elements map all upto 0.4 iterations 5 fix_families {} n_processors 1 smooth TRI_3 float TETRA_4 laplace 1
    ic_smooth_elements map all upto 0.4 iterations 5 prism_warp_weight 0.5 fix_families {} n_processors 1 smooth TETRA_4 float PENTA_6 freeze TRI_3
    ic_smooth_elements map all upto 0.4 iterations 5 prism_warp_weight 0.5 fix_families {} metric Quality n_processors 1 smooth TETRA_4 smooth TRI_3 float PENTA_6
    ic_geo_set_modified 1
    ic_uns_update_family_type visible {INLET GEOM OUTLET ORFN BODY} {!NODE !LINE_2 TRI_3 !TETRA_4} update 0
    ic_uns_update_family_type visible {INLET GEOM OUTLET ORFN BODY} {!NODE !LINE_2 TRI_3 !TETRA_4} update 0
    ic_undo_group_end 
    ic_undo_group_begin 
    ic_boco_solver {ANSYS CFX}
    ic_solver_mesh_info {ANSYS CFX}
    ic_undo_group_end 
    ic_boco_solver 
    ic_chdir """+cfxFormattedActiveDir+"""\nic_boco_save nastran.fbc
    ic_boco_save_atr nastran.atr
    ic_save_tetin project1.tin 0 0 {} {} 0 0 1
    ic_uns_check_duplicate_numbers 
    ic_uns_renumber_all_elements 1 1
    ic_save_unstruct project1.uns 1 {} {} {}
    ic_uns_set_modified 1
    ic_boco_solver 
    ic_boco_save project1.fbc
    ic_boco_save_atr project1.atr
    ic_cart_is_loaded 
    ic_save_project_file project1.prj {array\ set\ file_name\ \{ {    catia_dir .} {    parts_dir .} {    domain_loaded 0} {    cart_file_loaded 0} {    cart_file {}} {    domain_saved project1.uns} {    archive {}} {    med_replay {}} {    topology_dir .} {    ugparts_dir .} {    icons {{$env(ICEM_ACN)/lib/ai_env/icons} {$env(ICEM_ACN)/lib/va/EZCAD/icons} {$env(ICEM_ACN)/lib/icons} {$env(ICEM_ACN)/lib/va/CABIN/icons}}} {    tetin project1.tin} {    family_boco project1.fbc} {    prism_params C:/Users/1990joru/Desktop/2013_10_Grundfos_External/geom/channel.prism_params} {    iges_dir .} {    solver_params_loaded 0} {    attributes_loaded 0} {    project_lock {}} {    attributes project1.atr} {    domain project1.uns} {    domains_dir .} {    settings_loaded 0} {    settings project1.prj} {    blocking {}} {    hexa_replay {}} {    transfer_dir .} {    mesh_dir .} {    family_topo {}} {    gemsparts_dir .} {    family_boco_loaded 0} {    tetin_loaded 1} {    project_dir .} {    topo_mulcad_out {}} {    solver_params {}} \} array\ set\ options\ \{ {    expert 1} {    remote_path {}} {    tree_disp_quad 2} {    tree_disp_pyra 0} {    evaluate_diagnostic 0} {    histo_show_default 1} {    select_toggle_corners 0} {    remove_all 0} {    keep_existing_file_names 0} {    record_journal 0} {    edit_wait 0} {    face_mode all} {    select_mode all} {    med_save_emergency_tetin 1} {    user_name 1990joru} {    diag_which all} {    uns_warn_if_display 500000} {    bubble_delay 1000} {    external_num 1} {    tree_disp_tri 2} {    apply_all 0} {    temporary_directory {}} {    flood_select_angle 0} {    home_after_load 1} {    project_active 0} {    histo_color_by_quality_default 1} {    undo_logging 1} {    tree_disp_hexa 0} {    histo_solid_default 1} {    host_name 1990ltw204} {    xhidden_full 1} {    editor {}} {    mouse_color orange} {    clear_undo 1} {    remote_acn {}} {    remote_sh csh} {    tree_disp_penta 0} {    n_processors 1} {    remote_host {}} {    save_to_new 0} {    quality_info Quality} {    tree_disp_node 0} {    med_save_emergency_mesh 1} {    redtext_color red} {    tree_disp_line 0} {    select_edge_mode 0} {    use_dlremote 0} {    max_mesh_map_size 1024} {    show_tris 1} {    remote_user {}} {    auto_save_views 1} {    max_cad_map_size 512} {    display_origin 0} {    uns_warn_user_if_display 1000000} {    detail_info 0} {    win_java_help 0} {    show_factor 1} {    boundary_mode all} {    clean_up_tmp_files 1} {    med_save_emergency_blocking 1} {    max_binary_tetin 0} {    tree_disp_tetra 0} \} array\ set\ disp_options\ \{ {    uns_dualmesh 0} {    uns_warn_if_display 500000} {    uns_normals_colored 0} {    uns_icons 0} {    uns_locked_elements 0} {    uns_shrink_npos 0} {    uns_node_type None} {    uns_icons_normals_vol 0} {    uns_bcfield 0} {    backup Wire} {    uns_nodes 0} {    uns_only_edges 0} {    uns_surf_bounds 0} {    uns_wide_lines 0} {    uns_vol_bounds 0} {    uns_displ_orient Triad} {    uns_orientation 0} {    uns_directions 0} {    uns_thickness 0} {    uns_shell_diagnostic 0} {    uns_normals 0} {    uns_couplings 0} {    uns_periodicity 0} {    uns_single_surfaces 0} {    uns_midside_nodes 1} {    uns_shrink 100} {    uns_multiple_surfaces 0} {    uns_no_inner 0} {    uns_enums 0} {    uns_disp Wire} {    uns_bcfield_name {}} {    uns_color_by_quality 0} {    uns_changes 0} {    uns_cut_delay_count 1000} \} {set icon_size1 24} {set icon_size2 35} {set thickness_defined 0} {set solver_type 1} {set solver_setup 0} array\ set\ prism_values\ \{ {    n_triangle_smoothing_steps 5} {    min_smoothing_steps 6} {    first_layer_smoothing_steps 1} {    new_volume {}} {    height 0} {    prism_height_limit {}} {    interpolate_heights 0} {    n_tetra_smoothing_steps 10} {    do_checks {}} {    delete_standalone 1} {    ortho_weight 0.50} {    max_aspect_ratio {}} {    ratio_max {}} {    total_height 0} {    use_prism_v10 0} {    intermediate_write 1} {    delete_base_triangles {}} {    ratio_multiplier {}} {    refine_prism_boundary 1} {    max_size_ratio {}} {    triangle_quality {}} {    max_prism_angle 180} {    tetra_smooth_limit 0.3} {    max_jump_factor 5} {    use_existing_quad_layers 0} {    layers 3} {    fillet 0.10} {    into_orphan 0} {    init_dir_from_prev {}} {    blayer_2d 0} {    do_not_allow_sticking {}} {    top_family {}} {    law exponential} {    min_smoothing_val 0.1} {    auto_reduction 0} {    stop_columns 1} {    stair_step 1} {    smoothing_steps 12} {    side_family {}} {    min_prism_quality 0.01} {    ratio 1.2} \} {set aie_current_flavor {}} array\ set\ vid_options\ \{ {    wb_NS_to_subset 0} {    auxiliary 0} {    show_name 0} {    inherit 1} {    default_part GEOM} {    new_srf_topo 1} {    DelPerFlag 0} {    show_item_name 0} {    composite_tolerance 1.0} {    wb_import_scale_geo 0} {    replace 0} {    same_pnt_tol 1e-4} {    tdv_axes 1} {    vid_mode 0} {    DelBlkPerFlag 0} \} {set savedTreeVisibility {geomNode 1 geom_subsetNode 2 geomPointNode 0 geomCurveNode 2 geomSurfNode 0 geomBodyNode 2 meshNode 1 mesh_subsetNode 2 meshPointNode 0 meshLineNode 0 meshShellNode 2 meshTriNode 2 meshVolumeNode 0 meshTetraNode 0 partNode 2 part-BODY 2 part-GEOM 2 part-INLET 2 part-OUTLET 2}} {set last_view {rot {-0.121177242527 -0.494706960457 -0.0177633932749 0.860386867064} scale {67.9725 67.9725 67.9725} center {0.00031758908377899076 3.8134893287468707 5.0047881992469216} pos {-270.888476314 -40.999997503 0}}} array\ set\ cut_info\ \{ {    active 0} \} array\ set\ hex_option\ \{ {    default_bunching_ratio 2.0} {    floating_grid 0} {    n_tetra_smoothing_steps 20} {    trfDeg 1} {    wr_hexa7 0} {    smooth_ogrid 0} {    find_worst 1-3} {    hexa_verbose_mode 0} {    old_eparams 0} {    uns_face_mesh_method uniform_quad} {    multigrid_level 0} {    uns_face_mesh one_tri} {    check_blck 0} {    proj_limit 0} {    check_inv 0} {    project_bspline 0} {    hexa_update_mode 1} {    default_bunching_law BiGeometric} \} array\ set\ saved_views\ \{ {    views {}} \}} {ICEM CFD}
    """
    #Create the replay file
    replayFileName = "create_mesh.rpl"
    mshFileName = "channel.msh"
    replaydestinationPath = Path.Combine(activeDir, replayFileName)
    mshFilePath = Path.Combine(activeDir, mshFileName)
    CreateRPLFile = open(replaydestinationPath,'w')
    strgeoFile = geoFileRef.Location
    strgeoFileReplace=strgeoFile.replace('\\','/')
    CreateRPLFile.write("ic_load_tetin " + strgeoFileReplace + '\n')
    CreateRPLFile.write(replayContents + '\n')
    #Add the path to the save location for mesh file
    mshFileReplace=mshFilePath.replace('\\','/')
    cfx5Path = Path.Combine(installPath, Path.Combine("icemcfd", Path.Combine("win64_amd", Path.Combine("icemcfd", Path.Combine("output-interfaces", "cfx5")))))
    saveContent = "ic_exec {" + cfx5Path + "} -dom project1.uns -b project1.fbc -ascii -db -internal_faces " + mshFileReplace + '\n'
    CreateRPLFile.write(saveContent)
    CreateRPLFile.close()
    #Launch icem
    icemBin = Path.Combine(installPath, Path.Combine("icemcfd", Path.Combine("win64_amd","bin")))
    icemExeName = "icemcfd.bat"
    icemExePath = Path.Combine(icemBin, icemExeName)
    if File.Exists(icemExePath) == True:
        info = ProcessStartInfo(icemExePath)
        info.Arguments = System.String.Format("-batch -script \"{0}\"", replaydestinationPath)
        Process.Start(info).WaitForExit()
    #Register the .msh file 
    mshFile = None
    isRegistered = IsFileRegistered(FilePath=mshFilePath)
    if isRegistered == True:
         mshFile = GetRegisteredFile(mshFilePath)
    else:
         mshFile = task.RegisterFile(mshFilePath)
    #Convert File into a gtm file readable by the cfx system
    targetGTMName = "channel_converted.gtm"
    targetGTMPath = Path.Combine(activeDir, targetGTMName)
    cfxBin = Path.Combine(installPath, Path.Combine("CFX", "bin"))
    cfxConverterExeName = "cfx5gtmconv.exe"
    cfxConverterExePath = Path.Combine(cfxBin, cfxConverterExeName)
    if File.Exists(cfxConverterExePath) == True:
        info = ProcessStartInfo(cfxConverterExePath)
        info.Arguments = System.String.Format("-icem \"{0}\" \"{1}\"", mshFilePath, targetGTMPath)
        Process.Start(info).WaitForExit()
    gtmFile = None
    if File.Exists(targetGTMPath) == True:
        if IsFileRegistered(FilePath=targetGTMPath) == False:
            gtmFile = task.RegisterFile(targetGTMPath)
        else:
            gtmFile = GetRegisteredFile(FilePath=targetGTMPath)
    outputRefs = task.OutputData
    meshOutputSet = outputRefs["CFXMesh"]
    meshOutput = meshOutputSet[0]
    meshOutput.FileName = gtmFile
    meshOutput.PreFileType = "GTM"
#rsm callbacks
def createJobInput(task, inputFilePaths):
    print 'creating job input'
    cleanupGeomFile(task)
    #geom replay contents
    geomReplayContents = """
    #create geometry
    #starting here
    ic_geo_new_family GEOM
    ic_boco_set_part_color GEOM
    #create small box
    ic_vid_object box8 GEOM 00 {0 0 0} 20 5 5
    ic_set_dormant_pickable point 0 {}
    ic_set_dormant_pickable curve 0 {}
    #create small box
    ic_vid_object box8 GEOM 00 {10  2 0} $inp1 1 $inp2
    ic_set_dormant_pickable point 0 {}
    ic_set_dormant_pickable curve 0 {}
    #create boundary condition
    ic_geo_set_part surface box8.GEOM.00.S5 INLET 0
    ic_geo_set_part surface box8.GEOM.00.S6 OUTLET 0
    #save tetin file
    """
    #Create the replay file in the project dir
    replayFilePath = inputFilePaths[0]
    #Assembling the replay file with correct storage location
    dim1 = task.Properties["Inputs"].Properties["dim1"].Value
    dim2 = task.Properties["Inputs"].Properties["dim2"].Value
    CreateRPLFile = open(replayFilePath,'w')
    CreateRPLFile.write("set inp1 " + str(dim1) + '\n')
    CreateRPLFile.write("set inp2 " + str(dim2) + '\n')
    CreateRPLFile.write(geomReplayContents + '\n')
    #Define the path for the tin file to save and write to the replay file
    geoFileName = "channel_temp.tin"
    activeDir = task.ActiveDirectory
    destinationPath = Path.Combine(activeDir, geoFileName)
    #Write the save command to the rpl file
    strReplace=destinationPath.replace('\\','/')
    CreateRPLFile.write("ic_save_tetin " + strReplace + " 0 0 {} {} 0 0 1"+'\n')
    CreateRPLFile.close()
def reconnectJob(task, outputFilePaths):
    print 'reconnecting job'
    outputFilePath = outputFilePaths[0] #I know we only have one specified based on our definition...so work off of the first entry
    if System.IO.File.Exists(outputFilePath):
        destPath = System.IO.Path.Combine(System.IO.Path.GetDirectoryName(outputFilePath), "channel.tin")
        System.IO.File.Copy(outputFilePath, destPath)
        localGeomFile = task.RegisterFile(destPath)
        outputRefs = task.OutputData
        xyzOutputSet = outputRefs["CustomGeometry"]
        geomOutput = xyzOutputSet[0]
        geomOutput.TransferFile = localGeomFile
    else:
        raise Exception("Custom Geometry CAD File Could Not Be Generated!")
def getJobStatus(task, outputFiles):
    print 'checking job status'
    outputFilePath = outputFiles[0]
    finished = System.IO.File.Exists(outputFilePath)
    return finished
def cancelJob(task, inputFiles, outputFiles):
    #nothing to do...just print a message for now.
    print 'performing cancellation clean up'
def cleanupGeomFile(task):
    activeDir = task.ActiveDirectory
    geomFilePath = System.IO.Path.Combine(activeDir, "channel.tin")
    tempGeomFilePath = System.IO.Path.Combine(activeDir, "channel_temp.tin")
    if System.IO.File.Exists(geomFilePath):
        if IsFileRegistered(FilePath=geomFilePath) == True:
            task.UnregisterFile(geomFilePath)
        else:
            System.IO.File.Delete(geomFilePath)
    if System.IO.File.Exists(tempGeomFilePath):
        System.IO.File.Delete(tempGeomFilePath)
def isValid1(entity, property):
    if property.Value < 0.0 or property.Value > 20.0:
        return False
    else:
        return True
def isValid2(entity, property):
    if property.Value < 0.0 or property.Value > 3.0:
        return False
    else:
        return True