import System
import clr
clr.AddReference("Ans.Core")
import Ansys.Core
clr.AddReference("Ans.UI")
import Ansys.UI
clr.AddReference("Ans.ProjectSchematic")
import Ansys.ProjectSchematic
clr.AddReference("Ans.UI.Toolkit")
clr.AddReference("Ans.UI.Toolkit.Base")
import Ansys.UI.Toolkit

def update(task):
    ExtAPI.Log.WriteMessage("Updating task " + task.Name)
def createContextMenu(context):
    ExtAPI.Log.WriteMessage("Registering custom context menu...")
    uiMgr = Ansys.UI.UIManager.Instance
    attributes = System.Collections.Generic.List[System.Attribute]()
    guiOpAttr = Ansys.UI.Attributes.GuiOperationAttribute("Invoke My Custom GuiOperation")
    guiOpAttr.ImageName = "customEntryIcon"
    attributes.Add(guiOpAttr)
    visOptions = Ansys.UI.Attributes.AttributeOptions.InitialVisibilityOff | Ansys.UI.Attributes.AttributeOptions.InitialEnablingOff | Ansys.UI.Attributes.AttributeOptions.UseCallback
    visAttr = Ansys.UI.Attributes.VisibilityAttribute(visOptions)
    attributes.Add(visAttr)
    menuEntryAttr = Ansys.UI.Attributes.ContextMenuEntryAttribute()
    attributes.Add(menuEntryAttr)
    defineContext = uiMgr.CreateGuiDefineContext()
    defineContext.RegisterOperation(MyCustomGuiOperation(), attributes)
    #must manually update the context menu manager by adding our new meta data to the Standard context menu
    uiMgrType = uiMgr.GetType()
    p = uiMgrType.GetProperty("GuiOperationRegistry", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
    guiOpRegistry = p.GetValue(uiMgr)
    menuMgr = uiMgr.ContextMenuManager
    menuMgrType = menuMgr.GetType()
    p = menuMgrType.GetProperty("Item", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
    args = System.Collections.Generic.List[System.Object]()
    args.Add("Standard")
    menu = p.GetValue(menuMgr, args.ToArray())
    menuType = menu.GetType()
    argTypes = System.Collections.Generic.List[System.Type]()
    argTypes.Add(clr.GetClrType(Ansys.UI.GuiOperationMetaData))
    addMethod = menuType.GetMethod("AddMenuItem", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic, None, System.Reflection.CallingConventions.HasThis, argTypes.ToArray(), None)
    args = System.Collections.Generic.List[System.Object]()
    args.Add("Invoke My Custom GuiOperation")
    guiOpRegistryType = guiOpRegistry.GetType()
    getMethod = guiOpRegistryType.GetMethod("GetMetaDataForName", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
    metaData = getMethod.Invoke(guiOpRegistry, args.ToArray())
    #The UI only sets up images at start up.  We must do it manually for our entry...
    p = uiMgrType.GetProperty("ImageLibrary", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
    imageLib = p.GetValue(uiMgr)
    image = imageLib["customEntryIcon"]
    metaDataType = metaData.GetType()
    p = metaDataType.GetProperty("Image", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
    p.SetValue(metaData, image)
    args = System.Collections.Generic.List[System.Object]()
    args.Add(metaData)
    #args.Add(System.Collections.Generic.List[System.String]())
    addMethod.Invoke(menu, args.ToArray())
def removeContextMenu(context):
    ExtAPI.Log.WriteMessage("Removing custom context menu...")
    uiMgr = Ansys.UI.UIManager.Instance
    uiMgrType = uiMgr.GetType()
    p = uiMgrType.GetProperty("GuiOperationRegistry", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
    guiOpRegistry = p.GetValue(uiMgr)
    guiOpRegistryType = guiOpRegistry.GetType()
    getMethod = guiOpRegistryType.GetMethod("GetMetaDataForName", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
    args = System.Collections.Generic.List[System.Object]()
    args.Add("Invoke My Custom GuiOperation")
    metaData = getMethod.Invoke(guiOpRegistry, args.ToArray())
    menuMgr = uiMgr.ContextMenuManager
    menuMgrType = menuMgr.GetType()
    p = menuMgrType.GetProperty("Item", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
    args = System.Collections.Generic.List[System.Object]()
    args.Add("Standard")
    menu = p.GetValue(menuMgr, args.ToArray())
    menuType = menu.GetType()
    removeMethod = menuType.GetMethod("RemoveMenuOrMenuItem", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
    args = System.Collections.Generic.List[System.Object]()
    args.Add(metaData)
    args.Add(None)
    removeMethod.Invoke(menu, args.ToArray())
    f = guiOpRegistryType.GetField("_registeredOperations", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
    registeredOps = f.GetValue(guiOpRegistry);
    registeredOps.Remove(metaData)
    f.SetValue(guiOpRegistry, registeredOps)
    f = guiOpRegistryType.GetField("_operationIndex", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
    opIndex = f.GetValue(guiOpRegistry);
    metaDataType = metaData.GetType()
    p = metaDataType.GetProperty("OpType", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
    opType = p.GetValue(metaData)
    opIndex.Remove(opType)
    f.SetValue(guiOpRegistry, opIndex)
class MyCustomGuiOperation(Ansys.UI.Interfaces.IGuiOperation):
    def Invoke(self, context):
        Ansys.UI.Toolkit.MessageBox.Show("My Custom Gui Operation Invoked!")
    def GuiItemCallBack(self, context):
        context.Visible = False
        context.Enabled = False
        selection = context.View.GetSingleUISelection[Ansys.Core.DataModel.ProjectSystem.DataContainerReference]()
        if selection != None and selection.Type.Equals("Ansys.ACT.WorkBench.Addin:ACTCustomComponentContainerType"):
            task = ACT.GetACTTaskForContainer(selection)
            context.Visible = task.Properties["ShowMenu"].Value
            context.Enabled = task.Properties["ShowMenu"].Value
