import System
import clr
clr.AddReference("Ans.ProjectSchematic")
import Ansys.ProjectSchematic 
  
def onDesignPointChange(sender, args):
    """
        Called when user sets a new design point as current
    """
    if args.ActionState == Ansys.ProjectSchematic.Events.ActionState.Completed:
        ExtAPI.Log.WriteMessage('dp changed to '+getDPName())
        if isDP0() == True:
            systems = GetAllSystems()
            for sys in systems:
                if sys.Name.Contains("CADFileBridge"):
                    container = sys.GetContainer("Geometry Bridge")
                    # retrieving file , for dm, the file has to be in a retaine dp folder(bug), in the same folder  
                    task = ACT.GetTaskForContainer(container)
                    filePath = task.Properties["GeometryFilePath"].Value 
                    fileName = filePath.Split("\\")[-1]
                    SourcePath = System.IO.Path.Combine(container.GetActiveDirectory(),"backup_"+fileName)
                    TargetPath = System.IO.Path.Combine(container.GetActiveDirectory(),fileName)
                    if System.IO.File.Exists(SourcePath) == True:
                        ExtAPI.Log.WriteMessage("restoring to dp0")
                        copyfile(SourcePath, TargetPath)
                    isRegistered = IsFileRegistered(FilePath=TargetPath)
                    if isRegistered == True:
                        geoFile = GetRegisteredFile(TargetPath)
                        #Transfer file downstreams
                        outputData = container.GetOutputData()
                        data = outputData["FEMSetup"]
                        FEMSetup = data[0]
                        FEMSetup.FEModelerFile = geoFile

def getDPName():
    """
        Method to get current design point name
    """
    currDP = Parameters.GetActiveDesignPoint()
    return "dp"+currDP.Name

def isDP0():
    name = getDPName()
    return name == "dp0"

handler = None
def init(entity):
    """
        Called on opening of WB (when extension is loaded)
    """
    checkFEMSetup()
    ExtAPI.Log.WriteMessage('init')
    global handler
    handler = System.EventHandler[Ansys.ProjectSchematic.Events.DesignPointChangedEventArgs](onDesignPointChange)
    ExtAPI.Log.WriteMessage("subscribing DP handler")
    Ansys.ProjectSchematic.Events.DesignPointEventSource.GetEventSource().DesignPointChanged += handler

def getCurrentFile(container):
    """
        Return file associated with container
    """
    outputData = container.GetOutputData()
    MyKey = outputData.Keys[0] # I know their is only one key
    data = outputData[MyKey]
    MyData = data[0]
    if MyKey == "FEMSetup":
        geoFile = MyData.FEModelerFile
    else:
        geoFile = MyData.TransferFile
    if geoFile != None:
        geoFile = GetDesignPointFile(geoFile)
    return geoFile

def cleanupGeomFile(container):
    """
        remove file from project
    """
    geomFile = getCurrentFile(container)
    geomFilePath = ""
    if geomFile != None:
        geomFilePath = geomFile.Location
        if System.IO.File.Exists(geomFilePath):
            DisassociateFileWithContainer(geomFile, container)
            UnregisterFile(geomFile, DeleteFileIfNonShared=True, BackUp=True)

def terminate(context):
    global handler
    if handler != None:
        ExtAPI.Log.WriteMessage("UNsubscribing DP handler")
        Ansys.ProjectSchematic.Events.DesignPointEventSource.GetEventSource().DesignPointChanged -= handler

import xml.etree.ElementTree as ET
def checkFEMSetup():
    softwarePath = Ansys.Utilities.ApplicationConfiguration.DefaultConfiguration.WorkbenchInstallRootDirectoryPath
    path=System.IO.Path.Combine(System.IO.Path.Combine(System.IO.Path.Combine(System.IO.Path.Combine(System.IO.Path.Combine(softwarePath,"Addins"),"ACT"),"bin"),"Win64"),"TransferTypeDirectPropertyAccessList.xml")
    f =open(path,'r')
    if f.read().Contains("FEMSetup"):
        f.close()
        return
    else:
        f.close()
        res = Ansys.UI.Toolkit.MessageBox.Show(Ansys.UI.UIManager.Instance.MainWindow.Window, 
            'The Extension has detected the first launch of this App.  Proceed with initialization?', 
            'Extension Setup', 
            Ansys.UI.Toolkit.MessageBoxType.Question, 
            Ansys.UI.Toolkit.MessageBoxButtons.YesNo)
        if res == Ansys.UI.Toolkit.DialogResult.Yes:
            tree = ET.parse(path)
            root = tree.getroot()
            elem=ET.SubElement(root,"TransferType")
            elem.text = "FEMSetup"
            tree.write(path)
            Ansys.UI.Toolkit.MessageBox.Show(Ansys.UI.UIManager.Instance.MainWindow.Window, 
            'This initialization is completed.\nIn order to use correctly the App please restart Workbench.', 
            'Workbench needs to be restarted', 
            Ansys.UI.Toolkit.MessageBoxType.Warning, 
            Ansys.UI.Toolkit.MessageBoxButtons.OK)