def updateLoad(guid, pressureValue):
    ExtAPI.Log.WriteMessage("Entered update load")
    dict = {}
    if ExtAPI.Extension.Attributes.Contains("Loads"):
        dict = ExtAPI.Extension.Attributes["Loads"]
    else:
        ExtAPI.Extension.Attributes.SetValue("Loads", dict)
    
    load = None
    if not dict.ContainsKey(guid):
        load = ExtAPI.DataModel.AnalysisList[0].AddPressure()
        dict.Add(guid, load.ObjectId)
        ExtAPI.Log.WriteMessage("created pressure load")
    else:
        load = ExtAPI.DataModel.GetObjectById(dict[guid])
    ExtAPI.Log.WriteMessage("set pressure value")
    load.Magnitude.Output.DiscreteValues=[Quantity("0 [Pa]"),Quantity(pressureValue+" [Pa]")]
def pushGenericData(task):
    cmd = ""
    sourceTask = None
    if task.Name.Contains("Model"):
        for source in task.SourceTasks:
            if source.Name.Contains("CustomLoad"):
                sourceTask = ACT.GetACTTaskForContainer(source.Container)
                break
    if sourceTask != None:
        outputData = sourceTask.OutputData["GeneralTransfer"][0]
        guid = outputData.Guids[0]
        pressureVal = sourceTask.Properties['Pressure'].Value
        task.ExecuteCommand("SendCommand", { 'Command':"ExtAPI.ExtensionManager.GetExtensionByName('"+sourceTask.Extension.Name+"').GetModule().updateLoad(\""+str(guid)+"\",\""+str(pressureVal)+"\")", 'Language':"Python" })
def update(task):
    ExtAPI.Log.WriteMessage('Updating ' + task.Name)
def customLoadClick(args):
    ExtAPI.Log.WriteMessage('Custom Load Toolbar Button Clicked')

