import System
import clr
clr.AddReference("Ans.Core")
import Ansys.Core
clr.AddReference("Ans.UI")
import Ansys.UI
clr.AddReference("Ans.UI.Toolkit")
clr.AddReference("Ans.UI.Toolkit.Base")
import Ansys.UI.Toolkit
import Ansys.UI.Toolkit.Base
import Ansys.UI.Toolkit.Drawing

def registerPropertyAction(context):
    ExtAPI.Log.WriteMessage("Registering custom property action...")
    uiMgr = Ansys.UI.UIManager.Instance
    attributes = System.Collections.Generic.List[System.Attribute]()
    attr = Ansys.UI.Attributes.GuiOperationAttribute("ShowMyCustomPropertyAction")
    attributes.Add(attr)
    defineContext = uiMgr.CreateGuiDefineContext()
    defineContext.RegisterOperation(MyCustomPropertyActionGuiOperation(), attributes)
    Ansys.UI.PropertyEditActionRegistry.RegisterAction("DesignPointSolveSettings", "RsmUserString", "ShowMyCustomPropertyAction", Ansys.UI.PropertyEditActionRegistry.ActivationMode.ByButton)
    Ansys.UI.PropertyEditActionRegistry.RegisterAction("ComponentSolveSettingsForAddin", "RsmUserString", "ShowMyCustomPropertyAction", Ansys.UI.PropertyEditActionRegistry.ActivationMode.ByButton)
class MyCustomPropertyActionGuiOperation(Ansys.UI.Interfaces.IGuiOperation):
    def Invoke(self, context):
        selection = context.View.GetSingleUISelection[Ansys.Core.DataModel.ProjectSystem.DataContainerReference]()
        if selection == None:
            uiMgr = Ansys.UI.UIManager.Instance
            workspace = uiMgr.GetActiveWorkspace()
            view = workspace.GetView("ProjectSchematic")
            selection = view.GetSingleUISelection[Ansys.Core.DataModel.ProjectSystem.DataContainerReference]()
        dialog = MyCustomPropertyDialog(selection)
        dialog.ShowDialog()
    def GuiItemCallBack(self, context):
        context.Visible = True
        context.Enabled = True
class MyCustomPropertyDialog(Ansys.UI.Toolkit.Dialog):
    mainPanel = None
    userString = None
    container = None
    def __init__(self, container):
        self.container = container
        width = 250;
        height = 100;
        self.Text = "Set Text"
        self.Width = width
        self.Height = height
        self.MaximizeBox = False
        self.MinimumSize = Ansys.UI.Toolkit.Drawing.Size(width, height)
        self.MaximumSize = Ansys.UI.Toolkit.Drawing.Size(width, height)
        self.__BuildUI()
        self.SetControl(self.mainPanel)
    def __BuildUI(self):
        self.mainPanel = Ansys.UI.Toolkit.TableLayoutPanel()
        self.mainPanel.Rows.Add(Ansys.UI.Toolkit.TableLayoutSizeType.Percent, 50)
        self.mainPanel.Rows.Add(Ansys.UI.Toolkit.TableLayoutSizeType.Percent, 50)
        self.mainPanel.Columns.Add(Ansys.UI.Toolkit.TableLayoutSizeType.Percent, 50)
        self.mainPanel.Columns.Add(Ansys.UI.Toolkit.TableLayoutSizeType.Percent, 50)
        l = Ansys.UI.Toolkit.Label("Text:")
        self.mainPanel.Controls.Add(l, 0, 0)
        self.userString = Ansys.UI.Toolkit.TextBox()
        self.mainPanel.Controls.Add(self.userString, 0, 1)
        apply = Ansys.UI.Toolkit.Button("Apply")
        apply.Click += Ansys.UI.Toolkit.EventDelegate(self.apply_Click)
        self.mainPanel.Controls.Add(apply, 1, 0)
        cancel = Ansys.UI.Toolkit.Button("Cancel")
        cancel.Click += Ansys.UI.Toolkit.EventDelegate(self.cancel_Click)
        self.mainPanel.Controls.Add(cancel, 1, 1)
    def cancel_Click(self, sender, args):
        self.Close()
    def apply_Click(self, sender, args):
        context = Ansys.Core.Commands.CurrentContext.AsQueryContext
        dataRef = None
        dataType = ''
        if self.container != None:
            dataType = "ComponentSolveSettingsForAddin"
        else:
            dataType = "DesignPointSolveSettings"
            self.container = context.Project.GetStaticContainer("Schematic")
        with context.ContainerReadLock(self.container):
                dataRef = context.Project.GetDataReferencesByType(self.container, dataType)[0]
        if dataRef != None:
            Ansys.Core.Commands.Standard.SetEntityPropertyCommand.InvokeAndWait(dataRef, "RsmUserString", self.userString.Text)
        self.Close()
