import System
import clr
clr.AddReference("Ans.UI")
import Ansys.UI
clr.AddReference("Ans.Utilities")
import Ansys.Utilities
clr.AddReference("Ans.UI.Toolkit")
clr.AddReference("Ans.UI.Toolkit.Base")
import Ansys.UI.Toolkit
import Ansys.UI.Toolkit.Base

def init(context):
    ExtAPI.Log.WriteMessage("Init Scratch Extension ...")
    uiManager = Ansys.UI.UIManager.Instance
    t = uiManager.GetType()
    p = t.GetProperty("ViewRegistry", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
    registry = p.GetValue(uiManager)
    t = registry.GetType()
    m = t.GetMethod("RegisterView", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
    args = System.Collections.Generic.List[System.Object]()
    args.Add(clr.GetClrType(CustomView))
    m.Invoke(registry, args.ToArray())
def showTab(entity):
    global _p
    ExtAPI.Log.WriteMessage("Button clicked...")
    w = Ansys.UI.UIManager.Instance.GetActiveWorkspace()
    v = w.GetView("CustomView")
    if v == None:
        builder = w.PanesBuilder
        customPane = builder.CreateCustomerPane(w, "Custom")
        customPane.AllowMinimized = False
        customPane.AllowFloating = False
        customPane.AllowDocking = False
        header = customPane.Header
        header.CloseVisible = False
        header.AuxDropDownVisible = False
        header.DropDownVisible = False
        header.PinVisible = False
        header.Active = False
        header.Enabled = False
        header.ArrangeVisible = False
        header.RestoreVisible = False
        v = CustomView("CustomView")
        addMethod = w.GetType().GetMethod("AddViewToPane", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
        argsList = System.Collections.Generic.List[System.Object]()
        argsList.Add(customPane)
        argsList.Add(v)
        addMethod.Invoke(w, argsList.ToArray())
        layout = builder.CreateNewLayout("CustomLayout", customPane)
        header.Text = ""
    Ansys.UI.Workspaces.Workspace.ActivateLayout("CustomLayout", "", "Custom Page", None)
class CustomView(Ansys.UI.Views.View):
    def __init__(self, name):
        self._mainPanel = None
        self.Initialize()
    def Initialize(self):
        if self._mainPanel == None:
            self._mainPanel = Ansys.UI.Toolkit.TableLayoutPanel()
        else:
            self._mainPanel.Controls.Clear()
            self._mainPanel.Rows.Clear()
            self._mainPanel.Columns.Clear()
        self._mainPanel.Rows.Add(Ansys.UI.Toolkit.TableLayoutSizeType.Percent, 100)
        self._mainPanel.Columns.Add(Ansys.UI.Toolkit.TableLayoutSizeType.Percent, 100)
        self._mainPanel.BackColor = Ansys.Utilities.Color(83, 83, 83)
        htmlViewer = Ansys.UI.Toolkit.HtmlViewer()
        htmlViewer.MinimumSize = self._mainPanel.Size
        htmlViewer.Html = r"<html><head><title>Custom Tab</title></head><body><center><h3>Sample HTML Viewer</h3></center></body></html>"
        self._mainPanel.Controls.Add(htmlViewer, 0, 0)
        self.Control = self._mainPanel