import System
import clr
clr.AddReference("Ans.UI")
import Ansys.UI
clr.AddReference("Ans.Utilities")
import Ansys.Utilities
clr.AddReference("Ans.UI.Toolkit")
clr.AddReference("Ans.UI.Toolkit.Base")
import Ansys.UI.Toolkit
import Ansys.UI.Toolkit.Base
clr.AddReference("Ans.ProjectSchematic")
import Ansys.ProjectSchematic

def init(context):
    ExtAPI.Log.WriteMessage("Initializing CustomTab2")
    uiManager = Ansys.UI.UIManager.Instance
    t = uiManager.GetType()
    p = t.GetProperty("ViewRegistry", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
    registry = p.GetValue(uiManager)
    t = registry.GetType()
    m = t.GetMethod("RegisterView", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
    args = System.Collections.Generic.List[System.Object]()
    args.Add(clr.GetClrType(CustomView))
    m.Invoke(registry, args.ToArray())
def update(task):
    ExtAPI.Log.WriteMessage("Updating " + task.Name)
def editTask(task):
    ExtAPI.Log.WriteMessage("editing " + task.Name)
    showTab(task)
def showTab(task):
    ExtAPI.Log.WriteMessage("creating custom tab...")
    coord = task.CellId
    tabName = coord + " : Custom Page"
    activeWorkspace = Ansys.UI.UIManager.Instance.GetActiveWorkspace()
    projectSchematicView = activeWorkspace.GetView(Ansys.ProjectSchematic.View.ProjectSchematicView.ViewName)
    pageManagerProperty = activeWorkspace.GetType().GetProperty("PageManager", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
    pageManager = pageManagerProperty.GetValue(activeWorkspace)
    if pageManager.GetLayout("CustomLayout").Name == "Components":
        builder = activeWorkspace.PanesBuilder
        customPane = builder.CreateCustomerPane(activeWorkspace, "Custom")
        customPane.MaintainSizePerSubLayout = True
        customView = activeWorkspace.GetView("CustomView")
        if customView == None:
            customView = CustomView("CustomView")
        addViewMethod = activeWorkspace.GetType().GetMethod("AddViewToPane", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
        argsList = System.Collections.Generic.List[System.Object]()
        argsList.Add(customPane)
        argsList.Add(customView)
        addViewMethod.Invoke(activeWorkspace, argsList.ToArray())
        chartPaneProperty = pageManager.GetType().GetProperty("ChartPane", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
        chartPane = chartPaneProperty.GetValue(pageManager)
        propertyPaneProperty = pageManager.GetType().GetProperty("PropertyPane", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
        propertyPane = propertyPaneProperty.GetValue(pageManager)
        outlinePaneProperty = pageManager.GetType().GetProperty("OutlinePane", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
        outlinePane = outlinePaneProperty.GetValue(pageManager)
        layout = builder.CreateNewLayout("CustomLayout", outlinePane)
        layout.Add(propertyPane, outlinePane, Ansys.UI.Toolkit.WindowManager.WindowDockLocation.Bottom, System.Single.Parse("0.25"))
        layout.Add(chartPane, outlinePane, Ansys.UI.Toolkit.WindowManager.WindowDockLocation.Bottom, System.Single.Parse("0.25"))
        layout.Add(customPane, outlinePane, Ansys.UI.Toolkit.WindowManager.WindowDockLocation.Bottom, System.Single.Parse("0.25"))
    customView = activeWorkspace.GetView("CustomView")
    customView.SetContent(tabName)
    diagramProperty = projectSchematicView.GetType().GetProperty("Diagram", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
    diagram = diagramProperty.GetValue(projectSchematicView)
    for block in diagram.Blocks:
        sysBlock = block.Tag
        if sysBlock == None:
            continue
        else:
            entityProp = sysBlock.GetType().GetProperty("Entity", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.Public)
            if entityProp == None:
                continue
            else:
                entity = entityProp.GetValue(sysBlock)
                if entity == task.TaskGroup.InternalObject:
                    for cell in block.Cells:
                        if cell.Text == "Parameters":
                            cell.Select(True)
                            break
                    break
    Ansys.UI.Workspaces.Workspace.ActivateLayout("CustomLayout", "", tabName, None)
class CustomView(Ansys.UI.Views.View, Ansys.Core.Events.IEventFilter, Ansys.Core.Events.IEventObserver):
    _mainPanel = None
    _viewer = None

    def __init__(self, name):
        self.Initialize("")

    def Initialize(self, source):
        self._mainPanel = Ansys.UI.Toolkit.TableLayoutPanel()
        self._mainPanel.SizeChanged += self._mainPanel_SizeChanged
        self._mainPanel.Rows.Add(Ansys.UI.Toolkit.TableLayoutSizeType.Percent, 100)
        self._mainPanel.Columns.Add(Ansys.UI.Toolkit.TableLayoutSizeType.Percent, 100)
        self._mainPanel.BackColor = Ansys.Utilities.Color(83, 83, 83)
        self._viewer = Ansys.UI.Toolkit.HtmlViewer()
        self._viewer.MinimumSize = self._mainPanel.Size
        title = ""
        if source == "" or source == None:
            title = "Custom Tab"
        else:
            title = source
        self._viewer.Html = r"<html><head><title>" + title + r"</title></head><body><center><h3>Sample HTML Viewer for " + title + r"</h3></center></body></html>"
        self._mainPanel.Controls.Add(self._viewer, 0, 0)
        self.Control = self._mainPanel
        Ansys.UI.UIManager.Instance.EventManager.Subscribe(self, self)
    def SetContent(self, source):
        self._viewer.Html = r"<html><head><title>" + source + r"</title></head><body><center><h3>Sample HTML Viewer for " + source + r"</h3></center></body></html>"

    def _mainPanel_SizeChanged(self, sender, args):
        ExtAPI.Log.WriteMessage("Table Layout Panel in CustomView resized:  Hieght = " + str(args.Height) + " Width = " + str(args.Width))
        
    def IsMatch(self, eventInformation):
        return eventInformation.Name == Ansys.UI.EventNames.ActiveTabContextChanged

    def Receive(self, eventInformation):
        newTab = eventInformation.Current
        if newTab.AssociatedLayout == "CustomLayout":
            tabSource = newTab.Source
            if System.String.IsNullOrEmpty(tabSource):
                tabSource = "Custom Tab"
            self.SetContent(tabSource)
