def update(task):
    activeDir = task.ActiveDirectory
    extensionDir = task.Extension.InstallDir
    exeName = "ExampleAddinExternalSolver.exe"
    solverPath = System.IO.Path.Combine(extensionDir, exeName)
    
    monitor = ExtAPI.UserInterface.ProgressMonitor
    monitor.BeginWork("Data Sqaures Solver", 3)
    monitor.WorkDetails = "Preparing solver input..."
    monitor.UpdateWork(1)
    
    #get param values
    inputValue = task.Properties["Inputs"].Properties["Input"].Value
      
    #prep i/o file paths
    
    inputFileName = "input.txt"
    outputFileName = "output.txt"
    dpInputFile = System.IO.Path.Combine(activeDir, inputFileName)
    dpOutputFile = System.IO.Path.Combine(activeDir, outputFileName)
    
    #write input file
    f = open(dpInputFile, "w")
    f.write('input='+inputValue.ToString(System.Globalization.NumberFormatInfo.InvariantInfo))
    f.close()
    
    monitor.UpdateWork(1)
    
    monitor.WorkDetails = "Executing Solver..."
    
    #run exe
    
    exitCode = ExtAPI.ProcessUtils.Start(solverPath, dpInputFile, dpOutputFile)
    if exitCode != 0:
        raise Exception ('External solver failed!')
    #read output file
    
    monitor.UpdateWork(1)
    
    monitor.WorkDetails = "Retrieving results from solver..."
    
    #read output file
    
    outputValue = None
    f = open(dpOutputFile, "r")
    currLine = f.readline()
    while currLine != "":
        valuePair = currLine.split('=')
        outputValue = System.Double.Parse(valuePair[1], System.Globalization.NumberFormatInfo.InvariantInfo)
        currLine = f.readline()
    f.close()
    
    monitor.UpdateWork(1)
    
    #set output value
    
    if outputValue == None:
        raise Exception("Error in update - no output value detected!")
    else:
        task.Properties["Outputs"].Properties["Output"].Value = outputValue
    monitor.WorkDetails = "Solve completed..."
    monitor.EndWork()

def createJobInput(task, inputFilePaths):
    ExtAPI.Log.WriteMessage('creating job input')
    inputFilePath = inputFilePaths[0]
    #get param values
    inputValue = task.Properties["Inputs"].Properties["Input"].Value
    
    #write input file
    ExtAPI.Log.WriteMessage("Writing input value ("+str(inputValue)+") to file (" + inputFilePath + ")")
    f = open(inputFilePath, "w")
    f.write('input='+inputValue.ToString(System.Globalization.NumberFormatInfo.InvariantInfo))
    f.close()
def reconnectJob(task, outputFilePaths):
    ExtAPI.Log.WriteMessage('reconnecting job')
    outputValue = None
    outputFilePath = outputFilePaths[0] #I know we only have one specified based on our definition...so work off of the first entry
    f = open(outputFilePath, "r")
    currLine = f.readline()
    while currLine != "":
        valuePair = currLine.split('=')
        outputValue = System.Double.Parse(valuePair[1], System.Globalization.NumberFormatInfo.InvariantInfo)
        currLine = f.readline()
    f.close()    
    #set output value
    ExtAPI.Log.WriteMessage("Retrieved value (" + str(outputValue) + ") from file (" + outputFilePath + ")")
    if outputValue == None:
        raise Exception("Error in update - no output value detected!")
    else:
        task.Properties["Outputs"].Properties["Output"].Value = outputValue
def getJobStatus(task, outputFiles):
    ExtAPI.Log.WriteMessage('checking job status')
    outputFilePath = outputFiles[0]
    finished = System.IO.File.Exists(outputFilePath)
    return finished
def cancelJob(task, inputFiles, outputFiles):
    ExtAPI.Log.WriteMessage('performing cancellation clean up')
def status(task):
    return None
def reset(task):
    task.Properties["Inputs"].Properties["Input"].Value = 0
    task.Properties["Outputs"].Properties["Output"].Value = 0
