import System
import clr
import sys
clr.AddReference("Ansys.ACT.Interfaces")
from Ansys.ACT.Interfaces.Mesh import *

ExtAPI = None

link = {}
link.Add(ElementTypeEnum.kHex20,{ 0:[3,1,4], 1:[0,2,5], 2:[1,3,6], 3:[2,0,7], 4:[5,0,7], 5:[1,4,6], 6:[5,7,2], 7:[6,3,4], 8:[0,1], 9:[1,2], 10:[2,3], 11:[3,0], 12:[4,5], 13:[5,6], 14:[6,7], 15:[7,4], 16:[0,4], 17:[1,5], 18:[2,6], 19:[3,7]})
link.Add(ElementTypeEnum.kHex8,{ 0:[3,1,4], 1:[0,2,5], 2:[1,3,6], 3:[2,0,7], 4:[5,0,7], 5:[1,4,6], 6:[5,7,2], 7:[6,3,4]})
link.Add(ElementTypeEnum.kPyramid13,{ 0:[3,1,4], 1:[0,2,4], 2:[1,3,4], 3:[2,0,4], 4:[0,1,2,3], 5:[0,1], 6:[1,2], 7:[2,3], 8:[3,0], 9:[0,4], 10:[1,4], 11:[2,4], 12:[3,4]})
link.Add(ElementTypeEnum.kPyramid5,{ 0:[3,1,4], 1:[0,2,4], 2:[1,3,4], 3:[2,0,4], 4:[0,1,2,3]})
link.Add(ElementTypeEnum.kQuad4, { 0:[3,1], 1:[0,2], 2:[1,3], 3:[2,0]})
link.Add(ElementTypeEnum.kQuad8, { 0:[3,1], 1:[0,2], 2:[1,3], 3:[2,0], 4:[0,1], 5:[1,2], 6:[2,3], 7:[3,0]})
link.Add(ElementTypeEnum.kTet10,{ 0:[2,1,3], 1:[0,2,3], 2:[1,0,3], 3:[0,1,2], 4:[0,1], 5:[1,2], 6:[2,0], 7:[0,3], 8:[1,3], 9:[2,3]})
link.Add(ElementTypeEnum.kTet4, { 0:[2,1,3], 1:[0,2,3], 2:[1,0,3], 3:[0,1,2]})
link.Add(ElementTypeEnum.kTri3, { 0:[2,1], 1:[0,2], 2:[1,0]})
link.Add(ElementTypeEnum.kTri6, { 0:[2,1], 1:[0,2], 2:[1,0], 3:[0,1], 4:[1,2], 5:[2,3]})
link.Add(ElementTypeEnum.kWedge15,{ 0:[2,1,3], 1:[0,2,4], 2:[1,0,5], 3:[5,4,0], 4:[3,5,1], 5:[4,3,2], 6:[0,1], 7:[1,2], 8:[2,0], 9:[3,4], 10:[4,5], 11:[5,3], 12:[0,3], 13:[1,4], 14:[2,5]})
link.Add(ElementTypeEnum.kWedge6,{ 0:[2,1,3], 1:[0,2,4], 2:[1,0,5], 3:[5,4,0], 4:[3,5,1], 5:[4,3,2]})

class SolverEngine:
    def __init__(self,mesh,initValues,allowedNodes):
        self.initValues = initValues
        self.mesh = mesh
        self.allowedNodes = allowedNodes

    def Run(self,maxIter,f,steps,solbystep,fct,pctmin,pctmax):
        mesh = self.mesh
        initValues = self.initValues
        allowedNodes = self.allowedNodes
        numNodes = mesh.NodeCount
        previousValues = initValues.copy()
        currentValues = initValues.copy()
        steps.Add(1.*steps.Count)
        ExtAPI.Log.WriteMessage('---------- Add step #{0}'.format(steps.Count))
        solbystep.Add(steps.Count,currentValues.copy());
        cont = True
        iter = 0
        f.write("\nSolve on %d nodes.\n" % (allowedNodes.Count))
        fct(pctmin,"")
        if maxIter==0:
            return currentValues
        while cont:
            diff = 0.
            sum = 0.
            currentValues = initValues.copy()
            newIds = initValues.Keys
            while newIds.Count>0:
                elems = mesh.ElementIdsFromNodeIds(newIds)
                nodes = mesh.NodeIdsFromElementIds(elems)
                previousIds = newIds
                newIds = []
                for idall in nodes:
                    if currentValues.Contains(idall):
                        continue
                    if not allowedNodes.Contains(idall):
                        continue
                    elems = mesh.NodeById(idall).ConnectedElementIds
                    ilist = []
                    for ie in elems:
                        el = mesh.ElementById(ie)
                        ntmp = el.NodeIds
                        nn = ntmp.Count
                        for itmp in range(ntmp.Count):
                            if ntmp[itmp]==idall:
                                itoadd = link[el.Type][itmp]
                                for ii in itoadd:
                                    if not ilist.Contains(ntmp[ii]):
                                        ilist.Add(ntmp[ii])
                                break
                    nids = ilist
                    val = 0.
                    num = 0
                    for id in nids:
                        if id==idall:
                            continue
                        if previousValues.Contains(id):
                            val = val + previousValues[id]
                            num = num + 1
                    if num>0:
                        val = val/num
                        currentValues.Add(idall,val)
                        sum = sum + abs(val)
                        if previousValues.Contains(idall):
                            diff = diff + abs(val-previousValues[idall])
                        else:
                            diff = diff + abs(val)
                        newIds.Add(idall)
            previousValues = currentValues.copy()
            dtime = 1.*steps.Count
            steps.Add(dtime)
            ExtAPI.Log.WriteMessage('---------- Add step #{0}'.format(steps.Count))
            solbystep.Add(steps.Count,currentValues.copy());
            iter = iter+1
            pct = iter*(pctmax-pctmin)/maxIter+pctmin
            c = fct(pct,"")
            if iter>=maxIter:
                cont = False
            err = diff/sum if sum != 0.0 else diff
            if err<1.e-4:
                cont = False
            f.write("Iteration %3d: %d nodes computed.\n    err = %g\n" % (iter,currentValues.Count,err))
            if c:
                cont = False
        fct(pctmax,"")
        return currentValues    
