import System
import clr
clr.AddReference("Ans.Core")
import Ansys.Core
clr.AddReference("Ans.UI")
import Ansys.UI
clr.AddReference("Ans.ProjectSchematic")
import Ansys.ProjectSchematic
clr.AddReference("Ans.UI.Toolkit")
clr.AddReference("Ans.UI.Toolkit.Base")
import Ansys.UI.Toolkit

opNames = []
def update(task):
    ExtAPI.Log.WriteMessage("Updating task " + task.Name)
def createContextMenu(context):
    ExtAPI.Log.WriteMessage("Registering custom context menus...")
    uiMgr = Ansys.UI.UIManager.Instance
    attributes = System.Collections.Generic.List[System.Attribute]()
    guiOpAttr = Ansys.UI.Attributes.GuiOperationAttribute("Invoke My Custom GuiOperation")
    guiOpAttr.ImageName = "customEntryIcon"
    attributes.Add(guiOpAttr)
    visOptions = Ansys.UI.Attributes.AttributeOptions.InitialVisibilityOff | Ansys.UI.Attributes.AttributeOptions.InitialEnablingOff | Ansys.UI.Attributes.AttributeOptions.UseCallback
    visAttr = Ansys.UI.Attributes.VisibilityAttribute(visOptions)
    attributes.Add(visAttr)
    menuEntryAttr = Ansys.UI.Attributes.ContextMenuEntryAttribute()
    attributes.Add(menuEntryAttr)
    defineContext = uiMgr.CreateGuiDefineContext()
    defineContext.RegisterOperation(MyCustomGuiOperation(), attributes)
    menuMgr = uiMgr.ContextMenuManager
    global opNames
    for i in range(0,10):
        opName = str(i)
        opNames.append(opName)
        guiOp = MyCustomGuiOperation()
        guiOp.SetData(i)
        menuMgr.AddDynamicEntity(None, Ansys.UI.MenuEntityType.MenuEntry, opName, False, None, None, System.Single.Parse('1.0'), None, guiOp, True, False, Ansys.UI.OpClass.None, False, True, True)
def removeContextMenu(context):
    ExtAPI.Log.WriteMessage("Removing custom context menus...")
    uiMgr = Ansys.UI.UIManager.Instance
    uiMgrType = uiMgr.GetType()
    menuMgr = uiMgr.ContextMenuManager
    global opNames
    for opName in opNames:
        menuMgr.RemoveDynamicEntity(opName)
    opNames = []
class MyCustomGuiOperation(Ansys.UI.Interfaces.IGuiOperation):
    data = ""
    def SetData(self, data):
        self.data = data
    def Invoke(self, context):
        Ansys.UI.Toolkit.MessageBox.Show("Data = " + str(self.data))
    def GuiItemCallBack(self, context):
        context.Visible = False
        context.Enabled = False
        selection = context.View.GetSingleUISelection[Ansys.Core.DataModel.ProjectSystem.DataContainerReference]()
        if selection != None and selection.Type.Equals("Ansys.ACT.WorkBench.Addin:ACTCustomComponentContainerType"):
            task = ACT.GetACTTaskForContainer(selection)
            context.Visible = task.Properties["ShowMenu"].Value
            context.Enabled = task.Properties["ShowMenu"].Value
