import System
import clr
clr.AddReference("Ansys.ACT.WorkBench")
import Ansys.ACT.WorkBench
clr.AddReference("Ans.Utilities")
import Ansys.Utilities
clr.AddReference("Ans.UI.Toolkit")
clr.AddReference("Ans.UI.Toolkit.Base")
from Ansys.UI.Toolkit import *
from Ansys.UI.Toolkit.Base import *
from Ansys.UI.Toolkit.Drawing import *
clr.AddReference("Ans.Core")
import Ansys.Core

def update(task):
    ExtAPI.Log.WriteMessage("Updating " + task.Name)
def reset(task):
    ExtAPI.Log.WriteMessage("Resetting " + task.Name)
    container = task.InternalObject
    for parameterRef in container.GetAllParameters():
        entityPropsDict = parameterRef.GetAssociatedEntityProperties(Container=container)
        for dataRef in entityPropsDict:
            properties = entityPropsDict[dataRef]
            for propertyName in properties:
                parameterRef.Disassociate(dataRef, propertyName)
        parameterRef.Delete()
    context = ExtAPI.DataModel.Context
    installPath = Ansys.Utilities.ApplicationConfiguration.DefaultConfiguration.AwpRootEnvironmentVariableValue
    platform = Ansys.Utilities.ApplicationConfiguration.DefaultConfiguration.Platform
    assmPath = System.IO.Path.Combine(installPath, System.IO.Path.Combine("Addins", System.IO.Path.Combine("ACT", System.IO.Path.Combine("bin", System.IO.Path.Combine(platform, "Ansys.ACT.WorkBench.dll")))))
    assm = System.Reflection.Assembly.LoadFrom(assmPath)
    utilitiesType = assm.GetType("Ansys.ACT.WorkBench.Schematic.Utilities")
    field = utilitiesType.GetField("ContainerKey", System.Reflection.BindingFlags.NonPublic | System.Reflection.BindingFlags.Static)
    key = field.GetValue(None)
    containerObj = context.Project.GetContainerObject(container, key)
    dataObjects = []
    for object in containerObj.GetDataObjectsByType("ParameterAdapter"):
        dataObjects.append(object)
    lock = context.ContainerWriteLock(container)
    containerObj.DeleteDataObjects(dataObjects)
    lock.Dispose()
def delete(task):
    ExtAPI.Log.WriteMessage("Deleting " + task.Name)
    container = task.InternalObject
    for parameterRef in container.GetAllParameters():
        entityPropsDict = parameterRef.GetAssociatedEntityProperties(Container=container)
        for dataRef in entityPropsDict:
            properties = entityPropsDict[dataRef]
            for propertyName in properties:
                parameterRef.Disassociate(dataRef, propertyName)
        parameterRef.Delete()
def createInputParameter(task):
    ExtAPI.Log.WriteMessage("Creating input parameter for " + task.Name)
    d = AddTaskParameterDialog(False)
    d.StartLocation = Dialog.DialogStartLocation.CenterParent
    res = d.ShowDialog()
    name = d.ParameterName
    type = d.ParameterType
    value = d.ParameterValue
    ExtAPI.Log.WriteMessage("Information Received:  Name = " + name + ", Type = " + type + ", Value = " + value)
    context = ExtAPI.DataModel.Context
    container = task.InternalObject
    installPath = Ansys.Utilities.ApplicationConfiguration.DefaultConfiguration.AwpRootEnvironmentVariableValue
    platform = Ansys.Utilities.ApplicationConfiguration.DefaultConfiguration.Platform
    assmPath = System.IO.Path.Combine(installPath, System.IO.Path.Combine("Addins", System.IO.Path.Combine("ACT", System.IO.Path.Combine("bin", System.IO.Path.Combine(platform, "Ansys.ACT.WorkBench.dll")))))
    assm = System.Reflection.Assembly.LoadFrom(assmPath)
    utilitiesType = assm.GetType("Ansys.ACT.WorkBench.Schematic.Utilities")
    field = utilitiesType.GetField("ContainerKey", System.Reflection.BindingFlags.NonPublic | System.Reflection.BindingFlags.Static)
    key = field.GetValue(None)
    containerObject = context.Project.GetContainerObject(container, key)
    pType = None
    if type == "Integer":
        pType = clr.GetClrType(System.Int32)
    elif type == "Float":
        pType = clr.GetClrType(System.Float)
    else:
        pType = clr.GetClrType(Ansys.Core.Units.Quantity)
    spec = Ansys.Core.DataModel.DataObjects.ParameterAdapterTypeSpec(pType, containerObject)
    spec.DefineAdapterProperty("ParameterName", Ansys.Core.DataSpecs.StringSpec())
    spec.DefineAdapterProperty("IsOutput", Ansys.Core.DataSpecs.BooleanSpec())
    parameterSourceObject = Ansys.Core.DataModel.DataObjects.DynamicDataObject(spec)
    parameterSourceObject.SetProperty("ParameterName", name)
    parameterSourceObject.SetProperty("IsOutput", False)
    containerObject.AddDataObject(parameterSourceObject)
    paramName = container.Name + "::" + name
    if value == None:
        value = string.Empty
    else:
        value = value.ToString()
    Parameters.CreateParameter(Entity=parameterSourceObject.GetDataReference(), PropertyName="Value", IsOutput=False, IsDirectOutput=False, Expression=value, DisplayText=paramName)
def createOutputParameter(task):
    ExtAPI.Log.WriteMessage("Creating output parameter for " + task.Name)
    d = AddTaskParameterDialog(True)
    d.StartLocation = Dialog.DialogStartLocation.CenterParent
    res = d.ShowDialog()
    name = d.ParameterName
    type = d.ParameterType
    ExtAPI.Log.WriteMessage("Information Received:  Name = " + name + ", Type = " + type)
    context = ExtAPI.DataModel.Context
    container = task.InternalObject
    installPath = Ansys.Utilities.ApplicationConfiguration.DefaultConfiguration.AwpRootEnvironmentVariableValue
    platform = Ansys.Utilities.ApplicationConfiguration.DefaultConfiguration.Platform
    assmPath = System.IO.Path.Combine(installPath, System.IO.Path.Combine("Addins", System.IO.Path.Combine("ACT", System.IO.Path.Combine("bin", System.IO.Path.Combine(platform, "Ansys.ACT.WorkBench.dll")))))
    assm = System.Reflection.Assembly.LoadFrom(assmPath)
    utilitiesType = assm.GetType("Ansys.ACT.WorkBench.Schematic.Utilities")
    field = utilitiesType.GetField("ContainerKey", System.Reflection.BindingFlags.NonPublic | System.Reflection.BindingFlags.Static)
    key = field.GetValue(None)
    containerObject = context.Project.GetContainerObject(container, key)
    pType = None
    if type == "Integer":
        pType = clr.GetClrType(System.Int32)
    elif type == "Float":
        pType = clr.GetClrType(System.Float)
    else:
        pType = clr.GetClrType(Ansys.Core.Units.Quantity)
    spec = Ansys.Core.DataModel.DataObjects.ParameterAdapterTypeSpec(pType, containerObject)
    spec.DefineAdapterProperty("ParameterName", Ansys.Core.DataSpecs.StringSpec())
    spec.DefineAdapterProperty("IsOutput", Ansys.Core.DataSpecs.BooleanSpec())
    parameterSourceObject = Ansys.Core.DataModel.DataObjects.DynamicDataObject(spec)
    parameterSourceObject.SetProperty("ParameterName", name)
    parameterSourceObject.SetProperty("IsOutput", True)
    containerObject.AddDataObject(parameterSourceObject)
    paramName = container.Name + "::" + name
    Parameters.CreateParameter(Entity=parameterSourceObject.GetDataReference(), PropertyName="Value", IsOutput=True, IsDirectOutput=True, Expression="", DisplayText=paramName)
class AddTaskParameterDialog(Dialog):
    _mainPanel = None
    _nameBox = None
    _valueBox = None
    _typeBox = None
    _isOutput = False
    ParameterName=None
    ParameterType=None
    ParameterValue=None
    def __init__(self, isOutput):
        self._isOutput = isOutput
        self.Initialize()
        self.DialogResult = DialogResult.None;
        text = ""
        if self._isOutput:
            text = "Add an output parameter..."
        else:
            text = "Add an input parameter..."
        self.Text = text
        self.MinimumSize = self.MaximumSize = Size(320, 260)
    def Initialize(self):
        self._mainPanel = TableLayoutPanel()
        self._mainPanel.Rows.Add(TableLayoutSizeType.Absolute, 30)
        self._mainPanel.Rows.Add(TableLayoutSizeType.Absolute, 30)
        self._mainPanel.Rows.Add(TableLayoutSizeType.Absolute, 30)
        self._mainPanel.Rows.Add(TableLayoutSizeType.Absolute, 30)
        self._mainPanel.Rows.Add(TableLayoutSizeType.Absolute, 30)
        self._mainPanel.Rows.Add(TableLayoutSizeType.Absolute, 30)
        self._mainPanel.Rows.Add(TableLayoutSizeType.Absolute, 30)
        self._mainPanel.Columns.Add(TableLayoutSizeType.Absolute, 100)
        self._mainPanel.Columns.Add(TableLayoutSizeType.Absolute, 200)
        
        headerText = ""
        if self._isOutput:
            headerText = "New Output Parameter:"
        else:
            headerText = "New Input Parameter:"
        header = Label(headerText)
        header.Font = Font(header.Font.FamilyName, float(12.0), FontStyle.Bold)
        self._mainPanel.Controls.Add(header, 0, 0, 1, 2)
        
        nameLabel = Label("Name:")
        self._mainPanel.Controls.Add(nameLabel, 1, 0, 1, 1)
        
        self._nameBox = TextBox()
        self._mainPanel.Controls.Add(self._nameBox, 1, 1, 1, 1)
        
        typeLabel = Label("Type:")
        self._mainPanel.Controls.Add(typeLabel, 2, 0, 1, 1)
        
        self._typeBox = ComboBox()
        self._typeBox.AddItem("Integer")
        self._typeBox.AddItem("Float")
        self._typeBox.AddItem("Quantity")
        self._mainPanel.Controls.Add(self._typeBox, 2, 1, 1, 1)
        
        valueLabel = Label("Initial Value:")
        self._mainPanel.Controls.Add(valueLabel, 5, 0, 1, 1)
        
        self._valueBox = TextBox()
        self._valueBox.Enabled = self._isOutput == False
        self._mainPanel.Controls.Add(self._valueBox, 5, 1, 1, 1)
        
        addButton = Button("Add")
        addButton.Click += EventDelegate(self.AddButton_Click)
        self._mainPanel.Controls.Add(addButton, 6, 0, 1, 2)
        self.SetControl(self._mainPanel)
    def AddButton_Click(self, sender, args):
        self.ParameterName = self._nameBox.Text
        self.ParameterType = self._typeBox.Text
        self.ParameterValue = self._valueBox.Text
        self.DialogResult = DialogResult.OK
        self.Close()
