﻿import System
import clr
clr.AddReference("Ans.UI")
import Ansys.UI
clr.AddReference("Ans.Utilities")
import Ansys.Utilities
clr.AddReference("EmbeddedEXE")
import EmbeddedEXE
clr.AddReference("Ans.UI.Toolkit")
clr.AddReference("Ans.UI.Toolkit.Base")
import Ansys.UI.Toolkit
import Ansys.UI.Toolkit.Base

_p = None
def init(context):
    ExtAPI.Log.WriteMessage("Init Scratch Extension ...")
    uiManager = Ansys.UI.UIManager.Instance
    uiManager.UIEventSource.ApplicationAboutToExit += System.EventHandler[System.EventArgs](appExiting)
    t = uiManager.GetType()
    p = t.GetProperty("ViewRegistry", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
    registry = p.GetValue(uiManager)
    t = registry.GetType()
    m = t.GetMethod("RegisterView", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
    args = System.Collections.Generic.List[System.Object]()
    args.Add(clr.GetClrType(CustomView))
    m.Invoke(registry, args.ToArray())
def appExiting(sender, args):
    ExtAPI.Log.WriteMessage("Exiting...")
def showViewer(entity):
    global _p
    ExtAPI.Log.WriteMessage("Button clicked...")
    w = Ansys.UI.UIManager.Instance.GetActiveWorkspace()
    v = w.GetView("CustomView")
    if v == None:
        builder = w.PanesBuilder
        customPane = builder.CreateCustomerPane(w, "Custom")
        customPane.AllowMinimized = False
        customPane.AllowFloating = False
        customPane.AllowDocking = False
        header = customPane.Header
        header.CloseVisible = False
        header.AuxDropDownVisible = False
        header.DropDownVisible = False
        header.PinVisible = False
        header.Active = False
        header.Enabled = False
        header.ArrangeVisible = False
        header.RestoreVisible = False
        v = CustomView("CustomView")
        addMethod = w.GetType().GetMethod("AddViewToPane", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
        argsList = System.Collections.Generic.List[System.Object]()
        argsList.Add(customPane)
        argsList.Add(v)
        addMethod.Invoke(w, argsList.ToArray())
        layout = builder.CreateNewLayout("CustomLayout", customPane)
        header.Text = ""
    Ansys.UI.Workspaces.Workspace.ActivateLayout("CustomLayout", "", "Custom Page", None)
    #now spawn the exe
    ansysInstallRoot = Ansys.Utilities.ApplicationConfiguration.DefaultConfiguration.AwpRootEnvironmentVariableValue
    ansysViewerExe = "ANSYSViewer.exe"
    ansysViewerInstallPath = System.IO.Path.Combine(ansysInstallRoot, System.IO.Path.Combine("ANSYSViewer", ansysViewerExe))
    if _p == None:
        info = System.Diagnostics.ProcessStartInfo(ansysViewerInstallPath)
        info.WindowStyle = System.Diagnostics.ProcessWindowStyle.Minimized
        info.UseShellExecute = False
        _p = System.Diagnostics.Process.Start(info)
        _p.EnableRaisingEvents = True
        _p.Exited += System.EventHandler(_pExited)
        #sleep for 20 seconds.
        System.Threading.Thread.Sleep(20000)
    EmbeddedEXE.WindowUtilities.SetParent(_p.MainWindowHandle, v.Control.Handle)
    EmbeddedEXE.WindowUtilities.ShowWindow(_p.MainWindowHandle, 3)
def _pExited(sender, args):
    global _p
    _p = None
class CustomView(Ansys.UI.Views.View):
    def __init__(self, name):
        self._mainPanel = None
        self.Initialize()
    def Initialize(self):
        if self._mainPanel == None:
            self._mainPanel = Ansys.UI.Toolkit.TableLayoutPanel()
        else:
            self._mainPanel.Controls.Clear()
            self._mainPanel.Rows.Clear()
            self._mainPanel.Columns.Clear()
        self._mainPanel.Rows.Add(Ansys.UI.Toolkit.TableLayoutSizeType.Percent, 100)
        self._mainPanel.Columns.Add(Ansys.UI.Toolkit.TableLayoutSizeType.Percent, 100)
        self._mainPanel.BackColor = Ansys.Utilities.Color(83, 83, 83)
        self.Control = self._mainPanel