import System
import clr
clr.AddReference('Ans.Core')
import Ansys.Core
clr.AddReference('Ans.UI')
import Ansys.UI

saveEventHandler = None
exitEventHandler = None
def init(context):
    global saveEventHandler
    global exitEventHandler
    ExtAPI.Log.WriteMessage("Starting Events App...")
    context = ExtAPI.DataModel.Context
    saveEventHandler = System.EventHandler[Ansys.Core.Persistence.PersistenceActionsEventArgs](saveHandler)
    context.Project.EventSource.PersistenceStateChangeRequested += saveEventHandler
    if Ansys.UI.UIManager.IsRunningInteractively:
        exitEventHandler = System.EventHandler[System.EventArgs](exitHandler)
        Ansys.UI.UIManager.Instance.UIEventSource.ApplicationAboutToExit += exitEventHandler
def saveHandler(sender, args):
    if args.Action == Ansys.Core.Persistence.PersistenceActions.Save:
        ExtAPI.Log.WriteMessage("Project Save detected by Events App")
def exitHandler(sender, args):
    ExtAPI.Log.WriteMessage("Application exit detected by Events App")
def terminate(context):
    global saveEventHandler
    global exitEventHandler
    ExtAPI.Log.WriteMessage("Terminating Events App...")
    if saveEventHandler != None:
        context = ExtAPI.DataModel.Context
        context.Project.EventSource.PersistenceStateChanged -= saveEventHandler
    if exitEventHandler != None:
        if Ansys.UI.UIManager.IsRunningInteractively:
            Ansys.UI.UIManager.Instance.UIEventSource.ApplicationAboutToExit -= exitEventHandler
