import System
from System.Xml import *
import clr
clr.AddReference("Ans.Core")
import Ansys.Core
def update(task):
    ExtAPI.Log.WriteMessage("Updating " + task.Name)
    cleanup(task)
    workingDir = task.ActiveDirectory
    loadConfigFilePath = System.IO.Path.Combine(workingDir, "load_data_configuration.xml")
    strainFiles = GenerateStrainDataFiles(task, workingDir)
    configFile = GenerateExternalDataLoadConfigFile(task, loadConfigFilePath)
    setup = task.OutputData["ExternalDataSetup"][0]
    setup.TransferFile = configFile
    generatedFileRefs = System.Collections.Generic.List[Ansys.Core.DataModel.DataReference]()
    generatedFileRefs.AddRange(strainFiles)
    setup.InputFiles = generatedFileRefs
def cleanup(task):
    for existingFile in System.IO.Directory.GetFiles(task.ActiveDirectory):
        task.UnregisterFile(existingFile, True)
def reset(task):
    cleanup(task)
def GenerateExternalDataLoadConfigFile(task, filePath):
    document = XmlDocument()
    processingInstruction = document.CreateProcessingInstruction("xml", "version=\"1.0\"")
    document.AppendChild(processingInstruction)
    element = document.CreateElement("ExternalLoadData")
    element.SetAttribute("CurrentVersion", "1")
    fileData1 = document.CreateElement("FilesData")
    fileData1.SetAttribute("Count", "6")
    #add info about the custom results data files
    fileData2 = document.CreateElement("FileData")
    fileDataProperty = document.CreateElement("FileDataProperty")
    columnsData = document.CreateElement("ColumnsData")
    columnNotUsed = document.CreateElement("ColumnData")
    columnDataX = document.CreateElement("ColumnData")
    columnDataY = document.CreateElement("ColumnData")
    columnDataZ = document.CreateElement("ColumnData")
    columnStrain = document.CreateElement("ColumnData")
    #Res X
    fileData2 = document.CreateElement("FileData")
    fileData2.SetAttribute("CurrentVersion", "2")
    fileData2.SetAttribute("Description", "Custom Strain X")
    fileData2.SetAttribute("Master", "True")
    fileData2.SetAttribute("Location", "StrainX.txt")
    fileDataProperty = document.CreateElement("FileDataProperty")
    fileDataProperty.SetAttribute("CurrentVersion", "4")
    fileDataProperty.SetAttribute("FileIdentifier", "File1")
    fileDataProperty.SetAttribute("Dimensions", "3D")
    fileDataProperty.SetAttribute("StartImportAtLine", "2")
    fileDataProperty.SetAttribute("FormatType", "Delimited")
    fileDataProperty.SetAttribute("FormatString", "")
    fileDataProperty.SetAttribute("DelimiterType", "Tab")
    fileDataProperty.SetAttribute("DelimiterCharacter", "\\t")
    fileDataProperty.SetAttribute("SectionName", "")
    fileDataProperty.SetAttribute("LengthUnit", "m")
    fileDataProperty.SetAttribute("CoordinateSystemType", "Cartesian")
    fileDataProperty.SetAttribute("OriginX", "0")
    fileDataProperty.SetAttribute("OriginXUnit", "m")
    fileDataProperty.SetAttribute("OriginY", "0")
    fileDataProperty.SetAttribute("OriginYUnit", "m")
    fileDataProperty.SetAttribute("OriginZ", "0")
    fileDataProperty.SetAttribute("OriginZUnit", "m")
    fileDataProperty.SetAttribute("ThetaXY", "0")
    fileDataProperty.SetAttribute("ThetaXYUnit", "radian")
    fileDataProperty.SetAttribute("ThetaYZ", "0")
    fileDataProperty.SetAttribute("ThetaYZUnit", "radian")
    fileDataProperty.SetAttribute("ThetaZX", "0")
    fileDataProperty.SetAttribute("ThetaZXUnit", "radian")
    fileDataProperty.SetAttribute("MorphX", "x")
    fileDataProperty.SetAttribute("MorphY", "y")
    fileDataProperty.SetAttribute("MorphZ", "z")
    fileDataProperty.SetAttribute("ConversionOption", "NoConversion")
    columnsData = document.CreateElement("ColumnsData")
    columnsData.SetAttribute("Count", "5")
    columnNotUsed = document.CreateElement("ColumnData")
    columnNotUsed.SetAttribute("CurrentVersion", "2")
    columnNotUsed.SetAttribute("DataType", "Not Used")
    columnNotUsed.SetAttribute("Unit", "")
    columnNotUsed.SetAttribute("Identifier", "")
    columnNotUsed.SetAttribute("QuantityType", "")
    columnDataX = document.CreateElement("ColumnData")
    columnDataX.SetAttribute("CurrentVersion", "2")
    columnDataX.SetAttribute("DataType", "X Coordinate")
    columnDataX.SetAttribute("Unit", "m")
    columnDataX.SetAttribute("Identifier", "")
    columnNotUsed.SetAttribute("QuantityType", "Length")
    columnDataY = document.CreateElement("ColumnData")
    columnDataY.SetAttribute("CurrentVersion", "2")
    columnDataY.SetAttribute("DataType", "Y Coordinate")
    columnDataY.SetAttribute("Unit", "m")
    columnDataY.SetAttribute("Identifier", "")
    columnNotUsed.SetAttribute("QuantityType", "Length")
    columnDataZ = document.CreateElement("ColumnData")
    columnDataZ.SetAttribute("CurrentVersion", "2")
    columnDataZ.SetAttribute("DataType", "Z Coordinate")
    columnDataZ.SetAttribute("Unit", "m")
    columnDataZ.SetAttribute("Identifier", "")
    columnNotUsed.SetAttribute("QuantityType", "Length")
    columnStrain = document.CreateElement("ColumnData")
    columnStrain.SetAttribute("CurrentVersion", "2")
    columnStrain.SetAttribute("DataType", "Strain")
    columnStrain.SetAttribute("Unit", "m m^-1")
    columnStrain.SetAttribute("Identifier", "XX")
    columnNotUsed.SetAttribute("QuantityType", "Strain")
    columnsData.AppendChild(columnNotUsed)
    columnsData.AppendChild(columnDataX)
    columnsData.AppendChild(columnDataY)
    columnsData.AppendChild(columnDataZ)
    columnsData.AppendChild(columnStrain)
    fileDataProperty.AppendChild(columnsData)
    fileData2.AppendChild(fileDataProperty)
    fileData1.AppendChild(fileData2)
    #Res XY
    fileData2 = document.CreateElement("FileData")
    fileData2.SetAttribute("CurrentVersion", "2")
    fileData2.SetAttribute("Description", "Custom Strain XY")
    fileData2.SetAttribute("Master", "False")
    fileData2.SetAttribute("Location", "StrainXY.txt")
    fileDataProperty = document.CreateElement("FileDataProperty")
    fileDataProperty.SetAttribute("CurrentVersion", "4")
    fileDataProperty.SetAttribute("FileIdentifier", "File2")
    fileDataProperty.SetAttribute("Dimensions", "3D")
    fileDataProperty.SetAttribute("StartImportAtLine", "2")
    fileDataProperty.SetAttribute("FormatType", "Delimited")
    fileDataProperty.SetAttribute("FormatString", "")
    fileDataProperty.SetAttribute("DelimiterType", "Tab")
    fileDataProperty.SetAttribute("DelimiterCharacter", "\\t")
    fileDataProperty.SetAttribute("SectionName", "")
    fileDataProperty.SetAttribute("LengthUnit", "m")
    fileDataProperty.SetAttribute("CoordinateSystemType", "Cartesian")
    fileDataProperty.SetAttribute("OriginX", "0")
    fileDataProperty.SetAttribute("OriginXUnit", "m")
    fileDataProperty.SetAttribute("OriginY", "0")
    fileDataProperty.SetAttribute("OriginYUnit", "m")
    fileDataProperty.SetAttribute("OriginZ", "0")
    fileDataProperty.SetAttribute("OriginZUnit", "m")
    fileDataProperty.SetAttribute("ThetaXY", "0")
    fileDataProperty.SetAttribute("ThetaXYUnit", "radian")
    fileDataProperty.SetAttribute("ThetaYZ", "0")
    fileDataProperty.SetAttribute("ThetaYZUnit", "radian")
    fileDataProperty.SetAttribute("ThetaZX", "0")
    fileDataProperty.SetAttribute("ThetaZXUnit", "radian")
    fileDataProperty.SetAttribute("MorphX", "x")
    fileDataProperty.SetAttribute("MorphY", "y")
    fileDataProperty.SetAttribute("MorphZ", "z")
    fileDataProperty.SetAttribute("ConversionOption", "NoConversion")
    columnsData = document.CreateElement("ColumnsData")
    columnsData.SetAttribute("Count", "5")
    columnNotUsed = document.CreateElement("ColumnData")
    columnNotUsed = document.CreateElement("ColumnData")
    columnNotUsed.SetAttribute("CurrentVersion", "2")
    columnNotUsed.SetAttribute("DataType", "Not Used")
    columnNotUsed.SetAttribute("Unit", "")
    columnNotUsed.SetAttribute("Identifier", "")
    columnNotUsed.SetAttribute("QuantityType", "")
    columnDataX = document.CreateElement("ColumnData")
    columnDataX.SetAttribute("CurrentVersion", "2")
    columnDataX.SetAttribute("DataType", "X Coordinate")
    columnDataX.SetAttribute("Unit", "m")
    columnDataX.SetAttribute("Identifier", "")
    columnNotUsed.SetAttribute("QuantityType", "Length")
    columnDataY = document.CreateElement("ColumnData")
    columnDataY.SetAttribute("CurrentVersion", "2")
    columnDataY.SetAttribute("DataType", "Y Coordinate")
    columnDataY.SetAttribute("Unit", "m")
    columnDataY.SetAttribute("Identifier", "")
    columnNotUsed.SetAttribute("QuantityType", "Length")
    columnDataZ = document.CreateElement("ColumnData")
    columnDataZ.SetAttribute("CurrentVersion", "2")
    columnDataZ.SetAttribute("DataType", "Z Coordinate")
    columnDataZ.SetAttribute("Unit", "m")
    columnDataZ.SetAttribute("Identifier", "")
    columnNotUsed.SetAttribute("QuantityType", "Length")
    columnStrain = document.CreateElement("ColumnData")
    columnStrain = document.CreateElement("ColumnData")
    columnStrain.SetAttribute("CurrentVersion", "2")
    columnStrain.SetAttribute("DataType", "Strain")
    columnStrain.SetAttribute("Unit", "m m^-1")
    columnStrain.SetAttribute("Identifier", "XY")
    columnNotUsed.SetAttribute("QuantityType", "Strain")
    columnsData.AppendChild(columnNotUsed)
    columnsData.AppendChild(columnDataX)
    columnsData.AppendChild(columnDataY)
    columnsData.AppendChild(columnDataZ)
    columnsData.AppendChild(columnStrain)
    fileDataProperty.AppendChild(columnsData)
    fileData2.AppendChild(fileDataProperty)
    fileData1.AppendChild(fileData2)
    #Res XZ
    fileData2 = document.CreateElement("FileData")
    fileData2.SetAttribute("CurrentVersion", "2")
    fileData2.SetAttribute("Description", "Custom Strain XZ")
    fileData2.SetAttribute("Master", "False")
    fileData2.SetAttribute("Location", "StrainXZ.txt")
    fileDataProperty = document.CreateElement("FileDataProperty")
    fileDataProperty.SetAttribute("CurrentVersion", "4")
    fileDataProperty.SetAttribute("FileIdentifier", "File3")
    fileDataProperty.SetAttribute("Dimensions", "3D")
    fileDataProperty.SetAttribute("StartImportAtLine", "2")
    fileDataProperty.SetAttribute("FormatType", "Delimited")
    fileDataProperty.SetAttribute("FormatString", "")
    fileDataProperty.SetAttribute("DelimiterType", "Tab")
    fileDataProperty.SetAttribute("DelimiterCharacter", "\\t")
    fileDataProperty.SetAttribute("SectionName", "")
    fileDataProperty.SetAttribute("LengthUnit", "m")
    fileDataProperty.SetAttribute("CoordinateSystemType", "Cartesian")
    fileDataProperty.SetAttribute("OriginX", "0")
    fileDataProperty.SetAttribute("OriginXUnit", "m")
    fileDataProperty.SetAttribute("OriginY", "0")
    fileDataProperty.SetAttribute("OriginYUnit", "m")
    fileDataProperty.SetAttribute("OriginZ", "0")
    fileDataProperty.SetAttribute("OriginZUnit", "m")
    fileDataProperty.SetAttribute("ThetaXY", "0")
    fileDataProperty.SetAttribute("ThetaXYUnit", "radian")
    fileDataProperty.SetAttribute("ThetaYZ", "0")
    fileDataProperty.SetAttribute("ThetaYZUnit", "radian")
    fileDataProperty.SetAttribute("ThetaZX", "0")
    fileDataProperty.SetAttribute("ThetaZXUnit", "radian")
    fileDataProperty.SetAttribute("MorphX", "x")
    fileDataProperty.SetAttribute("MorphY", "y")
    fileDataProperty.SetAttribute("MorphZ", "z")
    fileDataProperty.SetAttribute("ConversionOption", "NoConversion")
    columnsData = document.CreateElement("ColumnsData")
    columnsData.SetAttribute("Count", "5")
    columnNotUsed = document.CreateElement("ColumnData")
    columnNotUsed = document.CreateElement("ColumnData")
    columnNotUsed.SetAttribute("CurrentVersion", "2")
    columnNotUsed.SetAttribute("DataType", "Not Used")
    columnNotUsed.SetAttribute("Unit", "")
    columnNotUsed.SetAttribute("Identifier", "")
    columnNotUsed.SetAttribute("QuantityType", "")
    columnDataX = document.CreateElement("ColumnData")
    columnDataX.SetAttribute("CurrentVersion", "2")
    columnDataX.SetAttribute("DataType", "X Coordinate")
    columnDataX.SetAttribute("Unit", "m")
    columnDataX.SetAttribute("Identifier", "")
    columnNotUsed.SetAttribute("QuantityType", "Length")
    columnDataY = document.CreateElement("ColumnData")
    columnDataY.SetAttribute("CurrentVersion", "2")
    columnDataY.SetAttribute("DataType", "Y Coordinate")
    columnDataY.SetAttribute("Unit", "m")
    columnDataY.SetAttribute("Identifier", "")
    columnNotUsed.SetAttribute("QuantityType", "Length")
    columnDataZ = document.CreateElement("ColumnData")
    columnDataZ.SetAttribute("CurrentVersion", "2")
    columnDataZ.SetAttribute("DataType", "Z Coordinate")
    columnDataZ.SetAttribute("Unit", "m")
    columnDataZ.SetAttribute("Identifier", "")
    columnNotUsed.SetAttribute("QuantityType", "Length")
    columnStrain = document.CreateElement("ColumnData")
    columnStrain = document.CreateElement("ColumnData")
    columnStrain.SetAttribute("CurrentVersion", "2")
    columnStrain.SetAttribute("DataType", "Strain")
    columnStrain.SetAttribute("Unit", "m m^-1")
    columnStrain.SetAttribute("Identifier", "XZ")
    columnNotUsed.SetAttribute("QuantityType", "Strain")
    columnsData.AppendChild(columnNotUsed)
    columnsData.AppendChild(columnDataX)
    columnsData.AppendChild(columnDataY)
    columnsData.AppendChild(columnDataZ)
    columnsData.AppendChild(columnStrain)
    fileDataProperty.AppendChild(columnsData)
    fileData2.AppendChild(fileDataProperty)
    fileData1.AppendChild(fileData2)
    #Res Y
    fileData2 = document.CreateElement("FileData")
    fileData2.SetAttribute("CurrentVersion", "2")
    fileData2.SetAttribute("Description", "Custom Strain Y")
    fileData2.SetAttribute("Master", "False")
    fileData2.SetAttribute("Location", "StrainY.txt")
    fileDataProperty = document.CreateElement("FileDataProperty")
    fileDataProperty.SetAttribute("CurrentVersion", "4")
    fileDataProperty.SetAttribute("FileIdentifier", "File4")
    fileDataProperty.SetAttribute("Dimensions", "3D")
    fileDataProperty.SetAttribute("StartImportAtLine", "2")
    fileDataProperty.SetAttribute("FormatType", "Delimited")
    fileDataProperty.SetAttribute("FormatString", "")
    fileDataProperty.SetAttribute("DelimiterType", "Tab")
    fileDataProperty.SetAttribute("DelimiterCharacter", "\\t")
    fileDataProperty.SetAttribute("SectionName", "")
    fileDataProperty.SetAttribute("LengthUnit", "m")
    fileDataProperty.SetAttribute("CoordinateSystemType", "Cartesian")
    fileDataProperty.SetAttribute("OriginX", "0")
    fileDataProperty.SetAttribute("OriginXUnit", "m")
    fileDataProperty.SetAttribute("OriginY", "0")
    fileDataProperty.SetAttribute("OriginYUnit", "m")
    fileDataProperty.SetAttribute("OriginZ", "0")
    fileDataProperty.SetAttribute("OriginZUnit", "m")
    fileDataProperty.SetAttribute("ThetaXY", "0")
    fileDataProperty.SetAttribute("ThetaXYUnit", "radian")
    fileDataProperty.SetAttribute("ThetaYZ", "0")
    fileDataProperty.SetAttribute("ThetaYZUnit", "radian")
    fileDataProperty.SetAttribute("ThetaZX", "0")
    fileDataProperty.SetAttribute("ThetaZXUnit", "radian")
    fileDataProperty.SetAttribute("MorphX", "x")
    fileDataProperty.SetAttribute("MorphY", "y")
    fileDataProperty.SetAttribute("MorphZ", "z")
    fileDataProperty.SetAttribute("ConversionOption", "NoConversion")
    columnsData = document.CreateElement("ColumnsData")
    columnsData.SetAttribute("Count", "5")
    columnNotUsed = document.CreateElement("ColumnData")
    columnNotUsed = document.CreateElement("ColumnData")
    columnNotUsed.SetAttribute("CurrentVersion", "2")
    columnNotUsed.SetAttribute("DataType", "Not Used")
    columnNotUsed.SetAttribute("Unit", "")
    columnNotUsed.SetAttribute("Identifier", "")
    columnNotUsed.SetAttribute("QuantityType", "")
    columnDataX = document.CreateElement("ColumnData")
    columnDataX.SetAttribute("CurrentVersion", "2")
    columnDataX.SetAttribute("DataType", "X Coordinate")
    columnDataX.SetAttribute("Unit", "m")
    columnDataX.SetAttribute("Identifier", "")
    columnNotUsed.SetAttribute("QuantityType", "Length")
    columnDataY = document.CreateElement("ColumnData")
    columnDataY.SetAttribute("CurrentVersion", "2")
    columnDataY.SetAttribute("DataType", "Y Coordinate")
    columnDataY.SetAttribute("Unit", "m")
    columnDataY.SetAttribute("Identifier", "")
    columnNotUsed.SetAttribute("QuantityType", "Length")
    columnDataZ = document.CreateElement("ColumnData")
    columnDataZ.SetAttribute("CurrentVersion", "2")
    columnDataZ.SetAttribute("DataType", "Z Coordinate")
    columnDataZ.SetAttribute("Unit", "m")
    columnDataZ.SetAttribute("Identifier", "")
    columnNotUsed.SetAttribute("QuantityType", "Length")
    columnStrain = document.CreateElement("ColumnData")
    columnStrain = document.CreateElement("ColumnData")
    columnStrain.SetAttribute("CurrentVersion", "2")
    columnStrain.SetAttribute("DataType", "Strain")
    columnStrain.SetAttribute("Unit", "m m^-1")
    columnStrain.SetAttribute("Identifier", "YY")
    columnNotUsed.SetAttribute("QuantityType", "Strain")
    columnsData.AppendChild(columnNotUsed)
    columnsData.AppendChild(columnDataX)
    columnsData.AppendChild(columnDataY)
    columnsData.AppendChild(columnDataZ)
    columnsData.AppendChild(columnStrain)
    fileDataProperty.AppendChild(columnsData)
    fileData2.AppendChild(fileDataProperty)
    fileData1.AppendChild(fileData2)
    #Res YZ
    fileData2 = document.CreateElement("FileData")
    fileData2.SetAttribute("CurrentVersion", "2")
    fileData2.SetAttribute("Description", "Custom Strain YZ")
    fileData2.SetAttribute("Master", "False")
    fileData2.SetAttribute("Location", "StrainYZ.txt")
    fileDataProperty = document.CreateElement("FileDataProperty")
    fileDataProperty.SetAttribute("CurrentVersion", "4")
    fileDataProperty.SetAttribute("FileIdentifier", "File5")
    fileDataProperty.SetAttribute("Dimensions", "3D")
    fileDataProperty.SetAttribute("StartImportAtLine", "2")
    fileDataProperty.SetAttribute("FormatType", "Delimited")
    fileDataProperty.SetAttribute("FormatString", "")
    fileDataProperty.SetAttribute("DelimiterType", "Tab")
    fileDataProperty.SetAttribute("DelimiterCharacter", "\\t")
    fileDataProperty.SetAttribute("SectionName", "")
    fileDataProperty.SetAttribute("LengthUnit", "m")
    fileDataProperty.SetAttribute("CoordinateSystemType", "Cartesian")
    fileDataProperty.SetAttribute("OriginX", "0")
    fileDataProperty.SetAttribute("OriginXUnit", "m")
    fileDataProperty.SetAttribute("OriginY", "0")
    fileDataProperty.SetAttribute("OriginYUnit", "m")
    fileDataProperty.SetAttribute("OriginZ", "0")
    fileDataProperty.SetAttribute("OriginZUnit", "m")
    fileDataProperty.SetAttribute("ThetaXY", "0")
    fileDataProperty.SetAttribute("ThetaXYUnit", "radian")
    fileDataProperty.SetAttribute("ThetaYZ", "0")
    fileDataProperty.SetAttribute("ThetaYZUnit", "radian")
    fileDataProperty.SetAttribute("ThetaZX", "0")
    fileDataProperty.SetAttribute("ThetaZXUnit", "radian")
    fileDataProperty.SetAttribute("MorphX", "x")
    fileDataProperty.SetAttribute("MorphY", "y")
    fileDataProperty.SetAttribute("MorphZ", "z")
    fileDataProperty.SetAttribute("ConversionOption", "NoConversion")
    columnsData = document.CreateElement("ColumnsData")
    columnsData.SetAttribute("Count", "5")
    columnNotUsed = document.CreateElement("ColumnData")
    columnNotUsed = document.CreateElement("ColumnData")
    columnNotUsed.SetAttribute("CurrentVersion", "2")
    columnNotUsed.SetAttribute("DataType", "Not Used")
    columnNotUsed.SetAttribute("Unit", "")
    columnNotUsed.SetAttribute("Identifier", "")
    columnNotUsed.SetAttribute("QuantityType", "")
    columnDataX = document.CreateElement("ColumnData")
    columnDataX.SetAttribute("CurrentVersion", "2")
    columnDataX.SetAttribute("DataType", "X Coordinate")
    columnDataX.SetAttribute("Unit", "m")
    columnDataX.SetAttribute("Identifier", "")
    columnNotUsed.SetAttribute("QuantityType", "Length")
    columnDataY = document.CreateElement("ColumnData")
    columnDataY.SetAttribute("CurrentVersion", "2")
    columnDataY.SetAttribute("DataType", "Y Coordinate")
    columnDataY.SetAttribute("Unit", "m")
    columnDataY.SetAttribute("Identifier", "")
    columnNotUsed.SetAttribute("QuantityType", "Length")
    columnDataZ = document.CreateElement("ColumnData")
    columnDataZ.SetAttribute("CurrentVersion", "2")
    columnDataZ.SetAttribute("DataType", "Z Coordinate")
    columnDataZ.SetAttribute("Unit", "m")
    columnDataZ.SetAttribute("Identifier", "")
    columnNotUsed.SetAttribute("QuantityType", "Length")
    columnStrain = document.CreateElement("ColumnData")
    columnStrain = document.CreateElement("ColumnData")
    columnStrain.SetAttribute("CurrentVersion", "2")
    columnStrain.SetAttribute("DataType", "Strain")
    columnStrain.SetAttribute("Unit", "m m^-1")
    columnStrain.SetAttribute("Identifier", "YZ")
    columnNotUsed.SetAttribute("QuantityType", "Strain")
    columnsData.AppendChild(columnNotUsed)
    columnsData.AppendChild(columnDataX)
    columnsData.AppendChild(columnDataY)
    columnsData.AppendChild(columnDataZ)
    columnsData.AppendChild(columnStrain)
    fileDataProperty.AppendChild(columnsData)
    fileData2.AppendChild(fileDataProperty)
    fileData1.AppendChild(fileData2)
    #Res Z
    fileData2 = document.CreateElement("FileData")
    fileData2.SetAttribute("CurrentVersion", "2")
    fileData2.SetAttribute("Description", "Custom Strain Z")
    fileData2.SetAttribute("Master", "False")
    fileData2.SetAttribute("Location", "StrainZ.txt")
    fileDataProperty = document.CreateElement("FileDataProperty")
    fileDataProperty.SetAttribute("CurrentVersion", "4")
    fileDataProperty.SetAttribute("FileIdentifier", "File6")
    fileDataProperty.SetAttribute("Dimensions", "3D")
    fileDataProperty.SetAttribute("StartImportAtLine", "2")
    fileDataProperty.SetAttribute("FormatType", "Delimited")
    fileDataProperty.SetAttribute("FormatString", "")
    fileDataProperty.SetAttribute("DelimiterType", "Tab")
    fileDataProperty.SetAttribute("DelimiterCharacter", "\\t")
    fileDataProperty.SetAttribute("SectionName", "")
    fileDataProperty.SetAttribute("LengthUnit", "m")
    fileDataProperty.SetAttribute("CoordinateSystemType", "Cartesian")
    fileDataProperty.SetAttribute("OriginX", "0")
    fileDataProperty.SetAttribute("OriginXUnit", "m")
    fileDataProperty.SetAttribute("OriginY", "0")
    fileDataProperty.SetAttribute("OriginYUnit", "m")
    fileDataProperty.SetAttribute("OriginZ", "0")
    fileDataProperty.SetAttribute("OriginZUnit", "m")
    fileDataProperty.SetAttribute("ThetaXY", "0")
    fileDataProperty.SetAttribute("ThetaXYUnit", "radian")
    fileDataProperty.SetAttribute("ThetaYZ", "0")
    fileDataProperty.SetAttribute("ThetaYZUnit", "radian")
    fileDataProperty.SetAttribute("ThetaZX", "0")
    fileDataProperty.SetAttribute("ThetaZXUnit", "radian")
    fileDataProperty.SetAttribute("MorphX", "x")
    fileDataProperty.SetAttribute("MorphY", "y")
    fileDataProperty.SetAttribute("MorphZ", "z")
    fileDataProperty.SetAttribute("ConversionOption", "NoConversion")
    columnsData = document.CreateElement("ColumnsData")
    columnsData.SetAttribute("Count", "5")
    columnNotUsed = document.CreateElement("ColumnData")
    columnNotUsed = document.CreateElement("ColumnData")
    columnNotUsed.SetAttribute("CurrentVersion", "2")
    columnNotUsed.SetAttribute("DataType", "Not Used")
    columnNotUsed.SetAttribute("Unit", "")
    columnNotUsed.SetAttribute("Identifier", "")
    columnNotUsed.SetAttribute("QuantityType", "")
    columnDataX = document.CreateElement("ColumnData")
    columnDataX.SetAttribute("CurrentVersion", "2")
    columnDataX.SetAttribute("DataType", "X Coordinate")
    columnDataX.SetAttribute("Unit", "m")
    columnDataX.SetAttribute("Identifier", "")
    columnNotUsed.SetAttribute("QuantityType", "Length")
    columnDataY = document.CreateElement("ColumnData")
    columnDataY.SetAttribute("CurrentVersion", "2")
    columnDataY.SetAttribute("DataType", "Y Coordinate")
    columnDataY.SetAttribute("Unit", "m")
    columnDataY.SetAttribute("Identifier", "")
    columnNotUsed.SetAttribute("QuantityType", "Length")
    columnDataZ = document.CreateElement("ColumnData")
    columnDataZ.SetAttribute("CurrentVersion", "2")
    columnDataZ.SetAttribute("DataType", "Z Coordinate")
    columnDataZ.SetAttribute("Unit", "m")
    columnDataZ.SetAttribute("Identifier", "")
    columnNotUsed.SetAttribute("QuantityType", "Length")
    columnStrain = document.CreateElement("ColumnData")
    columnStrain = document.CreateElement("ColumnData")
    columnStrain.SetAttribute("CurrentVersion", "2")
    columnStrain.SetAttribute("DataType", "Strain")
    columnStrain.SetAttribute("Unit", "m m^-1")
    columnStrain.SetAttribute("Identifier", "ZZ")
    columnNotUsed.SetAttribute("QuantityType", "Strain")
    columnsData.AppendChild(columnNotUsed)
    columnsData.AppendChild(columnDataX)
    columnsData.AppendChild(columnDataY)
    columnsData.AppendChild(columnDataZ)
    columnsData.AppendChild(columnStrain)
    fileDataProperty.AppendChild(columnsData)
    fileData2.AppendChild(fileDataProperty)
    fileData1.AppendChild(fileData2)
    element.AppendChild(fileData1)
    document.AppendChild(element)
    document.Save(filePath)
    transferFile = task.RegisterFile(filePath)
    return transferFile
def GenerateStrainDataFiles(task, workingDirectory):
    fileRefs = System.Collections.Generic.List[Ansys.Core.DataModel.DataReference]()
    #region x strain
    filePath = System.IO.Path.Combine(workingDirectory, "StrainX.txt")
    fileContents = r"""Node Number	X Location (m)	Y Location (m)	Z Location (m)	Normal Elastic Strain (m/m)
1	-3.5355e-002	3.5355e-002	5.e-002	-2.394e-005
2	3.5355e-002	3.5355e-002	5.e-002	-2.394e-005
3	-3.4645e-002	3.6051e-002	5.e-002	-2.439e-005
4	-3.3922e-002	3.6733e-002	5.e-002	-2.529e-005
5	-3.3185e-002	3.74e-002	5.e-002	-2.6185e-005
6	-3.2435e-002	3.8053e-002	5.e-002	-2.7074e-005
7	-3.1672e-002	3.869e-002	5.e-002	-2.7956e-005
8	-3.0896e-002	3.9312e-002	5.e-002	-2.8829e-005
9	-3.0108e-002	3.9918e-002	5.e-002	-2.9692e-005
10	-2.9309e-002	4.0509e-002	5.e-002	-3.0544e-005
11	-2.8498e-002	4.1084e-002	5.e-002	-3.1384e-005
12	-2.7675e-002	4.1642e-002	5.e-002	-3.221e-005
13	-2.6842e-002	4.2184e-002	5.e-002	-3.3021e-005
14	-2.5998e-002	4.271e-002	5.e-002	-3.3815e-005
15	-2.5143e-002	4.3218e-002	5.e-002	-3.4593e-005
16	-2.4279e-002	4.371e-002	5.e-002	-3.5352e-005
17	-2.3405e-002	4.4184e-002	5.e-002	-3.6091e-005
18	-2.2522e-002	4.464e-002	5.e-002	-3.6809e-005
19	-2.163e-002	4.5079e-002	5.e-002	-3.7506e-005
20	-2.073e-002	4.55e-002	5.e-002	-3.8181e-005
21	-1.9821e-002	4.5904e-002	5.e-002	-3.8831e-005
22	-1.8904e-002	4.6289e-002	5.e-002	-3.9457e-005
23	-1.798e-002	4.6655e-002	5.e-002	-4.0057e-005
24	-1.7049e-002	4.7003e-002	5.e-002	-4.0631e-005
25	-1.6111e-002	4.7333e-002	5.e-002	-4.1178e-005
26	-1.5167e-002	4.7644e-002	5.e-002	-4.1697e-005
27	-1.4217e-002	4.7936e-002	5.e-002	-4.2186e-005
28	-1.3261e-002	4.8209e-002	5.e-002	-4.2647e-005
29	-1.23e-002	4.8464e-002	5.e-002	-4.3077e-005
30	-1.1334e-002	4.8699e-002	5.e-002	-4.3477e-005
31	-1.0363e-002	4.8914e-002	5.e-002	-4.3845e-005
32	-9.3886e-003	4.9111e-002	5.e-002	-4.4182e-005
33	-8.4103e-003	4.9288e-002	5.e-002	-4.4486e-005
34	-7.4287e-003	4.9445e-002	5.e-002	-4.4758e-005
35	-6.4442e-003	4.9583e-002	5.e-002	-4.4996e-005
36	-5.4571e-003	4.9701e-002	5.e-002	-4.5201e-005
37	-4.4678e-003	4.98e-002	5.e-002	-4.5372e-005
38	-3.4768e-003	4.9879e-002	5.e-002	-4.551e-005
39	-2.4844e-003	4.9938e-002	5.e-002	-4.5613e-005
40	-1.491e-003	4.9978e-002	5.e-002	-4.5682e-005
41	-4.9708e-004	4.9998e-002	5.e-002	-4.5716e-005
42	4.9708e-004	4.9998e-002	5.e-002	-4.5716e-005
43	1.491e-003	4.9978e-002	5.e-002	-4.5682e-005
44	2.4844e-003	4.9938e-002	5.e-002	-4.5613e-005
45	3.4768e-003	4.9879e-002	5.e-002	-4.551e-005
46	4.4678e-003	4.98e-002	5.e-002	-4.5372e-005
47	5.4571e-003	4.9701e-002	5.e-002	-4.5201e-005
48	6.4442e-003	4.9583e-002	5.e-002	-4.4996e-005
49	7.4287e-003	4.9445e-002	5.e-002	-4.4758e-005
50	8.4103e-003	4.9288e-002	5.e-002	-4.4486e-005
51	9.3886e-003	4.9111e-002	5.e-002	-4.4182e-005
52	1.0363e-002	4.8914e-002	5.e-002	-4.3845e-005
53	1.1334e-002	4.8699e-002	5.e-002	-4.3477e-005
54	1.23e-002	4.8464e-002	5.e-002	-4.3077e-005
55	1.3261e-002	4.8209e-002	5.e-002	-4.2647e-005
56	1.4217e-002	4.7936e-002	5.e-002	-4.2186e-005
57	1.5167e-002	4.7644e-002	5.e-002	-4.1697e-005
58	1.6111e-002	4.7333e-002	5.e-002	-4.1178e-005
59	1.7049e-002	4.7003e-002	5.e-002	-4.0631e-005
60	1.798e-002	4.6655e-002	5.e-002	-4.0057e-005
61	1.8904e-002	4.6289e-002	5.e-002	-3.9457e-005
62	1.9821e-002	4.5904e-002	5.e-002	-3.8831e-005
63	2.073e-002	4.55e-002	5.e-002	-3.8181e-005
64	2.163e-002	4.5079e-002	5.e-002	-3.7506e-005
65	2.2522e-002	4.464e-002	5.e-002	-3.681e-005
66	2.3405e-002	4.4184e-002	5.e-002	-3.6091e-005
67	2.4279e-002	4.371e-002	5.e-002	-3.5352e-005
68	2.5143e-002	4.3218e-002	5.e-002	-3.4593e-005
69	2.5998e-002	4.271e-002	5.e-002	-3.3815e-005
70	2.6842e-002	4.2184e-002	5.e-002	-3.3021e-005
71	2.7675e-002	4.1642e-002	5.e-002	-3.221e-005
72	2.8498e-002	4.1084e-002	5.e-002	-3.1384e-005
73	2.9309e-002	4.0509e-002	5.e-002	-3.0544e-005
74	3.0108e-002	3.9918e-002	5.e-002	-2.9692e-005
75	3.0896e-002	3.9312e-002	5.e-002	-2.8829e-005
76	3.1672e-002	3.869e-002	5.e-002	-2.7956e-005
77	3.2435e-002	3.8053e-002	5.e-002	-2.7074e-005
78	3.3185e-002	3.74e-002	5.e-002	-2.6185e-005
79	3.3922e-002	3.6733e-002	5.e-002	-2.529e-005
80	3.4645e-002	3.6051e-002	5.e-002	-2.4391e-005
81	3.5355e-002	3.5355e-002	0.	-2.394e-005
82	3.5355e-002	3.5355e-002	4.9e-002	-2.394e-005
83	3.5355e-002	3.5355e-002	4.8e-002	-2.3942e-005
84	3.5355e-002	3.5355e-002	4.7e-002	-2.3942e-005
85	3.5355e-002	3.5355e-002	4.6e-002	-2.3942e-005
86	3.5355e-002	3.5355e-002	4.5e-002	-2.3942e-005
87	3.5355e-002	3.5355e-002	4.4e-002	-2.3942e-005
88	3.5355e-002	3.5355e-002	4.3e-002	-2.3942e-005
89	3.5355e-002	3.5355e-002	4.2e-002	-2.3942e-005
90	3.5355e-002	3.5355e-002	4.1e-002	-2.3942e-005
91	3.5355e-002	3.5355e-002	4.e-002	-2.3942e-005
92	3.5355e-002	3.5355e-002	3.9e-002	-2.3942e-005
93	3.5355e-002	3.5355e-002	3.8e-002	-2.3942e-005
94	3.5355e-002	3.5355e-002	3.7e-002	-2.3942e-005
95	3.5355e-002	3.5355e-002	3.6e-002	-2.3942e-005
96	3.5355e-002	3.5355e-002	3.5e-002	-2.3942e-005
97	3.5355e-002	3.5355e-002	3.4e-002	-2.3942e-005
98	3.5355e-002	3.5355e-002	3.3e-002	-2.3942e-005
99	3.5355e-002	3.5355e-002	3.2e-002	-2.3942e-005
100	3.5355e-002	3.5355e-002	3.1e-002	-2.3942e-005
101	3.5355e-002	3.5355e-002	3.e-002	-2.3942e-005
102	3.5355e-002	3.5355e-002	2.9e-002	-2.3942e-005
103	3.5355e-002	3.5355e-002	2.8e-002	-2.3942e-005
104	3.5355e-002	3.5355e-002	2.7e-002	-2.3942e-005
105	3.5355e-002	3.5355e-002	2.6e-002	-2.3942e-005
106	3.5355e-002	3.5355e-002	2.5e-002	-2.3942e-005
107	3.5355e-002	3.5355e-002	2.4e-002	-2.3942e-005
108	3.5355e-002	3.5355e-002	2.3e-002	-2.3942e-005
109	3.5355e-002	3.5355e-002	2.2e-002	-2.3942e-005
110	3.5355e-002	3.5355e-002	2.1e-002	-2.3942e-005
111	3.5355e-002	3.5355e-002	2.e-002	-2.3942e-005
112	3.5355e-002	3.5355e-002	1.9e-002	-2.3942e-005
113	3.5355e-002	3.5355e-002	1.8e-002	-2.3942e-005
114	3.5355e-002	3.5355e-002	1.7e-002	-2.3942e-005
115	3.5355e-002	3.5355e-002	1.6e-002	-2.3942e-005
116	3.5355e-002	3.5355e-002	1.5e-002	-2.3942e-005
117	3.5355e-002	3.5355e-002	1.4e-002	-2.3942e-005
118	3.5355e-002	3.5355e-002	1.3e-002	-2.3942e-005
119	3.5355e-002	3.5355e-002	1.2e-002	-2.3942e-005
120	3.5355e-002	3.5355e-002	1.1e-002	-2.3942e-005
121	3.5355e-002	3.5355e-002	1.e-002	-2.3942e-005
122	3.5355e-002	3.5355e-002	9.e-003	-2.3942e-005
123	3.5355e-002	3.5355e-002	8.e-003	-2.3942e-005
124	3.5355e-002	3.5355e-002	7.e-003	-2.3942e-005
125	3.5355e-002	3.5355e-002	6.e-003	-2.3942e-005
126	3.5355e-002	3.5355e-002	5.e-003	-2.3942e-005
127	3.5355e-002	3.5355e-002	4.e-003	-2.3942e-005
128	3.5355e-002	3.5355e-002	3.e-003	-2.3942e-005
129	3.5355e-002	3.5355e-002	2.e-003	-2.3942e-005
130	3.5355e-002	3.5355e-002	1.e-003	-2.3942e-005
131	-3.5355e-002	3.5355e-002	0.	-2.394e-005
132	3.4645e-002	3.6051e-002	0.	-2.4392e-005
133	3.3922e-002	3.6733e-002	0.	-2.5291e-005
134	3.3185e-002	3.74e-002	0.	-2.6185e-005
135	3.2435e-002	3.8053e-002	0.	-2.7074e-005
136	3.1672e-002	3.869e-002	0.	-2.7956e-005
137	3.0896e-002	3.9312e-002	0.	-2.8829e-005
138	3.0108e-002	3.9918e-002	0.	-2.9692e-005
139	2.9309e-002	4.0509e-002	0.	-3.0544e-005
140	2.8498e-002	4.1084e-002	0.	-3.1384e-005
141	2.7675e-002	4.1642e-002	0.	-3.221e-005
142	2.6842e-002	4.2184e-002	0.	-3.3021e-005
143	2.5998e-002	4.271e-002	0.	-3.3815e-005
144	2.5143e-002	4.3218e-002	0.	-3.4593e-005
145	2.4279e-002	4.371e-002	0.	-3.5352e-005
146	2.3405e-002	4.4184e-002	0.	-3.6091e-005
147	2.2522e-002	4.464e-002	0.	-3.681e-005
148	2.163e-002	4.5079e-002	0.	-3.7507e-005
149	2.073e-002	4.55e-002	0.	-3.8181e-005
150	1.9821e-002	4.5904e-002	0.	-3.8831e-005
151	1.8904e-002	4.6289e-002	0.	-3.9457e-005
152	1.798e-002	4.6655e-002	0.	-4.0057e-005
153	1.7049e-002	4.7003e-002	0.	-4.0631e-005
154	1.6111e-002	4.7333e-002	0.	-4.1178e-005
155	1.5167e-002	4.7644e-002	0.	-4.1697e-005
156	1.4217e-002	4.7936e-002	0.	-4.2187e-005
157	1.3261e-002	4.8209e-002	0.	-4.2647e-005
158	1.23e-002	4.8464e-002	0.	-4.3077e-005
159	1.1334e-002	4.8699e-002	0.	-4.3477e-005
160	1.0363e-002	4.8914e-002	0.	-4.3845e-005
161	9.3886e-003	4.9111e-002	0.	-4.4182e-005
162	8.4103e-003	4.9288e-002	0.	-4.4486e-005
163	7.4287e-003	4.9445e-002	0.	-4.4758e-005
164	6.4442e-003	4.9583e-002	0.	-4.4996e-005
165	5.4571e-003	4.9701e-002	0.	-4.5201e-005
166	4.4678e-003	4.98e-002	0.	-4.5372e-005
167	3.4768e-003	4.9879e-002	0.	-4.551e-005
168	2.4844e-003	4.9938e-002	0.	-4.5613e-005
169	1.491e-003	4.9978e-002	0.	-4.5682e-005
170	4.9708e-004	4.9998e-002	0.	-4.5716e-005
171	-4.9708e-004	4.9998e-002	0.	-4.5716e-005
172	-1.491e-003	4.9978e-002	0.	-4.5682e-005
173	-2.4844e-003	4.9938e-002	0.	-4.5613e-005
174	-3.4768e-003	4.9879e-002	0.	-4.551e-005
175	-4.4678e-003	4.98e-002	0.	-4.5372e-005
176	-5.4571e-003	4.9701e-002	0.	-4.5201e-005
177	-6.4442e-003	4.9583e-002	0.	-4.4996e-005
178	-7.4287e-003	4.9445e-002	0.	-4.4758e-005
179	-8.4103e-003	4.9288e-002	0.	-4.4486e-005
180	-9.3886e-003	4.9111e-002	0.	-4.4182e-005
181	-1.0363e-002	4.8914e-002	0.	-4.3845e-005
182	-1.1334e-002	4.8699e-002	0.	-4.3477e-005
183	-1.23e-002	4.8464e-002	0.	-4.3077e-005
184	-1.3261e-002	4.8209e-002	0.	-4.2647e-005
185	-1.4217e-002	4.7936e-002	0.	-4.2187e-005
186	-1.5167e-002	4.7644e-002	0.	-4.1697e-005
187	-1.6111e-002	4.7333e-002	0.	-4.1178e-005
188	-1.7049e-002	4.7003e-002	0.	-4.0631e-005
189	-1.798e-002	4.6655e-002	0.	-4.0057e-005
190	-1.8904e-002	4.6289e-002	0.	-3.9457e-005
191	-1.9821e-002	4.5904e-002	0.	-3.8831e-005
192	-2.073e-002	4.55e-002	0.	-3.8181e-005
193	-2.163e-002	4.5079e-002	0.	-3.7507e-005
194	-2.2522e-002	4.464e-002	0.	-3.681e-005
195	-2.3405e-002	4.4184e-002	0.	-3.6091e-005
196	-2.4279e-002	4.371e-002	0.	-3.5352e-005
197	-2.5143e-002	4.3218e-002	0.	-3.4593e-005
198	-2.5998e-002	4.271e-002	0.	-3.3815e-005
199	-2.6842e-002	4.2184e-002	0.	-3.3021e-005
200	-2.7675e-002	4.1642e-002	0.	-3.221e-005
201	-2.8498e-002	4.1084e-002	0.	-3.1384e-005
202	-2.9309e-002	4.0509e-002	0.	-3.0545e-005
203	-3.0108e-002	3.9918e-002	0.	-2.9692e-005
204	-3.0896e-002	3.9312e-002	0.	-2.8829e-005
205	-3.1672e-002	3.869e-002	0.	-2.7956e-005
206	-3.2435e-002	3.8053e-002	0.	-2.7074e-005
207	-3.3185e-002	3.74e-002	0.	-2.6185e-005
208	-3.3922e-002	3.6733e-002	0.	-2.529e-005
209	-3.4645e-002	3.6051e-002	0.	-2.4391e-005
210	-3.5355e-002	3.5355e-002	1.e-003	-2.394e-005
211	-3.5355e-002	3.5355e-002	2.e-003	-2.3942e-005
212	-3.5355e-002	3.5355e-002	3.e-003	-2.3942e-005
213	-3.5355e-002	3.5355e-002	4.e-003	-2.3942e-005
214	-3.5355e-002	3.5355e-002	5.e-003	-2.3942e-005
215	-3.5355e-002	3.5355e-002	6.e-003	-2.3942e-005
216	-3.5355e-002	3.5355e-002	7.e-003	-2.3942e-005
217	-3.5355e-002	3.5355e-002	8.e-003	-2.3942e-005
218	-3.5355e-002	3.5355e-002	9.e-003	-2.3942e-005
219	-3.5355e-002	3.5355e-002	1.e-002	-2.3943e-005
220	-3.5355e-002	3.5355e-002	1.1e-002	-2.3943e-005
221	-3.5355e-002	3.5355e-002	1.2e-002	-2.3943e-005
222	-3.5355e-002	3.5355e-002	1.3e-002	-2.3943e-005
223	-3.5355e-002	3.5355e-002	1.4e-002	-2.3943e-005
224	-3.5355e-002	3.5355e-002	1.5e-002	-2.3942e-005
225	-3.5355e-002	3.5355e-002	1.6e-002	-2.3942e-005
226	-3.5355e-002	3.5355e-002	1.7e-002	-2.3942e-005
227	-3.5355e-002	3.5355e-002	1.8e-002	-2.3942e-005
228	-3.5355e-002	3.5355e-002	1.9e-002	-2.3942e-005
229	-3.5355e-002	3.5355e-002	2.e-002	-2.3942e-005
230	-3.5355e-002	3.5355e-002	2.1e-002	-2.3942e-005
231	-3.5355e-002	3.5355e-002	2.2e-002	-2.3942e-005
232	-3.5355e-002	3.5355e-002	2.3e-002	-2.3942e-005
233	-3.5355e-002	3.5355e-002	2.4e-002	-2.3942e-005
234	-3.5355e-002	3.5355e-002	2.5e-002	-2.3942e-005
235	-3.5355e-002	3.5355e-002	2.6e-002	-2.3942e-005
236	-3.5355e-002	3.5355e-002	2.7e-002	-2.3942e-005
237	-3.5355e-002	3.5355e-002	2.8e-002	-2.3942e-005
238	-3.5355e-002	3.5355e-002	2.9e-002	-2.3942e-005
239	-3.5355e-002	3.5355e-002	3.e-002	-2.3942e-005
240	-3.5355e-002	3.5355e-002	3.1e-002	-2.3942e-005
241	-3.5355e-002	3.5355e-002	3.2e-002	-2.3942e-005
242	-3.5355e-002	3.5355e-002	3.3e-002	-2.3942e-005
243	-3.5355e-002	3.5355e-002	3.4e-002	-2.3942e-005
244	-3.5355e-002	3.5355e-002	3.5e-002	-2.3942e-005
245	-3.5355e-002	3.5355e-002	3.6e-002	-2.3942e-005
246	-3.5355e-002	3.5355e-002	3.7e-002	-2.3942e-005
247	-3.5355e-002	3.5355e-002	3.8e-002	-2.3942e-005
248	-3.5355e-002	3.5355e-002	3.9e-002	-2.3942e-005
249	-3.5355e-002	3.5355e-002	4.e-002	-2.3942e-005
250	-3.5355e-002	3.5355e-002	4.1e-002	-2.3942e-005
251	-3.5355e-002	3.5355e-002	4.2e-002	-2.3942e-005
252	-3.5355e-002	3.5355e-002	4.3e-002	-2.3942e-005
253	-3.5355e-002	3.5355e-002	4.4e-002	-2.3942e-005
254	-3.5355e-002	3.5355e-002	4.5e-002	-2.3942e-005
255	-3.5355e-002	3.5355e-002	4.6e-002	-2.3942e-005
256	-3.5355e-002	3.5355e-002	4.7e-002	-2.3942e-005
257	-3.5355e-002	3.5355e-002	4.8e-002	-2.3942e-005
258	-3.5355e-002	3.5355e-002	4.9e-002	-2.394e-005
259	3.4641e-002	3.6055e-002	4.e-003	-2.4394e-005
260	-3.4641e-002	3.6055e-002	2.e-003	-2.4393e-005
261	3.4641e-002	3.6055e-002	4.8e-002	-2.4393e-005
262	-2.8498e-002	4.1084e-002	4.8e-002	-3.1384e-005
263	-2.6842e-002	4.2184e-002	4.8e-002	-3.3021e-005
264	-2.5143e-002	4.3218e-002	4.8e-002	-3.4593e-005
265	-2.3405e-002	4.4184e-002	4.8e-002	-3.6091e-005
266	-2.163e-002	4.5079e-002	4.8e-002	-3.7506e-005
267	-1.9821e-002	4.5904e-002	4.8e-002	-3.8831e-005
268	-1.798e-002	4.6655e-002	4.8e-002	-4.0057e-005
269	-1.6111e-002	4.7333e-002	4.8e-002	-4.1178e-005
270	-1.4217e-002	4.7936e-002	4.8e-002	-4.2186e-005
271	-1.23e-002	4.8464e-002	4.8e-002	-4.3077e-005
272	-1.0363e-002	4.8914e-002	4.8e-002	-4.3845e-005
273	-8.4103e-003	4.9288e-002	4.8e-002	-4.4486e-005
274	-6.4442e-003	4.9583e-002	4.8e-002	-4.4996e-005
275	-4.4678e-003	4.98e-002	4.8e-002	-4.5372e-005
276	-2.4844e-003	4.9938e-002	4.8e-002	-4.5613e-005
277	-4.9707e-004	4.9998e-002	4.8e-002	-4.5716e-005
278	1.491e-003	4.9978e-002	4.8e-002	-4.5682e-005
279	3.4768e-003	4.9879e-002	4.8e-002	-4.551e-005
280	5.4571e-003	4.9701e-002	4.8e-002	-4.5201e-005
281	7.4287e-003	4.9445e-002	4.8e-002	-4.4758e-005
282	9.3886e-003	4.9111e-002	4.8e-002	-4.4182e-005
283	1.1334e-002	4.8699e-002	4.8e-002	-4.3477e-005
284	1.3261e-002	4.8209e-002	4.8e-002	-4.2647e-005
285	1.5167e-002	4.7644e-002	4.8e-002	-4.1697e-005
286	1.7049e-002	4.7003e-002	4.8e-002	-4.0631e-005
287	1.8904e-002	4.6289e-002	4.8e-002	-3.9457e-005
288	2.073e-002	4.55e-002	4.8e-002	-3.8181e-005
289	2.2522e-002	4.464e-002	4.8e-002	-3.681e-005
290	2.4279e-002	4.371e-002	4.8e-002	-3.5352e-005
291	2.5998e-002	4.271e-002	4.8e-002	-3.3815e-005
292	2.7675e-002	4.1642e-002	4.8e-002	-3.221e-005
293	2.9309e-002	4.0509e-002	4.8e-002	-3.0544e-005
294	3.0896e-002	3.9312e-002	4.8e-002	-2.8829e-005
295	-3.1672e-002	3.869e-002	2.e-003	-2.7956e-005
296	-3.3185e-002	3.74e-002	4.7e-002	-2.6185e-005
297	-3.0896e-002	3.9312e-002	4.e-003	-2.8829e-005
298	3.2433e-002	3.8054e-002	6.e-003	-2.7075e-005
299	-3.0108e-002	3.9919e-002	4.6e-002	-2.9692e-005
300	-2.6842e-002	4.2184e-002	4.6e-002	-3.3021e-005
301	2.9309e-002	4.0509e-002	4.6e-002	-3.0544e-005
302	2.4279e-002	4.371e-002	4.e-003	-3.5352e-005
303	2.2522e-002	4.464e-002	4.e-003	-3.681e-005
304	2.073e-002	4.55e-002	4.e-003	-3.8181e-005
305	1.8904e-002	4.6289e-002	4.e-003	-3.9457e-005
306	1.7049e-002	4.7003e-002	4.e-003	-4.0631e-005
307	1.5167e-002	4.7644e-002	4.e-003	-4.1697e-005
308	1.3261e-002	4.8209e-002	4.e-003	-4.2647e-005
309	1.1334e-002	4.8699e-002	4.e-003	-4.3477e-005
310	9.3886e-003	4.9111e-002	4.e-003	-4.4182e-005
311	7.4288e-003	4.9445e-002	4.e-003	-4.4758e-005
312	5.4571e-003	4.9701e-002	4.e-003	-4.5201e-005
313	3.4768e-003	4.9879e-002	4.e-003	-4.551e-005
314	1.4911e-003	4.9978e-002	4.e-003	-4.5682e-005
315	-4.9703e-004	4.9998e-002	4.e-003	-4.5716e-005
316	-2.4844e-003	4.9938e-002	4.e-003	-4.5613e-005
317	-4.4678e-003	4.98e-002	4.e-003	-4.5372e-005
318	-6.4441e-003	4.9583e-002	4.e-003	-4.4996e-005
319	-8.4103e-003	4.9288e-002	4.e-003	-4.4486e-005
320	-1.0363e-002	4.8914e-002	4.e-003	-4.3845e-005
321	-1.23e-002	4.8464e-002	4.e-003	-4.3077e-005
322	-1.4217e-002	4.7936e-002	4.e-003	-4.2187e-005
323	-1.6111e-002	4.7333e-002	4.e-003	-4.1178e-005
324	-1.798e-002	4.6655e-002	4.e-003	-4.0057e-005
325	-1.9821e-002	4.5904e-002	4.e-003	-3.8831e-005
326	-2.163e-002	4.5079e-002	4.e-003	-3.7507e-005
327	-2.3405e-002	4.4184e-002	4.e-003	-3.6091e-005
328	-2.5143e-002	4.3218e-002	4.e-003	-3.4593e-005
329	-2.6842e-002	4.2184e-002	4.e-003	-3.3021e-005
330	-2.8498e-002	4.1084e-002	4.e-003	-3.1384e-005
331	-3.0108e-002	3.9919e-002	4.e-003	-2.9692e-005
332	3.2435e-002	3.8053e-002	4.2e-002	-2.7074e-005
333	-3.2435e-002	3.8053e-002	8.e-003	-2.7078e-005
334	-3.0896e-002	3.9312e-002	5.e-003	-2.8829e-005
335	3.1671e-002	3.869e-002	3.8e-002	-2.7956e-005
336	3.1671e-002	3.869e-002	3.6e-002	-2.7956e-005
337	3.1671e-002	3.869e-002	3.4e-002	-2.7956e-005
338	3.1671e-002	3.869e-002	3.2e-002	-2.7956e-005
339	3.1671e-002	3.869e-002	3.e-002	-2.7956e-005
340	3.1671e-002	3.869e-002	2.8e-002	-2.7956e-005
341	3.1671e-002	3.869e-002	2.6e-002	-2.7956e-005
342	3.1671e-002	3.869e-002	2.4e-002	-2.7956e-005
343	3.1671e-002	3.869e-002	2.2e-002	-2.7956e-005
344	3.1671e-002	3.869e-002	2.e-002	-2.7956e-005
345	3.1671e-002	3.869e-002	1.8e-002	-2.7956e-005
346	3.1671e-002	3.869e-002	1.6e-002	-2.7956e-005
347	3.1671e-002	3.8691e-002	1.4e-002	-2.7956e-005
348	-3.1648e-002	3.8709e-002	1.1989e-002	-2.7982e-005
349	-3.1662e-002	3.8698e-002	1.3993e-002	-2.797e-005
350	-3.1667e-002	3.8694e-002	1.5998e-002	-2.7963e-005
351	-3.1671e-002	3.869e-002	1.8e-002	-2.7957e-005
352	-3.1671e-002	3.869e-002	2.e-002	-2.7954e-005
353	-3.1671e-002	3.869e-002	2.2e-002	-2.7952e-005
354	-3.1671e-002	3.869e-002	2.4e-002	-2.7954e-005
355	-3.1671e-002	3.869e-002	2.6e-002	-2.7959e-005
356	-3.1671e-002	3.869e-002	2.8e-002	-2.796e-005
357	-3.1671e-002	3.8691e-002	3.e-002	-2.796e-005
358	-3.1671e-002	3.8691e-002	3.2e-002	-2.796e-005
359	-3.1671e-002	3.8691e-002	3.4e-002	-2.7959e-005
360	-3.167e-002	3.8691e-002	3.6e-002	-2.7962e-005
361	-3.1662e-002	3.8698e-002	3.8e-002	-2.7967e-005
362	-3.1661e-002	3.8698e-002	3.9999e-002	-2.7965e-005
363	-3.167e-002	3.8691e-002	4.2e-002	-2.796e-005
364	-3.0882e-002	3.9323e-002	3.9997e-002	-2.8847e-005
365	-2.7675e-002	4.1642e-002	4.3e-002	-3.221e-005
366	2.9309e-002	4.0509e-002	3.1e-002	-3.0544e-005
367	2.9309e-002	4.0509e-002	2.9e-002	-3.0544e-005
368	2.9309e-002	4.0509e-002	2.7e-002	-3.0544e-005
369	2.9309e-002	4.0509e-002	2.5e-002	-3.0544e-005
370	2.9309e-002	4.0509e-002	2.3e-002	-3.0544e-005
371	2.9309e-002	4.0509e-002	2.1e-002	-3.0544e-005
372	2.9309e-002	4.0509e-002	1.9e-002	-3.0543e-005
373	2.9309e-002	4.0509e-002	1.7e-002	-3.0543e-005
374	2.9309e-002	4.0509e-002	1.5e-002	-3.0543e-005
375	-2.9282e-002	4.0528e-002	1.6991e-002	-3.0568e-005
376	-2.933e-002	4.0494e-002	1.8993e-002	-3.0522e-005
377	-2.9371e-002	4.0464e-002	2.1007e-002	-3.0481e-005
378	-2.9362e-002	4.0471e-002	2.3027e-002	-3.0489e-005
379	-2.9318e-002	4.0502e-002	2.5019e-002	-3.0535e-005
380	-2.9288e-002	4.0524e-002	2.6996e-002	-3.0564e-005
381	-2.9289e-002	4.0523e-002	2.8996e-002	-3.0567e-005
382	2.6842e-002	4.2184e-002	8.e-003	-3.3021e-005
383	2.5143e-002	4.3218e-002	8.e-003	-3.4593e-005
384	2.3405e-002	4.4184e-002	8.e-003	-3.6091e-005
385	2.163e-002	4.5079e-002	8.e-003	-3.7506e-005
386	1.9821e-002	4.5904e-002	8.e-003	-3.8831e-005
387	1.798e-002	4.6655e-002	8.e-003	-4.0057e-005
388	1.6111e-002	4.7333e-002	8.e-003	-4.1178e-005
389	1.4217e-002	4.7936e-002	8.e-003	-4.2187e-005
390	1.23e-002	4.8464e-002	8.e-003	-4.3077e-005
391	1.0363e-002	4.8914e-002	8.e-003	-4.3845e-005
392	8.4103e-003	4.9288e-002	8.e-003	-4.4486e-005
393	6.4442e-003	4.9583e-002	8.e-003	-4.4996e-005
394	4.4678e-003	4.98e-002	8.e-003	-4.5372e-005
395	2.4844e-003	4.9938e-002	8.e-003	-4.5613e-005
396	4.9708e-004	4.9998e-002	8.e-003	-4.5716e-005
397	-1.491e-003	4.9978e-002	8.e-003	-4.5682e-005
398	-3.4768e-003	4.9879e-002	8.e-003	-4.551e-005
399	-5.4571e-003	4.9701e-002	8.e-003	-4.5201e-005
400	-7.4287e-003	4.9445e-002	8.e-003	-4.4758e-005
401	-9.3886e-003	4.9111e-002	8.e-003	-4.4182e-005
402	-1.1334e-002	4.8699e-002	8.e-003	-4.3477e-005
403	-1.3261e-002	4.8209e-002	8.e-003	-4.2647e-005
404	-1.5167e-002	4.7644e-002	8.e-003	-4.1697e-005
405	-1.7049e-002	4.7003e-002	8.e-003	-4.0631e-005
406	-1.8904e-002	4.6289e-002	8.e-003	-3.9457e-005
407	-2.073e-002	4.55e-002	8.e-003	-3.8181e-005
408	-2.2522e-002	4.464e-002	8.e-003	-3.681e-005
409	-2.4279e-002	4.371e-002	8.e-003	-3.5352e-005
410	-2.5987e-002	4.2716e-002	7.9923e-003	-3.3826e-005
411	-2.7627e-002	4.1674e-002	9.9688e-003	-3.2256e-005
412	-2.7752e-002	4.1591e-002	2.0041e-002	-3.2137e-005
413	-2.6933e-002	4.2126e-002	2.3051e-002	-3.2941e-005
414	2.5143e-002	4.3218e-002	1.e-002	-3.4593e-005
415	2.5998e-002	4.271e-002	3.9e-002	-3.3815e-005
416	1.6111e-002	4.7333e-002	1.2e-002	-4.1178e-005
417	2.5997e-002	4.271e-002	3.5e-002	-3.3816e-005
418	2.4279e-002	4.371e-002	1.2e-002	-3.5352e-005
419	2.163e-002	4.5079e-002	3.7e-002	-3.7507e-005
420	-2.522e-002	4.3174e-002	2.0056e-002	-3.4531e-005
421	1.7049e-002	4.7003e-002	1.4e-002	-4.0631e-005
422	1.5167e-002	4.7644e-002	1.4e-002	-4.1697e-005
423	-2.4309e-002	4.3693e-002	2.4013e-002	-3.5327e-005
424	2.2522e-002	4.464e-002	1.7e-002	-3.681e-005
425	-2.163e-002	4.5079e-002	1.5e-002	-3.7506e-005
426	-2.3405e-002	4.4184e-002	1.7e-002	-3.6088e-005
427	-2.2522e-002	4.464e-002	1.6e-002	-3.6809e-005
428	2.2522e-002	4.464e-002	2.5e-002	-3.681e-005
429	2.163e-002	4.5079e-002	2.1e-002	-3.7506e-005
430	-2.163e-002	4.5079e-002	2.9e-002	-3.7507e-005
431	1.9821e-002	4.5903e-002	1.7e-002	-3.8831e-005
432	-1.9821e-002	4.5904e-002	1.7e-002	-3.8831e-005
433	-2.163e-002	4.5079e-002	2.5e-002	-3.7506e-005
434	-2.073e-002	4.55e-002	3.2e-002	-3.8181e-005
435	-1.8904e-002	4.6289e-002	1.8e-002	-3.9457e-005
436	1.6111e-002	4.7333e-002	1.8e-002	-4.1178e-005
437	2.073e-002	4.55e-002	2.9e-002	-3.8181e-005
438	2.073e-002	4.55e-002	2.7e-002	-3.8181e-005
439	1.798e-002	4.6655e-002	1.9e-002	-4.0057e-005
440	1.8904e-002	4.6289e-002	2.1e-002	-3.9457e-005
441	1.8904e-002	4.6289e-002	2.6e-002	-3.9457e-005
442	9.3887e-003	4.9111e-002	2.1e-002	-4.4182e-005
443	1.798e-002	4.6655e-002	2.3e-002	-4.0057e-005
444	1.7049e-002	4.7003e-002	2.1e-002	-4.0631e-005
445	-9.3888e-003	4.9111e-002	2.8e-002	-4.4182e-005
446	-7.4289e-003	4.9445e-002	2.8e-002	-4.4758e-005
447	3.4769e-003	4.9879e-002	2.2e-002	-4.551e-005
448	1.4911e-003	4.9978e-002	2.2e-002	-4.5682e-005
449	-4.9702e-004	4.9998e-002	2.2e-002	-4.5716e-005
450	-2.4844e-003	4.9938e-002	2.2e-002	-4.5613e-005
451	-4.4678e-003	4.98e-002	2.2e-002	-4.5372e-005
452	-6.4441e-003	4.9583e-002	2.2e-002	-4.4996e-005
453	-8.4103e-003	4.9288e-002	2.2e-002	-4.4486e-005
454	-1.0363e-002	4.8914e-002	2.2e-002	-4.3845e-005
455	-1.23e-002	4.8464e-002	2.2e-002	-4.3077e-005
456	-1.4217e-002	4.7936e-002	2.8e-002	-4.2186e-005
457	1.1334e-002	4.8699e-002	2.2e-002	-4.3477e-005
458	8.4104e-003	4.9288e-002	2.3e-002	-4.4486e-005
459	-1.1342e-002	4.8697e-002	2.6005e-002	-4.3474e-005
460	-1.3261e-002	4.8209e-002	2.4e-002	-4.2646e-005
461	-1.2313e-002	4.846e-002	2.5013e-002	-4.3073e-005
462	4.972e-004	4.9998e-002	2.5e-002	-4.5716e-005
463	6.4443e-003	4.9583e-002	2.5e-002	-4.4996e-005
464	-3.4645e-002	3.6051e-002	4.9e-002	-2.4391e-005
465	-3.3922e-002	3.6733e-002	4.9e-002	-2.5291e-005
466	-3.3185e-002	3.74e-002	4.9e-002	-2.6185e-005
467	-3.2435e-002	3.8053e-002	4.9e-002	-2.7074e-005
468	-3.1672e-002	3.869e-002	4.9e-002	-2.7956e-005
469	-3.0896e-002	3.9312e-002	4.9e-002	-2.8829e-005
470	-3.0108e-002	3.9918e-002	4.9e-002	-2.9692e-005
471	-2.9309e-002	4.0509e-002	4.9e-002	-3.0544e-005
472	-2.8498e-002	4.1084e-002	4.9e-002	-3.1384e-005
473	-2.7675e-002	4.1642e-002	4.9e-002	-3.221e-005
474	-2.6842e-002	4.2184e-002	4.9e-002	-3.3021e-005
475	-2.5998e-002	4.271e-002	4.9e-002	-3.3815e-005
476	-2.5143e-002	4.3218e-002	4.9e-002	-3.4593e-005
477	-2.4279e-002	4.371e-002	4.9e-002	-3.5352e-005
478	-2.3405e-002	4.4184e-002	4.9e-002	-3.6091e-005
479	-2.2522e-002	4.464e-002	4.9e-002	-3.6809e-005
480	-2.163e-002	4.5079e-002	4.9e-002	-3.7506e-005
481	-2.073e-002	4.55e-002	4.9e-002	-3.8181e-005
482	-1.9821e-002	4.5904e-002	4.9e-002	-3.8831e-005
483	-1.8904e-002	4.6289e-002	4.9e-002	-3.9457e-005
484	-1.798e-002	4.6655e-002	4.9e-002	-4.0057e-005
485	-1.7049e-002	4.7003e-002	4.9e-002	-4.0631e-005
486	-1.6111e-002	4.7333e-002	4.9e-002	-4.1178e-005
487	-1.5167e-002	4.7644e-002	4.9e-002	-4.1697e-005
488	-1.4217e-002	4.7936e-002	4.9e-002	-4.2186e-005
489	-1.3261e-002	4.8209e-002	4.9e-002	-4.2647e-005
490	-1.23e-002	4.8464e-002	4.9e-002	-4.3077e-005
491	-1.1334e-002	4.8699e-002	4.9e-002	-4.3477e-005
492	-1.0363e-002	4.8914e-002	4.9e-002	-4.3845e-005
493	-9.3886e-003	4.9111e-002	4.9e-002	-4.4182e-005
494	-8.4103e-003	4.9288e-002	4.9e-002	-4.4486e-005
495	-7.4287e-003	4.9445e-002	4.9e-002	-4.4758e-005
496	-6.4442e-003	4.9583e-002	4.9e-002	-4.4996e-005
497	-5.4571e-003	4.9701e-002	4.9e-002	-4.5201e-005
498	-4.4678e-003	4.98e-002	4.9e-002	-4.5372e-005
499	-3.4768e-003	4.9879e-002	4.9e-002	-4.551e-005
500	-2.4844e-003	4.9938e-002	4.9e-002	-4.5613e-005
501	-1.491e-003	4.9978e-002	4.9e-002	-4.5682e-005
502	-4.9708e-004	4.9998e-002	4.9e-002	-4.5716e-005
503	4.9709e-004	4.9998e-002	4.9e-002	-4.5716e-005
504	1.491e-003	4.9978e-002	4.9e-002	-4.5682e-005
505	2.4844e-003	4.9938e-002	4.9e-002	-4.5613e-005
506	3.4768e-003	4.9879e-002	4.9e-002	-4.551e-005
507	4.4678e-003	4.98e-002	4.9e-002	-4.5372e-005
508	5.4571e-003	4.9701e-002	4.9e-002	-4.5201e-005
509	6.4442e-003	4.9583e-002	4.9e-002	-4.4996e-005
510	7.4287e-003	4.9445e-002	4.9e-002	-4.4758e-005
511	8.4103e-003	4.9288e-002	4.9e-002	-4.4486e-005
512	9.3886e-003	4.9111e-002	4.9e-002	-4.4182e-005
513	1.0363e-002	4.8914e-002	4.9e-002	-4.3845e-005
514	1.1334e-002	4.8699e-002	4.9e-002	-4.3477e-005
515	1.23e-002	4.8464e-002	4.9e-002	-4.3077e-005
516	1.3261e-002	4.8209e-002	4.9e-002	-4.2647e-005
517	1.4217e-002	4.7936e-002	4.9e-002	-4.2186e-005
518	1.5167e-002	4.7644e-002	4.9e-002	-4.1697e-005
519	1.6111e-002	4.7333e-002	4.9e-002	-4.1178e-005
520	1.7049e-002	4.7003e-002	4.9e-002	-4.0631e-005
521	1.798e-002	4.6655e-002	4.9e-002	-4.0057e-005
522	1.8904e-002	4.6289e-002	4.9e-002	-3.9457e-005
523	1.9821e-002	4.5904e-002	4.9e-002	-3.8831e-005
524	2.073e-002	4.55e-002	4.9e-002	-3.8181e-005
525	2.163e-002	4.5079e-002	4.9e-002	-3.7506e-005
526	2.2522e-002	4.464e-002	4.9e-002	-3.681e-005
527	2.3405e-002	4.4184e-002	4.9e-002	-3.6091e-005
528	2.4279e-002	4.371e-002	4.9e-002	-3.5352e-005
529	2.5143e-002	4.3218e-002	4.9e-002	-3.4593e-005
530	2.5998e-002	4.271e-002	4.9e-002	-3.3815e-005
531	2.6842e-002	4.2184e-002	4.9e-002	-3.3021e-005
532	2.7675e-002	4.1642e-002	4.9e-002	-3.221e-005
533	2.8498e-002	4.1084e-002	4.9e-002	-3.1384e-005
534	2.9309e-002	4.0509e-002	4.9e-002	-3.0544e-005
535	3.0108e-002	3.9918e-002	4.9e-002	-2.9692e-005
536	3.0896e-002	3.9312e-002	4.9e-002	-2.8829e-005
537	3.1672e-002	3.869e-002	4.9e-002	-2.7956e-005
538	3.2435e-002	3.8053e-002	4.9e-002	-2.7074e-005
539	3.3185e-002	3.74e-002	4.9e-002	-2.6185e-005
540	3.3922e-002	3.6733e-002	4.9e-002	-2.529e-005
541	3.4645e-002	3.6051e-002	4.9e-002	-2.4391e-005
542	3.4641e-002	3.6055e-002	4.7e-002	-2.4393e-005
543	3.4641e-002	3.6055e-002	4.6e-002	-2.4393e-005
544	3.4641e-002	3.6055e-002	4.5e-002	-2.4393e-005
545	3.4641e-002	3.6055e-002	4.4e-002	-2.4393e-005
546	3.4641e-002	3.6055e-002	4.3e-002	-2.4393e-005
547	3.4641e-002	3.6055e-002	4.2e-002	-2.4393e-005
548	3.4641e-002	3.6055e-002	4.1e-002	-2.4393e-005
549	3.4641e-002	3.6055e-002	4.e-002	-2.4393e-005
550	3.4641e-002	3.6055e-002	3.9e-002	-2.4393e-005
551	3.4641e-002	3.6055e-002	3.8e-002	-2.4393e-005
552	3.4641e-002	3.6055e-002	3.7e-002	-2.4393e-005
553	3.4641e-002	3.6055e-002	3.6e-002	-2.4393e-005
554	3.4641e-002	3.6055e-002	3.5e-002	-2.4393e-005
555	3.4641e-002	3.6055e-002	3.4e-002	-2.4393e-005
556	3.4641e-002	3.6055e-002	3.3e-002	-2.4393e-005
557	3.4641e-002	3.6055e-002	3.2e-002	-2.4393e-005
558	3.4641e-002	3.6055e-002	3.1e-002	-2.4393e-005
559	3.4641e-002	3.6055e-002	3.e-002	-2.4393e-005
560	3.4641e-002	3.6055e-002	2.9e-002	-2.4393e-005
561	3.4641e-002	3.6055e-002	2.8e-002	-2.4393e-005
562	3.4641e-002	3.6055e-002	2.7e-002	-2.4393e-005
563	3.4641e-002	3.6055e-002	2.6e-002	-2.4393e-005
564	3.4641e-002	3.6055e-002	2.5e-002	-2.4393e-005
565	3.4641e-002	3.6055e-002	2.4e-002	-2.4393e-005
566	3.4641e-002	3.6055e-002	2.3e-002	-2.4393e-005
567	3.4641e-002	3.6055e-002	2.2e-002	-2.4393e-005
568	3.4641e-002	3.6055e-002	2.1e-002	-2.4393e-005
569	3.4641e-002	3.6055e-002	2.e-002	-2.4393e-005
570	3.4641e-002	3.6055e-002	1.9e-002	-2.4393e-005
571	3.4641e-002	3.6055e-002	1.8e-002	-2.4393e-005
572	3.4641e-002	3.6055e-002	1.7e-002	-2.4393e-005
573	3.4641e-002	3.6055e-002	1.6e-002	-2.4393e-005
574	3.4641e-002	3.6055e-002	1.5e-002	-2.4393e-005
575	3.4641e-002	3.6055e-002	1.4e-002	-2.4393e-005
576	3.4641e-002	3.6055e-002	1.3e-002	-2.4393e-005
577	3.4641e-002	3.6055e-002	1.2e-002	-2.4393e-005
578	3.4641e-002	3.6055e-002	1.1e-002	-2.4393e-005
579	3.4641e-002	3.6055e-002	1.e-002	-2.4393e-005
580	3.4641e-002	3.6055e-002	9.e-003	-2.4393e-005
581	3.4641e-002	3.6055e-002	8.e-003	-2.4393e-005
582	3.4641e-002	3.6055e-002	7.e-003	-2.4393e-005
583	3.4641e-002	3.6055e-002	6.e-003	-2.4393e-005
584	3.4641e-002	3.6055e-002	5.e-003	-2.4393e-005
585	3.4641e-002	3.6055e-002	3.e-003	-2.4394e-005
586	3.4641e-002	3.6055e-002	2.e-003	-2.4393e-005
587	3.4641e-002	3.6055e-002	9.9999e-004	-2.4392e-005
588	3.3922e-002	3.6733e-002	9.9999e-004	-2.5291e-005
589	3.3185e-002	3.74e-002	1.e-003	-2.6185e-005
590	3.2435e-002	3.8053e-002	1.e-003	-2.7074e-005
591	3.1672e-002	3.869e-002	1.e-003	-2.7956e-005
592	3.0896e-002	3.9312e-002	9.9999e-004	-2.8829e-005
593	3.0108e-002	3.9918e-002	1.e-003	-2.9692e-005
594	2.9309e-002	4.0509e-002	9.9999e-004	-3.0544e-005
595	2.8498e-002	4.1084e-002	1.e-003	-3.1384e-005
596	2.7675e-002	4.1642e-002	9.9999e-004	-3.221e-005
597	2.6842e-002	4.2184e-002	1.e-003	-3.3021e-005
598	2.5998e-002	4.271e-002	9.9999e-004	-3.3815e-005
599	2.5143e-002	4.3218e-002	1.e-003	-3.4593e-005
600	2.4279e-002	4.371e-002	9.9999e-004	-3.5352e-005
601	2.3405e-002	4.4184e-002	1.e-003	-3.6091e-005
602	2.2522e-002	4.464e-002	9.9999e-004	-3.681e-005
603	2.163e-002	4.5079e-002	1.e-003	-3.7507e-005
604	2.073e-002	4.55e-002	9.9999e-004	-3.8181e-005
605	1.9821e-002	4.5904e-002	1.e-003	-3.8831e-005
606	1.8904e-002	4.6289e-002	9.9999e-004	-3.9457e-005
607	1.798e-002	4.6655e-002	1.e-003	-4.0057e-005
608	1.7049e-002	4.7003e-002	9.9999e-004	-4.0631e-005
609	1.6111e-002	4.7333e-002	1.e-003	-4.1178e-005
610	1.5167e-002	4.7644e-002	9.9999e-004	-4.1697e-005
611	1.4217e-002	4.7936e-002	1.e-003	-4.2187e-005
612	1.3261e-002	4.8209e-002	9.9999e-004	-4.2647e-005
613	1.23e-002	4.8464e-002	1.e-003	-4.3077e-005
614	1.1334e-002	4.8699e-002	9.9999e-004	-4.3477e-005
615	1.0363e-002	4.8914e-002	1.e-003	-4.3845e-005
616	9.3886e-003	4.9111e-002	9.9999e-004	-4.4182e-005
617	8.4103e-003	4.9288e-002	1.e-003	-4.4486e-005
618	7.4287e-003	4.9445e-002	9.9999e-004	-4.4758e-005
619	6.4442e-003	4.9583e-002	1.e-003	-4.4996e-005
620	5.4571e-003	4.9701e-002	9.9999e-004	-4.5201e-005
621	4.4678e-003	4.98e-002	1.e-003	-4.5372e-005
622	3.4768e-003	4.9879e-002	9.9999e-004	-4.551e-005
623	2.4844e-003	4.9938e-002	1.e-003	-4.5613e-005
624	1.491e-003	4.9978e-002	9.9999e-004	-4.5682e-005
625	4.9708e-004	4.9998e-002	1.e-003	-4.5716e-005
626	-4.9708e-004	4.9998e-002	9.9999e-004	-4.5716e-005
627	-1.491e-003	4.9978e-002	1.e-003	-4.5682e-005
628	-2.4844e-003	4.9938e-002	9.9999e-004	-4.5613e-005
629	-3.4768e-003	4.9879e-002	1.e-003	-4.551e-005
630	-4.4678e-003	4.98e-002	9.9999e-004	-4.5372e-005
631	-5.4571e-003	4.9701e-002	1.e-003	-4.5201e-005
632	-6.4442e-003	4.9583e-002	9.9999e-004	-4.4996e-005
633	-7.4287e-003	4.9445e-002	1.e-003	-4.4758e-005
634	-8.4103e-003	4.9288e-002	9.9999e-004	-4.4486e-005
635	-9.3886e-003	4.9111e-002	1.e-003	-4.4182e-005
636	-1.0363e-002	4.8914e-002	9.9999e-004	-4.3845e-005
637	-1.1334e-002	4.8699e-002	1.e-003	-4.3477e-005
638	-1.23e-002	4.8464e-002	9.9999e-004	-4.3077e-005
639	-1.3261e-002	4.8209e-002	1.e-003	-4.2647e-005
640	-1.4217e-002	4.7936e-002	9.9999e-004	-4.2187e-005
641	-1.5167e-002	4.7644e-002	1.e-003	-4.1697e-005
642	-1.6111e-002	4.7333e-002	9.9999e-004	-4.1178e-005
643	-1.7049e-002	4.7003e-002	1.e-003	-4.0631e-005
644	-1.798e-002	4.6655e-002	9.9999e-004	-4.0057e-005
645	-1.8904e-002	4.6289e-002	1.e-003	-3.9457e-005
646	-1.9821e-002	4.5904e-002	9.9999e-004	-3.8831e-005
647	-2.073e-002	4.55e-002	1.e-003	-3.8181e-005
648	-2.163e-002	4.5079e-002	9.9999e-004	-3.7507e-005
649	-2.2522e-002	4.464e-002	1.e-003	-3.681e-005
650	-2.3405e-002	4.4184e-002	9.9999e-004	-3.6091e-005
651	-2.4279e-002	4.371e-002	1.e-003	-3.5352e-005
652	-2.5143e-002	4.3218e-002	9.9999e-004	-3.4593e-005
653	-2.5998e-002	4.271e-002	1.e-003	-3.3815e-005
654	-2.6842e-002	4.2184e-002	9.9999e-004	-3.3021e-005
655	-2.7675e-002	4.1642e-002	1.e-003	-3.221e-005
656	-2.8498e-002	4.1084e-002	9.9999e-004	-3.1384e-005
657	-2.9309e-002	4.0509e-002	1.e-003	-3.0544e-005
658	-3.0108e-002	3.9918e-002	9.9999e-004	-2.9692e-005
659	-3.0896e-002	3.9312e-002	1.e-003	-2.8829e-005
660	-3.1672e-002	3.869e-002	9.9999e-004	-2.7956e-005
661	-3.2435e-002	3.8053e-002	1.e-003	-2.7074e-005
662	-3.3185e-002	3.74e-002	1.e-003	-2.6185e-005
663	-3.3922e-002	3.6733e-002	1.e-003	-2.5291e-005
664	-3.4645e-002	3.6051e-002	1.e-003	-2.4391e-005
665	-3.4641e-002	3.6055e-002	3.e-003	-2.4393e-005
666	-3.4641e-002	3.6055e-002	4.e-003	-2.4393e-005
667	-3.4641e-002	3.6055e-002	5.e-003	-2.4393e-005
668	-3.4641e-002	3.6055e-002	6.e-003	-2.4393e-005
669	-3.4641e-002	3.6055e-002	7.e-003	-2.4393e-005
670	-3.4641e-002	3.6055e-002	8.e-003	-2.4393e-005
671	-3.4641e-002	3.6055e-002	9.e-003	-2.4393e-005
672	-3.4641e-002	3.6055e-002	1.e-002	-2.4393e-005
673	-3.4641e-002	3.6055e-002	1.1e-002	-2.4393e-005
674	-3.4641e-002	3.6055e-002	1.2e-002	-2.4393e-005
675	-3.4641e-002	3.6055e-002	1.3e-002	-2.4393e-005
676	-3.4641e-002	3.6055e-002	1.4e-002	-2.4393e-005
677	-3.4641e-002	3.6055e-002	1.5e-002	-2.4393e-005
678	-3.4641e-002	3.6055e-002	1.6e-002	-2.4393e-005
679	-3.4641e-002	3.6055e-002	1.7e-002	-2.4393e-005
680	-3.4641e-002	3.6055e-002	1.8e-002	-2.4393e-005
681	-3.4641e-002	3.6055e-002	1.9e-002	-2.4393e-005
682	-3.4641e-002	3.6055e-002	2.e-002	-2.4393e-005
683	-3.4641e-002	3.6055e-002	2.1e-002	-2.4393e-005
684	-3.4641e-002	3.6055e-002	2.2e-002	-2.4393e-005
685	-3.4641e-002	3.6055e-002	2.3e-002	-2.4393e-005
686	-3.4641e-002	3.6055e-002	2.4e-002	-2.4393e-005
687	-3.4641e-002	3.6055e-002	2.5e-002	-2.4393e-005
688	-3.4641e-002	3.6055e-002	2.6e-002	-2.4393e-005
689	-3.4641e-002	3.6055e-002	2.7e-002	-2.4393e-005
690	-3.4641e-002	3.6055e-002	2.8e-002	-2.4393e-005
691	-3.4641e-002	3.6055e-002	2.9e-002	-2.4393e-005
692	-3.4641e-002	3.6055e-002	3.e-002	-2.4393e-005
693	-3.4641e-002	3.6055e-002	3.1e-002	-2.4393e-005
694	-3.4641e-002	3.6055e-002	3.2e-002	-2.4393e-005
695	-3.4641e-002	3.6055e-002	3.3e-002	-2.4393e-005
696	-3.4641e-002	3.6055e-002	3.4e-002	-2.4393e-005
697	-3.4641e-002	3.6055e-002	3.5e-002	-2.4393e-005
698	-3.4641e-002	3.6055e-002	3.6e-002	-2.4393e-005
699	-3.4641e-002	3.6055e-002	3.7e-002	-2.4393e-005
700	-3.4641e-002	3.6055e-002	3.8e-002	-2.4393e-005
701	-3.4641e-002	3.6055e-002	3.9e-002	-2.4393e-005
702	-3.4641e-002	3.6055e-002	4.e-002	-2.4394e-005
703	-3.4641e-002	3.6055e-002	4.1e-002	-2.4394e-005
704	-3.4641e-002	3.6055e-002	4.2e-002	-2.4394e-005
705	-3.4641e-002	3.6055e-002	4.3e-002	-2.4394e-005
706	-3.4641e-002	3.6055e-002	4.4e-002	-2.4394e-005
707	-3.4641e-002	3.6055e-002	4.5e-002	-2.4394e-005
708	-3.4641e-002	3.6055e-002	4.6e-002	-2.4394e-005
709	-3.4641e-002	3.6055e-002	4.7e-002	-2.4394e-005
710	-3.4641e-002	3.6055e-002	4.8e-002	-2.4393e-005
711	3.3922e-002	3.6733e-002	2.e-003	-2.5291e-005
712	3.3185e-002	3.74e-002	2.e-003	-2.6185e-005
713	3.2435e-002	3.8053e-002	2.e-003	-2.7074e-005
714	3.1672e-002	3.869e-002	2.e-003	-2.7956e-005
715	3.0896e-002	3.9312e-002	2.e-003	-2.8829e-005
716	3.0108e-002	3.9918e-002	2.e-003	-2.9692e-005
717	2.9309e-002	4.0509e-002	2.e-003	-3.0544e-005
718	2.8498e-002	4.1084e-002	2.e-003	-3.1384e-005
719	2.7675e-002	4.1642e-002	2.e-003	-3.221e-005
720	2.6842e-002	4.2184e-002	2.e-003	-3.3021e-005
721	2.5998e-002	4.271e-002	2.e-003	-3.3815e-005
722	2.5143e-002	4.3218e-002	2.e-003	-3.4593e-005
723	2.4279e-002	4.371e-002	2.e-003	-3.5352e-005
724	2.3405e-002	4.4184e-002	2.e-003	-3.6091e-005
725	2.2522e-002	4.464e-002	2.e-003	-3.681e-005
726	2.163e-002	4.5079e-002	2.e-003	-3.7507e-005
727	2.073e-002	4.55e-002	2.e-003	-3.8181e-005
728	1.9821e-002	4.5904e-002	2.e-003	-3.8831e-005
729	1.8904e-002	4.6289e-002	2.e-003	-3.9457e-005
730	1.798e-002	4.6655e-002	2.e-003	-4.0057e-005
731	1.7049e-002	4.7003e-002	2.e-003	-4.0631e-005
732	1.6111e-002	4.7333e-002	2.e-003	-4.1178e-005
733	1.5167e-002	4.7644e-002	2.e-003	-4.1697e-005
734	1.4217e-002	4.7936e-002	2.e-003	-4.2187e-005
735	1.3261e-002	4.8209e-002	2.e-003	-4.2647e-005
736	1.23e-002	4.8464e-002	2.e-003	-4.3077e-005
737	1.1334e-002	4.8699e-002	2.e-003	-4.3477e-005
738	1.0363e-002	4.8914e-002	2.e-003	-4.3845e-005
739	9.3886e-003	4.9111e-002	2.e-003	-4.4182e-005
740	8.4103e-003	4.9288e-002	2.e-003	-4.4486e-005
741	7.4287e-003	4.9445e-002	2.e-003	-4.4758e-005
742	6.4441e-003	4.9583e-002	2.e-003	-4.4996e-005
743	5.4571e-003	4.9701e-002	2.e-003	-4.5201e-005
744	4.4678e-003	4.98e-002	2.e-003	-4.5372e-005
745	3.4768e-003	4.9879e-002	2.e-003	-4.551e-005
746	2.4844e-003	4.9938e-002	2.e-003	-4.5613e-005
747	1.491e-003	4.9978e-002	2.e-003	-4.5682e-005
748	4.9706e-004	4.9998e-002	2.e-003	-4.5716e-005
749	-4.9709e-004	4.9998e-002	2.e-003	-4.5716e-005
750	-1.4911e-003	4.9978e-002	2.e-003	-4.5682e-005
751	-2.4844e-003	4.9938e-002	2.e-003	-4.5613e-005
752	-3.4768e-003	4.9879e-002	2.e-003	-4.551e-005
753	-4.4678e-003	4.98e-002	2.e-003	-4.5372e-005
754	-5.4571e-003	4.9701e-002	2.e-003	-4.5201e-005
755	-6.4442e-003	4.9583e-002	2.e-003	-4.4996e-005
756	-7.4287e-003	4.9445e-002	2.e-003	-4.4758e-005
757	-8.4103e-003	4.9288e-002	2.e-003	-4.4486e-005
758	-9.3886e-003	4.9111e-002	2.e-003	-4.4182e-005
759	-1.0363e-002	4.8914e-002	2.e-003	-4.3845e-005
760	-1.1334e-002	4.8699e-002	2.e-003	-4.3477e-005
761	-1.23e-002	4.8464e-002	2.e-003	-4.3077e-005
762	-1.3261e-002	4.8209e-002	2.e-003	-4.2647e-005
763	-1.4217e-002	4.7936e-002	2.e-003	-4.2187e-005
764	-1.5167e-002	4.7644e-002	2.e-003	-4.1697e-005
765	-1.6111e-002	4.7333e-002	2.e-003	-4.1178e-005
766	-1.7049e-002	4.7003e-002	2.e-003	-4.0631e-005
767	-1.798e-002	4.6655e-002	2.e-003	-4.0057e-005
768	-1.8904e-002	4.6289e-002	2.e-003	-3.9457e-005
769	-1.9821e-002	4.5904e-002	2.e-003	-3.8831e-005
770	-2.073e-002	4.55e-002	2.e-003	-3.8181e-005
771	-2.163e-002	4.5079e-002	2.e-003	-3.7507e-005
772	-2.2522e-002	4.464e-002	2.e-003	-3.681e-005
773	-2.3405e-002	4.4184e-002	2.e-003	-3.6091e-005
774	-2.4279e-002	4.371e-002	2.e-003	-3.5352e-005
775	-2.5143e-002	4.3218e-002	2.e-003	-3.4593e-005
776	-2.5998e-002	4.271e-002	2.e-003	-3.3815e-005
777	-2.6842e-002	4.2184e-002	2.e-003	-3.3021e-005
778	-2.7675e-002	4.1642e-002	2.e-003	-3.221e-005
779	-2.8498e-002	4.1084e-002	2.e-003	-3.1384e-005
780	-2.9309e-002	4.0509e-002	2.e-003	-3.0544e-005
781	-3.0108e-002	3.9918e-002	2.e-003	-2.9692e-005
782	-3.0896e-002	3.9312e-002	2.e-003	-2.8829e-005
783	-3.2435e-002	3.8053e-002	2.e-003	-2.7074e-005
784	-3.3185e-002	3.74e-002	2.e-003	-2.6185e-005
785	-3.3922e-002	3.6733e-002	2.e-003	-2.5291e-005
786	-3.3922e-002	3.6733e-002	3.e-003	-2.5291e-005
787	-3.3922e-002	3.6733e-002	4.e-003	-2.5291e-005
788	-3.3922e-002	3.6733e-002	5.e-003	-2.5291e-005
789	-3.3922e-002	3.6733e-002	6.e-003	-2.5291e-005
790	-3.3922e-002	3.6733e-002	7.e-003	-2.5291e-005
791	-3.3922e-002	3.6733e-002	8.e-003	-2.5291e-005
792	-3.3922e-002	3.6733e-002	9.e-003	-2.5291e-005
793	-3.3922e-002	3.6733e-002	1.e-002	-2.5291e-005
794	-3.3922e-002	3.6733e-002	1.1e-002	-2.5292e-005
795	-3.3922e-002	3.6733e-002	1.2e-002	-2.5291e-005
796	-3.3922e-002	3.6733e-002	1.3e-002	-2.5291e-005
797	-3.3922e-002	3.6733e-002	1.4e-002	-2.5291e-005
798	-3.3922e-002	3.6733e-002	1.5e-002	-2.5291e-005
799	-3.3922e-002	3.6733e-002	1.6e-002	-2.5291e-005
800	-3.3922e-002	3.6733e-002	1.7e-002	-2.5291e-005
801	-3.3922e-002	3.6733e-002	1.8e-002	-2.5291e-005
802	-3.3922e-002	3.6733e-002	1.9e-002	-2.5291e-005
803	-3.3922e-002	3.6733e-002	2.e-002	-2.5291e-005
804	-3.3922e-002	3.6733e-002	2.1e-002	-2.5291e-005
805	-3.3922e-002	3.6733e-002	2.2e-002	-2.5291e-005
806	-3.3922e-002	3.6733e-002	2.3e-002	-2.5291e-005
807	-3.3922e-002	3.6733e-002	2.4e-002	-2.5291e-005
808	-3.3922e-002	3.6733e-002	2.5e-002	-2.5291e-005
809	-3.3921e-002	3.6733e-002	2.6e-002	-2.5291e-005
810	-3.3921e-002	3.6733e-002	2.7e-002	-2.5291e-005
811	-3.3921e-002	3.6733e-002	2.8e-002	-2.5291e-005
812	-3.3921e-002	3.6733e-002	2.9e-002	-2.5291e-005
813	-3.3921e-002	3.6733e-002	3.e-002	-2.5291e-005
814	-3.3921e-002	3.6733e-002	3.1e-002	-2.5291e-005
815	-3.3921e-002	3.6734e-002	3.2e-002	-2.5291e-005
816	-3.3921e-002	3.6734e-002	3.3e-002	-2.5291e-005
817	-3.3921e-002	3.6734e-002	3.4e-002	-2.5291e-005
818	-3.3921e-002	3.6734e-002	3.5e-002	-2.5291e-005
819	-3.3921e-002	3.6734e-002	3.6e-002	-2.5291e-005
820	-3.3921e-002	3.6734e-002	3.7e-002	-2.5291e-005
821	-3.3921e-002	3.6734e-002	3.8e-002	-2.5291e-005
822	-3.3921e-002	3.6734e-002	3.9e-002	-2.5291e-005
823	-3.3921e-002	3.6734e-002	4.e-002	-2.5291e-005
824	-3.3921e-002	3.6734e-002	4.1e-002	-2.5291e-005
825	-3.3921e-002	3.6734e-002	4.2e-002	-2.5291e-005
826	-3.392e-002	3.6734e-002	4.3e-002	-2.5291e-005
827	-3.392e-002	3.6734e-002	4.4e-002	-2.5291e-005
828	-3.392e-002	3.6734e-002	4.5e-002	-2.5291e-005
829	-3.392e-002	3.6735e-002	4.6e-002	-2.5291e-005
830	-3.392e-002	3.6735e-002	4.7e-002	-2.5292e-005
831	-3.392e-002	3.6735e-002	4.8e-002	-2.5292e-005
832	-3.3185e-002	3.74e-002	4.8e-002	-2.6185e-005
833	-3.2435e-002	3.8053e-002	4.8e-002	-2.7074e-005
834	-3.1672e-002	3.869e-002	4.8e-002	-2.7956e-005
835	-3.0896e-002	3.9312e-002	4.8e-002	-2.8829e-005
836	-3.0108e-002	3.9918e-002	4.8e-002	-2.9692e-005
837	-2.9309e-002	4.0509e-002	4.8e-002	-3.0544e-005
838	-2.7675e-002	4.1642e-002	4.8e-002	-3.221e-005
839	-2.5998e-002	4.271e-002	4.8e-002	-3.3815e-005
840	-2.4279e-002	4.371e-002	4.8e-002	-3.5352e-005
841	-2.2522e-002	4.464e-002	4.8e-002	-3.681e-005
842	-2.073e-002	4.55e-002	4.8e-002	-3.8181e-005
843	-1.8904e-002	4.6289e-002	4.8e-002	-3.9457e-005
844	-1.7049e-002	4.7003e-002	4.8e-002	-4.0631e-005
845	-1.5167e-002	4.7644e-002	4.8e-002	-4.1697e-005
846	-1.3261e-002	4.8209e-002	4.8e-002	-4.2647e-005
847	-1.1334e-002	4.8699e-002	4.8e-002	-4.3477e-005
848	-9.3886e-003	4.9111e-002	4.8e-002	-4.4182e-005
849	-7.4287e-003	4.9445e-002	4.8e-002	-4.4758e-005
850	-5.4571e-003	4.9701e-002	4.8e-002	-4.5201e-005
851	-3.4768e-003	4.9879e-002	4.8e-002	-4.551e-005
852	-1.491e-003	4.9978e-002	4.8e-002	-4.5682e-005
853	4.971e-004	4.9998e-002	4.8e-002	-4.5716e-005
854	2.4844e-003	4.9938e-002	4.8e-002	-4.5613e-005
855	4.4678e-003	4.98e-002	4.8e-002	-4.5372e-005
856	6.4442e-003	4.9583e-002	4.8e-002	-4.4996e-005
857	8.4103e-003	4.9288e-002	4.8e-002	-4.4486e-005
858	1.0363e-002	4.8914e-002	4.8e-002	-4.3845e-005
859	1.23e-002	4.8464e-002	4.8e-002	-4.3077e-005
860	1.4217e-002	4.7936e-002	4.8e-002	-4.2186e-005
861	1.6111e-002	4.7333e-002	4.8e-002	-4.1178e-005
862	1.798e-002	4.6655e-002	4.8e-002	-4.0057e-005
863	1.9821e-002	4.5904e-002	4.8e-002	-3.8831e-005
864	2.163e-002	4.5079e-002	4.8e-002	-3.7506e-005
865	2.3405e-002	4.4184e-002	4.8e-002	-3.6091e-005
866	2.5143e-002	4.3218e-002	4.8e-002	-3.4593e-005
867	2.6842e-002	4.2184e-002	4.8e-002	-3.3021e-005
868	2.8498e-002	4.1084e-002	4.8e-002	-3.1384e-005
869	3.0108e-002	3.9918e-002	4.8e-002	-2.9692e-005
870	3.1672e-002	3.869e-002	4.8e-002	-2.7956e-005
871	3.2435e-002	3.8053e-002	4.8e-002	-2.7074e-005
872	3.3185e-002	3.74e-002	4.8e-002	-2.6185e-005
873	3.3922e-002	3.6733e-002	4.8e-002	-2.5291e-005
874	3.3922e-002	3.6733e-002	4.7e-002	-2.5291e-005
875	3.3922e-002	3.6733e-002	4.6e-002	-2.5291e-005
876	3.3922e-002	3.6733e-002	4.5e-002	-2.5291e-005
877	3.3922e-002	3.6733e-002	4.4e-002	-2.5291e-005
878	3.3922e-002	3.6733e-002	4.3e-002	-2.5291e-005
879	3.3922e-002	3.6733e-002	4.2e-002	-2.5291e-005
880	3.3922e-002	3.6733e-002	4.1e-002	-2.5291e-005
881	3.3922e-002	3.6733e-002	4.e-002	-2.5291e-005
882	3.3922e-002	3.6733e-002	3.9e-002	-2.5291e-005
883	3.3922e-002	3.6733e-002	3.8e-002	-2.5291e-005
884	3.3922e-002	3.6733e-002	3.7e-002	-2.5291e-005
885	3.3922e-002	3.6733e-002	3.6e-002	-2.5291e-005
886	3.3922e-002	3.6733e-002	3.5e-002	-2.5291e-005
887	3.3922e-002	3.6733e-002	3.4e-002	-2.5291e-005
888	3.3922e-002	3.6733e-002	3.3e-002	-2.5291e-005
889	3.3922e-002	3.6733e-002	3.2e-002	-2.5291e-005
890	3.3922e-002	3.6733e-002	3.1e-002	-2.5291e-005
891	3.3922e-002	3.6733e-002	3.e-002	-2.5291e-005
892	3.3922e-002	3.6733e-002	2.9e-002	-2.5291e-005
893	3.3922e-002	3.6733e-002	2.8e-002	-2.5291e-005
894	3.3922e-002	3.6733e-002	2.7e-002	-2.5291e-005
895	3.3922e-002	3.6733e-002	2.6e-002	-2.5291e-005
896	3.3922e-002	3.6733e-002	2.5e-002	-2.5291e-005
897	3.3922e-002	3.6733e-002	2.4e-002	-2.5291e-005
898	3.3922e-002	3.6733e-002	2.3e-002	-2.5291e-005
899	3.3922e-002	3.6733e-002	2.2e-002	-2.5291e-005
900	3.3922e-002	3.6733e-002	2.1e-002	-2.5291e-005
901	3.3922e-002	3.6733e-002	2.e-002	-2.5291e-005
902	3.3922e-002	3.6733e-002	1.9e-002	-2.5291e-005
903	3.3922e-002	3.6733e-002	1.8e-002	-2.5291e-005
904	3.3921e-002	3.6733e-002	1.7e-002	-2.5291e-005
905	3.3921e-002	3.6733e-002	1.6e-002	-2.5291e-005
906	3.3921e-002	3.6733e-002	1.5e-002	-2.5291e-005
907	3.3921e-002	3.6733e-002	1.4e-002	-2.5291e-005
908	3.3921e-002	3.6733e-002	1.3e-002	-2.5291e-005
909	3.3921e-002	3.6734e-002	1.2e-002	-2.5291e-005
910	3.3921e-002	3.6734e-002	1.1e-002	-2.5291e-005
911	3.3921e-002	3.6734e-002	1.e-002	-2.5291e-005
912	3.3921e-002	3.6734e-002	9.0001e-003	-2.5291e-005
913	3.3921e-002	3.6734e-002	8.0001e-003	-2.5291e-005
914	3.3921e-002	3.6734e-002	7.0001e-003	-2.5291e-005
915	3.3921e-002	3.6734e-002	6.0001e-003	-2.5291e-005
916	3.3921e-002	3.6734e-002	5.0001e-003	-2.5291e-005
917	3.3921e-002	3.6734e-002	4.0001e-003	-2.5291e-005
918	3.3921e-002	3.6734e-002	3.0001e-003	-2.5291e-005
919	-3.2435e-002	3.8053e-002	4.7e-002	-2.7074e-005
920	-3.1672e-002	3.869e-002	4.7e-002	-2.7956e-005
921	-3.0896e-002	3.9312e-002	4.7e-002	-2.8829e-005
922	-3.0108e-002	3.9919e-002	4.7e-002	-2.9692e-005
923	-2.9309e-002	4.0509e-002	4.7e-002	-3.0544e-005
924	-2.8498e-002	4.1084e-002	4.7e-002	-3.1384e-005
925	-2.7675e-002	4.1642e-002	4.7e-002	-3.221e-005
926	-2.6842e-002	4.2184e-002	4.7e-002	-3.3021e-005
927	-2.5998e-002	4.271e-002	4.7e-002	-3.3815e-005
928	-2.5143e-002	4.3218e-002	4.7e-002	-3.4593e-005
929	-2.4279e-002	4.371e-002	4.7e-002	-3.5352e-005
930	-2.3405e-002	4.4184e-002	4.7e-002	-3.6091e-005
931	-2.2522e-002	4.464e-002	4.7e-002	-3.681e-005
932	-2.163e-002	4.5079e-002	4.7e-002	-3.7506e-005
933	-2.073e-002	4.55e-002	4.7e-002	-3.8181e-005
934	-1.9821e-002	4.5904e-002	4.7e-002	-3.8831e-005
935	-1.8904e-002	4.6289e-002	4.7e-002	-3.9457e-005
936	-1.798e-002	4.6655e-002	4.7e-002	-4.0057e-005
937	-1.7049e-002	4.7003e-002	4.7e-002	-4.0631e-005
938	-1.6111e-002	4.7333e-002	4.7e-002	-4.1178e-005
939	-1.5167e-002	4.7644e-002	4.7e-002	-4.1697e-005
940	-1.4217e-002	4.7936e-002	4.7e-002	-4.2186e-005
941	-1.3261e-002	4.8209e-002	4.7e-002	-4.2647e-005
942	-1.23e-002	4.8464e-002	4.7e-002	-4.3077e-005
943	-1.1334e-002	4.8699e-002	4.7e-002	-4.3477e-005
944	-1.0363e-002	4.8914e-002	4.7e-002	-4.3845e-005
945	-9.3886e-003	4.9111e-002	4.7e-002	-4.4182e-005
946	-8.4103e-003	4.9288e-002	4.7e-002	-4.4486e-005
947	-7.4287e-003	4.9445e-002	4.7e-002	-4.4758e-005
948	-6.4441e-003	4.9583e-002	4.7e-002	-4.4996e-005
949	-5.4571e-003	4.9701e-002	4.7e-002	-4.5201e-005
950	-4.4678e-003	4.98e-002	4.7e-002	-4.5372e-005
951	-3.4768e-003	4.9879e-002	4.7e-002	-4.551e-005
952	-2.4844e-003	4.9938e-002	4.7e-002	-4.5613e-005
953	-1.4911e-003	4.9978e-002	4.7e-002	-4.5682e-005
954	-4.9706e-004	4.9998e-002	4.7e-002	-4.5716e-005
955	4.9706e-004	4.9998e-002	4.7e-002	-4.5716e-005
956	1.4911e-003	4.9978e-002	4.7e-002	-4.5682e-005
957	2.4844e-003	4.9938e-002	4.7e-002	-4.5613e-005
958	3.4768e-003	4.9879e-002	4.7e-002	-4.551e-005
959	4.4678e-003	4.98e-002	4.7e-002	-4.5372e-005
960	5.4571e-003	4.9701e-002	4.7e-002	-4.5201e-005
961	6.4441e-003	4.9583e-002	4.7e-002	-4.4996e-005
962	7.4287e-003	4.9445e-002	4.7e-002	-4.4758e-005
963	8.4103e-003	4.9288e-002	4.7e-002	-4.4486e-005
964	9.3886e-003	4.9111e-002	4.7e-002	-4.4182e-005
965	1.0363e-002	4.8914e-002	4.7e-002	-4.3845e-005
966	1.1334e-002	4.8699e-002	4.7e-002	-4.3477e-005
967	1.23e-002	4.8464e-002	4.7e-002	-4.3077e-005
968	1.3261e-002	4.8209e-002	4.7e-002	-4.2647e-005
969	1.4217e-002	4.7936e-002	4.7e-002	-4.2186e-005
970	1.5167e-002	4.7644e-002	4.7e-002	-4.1697e-005
971	1.6111e-002	4.7333e-002	4.7e-002	-4.1178e-005
972	1.7049e-002	4.7003e-002	4.7e-002	-4.0631e-005
973	1.798e-002	4.6655e-002	4.7e-002	-4.0057e-005
974	1.8904e-002	4.6289e-002	4.7e-002	-3.9457e-005
975	1.9821e-002	4.5904e-002	4.7e-002	-3.8831e-005
976	2.073e-002	4.55e-002	4.7e-002	-3.8181e-005
977	2.163e-002	4.5079e-002	4.7e-002	-3.7506e-005
978	2.2522e-002	4.464e-002	4.7e-002	-3.681e-005
979	2.3405e-002	4.4184e-002	4.7e-002	-3.6091e-005
980	2.4279e-002	4.371e-002	4.7e-002	-3.5352e-005
981	2.5143e-002	4.3218e-002	4.7e-002	-3.4593e-005
982	2.5998e-002	4.271e-002	4.7e-002	-3.3815e-005
983	2.6842e-002	4.2184e-002	4.7e-002	-3.3021e-005
984	2.7675e-002	4.1642e-002	4.7e-002	-3.221e-005
985	2.8498e-002	4.1084e-002	4.7e-002	-3.1384e-005
986	2.9309e-002	4.0509e-002	4.7e-002	-3.0544e-005
987	3.0108e-002	3.9918e-002	4.7e-002	-2.9692e-005
988	3.0896e-002	3.9312e-002	4.7e-002	-2.8829e-005
989	3.1672e-002	3.869e-002	4.7e-002	-2.7956e-005
990	3.2435e-002	3.8053e-002	4.7e-002	-2.7074e-005
991	3.3185e-002	3.74e-002	4.7e-002	-2.6185e-005
992	3.3185e-002	3.74e-002	4.6e-002	-2.6185e-005
993	3.3185e-002	3.74e-002	4.5e-002	-2.6185e-005
994	3.3185e-002	3.74e-002	4.4e-002	-2.6185e-005
995	3.3185e-002	3.74e-002	4.3e-002	-2.6185e-005
996	3.3185e-002	3.74e-002	4.2e-002	-2.6185e-005
997	3.3185e-002	3.74e-002	4.1e-002	-2.6185e-005
998	3.3185e-002	3.74e-002	4.e-002	-2.6185e-005
999	3.3185e-002	3.74e-002	3.9e-002	-2.6185e-005
1000	3.3185e-002	3.74e-002	3.8e-002	-2.6185e-005
1001	3.3185e-002	3.74e-002	3.7e-002	-2.6185e-005
1002	3.3185e-002	3.74e-002	3.6e-002	-2.6185e-005
1003	3.3185e-002	3.74e-002	3.5e-002	-2.6185e-005
1004	3.3185e-002	3.74e-002	3.4e-002	-2.6185e-005
1005	3.3185e-002	3.74e-002	3.3e-002	-2.6185e-005
1006	3.3185e-002	3.74e-002	3.2e-002	-2.6185e-005
1007	3.3185e-002	3.74e-002	3.1e-002	-2.6185e-005
1008	3.3185e-002	3.74e-002	3.e-002	-2.6185e-005
1009	3.3185e-002	3.74e-002	2.9e-002	-2.6185e-005
1010	3.3185e-002	3.74e-002	2.8e-002	-2.6185e-005
1011	3.3185e-002	3.74e-002	2.7e-002	-2.6185e-005
1012	3.3185e-002	3.74e-002	2.6e-002	-2.6185e-005
1013	3.3185e-002	3.74e-002	2.5e-002	-2.6185e-005
1014	3.3185e-002	3.74e-002	2.4e-002	-2.6185e-005
1015	3.3185e-002	3.74e-002	2.3e-002	-2.6185e-005
1016	3.3185e-002	3.74e-002	2.2e-002	-2.6185e-005
1017	3.3185e-002	3.74e-002	2.1e-002	-2.6185e-005
1018	3.3185e-002	3.74e-002	2.e-002	-2.6185e-005
1019	3.3185e-002	3.74e-002	1.9e-002	-2.6185e-005
1020	3.3186e-002	3.7399e-002	1.8e-002	-2.6185e-005
1021	3.3186e-002	3.7399e-002	1.7e-002	-2.6185e-005
1022	3.3186e-002	3.7399e-002	1.6e-002	-2.6185e-005
1023	3.3186e-002	3.7399e-002	1.5e-002	-2.6185e-005
1024	3.3186e-002	3.7399e-002	1.4e-002	-2.6185e-005
1025	3.3186e-002	3.7399e-002	1.3e-002	-2.6185e-005
1026	3.3186e-002	3.7399e-002	1.2e-002	-2.6185e-005
1027	3.3186e-002	3.7399e-002	1.1e-002	-2.6185e-005
1028	3.3186e-002	3.7399e-002	1.e-002	-2.6185e-005
1029	3.3186e-002	3.7399e-002	8.9999e-003	-2.6185e-005
1030	3.3186e-002	3.7399e-002	7.9999e-003	-2.6185e-005
1031	3.3187e-002	3.7399e-002	6.9999e-003	-2.6185e-005
1032	3.3187e-002	3.7398e-002	5.9999e-003	-2.6185e-005
1033	3.3187e-002	3.7398e-002	4.9999e-003	-2.6185e-005
1034	3.3187e-002	3.7398e-002	3.9999e-003	-2.6185e-005
1035	3.3187e-002	3.7398e-002	3.e-003	-2.6184e-005
1036	3.2435e-002	3.8053e-002	3.e-003	-2.7074e-005
1037	3.1672e-002	3.869e-002	3.e-003	-2.7956e-005
1038	3.0896e-002	3.9312e-002	3.e-003	-2.8829e-005
1039	3.0108e-002	3.9918e-002	3.e-003	-2.9692e-005
1040	2.9309e-002	4.0509e-002	3.e-003	-3.0544e-005
1041	2.8498e-002	4.1084e-002	3.e-003	-3.1384e-005
1042	2.7675e-002	4.1642e-002	3.e-003	-3.221e-005
1043	2.6842e-002	4.2184e-002	3.e-003	-3.3021e-005
1044	2.5998e-002	4.271e-002	3.e-003	-3.3815e-005
1045	2.5143e-002	4.3218e-002	3.e-003	-3.4593e-005
1046	2.4279e-002	4.371e-002	3.e-003	-3.5352e-005
1047	2.3405e-002	4.4184e-002	3.e-003	-3.6091e-005
1048	2.2522e-002	4.464e-002	3.e-003	-3.681e-005
1049	2.163e-002	4.5079e-002	3.e-003	-3.7507e-005
1050	2.073e-002	4.55e-002	3.e-003	-3.8181e-005
1051	1.9821e-002	4.5904e-002	3.e-003	-3.8831e-005
1052	1.8904e-002	4.6289e-002	3.e-003	-3.9457e-005
1053	1.798e-002	4.6655e-002	3.e-003	-4.0057e-005
1054	1.7049e-002	4.7003e-002	3.e-003	-4.0631e-005
1055	1.6111e-002	4.7333e-002	3.e-003	-4.1178e-005
1056	1.5167e-002	4.7644e-002	3.e-003	-4.1697e-005
1057	1.4217e-002	4.7936e-002	3.e-003	-4.2187e-005
1058	1.3261e-002	4.8209e-002	3.e-003	-4.2647e-005
1059	1.23e-002	4.8464e-002	3.e-003	-4.3077e-005
1060	1.1334e-002	4.8699e-002	3.e-003	-4.3477e-005
1061	1.0363e-002	4.8914e-002	3.e-003	-4.3845e-005
1062	9.3886e-003	4.9111e-002	3.e-003	-4.4182e-005
1063	8.4103e-003	4.9288e-002	3.e-003	-4.4486e-005
1064	7.4287e-003	4.9445e-002	3.e-003	-4.4758e-005
1065	6.4442e-003	4.9583e-002	3.e-003	-4.4996e-005
1066	5.4571e-003	4.9701e-002	3.e-003	-4.5201e-005
1067	4.4678e-003	4.98e-002	3.e-003	-4.5372e-005
1068	3.4768e-003	4.9879e-002	3.e-003	-4.551e-005
1069	2.4844e-003	4.9938e-002	3.e-003	-4.5613e-005
1070	1.491e-003	4.9978e-002	3.e-003	-4.5682e-005
1071	4.9708e-004	4.9998e-002	3.e-003	-4.5716e-005
1072	-4.9707e-004	4.9998e-002	3.e-003	-4.5716e-005
1073	-1.491e-003	4.9978e-002	3.e-003	-4.5682e-005
1074	-2.4844e-003	4.9938e-002	3.e-003	-4.5613e-005
1075	-3.4768e-003	4.9879e-002	3.e-003	-4.551e-005
1076	-4.4678e-003	4.98e-002	3.e-003	-4.5372e-005
1077	-5.4571e-003	4.9701e-002	3.e-003	-4.5201e-005
1078	-6.4442e-003	4.9583e-002	3.e-003	-4.4996e-005
1079	-7.4287e-003	4.9445e-002	3.e-003	-4.4758e-005
1080	-8.4103e-003	4.9288e-002	3.e-003	-4.4486e-005
1081	-9.3886e-003	4.9111e-002	3.e-003	-4.4182e-005
1082	-1.0363e-002	4.8914e-002	3.e-003	-4.3845e-005
1083	-1.1334e-002	4.8699e-002	3.e-003	-4.3477e-005
1084	-1.23e-002	4.8464e-002	3.e-003	-4.3077e-005
1085	-1.3261e-002	4.8209e-002	3.e-003	-4.2647e-005
1086	-1.4217e-002	4.7936e-002	3.e-003	-4.2187e-005
1087	-1.5167e-002	4.7644e-002	3.e-003	-4.1697e-005
1088	-1.6111e-002	4.7333e-002	3.e-003	-4.1178e-005
1089	-1.7049e-002	4.7003e-002	3.e-003	-4.0631e-005
1090	-1.798e-002	4.6655e-002	3.e-003	-4.0057e-005
1091	-1.8904e-002	4.6289e-002	3.e-003	-3.9457e-005
1092	-1.9821e-002	4.5904e-002	3.e-003	-3.8831e-005
1093	-2.073e-002	4.55e-002	3.e-003	-3.8181e-005
1094	-2.163e-002	4.5079e-002	3.e-003	-3.7507e-005
1095	-2.2522e-002	4.464e-002	3.e-003	-3.681e-005
1096	-2.3405e-002	4.4184e-002	3.e-003	-3.6091e-005
1097	-2.4279e-002	4.371e-002	3.e-003	-3.5352e-005
1098	-2.5143e-002	4.3218e-002	3.e-003	-3.4593e-005
1099	-2.5998e-002	4.271e-002	3.e-003	-3.3815e-005
1100	-2.6842e-002	4.2184e-002	3.e-003	-3.3021e-005
1101	-2.7675e-002	4.1642e-002	3.e-003	-3.221e-005
1102	-2.8498e-002	4.1084e-002	3.e-003	-3.1384e-005
1103	-2.9309e-002	4.0509e-002	3.e-003	-3.0544e-005
1104	-3.0108e-002	3.9918e-002	3.e-003	-2.9692e-005
1105	-3.0896e-002	3.9312e-002	3.e-003	-2.8829e-005
1106	-3.1672e-002	3.869e-002	3.e-003	-2.7956e-005
1107	-3.2435e-002	3.8053e-002	3.e-003	-2.7074e-005
1108	-3.3185e-002	3.74e-002	3.e-003	-2.6185e-005
1109	-3.3185e-002	3.74e-002	4.e-003	-2.6185e-005
1110	-3.3185e-002	3.74e-002	5.e-003	-2.6185e-005
1111	-3.3185e-002	3.74e-002	6.e-003	-2.6185e-005
1112	-3.3185e-002	3.74e-002	7.e-003	-2.6185e-005
1113	-3.3185e-002	3.74e-002	8.e-003	-2.6185e-005
1114	-3.3185e-002	3.74e-002	9.e-003	-2.6187e-005
1115	-3.3185e-002	3.74e-002	1.e-002	-2.6188e-005
1116	-3.3185e-002	3.74e-002	1.1e-002	-2.6187e-005
1117	-3.3185e-002	3.74e-002	1.2e-002	-2.6187e-005
1118	-3.3185e-002	3.74e-002	1.3e-002	-2.6187e-005
1119	-3.3185e-002	3.74e-002	1.4e-002	-2.6186e-005
1120	-3.3185e-002	3.74e-002	1.5e-002	-2.6185e-005
1121	-3.3185e-002	3.74e-002	1.6e-002	-2.6185e-005
1122	-3.3185e-002	3.74e-002	1.7e-002	-2.6185e-005
1123	-3.3185e-002	3.74e-002	1.8e-002	-2.6185e-005
1124	-3.3185e-002	3.74e-002	1.9e-002	-2.6185e-005
1125	-3.3185e-002	3.74e-002	2.e-002	-2.6185e-005
1126	-3.3185e-002	3.74e-002	2.1e-002	-2.6185e-005
1127	-3.3186e-002	3.7399e-002	2.2e-002	-2.6185e-005
1128	-3.3186e-002	3.7399e-002	2.3e-002	-2.6185e-005
1129	-3.3186e-002	3.7399e-002	2.4e-002	-2.6185e-005
1130	-3.3186e-002	3.7399e-002	2.5e-002	-2.6185e-005
1131	-3.3186e-002	3.7399e-002	2.6e-002	-2.6185e-005
1132	-3.3186e-002	3.7399e-002	2.7e-002	-2.6185e-005
1133	-3.3186e-002	3.7399e-002	2.8e-002	-2.6185e-005
1134	-3.3186e-002	3.7399e-002	2.9e-002	-2.6185e-005
1135	-3.3186e-002	3.7399e-002	3.e-002	-2.6185e-005
1136	-3.3186e-002	3.7399e-002	3.1e-002	-2.6185e-005
1137	-3.3187e-002	3.7399e-002	3.2e-002	-2.6184e-005
1138	-3.3187e-002	3.7398e-002	3.3e-002	-2.6184e-005
1139	-3.3187e-002	3.7398e-002	3.4e-002	-2.6184e-005
1140	-3.3187e-002	3.7398e-002	3.5e-002	-2.6184e-005
1141	-3.3187e-002	3.7398e-002	3.6e-002	-2.6184e-005
1142	-3.3187e-002	3.7398e-002	3.7e-002	-2.6184e-005
1143	-3.3187e-002	3.7398e-002	3.8e-002	-2.6184e-005
1144	-3.3187e-002	3.7398e-002	3.9e-002	-2.6184e-005
1145	-3.3188e-002	3.7398e-002	4.e-002	-2.6184e-005
1146	-3.3188e-002	3.7398e-002	4.1e-002	-2.6184e-005
1147	-3.3188e-002	3.7397e-002	4.2e-002	-2.6184e-005
1148	-3.3188e-002	3.7397e-002	4.3e-002	-2.6184e-005
1149	-3.3188e-002	3.7397e-002	4.4e-002	-2.6184e-005
1150	-3.3188e-002	3.7397e-002	4.5e-002	-2.6184e-005
1151	-3.3189e-002	3.7397e-002	4.6e-002	-2.6184e-005
1152	3.2435e-002	3.8053e-002	4.6e-002	-2.7074e-005
1153	3.2435e-002	3.8053e-002	4.5e-002	-2.7074e-005
1154	3.2435e-002	3.8053e-002	4.4e-002	-2.7074e-005
1155	3.2435e-002	3.8053e-002	4.3e-002	-2.7074e-005
1156	3.2434e-002	3.8053e-002	4.1e-002	-2.7074e-005
1157	3.2434e-002	3.8053e-002	4.e-002	-2.7074e-005
1158	3.2434e-002	3.8053e-002	3.9e-002	-2.7074e-005
1159	3.2434e-002	3.8053e-002	3.8e-002	-2.7074e-005
1160	3.2434e-002	3.8053e-002	3.7e-002	-2.7074e-005
1161	3.2434e-002	3.8053e-002	3.6e-002	-2.7074e-005
1162	3.2434e-002	3.8053e-002	3.5e-002	-2.7074e-005
1163	3.2434e-002	3.8053e-002	3.4e-002	-2.7074e-005
1164	3.2434e-002	3.8053e-002	3.3e-002	-2.7074e-005
1165	3.2434e-002	3.8053e-002	3.2e-002	-2.7074e-005
1166	3.2434e-002	3.8053e-002	3.1e-002	-2.7074e-005
1167	3.2434e-002	3.8053e-002	3.e-002	-2.7074e-005
1168	3.2434e-002	3.8053e-002	2.9e-002	-2.7074e-005
1169	3.2434e-002	3.8053e-002	2.8e-002	-2.7075e-005
1170	3.2434e-002	3.8053e-002	2.7e-002	-2.7075e-005
1171	3.2434e-002	3.8053e-002	2.6e-002	-2.7075e-005
1172	3.2434e-002	3.8053e-002	2.5e-002	-2.7075e-005
1173	3.2434e-002	3.8053e-002	2.4e-002	-2.7075e-005
1174	3.2434e-002	3.8053e-002	2.3e-002	-2.7075e-005
1175	3.2434e-002	3.8053e-002	2.2e-002	-2.7075e-005
1176	3.2434e-002	3.8053e-002	2.1e-002	-2.7075e-005
1177	3.2434e-002	3.8053e-002	2.e-002	-2.7075e-005
1178	3.2434e-002	3.8053e-002	1.9e-002	-2.7075e-005
1179	3.2434e-002	3.8053e-002	1.8e-002	-2.7075e-005
1180	3.2434e-002	3.8053e-002	1.7e-002	-2.7075e-005
1181	3.2433e-002	3.8054e-002	1.6e-002	-2.7075e-005
1182	3.2433e-002	3.8054e-002	1.5e-002	-2.7075e-005
1183	3.2433e-002	3.8054e-002	1.4e-002	-2.7075e-005
1184	3.2433e-002	3.8054e-002	1.3e-002	-2.7075e-005
1185	3.2433e-002	3.8054e-002	1.2e-002	-2.7075e-005
1186	3.2433e-002	3.8054e-002	1.1e-002	-2.7075e-005
1187	3.2433e-002	3.8054e-002	1.e-002	-2.7075e-005
1188	3.2433e-002	3.8054e-002	9.e-003	-2.7075e-005
1189	3.2433e-002	3.8054e-002	8.e-003	-2.7075e-005
1190	3.2433e-002	3.8054e-002	7.e-003	-2.7075e-005
1191	3.2433e-002	3.8054e-002	5.0001e-003	-2.7075e-005
1192	3.2433e-002	3.8054e-002	4.0001e-003	-2.7074e-005
1193	3.1672e-002	3.869e-002	4.e-003	-2.7956e-005
1194	3.0896e-002	3.9312e-002	4.e-003	-2.8829e-005
1195	3.0108e-002	3.9918e-002	4.e-003	-2.9692e-005
1196	2.9309e-002	4.0509e-002	4.e-003	-3.0544e-005
1197	2.8498e-002	4.1084e-002	4.e-003	-3.1384e-005
1198	2.7675e-002	4.1642e-002	4.e-003	-3.221e-005
1199	2.6842e-002	4.2184e-002	4.e-003	-3.3021e-005
1200	2.5998e-002	4.271e-002	4.e-003	-3.3815e-005
1201	2.5143e-002	4.3218e-002	4.e-003	-3.4593e-005
1202	2.3405e-002	4.4184e-002	4.e-003	-3.6091e-005
1203	2.163e-002	4.5079e-002	4.e-003	-3.7507e-005
1204	1.9821e-002	4.5904e-002	4.e-003	-3.8831e-005
1205	1.798e-002	4.6655e-002	4.e-003	-4.0057e-005
1206	1.6111e-002	4.7333e-002	4.e-003	-4.1178e-005
1207	1.4217e-002	4.7936e-002	4.e-003	-4.2187e-005
1208	1.23e-002	4.8464e-002	4.e-003	-4.3077e-005
1209	1.0363e-002	4.8914e-002	4.e-003	-4.3845e-005
1210	8.4103e-003	4.9288e-002	4.e-003	-4.4486e-005
1211	6.4441e-003	4.9583e-002	4.e-003	-4.4996e-005
1212	4.4678e-003	4.98e-002	4.e-003	-4.5372e-005
1213	2.4844e-003	4.9938e-002	4.e-003	-4.5613e-005
1214	4.9706e-004	4.9998e-002	4.e-003	-4.5716e-005
1215	-1.4911e-003	4.9978e-002	4.e-003	-4.5682e-005
1216	-3.4768e-003	4.9879e-002	4.e-003	-4.551e-005
1217	-5.4571e-003	4.9701e-002	4.e-003	-4.5201e-005
1218	-7.4287e-003	4.9445e-002	4.e-003	-4.4758e-005
1219	-9.3886e-003	4.9111e-002	4.e-003	-4.4182e-005
1220	-1.1334e-002	4.8699e-002	4.e-003	-4.3477e-005
1221	-1.3261e-002	4.8209e-002	4.e-003	-4.2647e-005
1222	-1.5167e-002	4.7644e-002	4.e-003	-4.1697e-005
1223	-1.7049e-002	4.7003e-002	4.e-003	-4.0631e-005
1224	-1.8904e-002	4.6289e-002	4.e-003	-3.9457e-005
1225	-2.073e-002	4.55e-002	4.e-003	-3.8181e-005
1226	-2.2522e-002	4.464e-002	4.e-003	-3.681e-005
1227	-2.4279e-002	4.371e-002	4.e-003	-3.5352e-005
1228	-2.5998e-002	4.271e-002	4.e-003	-3.3815e-005
1229	-2.7675e-002	4.1642e-002	4.e-003	-3.221e-005
1230	-2.9309e-002	4.0509e-002	4.e-003	-3.0544e-005
1231	-3.1672e-002	3.869e-002	4.e-003	-2.7956e-005
1232	-3.2435e-002	3.8053e-002	4.e-003	-2.7074e-005
1233	-3.2435e-002	3.8053e-002	5.e-003	-2.7074e-005
1234	-3.2435e-002	3.8053e-002	6.e-003	-2.7074e-005
1235	-3.2435e-002	3.8053e-002	7.e-003	-2.7075e-005
1236	-3.2428e-002	3.8058e-002	9.001e-003	-2.7084e-005
1237	-3.2427e-002	3.8059e-002	1.e-002	-2.7087e-005
1238	-3.2426e-002	3.806e-002	1.0999e-002	-2.7086e-005
1239	-3.2428e-002	3.8058e-002	1.1996e-002	-2.7085e-005
1240	-3.2427e-002	3.8059e-002	1.2996e-002	-2.7082e-005
1241	-3.2434e-002	3.8053e-002	1.4e-002	-2.7078e-005
1242	-3.2434e-002	3.8053e-002	1.5e-002	-2.7076e-005
1243	-3.2434e-002	3.8053e-002	1.6e-002	-2.7075e-005
1244	-3.2434e-002	3.8053e-002	1.7e-002	-2.7074e-005
1245	-3.2434e-002	3.8053e-002	1.8e-002	-2.7074e-005
1246	-3.2434e-002	3.8053e-002	1.9e-002	-2.7074e-005
1247	-3.2434e-002	3.8053e-002	2.e-002	-2.7074e-005
1248	-3.2434e-002	3.8053e-002	2.1e-002	-2.7074e-005
1249	-3.2434e-002	3.8053e-002	2.2e-002	-2.7074e-005
1250	-3.2434e-002	3.8053e-002	2.3e-002	-2.7074e-005
1251	-3.2434e-002	3.8053e-002	2.4e-002	-2.7074e-005
1252	-3.2434e-002	3.8053e-002	2.5e-002	-2.7074e-005
1253	-3.2434e-002	3.8053e-002	2.6e-002	-2.7074e-005
1254	-3.2434e-002	3.8053e-002	2.7e-002	-2.7074e-005
1255	-3.2434e-002	3.8053e-002	2.8e-002	-2.7074e-005
1256	-3.2434e-002	3.8053e-002	2.9e-002	-2.7074e-005
1257	-3.2434e-002	3.8053e-002	3.e-002	-2.7074e-005
1258	-3.2434e-002	3.8053e-002	3.1e-002	-2.7074e-005
1259	-3.2434e-002	3.8053e-002	3.2e-002	-2.7074e-005
1260	-3.2434e-002	3.8053e-002	3.3e-002	-2.7074e-005
1261	-3.2434e-002	3.8053e-002	3.4e-002	-2.7074e-005
1262	-3.2434e-002	3.8053e-002	3.5e-002	-2.7074e-005
1263	-3.2434e-002	3.8053e-002	3.6e-002	-2.7075e-005
1264	-3.2433e-002	3.8054e-002	3.7e-002	-2.7076e-005
1265	-3.2433e-002	3.8054e-002	3.8e-002	-2.7077e-005
1266	-3.2433e-002	3.8054e-002	3.9e-002	-2.7077e-005
1267	-3.2433e-002	3.8054e-002	4.e-002	-2.7077e-005
1268	-3.2433e-002	3.8054e-002	4.1e-002	-2.7075e-005
1269	-3.2433e-002	3.8054e-002	4.2e-002	-2.7074e-005
1270	-3.2433e-002	3.8054e-002	4.3e-002	-2.7075e-005
1271	-3.2433e-002	3.8054e-002	4.4e-002	-2.7074e-005
1272	-3.2433e-002	3.8054e-002	4.5e-002	-2.7074e-005
1273	-3.2433e-002	3.8054e-002	4.6e-002	-2.7074e-005
1274	-3.1672e-002	3.869e-002	4.6e-002	-2.7956e-005
1275	-3.0896e-002	3.9312e-002	4.6e-002	-2.8829e-005
1276	-2.9309e-002	4.0509e-002	4.6e-002	-3.0544e-005
1277	-2.8498e-002	4.1084e-002	4.6e-002	-3.1384e-005
1278	-2.7675e-002	4.1642e-002	4.6e-002	-3.221e-005
1279	-2.5998e-002	4.271e-002	4.6e-002	-3.3815e-005
1280	-2.5143e-002	4.3218e-002	4.6e-002	-3.4593e-005
1281	-2.4279e-002	4.371e-002	4.6e-002	-3.5352e-005
1282	-2.3405e-002	4.4184e-002	4.6e-002	-3.6091e-005
1283	-2.2522e-002	4.464e-002	4.6e-002	-3.681e-005
1284	-2.163e-002	4.5079e-002	4.6e-002	-3.7506e-005
1285	-2.073e-002	4.55e-002	4.6e-002	-3.8181e-005
1286	-1.9821e-002	4.5904e-002	4.6e-002	-3.8831e-005
1287	-1.8904e-002	4.6289e-002	4.6e-002	-3.9457e-005
1288	-1.798e-002	4.6655e-002	4.6e-002	-4.0057e-005
1289	-1.7049e-002	4.7003e-002	4.6e-002	-4.0631e-005
1290	-1.6111e-002	4.7333e-002	4.6e-002	-4.1178e-005
1291	-1.5167e-002	4.7644e-002	4.6e-002	-4.1697e-005
1292	-1.4217e-002	4.7936e-002	4.6e-002	-4.2186e-005
1293	-1.3261e-002	4.8209e-002	4.6e-002	-4.2647e-005
1294	-1.23e-002	4.8464e-002	4.6e-002	-4.3077e-005
1295	-1.1334e-002	4.8699e-002	4.6e-002	-4.3477e-005
1296	-1.0363e-002	4.8914e-002	4.6e-002	-4.3845e-005
1297	-9.3886e-003	4.9111e-002	4.6e-002	-4.4182e-005
1298	-8.4103e-003	4.9288e-002	4.6e-002	-4.4486e-005
1299	-7.4287e-003	4.9445e-002	4.6e-002	-4.4758e-005
1300	-6.4442e-003	4.9583e-002	4.6e-002	-4.4996e-005
1301	-5.4571e-003	4.9701e-002	4.6e-002	-4.5201e-005
1302	-4.4678e-003	4.98e-002	4.6e-002	-4.5372e-005
1303	-3.4768e-003	4.9879e-002	4.6e-002	-4.551e-005
1304	-2.4844e-003	4.9938e-002	4.6e-002	-4.5613e-005
1305	-1.4911e-003	4.9978e-002	4.6e-002	-4.5682e-005
1306	-4.9708e-004	4.9998e-002	4.6e-002	-4.5716e-005
1307	4.9706e-004	4.9998e-002	4.6e-002	-4.5716e-005
1308	1.491e-003	4.9978e-002	4.6e-002	-4.5682e-005
1309	2.4844e-003	4.9938e-002	4.6e-002	-4.5613e-005
1310	3.4768e-003	4.9879e-002	4.6e-002	-4.551e-005
1311	4.4678e-003	4.98e-002	4.6e-002	-4.5372e-005
1312	5.4571e-003	4.9701e-002	4.6e-002	-4.5201e-005
1313	6.4441e-003	4.9583e-002	4.6e-002	-4.4996e-005
1314	7.4287e-003	4.9445e-002	4.6e-002	-4.4758e-005
1315	8.4103e-003	4.9288e-002	4.6e-002	-4.4486e-005
1316	9.3886e-003	4.9111e-002	4.6e-002	-4.4182e-005
1317	1.0363e-002	4.8914e-002	4.6e-002	-4.3845e-005
1318	1.1334e-002	4.8699e-002	4.6e-002	-4.3477e-005
1319	1.23e-002	4.8464e-002	4.6e-002	-4.3077e-005
1320	1.3261e-002	4.8209e-002	4.6e-002	-4.2647e-005
1321	1.4217e-002	4.7936e-002	4.6e-002	-4.2186e-005
1322	1.5167e-002	4.7644e-002	4.6e-002	-4.1697e-005
1323	1.6111e-002	4.7333e-002	4.6e-002	-4.1178e-005
1324	1.7049e-002	4.7003e-002	4.6e-002	-4.0631e-005
1325	1.798e-002	4.6655e-002	4.6e-002	-4.0057e-005
1326	1.8904e-002	4.6289e-002	4.6e-002	-3.9457e-005
1327	1.9821e-002	4.5904e-002	4.6e-002	-3.8831e-005
1328	2.073e-002	4.55e-002	4.6e-002	-3.8181e-005
1329	2.163e-002	4.5079e-002	4.6e-002	-3.7506e-005
1330	2.2522e-002	4.464e-002	4.6e-002	-3.681e-005
1331	2.3405e-002	4.4184e-002	4.6e-002	-3.6091e-005
1332	2.4279e-002	4.371e-002	4.6e-002	-3.5352e-005
1333	2.5143e-002	4.3218e-002	4.6e-002	-3.4593e-005
1334	2.5998e-002	4.271e-002	4.6e-002	-3.3815e-005
1335	2.6842e-002	4.2184e-002	4.6e-002	-3.3021e-005
1336	2.7675e-002	4.1642e-002	4.6e-002	-3.221e-005
1337	2.8498e-002	4.1084e-002	4.6e-002	-3.1384e-005
1338	3.0108e-002	3.9918e-002	4.6e-002	-2.9692e-005
1339	3.0896e-002	3.9312e-002	4.6e-002	-2.8829e-005
1340	3.1672e-002	3.869e-002	4.6e-002	-2.7956e-005
1341	3.1672e-002	3.869e-002	5.e-003	-2.7957e-005
1342	-3.1672e-002	3.869e-002	4.5e-002	-2.7956e-005
1343	-3.0896e-002	3.9312e-002	4.5e-002	-2.8829e-005
1344	-3.0108e-002	3.9919e-002	4.5e-002	-2.9692e-005
1345	-2.9309e-002	4.0509e-002	4.5e-002	-3.0544e-005
1346	-2.8498e-002	4.1084e-002	4.5e-002	-3.1384e-005
1347	-2.7675e-002	4.1642e-002	4.5e-002	-3.221e-005
1348	-2.6842e-002	4.2184e-002	4.5e-002	-3.3021e-005
1349	-2.5998e-002	4.271e-002	4.5e-002	-3.3815e-005
1350	-2.5143e-002	4.3218e-002	4.5e-002	-3.4593e-005
1351	-2.4279e-002	4.371e-002	4.5e-002	-3.5352e-005
1352	-2.3405e-002	4.4184e-002	4.5e-002	-3.6091e-005
1353	-2.2522e-002	4.464e-002	4.5e-002	-3.681e-005
1354	-2.163e-002	4.5079e-002	4.5e-002	-3.7506e-005
1355	-2.073e-002	4.55e-002	4.5e-002	-3.8181e-005
1356	-1.9821e-002	4.5904e-002	4.5e-002	-3.8831e-005
1357	-1.8904e-002	4.6288e-002	4.5e-002	-3.9457e-005
1358	-1.798e-002	4.6655e-002	4.5e-002	-4.0057e-005
1359	-1.7049e-002	4.7003e-002	4.5e-002	-4.0631e-005
1360	-1.6111e-002	4.7333e-002	4.5e-002	-4.1178e-005
1361	-1.5167e-002	4.7644e-002	4.5e-002	-4.1697e-005
1362	-1.4217e-002	4.7936e-002	4.5e-002	-4.2186e-005
1363	-1.3261e-002	4.8209e-002	4.5e-002	-4.2647e-005
1364	-1.23e-002	4.8464e-002	4.5e-002	-4.3077e-005
1365	-1.1334e-002	4.8699e-002	4.5e-002	-4.3477e-005
1366	-1.0363e-002	4.8914e-002	4.5e-002	-4.3845e-005
1367	-9.3887e-003	4.9111e-002	4.5e-002	-4.4182e-005
1368	-8.4103e-003	4.9288e-002	4.5e-002	-4.4486e-005
1369	-7.4288e-003	4.9445e-002	4.5e-002	-4.4758e-005
1370	-6.4442e-003	4.9583e-002	4.5e-002	-4.4996e-005
1371	-5.4571e-003	4.9701e-002	4.5e-002	-4.5201e-005
1372	-4.4678e-003	4.98e-002	4.5e-002	-4.5372e-005
1373	-3.4769e-003	4.9879e-002	4.5e-002	-4.551e-005
1374	-2.4844e-003	4.9938e-002	4.5e-002	-4.5613e-005
1375	-1.4911e-003	4.9978e-002	4.5e-002	-4.5682e-005
1376	-4.9708e-004	4.9998e-002	4.5e-002	-4.5716e-005
1377	4.9702e-004	4.9998e-002	4.5e-002	-4.5716e-005
1378	1.491e-003	4.9978e-002	4.5e-002	-4.5682e-005
1379	2.4844e-003	4.9938e-002	4.5e-002	-4.5613e-005
1380	3.4768e-003	4.9879e-002	4.5e-002	-4.551e-005
1381	4.4678e-003	4.98e-002	4.5e-002	-4.5372e-005
1382	5.4571e-003	4.9701e-002	4.5e-002	-4.5201e-005
1383	6.4441e-003	4.9583e-002	4.5e-002	-4.4996e-005
1384	7.4287e-003	4.9445e-002	4.5e-002	-4.4758e-005
1385	8.4103e-003	4.9288e-002	4.5e-002	-4.4486e-005
1386	9.3886e-003	4.9111e-002	4.5e-002	-4.4182e-005
1387	1.0363e-002	4.8914e-002	4.5e-002	-4.3845e-005
1388	1.1334e-002	4.8699e-002	4.5e-002	-4.3477e-005
1389	1.23e-002	4.8464e-002	4.5e-002	-4.3077e-005
1390	1.3261e-002	4.8209e-002	4.5e-002	-4.2647e-005
1391	1.4217e-002	4.7936e-002	4.5e-002	-4.2186e-005
1392	1.5167e-002	4.7644e-002	4.5e-002	-4.1697e-005
1393	1.6111e-002	4.7333e-002	4.5e-002	-4.1178e-005
1394	1.7049e-002	4.7003e-002	4.5e-002	-4.0631e-005
1395	1.798e-002	4.6655e-002	4.5e-002	-4.0057e-005
1396	1.8904e-002	4.6289e-002	4.5e-002	-3.9457e-005
1397	1.9821e-002	4.5904e-002	4.5e-002	-3.8831e-005
1398	2.073e-002	4.55e-002	4.5e-002	-3.8181e-005
1399	2.163e-002	4.5079e-002	4.5e-002	-3.7506e-005
1400	2.2522e-002	4.464e-002	4.5e-002	-3.681e-005
1401	2.3405e-002	4.4184e-002	4.5e-002	-3.6091e-005
1402	2.4279e-002	4.371e-002	4.5e-002	-3.5352e-005
1403	2.5143e-002	4.3218e-002	4.5e-002	-3.4593e-005
1404	2.5998e-002	4.271e-002	4.5e-002	-3.3815e-005
1405	2.6842e-002	4.2184e-002	4.5e-002	-3.3021e-005
1406	2.7675e-002	4.1642e-002	4.5e-002	-3.221e-005
1407	2.8498e-002	4.1084e-002	4.5e-002	-3.1384e-005
1408	2.9309e-002	4.0509e-002	4.5e-002	-3.0544e-005
1409	3.0108e-002	3.9918e-002	4.5e-002	-2.9692e-005
1410	3.0896e-002	3.9312e-002	4.5e-002	-2.8829e-005
1411	3.1672e-002	3.869e-002	4.5e-002	-2.7956e-005
1412	3.1672e-002	3.869e-002	4.4e-002	-2.7956e-005
1413	3.1672e-002	3.869e-002	4.3e-002	-2.7956e-005
1414	3.1671e-002	3.869e-002	4.2e-002	-2.7956e-005
1415	3.1671e-002	3.869e-002	4.1e-002	-2.7956e-005
1416	3.1671e-002	3.869e-002	4.e-002	-2.7956e-005
1417	3.1671e-002	3.869e-002	3.9e-002	-2.7956e-005
1418	3.1671e-002	3.869e-002	3.7e-002	-2.7956e-005
1419	3.1671e-002	3.869e-002	3.5e-002	-2.7956e-005
1420	3.1671e-002	3.869e-002	3.3e-002	-2.7956e-005
1421	3.1671e-002	3.869e-002	3.1e-002	-2.7956e-005
1422	3.1671e-002	3.869e-002	2.9e-002	-2.7956e-005
1423	3.1671e-002	3.869e-002	2.7e-002	-2.7956e-005
1424	3.1671e-002	3.869e-002	2.5e-002	-2.7956e-005
1425	3.1671e-002	3.869e-002	2.3e-002	-2.7956e-005
1426	3.1671e-002	3.869e-002	2.1e-002	-2.7956e-005
1427	3.1671e-002	3.869e-002	1.9e-002	-2.7956e-005
1428	3.1671e-002	3.869e-002	1.7e-002	-2.7956e-005
1429	3.1671e-002	3.869e-002	1.5e-002	-2.7956e-005
1430	3.1671e-002	3.8691e-002	1.3e-002	-2.7956e-005
1431	3.1671e-002	3.8691e-002	1.2e-002	-2.7956e-005
1432	3.1671e-002	3.8691e-002	1.1e-002	-2.7956e-005
1433	3.1671e-002	3.8691e-002	1.e-002	-2.7956e-005
1434	3.1671e-002	3.8691e-002	9.0001e-003	-2.7957e-005
1435	3.1671e-002	3.8691e-002	8.0001e-003	-2.7957e-005
1436	3.167e-002	3.8691e-002	7.0001e-003	-2.7957e-005
1437	3.167e-002	3.8691e-002	6.0001e-003	-2.7957e-005
1438	3.0896e-002	3.9312e-002	5.e-003	-2.8829e-005
1439	3.0108e-002	3.9918e-002	5.e-003	-2.9692e-005
1440	2.9309e-002	4.0509e-002	5.e-003	-3.0544e-005
1441	2.8498e-002	4.1084e-002	5.e-003	-3.1384e-005
1442	2.7675e-002	4.1642e-002	5.e-003	-3.221e-005
1443	2.6842e-002	4.2184e-002	5.e-003	-3.3021e-005
1444	2.5998e-002	4.271e-002	5.e-003	-3.3815e-005
1445	2.5143e-002	4.3218e-002	5.e-003	-3.4593e-005
1446	2.4279e-002	4.371e-002	5.e-003	-3.5352e-005
1447	2.3405e-002	4.4184e-002	5.e-003	-3.6091e-005
1448	2.2522e-002	4.464e-002	5.e-003	-3.681e-005
1449	2.163e-002	4.5079e-002	5.e-003	-3.7506e-005
1450	2.073e-002	4.55e-002	5.e-003	-3.8181e-005
1451	1.9821e-002	4.5904e-002	5.e-003	-3.8831e-005
1452	1.8904e-002	4.6288e-002	5.e-003	-3.9457e-005
1453	1.798e-002	4.6655e-002	5.e-003	-4.0057e-005
1454	1.7049e-002	4.7003e-002	5.e-003	-4.0631e-005
1455	1.6111e-002	4.7333e-002	5.e-003	-4.1178e-005
1456	1.5167e-002	4.7644e-002	5.e-003	-4.1697e-005
1457	1.4217e-002	4.7936e-002	5.e-003	-4.2187e-005
1458	1.3261e-002	4.8209e-002	5.e-003	-4.2647e-005
1459	1.23e-002	4.8464e-002	5.e-003	-4.3077e-005
1460	1.1334e-002	4.8699e-002	5.e-003	-4.3477e-005
1461	1.0363e-002	4.8914e-002	5.e-003	-4.3845e-005
1462	9.3887e-003	4.9111e-002	5.e-003	-4.4182e-005
1463	8.4103e-003	4.9288e-002	5.e-003	-4.4486e-005
1464	7.4288e-003	4.9445e-002	5.e-003	-4.4758e-005
1465	6.4442e-003	4.9583e-002	5.e-003	-4.4996e-005
1466	5.4571e-003	4.9701e-002	5.e-003	-4.5201e-005
1467	4.4678e-003	4.98e-002	5.e-003	-4.5372e-005
1468	3.4769e-003	4.9879e-002	5.e-003	-4.551e-005
1469	2.4844e-003	4.9938e-002	5.e-003	-4.5613e-005
1470	1.4911e-003	4.9978e-002	5.e-003	-4.5682e-005
1471	4.9708e-004	4.9998e-002	5.e-003	-4.5716e-005
1472	-4.9702e-004	4.9998e-002	5.e-003	-4.5716e-005
1473	-1.491e-003	4.9978e-002	5.e-003	-4.5682e-005
1474	-2.4844e-003	4.9938e-002	5.e-003	-4.5613e-005
1475	-3.4768e-003	4.9879e-002	5.e-003	-4.551e-005
1476	-4.4678e-003	4.98e-002	5.e-003	-4.5372e-005
1477	-5.4571e-003	4.9701e-002	5.e-003	-4.5201e-005
1478	-6.4441e-003	4.9583e-002	5.e-003	-4.4996e-005
1479	-7.4287e-003	4.9445e-002	5.e-003	-4.4758e-005
1480	-8.4103e-003	4.9288e-002	5.e-003	-4.4486e-005
1481	-9.3886e-003	4.9111e-002	5.e-003	-4.4182e-005
1482	-1.0363e-002	4.8914e-002	5.e-003	-4.3845e-005
1483	-1.1334e-002	4.8699e-002	5.e-003	-4.3477e-005
1484	-1.23e-002	4.8464e-002	5.e-003	-4.3077e-005
1485	-1.3261e-002	4.8209e-002	5.e-003	-4.2647e-005
1486	-1.4217e-002	4.7936e-002	5.e-003	-4.2187e-005
1487	-1.5167e-002	4.7644e-002	5.e-003	-4.1697e-005
1488	-1.6111e-002	4.7333e-002	5.e-003	-4.1178e-005
1489	-1.7049e-002	4.7003e-002	5.e-003	-4.0631e-005
1490	-1.798e-002	4.6655e-002	5.e-003	-4.0057e-005
1491	-1.8904e-002	4.6289e-002	5.e-003	-3.9457e-005
1492	-1.9821e-002	4.5904e-002	5.e-003	-3.8831e-005
1493	-2.073e-002	4.55e-002	5.e-003	-3.8181e-005
1494	-2.163e-002	4.5079e-002	5.e-003	-3.7507e-005
1495	-2.2522e-002	4.464e-002	5.e-003	-3.681e-005
1496	-2.3405e-002	4.4184e-002	5.e-003	-3.6091e-005
1497	-2.4279e-002	4.371e-002	5.e-003	-3.5352e-005
1498	-2.5143e-002	4.3218e-002	5.e-003	-3.4593e-005
1499	-2.5998e-002	4.271e-002	5.e-003	-3.3816e-005
1500	-2.6842e-002	4.2184e-002	5.e-003	-3.3022e-005
1501	-2.7673e-002	4.1644e-002	4.991e-003	-3.2211e-005
1502	-2.8497e-002	4.1084e-002	4.9885e-003	-3.1385e-005
1503	-2.931e-002	4.0509e-002	4.9913e-003	-3.0544e-005
1504	-3.0108e-002	3.9919e-002	5.e-003	-2.9692e-005
1505	-3.1672e-002	3.869e-002	5.e-003	-2.7956e-005
1506	-3.1672e-002	3.869e-002	6.e-003	-2.7956e-005
1507	-3.1672e-002	3.869e-002	7.e-003	-2.7958e-005
1508	-3.166e-002	3.8699e-002	8.0048e-003	-2.7968e-005
1509	-3.1648e-002	3.8709e-002	9.0041e-003	-2.798e-005
1510	-3.1642e-002	3.8714e-002	9.998e-003	-2.7986e-005
1511	-3.1648e-002	3.8709e-002	1.099e-002	-2.7986e-005
1512	-3.1656e-002	3.8702e-002	1.299e-002	-2.7976e-005
1513	-3.1666e-002	3.8695e-002	1.4996e-002	-2.7966e-005
1514	-3.1671e-002	3.869e-002	1.7e-002	-2.7959e-005
1515	-3.1671e-002	3.869e-002	1.9e-002	-2.7955e-005
1516	-3.1671e-002	3.869e-002	2.1e-002	-2.7953e-005
1517	-3.1671e-002	3.869e-002	2.3e-002	-2.7953e-005
1518	-3.1671e-002	3.869e-002	2.5e-002	-2.7956e-005
1519	-3.1671e-002	3.869e-002	2.7e-002	-2.796e-005
1520	-3.1671e-002	3.8691e-002	2.9e-002	-2.796e-005
1521	-3.1671e-002	3.8691e-002	3.1e-002	-2.796e-005
1522	-3.1671e-002	3.8691e-002	3.3e-002	-2.7959e-005
1523	-3.1671e-002	3.8691e-002	3.5e-002	-2.796e-005
1524	-3.1663e-002	3.8697e-002	3.7e-002	-2.7965e-005
1525	-3.1662e-002	3.8698e-002	3.8999e-002	-2.7967e-005
1526	-3.167e-002	3.8691e-002	4.1e-002	-2.7963e-005
1527	-3.167e-002	3.8691e-002	4.3e-002	-2.7957e-005
1528	-3.167e-002	3.8691e-002	4.4e-002	-2.7956e-005
1529	3.0896e-002	3.9312e-002	4.4e-002	-2.8829e-005
1530	3.0896e-002	3.9312e-002	4.3e-002	-2.8829e-005
1531	3.0896e-002	3.9312e-002	4.2e-002	-2.8829e-005
1532	3.0896e-002	3.9312e-002	4.1e-002	-2.8829e-005
1533	3.0896e-002	3.9312e-002	4.e-002	-2.8829e-005
1534	3.0896e-002	3.9312e-002	3.9e-002	-2.8829e-005
1535	3.0896e-002	3.9312e-002	3.8e-002	-2.8829e-005
1536	3.0896e-002	3.9312e-002	3.7e-002	-2.8829e-005
1537	3.0896e-002	3.9312e-002	3.6e-002	-2.8829e-005
1538	3.0896e-002	3.9312e-002	3.5e-002	-2.8829e-005
1539	3.0896e-002	3.9312e-002	3.4e-002	-2.8829e-005
1540	3.0896e-002	3.9312e-002	3.3e-002	-2.8829e-005
1541	3.0896e-002	3.9312e-002	3.2e-002	-2.8829e-005
1542	3.0896e-002	3.9312e-002	3.1e-002	-2.8829e-005
1543	3.0896e-002	3.9312e-002	3.e-002	-2.8829e-005
1544	3.0896e-002	3.9312e-002	2.9e-002	-2.8829e-005
1545	3.0896e-002	3.9312e-002	2.8e-002	-2.8829e-005
1546	3.0896e-002	3.9312e-002	2.7e-002	-2.8829e-005
1547	3.0896e-002	3.9312e-002	2.6e-002	-2.8829e-005
1548	3.0897e-002	3.9312e-002	2.5e-002	-2.8829e-005
1549	3.0897e-002	3.9312e-002	2.4e-002	-2.8829e-005
1550	3.0897e-002	3.9312e-002	2.3e-002	-2.8829e-005
1551	3.0897e-002	3.9312e-002	2.2e-002	-2.8829e-005
1552	3.0897e-002	3.9311e-002	2.1e-002	-2.8829e-005
1553	3.0897e-002	3.9311e-002	2.e-002	-2.8829e-005
1554	3.0897e-002	3.9311e-002	1.9e-002	-2.8829e-005
1555	3.0897e-002	3.9311e-002	1.8e-002	-2.8829e-005
1556	3.0897e-002	3.9311e-002	1.7e-002	-2.8829e-005
1557	3.0897e-002	3.9311e-002	1.6e-002	-2.8829e-005
1558	3.0897e-002	3.9311e-002	1.5e-002	-2.8829e-005
1559	3.0897e-002	3.9311e-002	1.4e-002	-2.8828e-005
1560	3.0897e-002	3.9311e-002	1.3e-002	-2.8828e-005
1561	3.0897e-002	3.9311e-002	1.2e-002	-2.8828e-005
1562	3.0897e-002	3.9311e-002	1.1e-002	-2.8828e-005
1563	3.0898e-002	3.9311e-002	1.e-002	-2.8828e-005
1564	3.0898e-002	3.9311e-002	9.e-003	-2.8828e-005
1565	3.0898e-002	3.9311e-002	8.e-003	-2.8828e-005
1566	3.0898e-002	3.9311e-002	7.e-003	-2.8828e-005
1567	3.0898e-002	3.9311e-002	6.e-003	-2.8829e-005
1568	3.0108e-002	3.9918e-002	6.e-003	-2.9692e-005
1569	2.9309e-002	4.0509e-002	6.e-003	-3.0544e-005
1570	2.8498e-002	4.1084e-002	6.e-003	-3.1384e-005
1571	2.7675e-002	4.1642e-002	6.e-003	-3.221e-005
1572	2.6842e-002	4.2184e-002	6.e-003	-3.3021e-005
1573	2.5998e-002	4.271e-002	6.e-003	-3.3815e-005
1574	2.5143e-002	4.3218e-002	6.e-003	-3.4593e-005
1575	2.4279e-002	4.371e-002	6.e-003	-3.5352e-005
1576	2.3405e-002	4.4184e-002	6.e-003	-3.6091e-005
1577	2.2522e-002	4.464e-002	6.e-003	-3.681e-005
1578	2.163e-002	4.5079e-002	6.e-003	-3.7506e-005
1579	2.073e-002	4.55e-002	6.e-003	-3.8181e-005
1580	1.9821e-002	4.5904e-002	6.e-003	-3.8831e-005
1581	1.8904e-002	4.6289e-002	6.e-003	-3.9457e-005
1582	1.798e-002	4.6655e-002	6.e-003	-4.0057e-005
1583	1.7049e-002	4.7003e-002	6.e-003	-4.0631e-005
1584	1.6111e-002	4.7333e-002	6.e-003	-4.1178e-005
1585	1.5167e-002	4.7644e-002	6.e-003	-4.1697e-005
1586	1.4217e-002	4.7936e-002	6.e-003	-4.2187e-005
1587	1.3261e-002	4.8209e-002	6.e-003	-4.2647e-005
1588	1.23e-002	4.8464e-002	6.e-003	-4.3077e-005
1589	1.1334e-002	4.8699e-002	6.e-003	-4.3477e-005
1590	1.0363e-002	4.8914e-002	6.e-003	-4.3845e-005
1591	9.3886e-003	4.9111e-002	6.e-003	-4.4182e-005
1592	8.4103e-003	4.9288e-002	6.e-003	-4.4486e-005
1593	7.4288e-003	4.9445e-002	6.e-003	-4.4758e-005
1594	6.4442e-003	4.9583e-002	6.e-003	-4.4996e-005
1595	5.4571e-003	4.9701e-002	6.e-003	-4.5201e-005
1596	4.4678e-003	4.98e-002	6.e-003	-4.5372e-005
1597	3.4769e-003	4.9879e-002	6.e-003	-4.551e-005
1598	2.4844e-003	4.9938e-002	6.e-003	-4.5613e-005
1599	1.4911e-003	4.9978e-002	6.e-003	-4.5682e-005
1600	4.9707e-004	4.9998e-002	6.e-003	-4.5716e-005
1601	-4.9703e-004	4.9998e-002	6.e-003	-4.5716e-005
1602	-1.4911e-003	4.9978e-002	6.e-003	-4.5682e-005
1603	-2.4844e-003	4.9938e-002	6.e-003	-4.5613e-005
1604	-3.4768e-003	4.9879e-002	6.e-003	-4.551e-005
1605	-4.4678e-003	4.98e-002	6.e-003	-4.5372e-005
1606	-5.4571e-003	4.9701e-002	6.e-003	-4.5201e-005
1607	-6.4441e-003	4.9583e-002	6.e-003	-4.4996e-005
1608	-7.4287e-003	4.9445e-002	6.e-003	-4.4758e-005
1609	-8.4103e-003	4.9288e-002	6.e-003	-4.4486e-005
1610	-9.3886e-003	4.9111e-002	6.e-003	-4.4182e-005
1611	-1.0363e-002	4.8914e-002	6.e-003	-4.3845e-005
1612	-1.1334e-002	4.8699e-002	6.e-003	-4.3477e-005
1613	-1.23e-002	4.8464e-002	6.e-003	-4.3077e-005
1614	-1.3261e-002	4.8209e-002	6.e-003	-4.2647e-005
1615	-1.4217e-002	4.7936e-002	6.e-003	-4.2187e-005
1616	-1.5167e-002	4.7644e-002	6.e-003	-4.1697e-005
1617	-1.6111e-002	4.7333e-002	6.e-003	-4.1178e-005
1618	-1.7049e-002	4.7003e-002	6.e-003	-4.0631e-005
1619	-1.798e-002	4.6655e-002	6.e-003	-4.0057e-005
1620	-1.8904e-002	4.6289e-002	6.e-003	-3.9457e-005
1621	-1.9821e-002	4.5904e-002	6.e-003	-3.8831e-005
1622	-2.073e-002	4.55e-002	6.e-003	-3.8181e-005
1623	-2.163e-002	4.5079e-002	6.e-003	-3.7506e-005
1624	-2.2522e-002	4.464e-002	6.e-003	-3.681e-005
1625	-2.3405e-002	4.4184e-002	6.e-003	-3.6091e-005
1626	-2.4279e-002	4.371e-002	6.e-003	-3.5352e-005
1627	-2.5143e-002	4.3218e-002	6.e-003	-3.4593e-005
1628	-2.5998e-002	4.271e-002	6.e-003	-3.3817e-005
1629	-2.6838e-002	4.2187e-002	5.9919e-003	-3.3024e-005
1630	-2.767e-002	4.1646e-002	5.9815e-003	-3.2215e-005
1631	-2.8495e-002	4.1086e-002	5.9722e-003	-3.1388e-005
1632	-2.931e-002	4.0508e-002	5.9785e-003	-3.0546e-005
1633	-3.0108e-002	3.9919e-002	6.e-003	-2.9693e-005
1634	-3.0896e-002	3.9312e-002	6.e-003	-2.8829e-005
1635	-3.0896e-002	3.9312e-002	7.e-003	-2.8834e-005
1636	-3.0878e-002	3.9326e-002	8.0003e-003	-2.8849e-005
1637	-3.0857e-002	3.9342e-002	9.0016e-003	-2.8866e-005
1638	-3.0853e-002	3.9345e-002	9.9957e-003	-2.8877e-005
1639	-3.0845e-002	3.9352e-002	1.0989e-002	-2.888e-005
1640	-3.0855e-002	3.9344e-002	1.1989e-002	-2.8875e-005
1641	-3.0862e-002	3.9339e-002	1.2989e-002	-2.8868e-005
1642	-3.0868e-002	3.9334e-002	1.3993e-002	-2.8861e-005
1643	-3.0874e-002	3.9329e-002	1.4994e-002	-2.8854e-005
1644	-3.088e-002	3.9324e-002	1.5993e-002	-2.8847e-005
1645	-3.0887e-002	3.9319e-002	1.6994e-002	-2.884e-005
1646	-3.0892e-002	3.9315e-002	1.7991e-002	-2.8833e-005
1647	-3.09e-002	3.9309e-002	1.899e-002	-2.8825e-005
1648	-3.0903e-002	3.9307e-002	1.9993e-002	-2.8818e-005
1649	-3.091e-002	3.9301e-002	2.0996e-002	-2.8812e-005
1650	-3.0909e-002	3.9302e-002	2.2002e-002	-2.8811e-005
1651	-3.0909e-002	3.9302e-002	2.3006e-002	-2.8815e-005
1652	-3.0902e-002	3.9307e-002	2.4007e-002	-2.8821e-005
1653	-3.0897e-002	3.9311e-002	2.5e-002	-2.8829e-005
1654	-3.0887e-002	3.9319e-002	2.6002e-002	-2.8837e-005
1655	-3.0885e-002	3.932e-002	2.7001e-002	-2.8841e-005
1656	-3.0885e-002	3.932e-002	2.7999e-002	-2.8841e-005
1657	-3.0885e-002	3.932e-002	2.9e-002	-2.8841e-005
1658	-3.0885e-002	3.9321e-002	2.9999e-002	-2.8842e-005
1659	-3.0884e-002	3.9322e-002	3.1e-002	-2.8842e-005
1660	-3.0883e-002	3.9322e-002	3.1999e-002	-2.8841e-005
1661	-3.0889e-002	3.9318e-002	3.3e-002	-2.8839e-005
1662	-3.0886e-002	3.932e-002	3.4e-002	-2.884e-005
1663	-3.0884e-002	3.9322e-002	3.5e-002	-2.8842e-005
1664	-3.0882e-002	3.9323e-002	3.6e-002	-2.8844e-005
1665	-3.0879e-002	3.9325e-002	3.7e-002	-2.8847e-005
1666	-3.0877e-002	3.9327e-002	3.8e-002	-2.8849e-005
1667	-3.0875e-002	3.9329e-002	3.9e-002	-2.8849e-005
1668	-3.0879e-002	3.9325e-002	4.0995e-002	-2.8843e-005
1669	-3.0887e-002	3.9319e-002	4.1995e-002	-2.8836e-005
1670	-3.0899e-002	3.931e-002	4.3e-002	-2.883e-005
1671	-3.0899e-002	3.931e-002	4.4e-002	-2.8828e-005
1672	-3.0108e-002	3.9919e-002	4.4e-002	-2.9692e-005
1673	-2.9309e-002	4.0509e-002	4.4e-002	-3.0545e-005
1674	-2.8498e-002	4.1084e-002	4.4e-002	-3.1384e-005
1675	-2.7675e-002	4.1642e-002	4.4e-002	-3.221e-005
1676	-2.6842e-002	4.2184e-002	4.4e-002	-3.3021e-005
1677	-2.5998e-002	4.271e-002	4.4e-002	-3.3815e-005
1678	-2.5143e-002	4.3218e-002	4.4e-002	-3.4593e-005
1679	-2.4279e-002	4.371e-002	4.4e-002	-3.5352e-005
1680	-2.3405e-002	4.4184e-002	4.4e-002	-3.6091e-005
1681	-2.2522e-002	4.464e-002	4.4e-002	-3.681e-005
1682	-2.163e-002	4.5079e-002	4.4e-002	-3.7506e-005
1683	-2.073e-002	4.55e-002	4.4e-002	-3.8181e-005
1684	-1.9821e-002	4.5904e-002	4.4e-002	-3.8831e-005
1685	-1.8904e-002	4.6289e-002	4.4e-002	-3.9457e-005
1686	-1.798e-002	4.6655e-002	4.4e-002	-4.0057e-005
1687	-1.7049e-002	4.7003e-002	4.4e-002	-4.0631e-005
1688	-1.6111e-002	4.7333e-002	4.4e-002	-4.1178e-005
1689	-1.5167e-002	4.7644e-002	4.4e-002	-4.1697e-005
1690	-1.4217e-002	4.7936e-002	4.4e-002	-4.2186e-005
1691	-1.3261e-002	4.8209e-002	4.4e-002	-4.2647e-005
1692	-1.23e-002	4.8464e-002	4.4e-002	-4.3077e-005
1693	-1.1334e-002	4.8699e-002	4.4e-002	-4.3477e-005
1694	-1.0363e-002	4.8914e-002	4.4e-002	-4.3845e-005
1695	-9.3886e-003	4.9111e-002	4.4e-002	-4.4182e-005
1696	-8.4103e-003	4.9288e-002	4.4e-002	-4.4486e-005
1697	-7.4288e-003	4.9445e-002	4.4e-002	-4.4758e-005
1698	-6.4442e-003	4.9583e-002	4.4e-002	-4.4996e-005
1699	-5.4571e-003	4.9701e-002	4.4e-002	-4.5201e-005
1700	-4.4678e-003	4.98e-002	4.4e-002	-4.5372e-005
1701	-3.4769e-003	4.9879e-002	4.4e-002	-4.551e-005
1702	-2.4844e-003	4.9938e-002	4.4e-002	-4.5613e-005
1703	-1.4911e-003	4.9978e-002	4.4e-002	-4.5682e-005
1704	-4.9707e-004	4.9998e-002	4.4e-002	-4.5716e-005
1705	4.9703e-004	4.9998e-002	4.4e-002	-4.5716e-005
1706	1.4911e-003	4.9978e-002	4.4e-002	-4.5682e-005
1707	2.4844e-003	4.9938e-002	4.4e-002	-4.5613e-005
1708	3.4768e-003	4.9879e-002	4.4e-002	-4.551e-005
1709	4.4678e-003	4.98e-002	4.4e-002	-4.5372e-005
1710	5.4571e-003	4.9701e-002	4.4e-002	-4.5201e-005
1711	6.4441e-003	4.9583e-002	4.4e-002	-4.4996e-005
1712	7.4287e-003	4.9445e-002	4.4e-002	-4.4758e-005
1713	8.4103e-003	4.9288e-002	4.4e-002	-4.4486e-005
1714	9.3886e-003	4.9111e-002	4.4e-002	-4.4182e-005
1715	1.0363e-002	4.8914e-002	4.4e-002	-4.3845e-005
1716	1.1334e-002	4.8699e-002	4.4e-002	-4.3477e-005
1717	1.23e-002	4.8464e-002	4.4e-002	-4.3077e-005
1718	1.3261e-002	4.8209e-002	4.4e-002	-4.2647e-005
1719	1.4217e-002	4.7936e-002	4.4e-002	-4.2186e-005
1720	1.5167e-002	4.7644e-002	4.4e-002	-4.1697e-005
1721	1.6111e-002	4.7333e-002	4.4e-002	-4.1178e-005
1722	1.7049e-002	4.7003e-002	4.4e-002	-4.0631e-005
1723	1.798e-002	4.6655e-002	4.4e-002	-4.0057e-005
1724	1.8904e-002	4.6289e-002	4.4e-002	-3.9457e-005
1725	1.9821e-002	4.5904e-002	4.4e-002	-3.8831e-005
1726	2.073e-002	4.55e-002	4.4e-002	-3.8181e-005
1727	2.163e-002	4.5079e-002	4.4e-002	-3.7506e-005
1728	2.2522e-002	4.464e-002	4.4e-002	-3.681e-005
1729	2.3405e-002	4.4184e-002	4.4e-002	-3.6091e-005
1730	2.4279e-002	4.371e-002	4.4e-002	-3.5352e-005
1731	2.5143e-002	4.3218e-002	4.4e-002	-3.4593e-005
1732	2.5998e-002	4.271e-002	4.4e-002	-3.3815e-005
1733	2.6842e-002	4.2184e-002	4.4e-002	-3.3021e-005
1734	2.7675e-002	4.1642e-002	4.4e-002	-3.221e-005
1735	2.8497e-002	4.1084e-002	4.4e-002	-3.1384e-005
1736	2.9309e-002	4.0509e-002	4.4e-002	-3.0544e-005
1737	3.0108e-002	3.9918e-002	4.4e-002	-2.9692e-005
1738	3.0108e-002	3.9918e-002	7.0001e-003	-2.9692e-005
1739	2.9309e-002	4.0509e-002	7.e-003	-3.0544e-005
1740	2.8498e-002	4.1084e-002	7.e-003	-3.1384e-005
1741	2.7675e-002	4.1642e-002	7.e-003	-3.221e-005
1742	2.6842e-002	4.2184e-002	7.e-003	-3.3021e-005
1743	2.5998e-002	4.271e-002	7.e-003	-3.3815e-005
1744	2.5143e-002	4.3218e-002	7.e-003	-3.4593e-005
1745	2.4279e-002	4.371e-002	7.e-003	-3.5352e-005
1746	2.3405e-002	4.4184e-002	7.e-003	-3.6091e-005
1747	2.2522e-002	4.464e-002	7.e-003	-3.681e-005
1748	2.163e-002	4.5079e-002	7.e-003	-3.7506e-005
1749	2.073e-002	4.55e-002	7.e-003	-3.8181e-005
1750	1.9821e-002	4.5904e-002	7.e-003	-3.8831e-005
1751	1.8904e-002	4.6288e-002	7.e-003	-3.9457e-005
1752	1.798e-002	4.6655e-002	7.e-003	-4.0057e-005
1753	1.7049e-002	4.7003e-002	7.e-003	-4.0631e-005
1754	1.6111e-002	4.7333e-002	7.e-003	-4.1178e-005
1755	1.5167e-002	4.7644e-002	7.e-003	-4.1697e-005
1756	1.4217e-002	4.7936e-002	7.e-003	-4.2187e-005
1757	1.3261e-002	4.8209e-002	7.e-003	-4.2647e-005
1758	1.23e-002	4.8464e-002	7.e-003	-4.3077e-005
1759	1.1334e-002	4.8699e-002	7.e-003	-4.3477e-005
1760	1.0363e-002	4.8914e-002	7.e-003	-4.3845e-005
1761	9.3887e-003	4.9111e-002	7.e-003	-4.4182e-005
1762	8.4103e-003	4.9288e-002	7.e-003	-4.4486e-005
1763	7.4288e-003	4.9445e-002	7.e-003	-4.4758e-005
1764	6.4442e-003	4.9583e-002	7.e-003	-4.4996e-005
1765	5.4571e-003	4.9701e-002	7.e-003	-4.5201e-005
1766	4.4678e-003	4.98e-002	7.e-003	-4.5372e-005
1767	3.4769e-003	4.9879e-002	7.e-003	-4.551e-005
1768	2.4844e-003	4.9938e-002	7.e-003	-4.5613e-005
1769	1.4911e-003	4.9978e-002	7.e-003	-4.5682e-005
1770	4.9709e-004	4.9998e-002	7.e-003	-4.5716e-005
1771	-4.9702e-004	4.9998e-002	7.e-003	-4.5716e-005
1772	-1.491e-003	4.9978e-002	7.e-003	-4.5682e-005
1773	-2.4844e-003	4.9938e-002	7.e-003	-4.5613e-005
1774	-3.4768e-003	4.9879e-002	7.e-003	-4.551e-005
1775	-4.4678e-003	4.98e-002	7.e-003	-4.5372e-005
1776	-5.4571e-003	4.9701e-002	7.e-003	-4.5201e-005
1777	-6.4441e-003	4.9583e-002	7.e-003	-4.4996e-005
1778	-7.4287e-003	4.9445e-002	7.e-003	-4.4758e-005
1779	-8.4103e-003	4.9288e-002	7.e-003	-4.4486e-005
1780	-9.3886e-003	4.9111e-002	7.e-003	-4.4182e-005
1781	-1.0363e-002	4.8914e-002	7.e-003	-4.3845e-005
1782	-1.1334e-002	4.8699e-002	7.e-003	-4.3477e-005
1783	-1.23e-002	4.8464e-002	7.e-003	-4.3077e-005
1784	-1.3261e-002	4.8209e-002	7.e-003	-4.2647e-005
1785	-1.4217e-002	4.7936e-002	7.e-003	-4.2187e-005
1786	-1.5167e-002	4.7644e-002	7.e-003	-4.1697e-005
1787	-1.6111e-002	4.7333e-002	7.e-003	-4.1178e-005
1788	-1.7049e-002	4.7003e-002	7.e-003	-4.0631e-005
1789	-1.798e-002	4.6655e-002	7.e-003	-4.0057e-005
1790	-1.8904e-002	4.6289e-002	7.e-003	-3.9457e-005
1791	-1.9821e-002	4.5904e-002	7.e-003	-3.8831e-005
1792	-2.073e-002	4.55e-002	7.e-003	-3.8181e-005
1793	-2.163e-002	4.5079e-002	7.e-003	-3.7506e-005
1794	-2.2522e-002	4.464e-002	7.e-003	-3.681e-005
1795	-2.3405e-002	4.4184e-002	7.e-003	-3.6091e-005
1796	-2.4279e-002	4.371e-002	7.e-003	-3.5352e-005
1797	-2.5143e-002	4.3218e-002	7.e-003	-3.4594e-005
1798	-2.5992e-002	4.2713e-002	6.9929e-003	-3.382e-005
1799	-2.6833e-002	4.219e-002	6.9778e-003	-3.303e-005
1800	-2.7665e-002	4.1649e-002	6.969e-003	-3.2222e-005
1801	-2.8487e-002	4.1091e-002	6.9664e-003	-3.1396e-005
1802	-2.9301e-002	4.0515e-002	6.9722e-003	-3.0555e-005
1803	-3.0104e-002	3.9922e-002	6.9927e-003	-2.9701e-005
1804	-3.0084e-002	3.9937e-002	7.9964e-003	-2.9718e-005
1805	-3.0065e-002	3.9951e-002	8.9889e-003	-2.9738e-005
1806	-3.0047e-002	3.9965e-002	9.9867e-003	-2.9752e-005
1807	-3.0043e-002	3.9968e-002	1.0988e-002	-2.9756e-005
1808	-3.0049e-002	3.9964e-002	1.1992e-002	-2.9753e-005
1809	-3.0054e-002	3.996e-002	1.2994e-002	-2.9748e-005
1810	-3.0062e-002	3.9954e-002	1.3998e-002	-2.9741e-005
1811	-3.0068e-002	3.9949e-002	1.4995e-002	-2.9733e-005
1812	-3.008e-002	3.994e-002	1.5994e-002	-2.9723e-005
1813	-3.0088e-002	3.9934e-002	1.6988e-002	-2.9712e-005
1814	-3.01e-002	3.9925e-002	1.7985e-002	-2.9698e-005
1815	-3.0116e-002	3.9913e-002	1.8986e-002	-2.9681e-005
1816	-3.0134e-002	3.9899e-002	1.9987e-002	-2.9665e-005
1817	-3.0148e-002	3.9889e-002	2.0995e-002	-2.9653e-005
1818	-3.015e-002	3.9887e-002	2.2008e-002	-2.9651e-005
1819	-3.0137e-002	3.9897e-002	2.3015e-002	-2.966e-005
1820	-3.0126e-002	3.9905e-002	2.4016e-002	-2.9674e-005
1821	-3.0108e-002	3.9919e-002	2.5012e-002	-2.9689e-005
1822	-3.0097e-002	3.9927e-002	2.6005e-002	-2.9703e-005
1823	-3.0086e-002	3.9935e-002	2.6998e-002	-2.9711e-005
1824	-3.0087e-002	3.9935e-002	2.7998e-002	-2.9713e-005
1825	-3.0088e-002	3.9933e-002	2.8996e-002	-2.9713e-005
1826	-3.0086e-002	3.9935e-002	3.e-002	-2.9714e-005
1827	-3.0083e-002	3.9937e-002	3.0997e-002	-2.9715e-005
1828	-3.0091e-002	3.9932e-002	3.1997e-002	-2.9712e-005
1829	-3.0092e-002	3.9931e-002	3.2997e-002	-2.971e-005
1830	-3.0089e-002	3.9933e-002	3.3998e-002	-2.9711e-005
1831	-3.0085e-002	3.9936e-002	3.4998e-002	-2.9713e-005
1832	-3.009e-002	3.9932e-002	3.5997e-002	-2.9714e-005
1833	-3.0082e-002	3.9938e-002	3.6996e-002	-2.9716e-005
1834	-3.0083e-002	3.9938e-002	3.7996e-002	-2.9717e-005
1835	-3.0083e-002	3.9937e-002	3.8995e-002	-2.9716e-005
1836	-3.0085e-002	3.9936e-002	3.9994e-002	-2.9713e-005
1837	-3.0091e-002	3.9932e-002	4.0993e-002	-2.9708e-005
1838	-3.01e-002	3.9925e-002	4.1998e-002	-2.9701e-005
1839	-3.0108e-002	3.9919e-002	4.3e-002	-2.9694e-005
1840	-2.9309e-002	4.0509e-002	4.3e-002	-3.0546e-005
1841	-2.8498e-002	4.1084e-002	4.3e-002	-3.1385e-005
1842	-2.6842e-002	4.2184e-002	4.3e-002	-3.3021e-005
1843	-2.5998e-002	4.271e-002	4.3e-002	-3.3815e-005
1844	-2.5143e-002	4.3218e-002	4.3e-002	-3.4593e-005
1845	-2.4279e-002	4.371e-002	4.3e-002	-3.5352e-005
1846	-2.3405e-002	4.4184e-002	4.3e-002	-3.6091e-005
1847	-2.2522e-002	4.464e-002	4.3e-002	-3.681e-005
1848	-2.163e-002	4.5079e-002	4.3e-002	-3.7506e-005
1849	-2.073e-002	4.55e-002	4.3e-002	-3.8181e-005
1850	-1.9821e-002	4.5904e-002	4.3e-002	-3.8831e-005
1851	-1.8904e-002	4.6288e-002	4.3e-002	-3.9457e-005
1852	-1.798e-002	4.6655e-002	4.3e-002	-4.0057e-005
1853	-1.7049e-002	4.7003e-002	4.3e-002	-4.0631e-005
1854	-1.6111e-002	4.7333e-002	4.3e-002	-4.1178e-005
1855	-1.5167e-002	4.7644e-002	4.3e-002	-4.1697e-005
1856	-1.4217e-002	4.7936e-002	4.3e-002	-4.2186e-005
1857	-1.3261e-002	4.8209e-002	4.3e-002	-4.2647e-005
1858	-1.23e-002	4.8464e-002	4.3e-002	-4.3077e-005
1859	-1.1334e-002	4.8699e-002	4.3e-002	-4.3477e-005
1860	-1.0363e-002	4.8914e-002	4.3e-002	-4.3845e-005
1861	-9.3887e-003	4.9111e-002	4.3e-002	-4.4182e-005
1862	-8.4103e-003	4.9288e-002	4.3e-002	-4.4486e-005
1863	-7.4288e-003	4.9445e-002	4.3e-002	-4.4758e-005
1864	-6.4442e-003	4.9583e-002	4.3e-002	-4.4996e-005
1865	-5.4571e-003	4.9701e-002	4.3e-002	-4.5201e-005
1866	-4.4678e-003	4.98e-002	4.3e-002	-4.5372e-005
1867	-3.4769e-003	4.9879e-002	4.3e-002	-4.551e-005
1868	-2.4844e-003	4.9938e-002	4.3e-002	-4.5613e-005
1869	-1.4911e-003	4.9978e-002	4.3e-002	-4.5682e-005
1870	-4.971e-004	4.9998e-002	4.3e-002	-4.5716e-005
1871	4.9702e-004	4.9998e-002	4.3e-002	-4.5716e-005
1872	1.491e-003	4.9978e-002	4.3e-002	-4.5682e-005
1873	2.4844e-003	4.9938e-002	4.3e-002	-4.5613e-005
1874	3.4768e-003	4.9879e-002	4.3e-002	-4.551e-005
1875	4.4678e-003	4.98e-002	4.3e-002	-4.5372e-005
1876	5.457e-003	4.9701e-002	4.3e-002	-4.5201e-005
1877	6.4441e-003	4.9583e-002	4.3e-002	-4.4996e-005
1878	7.4287e-003	4.9445e-002	4.3e-002	-4.4758e-005
1879	8.4103e-003	4.9288e-002	4.3e-002	-4.4486e-005
1880	9.3886e-003	4.9111e-002	4.3e-002	-4.4182e-005
1881	1.0363e-002	4.8914e-002	4.3e-002	-4.3845e-005
1882	1.1334e-002	4.8699e-002	4.3e-002	-4.3477e-005
1883	1.23e-002	4.8464e-002	4.3e-002	-4.3077e-005
1884	1.3261e-002	4.8209e-002	4.3e-002	-4.2647e-005
1885	1.4217e-002	4.7936e-002	4.3e-002	-4.2186e-005
1886	1.5167e-002	4.7644e-002	4.3e-002	-4.1697e-005
1887	1.6111e-002	4.7333e-002	4.3e-002	-4.1178e-005
1888	1.7049e-002	4.7003e-002	4.3e-002	-4.0631e-005
1889	1.798e-002	4.6655e-002	4.3e-002	-4.0057e-005
1890	1.8904e-002	4.6289e-002	4.3e-002	-3.9457e-005
1891	1.9821e-002	4.5904e-002	4.3e-002	-3.8831e-005
1892	2.073e-002	4.55e-002	4.3e-002	-3.8181e-005
1893	2.163e-002	4.5079e-002	4.3e-002	-3.7506e-005
1894	2.2522e-002	4.464e-002	4.3e-002	-3.681e-005
1895	2.3405e-002	4.4184e-002	4.3e-002	-3.6091e-005
1896	2.4279e-002	4.371e-002	4.3e-002	-3.5352e-005
1897	2.5143e-002	4.3218e-002	4.3e-002	-3.4593e-005
1898	2.5998e-002	4.271e-002	4.3e-002	-3.3815e-005
1899	2.6842e-002	4.2184e-002	4.3e-002	-3.3021e-005
1900	2.7675e-002	4.1642e-002	4.3e-002	-3.221e-005
1901	2.8497e-002	4.1084e-002	4.3e-002	-3.1384e-005
1902	2.9309e-002	4.0509e-002	4.3e-002	-3.0544e-005
1903	3.0108e-002	3.9918e-002	4.3e-002	-2.9692e-005
1904	3.0108e-002	3.9918e-002	4.2e-002	-2.9692e-005
1905	3.0108e-002	3.9918e-002	4.1e-002	-2.9692e-005
1906	3.0108e-002	3.9918e-002	4.e-002	-2.9692e-005
1907	3.0109e-002	3.9918e-002	3.9e-002	-2.9692e-005
1908	3.0109e-002	3.9918e-002	3.8e-002	-2.9692e-005
1909	3.0109e-002	3.9918e-002	3.7e-002	-2.9692e-005
1910	3.0109e-002	3.9918e-002	3.6e-002	-2.9692e-005
1911	3.0109e-002	3.9918e-002	3.5e-002	-2.9692e-005
1912	3.0109e-002	3.9918e-002	3.4e-002	-2.9692e-005
1913	3.0109e-002	3.9918e-002	3.3e-002	-2.9692e-005
1914	3.0109e-002	3.9918e-002	3.2e-002	-2.9692e-005
1915	3.0109e-002	3.9918e-002	3.1e-002	-2.9692e-005
1916	3.0109e-002	3.9918e-002	3.e-002	-2.9692e-005
1917	3.0109e-002	3.9918e-002	2.9e-002	-2.9692e-005
1918	3.0109e-002	3.9918e-002	2.8e-002	-2.9692e-005
1919	3.0109e-002	3.9918e-002	2.7e-002	-2.9692e-005
1920	3.0109e-002	3.9918e-002	2.6e-002	-2.9692e-005
1921	3.0109e-002	3.9918e-002	2.5e-002	-2.9692e-005
1922	3.0109e-002	3.9918e-002	2.4e-002	-2.9692e-005
1923	3.0109e-002	3.9918e-002	2.3e-002	-2.9692e-005
1924	3.0109e-002	3.9918e-002	2.2e-002	-2.9692e-005
1925	3.0109e-002	3.9918e-002	2.1e-002	-2.9692e-005
1926	3.0109e-002	3.9918e-002	2.e-002	-2.9692e-005
1927	3.0109e-002	3.9918e-002	1.9e-002	-2.9692e-005
1928	3.0109e-002	3.9918e-002	1.8e-002	-2.9692e-005
1929	3.0109e-002	3.9918e-002	1.7e-002	-2.9692e-005
1930	3.0109e-002	3.9918e-002	1.6e-002	-2.9692e-005
1931	3.0109e-002	3.9918e-002	1.5e-002	-2.9691e-005
1932	3.0109e-002	3.9918e-002	1.4e-002	-2.9691e-005
1933	3.0109e-002	3.9918e-002	1.3e-002	-2.9691e-005
1934	3.0109e-002	3.9918e-002	1.2e-002	-2.9691e-005
1935	3.0109e-002	3.9918e-002	1.1e-002	-2.9691e-005
1936	3.0109e-002	3.9918e-002	1.e-002	-2.9691e-005
1937	3.0109e-002	3.9918e-002	9.e-003	-2.9691e-005
1938	3.0109e-002	3.9918e-002	8.e-003	-2.9691e-005
1939	-2.9301e-002	4.0515e-002	4.1998e-002	-3.0552e-005
1940	-2.8493e-002	4.1087e-002	4.2002e-002	-3.1388e-005
1941	-2.7675e-002	4.1642e-002	4.2e-002	-3.2211e-005
1942	-2.6842e-002	4.2184e-002	4.2e-002	-3.3021e-005
1943	-2.5998e-002	4.271e-002	4.2e-002	-3.3815e-005
1944	-2.5143e-002	4.3218e-002	4.2e-002	-3.4593e-005
1945	-2.4279e-002	4.371e-002	4.2e-002	-3.5352e-005
1946	-2.3405e-002	4.4184e-002	4.2e-002	-3.6091e-005
1947	-2.2522e-002	4.464e-002	4.2e-002	-3.681e-005
1948	-2.163e-002	4.5079e-002	4.2e-002	-3.7506e-005
1949	-2.073e-002	4.55e-002	4.2e-002	-3.8181e-005
1950	-1.9821e-002	4.5904e-002	4.2e-002	-3.8831e-005
1951	-1.8904e-002	4.6288e-002	4.2e-002	-3.9457e-005
1952	-1.798e-002	4.6655e-002	4.2e-002	-4.0057e-005
1953	-1.7049e-002	4.7003e-002	4.2e-002	-4.0631e-005
1954	-1.6111e-002	4.7333e-002	4.2e-002	-4.1178e-005
1955	-1.5167e-002	4.7644e-002	4.2e-002	-4.1697e-005
1956	-1.4217e-002	4.7936e-002	4.2e-002	-4.2186e-005
1957	-1.3261e-002	4.8209e-002	4.2e-002	-4.2647e-005
1958	-1.23e-002	4.8464e-002	4.2e-002	-4.3077e-005
1959	-1.1334e-002	4.8699e-002	4.2e-002	-4.3477e-005
1960	-1.0363e-002	4.8914e-002	4.2e-002	-4.3845e-005
1961	-9.3887e-003	4.9111e-002	4.2e-002	-4.4182e-005
1962	-8.4103e-003	4.9288e-002	4.2e-002	-4.4486e-005
1963	-7.4288e-003	4.9445e-002	4.2e-002	-4.4758e-005
1964	-6.4442e-003	4.9583e-002	4.2e-002	-4.4996e-005
1965	-5.4571e-003	4.9701e-002	4.2e-002	-4.5201e-005
1966	-4.4678e-003	4.98e-002	4.2e-002	-4.5372e-005
1967	-3.4769e-003	4.9879e-002	4.2e-002	-4.551e-005
1968	-2.4844e-003	4.9938e-002	4.2e-002	-4.5613e-005
1969	-1.4911e-003	4.9978e-002	4.2e-002	-4.5682e-005
1970	-4.9708e-004	4.9998e-002	4.2e-002	-4.5716e-005
1971	4.9702e-004	4.9998e-002	4.2e-002	-4.5716e-005
1972	1.491e-003	4.9978e-002	4.2e-002	-4.5682e-005
1973	2.4844e-003	4.9938e-002	4.2e-002	-4.5613e-005
1974	3.4768e-003	4.9879e-002	4.2e-002	-4.551e-005
1975	4.4678e-003	4.98e-002	4.2e-002	-4.5372e-005
1976	5.4571e-003	4.9701e-002	4.2e-002	-4.5201e-005
1977	6.4441e-003	4.9583e-002	4.2e-002	-4.4996e-005
1978	7.4287e-003	4.9445e-002	4.2e-002	-4.4758e-005
1979	8.4103e-003	4.9288e-002	4.2e-002	-4.4486e-005
1980	9.3886e-003	4.9111e-002	4.2e-002	-4.4182e-005
1981	1.0363e-002	4.8914e-002	4.2e-002	-4.3845e-005
1982	1.1334e-002	4.8699e-002	4.2e-002	-4.3477e-005
1983	1.23e-002	4.8464e-002	4.2e-002	-4.3077e-005
1984	1.3261e-002	4.8209e-002	4.2e-002	-4.2647e-005
1985	1.4217e-002	4.7936e-002	4.2e-002	-4.2187e-005
1986	1.5167e-002	4.7644e-002	4.2e-002	-4.1697e-005
1987	1.6111e-002	4.7333e-002	4.2e-002	-4.1178e-005
1988	1.7049e-002	4.7003e-002	4.2e-002	-4.0631e-005
1989	1.798e-002	4.6655e-002	4.2e-002	-4.0057e-005
1990	1.8904e-002	4.6289e-002	4.2e-002	-3.9457e-005
1991	1.9821e-002	4.5904e-002	4.2e-002	-3.8831e-005
1992	2.073e-002	4.55e-002	4.2e-002	-3.8181e-005
1993	2.163e-002	4.5079e-002	4.2e-002	-3.7507e-005
1994	2.2522e-002	4.464e-002	4.2e-002	-3.681e-005
1995	2.3405e-002	4.4184e-002	4.2e-002	-3.6091e-005
1996	2.4279e-002	4.371e-002	4.2e-002	-3.5352e-005
1997	2.5143e-002	4.3218e-002	4.2e-002	-3.4593e-005
1998	2.5998e-002	4.271e-002	4.2e-002	-3.3815e-005
1999	2.6842e-002	4.2184e-002	4.2e-002	-3.3021e-005
2000	2.7675e-002	4.1642e-002	4.2e-002	-3.221e-005
2001	2.8497e-002	4.1084e-002	4.2e-002	-3.1384e-005
2002	2.9309e-002	4.0509e-002	4.2e-002	-3.0544e-005
2003	2.9309e-002	4.0509e-002	4.1e-002	-3.0544e-005
2004	2.9309e-002	4.0509e-002	4.e-002	-3.0544e-005
2005	2.9309e-002	4.0509e-002	3.9e-002	-3.0544e-005
2006	2.9309e-002	4.0509e-002	3.8e-002	-3.0544e-005
2007	2.9309e-002	4.0509e-002	3.7e-002	-3.0544e-005
2008	2.9309e-002	4.0509e-002	3.6e-002	-3.0544e-005
2009	2.9309e-002	4.0509e-002	3.5e-002	-3.0544e-005
2010	2.9309e-002	4.0509e-002	3.4e-002	-3.0544e-005
2011	2.9309e-002	4.0509e-002	3.3e-002	-3.0544e-005
2012	2.9309e-002	4.0509e-002	3.2e-002	-3.0544e-005
2013	2.9309e-002	4.0509e-002	3.e-002	-3.0544e-005
2014	2.9309e-002	4.0509e-002	2.8e-002	-3.0544e-005
2015	2.9309e-002	4.0509e-002	2.6e-002	-3.0544e-005
2016	2.9309e-002	4.0509e-002	2.4e-002	-3.0544e-005
2017	2.9309e-002	4.0509e-002	2.2e-002	-3.0544e-005
2018	2.9309e-002	4.0509e-002	2.e-002	-3.0544e-005
2019	2.9309e-002	4.0509e-002	1.8e-002	-3.0543e-005
2020	2.9309e-002	4.0509e-002	1.6e-002	-3.0543e-005
2021	2.9309e-002	4.0509e-002	1.4e-002	-3.0543e-005
2022	2.9309e-002	4.0509e-002	1.3e-002	-3.0543e-005
2023	2.931e-002	4.0509e-002	1.2e-002	-3.0543e-005
2024	2.931e-002	4.0509e-002	1.1e-002	-3.0543e-005
2025	2.931e-002	4.0509e-002	9.9999e-003	-3.0543e-005
2026	2.931e-002	4.0509e-002	8.9999e-003	-3.0543e-005
2027	2.931e-002	4.0508e-002	7.9999e-003	-3.0544e-005
2028	2.8498e-002	4.1084e-002	8.e-003	-3.1383e-005
2029	2.7675e-002	4.1642e-002	8.e-003	-3.221e-005
2030	2.5998e-002	4.271e-002	8.e-003	-3.3815e-005
2031	2.4279e-002	4.371e-002	8.e-003	-3.5352e-005
2032	2.2522e-002	4.464e-002	8.e-003	-3.681e-005
2033	2.073e-002	4.55e-002	8.e-003	-3.8181e-005
2034	1.8904e-002	4.6289e-002	8.e-003	-3.9457e-005
2035	1.7049e-002	4.7003e-002	8.e-003	-4.0631e-005
2036	1.5167e-002	4.7644e-002	8.e-003	-4.1697e-005
2037	1.3261e-002	4.8209e-002	8.e-003	-4.2647e-005
2038	1.1334e-002	4.8699e-002	8.e-003	-4.3477e-005
2039	9.3886e-003	4.9111e-002	8.e-003	-4.4182e-005
2040	7.4287e-003	4.9445e-002	8.e-003	-4.4758e-005
2041	5.4571e-003	4.9701e-002	8.e-003	-4.5201e-005
2042	3.4768e-003	4.9879e-002	8.e-003	-4.551e-005
2043	1.4911e-003	4.9978e-002	8.e-003	-4.5682e-005
2044	-4.9704e-004	4.9998e-002	8.e-003	-4.5716e-005
2045	-2.4844e-003	4.9938e-002	8.e-003	-4.5613e-005
2046	-4.4678e-003	4.98e-002	8.e-003	-4.5372e-005
2047	-6.4441e-003	4.9583e-002	8.e-003	-4.4996e-005
2048	-8.4103e-003	4.9288e-002	8.e-003	-4.4486e-005
2049	-1.0363e-002	4.8914e-002	8.e-003	-4.3845e-005
2050	-1.23e-002	4.8464e-002	8.e-003	-4.3077e-005
2051	-1.4217e-002	4.7936e-002	8.e-003	-4.2187e-005
2052	-1.6111e-002	4.7333e-002	8.e-003	-4.1178e-005
2053	-1.798e-002	4.6655e-002	8.e-003	-4.0057e-005
2054	-1.9821e-002	4.5904e-002	8.e-003	-3.8831e-005
2055	-2.163e-002	4.5079e-002	8.e-003	-3.7507e-005
2056	-2.3405e-002	4.4184e-002	8.e-003	-3.6091e-005
2057	-2.5143e-002	4.3218e-002	8.e-003	-3.4596e-005
2058	-2.682e-002	4.2198e-002	7.9663e-003	-3.3039e-005
2059	-2.7651e-002	4.1659e-002	7.954e-003	-3.2234e-005
2060	-2.8472e-002	4.1102e-002	7.9551e-003	-3.1411e-005
2061	-2.9282e-002	4.0528e-002	7.9677e-003	-3.0572e-005
2062	-2.926e-002	4.0545e-002	8.9743e-003	-3.0592e-005
2063	-2.8451e-002	4.1116e-002	8.9602e-003	-3.1428e-005
2064	-2.9244e-002	4.0556e-002	9.9807e-003	-3.0607e-005
2065	-2.9243e-002	4.0557e-002	1.0988e-002	-3.0611e-005
2066	-2.9244e-002	4.0556e-002	1.1995e-002	-3.061e-005
2067	-2.9247e-002	4.0553e-002	1.3e-002	-3.0608e-005
2068	-2.925e-002	4.0551e-002	1.4003e-002	-3.0605e-005
2069	-2.9259e-002	4.0545e-002	1.4999e-002	-3.0597e-005
2070	-2.9271e-002	4.0537e-002	1.5995e-002	-3.0584e-005
2071	-2.9307e-002	4.0511e-002	1.7993e-002	-3.0546e-005
2072	-2.9354e-002	4.0476e-002	2.0001e-002	-3.0499e-005
2073	-2.9378e-002	4.0459e-002	2.2018e-002	-3.0475e-005
2074	-2.9337e-002	4.0489e-002	2.4025e-002	-3.0512e-005
2075	-2.9298e-002	4.0517e-002	2.6007e-002	-3.0553e-005
2076	-2.9283e-002	4.0528e-002	2.7997e-002	-3.0568e-005
2077	-2.9284e-002	4.0527e-002	2.9996e-002	-3.0568e-005
2078	-2.9284e-002	4.0527e-002	3.0996e-002	-3.0569e-005
2079	-2.9284e-002	4.0527e-002	3.1995e-002	-3.0569e-005
2080	-2.9286e-002	4.0526e-002	3.2995e-002	-3.0567e-005
2081	-2.9288e-002	4.0525e-002	3.3995e-002	-3.0566e-005
2082	-2.9287e-002	4.0525e-002	3.4995e-002	-3.0567e-005
2083	-2.9286e-002	4.0526e-002	3.5995e-002	-3.0567e-005
2084	-2.9286e-002	4.0525e-002	3.6995e-002	-3.0567e-005
2085	-2.9288e-002	4.0525e-002	3.7995e-002	-3.0567e-005
2086	-2.9289e-002	4.0523e-002	3.8995e-002	-3.0565e-005
2087	-2.9293e-002	4.0521e-002	3.9998e-002	-3.0561e-005
2088	-2.9297e-002	4.0518e-002	4.0999e-002	-3.0557e-005
2089	2.8497e-002	4.1084e-002	4.1e-002	-3.1384e-005
2090	2.7675e-002	4.1642e-002	4.1e-002	-3.221e-005
2091	2.8497e-002	4.1084e-002	4.e-002	-3.1384e-005
2092	2.8497e-002	4.1084e-002	3.9e-002	-3.1384e-005
2093	2.8498e-002	4.1084e-002	3.8e-002	-3.1384e-005
2094	2.8498e-002	4.1084e-002	3.7e-002	-3.1384e-005
2095	2.8498e-002	4.1084e-002	3.6e-002	-3.1384e-005
2096	2.8498e-002	4.1084e-002	3.5e-002	-3.1384e-005
2097	2.8498e-002	4.1084e-002	3.4e-002	-3.1384e-005
2098	2.8498e-002	4.1083e-002	3.3e-002	-3.1384e-005
2099	2.8498e-002	4.1083e-002	3.2e-002	-3.1384e-005
2100	2.8498e-002	4.1083e-002	3.1e-002	-3.1384e-005
2101	2.8499e-002	4.1083e-002	3.e-002	-3.1384e-005
2102	2.8499e-002	4.1083e-002	2.9e-002	-3.1384e-005
2103	2.8499e-002	4.1083e-002	2.8e-002	-3.1384e-005
2104	2.8499e-002	4.1083e-002	2.7e-002	-3.1384e-005
2105	2.8499e-002	4.1083e-002	2.6e-002	-3.1384e-005
2106	2.8499e-002	4.1083e-002	2.5e-002	-3.1384e-005
2107	2.8499e-002	4.1083e-002	2.4e-002	-3.1384e-005
2108	2.8499e-002	4.1083e-002	2.3e-002	-3.1384e-005
2109	2.85e-002	4.1083e-002	2.2e-002	-3.1384e-005
2110	2.85e-002	4.1082e-002	2.1e-002	-3.1384e-005
2111	2.85e-002	4.1082e-002	2.e-002	-3.1384e-005
2112	2.85e-002	4.1082e-002	1.9e-002	-3.1384e-005
2113	2.85e-002	4.1082e-002	1.8e-002	-3.1383e-005
2114	2.85e-002	4.1082e-002	1.7e-002	-3.1383e-005
2115	2.85e-002	4.1082e-002	1.6e-002	-3.1383e-005
2116	2.85e-002	4.1082e-002	1.5e-002	-3.1383e-005
2117	2.85e-002	4.1082e-002	1.4e-002	-3.1383e-005
2118	2.8501e-002	4.1082e-002	1.3e-002	-3.1383e-005
2119	2.8501e-002	4.1082e-002	1.2e-002	-3.1383e-005
2120	2.8501e-002	4.1082e-002	1.1e-002	-3.1383e-005
2121	2.8501e-002	4.1082e-002	9.9998e-003	-3.1383e-005
2122	2.8501e-002	4.1082e-002	8.9998e-003	-3.1383e-005
2123	2.7675e-002	4.1642e-002	9.e-003	-3.221e-005
2124	2.6842e-002	4.2184e-002	9.e-003	-3.3021e-005
2125	2.5998e-002	4.271e-002	9.e-003	-3.3815e-005
2126	2.5143e-002	4.3218e-002	9.e-003	-3.4593e-005
2127	2.4279e-002	4.371e-002	9.e-003	-3.5352e-005
2128	2.3405e-002	4.4184e-002	9.e-003	-3.6091e-005
2129	2.2522e-002	4.464e-002	9.e-003	-3.681e-005
2130	2.163e-002	4.5079e-002	9.e-003	-3.7506e-005
2131	2.073e-002	4.55e-002	9.e-003	-3.8181e-005
2132	1.9821e-002	4.5904e-002	9.e-003	-3.8831e-005
2133	1.8904e-002	4.6288e-002	9.e-003	-3.9457e-005
2134	1.798e-002	4.6655e-002	9.e-003	-4.0057e-005
2135	1.7049e-002	4.7003e-002	9.e-003	-4.0631e-005
2136	1.6111e-002	4.7333e-002	9.e-003	-4.1178e-005
2137	1.5167e-002	4.7644e-002	9.e-003	-4.1697e-005
2138	1.4217e-002	4.7936e-002	9.e-003	-4.2187e-005
2139	1.3261e-002	4.8209e-002	9.e-003	-4.2647e-005
2140	1.23e-002	4.8464e-002	9.e-003	-4.3077e-005
2141	1.1334e-002	4.8699e-002	9.e-003	-4.3477e-005
2142	1.0363e-002	4.8914e-002	9.e-003	-4.3845e-005
2143	9.3887e-003	4.9111e-002	9.e-003	-4.4182e-005
2144	8.4103e-003	4.9288e-002	9.e-003	-4.4486e-005
2145	7.4288e-003	4.9445e-002	9.e-003	-4.4758e-005
2146	6.4442e-003	4.9583e-002	9.e-003	-4.4996e-005
2147	5.4571e-003	4.9701e-002	9.e-003	-4.5201e-005
2148	4.4678e-003	4.98e-002	9.e-003	-4.5372e-005
2149	3.4769e-003	4.9879e-002	9.e-003	-4.551e-005
2150	2.4844e-003	4.9938e-002	9.e-003	-4.5613e-005
2151	1.4911e-003	4.9978e-002	9.e-003	-4.5682e-005
2152	4.9709e-004	4.9998e-002	9.e-003	-4.5716e-005
2153	-4.9701e-004	4.9998e-002	9.e-003	-4.5716e-005
2154	-1.491e-003	4.9978e-002	9.e-003	-4.5682e-005
2155	-2.4843e-003	4.9938e-002	9.e-003	-4.5613e-005
2156	-3.4768e-003	4.9879e-002	9.e-003	-4.551e-005
2157	-4.4678e-003	4.98e-002	9.e-003	-4.5372e-005
2158	-5.4571e-003	4.9701e-002	9.e-003	-4.5201e-005
2159	-6.4441e-003	4.9583e-002	9.e-003	-4.4996e-005
2160	-7.4287e-003	4.9445e-002	9.e-003	-4.4758e-005
2161	-8.4102e-003	4.9288e-002	9.e-003	-4.4486e-005
2162	-9.3886e-003	4.9111e-002	9.e-003	-4.4182e-005
2163	-1.0363e-002	4.8914e-002	9.e-003	-4.3845e-005
2164	-1.1334e-002	4.8699e-002	9.e-003	-4.3477e-005
2165	-1.23e-002	4.8464e-002	9.e-003	-4.3077e-005
2166	-1.3261e-002	4.8209e-002	9.e-003	-4.2647e-005
2167	-1.4217e-002	4.7936e-002	9.e-003	-4.2187e-005
2168	-1.5167e-002	4.7644e-002	9.e-003	-4.1697e-005
2169	-1.6111e-002	4.7333e-002	9.e-003	-4.1178e-005
2170	-1.7049e-002	4.7003e-002	9.e-003	-4.0631e-005
2171	-1.798e-002	4.6655e-002	9.e-003	-4.0057e-005
2172	-1.8904e-002	4.6289e-002	9.e-003	-3.9457e-005
2173	-1.9821e-002	4.5904e-002	9.e-003	-3.8831e-005
2174	-2.073e-002	4.55e-002	9.e-003	-3.8181e-005
2175	-2.163e-002	4.5079e-002	9.e-003	-3.7507e-005
2176	-2.2522e-002	4.464e-002	9.e-003	-3.681e-005
2177	-2.3405e-002	4.4184e-002	9.e-003	-3.6091e-005
2178	-2.4279e-002	4.371e-002	9.e-003	-3.5353e-005
2179	-2.5135e-002	4.3223e-002	8.9959e-003	-3.4599e-005
2180	-2.5981e-002	4.272e-002	8.988e-003	-3.3832e-005
2181	-2.6811e-002	4.2204e-002	8.9643e-003	-3.3048e-005
2182	-2.7638e-002	4.1667e-002	8.9609e-003	-3.2247e-005
2183	-2.8438e-002	4.1125e-002	9.9704e-003	-3.1441e-005
2184	-2.8435e-002	4.1127e-002	1.0985e-002	-3.1445e-005
2185	-2.8488e-002	4.109e-002	4.1002e-002	-3.1391e-005
2186	-2.7675e-002	4.1642e-002	4.1e-002	-3.2212e-005
2187	-2.6842e-002	4.2184e-002	4.1e-002	-3.3021e-005
2188	-2.5998e-002	4.271e-002	4.1e-002	-3.3815e-005
2189	-2.5143e-002	4.3218e-002	4.1e-002	-3.4593e-005
2190	-2.4279e-002	4.371e-002	4.1e-002	-3.5352e-005
2191	-2.3405e-002	4.4184e-002	4.1e-002	-3.6091e-005
2192	-2.2522e-002	4.464e-002	4.1e-002	-3.681e-005
2193	-2.163e-002	4.5079e-002	4.1e-002	-3.7506e-005
2194	-2.073e-002	4.55e-002	4.1e-002	-3.8181e-005
2195	-1.9821e-002	4.5904e-002	4.1e-002	-3.8831e-005
2196	-1.8904e-002	4.6288e-002	4.1e-002	-3.9457e-005
2197	-1.798e-002	4.6655e-002	4.1e-002	-4.0057e-005
2198	-1.7049e-002	4.7003e-002	4.1e-002	-4.0631e-005
2199	-1.6111e-002	4.7333e-002	4.1e-002	-4.1178e-005
2200	-1.5167e-002	4.7644e-002	4.1e-002	-4.1697e-005
2201	-1.4217e-002	4.7936e-002	4.1e-002	-4.2186e-005
2202	-1.3261e-002	4.8209e-002	4.1e-002	-4.2647e-005
2203	-1.23e-002	4.8464e-002	4.1e-002	-4.3077e-005
2204	-1.1334e-002	4.8699e-002	4.1e-002	-4.3477e-005
2205	-1.0363e-002	4.8914e-002	4.1e-002	-4.3845e-005
2206	-9.3887e-003	4.9111e-002	4.1e-002	-4.4182e-005
2207	-8.4103e-003	4.9288e-002	4.1e-002	-4.4486e-005
2208	-7.4288e-003	4.9445e-002	4.1e-002	-4.4758e-005
2209	-6.4442e-003	4.9583e-002	4.1e-002	-4.4996e-005
2210	-5.4571e-003	4.9701e-002	4.1e-002	-4.5201e-005
2211	-4.4678e-003	4.98e-002	4.1e-002	-4.5372e-005
2212	-3.4769e-003	4.9879e-002	4.1e-002	-4.551e-005
2213	-2.4844e-003	4.9938e-002	4.1e-002	-4.5613e-005
2214	-1.4911e-003	4.9978e-002	4.1e-002	-4.5682e-005
2215	-4.971e-004	4.9998e-002	4.1e-002	-4.5716e-005
2216	4.9702e-004	4.9998e-002	4.1e-002	-4.5716e-005
2217	1.491e-003	4.9978e-002	4.1e-002	-4.5682e-005
2218	2.4844e-003	4.9938e-002	4.1e-002	-4.5613e-005
2219	3.4768e-003	4.9879e-002	4.1e-002	-4.551e-005
2220	4.4678e-003	4.98e-002	4.1e-002	-4.5372e-005
2221	5.457e-003	4.9701e-002	4.1e-002	-4.5201e-005
2222	6.4441e-003	4.9583e-002	4.1e-002	-4.4996e-005
2223	7.4287e-003	4.9445e-002	4.1e-002	-4.4758e-005
2224	8.4103e-003	4.9288e-002	4.1e-002	-4.4486e-005
2225	9.3886e-003	4.9111e-002	4.1e-002	-4.4182e-005
2226	1.0363e-002	4.8914e-002	4.1e-002	-4.3845e-005
2227	1.1334e-002	4.8699e-002	4.1e-002	-4.3477e-005
2228	1.23e-002	4.8464e-002	4.1e-002	-4.3077e-005
2229	1.3261e-002	4.8209e-002	4.1e-002	-4.2647e-005
2230	1.4217e-002	4.7936e-002	4.1e-002	-4.2187e-005
2231	1.5167e-002	4.7644e-002	4.1e-002	-4.1697e-005
2232	1.6111e-002	4.7333e-002	4.1e-002	-4.1178e-005
2233	1.7049e-002	4.7004e-002	4.1e-002	-4.0631e-005
2234	1.798e-002	4.6655e-002	4.1e-002	-4.0057e-005
2235	1.8904e-002	4.6289e-002	4.1e-002	-3.9457e-005
2236	1.9821e-002	4.5904e-002	4.1e-002	-3.8831e-005
2237	2.073e-002	4.55e-002	4.1e-002	-3.8181e-005
2238	2.163e-002	4.5079e-002	4.1e-002	-3.7507e-005
2239	2.2522e-002	4.464e-002	4.1e-002	-3.681e-005
2240	2.3405e-002	4.4184e-002	4.1e-002	-3.6091e-005
2241	2.4279e-002	4.371e-002	4.1e-002	-3.5352e-005
2242	2.5143e-002	4.3218e-002	4.1e-002	-3.4593e-005
2243	2.5998e-002	4.271e-002	4.1e-002	-3.3815e-005
2244	2.6842e-002	4.2184e-002	4.1e-002	-3.3021e-005
2245	-2.7623e-002	4.1677e-002	1.0982e-002	-3.2261e-005
2246	-2.8492e-002	4.1088e-002	4.e-002	-3.1393e-005
2247	-2.8482e-002	4.1095e-002	3.9e-002	-3.1396e-005
2248	-2.8481e-002	4.1095e-002	3.7999e-002	-3.14e-005
2249	-2.848e-002	4.1096e-002	3.6998e-002	-3.1401e-005
2250	-2.8478e-002	4.1097e-002	3.5998e-002	-3.1402e-005
2251	-2.8478e-002	4.1098e-002	3.4997e-002	-3.1402e-005
2252	-2.8477e-002	4.1098e-002	3.3998e-002	-3.1403e-005
2253	-2.8475e-002	4.11e-002	3.2998e-002	-3.1404e-005
2254	-2.8474e-002	4.11e-002	3.1998e-002	-3.1406e-005
2255	-2.8472e-002	4.1101e-002	3.0999e-002	-3.1406e-005
2256	-2.8479e-002	4.1097e-002	2.9998e-002	-3.1404e-005
2257	-2.8479e-002	4.1097e-002	2.8998e-002	-3.1403e-005
2258	-2.8478e-002	4.1097e-002	2.7998e-002	-3.1404e-005
2259	-2.8477e-002	4.1098e-002	2.6999e-002	-3.14e-005
2260	-2.8492e-002	4.1088e-002	2.6012e-002	-3.1389e-005
2261	-2.8513e-002	4.1073e-002	2.5025e-002	-3.1367e-005
2262	-2.8545e-002	4.1051e-002	2.4034e-002	-3.1338e-005
2263	-2.8581e-002	4.1026e-002	2.3037e-002	-3.1308e-005
2264	-2.8603e-002	4.1011e-002	2.2033e-002	-3.1292e-005
2265	-2.8586e-002	4.1022e-002	2.1026e-002	-3.1299e-005
2266	-2.8559e-002	4.1041e-002	2.002e-002	-3.1322e-005
2267	-2.8535e-002	4.1058e-002	1.9017e-002	-3.1348e-005
2268	-2.85e-002	4.1082e-002	1.8011e-002	-3.1378e-005
2269	-2.8475e-002	4.11e-002	1.7005e-002	-3.1405e-005
2270	-2.845e-002	4.1117e-002	1.6005e-002	-3.1426e-005
2271	-2.8433e-002	4.1128e-002	1.5007e-002	-3.1442e-005
2272	-2.8428e-002	4.1132e-002	1.4009e-002	-3.1449e-005
2273	-2.8431e-002	4.113e-002	1.3004e-002	-3.1448e-005
2274	-2.8436e-002	4.1126e-002	1.1995e-002	-3.1446e-005
2275	-2.7622e-002	4.1677e-002	1.1991e-002	-3.2263e-005
2276	-2.6802e-002	4.221e-002	9.9715e-003	-3.3055e-005
2277	2.7675e-002	4.1642e-002	4.e-002	-3.221e-005
2278	-2.68e-002	4.2211e-002	1.0979e-002	-3.3059e-005
2279	2.7675e-002	4.1642e-002	3.9e-002	-3.221e-005
2280	2.7675e-002	4.1642e-002	3.8e-002	-3.221e-005
2281	2.7675e-002	4.1643e-002	3.7e-002	-3.221e-005
2282	2.7675e-002	4.1643e-002	3.6e-002	-3.221e-005
2283	2.7675e-002	4.1643e-002	3.5e-002	-3.221e-005
2284	2.7675e-002	4.1643e-002	3.4e-002	-3.221e-005
2285	2.7674e-002	4.1643e-002	3.3e-002	-3.221e-005
2286	2.7674e-002	4.1643e-002	3.2e-002	-3.221e-005
2287	2.7674e-002	4.1643e-002	3.1e-002	-3.221e-005
2288	2.7674e-002	4.1643e-002	3.e-002	-3.221e-005
2289	2.7674e-002	4.1643e-002	2.9e-002	-3.221e-005
2290	2.7674e-002	4.1643e-002	2.8e-002	-3.221e-005
2291	2.7673e-002	4.1644e-002	2.7e-002	-3.221e-005
2292	2.7673e-002	4.1644e-002	2.6e-002	-3.221e-005
2293	2.7673e-002	4.1644e-002	2.5e-002	-3.221e-005
2294	2.7673e-002	4.1644e-002	2.4e-002	-3.2211e-005
2295	2.7673e-002	4.1644e-002	2.3e-002	-3.2211e-005
2296	2.7672e-002	4.1644e-002	2.2e-002	-3.2211e-005
2297	2.7672e-002	4.1644e-002	2.1e-002	-3.2211e-005
2298	2.7672e-002	4.1644e-002	2.e-002	-3.2211e-005
2299	2.7672e-002	4.1645e-002	1.9e-002	-3.2211e-005
2300	2.7672e-002	4.1645e-002	1.8e-002	-3.2211e-005
2301	2.7672e-002	4.1645e-002	1.7e-002	-3.2211e-005
2302	2.7671e-002	4.1645e-002	1.6e-002	-3.2211e-005
2303	2.7671e-002	4.1645e-002	1.5e-002	-3.2211e-005
2304	2.7671e-002	4.1645e-002	1.4e-002	-3.2211e-005
2305	2.7671e-002	4.1645e-002	1.3e-002	-3.2211e-005
2306	2.7671e-002	4.1645e-002	1.2e-002	-3.2211e-005
2307	2.767e-002	4.1646e-002	1.1e-002	-3.2211e-005
2308	2.767e-002	4.1646e-002	1.e-002	-3.2211e-005
2309	2.6842e-002	4.2184e-002	1.e-002	-3.3022e-005
2310	2.5998e-002	4.271e-002	1.e-002	-3.3815e-005
2311	2.4279e-002	4.371e-002	1.e-002	-3.5352e-005
2312	2.3405e-002	4.4184e-002	1.e-002	-3.6091e-005
2313	2.2522e-002	4.464e-002	1.e-002	-3.681e-005
2314	2.163e-002	4.5079e-002	1.e-002	-3.7506e-005
2315	2.073e-002	4.55e-002	1.e-002	-3.8181e-005
2316	1.9821e-002	4.5904e-002	1.e-002	-3.8831e-005
2317	1.8904e-002	4.6289e-002	1.e-002	-3.9457e-005
2318	1.798e-002	4.6655e-002	1.e-002	-4.0057e-005
2319	1.7049e-002	4.7003e-002	1.e-002	-4.0631e-005
2320	1.6111e-002	4.7333e-002	1.e-002	-4.1178e-005
2321	1.5167e-002	4.7644e-002	1.e-002	-4.1697e-005
2322	1.4217e-002	4.7936e-002	1.e-002	-4.2186e-005
2323	1.3261e-002	4.8209e-002	1.e-002	-4.2647e-005
2324	1.23e-002	4.8464e-002	1.e-002	-4.3077e-005
2325	1.1334e-002	4.8699e-002	1.e-002	-4.3477e-005
2326	1.0363e-002	4.8914e-002	1.e-002	-4.3845e-005
2327	9.3886e-003	4.9111e-002	1.e-002	-4.4182e-005
2328	8.4103e-003	4.9288e-002	1.e-002	-4.4486e-005
2329	7.4288e-003	4.9445e-002	1.e-002	-4.4758e-005
2330	6.4442e-003	4.9583e-002	1.e-002	-4.4996e-005
2331	5.4571e-003	4.9701e-002	1.e-002	-4.5201e-005
2332	4.4678e-003	4.98e-002	1.e-002	-4.5372e-005
2333	3.4769e-003	4.9879e-002	1.e-002	-4.551e-005
2334	2.4844e-003	4.9938e-002	1.e-002	-4.5613e-005
2335	1.4911e-003	4.9978e-002	1.e-002	-4.5682e-005
2336	4.9708e-004	4.9998e-002	1.e-002	-4.5716e-005
2337	-4.9703e-004	4.9998e-002	1.e-002	-4.5716e-005
2338	-1.491e-003	4.9978e-002	1.e-002	-4.5682e-005
2339	-2.4844e-003	4.9938e-002	1.e-002	-4.5613e-005
2340	-3.4768e-003	4.9879e-002	1.e-002	-4.551e-005
2341	-4.4678e-003	4.98e-002	1.e-002	-4.5372e-005
2342	-5.4571e-003	4.9701e-002	1.e-002	-4.5201e-005
2343	-6.4441e-003	4.9583e-002	1.e-002	-4.4996e-005
2344	-7.4287e-003	4.9445e-002	1.e-002	-4.4758e-005
2345	-8.4103e-003	4.9288e-002	1.e-002	-4.4486e-005
2346	-9.3886e-003	4.9111e-002	1.e-002	-4.4182e-005
2347	-1.0363e-002	4.8914e-002	1.e-002	-4.3845e-005
2348	-1.1334e-002	4.8699e-002	1.e-002	-4.3477e-005
2349	-1.23e-002	4.8464e-002	1.e-002	-4.3077e-005
2350	-1.3261e-002	4.8209e-002	1.e-002	-4.2647e-005
2351	-1.4217e-002	4.7936e-002	1.e-002	-4.2186e-005
2352	-1.5167e-002	4.7644e-002	1.e-002	-4.1697e-005
2353	-1.6111e-002	4.7333e-002	1.e-002	-4.1178e-005
2354	-1.7049e-002	4.7003e-002	1.e-002	-4.0631e-005
2355	-1.798e-002	4.6655e-002	1.e-002	-4.0057e-005
2356	-1.8904e-002	4.6289e-002	1.e-002	-3.9457e-005
2357	-1.9821e-002	4.5904e-002	1.e-002	-3.8831e-005
2358	-2.073e-002	4.55e-002	1.e-002	-3.8181e-005
2359	-2.163e-002	4.5079e-002	1.e-002	-3.7507e-005
2360	-2.2522e-002	4.464e-002	1.e-002	-3.681e-005
2361	-2.3405e-002	4.4184e-002	1.e-002	-3.6091e-005
2362	-2.4279e-002	4.371e-002	1.e-002	-3.5354e-005
2363	-2.5135e-002	4.3223e-002	9.9976e-003	-3.4602e-005
2364	-2.5975e-002	4.2724e-002	9.9876e-003	-3.3837e-005
2365	-2.7616e-002	4.1681e-002	1.3002e-002	-3.2266e-005
2366	-2.7612e-002	4.1684e-002	1.4008e-002	-3.2267e-005
2367	-2.762e-002	4.1679e-002	1.5011e-002	-3.2261e-005
2368	-2.7637e-002	4.1668e-002	1.6015e-002	-3.2246e-005
2369	-2.7662e-002	4.1651e-002	1.7025e-002	-3.2222e-005
2370	-2.7693e-002	4.1631e-002	1.8032e-002	-3.2193e-005
2371	-2.7726e-002	4.1608e-002	1.9038e-002	-3.2163e-005
2372	-2.778e-002	4.1572e-002	2.1047e-002	-3.2115e-005
2373	-2.7789e-002	4.1566e-002	2.205e-002	-3.2109e-005
2374	-2.7675e-002	4.1642e-002	4.e-002	-3.2212e-005
2375	-2.6842e-002	4.2184e-002	4.e-002	-3.3021e-005
2376	-2.5998e-002	4.271e-002	4.e-002	-3.3815e-005
2377	-2.5143e-002	4.3218e-002	4.e-002	-3.4593e-005
2378	-2.4279e-002	4.371e-002	4.e-002	-3.5352e-005
2379	-2.3405e-002	4.4184e-002	4.e-002	-3.6091e-005
2380	-2.2522e-002	4.464e-002	4.e-002	-3.681e-005
2381	-2.163e-002	4.5079e-002	4.e-002	-3.7506e-005
2382	-2.073e-002	4.55e-002	4.e-002	-3.8181e-005
2383	-1.9821e-002	4.5904e-002	4.e-002	-3.8831e-005
2384	-1.8904e-002	4.6288e-002	4.e-002	-3.9457e-005
2385	-1.798e-002	4.6655e-002	4.e-002	-4.0057e-005
2386	-1.7049e-002	4.7003e-002	4.e-002	-4.0631e-005
2387	-1.6111e-002	4.7333e-002	4.e-002	-4.1178e-005
2388	-1.5167e-002	4.7644e-002	4.e-002	-4.1697e-005
2389	-1.4217e-002	4.7936e-002	4.e-002	-4.2186e-005
2390	-1.3261e-002	4.8209e-002	4.e-002	-4.2647e-005
2391	-1.23e-002	4.8464e-002	4.e-002	-4.3077e-005
2392	-1.1334e-002	4.8699e-002	4.e-002	-4.3477e-005
2393	-1.0363e-002	4.8914e-002	4.e-002	-4.3845e-005
2394	-9.3887e-003	4.9111e-002	4.e-002	-4.4182e-005
2395	-8.4103e-003	4.9288e-002	4.e-002	-4.4486e-005
2396	-7.4288e-003	4.9445e-002	4.e-002	-4.4758e-005
2397	-6.4442e-003	4.9583e-002	4.e-002	-4.4996e-005
2398	-5.4572e-003	4.9701e-002	4.e-002	-4.5201e-005
2399	-4.4678e-003	4.98e-002	4.e-002	-4.5372e-005
2400	-3.4769e-003	4.9879e-002	4.e-002	-4.551e-005
2401	-2.4844e-003	4.9938e-002	4.e-002	-4.5613e-005
2402	-1.4911e-003	4.9978e-002	4.e-002	-4.5682e-005
2403	-4.9707e-004	4.9998e-002	4.e-002	-4.5716e-005
2404	4.9697e-004	4.9998e-002	4.e-002	-4.5716e-005
2405	1.491e-003	4.9978e-002	4.e-002	-4.5682e-005
2406	2.4843e-003	4.9938e-002	4.e-002	-4.5613e-005
2407	3.4768e-003	4.9879e-002	4.e-002	-4.551e-005
2408	4.4677e-003	4.98e-002	4.e-002	-4.5372e-005
2409	5.4571e-003	4.9701e-002	4.e-002	-4.5201e-005
2410	6.4441e-003	4.9583e-002	4.e-002	-4.4996e-005
2411	7.4287e-003	4.9445e-002	4.e-002	-4.4758e-005
2412	8.4102e-003	4.9288e-002	4.e-002	-4.4486e-005
2413	9.3886e-003	4.9111e-002	4.e-002	-4.4182e-005
2414	1.0363e-002	4.8914e-002	4.e-002	-4.3845e-005
2415	1.1334e-002	4.8699e-002	4.e-002	-4.3477e-005
2416	1.23e-002	4.8464e-002	4.e-002	-4.3077e-005
2417	1.3261e-002	4.8209e-002	4.e-002	-4.2647e-005
2418	1.4217e-002	4.7936e-002	4.e-002	-4.2187e-005
2419	1.5167e-002	4.7644e-002	4.e-002	-4.1697e-005
2420	1.6111e-002	4.7333e-002	4.e-002	-4.1178e-005
2421	1.7049e-002	4.7003e-002	4.e-002	-4.0631e-005
2422	1.798e-002	4.6655e-002	4.e-002	-4.0057e-005
2423	1.8904e-002	4.6289e-002	4.e-002	-3.9457e-005
2424	1.9821e-002	4.5904e-002	4.e-002	-3.8831e-005
2425	2.073e-002	4.55e-002	4.e-002	-3.8181e-005
2426	2.163e-002	4.5079e-002	4.e-002	-3.7507e-005
2427	2.2522e-002	4.464e-002	4.e-002	-3.681e-005
2428	2.3405e-002	4.4184e-002	4.e-002	-3.6091e-005
2429	2.4279e-002	4.371e-002	4.e-002	-3.5352e-005
2430	2.5143e-002	4.3218e-002	4.e-002	-3.4593e-005
2431	2.5998e-002	4.271e-002	4.e-002	-3.3815e-005
2432	2.6842e-002	4.2184e-002	4.e-002	-3.3021e-005
2433	-2.7675e-002	4.1642e-002	3.9e-002	-3.2214e-005
2434	-2.7667e-002	4.1648e-002	3.8e-002	-3.2217e-005
2435	-2.7666e-002	4.1648e-002	3.7e-002	-3.2219e-005
2436	-2.7666e-002	4.1649e-002	3.6e-002	-3.2219e-005
2437	-2.7665e-002	4.1649e-002	3.4999e-002	-3.222e-005
2438	-2.7664e-002	4.165e-002	3.3999e-002	-3.2221e-005
2439	-2.7664e-002	4.165e-002	3.3e-002	-3.2221e-005
2440	-2.7663e-002	4.1651e-002	3.2e-002	-3.2222e-005
2441	-2.7662e-002	4.1651e-002	3.1e-002	-3.2222e-005
2442	-2.7661e-002	4.1652e-002	3.e-002	-3.2222e-005
2443	-2.766e-002	4.1652e-002	2.9e-002	-3.2222e-005
2444	-2.7659e-002	4.1653e-002	2.8e-002	-3.2222e-005
2445	-2.7665e-002	4.1649e-002	2.7005e-002	-3.222e-005
2446	-2.767e-002	4.1646e-002	2.6012e-002	-3.221e-005
2447	-2.7695e-002	4.1629e-002	2.5031e-002	-3.2188e-005
2448	-2.773e-002	4.1606e-002	2.4038e-002	-3.2157e-005
2449	-2.7762e-002	4.1585e-002	2.3044e-002	-3.2126e-005
2450	2.6842e-002	4.2184e-002	1.1e-002	-3.3022e-005
2451	2.6842e-002	4.2184e-002	1.2e-002	-3.3022e-005
2452	2.6842e-002	4.2184e-002	1.3e-002	-3.3022e-005
2453	2.6842e-002	4.2184e-002	1.4e-002	-3.3022e-005
2454	2.6842e-002	4.2184e-002	1.5e-002	-3.3022e-005
2455	2.6842e-002	4.2184e-002	1.6e-002	-3.3022e-005
2456	2.6842e-002	4.2184e-002	1.7e-002	-3.3022e-005
2457	2.6842e-002	4.2184e-002	1.8e-002	-3.3022e-005
2458	2.6842e-002	4.2184e-002	1.9e-002	-3.3022e-005
2459	2.6842e-002	4.2184e-002	2.e-002	-3.3022e-005
2460	2.6842e-002	4.2184e-002	2.1e-002	-3.3021e-005
2461	2.6842e-002	4.2184e-002	2.2e-002	-3.3021e-005
2462	2.6842e-002	4.2184e-002	2.3e-002	-3.3021e-005
2463	2.6842e-002	4.2184e-002	2.4e-002	-3.3021e-005
2464	2.6842e-002	4.2184e-002	2.5e-002	-3.3021e-005
2465	2.6842e-002	4.2184e-002	2.6e-002	-3.3021e-005
2466	2.6842e-002	4.2184e-002	2.7e-002	-3.3021e-005
2467	2.6842e-002	4.2184e-002	2.8e-002	-3.3021e-005
2468	2.6842e-002	4.2184e-002	2.9e-002	-3.3021e-005
2469	2.6842e-002	4.2185e-002	3.e-002	-3.3021e-005
2470	2.6842e-002	4.2185e-002	3.1e-002	-3.3021e-005
2471	2.6841e-002	4.2185e-002	3.2e-002	-3.3021e-005
2472	2.6841e-002	4.2185e-002	3.3e-002	-3.3021e-005
2473	2.6841e-002	4.2185e-002	3.4e-002	-3.3021e-005
2474	2.6841e-002	4.2185e-002	3.5e-002	-3.3021e-005
2475	2.6841e-002	4.2185e-002	3.6e-002	-3.3021e-005
2476	2.5998e-002	4.271e-002	1.1e-002	-3.3815e-005
2477	2.5143e-002	4.3218e-002	1.1e-002	-3.4593e-005
2478	2.4279e-002	4.3709e-002	1.1e-002	-3.5352e-005
2479	2.3405e-002	4.4184e-002	1.1e-002	-3.6091e-005
2480	2.2522e-002	4.464e-002	1.1e-002	-3.681e-005
2481	2.163e-002	4.5079e-002	1.1e-002	-3.7506e-005
2482	2.073e-002	4.55e-002	1.1e-002	-3.8181e-005
2483	1.9821e-002	4.5904e-002	1.1e-002	-3.8831e-005
2484	1.8904e-002	4.6288e-002	1.1e-002	-3.9457e-005
2485	1.798e-002	4.6655e-002	1.1e-002	-4.0057e-005
2486	1.7049e-002	4.7003e-002	1.1e-002	-4.0631e-005
2487	1.6111e-002	4.7333e-002	1.1e-002	-4.1178e-005
2488	1.5167e-002	4.7644e-002	1.1e-002	-4.1697e-005
2489	1.4217e-002	4.7936e-002	1.1e-002	-4.2186e-005
2490	1.3261e-002	4.8209e-002	1.1e-002	-4.2647e-005
2491	1.23e-002	4.8464e-002	1.1e-002	-4.3077e-005
2492	1.1334e-002	4.8699e-002	1.1e-002	-4.3477e-005
2493	1.0363e-002	4.8914e-002	1.1e-002	-4.3845e-005
2494	9.3887e-003	4.9111e-002	1.1e-002	-4.4182e-005
2495	8.4103e-003	4.9288e-002	1.1e-002	-4.4486e-005
2496	7.4288e-003	4.9445e-002	1.1e-002	-4.4758e-005
2497	6.4442e-003	4.9583e-002	1.1e-002	-4.4996e-005
2498	5.4571e-003	4.9701e-002	1.1e-002	-4.5201e-005
2499	4.4678e-003	4.98e-002	1.1e-002	-4.5372e-005
2500	3.4769e-003	4.9879e-002	1.1e-002	-4.551e-005
2501	2.4844e-003	4.9938e-002	1.1e-002	-4.5613e-005
2502	1.4911e-003	4.9978e-002	1.1e-002	-4.5682e-005
2503	4.971e-004	4.9998e-002	1.1e-002	-4.5716e-005
2504	-4.9702e-004	4.9998e-002	1.1e-002	-4.5716e-005
2505	-1.491e-003	4.9978e-002	1.1e-002	-4.5682e-005
2506	-2.4844e-003	4.9938e-002	1.1e-002	-4.5613e-005
2507	-3.4768e-003	4.9879e-002	1.1e-002	-4.551e-005
2508	-4.4678e-003	4.98e-002	1.1e-002	-4.5372e-005
2509	-5.4571e-003	4.9701e-002	1.1e-002	-4.5201e-005
2510	-6.4441e-003	4.9583e-002	1.1e-002	-4.4996e-005
2511	-7.4287e-003	4.9445e-002	1.1e-002	-4.4758e-005
2512	-8.4103e-003	4.9288e-002	1.1e-002	-4.4486e-005
2513	-9.3886e-003	4.9111e-002	1.1e-002	-4.4182e-005
2514	-1.0363e-002	4.8914e-002	1.1e-002	-4.3845e-005
2515	-1.1334e-002	4.8699e-002	1.1e-002	-4.3477e-005
2516	-1.23e-002	4.8464e-002	1.1e-002	-4.3077e-005
2517	-1.3261e-002	4.8209e-002	1.1e-002	-4.2647e-005
2518	-1.4217e-002	4.7936e-002	1.1e-002	-4.2186e-005
2519	-1.5167e-002	4.7644e-002	1.1e-002	-4.1697e-005
2520	-1.6111e-002	4.7333e-002	1.1e-002	-4.1178e-005
2521	-1.7049e-002	4.7003e-002	1.1e-002	-4.0631e-005
2522	-1.798e-002	4.6655e-002	1.1e-002	-4.0057e-005
2523	-1.8904e-002	4.6289e-002	1.1e-002	-3.9457e-005
2524	-1.9821e-002	4.5904e-002	1.1e-002	-3.8831e-005
2525	-2.073e-002	4.55e-002	1.1e-002	-3.8181e-005
2526	-2.163e-002	4.5079e-002	1.1e-002	-3.7507e-005
2527	-2.2522e-002	4.464e-002	1.1e-002	-3.681e-005
2528	-2.3405e-002	4.4184e-002	1.1e-002	-3.6091e-005
2529	-2.4279e-002	4.371e-002	1.1e-002	-3.5354e-005
2530	-2.5134e-002	4.3224e-002	1.0997e-002	-3.4603e-005
2531	-2.6799e-002	4.2211e-002	1.1987e-002	-3.306e-005
2532	-2.6798e-002	4.2212e-002	1.2996e-002	-3.3062e-005
2533	-2.6796e-002	4.2213e-002	1.4004e-002	-3.3063e-005
2534	-2.6799e-002	4.2212e-002	1.5012e-002	-3.306e-005
2535	-2.681e-002	4.2205e-002	1.6022e-002	-3.3046e-005
2536	-2.6841e-002	4.2185e-002	1.7033e-002	-3.3022e-005
2537	-2.6867e-002	4.2168e-002	1.8041e-002	-3.2996e-005
2538	-2.6899e-002	4.2148e-002	1.9054e-002	-3.2969e-005
2539	-2.692e-002	4.2134e-002	2.0055e-002	-3.2946e-005
2540	-2.6941e-002	4.2121e-002	2.1054e-002	-3.293e-005
2541	-2.6946e-002	4.2118e-002	2.2053e-002	-3.2927e-005
2542	2.6842e-002	4.2184e-002	3.9e-002	-3.3021e-005
2543	2.6842e-002	4.2184e-002	3.8e-002	-3.3021e-005
2544	2.6842e-002	4.2184e-002	3.7e-002	-3.3021e-005
2545	-2.6842e-002	4.2184e-002	3.9e-002	-3.3021e-005
2546	-2.5998e-002	4.271e-002	3.9e-002	-3.3815e-005
2547	-2.5143e-002	4.3218e-002	3.9e-002	-3.4593e-005
2548	-2.4279e-002	4.371e-002	3.9e-002	-3.5352e-005
2549	-2.3405e-002	4.4184e-002	3.9e-002	-3.6091e-005
2550	-2.2522e-002	4.464e-002	3.9e-002	-3.681e-005
2551	-2.163e-002	4.5079e-002	3.9e-002	-3.7506e-005
2552	-2.073e-002	4.55e-002	3.9e-002	-3.8181e-005
2553	-1.9821e-002	4.5904e-002	3.9e-002	-3.8831e-005
2554	-1.8904e-002	4.6288e-002	3.9e-002	-3.9457e-005
2555	-1.798e-002	4.6655e-002	3.9e-002	-4.0057e-005
2556	-1.7049e-002	4.7003e-002	3.9e-002	-4.0631e-005
2557	-1.6111e-002	4.7333e-002	3.9e-002	-4.1178e-005
2558	-1.5167e-002	4.7644e-002	3.9e-002	-4.1697e-005
2559	-1.4217e-002	4.7936e-002	3.9e-002	-4.2186e-005
2560	-1.3261e-002	4.8209e-002	3.9e-002	-4.2647e-005
2561	-1.23e-002	4.8464e-002	3.9e-002	-4.3077e-005
2562	-1.1334e-002	4.8699e-002	3.9e-002	-4.3477e-005
2563	-1.0363e-002	4.8914e-002	3.9e-002	-4.3845e-005
2564	-9.3887e-003	4.9111e-002	3.9e-002	-4.4182e-005
2565	-8.4103e-003	4.9288e-002	3.9e-002	-4.4486e-005
2566	-7.4288e-003	4.9445e-002	3.9e-002	-4.4758e-005
2567	-6.4442e-003	4.9583e-002	3.9e-002	-4.4996e-005
2568	-5.4572e-003	4.9701e-002	3.9e-002	-4.5201e-005
2569	-4.4678e-003	4.98e-002	3.9e-002	-4.5372e-005
2570	-3.4769e-003	4.9879e-002	3.9e-002	-4.551e-005
2571	-2.4844e-003	4.9938e-002	3.9e-002	-4.5613e-005
2572	-1.4912e-003	4.9978e-002	3.9e-002	-4.5682e-005
2573	-4.971e-004	4.9998e-002	3.9e-002	-4.5716e-005
2574	4.9697e-004	4.9998e-002	3.9e-002	-4.5716e-005
2575	1.491e-003	4.9978e-002	3.9e-002	-4.5682e-005
2576	2.4843e-003	4.9938e-002	3.9e-002	-4.5613e-005
2577	3.4768e-003	4.9879e-002	3.9e-002	-4.551e-005
2578	4.4677e-003	4.98e-002	3.9e-002	-4.5372e-005
2579	5.457e-003	4.9701e-002	3.9e-002	-4.5201e-005
2580	6.4441e-003	4.9583e-002	3.9e-002	-4.4996e-005
2581	7.4287e-003	4.9445e-002	3.9e-002	-4.4758e-005
2582	8.4102e-003	4.9288e-002	3.9e-002	-4.4486e-005
2583	9.3886e-003	4.9111e-002	3.9e-002	-4.4182e-005
2584	1.0363e-002	4.8914e-002	3.9e-002	-4.3845e-005
2585	1.1334e-002	4.8699e-002	3.9e-002	-4.3477e-005
2586	1.23e-002	4.8464e-002	3.9e-002	-4.3077e-005
2587	1.3261e-002	4.8209e-002	3.9e-002	-4.2647e-005
2588	1.4217e-002	4.7936e-002	3.9e-002	-4.2187e-005
2589	1.5167e-002	4.7644e-002	3.9e-002	-4.1697e-005
2590	1.6111e-002	4.7333e-002	3.9e-002	-4.1178e-005
2591	1.7049e-002	4.7003e-002	3.9e-002	-4.0631e-005
2592	1.798e-002	4.6655e-002	3.9e-002	-4.0057e-005
2593	1.8904e-002	4.6289e-002	3.9e-002	-3.9457e-005
2594	1.9821e-002	4.5904e-002	3.9e-002	-3.8831e-005
2595	2.073e-002	4.55e-002	3.9e-002	-3.8181e-005
2596	2.163e-002	4.5079e-002	3.9e-002	-3.7507e-005
2597	2.2522e-002	4.464e-002	3.9e-002	-3.681e-005
2598	2.3405e-002	4.4184e-002	3.9e-002	-3.6091e-005
2599	2.4279e-002	4.371e-002	3.9e-002	-3.5352e-005
2600	2.5143e-002	4.3218e-002	3.9e-002	-3.4593e-005
2601	-2.5972e-002	4.2725e-002	1.0989e-002	-3.3839e-005
2602	-2.6842e-002	4.2184e-002	3.8e-002	-3.3022e-005
2603	-2.6842e-002	4.2184e-002	3.7e-002	-3.3023e-005
2604	-2.6842e-002	4.2184e-002	3.6e-002	-3.3023e-005
2605	-2.6842e-002	4.2184e-002	3.5e-002	-3.3023e-005
2606	-2.6842e-002	4.2184e-002	3.4e-002	-3.3023e-005
2607	-2.6842e-002	4.2184e-002	3.3e-002	-3.3024e-005
2608	-2.6842e-002	4.2184e-002	3.2e-002	-3.3024e-005
2609	-2.6841e-002	4.2185e-002	3.1e-002	-3.3024e-005
2610	-2.6841e-002	4.2185e-002	3.e-002	-3.3024e-005
2611	-2.6841e-002	4.2185e-002	2.9e-002	-3.3024e-005
2612	-2.6841e-002	4.2185e-002	2.8e-002	-3.3025e-005
2613	-2.6834e-002	4.219e-002	2.7e-002	-3.3025e-005
2614	-2.6842e-002	4.2184e-002	2.6015e-002	-3.3017e-005
2615	-2.6868e-002	4.2168e-002	2.503e-002	-3.2996e-005
2616	-2.6898e-002	4.2149e-002	2.404e-002	-3.2967e-005
2617	2.5998e-002	4.271e-002	1.2e-002	-3.3815e-005
2618	2.5143e-002	4.3218e-002	1.2e-002	-3.4593e-005
2619	2.3405e-002	4.4184e-002	1.2e-002	-3.6091e-005
2620	2.2522e-002	4.464e-002	1.2e-002	-3.681e-005
2621	2.163e-002	4.5079e-002	1.2e-002	-3.7506e-005
2622	2.073e-002	4.55e-002	1.2e-002	-3.8181e-005
2623	1.9821e-002	4.5904e-002	1.2e-002	-3.8831e-005
2624	1.8904e-002	4.6289e-002	1.2e-002	-3.9457e-005
2625	1.798e-002	4.6655e-002	1.2e-002	-4.0057e-005
2626	1.7049e-002	4.7003e-002	1.2e-002	-4.0631e-005
2627	1.5167e-002	4.7644e-002	1.2e-002	-4.1697e-005
2628	1.4217e-002	4.7936e-002	1.2e-002	-4.2186e-005
2629	1.3261e-002	4.8209e-002	1.2e-002	-4.2647e-005
2630	1.23e-002	4.8464e-002	1.2e-002	-4.3077e-005
2631	1.1334e-002	4.8699e-002	1.2e-002	-4.3477e-005
2632	1.0363e-002	4.8914e-002	1.2e-002	-4.3845e-005
2633	9.3886e-003	4.9111e-002	1.2e-002	-4.4182e-005
2634	8.4103e-003	4.9288e-002	1.2e-002	-4.4486e-005
2635	7.4287e-003	4.9445e-002	1.2e-002	-4.4758e-005
2636	6.4442e-003	4.9583e-002	1.2e-002	-4.4996e-005
2637	5.4571e-003	4.9701e-002	1.2e-002	-4.5201e-005
2638	4.4678e-003	4.98e-002	1.2e-002	-4.5372e-005
2639	3.4768e-003	4.9879e-002	1.2e-002	-4.551e-005
2640	2.4844e-003	4.9938e-002	1.2e-002	-4.5613e-005
2641	1.4911e-003	4.9978e-002	1.2e-002	-4.5682e-005
2642	4.9708e-004	4.9998e-002	1.2e-002	-4.5716e-005
2643	-4.9704e-004	4.9998e-002	1.2e-002	-4.5716e-005
2644	-1.491e-003	4.9978e-002	1.2e-002	-4.5682e-005
2645	-2.4844e-003	4.9938e-002	1.2e-002	-4.5613e-005
2646	-3.4768e-003	4.9879e-002	1.2e-002	-4.551e-005
2647	-4.4678e-003	4.98e-002	1.2e-002	-4.5372e-005
2648	-5.4571e-003	4.9701e-002	1.2e-002	-4.5201e-005
2649	-6.4441e-003	4.9583e-002	1.2e-002	-4.4996e-005
2650	-7.4287e-003	4.9445e-002	1.2e-002	-4.4758e-005
2651	-8.4103e-003	4.9288e-002	1.2e-002	-4.4486e-005
2652	-9.3886e-003	4.9111e-002	1.2e-002	-4.4182e-005
2653	-1.0363e-002	4.8914e-002	1.2e-002	-4.3845e-005
2654	-1.1334e-002	4.8699e-002	1.2e-002	-4.3477e-005
2655	-1.23e-002	4.8464e-002	1.2e-002	-4.3077e-005
2656	-1.3261e-002	4.8209e-002	1.2e-002	-4.2647e-005
2657	-1.4217e-002	4.7936e-002	1.2e-002	-4.2186e-005
2658	-1.5167e-002	4.7644e-002	1.2e-002	-4.1697e-005
2659	-1.6111e-002	4.7333e-002	1.2e-002	-4.1178e-005
2660	-1.7049e-002	4.7003e-002	1.2e-002	-4.0631e-005
2661	-1.798e-002	4.6655e-002	1.2e-002	-4.0057e-005
2662	-1.8904e-002	4.6289e-002	1.2e-002	-3.9457e-005
2663	-1.9821e-002	4.5904e-002	1.2e-002	-3.8831e-005
2664	-2.073e-002	4.55e-002	1.2e-002	-3.8181e-005
2665	-2.163e-002	4.5079e-002	1.2e-002	-3.7506e-005
2666	-2.2522e-002	4.464e-002	1.2e-002	-3.681e-005
2667	-2.3405e-002	4.4184e-002	1.2e-002	-3.6091e-005
2668	-2.4279e-002	4.371e-002	1.2e-002	-3.5354e-005
2669	-2.5132e-002	4.3225e-002	1.1996e-002	-3.4604e-005
2670	-2.5971e-002	4.2726e-002	1.199e-002	-3.384e-005
2671	-2.5974e-002	4.2724e-002	1.299e-002	-3.3841e-005
2672	-2.5965e-002	4.273e-002	1.3995e-002	-3.3843e-005
2673	-2.5971e-002	4.2726e-002	1.5008e-002	-3.384e-005
2674	-2.5977e-002	4.2722e-002	1.6019e-002	-3.3829e-005
2675	-2.6009e-002	4.2703e-002	1.7025e-002	-3.3809e-005
2676	-2.6031e-002	4.269e-002	1.8043e-002	-3.3786e-005
2677	-2.6054e-002	4.2675e-002	1.9054e-002	-3.3764e-005
2678	-2.6078e-002	4.2661e-002	2.0059e-002	-3.3745e-005
2679	-2.6086e-002	4.2656e-002	2.1057e-002	-3.3734e-005
2680	-2.6088e-002	4.2655e-002	2.2049e-002	-3.3735e-005
2681	2.5998e-002	4.271e-002	3.8e-002	-3.3815e-005
2682	2.5998e-002	4.271e-002	3.7e-002	-3.3815e-005
2683	2.5997e-002	4.271e-002	3.6e-002	-3.3816e-005
2684	2.5997e-002	4.271e-002	3.4e-002	-3.3816e-005
2685	2.5997e-002	4.271e-002	3.3e-002	-3.3816e-005
2686	2.5997e-002	4.271e-002	3.2e-002	-3.3816e-005
2687	2.5997e-002	4.271e-002	3.1e-002	-3.3816e-005
2688	2.5997e-002	4.271e-002	3.e-002	-3.3816e-005
2689	2.5997e-002	4.271e-002	2.9e-002	-3.3816e-005
2690	2.5997e-002	4.271e-002	2.8e-002	-3.3816e-005
2691	2.5997e-002	4.271e-002	2.7e-002	-3.3816e-005
2692	2.5997e-002	4.271e-002	2.6e-002	-3.3816e-005
2693	2.5997e-002	4.271e-002	2.5e-002	-3.3816e-005
2694	2.5997e-002	4.271e-002	2.4e-002	-3.3816e-005
2695	2.5997e-002	4.271e-002	2.3e-002	-3.3816e-005
2696	2.5997e-002	4.271e-002	2.2e-002	-3.3816e-005
2697	2.5997e-002	4.271e-002	2.1e-002	-3.3816e-005
2698	2.5997e-002	4.271e-002	2.e-002	-3.3816e-005
2699	2.5997e-002	4.271e-002	1.9e-002	-3.3816e-005
2700	2.5997e-002	4.271e-002	1.8e-002	-3.3816e-005
2701	2.5997e-002	4.271e-002	1.7e-002	-3.3816e-005
2702	2.5997e-002	4.271e-002	1.6e-002	-3.3816e-005
2703	2.5997e-002	4.271e-002	1.5e-002	-3.3815e-005
2704	2.5997e-002	4.271e-002	1.4e-002	-3.3815e-005
2705	2.5998e-002	4.271e-002	1.3e-002	-3.3815e-005
2706	-2.5998e-002	4.271e-002	3.8e-002	-3.3815e-005
2707	-2.5143e-002	4.3218e-002	3.8e-002	-3.4593e-005
2708	-2.4279e-002	4.371e-002	3.8e-002	-3.5352e-005
2709	-2.3405e-002	4.4184e-002	3.8e-002	-3.6091e-005
2710	-2.2522e-002	4.464e-002	3.8e-002	-3.681e-005
2711	-2.163e-002	4.5079e-002	3.8e-002	-3.7506e-005
2712	-2.073e-002	4.55e-002	3.8e-002	-3.8181e-005
2713	-1.9821e-002	4.5904e-002	3.8e-002	-3.8831e-005
2714	-1.8904e-002	4.6288e-002	3.8e-002	-3.9457e-005
2715	-1.798e-002	4.6655e-002	3.8e-002	-4.0057e-005
2716	-1.7049e-002	4.7003e-002	3.8e-002	-4.0631e-005
2717	-1.6111e-002	4.7333e-002	3.8e-002	-4.1178e-005
2718	-1.5167e-002	4.7644e-002	3.8e-002	-4.1697e-005
2719	-1.4217e-002	4.7936e-002	3.8e-002	-4.2186e-005
2720	-1.3261e-002	4.8209e-002	3.8e-002	-4.2647e-005
2721	-1.23e-002	4.8464e-002	3.8e-002	-4.3077e-005
2722	-1.1334e-002	4.8699e-002	3.8e-002	-4.3477e-005
2723	-1.0363e-002	4.8914e-002	3.8e-002	-4.3845e-005
2724	-9.3887e-003	4.9111e-002	3.8e-002	-4.4182e-005
2725	-8.4103e-003	4.9288e-002	3.8e-002	-4.4486e-005
2726	-7.4289e-003	4.9445e-002	3.8e-002	-4.4758e-005
2727	-6.4442e-003	4.9583e-002	3.8e-002	-4.4996e-005
2728	-5.4572e-003	4.9701e-002	3.8e-002	-4.5201e-005
2729	-4.4678e-003	4.98e-002	3.8e-002	-4.5372e-005
2730	-3.477e-003	4.9879e-002	3.8e-002	-4.551e-005
2731	-2.4844e-003	4.9938e-002	3.8e-002	-4.5613e-005
2732	-1.4912e-003	4.9978e-002	3.8e-002	-4.5682e-005
2733	-4.9709e-004	4.9998e-002	3.8e-002	-4.5716e-005
2734	4.9693e-004	4.9998e-002	3.8e-002	-4.5716e-005
2735	1.491e-003	4.9978e-002	3.8e-002	-4.5682e-005
2736	2.4843e-003	4.9938e-002	3.8e-002	-4.5613e-005
2737	3.4768e-003	4.9879e-002	3.8e-002	-4.551e-005
2738	4.4677e-003	4.98e-002	3.8e-002	-4.5372e-005
2739	5.4571e-003	4.9701e-002	3.8e-002	-4.5201e-005
2740	6.444e-003	4.9583e-002	3.8e-002	-4.4996e-005
2741	7.4287e-003	4.9445e-002	3.8e-002	-4.4758e-005
2742	8.4102e-003	4.9288e-002	3.8e-002	-4.4486e-005
2743	9.3886e-003	4.9111e-002	3.8e-002	-4.4182e-005
2744	1.0363e-002	4.8914e-002	3.8e-002	-4.3845e-005
2745	1.1334e-002	4.8699e-002	3.8e-002	-4.3477e-005
2746	1.2299e-002	4.8464e-002	3.8e-002	-4.3077e-005
2747	1.3261e-002	4.8209e-002	3.8e-002	-4.2647e-005
2748	1.4217e-002	4.7936e-002	3.8e-002	-4.2187e-005
2749	1.5167e-002	4.7644e-002	3.8e-002	-4.1697e-005
2750	1.6111e-002	4.7333e-002	3.8e-002	-4.1178e-005
2751	1.7049e-002	4.7003e-002	3.8e-002	-4.0631e-005
2752	1.798e-002	4.6655e-002	3.8e-002	-4.0057e-005
2753	1.8904e-002	4.6289e-002	3.8e-002	-3.9457e-005
2754	1.9821e-002	4.5904e-002	3.8e-002	-3.8831e-005
2755	2.073e-002	4.55e-002	3.8e-002	-3.8181e-005
2756	2.163e-002	4.5079e-002	3.8e-002	-3.7507e-005
2757	2.2522e-002	4.464e-002	3.8e-002	-3.681e-005
2758	2.3405e-002	4.4184e-002	3.8e-002	-3.6091e-005
2759	2.4279e-002	4.371e-002	3.8e-002	-3.5352e-005
2760	2.5143e-002	4.3218e-002	3.8e-002	-3.4593e-005
2761	-2.5998e-002	4.271e-002	3.7e-002	-3.3815e-005
2762	-2.5998e-002	4.271e-002	3.6e-002	-3.3815e-005
2763	-2.5998e-002	4.271e-002	3.5e-002	-3.3815e-005
2764	-2.5998e-002	4.271e-002	3.4e-002	-3.3815e-005
2765	-2.5998e-002	4.271e-002	3.3e-002	-3.3815e-005
2766	-2.5998e-002	4.271e-002	3.2e-002	-3.3815e-005
2767	-2.5998e-002	4.271e-002	3.1e-002	-3.3815e-005
2768	-2.5998e-002	4.271e-002	3.e-002	-3.3815e-005
2769	-2.5998e-002	4.271e-002	2.9e-002	-3.3815e-005
2770	-2.5998e-002	4.2709e-002	2.8e-002	-3.3816e-005
2771	-2.5998e-002	4.2709e-002	2.7e-002	-3.3816e-005
2772	-2.6e-002	4.2709e-002	2.6012e-002	-3.3811e-005
2773	-2.6019e-002	4.2697e-002	2.503e-002	-3.3793e-005
2774	-2.6056e-002	4.2674e-002	2.404e-002	-3.3767e-005
2775	-2.6074e-002	4.2663e-002	2.3044e-002	-3.3746e-005
2776	-2.5131e-002	4.3226e-002	1.2998e-002	-3.4605e-005
2777	-2.5128e-002	4.3227e-002	1.3998e-002	-3.4606e-005
2778	-2.5129e-002	4.3227e-002	1.5002e-002	-3.4604e-005
2779	-2.5139e-002	4.3221e-002	1.6008e-002	-3.4597e-005
2780	-2.5153e-002	4.3213e-002	1.7021e-002	-3.4583e-005
2781	-2.5175e-002	4.3199e-002	1.8028e-002	-3.4566e-005
2782	-2.5193e-002	4.3189e-002	1.9041e-002	-3.4547e-005
2783	-2.5226e-002	4.317e-002	2.1052e-002	-3.4525e-005
2784	-2.5216e-002	4.3176e-002	2.204e-002	-3.4529e-005
2785	-2.5205e-002	4.3182e-002	2.3032e-002	-3.4539e-005
2786	2.5143e-002	4.3218e-002	1.3e-002	-3.4593e-005
2787	2.4279e-002	4.371e-002	1.3e-002	-3.5352e-005
2788	2.3405e-002	4.4184e-002	1.3e-002	-3.6091e-005
2789	2.2522e-002	4.464e-002	1.3e-002	-3.681e-005
2790	2.163e-002	4.5079e-002	1.3e-002	-3.7506e-005
2791	2.073e-002	4.55e-002	1.3e-002	-3.8181e-005
2792	1.9821e-002	4.5903e-002	1.3e-002	-3.8831e-005
2793	1.8904e-002	4.6288e-002	1.3e-002	-3.9457e-005
2794	1.798e-002	4.6655e-002	1.3e-002	-4.0057e-005
2795	1.7049e-002	4.7003e-002	1.3e-002	-4.0631e-005
2796	1.6111e-002	4.7333e-002	1.3e-002	-4.1178e-005
2797	1.5167e-002	4.7644e-002	1.3e-002	-4.1697e-005
2798	1.4217e-002	4.7936e-002	1.3e-002	-4.2186e-005
2799	1.3261e-002	4.8209e-002	1.3e-002	-4.2647e-005
2800	1.23e-002	4.8464e-002	1.3e-002	-4.3077e-005
2801	1.1334e-002	4.8699e-002	1.3e-002	-4.3477e-005
2802	1.0363e-002	4.8914e-002	1.3e-002	-4.3845e-005
2803	9.3887e-003	4.9111e-002	1.3e-002	-4.4182e-005
2804	8.4103e-003	4.9288e-002	1.3e-002	-4.4486e-005
2805	7.4288e-003	4.9445e-002	1.3e-002	-4.4758e-005
2806	6.4442e-003	4.9583e-002	1.3e-002	-4.4996e-005
2807	5.4571e-003	4.9701e-002	1.3e-002	-4.5201e-005
2808	4.4678e-003	4.98e-002	1.3e-002	-4.5372e-005
2809	3.4769e-003	4.9879e-002	1.3e-002	-4.551e-005
2810	2.4844e-003	4.9938e-002	1.3e-002	-4.5613e-005
2811	1.4911e-003	4.9978e-002	1.3e-002	-4.5682e-005
2812	4.971e-004	4.9998e-002	1.3e-002	-4.5716e-005
2813	-4.9702e-004	4.9998e-002	1.3e-002	-4.5716e-005
2814	-1.491e-003	4.9978e-002	1.3e-002	-4.5682e-005
2815	-2.4844e-003	4.9938e-002	1.3e-002	-4.5613e-005
2816	-3.4768e-003	4.9879e-002	1.3e-002	-4.551e-005
2817	-4.4678e-003	4.98e-002	1.3e-002	-4.5372e-005
2818	-5.457e-003	4.9701e-002	1.3e-002	-4.5201e-005
2819	-6.4441e-003	4.9583e-002	1.3e-002	-4.4996e-005
2820	-7.4287e-003	4.9445e-002	1.3e-002	-4.4758e-005
2821	-8.4103e-003	4.9288e-002	1.3e-002	-4.4486e-005
2822	-9.3886e-003	4.9111e-002	1.3e-002	-4.4182e-005
2823	-1.0363e-002	4.8914e-002	1.3e-002	-4.3845e-005
2824	-1.1334e-002	4.8699e-002	1.3e-002	-4.3477e-005
2825	-1.23e-002	4.8464e-002	1.3e-002	-4.3077e-005
2826	-1.3261e-002	4.8209e-002	1.3e-002	-4.2647e-005
2827	-1.4217e-002	4.7936e-002	1.3e-002	-4.2186e-005
2828	-1.5167e-002	4.7644e-002	1.3e-002	-4.1697e-005
2829	-1.6111e-002	4.7333e-002	1.3e-002	-4.1178e-005
2830	-1.7049e-002	4.7004e-002	1.3e-002	-4.0631e-005
2831	-1.798e-002	4.6655e-002	1.3e-002	-4.0057e-005
2832	-1.8904e-002	4.6289e-002	1.3e-002	-3.9457e-005
2833	-1.9821e-002	4.5904e-002	1.3e-002	-3.8831e-005
2834	-2.073e-002	4.55e-002	1.3e-002	-3.8181e-005
2835	-2.163e-002	4.5079e-002	1.3e-002	-3.7506e-005
2836	-2.2522e-002	4.464e-002	1.3e-002	-3.681e-005
2837	-2.3405e-002	4.4184e-002	1.3e-002	-3.6091e-005
2838	-2.4279e-002	4.371e-002	1.3e-002	-3.5354e-005
2839	2.5143e-002	4.3218e-002	3.7e-002	-3.4593e-005
2840	2.5143e-002	4.3218e-002	3.6e-002	-3.4593e-005
2841	2.5143e-002	4.3218e-002	3.5e-002	-3.4593e-005
2842	2.5143e-002	4.3218e-002	3.4e-002	-3.4593e-005
2843	2.5143e-002	4.3218e-002	3.3e-002	-3.4593e-005
2844	2.5143e-002	4.3218e-002	3.2e-002	-3.4593e-005
2845	2.5143e-002	4.3218e-002	3.1e-002	-3.4593e-005
2846	2.5143e-002	4.3218e-002	3.e-002	-3.4593e-005
2847	2.5143e-002	4.3218e-002	2.9e-002	-3.4593e-005
2848	2.5143e-002	4.3218e-002	2.8e-002	-3.4593e-005
2849	2.5143e-002	4.3218e-002	2.7e-002	-3.4593e-005
2850	2.5143e-002	4.3218e-002	2.6e-002	-3.4593e-005
2851	2.5143e-002	4.3218e-002	2.5e-002	-3.4593e-005
2852	2.5143e-002	4.3218e-002	2.4e-002	-3.4593e-005
2853	2.5143e-002	4.3218e-002	2.3e-002	-3.4593e-005
2854	2.5143e-002	4.3218e-002	2.2e-002	-3.4593e-005
2855	2.5143e-002	4.3218e-002	2.1e-002	-3.4593e-005
2856	2.5143e-002	4.3218e-002	2.e-002	-3.4593e-005
2857	2.5143e-002	4.3218e-002	1.9e-002	-3.4593e-005
2858	2.5143e-002	4.3218e-002	1.8e-002	-3.4593e-005
2859	2.5143e-002	4.3218e-002	1.7e-002	-3.4593e-005
2860	2.5143e-002	4.3218e-002	1.6e-002	-3.4593e-005
2861	2.5143e-002	4.3218e-002	1.5e-002	-3.4593e-005
2862	2.5143e-002	4.3218e-002	1.4e-002	-3.4593e-005
2863	-2.5143e-002	4.3218e-002	3.7e-002	-3.4593e-005
2864	-2.4279e-002	4.371e-002	3.7e-002	-3.5352e-005
2865	-2.3405e-002	4.4184e-002	3.7e-002	-3.6091e-005
2866	-2.2522e-002	4.464e-002	3.7e-002	-3.6809e-005
2867	-2.163e-002	4.5079e-002	3.7e-002	-3.7506e-005
2868	-2.073e-002	4.55e-002	3.7e-002	-3.8181e-005
2869	-1.9821e-002	4.5904e-002	3.7e-002	-3.8831e-005
2870	-1.8904e-002	4.6288e-002	3.7e-002	-3.9457e-005
2871	-1.798e-002	4.6655e-002	3.7e-002	-4.0057e-005
2872	-1.7049e-002	4.7003e-002	3.7e-002	-4.0631e-005
2873	-1.6111e-002	4.7333e-002	3.7e-002	-4.1178e-005
2874	-1.5167e-002	4.7644e-002	3.7e-002	-4.1697e-005
2875	-1.4217e-002	4.7936e-002	3.7e-002	-4.2186e-005
2876	-1.3261e-002	4.8209e-002	3.7e-002	-4.2647e-005
2877	-1.23e-002	4.8464e-002	3.7e-002	-4.3077e-005
2878	-1.1334e-002	4.8699e-002	3.7e-002	-4.3477e-005
2879	-1.0363e-002	4.8914e-002	3.7e-002	-4.3845e-005
2880	-9.3888e-003	4.9111e-002	3.7e-002	-4.4182e-005
2881	-8.4103e-003	4.9288e-002	3.7e-002	-4.4486e-005
2882	-7.4289e-003	4.9445e-002	3.7e-002	-4.4758e-005
2883	-6.4442e-003	4.9583e-002	3.7e-002	-4.4996e-005
2884	-5.4572e-003	4.9701e-002	3.7e-002	-4.5201e-005
2885	-4.4678e-003	4.98e-002	3.7e-002	-4.5372e-005
2886	-3.477e-003	4.9879e-002	3.7e-002	-4.551e-005
2887	-2.4844e-003	4.9938e-002	3.7e-002	-4.5613e-005
2888	-1.4912e-003	4.9978e-002	3.7e-002	-4.5682e-005
2889	-4.971e-004	4.9998e-002	3.7e-002	-4.5716e-005
2890	4.9691e-004	4.9998e-002	3.7e-002	-4.5716e-005
2891	1.491e-003	4.9978e-002	3.7e-002	-4.5682e-005
2892	2.4842e-003	4.9938e-002	3.7e-002	-4.5613e-005
2893	3.4768e-003	4.9879e-002	3.7e-002	-4.551e-005
2894	4.4677e-003	4.98e-002	3.7e-002	-4.5372e-005
2895	5.4571e-003	4.9701e-002	3.7e-002	-4.5201e-005
2896	6.444e-003	4.9583e-002	3.7e-002	-4.4996e-005
2897	7.4287e-003	4.9445e-002	3.7e-002	-4.4758e-005
2898	8.4101e-003	4.9288e-002	3.7e-002	-4.4486e-005
2899	9.3886e-003	4.9111e-002	3.7e-002	-4.4182e-005
2900	1.0363e-002	4.8914e-002	3.7e-002	-4.3845e-005
2901	1.1334e-002	4.8699e-002	3.7e-002	-4.3477e-005
2902	1.2299e-002	4.8464e-002	3.7e-002	-4.3077e-005
2903	1.3261e-002	4.8209e-002	3.7e-002	-4.2647e-005
2904	1.4216e-002	4.7936e-002	3.7e-002	-4.2187e-005
2905	1.5167e-002	4.7644e-002	3.7e-002	-4.1697e-005
2906	1.6111e-002	4.7333e-002	3.7e-002	-4.1178e-005
2907	1.7049e-002	4.7003e-002	3.7e-002	-4.0631e-005
2908	1.798e-002	4.6655e-002	3.7e-002	-4.0057e-005
2909	1.8904e-002	4.6289e-002	3.7e-002	-3.9457e-005
2910	1.9821e-002	4.5904e-002	3.7e-002	-3.8831e-005
2911	2.073e-002	4.55e-002	3.7e-002	-3.8181e-005
2912	2.2522e-002	4.464e-002	3.7e-002	-3.681e-005
2913	2.3405e-002	4.4184e-002	3.7e-002	-3.6091e-005
2914	2.4279e-002	4.371e-002	3.7e-002	-3.5352e-005
2915	-2.5143e-002	4.3218e-002	3.6e-002	-3.4593e-005
2916	-2.5143e-002	4.3218e-002	3.5e-002	-3.4593e-005
2917	-2.5143e-002	4.3218e-002	3.4e-002	-3.4593e-005
2918	-2.5143e-002	4.3218e-002	3.3e-002	-3.4593e-005
2919	-2.5143e-002	4.3218e-002	3.2e-002	-3.4593e-005
2920	-2.5143e-002	4.3218e-002	3.1e-002	-3.4593e-005
2921	-2.5143e-002	4.3218e-002	3.e-002	-3.4593e-005
2922	-2.5143e-002	4.3218e-002	2.9e-002	-3.4593e-005
2923	-2.5143e-002	4.3218e-002	2.8e-002	-3.4593e-005
2924	-2.5143e-002	4.3218e-002	2.7e-002	-3.4593e-005
2925	-2.5143e-002	4.3218e-002	2.6e-002	-3.4589e-005
2926	-2.5156e-002	4.3211e-002	2.5015e-002	-3.4576e-005
2927	-2.5188e-002	4.3192e-002	2.4023e-002	-3.4556e-005
2928	-2.4279e-002	4.371e-002	1.4e-002	-3.5355e-005
2929	-2.4279e-002	4.371e-002	1.5e-002	-3.5354e-005
2930	-2.4279e-002	4.371e-002	1.6e-002	-3.5351e-005
2931	-2.4287e-002	4.3705e-002	1.7006e-002	-3.5344e-005
2932	-2.4302e-002	4.3697e-002	1.802e-002	-3.5332e-005
2933	-2.4322e-002	4.3686e-002	1.9028e-002	-3.5317e-005
2934	-2.434e-002	4.3675e-002	2.003e-002	-3.5304e-005
2935	-2.4339e-002	4.3676e-002	2.1031e-002	-3.5301e-005
2936	2.4279e-002	4.3709e-002	1.4e-002	-3.5352e-005
2937	2.3405e-002	4.4184e-002	1.4e-002	-3.6091e-005
2938	2.2522e-002	4.464e-002	1.4e-002	-3.681e-005
2939	2.163e-002	4.5079e-002	1.4e-002	-3.7506e-005
2940	2.073e-002	4.55e-002	1.4e-002	-3.8181e-005
2941	1.9821e-002	4.5903e-002	1.4e-002	-3.8831e-005
2942	1.8904e-002	4.6289e-002	1.4e-002	-3.9457e-005
2943	1.798e-002	4.6655e-002	1.4e-002	-4.0057e-005
2944	1.6111e-002	4.7333e-002	1.4e-002	-4.1178e-005
2945	1.4217e-002	4.7936e-002	1.4e-002	-4.2186e-005
2946	1.3261e-002	4.8209e-002	1.4e-002	-4.2647e-005
2947	1.23e-002	4.8464e-002	1.4e-002	-4.3077e-005
2948	1.1334e-002	4.8699e-002	1.4e-002	-4.3477e-005
2949	1.0363e-002	4.8914e-002	1.4e-002	-4.3845e-005
2950	9.3886e-003	4.9111e-002	1.4e-002	-4.4182e-005
2951	8.4103e-003	4.9288e-002	1.4e-002	-4.4486e-005
2952	7.4288e-003	4.9445e-002	1.4e-002	-4.4758e-005
2953	6.4442e-003	4.9583e-002	1.4e-002	-4.4996e-005
2954	5.4571e-003	4.9701e-002	1.4e-002	-4.5201e-005
2955	4.4678e-003	4.98e-002	1.4e-002	-4.5372e-005
2956	3.4769e-003	4.9879e-002	1.4e-002	-4.551e-005
2957	2.4844e-003	4.9938e-002	1.4e-002	-4.5613e-005
2958	1.4911e-003	4.9978e-002	1.4e-002	-4.5682e-005
2959	4.9709e-004	4.9998e-002	1.4e-002	-4.5716e-005
2960	-4.9703e-004	4.9998e-002	1.4e-002	-4.5716e-005
2961	-1.491e-003	4.9978e-002	1.4e-002	-4.5682e-005
2962	-2.4844e-003	4.9938e-002	1.4e-002	-4.5613e-005
2963	-3.4768e-003	4.9879e-002	1.4e-002	-4.551e-005
2964	-4.4678e-003	4.98e-002	1.4e-002	-4.5372e-005
2965	-5.4571e-003	4.9701e-002	1.4e-002	-4.5201e-005
2966	-6.4441e-003	4.9583e-002	1.4e-002	-4.4996e-005
2967	-7.4287e-003	4.9445e-002	1.4e-002	-4.4758e-005
2968	-8.4103e-003	4.9288e-002	1.4e-002	-4.4486e-005
2969	-9.3886e-003	4.9111e-002	1.4e-002	-4.4182e-005
2970	-1.0363e-002	4.8914e-002	1.4e-002	-4.3845e-005
2971	-1.1334e-002	4.8699e-002	1.4e-002	-4.3477e-005
2972	-1.23e-002	4.8464e-002	1.4e-002	-4.3077e-005
2973	-1.3261e-002	4.8209e-002	1.4e-002	-4.2647e-005
2974	-1.4217e-002	4.7936e-002	1.4e-002	-4.2186e-005
2975	-1.5167e-002	4.7644e-002	1.4e-002	-4.1697e-005
2976	-1.6111e-002	4.7333e-002	1.4e-002	-4.1178e-005
2977	-1.7049e-002	4.7003e-002	1.4e-002	-4.0631e-005
2978	-1.798e-002	4.6655e-002	1.4e-002	-4.0057e-005
2979	-1.8904e-002	4.6289e-002	1.4e-002	-3.9457e-005
2980	-1.9821e-002	4.5904e-002	1.4e-002	-3.8831e-005
2981	-2.073e-002	4.55e-002	1.4e-002	-3.8181e-005
2982	-2.163e-002	4.5079e-002	1.4e-002	-3.7506e-005
2983	-2.2522e-002	4.464e-002	1.4e-002	-3.681e-005
2984	-2.3405e-002	4.4184e-002	1.4e-002	-3.6091e-005
2985	2.4279e-002	4.371e-002	3.6e-002	-3.5352e-005
2986	2.4279e-002	4.371e-002	3.5e-002	-3.5352e-005
2987	2.4279e-002	4.371e-002	3.4e-002	-3.5352e-005
2988	2.4279e-002	4.371e-002	3.3e-002	-3.5352e-005
2989	2.4279e-002	4.371e-002	3.2e-002	-3.5352e-005
2990	2.4279e-002	4.371e-002	3.1e-002	-3.5352e-005
2991	2.4279e-002	4.371e-002	3.e-002	-3.5352e-005
2992	2.4279e-002	4.371e-002	2.9e-002	-3.5352e-005
2993	2.4279e-002	4.371e-002	2.8e-002	-3.5352e-005
2994	2.4279e-002	4.371e-002	2.7e-002	-3.5352e-005
2995	2.4279e-002	4.371e-002	2.6e-002	-3.5352e-005
2996	2.4279e-002	4.371e-002	2.5e-002	-3.5352e-005
2997	2.4279e-002	4.371e-002	2.4e-002	-3.5352e-005
2998	2.4279e-002	4.371e-002	2.3e-002	-3.5352e-005
2999	2.4279e-002	4.371e-002	2.2e-002	-3.5352e-005
3000	2.4279e-002	4.371e-002	2.1e-002	-3.5352e-005
3001	2.4279e-002	4.371e-002	2.e-002	-3.5352e-005
3002	2.4279e-002	4.3709e-002	1.9e-002	-3.5352e-005
3003	2.4279e-002	4.3709e-002	1.8e-002	-3.5352e-005
3004	2.4279e-002	4.3709e-002	1.7e-002	-3.5352e-005
3005	2.4279e-002	4.3709e-002	1.6e-002	-3.5352e-005
3006	2.4279e-002	4.3709e-002	1.5e-002	-3.5352e-005
3007	-2.4279e-002	4.371e-002	3.6e-002	-3.5352e-005
3008	-2.3405e-002	4.4184e-002	3.6e-002	-3.6091e-005
3009	-2.2522e-002	4.464e-002	3.6e-002	-3.6809e-005
3010	-2.163e-002	4.5079e-002	3.6e-002	-3.7506e-005
3011	-2.073e-002	4.55e-002	3.6e-002	-3.8181e-005
3012	-1.9821e-002	4.5904e-002	3.6e-002	-3.8831e-005
3013	-1.8904e-002	4.6288e-002	3.6e-002	-3.9457e-005
3014	-1.798e-002	4.6655e-002	3.6e-002	-4.0057e-005
3015	-1.7049e-002	4.7003e-002	3.6e-002	-4.0631e-005
3016	-1.6111e-002	4.7333e-002	3.6e-002	-4.1178e-005
3017	-1.5167e-002	4.7644e-002	3.6e-002	-4.1697e-005
3018	-1.4217e-002	4.7936e-002	3.6e-002	-4.2186e-005
3019	-1.3261e-002	4.8209e-002	3.6e-002	-4.2647e-005
3020	-1.23e-002	4.8464e-002	3.6e-002	-4.3077e-005
3021	-1.1334e-002	4.8699e-002	3.6e-002	-4.3477e-005
3022	-1.0363e-002	4.8914e-002	3.6e-002	-4.3845e-005
3023	-9.3888e-003	4.9111e-002	3.6e-002	-4.4182e-005
3024	-8.4104e-003	4.9288e-002	3.6e-002	-4.4486e-005
3025	-7.4289e-003	4.9445e-002	3.6e-002	-4.4758e-005
3026	-6.4442e-003	4.9583e-002	3.6e-002	-4.4996e-005
3027	-5.4572e-003	4.9701e-002	3.6e-002	-4.5201e-005
3028	-4.4679e-003	4.98e-002	3.6e-002	-4.5372e-005
3029	-3.477e-003	4.9879e-002	3.6e-002	-4.551e-005
3030	-2.4845e-003	4.9938e-002	3.6e-002	-4.5613e-005
3031	-1.4912e-003	4.9978e-002	3.6e-002	-4.5682e-005
3032	-4.9714e-004	4.9998e-002	3.6e-002	-4.5716e-005
3033	4.9691e-004	4.9998e-002	3.6e-002	-4.5716e-005
3034	1.491e-003	4.9978e-002	3.6e-002	-4.5682e-005
3035	2.4842e-003	4.9938e-002	3.6e-002	-4.5613e-005
3036	3.4767e-003	4.9879e-002	3.6e-002	-4.551e-005
3037	4.4676e-003	4.98e-002	3.6e-002	-4.5372e-005
3038	5.457e-003	4.9701e-002	3.6e-002	-4.5201e-005
3039	6.444e-003	4.9583e-002	3.6e-002	-4.4996e-005
3040	7.4286e-003	4.9445e-002	3.6e-002	-4.4758e-005
3041	8.4101e-003	4.9288e-002	3.6e-002	-4.4486e-005
3042	9.3885e-003	4.9111e-002	3.6e-002	-4.4182e-005
3043	1.0363e-002	4.8914e-002	3.6e-002	-4.3845e-005
3044	1.1334e-002	4.8699e-002	3.6e-002	-4.3477e-005
3045	1.2299e-002	4.8464e-002	3.6e-002	-4.3077e-005
3046	1.3261e-002	4.8209e-002	3.6e-002	-4.2647e-005
3047	1.4216e-002	4.7936e-002	3.6e-002	-4.2187e-005
3048	1.5167e-002	4.7644e-002	3.6e-002	-4.1697e-005
3049	1.6111e-002	4.7333e-002	3.6e-002	-4.1178e-005
3050	1.7049e-002	4.7004e-002	3.6e-002	-4.0631e-005
3051	1.798e-002	4.6655e-002	3.6e-002	-4.0057e-005
3052	1.8904e-002	4.6289e-002	3.6e-002	-3.9457e-005
3053	1.9821e-002	4.5904e-002	3.6e-002	-3.8831e-005
3054	2.073e-002	4.55e-002	3.6e-002	-3.8181e-005
3055	2.163e-002	4.5079e-002	3.6e-002	-3.7507e-005
3056	2.2522e-002	4.464e-002	3.6e-002	-3.681e-005
3057	2.3405e-002	4.4184e-002	3.6e-002	-3.6091e-005
3058	-2.4289e-002	4.3704e-002	2.5003e-002	-3.5342e-005
3059	-2.4279e-002	4.3709e-002	3.5e-002	-3.5352e-005
3060	-2.4279e-002	4.3709e-002	3.4e-002	-3.5352e-005
3061	-2.4279e-002	4.3709e-002	3.3e-002	-3.5352e-005
3062	-2.4279e-002	4.3709e-002	3.2e-002	-3.5352e-005
3063	-2.4279e-002	4.3709e-002	3.1e-002	-3.5352e-005
3064	-2.4279e-002	4.3709e-002	3.e-002	-3.5352e-005
3065	-2.4279e-002	4.3709e-002	2.9e-002	-3.5352e-005
3066	-2.4279e-002	4.3709e-002	2.8e-002	-3.5352e-005
3067	-2.428e-002	4.3709e-002	2.7e-002	-3.5352e-005
3068	-2.428e-002	4.3709e-002	2.6e-002	-3.535e-005
3069	-2.3405e-002	4.4184e-002	1.5e-002	-3.6091e-005
3070	-2.3405e-002	4.4184e-002	1.6e-002	-3.609e-005
3071	-2.3416e-002	4.4178e-002	1.8004e-002	-3.608e-005
3072	-2.3431e-002	4.417e-002	1.9014e-002	-3.607e-005
3073	-2.3441e-002	4.4164e-002	2.0016e-002	-3.6062e-005
3074	-2.3447e-002	4.4161e-002	2.1016e-002	-3.6059e-005
3075	2.3405e-002	4.4184e-002	1.5e-002	-3.6091e-005
3076	2.2522e-002	4.464e-002	1.5e-002	-3.681e-005
3077	2.163e-002	4.5079e-002	1.5e-002	-3.7506e-005
3078	2.073e-002	4.55e-002	1.5e-002	-3.8181e-005
3079	1.9821e-002	4.5903e-002	1.5e-002	-3.8831e-005
3080	1.8904e-002	4.6289e-002	1.5e-002	-3.9457e-005
3081	1.798e-002	4.6655e-002	1.5e-002	-4.0057e-005
3082	1.7049e-002	4.7003e-002	1.5e-002	-4.0631e-005
3083	1.6111e-002	4.7333e-002	1.5e-002	-4.1178e-005
3084	1.5167e-002	4.7644e-002	1.5e-002	-4.1697e-005
3085	1.4217e-002	4.7936e-002	1.5e-002	-4.2186e-005
3086	1.3261e-002	4.8209e-002	1.5e-002	-4.2647e-005
3087	1.23e-002	4.8464e-002	1.5e-002	-4.3077e-005
3088	1.1334e-002	4.8699e-002	1.5e-002	-4.3477e-005
3089	1.0363e-002	4.8914e-002	1.5e-002	-4.3845e-005
3090	9.3886e-003	4.9111e-002	1.5e-002	-4.4182e-005
3091	8.4103e-003	4.9288e-002	1.5e-002	-4.4486e-005
3092	7.4287e-003	4.9445e-002	1.5e-002	-4.4758e-005
3093	6.4442e-003	4.9583e-002	1.5e-002	-4.4996e-005
3094	5.4571e-003	4.9701e-002	1.5e-002	-4.5201e-005
3095	4.4678e-003	4.98e-002	1.5e-002	-4.5372e-005
3096	3.4768e-003	4.9879e-002	1.5e-002	-4.551e-005
3097	2.4844e-003	4.9938e-002	1.5e-002	-4.5613e-005
3098	1.4911e-003	4.9978e-002	1.5e-002	-4.5682e-005
3099	4.9711e-004	4.9998e-002	1.5e-002	-4.5716e-005
3100	-4.9704e-004	4.9998e-002	1.5e-002	-4.5716e-005
3101	-1.491e-003	4.9978e-002	1.5e-002	-4.5682e-005
3102	-2.4844e-003	4.9938e-002	1.5e-002	-4.5613e-005
3103	-3.4768e-003	4.9879e-002	1.5e-002	-4.551e-005
3104	-4.4678e-003	4.98e-002	1.5e-002	-4.5372e-005
3105	-5.457e-003	4.9701e-002	1.5e-002	-4.5201e-005
3106	-6.4441e-003	4.9583e-002	1.5e-002	-4.4996e-005
3107	-7.4287e-003	4.9445e-002	1.5e-002	-4.4758e-005
3108	-8.4103e-003	4.9288e-002	1.5e-002	-4.4486e-005
3109	-9.3886e-003	4.9111e-002	1.5e-002	-4.4182e-005
3110	-1.0363e-002	4.8914e-002	1.5e-002	-4.3845e-005
3111	-1.1334e-002	4.8699e-002	1.5e-002	-4.3477e-005
3112	-1.23e-002	4.8464e-002	1.5e-002	-4.3077e-005
3113	-1.3261e-002	4.8209e-002	1.5e-002	-4.2647e-005
3114	-1.4217e-002	4.7936e-002	1.5e-002	-4.2186e-005
3115	-1.5167e-002	4.7644e-002	1.5e-002	-4.1697e-005
3116	-1.6111e-002	4.7333e-002	1.5e-002	-4.1178e-005
3117	-1.7049e-002	4.7004e-002	1.5e-002	-4.0631e-005
3118	-1.798e-002	4.6655e-002	1.5e-002	-4.0057e-005
3119	-1.8904e-002	4.6289e-002	1.5e-002	-3.9457e-005
3120	-1.9821e-002	4.5904e-002	1.5e-002	-3.8831e-005
3121	-2.073e-002	4.55e-002	1.5e-002	-3.8181e-005
3122	-2.2522e-002	4.464e-002	1.5e-002	-3.681e-005
3123	2.3405e-002	4.4184e-002	3.5e-002	-3.6091e-005
3124	2.3405e-002	4.4184e-002	3.4e-002	-3.6091e-005
3125	2.3405e-002	4.4184e-002	3.3e-002	-3.6091e-005
3126	2.3405e-002	4.4184e-002	3.2e-002	-3.6091e-005
3127	2.3405e-002	4.4184e-002	3.1e-002	-3.6091e-005
3128	2.3405e-002	4.4184e-002	3.e-002	-3.6091e-005
3129	2.3405e-002	4.4184e-002	2.9e-002	-3.6091e-005
3130	2.3405e-002	4.4184e-002	2.8e-002	-3.6091e-005
3131	2.3405e-002	4.4184e-002	2.7e-002	-3.6091e-005
3132	2.3405e-002	4.4184e-002	2.6e-002	-3.6091e-005
3133	2.3405e-002	4.4184e-002	2.5e-002	-3.6091e-005
3134	2.3405e-002	4.4184e-002	2.4e-002	-3.6091e-005
3135	2.3405e-002	4.4184e-002	2.3e-002	-3.6091e-005
3136	2.3405e-002	4.4184e-002	2.2e-002	-3.6091e-005
3137	2.3405e-002	4.4184e-002	2.1e-002	-3.6091e-005
3138	2.3405e-002	4.4184e-002	2.e-002	-3.6091e-005
3139	2.3405e-002	4.4184e-002	1.9e-002	-3.6091e-005
3140	2.3405e-002	4.4184e-002	1.8e-002	-3.6091e-005
3141	2.3405e-002	4.4184e-002	1.7e-002	-3.6091e-005
3142	2.3406e-002	4.4183e-002	1.6e-002	-3.6091e-005
3143	-2.4324e-002	4.3684e-002	2.3019e-002	-3.5314e-005
3144	-2.4332e-002	4.368e-002	2.2025e-002	-3.5305e-005
3145	-2.3405e-002	4.4184e-002	3.5e-002	-3.6091e-005
3146	-2.2522e-002	4.464e-002	3.5e-002	-3.6809e-005
3147	-2.163e-002	4.5079e-002	3.5e-002	-3.7506e-005
3148	-2.073e-002	4.55e-002	3.5e-002	-3.8181e-005
3149	-1.9821e-002	4.5904e-002	3.5e-002	-3.8831e-005
3150	-1.8904e-002	4.6288e-002	3.5e-002	-3.9457e-005
3151	-1.798e-002	4.6655e-002	3.5e-002	-4.0057e-005
3152	-1.7049e-002	4.7003e-002	3.5e-002	-4.0631e-005
3153	-1.6111e-002	4.7333e-002	3.5e-002	-4.1178e-005
3154	-1.5167e-002	4.7644e-002	3.5e-002	-4.1697e-005
3155	-1.4217e-002	4.7936e-002	3.5e-002	-4.2186e-005
3156	-1.3261e-002	4.8209e-002	3.5e-002	-4.2647e-005
3157	-1.23e-002	4.8464e-002	3.5e-002	-4.3077e-005
3158	-1.1334e-002	4.8699e-002	3.5e-002	-4.3477e-005
3159	-1.0363e-002	4.8914e-002	3.5e-002	-4.3845e-005
3160	-9.3888e-003	4.9111e-002	3.5e-002	-4.4182e-005
3161	-8.4104e-003	4.9288e-002	3.5e-002	-4.4486e-005
3162	-7.4289e-003	4.9445e-002	3.5e-002	-4.4758e-005
3163	-6.4442e-003	4.9583e-002	3.5e-002	-4.4996e-005
3164	-5.4572e-003	4.9701e-002	3.5e-002	-4.5201e-005
3165	-4.4679e-003	4.98e-002	3.5e-002	-4.5372e-005
3166	-3.477e-003	4.9879e-002	3.5e-002	-4.551e-005
3167	-2.4845e-003	4.9938e-002	3.5e-002	-4.5613e-005
3168	-1.4912e-003	4.9978e-002	3.5e-002	-4.5682e-005
3169	-4.9714e-004	4.9998e-002	3.5e-002	-4.5716e-005
3170	4.9692e-004	4.9998e-002	3.5e-002	-4.5716e-005
3171	1.491e-003	4.9978e-002	3.5e-002	-4.5682e-005
3172	2.4843e-003	4.9938e-002	3.5e-002	-4.5613e-005
3173	3.4767e-003	4.9879e-002	3.5e-002	-4.551e-005
3174	4.4677e-003	4.98e-002	3.5e-002	-4.5372e-005
3175	5.457e-003	4.9701e-002	3.5e-002	-4.5201e-005
3176	6.444e-003	4.9583e-002	3.5e-002	-4.4996e-005
3177	7.4286e-003	4.9445e-002	3.5e-002	-4.4758e-005
3178	8.4102e-003	4.9288e-002	3.5e-002	-4.4486e-005
3179	9.3885e-003	4.9111e-002	3.5e-002	-4.4182e-005
3180	1.0363e-002	4.8914e-002	3.5e-002	-4.3845e-005
3181	1.1334e-002	4.8699e-002	3.5e-002	-4.3477e-005
3182	1.2299e-002	4.8464e-002	3.5e-002	-4.3077e-005
3183	1.3261e-002	4.8209e-002	3.5e-002	-4.2647e-005
3184	1.4216e-002	4.7936e-002	3.5e-002	-4.2187e-005
3185	1.5167e-002	4.7644e-002	3.5e-002	-4.1697e-005
3186	1.6111e-002	4.7333e-002	3.5e-002	-4.1178e-005
3187	1.7049e-002	4.7004e-002	3.5e-002	-4.0631e-005
3188	1.798e-002	4.6655e-002	3.5e-002	-4.0057e-005
3189	1.8904e-002	4.6289e-002	3.5e-002	-3.9457e-005
3190	1.9821e-002	4.5904e-002	3.5e-002	-3.8831e-005
3191	2.073e-002	4.55e-002	3.5e-002	-3.8181e-005
3192	2.163e-002	4.5079e-002	3.5e-002	-3.7507e-005
3193	2.2522e-002	4.464e-002	3.5e-002	-3.681e-005
3194	-2.3405e-002	4.4184e-002	3.4e-002	-3.6091e-005
3195	-2.3405e-002	4.4184e-002	3.3e-002	-3.6091e-005
3196	-2.3405e-002	4.4184e-002	3.2e-002	-3.6091e-005
3197	-2.3405e-002	4.4184e-002	3.1e-002	-3.6091e-005
3198	-2.3405e-002	4.4184e-002	3.e-002	-3.6091e-005
3199	-2.3405e-002	4.4184e-002	2.9e-002	-3.6091e-005
3200	-2.3405e-002	4.4184e-002	2.8e-002	-3.6091e-005
3201	-2.3405e-002	4.4184e-002	2.7e-002	-3.6091e-005
3202	-2.3405e-002	4.4184e-002	2.6e-002	-3.609e-005
3203	-2.3405e-002	4.4184e-002	2.5e-002	-3.6087e-005
3204	-2.2522e-002	4.464e-002	1.7e-002	-3.6809e-005
3205	-2.2522e-002	4.464e-002	1.8e-002	-3.6806e-005
3206	-2.2532e-002	4.4636e-002	1.9003e-002	-3.6801e-005
3207	-2.2535e-002	4.4634e-002	2.0005e-002	-3.6797e-005
3208	-2.2541e-002	4.4631e-002	2.1005e-002	-3.6794e-005
3209	2.2522e-002	4.464e-002	1.6e-002	-3.681e-005
3210	2.163e-002	4.5079e-002	1.6e-002	-3.7507e-005
3211	2.073e-002	4.55e-002	1.6e-002	-3.8181e-005
3212	1.9821e-002	4.5903e-002	1.6e-002	-3.8831e-005
3213	1.8904e-002	4.6289e-002	1.6e-002	-3.9457e-005
3214	1.798e-002	4.6655e-002	1.6e-002	-4.0057e-005
3215	1.7049e-002	4.7003e-002	1.6e-002	-4.0631e-005
3216	1.6111e-002	4.7333e-002	1.6e-002	-4.1178e-005
3217	1.5167e-002	4.7644e-002	1.6e-002	-4.1697e-005
3218	1.4217e-002	4.7936e-002	1.6e-002	-4.2186e-005
3219	1.3261e-002	4.8209e-002	1.6e-002	-4.2647e-005
3220	1.23e-002	4.8464e-002	1.6e-002	-4.3077e-005
3221	1.1334e-002	4.8699e-002	1.6e-002	-4.3477e-005
3222	1.0363e-002	4.8914e-002	1.6e-002	-4.3845e-005
3223	9.3886e-003	4.9111e-002	1.6e-002	-4.4182e-005
3224	8.4104e-003	4.9288e-002	1.6e-002	-4.4486e-005
3225	7.4287e-003	4.9445e-002	1.6e-002	-4.4758e-005
3226	6.4442e-003	4.9583e-002	1.6e-002	-4.4996e-005
3227	5.4571e-003	4.9701e-002	1.6e-002	-4.5201e-005
3228	4.4679e-003	4.98e-002	1.6e-002	-4.5372e-005
3229	3.4768e-003	4.9879e-002	1.6e-002	-4.551e-005
3230	2.4845e-003	4.9938e-002	1.6e-002	-4.5613e-005
3231	1.4911e-003	4.9978e-002	1.6e-002	-4.5682e-005
3232	4.9714e-004	4.9998e-002	1.6e-002	-4.5716e-005
3233	-4.9704e-004	4.9998e-002	1.6e-002	-4.5716e-005
3234	-1.491e-003	4.9978e-002	1.6e-002	-4.5682e-005
3235	-2.4844e-003	4.9938e-002	1.6e-002	-4.5613e-005
3236	-3.4767e-003	4.9879e-002	1.6e-002	-4.551e-005
3237	-4.4678e-003	4.98e-002	1.6e-002	-4.5372e-005
3238	-5.457e-003	4.9701e-002	1.6e-002	-4.5201e-005
3239	-6.4441e-003	4.9583e-002	1.6e-002	-4.4996e-005
3240	-7.4286e-003	4.9445e-002	1.6e-002	-4.4758e-005
3241	-8.4103e-003	4.9288e-002	1.6e-002	-4.4486e-005
3242	-9.3885e-003	4.9111e-002	1.6e-002	-4.4182e-005
3243	-1.0363e-002	4.8914e-002	1.6e-002	-4.3845e-005
3244	-1.1334e-002	4.8699e-002	1.6e-002	-4.3477e-005
3245	-1.23e-002	4.8464e-002	1.6e-002	-4.3077e-005
3246	-1.3261e-002	4.8209e-002	1.6e-002	-4.2647e-005
3247	-1.4217e-002	4.7936e-002	1.6e-002	-4.2186e-005
3248	-1.5167e-002	4.7644e-002	1.6e-002	-4.1697e-005
3249	-1.6111e-002	4.7333e-002	1.6e-002	-4.1178e-005
3250	-1.7049e-002	4.7004e-002	1.6e-002	-4.0631e-005
3251	-1.798e-002	4.6655e-002	1.6e-002	-4.0057e-005
3252	-1.8904e-002	4.6289e-002	1.6e-002	-3.9457e-005
3253	-1.9821e-002	4.5904e-002	1.6e-002	-3.8831e-005
3254	-2.073e-002	4.55e-002	1.6e-002	-3.8181e-005
3255	-2.163e-002	4.5079e-002	1.6e-002	-3.7506e-005
3256	2.2522e-002	4.464e-002	3.4e-002	-3.681e-005
3257	2.2522e-002	4.464e-002	3.3e-002	-3.681e-005
3258	2.2522e-002	4.464e-002	3.2e-002	-3.681e-005
3259	2.2522e-002	4.464e-002	3.1e-002	-3.681e-005
3260	2.2522e-002	4.464e-002	3.e-002	-3.681e-005
3261	2.2522e-002	4.464e-002	2.9e-002	-3.681e-005
3262	2.2522e-002	4.464e-002	2.8e-002	-3.681e-005
3263	2.2522e-002	4.464e-002	2.7e-002	-3.681e-005
3264	2.2522e-002	4.464e-002	2.6e-002	-3.681e-005
3265	2.2522e-002	4.464e-002	2.4e-002	-3.681e-005
3266	2.2522e-002	4.464e-002	2.3e-002	-3.681e-005
3267	2.2522e-002	4.464e-002	2.2e-002	-3.681e-005
3268	2.2522e-002	4.464e-002	2.1e-002	-3.681e-005
3269	2.2522e-002	4.464e-002	2.e-002	-3.681e-005
3270	2.2522e-002	4.464e-002	1.9e-002	-3.681e-005
3271	2.2522e-002	4.464e-002	1.8e-002	-3.681e-005
3272	-2.2522e-002	4.464e-002	3.4e-002	-3.681e-005
3273	-2.163e-002	4.5079e-002	3.4e-002	-3.7506e-005
3274	-2.073e-002	4.55e-002	3.4e-002	-3.8181e-005
3275	-1.9821e-002	4.5904e-002	3.4e-002	-3.8831e-005
3276	-1.8904e-002	4.6288e-002	3.4e-002	-3.9457e-005
3277	-1.798e-002	4.6655e-002	3.4e-002	-4.0057e-005
3278	-1.7049e-002	4.7003e-002	3.4e-002	-4.0631e-005
3279	-1.6111e-002	4.7333e-002	3.4e-002	-4.1178e-005
3280	-1.5167e-002	4.7644e-002	3.4e-002	-4.1697e-005
3281	-1.4217e-002	4.7936e-002	3.4e-002	-4.2186e-005
3282	-1.3261e-002	4.8209e-002	3.4e-002	-4.2647e-005
3283	-1.23e-002	4.8464e-002	3.4e-002	-4.3077e-005
3284	-1.1334e-002	4.8699e-002	3.4e-002	-4.3477e-005
3285	-1.0363e-002	4.8914e-002	3.4e-002	-4.3845e-005
3286	-9.3888e-003	4.9111e-002	3.4e-002	-4.4182e-005
3287	-8.4104e-003	4.9288e-002	3.4e-002	-4.4486e-005
3288	-7.4289e-003	4.9445e-002	3.4e-002	-4.4758e-005
3289	-6.4442e-003	4.9583e-002	3.4e-002	-4.4996e-005
3290	-5.4573e-003	4.9701e-002	3.4e-002	-4.5201e-005
3291	-4.4679e-003	4.98e-002	3.4e-002	-4.5372e-005
3292	-3.477e-003	4.9879e-002	3.4e-002	-4.551e-005
3293	-2.4845e-003	4.9938e-002	3.4e-002	-4.5613e-005
3294	-1.4912e-003	4.9978e-002	3.4e-002	-4.5682e-005
3295	-4.9717e-004	4.9998e-002	3.4e-002	-4.5716e-005
3296	4.9687e-004	4.9998e-002	3.4e-002	-4.5716e-005
3297	1.491e-003	4.9978e-002	3.4e-002	-4.5682e-005
3298	2.4842e-003	4.9938e-002	3.4e-002	-4.5613e-005
3299	3.4767e-003	4.9879e-002	3.4e-002	-4.551e-005
3300	4.4676e-003	4.98e-002	3.4e-002	-4.5372e-005
3301	5.457e-003	4.9701e-002	3.4e-002	-4.5201e-005
3302	6.444e-003	4.9583e-002	3.4e-002	-4.4996e-005
3303	7.4286e-003	4.9445e-002	3.4e-002	-4.4758e-005
3304	8.4101e-003	4.9288e-002	3.4e-002	-4.4486e-005
3305	9.3885e-003	4.9111e-002	3.4e-002	-4.4182e-005
3306	1.0363e-002	4.8914e-002	3.4e-002	-4.3845e-005
3307	1.1334e-002	4.8699e-002	3.4e-002	-4.3477e-005
3308	1.2299e-002	4.8464e-002	3.4e-002	-4.3077e-005
3309	1.3261e-002	4.8209e-002	3.4e-002	-4.2647e-005
3310	1.4216e-002	4.7936e-002	3.4e-002	-4.2187e-005
3311	1.5167e-002	4.7644e-002	3.4e-002	-4.1697e-005
3312	1.6111e-002	4.7333e-002	3.4e-002	-4.1178e-005
3313	1.7049e-002	4.7004e-002	3.4e-002	-4.0631e-005
3314	1.798e-002	4.6655e-002	3.4e-002	-4.0057e-005
3315	1.8904e-002	4.6289e-002	3.4e-002	-3.9457e-005
3316	1.9821e-002	4.5904e-002	3.4e-002	-3.8831e-005
3317	2.073e-002	4.55e-002	3.4e-002	-3.8181e-005
3318	2.163e-002	4.5079e-002	3.4e-002	-3.7507e-005
3319	-2.3417e-002	4.4177e-002	2.3998e-002	-3.6079e-005
3320	-2.343e-002	4.417e-002	2.3001e-002	-3.6069e-005
3321	-2.3441e-002	4.4165e-002	2.2009e-002	-3.6062e-005
3322	-2.2522e-002	4.464e-002	3.3e-002	-3.681e-005
3323	-2.2522e-002	4.464e-002	3.2e-002	-3.681e-005
3324	-2.2523e-002	4.464e-002	3.1e-002	-3.681e-005
3325	-2.2523e-002	4.464e-002	3.e-002	-3.681e-005
3326	-2.2523e-002	4.464e-002	2.9e-002	-3.681e-005
3327	-2.2523e-002	4.464e-002	2.8e-002	-3.681e-005
3328	-2.2523e-002	4.464e-002	2.7e-002	-3.6809e-005
3329	-2.2523e-002	4.464e-002	2.6e-002	-3.6809e-005
3330	-2.2523e-002	4.464e-002	2.5e-002	-3.6809e-005
3331	-2.2523e-002	4.464e-002	2.4e-002	-3.6806e-005
3332	-2.163e-002	4.5079e-002	1.7e-002	-3.7506e-005
3333	-2.163e-002	4.5079e-002	1.8e-002	-3.7506e-005
3334	-2.163e-002	4.5079e-002	1.9e-002	-3.7505e-005
3335	-2.163e-002	4.5079e-002	2.e-002	-3.7503e-005
3336	-2.1638e-002	4.5075e-002	2.1001e-002	-3.7501e-005
3337	2.163e-002	4.5079e-002	1.7e-002	-3.7507e-005
3338	2.073e-002	4.55e-002	1.7e-002	-3.8181e-005
3339	1.8904e-002	4.6289e-002	1.7e-002	-3.9457e-005
3340	1.798e-002	4.6655e-002	1.7e-002	-4.0057e-005
3341	1.7049e-002	4.7003e-002	1.7e-002	-4.0631e-005
3342	1.6111e-002	4.7333e-002	1.7e-002	-4.1178e-005
3343	1.5167e-002	4.7644e-002	1.7e-002	-4.1697e-005
3344	1.4217e-002	4.7936e-002	1.7e-002	-4.2186e-005
3345	1.3261e-002	4.8209e-002	1.7e-002	-4.2647e-005
3346	1.23e-002	4.8464e-002	1.7e-002	-4.3077e-005
3347	1.1334e-002	4.8699e-002	1.7e-002	-4.3477e-005
3348	1.0363e-002	4.8914e-002	1.7e-002	-4.3845e-005
3349	9.3886e-003	4.9111e-002	1.7e-002	-4.4182e-005
3350	8.4104e-003	4.9288e-002	1.7e-002	-4.4486e-005
3351	7.4287e-003	4.9445e-002	1.7e-002	-4.4758e-005
3352	6.4442e-003	4.9583e-002	1.7e-002	-4.4996e-005
3353	5.4571e-003	4.9701e-002	1.7e-002	-4.5201e-005
3354	4.4679e-003	4.98e-002	1.7e-002	-4.5372e-005
3355	3.4768e-003	4.9879e-002	1.7e-002	-4.551e-005
3356	2.4845e-003	4.9938e-002	1.7e-002	-4.5613e-005
3357	1.4911e-003	4.9978e-002	1.7e-002	-4.5682e-005
3358	4.9715e-004	4.9998e-002	1.7e-002	-4.5716e-005
3359	-4.9704e-004	4.9998e-002	1.7e-002	-4.5716e-005
3360	-1.491e-003	4.9978e-002	1.7e-002	-4.5682e-005
3361	-2.4844e-003	4.9938e-002	1.7e-002	-4.5613e-005
3362	-3.4767e-003	4.9879e-002	1.7e-002	-4.551e-005
3363	-4.4678e-003	4.98e-002	1.7e-002	-4.5372e-005
3364	-5.457e-003	4.9701e-002	1.7e-002	-4.5201e-005
3365	-6.4441e-003	4.9583e-002	1.7e-002	-4.4996e-005
3366	-7.4286e-003	4.9445e-002	1.7e-002	-4.4758e-005
3367	-8.4103e-003	4.9288e-002	1.7e-002	-4.4486e-005
3368	-9.3885e-003	4.9111e-002	1.7e-002	-4.4182e-005
3369	-1.0363e-002	4.8914e-002	1.7e-002	-4.3845e-005
3370	-1.1334e-002	4.8699e-002	1.7e-002	-4.3477e-005
3371	-1.23e-002	4.8464e-002	1.7e-002	-4.3077e-005
3372	-1.3261e-002	4.8209e-002	1.7e-002	-4.2647e-005
3373	-1.4217e-002	4.7936e-002	1.7e-002	-4.2186e-005
3374	-1.5167e-002	4.7644e-002	1.7e-002	-4.1697e-005
3375	-1.6111e-002	4.7333e-002	1.7e-002	-4.1178e-005
3376	-1.7049e-002	4.7004e-002	1.7e-002	-4.0631e-005
3377	-1.798e-002	4.6655e-002	1.7e-002	-4.0057e-005
3378	-1.8904e-002	4.6289e-002	1.7e-002	-3.9457e-005
3379	-2.073e-002	4.55e-002	1.7e-002	-3.8181e-005
3380	2.163e-002	4.5079e-002	3.3e-002	-3.7506e-005
3381	2.163e-002	4.5079e-002	3.2e-002	-3.7506e-005
3382	2.163e-002	4.5079e-002	3.1e-002	-3.7506e-005
3383	2.163e-002	4.5079e-002	3.e-002	-3.7506e-005
3384	2.163e-002	4.5079e-002	2.9e-002	-3.7506e-005
3385	2.163e-002	4.5079e-002	2.8e-002	-3.7506e-005
3386	2.163e-002	4.5079e-002	2.7e-002	-3.7506e-005
3387	2.163e-002	4.5079e-002	2.6e-002	-3.7506e-005
3388	2.163e-002	4.5079e-002	2.5e-002	-3.7506e-005
3389	2.163e-002	4.5079e-002	2.4e-002	-3.7506e-005
3390	2.163e-002	4.5079e-002	2.3e-002	-3.7506e-005
3391	2.163e-002	4.5079e-002	2.2e-002	-3.7506e-005
3392	2.1631e-002	4.5079e-002	2.e-002	-3.7506e-005
3393	2.1631e-002	4.5079e-002	1.9e-002	-3.7506e-005
3394	2.1631e-002	4.5079e-002	1.8e-002	-3.7506e-005
3395	-2.2538e-002	4.4632e-002	2.2001e-002	-3.6796e-005
3396	-2.2534e-002	4.4634e-002	2.3e-002	-3.6801e-005
3397	-2.163e-002	4.5079e-002	3.3e-002	-3.7506e-005
3398	-2.073e-002	4.55e-002	3.3e-002	-3.8181e-005
3399	-1.9821e-002	4.5903e-002	3.3e-002	-3.8831e-005
3400	-1.8904e-002	4.6288e-002	3.3e-002	-3.9457e-005
3401	-1.798e-002	4.6655e-002	3.3e-002	-4.0057e-005
3402	-1.7049e-002	4.7003e-002	3.3e-002	-4.0631e-005
3403	-1.6111e-002	4.7333e-002	3.3e-002	-4.1178e-005
3404	-1.5167e-002	4.7644e-002	3.3e-002	-4.1697e-005
3405	-1.4217e-002	4.7936e-002	3.3e-002	-4.2186e-005
3406	-1.3261e-002	4.8209e-002	3.3e-002	-4.2647e-005
3407	-1.23e-002	4.8464e-002	3.3e-002	-4.3077e-005
3408	-1.1334e-002	4.8699e-002	3.3e-002	-4.3477e-005
3409	-1.0363e-002	4.8914e-002	3.3e-002	-4.3845e-005
3410	-9.3888e-003	4.9111e-002	3.3e-002	-4.4182e-005
3411	-8.4104e-003	4.9288e-002	3.3e-002	-4.4486e-005
3412	-7.4289e-003	4.9445e-002	3.3e-002	-4.4758e-005
3413	-6.4442e-003	4.9583e-002	3.3e-002	-4.4996e-005
3414	-5.4573e-003	4.9701e-002	3.3e-002	-4.5201e-005
3415	-4.4679e-003	4.98e-002	3.3e-002	-4.5372e-005
3416	-3.477e-003	4.9879e-002	3.3e-002	-4.551e-005
3417	-2.4845e-003	4.9938e-002	3.3e-002	-4.5613e-005
3418	-1.4912e-003	4.9978e-002	3.3e-002	-4.5682e-005
3419	-4.9717e-004	4.9998e-002	3.3e-002	-4.5716e-005
3420	4.9688e-004	4.9998e-002	3.3e-002	-4.5716e-005
3421	1.491e-003	4.9978e-002	3.3e-002	-4.5682e-005
3422	2.4842e-003	4.9938e-002	3.3e-002	-4.5613e-005
3423	3.4767e-003	4.9879e-002	3.3e-002	-4.551e-005
3424	4.4676e-003	4.98e-002	3.3e-002	-4.5372e-005
3425	5.457e-003	4.9701e-002	3.3e-002	-4.5201e-005
3426	6.444e-003	4.9583e-002	3.3e-002	-4.4996e-005
3427	7.4286e-003	4.9445e-002	3.3e-002	-4.4758e-005
3428	8.4101e-003	4.9288e-002	3.3e-002	-4.4486e-005
3429	9.3885e-003	4.9111e-002	3.3e-002	-4.4182e-005
3430	1.0363e-002	4.8914e-002	3.3e-002	-4.3845e-005
3431	1.1334e-002	4.8699e-002	3.3e-002	-4.3477e-005
3432	1.2299e-002	4.8464e-002	3.3e-002	-4.3077e-005
3433	1.3261e-002	4.8209e-002	3.3e-002	-4.2647e-005
3434	1.4216e-002	4.7936e-002	3.3e-002	-4.2187e-005
3435	1.5167e-002	4.7644e-002	3.3e-002	-4.1697e-005
3436	1.6111e-002	4.7333e-002	3.3e-002	-4.1178e-005
3437	1.7049e-002	4.7004e-002	3.3e-002	-4.0631e-005
3438	1.798e-002	4.6655e-002	3.3e-002	-4.0057e-005
3439	1.8904e-002	4.6289e-002	3.3e-002	-3.9457e-005
3440	1.9821e-002	4.5904e-002	3.3e-002	-3.8831e-005
3441	2.073e-002	4.55e-002	3.3e-002	-3.8181e-005
3442	-2.163e-002	4.5079e-002	3.2e-002	-3.7506e-005
3443	-2.163e-002	4.5079e-002	3.1e-002	-3.7506e-005
3444	-2.163e-002	4.5079e-002	3.e-002	-3.7506e-005
3445	-2.163e-002	4.5079e-002	2.8e-002	-3.7506e-005
3446	-2.163e-002	4.5079e-002	2.7e-002	-3.7506e-005
3447	-2.163e-002	4.5079e-002	2.6e-002	-3.7506e-005
3448	2.073e-002	4.55e-002	1.8e-002	-3.8181e-005
3449	1.9821e-002	4.5903e-002	1.8e-002	-3.8831e-005
3450	1.8904e-002	4.6289e-002	1.8e-002	-3.9457e-005
3451	1.798e-002	4.6655e-002	1.8e-002	-4.0057e-005
3452	1.7049e-002	4.7003e-002	1.8e-002	-4.0631e-005
3453	1.5167e-002	4.7644e-002	1.8e-002	-4.1697e-005
3454	1.4217e-002	4.7936e-002	1.8e-002	-4.2186e-005
3455	1.3261e-002	4.8209e-002	1.8e-002	-4.2647e-005
3456	1.23e-002	4.8464e-002	1.8e-002	-4.3077e-005
3457	1.1334e-002	4.8699e-002	1.8e-002	-4.3477e-005
3458	1.0363e-002	4.8914e-002	1.8e-002	-4.3845e-005
3459	9.3887e-003	4.9111e-002	1.8e-002	-4.4182e-005
3460	8.4104e-003	4.9288e-002	1.8e-002	-4.4486e-005
3461	7.4288e-003	4.9445e-002	1.8e-002	-4.4758e-005
3462	6.4442e-003	4.9583e-002	1.8e-002	-4.4996e-005
3463	5.4571e-003	4.9701e-002	1.8e-002	-4.5201e-005
3464	4.4679e-003	4.98e-002	1.8e-002	-4.5372e-005
3465	3.4769e-003	4.9879e-002	1.8e-002	-4.551e-005
3466	2.4845e-003	4.9938e-002	1.8e-002	-4.5613e-005
3467	1.4911e-003	4.9978e-002	1.8e-002	-4.5682e-005
3468	4.9716e-004	4.9998e-002	1.8e-002	-4.5716e-005
3469	-4.9701e-004	4.9998e-002	1.8e-002	-4.5716e-005
3470	-1.491e-003	4.9978e-002	1.8e-002	-4.5682e-005
3471	-2.4843e-003	4.9938e-002	1.8e-002	-4.5613e-005
3472	-3.4767e-003	4.9879e-002	1.8e-002	-4.551e-005
3473	-4.4677e-003	4.98e-002	1.8e-002	-4.5372e-005
3474	-5.457e-003	4.9701e-002	1.8e-002	-4.5201e-005
3475	-6.4441e-003	4.9583e-002	1.8e-002	-4.4996e-005
3476	-7.4286e-003	4.9445e-002	1.8e-002	-4.4758e-005
3477	-8.4102e-003	4.9288e-002	1.8e-002	-4.4486e-005
3478	-9.3885e-003	4.9111e-002	1.8e-002	-4.4182e-005
3479	-1.0363e-002	4.8914e-002	1.8e-002	-4.3845e-005
3480	-1.1334e-002	4.8699e-002	1.8e-002	-4.3477e-005
3481	-1.23e-002	4.8464e-002	1.8e-002	-4.3077e-005
3482	-1.3261e-002	4.8209e-002	1.8e-002	-4.2647e-005
3483	-1.4217e-002	4.7936e-002	1.8e-002	-4.2187e-005
3484	-1.5167e-002	4.7644e-002	1.8e-002	-4.1697e-005
3485	-1.6111e-002	4.7333e-002	1.8e-002	-4.1178e-005
3486	-1.7049e-002	4.7004e-002	1.8e-002	-4.0631e-005
3487	-1.798e-002	4.6655e-002	1.8e-002	-4.0057e-005
3488	-1.9821e-002	4.5904e-002	1.8e-002	-3.8831e-005
3489	-2.073e-002	4.55e-002	1.8e-002	-3.8181e-005
3490	-2.073e-002	4.55e-002	1.9e-002	-3.8181e-005
3491	-2.073e-002	4.55e-002	2.e-002	-3.818e-005
3492	-2.073e-002	4.55e-002	2.1e-002	-3.818e-005
3493	-2.163e-002	4.5079e-002	2.2e-002	-3.7503e-005
3494	-2.163e-002	4.5079e-002	2.3e-002	-3.7505e-005
3495	-2.163e-002	4.5079e-002	2.4e-002	-3.7506e-005
3496	2.073e-002	4.55e-002	3.2e-002	-3.8181e-005
3497	2.073e-002	4.55e-002	3.1e-002	-3.8181e-005
3498	2.073e-002	4.55e-002	3.e-002	-3.8181e-005
3499	2.073e-002	4.55e-002	2.8e-002	-3.8181e-005
3500	2.073e-002	4.55e-002	2.6e-002	-3.8181e-005
3501	2.073e-002	4.55e-002	2.5e-002	-3.8181e-005
3502	2.073e-002	4.55e-002	2.4e-002	-3.8181e-005
3503	2.0729e-002	4.55e-002	2.3e-002	-3.8181e-005
3504	2.0729e-002	4.55e-002	2.2e-002	-3.8181e-005
3505	2.0729e-002	4.55e-002	2.1e-002	-3.8181e-005
3506	2.0729e-002	4.55e-002	2.e-002	-3.8181e-005
3507	2.0729e-002	4.55e-002	1.9e-002	-3.8181e-005
3508	-1.9821e-002	4.5903e-002	3.2e-002	-3.8831e-005
3509	-1.8904e-002	4.6288e-002	3.2e-002	-3.9457e-005
3510	-1.798e-002	4.6655e-002	3.2e-002	-4.0057e-005
3511	-1.7049e-002	4.7003e-002	3.2e-002	-4.0631e-005
3512	-1.6111e-002	4.7333e-002	3.2e-002	-4.1178e-005
3513	-1.5167e-002	4.7644e-002	3.2e-002	-4.1697e-005
3514	-1.4217e-002	4.7936e-002	3.2e-002	-4.2186e-005
3515	-1.3261e-002	4.8209e-002	3.2e-002	-4.2647e-005
3516	-1.23e-002	4.8464e-002	3.2e-002	-4.3077e-005
3517	-1.1334e-002	4.8699e-002	3.2e-002	-4.3477e-005
3518	-1.0363e-002	4.8914e-002	3.2e-002	-4.3845e-005
3519	-9.3888e-003	4.9111e-002	3.2e-002	-4.4182e-005
3520	-8.4104e-003	4.9288e-002	3.2e-002	-4.4486e-005
3521	-7.4289e-003	4.9445e-002	3.2e-002	-4.4758e-005
3522	-6.4442e-003	4.9583e-002	3.2e-002	-4.4996e-005
3523	-5.4573e-003	4.9701e-002	3.2e-002	-4.5201e-005
3524	-4.4679e-003	4.98e-002	3.2e-002	-4.5372e-005
3525	-3.477e-003	4.9879e-002	3.2e-002	-4.551e-005
3526	-2.4845e-003	4.9938e-002	3.2e-002	-4.5613e-005
3527	-1.4912e-003	4.9978e-002	3.2e-002	-4.5682e-005
3528	-4.9716e-004	4.9998e-002	3.2e-002	-4.5716e-005
3529	4.9688e-004	4.9998e-002	3.2e-002	-4.5716e-005
3530	1.491e-003	4.9978e-002	3.2e-002	-4.5682e-005
3531	2.4842e-003	4.9938e-002	3.2e-002	-4.5613e-005
3532	3.4767e-003	4.9879e-002	3.2e-002	-4.551e-005
3533	4.4676e-003	4.98e-002	3.2e-002	-4.5372e-005
3534	5.457e-003	4.9701e-002	3.2e-002	-4.5201e-005
3535	6.444e-003	4.9583e-002	3.2e-002	-4.4996e-005
3536	7.4286e-003	4.9445e-002	3.2e-002	-4.4758e-005
3537	8.4101e-003	4.9288e-002	3.2e-002	-4.4486e-005
3538	9.3885e-003	4.9111e-002	3.2e-002	-4.4182e-005
3539	1.0363e-002	4.8914e-002	3.2e-002	-4.3845e-005
3540	1.1334e-002	4.8699e-002	3.2e-002	-4.3477e-005
3541	1.2299e-002	4.8464e-002	3.2e-002	-4.3077e-005
3542	1.3261e-002	4.8209e-002	3.2e-002	-4.2647e-005
3543	1.4216e-002	4.7936e-002	3.2e-002	-4.2187e-005
3544	1.5167e-002	4.7644e-002	3.2e-002	-4.1697e-005
3545	1.6111e-002	4.7333e-002	3.2e-002	-4.1178e-005
3546	1.7049e-002	4.7004e-002	3.2e-002	-4.0631e-005
3547	1.798e-002	4.6655e-002	3.2e-002	-4.0057e-005
3548	1.8904e-002	4.6289e-002	3.2e-002	-3.9457e-005
3549	1.9821e-002	4.5904e-002	3.2e-002	-3.8831e-005
3550	-2.073e-002	4.55e-002	3.1e-002	-3.8181e-005
3551	-2.073e-002	4.55e-002	3.e-002	-3.8181e-005
3552	-2.073e-002	4.55e-002	2.9e-002	-3.8181e-005
3553	-2.073e-002	4.55e-002	2.8e-002	-3.8181e-005
3554	-2.073e-002	4.55e-002	2.7e-002	-3.8181e-005
3555	-2.073e-002	4.55e-002	2.6e-002	-3.8181e-005
3556	-2.073e-002	4.55e-002	2.5e-002	-3.8181e-005
3557	-2.073e-002	4.55e-002	2.4e-002	-3.8181e-005
3558	-1.9821e-002	4.5904e-002	1.9e-002	-3.8831e-005
3559	-1.9821e-002	4.5904e-002	2.e-002	-3.8831e-005
3560	-1.9821e-002	4.5904e-002	2.1e-002	-3.8831e-005
3561	-2.073e-002	4.55e-002	2.2e-002	-3.818e-005
3562	-2.073e-002	4.55e-002	2.3e-002	-3.8181e-005
3563	1.9821e-002	4.5903e-002	1.9e-002	-3.8831e-005
3564	1.8904e-002	4.6289e-002	1.9e-002	-3.9457e-005
3565	1.7049e-002	4.7003e-002	1.9e-002	-4.0631e-005
3566	1.6111e-002	4.7333e-002	1.9e-002	-4.1178e-005
3567	1.5167e-002	4.7644e-002	1.9e-002	-4.1697e-005
3568	1.4217e-002	4.7936e-002	1.9e-002	-4.2186e-005
3569	1.3261e-002	4.8209e-002	1.9e-002	-4.2647e-005
3570	1.23e-002	4.8464e-002	1.9e-002	-4.3077e-005
3571	1.1334e-002	4.8699e-002	1.9e-002	-4.3477e-005
3572	1.0363e-002	4.8914e-002	1.9e-002	-4.3845e-005
3573	9.3887e-003	4.9111e-002	1.9e-002	-4.4182e-005
3574	8.4104e-003	4.9288e-002	1.9e-002	-4.4486e-005
3575	7.4288e-003	4.9445e-002	1.9e-002	-4.4758e-005
3576	6.4442e-003	4.9583e-002	1.9e-002	-4.4996e-005
3577	5.4571e-003	4.9701e-002	1.9e-002	-4.5201e-005
3578	4.4679e-003	4.98e-002	1.9e-002	-4.5372e-005
3579	3.4769e-003	4.9879e-002	1.9e-002	-4.551e-005
3580	2.4845e-003	4.9938e-002	1.9e-002	-4.5613e-005
3581	1.4911e-003	4.9978e-002	1.9e-002	-4.5682e-005
3582	4.9715e-004	4.9998e-002	1.9e-002	-4.5716e-005
3583	-4.9702e-004	4.9998e-002	1.9e-002	-4.5716e-005
3584	-1.491e-003	4.9978e-002	1.9e-002	-4.5682e-005
3585	-2.4844e-003	4.9938e-002	1.9e-002	-4.5613e-005
3586	-3.4767e-003	4.9879e-002	1.9e-002	-4.551e-005
3587	-4.4678e-003	4.98e-002	1.9e-002	-4.5372e-005
3588	-5.457e-003	4.9701e-002	1.9e-002	-4.5201e-005
3589	-6.4441e-003	4.9583e-002	1.9e-002	-4.4996e-005
3590	-7.4286e-003	4.9445e-002	1.9e-002	-4.4758e-005
3591	-8.4103e-003	4.9288e-002	1.9e-002	-4.4486e-005
3592	-9.3885e-003	4.9111e-002	1.9e-002	-4.4182e-005
3593	-1.0363e-002	4.8914e-002	1.9e-002	-4.3845e-005
3594	-1.1334e-002	4.8699e-002	1.9e-002	-4.3477e-005
3595	-1.23e-002	4.8464e-002	1.9e-002	-4.3077e-005
3596	-1.3261e-002	4.8209e-002	1.9e-002	-4.2647e-005
3597	-1.4217e-002	4.7936e-002	1.9e-002	-4.2187e-005
3598	-1.5167e-002	4.7644e-002	1.9e-002	-4.1697e-005
3599	-1.6111e-002	4.7333e-002	1.9e-002	-4.1178e-005
3600	-1.7049e-002	4.7004e-002	1.9e-002	-4.0631e-005
3601	-1.798e-002	4.6655e-002	1.9e-002	-4.0057e-005
3602	-1.8904e-002	4.6289e-002	1.9e-002	-3.9457e-005
3603	1.9821e-002	4.5904e-002	3.1e-002	-3.8831e-005
3604	1.9821e-002	4.5904e-002	3.e-002	-3.8831e-005
3605	1.9821e-002	4.5904e-002	2.9e-002	-3.8831e-005
3606	1.9821e-002	4.5904e-002	2.8e-002	-3.8831e-005
3607	1.9821e-002	4.5904e-002	2.7e-002	-3.8831e-005
3608	1.9821e-002	4.5904e-002	2.6e-002	-3.8831e-005
3609	1.9821e-002	4.5904e-002	2.5e-002	-3.8831e-005
3610	1.9821e-002	4.5904e-002	2.4e-002	-3.8831e-005
3611	1.9821e-002	4.5904e-002	2.3e-002	-3.8831e-005
3612	1.9821e-002	4.5904e-002	2.2e-002	-3.8831e-005
3613	1.9821e-002	4.5904e-002	2.1e-002	-3.8831e-005
3614	1.9821e-002	4.5904e-002	2.e-002	-3.8831e-005
3615	-1.9821e-002	4.5903e-002	3.1e-002	-3.8831e-005
3616	-1.8904e-002	4.6288e-002	3.1e-002	-3.9457e-005
3617	-1.798e-002	4.6655e-002	3.1e-002	-4.0057e-005
3618	-1.7049e-002	4.7003e-002	3.1e-002	-4.0631e-005
3619	-1.6111e-002	4.7333e-002	3.1e-002	-4.1178e-005
3620	-1.5167e-002	4.7644e-002	3.1e-002	-4.1697e-005
3621	-1.4217e-002	4.7936e-002	3.1e-002	-4.2186e-005
3622	-1.3261e-002	4.8209e-002	3.1e-002	-4.2647e-005
3623	-1.23e-002	4.8464e-002	3.1e-002	-4.3077e-005
3624	-1.1334e-002	4.8699e-002	3.1e-002	-4.3477e-005
3625	-1.0363e-002	4.8914e-002	3.1e-002	-4.3845e-005
3626	-9.3888e-003	4.9111e-002	3.1e-002	-4.4182e-005
3627	-8.4104e-003	4.9288e-002	3.1e-002	-4.4486e-005
3628	-7.4289e-003	4.9445e-002	3.1e-002	-4.4758e-005
3629	-6.4443e-003	4.9583e-002	3.1e-002	-4.4996e-005
3630	-5.4573e-003	4.9701e-002	3.1e-002	-4.5201e-005
3631	-4.4679e-003	4.98e-002	3.1e-002	-4.5372e-005
3632	-3.477e-003	4.9879e-002	3.1e-002	-4.551e-005
3633	-2.4845e-003	4.9938e-002	3.1e-002	-4.5613e-005
3634	-1.4912e-003	4.9978e-002	3.1e-002	-4.5682e-005
3635	-4.972e-004	4.9998e-002	3.1e-002	-4.5716e-005
3636	4.9688e-004	4.9998e-002	3.1e-002	-4.5716e-005
3637	1.4909e-003	4.9978e-002	3.1e-002	-4.5682e-005
3638	2.4842e-003	4.9938e-002	3.1e-002	-4.5613e-005
3639	3.4767e-003	4.9879e-002	3.1e-002	-4.551e-005
3640	4.4676e-003	4.98e-002	3.1e-002	-4.5372e-005
3641	5.4569e-003	4.9701e-002	3.1e-002	-4.5201e-005
3642	6.444e-003	4.9583e-002	3.1e-002	-4.4996e-005
3643	7.4286e-003	4.9445e-002	3.1e-002	-4.4758e-005
3644	8.4101e-003	4.9288e-002	3.1e-002	-4.4486e-005
3645	9.3885e-003	4.9111e-002	3.1e-002	-4.4182e-005
3646	1.0363e-002	4.8914e-002	3.1e-002	-4.3845e-005
3647	1.1334e-002	4.8699e-002	3.1e-002	-4.3477e-005
3648	1.2299e-002	4.8464e-002	3.1e-002	-4.3077e-005
3649	1.3261e-002	4.8209e-002	3.1e-002	-4.2647e-005
3650	1.4216e-002	4.7936e-002	3.1e-002	-4.2187e-005
3651	1.5167e-002	4.7644e-002	3.1e-002	-4.1697e-005
3652	1.6111e-002	4.7333e-002	3.1e-002	-4.1178e-005
3653	1.7049e-002	4.7004e-002	3.1e-002	-4.0631e-005
3654	1.798e-002	4.6655e-002	3.1e-002	-4.0057e-005
3655	1.8904e-002	4.6289e-002	3.1e-002	-3.9457e-005
3656	-1.9821e-002	4.5903e-002	3.e-002	-3.8831e-005
3657	-1.9821e-002	4.5903e-002	2.9e-002	-3.8831e-005
3658	-1.9821e-002	4.5903e-002	2.8e-002	-3.8831e-005
3659	-1.9821e-002	4.5903e-002	2.7e-002	-3.8831e-005
3660	-1.9821e-002	4.5903e-002	2.6e-002	-3.8831e-005
3661	-1.9821e-002	4.5903e-002	2.5e-002	-3.8831e-005
3662	-1.9821e-002	4.5904e-002	2.2e-002	-3.8831e-005
3663	-1.9821e-002	4.5904e-002	2.3e-002	-3.8831e-005
3664	-1.9821e-002	4.5903e-002	2.4e-002	-3.8831e-005
3665	-1.8904e-002	4.6289e-002	2.e-002	-3.9457e-005
3666	-1.8904e-002	4.6289e-002	2.1e-002	-3.9457e-005
3667	1.8904e-002	4.6289e-002	2.e-002	-3.9457e-005
3668	1.798e-002	4.6655e-002	2.e-002	-4.0057e-005
3669	1.7049e-002	4.7003e-002	2.e-002	-4.0631e-005
3670	1.6111e-002	4.7333e-002	2.e-002	-4.1178e-005
3671	1.5167e-002	4.7644e-002	2.e-002	-4.1697e-005
3672	1.4217e-002	4.7936e-002	2.e-002	-4.2186e-005
3673	1.3261e-002	4.8209e-002	2.e-002	-4.2647e-005
3674	1.23e-002	4.8464e-002	2.e-002	-4.3077e-005
3675	1.1334e-002	4.8699e-002	2.e-002	-4.3477e-005
3676	1.0363e-002	4.8914e-002	2.e-002	-4.3845e-005
3677	9.3887e-003	4.9111e-002	2.e-002	-4.4182e-005
3678	8.4104e-003	4.9288e-002	2.e-002	-4.4486e-005
3679	7.4288e-003	4.9445e-002	2.e-002	-4.4758e-005
3680	6.4442e-003	4.9583e-002	2.e-002	-4.4996e-005
3681	5.4571e-003	4.9701e-002	2.e-002	-4.5201e-005
3682	4.4679e-003	4.98e-002	2.e-002	-4.5372e-005
3683	3.4769e-003	4.9879e-002	2.e-002	-4.551e-005
3684	2.4845e-003	4.9938e-002	2.e-002	-4.5613e-005
3685	1.4911e-003	4.9978e-002	2.e-002	-4.5682e-005
3686	4.9717e-004	4.9998e-002	2.e-002	-4.5716e-005
3687	-4.9701e-004	4.9998e-002	2.e-002	-4.5716e-005
3688	-1.491e-003	4.9978e-002	2.e-002	-4.5682e-005
3689	-2.4843e-003	4.9938e-002	2.e-002	-4.5613e-005
3690	-3.4767e-003	4.9879e-002	2.e-002	-4.551e-005
3691	-4.4678e-003	4.98e-002	2.e-002	-4.5372e-005
3692	-5.457e-003	4.9701e-002	2.e-002	-4.5201e-005
3693	-6.4441e-003	4.9583e-002	2.e-002	-4.4996e-005
3694	-7.4286e-003	4.9445e-002	2.e-002	-4.4758e-005
3695	-8.4102e-003	4.9288e-002	2.e-002	-4.4486e-005
3696	-9.3885e-003	4.9111e-002	2.e-002	-4.4182e-005
3697	-1.0363e-002	4.8914e-002	2.e-002	-4.3845e-005
3698	-1.1334e-002	4.8699e-002	2.e-002	-4.3477e-005
3699	-1.23e-002	4.8464e-002	2.e-002	-4.3077e-005
3700	-1.3261e-002	4.8209e-002	2.e-002	-4.2647e-005
3701	-1.4217e-002	4.7936e-002	2.e-002	-4.2187e-005
3702	-1.5167e-002	4.7644e-002	2.e-002	-4.1697e-005
3703	-1.6111e-002	4.7333e-002	2.e-002	-4.1178e-005
3704	-1.7049e-002	4.7004e-002	2.e-002	-4.0631e-005
3705	-1.798e-002	4.6655e-002	2.e-002	-4.0057e-005
3706	1.8904e-002	4.6289e-002	3.e-002	-3.9457e-005
3707	1.8904e-002	4.6289e-002	2.9e-002	-3.9457e-005
3708	1.8904e-002	4.6289e-002	2.8e-002	-3.9457e-005
3709	1.8904e-002	4.6289e-002	2.7e-002	-3.9457e-005
3710	1.8904e-002	4.6289e-002	2.5e-002	-3.9457e-005
3711	1.8904e-002	4.6289e-002	2.4e-002	-3.9457e-005
3712	1.8904e-002	4.6289e-002	2.3e-002	-3.9457e-005
3713	1.8904e-002	4.6289e-002	2.2e-002	-3.9457e-005
3714	-1.8904e-002	4.6288e-002	3.e-002	-3.9457e-005
3715	-1.798e-002	4.6655e-002	3.e-002	-4.0057e-005
3716	-1.7049e-002	4.7003e-002	3.e-002	-4.0631e-005
3717	-1.6111e-002	4.7333e-002	3.e-002	-4.1178e-005
3718	-1.5167e-002	4.7644e-002	3.e-002	-4.1697e-005
3719	-1.4217e-002	4.7936e-002	3.e-002	-4.2186e-005
3720	-1.3261e-002	4.8209e-002	3.e-002	-4.2647e-005
3721	-1.23e-002	4.8464e-002	3.e-002	-4.3077e-005
3722	-1.1334e-002	4.8699e-002	3.e-002	-4.3477e-005
3723	-1.0363e-002	4.8914e-002	3.e-002	-4.3845e-005
3724	-9.3888e-003	4.9111e-002	3.e-002	-4.4182e-005
3725	-8.4105e-003	4.9288e-002	3.e-002	-4.4486e-005
3726	-7.4289e-003	4.9445e-002	3.e-002	-4.4758e-005
3727	-6.4443e-003	4.9583e-002	3.e-002	-4.4996e-005
3728	-5.4573e-003	4.9701e-002	3.e-002	-4.5201e-005
3729	-4.468e-003	4.98e-002	3.e-002	-4.5372e-005
3730	-3.477e-003	4.9879e-002	3.e-002	-4.551e-005
3731	-2.4846e-003	4.9938e-002	3.e-002	-4.5613e-005
3732	-1.4912e-003	4.9978e-002	3.e-002	-4.5682e-005
3733	-4.9723e-004	4.9998e-002	3.e-002	-4.5716e-005
3734	4.9688e-004	4.9998e-002	3.e-002	-4.5716e-005
3735	1.4909e-003	4.9978e-002	3.e-002	-4.5682e-005
3736	2.4842e-003	4.9938e-002	3.e-002	-4.5613e-005
3737	3.4767e-003	4.9879e-002	3.e-002	-4.551e-005
3738	4.4676e-003	4.98e-002	3.e-002	-4.5372e-005
3739	5.4569e-003	4.9701e-002	3.e-002	-4.5201e-005
3740	6.444e-003	4.9583e-002	3.e-002	-4.4996e-005
3741	7.4286e-003	4.9445e-002	3.e-002	-4.4758e-005
3742	8.4101e-003	4.9288e-002	3.e-002	-4.4486e-005
3743	9.3884e-003	4.9111e-002	3.e-002	-4.4182e-005
3744	1.0363e-002	4.8914e-002	3.e-002	-4.3845e-005
3745	1.1333e-002	4.8699e-002	3.e-002	-4.3477e-005
3746	1.2299e-002	4.8464e-002	3.e-002	-4.3077e-005
3747	1.3261e-002	4.821e-002	3.e-002	-4.2647e-005
3748	1.4216e-002	4.7936e-002	3.e-002	-4.2187e-005
3749	1.5167e-002	4.7644e-002	3.e-002	-4.1697e-005
3750	1.6111e-002	4.7333e-002	3.e-002	-4.1178e-005
3751	1.7049e-002	4.7004e-002	3.e-002	-4.0631e-005
3752	1.798e-002	4.6655e-002	3.e-002	-4.0057e-005
3753	-1.8904e-002	4.6289e-002	2.9e-002	-3.9457e-005
3754	-1.8904e-002	4.6289e-002	2.8e-002	-3.9457e-005
3755	-1.8904e-002	4.6289e-002	2.7e-002	-3.9457e-005
3756	-1.8904e-002	4.6289e-002	2.6e-002	-3.9457e-005
3757	-1.8904e-002	4.6289e-002	2.5e-002	-3.9457e-005
3758	-1.8904e-002	4.6289e-002	2.2e-002	-3.9457e-005
3759	-1.8904e-002	4.6289e-002	2.3e-002	-3.9457e-005
3760	-1.8904e-002	4.6289e-002	2.4e-002	-3.9457e-005
3761	-1.798e-002	4.6655e-002	2.1e-002	-4.0057e-005
3762	1.798e-002	4.6655e-002	2.1e-002	-4.0057e-005
3763	1.6111e-002	4.7333e-002	2.1e-002	-4.1178e-005
3764	1.5167e-002	4.7644e-002	2.1e-002	-4.1697e-005
3765	1.4217e-002	4.7936e-002	2.1e-002	-4.2186e-005
3766	1.3261e-002	4.8209e-002	2.1e-002	-4.2647e-005
3767	1.23e-002	4.8464e-002	2.1e-002	-4.3077e-005
3768	1.1334e-002	4.8699e-002	2.1e-002	-4.3477e-005
3769	1.0363e-002	4.8914e-002	2.1e-002	-4.3845e-005
3770	8.4104e-003	4.9288e-002	2.1e-002	-4.4486e-005
3771	7.4288e-003	4.9445e-002	2.1e-002	-4.4758e-005
3772	6.4442e-003	4.9583e-002	2.1e-002	-4.4996e-005
3773	5.4571e-003	4.9701e-002	2.1e-002	-4.5201e-005
3774	4.4679e-003	4.98e-002	2.1e-002	-4.5372e-005
3775	3.4769e-003	4.9879e-002	2.1e-002	-4.551e-005
3776	2.4845e-003	4.9938e-002	2.1e-002	-4.5613e-005
3777	1.4911e-003	4.9978e-002	2.1e-002	-4.5682e-005
3778	4.9716e-004	4.9998e-002	2.1e-002	-4.5716e-005
3779	-4.9701e-004	4.9998e-002	2.1e-002	-4.5716e-005
3780	-1.491e-003	4.9978e-002	2.1e-002	-4.5682e-005
3781	-2.4843e-003	4.9938e-002	2.1e-002	-4.5613e-005
3782	-3.4767e-003	4.9879e-002	2.1e-002	-4.551e-005
3783	-4.4677e-003	4.98e-002	2.1e-002	-4.5372e-005
3784	-5.457e-003	4.9701e-002	2.1e-002	-4.5201e-005
3785	-6.4441e-003	4.9583e-002	2.1e-002	-4.4996e-005
3786	-7.4286e-003	4.9445e-002	2.1e-002	-4.4758e-005
3787	-8.4102e-003	4.9288e-002	2.1e-002	-4.4486e-005
3788	-9.3885e-003	4.9111e-002	2.1e-002	-4.4182e-005
3789	-1.0363e-002	4.8914e-002	2.1e-002	-4.3845e-005
3790	-1.1334e-002	4.8699e-002	2.1e-002	-4.3477e-005
3791	-1.23e-002	4.8464e-002	2.1e-002	-4.3077e-005
3792	-1.3261e-002	4.8209e-002	2.1e-002	-4.2647e-005
3793	-1.4217e-002	4.7936e-002	2.1e-002	-4.2187e-005
3794	-1.5167e-002	4.7644e-002	2.1e-002	-4.1697e-005
3795	-1.6111e-002	4.7333e-002	2.1e-002	-4.1178e-005
3796	-1.7049e-002	4.7004e-002	2.1e-002	-4.0631e-005
3797	1.798e-002	4.6655e-002	2.9e-002	-4.0057e-005
3798	1.798e-002	4.6655e-002	2.8e-002	-4.0057e-005
3799	1.798e-002	4.6655e-002	2.7e-002	-4.0057e-005
3800	1.798e-002	4.6655e-002	2.6e-002	-4.0057e-005
3801	1.798e-002	4.6655e-002	2.5e-002	-4.0057e-005
3802	1.798e-002	4.6655e-002	2.4e-002	-4.0057e-005
3803	1.798e-002	4.6655e-002	2.2e-002	-4.0057e-005
3804	-1.798e-002	4.6655e-002	2.9e-002	-4.0057e-005
3805	-1.7049e-002	4.7003e-002	2.9e-002	-4.0631e-005
3806	-1.6111e-002	4.7333e-002	2.9e-002	-4.1178e-005
3807	-1.5167e-002	4.7644e-002	2.9e-002	-4.1697e-005
3808	-1.4217e-002	4.7936e-002	2.9e-002	-4.2186e-005
3809	-1.3261e-002	4.8209e-002	2.9e-002	-4.2647e-005
3810	-1.23e-002	4.8464e-002	2.9e-002	-4.3077e-005
3811	-1.1334e-002	4.8699e-002	2.9e-002	-4.3477e-005
3812	-1.0363e-002	4.8914e-002	2.9e-002	-4.3845e-005
3813	-9.3888e-003	4.9111e-002	2.9e-002	-4.4182e-005
3814	-8.4105e-003	4.9288e-002	2.9e-002	-4.4486e-005
3815	-7.4289e-003	4.9445e-002	2.9e-002	-4.4758e-005
3816	-6.4443e-003	4.9583e-002	2.9e-002	-4.4996e-005
3817	-5.4573e-003	4.9701e-002	2.9e-002	-4.5201e-005
3818	-4.468e-003	4.98e-002	2.9e-002	-4.5372e-005
3819	-3.477e-003	4.9879e-002	2.9e-002	-4.551e-005
3820	-2.4846e-003	4.9938e-002	2.9e-002	-4.5613e-005
3821	-1.4912e-003	4.9978e-002	2.9e-002	-4.5682e-005
3822	-4.9726e-004	4.9998e-002	2.9e-002	-4.5716e-005
3823	4.9689e-004	4.9998e-002	2.9e-002	-4.5716e-005
3824	1.4909e-003	4.9978e-002	2.9e-002	-4.5682e-005
3825	2.4842e-003	4.9938e-002	2.9e-002	-4.5613e-005
3826	3.4766e-003	4.9879e-002	2.9e-002	-4.551e-005
3827	4.4676e-003	4.98e-002	2.9e-002	-4.5372e-005
3828	5.4569e-003	4.9701e-002	2.9e-002	-4.5201e-005
3829	6.444e-003	4.9583e-002	2.9e-002	-4.4996e-005
3830	7.4285e-003	4.9445e-002	2.9e-002	-4.4758e-005
3831	8.4101e-003	4.9288e-002	2.9e-002	-4.4486e-005
3832	9.3884e-003	4.9111e-002	2.9e-002	-4.4182e-005
3833	1.0363e-002	4.8914e-002	2.9e-002	-4.3845e-005
3834	1.1333e-002	4.8699e-002	2.9e-002	-4.3477e-005
3835	1.2299e-002	4.8464e-002	2.9e-002	-4.3077e-005
3836	1.3261e-002	4.821e-002	2.9e-002	-4.2647e-005
3837	1.4216e-002	4.7936e-002	2.9e-002	-4.2187e-005
3838	1.5167e-002	4.7644e-002	2.9e-002	-4.1697e-005
3839	1.6111e-002	4.7333e-002	2.9e-002	-4.1178e-005
3840	1.7049e-002	4.7004e-002	2.9e-002	-4.0631e-005
3841	-1.798e-002	4.6655e-002	2.8e-002	-4.0057e-005
3842	-1.798e-002	4.6655e-002	2.7e-002	-4.0057e-005
3843	-1.798e-002	4.6655e-002	2.6e-002	-4.0057e-005
3844	-1.798e-002	4.6655e-002	2.5e-002	-4.0057e-005
3845	1.7049e-002	4.7003e-002	2.2e-002	-4.0631e-005
3846	1.6111e-002	4.7333e-002	2.2e-002	-4.1178e-005
3847	1.5167e-002	4.7644e-002	2.2e-002	-4.1697e-005
3848	1.4217e-002	4.7936e-002	2.2e-002	-4.2186e-005
3849	1.3261e-002	4.8209e-002	2.2e-002	-4.2647e-005
3850	1.23e-002	4.8464e-002	2.2e-002	-4.3077e-005
3851	1.0363e-002	4.8914e-002	2.2e-002	-4.3845e-005
3852	9.3887e-003	4.9111e-002	2.2e-002	-4.4182e-005
3853	8.4104e-003	4.9288e-002	2.2e-002	-4.4486e-005
3854	7.4288e-003	4.9445e-002	2.2e-002	-4.4758e-005
3855	6.4442e-003	4.9583e-002	2.2e-002	-4.4996e-005
3856	5.4571e-003	4.9701e-002	2.2e-002	-4.5201e-005
3857	4.4679e-003	4.98e-002	2.2e-002	-4.5372e-005
3858	2.4845e-003	4.9938e-002	2.2e-002	-4.5613e-005
3859	4.9716e-004	4.9998e-002	2.2e-002	-4.5716e-005
3860	-1.491e-003	4.9978e-002	2.2e-002	-4.5682e-005
3861	-3.4767e-003	4.9879e-002	2.2e-002	-4.551e-005
3862	-5.457e-003	4.9701e-002	2.2e-002	-4.5201e-005
3863	-7.4286e-003	4.9445e-002	2.2e-002	-4.4758e-005
3864	-9.3885e-003	4.9111e-002	2.2e-002	-4.4182e-005
3865	-1.1334e-002	4.8699e-002	2.2e-002	-4.3477e-005
3866	-1.3261e-002	4.8209e-002	2.2e-002	-4.2647e-005
3867	-1.4217e-002	4.7936e-002	2.2e-002	-4.2187e-005
3868	-1.5167e-002	4.7644e-002	2.2e-002	-4.1697e-005
3869	-1.6111e-002	4.7333e-002	2.2e-002	-4.1178e-005
3870	-1.7049e-002	4.7004e-002	2.2e-002	-4.0631e-005
3871	-1.798e-002	4.6655e-002	2.2e-002	-4.0057e-005
3872	-1.798e-002	4.6655e-002	2.3e-002	-4.0057e-005
3873	-1.798e-002	4.6655e-002	2.4e-002	-4.0057e-005
3874	1.7049e-002	4.7004e-002	2.8e-002	-4.0631e-005
3875	1.7049e-002	4.7004e-002	2.7e-002	-4.0631e-005
3876	1.7049e-002	4.7004e-002	2.6e-002	-4.0631e-005
3877	1.7049e-002	4.7004e-002	2.5e-002	-4.0631e-005
3878	1.7049e-002	4.7004e-002	2.4e-002	-4.0631e-005
3879	1.7049e-002	4.7004e-002	2.3e-002	-4.0631e-005
3880	-1.7049e-002	4.7003e-002	2.8e-002	-4.0631e-005
3881	-1.6111e-002	4.7333e-002	2.8e-002	-4.1178e-005
3882	-1.5167e-002	4.7644e-002	2.8e-002	-4.1697e-005
3883	-1.3261e-002	4.8209e-002	2.8e-002	-4.2647e-005
3884	-1.23e-002	4.8464e-002	2.8e-002	-4.3077e-005
3885	-1.1334e-002	4.8699e-002	2.8e-002	-4.3477e-005
3886	-1.0363e-002	4.8914e-002	2.8e-002	-4.3845e-005
3887	-8.4106e-003	4.9288e-002	2.8e-002	-4.4486e-005
3888	-6.4444e-003	4.9583e-002	2.8e-002	-4.4996e-005
3889	-5.4573e-003	4.9701e-002	2.8e-002	-4.5201e-005
3890	-4.4681e-003	4.98e-002	2.8e-002	-4.5372e-005
3891	-3.477e-003	4.9879e-002	2.8e-002	-4.551e-005
3892	-2.4846e-003	4.9938e-002	2.8e-002	-4.5613e-005
3893	-1.4912e-003	4.9978e-002	2.8e-002	-4.5682e-005
3894	-4.9731e-004	4.9998e-002	2.8e-002	-4.5716e-005
3895	4.9689e-004	4.9998e-002	2.8e-002	-4.5716e-005
3896	1.4908e-003	4.9978e-002	2.8e-002	-4.5682e-005
3897	2.4842e-003	4.9938e-002	2.8e-002	-4.5613e-005
3898	3.4766e-003	4.9879e-002	2.8e-002	-4.551e-005
3899	4.4676e-003	4.98e-002	2.8e-002	-4.5372e-005
3900	5.4568e-003	4.9701e-002	2.8e-002	-4.5201e-005
3901	6.444e-003	4.9583e-002	2.8e-002	-4.4996e-005
3902	7.4285e-003	4.9445e-002	2.8e-002	-4.4758e-005
3903	8.4101e-003	4.9288e-002	2.8e-002	-4.4486e-005
3904	9.3884e-003	4.9111e-002	2.8e-002	-4.4182e-005
3905	1.0363e-002	4.8914e-002	2.8e-002	-4.3845e-005
3906	1.1333e-002	4.8699e-002	2.8e-002	-4.3477e-005
3907	1.2299e-002	4.8464e-002	2.8e-002	-4.3077e-005
3908	1.3261e-002	4.821e-002	2.8e-002	-4.2647e-005
3909	1.4216e-002	4.7936e-002	2.8e-002	-4.2187e-005
3910	1.5167e-002	4.7644e-002	2.8e-002	-4.1697e-005
3911	1.6111e-002	4.7333e-002	2.8e-002	-4.1178e-005
3912	-1.7049e-002	4.7003e-002	2.7e-002	-4.0631e-005
3913	-1.7049e-002	4.7003e-002	2.6e-002	-4.0631e-005
3914	-1.7049e-002	4.7003e-002	2.5e-002	-4.0631e-005
3915	-1.7049e-002	4.7003e-002	2.3e-002	-4.0631e-005
3916	-1.7049e-002	4.7003e-002	2.4e-002	-4.0631e-005
3917	1.6111e-002	4.7333e-002	2.3e-002	-4.1178e-005
3918	1.5167e-002	4.7644e-002	2.3e-002	-4.1697e-005
3919	1.4217e-002	4.7936e-002	2.3e-002	-4.2186e-005
3920	1.3261e-002	4.8209e-002	2.3e-002	-4.2647e-005
3921	1.23e-002	4.8464e-002	2.3e-002	-4.3077e-005
3922	1.1334e-002	4.8699e-002	2.3e-002	-4.3477e-005
3923	1.0363e-002	4.8914e-002	2.3e-002	-4.3845e-005
3924	9.3887e-003	4.9111e-002	2.3e-002	-4.4182e-005
3925	7.4288e-003	4.9445e-002	2.3e-002	-4.4758e-005
3926	6.4443e-003	4.9583e-002	2.3e-002	-4.4996e-005
3927	5.4571e-003	4.9701e-002	2.3e-002	-4.5201e-005
3928	4.4679e-003	4.98e-002	2.3e-002	-4.5372e-005
3929	3.4769e-003	4.9879e-002	2.3e-002	-4.551e-005
3930	2.4845e-003	4.9938e-002	2.3e-002	-4.5613e-005
3931	1.4911e-003	4.9978e-002	2.3e-002	-4.5682e-005
3932	4.9718e-004	4.9998e-002	2.3e-002	-4.5716e-005
3933	-4.9701e-004	4.9998e-002	2.3e-002	-4.5716e-005
3934	-1.4909e-003	4.9978e-002	2.3e-002	-4.5682e-005
3935	-2.4843e-003	4.9938e-002	2.3e-002	-4.5613e-005
3936	-3.4767e-003	4.9879e-002	2.3e-002	-4.551e-005
3937	-4.4677e-003	4.98e-002	2.3e-002	-4.5372e-005
3938	-5.457e-003	4.9701e-002	2.3e-002	-4.5201e-005
3939	-6.4441e-003	4.9583e-002	2.3e-002	-4.4996e-005
3940	-7.4286e-003	4.9445e-002	2.3e-002	-4.4758e-005
3941	-8.4102e-003	4.9288e-002	2.3e-002	-4.4486e-005
3942	-9.3885e-003	4.9111e-002	2.3e-002	-4.4181e-005
3943	-1.0366e-002	4.8914e-002	2.3011e-002	-4.3844e-005
3944	-1.1338e-002	4.8698e-002	2.3012e-002	-4.3475e-005
3945	-1.23e-002	4.8464e-002	2.3e-002	-4.3076e-005
3946	-1.3261e-002	4.8209e-002	2.3e-002	-4.2647e-005
3947	-1.4217e-002	4.7936e-002	2.3e-002	-4.2187e-005
3948	-1.5167e-002	4.7644e-002	2.3e-002	-4.1697e-005
3949	-1.6111e-002	4.7333e-002	2.3e-002	-4.1178e-005
3950	1.6111e-002	4.7333e-002	2.7e-002	-4.1178e-005
3951	1.6111e-002	4.7333e-002	2.6e-002	-4.1178e-005
3952	1.6111e-002	4.7333e-002	2.5e-002	-4.1178e-005
3953	1.6111e-002	4.7333e-002	2.4e-002	-4.1178e-005
3954	-1.6111e-002	4.7333e-002	2.7e-002	-4.1178e-005
3955	-1.5167e-002	4.7644e-002	2.7e-002	-4.1697e-005
3956	-1.4217e-002	4.7936e-002	2.7e-002	-4.2186e-005
3957	-1.3261e-002	4.8209e-002	2.7e-002	-4.2646e-005
3958	-1.23e-002	4.8464e-002	2.7e-002	-4.3076e-005
3959	-1.1334e-002	4.8699e-002	2.7e-002	-4.3476e-005
3960	-1.0363e-002	4.8914e-002	2.7e-002	-4.3845e-005
3961	-9.3888e-003	4.9111e-002	2.7e-002	-4.4182e-005
3962	-8.4106e-003	4.9288e-002	2.7e-002	-4.4486e-005
3963	-7.4289e-003	4.9445e-002	2.7e-002	-4.4758e-005
3964	-6.4443e-003	4.9583e-002	2.7e-002	-4.4996e-005
3965	-5.4572e-003	4.9701e-002	2.7e-002	-4.5201e-005
3966	-4.4681e-003	4.98e-002	2.7e-002	-4.5372e-005
3967	-3.477e-003	4.9879e-002	2.7e-002	-4.551e-005
3968	-2.4847e-003	4.9938e-002	2.7e-002	-4.5613e-005
3969	-1.4912e-003	4.9978e-002	2.7e-002	-4.5682e-005
3970	-4.9732e-004	4.9998e-002	2.7e-002	-4.5716e-005
3971	4.9689e-004	4.9998e-002	2.7e-002	-4.5716e-005
3972	1.4908e-003	4.9978e-002	2.7e-002	-4.5682e-005
3973	2.4842e-003	4.9938e-002	2.7e-002	-4.5613e-005
3974	3.4766e-003	4.9879e-002	2.7e-002	-4.551e-005
3975	4.4676e-003	4.98e-002	2.7e-002	-4.5372e-005
3976	5.4568e-003	4.9701e-002	2.7e-002	-4.5201e-005
3977	6.444e-003	4.9583e-002	2.7e-002	-4.4996e-005
3978	7.4285e-003	4.9445e-002	2.7e-002	-4.4758e-005
3979	8.4101e-003	4.9288e-002	2.7e-002	-4.4486e-005
3980	9.3884e-003	4.9111e-002	2.7e-002	-4.4182e-005
3981	1.0363e-002	4.8914e-002	2.7e-002	-4.3845e-005
3982	1.1333e-002	4.8699e-002	2.7e-002	-4.3477e-005
3983	1.2299e-002	4.8464e-002	2.7e-002	-4.3077e-005
3984	1.3261e-002	4.821e-002	2.7e-002	-4.2647e-005
3985	1.4216e-002	4.7936e-002	2.7e-002	-4.2187e-005
3986	1.5167e-002	4.7644e-002	2.7e-002	-4.1697e-005
3987	-1.6111e-002	4.7333e-002	2.6e-002	-4.1178e-005
3988	-1.6111e-002	4.7333e-002	2.5e-002	-4.1178e-005
3989	-1.6111e-002	4.7333e-002	2.4e-002	-4.1178e-005
3990	1.5167e-002	4.7644e-002	2.4e-002	-4.1697e-005
3991	1.4217e-002	4.7936e-002	2.4e-002	-4.2186e-005
3992	1.3261e-002	4.8209e-002	2.4e-002	-4.2647e-005
3993	1.23e-002	4.8464e-002	2.4e-002	-4.3077e-005
3994	1.1334e-002	4.8699e-002	2.4e-002	-4.3477e-005
3995	1.0363e-002	4.8914e-002	2.4e-002	-4.3845e-005
3996	9.3887e-003	4.9111e-002	2.4e-002	-4.4182e-005
3997	8.4104e-003	4.9288e-002	2.4e-002	-4.4486e-005
3998	7.4288e-003	4.9445e-002	2.4e-002	-4.4758e-005
3999	6.4443e-003	4.9583e-002	2.4e-002	-4.4996e-005
4000	5.4571e-003	4.9701e-002	2.4e-002	-4.5201e-005
4001	4.468e-003	4.98e-002	2.4e-002	-4.5372e-005
4002	3.4769e-003	4.9879e-002	2.4e-002	-4.551e-005
4003	2.4846e-003	4.9938e-002	2.4e-002	-4.5613e-005
4004	1.4911e-003	4.9978e-002	2.4e-002	-4.5682e-005
4005	4.9722e-004	4.9998e-002	2.4e-002	-4.5716e-005
4006	-4.9702e-004	4.9998e-002	2.4e-002	-4.5716e-005
4007	-1.4909e-003	4.9978e-002	2.4e-002	-4.5682e-005
4008	-2.4844e-003	4.9938e-002	2.4e-002	-4.5613e-005
4009	-3.4767e-003	4.9879e-002	2.4e-002	-4.551e-005
4010	-4.4678e-003	4.98e-002	2.4e-002	-4.5372e-005
4011	-5.457e-003	4.9701e-002	2.4e-002	-4.5201e-005
4012	-6.4441e-003	4.9583e-002	2.4e-002	-4.4996e-005
4013	-7.4286e-003	4.9445e-002	2.4e-002	-4.4758e-005
4014	-8.4103e-003	4.9288e-002	2.4e-002	-4.4485e-005
4015	-9.399e-003	4.9109e-002	2.4005e-002	-4.418e-005
4016	-1.0373e-002	4.8912e-002	2.4013e-002	-4.3842e-005
4017	-1.1345e-002	4.8696e-002	2.4013e-002	-4.3473e-005
4018	-1.2309e-002	4.8461e-002	2.4009e-002	-4.3075e-005
4019	-1.4217e-002	4.7936e-002	2.4e-002	-4.2186e-005
4020	-1.5167e-002	4.7644e-002	2.4e-002	-4.1697e-005
4021	1.5167e-002	4.7644e-002	2.6e-002	-4.1697e-005
4022	1.5167e-002	4.7644e-002	2.5e-002	-4.1697e-005
4023	-1.5167e-002	4.7644e-002	2.6e-002	-4.1696e-005
4024	-1.4217e-002	4.7936e-002	2.6e-002	-4.2186e-005
4025	-1.3269e-002	4.8207e-002	2.6003e-002	-4.2644e-005
4026	-1.2311e-002	4.8461e-002	2.6008e-002	-4.3074e-005
4027	-1.0371e-002	4.8913e-002	2.6008e-002	-4.3843e-005
4028	-9.3888e-003	4.9111e-002	2.6e-002	-4.4181e-005
4029	-8.4106e-003	4.9288e-002	2.6e-002	-4.4486e-005
4030	-7.429e-003	4.9445e-002	2.6e-002	-4.4758e-005
4031	-6.4442e-003	4.9583e-002	2.6e-002	-4.4996e-005
4032	-5.4572e-003	4.9701e-002	2.6e-002	-4.5201e-005
4033	-4.4681e-003	4.98e-002	2.6e-002	-4.5372e-005
4034	-3.477e-003	4.9879e-002	2.6e-002	-4.551e-005
4035	-2.4847e-003	4.9938e-002	2.6e-002	-4.5613e-005
4036	-1.4912e-003	4.9978e-002	2.6e-002	-4.5682e-005
4037	-4.9733e-004	4.9998e-002	2.6e-002	-4.5716e-005
4038	4.9691e-004	4.9998e-002	2.6e-002	-4.5716e-005
4039	1.4908e-003	4.9978e-002	2.6e-002	-4.5682e-005
4040	2.4842e-003	4.9938e-002	2.6e-002	-4.5613e-005
4041	3.4766e-003	4.9879e-002	2.6e-002	-4.551e-005
4042	4.4676e-003	4.98e-002	2.6e-002	-4.5372e-005
4043	5.4568e-003	4.9701e-002	2.6e-002	-4.5201e-005
4044	6.444e-003	4.9583e-002	2.6e-002	-4.4996e-005
4045	7.4285e-003	4.9445e-002	2.6e-002	-4.4758e-005
4046	8.4102e-003	4.9288e-002	2.6e-002	-4.4486e-005
4047	9.3884e-003	4.9111e-002	2.6e-002	-4.4182e-005
4048	1.0363e-002	4.8914e-002	2.6e-002	-4.3845e-005
4049	1.1333e-002	4.8699e-002	2.6e-002	-4.3477e-005
4050	1.2299e-002	4.8464e-002	2.6e-002	-4.3077e-005
4051	1.3261e-002	4.821e-002	2.6e-002	-4.2647e-005
4052	1.4216e-002	4.7936e-002	2.6e-002	-4.2187e-005
4053	-1.5167e-002	4.7644e-002	2.5e-002	-4.1696e-005
4054	1.4217e-002	4.7936e-002	2.5e-002	-4.2187e-005
4055	-1.4217e-002	4.7936e-002	2.5e-002	-4.2186e-005
4056	-1.3271e-002	4.8207e-002	2.5003e-002	-4.2644e-005
4057	1.3261e-002	4.8209e-002	2.5e-002	-4.2647e-005
4058	1.23e-002	4.8464e-002	2.5e-002	-4.3077e-005
4059	1.1334e-002	4.8699e-002	2.5e-002	-4.3477e-005
4060	1.0363e-002	4.8914e-002	2.5e-002	-4.3845e-005
4061	9.3887e-003	4.9111e-002	2.5e-002	-4.4182e-005
4062	8.4104e-003	4.9288e-002	2.5e-002	-4.4486e-005
4063	7.4288e-003	4.9445e-002	2.5e-002	-4.4758e-005
4064	5.457e-003	4.9701e-002	2.5e-002	-4.5201e-005
4065	4.468e-003	4.98e-002	2.5e-002	-4.5372e-005
4066	3.4769e-003	4.9879e-002	2.5e-002	-4.551e-005
4067	2.4845e-003	4.9938e-002	2.5e-002	-4.5613e-005
4068	1.4911e-003	4.9978e-002	2.5e-002	-4.5682e-005
4069	-4.9702e-004	4.9998e-002	2.5e-002	-4.5716e-005
4070	-1.4909e-003	4.9978e-002	2.5e-002	-4.5682e-005
4071	-2.4844e-003	4.9938e-002	2.5e-002	-4.5613e-005
4072	-3.4767e-003	4.9879e-002	2.5e-002	-4.551e-005
4073	-4.4677e-003	4.98e-002	2.5e-002	-4.5372e-005
4074	-5.457e-003	4.9701e-002	2.5e-002	-4.5201e-005
4075	-6.4441e-003	4.9583e-002	2.5e-002	-4.4996e-005
4076	-7.4285e-003	4.9445e-002	2.5e-002	-4.4758e-005
4077	-8.4103e-003	4.9288e-002	2.5e-002	-4.4485e-005
4078	-9.3984e-003	4.9109e-002	2.5004e-002	-4.4179e-005
4079	-1.0377e-002	4.8911e-002	2.501e-002	-4.3842e-005
4080	-1.1346e-002	4.8696e-002	2.5011e-002	-4.3472e-005"""
    writer = System.IO.StreamWriter(filePath, False)
    writer.WriteLine(fileContents)
    writer.Close()
    fileRef = task.RegisterFile(filePath)
    fileRefs.Add(fileRef)
    #region y strain
    filePath = System.IO.Path.Combine(workingDirectory, "StrainY.txt")
    fileContents = r"""Node Number	X Location (m)	Y Location (m)	Z Location (m)	Normal Elastic Strain (m/m)
1	-3.5355e-002	3.5355e-002	5.e-002	-2.3006e-005
2	3.5355e-002	3.5355e-002	5.e-002	-2.3006e-005
3	-3.4645e-002	3.6051e-002	5.e-002	-2.2526e-005
4	-3.3922e-002	3.6733e-002	5.e-002	-2.1569e-005
5	-3.3185e-002	3.74e-002	5.e-002	-2.0616e-005
6	-3.2435e-002	3.8053e-002	5.e-002	-1.9672e-005
7	-3.1672e-002	3.869e-002	5.e-002	-1.8735e-005
8	-3.0896e-002	3.9312e-002	5.e-002	-1.7809e-005
9	-3.0108e-002	3.9918e-002	5.e-002	-1.6894e-005
10	-2.9309e-002	4.0509e-002	5.e-002	-1.5991e-005
11	-2.8498e-002	4.1084e-002	5.e-002	-1.5103e-005
12	-2.7675e-002	4.1642e-002	5.e-002	-1.4229e-005
13	-2.6842e-002	4.2184e-002	5.e-002	-1.3372e-005
14	-2.5998e-002	4.271e-002	5.e-002	-1.2532e-005
15	-2.5143e-002	4.3218e-002	5.e-002	-1.1712e-005
16	-2.4279e-002	4.371e-002	5.e-002	-1.0911e-005
17	-2.3405e-002	4.4184e-002	5.e-002	-1.0131e-005
18	-2.2522e-002	4.464e-002	5.e-002	-9.3733e-006
19	-2.163e-002	4.5079e-002	5.e-002	-8.6389e-006
20	-2.073e-002	4.55e-002	5.e-002	-7.9287e-006
21	-1.9821e-002	4.5904e-002	5.e-002	-7.2438e-006
22	-1.8904e-002	4.6289e-002	5.e-002	-6.585e-006
23	-1.798e-002	4.6655e-002	5.e-002	-5.9534e-006
24	-1.7049e-002	4.7003e-002	5.e-002	-5.3497e-006
25	-1.6111e-002	4.7333e-002	5.e-002	-4.7749e-006
26	-1.5167e-002	4.7644e-002	5.e-002	-4.2296e-006
27	-1.4217e-002	4.7936e-002	5.e-002	-3.7148e-006
28	-1.3261e-002	4.8209e-002	5.e-002	-3.231e-006
29	-1.23e-002	4.8464e-002	5.e-002	-2.7789e-006
30	-1.1334e-002	4.8699e-002	5.e-002	-2.3592e-006
31	-1.0363e-002	4.8914e-002	5.e-002	-1.9724e-006
32	-9.3886e-003	4.9111e-002	5.e-002	-1.6191e-006
33	-8.4103e-003	4.9288e-002	5.e-002	-1.2997e-006
34	-7.4287e-003	4.9445e-002	5.e-002	-1.0147e-006
35	-6.4442e-003	4.9583e-002	5.e-002	-7.6451e-007
36	-5.4571e-003	4.9701e-002	5.e-002	-5.494e-007
37	-4.4678e-003	4.98e-002	5.e-002	-3.6968e-007
38	-3.4768e-003	4.9879e-002	5.e-002	-2.2562e-007
39	-2.4844e-003	4.9938e-002	5.e-002	-1.174e-007
40	-1.491e-003	4.9978e-002	5.e-002	-4.5176e-008
41	-4.9708e-004	4.9998e-002	5.e-002	-9.0376e-009
42	4.9708e-004	4.9998e-002	5.e-002	-9.0377e-009
43	1.491e-003	4.9978e-002	5.e-002	-4.5176e-008
44	2.4844e-003	4.9938e-002	5.e-002	-1.174e-007
45	3.4768e-003	4.9879e-002	5.e-002	-2.2562e-007
46	4.4678e-003	4.98e-002	5.e-002	-3.6969e-007
47	5.4571e-003	4.9701e-002	5.e-002	-5.494e-007
48	6.4442e-003	4.9583e-002	5.e-002	-7.6451e-007
49	7.4287e-003	4.9445e-002	5.e-002	-1.0147e-006
50	8.4103e-003	4.9288e-002	5.e-002	-1.2997e-006
51	9.3886e-003	4.9111e-002	5.e-002	-1.6191e-006
52	1.0363e-002	4.8914e-002	5.e-002	-1.9724e-006
53	1.1334e-002	4.8699e-002	5.e-002	-2.3592e-006
54	1.23e-002	4.8464e-002	5.e-002	-2.7789e-006
55	1.3261e-002	4.8209e-002	5.e-002	-3.231e-006
56	1.4217e-002	4.7936e-002	5.e-002	-3.7148e-006
57	1.5167e-002	4.7644e-002	5.e-002	-4.2296e-006
58	1.6111e-002	4.7333e-002	5.e-002	-4.7749e-006
59	1.7049e-002	4.7003e-002	5.e-002	-5.3497e-006
60	1.798e-002	4.6655e-002	5.e-002	-5.9534e-006
61	1.8904e-002	4.6289e-002	5.e-002	-6.585e-006
62	1.9821e-002	4.5904e-002	5.e-002	-7.2438e-006
63	2.073e-002	4.55e-002	5.e-002	-7.9287e-006
64	2.163e-002	4.5079e-002	5.e-002	-8.6389e-006
65	2.2522e-002	4.464e-002	5.e-002	-9.3734e-006
66	2.3405e-002	4.4184e-002	5.e-002	-1.0131e-005
67	2.4279e-002	4.371e-002	5.e-002	-1.0911e-005
68	2.5143e-002	4.3218e-002	5.e-002	-1.1712e-005
69	2.5998e-002	4.271e-002	5.e-002	-1.2533e-005
70	2.6842e-002	4.2184e-002	5.e-002	-1.3372e-005
71	2.7675e-002	4.1642e-002	5.e-002	-1.4229e-005
72	2.8498e-002	4.1084e-002	5.e-002	-1.5103e-005
73	2.9309e-002	4.0509e-002	5.e-002	-1.5991e-005
74	3.0108e-002	3.9918e-002	5.e-002	-1.6894e-005
75	3.0896e-002	3.9312e-002	5.e-002	-1.7809e-005
76	3.1672e-002	3.869e-002	5.e-002	-1.8735e-005
77	3.2435e-002	3.8053e-002	5.e-002	-1.9672e-005
78	3.3185e-002	3.74e-002	5.e-002	-2.0617e-005
79	3.3922e-002	3.6733e-002	5.e-002	-2.1569e-005
80	3.4645e-002	3.6051e-002	5.e-002	-2.2526e-005
81	3.5355e-002	3.5355e-002	0.	-2.3004e-005
82	3.5355e-002	3.5355e-002	4.9e-002	-2.3006e-005
83	3.5355e-002	3.5355e-002	4.8e-002	-2.3005e-005
84	3.5355e-002	3.5355e-002	4.7e-002	-2.3004e-005
85	3.5355e-002	3.5355e-002	4.6e-002	-2.3004e-005
86	3.5355e-002	3.5355e-002	4.5e-002	-2.3004e-005
87	3.5355e-002	3.5355e-002	4.4e-002	-2.3004e-005
88	3.5355e-002	3.5355e-002	4.3e-002	-2.3004e-005
89	3.5355e-002	3.5355e-002	4.2e-002	-2.3004e-005
90	3.5355e-002	3.5355e-002	4.1e-002	-2.3004e-005
91	3.5355e-002	3.5355e-002	4.e-002	-2.3004e-005
92	3.5355e-002	3.5355e-002	3.9e-002	-2.3004e-005
93	3.5355e-002	3.5355e-002	3.8e-002	-2.3004e-005
94	3.5355e-002	3.5355e-002	3.7e-002	-2.3004e-005
95	3.5355e-002	3.5355e-002	3.6e-002	-2.3004e-005
96	3.5355e-002	3.5355e-002	3.5e-002	-2.3004e-005
97	3.5355e-002	3.5355e-002	3.4e-002	-2.3004e-005
98	3.5355e-002	3.5355e-002	3.3e-002	-2.3004e-005
99	3.5355e-002	3.5355e-002	3.2e-002	-2.3004e-005
100	3.5355e-002	3.5355e-002	3.1e-002	-2.3004e-005
101	3.5355e-002	3.5355e-002	3.e-002	-2.3004e-005
102	3.5355e-002	3.5355e-002	2.9e-002	-2.3004e-005
103	3.5355e-002	3.5355e-002	2.8e-002	-2.3004e-005
104	3.5355e-002	3.5355e-002	2.7e-002	-2.3004e-005
105	3.5355e-002	3.5355e-002	2.6e-002	-2.3004e-005
106	3.5355e-002	3.5355e-002	2.5e-002	-2.3004e-005
107	3.5355e-002	3.5355e-002	2.4e-002	-2.3004e-005
108	3.5355e-002	3.5355e-002	2.3e-002	-2.3004e-005
109	3.5355e-002	3.5355e-002	2.2e-002	-2.3004e-005
110	3.5355e-002	3.5355e-002	2.1e-002	-2.3004e-005
111	3.5355e-002	3.5355e-002	2.e-002	-2.3004e-005
112	3.5355e-002	3.5355e-002	1.9e-002	-2.3004e-005
113	3.5355e-002	3.5355e-002	1.8e-002	-2.3004e-005
114	3.5355e-002	3.5355e-002	1.7e-002	-2.3004e-005
115	3.5355e-002	3.5355e-002	1.6e-002	-2.3004e-005
116	3.5355e-002	3.5355e-002	1.5e-002	-2.3004e-005
117	3.5355e-002	3.5355e-002	1.4e-002	-2.3004e-005
118	3.5355e-002	3.5355e-002	1.3e-002	-2.3004e-005
119	3.5355e-002	3.5355e-002	1.2e-002	-2.3004e-005
120	3.5355e-002	3.5355e-002	1.1e-002	-2.3004e-005
121	3.5355e-002	3.5355e-002	1.e-002	-2.3004e-005
122	3.5355e-002	3.5355e-002	9.e-003	-2.3004e-005
123	3.5355e-002	3.5355e-002	8.e-003	-2.3004e-005
124	3.5355e-002	3.5355e-002	7.e-003	-2.3004e-005
125	3.5355e-002	3.5355e-002	6.e-003	-2.3004e-005
126	3.5355e-002	3.5355e-002	5.e-003	-2.3004e-005
127	3.5355e-002	3.5355e-002	4.e-003	-2.3004e-005
128	3.5355e-002	3.5355e-002	3.e-003	-2.3004e-005
129	3.5355e-002	3.5355e-002	2.e-003	-2.3004e-005
130	3.5355e-002	3.5355e-002	1.e-003	-2.3005e-005
131	-3.5355e-002	3.5355e-002	0.	-2.3006e-005
132	3.4645e-002	3.6051e-002	0.	-2.2525e-005
133	3.3922e-002	3.6733e-002	0.	-2.1568e-005
134	3.3185e-002	3.74e-002	0.	-2.0616e-005
135	3.2435e-002	3.8053e-002	0.	-1.9672e-005
136	3.1672e-002	3.869e-002	0.	-1.8735e-005
137	3.0896e-002	3.9312e-002	0.	-1.7809e-005
138	3.0108e-002	3.9918e-002	0.	-1.6894e-005
139	2.9309e-002	4.0509e-002	0.	-1.5992e-005
140	2.8498e-002	4.1084e-002	0.	-1.5103e-005
141	2.7675e-002	4.1642e-002	0.	-1.4229e-005
142	2.6842e-002	4.2184e-002	0.	-1.3372e-005
143	2.5998e-002	4.271e-002	0.	-1.2533e-005
144	2.5143e-002	4.3218e-002	0.	-1.1712e-005
145	2.4279e-002	4.371e-002	0.	-1.0911e-005
146	2.3405e-002	4.4184e-002	0.	-1.0131e-005
147	2.2522e-002	4.464e-002	0.	-9.3734e-006
148	2.163e-002	4.5079e-002	0.	-8.6389e-006
149	2.073e-002	4.55e-002	0.	-7.9287e-006
150	1.9821e-002	4.5904e-002	0.	-7.2438e-006
151	1.8904e-002	4.6289e-002	0.	-6.585e-006
152	1.798e-002	4.6655e-002	0.	-5.9534e-006
153	1.7049e-002	4.7003e-002	0.	-5.3497e-006
154	1.6111e-002	4.7333e-002	0.	-4.7749e-006
155	1.5167e-002	4.7644e-002	0.	-4.2296e-006
156	1.4217e-002	4.7936e-002	0.	-3.7148e-006
157	1.3261e-002	4.8209e-002	0.	-3.231e-006
158	1.23e-002	4.8464e-002	0.	-2.7789e-006
159	1.1334e-002	4.8699e-002	0.	-2.3592e-006
160	1.0363e-002	4.8914e-002	0.	-1.9724e-006
161	9.3886e-003	4.9111e-002	0.	-1.6191e-006
162	8.4103e-003	4.9288e-002	0.	-1.2997e-006
163	7.4287e-003	4.9445e-002	0.	-1.0147e-006
164	6.4442e-003	4.9583e-002	0.	-7.6451e-007
165	5.4571e-003	4.9701e-002	0.	-5.494e-007
166	4.4678e-003	4.98e-002	0.	-3.6969e-007
167	3.4768e-003	4.9879e-002	0.	-2.2562e-007
168	2.4844e-003	4.9938e-002	0.	-1.174e-007
169	1.491e-003	4.9978e-002	0.	-4.5176e-008
170	4.9708e-004	4.9998e-002	0.	-9.0376e-009
171	-4.9708e-004	4.9998e-002	0.	-9.0378e-009
172	-1.491e-003	4.9978e-002	0.	-4.5176e-008
173	-2.4844e-003	4.9938e-002	0.	-1.174e-007
174	-3.4768e-003	4.9879e-002	0.	-2.2562e-007
175	-4.4678e-003	4.98e-002	0.	-3.6969e-007
176	-5.4571e-003	4.9701e-002	0.	-5.494e-007
177	-6.4442e-003	4.9583e-002	0.	-7.6451e-007
178	-7.4287e-003	4.9445e-002	0.	-1.0147e-006
179	-8.4103e-003	4.9288e-002	0.	-1.2997e-006
180	-9.3886e-003	4.9111e-002	0.	-1.6191e-006
181	-1.0363e-002	4.8914e-002	0.	-1.9724e-006
182	-1.1334e-002	4.8699e-002	0.	-2.3592e-006
183	-1.23e-002	4.8464e-002	0.	-2.7789e-006
184	-1.3261e-002	4.8209e-002	0.	-3.231e-006
185	-1.4217e-002	4.7936e-002	0.	-3.7148e-006
186	-1.5167e-002	4.7644e-002	0.	-4.2297e-006
187	-1.6111e-002	4.7333e-002	0.	-4.7749e-006
188	-1.7049e-002	4.7003e-002	0.	-5.3497e-006
189	-1.798e-002	4.6655e-002	0.	-5.9534e-006
190	-1.8904e-002	4.6289e-002	0.	-6.5851e-006
191	-1.9821e-002	4.5904e-002	0.	-7.2438e-006
192	-2.073e-002	4.55e-002	0.	-7.9288e-006
193	-2.163e-002	4.5079e-002	0.	-8.639e-006
194	-2.2522e-002	4.464e-002	0.	-9.3734e-006
195	-2.3405e-002	4.4184e-002	0.	-1.0131e-005
196	-2.4279e-002	4.371e-002	0.	-1.0911e-005
197	-2.5143e-002	4.3218e-002	0.	-1.1712e-005
198	-2.5998e-002	4.271e-002	0.	-1.2533e-005
199	-2.6842e-002	4.2184e-002	0.	-1.3372e-005
200	-2.7675e-002	4.1642e-002	0.	-1.4229e-005
201	-2.8498e-002	4.1084e-002	0.	-1.5103e-005
202	-2.9309e-002	4.0509e-002	0.	-1.5992e-005
203	-3.0108e-002	3.9918e-002	0.	-1.6894e-005
204	-3.0896e-002	3.9312e-002	0.	-1.7809e-005
205	-3.1672e-002	3.869e-002	0.	-1.8735e-005
206	-3.2435e-002	3.8053e-002	0.	-1.9672e-005
207	-3.3185e-002	3.74e-002	0.	-2.0617e-005
208	-3.3922e-002	3.6733e-002	0.	-2.1569e-005
209	-3.4645e-002	3.6051e-002	0.	-2.2526e-005
210	-3.5355e-002	3.5355e-002	1.e-003	-2.3006e-005
211	-3.5355e-002	3.5355e-002	2.e-003	-2.3005e-005
212	-3.5355e-002	3.5355e-002	3.e-003	-2.3004e-005
213	-3.5355e-002	3.5355e-002	4.e-003	-2.3004e-005
214	-3.5355e-002	3.5355e-002	5.e-003	-2.3004e-005
215	-3.5355e-002	3.5355e-002	6.e-003	-2.3004e-005
216	-3.5355e-002	3.5355e-002	7.e-003	-2.3004e-005
217	-3.5355e-002	3.5355e-002	8.e-003	-2.3004e-005
218	-3.5355e-002	3.5355e-002	9.e-003	-2.3004e-005
219	-3.5355e-002	3.5355e-002	1.e-002	-2.3004e-005
220	-3.5355e-002	3.5355e-002	1.1e-002	-2.3004e-005
221	-3.5355e-002	3.5355e-002	1.2e-002	-2.3004e-005
222	-3.5355e-002	3.5355e-002	1.3e-002	-2.3004e-005
223	-3.5355e-002	3.5355e-002	1.4e-002	-2.3004e-005
224	-3.5355e-002	3.5355e-002	1.5e-002	-2.3004e-005
225	-3.5355e-002	3.5355e-002	1.6e-002	-2.3004e-005
226	-3.5355e-002	3.5355e-002	1.7e-002	-2.3004e-005
227	-3.5355e-002	3.5355e-002	1.8e-002	-2.3004e-005
228	-3.5355e-002	3.5355e-002	1.9e-002	-2.3004e-005
229	-3.5355e-002	3.5355e-002	2.e-002	-2.3004e-005
230	-3.5355e-002	3.5355e-002	2.1e-002	-2.3004e-005
231	-3.5355e-002	3.5355e-002	2.2e-002	-2.3004e-005
232	-3.5355e-002	3.5355e-002	2.3e-002	-2.3004e-005
233	-3.5355e-002	3.5355e-002	2.4e-002	-2.3004e-005
234	-3.5355e-002	3.5355e-002	2.5e-002	-2.3004e-005
235	-3.5355e-002	3.5355e-002	2.6e-002	-2.3004e-005
236	-3.5355e-002	3.5355e-002	2.7e-002	-2.3004e-005
237	-3.5355e-002	3.5355e-002	2.8e-002	-2.3004e-005
238	-3.5355e-002	3.5355e-002	2.9e-002	-2.3004e-005
239	-3.5355e-002	3.5355e-002	3.e-002	-2.3004e-005
240	-3.5355e-002	3.5355e-002	3.1e-002	-2.3004e-005
241	-3.5355e-002	3.5355e-002	3.2e-002	-2.3004e-005
242	-3.5355e-002	3.5355e-002	3.3e-002	-2.3004e-005
243	-3.5355e-002	3.5355e-002	3.4e-002	-2.3004e-005
244	-3.5355e-002	3.5355e-002	3.5e-002	-2.3004e-005
245	-3.5355e-002	3.5355e-002	3.6e-002	-2.3004e-005
246	-3.5355e-002	3.5355e-002	3.7e-002	-2.3004e-005
247	-3.5355e-002	3.5355e-002	3.8e-002	-2.3004e-005
248	-3.5355e-002	3.5355e-002	3.9e-002	-2.3004e-005
249	-3.5355e-002	3.5355e-002	4.e-002	-2.3004e-005
250	-3.5355e-002	3.5355e-002	4.1e-002	-2.3004e-005
251	-3.5355e-002	3.5355e-002	4.2e-002	-2.3004e-005
252	-3.5355e-002	3.5355e-002	4.3e-002	-2.3004e-005
253	-3.5355e-002	3.5355e-002	4.4e-002	-2.3004e-005
254	-3.5355e-002	3.5355e-002	4.5e-002	-2.3004e-005
255	-3.5355e-002	3.5355e-002	4.6e-002	-2.3004e-005
256	-3.5355e-002	3.5355e-002	4.7e-002	-2.3004e-005
257	-3.5355e-002	3.5355e-002	4.8e-002	-2.3005e-005
258	-3.5355e-002	3.5355e-002	4.9e-002	-2.3005e-005
259	3.4641e-002	3.6055e-002	4.e-003	-2.2523e-005
260	-3.4641e-002	3.6055e-002	2.e-003	-2.2524e-005
261	3.4641e-002	3.6055e-002	4.8e-002	-2.2524e-005
262	-2.8498e-002	4.1084e-002	4.8e-002	-1.5103e-005
263	-2.6842e-002	4.2184e-002	4.8e-002	-1.3372e-005
264	-2.5143e-002	4.3218e-002	4.8e-002	-1.1712e-005
265	-2.3405e-002	4.4184e-002	4.8e-002	-1.0131e-005
266	-2.163e-002	4.5079e-002	4.8e-002	-8.6389e-006
267	-1.9821e-002	4.5904e-002	4.8e-002	-7.2438e-006
268	-1.798e-002	4.6655e-002	4.8e-002	-5.9534e-006
269	-1.6111e-002	4.7333e-002	4.8e-002	-4.7749e-006
270	-1.4217e-002	4.7936e-002	4.8e-002	-3.7148e-006
271	-1.23e-002	4.8464e-002	4.8e-002	-2.7789e-006
272	-1.0363e-002	4.8914e-002	4.8e-002	-1.9724e-006
273	-8.4103e-003	4.9288e-002	4.8e-002	-1.2997e-006
274	-6.4442e-003	4.9583e-002	4.8e-002	-7.6451e-007
275	-4.4678e-003	4.98e-002	4.8e-002	-3.6968e-007
276	-2.4844e-003	4.9938e-002	4.8e-002	-1.174e-007
277	-4.9707e-004	4.9998e-002	4.8e-002	-9.0376e-009
278	1.491e-003	4.9978e-002	4.8e-002	-4.5176e-008
279	3.4768e-003	4.9879e-002	4.8e-002	-2.2562e-007
280	5.4571e-003	4.9701e-002	4.8e-002	-5.494e-007
281	7.4287e-003	4.9445e-002	4.8e-002	-1.0147e-006
282	9.3886e-003	4.9111e-002	4.8e-002	-1.6191e-006
283	1.1334e-002	4.8699e-002	4.8e-002	-2.3592e-006
284	1.3261e-002	4.8209e-002	4.8e-002	-3.231e-006
285	1.5167e-002	4.7644e-002	4.8e-002	-4.2296e-006
286	1.7049e-002	4.7003e-002	4.8e-002	-5.3497e-006
287	1.8904e-002	4.6289e-002	4.8e-002	-6.585e-006
288	2.073e-002	4.55e-002	4.8e-002	-7.9287e-006
289	2.2522e-002	4.464e-002	4.8e-002	-9.3734e-006
290	2.4279e-002	4.371e-002	4.8e-002	-1.0911e-005
291	2.5998e-002	4.271e-002	4.8e-002	-1.2533e-005
292	2.7675e-002	4.1642e-002	4.8e-002	-1.4229e-005
293	2.9309e-002	4.0509e-002	4.8e-002	-1.5991e-005
294	3.0896e-002	3.9312e-002	4.8e-002	-1.7809e-005
295	-3.1672e-002	3.869e-002	2.e-003	-1.8735e-005
296	-3.3185e-002	3.74e-002	4.7e-002	-2.0616e-005
297	-3.0896e-002	3.9312e-002	4.e-003	-1.7809e-005
298	3.2433e-002	3.8054e-002	6.e-003	-1.9671e-005
299	-3.0108e-002	3.9919e-002	4.6e-002	-1.6894e-005
300	-2.6842e-002	4.2184e-002	4.6e-002	-1.3372e-005
301	2.9309e-002	4.0509e-002	4.6e-002	-1.5991e-005
302	2.4279e-002	4.371e-002	4.e-003	-1.0911e-005
303	2.2522e-002	4.464e-002	4.e-003	-9.3734e-006
304	2.073e-002	4.55e-002	4.e-003	-7.9288e-006
305	1.8904e-002	4.6289e-002	4.e-003	-6.5851e-006
306	1.7049e-002	4.7003e-002	4.e-003	-5.3497e-006
307	1.5167e-002	4.7644e-002	4.e-003	-4.2297e-006
308	1.3261e-002	4.8209e-002	4.e-003	-3.231e-006
309	1.1334e-002	4.8699e-002	4.e-003	-2.3592e-006
310	9.3886e-003	4.9111e-002	4.e-003	-1.6191e-006
311	7.4288e-003	4.9445e-002	4.e-003	-1.0147e-006
312	5.4571e-003	4.9701e-002	4.e-003	-5.494e-007
313	3.4768e-003	4.9879e-002	4.e-003	-2.2562e-007
314	1.4911e-003	4.9978e-002	4.e-003	-4.5177e-008
315	-4.9703e-004	4.9998e-002	4.e-003	-9.0374e-009
316	-2.4844e-003	4.9938e-002	4.e-003	-1.174e-007
317	-4.4678e-003	4.98e-002	4.e-003	-3.6968e-007
318	-6.4441e-003	4.9583e-002	4.e-003	-7.6451e-007
319	-8.4103e-003	4.9288e-002	4.e-003	-1.2997e-006
320	-1.0363e-002	4.8914e-002	4.e-003	-1.9724e-006
321	-1.23e-002	4.8464e-002	4.e-003	-2.7789e-006
322	-1.4217e-002	4.7936e-002	4.e-003	-3.7148e-006
323	-1.6111e-002	4.7333e-002	4.e-003	-4.7749e-006
324	-1.798e-002	4.6655e-002	4.e-003	-5.9534e-006
325	-1.9821e-002	4.5904e-002	4.e-003	-7.2438e-006
326	-2.163e-002	4.5079e-002	4.e-003	-8.6389e-006
327	-2.3405e-002	4.4184e-002	4.e-003	-1.0131e-005
328	-2.5143e-002	4.3218e-002	4.e-003	-1.1712e-005
329	-2.6842e-002	4.2184e-002	4.e-003	-1.3372e-005
330	-2.8498e-002	4.1084e-002	4.e-003	-1.5103e-005
331	-3.0108e-002	3.9919e-002	4.e-003	-1.6894e-005
332	3.2435e-002	3.8053e-002	4.2e-002	-1.9672e-005
333	-3.2435e-002	3.8053e-002	8.e-003	-1.9667e-005
334	-3.0896e-002	3.9312e-002	5.e-003	-1.7809e-005
335	3.1671e-002	3.869e-002	3.8e-002	-1.8735e-005
336	3.1671e-002	3.869e-002	3.6e-002	-1.8735e-005
337	3.1671e-002	3.869e-002	3.4e-002	-1.8735e-005
338	3.1671e-002	3.869e-002	3.2e-002	-1.8735e-005
339	3.1671e-002	3.869e-002	3.e-002	-1.8735e-005
340	3.1671e-002	3.869e-002	2.8e-002	-1.8735e-005
341	3.1671e-002	3.869e-002	2.6e-002	-1.8735e-005
342	3.1671e-002	3.869e-002	2.4e-002	-1.8735e-005
343	3.1671e-002	3.869e-002	2.2e-002	-1.8735e-005
344	3.1671e-002	3.869e-002	2.e-002	-1.8735e-005
345	3.1671e-002	3.869e-002	1.8e-002	-1.8735e-005
346	3.1671e-002	3.869e-002	1.6e-002	-1.8735e-005
347	3.1671e-002	3.8691e-002	1.4e-002	-1.8735e-005
348	-3.1648e-002	3.8709e-002	1.1989e-002	-1.8708e-005
349	-3.1662e-002	3.8698e-002	1.3993e-002	-1.872e-005
350	-3.1667e-002	3.8694e-002	1.5998e-002	-1.8728e-005
351	-3.1671e-002	3.869e-002	1.8e-002	-1.8734e-005
352	-3.1671e-002	3.869e-002	2.e-002	-1.8737e-005
353	-3.1671e-002	3.869e-002	2.2e-002	-1.8739e-005
354	-3.1671e-002	3.869e-002	2.4e-002	-1.8737e-005
355	-3.1671e-002	3.869e-002	2.6e-002	-1.8733e-005
356	-3.1671e-002	3.869e-002	2.8e-002	-1.8732e-005
357	-3.1671e-002	3.8691e-002	3.e-002	-1.8731e-005
358	-3.1671e-002	3.8691e-002	3.2e-002	-1.8731e-005
359	-3.1671e-002	3.8691e-002	3.4e-002	-1.8732e-005
360	-3.167e-002	3.8691e-002	3.6e-002	-1.8729e-005
361	-3.1662e-002	3.8698e-002	3.8e-002	-1.8724e-005
362	-3.1661e-002	3.8698e-002	3.9999e-002	-1.8725e-005
363	-3.167e-002	3.8691e-002	4.2e-002	-1.8732e-005
364	-3.0882e-002	3.9323e-002	3.9997e-002	-1.779e-005
365	-2.7675e-002	4.1642e-002	4.3e-002	-1.4229e-005
366	2.9309e-002	4.0509e-002	3.1e-002	-1.5992e-005
367	2.9309e-002	4.0509e-002	2.9e-002	-1.5992e-005
368	2.9309e-002	4.0509e-002	2.7e-002	-1.5992e-005
369	2.9309e-002	4.0509e-002	2.5e-002	-1.5992e-005
370	2.9309e-002	4.0509e-002	2.3e-002	-1.5992e-005
371	2.9309e-002	4.0509e-002	2.1e-002	-1.5992e-005
372	2.9309e-002	4.0509e-002	1.9e-002	-1.5993e-005
373	2.9309e-002	4.0509e-002	1.7e-002	-1.5993e-005
374	2.9309e-002	4.0509e-002	1.5e-002	-1.5993e-005
375	-2.9282e-002	4.0528e-002	1.6991e-002	-1.5967e-005
376	-2.933e-002	4.0494e-002	1.8993e-002	-1.6015e-005
377	-2.9371e-002	4.0464e-002	2.1007e-002	-1.6059e-005
378	-2.9362e-002	4.0471e-002	2.3027e-002	-1.605e-005
379	-2.9318e-002	4.0502e-002	2.5019e-002	-1.6002e-005
380	-2.9288e-002	4.0524e-002	2.6996e-002	-1.5971e-005
381	-2.9289e-002	4.0523e-002	2.8996e-002	-1.5968e-005
382	2.6842e-002	4.2184e-002	8.e-003	-1.3372e-005
383	2.5143e-002	4.3218e-002	8.e-003	-1.1712e-005
384	2.3405e-002	4.4184e-002	8.e-003	-1.0131e-005
385	2.163e-002	4.5079e-002	8.e-003	-8.6389e-006
386	1.9821e-002	4.5904e-002	8.e-003	-7.2438e-006
387	1.798e-002	4.6655e-002	8.e-003	-5.9534e-006
388	1.6111e-002	4.7333e-002	8.e-003	-4.7749e-006
389	1.4217e-002	4.7936e-002	8.e-003	-3.7148e-006
390	1.23e-002	4.8464e-002	8.e-003	-2.7789e-006
391	1.0363e-002	4.8914e-002	8.e-003	-1.9724e-006
392	8.4103e-003	4.9288e-002	8.e-003	-1.2997e-006
393	6.4442e-003	4.9583e-002	8.e-003	-7.6452e-007
394	4.4678e-003	4.98e-002	8.e-003	-3.6969e-007
395	2.4844e-003	4.9938e-002	8.e-003	-1.1741e-007
396	4.9708e-004	4.9998e-002	8.e-003	-9.0382e-009
397	-1.491e-003	4.9978e-002	8.e-003	-4.5175e-008
398	-3.4768e-003	4.9879e-002	8.e-003	-2.2562e-007
399	-5.4571e-003	4.9701e-002	8.e-003	-5.4939e-007
400	-7.4287e-003	4.9445e-002	8.e-003	-1.0147e-006
401	-9.3886e-003	4.9111e-002	8.e-003	-1.6191e-006
402	-1.1334e-002	4.8699e-002	8.e-003	-2.3592e-006
403	-1.3261e-002	4.8209e-002	8.e-003	-3.231e-006
404	-1.5167e-002	4.7644e-002	8.e-003	-4.2296e-006
405	-1.7049e-002	4.7003e-002	8.e-003	-5.3497e-006
406	-1.8904e-002	4.6289e-002	8.e-003	-6.585e-006
407	-2.073e-002	4.55e-002	8.e-003	-7.9287e-006
408	-2.2522e-002	4.464e-002	8.e-003	-9.3733e-006
409	-2.4279e-002	4.371e-002	8.e-003	-1.091e-005
410	-2.5987e-002	4.2716e-002	7.9923e-003	-1.2522e-005
411	-2.7627e-002	4.1674e-002	9.9688e-003	-1.418e-005
412	-2.7752e-002	4.1591e-002	2.0041e-002	-1.4307e-005
413	-2.6933e-002	4.2126e-002	2.3051e-002	-1.3457e-005
414	2.5143e-002	4.3218e-002	1.e-002	-1.1712e-005
415	2.5998e-002	4.271e-002	3.9e-002	-1.2532e-005
416	1.6111e-002	4.7333e-002	1.2e-002	-4.7749e-006
417	2.5997e-002	4.271e-002	3.5e-002	-1.2532e-005
418	2.4279e-002	4.371e-002	1.2e-002	-1.0911e-005
419	2.163e-002	4.5079e-002	3.7e-002	-8.6389e-006
420	-2.522e-002	4.3174e-002	2.0056e-002	-1.1777e-005
421	1.7049e-002	4.7003e-002	1.4e-002	-5.3497e-006
422	1.5167e-002	4.7644e-002	1.4e-002	-4.2297e-006
423	-2.4309e-002	4.3693e-002	2.4013e-002	-1.0936e-005
424	2.2522e-002	4.464e-002	1.7e-002	-9.3733e-006
425	-2.163e-002	4.5079e-002	1.5e-002	-8.6389e-006
426	-2.3405e-002	4.4184e-002	1.7e-002	-1.0134e-005
427	-2.2522e-002	4.464e-002	1.6e-002	-9.3733e-006
428	2.2522e-002	4.464e-002	2.5e-002	-9.3734e-006
429	2.163e-002	4.5079e-002	2.1e-002	-8.639e-006
430	-2.163e-002	4.5079e-002	2.9e-002	-8.639e-006
431	1.9821e-002	4.5903e-002	1.7e-002	-7.2439e-006
432	-1.9821e-002	4.5904e-002	1.7e-002	-7.2438e-006
433	-2.163e-002	4.5079e-002	2.5e-002	-8.639e-006
434	-2.073e-002	4.55e-002	3.2e-002	-7.9288e-006
435	-1.8904e-002	4.6289e-002	1.8e-002	-6.585e-006
436	1.6111e-002	4.7333e-002	1.8e-002	-4.7749e-006
437	2.073e-002	4.55e-002	2.9e-002	-7.9286e-006
438	2.073e-002	4.55e-002	2.7e-002	-7.9287e-006
439	1.798e-002	4.6655e-002	1.9e-002	-5.9534e-006
440	1.8904e-002	4.6289e-002	2.1e-002	-6.5849e-006
441	1.8904e-002	4.6289e-002	2.6e-002	-6.5849e-006
442	9.3887e-003	4.9111e-002	2.1e-002	-1.6191e-006
443	1.798e-002	4.6655e-002	2.3e-002	-5.9534e-006
444	1.7049e-002	4.7003e-002	2.1e-002	-5.3498e-006
445	-9.3888e-003	4.9111e-002	2.8e-002	-1.6192e-006
446	-7.4289e-003	4.9445e-002	2.8e-002	-1.0148e-006
447	3.4769e-003	4.9879e-002	2.2e-002	-2.2563e-007
448	1.4911e-003	4.9978e-002	2.2e-002	-4.518e-008
449	-4.9702e-004	4.9998e-002	2.2e-002	-9.0364e-009
450	-2.4844e-003	4.9938e-002	2.2e-002	-1.174e-007
451	-4.4678e-003	4.98e-002	2.2e-002	-3.6967e-007
452	-6.4441e-003	4.9583e-002	2.2e-002	-7.6449e-007
453	-8.4103e-003	4.9288e-002	2.2e-002	-1.2997e-006
454	-1.0363e-002	4.8914e-002	2.2e-002	-1.9727e-006
455	-1.23e-002	4.8464e-002	2.2e-002	-2.779e-006
456	-1.4217e-002	4.7936e-002	2.8e-002	-3.7148e-006
457	1.1334e-002	4.8699e-002	2.2e-002	-2.3592e-006
458	8.4104e-003	4.9288e-002	2.3e-002	-1.2998e-006
459	-1.1342e-002	4.8697e-002	2.6005e-002	-2.3624e-006
460	-1.3261e-002	4.8209e-002	2.4e-002	-3.2325e-006
461	-1.2313e-002	4.846e-002	2.5013e-002	-2.7836e-006
462	4.972e-004	4.9998e-002	2.5e-002	-9.038e-009
463	6.4443e-003	4.9583e-002	2.5e-002	-7.6451e-007
464	-3.4645e-002	3.6051e-002	4.9e-002	-2.2525e-005
465	-3.3922e-002	3.6733e-002	4.9e-002	-2.1568e-005
466	-3.3185e-002	3.74e-002	4.9e-002	-2.0616e-005
467	-3.2435e-002	3.8053e-002	4.9e-002	-1.9672e-005
468	-3.1672e-002	3.869e-002	4.9e-002	-1.8735e-005
469	-3.0896e-002	3.9312e-002	4.9e-002	-1.7809e-005
470	-3.0108e-002	3.9918e-002	4.9e-002	-1.6894e-005
471	-2.9309e-002	4.0509e-002	4.9e-002	-1.5991e-005
472	-2.8498e-002	4.1084e-002	4.9e-002	-1.5103e-005
473	-2.7675e-002	4.1642e-002	4.9e-002	-1.4229e-005
474	-2.6842e-002	4.2184e-002	4.9e-002	-1.3372e-005
475	-2.5998e-002	4.271e-002	4.9e-002	-1.2532e-005
476	-2.5143e-002	4.3218e-002	4.9e-002	-1.1712e-005
477	-2.4279e-002	4.371e-002	4.9e-002	-1.0911e-005
478	-2.3405e-002	4.4184e-002	4.9e-002	-1.0131e-005
479	-2.2522e-002	4.464e-002	4.9e-002	-9.3733e-006
480	-2.163e-002	4.5079e-002	4.9e-002	-8.6389e-006
481	-2.073e-002	4.55e-002	4.9e-002	-7.9287e-006
482	-1.9821e-002	4.5904e-002	4.9e-002	-7.2438e-006
483	-1.8904e-002	4.6289e-002	4.9e-002	-6.585e-006
484	-1.798e-002	4.6655e-002	4.9e-002	-5.9534e-006
485	-1.7049e-002	4.7003e-002	4.9e-002	-5.3497e-006
486	-1.6111e-002	4.7333e-002	4.9e-002	-4.7749e-006
487	-1.5167e-002	4.7644e-002	4.9e-002	-4.2296e-006
488	-1.4217e-002	4.7936e-002	4.9e-002	-3.7148e-006
489	-1.3261e-002	4.8209e-002	4.9e-002	-3.231e-006
490	-1.23e-002	4.8464e-002	4.9e-002	-2.7789e-006
491	-1.1334e-002	4.8699e-002	4.9e-002	-2.3592e-006
492	-1.0363e-002	4.8914e-002	4.9e-002	-1.9724e-006
493	-9.3886e-003	4.9111e-002	4.9e-002	-1.6191e-006
494	-8.4103e-003	4.9288e-002	4.9e-002	-1.2997e-006
495	-7.4287e-003	4.9445e-002	4.9e-002	-1.0147e-006
496	-6.4442e-003	4.9583e-002	4.9e-002	-7.6451e-007
497	-5.4571e-003	4.9701e-002	4.9e-002	-5.4939e-007
498	-4.4678e-003	4.98e-002	4.9e-002	-3.6968e-007
499	-3.4768e-003	4.9879e-002	4.9e-002	-2.2562e-007
500	-2.4844e-003	4.9938e-002	4.9e-002	-1.174e-007
501	-1.491e-003	4.9978e-002	4.9e-002	-4.5176e-008
502	-4.9708e-004	4.9998e-002	4.9e-002	-9.0376e-009
503	4.9709e-004	4.9998e-002	4.9e-002	-9.0378e-009
504	1.491e-003	4.9978e-002	4.9e-002	-4.5176e-008
505	2.4844e-003	4.9938e-002	4.9e-002	-1.174e-007
506	3.4768e-003	4.9879e-002	4.9e-002	-2.2562e-007
507	4.4678e-003	4.98e-002	4.9e-002	-3.6969e-007
508	5.4571e-003	4.9701e-002	4.9e-002	-5.494e-007
509	6.4442e-003	4.9583e-002	4.9e-002	-7.6451e-007
510	7.4287e-003	4.9445e-002	4.9e-002	-1.0147e-006
511	8.4103e-003	4.9288e-002	4.9e-002	-1.2997e-006
512	9.3886e-003	4.9111e-002	4.9e-002	-1.6191e-006
513	1.0363e-002	4.8914e-002	4.9e-002	-1.9724e-006
514	1.1334e-002	4.8699e-002	4.9e-002	-2.3592e-006
515	1.23e-002	4.8464e-002	4.9e-002	-2.7789e-006
516	1.3261e-002	4.8209e-002	4.9e-002	-3.231e-006
517	1.4217e-002	4.7936e-002	4.9e-002	-3.7148e-006
518	1.5167e-002	4.7644e-002	4.9e-002	-4.2296e-006
519	1.6111e-002	4.7333e-002	4.9e-002	-4.7749e-006
520	1.7049e-002	4.7003e-002	4.9e-002	-5.3497e-006
521	1.798e-002	4.6655e-002	4.9e-002	-5.9534e-006
522	1.8904e-002	4.6289e-002	4.9e-002	-6.585e-006
523	1.9821e-002	4.5904e-002	4.9e-002	-7.2438e-006
524	2.073e-002	4.55e-002	4.9e-002	-7.9287e-006
525	2.163e-002	4.5079e-002	4.9e-002	-8.6389e-006
526	2.2522e-002	4.464e-002	4.9e-002	-9.3734e-006
527	2.3405e-002	4.4184e-002	4.9e-002	-1.0131e-005
528	2.4279e-002	4.371e-002	4.9e-002	-1.0911e-005
529	2.5143e-002	4.3218e-002	4.9e-002	-1.1712e-005
530	2.5998e-002	4.271e-002	4.9e-002	-1.2533e-005
531	2.6842e-002	4.2184e-002	4.9e-002	-1.3372e-005
532	2.7675e-002	4.1642e-002	4.9e-002	-1.4229e-005
533	2.8498e-002	4.1084e-002	4.9e-002	-1.5103e-005
534	2.9309e-002	4.0509e-002	4.9e-002	-1.5991e-005
535	3.0108e-002	3.9918e-002	4.9e-002	-1.6894e-005
536	3.0896e-002	3.9312e-002	4.9e-002	-1.7809e-005
537	3.1672e-002	3.869e-002	4.9e-002	-1.8735e-005
538	3.2435e-002	3.8053e-002	4.9e-002	-1.9672e-005
539	3.3185e-002	3.74e-002	4.9e-002	-2.0616e-005
540	3.3922e-002	3.6733e-002	4.9e-002	-2.1568e-005
541	3.4645e-002	3.6051e-002	4.9e-002	-2.2526e-005
542	3.4641e-002	3.6055e-002	4.7e-002	-2.2524e-005
543	3.4641e-002	3.6055e-002	4.6e-002	-2.2524e-005
544	3.4641e-002	3.6055e-002	4.5e-002	-2.2524e-005
545	3.4641e-002	3.6055e-002	4.4e-002	-2.2524e-005
546	3.4641e-002	3.6055e-002	4.3e-002	-2.2524e-005
547	3.4641e-002	3.6055e-002	4.2e-002	-2.2524e-005
548	3.4641e-002	3.6055e-002	4.1e-002	-2.2524e-005
549	3.4641e-002	3.6055e-002	4.e-002	-2.2524e-005
550	3.4641e-002	3.6055e-002	3.9e-002	-2.2524e-005
551	3.4641e-002	3.6055e-002	3.8e-002	-2.2524e-005
552	3.4641e-002	3.6055e-002	3.7e-002	-2.2524e-005
553	3.4641e-002	3.6055e-002	3.6e-002	-2.2524e-005
554	3.4641e-002	3.6055e-002	3.5e-002	-2.2524e-005
555	3.4641e-002	3.6055e-002	3.4e-002	-2.2524e-005
556	3.4641e-002	3.6055e-002	3.3e-002	-2.2524e-005
557	3.4641e-002	3.6055e-002	3.2e-002	-2.2524e-005
558	3.4641e-002	3.6055e-002	3.1e-002	-2.2524e-005
559	3.4641e-002	3.6055e-002	3.e-002	-2.2524e-005
560	3.4641e-002	3.6055e-002	2.9e-002	-2.2524e-005
561	3.4641e-002	3.6055e-002	2.8e-002	-2.2524e-005
562	3.4641e-002	3.6055e-002	2.7e-002	-2.2524e-005
563	3.4641e-002	3.6055e-002	2.6e-002	-2.2524e-005
564	3.4641e-002	3.6055e-002	2.5e-002	-2.2524e-005
565	3.4641e-002	3.6055e-002	2.4e-002	-2.2524e-005
566	3.4641e-002	3.6055e-002	2.3e-002	-2.2524e-005
567	3.4641e-002	3.6055e-002	2.2e-002	-2.2523e-005
568	3.4641e-002	3.6055e-002	2.1e-002	-2.2523e-005
569	3.4641e-002	3.6055e-002	2.e-002	-2.2523e-005
570	3.4641e-002	3.6055e-002	1.9e-002	-2.2523e-005
571	3.4641e-002	3.6055e-002	1.8e-002	-2.2523e-005
572	3.4641e-002	3.6055e-002	1.7e-002	-2.2523e-005
573	3.4641e-002	3.6055e-002	1.6e-002	-2.2523e-005
574	3.4641e-002	3.6055e-002	1.5e-002	-2.2523e-005
575	3.4641e-002	3.6055e-002	1.4e-002	-2.2523e-005
576	3.4641e-002	3.6055e-002	1.3e-002	-2.2523e-005
577	3.4641e-002	3.6055e-002	1.2e-002	-2.2523e-005
578	3.4641e-002	3.6055e-002	1.1e-002	-2.2523e-005
579	3.4641e-002	3.6055e-002	1.e-002	-2.2523e-005
580	3.4641e-002	3.6055e-002	9.e-003	-2.2523e-005
581	3.4641e-002	3.6055e-002	8.e-003	-2.2523e-005
582	3.4641e-002	3.6055e-002	7.e-003	-2.2523e-005
583	3.4641e-002	3.6055e-002	6.e-003	-2.2523e-005
584	3.4641e-002	3.6055e-002	5.e-003	-2.2523e-005
585	3.4641e-002	3.6055e-002	3.e-003	-2.2523e-005
586	3.4641e-002	3.6055e-002	2.e-003	-2.2523e-005
587	3.4641e-002	3.6055e-002	9.9999e-004	-2.2524e-005
588	3.3922e-002	3.6733e-002	9.9999e-004	-2.1567e-005
589	3.3185e-002	3.74e-002	1.e-003	-2.0617e-005
590	3.2435e-002	3.8053e-002	1.e-003	-1.9672e-005
591	3.1672e-002	3.869e-002	1.e-003	-1.8735e-005
592	3.0896e-002	3.9312e-002	9.9999e-004	-1.7809e-005
593	3.0108e-002	3.9918e-002	1.e-003	-1.6894e-005
594	2.9309e-002	4.0509e-002	9.9999e-004	-1.5992e-005
595	2.8498e-002	4.1084e-002	1.e-003	-1.5103e-005
596	2.7675e-002	4.1642e-002	9.9999e-004	-1.4229e-005
597	2.6842e-002	4.2184e-002	1.e-003	-1.3372e-005
598	2.5998e-002	4.271e-002	9.9999e-004	-1.2533e-005
599	2.5143e-002	4.3218e-002	1.e-003	-1.1712e-005
600	2.4279e-002	4.371e-002	9.9999e-004	-1.0911e-005
601	2.3405e-002	4.4184e-002	1.e-003	-1.0131e-005
602	2.2522e-002	4.464e-002	9.9999e-004	-9.3734e-006
603	2.163e-002	4.5079e-002	1.e-003	-8.6389e-006
604	2.073e-002	4.55e-002	9.9999e-004	-7.9287e-006
605	1.9821e-002	4.5904e-002	1.e-003	-7.2438e-006
606	1.8904e-002	4.6289e-002	9.9999e-004	-6.585e-006
607	1.798e-002	4.6655e-002	1.e-003	-5.9534e-006
608	1.7049e-002	4.7003e-002	9.9999e-004	-5.3497e-006
609	1.6111e-002	4.7333e-002	1.e-003	-4.7749e-006
610	1.5167e-002	4.7644e-002	9.9999e-004	-4.2296e-006
611	1.4217e-002	4.7936e-002	1.e-003	-3.7148e-006
612	1.3261e-002	4.8209e-002	9.9999e-004	-3.231e-006
613	1.23e-002	4.8464e-002	1.e-003	-2.7789e-006
614	1.1334e-002	4.8699e-002	9.9999e-004	-2.3592e-006
615	1.0363e-002	4.8914e-002	1.e-003	-1.9724e-006
616	9.3886e-003	4.9111e-002	9.9999e-004	-1.6191e-006
617	8.4103e-003	4.9288e-002	1.e-003	-1.2997e-006
618	7.4287e-003	4.9445e-002	9.9999e-004	-1.0147e-006
619	6.4442e-003	4.9583e-002	1.e-003	-7.6451e-007
620	5.4571e-003	4.9701e-002	9.9999e-004	-5.494e-007
621	4.4678e-003	4.98e-002	1.e-003	-3.6968e-007
622	3.4768e-003	4.9879e-002	9.9999e-004	-2.2562e-007
623	2.4844e-003	4.9938e-002	1.e-003	-1.174e-007
624	1.491e-003	4.9978e-002	9.9999e-004	-4.5176e-008
625	4.9708e-004	4.9998e-002	1.e-003	-9.0376e-009
626	-4.9708e-004	4.9998e-002	9.9999e-004	-9.0378e-009
627	-1.491e-003	4.9978e-002	1.e-003	-4.5177e-008
628	-2.4844e-003	4.9938e-002	9.9999e-004	-1.174e-007
629	-3.4768e-003	4.9879e-002	1.e-003	-2.2562e-007
630	-4.4678e-003	4.98e-002	9.9999e-004	-3.6969e-007
631	-5.4571e-003	4.9701e-002	1.e-003	-5.494e-007
632	-6.4442e-003	4.9583e-002	9.9999e-004	-7.6451e-007
633	-7.4287e-003	4.9445e-002	1.e-003	-1.0147e-006
634	-8.4103e-003	4.9288e-002	9.9999e-004	-1.2997e-006
635	-9.3886e-003	4.9111e-002	1.e-003	-1.6191e-006
636	-1.0363e-002	4.8914e-002	9.9999e-004	-1.9724e-006
637	-1.1334e-002	4.8699e-002	1.e-003	-2.3592e-006
638	-1.23e-002	4.8464e-002	9.9999e-004	-2.7789e-006
639	-1.3261e-002	4.8209e-002	1.e-003	-3.231e-006
640	-1.4217e-002	4.7936e-002	9.9999e-004	-3.7148e-006
641	-1.5167e-002	4.7644e-002	1.e-003	-4.2297e-006
642	-1.6111e-002	4.7333e-002	9.9999e-004	-4.7749e-006
643	-1.7049e-002	4.7003e-002	1.e-003	-5.3497e-006
644	-1.798e-002	4.6655e-002	9.9999e-004	-5.9534e-006
645	-1.8904e-002	4.6289e-002	1.e-003	-6.5851e-006
646	-1.9821e-002	4.5904e-002	9.9999e-004	-7.2438e-006
647	-2.073e-002	4.55e-002	1.e-003	-7.9288e-006
648	-2.163e-002	4.5079e-002	9.9999e-004	-8.6389e-006
649	-2.2522e-002	4.464e-002	1.e-003	-9.3734e-006
650	-2.3405e-002	4.4184e-002	9.9999e-004	-1.0131e-005
651	-2.4279e-002	4.371e-002	1.e-003	-1.0911e-005
652	-2.5143e-002	4.3218e-002	9.9999e-004	-1.1712e-005
653	-2.5998e-002	4.271e-002	1.e-003	-1.2533e-005
654	-2.6842e-002	4.2184e-002	9.9999e-004	-1.3372e-005
655	-2.7675e-002	4.1642e-002	1.e-003	-1.4229e-005
656	-2.8498e-002	4.1084e-002	9.9999e-004	-1.5103e-005
657	-2.9309e-002	4.0509e-002	1.e-003	-1.5992e-005
658	-3.0108e-002	3.9918e-002	9.9999e-004	-1.6894e-005
659	-3.0896e-002	3.9312e-002	1.e-003	-1.7809e-005
660	-3.1672e-002	3.869e-002	9.9999e-004	-1.8735e-005
661	-3.2435e-002	3.8053e-002	1.e-003	-1.9672e-005
662	-3.3185e-002	3.74e-002	1.e-003	-2.0617e-005
663	-3.3922e-002	3.6733e-002	1.e-003	-2.1568e-005
664	-3.4645e-002	3.6051e-002	1.e-003	-2.2526e-005
665	-3.4641e-002	3.6055e-002	3.e-003	-2.2523e-005
666	-3.4641e-002	3.6055e-002	4.e-003	-2.2523e-005
667	-3.4641e-002	3.6055e-002	5.e-003	-2.2523e-005
668	-3.4641e-002	3.6055e-002	6.e-003	-2.2523e-005
669	-3.4641e-002	3.6055e-002	7.e-003	-2.2523e-005
670	-3.4641e-002	3.6055e-002	8.e-003	-2.2524e-005
671	-3.4641e-002	3.6055e-002	9.e-003	-2.2524e-005
672	-3.4641e-002	3.6055e-002	1.e-002	-2.2524e-005
673	-3.4641e-002	3.6055e-002	1.1e-002	-2.2524e-005
674	-3.4641e-002	3.6055e-002	1.2e-002	-2.2524e-005
675	-3.4641e-002	3.6055e-002	1.3e-002	-2.2524e-005
676	-3.4641e-002	3.6055e-002	1.4e-002	-2.2524e-005
677	-3.4641e-002	3.6055e-002	1.5e-002	-2.2524e-005
678	-3.4641e-002	3.6055e-002	1.6e-002	-2.2524e-005
679	-3.4641e-002	3.6055e-002	1.7e-002	-2.2523e-005
680	-3.4641e-002	3.6055e-002	1.8e-002	-2.2523e-005
681	-3.4641e-002	3.6055e-002	1.9e-002	-2.2523e-005
682	-3.4641e-002	3.6055e-002	2.e-002	-2.2523e-005
683	-3.4641e-002	3.6055e-002	2.1e-002	-2.2523e-005
684	-3.4641e-002	3.6055e-002	2.2e-002	-2.2523e-005
685	-3.4641e-002	3.6055e-002	2.3e-002	-2.2523e-005
686	-3.4641e-002	3.6055e-002	2.4e-002	-2.2523e-005
687	-3.4641e-002	3.6055e-002	2.5e-002	-2.2523e-005
688	-3.4641e-002	3.6055e-002	2.6e-002	-2.2523e-005
689	-3.4641e-002	3.6055e-002	2.7e-002	-2.2523e-005
690	-3.4641e-002	3.6055e-002	2.8e-002	-2.2523e-005
691	-3.4641e-002	3.6055e-002	2.9e-002	-2.2523e-005
692	-3.4641e-002	3.6055e-002	3.e-002	-2.2523e-005
693	-3.4641e-002	3.6055e-002	3.1e-002	-2.2523e-005
694	-3.4641e-002	3.6055e-002	3.2e-002	-2.2523e-005
695	-3.4641e-002	3.6055e-002	3.3e-002	-2.2523e-005
696	-3.4641e-002	3.6055e-002	3.4e-002	-2.2523e-005
697	-3.4641e-002	3.6055e-002	3.5e-002	-2.2523e-005
698	-3.4641e-002	3.6055e-002	3.6e-002	-2.2523e-005
699	-3.4641e-002	3.6055e-002	3.7e-002	-2.2523e-005
700	-3.4641e-002	3.6055e-002	3.8e-002	-2.2523e-005
701	-3.4641e-002	3.6055e-002	3.9e-002	-2.2523e-005
702	-3.4641e-002	3.6055e-002	4.e-002	-2.2523e-005
703	-3.4641e-002	3.6055e-002	4.1e-002	-2.2523e-005
704	-3.4641e-002	3.6055e-002	4.2e-002	-2.2523e-005
705	-3.4641e-002	3.6055e-002	4.3e-002	-2.2523e-005
706	-3.4641e-002	3.6055e-002	4.4e-002	-2.2523e-005
707	-3.4641e-002	3.6055e-002	4.5e-002	-2.2523e-005
708	-3.4641e-002	3.6055e-002	4.6e-002	-2.2523e-005
709	-3.4641e-002	3.6055e-002	4.7e-002	-2.2523e-005
710	-3.4641e-002	3.6055e-002	4.8e-002	-2.2524e-005
711	3.3922e-002	3.6733e-002	2.e-003	-2.1567e-005
712	3.3185e-002	3.74e-002	2.e-003	-2.0617e-005
713	3.2435e-002	3.8053e-002	2.e-003	-1.9672e-005
714	3.1672e-002	3.869e-002	2.e-003	-1.8735e-005
715	3.0896e-002	3.9312e-002	2.e-003	-1.7809e-005
716	3.0108e-002	3.9918e-002	2.e-003	-1.6894e-005
717	2.9309e-002	4.0509e-002	2.e-003	-1.5992e-005
718	2.8498e-002	4.1084e-002	2.e-003	-1.5103e-005
719	2.7675e-002	4.1642e-002	2.e-003	-1.4229e-005
720	2.6842e-002	4.2184e-002	2.e-003	-1.3372e-005
721	2.5998e-002	4.271e-002	2.e-003	-1.2533e-005
722	2.5143e-002	4.3218e-002	2.e-003	-1.1712e-005
723	2.4279e-002	4.371e-002	2.e-003	-1.0911e-005
724	2.3405e-002	4.4184e-002	2.e-003	-1.0131e-005
725	2.2522e-002	4.464e-002	2.e-003	-9.3734e-006
726	2.163e-002	4.5079e-002	2.e-003	-8.6389e-006
727	2.073e-002	4.55e-002	2.e-003	-7.9287e-006
728	1.9821e-002	4.5904e-002	2.e-003	-7.2438e-006
729	1.8904e-002	4.6289e-002	2.e-003	-6.585e-006
730	1.798e-002	4.6655e-002	2.e-003	-5.9534e-006
731	1.7049e-002	4.7003e-002	2.e-003	-5.3497e-006
732	1.6111e-002	4.7333e-002	2.e-003	-4.7749e-006
733	1.5167e-002	4.7644e-002	2.e-003	-4.2296e-006
734	1.4217e-002	4.7936e-002	2.e-003	-3.7148e-006
735	1.3261e-002	4.8209e-002	2.e-003	-3.231e-006
736	1.23e-002	4.8464e-002	2.e-003	-2.7789e-006
737	1.1334e-002	4.8699e-002	2.e-003	-2.3592e-006
738	1.0363e-002	4.8914e-002	2.e-003	-1.9724e-006
739	9.3886e-003	4.9111e-002	2.e-003	-1.6191e-006
740	8.4103e-003	4.9288e-002	2.e-003	-1.2997e-006
741	7.4287e-003	4.9445e-002	2.e-003	-1.0147e-006
742	6.4441e-003	4.9583e-002	2.e-003	-7.6451e-007
743	5.4571e-003	4.9701e-002	2.e-003	-5.4939e-007
744	4.4678e-003	4.98e-002	2.e-003	-3.6968e-007
745	3.4768e-003	4.9879e-002	2.e-003	-2.2562e-007
746	2.4844e-003	4.9938e-002	2.e-003	-1.174e-007
747	1.491e-003	4.9978e-002	2.e-003	-4.5176e-008
748	4.9706e-004	4.9998e-002	2.e-003	-9.0375e-009
749	-4.9709e-004	4.9998e-002	2.e-003	-9.0379e-009
750	-1.4911e-003	4.9978e-002	2.e-003	-4.5177e-008
751	-2.4844e-003	4.9938e-002	2.e-003	-1.174e-007
752	-3.4768e-003	4.9879e-002	2.e-003	-2.2562e-007
753	-4.4678e-003	4.98e-002	2.e-003	-3.6969e-007
754	-5.4571e-003	4.9701e-002	2.e-003	-5.494e-007
755	-6.4442e-003	4.9583e-002	2.e-003	-7.6451e-007
756	-7.4287e-003	4.9445e-002	2.e-003	-1.0147e-006
757	-8.4103e-003	4.9288e-002	2.e-003	-1.2997e-006
758	-9.3886e-003	4.9111e-002	2.e-003	-1.6191e-006
759	-1.0363e-002	4.8914e-002	2.e-003	-1.9724e-006
760	-1.1334e-002	4.8699e-002	2.e-003	-2.3592e-006
761	-1.23e-002	4.8464e-002	2.e-003	-2.7789e-006
762	-1.3261e-002	4.8209e-002	2.e-003	-3.231e-006
763	-1.4217e-002	4.7936e-002	2.e-003	-3.7148e-006
764	-1.5167e-002	4.7644e-002	2.e-003	-4.2297e-006
765	-1.6111e-002	4.7333e-002	2.e-003	-4.7749e-006
766	-1.7049e-002	4.7003e-002	2.e-003	-5.3497e-006
767	-1.798e-002	4.6655e-002	2.e-003	-5.9534e-006
768	-1.8904e-002	4.6289e-002	2.e-003	-6.5851e-006
769	-1.9821e-002	4.5904e-002	2.e-003	-7.2438e-006
770	-2.073e-002	4.55e-002	2.e-003	-7.9288e-006
771	-2.163e-002	4.5079e-002	2.e-003	-8.6389e-006
772	-2.2522e-002	4.464e-002	2.e-003	-9.3734e-006
773	-2.3405e-002	4.4184e-002	2.e-003	-1.0131e-005
774	-2.4279e-002	4.371e-002	2.e-003	-1.0911e-005
775	-2.5143e-002	4.3218e-002	2.e-003	-1.1712e-005
776	-2.5998e-002	4.271e-002	2.e-003	-1.2533e-005
777	-2.6842e-002	4.2184e-002	2.e-003	-1.3372e-005
778	-2.7675e-002	4.1642e-002	2.e-003	-1.4229e-005
779	-2.8498e-002	4.1084e-002	2.e-003	-1.5103e-005
780	-2.9309e-002	4.0509e-002	2.e-003	-1.5992e-005
781	-3.0108e-002	3.9918e-002	2.e-003	-1.6894e-005
782	-3.0896e-002	3.9312e-002	2.e-003	-1.7809e-005
783	-3.2435e-002	3.8053e-002	2.e-003	-1.9672e-005
784	-3.3185e-002	3.74e-002	2.e-003	-2.0617e-005
785	-3.3922e-002	3.6733e-002	2.e-003	-2.1567e-005
786	-3.3922e-002	3.6733e-002	3.e-003	-2.1567e-005
787	-3.3922e-002	3.6733e-002	4.e-003	-2.1567e-005
788	-3.3922e-002	3.6733e-002	5.e-003	-2.1567e-005
789	-3.3922e-002	3.6733e-002	6.e-003	-2.1567e-005
790	-3.3922e-002	3.6733e-002	7.e-003	-2.1567e-005
791	-3.3922e-002	3.6733e-002	8.e-003	-2.1567e-005
792	-3.3922e-002	3.6733e-002	9.e-003	-2.1567e-005
793	-3.3922e-002	3.6733e-002	1.e-002	-2.1567e-005
794	-3.3922e-002	3.6733e-002	1.1e-002	-2.1567e-005
795	-3.3922e-002	3.6733e-002	1.2e-002	-2.1567e-005
796	-3.3922e-002	3.6733e-002	1.3e-002	-2.1567e-005
797	-3.3922e-002	3.6733e-002	1.4e-002	-2.1567e-005
798	-3.3922e-002	3.6733e-002	1.5e-002	-2.1567e-005
799	-3.3922e-002	3.6733e-002	1.6e-002	-2.1567e-005
800	-3.3922e-002	3.6733e-002	1.7e-002	-2.1567e-005
801	-3.3922e-002	3.6733e-002	1.8e-002	-2.1567e-005
802	-3.3922e-002	3.6733e-002	1.9e-002	-2.1567e-005
803	-3.3922e-002	3.6733e-002	2.e-002	-2.1567e-005
804	-3.3922e-002	3.6733e-002	2.1e-002	-2.1567e-005
805	-3.3922e-002	3.6733e-002	2.2e-002	-2.1567e-005
806	-3.3922e-002	3.6733e-002	2.3e-002	-2.1567e-005
807	-3.3922e-002	3.6733e-002	2.4e-002	-2.1567e-005
808	-3.3922e-002	3.6733e-002	2.5e-002	-2.1567e-005
809	-3.3921e-002	3.6733e-002	2.6e-002	-2.1567e-005
810	-3.3921e-002	3.6733e-002	2.7e-002	-2.1567e-005
811	-3.3921e-002	3.6733e-002	2.8e-002	-2.1567e-005
812	-3.3921e-002	3.6733e-002	2.9e-002	-2.1567e-005
813	-3.3921e-002	3.6733e-002	3.e-002	-2.1567e-005
814	-3.3921e-002	3.6733e-002	3.1e-002	-2.1567e-005
815	-3.3921e-002	3.6734e-002	3.2e-002	-2.1567e-005
816	-3.3921e-002	3.6734e-002	3.3e-002	-2.1567e-005
817	-3.3921e-002	3.6734e-002	3.4e-002	-2.1567e-005
818	-3.3921e-002	3.6734e-002	3.5e-002	-2.1567e-005
819	-3.3921e-002	3.6734e-002	3.6e-002	-2.1567e-005
820	-3.3921e-002	3.6734e-002	3.7e-002	-2.1567e-005
821	-3.3921e-002	3.6734e-002	3.8e-002	-2.1567e-005
822	-3.3921e-002	3.6734e-002	3.9e-002	-2.1567e-005
823	-3.3921e-002	3.6734e-002	4.e-002	-2.1567e-005
824	-3.3921e-002	3.6734e-002	4.1e-002	-2.1567e-005
825	-3.3921e-002	3.6734e-002	4.2e-002	-2.1567e-005
826	-3.392e-002	3.6734e-002	4.3e-002	-2.1567e-005
827	-3.392e-002	3.6734e-002	4.4e-002	-2.1567e-005
828	-3.392e-002	3.6734e-002	4.5e-002	-2.1567e-005
829	-3.392e-002	3.6735e-002	4.6e-002	-2.1567e-005
830	-3.392e-002	3.6735e-002	4.7e-002	-2.1566e-005
831	-3.392e-002	3.6735e-002	4.8e-002	-2.1567e-005
832	-3.3185e-002	3.74e-002	4.8e-002	-2.0616e-005
833	-3.2435e-002	3.8053e-002	4.8e-002	-1.9672e-005
834	-3.1672e-002	3.869e-002	4.8e-002	-1.8735e-005
835	-3.0896e-002	3.9312e-002	4.8e-002	-1.7809e-005
836	-3.0108e-002	3.9918e-002	4.8e-002	-1.6894e-005
837	-2.9309e-002	4.0509e-002	4.8e-002	-1.5991e-005
838	-2.7675e-002	4.1642e-002	4.8e-002	-1.4229e-005
839	-2.5998e-002	4.271e-002	4.8e-002	-1.2532e-005
840	-2.4279e-002	4.371e-002	4.8e-002	-1.0911e-005
841	-2.2522e-002	4.464e-002	4.8e-002	-9.3733e-006
842	-2.073e-002	4.55e-002	4.8e-002	-7.9287e-006
843	-1.8904e-002	4.6289e-002	4.8e-002	-6.585e-006
844	-1.7049e-002	4.7003e-002	4.8e-002	-5.3497e-006
845	-1.5167e-002	4.7644e-002	4.8e-002	-4.2296e-006
846	-1.3261e-002	4.8209e-002	4.8e-002	-3.231e-006
847	-1.1334e-002	4.8699e-002	4.8e-002	-2.3592e-006
848	-9.3886e-003	4.9111e-002	4.8e-002	-1.6191e-006
849	-7.4287e-003	4.9445e-002	4.8e-002	-1.0147e-006
850	-5.4571e-003	4.9701e-002	4.8e-002	-5.4939e-007
851	-3.4768e-003	4.9879e-002	4.8e-002	-2.2562e-007
852	-1.491e-003	4.9978e-002	4.8e-002	-4.5176e-008
853	4.971e-004	4.9998e-002	4.8e-002	-9.0378e-009
854	2.4844e-003	4.9938e-002	4.8e-002	-1.174e-007
855	4.4678e-003	4.98e-002	4.8e-002	-3.6969e-007
856	6.4442e-003	4.9583e-002	4.8e-002	-7.6451e-007
857	8.4103e-003	4.9288e-002	4.8e-002	-1.2997e-006
858	1.0363e-002	4.8914e-002	4.8e-002	-1.9724e-006
859	1.23e-002	4.8464e-002	4.8e-002	-2.7789e-006
860	1.4217e-002	4.7936e-002	4.8e-002	-3.7148e-006
861	1.6111e-002	4.7333e-002	4.8e-002	-4.7749e-006
862	1.798e-002	4.6655e-002	4.8e-002	-5.9534e-006
863	1.9821e-002	4.5904e-002	4.8e-002	-7.2438e-006
864	2.163e-002	4.5079e-002	4.8e-002	-8.6389e-006
865	2.3405e-002	4.4184e-002	4.8e-002	-1.0131e-005
866	2.5143e-002	4.3218e-002	4.8e-002	-1.1712e-005
867	2.6842e-002	4.2184e-002	4.8e-002	-1.3372e-005
868	2.8498e-002	4.1084e-002	4.8e-002	-1.5103e-005
869	3.0108e-002	3.9918e-002	4.8e-002	-1.6894e-005
870	3.1672e-002	3.869e-002	4.8e-002	-1.8735e-005
871	3.2435e-002	3.8053e-002	4.8e-002	-1.9672e-005
872	3.3185e-002	3.74e-002	4.8e-002	-2.0617e-005
873	3.3922e-002	3.6733e-002	4.8e-002	-2.1567e-005
874	3.3922e-002	3.6733e-002	4.7e-002	-2.1567e-005
875	3.3922e-002	3.6733e-002	4.6e-002	-2.1567e-005
876	3.3922e-002	3.6733e-002	4.5e-002	-2.1567e-005
877	3.3922e-002	3.6733e-002	4.4e-002	-2.1567e-005
878	3.3922e-002	3.6733e-002	4.3e-002	-2.1567e-005
879	3.3922e-002	3.6733e-002	4.2e-002	-2.1567e-005
880	3.3922e-002	3.6733e-002	4.1e-002	-2.1567e-005
881	3.3922e-002	3.6733e-002	4.e-002	-2.1567e-005
882	3.3922e-002	3.6733e-002	3.9e-002	-2.1567e-005
883	3.3922e-002	3.6733e-002	3.8e-002	-2.1567e-005
884	3.3922e-002	3.6733e-002	3.7e-002	-2.1567e-005
885	3.3922e-002	3.6733e-002	3.6e-002	-2.1567e-005
886	3.3922e-002	3.6733e-002	3.5e-002	-2.1567e-005
887	3.3922e-002	3.6733e-002	3.4e-002	-2.1567e-005
888	3.3922e-002	3.6733e-002	3.3e-002	-2.1567e-005
889	3.3922e-002	3.6733e-002	3.2e-002	-2.1567e-005
890	3.3922e-002	3.6733e-002	3.1e-002	-2.1567e-005
891	3.3922e-002	3.6733e-002	3.e-002	-2.1567e-005
892	3.3922e-002	3.6733e-002	2.9e-002	-2.1567e-005
893	3.3922e-002	3.6733e-002	2.8e-002	-2.1567e-005
894	3.3922e-002	3.6733e-002	2.7e-002	-2.1567e-005
895	3.3922e-002	3.6733e-002	2.6e-002	-2.1567e-005
896	3.3922e-002	3.6733e-002	2.5e-002	-2.1567e-005
897	3.3922e-002	3.6733e-002	2.4e-002	-2.1567e-005
898	3.3922e-002	3.6733e-002	2.3e-002	-2.1567e-005
899	3.3922e-002	3.6733e-002	2.2e-002	-2.1567e-005
900	3.3922e-002	3.6733e-002	2.1e-002	-2.1567e-005
901	3.3922e-002	3.6733e-002	2.e-002	-2.1567e-005
902	3.3922e-002	3.6733e-002	1.9e-002	-2.1567e-005
903	3.3922e-002	3.6733e-002	1.8e-002	-2.1567e-005
904	3.3921e-002	3.6733e-002	1.7e-002	-2.1567e-005
905	3.3921e-002	3.6733e-002	1.6e-002	-2.1567e-005
906	3.3921e-002	3.6733e-002	1.5e-002	-2.1567e-005
907	3.3921e-002	3.6733e-002	1.4e-002	-2.1567e-005
908	3.3921e-002	3.6733e-002	1.3e-002	-2.1567e-005
909	3.3921e-002	3.6734e-002	1.2e-002	-2.1567e-005
910	3.3921e-002	3.6734e-002	1.1e-002	-2.1567e-005
911	3.3921e-002	3.6734e-002	1.e-002	-2.1567e-005
912	3.3921e-002	3.6734e-002	9.0001e-003	-2.1567e-005
913	3.3921e-002	3.6734e-002	8.0001e-003	-2.1567e-005
914	3.3921e-002	3.6734e-002	7.0001e-003	-2.1567e-005
915	3.3921e-002	3.6734e-002	6.0001e-003	-2.1567e-005
916	3.3921e-002	3.6734e-002	5.0001e-003	-2.1567e-005
917	3.3921e-002	3.6734e-002	4.0001e-003	-2.1567e-005
918	3.3921e-002	3.6734e-002	3.0001e-003	-2.1567e-005
919	-3.2435e-002	3.8053e-002	4.7e-002	-1.9672e-005
920	-3.1672e-002	3.869e-002	4.7e-002	-1.8735e-005
921	-3.0896e-002	3.9312e-002	4.7e-002	-1.7809e-005
922	-3.0108e-002	3.9919e-002	4.7e-002	-1.6894e-005
923	-2.9309e-002	4.0509e-002	4.7e-002	-1.5991e-005
924	-2.8498e-002	4.1084e-002	4.7e-002	-1.5103e-005
925	-2.7675e-002	4.1642e-002	4.7e-002	-1.4229e-005
926	-2.6842e-002	4.2184e-002	4.7e-002	-1.3372e-005
927	-2.5998e-002	4.271e-002	4.7e-002	-1.2533e-005
928	-2.5143e-002	4.3218e-002	4.7e-002	-1.1712e-005
929	-2.4279e-002	4.371e-002	4.7e-002	-1.0911e-005
930	-2.3405e-002	4.4184e-002	4.7e-002	-1.0131e-005
931	-2.2522e-002	4.464e-002	4.7e-002	-9.3733e-006
932	-2.163e-002	4.5079e-002	4.7e-002	-8.6389e-006
933	-2.073e-002	4.55e-002	4.7e-002	-7.9287e-006
934	-1.9821e-002	4.5904e-002	4.7e-002	-7.2438e-006
935	-1.8904e-002	4.6289e-002	4.7e-002	-6.585e-006
936	-1.798e-002	4.6655e-002	4.7e-002	-5.9534e-006
937	-1.7049e-002	4.7003e-002	4.7e-002	-5.3497e-006
938	-1.6111e-002	4.7333e-002	4.7e-002	-4.7749e-006
939	-1.5167e-002	4.7644e-002	4.7e-002	-4.2296e-006
940	-1.4217e-002	4.7936e-002	4.7e-002	-3.7148e-006
941	-1.3261e-002	4.8209e-002	4.7e-002	-3.231e-006
942	-1.23e-002	4.8464e-002	4.7e-002	-2.7789e-006
943	-1.1334e-002	4.8699e-002	4.7e-002	-2.3592e-006
944	-1.0363e-002	4.8914e-002	4.7e-002	-1.9724e-006
945	-9.3886e-003	4.9111e-002	4.7e-002	-1.6191e-006
946	-8.4103e-003	4.9288e-002	4.7e-002	-1.2997e-006
947	-7.4287e-003	4.9445e-002	4.7e-002	-1.0147e-006
948	-6.4441e-003	4.9583e-002	4.7e-002	-7.6451e-007
949	-5.4571e-003	4.9701e-002	4.7e-002	-5.494e-007
950	-4.4678e-003	4.98e-002	4.7e-002	-3.6969e-007
951	-3.4768e-003	4.9879e-002	4.7e-002	-2.2562e-007
952	-2.4844e-003	4.9938e-002	4.7e-002	-1.174e-007
953	-1.4911e-003	4.9978e-002	4.7e-002	-4.5176e-008
954	-4.9706e-004	4.9998e-002	4.7e-002	-9.0377e-009
955	4.9706e-004	4.9998e-002	4.7e-002	-9.0377e-009
956	1.4911e-003	4.9978e-002	4.7e-002	-4.5176e-008
957	2.4844e-003	4.9938e-002	4.7e-002	-1.174e-007
958	3.4768e-003	4.9879e-002	4.7e-002	-2.2562e-007
959	4.4678e-003	4.98e-002	4.7e-002	-3.6969e-007
960	5.4571e-003	4.9701e-002	4.7e-002	-5.494e-007
961	6.4441e-003	4.9583e-002	4.7e-002	-7.6451e-007
962	7.4287e-003	4.9445e-002	4.7e-002	-1.0147e-006
963	8.4103e-003	4.9288e-002	4.7e-002	-1.2997e-006
964	9.3886e-003	4.9111e-002	4.7e-002	-1.6191e-006
965	1.0363e-002	4.8914e-002	4.7e-002	-1.9724e-006
966	1.1334e-002	4.8699e-002	4.7e-002	-2.3592e-006
967	1.23e-002	4.8464e-002	4.7e-002	-2.7789e-006
968	1.3261e-002	4.8209e-002	4.7e-002	-3.231e-006
969	1.4217e-002	4.7936e-002	4.7e-002	-3.7148e-006
970	1.5167e-002	4.7644e-002	4.7e-002	-4.2296e-006
971	1.6111e-002	4.7333e-002	4.7e-002	-4.7749e-006
972	1.7049e-002	4.7003e-002	4.7e-002	-5.3497e-006
973	1.798e-002	4.6655e-002	4.7e-002	-5.9534e-006
974	1.8904e-002	4.6289e-002	4.7e-002	-6.585e-006
975	1.9821e-002	4.5904e-002	4.7e-002	-7.2438e-006
976	2.073e-002	4.55e-002	4.7e-002	-7.9287e-006
977	2.163e-002	4.5079e-002	4.7e-002	-8.6389e-006
978	2.2522e-002	4.464e-002	4.7e-002	-9.3734e-006
979	2.3405e-002	4.4184e-002	4.7e-002	-1.0131e-005
980	2.4279e-002	4.371e-002	4.7e-002	-1.0911e-005
981	2.5143e-002	4.3218e-002	4.7e-002	-1.1712e-005
982	2.5998e-002	4.271e-002	4.7e-002	-1.2533e-005
983	2.6842e-002	4.2184e-002	4.7e-002	-1.3372e-005
984	2.7675e-002	4.1642e-002	4.7e-002	-1.4229e-005
985	2.8498e-002	4.1084e-002	4.7e-002	-1.5103e-005
986	2.9309e-002	4.0509e-002	4.7e-002	-1.5991e-005
987	3.0108e-002	3.9918e-002	4.7e-002	-1.6894e-005
988	3.0896e-002	3.9312e-002	4.7e-002	-1.7809e-005
989	3.1672e-002	3.869e-002	4.7e-002	-1.8735e-005
990	3.2435e-002	3.8053e-002	4.7e-002	-1.9672e-005
991	3.3185e-002	3.74e-002	4.7e-002	-2.0616e-005
992	3.3185e-002	3.74e-002	4.6e-002	-2.0616e-005
993	3.3185e-002	3.74e-002	4.5e-002	-2.0616e-005
994	3.3185e-002	3.74e-002	4.4e-002	-2.0616e-005
995	3.3185e-002	3.74e-002	4.3e-002	-2.0616e-005
996	3.3185e-002	3.74e-002	4.2e-002	-2.0616e-005
997	3.3185e-002	3.74e-002	4.1e-002	-2.0616e-005
998	3.3185e-002	3.74e-002	4.e-002	-2.0616e-005
999	3.3185e-002	3.74e-002	3.9e-002	-2.0616e-005
1000	3.3185e-002	3.74e-002	3.8e-002	-2.0616e-005
1001	3.3185e-002	3.74e-002	3.7e-002	-2.0616e-005
1002	3.3185e-002	3.74e-002	3.6e-002	-2.0616e-005
1003	3.3185e-002	3.74e-002	3.5e-002	-2.0616e-005
1004	3.3185e-002	3.74e-002	3.4e-002	-2.0616e-005
1005	3.3185e-002	3.74e-002	3.3e-002	-2.0616e-005
1006	3.3185e-002	3.74e-002	3.2e-002	-2.0616e-005
1007	3.3185e-002	3.74e-002	3.1e-002	-2.0616e-005
1008	3.3185e-002	3.74e-002	3.e-002	-2.0616e-005
1009	3.3185e-002	3.74e-002	2.9e-002	-2.0616e-005
1010	3.3185e-002	3.74e-002	2.8e-002	-2.0616e-005
1011	3.3185e-002	3.74e-002	2.7e-002	-2.0616e-005
1012	3.3185e-002	3.74e-002	2.6e-002	-2.0616e-005
1013	3.3185e-002	3.74e-002	2.5e-002	-2.0617e-005
1014	3.3185e-002	3.74e-002	2.4e-002	-2.0617e-005
1015	3.3185e-002	3.74e-002	2.3e-002	-2.0617e-005
1016	3.3185e-002	3.74e-002	2.2e-002	-2.0617e-005
1017	3.3185e-002	3.74e-002	2.1e-002	-2.0617e-005
1018	3.3185e-002	3.74e-002	2.e-002	-2.0617e-005
1019	3.3185e-002	3.74e-002	1.9e-002	-2.0617e-005
1020	3.3186e-002	3.7399e-002	1.8e-002	-2.0617e-005
1021	3.3186e-002	3.7399e-002	1.7e-002	-2.0617e-005
1022	3.3186e-002	3.7399e-002	1.6e-002	-2.0617e-005
1023	3.3186e-002	3.7399e-002	1.5e-002	-2.0617e-005
1024	3.3186e-002	3.7399e-002	1.4e-002	-2.0617e-005
1025	3.3186e-002	3.7399e-002	1.3e-002	-2.0617e-005
1026	3.3186e-002	3.7399e-002	1.2e-002	-2.0617e-005
1027	3.3186e-002	3.7399e-002	1.1e-002	-2.0617e-005
1028	3.3186e-002	3.7399e-002	1.e-002	-2.0617e-005
1029	3.3186e-002	3.7399e-002	8.9999e-003	-2.0617e-005
1030	3.3186e-002	3.7399e-002	7.9999e-003	-2.0617e-005
1031	3.3187e-002	3.7399e-002	6.9999e-003	-2.0617e-005
1032	3.3187e-002	3.7398e-002	5.9999e-003	-2.0617e-005
1033	3.3187e-002	3.7398e-002	4.9999e-003	-2.0617e-005
1034	3.3187e-002	3.7398e-002	3.9999e-003	-2.0617e-005
1035	3.3187e-002	3.7398e-002	3.e-003	-2.0617e-005
1036	3.2435e-002	3.8053e-002	3.e-003	-1.9672e-005
1037	3.1672e-002	3.869e-002	3.e-003	-1.8735e-005
1038	3.0896e-002	3.9312e-002	3.e-003	-1.7809e-005
1039	3.0108e-002	3.9918e-002	3.e-003	-1.6894e-005
1040	2.9309e-002	4.0509e-002	3.e-003	-1.5992e-005
1041	2.8498e-002	4.1084e-002	3.e-003	-1.5103e-005
1042	2.7675e-002	4.1642e-002	3.e-003	-1.4229e-005
1043	2.6842e-002	4.2184e-002	3.e-003	-1.3372e-005
1044	2.5998e-002	4.271e-002	3.e-003	-1.2533e-005
1045	2.5143e-002	4.3218e-002	3.e-003	-1.1712e-005
1046	2.4279e-002	4.371e-002	3.e-003	-1.0911e-005
1047	2.3405e-002	4.4184e-002	3.e-003	-1.0131e-005
1048	2.2522e-002	4.464e-002	3.e-003	-9.3734e-006
1049	2.163e-002	4.5079e-002	3.e-003	-8.6389e-006
1050	2.073e-002	4.55e-002	3.e-003	-7.9287e-006
1051	1.9821e-002	4.5904e-002	3.e-003	-7.2438e-006
1052	1.8904e-002	4.6289e-002	3.e-003	-6.585e-006
1053	1.798e-002	4.6655e-002	3.e-003	-5.9534e-006
1054	1.7049e-002	4.7003e-002	3.e-003	-5.3497e-006
1055	1.6111e-002	4.7333e-002	3.e-003	-4.7749e-006
1056	1.5167e-002	4.7644e-002	3.e-003	-4.2296e-006
1057	1.4217e-002	4.7936e-002	3.e-003	-3.7148e-006
1058	1.3261e-002	4.8209e-002	3.e-003	-3.231e-006
1059	1.23e-002	4.8464e-002	3.e-003	-2.7789e-006
1060	1.1334e-002	4.8699e-002	3.e-003	-2.3592e-006
1061	1.0363e-002	4.8914e-002	3.e-003	-1.9724e-006
1062	9.3886e-003	4.9111e-002	3.e-003	-1.6191e-006
1063	8.4103e-003	4.9288e-002	3.e-003	-1.2997e-006
1064	7.4287e-003	4.9445e-002	3.e-003	-1.0147e-006
1065	6.4442e-003	4.9583e-002	3.e-003	-7.6451e-007
1066	5.4571e-003	4.9701e-002	3.e-003	-5.494e-007
1067	4.4678e-003	4.98e-002	3.e-003	-3.6969e-007
1068	3.4768e-003	4.9879e-002	3.e-003	-2.2562e-007
1069	2.4844e-003	4.9938e-002	3.e-003	-1.174e-007
1070	1.491e-003	4.9978e-002	3.e-003	-4.5176e-008
1071	4.9708e-004	4.9998e-002	3.e-003	-9.0376e-009
1072	-4.9707e-004	4.9998e-002	3.e-003	-9.0378e-009
1073	-1.491e-003	4.9978e-002	3.e-003	-4.5176e-008
1074	-2.4844e-003	4.9938e-002	3.e-003	-1.174e-007
1075	-3.4768e-003	4.9879e-002	3.e-003	-2.2562e-007
1076	-4.4678e-003	4.98e-002	3.e-003	-3.6969e-007
1077	-5.4571e-003	4.9701e-002	3.e-003	-5.494e-007
1078	-6.4442e-003	4.9583e-002	3.e-003	-7.6451e-007
1079	-7.4287e-003	4.9445e-002	3.e-003	-1.0147e-006
1080	-8.4103e-003	4.9288e-002	3.e-003	-1.2997e-006
1081	-9.3886e-003	4.9111e-002	3.e-003	-1.6191e-006
1082	-1.0363e-002	4.8914e-002	3.e-003	-1.9724e-006
1083	-1.1334e-002	4.8699e-002	3.e-003	-2.3592e-006
1084	-1.23e-002	4.8464e-002	3.e-003	-2.7789e-006
1085	-1.3261e-002	4.8209e-002	3.e-003	-3.231e-006
1086	-1.4217e-002	4.7936e-002	3.e-003	-3.7148e-006
1087	-1.5167e-002	4.7644e-002	3.e-003	-4.2296e-006
1088	-1.6111e-002	4.7333e-002	3.e-003	-4.7749e-006
1089	-1.7049e-002	4.7003e-002	3.e-003	-5.3497e-006
1090	-1.798e-002	4.6655e-002	3.e-003	-5.9534e-006
1091	-1.8904e-002	4.6289e-002	3.e-003	-6.585e-006
1092	-1.9821e-002	4.5904e-002	3.e-003	-7.2438e-006
1093	-2.073e-002	4.55e-002	3.e-003	-7.9287e-006
1094	-2.163e-002	4.5079e-002	3.e-003	-8.6389e-006
1095	-2.2522e-002	4.464e-002	3.e-003	-9.3734e-006
1096	-2.3405e-002	4.4184e-002	3.e-003	-1.0131e-005
1097	-2.4279e-002	4.371e-002	3.e-003	-1.0911e-005
1098	-2.5143e-002	4.3218e-002	3.e-003	-1.1712e-005
1099	-2.5998e-002	4.271e-002	3.e-003	-1.2533e-005
1100	-2.6842e-002	4.2184e-002	3.e-003	-1.3372e-005
1101	-2.7675e-002	4.1642e-002	3.e-003	-1.4229e-005
1102	-2.8498e-002	4.1084e-002	3.e-003	-1.5103e-005
1103	-2.9309e-002	4.0509e-002	3.e-003	-1.5992e-005
1104	-3.0108e-002	3.9918e-002	3.e-003	-1.6894e-005
1105	-3.0896e-002	3.9312e-002	3.e-003	-1.7809e-005
1106	-3.1672e-002	3.869e-002	3.e-003	-1.8735e-005
1107	-3.2435e-002	3.8053e-002	3.e-003	-1.9672e-005
1108	-3.3185e-002	3.74e-002	3.e-003	-2.0616e-005
1109	-3.3185e-002	3.74e-002	4.e-003	-2.0616e-005
1110	-3.3185e-002	3.74e-002	5.e-003	-2.0616e-005
1111	-3.3185e-002	3.74e-002	6.e-003	-2.0616e-005
1112	-3.3185e-002	3.74e-002	7.e-003	-2.0616e-005
1113	-3.3185e-002	3.74e-002	8.e-003	-2.0616e-005
1114	-3.3185e-002	3.74e-002	9.e-003	-2.0615e-005
1115	-3.3185e-002	3.74e-002	1.e-002	-2.0614e-005
1116	-3.3185e-002	3.74e-002	1.1e-002	-2.0614e-005
1117	-3.3185e-002	3.74e-002	1.2e-002	-2.0614e-005
1118	-3.3185e-002	3.74e-002	1.3e-002	-2.0615e-005
1119	-3.3185e-002	3.74e-002	1.4e-002	-2.0616e-005
1120	-3.3185e-002	3.74e-002	1.5e-002	-2.0617e-005
1121	-3.3185e-002	3.74e-002	1.6e-002	-2.0617e-005
1122	-3.3185e-002	3.74e-002	1.7e-002	-2.0617e-005
1123	-3.3185e-002	3.74e-002	1.8e-002	-2.0617e-005
1124	-3.3185e-002	3.74e-002	1.9e-002	-2.0617e-005
1125	-3.3185e-002	3.74e-002	2.e-002	-2.0617e-005
1126	-3.3185e-002	3.74e-002	2.1e-002	-2.0617e-005
1127	-3.3186e-002	3.7399e-002	2.2e-002	-2.0617e-005
1128	-3.3186e-002	3.7399e-002	2.3e-002	-2.0617e-005
1129	-3.3186e-002	3.7399e-002	2.4e-002	-2.0617e-005
1130	-3.3186e-002	3.7399e-002	2.5e-002	-2.0617e-005
1131	-3.3186e-002	3.7399e-002	2.6e-002	-2.0617e-005
1132	-3.3186e-002	3.7399e-002	2.7e-002	-2.0617e-005
1133	-3.3186e-002	3.7399e-002	2.8e-002	-2.0617e-005
1134	-3.3186e-002	3.7399e-002	2.9e-002	-2.0617e-005
1135	-3.3186e-002	3.7399e-002	3.e-002	-2.0617e-005
1136	-3.3186e-002	3.7399e-002	3.1e-002	-2.0617e-005
1137	-3.3187e-002	3.7399e-002	3.2e-002	-2.0617e-005
1138	-3.3187e-002	3.7398e-002	3.3e-002	-2.0617e-005
1139	-3.3187e-002	3.7398e-002	3.4e-002	-2.0617e-005
1140	-3.3187e-002	3.7398e-002	3.5e-002	-2.0617e-005
1141	-3.3187e-002	3.7398e-002	3.6e-002	-2.0617e-005
1142	-3.3187e-002	3.7398e-002	3.7e-002	-2.0617e-005
1143	-3.3187e-002	3.7398e-002	3.8e-002	-2.0617e-005
1144	-3.3187e-002	3.7398e-002	3.9e-002	-2.0617e-005
1145	-3.3188e-002	3.7398e-002	4.e-002	-2.0618e-005
1146	-3.3188e-002	3.7398e-002	4.1e-002	-2.0618e-005
1147	-3.3188e-002	3.7397e-002	4.2e-002	-2.0618e-005
1148	-3.3188e-002	3.7397e-002	4.3e-002	-2.0618e-005
1149	-3.3188e-002	3.7397e-002	4.4e-002	-2.0618e-005
1150	-3.3188e-002	3.7397e-002	4.5e-002	-2.0618e-005
1151	-3.3189e-002	3.7397e-002	4.6e-002	-2.0617e-005
1152	3.2435e-002	3.8053e-002	4.6e-002	-1.9672e-005
1153	3.2435e-002	3.8053e-002	4.5e-002	-1.9672e-005
1154	3.2435e-002	3.8053e-002	4.4e-002	-1.9672e-005
1155	3.2435e-002	3.8053e-002	4.3e-002	-1.9672e-005
1156	3.2434e-002	3.8053e-002	4.1e-002	-1.9672e-005
1157	3.2434e-002	3.8053e-002	4.e-002	-1.9672e-005
1158	3.2434e-002	3.8053e-002	3.9e-002	-1.9671e-005
1159	3.2434e-002	3.8053e-002	3.8e-002	-1.9671e-005
1160	3.2434e-002	3.8053e-002	3.7e-002	-1.9671e-005
1161	3.2434e-002	3.8053e-002	3.6e-002	-1.9671e-005
1162	3.2434e-002	3.8053e-002	3.5e-002	-1.9671e-005
1163	3.2434e-002	3.8053e-002	3.4e-002	-1.9671e-005
1164	3.2434e-002	3.8053e-002	3.3e-002	-1.9671e-005
1165	3.2434e-002	3.8053e-002	3.2e-002	-1.9671e-005
1166	3.2434e-002	3.8053e-002	3.1e-002	-1.9671e-005
1167	3.2434e-002	3.8053e-002	3.e-002	-1.9671e-005
1168	3.2434e-002	3.8053e-002	2.9e-002	-1.9671e-005
1169	3.2434e-002	3.8053e-002	2.8e-002	-1.9671e-005
1170	3.2434e-002	3.8053e-002	2.7e-002	-1.9671e-005
1171	3.2434e-002	3.8053e-002	2.6e-002	-1.9671e-005
1172	3.2434e-002	3.8053e-002	2.5e-002	-1.9671e-005
1173	3.2434e-002	3.8053e-002	2.4e-002	-1.9671e-005
1174	3.2434e-002	3.8053e-002	2.3e-002	-1.9671e-005
1175	3.2434e-002	3.8053e-002	2.2e-002	-1.9671e-005
1176	3.2434e-002	3.8053e-002	2.1e-002	-1.9671e-005
1177	3.2434e-002	3.8053e-002	2.e-002	-1.9671e-005
1178	3.2434e-002	3.8053e-002	1.9e-002	-1.9671e-005
1179	3.2434e-002	3.8053e-002	1.8e-002	-1.9671e-005
1180	3.2434e-002	3.8053e-002	1.7e-002	-1.9671e-005
1181	3.2433e-002	3.8054e-002	1.6e-002	-1.9671e-005
1182	3.2433e-002	3.8054e-002	1.5e-002	-1.9671e-005
1183	3.2433e-002	3.8054e-002	1.4e-002	-1.9671e-005
1184	3.2433e-002	3.8054e-002	1.3e-002	-1.9671e-005
1185	3.2433e-002	3.8054e-002	1.2e-002	-1.9671e-005
1186	3.2433e-002	3.8054e-002	1.1e-002	-1.9671e-005
1187	3.2433e-002	3.8054e-002	1.e-002	-1.9671e-005
1188	3.2433e-002	3.8054e-002	9.e-003	-1.9671e-005
1189	3.2433e-002	3.8054e-002	8.e-003	-1.9671e-005
1190	3.2433e-002	3.8054e-002	7.e-003	-1.9671e-005
1191	3.2433e-002	3.8054e-002	5.0001e-003	-1.9671e-005
1192	3.2433e-002	3.8054e-002	4.0001e-003	-1.9672e-005
1193	3.1672e-002	3.869e-002	4.e-003	-1.8735e-005
1194	3.0896e-002	3.9312e-002	4.e-003	-1.7809e-005
1195	3.0108e-002	3.9918e-002	4.e-003	-1.6894e-005
1196	2.9309e-002	4.0509e-002	4.e-003	-1.5992e-005
1197	2.8498e-002	4.1084e-002	4.e-003	-1.5103e-005
1198	2.7675e-002	4.1642e-002	4.e-003	-1.4229e-005
1199	2.6842e-002	4.2184e-002	4.e-003	-1.3372e-005
1200	2.5998e-002	4.271e-002	4.e-003	-1.2533e-005
1201	2.5143e-002	4.3218e-002	4.e-003	-1.1712e-005
1202	2.3405e-002	4.4184e-002	4.e-003	-1.0131e-005
1203	2.163e-002	4.5079e-002	4.e-003	-8.6389e-006
1204	1.9821e-002	4.5904e-002	4.e-003	-7.2438e-006
1205	1.798e-002	4.6655e-002	4.e-003	-5.9534e-006
1206	1.6111e-002	4.7333e-002	4.e-003	-4.7749e-006
1207	1.4217e-002	4.7936e-002	4.e-003	-3.7148e-006
1208	1.23e-002	4.8464e-002	4.e-003	-2.7789e-006
1209	1.0363e-002	4.8914e-002	4.e-003	-1.9724e-006
1210	8.4103e-003	4.9288e-002	4.e-003	-1.2997e-006
1211	6.4441e-003	4.9583e-002	4.e-003	-7.6451e-007
1212	4.4678e-003	4.98e-002	4.e-003	-3.6969e-007
1213	2.4844e-003	4.9938e-002	4.e-003	-1.1741e-007
1214	4.9706e-004	4.9998e-002	4.e-003	-9.0379e-009
1215	-1.4911e-003	4.9978e-002	4.e-003	-4.5175e-008
1216	-3.4768e-003	4.9879e-002	4.e-003	-2.2562e-007
1217	-5.4571e-003	4.9701e-002	4.e-003	-5.4939e-007
1218	-7.4287e-003	4.9445e-002	4.e-003	-1.0147e-006
1219	-9.3886e-003	4.9111e-002	4.e-003	-1.6191e-006
1220	-1.1334e-002	4.8699e-002	4.e-003	-2.3592e-006
1221	-1.3261e-002	4.8209e-002	4.e-003	-3.231e-006
1222	-1.5167e-002	4.7644e-002	4.e-003	-4.2296e-006
1223	-1.7049e-002	4.7003e-002	4.e-003	-5.3497e-006
1224	-1.8904e-002	4.6289e-002	4.e-003	-6.585e-006
1225	-2.073e-002	4.55e-002	4.e-003	-7.9287e-006
1226	-2.2522e-002	4.464e-002	4.e-003	-9.3734e-006
1227	-2.4279e-002	4.371e-002	4.e-003	-1.0911e-005
1228	-2.5998e-002	4.271e-002	4.e-003	-1.2533e-005
1229	-2.7675e-002	4.1642e-002	4.e-003	-1.4229e-005
1230	-2.9309e-002	4.0509e-002	4.e-003	-1.5992e-005
1231	-3.1672e-002	3.869e-002	4.e-003	-1.8735e-005
1232	-3.2435e-002	3.8053e-002	4.e-003	-1.9672e-005
1233	-3.2435e-002	3.8053e-002	5.e-003	-1.9672e-005
1234	-3.2435e-002	3.8053e-002	6.e-003	-1.9672e-005
1235	-3.2435e-002	3.8053e-002	7.e-003	-1.9671e-005
1236	-3.2428e-002	3.8058e-002	9.001e-003	-1.9662e-005
1237	-3.2427e-002	3.8059e-002	1.e-002	-1.9659e-005
1238	-3.2426e-002	3.806e-002	1.0999e-002	-1.9659e-005
1239	-3.2428e-002	3.8058e-002	1.1996e-002	-1.9661e-005
1240	-3.2427e-002	3.8059e-002	1.2996e-002	-1.9664e-005
1241	-3.2434e-002	3.8053e-002	1.4e-002	-1.9667e-005
1242	-3.2434e-002	3.8053e-002	1.5e-002	-1.967e-005
1243	-3.2434e-002	3.8053e-002	1.6e-002	-1.9671e-005
1244	-3.2434e-002	3.8053e-002	1.7e-002	-1.9671e-005
1245	-3.2434e-002	3.8053e-002	1.8e-002	-1.9672e-005
1246	-3.2434e-002	3.8053e-002	1.9e-002	-1.9672e-005
1247	-3.2434e-002	3.8053e-002	2.e-002	-1.9671e-005
1248	-3.2434e-002	3.8053e-002	2.1e-002	-1.9671e-005
1249	-3.2434e-002	3.8053e-002	2.2e-002	-1.9671e-005
1250	-3.2434e-002	3.8053e-002	2.3e-002	-1.9671e-005
1251	-3.2434e-002	3.8053e-002	2.4e-002	-1.9672e-005
1252	-3.2434e-002	3.8053e-002	2.5e-002	-1.9672e-005
1253	-3.2434e-002	3.8053e-002	2.6e-002	-1.9672e-005
1254	-3.2434e-002	3.8053e-002	2.7e-002	-1.9672e-005
1255	-3.2434e-002	3.8053e-002	2.8e-002	-1.9672e-005
1256	-3.2434e-002	3.8053e-002	2.9e-002	-1.9672e-005
1257	-3.2434e-002	3.8053e-002	3.e-002	-1.9672e-005
1258	-3.2434e-002	3.8053e-002	3.1e-002	-1.9672e-005
1259	-3.2434e-002	3.8053e-002	3.2e-002	-1.9672e-005
1260	-3.2434e-002	3.8053e-002	3.3e-002	-1.9671e-005
1261	-3.2434e-002	3.8053e-002	3.4e-002	-1.9671e-005
1262	-3.2434e-002	3.8053e-002	3.5e-002	-1.9671e-005
1263	-3.2434e-002	3.8053e-002	3.6e-002	-1.9671e-005
1264	-3.2433e-002	3.8054e-002	3.7e-002	-1.967e-005
1265	-3.2433e-002	3.8054e-002	3.8e-002	-1.9669e-005
1266	-3.2433e-002	3.8054e-002	3.9e-002	-1.9669e-005
1267	-3.2433e-002	3.8054e-002	4.e-002	-1.9669e-005
1268	-3.2433e-002	3.8054e-002	4.1e-002	-1.9671e-005
1269	-3.2433e-002	3.8054e-002	4.2e-002	-1.9671e-005
1270	-3.2433e-002	3.8054e-002	4.3e-002	-1.9671e-005
1271	-3.2433e-002	3.8054e-002	4.4e-002	-1.9671e-005
1272	-3.2433e-002	3.8054e-002	4.5e-002	-1.9672e-005
1273	-3.2433e-002	3.8054e-002	4.6e-002	-1.9672e-005
1274	-3.1672e-002	3.869e-002	4.6e-002	-1.8735e-005
1275	-3.0896e-002	3.9312e-002	4.6e-002	-1.7809e-005
1276	-2.9309e-002	4.0509e-002	4.6e-002	-1.5991e-005
1277	-2.8498e-002	4.1084e-002	4.6e-002	-1.5103e-005
1278	-2.7675e-002	4.1642e-002	4.6e-002	-1.4229e-005
1279	-2.5998e-002	4.271e-002	4.6e-002	-1.2533e-005
1280	-2.5143e-002	4.3218e-002	4.6e-002	-1.1712e-005
1281	-2.4279e-002	4.371e-002	4.6e-002	-1.0911e-005
1282	-2.3405e-002	4.4184e-002	4.6e-002	-1.0131e-005
1283	-2.2522e-002	4.464e-002	4.6e-002	-9.3734e-006
1284	-2.163e-002	4.5079e-002	4.6e-002	-8.6389e-006
1285	-2.073e-002	4.55e-002	4.6e-002	-7.9287e-006
1286	-1.9821e-002	4.5904e-002	4.6e-002	-7.2438e-006
1287	-1.8904e-002	4.6289e-002	4.6e-002	-6.585e-006
1288	-1.798e-002	4.6655e-002	4.6e-002	-5.9534e-006
1289	-1.7049e-002	4.7003e-002	4.6e-002	-5.3497e-006
1290	-1.6111e-002	4.7333e-002	4.6e-002	-4.7749e-006
1291	-1.5167e-002	4.7644e-002	4.6e-002	-4.2296e-006
1292	-1.4217e-002	4.7936e-002	4.6e-002	-3.7148e-006
1293	-1.3261e-002	4.8209e-002	4.6e-002	-3.231e-006
1294	-1.23e-002	4.8464e-002	4.6e-002	-2.7789e-006
1295	-1.1334e-002	4.8699e-002	4.6e-002	-2.3592e-006
1296	-1.0363e-002	4.8914e-002	4.6e-002	-1.9724e-006
1297	-9.3886e-003	4.9111e-002	4.6e-002	-1.6191e-006
1298	-8.4103e-003	4.9288e-002	4.6e-002	-1.2997e-006
1299	-7.4287e-003	4.9445e-002	4.6e-002	-1.0147e-006
1300	-6.4442e-003	4.9583e-002	4.6e-002	-7.6451e-007
1301	-5.4571e-003	4.9701e-002	4.6e-002	-5.494e-007
1302	-4.4678e-003	4.98e-002	4.6e-002	-3.6969e-007
1303	-3.4768e-003	4.9879e-002	4.6e-002	-2.2562e-007
1304	-2.4844e-003	4.9938e-002	4.6e-002	-1.1741e-007
1305	-1.4911e-003	4.9978e-002	4.6e-002	-4.5177e-008
1306	-4.9708e-004	4.9998e-002	4.6e-002	-9.0379e-009
1307	4.9706e-004	4.9998e-002	4.6e-002	-9.0375e-009
1308	1.491e-003	4.9978e-002	4.6e-002	-4.5175e-008
1309	2.4844e-003	4.9938e-002	4.6e-002	-1.174e-007
1310	3.4768e-003	4.9879e-002	4.6e-002	-2.2562e-007
1311	4.4678e-003	4.98e-002	4.6e-002	-3.6968e-007
1312	5.4571e-003	4.9701e-002	4.6e-002	-5.4939e-007
1313	6.4441e-003	4.9583e-002	4.6e-002	-7.6451e-007
1314	7.4287e-003	4.9445e-002	4.6e-002	-1.0147e-006
1315	8.4103e-003	4.9288e-002	4.6e-002	-1.2997e-006
1316	9.3886e-003	4.9111e-002	4.6e-002	-1.6191e-006
1317	1.0363e-002	4.8914e-002	4.6e-002	-1.9724e-006
1318	1.1334e-002	4.8699e-002	4.6e-002	-2.3592e-006
1319	1.23e-002	4.8464e-002	4.6e-002	-2.7789e-006
1320	1.3261e-002	4.8209e-002	4.6e-002	-3.231e-006
1321	1.4217e-002	4.7936e-002	4.6e-002	-3.7148e-006
1322	1.5167e-002	4.7644e-002	4.6e-002	-4.2296e-006
1323	1.6111e-002	4.7333e-002	4.6e-002	-4.7749e-006
1324	1.7049e-002	4.7003e-002	4.6e-002	-5.3497e-006
1325	1.798e-002	4.6655e-002	4.6e-002	-5.9534e-006
1326	1.8904e-002	4.6289e-002	4.6e-002	-6.585e-006
1327	1.9821e-002	4.5904e-002	4.6e-002	-7.2438e-006
1328	2.073e-002	4.55e-002	4.6e-002	-7.9287e-006
1329	2.163e-002	4.5079e-002	4.6e-002	-8.6389e-006
1330	2.2522e-002	4.464e-002	4.6e-002	-9.3733e-006
1331	2.3405e-002	4.4184e-002	4.6e-002	-1.0131e-005
1332	2.4279e-002	4.371e-002	4.6e-002	-1.0911e-005
1333	2.5143e-002	4.3218e-002	4.6e-002	-1.1712e-005
1334	2.5998e-002	4.271e-002	4.6e-002	-1.2532e-005
1335	2.6842e-002	4.2184e-002	4.6e-002	-1.3372e-005
1336	2.7675e-002	4.1642e-002	4.6e-002	-1.4229e-005
1337	2.8498e-002	4.1084e-002	4.6e-002	-1.5103e-005
1338	3.0108e-002	3.9918e-002	4.6e-002	-1.6894e-005
1339	3.0896e-002	3.9312e-002	4.6e-002	-1.7809e-005
1340	3.1672e-002	3.869e-002	4.6e-002	-1.8735e-005
1341	3.1672e-002	3.869e-002	5.e-003	-1.8735e-005
1342	-3.1672e-002	3.869e-002	4.5e-002	-1.8735e-005
1343	-3.0896e-002	3.9312e-002	4.5e-002	-1.7809e-005
1344	-3.0108e-002	3.9919e-002	4.5e-002	-1.6894e-005
1345	-2.9309e-002	4.0509e-002	4.5e-002	-1.5992e-005
1346	-2.8498e-002	4.1084e-002	4.5e-002	-1.5103e-005
1347	-2.7675e-002	4.1642e-002	4.5e-002	-1.4229e-005
1348	-2.6842e-002	4.2184e-002	4.5e-002	-1.3372e-005
1349	-2.5998e-002	4.271e-002	4.5e-002	-1.2533e-005
1350	-2.5143e-002	4.3218e-002	4.5e-002	-1.1712e-005
1351	-2.4279e-002	4.371e-002	4.5e-002	-1.0911e-005
1352	-2.3405e-002	4.4184e-002	4.5e-002	-1.0131e-005
1353	-2.2522e-002	4.464e-002	4.5e-002	-9.3734e-006
1354	-2.163e-002	4.5079e-002	4.5e-002	-8.6389e-006
1355	-2.073e-002	4.55e-002	4.5e-002	-7.9288e-006
1356	-1.9821e-002	4.5904e-002	4.5e-002	-7.2438e-006
1357	-1.8904e-002	4.6288e-002	4.5e-002	-6.585e-006
1358	-1.798e-002	4.6655e-002	4.5e-002	-5.9534e-006
1359	-1.7049e-002	4.7003e-002	4.5e-002	-5.3497e-006
1360	-1.6111e-002	4.7333e-002	4.5e-002	-4.7749e-006
1361	-1.5167e-002	4.7644e-002	4.5e-002	-4.2297e-006
1362	-1.4217e-002	4.7936e-002	4.5e-002	-3.7148e-006
1363	-1.3261e-002	4.8209e-002	4.5e-002	-3.231e-006
1364	-1.23e-002	4.8464e-002	4.5e-002	-2.7789e-006
1365	-1.1334e-002	4.8699e-002	4.5e-002	-2.3592e-006
1366	-1.0363e-002	4.8914e-002	4.5e-002	-1.9724e-006
1367	-9.3887e-003	4.9111e-002	4.5e-002	-1.6191e-006
1368	-8.4103e-003	4.9288e-002	4.5e-002	-1.2997e-006
1369	-7.4288e-003	4.9445e-002	4.5e-002	-1.0147e-006
1370	-6.4442e-003	4.9583e-002	4.5e-002	-7.6451e-007
1371	-5.4571e-003	4.9701e-002	4.5e-002	-5.494e-007
1372	-4.4678e-003	4.98e-002	4.5e-002	-3.6969e-007
1373	-3.4769e-003	4.9879e-002	4.5e-002	-2.2563e-007
1374	-2.4844e-003	4.9938e-002	4.5e-002	-1.1741e-007
1375	-1.4911e-003	4.9978e-002	4.5e-002	-4.5177e-008
1376	-4.9708e-004	4.9998e-002	4.5e-002	-9.0381e-009
1377	4.9702e-004	4.9998e-002	4.5e-002	-9.0373e-009
1378	1.491e-003	4.9978e-002	4.5e-002	-4.5175e-008
1379	2.4844e-003	4.9938e-002	4.5e-002	-1.174e-007
1380	3.4768e-003	4.9879e-002	4.5e-002	-2.2562e-007
1381	4.4678e-003	4.98e-002	4.5e-002	-3.6968e-007
1382	5.4571e-003	4.9701e-002	4.5e-002	-5.4939e-007
1383	6.4441e-003	4.9583e-002	4.5e-002	-7.645e-007
1384	7.4287e-003	4.9445e-002	4.5e-002	-1.0147e-006
1385	8.4103e-003	4.9288e-002	4.5e-002	-1.2997e-006
1386	9.3886e-003	4.9111e-002	4.5e-002	-1.6191e-006
1387	1.0363e-002	4.8914e-002	4.5e-002	-1.9724e-006
1388	1.1334e-002	4.8699e-002	4.5e-002	-2.3592e-006
1389	1.23e-002	4.8464e-002	4.5e-002	-2.7789e-006
1390	1.3261e-002	4.8209e-002	4.5e-002	-3.231e-006
1391	1.4217e-002	4.7936e-002	4.5e-002	-3.7148e-006
1392	1.5167e-002	4.7644e-002	4.5e-002	-4.2296e-006
1393	1.6111e-002	4.7333e-002	4.5e-002	-4.7749e-006
1394	1.7049e-002	4.7003e-002	4.5e-002	-5.3497e-006
1395	1.798e-002	4.6655e-002	4.5e-002	-5.9534e-006
1396	1.8904e-002	4.6289e-002	4.5e-002	-6.585e-006
1397	1.9821e-002	4.5904e-002	4.5e-002	-7.2438e-006
1398	2.073e-002	4.55e-002	4.5e-002	-7.9287e-006
1399	2.163e-002	4.5079e-002	4.5e-002	-8.6389e-006
1400	2.2522e-002	4.464e-002	4.5e-002	-9.3733e-006
1401	2.3405e-002	4.4184e-002	4.5e-002	-1.0131e-005
1402	2.4279e-002	4.371e-002	4.5e-002	-1.0911e-005
1403	2.5143e-002	4.3218e-002	4.5e-002	-1.1712e-005
1404	2.5998e-002	4.271e-002	4.5e-002	-1.2532e-005
1405	2.6842e-002	4.2184e-002	4.5e-002	-1.3372e-005
1406	2.7675e-002	4.1642e-002	4.5e-002	-1.4229e-005
1407	2.8498e-002	4.1084e-002	4.5e-002	-1.5103e-005
1408	2.9309e-002	4.0509e-002	4.5e-002	-1.5991e-005
1409	3.0108e-002	3.9918e-002	4.5e-002	-1.6894e-005
1410	3.0896e-002	3.9312e-002	4.5e-002	-1.7809e-005
1411	3.1672e-002	3.869e-002	4.5e-002	-1.8735e-005
1412	3.1672e-002	3.869e-002	4.4e-002	-1.8735e-005
1413	3.1672e-002	3.869e-002	4.3e-002	-1.8735e-005
1414	3.1671e-002	3.869e-002	4.2e-002	-1.8735e-005
1415	3.1671e-002	3.869e-002	4.1e-002	-1.8735e-005
1416	3.1671e-002	3.869e-002	4.e-002	-1.8735e-005
1417	3.1671e-002	3.869e-002	3.9e-002	-1.8735e-005
1418	3.1671e-002	3.869e-002	3.7e-002	-1.8735e-005
1419	3.1671e-002	3.869e-002	3.5e-002	-1.8735e-005
1420	3.1671e-002	3.869e-002	3.3e-002	-1.8735e-005
1421	3.1671e-002	3.869e-002	3.1e-002	-1.8735e-005
1422	3.1671e-002	3.869e-002	2.9e-002	-1.8735e-005
1423	3.1671e-002	3.869e-002	2.7e-002	-1.8735e-005
1424	3.1671e-002	3.869e-002	2.5e-002	-1.8735e-005
1425	3.1671e-002	3.869e-002	2.3e-002	-1.8735e-005
1426	3.1671e-002	3.869e-002	2.1e-002	-1.8735e-005
1427	3.1671e-002	3.869e-002	1.9e-002	-1.8735e-005
1428	3.1671e-002	3.869e-002	1.7e-002	-1.8735e-005
1429	3.1671e-002	3.869e-002	1.5e-002	-1.8735e-005
1430	3.1671e-002	3.8691e-002	1.3e-002	-1.8735e-005
1431	3.1671e-002	3.8691e-002	1.2e-002	-1.8735e-005
1432	3.1671e-002	3.8691e-002	1.1e-002	-1.8735e-005
1433	3.1671e-002	3.8691e-002	1.e-002	-1.8735e-005
1434	3.1671e-002	3.8691e-002	9.0001e-003	-1.8735e-005
1435	3.1671e-002	3.8691e-002	8.0001e-003	-1.8735e-005
1436	3.167e-002	3.8691e-002	7.0001e-003	-1.8735e-005
1437	3.167e-002	3.8691e-002	6.0001e-003	-1.8735e-005
1438	3.0896e-002	3.9312e-002	5.e-003	-1.7809e-005
1439	3.0108e-002	3.9918e-002	5.e-003	-1.6894e-005
1440	2.9309e-002	4.0509e-002	5.e-003	-1.5992e-005
1441	2.8498e-002	4.1084e-002	5.e-003	-1.5103e-005
1442	2.7675e-002	4.1642e-002	5.e-003	-1.4229e-005
1443	2.6842e-002	4.2184e-002	5.e-003	-1.3372e-005
1444	2.5998e-002	4.271e-002	5.e-003	-1.2533e-005
1445	2.5143e-002	4.3218e-002	5.e-003	-1.1712e-005
1446	2.4279e-002	4.371e-002	5.e-003	-1.0911e-005
1447	2.3405e-002	4.4184e-002	5.e-003	-1.0131e-005
1448	2.2522e-002	4.464e-002	5.e-003	-9.3734e-006
1449	2.163e-002	4.5079e-002	5.e-003	-8.6389e-006
1450	2.073e-002	4.55e-002	5.e-003	-7.9288e-006
1451	1.9821e-002	4.5904e-002	5.e-003	-7.2438e-006
1452	1.8904e-002	4.6288e-002	5.e-003	-6.5851e-006
1453	1.798e-002	4.6655e-002	5.e-003	-5.9534e-006
1454	1.7049e-002	4.7003e-002	5.e-003	-5.3497e-006
1455	1.6111e-002	4.7333e-002	5.e-003	-4.7749e-006
1456	1.5167e-002	4.7644e-002	5.e-003	-4.2297e-006
1457	1.4217e-002	4.7936e-002	5.e-003	-3.7148e-006
1458	1.3261e-002	4.8209e-002	5.e-003	-3.231e-006
1459	1.23e-002	4.8464e-002	5.e-003	-2.7789e-006
1460	1.1334e-002	4.8699e-002	5.e-003	-2.3592e-006
1461	1.0363e-002	4.8914e-002	5.e-003	-1.9724e-006
1462	9.3887e-003	4.9111e-002	5.e-003	-1.6191e-006
1463	8.4103e-003	4.9288e-002	5.e-003	-1.2997e-006
1464	7.4288e-003	4.9445e-002	5.e-003	-1.0147e-006
1465	6.4442e-003	4.9583e-002	5.e-003	-7.6452e-007
1466	5.4571e-003	4.9701e-002	5.e-003	-5.494e-007
1467	4.4678e-003	4.98e-002	5.e-003	-3.6969e-007
1468	3.4769e-003	4.9879e-002	5.e-003	-2.2563e-007
1469	2.4844e-003	4.9938e-002	5.e-003	-1.1741e-007
1470	1.4911e-003	4.9978e-002	5.e-003	-4.5177e-008
1471	4.9708e-004	4.9998e-002	5.e-003	-9.0381e-009
1472	-4.9702e-004	4.9998e-002	5.e-003	-9.0373e-009
1473	-1.491e-003	4.9978e-002	5.e-003	-4.5175e-008
1474	-2.4844e-003	4.9938e-002	5.e-003	-1.174e-007
1475	-3.4768e-003	4.9879e-002	5.e-003	-2.2562e-007
1476	-4.4678e-003	4.98e-002	5.e-003	-3.6968e-007
1477	-5.4571e-003	4.9701e-002	5.e-003	-5.4939e-007
1478	-6.4441e-003	4.9583e-002	5.e-003	-7.6451e-007
1479	-7.4287e-003	4.9445e-002	5.e-003	-1.0147e-006
1480	-8.4103e-003	4.9288e-002	5.e-003	-1.2997e-006
1481	-9.3886e-003	4.9111e-002	5.e-003	-1.6191e-006
1482	-1.0363e-002	4.8914e-002	5.e-003	-1.9724e-006
1483	-1.1334e-002	4.8699e-002	5.e-003	-2.3592e-006
1484	-1.23e-002	4.8464e-002	5.e-003	-2.7789e-006
1485	-1.3261e-002	4.8209e-002	5.e-003	-3.231e-006
1486	-1.4217e-002	4.7936e-002	5.e-003	-3.7148e-006
1487	-1.5167e-002	4.7644e-002	5.e-003	-4.2296e-006
1488	-1.6111e-002	4.7333e-002	5.e-003	-4.7749e-006
1489	-1.7049e-002	4.7003e-002	5.e-003	-5.3497e-006
1490	-1.798e-002	4.6655e-002	5.e-003	-5.9534e-006
1491	-1.8904e-002	4.6289e-002	5.e-003	-6.585e-006
1492	-1.9821e-002	4.5904e-002	5.e-003	-7.2438e-006
1493	-2.073e-002	4.55e-002	5.e-003	-7.9287e-006
1494	-2.163e-002	4.5079e-002	5.e-003	-8.6389e-006
1495	-2.2522e-002	4.464e-002	5.e-003	-9.3733e-006
1496	-2.3405e-002	4.4184e-002	5.e-003	-1.0131e-005
1497	-2.4279e-002	4.371e-002	5.e-003	-1.0911e-005
1498	-2.5143e-002	4.3218e-002	5.e-003	-1.1712e-005
1499	-2.5998e-002	4.271e-002	5.e-003	-1.2532e-005
1500	-2.6842e-002	4.2184e-002	5.e-003	-1.3371e-005
1501	-2.7673e-002	4.1644e-002	4.991e-003	-1.4228e-005
1502	-2.8497e-002	4.1084e-002	4.9885e-003	-1.5102e-005
1503	-2.931e-002	4.0509e-002	4.9913e-003	-1.5992e-005
1504	-3.0108e-002	3.9919e-002	5.e-003	-1.6894e-005
1505	-3.1672e-002	3.869e-002	5.e-003	-1.8735e-005
1506	-3.1672e-002	3.869e-002	6.e-003	-1.8735e-005
1507	-3.1672e-002	3.869e-002	7.e-003	-1.8732e-005
1508	-3.166e-002	3.8699e-002	8.0048e-003	-1.8722e-005
1509	-3.1648e-002	3.8709e-002	9.0041e-003	-1.871e-005
1510	-3.1642e-002	3.8714e-002	9.998e-003	-1.8704e-005
1511	-3.1648e-002	3.8709e-002	1.099e-002	-1.8705e-005
1512	-3.1656e-002	3.8702e-002	1.299e-002	-1.8714e-005
1513	-3.1666e-002	3.8695e-002	1.4996e-002	-1.8725e-005
1514	-3.1671e-002	3.869e-002	1.7e-002	-1.8732e-005
1515	-3.1671e-002	3.869e-002	1.9e-002	-1.8736e-005
1516	-3.1671e-002	3.869e-002	2.1e-002	-1.8738e-005
1517	-3.1671e-002	3.869e-002	2.3e-002	-1.8738e-005
1518	-3.1671e-002	3.869e-002	2.5e-002	-1.8735e-005
1519	-3.1671e-002	3.869e-002	2.7e-002	-1.8732e-005
1520	-3.1671e-002	3.8691e-002	2.9e-002	-1.8732e-005
1521	-3.1671e-002	3.8691e-002	3.1e-002	-1.8731e-005
1522	-3.1671e-002	3.8691e-002	3.3e-002	-1.8732e-005
1523	-3.1671e-002	3.8691e-002	3.5e-002	-1.8731e-005
1524	-3.1663e-002	3.8697e-002	3.7e-002	-1.8726e-005
1525	-3.1662e-002	3.8698e-002	3.8999e-002	-1.8723e-005
1526	-3.167e-002	3.8691e-002	4.1e-002	-1.8729e-005
1527	-3.167e-002	3.8691e-002	4.3e-002	-1.8734e-005
1528	-3.167e-002	3.8691e-002	4.4e-002	-1.8735e-005
1529	3.0896e-002	3.9312e-002	4.4e-002	-1.7809e-005
1530	3.0896e-002	3.9312e-002	4.3e-002	-1.7809e-005
1531	3.0896e-002	3.9312e-002	4.2e-002	-1.7809e-005
1532	3.0896e-002	3.9312e-002	4.1e-002	-1.7809e-005
1533	3.0896e-002	3.9312e-002	4.e-002	-1.7809e-005
1534	3.0896e-002	3.9312e-002	3.9e-002	-1.7809e-005
1535	3.0896e-002	3.9312e-002	3.8e-002	-1.7809e-005
1536	3.0896e-002	3.9312e-002	3.7e-002	-1.7809e-005
1537	3.0896e-002	3.9312e-002	3.6e-002	-1.7809e-005
1538	3.0896e-002	3.9312e-002	3.5e-002	-1.7809e-005
1539	3.0896e-002	3.9312e-002	3.4e-002	-1.7809e-005
1540	3.0896e-002	3.9312e-002	3.3e-002	-1.7809e-005
1541	3.0896e-002	3.9312e-002	3.2e-002	-1.7809e-005
1542	3.0896e-002	3.9312e-002	3.1e-002	-1.7809e-005
1543	3.0896e-002	3.9312e-002	3.e-002	-1.7809e-005
1544	3.0896e-002	3.9312e-002	2.9e-002	-1.7809e-005
1545	3.0896e-002	3.9312e-002	2.8e-002	-1.7809e-005
1546	3.0896e-002	3.9312e-002	2.7e-002	-1.7809e-005
1547	3.0896e-002	3.9312e-002	2.6e-002	-1.7809e-005
1548	3.0897e-002	3.9312e-002	2.5e-002	-1.7809e-005
1549	3.0897e-002	3.9312e-002	2.4e-002	-1.7809e-005
1550	3.0897e-002	3.9312e-002	2.3e-002	-1.7809e-005
1551	3.0897e-002	3.9312e-002	2.2e-002	-1.781e-005
1552	3.0897e-002	3.9311e-002	2.1e-002	-1.781e-005
1553	3.0897e-002	3.9311e-002	2.e-002	-1.781e-005
1554	3.0897e-002	3.9311e-002	1.9e-002	-1.781e-005
1555	3.0897e-002	3.9311e-002	1.8e-002	-1.781e-005
1556	3.0897e-002	3.9311e-002	1.7e-002	-1.781e-005
1557	3.0897e-002	3.9311e-002	1.6e-002	-1.781e-005
1558	3.0897e-002	3.9311e-002	1.5e-002	-1.781e-005
1559	3.0897e-002	3.9311e-002	1.4e-002	-1.781e-005
1560	3.0897e-002	3.9311e-002	1.3e-002	-1.781e-005
1561	3.0897e-002	3.9311e-002	1.2e-002	-1.781e-005
1562	3.0897e-002	3.9311e-002	1.1e-002	-1.781e-005
1563	3.0898e-002	3.9311e-002	1.e-002	-1.781e-005
1564	3.0898e-002	3.9311e-002	9.e-003	-1.781e-005
1565	3.0898e-002	3.9311e-002	8.e-003	-1.781e-005
1566	3.0898e-002	3.9311e-002	7.e-003	-1.781e-005
1567	3.0898e-002	3.9311e-002	6.e-003	-1.781e-005
1568	3.0108e-002	3.9918e-002	6.e-003	-1.6894e-005
1569	2.9309e-002	4.0509e-002	6.e-003	-1.5992e-005
1570	2.8498e-002	4.1084e-002	6.e-003	-1.5103e-005
1571	2.7675e-002	4.1642e-002	6.e-003	-1.4229e-005
1572	2.6842e-002	4.2184e-002	6.e-003	-1.3372e-005
1573	2.5998e-002	4.271e-002	6.e-003	-1.2533e-005
1574	2.5143e-002	4.3218e-002	6.e-003	-1.1712e-005
1575	2.4279e-002	4.371e-002	6.e-003	-1.0911e-005
1576	2.3405e-002	4.4184e-002	6.e-003	-1.0131e-005
1577	2.2522e-002	4.464e-002	6.e-003	-9.3734e-006
1578	2.163e-002	4.5079e-002	6.e-003	-8.6389e-006
1579	2.073e-002	4.55e-002	6.e-003	-7.9288e-006
1580	1.9821e-002	4.5904e-002	6.e-003	-7.2438e-006
1581	1.8904e-002	4.6289e-002	6.e-003	-6.5851e-006
1582	1.798e-002	4.6655e-002	6.e-003	-5.9534e-006
1583	1.7049e-002	4.7003e-002	6.e-003	-5.3497e-006
1584	1.6111e-002	4.7333e-002	6.e-003	-4.7749e-006
1585	1.5167e-002	4.7644e-002	6.e-003	-4.2297e-006
1586	1.4217e-002	4.7936e-002	6.e-003	-3.7148e-006
1587	1.3261e-002	4.8209e-002	6.e-003	-3.231e-006
1588	1.23e-002	4.8464e-002	6.e-003	-2.7789e-006
1589	1.1334e-002	4.8699e-002	6.e-003	-2.3592e-006
1590	1.0363e-002	4.8914e-002	6.e-003	-1.9724e-006
1591	9.3886e-003	4.9111e-002	6.e-003	-1.6191e-006
1592	8.4103e-003	4.9288e-002	6.e-003	-1.2997e-006
1593	7.4288e-003	4.9445e-002	6.e-003	-1.0147e-006
1594	6.4442e-003	4.9583e-002	6.e-003	-7.6452e-007
1595	5.4571e-003	4.9701e-002	6.e-003	-5.494e-007
1596	4.4678e-003	4.98e-002	6.e-003	-3.6969e-007
1597	3.4769e-003	4.9879e-002	6.e-003	-2.2563e-007
1598	2.4844e-003	4.9938e-002	6.e-003	-1.1741e-007
1599	1.4911e-003	4.9978e-002	6.e-003	-4.5178e-008
1600	4.9707e-004	4.9998e-002	6.e-003	-9.0381e-009
1601	-4.9703e-004	4.9998e-002	6.e-003	-9.0373e-009
1602	-1.4911e-003	4.9978e-002	6.e-003	-4.5175e-008
1603	-2.4844e-003	4.9938e-002	6.e-003	-1.174e-007
1604	-3.4768e-003	4.9879e-002	6.e-003	-2.2562e-007
1605	-4.4678e-003	4.98e-002	6.e-003	-3.6968e-007
1606	-5.4571e-003	4.9701e-002	6.e-003	-5.4939e-007
1607	-6.4441e-003	4.9583e-002	6.e-003	-7.645e-007
1608	-7.4287e-003	4.9445e-002	6.e-003	-1.0147e-006
1609	-8.4103e-003	4.9288e-002	6.e-003	-1.2997e-006
1610	-9.3886e-003	4.9111e-002	6.e-003	-1.6191e-006
1611	-1.0363e-002	4.8914e-002	6.e-003	-1.9724e-006
1612	-1.1334e-002	4.8699e-002	6.e-003	-2.3592e-006
1613	-1.23e-002	4.8464e-002	6.e-003	-2.7789e-006
1614	-1.3261e-002	4.8209e-002	6.e-003	-3.231e-006
1615	-1.4217e-002	4.7936e-002	6.e-003	-3.7148e-006
1616	-1.5167e-002	4.7644e-002	6.e-003	-4.2296e-006
1617	-1.6111e-002	4.7333e-002	6.e-003	-4.7749e-006
1618	-1.7049e-002	4.7003e-002	6.e-003	-5.3497e-006
1619	-1.798e-002	4.6655e-002	6.e-003	-5.9534e-006
1620	-1.8904e-002	4.6289e-002	6.e-003	-6.585e-006
1621	-1.9821e-002	4.5904e-002	6.e-003	-7.2438e-006
1622	-2.073e-002	4.55e-002	6.e-003	-7.9287e-006
1623	-2.163e-002	4.5079e-002	6.e-003	-8.6389e-006
1624	-2.2522e-002	4.464e-002	6.e-003	-9.3733e-006
1625	-2.3405e-002	4.4184e-002	6.e-003	-1.0131e-005
1626	-2.4279e-002	4.371e-002	6.e-003	-1.0911e-005
1627	-2.5143e-002	4.3218e-002	6.e-003	-1.1711e-005
1628	-2.5998e-002	4.271e-002	6.e-003	-1.2531e-005
1629	-2.6838e-002	4.2187e-002	5.9919e-003	-1.3368e-005
1630	-2.767e-002	4.1646e-002	5.9815e-003	-1.4224e-005
1631	-2.8495e-002	4.1086e-002	5.9722e-003	-1.5099e-005
1632	-2.931e-002	4.0508e-002	5.9785e-003	-1.5989e-005
1633	-3.0108e-002	3.9919e-002	6.e-003	-1.6893e-005
1634	-3.0896e-002	3.9312e-002	6.e-003	-1.7809e-005
1635	-3.0896e-002	3.9312e-002	7.e-003	-1.7803e-005
1636	-3.0878e-002	3.9326e-002	8.0003e-003	-1.7788e-005
1637	-3.0857e-002	3.9342e-002	9.0016e-003	-1.777e-005
1638	-3.0853e-002	3.9345e-002	9.9957e-003	-1.7759e-005
1639	-3.0845e-002	3.9352e-002	1.0989e-002	-1.7756e-005
1640	-3.0855e-002	3.9344e-002	1.1989e-002	-1.7761e-005
1641	-3.0862e-002	3.9339e-002	1.2989e-002	-1.7769e-005
1642	-3.0868e-002	3.9334e-002	1.3993e-002	-1.7776e-005
1643	-3.0874e-002	3.9329e-002	1.4994e-002	-1.7783e-005
1644	-3.088e-002	3.9324e-002	1.5993e-002	-1.779e-005
1645	-3.0887e-002	3.9319e-002	1.6994e-002	-1.7798e-005
1646	-3.0892e-002	3.9315e-002	1.7991e-002	-1.7805e-005
1647	-3.09e-002	3.9309e-002	1.899e-002	-1.7813e-005
1648	-3.0903e-002	3.9307e-002	1.9993e-002	-1.7821e-005
1649	-3.091e-002	3.9301e-002	2.0996e-002	-1.7826e-005
1650	-3.0909e-002	3.9302e-002	2.2002e-002	-1.7827e-005
1651	-3.0909e-002	3.9302e-002	2.3006e-002	-1.7824e-005
1652	-3.0902e-002	3.9307e-002	2.4007e-002	-1.7817e-005
1653	-3.0897e-002	3.9311e-002	2.5e-002	-1.7809e-005
1654	-3.0887e-002	3.9319e-002	2.6002e-002	-1.7802e-005
1655	-3.0885e-002	3.932e-002	2.7001e-002	-1.7797e-005
1656	-3.0885e-002	3.932e-002	2.7999e-002	-1.7797e-005
1657	-3.0885e-002	3.932e-002	2.9e-002	-1.7796e-005
1658	-3.0885e-002	3.9321e-002	2.9999e-002	-1.7796e-005
1659	-3.0884e-002	3.9322e-002	3.1e-002	-1.7795e-005
1660	-3.0883e-002	3.9322e-002	3.1999e-002	-1.7797e-005
1661	-3.0889e-002	3.9318e-002	3.3e-002	-1.7798e-005
1662	-3.0886e-002	3.932e-002	3.4e-002	-1.7797e-005
1663	-3.0884e-002	3.9322e-002	3.5e-002	-1.7796e-005
1664	-3.0882e-002	3.9323e-002	3.6e-002	-1.7793e-005
1665	-3.0879e-002	3.9325e-002	3.7e-002	-1.779e-005
1666	-3.0877e-002	3.9327e-002	3.8e-002	-1.7788e-005
1667	-3.0875e-002	3.9329e-002	3.9e-002	-1.7788e-005
1668	-3.0879e-002	3.9325e-002	4.0995e-002	-1.7795e-005
1669	-3.0887e-002	3.9319e-002	4.1995e-002	-1.7801e-005
1670	-3.0899e-002	3.931e-002	4.3e-002	-1.7808e-005
1671	-3.0899e-002	3.931e-002	4.4e-002	-1.781e-005
1672	-3.0108e-002	3.9919e-002	4.4e-002	-1.6895e-005
1673	-2.9309e-002	4.0509e-002	4.4e-002	-1.5992e-005
1674	-2.8498e-002	4.1084e-002	4.4e-002	-1.5103e-005
1675	-2.7675e-002	4.1642e-002	4.4e-002	-1.4229e-005
1676	-2.6842e-002	4.2184e-002	4.4e-002	-1.3372e-005
1677	-2.5998e-002	4.271e-002	4.4e-002	-1.2533e-005
1678	-2.5143e-002	4.3218e-002	4.4e-002	-1.1712e-005
1679	-2.4279e-002	4.371e-002	4.4e-002	-1.0911e-005
1680	-2.3405e-002	4.4184e-002	4.4e-002	-1.0131e-005
1681	-2.2522e-002	4.464e-002	4.4e-002	-9.3734e-006
1682	-2.163e-002	4.5079e-002	4.4e-002	-8.6389e-006
1683	-2.073e-002	4.55e-002	4.4e-002	-7.9288e-006
1684	-1.9821e-002	4.5904e-002	4.4e-002	-7.2438e-006
1685	-1.8904e-002	4.6289e-002	4.4e-002	-6.5851e-006
1686	-1.798e-002	4.6655e-002	4.4e-002	-5.9534e-006
1687	-1.7049e-002	4.7003e-002	4.4e-002	-5.3497e-006
1688	-1.6111e-002	4.7333e-002	4.4e-002	-4.7749e-006
1689	-1.5167e-002	4.7644e-002	4.4e-002	-4.2297e-006
1690	-1.4217e-002	4.7936e-002	4.4e-002	-3.7148e-006
1691	-1.3261e-002	4.8209e-002	4.4e-002	-3.231e-006
1692	-1.23e-002	4.8464e-002	4.4e-002	-2.7789e-006
1693	-1.1334e-002	4.8699e-002	4.4e-002	-2.3592e-006
1694	-1.0363e-002	4.8914e-002	4.4e-002	-1.9724e-006
1695	-9.3886e-003	4.9111e-002	4.4e-002	-1.6191e-006
1696	-8.4103e-003	4.9288e-002	4.4e-002	-1.2997e-006
1697	-7.4288e-003	4.9445e-002	4.4e-002	-1.0147e-006
1698	-6.4442e-003	4.9583e-002	4.4e-002	-7.6452e-007
1699	-5.4571e-003	4.9701e-002	4.4e-002	-5.494e-007
1700	-4.4678e-003	4.98e-002	4.4e-002	-3.6969e-007
1701	-3.4769e-003	4.9879e-002	4.4e-002	-2.2563e-007
1702	-2.4844e-003	4.9938e-002	4.4e-002	-1.1741e-007
1703	-1.4911e-003	4.9978e-002	4.4e-002	-4.5178e-008
1704	-4.9707e-004	4.9998e-002	4.4e-002	-9.0382e-009
1705	4.9703e-004	4.9998e-002	4.4e-002	-9.0372e-009
1706	1.4911e-003	4.9978e-002	4.4e-002	-4.5175e-008
1707	2.4844e-003	4.9938e-002	4.4e-002	-1.174e-007
1708	3.4768e-003	4.9879e-002	4.4e-002	-2.2562e-007
1709	4.4678e-003	4.98e-002	4.4e-002	-3.6968e-007
1710	5.4571e-003	4.9701e-002	4.4e-002	-5.4939e-007
1711	6.4441e-003	4.9583e-002	4.4e-002	-7.645e-007
1712	7.4287e-003	4.9445e-002	4.4e-002	-1.0147e-006
1713	8.4103e-003	4.9288e-002	4.4e-002	-1.2997e-006
1714	9.3886e-003	4.9111e-002	4.4e-002	-1.6191e-006
1715	1.0363e-002	4.8914e-002	4.4e-002	-1.9724e-006
1716	1.1334e-002	4.8699e-002	4.4e-002	-2.3592e-006
1717	1.23e-002	4.8464e-002	4.4e-002	-2.7789e-006
1718	1.3261e-002	4.8209e-002	4.4e-002	-3.231e-006
1719	1.4217e-002	4.7936e-002	4.4e-002	-3.7148e-006
1720	1.5167e-002	4.7644e-002	4.4e-002	-4.2296e-006
1721	1.6111e-002	4.7333e-002	4.4e-002	-4.7749e-006
1722	1.7049e-002	4.7003e-002	4.4e-002	-5.3497e-006
1723	1.798e-002	4.6655e-002	4.4e-002	-5.9534e-006
1724	1.8904e-002	4.6289e-002	4.4e-002	-6.585e-006
1725	1.9821e-002	4.5904e-002	4.4e-002	-7.2438e-006
1726	2.073e-002	4.55e-002	4.4e-002	-7.9287e-006
1727	2.163e-002	4.5079e-002	4.4e-002	-8.6389e-006
1728	2.2522e-002	4.464e-002	4.4e-002	-9.3733e-006
1729	2.3405e-002	4.4184e-002	4.4e-002	-1.0131e-005
1730	2.4279e-002	4.371e-002	4.4e-002	-1.0911e-005
1731	2.5143e-002	4.3218e-002	4.4e-002	-1.1712e-005
1732	2.5998e-002	4.271e-002	4.4e-002	-1.2532e-005
1733	2.6842e-002	4.2184e-002	4.4e-002	-1.3372e-005
1734	2.7675e-002	4.1642e-002	4.4e-002	-1.4229e-005
1735	2.8497e-002	4.1084e-002	4.4e-002	-1.5103e-005
1736	2.9309e-002	4.0509e-002	4.4e-002	-1.5991e-005
1737	3.0108e-002	3.9918e-002	4.4e-002	-1.6894e-005
1738	3.0108e-002	3.9918e-002	7.0001e-003	-1.6895e-005
1739	2.9309e-002	4.0509e-002	7.e-003	-1.5992e-005
1740	2.8498e-002	4.1084e-002	7.e-003	-1.5103e-005
1741	2.7675e-002	4.1642e-002	7.e-003	-1.4229e-005
1742	2.6842e-002	4.2184e-002	7.e-003	-1.3372e-005
1743	2.5998e-002	4.271e-002	7.e-003	-1.2533e-005
1744	2.5143e-002	4.3218e-002	7.e-003	-1.1712e-005
1745	2.4279e-002	4.371e-002	7.e-003	-1.0911e-005
1746	2.3405e-002	4.4184e-002	7.e-003	-1.0131e-005
1747	2.2522e-002	4.464e-002	7.e-003	-9.3734e-006
1748	2.163e-002	4.5079e-002	7.e-003	-8.6389e-006
1749	2.073e-002	4.55e-002	7.e-003	-7.9288e-006
1750	1.9821e-002	4.5904e-002	7.e-003	-7.2438e-006
1751	1.8904e-002	4.6288e-002	7.e-003	-6.5851e-006
1752	1.798e-002	4.6655e-002	7.e-003	-5.9534e-006
1753	1.7049e-002	4.7003e-002	7.e-003	-5.3497e-006
1754	1.6111e-002	4.7333e-002	7.e-003	-4.7749e-006
1755	1.5167e-002	4.7644e-002	7.e-003	-4.2297e-006
1756	1.4217e-002	4.7936e-002	7.e-003	-3.7148e-006
1757	1.3261e-002	4.8209e-002	7.e-003	-3.231e-006
1758	1.23e-002	4.8464e-002	7.e-003	-2.7789e-006
1759	1.1334e-002	4.8699e-002	7.e-003	-2.3592e-006
1760	1.0363e-002	4.8914e-002	7.e-003	-1.9724e-006
1761	9.3887e-003	4.9111e-002	7.e-003	-1.6191e-006
1762	8.4103e-003	4.9288e-002	7.e-003	-1.2997e-006
1763	7.4288e-003	4.9445e-002	7.e-003	-1.0147e-006
1764	6.4442e-003	4.9583e-002	7.e-003	-7.6452e-007
1765	5.4571e-003	4.9701e-002	7.e-003	-5.494e-007
1766	4.4678e-003	4.98e-002	7.e-003	-3.6969e-007
1767	3.4769e-003	4.9879e-002	7.e-003	-2.2563e-007
1768	2.4844e-003	4.9938e-002	7.e-003	-1.1741e-007
1769	1.4911e-003	4.9978e-002	7.e-003	-4.5178e-008
1770	4.9709e-004	4.9998e-002	7.e-003	-9.0381e-009
1771	-4.9702e-004	4.9998e-002	7.e-003	-9.0373e-009
1772	-1.491e-003	4.9978e-002	7.e-003	-4.5175e-008
1773	-2.4844e-003	4.9938e-002	7.e-003	-1.174e-007
1774	-3.4768e-003	4.9879e-002	7.e-003	-2.2562e-007
1775	-4.4678e-003	4.98e-002	7.e-003	-3.6968e-007
1776	-5.4571e-003	4.9701e-002	7.e-003	-5.4939e-007
1777	-6.4441e-003	4.9583e-002	7.e-003	-7.645e-007
1778	-7.4287e-003	4.9445e-002	7.e-003	-1.0147e-006
1779	-8.4103e-003	4.9288e-002	7.e-003	-1.2997e-006
1780	-9.3886e-003	4.9111e-002	7.e-003	-1.6191e-006
1781	-1.0363e-002	4.8914e-002	7.e-003	-1.9724e-006
1782	-1.1334e-002	4.8699e-002	7.e-003	-2.3592e-006
1783	-1.23e-002	4.8464e-002	7.e-003	-2.7789e-006
1784	-1.3261e-002	4.8209e-002	7.e-003	-3.231e-006
1785	-1.4217e-002	4.7936e-002	7.e-003	-3.7148e-006
1786	-1.5167e-002	4.7644e-002	7.e-003	-4.2296e-006
1787	-1.6111e-002	4.7333e-002	7.e-003	-4.7749e-006
1788	-1.7049e-002	4.7003e-002	7.e-003	-5.3497e-006
1789	-1.798e-002	4.6655e-002	7.e-003	-5.9534e-006
1790	-1.8904e-002	4.6289e-002	7.e-003	-6.585e-006
1791	-1.9821e-002	4.5904e-002	7.e-003	-7.2438e-006
1792	-2.073e-002	4.55e-002	7.e-003	-7.9287e-006
1793	-2.163e-002	4.5079e-002	7.e-003	-8.6389e-006
1794	-2.2522e-002	4.464e-002	7.e-003	-9.3733e-006
1795	-2.3405e-002	4.4184e-002	7.e-003	-1.0131e-005
1796	-2.4279e-002	4.371e-002	7.e-003	-1.0911e-005
1797	-2.5143e-002	4.3218e-002	7.e-003	-1.171e-005
1798	-2.5992e-002	4.2713e-002	6.9929e-003	-1.2527e-005
1799	-2.6833e-002	4.219e-002	6.9778e-003	-1.3362e-005
1800	-2.7665e-002	4.1649e-002	6.969e-003	-1.4217e-005
1801	-2.8487e-002	4.1091e-002	6.9664e-003	-1.509e-005
1802	-2.9301e-002	4.0515e-002	6.9722e-003	-1.598e-005
1803	-3.0104e-002	3.9922e-002	6.9927e-003	-1.6885e-005
1804	-3.0084e-002	3.9937e-002	7.9964e-003	-1.6867e-005
1805	-3.0065e-002	3.9951e-002	8.9889e-003	-1.6846e-005
1806	-3.0047e-002	3.9965e-002	9.9867e-003	-1.6831e-005
1807	-3.0043e-002	3.9968e-002	1.0988e-002	-1.6826e-005
1808	-3.0049e-002	3.9964e-002	1.1992e-002	-1.6829e-005
1809	-3.0054e-002	3.996e-002	1.2994e-002	-1.6836e-005
1810	-3.0062e-002	3.9954e-002	1.3998e-002	-1.6843e-005
1811	-3.0068e-002	3.9949e-002	1.4995e-002	-1.6852e-005
1812	-3.008e-002	3.994e-002	1.5994e-002	-1.6862e-005
1813	-3.0088e-002	3.9934e-002	1.6988e-002	-1.6874e-005
1814	-3.01e-002	3.9925e-002	1.7985e-002	-1.6888e-005
1815	-3.0116e-002	3.9913e-002	1.8986e-002	-1.6905e-005
1816	-3.0134e-002	3.9899e-002	1.9987e-002	-1.6923e-005
1817	-3.0148e-002	3.9889e-002	2.0995e-002	-1.6935e-005
1818	-3.015e-002	3.9887e-002	2.2008e-002	-1.6937e-005
1819	-3.0137e-002	3.9897e-002	2.3015e-002	-1.6928e-005
1820	-3.0126e-002	3.9905e-002	2.4016e-002	-1.6913e-005
1821	-3.0108e-002	3.9919e-002	2.5012e-002	-1.6897e-005
1822	-3.0097e-002	3.9927e-002	2.6005e-002	-1.6883e-005
1823	-3.0086e-002	3.9935e-002	2.6998e-002	-1.6875e-005
1824	-3.0087e-002	3.9935e-002	2.7998e-002	-1.6872e-005
1825	-3.0088e-002	3.9933e-002	2.8996e-002	-1.6873e-005
1826	-3.0086e-002	3.9935e-002	3.e-002	-1.6871e-005
1827	-3.0083e-002	3.9937e-002	3.0997e-002	-1.6871e-005
1828	-3.0091e-002	3.9932e-002	3.1997e-002	-1.6873e-005
1829	-3.0092e-002	3.9931e-002	3.2997e-002	-1.6875e-005
1830	-3.0089e-002	3.9933e-002	3.3998e-002	-1.6874e-005
1831	-3.0085e-002	3.9936e-002	3.4998e-002	-1.6872e-005
1832	-3.009e-002	3.9932e-002	3.5997e-002	-1.6871e-005
1833	-3.0082e-002	3.9938e-002	3.6996e-002	-1.6869e-005
1834	-3.0083e-002	3.9938e-002	3.7996e-002	-1.6868e-005
1835	-3.0083e-002	3.9937e-002	3.8995e-002	-1.6869e-005
1836	-3.0085e-002	3.9936e-002	3.9994e-002	-1.6872e-005
1837	-3.0091e-002	3.9932e-002	4.0993e-002	-1.6877e-005
1838	-3.01e-002	3.9925e-002	4.1998e-002	-1.6885e-005
1839	-3.0108e-002	3.9919e-002	4.3e-002	-1.6892e-005
1840	-2.9309e-002	4.0509e-002	4.3e-002	-1.599e-005
1841	-2.8498e-002	4.1084e-002	4.3e-002	-1.5102e-005
1842	-2.6842e-002	4.2184e-002	4.3e-002	-1.3372e-005
1843	-2.5998e-002	4.271e-002	4.3e-002	-1.2533e-005
1844	-2.5143e-002	4.3218e-002	4.3e-002	-1.1712e-005
1845	-2.4279e-002	4.371e-002	4.3e-002	-1.0911e-005
1846	-2.3405e-002	4.4184e-002	4.3e-002	-1.0131e-005
1847	-2.2522e-002	4.464e-002	4.3e-002	-9.3734e-006
1848	-2.163e-002	4.5079e-002	4.3e-002	-8.6389e-006
1849	-2.073e-002	4.55e-002	4.3e-002	-7.9288e-006
1850	-1.9821e-002	4.5904e-002	4.3e-002	-7.2438e-006
1851	-1.8904e-002	4.6288e-002	4.3e-002	-6.5851e-006
1852	-1.798e-002	4.6655e-002	4.3e-002	-5.9534e-006
1853	-1.7049e-002	4.7003e-002	4.3e-002	-5.3497e-006
1854	-1.6111e-002	4.7333e-002	4.3e-002	-4.7749e-006
1855	-1.5167e-002	4.7644e-002	4.3e-002	-4.2297e-006
1856	-1.4217e-002	4.7936e-002	4.3e-002	-3.7148e-006
1857	-1.3261e-002	4.8209e-002	4.3e-002	-3.231e-006
1858	-1.23e-002	4.8464e-002	4.3e-002	-2.7789e-006
1859	-1.1334e-002	4.8699e-002	4.3e-002	-2.3592e-006
1860	-1.0363e-002	4.8914e-002	4.3e-002	-1.9724e-006
1861	-9.3887e-003	4.9111e-002	4.3e-002	-1.6191e-006
1862	-8.4103e-003	4.9288e-002	4.3e-002	-1.2997e-006
1863	-7.4288e-003	4.9445e-002	4.3e-002	-1.0147e-006
1864	-6.4442e-003	4.9583e-002	4.3e-002	-7.6452e-007
1865	-5.4571e-003	4.9701e-002	4.3e-002	-5.494e-007
1866	-4.4678e-003	4.98e-002	4.3e-002	-3.6969e-007
1867	-3.4769e-003	4.9879e-002	4.3e-002	-2.2563e-007
1868	-2.4844e-003	4.9938e-002	4.3e-002	-1.1741e-007
1869	-1.4911e-003	4.9978e-002	4.3e-002	-4.5178e-008
1870	-4.971e-004	4.9998e-002	4.3e-002	-9.0383e-009
1871	4.9702e-004	4.9998e-002	4.3e-002	-9.0371e-009
1872	1.491e-003	4.9978e-002	4.3e-002	-4.5174e-008
1873	2.4844e-003	4.9938e-002	4.3e-002	-1.174e-007
1874	3.4768e-003	4.9879e-002	4.3e-002	-2.2562e-007
1875	4.4678e-003	4.98e-002	4.3e-002	-3.6968e-007
1876	5.457e-003	4.9701e-002	4.3e-002	-5.4939e-007
1877	6.4441e-003	4.9583e-002	4.3e-002	-7.645e-007
1878	7.4287e-003	4.9445e-002	4.3e-002	-1.0147e-006
1879	8.4103e-003	4.9288e-002	4.3e-002	-1.2997e-006
1880	9.3886e-003	4.9111e-002	4.3e-002	-1.6191e-006
1881	1.0363e-002	4.8914e-002	4.3e-002	-1.9724e-006
1882	1.1334e-002	4.8699e-002	4.3e-002	-2.3592e-006
1883	1.23e-002	4.8464e-002	4.3e-002	-2.7789e-006
1884	1.3261e-002	4.8209e-002	4.3e-002	-3.231e-006
1885	1.4217e-002	4.7936e-002	4.3e-002	-3.7148e-006
1886	1.5167e-002	4.7644e-002	4.3e-002	-4.2296e-006
1887	1.6111e-002	4.7333e-002	4.3e-002	-4.7749e-006
1888	1.7049e-002	4.7003e-002	4.3e-002	-5.3497e-006
1889	1.798e-002	4.6655e-002	4.3e-002	-5.9534e-006
1890	1.8904e-002	4.6289e-002	4.3e-002	-6.585e-006
1891	1.9821e-002	4.5904e-002	4.3e-002	-7.2438e-006
1892	2.073e-002	4.55e-002	4.3e-002	-7.9287e-006
1893	2.163e-002	4.5079e-002	4.3e-002	-8.6389e-006
1894	2.2522e-002	4.464e-002	4.3e-002	-9.3733e-006
1895	2.3405e-002	4.4184e-002	4.3e-002	-1.0131e-005
1896	2.4279e-002	4.371e-002	4.3e-002	-1.0911e-005
1897	2.5143e-002	4.3218e-002	4.3e-002	-1.1712e-005
1898	2.5998e-002	4.271e-002	4.3e-002	-1.2532e-005
1899	2.6842e-002	4.2184e-002	4.3e-002	-1.3372e-005
1900	2.7675e-002	4.1642e-002	4.3e-002	-1.4229e-005
1901	2.8497e-002	4.1084e-002	4.3e-002	-1.5103e-005
1902	2.9309e-002	4.0509e-002	4.3e-002	-1.5991e-005
1903	3.0108e-002	3.9918e-002	4.3e-002	-1.6894e-005
1904	3.0108e-002	3.9918e-002	4.2e-002	-1.6894e-005
1905	3.0108e-002	3.9918e-002	4.1e-002	-1.6894e-005
1906	3.0108e-002	3.9918e-002	4.e-002	-1.6894e-005
1907	3.0109e-002	3.9918e-002	3.9e-002	-1.6894e-005
1908	3.0109e-002	3.9918e-002	3.8e-002	-1.6894e-005
1909	3.0109e-002	3.9918e-002	3.7e-002	-1.6894e-005
1910	3.0109e-002	3.9918e-002	3.6e-002	-1.6894e-005
1911	3.0109e-002	3.9918e-002	3.5e-002	-1.6894e-005
1912	3.0109e-002	3.9918e-002	3.4e-002	-1.6894e-005
1913	3.0109e-002	3.9918e-002	3.3e-002	-1.6894e-005
1914	3.0109e-002	3.9918e-002	3.2e-002	-1.6894e-005
1915	3.0109e-002	3.9918e-002	3.1e-002	-1.6894e-005
1916	3.0109e-002	3.9918e-002	3.e-002	-1.6894e-005
1917	3.0109e-002	3.9918e-002	2.9e-002	-1.6894e-005
1918	3.0109e-002	3.9918e-002	2.8e-002	-1.6894e-005
1919	3.0109e-002	3.9918e-002	2.7e-002	-1.6894e-005
1920	3.0109e-002	3.9918e-002	2.6e-002	-1.6895e-005
1921	3.0109e-002	3.9918e-002	2.5e-002	-1.6895e-005
1922	3.0109e-002	3.9918e-002	2.4e-002	-1.6895e-005
1923	3.0109e-002	3.9918e-002	2.3e-002	-1.6895e-005
1924	3.0109e-002	3.9918e-002	2.2e-002	-1.6895e-005
1925	3.0109e-002	3.9918e-002	2.1e-002	-1.6895e-005
1926	3.0109e-002	3.9918e-002	2.e-002	-1.6895e-005
1927	3.0109e-002	3.9918e-002	1.9e-002	-1.6895e-005
1928	3.0109e-002	3.9918e-002	1.8e-002	-1.6895e-005
1929	3.0109e-002	3.9918e-002	1.7e-002	-1.6895e-005
1930	3.0109e-002	3.9918e-002	1.6e-002	-1.6895e-005
1931	3.0109e-002	3.9918e-002	1.5e-002	-1.6895e-005
1932	3.0109e-002	3.9918e-002	1.4e-002	-1.6895e-005
1933	3.0109e-002	3.9918e-002	1.3e-002	-1.6895e-005
1934	3.0109e-002	3.9918e-002	1.2e-002	-1.6895e-005
1935	3.0109e-002	3.9918e-002	1.1e-002	-1.6895e-005
1936	3.0109e-002	3.9918e-002	1.e-002	-1.6895e-005
1937	3.0109e-002	3.9918e-002	9.e-003	-1.6895e-005
1938	3.0109e-002	3.9918e-002	8.e-003	-1.6895e-005
1939	-2.9301e-002	4.0515e-002	4.1998e-002	-1.5984e-005
1940	-2.8493e-002	4.1087e-002	4.2002e-002	-1.5099e-005
1941	-2.7675e-002	4.1642e-002	4.2e-002	-1.4228e-005
1942	-2.6842e-002	4.2184e-002	4.2e-002	-1.3372e-005
1943	-2.5998e-002	4.271e-002	4.2e-002	-1.2533e-005
1944	-2.5143e-002	4.3218e-002	4.2e-002	-1.1712e-005
1945	-2.4279e-002	4.371e-002	4.2e-002	-1.0911e-005
1946	-2.3405e-002	4.4184e-002	4.2e-002	-1.0131e-005
1947	-2.2522e-002	4.464e-002	4.2e-002	-9.3734e-006
1948	-2.163e-002	4.5079e-002	4.2e-002	-8.639e-006
1949	-2.073e-002	4.55e-002	4.2e-002	-7.9288e-006
1950	-1.9821e-002	4.5904e-002	4.2e-002	-7.2438e-006
1951	-1.8904e-002	4.6288e-002	4.2e-002	-6.5851e-006
1952	-1.798e-002	4.6655e-002	4.2e-002	-5.9534e-006
1953	-1.7049e-002	4.7003e-002	4.2e-002	-5.3497e-006
1954	-1.6111e-002	4.7333e-002	4.2e-002	-4.7749e-006
1955	-1.5167e-002	4.7644e-002	4.2e-002	-4.2297e-006
1956	-1.4217e-002	4.7936e-002	4.2e-002	-3.7148e-006
1957	-1.3261e-002	4.8209e-002	4.2e-002	-3.231e-006
1958	-1.23e-002	4.8464e-002	4.2e-002	-2.7789e-006
1959	-1.1334e-002	4.8699e-002	4.2e-002	-2.3592e-006
1960	-1.0363e-002	4.8914e-002	4.2e-002	-1.9724e-006
1961	-9.3887e-003	4.9111e-002	4.2e-002	-1.6191e-006
1962	-8.4103e-003	4.9288e-002	4.2e-002	-1.2997e-006
1963	-7.4288e-003	4.9445e-002	4.2e-002	-1.0147e-006
1964	-6.4442e-003	4.9583e-002	4.2e-002	-7.6452e-007
1965	-5.4571e-003	4.9701e-002	4.2e-002	-5.494e-007
1966	-4.4678e-003	4.98e-002	4.2e-002	-3.6969e-007
1967	-3.4769e-003	4.9879e-002	4.2e-002	-2.2563e-007
1968	-2.4844e-003	4.9938e-002	4.2e-002	-1.1741e-007
1969	-1.4911e-003	4.9978e-002	4.2e-002	-4.5178e-008
1970	-4.9708e-004	4.9998e-002	4.2e-002	-9.0383e-009
1971	4.9702e-004	4.9998e-002	4.2e-002	-9.037e-009
1972	1.491e-003	4.9978e-002	4.2e-002	-4.5174e-008
1973	2.4844e-003	4.9938e-002	4.2e-002	-1.174e-007
1974	3.4768e-003	4.9879e-002	4.2e-002	-2.2562e-007
1975	4.4678e-003	4.98e-002	4.2e-002	-3.6968e-007
1976	5.4571e-003	4.9701e-002	4.2e-002	-5.4939e-007
1977	6.4441e-003	4.9583e-002	4.2e-002	-7.645e-007
1978	7.4287e-003	4.9445e-002	4.2e-002	-1.0147e-006
1979	8.4103e-003	4.9288e-002	4.2e-002	-1.2997e-006
1980	9.3886e-003	4.9111e-002	4.2e-002	-1.6191e-006
1981	1.0363e-002	4.8914e-002	4.2e-002	-1.9724e-006
1982	1.1334e-002	4.8699e-002	4.2e-002	-2.3592e-006
1983	1.23e-002	4.8464e-002	4.2e-002	-2.7789e-006
1984	1.3261e-002	4.8209e-002	4.2e-002	-3.231e-006
1985	1.4217e-002	4.7936e-002	4.2e-002	-3.7148e-006
1986	1.5167e-002	4.7644e-002	4.2e-002	-4.2296e-006
1987	1.6111e-002	4.7333e-002	4.2e-002	-4.7749e-006
1988	1.7049e-002	4.7003e-002	4.2e-002	-5.3497e-006
1989	1.798e-002	4.6655e-002	4.2e-002	-5.9534e-006
1990	1.8904e-002	4.6289e-002	4.2e-002	-6.585e-006
1991	1.9821e-002	4.5904e-002	4.2e-002	-7.2438e-006
1992	2.073e-002	4.55e-002	4.2e-002	-7.9287e-006
1993	2.163e-002	4.5079e-002	4.2e-002	-8.6389e-006
1994	2.2522e-002	4.464e-002	4.2e-002	-9.3733e-006
1995	2.3405e-002	4.4184e-002	4.2e-002	-1.0131e-005
1996	2.4279e-002	4.371e-002	4.2e-002	-1.0911e-005
1997	2.5143e-002	4.3218e-002	4.2e-002	-1.1712e-005
1998	2.5998e-002	4.271e-002	4.2e-002	-1.2532e-005
1999	2.6842e-002	4.2184e-002	4.2e-002	-1.3372e-005
2000	2.7675e-002	4.1642e-002	4.2e-002	-1.4229e-005
2001	2.8497e-002	4.1084e-002	4.2e-002	-1.5103e-005
2002	2.9309e-002	4.0509e-002	4.2e-002	-1.5991e-005
2003	2.9309e-002	4.0509e-002	4.1e-002	-1.5992e-005
2004	2.9309e-002	4.0509e-002	4.e-002	-1.5992e-005
2005	2.9309e-002	4.0509e-002	3.9e-002	-1.5992e-005
2006	2.9309e-002	4.0509e-002	3.8e-002	-1.5992e-005
2007	2.9309e-002	4.0509e-002	3.7e-002	-1.5992e-005
2008	2.9309e-002	4.0509e-002	3.6e-002	-1.5992e-005
2009	2.9309e-002	4.0509e-002	3.5e-002	-1.5992e-005
2010	2.9309e-002	4.0509e-002	3.4e-002	-1.5992e-005
2011	2.9309e-002	4.0509e-002	3.3e-002	-1.5992e-005
2012	2.9309e-002	4.0509e-002	3.2e-002	-1.5992e-005
2013	2.9309e-002	4.0509e-002	3.e-002	-1.5992e-005
2014	2.9309e-002	4.0509e-002	2.8e-002	-1.5992e-005
2015	2.9309e-002	4.0509e-002	2.6e-002	-1.5992e-005
2016	2.9309e-002	4.0509e-002	2.4e-002	-1.5992e-005
2017	2.9309e-002	4.0509e-002	2.2e-002	-1.5992e-005
2018	2.9309e-002	4.0509e-002	2.e-002	-1.5992e-005
2019	2.9309e-002	4.0509e-002	1.8e-002	-1.5993e-005
2020	2.9309e-002	4.0509e-002	1.6e-002	-1.5993e-005
2021	2.9309e-002	4.0509e-002	1.4e-002	-1.5993e-005
2022	2.9309e-002	4.0509e-002	1.3e-002	-1.5993e-005
2023	2.931e-002	4.0509e-002	1.2e-002	-1.5993e-005
2024	2.931e-002	4.0509e-002	1.1e-002	-1.5993e-005
2025	2.931e-002	4.0509e-002	9.9999e-003	-1.5993e-005
2026	2.931e-002	4.0509e-002	8.9999e-003	-1.5993e-005
2027	2.931e-002	4.0508e-002	7.9999e-003	-1.5992e-005
2028	2.8498e-002	4.1084e-002	8.e-003	-1.5104e-005
2029	2.7675e-002	4.1642e-002	8.e-003	-1.423e-005
2030	2.5998e-002	4.271e-002	8.e-003	-1.2533e-005
2031	2.4279e-002	4.371e-002	8.e-003	-1.0911e-005
2032	2.2522e-002	4.464e-002	8.e-003	-9.3734e-006
2033	2.073e-002	4.55e-002	8.e-003	-7.9288e-006
2034	1.8904e-002	4.6289e-002	8.e-003	-6.5851e-006
2035	1.7049e-002	4.7003e-002	8.e-003	-5.3497e-006
2036	1.5167e-002	4.7644e-002	8.e-003	-4.2297e-006
2037	1.3261e-002	4.8209e-002	8.e-003	-3.231e-006
2038	1.1334e-002	4.8699e-002	8.e-003	-2.3592e-006
2039	9.3886e-003	4.9111e-002	8.e-003	-1.6191e-006
2040	7.4287e-003	4.9445e-002	8.e-003	-1.0147e-006
2041	5.4571e-003	4.9701e-002	8.e-003	-5.494e-007
2042	3.4768e-003	4.9879e-002	8.e-003	-2.2563e-007
2043	1.4911e-003	4.9978e-002	8.e-003	-4.5178e-008
2044	-4.9704e-004	4.9998e-002	8.e-003	-9.0372e-009
2045	-2.4844e-003	4.9938e-002	8.e-003	-1.174e-007
2046	-4.4678e-003	4.98e-002	8.e-003	-3.6968e-007
2047	-6.4441e-003	4.9583e-002	8.e-003	-7.645e-007
2048	-8.4103e-003	4.9288e-002	8.e-003	-1.2997e-006
2049	-1.0363e-002	4.8914e-002	8.e-003	-1.9724e-006
2050	-1.23e-002	4.8464e-002	8.e-003	-2.7789e-006
2051	-1.4217e-002	4.7936e-002	8.e-003	-3.7148e-006
2052	-1.6111e-002	4.7333e-002	8.e-003	-4.7749e-006
2053	-1.798e-002	4.6655e-002	8.e-003	-5.9534e-006
2054	-1.9821e-002	4.5904e-002	8.e-003	-7.2438e-006
2055	-2.163e-002	4.5079e-002	8.e-003	-8.6389e-006
2056	-2.3405e-002	4.4184e-002	8.e-003	-1.0131e-005
2057	-2.5143e-002	4.3218e-002	8.e-003	-1.1708e-005
2058	-2.682e-002	4.2198e-002	7.9663e-003	-1.3353e-005
2059	-2.7651e-002	4.1659e-002	7.954e-003	-1.4204e-005
2060	-2.8472e-002	4.1102e-002	7.9551e-003	-1.5074e-005
2061	-2.9282e-002	4.0528e-002	7.9677e-003	-1.5962e-005
2062	-2.926e-002	4.0545e-002	8.9743e-003	-1.5941e-005
2063	-2.8451e-002	4.1116e-002	8.9602e-003	-1.5056e-005
2064	-2.9244e-002	4.0556e-002	9.9807e-003	-1.5926e-005
2065	-2.9243e-002	4.0557e-002	1.0988e-002	-1.592e-005
2066	-2.9244e-002	4.0556e-002	1.1995e-002	-1.5922e-005
2067	-2.9247e-002	4.0553e-002	1.3e-002	-1.5924e-005
2068	-2.925e-002	4.0551e-002	1.4003e-002	-1.5928e-005
2069	-2.9259e-002	4.0545e-002	1.4999e-002	-1.5937e-005
2070	-2.9271e-002	4.0537e-002	1.5995e-002	-1.595e-005
2071	-2.9307e-002	4.0511e-002	1.7993e-002	-1.5989e-005
2072	-2.9354e-002	4.0476e-002	2.0001e-002	-1.604e-005
2073	-2.9378e-002	4.0459e-002	2.2018e-002	-1.6063e-005
2074	-2.9337e-002	4.0489e-002	2.4025e-002	-1.6026e-005
2075	-2.9298e-002	4.0517e-002	2.6007e-002	-1.5983e-005
2076	-2.9283e-002	4.0528e-002	2.7997e-002	-1.5967e-005
2077	-2.9284e-002	4.0527e-002	2.9996e-002	-1.5967e-005
2078	-2.9284e-002	4.0527e-002	3.0996e-002	-1.5965e-005
2079	-2.9284e-002	4.0527e-002	3.1995e-002	-1.5966e-005
2080	-2.9286e-002	4.0526e-002	3.2995e-002	-1.5968e-005
2081	-2.9288e-002	4.0525e-002	3.3995e-002	-1.5968e-005
2082	-2.9287e-002	4.0525e-002	3.4995e-002	-1.5968e-005
2083	-2.9286e-002	4.0526e-002	3.5995e-002	-1.5968e-005
2084	-2.9286e-002	4.0525e-002	3.6995e-002	-1.5967e-005
2085	-2.9288e-002	4.0525e-002	3.7995e-002	-1.5968e-005
2086	-2.9289e-002	4.0523e-002	3.8995e-002	-1.597e-005
2087	-2.9293e-002	4.0521e-002	3.9998e-002	-1.5974e-005
2088	-2.9297e-002	4.0518e-002	4.0999e-002	-1.5978e-005
2089	2.8497e-002	4.1084e-002	4.1e-002	-1.5103e-005
2090	2.7675e-002	4.1642e-002	4.1e-002	-1.4229e-005
2091	2.8497e-002	4.1084e-002	4.e-002	-1.5103e-005
2092	2.8497e-002	4.1084e-002	3.9e-002	-1.5103e-005
2093	2.8498e-002	4.1084e-002	3.8e-002	-1.5103e-005
2094	2.8498e-002	4.1084e-002	3.7e-002	-1.5103e-005
2095	2.8498e-002	4.1084e-002	3.6e-002	-1.5103e-005
2096	2.8498e-002	4.1084e-002	3.5e-002	-1.5103e-005
2097	2.8498e-002	4.1084e-002	3.4e-002	-1.5103e-005
2098	2.8498e-002	4.1083e-002	3.3e-002	-1.5103e-005
2099	2.8498e-002	4.1083e-002	3.2e-002	-1.5103e-005
2100	2.8498e-002	4.1083e-002	3.1e-002	-1.5103e-005
2101	2.8499e-002	4.1083e-002	3.e-002	-1.5103e-005
2102	2.8499e-002	4.1083e-002	2.9e-002	-1.5103e-005
2103	2.8499e-002	4.1083e-002	2.8e-002	-1.5103e-005
2104	2.8499e-002	4.1083e-002	2.7e-002	-1.5103e-005
2105	2.8499e-002	4.1083e-002	2.6e-002	-1.5103e-005
2106	2.8499e-002	4.1083e-002	2.5e-002	-1.5103e-005
2107	2.8499e-002	4.1083e-002	2.4e-002	-1.5103e-005
2108	2.8499e-002	4.1083e-002	2.3e-002	-1.5103e-005
2109	2.85e-002	4.1083e-002	2.2e-002	-1.5103e-005
2110	2.85e-002	4.1082e-002	2.1e-002	-1.5103e-005
2111	2.85e-002	4.1082e-002	2.e-002	-1.5103e-005
2112	2.85e-002	4.1082e-002	1.9e-002	-1.5103e-005
2113	2.85e-002	4.1082e-002	1.8e-002	-1.5103e-005
2114	2.85e-002	4.1082e-002	1.7e-002	-1.5103e-005
2115	2.85e-002	4.1082e-002	1.6e-002	-1.5103e-005
2116	2.85e-002	4.1082e-002	1.5e-002	-1.5103e-005
2117	2.85e-002	4.1082e-002	1.4e-002	-1.5103e-005
2118	2.8501e-002	4.1082e-002	1.3e-002	-1.5103e-005
2119	2.8501e-002	4.1082e-002	1.2e-002	-1.5103e-005
2120	2.8501e-002	4.1082e-002	1.1e-002	-1.5104e-005
2121	2.8501e-002	4.1082e-002	9.9998e-003	-1.5104e-005
2122	2.8501e-002	4.1082e-002	8.9998e-003	-1.5104e-005
2123	2.7675e-002	4.1642e-002	9.e-003	-1.4229e-005
2124	2.6842e-002	4.2184e-002	9.e-003	-1.3372e-005
2125	2.5998e-002	4.271e-002	9.e-003	-1.2533e-005
2126	2.5143e-002	4.3218e-002	9.e-003	-1.1712e-005
2127	2.4279e-002	4.371e-002	9.e-003	-1.0911e-005
2128	2.3405e-002	4.4184e-002	9.e-003	-1.0131e-005
2129	2.2522e-002	4.464e-002	9.e-003	-9.3734e-006
2130	2.163e-002	4.5079e-002	9.e-003	-8.639e-006
2131	2.073e-002	4.55e-002	9.e-003	-7.9288e-006
2132	1.9821e-002	4.5904e-002	9.e-003	-7.2438e-006
2133	1.8904e-002	4.6288e-002	9.e-003	-6.5851e-006
2134	1.798e-002	4.6655e-002	9.e-003	-5.9534e-006
2135	1.7049e-002	4.7003e-002	9.e-003	-5.3497e-006
2136	1.6111e-002	4.7333e-002	9.e-003	-4.7749e-006
2137	1.5167e-002	4.7644e-002	9.e-003	-4.2297e-006
2138	1.4217e-002	4.7936e-002	9.e-003	-3.7148e-006
2139	1.3261e-002	4.8209e-002	9.e-003	-3.231e-006
2140	1.23e-002	4.8464e-002	9.e-003	-2.7789e-006
2141	1.1334e-002	4.8699e-002	9.e-003	-2.3592e-006
2142	1.0363e-002	4.8914e-002	9.e-003	-1.9724e-006
2143	9.3887e-003	4.9111e-002	9.e-003	-1.6191e-006
2144	8.4103e-003	4.9288e-002	9.e-003	-1.2997e-006
2145	7.4288e-003	4.9445e-002	9.e-003	-1.0147e-006
2146	6.4442e-003	4.9583e-002	9.e-003	-7.6452e-007
2147	5.4571e-003	4.9701e-002	9.e-003	-5.494e-007
2148	4.4678e-003	4.98e-002	9.e-003	-3.6969e-007
2149	3.4769e-003	4.9879e-002	9.e-003	-2.2563e-007
2150	2.4844e-003	4.9938e-002	9.e-003	-1.1741e-007
2151	1.4911e-003	4.9978e-002	9.e-003	-4.5178e-008
2152	4.9709e-004	4.9998e-002	9.e-003	-9.0382e-009
2153	-4.9701e-004	4.9998e-002	9.e-003	-9.0371e-009
2154	-1.491e-003	4.9978e-002	9.e-003	-4.5175e-008
2155	-2.4843e-003	4.9938e-002	9.e-003	-1.174e-007
2156	-3.4768e-003	4.9879e-002	9.e-003	-2.2562e-007
2157	-4.4678e-003	4.98e-002	9.e-003	-3.6968e-007
2158	-5.4571e-003	4.9701e-002	9.e-003	-5.4939e-007
2159	-6.4441e-003	4.9583e-002	9.e-003	-7.645e-007
2160	-7.4287e-003	4.9445e-002	9.e-003	-1.0147e-006
2161	-8.4102e-003	4.9288e-002	9.e-003	-1.2997e-006
2162	-9.3886e-003	4.9111e-002	9.e-003	-1.6191e-006
2163	-1.0363e-002	4.8914e-002	9.e-003	-1.9724e-006
2164	-1.1334e-002	4.8699e-002	9.e-003	-2.3592e-006
2165	-1.23e-002	4.8464e-002	9.e-003	-2.7789e-006
2166	-1.3261e-002	4.8209e-002	9.e-003	-3.231e-006
2167	-1.4217e-002	4.7936e-002	9.e-003	-3.7148e-006
2168	-1.5167e-002	4.7644e-002	9.e-003	-4.2296e-006
2169	-1.6111e-002	4.7333e-002	9.e-003	-4.7749e-006
2170	-1.7049e-002	4.7003e-002	9.e-003	-5.3497e-006
2171	-1.798e-002	4.6655e-002	9.e-003	-5.9534e-006
2172	-1.8904e-002	4.6289e-002	9.e-003	-6.585e-006
2173	-1.9821e-002	4.5904e-002	9.e-003	-7.2438e-006
2174	-2.073e-002	4.55e-002	9.e-003	-7.9287e-006
2175	-2.163e-002	4.5079e-002	9.e-003	-8.6389e-006
2176	-2.2522e-002	4.464e-002	9.e-003	-9.3733e-006
2177	-2.3405e-002	4.4184e-002	9.e-003	-1.0131e-005
2178	-2.4279e-002	4.371e-002	9.e-003	-1.0909e-005
2179	-2.5135e-002	4.3223e-002	8.9959e-003	-1.1705e-005
2180	-2.5981e-002	4.272e-002	8.988e-003	-1.2515e-005
2181	-2.6811e-002	4.2204e-002	8.9643e-003	-1.3343e-005
2182	-2.7638e-002	4.1667e-002	8.9609e-003	-1.419e-005
2183	-2.8438e-002	4.1125e-002	9.9704e-003	-1.5043e-005
2184	-2.8435e-002	4.1127e-002	1.0985e-002	-1.5038e-005
2185	-2.8488e-002	4.109e-002	4.1002e-002	-1.5096e-005
2186	-2.7675e-002	4.1642e-002	4.1e-002	-1.4227e-005
2187	-2.6842e-002	4.2184e-002	4.1e-002	-1.3372e-005
2188	-2.5998e-002	4.271e-002	4.1e-002	-1.2533e-005
2189	-2.5143e-002	4.3218e-002	4.1e-002	-1.1712e-005
2190	-2.4279e-002	4.371e-002	4.1e-002	-1.0911e-005
2191	-2.3405e-002	4.4184e-002	4.1e-002	-1.0131e-005
2192	-2.2522e-002	4.464e-002	4.1e-002	-9.3734e-006
2193	-2.163e-002	4.5079e-002	4.1e-002	-8.639e-006
2194	-2.073e-002	4.55e-002	4.1e-002	-7.9288e-006
2195	-1.9821e-002	4.5904e-002	4.1e-002	-7.2438e-006
2196	-1.8904e-002	4.6288e-002	4.1e-002	-6.5851e-006
2197	-1.798e-002	4.6655e-002	4.1e-002	-5.9534e-006
2198	-1.7049e-002	4.7003e-002	4.1e-002	-5.3498e-006
2199	-1.6111e-002	4.7333e-002	4.1e-002	-4.7749e-006
2200	-1.5167e-002	4.7644e-002	4.1e-002	-4.2297e-006
2201	-1.4217e-002	4.7936e-002	4.1e-002	-3.7148e-006
2202	-1.3261e-002	4.8209e-002	4.1e-002	-3.231e-006
2203	-1.23e-002	4.8464e-002	4.1e-002	-2.7789e-006
2204	-1.1334e-002	4.8699e-002	4.1e-002	-2.3592e-006
2205	-1.0363e-002	4.8914e-002	4.1e-002	-1.9724e-006
2206	-9.3887e-003	4.9111e-002	4.1e-002	-1.6191e-006
2207	-8.4103e-003	4.9288e-002	4.1e-002	-1.2997e-006
2208	-7.4288e-003	4.9445e-002	4.1e-002	-1.0147e-006
2209	-6.4442e-003	4.9583e-002	4.1e-002	-7.6452e-007
2210	-5.4571e-003	4.9701e-002	4.1e-002	-5.494e-007
2211	-4.4678e-003	4.98e-002	4.1e-002	-3.6969e-007
2212	-3.4769e-003	4.9879e-002	4.1e-002	-2.2563e-007
2213	-2.4844e-003	4.9938e-002	4.1e-002	-1.1741e-007
2214	-1.4911e-003	4.9978e-002	4.1e-002	-4.5178e-008
2215	-4.971e-004	4.9998e-002	4.1e-002	-9.0384e-009
2216	4.9702e-004	4.9998e-002	4.1e-002	-9.037e-009
2217	1.491e-003	4.9978e-002	4.1e-002	-4.5174e-008
2218	2.4844e-003	4.9938e-002	4.1e-002	-1.174e-007
2219	3.4768e-003	4.9879e-002	4.1e-002	-2.2562e-007
2220	4.4678e-003	4.98e-002	4.1e-002	-3.6968e-007
2221	5.457e-003	4.9701e-002	4.1e-002	-5.4939e-007
2222	6.4441e-003	4.9583e-002	4.1e-002	-7.645e-007
2223	7.4287e-003	4.9445e-002	4.1e-002	-1.0147e-006
2224	8.4103e-003	4.9288e-002	4.1e-002	-1.2997e-006
2225	9.3886e-003	4.9111e-002	4.1e-002	-1.6191e-006
2226	1.0363e-002	4.8914e-002	4.1e-002	-1.9724e-006
2227	1.1334e-002	4.8699e-002	4.1e-002	-2.3592e-006
2228	1.23e-002	4.8464e-002	4.1e-002	-2.7789e-006
2229	1.3261e-002	4.8209e-002	4.1e-002	-3.2309e-006
2230	1.4217e-002	4.7936e-002	4.1e-002	-3.7147e-006
2231	1.5167e-002	4.7644e-002	4.1e-002	-4.2296e-006
2232	1.6111e-002	4.7333e-002	4.1e-002	-4.7749e-006
2233	1.7049e-002	4.7004e-002	4.1e-002	-5.3497e-006
2234	1.798e-002	4.6655e-002	4.1e-002	-5.9534e-006
2235	1.8904e-002	4.6289e-002	4.1e-002	-6.585e-006
2236	1.9821e-002	4.5904e-002	4.1e-002	-7.2438e-006
2237	2.073e-002	4.55e-002	4.1e-002	-7.9287e-006
2238	2.163e-002	4.5079e-002	4.1e-002	-8.6389e-006
2239	2.2522e-002	4.464e-002	4.1e-002	-9.3733e-006
2240	2.3405e-002	4.4184e-002	4.1e-002	-1.0131e-005
2241	2.4279e-002	4.371e-002	4.1e-002	-1.0911e-005
2242	2.5143e-002	4.3218e-002	4.1e-002	-1.1712e-005
2243	2.5998e-002	4.271e-002	4.1e-002	-1.2532e-005
2244	2.6842e-002	4.2184e-002	4.1e-002	-1.3372e-005
2245	-2.7623e-002	4.1677e-002	1.0982e-002	-1.4176e-005
2246	-2.8492e-002	4.1088e-002	4.e-002	-1.5093e-005
2247	-2.8482e-002	4.1095e-002	3.9e-002	-1.509e-005
2248	-2.8481e-002	4.1095e-002	3.7999e-002	-1.5086e-005
2249	-2.848e-002	4.1096e-002	3.6998e-002	-1.5085e-005
2250	-2.8478e-002	4.1097e-002	3.5998e-002	-1.5084e-005
2251	-2.8478e-002	4.1098e-002	3.4997e-002	-1.5083e-005
2252	-2.8477e-002	4.1098e-002	3.3998e-002	-1.5083e-005
2253	-2.8475e-002	4.11e-002	3.2998e-002	-1.5081e-005
2254	-2.8474e-002	4.11e-002	3.1998e-002	-1.508e-005
2255	-2.8472e-002	4.1101e-002	3.0999e-002	-1.508e-005
2256	-2.8479e-002	4.1097e-002	2.9998e-002	-1.5082e-005
2257	-2.8479e-002	4.1097e-002	2.8998e-002	-1.5083e-005
2258	-2.8478e-002	4.1097e-002	2.7998e-002	-1.5082e-005
2259	-2.8477e-002	4.1098e-002	2.6999e-002	-1.5086e-005
2260	-2.8492e-002	4.1088e-002	2.6012e-002	-1.5099e-005
2261	-2.8513e-002	4.1073e-002	2.5025e-002	-1.5121e-005
2262	-2.8545e-002	4.1051e-002	2.4034e-002	-1.5151e-005
2263	-2.8581e-002	4.1026e-002	2.3037e-002	-1.5183e-005
2264	-2.8603e-002	4.1011e-002	2.2033e-002	-1.52e-005
2265	-2.8586e-002	4.1022e-002	2.1026e-002	-1.5192e-005
2266	-2.8559e-002	4.1041e-002	2.002e-002	-1.5169e-005
2267	-2.8535e-002	4.1058e-002	1.9017e-002	-1.514e-005
2268	-2.85e-002	4.1082e-002	1.8011e-002	-1.511e-005
2269	-2.8475e-002	4.11e-002	1.7005e-002	-1.5081e-005
2270	-2.845e-002	4.1117e-002	1.6005e-002	-1.5058e-005
2271	-2.8433e-002	4.1128e-002	1.5007e-002	-1.5042e-005
2272	-2.8428e-002	4.1132e-002	1.4009e-002	-1.5035e-005
2273	-2.8431e-002	4.113e-002	1.3004e-002	-1.5035e-005
2274	-2.8436e-002	4.1126e-002	1.1995e-002	-1.5037e-005
2275	-2.7622e-002	4.1677e-002	1.1991e-002	-1.4173e-005
2276	-2.6802e-002	4.221e-002	9.9715e-003	-1.3336e-005
2277	2.7675e-002	4.1642e-002	4.e-002	-1.4229e-005
2278	-2.68e-002	4.2211e-002	1.0979e-002	-1.3332e-005
2279	2.7675e-002	4.1642e-002	3.9e-002	-1.4229e-005
2280	2.7675e-002	4.1642e-002	3.8e-002	-1.4229e-005
2281	2.7675e-002	4.1643e-002	3.7e-002	-1.4229e-005
2282	2.7675e-002	4.1643e-002	3.6e-002	-1.4229e-005
2283	2.7675e-002	4.1643e-002	3.5e-002	-1.4229e-005
2284	2.7675e-002	4.1643e-002	3.4e-002	-1.4229e-005
2285	2.7674e-002	4.1643e-002	3.3e-002	-1.4229e-005
2286	2.7674e-002	4.1643e-002	3.2e-002	-1.4229e-005
2287	2.7674e-002	4.1643e-002	3.1e-002	-1.4229e-005
2288	2.7674e-002	4.1643e-002	3.e-002	-1.4229e-005
2289	2.7674e-002	4.1643e-002	2.9e-002	-1.4229e-005
2290	2.7674e-002	4.1643e-002	2.8e-002	-1.4229e-005
2291	2.7673e-002	4.1644e-002	2.7e-002	-1.4229e-005
2292	2.7673e-002	4.1644e-002	2.6e-002	-1.4229e-005
2293	2.7673e-002	4.1644e-002	2.5e-002	-1.4229e-005
2294	2.7673e-002	4.1644e-002	2.4e-002	-1.4229e-005
2295	2.7673e-002	4.1644e-002	2.3e-002	-1.4228e-005
2296	2.7672e-002	4.1644e-002	2.2e-002	-1.4228e-005
2297	2.7672e-002	4.1644e-002	2.1e-002	-1.4228e-005
2298	2.7672e-002	4.1644e-002	2.e-002	-1.4228e-005
2299	2.7672e-002	4.1645e-002	1.9e-002	-1.4228e-005
2300	2.7672e-002	4.1645e-002	1.8e-002	-1.4228e-005
2301	2.7672e-002	4.1645e-002	1.7e-002	-1.4228e-005
2302	2.7671e-002	4.1645e-002	1.6e-002	-1.4228e-005
2303	2.7671e-002	4.1645e-002	1.5e-002	-1.4228e-005
2304	2.7671e-002	4.1645e-002	1.4e-002	-1.4228e-005
2305	2.7671e-002	4.1645e-002	1.3e-002	-1.4228e-005
2306	2.7671e-002	4.1645e-002	1.2e-002	-1.4228e-005
2307	2.767e-002	4.1646e-002	1.1e-002	-1.4228e-005
2308	2.767e-002	4.1646e-002	1.e-002	-1.4228e-005
2309	2.6842e-002	4.2184e-002	1.e-002	-1.3371e-005
2310	2.5998e-002	4.271e-002	1.e-002	-1.2533e-005
2311	2.4279e-002	4.371e-002	1.e-002	-1.0911e-005
2312	2.3405e-002	4.4184e-002	1.e-002	-1.0131e-005
2313	2.2522e-002	4.464e-002	1.e-002	-9.3734e-006
2314	2.163e-002	4.5079e-002	1.e-002	-8.639e-006
2315	2.073e-002	4.55e-002	1.e-002	-7.9288e-006
2316	1.9821e-002	4.5904e-002	1.e-002	-7.2438e-006
2317	1.8904e-002	4.6289e-002	1.e-002	-6.5851e-006
2318	1.798e-002	4.6655e-002	1.e-002	-5.9534e-006
2319	1.7049e-002	4.7003e-002	1.e-002	-5.3497e-006
2320	1.6111e-002	4.7333e-002	1.e-002	-4.7749e-006
2321	1.5167e-002	4.7644e-002	1.e-002	-4.2297e-006
2322	1.4217e-002	4.7936e-002	1.e-002	-3.7148e-006
2323	1.3261e-002	4.8209e-002	1.e-002	-3.231e-006
2324	1.23e-002	4.8464e-002	1.e-002	-2.7789e-006
2325	1.1334e-002	4.8699e-002	1.e-002	-2.3592e-006
2326	1.0363e-002	4.8914e-002	1.e-002	-1.9724e-006
2327	9.3886e-003	4.9111e-002	1.e-002	-1.6191e-006
2328	8.4103e-003	4.9288e-002	1.e-002	-1.2997e-006
2329	7.4288e-003	4.9445e-002	1.e-002	-1.0147e-006
2330	6.4442e-003	4.9583e-002	1.e-002	-7.6452e-007
2331	5.4571e-003	4.9701e-002	1.e-002	-5.494e-007
2332	4.4678e-003	4.98e-002	1.e-002	-3.6969e-007
2333	3.4769e-003	4.9879e-002	1.e-002	-2.2563e-007
2334	2.4844e-003	4.9938e-002	1.e-002	-1.1741e-007
2335	1.4911e-003	4.9978e-002	1.e-002	-4.5178e-008
2336	4.9708e-004	4.9998e-002	1.e-002	-9.0382e-009
2337	-4.9703e-004	4.9998e-002	1.e-002	-9.0371e-009
2338	-1.491e-003	4.9978e-002	1.e-002	-4.5175e-008
2339	-2.4844e-003	4.9938e-002	1.e-002	-1.174e-007
2340	-3.4768e-003	4.9879e-002	1.e-002	-2.2562e-007
2341	-4.4678e-003	4.98e-002	1.e-002	-3.6968e-007
2342	-5.4571e-003	4.9701e-002	1.e-002	-5.4939e-007
2343	-6.4441e-003	4.9583e-002	1.e-002	-7.645e-007
2344	-7.4287e-003	4.9445e-002	1.e-002	-1.0147e-006
2345	-8.4103e-003	4.9288e-002	1.e-002	-1.2997e-006
2346	-9.3886e-003	4.9111e-002	1.e-002	-1.6191e-006
2347	-1.0363e-002	4.8914e-002	1.e-002	-1.9724e-006
2348	-1.1334e-002	4.8699e-002	1.e-002	-2.3592e-006
2349	-1.23e-002	4.8464e-002	1.e-002	-2.7789e-006
2350	-1.3261e-002	4.8209e-002	1.e-002	-3.231e-006
2351	-1.4217e-002	4.7936e-002	1.e-002	-3.7148e-006
2352	-1.5167e-002	4.7644e-002	1.e-002	-4.2296e-006
2353	-1.6111e-002	4.7333e-002	1.e-002	-4.7749e-006
2354	-1.7049e-002	4.7003e-002	1.e-002	-5.3497e-006
2355	-1.798e-002	4.6655e-002	1.e-002	-5.9534e-006
2356	-1.8904e-002	4.6289e-002	1.e-002	-6.585e-006
2357	-1.9821e-002	4.5904e-002	1.e-002	-7.2438e-006
2358	-2.073e-002	4.55e-002	1.e-002	-7.9287e-006
2359	-2.163e-002	4.5079e-002	1.e-002	-8.6389e-006
2360	-2.2522e-002	4.464e-002	1.e-002	-9.3733e-006
2361	-2.3405e-002	4.4184e-002	1.e-002	-1.0131e-005
2362	-2.4279e-002	4.371e-002	1.e-002	-1.0909e-005
2363	-2.5135e-002	4.3223e-002	9.9976e-003	-1.1702e-005
2364	-2.5975e-002	4.2724e-002	9.9876e-003	-1.251e-005
2365	-2.7616e-002	4.1681e-002	1.3002e-002	-1.417e-005
2366	-2.7612e-002	4.1684e-002	1.4008e-002	-1.4169e-005
2367	-2.762e-002	4.1679e-002	1.5011e-002	-1.4175e-005
2368	-2.7637e-002	4.1668e-002	1.6015e-002	-1.4191e-005
2369	-2.7662e-002	4.1651e-002	1.7025e-002	-1.4217e-005
2370	-2.7693e-002	4.1631e-002	1.8032e-002	-1.4247e-005
2371	-2.7726e-002	4.1608e-002	1.9038e-002	-1.4278e-005
2372	-2.778e-002	4.1572e-002	2.1047e-002	-1.4329e-005
2373	-2.7789e-002	4.1566e-002	2.205e-002	-1.4335e-005
2374	-2.7675e-002	4.1642e-002	4.e-002	-1.4227e-005
2375	-2.6842e-002	4.2184e-002	4.e-002	-1.3372e-005
2376	-2.5998e-002	4.271e-002	4.e-002	-1.2533e-005
2377	-2.5143e-002	4.3218e-002	4.e-002	-1.1712e-005
2378	-2.4279e-002	4.371e-002	4.e-002	-1.0911e-005
2379	-2.3405e-002	4.4184e-002	4.e-002	-1.0131e-005
2380	-2.2522e-002	4.464e-002	4.e-002	-9.3734e-006
2381	-2.163e-002	4.5079e-002	4.e-002	-8.639e-006
2382	-2.073e-002	4.55e-002	4.e-002	-7.9288e-006
2383	-1.9821e-002	4.5904e-002	4.e-002	-7.2438e-006
2384	-1.8904e-002	4.6288e-002	4.e-002	-6.5851e-006
2385	-1.798e-002	4.6655e-002	4.e-002	-5.9534e-006
2386	-1.7049e-002	4.7003e-002	4.e-002	-5.3498e-006
2387	-1.6111e-002	4.7333e-002	4.e-002	-4.7749e-006
2388	-1.5167e-002	4.7644e-002	4.e-002	-4.2297e-006
2389	-1.4217e-002	4.7936e-002	4.e-002	-3.7148e-006
2390	-1.3261e-002	4.8209e-002	4.e-002	-3.231e-006
2391	-1.23e-002	4.8464e-002	4.e-002	-2.7789e-006
2392	-1.1334e-002	4.8699e-002	4.e-002	-2.3592e-006
2393	-1.0363e-002	4.8914e-002	4.e-002	-1.9724e-006
2394	-9.3887e-003	4.9111e-002	4.e-002	-1.6191e-006
2395	-8.4103e-003	4.9288e-002	4.e-002	-1.2997e-006
2396	-7.4288e-003	4.9445e-002	4.e-002	-1.0147e-006
2397	-6.4442e-003	4.9583e-002	4.e-002	-7.6452e-007
2398	-5.4572e-003	4.9701e-002	4.e-002	-5.4941e-007
2399	-4.4678e-003	4.98e-002	4.e-002	-3.6969e-007
2400	-3.4769e-003	4.9879e-002	4.e-002	-2.2563e-007
2401	-2.4844e-003	4.9938e-002	4.e-002	-1.1741e-007
2402	-1.4911e-003	4.9978e-002	4.e-002	-4.5179e-008
2403	-4.9707e-004	4.9998e-002	4.e-002	-9.0386e-009
2404	4.9697e-004	4.9998e-002	4.e-002	-9.0368e-009
2405	1.491e-003	4.9978e-002	4.e-002	-4.5173e-008
2406	2.4843e-003	4.9938e-002	4.e-002	-1.174e-007
2407	3.4768e-003	4.9879e-002	4.e-002	-2.2562e-007
2408	4.4677e-003	4.98e-002	4.e-002	-3.6968e-007
2409	5.4571e-003	4.9701e-002	4.e-002	-5.4939e-007
2410	6.4441e-003	4.9583e-002	4.e-002	-7.645e-007
2411	7.4287e-003	4.9445e-002	4.e-002	-1.0147e-006
2412	8.4102e-003	4.9288e-002	4.e-002	-1.2997e-006
2413	9.3886e-003	4.9111e-002	4.e-002	-1.6191e-006
2414	1.0363e-002	4.8914e-002	4.e-002	-1.9724e-006
2415	1.1334e-002	4.8699e-002	4.e-002	-2.3592e-006
2416	1.23e-002	4.8464e-002	4.e-002	-2.7789e-006
2417	1.3261e-002	4.8209e-002	4.e-002	-3.2309e-006
2418	1.4217e-002	4.7936e-002	4.e-002	-3.7147e-006
2419	1.5167e-002	4.7644e-002	4.e-002	-4.2296e-006
2420	1.6111e-002	4.7333e-002	4.e-002	-4.7748e-006
2421	1.7049e-002	4.7003e-002	4.e-002	-5.3497e-006
2422	1.798e-002	4.6655e-002	4.e-002	-5.9534e-006
2423	1.8904e-002	4.6289e-002	4.e-002	-6.585e-006
2424	1.9821e-002	4.5904e-002	4.e-002	-7.2438e-006
2425	2.073e-002	4.55e-002	4.e-002	-7.9287e-006
2426	2.163e-002	4.5079e-002	4.e-002	-8.6389e-006
2427	2.2522e-002	4.464e-002	4.e-002	-9.3733e-006
2428	2.3405e-002	4.4184e-002	4.e-002	-1.0131e-005
2429	2.4279e-002	4.371e-002	4.e-002	-1.0911e-005
2430	2.5143e-002	4.3218e-002	4.e-002	-1.1712e-005
2431	2.5998e-002	4.271e-002	4.e-002	-1.2532e-005
2432	2.6842e-002	4.2184e-002	4.e-002	-1.3372e-005
2433	-2.7675e-002	4.1642e-002	3.9e-002	-1.4225e-005
2434	-2.7667e-002	4.1648e-002	3.8e-002	-1.4222e-005
2435	-2.7666e-002	4.1648e-002	3.7e-002	-1.422e-005
2436	-2.7666e-002	4.1649e-002	3.6e-002	-1.4219e-005
2437	-2.7665e-002	4.1649e-002	3.4999e-002	-1.4219e-005
2438	-2.7664e-002	4.165e-002	3.3999e-002	-1.4218e-005
2439	-2.7664e-002	4.165e-002	3.3e-002	-1.4217e-005
2440	-2.7663e-002	4.1651e-002	3.2e-002	-1.4217e-005
2441	-2.7662e-002	4.1651e-002	3.1e-002	-1.4216e-005
2442	-2.7661e-002	4.1652e-002	3.e-002	-1.4217e-005
2443	-2.766e-002	4.1652e-002	2.9e-002	-1.4217e-005
2444	-2.7659e-002	4.1653e-002	2.8e-002	-1.4216e-005
2445	-2.7665e-002	4.1649e-002	2.7005e-002	-1.4219e-005
2446	-2.767e-002	4.1646e-002	2.6012e-002	-1.423e-005
2447	-2.7695e-002	4.1629e-002	2.5031e-002	-1.4253e-005
2448	-2.773e-002	4.1606e-002	2.4038e-002	-1.4285e-005
2449	-2.7762e-002	4.1585e-002	2.3044e-002	-1.4318e-005
2450	2.6842e-002	4.2184e-002	1.1e-002	-1.3371e-005
2451	2.6842e-002	4.2184e-002	1.2e-002	-1.3371e-005
2452	2.6842e-002	4.2184e-002	1.3e-002	-1.3371e-005
2453	2.6842e-002	4.2184e-002	1.4e-002	-1.3371e-005
2454	2.6842e-002	4.2184e-002	1.5e-002	-1.3371e-005
2455	2.6842e-002	4.2184e-002	1.6e-002	-1.3371e-005
2456	2.6842e-002	4.2184e-002	1.7e-002	-1.3371e-005
2457	2.6842e-002	4.2184e-002	1.8e-002	-1.3371e-005
2458	2.6842e-002	4.2184e-002	1.9e-002	-1.3371e-005
2459	2.6842e-002	4.2184e-002	2.e-002	-1.3371e-005
2460	2.6842e-002	4.2184e-002	2.1e-002	-1.3371e-005
2461	2.6842e-002	4.2184e-002	2.2e-002	-1.3371e-005
2462	2.6842e-002	4.2184e-002	2.3e-002	-1.3371e-005
2463	2.6842e-002	4.2184e-002	2.4e-002	-1.3371e-005
2464	2.6842e-002	4.2184e-002	2.5e-002	-1.3371e-005
2465	2.6842e-002	4.2184e-002	2.6e-002	-1.3371e-005
2466	2.6842e-002	4.2184e-002	2.7e-002	-1.3372e-005
2467	2.6842e-002	4.2184e-002	2.8e-002	-1.3372e-005
2468	2.6842e-002	4.2184e-002	2.9e-002	-1.3372e-005
2469	2.6842e-002	4.2185e-002	3.e-002	-1.3372e-005
2470	2.6842e-002	4.2185e-002	3.1e-002	-1.3372e-005
2471	2.6841e-002	4.2185e-002	3.2e-002	-1.3372e-005
2472	2.6841e-002	4.2185e-002	3.3e-002	-1.3372e-005
2473	2.6841e-002	4.2185e-002	3.4e-002	-1.3372e-005
2474	2.6841e-002	4.2185e-002	3.5e-002	-1.3372e-005
2475	2.6841e-002	4.2185e-002	3.6e-002	-1.3372e-005
2476	2.5998e-002	4.271e-002	1.1e-002	-1.2533e-005
2477	2.5143e-002	4.3218e-002	1.1e-002	-1.1712e-005
2478	2.4279e-002	4.3709e-002	1.1e-002	-1.0911e-005
2479	2.3405e-002	4.4184e-002	1.1e-002	-1.0131e-005
2480	2.2522e-002	4.464e-002	1.1e-002	-9.3734e-006
2481	2.163e-002	4.5079e-002	1.1e-002	-8.639e-006
2482	2.073e-002	4.55e-002	1.1e-002	-7.9288e-006
2483	1.9821e-002	4.5904e-002	1.1e-002	-7.2438e-006
2484	1.8904e-002	4.6288e-002	1.1e-002	-6.5851e-006
2485	1.798e-002	4.6655e-002	1.1e-002	-5.9534e-006
2486	1.7049e-002	4.7003e-002	1.1e-002	-5.3497e-006
2487	1.6111e-002	4.7333e-002	1.1e-002	-4.7749e-006
2488	1.5167e-002	4.7644e-002	1.1e-002	-4.2297e-006
2489	1.4217e-002	4.7936e-002	1.1e-002	-3.7148e-006
2490	1.3261e-002	4.8209e-002	1.1e-002	-3.231e-006
2491	1.23e-002	4.8464e-002	1.1e-002	-2.7789e-006
2492	1.1334e-002	4.8699e-002	1.1e-002	-2.3592e-006
2493	1.0363e-002	4.8914e-002	1.1e-002	-1.9724e-006
2494	9.3887e-003	4.9111e-002	1.1e-002	-1.6191e-006
2495	8.4103e-003	4.9288e-002	1.1e-002	-1.2997e-006
2496	7.4288e-003	4.9445e-002	1.1e-002	-1.0147e-006
2497	6.4442e-003	4.9583e-002	1.1e-002	-7.6452e-007
2498	5.4571e-003	4.9701e-002	1.1e-002	-5.494e-007
2499	4.4678e-003	4.98e-002	1.1e-002	-3.6969e-007
2500	3.4769e-003	4.9879e-002	1.1e-002	-2.2563e-007
2501	2.4844e-003	4.9938e-002	1.1e-002	-1.1741e-007
2502	1.4911e-003	4.9978e-002	1.1e-002	-4.5178e-008
2503	4.971e-004	4.9998e-002	1.1e-002	-9.0382e-009
2504	-4.9702e-004	4.9998e-002	1.1e-002	-9.0371e-009
2505	-1.491e-003	4.9978e-002	1.1e-002	-4.5175e-008
2506	-2.4844e-003	4.9938e-002	1.1e-002	-1.174e-007
2507	-3.4768e-003	4.9879e-002	1.1e-002	-2.2562e-007
2508	-4.4678e-003	4.98e-002	1.1e-002	-3.6968e-007
2509	-5.4571e-003	4.9701e-002	1.1e-002	-5.4939e-007
2510	-6.4441e-003	4.9583e-002	1.1e-002	-7.645e-007
2511	-7.4287e-003	4.9445e-002	1.1e-002	-1.0147e-006
2512	-8.4103e-003	4.9288e-002	1.1e-002	-1.2997e-006
2513	-9.3886e-003	4.9111e-002	1.1e-002	-1.6191e-006
2514	-1.0363e-002	4.8914e-002	1.1e-002	-1.9724e-006
2515	-1.1334e-002	4.8699e-002	1.1e-002	-2.3592e-006
2516	-1.23e-002	4.8464e-002	1.1e-002	-2.7789e-006
2517	-1.3261e-002	4.8209e-002	1.1e-002	-3.231e-006
2518	-1.4217e-002	4.7936e-002	1.1e-002	-3.7148e-006
2519	-1.5167e-002	4.7644e-002	1.1e-002	-4.2296e-006
2520	-1.6111e-002	4.7333e-002	1.1e-002	-4.7749e-006
2521	-1.7049e-002	4.7003e-002	1.1e-002	-5.3497e-006
2522	-1.798e-002	4.6655e-002	1.1e-002	-5.9534e-006
2523	-1.8904e-002	4.6289e-002	1.1e-002	-6.585e-006
2524	-1.9821e-002	4.5904e-002	1.1e-002	-7.2438e-006
2525	-2.073e-002	4.55e-002	1.1e-002	-7.9287e-006
2526	-2.163e-002	4.5079e-002	1.1e-002	-8.6389e-006
2527	-2.2522e-002	4.464e-002	1.1e-002	-9.3733e-006
2528	-2.3405e-002	4.4184e-002	1.1e-002	-1.0131e-005
2529	-2.4279e-002	4.371e-002	1.1e-002	-1.0909e-005
2530	-2.5134e-002	4.3224e-002	1.0997e-002	-1.1701e-005
2531	-2.6799e-002	4.2211e-002	1.1987e-002	-1.333e-005
2532	-2.6798e-002	4.2212e-002	1.2996e-002	-1.3328e-005
2533	-2.6796e-002	4.2213e-002	1.4004e-002	-1.3327e-005
2534	-2.6799e-002	4.2212e-002	1.5012e-002	-1.3331e-005
2535	-2.681e-002	4.2205e-002	1.6022e-002	-1.3346e-005
2536	-2.6841e-002	4.2185e-002	1.7033e-002	-1.337e-005
2537	-2.6867e-002	4.2168e-002	1.8041e-002	-1.3399e-005
2538	-2.6899e-002	4.2148e-002	1.9054e-002	-1.3426e-005
2539	-2.692e-002	4.2134e-002	2.0055e-002	-1.3451e-005
2540	-2.6941e-002	4.2121e-002	2.1054e-002	-1.3468e-005
2541	-2.6946e-002	4.2118e-002	2.2053e-002	-1.3471e-005
2542	2.6842e-002	4.2184e-002	3.9e-002	-1.3372e-005
2543	2.6842e-002	4.2184e-002	3.8e-002	-1.3372e-005
2544	2.6842e-002	4.2184e-002	3.7e-002	-1.3372e-005
2545	-2.6842e-002	4.2184e-002	3.9e-002	-1.3372e-005
2546	-2.5998e-002	4.271e-002	3.9e-002	-1.2533e-005
2547	-2.5143e-002	4.3218e-002	3.9e-002	-1.1712e-005
2548	-2.4279e-002	4.371e-002	3.9e-002	-1.0911e-005
2549	-2.3405e-002	4.4184e-002	3.9e-002	-1.0131e-005
2550	-2.2522e-002	4.464e-002	3.9e-002	-9.3734e-006
2551	-2.163e-002	4.5079e-002	3.9e-002	-8.639e-006
2552	-2.073e-002	4.55e-002	3.9e-002	-7.9288e-006
2553	-1.9821e-002	4.5904e-002	3.9e-002	-7.2438e-006
2554	-1.8904e-002	4.6288e-002	3.9e-002	-6.5851e-006
2555	-1.798e-002	4.6655e-002	3.9e-002	-5.9534e-006
2556	-1.7049e-002	4.7003e-002	3.9e-002	-5.3498e-006
2557	-1.6111e-002	4.7333e-002	3.9e-002	-4.7749e-006
2558	-1.5167e-002	4.7644e-002	3.9e-002	-4.2297e-006
2559	-1.4217e-002	4.7936e-002	3.9e-002	-3.7148e-006
2560	-1.3261e-002	4.8209e-002	3.9e-002	-3.231e-006
2561	-1.23e-002	4.8464e-002	3.9e-002	-2.7789e-006
2562	-1.1334e-002	4.8699e-002	3.9e-002	-2.3592e-006
2563	-1.0363e-002	4.8914e-002	3.9e-002	-1.9724e-006
2564	-9.3887e-003	4.9111e-002	3.9e-002	-1.6191e-006
2565	-8.4103e-003	4.9288e-002	3.9e-002	-1.2997e-006
2566	-7.4288e-003	4.9445e-002	3.9e-002	-1.0148e-006
2567	-6.4442e-003	4.9583e-002	3.9e-002	-7.6453e-007
2568	-5.4572e-003	4.9701e-002	3.9e-002	-5.4941e-007
2569	-4.4678e-003	4.98e-002	3.9e-002	-3.697e-007
2570	-3.4769e-003	4.9879e-002	3.9e-002	-2.2563e-007
2571	-2.4844e-003	4.9938e-002	3.9e-002	-1.1741e-007
2572	-1.4912e-003	4.9978e-002	3.9e-002	-4.518e-008
2573	-4.971e-004	4.9998e-002	3.9e-002	-9.0388e-009
2574	4.9697e-004	4.9998e-002	3.9e-002	-9.0365e-009
2575	1.491e-003	4.9978e-002	3.9e-002	-4.5173e-008
2576	2.4843e-003	4.9938e-002	3.9e-002	-1.174e-007
2577	3.4768e-003	4.9879e-002	3.9e-002	-2.2561e-007
2578	4.4677e-003	4.98e-002	3.9e-002	-3.6967e-007
2579	5.457e-003	4.9701e-002	3.9e-002	-5.4938e-007
2580	6.4441e-003	4.9583e-002	3.9e-002	-7.6449e-007
2581	7.4287e-003	4.9445e-002	3.9e-002	-1.0147e-006
2582	8.4102e-003	4.9288e-002	3.9e-002	-1.2997e-006
2583	9.3886e-003	4.9111e-002	3.9e-002	-1.6191e-006
2584	1.0363e-002	4.8914e-002	3.9e-002	-1.9724e-006
2585	1.1334e-002	4.8699e-002	3.9e-002	-2.3592e-006
2586	1.23e-002	4.8464e-002	3.9e-002	-2.7789e-006
2587	1.3261e-002	4.8209e-002	3.9e-002	-3.2309e-006
2588	1.4217e-002	4.7936e-002	3.9e-002	-3.7147e-006
2589	1.5167e-002	4.7644e-002	3.9e-002	-4.2296e-006
2590	1.6111e-002	4.7333e-002	3.9e-002	-4.7748e-006
2591	1.7049e-002	4.7003e-002	3.9e-002	-5.3497e-006
2592	1.798e-002	4.6655e-002	3.9e-002	-5.9533e-006
2593	1.8904e-002	4.6289e-002	3.9e-002	-6.585e-006
2594	1.9821e-002	4.5904e-002	3.9e-002	-7.2437e-006
2595	2.073e-002	4.55e-002	3.9e-002	-7.9287e-006
2596	2.163e-002	4.5079e-002	3.9e-002	-8.6389e-006
2597	2.2522e-002	4.464e-002	3.9e-002	-9.3733e-006
2598	2.3405e-002	4.4184e-002	3.9e-002	-1.0131e-005
2599	2.4279e-002	4.371e-002	3.9e-002	-1.0911e-005
2600	2.5143e-002	4.3218e-002	3.9e-002	-1.1712e-005
2601	-2.5972e-002	4.2725e-002	1.0989e-002	-1.2508e-005
2602	-2.6842e-002	4.2184e-002	3.8e-002	-1.337e-005
2603	-2.6842e-002	4.2184e-002	3.7e-002	-1.337e-005
2604	-2.6842e-002	4.2184e-002	3.6e-002	-1.337e-005
2605	-2.6842e-002	4.2184e-002	3.5e-002	-1.3369e-005
2606	-2.6842e-002	4.2184e-002	3.4e-002	-1.3369e-005
2607	-2.6842e-002	4.2184e-002	3.3e-002	-1.3369e-005
2608	-2.6842e-002	4.2184e-002	3.2e-002	-1.3369e-005
2609	-2.6841e-002	4.2185e-002	3.1e-002	-1.3369e-005
2610	-2.6841e-002	4.2185e-002	3.e-002	-1.3369e-005
2611	-2.6841e-002	4.2185e-002	2.9e-002	-1.3368e-005
2612	-2.6841e-002	4.2185e-002	2.8e-002	-1.3367e-005
2613	-2.6834e-002	4.219e-002	2.7e-002	-1.3368e-005
2614	-2.6842e-002	4.2184e-002	2.6015e-002	-1.3376e-005
2615	-2.6868e-002	4.2168e-002	2.503e-002	-1.3398e-005
2616	-2.6898e-002	4.2149e-002	2.404e-002	-1.3429e-005
2617	2.5998e-002	4.271e-002	1.2e-002	-1.2533e-005
2618	2.5143e-002	4.3218e-002	1.2e-002	-1.1712e-005
2619	2.3405e-002	4.4184e-002	1.2e-002	-1.0131e-005
2620	2.2522e-002	4.464e-002	1.2e-002	-9.3734e-006
2621	2.163e-002	4.5079e-002	1.2e-002	-8.639e-006
2622	2.073e-002	4.55e-002	1.2e-002	-7.9288e-006
2623	1.9821e-002	4.5904e-002	1.2e-002	-7.2438e-006
2624	1.8904e-002	4.6289e-002	1.2e-002	-6.5851e-006
2625	1.798e-002	4.6655e-002	1.2e-002	-5.9534e-006
2626	1.7049e-002	4.7003e-002	1.2e-002	-5.3497e-006
2627	1.5167e-002	4.7644e-002	1.2e-002	-4.2297e-006
2628	1.4217e-002	4.7936e-002	1.2e-002	-3.7148e-006
2629	1.3261e-002	4.8209e-002	1.2e-002	-3.231e-006
2630	1.23e-002	4.8464e-002	1.2e-002	-2.7789e-006
2631	1.1334e-002	4.8699e-002	1.2e-002	-2.3592e-006
2632	1.0363e-002	4.8914e-002	1.2e-002	-1.9724e-006
2633	9.3886e-003	4.9111e-002	1.2e-002	-1.6191e-006
2634	8.4103e-003	4.9288e-002	1.2e-002	-1.2997e-006
2635	7.4287e-003	4.9445e-002	1.2e-002	-1.0147e-006
2636	6.4442e-003	4.9583e-002	1.2e-002	-7.6452e-007
2637	5.4571e-003	4.9701e-002	1.2e-002	-5.494e-007
2638	4.4678e-003	4.98e-002	1.2e-002	-3.6969e-007
2639	3.4768e-003	4.9879e-002	1.2e-002	-2.2563e-007
2640	2.4844e-003	4.9938e-002	1.2e-002	-1.1741e-007
2641	1.4911e-003	4.9978e-002	1.2e-002	-4.5178e-008
2642	4.9708e-004	4.9998e-002	1.2e-002	-9.0382e-009
2643	-4.9704e-004	4.9998e-002	1.2e-002	-9.0371e-009
2644	-1.491e-003	4.9978e-002	1.2e-002	-4.5175e-008
2645	-2.4844e-003	4.9938e-002	1.2e-002	-1.174e-007
2646	-3.4768e-003	4.9879e-002	1.2e-002	-2.2562e-007
2647	-4.4678e-003	4.98e-002	1.2e-002	-3.6968e-007
2648	-5.4571e-003	4.9701e-002	1.2e-002	-5.4939e-007
2649	-6.4441e-003	4.9583e-002	1.2e-002	-7.645e-007
2650	-7.4287e-003	4.9445e-002	1.2e-002	-1.0147e-006
2651	-8.4103e-003	4.9288e-002	1.2e-002	-1.2997e-006
2652	-9.3886e-003	4.9111e-002	1.2e-002	-1.6191e-006
2653	-1.0363e-002	4.8914e-002	1.2e-002	-1.9724e-006
2654	-1.1334e-002	4.8699e-002	1.2e-002	-2.3592e-006
2655	-1.23e-002	4.8464e-002	1.2e-002	-2.7789e-006
2656	-1.3261e-002	4.8209e-002	1.2e-002	-3.231e-006
2657	-1.4217e-002	4.7936e-002	1.2e-002	-3.7148e-006
2658	-1.5167e-002	4.7644e-002	1.2e-002	-4.2296e-006
2659	-1.6111e-002	4.7333e-002	1.2e-002	-4.7749e-006
2660	-1.7049e-002	4.7003e-002	1.2e-002	-5.3497e-006
2661	-1.798e-002	4.6655e-002	1.2e-002	-5.9534e-006
2662	-1.8904e-002	4.6289e-002	1.2e-002	-6.585e-006
2663	-1.9821e-002	4.5904e-002	1.2e-002	-7.2438e-006
2664	-2.073e-002	4.55e-002	1.2e-002	-7.9287e-006
2665	-2.163e-002	4.5079e-002	1.2e-002	-8.6389e-006
2666	-2.2522e-002	4.464e-002	1.2e-002	-9.3733e-006
2667	-2.3405e-002	4.4184e-002	1.2e-002	-1.0131e-005
2668	-2.4279e-002	4.371e-002	1.2e-002	-1.0908e-005
2669	-2.5132e-002	4.3225e-002	1.1996e-002	-1.17e-005
2670	-2.5971e-002	4.2726e-002	1.199e-002	-1.2507e-005
2671	-2.5974e-002	4.2724e-002	1.299e-002	-1.2505e-005
2672	-2.5965e-002	4.273e-002	1.3995e-002	-1.2504e-005
2673	-2.5971e-002	4.2726e-002	1.5008e-002	-1.2506e-005
2674	-2.5977e-002	4.2722e-002	1.6019e-002	-1.2518e-005
2675	-2.6009e-002	4.2703e-002	1.7025e-002	-1.2539e-005
2676	-2.6031e-002	4.269e-002	1.8043e-002	-1.2563e-005
2677	-2.6054e-002	4.2675e-002	1.9054e-002	-1.2586e-005
2678	-2.6078e-002	4.2661e-002	2.0059e-002	-1.2607e-005
2679	-2.6086e-002	4.2656e-002	2.1057e-002	-1.2618e-005
2680	-2.6088e-002	4.2655e-002	2.2049e-002	-1.2617e-005
2681	2.5998e-002	4.271e-002	3.8e-002	-1.2532e-005
2682	2.5998e-002	4.271e-002	3.7e-002	-1.2532e-005
2683	2.5997e-002	4.271e-002	3.6e-002	-1.2532e-005
2684	2.5997e-002	4.271e-002	3.4e-002	-1.2532e-005
2685	2.5997e-002	4.271e-002	3.3e-002	-1.2532e-005
2686	2.5997e-002	4.271e-002	3.2e-002	-1.2532e-005
2687	2.5997e-002	4.271e-002	3.1e-002	-1.2532e-005
2688	2.5997e-002	4.271e-002	3.e-002	-1.2532e-005
2689	2.5997e-002	4.271e-002	2.9e-002	-1.2532e-005
2690	2.5997e-002	4.271e-002	2.8e-002	-1.2532e-005
2691	2.5997e-002	4.271e-002	2.7e-002	-1.2532e-005
2692	2.5997e-002	4.271e-002	2.6e-002	-1.2532e-005
2693	2.5997e-002	4.271e-002	2.5e-002	-1.2532e-005
2694	2.5997e-002	4.271e-002	2.4e-002	-1.2532e-005
2695	2.5997e-002	4.271e-002	2.3e-002	-1.2532e-005
2696	2.5997e-002	4.271e-002	2.2e-002	-1.2532e-005
2697	2.5997e-002	4.271e-002	2.1e-002	-1.2532e-005
2698	2.5997e-002	4.271e-002	2.e-002	-1.2532e-005
2699	2.5997e-002	4.271e-002	1.9e-002	-1.2532e-005
2700	2.5997e-002	4.271e-002	1.8e-002	-1.2532e-005
2701	2.5997e-002	4.271e-002	1.7e-002	-1.2532e-005
2702	2.5997e-002	4.271e-002	1.6e-002	-1.2532e-005
2703	2.5997e-002	4.271e-002	1.5e-002	-1.2532e-005
2704	2.5997e-002	4.271e-002	1.4e-002	-1.2532e-005
2705	2.5998e-002	4.271e-002	1.3e-002	-1.2532e-005
2706	-2.5998e-002	4.271e-002	3.8e-002	-1.2532e-005
2707	-2.5143e-002	4.3218e-002	3.8e-002	-1.1712e-005
2708	-2.4279e-002	4.371e-002	3.8e-002	-1.0911e-005
2709	-2.3405e-002	4.4184e-002	3.8e-002	-1.0131e-005
2710	-2.2522e-002	4.464e-002	3.8e-002	-9.3734e-006
2711	-2.163e-002	4.5079e-002	3.8e-002	-8.639e-006
2712	-2.073e-002	4.55e-002	3.8e-002	-7.9288e-006
2713	-1.9821e-002	4.5904e-002	3.8e-002	-7.2438e-006
2714	-1.8904e-002	4.6288e-002	3.8e-002	-6.5851e-006
2715	-1.798e-002	4.6655e-002	3.8e-002	-5.9534e-006
2716	-1.7049e-002	4.7003e-002	3.8e-002	-5.3498e-006
2717	-1.6111e-002	4.7333e-002	3.8e-002	-4.7749e-006
2718	-1.5167e-002	4.7644e-002	3.8e-002	-4.2297e-006
2719	-1.4217e-002	4.7936e-002	3.8e-002	-3.7148e-006
2720	-1.3261e-002	4.8209e-002	3.8e-002	-3.231e-006
2721	-1.23e-002	4.8464e-002	3.8e-002	-2.7789e-006
2722	-1.1334e-002	4.8699e-002	3.8e-002	-2.3592e-006
2723	-1.0363e-002	4.8914e-002	3.8e-002	-1.9724e-006
2724	-9.3887e-003	4.9111e-002	3.8e-002	-1.6191e-006
2725	-8.4103e-003	4.9288e-002	3.8e-002	-1.2998e-006
2726	-7.4289e-003	4.9445e-002	3.8e-002	-1.0148e-006
2727	-6.4442e-003	4.9583e-002	3.8e-002	-7.6453e-007
2728	-5.4572e-003	4.9701e-002	3.8e-002	-5.4941e-007
2729	-4.4678e-003	4.98e-002	3.8e-002	-3.697e-007
2730	-3.477e-003	4.9879e-002	3.8e-002	-2.2563e-007
2731	-2.4844e-003	4.9938e-002	3.8e-002	-1.1741e-007
2732	-1.4912e-003	4.9978e-002	3.8e-002	-4.518e-008
2733	-4.9709e-004	4.9998e-002	3.8e-002	-9.0391e-009
2734	4.9693e-004	4.9998e-002	3.8e-002	-9.0363e-009
2735	1.491e-003	4.9978e-002	3.8e-002	-4.5172e-008
2736	2.4843e-003	4.9938e-002	3.8e-002	-1.174e-007
2737	3.4768e-003	4.9879e-002	3.8e-002	-2.2561e-007
2738	4.4677e-003	4.98e-002	3.8e-002	-3.6967e-007
2739	5.4571e-003	4.9701e-002	3.8e-002	-5.4938e-007
2740	6.444e-003	4.9583e-002	3.8e-002	-7.6449e-007
2741	7.4287e-003	4.9445e-002	3.8e-002	-1.0147e-006
2742	8.4102e-003	4.9288e-002	3.8e-002	-1.2997e-006
2743	9.3886e-003	4.9111e-002	3.8e-002	-1.6191e-006
2744	1.0363e-002	4.8914e-002	3.8e-002	-1.9724e-006
2745	1.1334e-002	4.8699e-002	3.8e-002	-2.3592e-006
2746	1.2299e-002	4.8464e-002	3.8e-002	-2.7789e-006
2747	1.3261e-002	4.8209e-002	3.8e-002	-3.2309e-006
2748	1.4217e-002	4.7936e-002	3.8e-002	-3.7147e-006
2749	1.5167e-002	4.7644e-002	3.8e-002	-4.2296e-006
2750	1.6111e-002	4.7333e-002	3.8e-002	-4.7748e-006
2751	1.7049e-002	4.7003e-002	3.8e-002	-5.3497e-006
2752	1.798e-002	4.6655e-002	3.8e-002	-5.9533e-006
2753	1.8904e-002	4.6289e-002	3.8e-002	-6.585e-006
2754	1.9821e-002	4.5904e-002	3.8e-002	-7.2437e-006
2755	2.073e-002	4.55e-002	3.8e-002	-7.9287e-006
2756	2.163e-002	4.5079e-002	3.8e-002	-8.6389e-006
2757	2.2522e-002	4.464e-002	3.8e-002	-9.3733e-006
2758	2.3405e-002	4.4184e-002	3.8e-002	-1.0131e-005
2759	2.4279e-002	4.371e-002	3.8e-002	-1.0911e-005
2760	2.5143e-002	4.3218e-002	3.8e-002	-1.1712e-005
2761	-2.5998e-002	4.271e-002	3.7e-002	-1.2532e-005
2762	-2.5998e-002	4.271e-002	3.6e-002	-1.2532e-005
2763	-2.5998e-002	4.271e-002	3.5e-002	-1.2532e-005
2764	-2.5998e-002	4.271e-002	3.4e-002	-1.2532e-005
2765	-2.5998e-002	4.271e-002	3.3e-002	-1.2533e-005
2766	-2.5998e-002	4.271e-002	3.2e-002	-1.2533e-005
2767	-2.5998e-002	4.271e-002	3.1e-002	-1.2533e-005
2768	-2.5998e-002	4.271e-002	3.e-002	-1.2533e-005
2769	-2.5998e-002	4.271e-002	2.9e-002	-1.2533e-005
2770	-2.5998e-002	4.2709e-002	2.8e-002	-1.2532e-005
2771	-2.5998e-002	4.2709e-002	2.7e-002	-1.2532e-005
2772	-2.6e-002	4.2709e-002	2.6012e-002	-1.2538e-005
2773	-2.6019e-002	4.2697e-002	2.503e-002	-1.2556e-005
2774	-2.6056e-002	4.2674e-002	2.404e-002	-1.2583e-005
2775	-2.6074e-002	4.2663e-002	2.3044e-002	-1.2605e-005
2776	-2.5131e-002	4.3226e-002	1.2998e-002	-1.1699e-005
2777	-2.5128e-002	4.3227e-002	1.3998e-002	-1.1698e-005
2778	-2.5129e-002	4.3227e-002	1.5002e-002	-1.1699e-005
2779	-2.5139e-002	4.3221e-002	1.6008e-002	-1.1707e-005
2780	-2.5153e-002	4.3213e-002	1.7021e-002	-1.1722e-005
2781	-2.5175e-002	4.3199e-002	1.8028e-002	-1.174e-005
2782	-2.5193e-002	4.3189e-002	1.9041e-002	-1.176e-005
2783	-2.5226e-002	4.317e-002	2.1052e-002	-1.1783e-005
2784	-2.5216e-002	4.3176e-002	2.204e-002	-1.1779e-005
2785	-2.5205e-002	4.3182e-002	2.3032e-002	-1.1768e-005
2786	2.5143e-002	4.3218e-002	1.3e-002	-1.1712e-005
2787	2.4279e-002	4.371e-002	1.3e-002	-1.0911e-005
2788	2.3405e-002	4.4184e-002	1.3e-002	-1.0131e-005
2789	2.2522e-002	4.464e-002	1.3e-002	-9.3734e-006
2790	2.163e-002	4.5079e-002	1.3e-002	-8.639e-006
2791	2.073e-002	4.55e-002	1.3e-002	-7.9288e-006
2792	1.9821e-002	4.5903e-002	1.3e-002	-7.2438e-006
2793	1.8904e-002	4.6288e-002	1.3e-002	-6.5851e-006
2794	1.798e-002	4.6655e-002	1.3e-002	-5.9534e-006
2795	1.7049e-002	4.7003e-002	1.3e-002	-5.3497e-006
2796	1.6111e-002	4.7333e-002	1.3e-002	-4.7749e-006
2797	1.5167e-002	4.7644e-002	1.3e-002	-4.2297e-006
2798	1.4217e-002	4.7936e-002	1.3e-002	-3.7148e-006
2799	1.3261e-002	4.8209e-002	1.3e-002	-3.231e-006
2800	1.23e-002	4.8464e-002	1.3e-002	-2.7789e-006
2801	1.1334e-002	4.8699e-002	1.3e-002	-2.3592e-006
2802	1.0363e-002	4.8914e-002	1.3e-002	-1.9724e-006
2803	9.3887e-003	4.9111e-002	1.3e-002	-1.6191e-006
2804	8.4103e-003	4.9288e-002	1.3e-002	-1.2997e-006
2805	7.4288e-003	4.9445e-002	1.3e-002	-1.0147e-006
2806	6.4442e-003	4.9583e-002	1.3e-002	-7.6452e-007
2807	5.4571e-003	4.9701e-002	1.3e-002	-5.494e-007
2808	4.4678e-003	4.98e-002	1.3e-002	-3.6969e-007
2809	3.4769e-003	4.9879e-002	1.3e-002	-2.2563e-007
2810	2.4844e-003	4.9938e-002	1.3e-002	-1.1741e-007
2811	1.4911e-003	4.9978e-002	1.3e-002	-4.5178e-008
2812	4.971e-004	4.9998e-002	1.3e-002	-9.0383e-009
2813	-4.9702e-004	4.9998e-002	1.3e-002	-9.0371e-009
2814	-1.491e-003	4.9978e-002	1.3e-002	-4.5174e-008
2815	-2.4844e-003	4.9938e-002	1.3e-002	-1.174e-007
2816	-3.4768e-003	4.9879e-002	1.3e-002	-2.2562e-007
2817	-4.4678e-003	4.98e-002	1.3e-002	-3.6968e-007
2818	-5.457e-003	4.9701e-002	1.3e-002	-5.4939e-007
2819	-6.4441e-003	4.9583e-002	1.3e-002	-7.645e-007
2820	-7.4287e-003	4.9445e-002	1.3e-002	-1.0147e-006
2821	-8.4103e-003	4.9288e-002	1.3e-002	-1.2997e-006
2822	-9.3886e-003	4.9111e-002	1.3e-002	-1.6191e-006
2823	-1.0363e-002	4.8914e-002	1.3e-002	-1.9724e-006
2824	-1.1334e-002	4.8699e-002	1.3e-002	-2.3592e-006
2825	-1.23e-002	4.8464e-002	1.3e-002	-2.7789e-006
2826	-1.3261e-002	4.8209e-002	1.3e-002	-3.231e-006
2827	-1.4217e-002	4.7936e-002	1.3e-002	-3.7148e-006
2828	-1.5167e-002	4.7644e-002	1.3e-002	-4.2296e-006
2829	-1.6111e-002	4.7333e-002	1.3e-002	-4.7749e-006
2830	-1.7049e-002	4.7004e-002	1.3e-002	-5.3497e-006
2831	-1.798e-002	4.6655e-002	1.3e-002	-5.9534e-006
2832	-1.8904e-002	4.6289e-002	1.3e-002	-6.585e-006
2833	-1.9821e-002	4.5904e-002	1.3e-002	-7.2438e-006
2834	-2.073e-002	4.55e-002	1.3e-002	-7.9287e-006
2835	-2.163e-002	4.5079e-002	1.3e-002	-8.6389e-006
2836	-2.2522e-002	4.464e-002	1.3e-002	-9.3733e-006
2837	-2.3405e-002	4.4184e-002	1.3e-002	-1.0131e-005
2838	-2.4279e-002	4.371e-002	1.3e-002	-1.0908e-005
2839	2.5143e-002	4.3218e-002	3.7e-002	-1.1712e-005
2840	2.5143e-002	4.3218e-002	3.6e-002	-1.1712e-005
2841	2.5143e-002	4.3218e-002	3.5e-002	-1.1712e-005
2842	2.5143e-002	4.3218e-002	3.4e-002	-1.1712e-005
2843	2.5143e-002	4.3218e-002	3.3e-002	-1.1712e-005
2844	2.5143e-002	4.3218e-002	3.2e-002	-1.1712e-005
2845	2.5143e-002	4.3218e-002	3.1e-002	-1.1712e-005
2846	2.5143e-002	4.3218e-002	3.e-002	-1.1712e-005
2847	2.5143e-002	4.3218e-002	2.9e-002	-1.1712e-005
2848	2.5143e-002	4.3218e-002	2.8e-002	-1.1712e-005
2849	2.5143e-002	4.3218e-002	2.7e-002	-1.1712e-005
2850	2.5143e-002	4.3218e-002	2.6e-002	-1.1712e-005
2851	2.5143e-002	4.3218e-002	2.5e-002	-1.1712e-005
2852	2.5143e-002	4.3218e-002	2.4e-002	-1.1712e-005
2853	2.5143e-002	4.3218e-002	2.3e-002	-1.1712e-005
2854	2.5143e-002	4.3218e-002	2.2e-002	-1.1712e-005
2855	2.5143e-002	4.3218e-002	2.1e-002	-1.1712e-005
2856	2.5143e-002	4.3218e-002	2.e-002	-1.1712e-005
2857	2.5143e-002	4.3218e-002	1.9e-002	-1.1712e-005
2858	2.5143e-002	4.3218e-002	1.8e-002	-1.1712e-005
2859	2.5143e-002	4.3218e-002	1.7e-002	-1.1712e-005
2860	2.5143e-002	4.3218e-002	1.6e-002	-1.1712e-005
2861	2.5143e-002	4.3218e-002	1.5e-002	-1.1712e-005
2862	2.5143e-002	4.3218e-002	1.4e-002	-1.1712e-005
2863	-2.5143e-002	4.3218e-002	3.7e-002	-1.1712e-005
2864	-2.4279e-002	4.371e-002	3.7e-002	-1.0911e-005
2865	-2.3405e-002	4.4184e-002	3.7e-002	-1.0131e-005
2866	-2.2522e-002	4.464e-002	3.7e-002	-9.3734e-006
2867	-2.163e-002	4.5079e-002	3.7e-002	-8.639e-006
2868	-2.073e-002	4.55e-002	3.7e-002	-7.9288e-006
2869	-1.9821e-002	4.5904e-002	3.7e-002	-7.2439e-006
2870	-1.8904e-002	4.6288e-002	3.7e-002	-6.5851e-006
2871	-1.798e-002	4.6655e-002	3.7e-002	-5.9534e-006
2872	-1.7049e-002	4.7003e-002	3.7e-002	-5.3498e-006
2873	-1.6111e-002	4.7333e-002	3.7e-002	-4.7749e-006
2874	-1.5167e-002	4.7644e-002	3.7e-002	-4.2297e-006
2875	-1.4217e-002	4.7936e-002	3.7e-002	-3.7148e-006
2876	-1.3261e-002	4.8209e-002	3.7e-002	-3.231e-006
2877	-1.23e-002	4.8464e-002	3.7e-002	-2.7789e-006
2878	-1.1334e-002	4.8699e-002	3.7e-002	-2.3592e-006
2879	-1.0363e-002	4.8914e-002	3.7e-002	-1.9725e-006
2880	-9.3888e-003	4.9111e-002	3.7e-002	-1.6191e-006
2881	-8.4103e-003	4.9288e-002	3.7e-002	-1.2998e-006
2882	-7.4289e-003	4.9445e-002	3.7e-002	-1.0148e-006
2883	-6.4442e-003	4.9583e-002	3.7e-002	-7.6453e-007
2884	-5.4572e-003	4.9701e-002	3.7e-002	-5.4942e-007
2885	-4.4678e-003	4.98e-002	3.7e-002	-3.697e-007
2886	-3.477e-003	4.9879e-002	3.7e-002	-2.2563e-007
2887	-2.4844e-003	4.9938e-002	3.7e-002	-1.1741e-007
2888	-1.4912e-003	4.9978e-002	3.7e-002	-4.5181e-008
2889	-4.971e-004	4.9998e-002	3.7e-002	-9.0394e-009
2890	4.9691e-004	4.9998e-002	3.7e-002	-9.036e-009
2891	1.491e-003	4.9978e-002	3.7e-002	-4.5171e-008
2892	2.4842e-003	4.9938e-002	3.7e-002	-1.174e-007
2893	3.4768e-003	4.9879e-002	3.7e-002	-2.2561e-007
2894	4.4677e-003	4.98e-002	3.7e-002	-3.6967e-007
2895	5.4571e-003	4.9701e-002	3.7e-002	-5.4938e-007
2896	6.444e-003	4.9583e-002	3.7e-002	-7.6449e-007
2897	7.4287e-003	4.9445e-002	3.7e-002	-1.0147e-006
2898	8.4101e-003	4.9288e-002	3.7e-002	-1.2997e-006
2899	9.3886e-003	4.9111e-002	3.7e-002	-1.6191e-006
2900	1.0363e-002	4.8914e-002	3.7e-002	-1.9724e-006
2901	1.1334e-002	4.8699e-002	3.7e-002	-2.3592e-006
2902	1.2299e-002	4.8464e-002	3.7e-002	-2.7789e-006
2903	1.3261e-002	4.8209e-002	3.7e-002	-3.2309e-006
2904	1.4216e-002	4.7936e-002	3.7e-002	-3.7147e-006
2905	1.5167e-002	4.7644e-002	3.7e-002	-4.2296e-006
2906	1.6111e-002	4.7333e-002	3.7e-002	-4.7748e-006
2907	1.7049e-002	4.7003e-002	3.7e-002	-5.3497e-006
2908	1.798e-002	4.6655e-002	3.7e-002	-5.9533e-006
2909	1.8904e-002	4.6289e-002	3.7e-002	-6.585e-006
2910	1.9821e-002	4.5904e-002	3.7e-002	-7.2437e-006
2911	2.073e-002	4.55e-002	3.7e-002	-7.9287e-006
2912	2.2522e-002	4.464e-002	3.7e-002	-9.3733e-006
2913	2.3405e-002	4.4184e-002	3.7e-002	-1.0131e-005
2914	2.4279e-002	4.371e-002	3.7e-002	-1.0911e-005
2915	-2.5143e-002	4.3218e-002	3.6e-002	-1.1712e-005
2916	-2.5143e-002	4.3218e-002	3.5e-002	-1.1712e-005
2917	-2.5143e-002	4.3218e-002	3.4e-002	-1.1712e-005
2918	-2.5143e-002	4.3218e-002	3.3e-002	-1.1712e-005
2919	-2.5143e-002	4.3218e-002	3.2e-002	-1.1712e-005
2920	-2.5143e-002	4.3218e-002	3.1e-002	-1.1712e-005
2921	-2.5143e-002	4.3218e-002	3.e-002	-1.1712e-005
2922	-2.5143e-002	4.3218e-002	2.9e-002	-1.1712e-005
2923	-2.5143e-002	4.3218e-002	2.8e-002	-1.1712e-005
2924	-2.5143e-002	4.3218e-002	2.7e-002	-1.1712e-005
2925	-2.5143e-002	4.3218e-002	2.6e-002	-1.1715e-005
2926	-2.5156e-002	4.3211e-002	2.5015e-002	-1.1729e-005
2927	-2.5188e-002	4.3192e-002	2.4023e-002	-1.1751e-005
2928	-2.4279e-002	4.371e-002	1.4e-002	-1.0907e-005
2929	-2.4279e-002	4.371e-002	1.5e-002	-1.0908e-005
2930	-2.4279e-002	4.371e-002	1.6e-002	-1.0911e-005
2931	-2.4287e-002	4.3705e-002	1.7006e-002	-1.0918e-005
2932	-2.4302e-002	4.3697e-002	1.802e-002	-1.0931e-005
2933	-2.4322e-002	4.3686e-002	1.9028e-002	-1.0948e-005
2934	-2.434e-002	4.3675e-002	2.003e-002	-1.0961e-005
2935	-2.4339e-002	4.3676e-002	2.1031e-002	-1.0965e-005
2936	2.4279e-002	4.3709e-002	1.4e-002	-1.0911e-005
2937	2.3405e-002	4.4184e-002	1.4e-002	-1.0131e-005
2938	2.2522e-002	4.464e-002	1.4e-002	-9.3734e-006
2939	2.163e-002	4.5079e-002	1.4e-002	-8.639e-006
2940	2.073e-002	4.55e-002	1.4e-002	-7.9288e-006
2941	1.9821e-002	4.5903e-002	1.4e-002	-7.2438e-006
2942	1.8904e-002	4.6289e-002	1.4e-002	-6.5851e-006
2943	1.798e-002	4.6655e-002	1.4e-002	-5.9534e-006
2944	1.6111e-002	4.7333e-002	1.4e-002	-4.7749e-006
2945	1.4217e-002	4.7936e-002	1.4e-002	-3.7148e-006
2946	1.3261e-002	4.8209e-002	1.4e-002	-3.231e-006
2947	1.23e-002	4.8464e-002	1.4e-002	-2.7789e-006
2948	1.1334e-002	4.8699e-002	1.4e-002	-2.3592e-006
2949	1.0363e-002	4.8914e-002	1.4e-002	-1.9724e-006
2950	9.3886e-003	4.9111e-002	1.4e-002	-1.6191e-006
2951	8.4103e-003	4.9288e-002	1.4e-002	-1.2997e-006
2952	7.4288e-003	4.9445e-002	1.4e-002	-1.0147e-006
2953	6.4442e-003	4.9583e-002	1.4e-002	-7.6452e-007
2954	5.4571e-003	4.9701e-002	1.4e-002	-5.494e-007
2955	4.4678e-003	4.98e-002	1.4e-002	-3.6969e-007
2956	3.4769e-003	4.9879e-002	1.4e-002	-2.2563e-007
2957	2.4844e-003	4.9938e-002	1.4e-002	-1.1741e-007
2958	1.4911e-003	4.9978e-002	1.4e-002	-4.5178e-008
2959	4.9709e-004	4.9998e-002	1.4e-002	-9.0383e-009
2960	-4.9703e-004	4.9998e-002	1.4e-002	-9.0371e-009
2961	-1.491e-003	4.9978e-002	1.4e-002	-4.5174e-008
2962	-2.4844e-003	4.9938e-002	1.4e-002	-1.174e-007
2963	-3.4768e-003	4.9879e-002	1.4e-002	-2.2562e-007
2964	-4.4678e-003	4.98e-002	1.4e-002	-3.6968e-007
2965	-5.4571e-003	4.9701e-002	1.4e-002	-5.4939e-007
2966	-6.4441e-003	4.9583e-002	1.4e-002	-7.645e-007
2967	-7.4287e-003	4.9445e-002	1.4e-002	-1.0147e-006
2968	-8.4103e-003	4.9288e-002	1.4e-002	-1.2997e-006
2969	-9.3886e-003	4.9111e-002	1.4e-002	-1.6191e-006
2970	-1.0363e-002	4.8914e-002	1.4e-002	-1.9724e-006
2971	-1.1334e-002	4.8699e-002	1.4e-002	-2.3592e-006
2972	-1.23e-002	4.8464e-002	1.4e-002	-2.7789e-006
2973	-1.3261e-002	4.8209e-002	1.4e-002	-3.231e-006
2974	-1.4217e-002	4.7936e-002	1.4e-002	-3.7148e-006
2975	-1.5167e-002	4.7644e-002	1.4e-002	-4.2296e-006
2976	-1.6111e-002	4.7333e-002	1.4e-002	-4.7749e-006
2977	-1.7049e-002	4.7003e-002	1.4e-002	-5.3497e-006
2978	-1.798e-002	4.6655e-002	1.4e-002	-5.9534e-006
2979	-1.8904e-002	4.6289e-002	1.4e-002	-6.585e-006
2980	-1.9821e-002	4.5904e-002	1.4e-002	-7.2438e-006
2981	-2.073e-002	4.55e-002	1.4e-002	-7.9287e-006
2982	-2.163e-002	4.5079e-002	1.4e-002	-8.6389e-006
2983	-2.2522e-002	4.464e-002	1.4e-002	-9.3733e-006
2984	-2.3405e-002	4.4184e-002	1.4e-002	-1.0131e-005
2985	2.4279e-002	4.371e-002	3.6e-002	-1.0911e-005
2986	2.4279e-002	4.371e-002	3.5e-002	-1.0911e-005
2987	2.4279e-002	4.371e-002	3.4e-002	-1.0911e-005
2988	2.4279e-002	4.371e-002	3.3e-002	-1.0911e-005
2989	2.4279e-002	4.371e-002	3.2e-002	-1.0911e-005
2990	2.4279e-002	4.371e-002	3.1e-002	-1.0911e-005
2991	2.4279e-002	4.371e-002	3.e-002	-1.0911e-005
2992	2.4279e-002	4.371e-002	2.9e-002	-1.0911e-005
2993	2.4279e-002	4.371e-002	2.8e-002	-1.0911e-005
2994	2.4279e-002	4.371e-002	2.7e-002	-1.0911e-005
2995	2.4279e-002	4.371e-002	2.6e-002	-1.0911e-005
2996	2.4279e-002	4.371e-002	2.5e-002	-1.0911e-005
2997	2.4279e-002	4.371e-002	2.4e-002	-1.0911e-005
2998	2.4279e-002	4.371e-002	2.3e-002	-1.0911e-005
2999	2.4279e-002	4.371e-002	2.2e-002	-1.0911e-005
3000	2.4279e-002	4.371e-002	2.1e-002	-1.0911e-005
3001	2.4279e-002	4.371e-002	2.e-002	-1.0911e-005
3002	2.4279e-002	4.3709e-002	1.9e-002	-1.0911e-005
3003	2.4279e-002	4.3709e-002	1.8e-002	-1.0911e-005
3004	2.4279e-002	4.3709e-002	1.7e-002	-1.0911e-005
3005	2.4279e-002	4.3709e-002	1.6e-002	-1.0911e-005
3006	2.4279e-002	4.3709e-002	1.5e-002	-1.0911e-005
3007	-2.4279e-002	4.371e-002	3.6e-002	-1.0911e-005
3008	-2.3405e-002	4.4184e-002	3.6e-002	-1.0131e-005
3009	-2.2522e-002	4.464e-002	3.6e-002	-9.3734e-006
3010	-2.163e-002	4.5079e-002	3.6e-002	-8.639e-006
3011	-2.073e-002	4.55e-002	3.6e-002	-7.9288e-006
3012	-1.9821e-002	4.5904e-002	3.6e-002	-7.2439e-006
3013	-1.8904e-002	4.6288e-002	3.6e-002	-6.5851e-006
3014	-1.798e-002	4.6655e-002	3.6e-002	-5.9535e-006
3015	-1.7049e-002	4.7003e-002	3.6e-002	-5.3498e-006
3016	-1.6111e-002	4.7333e-002	3.6e-002	-4.7749e-006
3017	-1.5167e-002	4.7644e-002	3.6e-002	-4.2297e-006
3018	-1.4217e-002	4.7936e-002	3.6e-002	-3.7148e-006
3019	-1.3261e-002	4.8209e-002	3.6e-002	-3.231e-006
3020	-1.23e-002	4.8464e-002	3.6e-002	-2.779e-006
3021	-1.1334e-002	4.8699e-002	3.6e-002	-2.3592e-006
3022	-1.0363e-002	4.8914e-002	3.6e-002	-1.9725e-006
3023	-9.3888e-003	4.9111e-002	3.6e-002	-1.6191e-006
3024	-8.4104e-003	4.9288e-002	3.6e-002	-1.2998e-006
3025	-7.4289e-003	4.9445e-002	3.6e-002	-1.0148e-006
3026	-6.4442e-003	4.9583e-002	3.6e-002	-7.6454e-007
3027	-5.4572e-003	4.9701e-002	3.6e-002	-5.4942e-007
3028	-4.4679e-003	4.98e-002	3.6e-002	-3.697e-007
3029	-3.477e-003	4.9879e-002	3.6e-002	-2.2564e-007
3030	-2.4845e-003	4.9938e-002	3.6e-002	-1.1741e-007
3031	-1.4912e-003	4.9978e-002	3.6e-002	-4.5182e-008
3032	-4.9714e-004	4.9998e-002	3.6e-002	-9.0397e-009
3033	4.9691e-004	4.9998e-002	3.6e-002	-9.0357e-009
3034	1.491e-003	4.9978e-002	3.6e-002	-4.517e-008
3035	2.4842e-003	4.9938e-002	3.6e-002	-1.1739e-007
3036	3.4767e-003	4.9879e-002	3.6e-002	-2.2561e-007
3037	4.4676e-003	4.98e-002	3.6e-002	-3.6967e-007
3038	5.457e-003	4.9701e-002	3.6e-002	-5.4937e-007
3039	6.444e-003	4.9583e-002	3.6e-002	-7.6448e-007
3040	7.4286e-003	4.9445e-002	3.6e-002	-1.0147e-006
3041	8.4101e-003	4.9288e-002	3.6e-002	-1.2997e-006
3042	9.3885e-003	4.9111e-002	3.6e-002	-1.6191e-006
3043	1.0363e-002	4.8914e-002	3.6e-002	-1.9724e-006
3044	1.1334e-002	4.8699e-002	3.6e-002	-2.3591e-006
3045	1.2299e-002	4.8464e-002	3.6e-002	-2.7789e-006
3046	1.3261e-002	4.8209e-002	3.6e-002	-3.2309e-006
3047	1.4216e-002	4.7936e-002	3.6e-002	-3.7147e-006
3048	1.5167e-002	4.7644e-002	3.6e-002	-4.2296e-006
3049	1.6111e-002	4.7333e-002	3.6e-002	-4.7748e-006
3050	1.7049e-002	4.7004e-002	3.6e-002	-5.3497e-006
3051	1.798e-002	4.6655e-002	3.6e-002	-5.9533e-006
3052	1.8904e-002	4.6289e-002	3.6e-002	-6.585e-006
3053	1.9821e-002	4.5904e-002	3.6e-002	-7.2437e-006
3054	2.073e-002	4.55e-002	3.6e-002	-7.9287e-006
3055	2.163e-002	4.5079e-002	3.6e-002	-8.6389e-006
3056	2.2522e-002	4.464e-002	3.6e-002	-9.3733e-006
3057	2.3405e-002	4.4184e-002	3.6e-002	-1.0131e-005
3058	-2.4289e-002	4.3704e-002	2.5003e-002	-1.0921e-005
3059	-2.4279e-002	4.3709e-002	3.5e-002	-1.0911e-005
3060	-2.4279e-002	4.3709e-002	3.4e-002	-1.0911e-005
3061	-2.4279e-002	4.3709e-002	3.3e-002	-1.0911e-005
3062	-2.4279e-002	4.3709e-002	3.2e-002	-1.0911e-005
3063	-2.4279e-002	4.3709e-002	3.1e-002	-1.0911e-005
3064	-2.4279e-002	4.3709e-002	3.e-002	-1.0911e-005
3065	-2.4279e-002	4.3709e-002	2.9e-002	-1.0911e-005
3066	-2.4279e-002	4.3709e-002	2.8e-002	-1.0911e-005
3067	-2.428e-002	4.3709e-002	2.7e-002	-1.0911e-005
3068	-2.428e-002	4.3709e-002	2.6e-002	-1.0913e-005
3069	-2.3405e-002	4.4184e-002	1.5e-002	-1.0131e-005
3070	-2.3405e-002	4.4184e-002	1.6e-002	-1.0131e-005
3071	-2.3416e-002	4.4178e-002	1.8004e-002	-1.0142e-005
3072	-2.3431e-002	4.417e-002	1.9014e-002	-1.0153e-005
3073	-2.3441e-002	4.4164e-002	2.0016e-002	-1.0162e-005
3074	-2.3447e-002	4.4161e-002	2.1016e-002	-1.0165e-005
3075	2.3405e-002	4.4184e-002	1.5e-002	-1.0131e-005
3076	2.2522e-002	4.464e-002	1.5e-002	-9.3734e-006
3077	2.163e-002	4.5079e-002	1.5e-002	-8.6389e-006
3078	2.073e-002	4.55e-002	1.5e-002	-7.9288e-006
3079	1.9821e-002	4.5903e-002	1.5e-002	-7.2439e-006
3080	1.8904e-002	4.6289e-002	1.5e-002	-6.5851e-006
3081	1.798e-002	4.6655e-002	1.5e-002	-5.9534e-006
3082	1.7049e-002	4.7003e-002	1.5e-002	-5.3498e-006
3083	1.6111e-002	4.7333e-002	1.5e-002	-4.7749e-006
3084	1.5167e-002	4.7644e-002	1.5e-002	-4.2297e-006
3085	1.4217e-002	4.7936e-002	1.5e-002	-3.7148e-006
3086	1.3261e-002	4.8209e-002	1.5e-002	-3.231e-006
3087	1.23e-002	4.8464e-002	1.5e-002	-2.7789e-006
3088	1.1334e-002	4.8699e-002	1.5e-002	-2.3592e-006
3089	1.0363e-002	4.8914e-002	1.5e-002	-1.9724e-006
3090	9.3886e-003	4.9111e-002	1.5e-002	-1.6191e-006
3091	8.4103e-003	4.9288e-002	1.5e-002	-1.2997e-006
3092	7.4287e-003	4.9445e-002	1.5e-002	-1.0147e-006
3093	6.4442e-003	4.9583e-002	1.5e-002	-7.6452e-007
3094	5.4571e-003	4.9701e-002	1.5e-002	-5.494e-007
3095	4.4678e-003	4.98e-002	1.5e-002	-3.6969e-007
3096	3.4768e-003	4.9879e-002	1.5e-002	-2.2563e-007
3097	2.4844e-003	4.9938e-002	1.5e-002	-1.1741e-007
3098	1.4911e-003	4.9978e-002	1.5e-002	-4.5178e-008
3099	4.9711e-004	4.9998e-002	1.5e-002	-9.0383e-009
3100	-4.9704e-004	4.9998e-002	1.5e-002	-9.037e-009
3101	-1.491e-003	4.9978e-002	1.5e-002	-4.5174e-008
3102	-2.4844e-003	4.9938e-002	1.5e-002	-1.174e-007
3103	-3.4768e-003	4.9879e-002	1.5e-002	-2.2562e-007
3104	-4.4678e-003	4.98e-002	1.5e-002	-3.6968e-007
3105	-5.457e-003	4.9701e-002	1.5e-002	-5.4939e-007
3106	-6.4441e-003	4.9583e-002	1.5e-002	-7.645e-007
3107	-7.4287e-003	4.9445e-002	1.5e-002	-1.0147e-006
3108	-8.4103e-003	4.9288e-002	1.5e-002	-1.2997e-006
3109	-9.3886e-003	4.9111e-002	1.5e-002	-1.6191e-006
3110	-1.0363e-002	4.8914e-002	1.5e-002	-1.9724e-006
3111	-1.1334e-002	4.8699e-002	1.5e-002	-2.3592e-006
3112	-1.23e-002	4.8464e-002	1.5e-002	-2.7789e-006
3113	-1.3261e-002	4.8209e-002	1.5e-002	-3.2309e-006
3114	-1.4217e-002	4.7936e-002	1.5e-002	-3.7147e-006
3115	-1.5167e-002	4.7644e-002	1.5e-002	-4.2296e-006
3116	-1.6111e-002	4.7333e-002	1.5e-002	-4.7749e-006
3117	-1.7049e-002	4.7004e-002	1.5e-002	-5.3497e-006
3118	-1.798e-002	4.6655e-002	1.5e-002	-5.9534e-006
3119	-1.8904e-002	4.6289e-002	1.5e-002	-6.585e-006
3120	-1.9821e-002	4.5904e-002	1.5e-002	-7.2438e-006
3121	-2.073e-002	4.55e-002	1.5e-002	-7.9287e-006
3122	-2.2522e-002	4.464e-002	1.5e-002	-9.3733e-006
3123	2.3405e-002	4.4184e-002	3.5e-002	-1.0131e-005
3124	2.3405e-002	4.4184e-002	3.4e-002	-1.0131e-005
3125	2.3405e-002	4.4184e-002	3.3e-002	-1.0131e-005
3126	2.3405e-002	4.4184e-002	3.2e-002	-1.0131e-005
3127	2.3405e-002	4.4184e-002	3.1e-002	-1.0131e-005
3128	2.3405e-002	4.4184e-002	3.e-002	-1.0131e-005
3129	2.3405e-002	4.4184e-002	2.9e-002	-1.0131e-005
3130	2.3405e-002	4.4184e-002	2.8e-002	-1.0131e-005
3131	2.3405e-002	4.4184e-002	2.7e-002	-1.0131e-005
3132	2.3405e-002	4.4184e-002	2.6e-002	-1.0131e-005
3133	2.3405e-002	4.4184e-002	2.5e-002	-1.0131e-005
3134	2.3405e-002	4.4184e-002	2.4e-002	-1.0131e-005
3135	2.3405e-002	4.4184e-002	2.3e-002	-1.0131e-005
3136	2.3405e-002	4.4184e-002	2.2e-002	-1.0131e-005
3137	2.3405e-002	4.4184e-002	2.1e-002	-1.0131e-005
3138	2.3405e-002	4.4184e-002	2.e-002	-1.0131e-005
3139	2.3405e-002	4.4184e-002	1.9e-002	-1.0131e-005
3140	2.3405e-002	4.4184e-002	1.8e-002	-1.0131e-005
3141	2.3405e-002	4.4184e-002	1.7e-002	-1.0131e-005
3142	2.3406e-002	4.4183e-002	1.6e-002	-1.0131e-005
3143	-2.4324e-002	4.3684e-002	2.3019e-002	-1.095e-005
3144	-2.4332e-002	4.368e-002	2.2025e-002	-1.0959e-005
3145	-2.3405e-002	4.4184e-002	3.5e-002	-1.0131e-005
3146	-2.2522e-002	4.464e-002	3.5e-002	-9.3734e-006
3147	-2.163e-002	4.5079e-002	3.5e-002	-8.639e-006
3148	-2.073e-002	4.55e-002	3.5e-002	-7.9288e-006
3149	-1.9821e-002	4.5904e-002	3.5e-002	-7.2439e-006
3150	-1.8904e-002	4.6288e-002	3.5e-002	-6.5851e-006
3151	-1.798e-002	4.6655e-002	3.5e-002	-5.9535e-006
3152	-1.7049e-002	4.7003e-002	3.5e-002	-5.3498e-006
3153	-1.6111e-002	4.7333e-002	3.5e-002	-4.775e-006
3154	-1.5167e-002	4.7644e-002	3.5e-002	-4.2297e-006
3155	-1.4217e-002	4.7936e-002	3.5e-002	-3.7148e-006
3156	-1.3261e-002	4.8209e-002	3.5e-002	-3.231e-006
3157	-1.23e-002	4.8464e-002	3.5e-002	-2.779e-006
3158	-1.1334e-002	4.8699e-002	3.5e-002	-2.3592e-006
3159	-1.0363e-002	4.8914e-002	3.5e-002	-1.9725e-006
3160	-9.3888e-003	4.9111e-002	3.5e-002	-1.6191e-006
3161	-8.4104e-003	4.9288e-002	3.5e-002	-1.2998e-006
3162	-7.4289e-003	4.9445e-002	3.5e-002	-1.0148e-006
3163	-6.4442e-003	4.9583e-002	3.5e-002	-7.6454e-007
3164	-5.4572e-003	4.9701e-002	3.5e-002	-5.4942e-007
3165	-4.4679e-003	4.98e-002	3.5e-002	-3.6971e-007
3166	-3.477e-003	4.9879e-002	3.5e-002	-2.2564e-007
3167	-2.4845e-003	4.9938e-002	3.5e-002	-1.1742e-007
3168	-1.4912e-003	4.9978e-002	3.5e-002	-4.5183e-008
3169	-4.9714e-004	4.9998e-002	3.5e-002	-9.0399e-009
3170	4.9692e-004	4.9998e-002	3.5e-002	-9.0354e-009
3171	1.491e-003	4.9978e-002	3.5e-002	-4.5169e-008
3172	2.4843e-003	4.9938e-002	3.5e-002	-1.1739e-007
3173	3.4767e-003	4.9879e-002	3.5e-002	-2.2561e-007
3174	4.4677e-003	4.98e-002	3.5e-002	-3.6967e-007
3175	5.457e-003	4.9701e-002	3.5e-002	-5.4937e-007
3176	6.444e-003	4.9583e-002	3.5e-002	-7.6448e-007
3177	7.4286e-003	4.9445e-002	3.5e-002	-1.0147e-006
3178	8.4102e-003	4.9288e-002	3.5e-002	-1.2997e-006
3179	9.3885e-003	4.9111e-002	3.5e-002	-1.6191e-006
3180	1.0363e-002	4.8914e-002	3.5e-002	-1.9724e-006
3181	1.1334e-002	4.8699e-002	3.5e-002	-2.3591e-006
3182	1.2299e-002	4.8464e-002	3.5e-002	-2.7788e-006
3183	1.3261e-002	4.8209e-002	3.5e-002	-3.2309e-006
3184	1.4216e-002	4.7936e-002	3.5e-002	-3.7147e-006
3185	1.5167e-002	4.7644e-002	3.5e-002	-4.2296e-006
3186	1.6111e-002	4.7333e-002	3.5e-002	-4.7748e-006
3187	1.7049e-002	4.7004e-002	3.5e-002	-5.3497e-006
3188	1.798e-002	4.6655e-002	3.5e-002	-5.9533e-006
3189	1.8904e-002	4.6289e-002	3.5e-002	-6.585e-006
3190	1.9821e-002	4.5904e-002	3.5e-002	-7.2437e-006
3191	2.073e-002	4.55e-002	3.5e-002	-7.9287e-006
3192	2.163e-002	4.5079e-002	3.5e-002	-8.6389e-006
3193	2.2522e-002	4.464e-002	3.5e-002	-9.3733e-006
3194	-2.3405e-002	4.4184e-002	3.4e-002	-1.0131e-005
3195	-2.3405e-002	4.4184e-002	3.3e-002	-1.0131e-005
3196	-2.3405e-002	4.4184e-002	3.2e-002	-1.0131e-005
3197	-2.3405e-002	4.4184e-002	3.1e-002	-1.0131e-005
3198	-2.3405e-002	4.4184e-002	3.e-002	-1.0131e-005
3199	-2.3405e-002	4.4184e-002	2.9e-002	-1.0131e-005
3200	-2.3405e-002	4.4184e-002	2.8e-002	-1.0131e-005
3201	-2.3405e-002	4.4184e-002	2.7e-002	-1.0131e-005
3202	-2.3405e-002	4.4184e-002	2.6e-002	-1.0132e-005
3203	-2.3405e-002	4.4184e-002	2.5e-002	-1.0135e-005
3204	-2.2522e-002	4.464e-002	1.7e-002	-9.3739e-006
3205	-2.2522e-002	4.464e-002	1.8e-002	-9.3768e-006
3206	-2.2532e-002	4.4636e-002	1.9003e-002	-9.3819e-006
3207	-2.2535e-002	4.4634e-002	2.0005e-002	-9.387e-006
3208	-2.2541e-002	4.4631e-002	2.1005e-002	-9.3896e-006
3209	2.2522e-002	4.464e-002	1.6e-002	-9.3734e-006
3210	2.163e-002	4.5079e-002	1.6e-002	-8.6389e-006
3211	2.073e-002	4.55e-002	1.6e-002	-7.9288e-006
3212	1.9821e-002	4.5903e-002	1.6e-002	-7.2439e-006
3213	1.8904e-002	4.6289e-002	1.6e-002	-6.5851e-006
3214	1.798e-002	4.6655e-002	1.6e-002	-5.9534e-006
3215	1.7049e-002	4.7003e-002	1.6e-002	-5.3498e-006
3216	1.6111e-002	4.7333e-002	1.6e-002	-4.7749e-006
3217	1.5167e-002	4.7644e-002	1.6e-002	-4.2297e-006
3218	1.4217e-002	4.7936e-002	1.6e-002	-3.7148e-006
3219	1.3261e-002	4.8209e-002	1.6e-002	-3.231e-006
3220	1.23e-002	4.8464e-002	1.6e-002	-2.7789e-006
3221	1.1334e-002	4.8699e-002	1.6e-002	-2.3592e-006
3222	1.0363e-002	4.8914e-002	1.6e-002	-1.9724e-006
3223	9.3886e-003	4.9111e-002	1.6e-002	-1.6191e-006
3224	8.4104e-003	4.9288e-002	1.6e-002	-1.2997e-006
3225	7.4287e-003	4.9445e-002	1.6e-002	-1.0147e-006
3226	6.4442e-003	4.9583e-002	1.6e-002	-7.6452e-007
3227	5.4571e-003	4.9701e-002	1.6e-002	-5.4941e-007
3228	4.4679e-003	4.98e-002	1.6e-002	-3.6969e-007
3229	3.4768e-003	4.9879e-002	1.6e-002	-2.2563e-007
3230	2.4845e-003	4.9938e-002	1.6e-002	-1.1741e-007
3231	1.4911e-003	4.9978e-002	1.6e-002	-4.5179e-008
3232	4.9714e-004	4.9998e-002	1.6e-002	-9.0385e-009
3233	-4.9704e-004	4.9998e-002	1.6e-002	-9.0368e-009
3234	-1.491e-003	4.9978e-002	1.6e-002	-4.5174e-008
3235	-2.4844e-003	4.9938e-002	1.6e-002	-1.174e-007
3236	-3.4767e-003	4.9879e-002	1.6e-002	-2.2562e-007
3237	-4.4678e-003	4.98e-002	1.6e-002	-3.6968e-007
3238	-5.457e-003	4.9701e-002	1.6e-002	-5.4939e-007
3239	-6.4441e-003	4.9583e-002	1.6e-002	-7.645e-007
3240	-7.4286e-003	4.9445e-002	1.6e-002	-1.0147e-006
3241	-8.4103e-003	4.9288e-002	1.6e-002	-1.2997e-006
3242	-9.3885e-003	4.9111e-002	1.6e-002	-1.6191e-006
3243	-1.0363e-002	4.8914e-002	1.6e-002	-1.9724e-006
3244	-1.1334e-002	4.8699e-002	1.6e-002	-2.3592e-006
3245	-1.23e-002	4.8464e-002	1.6e-002	-2.7789e-006
3246	-1.3261e-002	4.8209e-002	1.6e-002	-3.2309e-006
3247	-1.4217e-002	4.7936e-002	1.6e-002	-3.7147e-006
3248	-1.5167e-002	4.7644e-002	1.6e-002	-4.2296e-006
3249	-1.6111e-002	4.7333e-002	1.6e-002	-4.7748e-006
3250	-1.7049e-002	4.7004e-002	1.6e-002	-5.3497e-006
3251	-1.798e-002	4.6655e-002	1.6e-002	-5.9534e-006
3252	-1.8904e-002	4.6289e-002	1.6e-002	-6.585e-006
3253	-1.9821e-002	4.5904e-002	1.6e-002	-7.2438e-006
3254	-2.073e-002	4.55e-002	1.6e-002	-7.9287e-006
3255	-2.163e-002	4.5079e-002	1.6e-002	-8.6389e-006
3256	2.2522e-002	4.464e-002	3.4e-002	-9.3734e-006
3257	2.2522e-002	4.464e-002	3.3e-002	-9.3734e-006
3258	2.2522e-002	4.464e-002	3.2e-002	-9.3734e-006
3259	2.2522e-002	4.464e-002	3.1e-002	-9.3734e-006
3260	2.2522e-002	4.464e-002	3.e-002	-9.3734e-006
3261	2.2522e-002	4.464e-002	2.9e-002	-9.3734e-006
3262	2.2522e-002	4.464e-002	2.8e-002	-9.3734e-006
3263	2.2522e-002	4.464e-002	2.7e-002	-9.3734e-006
3264	2.2522e-002	4.464e-002	2.6e-002	-9.3734e-006
3265	2.2522e-002	4.464e-002	2.4e-002	-9.3734e-006
3266	2.2522e-002	4.464e-002	2.3e-002	-9.3734e-006
3267	2.2522e-002	4.464e-002	2.2e-002	-9.3734e-006
3268	2.2522e-002	4.464e-002	2.1e-002	-9.3734e-006
3269	2.2522e-002	4.464e-002	2.e-002	-9.3734e-006
3270	2.2522e-002	4.464e-002	1.9e-002	-9.3734e-006
3271	2.2522e-002	4.464e-002	1.8e-002	-9.3733e-006
3272	-2.2522e-002	4.464e-002	3.4e-002	-9.3734e-006
3273	-2.163e-002	4.5079e-002	3.4e-002	-8.639e-006
3274	-2.073e-002	4.55e-002	3.4e-002	-7.9288e-006
3275	-1.9821e-002	4.5904e-002	3.4e-002	-7.2439e-006
3276	-1.8904e-002	4.6288e-002	3.4e-002	-6.5851e-006
3277	-1.798e-002	4.6655e-002	3.4e-002	-5.9535e-006
3278	-1.7049e-002	4.7003e-002	3.4e-002	-5.3498e-006
3279	-1.6111e-002	4.7333e-002	3.4e-002	-4.775e-006
3280	-1.5167e-002	4.7644e-002	3.4e-002	-4.2297e-006
3281	-1.4217e-002	4.7936e-002	3.4e-002	-3.7148e-006
3282	-1.3261e-002	4.8209e-002	3.4e-002	-3.231e-006
3283	-1.23e-002	4.8464e-002	3.4e-002	-2.779e-006
3284	-1.1334e-002	4.8699e-002	3.4e-002	-2.3593e-006
3285	-1.0363e-002	4.8914e-002	3.4e-002	-1.9725e-006
3286	-9.3888e-003	4.9111e-002	3.4e-002	-1.6191e-006
3287	-8.4104e-003	4.9288e-002	3.4e-002	-1.2998e-006
3288	-7.4289e-003	4.9445e-002	3.4e-002	-1.0148e-006
3289	-6.4442e-003	4.9583e-002	3.4e-002	-7.6454e-007
3290	-5.4573e-003	4.9701e-002	3.4e-002	-5.4942e-007
3291	-4.4679e-003	4.98e-002	3.4e-002	-3.6971e-007
3292	-3.477e-003	4.9879e-002	3.4e-002	-2.2564e-007
3293	-2.4845e-003	4.9938e-002	3.4e-002	-1.1742e-007
3294	-1.4912e-003	4.9978e-002	3.4e-002	-4.5184e-008
3295	-4.9717e-004	4.9998e-002	3.4e-002	-9.0402e-009
3296	4.9687e-004	4.9998e-002	3.4e-002	-9.0352e-009
3297	1.491e-003	4.9978e-002	3.4e-002	-4.5169e-008
3298	2.4842e-003	4.9938e-002	3.4e-002	-1.1739e-007
3299	3.4767e-003	4.9879e-002	3.4e-002	-2.2561e-007
3300	4.4676e-003	4.98e-002	3.4e-002	-3.6966e-007
3301	5.457e-003	4.9701e-002	3.4e-002	-5.4937e-007
3302	6.444e-003	4.9583e-002	3.4e-002	-7.6448e-007
3303	7.4286e-003	4.9445e-002	3.4e-002	-1.0147e-006
3304	8.4101e-003	4.9288e-002	3.4e-002	-1.2997e-006
3305	9.3885e-003	4.9111e-002	3.4e-002	-1.6191e-006
3306	1.0363e-002	4.8914e-002	3.4e-002	-1.9724e-006
3307	1.1334e-002	4.8699e-002	3.4e-002	-2.3591e-006
3308	1.2299e-002	4.8464e-002	3.4e-002	-2.7788e-006
3309	1.3261e-002	4.8209e-002	3.4e-002	-3.2309e-006
3310	1.4216e-002	4.7936e-002	3.4e-002	-3.7147e-006
3311	1.5167e-002	4.7644e-002	3.4e-002	-4.2296e-006
3312	1.6111e-002	4.7333e-002	3.4e-002	-4.7748e-006
3313	1.7049e-002	4.7004e-002	3.4e-002	-5.3496e-006
3314	1.798e-002	4.6655e-002	3.4e-002	-5.9533e-006
3315	1.8904e-002	4.6289e-002	3.4e-002	-6.5849e-006
3316	1.9821e-002	4.5904e-002	3.4e-002	-7.2437e-006
3317	2.073e-002	4.55e-002	3.4e-002	-7.9287e-006
3318	2.163e-002	4.5079e-002	3.4e-002	-8.6389e-006
3319	-2.3417e-002	4.4177e-002	2.3998e-002	-1.0144e-005
3320	-2.343e-002	4.417e-002	2.3001e-002	-1.0154e-005
3321	-2.3441e-002	4.4165e-002	2.2009e-002	-1.0161e-005
3322	-2.2522e-002	4.464e-002	3.3e-002	-9.3735e-006
3323	-2.2522e-002	4.464e-002	3.2e-002	-9.3735e-006
3324	-2.2523e-002	4.464e-002	3.1e-002	-9.3735e-006
3325	-2.2523e-002	4.464e-002	3.e-002	-9.3735e-006
3326	-2.2523e-002	4.464e-002	2.9e-002	-9.3735e-006
3327	-2.2523e-002	4.464e-002	2.8e-002	-9.3735e-006
3328	-2.2523e-002	4.464e-002	2.7e-002	-9.3735e-006
3329	-2.2523e-002	4.464e-002	2.6e-002	-9.3736e-006
3330	-2.2523e-002	4.464e-002	2.5e-002	-9.3742e-006
3331	-2.2523e-002	4.464e-002	2.4e-002	-9.3774e-006
3332	-2.163e-002	4.5079e-002	1.7e-002	-8.6389e-006
3333	-2.163e-002	4.5079e-002	1.8e-002	-8.6394e-006
3334	-2.163e-002	4.5079e-002	1.9e-002	-8.6405e-006
3335	-2.163e-002	4.5079e-002	2.e-002	-8.6426e-006
3336	-2.1638e-002	4.5075e-002	2.1001e-002	-8.644e-006
3337	2.163e-002	4.5079e-002	1.7e-002	-8.6389e-006
3338	2.073e-002	4.55e-002	1.7e-002	-7.9288e-006
3339	1.8904e-002	4.6289e-002	1.7e-002	-6.5851e-006
3340	1.798e-002	4.6655e-002	1.7e-002	-5.9534e-006
3341	1.7049e-002	4.7003e-002	1.7e-002	-5.3498e-006
3342	1.6111e-002	4.7333e-002	1.7e-002	-4.7749e-006
3343	1.5167e-002	4.7644e-002	1.7e-002	-4.2297e-006
3344	1.4217e-002	4.7936e-002	1.7e-002	-3.7148e-006
3345	1.3261e-002	4.8209e-002	1.7e-002	-3.231e-006
3346	1.23e-002	4.8464e-002	1.7e-002	-2.7789e-006
3347	1.1334e-002	4.8699e-002	1.7e-002	-2.3592e-006
3348	1.0363e-002	4.8914e-002	1.7e-002	-1.9724e-006
3349	9.3886e-003	4.9111e-002	1.7e-002	-1.6191e-006
3350	8.4104e-003	4.9288e-002	1.7e-002	-1.2997e-006
3351	7.4287e-003	4.9445e-002	1.7e-002	-1.0147e-006
3352	6.4442e-003	4.9583e-002	1.7e-002	-7.6452e-007
3353	5.4571e-003	4.9701e-002	1.7e-002	-5.4941e-007
3354	4.4679e-003	4.98e-002	1.7e-002	-3.6969e-007
3355	3.4768e-003	4.9879e-002	1.7e-002	-2.2563e-007
3356	2.4845e-003	4.9938e-002	1.7e-002	-1.1741e-007
3357	1.4911e-003	4.9978e-002	1.7e-002	-4.5179e-008
3358	4.9715e-004	4.9998e-002	1.7e-002	-9.0387e-009
3359	-4.9704e-004	4.9998e-002	1.7e-002	-9.0367e-009
3360	-1.491e-003	4.9978e-002	1.7e-002	-4.5173e-008
3361	-2.4844e-003	4.9938e-002	1.7e-002	-1.174e-007
3362	-3.4767e-003	4.9879e-002	1.7e-002	-2.2562e-007
3363	-4.4678e-003	4.98e-002	1.7e-002	-3.6968e-007
3364	-5.457e-003	4.9701e-002	1.7e-002	-5.4938e-007
3365	-6.4441e-003	4.9583e-002	1.7e-002	-7.645e-007
3366	-7.4286e-003	4.9445e-002	1.7e-002	-1.0147e-006
3367	-8.4103e-003	4.9288e-002	1.7e-002	-1.2997e-006
3368	-9.3885e-003	4.9111e-002	1.7e-002	-1.6191e-006
3369	-1.0363e-002	4.8914e-002	1.7e-002	-1.9724e-006
3370	-1.1334e-002	4.8699e-002	1.7e-002	-2.3592e-006
3371	-1.23e-002	4.8464e-002	1.7e-002	-2.7789e-006
3372	-1.3261e-002	4.8209e-002	1.7e-002	-3.2309e-006
3373	-1.4217e-002	4.7936e-002	1.7e-002	-3.7147e-006
3374	-1.5167e-002	4.7644e-002	1.7e-002	-4.2296e-006
3375	-1.6111e-002	4.7333e-002	1.7e-002	-4.7748e-006
3376	-1.7049e-002	4.7004e-002	1.7e-002	-5.3497e-006
3377	-1.798e-002	4.6655e-002	1.7e-002	-5.9533e-006
3378	-1.8904e-002	4.6289e-002	1.7e-002	-6.585e-006
3379	-2.073e-002	4.55e-002	1.7e-002	-7.9287e-006
3380	2.163e-002	4.5079e-002	3.3e-002	-8.6389e-006
3381	2.163e-002	4.5079e-002	3.2e-002	-8.6389e-006
3382	2.163e-002	4.5079e-002	3.1e-002	-8.6389e-006
3383	2.163e-002	4.5079e-002	3.e-002	-8.6389e-006
3384	2.163e-002	4.5079e-002	2.9e-002	-8.6389e-006
3385	2.163e-002	4.5079e-002	2.8e-002	-8.6389e-006
3386	2.163e-002	4.5079e-002	2.7e-002	-8.639e-006
3387	2.163e-002	4.5079e-002	2.6e-002	-8.639e-006
3388	2.163e-002	4.5079e-002	2.5e-002	-8.639e-006
3389	2.163e-002	4.5079e-002	2.4e-002	-8.639e-006
3390	2.163e-002	4.5079e-002	2.3e-002	-8.639e-006
3391	2.163e-002	4.5079e-002	2.2e-002	-8.639e-006
3392	2.1631e-002	4.5079e-002	2.e-002	-8.639e-006
3393	2.1631e-002	4.5079e-002	1.9e-002	-8.639e-006
3394	2.1631e-002	4.5079e-002	1.8e-002	-8.639e-006
3395	-2.2538e-002	4.4632e-002	2.2001e-002	-9.3877e-006
3396	-2.2534e-002	4.4634e-002	2.3e-002	-9.3828e-006
3397	-2.163e-002	4.5079e-002	3.3e-002	-8.639e-006
3398	-2.073e-002	4.55e-002	3.3e-002	-7.9288e-006
3399	-1.9821e-002	4.5903e-002	3.3e-002	-7.2439e-006
3400	-1.8904e-002	4.6288e-002	3.3e-002	-6.5851e-006
3401	-1.798e-002	4.6655e-002	3.3e-002	-5.9535e-006
3402	-1.7049e-002	4.7003e-002	3.3e-002	-5.3498e-006
3403	-1.6111e-002	4.7333e-002	3.3e-002	-4.775e-006
3404	-1.5167e-002	4.7644e-002	3.3e-002	-4.2297e-006
3405	-1.4217e-002	4.7936e-002	3.3e-002	-3.7148e-006
3406	-1.3261e-002	4.8209e-002	3.3e-002	-3.231e-006
3407	-1.23e-002	4.8464e-002	3.3e-002	-2.779e-006
3408	-1.1334e-002	4.8699e-002	3.3e-002	-2.3593e-006
3409	-1.0363e-002	4.8914e-002	3.3e-002	-1.9725e-006
3410	-9.3888e-003	4.9111e-002	3.3e-002	-1.6191e-006
3411	-8.4104e-003	4.9288e-002	3.3e-002	-1.2998e-006
3412	-7.4289e-003	4.9445e-002	3.3e-002	-1.0148e-006
3413	-6.4442e-003	4.9583e-002	3.3e-002	-7.6454e-007
3414	-5.4573e-003	4.9701e-002	3.3e-002	-5.4942e-007
3415	-4.4679e-003	4.98e-002	3.3e-002	-3.6971e-007
3416	-3.477e-003	4.9879e-002	3.3e-002	-2.2564e-007
3417	-2.4845e-003	4.9938e-002	3.3e-002	-1.1742e-007
3418	-1.4912e-003	4.9978e-002	3.3e-002	-4.5184e-008
3419	-4.9717e-004	4.9998e-002	3.3e-002	-9.0403e-009
3420	4.9688e-004	4.9998e-002	3.3e-002	-9.0351e-009
3421	1.491e-003	4.9978e-002	3.3e-002	-4.5168e-008
3422	2.4842e-003	4.9938e-002	3.3e-002	-1.1739e-007
3423	3.4767e-003	4.9879e-002	3.3e-002	-2.256e-007
3424	4.4676e-003	4.98e-002	3.3e-002	-3.6966e-007
3425	5.457e-003	4.9701e-002	3.3e-002	-5.4937e-007
3426	6.444e-003	4.9583e-002	3.3e-002	-7.6448e-007
3427	7.4286e-003	4.9445e-002	3.3e-002	-1.0147e-006
3428	8.4101e-003	4.9288e-002	3.3e-002	-1.2997e-006
3429	9.3885e-003	4.9111e-002	3.3e-002	-1.6191e-006
3430	1.0363e-002	4.8914e-002	3.3e-002	-1.9724e-006
3431	1.1334e-002	4.8699e-002	3.3e-002	-2.3591e-006
3432	1.2299e-002	4.8464e-002	3.3e-002	-2.7788e-006
3433	1.3261e-002	4.8209e-002	3.3e-002	-3.2309e-006
3434	1.4216e-002	4.7936e-002	3.3e-002	-3.7147e-006
3435	1.5167e-002	4.7644e-002	3.3e-002	-4.2296e-006
3436	1.6111e-002	4.7333e-002	3.3e-002	-4.7748e-006
3437	1.7049e-002	4.7004e-002	3.3e-002	-5.3496e-006
3438	1.798e-002	4.6655e-002	3.3e-002	-5.9533e-006
3439	1.8904e-002	4.6289e-002	3.3e-002	-6.5849e-006
3440	1.9821e-002	4.5904e-002	3.3e-002	-7.2437e-006
3441	2.073e-002	4.55e-002	3.3e-002	-7.9287e-006
3442	-2.163e-002	4.5079e-002	3.2e-002	-8.639e-006
3443	-2.163e-002	4.5079e-002	3.1e-002	-8.639e-006
3444	-2.163e-002	4.5079e-002	3.e-002	-8.639e-006
3445	-2.163e-002	4.5079e-002	2.8e-002	-8.639e-006
3446	-2.163e-002	4.5079e-002	2.7e-002	-8.639e-006
3447	-2.163e-002	4.5079e-002	2.6e-002	-8.639e-006
3448	2.073e-002	4.55e-002	1.8e-002	-7.9288e-006
3449	1.9821e-002	4.5903e-002	1.8e-002	-7.2438e-006
3450	1.8904e-002	4.6289e-002	1.8e-002	-6.5851e-006
3451	1.798e-002	4.6655e-002	1.8e-002	-5.9534e-006
3452	1.7049e-002	4.7003e-002	1.8e-002	-5.3498e-006
3453	1.5167e-002	4.7644e-002	1.8e-002	-4.2297e-006
3454	1.4217e-002	4.7936e-002	1.8e-002	-3.7148e-006
3455	1.3261e-002	4.8209e-002	1.8e-002	-3.231e-006
3456	1.23e-002	4.8464e-002	1.8e-002	-2.7789e-006
3457	1.1334e-002	4.8699e-002	1.8e-002	-2.3592e-006
3458	1.0363e-002	4.8914e-002	1.8e-002	-1.9724e-006
3459	9.3887e-003	4.9111e-002	1.8e-002	-1.6191e-006
3460	8.4104e-003	4.9288e-002	1.8e-002	-1.2997e-006
3461	7.4288e-003	4.9445e-002	1.8e-002	-1.0148e-006
3462	6.4442e-003	4.9583e-002	1.8e-002	-7.6453e-007
3463	5.4571e-003	4.9701e-002	1.8e-002	-5.4941e-007
3464	4.4679e-003	4.98e-002	1.8e-002	-3.697e-007
3465	3.4769e-003	4.9879e-002	1.8e-002	-2.2563e-007
3466	2.4845e-003	4.9938e-002	1.8e-002	-1.1741e-007
3467	1.4911e-003	4.9978e-002	1.8e-002	-4.518e-008
3468	4.9716e-004	4.9998e-002	1.8e-002	-9.0389e-009
3469	-4.9701e-004	4.9998e-002	1.8e-002	-9.0365e-009
3470	-1.491e-003	4.9978e-002	1.8e-002	-4.5172e-008
3471	-2.4843e-003	4.9938e-002	1.8e-002	-1.174e-007
3472	-3.4767e-003	4.9879e-002	1.8e-002	-2.2561e-007
3473	-4.4677e-003	4.98e-002	1.8e-002	-3.6967e-007
3474	-5.457e-003	4.9701e-002	1.8e-002	-5.4938e-007
3475	-6.4441e-003	4.9583e-002	1.8e-002	-7.6449e-007
3476	-7.4286e-003	4.9445e-002	1.8e-002	-1.0147e-006
3477	-8.4102e-003	4.9288e-002	1.8e-002	-1.2997e-006
3478	-9.3885e-003	4.9111e-002	1.8e-002	-1.6191e-006
3479	-1.0363e-002	4.8914e-002	1.8e-002	-1.9724e-006
3480	-1.1334e-002	4.8699e-002	1.8e-002	-2.3592e-006
3481	-1.23e-002	4.8464e-002	1.8e-002	-2.7789e-006
3482	-1.3261e-002	4.8209e-002	1.8e-002	-3.2309e-006
3483	-1.4217e-002	4.7936e-002	1.8e-002	-3.7147e-006
3484	-1.5167e-002	4.7644e-002	1.8e-002	-4.2296e-006
3485	-1.6111e-002	4.7333e-002	1.8e-002	-4.7748e-006
3486	-1.7049e-002	4.7004e-002	1.8e-002	-5.3497e-006
3487	-1.798e-002	4.6655e-002	1.8e-002	-5.9533e-006
3488	-1.9821e-002	4.5904e-002	1.8e-002	-7.2438e-006
3489	-2.073e-002	4.55e-002	1.8e-002	-7.9287e-006
3490	-2.073e-002	4.55e-002	1.9e-002	-7.9287e-006
3491	-2.073e-002	4.55e-002	2.e-002	-7.9291e-006
3492	-2.073e-002	4.55e-002	2.1e-002	-7.9296e-006
3493	-2.163e-002	4.5079e-002	2.2e-002	-8.6429e-006
3494	-2.163e-002	4.5079e-002	2.3e-002	-8.6409e-006
3495	-2.163e-002	4.5079e-002	2.4e-002	-8.6396e-006
3496	2.073e-002	4.55e-002	3.2e-002	-7.9287e-006
3497	2.073e-002	4.55e-002	3.1e-002	-7.9287e-006
3498	2.073e-002	4.55e-002	3.e-002	-7.9287e-006
3499	2.073e-002	4.55e-002	2.8e-002	-7.9286e-006
3500	2.073e-002	4.55e-002	2.6e-002	-7.9287e-006
3501	2.073e-002	4.55e-002	2.5e-002	-7.9287e-006
3502	2.073e-002	4.55e-002	2.4e-002	-7.9287e-006
3503	2.0729e-002	4.55e-002	2.3e-002	-7.9287e-006
3504	2.0729e-002	4.55e-002	2.2e-002	-7.9287e-006
3505	2.0729e-002	4.55e-002	2.1e-002	-7.9287e-006
3506	2.0729e-002	4.55e-002	2.e-002	-7.9287e-006
3507	2.0729e-002	4.55e-002	1.9e-002	-7.9288e-006
3508	-1.9821e-002	4.5903e-002	3.2e-002	-7.2439e-006
3509	-1.8904e-002	4.6288e-002	3.2e-002	-6.5851e-006
3510	-1.798e-002	4.6655e-002	3.2e-002	-5.9535e-006
3511	-1.7049e-002	4.7003e-002	3.2e-002	-5.3498e-006
3512	-1.6111e-002	4.7333e-002	3.2e-002	-4.775e-006
3513	-1.5167e-002	4.7644e-002	3.2e-002	-4.2297e-006
3514	-1.4217e-002	4.7936e-002	3.2e-002	-3.7148e-006
3515	-1.3261e-002	4.8209e-002	3.2e-002	-3.231e-006
3516	-1.23e-002	4.8464e-002	3.2e-002	-2.779e-006
3517	-1.1334e-002	4.8699e-002	3.2e-002	-2.3593e-006
3518	-1.0363e-002	4.8914e-002	3.2e-002	-1.9725e-006
3519	-9.3888e-003	4.9111e-002	3.2e-002	-1.6191e-006
3520	-8.4104e-003	4.9288e-002	3.2e-002	-1.2998e-006
3521	-7.4289e-003	4.9445e-002	3.2e-002	-1.0148e-006
3522	-6.4442e-003	4.9583e-002	3.2e-002	-7.6454e-007
3523	-5.4573e-003	4.9701e-002	3.2e-002	-5.4943e-007
3524	-4.4679e-003	4.98e-002	3.2e-002	-3.6971e-007
3525	-3.477e-003	4.9879e-002	3.2e-002	-2.2564e-007
3526	-2.4845e-003	4.9938e-002	3.2e-002	-1.1742e-007
3527	-1.4912e-003	4.9978e-002	3.2e-002	-4.5184e-008
3528	-4.9716e-004	4.9998e-002	3.2e-002	-9.0403e-009
3529	4.9688e-004	4.9998e-002	3.2e-002	-9.035e-009
3530	1.491e-003	4.9978e-002	3.2e-002	-4.5168e-008
3531	2.4842e-003	4.9938e-002	3.2e-002	-1.1739e-007
3532	3.4767e-003	4.9879e-002	3.2e-002	-2.256e-007
3533	4.4676e-003	4.98e-002	3.2e-002	-3.6966e-007
3534	5.457e-003	4.9701e-002	3.2e-002	-5.4937e-007
3535	6.444e-003	4.9583e-002	3.2e-002	-7.6448e-007
3536	7.4286e-003	4.9445e-002	3.2e-002	-1.0147e-006
3537	8.4101e-003	4.9288e-002	3.2e-002	-1.2997e-006
3538	9.3885e-003	4.9111e-002	3.2e-002	-1.619e-006
3539	1.0363e-002	4.8914e-002	3.2e-002	-1.9724e-006
3540	1.1334e-002	4.8699e-002	3.2e-002	-2.3591e-006
3541	1.2299e-002	4.8464e-002	3.2e-002	-2.7788e-006
3542	1.3261e-002	4.8209e-002	3.2e-002	-3.2309e-006
3543	1.4216e-002	4.7936e-002	3.2e-002	-3.7147e-006
3544	1.5167e-002	4.7644e-002	3.2e-002	-4.2296e-006
3545	1.6111e-002	4.7333e-002	3.2e-002	-4.7748e-006
3546	1.7049e-002	4.7004e-002	3.2e-002	-5.3496e-006
3547	1.798e-002	4.6655e-002	3.2e-002	-5.9533e-006
3548	1.8904e-002	4.6289e-002	3.2e-002	-6.5849e-006
3549	1.9821e-002	4.5904e-002	3.2e-002	-7.2437e-006
3550	-2.073e-002	4.55e-002	3.1e-002	-7.9288e-006
3551	-2.073e-002	4.55e-002	3.e-002	-7.9288e-006
3552	-2.073e-002	4.55e-002	2.9e-002	-7.9288e-006
3553	-2.073e-002	4.55e-002	2.8e-002	-7.9288e-006
3554	-2.073e-002	4.55e-002	2.7e-002	-7.9288e-006
3555	-2.073e-002	4.55e-002	2.6e-002	-7.9288e-006
3556	-2.073e-002	4.55e-002	2.5e-002	-7.9288e-006
3557	-2.073e-002	4.55e-002	2.4e-002	-7.9287e-006
3558	-1.9821e-002	4.5904e-002	1.9e-002	-7.2438e-006
3559	-1.9821e-002	4.5904e-002	2.e-002	-7.2438e-006
3560	-1.9821e-002	4.5904e-002	2.1e-002	-7.2438e-006
3561	-2.073e-002	4.55e-002	2.2e-002	-7.9292e-006
3562	-2.073e-002	4.55e-002	2.3e-002	-7.9287e-006
3563	1.9821e-002	4.5903e-002	1.9e-002	-7.2438e-006
3564	1.8904e-002	4.6289e-002	1.9e-002	-6.585e-006
3565	1.7049e-002	4.7003e-002	1.9e-002	-5.3498e-006
3566	1.6111e-002	4.7333e-002	1.9e-002	-4.7749e-006
3567	1.5167e-002	4.7644e-002	1.9e-002	-4.2297e-006
3568	1.4217e-002	4.7936e-002	1.9e-002	-3.7148e-006
3569	1.3261e-002	4.8209e-002	1.9e-002	-3.231e-006
3570	1.23e-002	4.8464e-002	1.9e-002	-2.7789e-006
3571	1.1334e-002	4.8699e-002	1.9e-002	-2.3592e-006
3572	1.0363e-002	4.8914e-002	1.9e-002	-1.9724e-006
3573	9.3887e-003	4.9111e-002	1.9e-002	-1.6191e-006
3574	8.4104e-003	4.9288e-002	1.9e-002	-1.2997e-006
3575	7.4288e-003	4.9445e-002	1.9e-002	-1.0148e-006
3576	6.4442e-003	4.9583e-002	1.9e-002	-7.6453e-007
3577	5.4571e-003	4.9701e-002	1.9e-002	-5.4941e-007
3578	4.4679e-003	4.98e-002	1.9e-002	-3.697e-007
3579	3.4769e-003	4.9879e-002	1.9e-002	-2.2563e-007
3580	2.4845e-003	4.9938e-002	1.9e-002	-1.1741e-007
3581	1.4911e-003	4.9978e-002	1.9e-002	-4.518e-008
3582	4.9715e-004	4.9998e-002	1.9e-002	-9.039e-009
3583	-4.9702e-004	4.9998e-002	1.9e-002	-9.0364e-009
3584	-1.491e-003	4.9978e-002	1.9e-002	-4.5172e-008
3585	-2.4844e-003	4.9938e-002	1.9e-002	-1.174e-007
3586	-3.4767e-003	4.9879e-002	1.9e-002	-2.2561e-007
3587	-4.4678e-003	4.98e-002	1.9e-002	-3.6967e-007
3588	-5.457e-003	4.9701e-002	1.9e-002	-5.4938e-007
3589	-6.4441e-003	4.9583e-002	1.9e-002	-7.6449e-007
3590	-7.4286e-003	4.9445e-002	1.9e-002	-1.0147e-006
3591	-8.4103e-003	4.9288e-002	1.9e-002	-1.2997e-006
3592	-9.3885e-003	4.9111e-002	1.9e-002	-1.6191e-006
3593	-1.0363e-002	4.8914e-002	1.9e-002	-1.9724e-006
3594	-1.1334e-002	4.8699e-002	1.9e-002	-2.3592e-006
3595	-1.23e-002	4.8464e-002	1.9e-002	-2.7789e-006
3596	-1.3261e-002	4.8209e-002	1.9e-002	-3.2309e-006
3597	-1.4217e-002	4.7936e-002	1.9e-002	-3.7147e-006
3598	-1.5167e-002	4.7644e-002	1.9e-002	-4.2296e-006
3599	-1.6111e-002	4.7333e-002	1.9e-002	-4.7748e-006
3600	-1.7049e-002	4.7004e-002	1.9e-002	-5.3497e-006
3601	-1.798e-002	4.6655e-002	1.9e-002	-5.9533e-006
3602	-1.8904e-002	4.6289e-002	1.9e-002	-6.585e-006
3603	1.9821e-002	4.5904e-002	3.1e-002	-7.2437e-006
3604	1.9821e-002	4.5904e-002	3.e-002	-7.2436e-006
3605	1.9821e-002	4.5904e-002	2.9e-002	-7.2436e-006
3606	1.9821e-002	4.5904e-002	2.8e-002	-7.2436e-006
3607	1.9821e-002	4.5904e-002	2.7e-002	-7.2436e-006
3608	1.9821e-002	4.5904e-002	2.6e-002	-7.2436e-006
3609	1.9821e-002	4.5904e-002	2.5e-002	-7.2436e-006
3610	1.9821e-002	4.5904e-002	2.4e-002	-7.2436e-006
3611	1.9821e-002	4.5904e-002	2.3e-002	-7.2436e-006
3612	1.9821e-002	4.5904e-002	2.2e-002	-7.2436e-006
3613	1.9821e-002	4.5904e-002	2.1e-002	-7.2436e-006
3614	1.9821e-002	4.5904e-002	2.e-002	-7.2437e-006
3615	-1.9821e-002	4.5903e-002	3.1e-002	-7.2439e-006
3616	-1.8904e-002	4.6288e-002	3.1e-002	-6.5851e-006
3617	-1.798e-002	4.6655e-002	3.1e-002	-5.9535e-006
3618	-1.7049e-002	4.7003e-002	3.1e-002	-5.3498e-006
3619	-1.6111e-002	4.7333e-002	3.1e-002	-4.775e-006
3620	-1.5167e-002	4.7644e-002	3.1e-002	-4.2297e-006
3621	-1.4217e-002	4.7936e-002	3.1e-002	-3.7148e-006
3622	-1.3261e-002	4.8209e-002	3.1e-002	-3.231e-006
3623	-1.23e-002	4.8464e-002	3.1e-002	-2.779e-006
3624	-1.1334e-002	4.8699e-002	3.1e-002	-2.3593e-006
3625	-1.0363e-002	4.8914e-002	3.1e-002	-1.9725e-006
3626	-9.3888e-003	4.9111e-002	3.1e-002	-1.6192e-006
3627	-8.4104e-003	4.9288e-002	3.1e-002	-1.2998e-006
3628	-7.4289e-003	4.9445e-002	3.1e-002	-1.0148e-006
3629	-6.4443e-003	4.9583e-002	3.1e-002	-7.6455e-007
3630	-5.4573e-003	4.9701e-002	3.1e-002	-5.4943e-007
3631	-4.4679e-003	4.98e-002	3.1e-002	-3.6971e-007
3632	-3.477e-003	4.9879e-002	3.1e-002	-2.2564e-007
3633	-2.4845e-003	4.9938e-002	3.1e-002	-1.1742e-007
3634	-1.4912e-003	4.9978e-002	3.1e-002	-4.5185e-008
3635	-4.972e-004	4.9998e-002	3.1e-002	-9.0406e-009
3636	4.9688e-004	4.9998e-002	3.1e-002	-9.0348e-009
3637	1.4909e-003	4.9978e-002	3.1e-002	-4.5168e-008
3638	2.4842e-003	4.9938e-002	3.1e-002	-1.1739e-007
3639	3.4767e-003	4.9879e-002	3.1e-002	-2.256e-007
3640	4.4676e-003	4.98e-002	3.1e-002	-3.6966e-007
3641	5.4569e-003	4.9701e-002	3.1e-002	-5.4936e-007
3642	6.444e-003	4.9583e-002	3.1e-002	-7.6447e-007
3643	7.4286e-003	4.9445e-002	3.1e-002	-1.0147e-006
3644	8.4101e-003	4.9288e-002	3.1e-002	-1.2997e-006
3645	9.3885e-003	4.9111e-002	3.1e-002	-1.619e-006
3646	1.0363e-002	4.8914e-002	3.1e-002	-1.9724e-006
3647	1.1334e-002	4.8699e-002	3.1e-002	-2.3591e-006
3648	1.2299e-002	4.8464e-002	3.1e-002	-2.7788e-006
3649	1.3261e-002	4.8209e-002	3.1e-002	-3.2309e-006
3650	1.4216e-002	4.7936e-002	3.1e-002	-3.7147e-006
3651	1.5167e-002	4.7644e-002	3.1e-002	-4.2296e-006
3652	1.6111e-002	4.7333e-002	3.1e-002	-4.7748e-006
3653	1.7049e-002	4.7004e-002	3.1e-002	-5.3496e-006
3654	1.798e-002	4.6655e-002	3.1e-002	-5.9533e-006
3655	1.8904e-002	4.6289e-002	3.1e-002	-6.5849e-006
3656	-1.9821e-002	4.5903e-002	3.e-002	-7.2439e-006
3657	-1.9821e-002	4.5903e-002	2.9e-002	-7.2439e-006
3658	-1.9821e-002	4.5903e-002	2.8e-002	-7.2439e-006
3659	-1.9821e-002	4.5903e-002	2.7e-002	-7.2439e-006
3660	-1.9821e-002	4.5903e-002	2.6e-002	-7.2439e-006
3661	-1.9821e-002	4.5903e-002	2.5e-002	-7.2438e-006
3662	-1.9821e-002	4.5904e-002	2.2e-002	-7.2438e-006
3663	-1.9821e-002	4.5904e-002	2.3e-002	-7.2438e-006
3664	-1.9821e-002	4.5903e-002	2.4e-002	-7.2438e-006
3665	-1.8904e-002	4.6289e-002	2.e-002	-6.585e-006
3666	-1.8904e-002	4.6289e-002	2.1e-002	-6.585e-006
3667	1.8904e-002	4.6289e-002	2.e-002	-6.585e-006
3668	1.798e-002	4.6655e-002	2.e-002	-5.9534e-006
3669	1.7049e-002	4.7003e-002	2.e-002	-5.3498e-006
3670	1.6111e-002	4.7333e-002	2.e-002	-4.7749e-006
3671	1.5167e-002	4.7644e-002	2.e-002	-4.2297e-006
3672	1.4217e-002	4.7936e-002	2.e-002	-3.7148e-006
3673	1.3261e-002	4.8209e-002	2.e-002	-3.231e-006
3674	1.23e-002	4.8464e-002	2.e-002	-2.7789e-006
3675	1.1334e-002	4.8699e-002	2.e-002	-2.3592e-006
3676	1.0363e-002	4.8914e-002	2.e-002	-1.9724e-006
3677	9.3887e-003	4.9111e-002	2.e-002	-1.6191e-006
3678	8.4104e-003	4.9288e-002	2.e-002	-1.2997e-006
3679	7.4288e-003	4.9445e-002	2.e-002	-1.0148e-006
3680	6.4442e-003	4.9583e-002	2.e-002	-7.6453e-007
3681	5.4571e-003	4.9701e-002	2.e-002	-5.4941e-007
3682	4.4679e-003	4.98e-002	2.e-002	-3.697e-007
3683	3.4769e-003	4.9879e-002	2.e-002	-2.2563e-007
3684	2.4845e-003	4.9938e-002	2.e-002	-1.1741e-007
3685	1.4911e-003	4.9978e-002	2.e-002	-4.518e-008
3686	4.9717e-004	4.9998e-002	2.e-002	-9.039e-009
3687	-4.9701e-004	4.9998e-002	2.e-002	-9.0364e-009
3688	-1.491e-003	4.9978e-002	2.e-002	-4.5172e-008
3689	-2.4843e-003	4.9938e-002	2.e-002	-1.174e-007
3690	-3.4767e-003	4.9879e-002	2.e-002	-2.2561e-007
3691	-4.4678e-003	4.98e-002	2.e-002	-3.6967e-007
3692	-5.457e-003	4.9701e-002	2.e-002	-5.4938e-007
3693	-6.4441e-003	4.9583e-002	2.e-002	-7.6449e-007
3694	-7.4286e-003	4.9445e-002	2.e-002	-1.0147e-006
3695	-8.4102e-003	4.9288e-002	2.e-002	-1.2997e-006
3696	-9.3885e-003	4.9111e-002	2.e-002	-1.6191e-006
3697	-1.0363e-002	4.8914e-002	2.e-002	-1.9724e-006
3698	-1.1334e-002	4.8699e-002	2.e-002	-2.3592e-006
3699	-1.23e-002	4.8464e-002	2.e-002	-2.7789e-006
3700	-1.3261e-002	4.8209e-002	2.e-002	-3.2309e-006
3701	-1.4217e-002	4.7936e-002	2.e-002	-3.7147e-006
3702	-1.5167e-002	4.7644e-002	2.e-002	-4.2296e-006
3703	-1.6111e-002	4.7333e-002	2.e-002	-4.7748e-006
3704	-1.7049e-002	4.7004e-002	2.e-002	-5.3497e-006
3705	-1.798e-002	4.6655e-002	2.e-002	-5.9533e-006
3706	1.8904e-002	4.6289e-002	3.e-002	-6.5849e-006
3707	1.8904e-002	4.6289e-002	2.9e-002	-6.5849e-006
3708	1.8904e-002	4.6289e-002	2.8e-002	-6.5849e-006
3709	1.8904e-002	4.6289e-002	2.7e-002	-6.5849e-006
3710	1.8904e-002	4.6289e-002	2.5e-002	-6.5849e-006
3711	1.8904e-002	4.6289e-002	2.4e-002	-6.5849e-006
3712	1.8904e-002	4.6289e-002	2.3e-002	-6.5849e-006
3713	1.8904e-002	4.6289e-002	2.2e-002	-6.5849e-006
3714	-1.8904e-002	4.6288e-002	3.e-002	-6.5851e-006
3715	-1.798e-002	4.6655e-002	3.e-002	-5.9535e-006
3716	-1.7049e-002	4.7003e-002	3.e-002	-5.3498e-006
3717	-1.6111e-002	4.7333e-002	3.e-002	-4.775e-006
3718	-1.5167e-002	4.7644e-002	3.e-002	-4.2297e-006
3719	-1.4217e-002	4.7936e-002	3.e-002	-3.7148e-006
3720	-1.3261e-002	4.8209e-002	3.e-002	-3.231e-006
3721	-1.23e-002	4.8464e-002	3.e-002	-2.779e-006
3722	-1.1334e-002	4.8699e-002	3.e-002	-2.3593e-006
3723	-1.0363e-002	4.8914e-002	3.e-002	-1.9725e-006
3724	-9.3888e-003	4.9111e-002	3.e-002	-1.6192e-006
3725	-8.4105e-003	4.9288e-002	3.e-002	-1.2998e-006
3726	-7.4289e-003	4.9445e-002	3.e-002	-1.0148e-006
3727	-6.4443e-003	4.9583e-002	3.e-002	-7.6455e-007
3728	-5.4573e-003	4.9701e-002	3.e-002	-5.4943e-007
3729	-4.468e-003	4.98e-002	3.e-002	-3.6971e-007
3730	-3.477e-003	4.9879e-002	3.e-002	-2.2564e-007
3731	-2.4846e-003	4.9938e-002	3.e-002	-1.1742e-007
3732	-1.4912e-003	4.9978e-002	3.e-002	-4.5186e-008
3733	-4.9723e-004	4.9998e-002	3.e-002	-9.0409e-009
3734	4.9688e-004	4.9998e-002	3.e-002	-9.0345e-009
3735	1.4909e-003	4.9978e-002	3.e-002	-4.5167e-008
3736	2.4842e-003	4.9938e-002	3.e-002	-1.1739e-007
3737	3.4767e-003	4.9879e-002	3.e-002	-2.256e-007
3738	4.4676e-003	4.98e-002	3.e-002	-3.6966e-007
3739	5.4569e-003	4.9701e-002	3.e-002	-5.4936e-007
3740	6.444e-003	4.9583e-002	3.e-002	-7.6447e-007
3741	7.4286e-003	4.9445e-002	3.e-002	-1.0147e-006
3742	8.4101e-003	4.9288e-002	3.e-002	-1.2997e-006
3743	9.3884e-003	4.9111e-002	3.e-002	-1.619e-006
3744	1.0363e-002	4.8914e-002	3.e-002	-1.9724e-006
3745	1.1333e-002	4.8699e-002	3.e-002	-2.3591e-006
3746	1.2299e-002	4.8464e-002	3.e-002	-2.7788e-006
3747	1.3261e-002	4.821e-002	3.e-002	-3.2309e-006
3748	1.4216e-002	4.7936e-002	3.e-002	-3.7147e-006
3749	1.5167e-002	4.7644e-002	3.e-002	-4.2296e-006
3750	1.6111e-002	4.7333e-002	3.e-002	-4.7748e-006
3751	1.7049e-002	4.7004e-002	3.e-002	-5.3496e-006
3752	1.798e-002	4.6655e-002	3.e-002	-5.9533e-006
3753	-1.8904e-002	4.6289e-002	2.9e-002	-6.5851e-006
3754	-1.8904e-002	4.6289e-002	2.8e-002	-6.5851e-006
3755	-1.8904e-002	4.6289e-002	2.7e-002	-6.5851e-006
3756	-1.8904e-002	4.6289e-002	2.6e-002	-6.5851e-006
3757	-1.8904e-002	4.6289e-002	2.5e-002	-6.585e-006
3758	-1.8904e-002	4.6289e-002	2.2e-002	-6.5849e-006
3759	-1.8904e-002	4.6289e-002	2.3e-002	-6.5849e-006
3760	-1.8904e-002	4.6289e-002	2.4e-002	-6.585e-006
3761	-1.798e-002	4.6655e-002	2.1e-002	-5.9533e-006
3762	1.798e-002	4.6655e-002	2.1e-002	-5.9534e-006
3763	1.6111e-002	4.7333e-002	2.1e-002	-4.7749e-006
3764	1.5167e-002	4.7644e-002	2.1e-002	-4.2297e-006
3765	1.4217e-002	4.7936e-002	2.1e-002	-3.7148e-006
3766	1.3261e-002	4.8209e-002	2.1e-002	-3.231e-006
3767	1.23e-002	4.8464e-002	2.1e-002	-2.7789e-006
3768	1.1334e-002	4.8699e-002	2.1e-002	-2.3592e-006
3769	1.0363e-002	4.8914e-002	2.1e-002	-1.9724e-006
3770	8.4104e-003	4.9288e-002	2.1e-002	-1.2997e-006
3771	7.4288e-003	4.9445e-002	2.1e-002	-1.0148e-006
3772	6.4442e-003	4.9583e-002	2.1e-002	-7.6453e-007
3773	5.4571e-003	4.9701e-002	2.1e-002	-5.4941e-007
3774	4.4679e-003	4.98e-002	2.1e-002	-3.697e-007
3775	3.4769e-003	4.9879e-002	2.1e-002	-2.2563e-007
3776	2.4845e-003	4.9938e-002	2.1e-002	-1.1741e-007
3777	1.4911e-003	4.9978e-002	2.1e-002	-4.518e-008
3778	4.9716e-004	4.9998e-002	2.1e-002	-9.039e-009
3779	-4.9701e-004	4.9998e-002	2.1e-002	-9.0364e-009
3780	-1.491e-003	4.9978e-002	2.1e-002	-4.5172e-008
3781	-2.4843e-003	4.9938e-002	2.1e-002	-1.174e-007
3782	-3.4767e-003	4.9879e-002	2.1e-002	-2.2561e-007
3783	-4.4677e-003	4.98e-002	2.1e-002	-3.6967e-007
3784	-5.457e-003	4.9701e-002	2.1e-002	-5.4938e-007
3785	-6.4441e-003	4.9583e-002	2.1e-002	-7.6449e-007
3786	-7.4286e-003	4.9445e-002	2.1e-002	-1.0147e-006
3787	-8.4102e-003	4.9288e-002	2.1e-002	-1.2997e-006
3788	-9.3885e-003	4.9111e-002	2.1e-002	-1.6191e-006
3789	-1.0363e-002	4.8914e-002	2.1e-002	-1.9724e-006
3790	-1.1334e-002	4.8699e-002	2.1e-002	-2.3592e-006
3791	-1.23e-002	4.8464e-002	2.1e-002	-2.7789e-006
3792	-1.3261e-002	4.8209e-002	2.1e-002	-3.2309e-006
3793	-1.4217e-002	4.7936e-002	2.1e-002	-3.7147e-006
3794	-1.5167e-002	4.7644e-002	2.1e-002	-4.2296e-006
3795	-1.6111e-002	4.7333e-002	2.1e-002	-4.7748e-006
3796	-1.7049e-002	4.7004e-002	2.1e-002	-5.3497e-006
3797	1.798e-002	4.6655e-002	2.9e-002	-5.9533e-006
3798	1.798e-002	4.6655e-002	2.8e-002	-5.9533e-006
3799	1.798e-002	4.6655e-002	2.7e-002	-5.9533e-006
3800	1.798e-002	4.6655e-002	2.6e-002	-5.9533e-006
3801	1.798e-002	4.6655e-002	2.5e-002	-5.9533e-006
3802	1.798e-002	4.6655e-002	2.4e-002	-5.9533e-006
3803	1.798e-002	4.6655e-002	2.2e-002	-5.9534e-006
3804	-1.798e-002	4.6655e-002	2.9e-002	-5.9535e-006
3805	-1.7049e-002	4.7003e-002	2.9e-002	-5.3498e-006
3806	-1.6111e-002	4.7333e-002	2.9e-002	-4.775e-006
3807	-1.5167e-002	4.7644e-002	2.9e-002	-4.2297e-006
3808	-1.4217e-002	4.7936e-002	2.9e-002	-3.7148e-006
3809	-1.3261e-002	4.8209e-002	2.9e-002	-3.231e-006
3810	-1.23e-002	4.8464e-002	2.9e-002	-2.779e-006
3811	-1.1334e-002	4.8699e-002	2.9e-002	-2.3593e-006
3812	-1.0363e-002	4.8914e-002	2.9e-002	-1.9725e-006
3813	-9.3888e-003	4.9111e-002	2.9e-002	-1.6192e-006
3814	-8.4105e-003	4.9288e-002	2.9e-002	-1.2998e-006
3815	-7.4289e-003	4.9445e-002	2.9e-002	-1.0148e-006
3816	-6.4443e-003	4.9583e-002	2.9e-002	-7.6455e-007
3817	-5.4573e-003	4.9701e-002	2.9e-002	-5.4943e-007
3818	-4.468e-003	4.98e-002	2.9e-002	-3.6972e-007
3819	-3.477e-003	4.9879e-002	2.9e-002	-2.2565e-007
3820	-2.4846e-003	4.9938e-002	2.9e-002	-1.1742e-007
3821	-1.4912e-003	4.9978e-002	2.9e-002	-4.5186e-008
3822	-4.9726e-004	4.9998e-002	2.9e-002	-9.0411e-009
3823	4.9689e-004	4.9998e-002	2.9e-002	-9.0342e-009
3824	1.4909e-003	4.9978e-002	2.9e-002	-4.5166e-008
3825	2.4842e-003	4.9938e-002	2.9e-002	-1.1739e-007
3826	3.4766e-003	4.9879e-002	2.9e-002	-2.256e-007
3827	4.4676e-003	4.98e-002	2.9e-002	-3.6966e-007
3828	5.4569e-003	4.9701e-002	2.9e-002	-5.4936e-007
3829	6.444e-003	4.9583e-002	2.9e-002	-7.6447e-007
3830	7.4285e-003	4.9445e-002	2.9e-002	-1.0147e-006
3831	8.4101e-003	4.9288e-002	2.9e-002	-1.2997e-006
3832	9.3884e-003	4.9111e-002	2.9e-002	-1.619e-006
3833	1.0363e-002	4.8914e-002	2.9e-002	-1.9723e-006
3834	1.1333e-002	4.8699e-002	2.9e-002	-2.3591e-006
3835	1.2299e-002	4.8464e-002	2.9e-002	-2.7788e-006
3836	1.3261e-002	4.821e-002	2.9e-002	-3.2309e-006
3837	1.4216e-002	4.7936e-002	2.9e-002	-3.7147e-006
3838	1.5167e-002	4.7644e-002	2.9e-002	-4.2295e-006
3839	1.6111e-002	4.7333e-002	2.9e-002	-4.7748e-006
3840	1.7049e-002	4.7004e-002	2.9e-002	-5.3497e-006
3841	-1.798e-002	4.6655e-002	2.8e-002	-5.9535e-006
3842	-1.798e-002	4.6655e-002	2.7e-002	-5.9535e-006
3843	-1.798e-002	4.6655e-002	2.6e-002	-5.9535e-006
3844	-1.798e-002	4.6655e-002	2.5e-002	-5.9534e-006
3845	1.7049e-002	4.7003e-002	2.2e-002	-5.3498e-006
3846	1.6111e-002	4.7333e-002	2.2e-002	-4.7749e-006
3847	1.5167e-002	4.7644e-002	2.2e-002	-4.2297e-006
3848	1.4217e-002	4.7936e-002	2.2e-002	-3.7148e-006
3849	1.3261e-002	4.8209e-002	2.2e-002	-3.231e-006
3850	1.23e-002	4.8464e-002	2.2e-002	-2.7789e-006
3851	1.0363e-002	4.8914e-002	2.2e-002	-1.9724e-006
3852	9.3887e-003	4.9111e-002	2.2e-002	-1.6191e-006
3853	8.4104e-003	4.9288e-002	2.2e-002	-1.2998e-006
3854	7.4288e-003	4.9445e-002	2.2e-002	-1.0148e-006
3855	6.4442e-003	4.9583e-002	2.2e-002	-7.6453e-007
3856	5.4571e-003	4.9701e-002	2.2e-002	-5.4941e-007
3857	4.4679e-003	4.98e-002	2.2e-002	-3.697e-007
3858	2.4845e-003	4.9938e-002	2.2e-002	-1.1741e-007
3859	4.9716e-004	4.9998e-002	2.2e-002	-9.039e-009
3860	-1.491e-003	4.9978e-002	2.2e-002	-4.5172e-008
3861	-3.4767e-003	4.9879e-002	2.2e-002	-2.2561e-007
3862	-5.457e-003	4.9701e-002	2.2e-002	-5.4938e-007
3863	-7.4286e-003	4.9445e-002	2.2e-002	-1.0147e-006
3864	-9.3885e-003	4.9111e-002	2.2e-002	-1.6192e-006
3865	-1.1334e-002	4.8699e-002	2.2e-002	-2.3595e-006
3866	-1.3261e-002	4.8209e-002	2.2e-002	-3.2309e-006
3867	-1.4217e-002	4.7936e-002	2.2e-002	-3.7147e-006
3868	-1.5167e-002	4.7644e-002	2.2e-002	-4.2296e-006
3869	-1.6111e-002	4.7333e-002	2.2e-002	-4.7748e-006
3870	-1.7049e-002	4.7004e-002	2.2e-002	-5.3497e-006
3871	-1.798e-002	4.6655e-002	2.2e-002	-5.9533e-006
3872	-1.798e-002	4.6655e-002	2.3e-002	-5.9533e-006
3873	-1.798e-002	4.6655e-002	2.4e-002	-5.9534e-006
3874	1.7049e-002	4.7004e-002	2.8e-002	-5.3497e-006
3875	1.7049e-002	4.7004e-002	2.7e-002	-5.3497e-006
3876	1.7049e-002	4.7004e-002	2.6e-002	-5.3497e-006
3877	1.7049e-002	4.7004e-002	2.5e-002	-5.3497e-006
3878	1.7049e-002	4.7004e-002	2.4e-002	-5.3497e-006
3879	1.7049e-002	4.7004e-002	2.3e-002	-5.3497e-006
3880	-1.7049e-002	4.7003e-002	2.8e-002	-5.3498e-006
3881	-1.6111e-002	4.7333e-002	2.8e-002	-4.775e-006
3882	-1.5167e-002	4.7644e-002	2.8e-002	-4.2297e-006
3883	-1.3261e-002	4.8209e-002	2.8e-002	-3.231e-006
3884	-1.23e-002	4.8464e-002	2.8e-002	-2.779e-006
3885	-1.1334e-002	4.8699e-002	2.8e-002	-2.3593e-006
3886	-1.0363e-002	4.8914e-002	2.8e-002	-1.9725e-006
3887	-8.4106e-003	4.9288e-002	2.8e-002	-1.2998e-006
3888	-6.4444e-003	4.9583e-002	2.8e-002	-7.6455e-007
3889	-5.4573e-003	4.9701e-002	2.8e-002	-5.4944e-007
3890	-4.4681e-003	4.98e-002	2.8e-002	-3.6972e-007
3891	-3.477e-003	4.9879e-002	2.8e-002	-2.2565e-007
3892	-2.4846e-003	4.9938e-002	2.8e-002	-1.1742e-007
3893	-1.4912e-003	4.9978e-002	2.8e-002	-4.5187e-008
3894	-4.9731e-004	4.9998e-002	2.8e-002	-9.0414e-009
3895	4.9689e-004	4.9998e-002	2.8e-002	-9.034e-009
3896	1.4908e-003	4.9978e-002	2.8e-002	-4.5165e-008
3897	2.4842e-003	4.9938e-002	2.8e-002	-1.1739e-007
3898	3.4766e-003	4.9879e-002	2.8e-002	-2.256e-007
3899	4.4676e-003	4.98e-002	2.8e-002	-3.6965e-007
3900	5.4568e-003	4.9701e-002	2.8e-002	-5.4936e-007
3901	6.444e-003	4.9583e-002	2.8e-002	-7.6446e-007
3902	7.4285e-003	4.9445e-002	2.8e-002	-1.0147e-006
3903	8.4101e-003	4.9288e-002	2.8e-002	-1.2997e-006
3904	9.3884e-003	4.9111e-002	2.8e-002	-1.619e-006
3905	1.0363e-002	4.8914e-002	2.8e-002	-1.9723e-006
3906	1.1333e-002	4.8699e-002	2.8e-002	-2.3591e-006
3907	1.2299e-002	4.8464e-002	2.8e-002	-2.7788e-006
3908	1.3261e-002	4.821e-002	2.8e-002	-3.2309e-006
3909	1.4216e-002	4.7936e-002	2.8e-002	-3.7147e-006
3910	1.5167e-002	4.7644e-002	2.8e-002	-4.2295e-006
3911	1.6111e-002	4.7333e-002	2.8e-002	-4.7748e-006
3912	-1.7049e-002	4.7003e-002	2.7e-002	-5.3498e-006
3913	-1.7049e-002	4.7003e-002	2.6e-002	-5.3498e-006
3914	-1.7049e-002	4.7003e-002	2.5e-002	-5.3498e-006
3915	-1.7049e-002	4.7003e-002	2.3e-002	-5.3497e-006
3916	-1.7049e-002	4.7003e-002	2.4e-002	-5.3497e-006
3917	1.6111e-002	4.7333e-002	2.3e-002	-4.7749e-006
3918	1.5167e-002	4.7644e-002	2.3e-002	-4.2297e-006
3919	1.4217e-002	4.7936e-002	2.3e-002	-3.7148e-006
3920	1.3261e-002	4.8209e-002	2.3e-002	-3.231e-006
3921	1.23e-002	4.8464e-002	2.3e-002	-2.7789e-006
3922	1.1334e-002	4.8699e-002	2.3e-002	-2.3592e-006
3923	1.0363e-002	4.8914e-002	2.3e-002	-1.9724e-006
3924	9.3887e-003	4.9111e-002	2.3e-002	-1.6191e-006
3925	7.4288e-003	4.9445e-002	2.3e-002	-1.0148e-006
3926	6.4443e-003	4.9583e-002	2.3e-002	-7.6453e-007
3927	5.4571e-003	4.9701e-002	2.3e-002	-5.4941e-007
3928	4.4679e-003	4.98e-002	2.3e-002	-3.697e-007
3929	3.4769e-003	4.9879e-002	2.3e-002	-2.2563e-007
3930	2.4845e-003	4.9938e-002	2.3e-002	-1.1741e-007
3931	1.4911e-003	4.9978e-002	2.3e-002	-4.5181e-008
3932	4.9718e-004	4.9998e-002	2.3e-002	-9.0392e-009
3933	-4.9701e-004	4.9998e-002	2.3e-002	-9.0362e-009
3934	-1.4909e-003	4.9978e-002	2.3e-002	-4.5171e-008
3935	-2.4843e-003	4.9938e-002	2.3e-002	-1.174e-007
3936	-3.4767e-003	4.9879e-002	2.3e-002	-2.2561e-007
3937	-4.4677e-003	4.98e-002	2.3e-002	-3.6967e-007
3938	-5.457e-003	4.9701e-002	2.3e-002	-5.4938e-007
3939	-6.4441e-003	4.9583e-002	2.3e-002	-7.6449e-007
3940	-7.4286e-003	4.9445e-002	2.3e-002	-1.0147e-006
3941	-8.4102e-003	4.9288e-002	2.3e-002	-1.2999e-006
3942	-9.3885e-003	4.9111e-002	2.3e-002	-1.6199e-006
3943	-1.0366e-002	4.8914e-002	2.3011e-002	-1.9739e-006
3944	-1.1338e-002	4.8698e-002	2.3012e-002	-2.3609e-006
3945	-1.23e-002	4.8464e-002	2.3e-002	-2.78e-006
3946	-1.3261e-002	4.8209e-002	2.3e-002	-3.2312e-006
3947	-1.4217e-002	4.7936e-002	2.3e-002	-3.7147e-006
3948	-1.5167e-002	4.7644e-002	2.3e-002	-4.2296e-006
3949	-1.6111e-002	4.7333e-002	2.3e-002	-4.7748e-006
3950	1.6111e-002	4.7333e-002	2.7e-002	-4.7748e-006
3951	1.6111e-002	4.7333e-002	2.6e-002	-4.7748e-006
3952	1.6111e-002	4.7333e-002	2.5e-002	-4.7748e-006
3953	1.6111e-002	4.7333e-002	2.4e-002	-4.7748e-006
3954	-1.6111e-002	4.7333e-002	2.7e-002	-4.775e-006
3955	-1.5167e-002	4.7644e-002	2.7e-002	-4.2297e-006
3956	-1.4217e-002	4.7936e-002	2.7e-002	-3.7151e-006
3957	-1.3261e-002	4.8209e-002	2.7e-002	-3.2319e-006
3958	-1.23e-002	4.8464e-002	2.7e-002	-2.7801e-006
3959	-1.1334e-002	4.8699e-002	2.7e-002	-2.3602e-006
3960	-1.0363e-002	4.8914e-002	2.7e-002	-1.9731e-006
3961	-9.3888e-003	4.9111e-002	2.7e-002	-1.6194e-006
3962	-8.4106e-003	4.9288e-002	2.7e-002	-1.2998e-006
3963	-7.4289e-003	4.9445e-002	2.7e-002	-1.0148e-006
3964	-6.4443e-003	4.9583e-002	2.7e-002	-7.6455e-007
3965	-5.4572e-003	4.9701e-002	2.7e-002	-5.4943e-007
3966	-4.4681e-003	4.98e-002	2.7e-002	-3.6972e-007
3967	-3.477e-003	4.9879e-002	2.7e-002	-2.2565e-007
3968	-2.4847e-003	4.9938e-002	2.7e-002	-1.1742e-007
3969	-1.4912e-003	4.9978e-002	2.7e-002	-4.5187e-008
3970	-4.9732e-004	4.9998e-002	2.7e-002	-9.0415e-009
3971	4.9689e-004	4.9998e-002	2.7e-002	-9.0339e-009
3972	1.4908e-003	4.9978e-002	2.7e-002	-4.5165e-008
3973	2.4842e-003	4.9938e-002	2.7e-002	-1.1738e-007
3974	3.4766e-003	4.9879e-002	2.7e-002	-2.256e-007
3975	4.4676e-003	4.98e-002	2.7e-002	-3.6965e-007
3976	5.4568e-003	4.9701e-002	2.7e-002	-5.4935e-007
3977	6.444e-003	4.9583e-002	2.7e-002	-7.6446e-007
3978	7.4285e-003	4.9445e-002	2.7e-002	-1.0147e-006
3979	8.4101e-003	4.9288e-002	2.7e-002	-1.2997e-006
3980	9.3884e-003	4.9111e-002	2.7e-002	-1.619e-006
3981	1.0363e-002	4.8914e-002	2.7e-002	-1.9723e-006
3982	1.1333e-002	4.8699e-002	2.7e-002	-2.3591e-006
3983	1.2299e-002	4.8464e-002	2.7e-002	-2.7788e-006
3984	1.3261e-002	4.821e-002	2.7e-002	-3.2308e-006
3985	1.4216e-002	4.7936e-002	2.7e-002	-3.7147e-006
3986	1.5167e-002	4.7644e-002	2.7e-002	-4.2295e-006
3987	-1.6111e-002	4.7333e-002	2.6e-002	-4.775e-006
3988	-1.6111e-002	4.7333e-002	2.5e-002	-4.775e-006
3989	-1.6111e-002	4.7333e-002	2.4e-002	-4.7749e-006
3990	1.5167e-002	4.7644e-002	2.4e-002	-4.2296e-006
3991	1.4217e-002	4.7936e-002	2.4e-002	-3.7148e-006
3992	1.3261e-002	4.8209e-002	2.4e-002	-3.231e-006
3993	1.23e-002	4.8464e-002	2.4e-002	-2.7789e-006
3994	1.1334e-002	4.8699e-002	2.4e-002	-2.3592e-006
3995	1.0363e-002	4.8914e-002	2.4e-002	-1.9724e-006
3996	9.3887e-003	4.9111e-002	2.4e-002	-1.6191e-006
3997	8.4104e-003	4.9288e-002	2.4e-002	-1.2998e-006
3998	7.4288e-003	4.9445e-002	2.4e-002	-1.0148e-006
3999	6.4443e-003	4.9583e-002	2.4e-002	-7.6453e-007
4000	5.4571e-003	4.9701e-002	2.4e-002	-5.4941e-007
4001	4.468e-003	4.98e-002	2.4e-002	-3.697e-007
4002	3.4769e-003	4.9879e-002	2.4e-002	-2.2564e-007
4003	2.4846e-003	4.9938e-002	2.4e-002	-1.1741e-007
4004	1.4911e-003	4.9978e-002	2.4e-002	-4.5181e-008
4005	4.9722e-004	4.9998e-002	2.4e-002	-9.0394e-009
4006	-4.9702e-004	4.9998e-002	2.4e-002	-9.036e-009
4007	-1.4909e-003	4.9978e-002	2.4e-002	-4.5171e-008
4008	-2.4844e-003	4.9938e-002	2.4e-002	-1.174e-007
4009	-3.4767e-003	4.9879e-002	2.4e-002	-2.2561e-007
4010	-4.4678e-003	4.98e-002	2.4e-002	-3.6967e-007
4011	-5.457e-003	4.9701e-002	2.4e-002	-5.4938e-007
4012	-6.4441e-003	4.9583e-002	2.4e-002	-7.6449e-007
4013	-7.4286e-003	4.9445e-002	2.4e-002	-1.0147e-006
4014	-8.4103e-003	4.9288e-002	2.4e-002	-1.3003e-006
4015	-9.399e-003	4.9109e-002	2.4005e-002	-1.6212e-006
4016	-1.0373e-002	4.8912e-002	2.4013e-002	-1.9758e-006
4017	-1.1345e-002	4.8696e-002	2.4013e-002	-2.363e-006
4018	-1.2309e-002	4.8461e-002	2.4009e-002	-2.7821e-006
4019	-1.4217e-002	4.7936e-002	2.4e-002	-3.7151e-006
4020	-1.5167e-002	4.7644e-002	2.4e-002	-4.2296e-006
4021	1.5167e-002	4.7644e-002	2.6e-002	-4.2295e-006
4022	1.5167e-002	4.7644e-002	2.5e-002	-4.2296e-006
4023	-1.5167e-002	4.7644e-002	2.6e-002	-4.2297e-006
4024	-1.4217e-002	4.7936e-002	2.6e-002	-3.7156e-006
4025	-1.3269e-002	4.8207e-002	2.6003e-002	-3.2337e-006
4026	-1.2311e-002	4.8461e-002	2.6008e-002	-2.7826e-006
4027	-1.0371e-002	4.8913e-002	2.6008e-002	-1.9748e-006
4028	-9.3888e-003	4.9111e-002	2.6e-002	-1.6202e-006
4029	-8.4106e-003	4.9288e-002	2.6e-002	-1.3e-006
4030	-7.429e-003	4.9445e-002	2.6e-002	-1.0148e-006
4031	-6.4442e-003	4.9583e-002	2.6e-002	-7.6453e-007
4032	-5.4572e-003	4.9701e-002	2.6e-002	-5.4942e-007
4033	-4.4681e-003	4.98e-002	2.6e-002	-3.6971e-007
4034	-3.477e-003	4.9879e-002	2.6e-002	-2.2564e-007
4035	-2.4847e-003	4.9938e-002	2.6e-002	-1.1742e-007
4036	-1.4912e-003	4.9978e-002	2.6e-002	-4.5183e-008
4037	-4.9733e-004	4.9998e-002	2.6e-002	-9.0401e-009
4038	4.9691e-004	4.9998e-002	2.6e-002	-9.0353e-009
4039	1.4908e-003	4.9978e-002	2.6e-002	-4.5169e-008
4040	2.4842e-003	4.9938e-002	2.6e-002	-1.1739e-007
4041	3.4766e-003	4.9879e-002	2.6e-002	-2.2561e-007
4042	4.4676e-003	4.98e-002	2.6e-002	-3.6966e-007
4043	5.4568e-003	4.9701e-002	2.6e-002	-5.4937e-007
4044	6.444e-003	4.9583e-002	2.6e-002	-7.6448e-007
4045	7.4285e-003	4.9445e-002	2.6e-002	-1.0147e-006
4046	8.4102e-003	4.9288e-002	2.6e-002	-1.2997e-006
4047	9.3884e-003	4.9111e-002	2.6e-002	-1.6191e-006
4048	1.0363e-002	4.8914e-002	2.6e-002	-1.9724e-006
4049	1.1333e-002	4.8699e-002	2.6e-002	-2.3591e-006
4050	1.2299e-002	4.8464e-002	2.6e-002	-2.7788e-006
4051	1.3261e-002	4.821e-002	2.6e-002	-3.2309e-006
4052	1.4216e-002	4.7936e-002	2.6e-002	-3.7147e-006
4053	-1.5167e-002	4.7644e-002	2.5e-002	-4.2297e-006
4054	1.4217e-002	4.7936e-002	2.5e-002	-3.7147e-006
4055	-1.4217e-002	4.7936e-002	2.5e-002	-3.7157e-006
4056	-1.3271e-002	4.8207e-002	2.5003e-002	-3.2341e-006
4057	1.3261e-002	4.8209e-002	2.5e-002	-3.231e-006
4058	1.23e-002	4.8464e-002	2.5e-002	-2.7789e-006
4059	1.1334e-002	4.8699e-002	2.5e-002	-2.3592e-006
4060	1.0363e-002	4.8914e-002	2.5e-002	-1.9724e-006
4061	9.3887e-003	4.9111e-002	2.5e-002	-1.6191e-006
4062	8.4104e-003	4.9288e-002	2.5e-002	-1.2997e-006
4063	7.4288e-003	4.9445e-002	2.5e-002	-1.0147e-006
4064	5.457e-003	4.9701e-002	2.5e-002	-5.4939e-007
4065	4.468e-003	4.98e-002	2.5e-002	-3.6969e-007
4066	3.4769e-003	4.9879e-002	2.5e-002	-2.2563e-007
4067	2.4845e-003	4.9938e-002	2.5e-002	-1.1741e-007
4068	1.4911e-003	4.9978e-002	2.5e-002	-4.5177e-008
4069	-4.9702e-004	4.9998e-002	2.5e-002	-9.0374e-009
4070	-1.4909e-003	4.9978e-002	2.5e-002	-4.5175e-008
4071	-2.4844e-003	4.9938e-002	2.5e-002	-1.174e-007
4072	-3.4767e-003	4.9879e-002	2.5e-002	-2.2562e-007
4073	-4.4677e-003	4.98e-002	2.5e-002	-3.6968e-007
4074	-5.457e-003	4.9701e-002	2.5e-002	-5.4939e-007
4075	-6.4441e-003	4.9583e-002	2.5e-002	-7.645e-007
4076	-7.4285e-003	4.9445e-002	2.5e-002	-1.0147e-006
4077	-8.4103e-003	4.9288e-002	2.5e-002	-1.3003e-006
4078	-9.3984e-003	4.9109e-002	2.5004e-002	-1.6214e-006
4079	-1.0377e-002	4.8911e-002	2.501e-002	-1.9763e-006
4080	-1.1346e-002	4.8696e-002	2.5011e-002	-2.3639e-006"""
    writer = System.IO.StreamWriter(filePath, False)
    writer.WriteLine(fileContents)
    writer.Close()
    fileRef = task.RegisterFile(filePath)
    fileRefs.Add(fileRef)
    #region z strain
    filePath = System.IO.Path.Combine(workingDirectory, "StrainZ.txt")
    fileContents = r"""Node Number	X Location (m)	Y Location (m)	Z Location (m)	Normal Elastic Strain (m/m)
1	-3.5355e-002	3.5355e-002	5.e-002	-3.5875e-016
2	3.5355e-002	3.5355e-002	5.e-002	-1.0585e-015
3	-3.4645e-002	3.6051e-002	5.e-002	4.019e-011
4	-3.3922e-002	3.6733e-002	5.e-002	1.4702e-010
5	-3.3185e-002	3.74e-002	5.e-002	-9.261e-011
6	-3.2435e-002	3.8053e-002	5.e-002	5.9468e-014
7	-3.1672e-002	3.869e-002	5.e-002	-2.771e-012
8	-3.0896e-002	3.9312e-002	5.e-002	4.8395e-012
9	-3.0108e-002	3.9918e-002	5.e-002	1.9657e-012
10	-2.9309e-002	4.0509e-002	5.e-002	-2.0876e-012
11	-2.8498e-002	4.1084e-002	5.e-002	-1.4025e-012
12	-2.7675e-002	4.1642e-002	5.e-002	-5.0973e-013
13	-2.6842e-002	4.2184e-002	5.e-002	-5.7084e-013
14	-2.5998e-002	4.271e-002	5.e-002	-2.1445e-013
15	-2.5143e-002	4.3218e-002	5.e-002	-3.6892e-013
16	-2.4279e-002	4.371e-002	5.e-002	-3.0226e-014
17	-2.3405e-002	4.4184e-002	5.e-002	1.1643e-013
18	-2.2522e-002	4.464e-002	5.e-002	1.9745e-013
19	-2.163e-002	4.5079e-002	5.e-002	3.0861e-013
20	-2.073e-002	4.55e-002	5.e-002	2.5284e-013
21	-1.9821e-002	4.5904e-002	5.e-002	2.8697e-013
22	-1.8904e-002	4.6289e-002	5.e-002	1.9683e-013
23	-1.798e-002	4.6655e-002	5.e-002	2.1101e-013
24	-1.7049e-002	4.7003e-002	5.e-002	1.015e-013
25	-1.6111e-002	4.7333e-002	5.e-002	1.411e-013
26	-1.5167e-002	4.7644e-002	5.e-002	4.8241e-014
27	-1.4217e-002	4.7936e-002	5.e-002	8.3685e-014
28	-1.3261e-002	4.8209e-002	5.e-002	3.0322e-014
29	-1.23e-002	4.8464e-002	5.e-002	6.1312e-014
30	-1.1334e-002	4.8699e-002	5.e-002	2.8109e-014
31	-1.0363e-002	4.8914e-002	5.e-002	1.0617e-013
32	-9.3886e-003	4.9111e-002	5.e-002	2.447e-014
33	-8.4103e-003	4.9288e-002	5.e-002	7.7977e-014
34	-7.4287e-003	4.9445e-002	5.e-002	3.6258e-014
35	-6.4442e-003	4.9583e-002	5.e-002	2.7629e-014
36	-5.4571e-003	4.9701e-002	5.e-002	2.9438e-014
37	-4.4678e-003	4.98e-002	5.e-002	1.2229e-013
38	-3.4768e-003	4.9879e-002	5.e-002	2.2903e-014
39	-2.4844e-003	4.9938e-002	5.e-002	6.1744e-014
40	-1.491e-003	4.9978e-002	5.e-002	2.2871e-014
41	-4.9708e-004	4.9998e-002	5.e-002	6.0384e-014
42	4.9708e-004	4.9998e-002	5.e-002	5.7035e-014
43	1.491e-003	4.9978e-002	5.e-002	5.5944e-014
44	2.4844e-003	4.9938e-002	5.e-002	2.374e-015
45	3.4768e-003	4.9879e-002	5.e-002	6.7452e-014
46	4.4678e-003	4.98e-002	5.e-002	7.563e-015
47	5.4571e-003	4.9701e-002	5.e-002	6.5666e-014
48	6.4442e-003	4.9583e-002	5.e-002	3.1164e-014
49	7.4287e-003	4.9445e-002	5.e-002	3.7826e-014
50	8.4103e-003	4.9288e-002	5.e-002	2.4811e-015
51	9.3886e-003	4.9111e-002	5.e-002	-7.1858e-015
52	1.0363e-002	4.8914e-002	5.e-002	2.8607e-014
53	1.1334e-002	4.8699e-002	5.e-002	6.9555e-014
54	1.23e-002	4.8464e-002	5.e-002	7.847e-015
55	1.3261e-002	4.8209e-002	5.e-002	-9.8889e-015
56	1.4217e-002	4.7936e-002	5.e-002	-1.5385e-014
57	1.5167e-002	4.7644e-002	5.e-002	2.6038e-014
58	1.6111e-002	4.7333e-002	5.e-002	1.8192e-014
59	1.7049e-002	4.7003e-002	5.e-002	2.0565e-014
60	1.798e-002	4.6655e-002	5.e-002	2.2167e-015
61	1.8904e-002	4.6289e-002	5.e-002	6.4537e-015
62	1.9821e-002	4.5904e-002	5.e-002	1.8304e-015
63	2.073e-002	4.55e-002	5.e-002	1.2529e-014
64	2.163e-002	4.5079e-002	5.e-002	1.5165e-014
65	2.2522e-002	4.464e-002	5.e-002	2.221e-014
66	2.3405e-002	4.4184e-002	5.e-002	3.2947e-014
67	2.4279e-002	4.371e-002	5.e-002	1.5034e-014
68	2.5143e-002	4.3218e-002	5.e-002	8.0234e-014
69	2.5998e-002	4.271e-002	5.e-002	-5.5794e-014
70	2.6842e-002	4.2184e-002	5.e-002	4.5735e-013
71	2.7675e-002	4.1642e-002	5.e-002	-7.2296e-013
72	2.8498e-002	4.1084e-002	5.e-002	1.2267e-012
73	2.9309e-002	4.0509e-002	5.e-002	4.7112e-015
74	3.0108e-002	3.9918e-002	5.e-002	-1.7665e-012
75	3.0896e-002	3.9312e-002	5.e-002	8.0111e-012
76	3.1672e-002	3.869e-002	5.e-002	-1.6182e-011
77	3.2435e-002	3.8053e-002	5.e-002	6.7951e-011
78	3.3185e-002	3.74e-002	5.e-002	-1.9279e-010
79	3.3922e-002	3.6733e-002	5.e-002	1.5549e-010
80	3.4645e-002	3.6051e-002	5.e-002	1.3439e-010
81	3.5355e-002	3.5355e-002	0.	3.8272e-012
82	3.5355e-002	3.5355e-002	4.9e-002	7.5731e-013
83	3.5355e-002	3.5355e-002	4.8e-002	6.7793e-013
84	3.5355e-002	3.5355e-002	4.7e-002	2.5792e-016
85	3.5355e-002	3.5355e-002	4.6e-002	1.4159e-016
86	3.5355e-002	3.5355e-002	4.5e-002	-9.9353e-017
87	3.5355e-002	3.5355e-002	4.4e-002	-2.771e-016
88	3.5355e-002	3.5355e-002	4.3e-002	-2.372e-016
89	3.5355e-002	3.5355e-002	4.2e-002	-1.3316e-017
90	3.5355e-002	3.5355e-002	4.1e-002	-2.389e-017
91	3.5355e-002	3.5355e-002	4.e-002	-3.1466e-017
92	3.5355e-002	3.5355e-002	3.9e-002	-3.1671e-017
93	3.5355e-002	3.5355e-002	3.8e-002	-2.9052e-017
94	3.5355e-002	3.5355e-002	3.7e-002	-2.7835e-017
95	3.5355e-002	3.5355e-002	3.6e-002	-2.5532e-017
96	3.5355e-002	3.5355e-002	3.5e-002	-2.4903e-017
97	3.5355e-002	3.5355e-002	3.4e-002	-2.2904e-017
98	3.5355e-002	3.5355e-002	3.3e-002	-2.2574e-017
99	3.5355e-002	3.5355e-002	3.2e-002	-2.069e-017
100	3.5355e-002	3.5355e-002	3.1e-002	-2.0491e-017
101	3.5355e-002	3.5355e-002	3.e-002	-1.8693e-017
102	3.5355e-002	3.5355e-002	2.9e-002	-1.8562e-017
103	3.5355e-002	3.5355e-002	2.8e-002	-1.6788e-017
104	3.5355e-002	3.5355e-002	2.7e-002	-1.6737e-017
105	3.5355e-002	3.5355e-002	2.6e-002	-1.4957e-017
106	3.5355e-002	3.5355e-002	2.5e-002	-1.4904e-017
107	3.5355e-002	3.5355e-002	2.4e-002	-1.3034e-017
108	3.5355e-002	3.5355e-002	2.3e-002	-1.3005e-017
109	3.5355e-002	3.5355e-002	2.2e-002	-1.1204e-017
110	3.5355e-002	3.5355e-002	2.1e-002	-1.1173e-017
111	3.5355e-002	3.5355e-002	2.e-002	-9.2649e-018
112	3.5355e-002	3.5355e-002	1.9e-002	-9.34e-018
113	3.5355e-002	3.5355e-002	1.8e-002	-7.2916e-018
114	3.5355e-002	3.5355e-002	1.7e-002	-7.4746e-018
115	3.5355e-002	3.5355e-002	1.6e-002	-4.8163e-018
116	3.5355e-002	3.5355e-002	1.5e-002	-5.3582e-018
117	3.5355e-002	3.5355e-002	1.4e-002	-1.6751e-018
118	3.5355e-002	3.5355e-002	1.3e-002	-1.7183e-017
119	3.5355e-002	3.5355e-002	1.2e-002	-1.5014e-017
120	3.5355e-002	3.5355e-002	1.1e-002	-7.6506e-017
121	3.5355e-002	3.5355e-002	1.e-002	-5.8723e-016
122	3.5355e-002	3.5355e-002	9.e-003	-5.2621e-016
123	3.5355e-002	3.5355e-002	8.e-003	-3.3124e-017
124	3.5355e-002	3.5355e-002	7.e-003	-9.5122e-016
125	3.5355e-002	3.5355e-002	6.e-003	-1.4478e-015
126	3.5355e-002	3.5355e-002	5.e-003	-4.5222e-016
127	3.5355e-002	3.5355e-002	4.e-003	-5.4846e-016
128	3.5355e-002	3.5355e-002	3.e-003	-1.0516e-015
129	3.5355e-002	3.5355e-002	2.e-003	-2.289e-016
130	3.5355e-002	3.5355e-002	1.e-003	1.4095e-012
131	-3.5355e-002	3.5355e-002	0.	-1.1638e-015
132	3.4645e-002	3.6051e-002	0.	-3.4788e-010
133	3.3922e-002	3.6733e-002	0.	-3.8849e-010
134	3.3185e-002	3.74e-002	0.	2.65e-010
135	3.2435e-002	3.8053e-002	0.	-5.1337e-011
136	3.1672e-002	3.869e-002	0.	-4.515e-012
137	3.0896e-002	3.9312e-002	0.	1.7859e-011
138	3.0108e-002	3.9918e-002	0.	-4.2879e-012
139	2.9309e-002	4.0509e-002	0.	-6.3069e-014
140	2.8498e-002	4.1084e-002	0.	5.0272e-013
141	2.7675e-002	4.1642e-002	0.	-1.7519e-013
142	2.6842e-002	4.2184e-002	0.	1.4622e-014
143	2.5998e-002	4.271e-002	0.	7.2992e-014
144	2.5143e-002	4.3218e-002	0.	-9.9402e-014
145	2.4279e-002	4.371e-002	0.	1.7803e-014
146	2.3405e-002	4.4184e-002	0.	-7.3315e-014
147	2.2522e-002	4.464e-002	0.	1.0639e-014
148	2.163e-002	4.5079e-002	0.	-2.8756e-014
149	2.073e-002	4.55e-002	0.	5.0174e-014
150	1.9821e-002	4.5904e-002	0.	-8.249e-015
151	1.8904e-002	4.6289e-002	0.	3.1101e-014
152	1.798e-002	4.6655e-002	0.	-2.0324e-014
153	1.7049e-002	4.7003e-002	0.	4.3927e-014
154	1.6111e-002	4.7333e-002	0.	5.0203e-015
155	1.5167e-002	4.7644e-002	0.	2.9387e-014
156	1.4217e-002	4.7936e-002	0.	-5.3716e-014
157	1.3261e-002	4.8209e-002	0.	-5.4362e-015
158	1.23e-002	4.8464e-002	0.	3.8535e-015
159	1.1334e-002	4.8699e-002	0.	1.6722e-015
160	1.0363e-002	4.8914e-002	0.	-3.8116e-014
161	9.3886e-003	4.9111e-002	0.	-4.0272e-015
162	8.4103e-003	4.9288e-002	0.	-2.9347e-014
163	7.4287e-003	4.9445e-002	0.	8.0213e-015
164	6.4442e-003	4.9583e-002	0.	-5.3493e-014
165	5.4571e-003	4.9701e-002	0.	-2.2343e-014
166	4.4678e-003	4.98e-002	0.	2.141e-014
167	3.4768e-003	4.9879e-002	0.	-3.679e-014
168	2.4844e-003	4.9938e-002	0.	-5.468e-014
169	1.491e-003	4.9978e-002	0.	4.0597e-015
170	4.9708e-004	4.9998e-002	0.	-7.7742e-014
171	-4.9708e-004	4.9998e-002	0.	-7.9889e-014
172	-1.491e-003	4.9978e-002	0.	1.592e-014
173	-2.4844e-003	4.9938e-002	0.	-5.9278e-014
174	-3.4768e-003	4.9879e-002	0.	-1.2021e-013
175	-4.4678e-003	4.98e-002	0.	-8.9693e-014
176	-5.4571e-003	4.9701e-002	0.	-2.9171e-014
177	-6.4442e-003	4.9583e-002	0.	-1.0918e-013
178	-7.4287e-003	4.9445e-002	0.	-5.7717e-014
179	-8.4103e-003	4.9288e-002	0.	-1.4285e-013
180	-9.3886e-003	4.9111e-002	0.	-1.3551e-013
181	-1.0363e-002	4.8914e-002	0.	-1.0913e-013
182	-1.1334e-002	4.8699e-002	0.	-6.5531e-014
183	-1.23e-002	4.8464e-002	0.	-1.469e-013
184	-1.3261e-002	4.8209e-002	0.	-1.4972e-013
185	-1.4217e-002	4.7936e-002	0.	-1.7614e-013
186	-1.5167e-002	4.7644e-002	0.	-1.336e-013
187	-1.6111e-002	4.7333e-002	0.	-2.1864e-013
188	-1.7049e-002	4.7003e-002	0.	-1.6252e-013
189	-1.798e-002	4.6655e-002	0.	-2.4594e-013
190	-1.8904e-002	4.6289e-002	0.	-1.8901e-013
191	-1.9821e-002	4.5904e-002	0.	-1.9363e-013
192	-2.073e-002	4.55e-002	0.	-8.0454e-015
193	-2.163e-002	4.5079e-002	0.	5.4154e-014
194	-2.2522e-002	4.464e-002	0.	3.0428e-013
195	-2.3405e-002	4.4184e-002	0.	2.2712e-013
196	-2.4279e-002	4.371e-002	0.	2.7616e-013
197	-2.5143e-002	4.3218e-002	0.	7.8596e-013
198	-2.5998e-002	4.271e-002	0.	-1.2467e-013
199	-2.6842e-002	4.2184e-002	0.	3.5725e-013
200	-2.7675e-002	4.1642e-002	0.	1.3584e-012
201	-2.8498e-002	4.1084e-002	0.	4.0982e-013
202	-2.9309e-002	4.0509e-002	0.	2.8051e-012
203	-3.0108e-002	3.9918e-002	0.	9.7349e-013
204	-3.0896e-002	3.9312e-002	0.	5.5148e-012
205	-3.1672e-002	3.869e-002	0.	-1.2457e-011
206	-3.2435e-002	3.8053e-002	0.	6.8071e-011
207	-3.3185e-002	3.74e-002	0.	-1.9148e-010
208	-3.3922e-002	3.6733e-002	0.	1.5875e-010
209	-3.4645e-002	3.6051e-002	0.	1.3784e-010
210	-3.5355e-002	3.5355e-002	1.e-003	7.1982e-013
211	-3.5355e-002	3.5355e-002	2.e-003	6.4945e-013
212	-3.5355e-002	3.5355e-002	3.e-003	4.135e-016
213	-3.5355e-002	3.5355e-002	4.e-003	3.6673e-016
214	-3.5355e-002	3.5355e-002	5.e-003	-6.9387e-017
215	-3.5355e-002	3.5355e-002	6.e-003	-1.8786e-016
216	-3.5355e-002	3.5355e-002	7.e-003	-3.1289e-016
217	-3.5355e-002	3.5355e-002	8.e-003	-5.9586e-017
218	-3.5355e-002	3.5355e-002	9.e-003	8.3532e-017
219	-3.5355e-002	3.5355e-002	1.e-002	2.9614e-018
220	-3.5355e-002	3.5355e-002	1.1e-002	-6.9039e-017
221	-3.5355e-002	3.5355e-002	1.2e-002	-9.927e-017
222	-3.5355e-002	3.5355e-002	1.3e-002	2.3347e-017
223	-3.5355e-002	3.5355e-002	1.4e-002	1.3012e-016
224	-3.5355e-002	3.5355e-002	1.5e-002	1.0097e-016
225	-3.5355e-002	3.5355e-002	1.6e-002	3.0375e-018
226	-3.5355e-002	3.5355e-002	1.7e-002	-3.0804e-017
227	-3.5355e-002	3.5355e-002	1.8e-002	-3.8075e-018
228	-3.5355e-002	3.5355e-002	1.9e-002	-1.9645e-017
229	-3.5355e-002	3.5355e-002	2.e-002	1.8267e-017
230	-3.5355e-002	3.5355e-002	2.1e-002	2.2141e-018
231	-3.5355e-002	3.5355e-002	2.2e-002	5.4186e-017
232	-3.5355e-002	3.5355e-002	2.3e-002	6.6935e-017
233	-3.5355e-002	3.5355e-002	2.4e-002	6.4836e-017
234	-3.5355e-002	3.5355e-002	2.5e-002	1.058e-016
235	-3.5355e-002	3.5355e-002	2.6e-002	3.1567e-017
236	-3.5355e-002	3.5355e-002	2.7e-002	4.1144e-017
237	-3.5355e-002	3.5355e-002	2.8e-002	-1.9471e-018
238	-3.5355e-002	3.5355e-002	2.9e-002	-1.7945e-017
239	-3.5355e-002	3.5355e-002	3.e-002	-2.3444e-017
240	-3.5355e-002	3.5355e-002	3.1e-002	-3.8724e-017
241	-3.5355e-002	3.5355e-002	3.2e-002	-3.3515e-017
242	-3.5355e-002	3.5355e-002	3.3e-002	-4.8742e-017
243	-3.5355e-002	3.5355e-002	3.4e-002	-9.2535e-018
244	-3.5355e-002	3.5355e-002	3.5e-002	8.1634e-018
245	-3.5355e-002	3.5355e-002	3.6e-002	-2.0418e-018
246	-3.5355e-002	3.5355e-002	3.7e-002	-6.6341e-017
247	-3.5355e-002	3.5355e-002	3.8e-002	-5.4893e-017
248	-3.5355e-002	3.5355e-002	3.9e-002	-5.3238e-017
249	-3.5355e-002	3.5355e-002	4.e-002	1.0142e-017
250	-3.5355e-002	3.5355e-002	4.1e-002	1.0588e-016
251	-3.5355e-002	3.5355e-002	4.2e-002	7.2966e-017
252	-3.5355e-002	3.5355e-002	4.3e-002	-2.2431e-017
253	-3.5355e-002	3.5355e-002	4.4e-002	2.7382e-017
254	-3.5355e-002	3.5355e-002	4.5e-002	-1.9087e-015
255	-3.5355e-002	3.5355e-002	4.6e-002	-1.5227e-015
256	-3.5355e-002	3.5355e-002	4.7e-002	-1.0772e-016
257	-3.5355e-002	3.5355e-002	4.8e-002	6.7652e-013
258	-3.5355e-002	3.5355e-002	4.9e-002	6.9831e-013
259	3.4641e-002	3.6055e-002	4.e-003	6.7246e-011
260	-3.4641e-002	3.6055e-002	2.e-003	-1.5513e-010
261	3.4641e-002	3.6055e-002	4.8e-002	-1.5951e-010
262	-2.8498e-002	4.1084e-002	4.8e-002	-7.9125e-012
263	-2.6842e-002	4.2184e-002	4.8e-002	-2.2157e-012
264	-2.5143e-002	4.3218e-002	4.8e-002	-1.5834e-012
265	-2.3405e-002	4.4184e-002	4.8e-002	5.8004e-013
266	-2.163e-002	4.5079e-002	4.8e-002	1.7096e-012
267	-1.9821e-002	4.5904e-002	4.8e-002	1.5569e-012
268	-1.798e-002	4.6655e-002	4.8e-002	1.0194e-012
269	-1.6111e-002	4.7333e-002	4.8e-002	5.5556e-013
270	-1.4217e-002	4.7936e-002	4.8e-002	3.049e-013
271	-1.23e-002	4.8464e-002	4.8e-002	2.2132e-013
272	-1.0363e-002	4.8914e-002	4.8e-002	2.7249e-013
273	-8.4103e-003	4.9288e-002	4.8e-002	3.0309e-013
274	-6.4442e-003	4.9583e-002	4.8e-002	3.0899e-013
275	-4.4678e-003	4.98e-002	4.8e-002	3.4429e-013
276	-2.4844e-003	4.9938e-002	4.8e-002	3.0592e-013
277	-4.9707e-004	4.9998e-002	4.8e-002	3.3084e-013
278	1.491e-003	4.9978e-002	4.8e-002	3.0357e-013
279	3.4768e-003	4.9879e-002	4.8e-002	2.6572e-013
280	5.4571e-003	4.9701e-002	4.8e-002	2.7486e-013
281	7.4287e-003	4.9445e-002	4.8e-002	1.9681e-013
282	9.3886e-003	4.9111e-002	4.8e-002	1.8241e-013
283	1.1334e-002	4.8699e-002	4.8e-002	1.6137e-013
284	1.3261e-002	4.8209e-002	4.8e-002	1.1487e-013
285	1.5167e-002	4.7644e-002	4.8e-002	1.246e-013
286	1.7049e-002	4.7003e-002	4.8e-002	1.0506e-013
287	1.8904e-002	4.6289e-002	4.8e-002	1.2466e-013
288	2.073e-002	4.55e-002	4.8e-002	1.5113e-013
289	2.2522e-002	4.464e-002	4.8e-002	2.1477e-013
290	2.4279e-002	4.371e-002	4.8e-002	3.1532e-013
291	2.5998e-002	4.271e-002	4.8e-002	6.1606e-013
292	2.7675e-002	4.1642e-002	4.8e-002	1.5806e-012
293	2.9309e-002	4.0509e-002	4.8e-002	2.0209e-012
294	3.0896e-002	3.9312e-002	4.8e-002	1.3802e-013
295	-3.1672e-002	3.869e-002	2.e-003	2.1149e-011
296	-3.3185e-002	3.74e-002	4.7e-002	-7.9273e-011
297	-3.0896e-002	3.9312e-002	4.e-003	-1.9063e-012
298	3.2433e-002	3.8054e-002	6.e-003	4.5788e-011
299	-3.0108e-002	3.9919e-002	4.6e-002	-1.1079e-010
300	-2.6842e-002	4.2184e-002	4.6e-002	-9.8804e-012
301	2.9309e-002	4.0509e-002	4.6e-002	1.472e-012
302	2.4279e-002	4.371e-002	4.e-003	-8.0242e-013
303	2.2522e-002	4.464e-002	4.e-003	-3.103e-013
304	2.073e-002	4.55e-002	4.e-003	6.3506e-014
305	1.8904e-002	4.6289e-002	4.e-003	5.8962e-014
306	1.7049e-002	4.7003e-002	4.e-003	-7.6253e-014
307	1.5167e-002	4.7644e-002	4.e-003	-1.8904e-013
308	1.3261e-002	4.8209e-002	4.e-003	-2.8897e-013
309	1.1334e-002	4.8699e-002	4.e-003	-3.5493e-013
310	9.3886e-003	4.9111e-002	4.e-003	-3.9529e-013
311	7.4288e-003	4.9445e-002	4.e-003	-4.7544e-013
312	5.4571e-003	4.9701e-002	4.e-003	-5.6543e-013
313	3.4768e-003	4.9879e-002	4.e-003	-6.7669e-013
314	1.4911e-003	4.9978e-002	4.e-003	-8.264e-013
315	-4.9703e-004	4.9998e-002	4.e-003	-1.0687e-012
316	-2.4844e-003	4.9938e-002	4.e-003	-1.3643e-012
317	-4.4678e-003	4.98e-002	4.e-003	-1.661e-012
318	-6.4441e-003	4.9583e-002	4.e-003	-1.9894e-012
319	-8.4103e-003	4.9288e-002	4.e-003	-2.202e-012
320	-1.0363e-002	4.8914e-002	4.e-003	-2.2539e-012
321	-1.23e-002	4.8464e-002	4.e-003	-2.2029e-012
322	-1.4217e-002	4.7936e-002	4.e-003	-2.029e-012
323	-1.6111e-002	4.7333e-002	4.e-003	-1.8189e-012
324	-1.798e-002	4.6655e-002	4.e-003	-1.4075e-012
325	-1.9821e-002	4.5904e-002	4.e-003	4.5462e-014
326	-2.163e-002	4.5079e-002	4.e-003	3.9706e-012
327	-2.3405e-002	4.4184e-002	4.e-003	6.3439e-012
328	-2.5143e-002	4.3218e-002	4.e-003	1.8962e-012
329	-2.6842e-002	4.2184e-002	4.e-003	6.0777e-011
330	-2.8498e-002	4.1084e-002	4.e-003	-4.0712e-011
331	-3.0108e-002	3.9919e-002	4.e-003	5.0436e-011
332	3.2435e-002	3.8053e-002	4.2e-002	-1.0648e-011
333	-3.2435e-002	3.8053e-002	8.e-003	-1.2488e-010
334	-3.0896e-002	3.9312e-002	5.e-003	2.2069e-011
335	3.1671e-002	3.869e-002	3.8e-002	-4.5607e-012
336	3.1671e-002	3.869e-002	3.6e-002	-1.4349e-012
337	3.1671e-002	3.869e-002	3.4e-002	-1.6967e-012
338	3.1671e-002	3.869e-002	3.2e-002	-1.4734e-012
339	3.1671e-002	3.869e-002	3.e-002	-1.2501e-012
340	3.1671e-002	3.869e-002	2.8e-002	-1.1964e-012
341	3.1671e-002	3.869e-002	2.6e-002	-1.1948e-012
342	3.1671e-002	3.869e-002	2.4e-002	-1.2769e-012
343	3.1671e-002	3.869e-002	2.2e-002	-1.3536e-012
344	3.1671e-002	3.869e-002	2.e-002	-1.4335e-012
345	3.1671e-002	3.869e-002	1.8e-002	-1.5906e-012
346	3.1671e-002	3.869e-002	1.6e-002	-1.8506e-012
347	3.1671e-002	3.8691e-002	1.4e-002	-2.5613e-012
348	-3.1648e-002	3.8709e-002	1.1989e-002	-7.8471e-011
349	-3.1662e-002	3.8698e-002	1.3993e-002	5.2532e-011
350	-3.1667e-002	3.8694e-002	1.5998e-002	-2.8656e-011
351	-3.1671e-002	3.869e-002	1.8e-002	-1.7625e-010
352	-3.1671e-002	3.869e-002	2.e-002	1.555e-010
353	-3.1671e-002	3.869e-002	2.2e-002	1.6128e-010
354	-3.1671e-002	3.869e-002	2.4e-002	-6.1946e-011
355	-3.1671e-002	3.869e-002	2.6e-002	1.1567e-010
356	-3.1671e-002	3.869e-002	2.8e-002	-6.5967e-011
357	-3.1671e-002	3.8691e-002	3.e-002	-9.5638e-011
358	-3.1671e-002	3.8691e-002	3.2e-002	1.4545e-010
359	-3.1671e-002	3.8691e-002	3.4e-002	-2.7396e-010
360	-3.167e-002	3.8691e-002	3.6e-002	1.1004e-010
361	-3.1662e-002	3.8698e-002	3.8e-002	9.8502e-011
362	-3.1661e-002	3.8698e-002	3.9999e-002	-1.3767e-010
363	-3.167e-002	3.8691e-002	4.2e-002	2.1541e-010
364	-3.0882e-002	3.9323e-002	3.9997e-002	-8.6294e-012
365	-2.7675e-002	4.1642e-002	4.3e-002	1.2725e-011
366	2.9309e-002	4.0509e-002	3.1e-002	-1.3091e-012
367	2.9309e-002	4.0509e-002	2.9e-002	-2.0269e-012
368	2.9309e-002	4.0509e-002	2.7e-002	-2.1203e-012
369	2.9309e-002	4.0509e-002	2.5e-002	-2.2107e-012
370	2.9309e-002	4.0509e-002	2.3e-002	-2.3073e-012
371	2.9309e-002	4.0509e-002	2.1e-002	-2.3909e-012
372	2.9309e-002	4.0509e-002	1.9e-002	-2.5557e-012
373	2.9309e-002	4.0509e-002	1.7e-002	-2.6576e-012
374	2.9309e-002	4.0509e-002	1.5e-002	-2.3195e-012
375	-2.9282e-002	4.0528e-002	1.6991e-002	-9.3063e-013
376	-2.933e-002	4.0494e-002	1.8993e-002	-1.3234e-010
377	-2.9371e-002	4.0464e-002	2.1007e-002	3.6816e-010
378	-2.9362e-002	4.0471e-002	2.3027e-002	-3.9868e-010
379	-2.9318e-002	4.0502e-002	2.5019e-002	1.1886e-010
380	-2.9288e-002	4.0524e-002	2.6996e-002	6.9927e-011
381	-2.9289e-002	4.0523e-002	2.8996e-002	-1.0929e-010
382	2.6842e-002	4.2184e-002	8.e-003	9.0719e-011
383	2.5143e-002	4.3218e-002	8.e-003	5.4979e-012
384	2.3405e-002	4.4184e-002	8.e-003	-2.9585e-013
385	2.163e-002	4.5079e-002	8.e-003	-6.1839e-013
386	1.9821e-002	4.5904e-002	8.e-003	-4.794e-013
387	1.798e-002	4.6655e-002	8.e-003	-5.6857e-013
388	1.6111e-002	4.7333e-002	8.e-003	-6.9695e-013
389	1.4217e-002	4.7936e-002	8.e-003	-7.5877e-013
390	1.23e-002	4.8464e-002	8.e-003	-8.5496e-013
391	1.0363e-002	4.8914e-002	8.e-003	-9.3958e-013
392	8.4103e-003	4.9288e-002	8.e-003	-1.108e-012
393	6.4442e-003	4.9583e-002	8.e-003	-1.3033e-012
394	4.4678e-003	4.98e-002	8.e-003	-1.5547e-012
395	2.4844e-003	4.9938e-002	8.e-003	-1.9087e-012
396	4.9708e-004	4.9998e-002	8.e-003	-2.3825e-012
397	-1.491e-003	4.9978e-002	8.e-003	-2.9902e-012
398	-3.4768e-003	4.9879e-002	8.e-003	-3.753e-012
399	-5.4571e-003	4.9701e-002	8.e-003	-4.5505e-012
400	-7.4287e-003	4.9445e-002	8.e-003	-5.1394e-012
401	-9.3886e-003	4.9111e-002	8.e-003	-5.2783e-012
402	-1.1334e-002	4.8699e-002	8.e-003	-4.6115e-012
403	-1.3261e-002	4.8209e-002	8.e-003	-2.8842e-012
404	-1.5167e-002	4.7644e-002	8.e-003	6.6588e-014
405	-1.7049e-002	4.7003e-002	8.e-003	4.3411e-012
406	-1.8904e-002	4.6289e-002	8.e-003	1.0053e-011
407	-2.073e-002	4.55e-002	8.e-003	1.7871e-011
408	-2.2522e-002	4.464e-002	8.e-003	3.3687e-011
409	-2.4279e-002	4.371e-002	8.e-003	8.7378e-011
410	-2.5987e-002	4.2716e-002	7.9923e-003	-3.166e-011
411	-2.7627e-002	4.1674e-002	9.9688e-003	7.4034e-012
412	-2.7752e-002	4.1591e-002	2.0041e-002	-8.0906e-011
413	-2.6933e-002	4.2126e-002	2.3051e-002	-1.447e-010
414	2.5143e-002	4.3218e-002	1.e-002	-1.3958e-011
415	2.5998e-002	4.271e-002	3.9e-002	-2.0913e-012
416	1.6111e-002	4.7333e-002	1.2e-002	-1.5705e-012
417	2.5997e-002	4.271e-002	3.5e-002	-4.264e-012
418	2.4279e-002	4.371e-002	1.2e-002	-3.6049e-012
419	2.163e-002	4.5079e-002	3.7e-002	-1.1391e-013
420	-2.522e-002	4.3174e-002	2.0056e-002	-6.7064e-011
421	1.7049e-002	4.7003e-002	1.4e-002	-2.2334e-012
422	1.5167e-002	4.7644e-002	1.4e-002	-1.8216e-012
423	-2.4309e-002	4.3693e-002	2.4013e-002	-2.7031e-011
424	2.2522e-002	4.464e-002	1.7e-002	-1.0863e-012
425	-2.163e-002	4.5079e-002	1.5e-002	2.3903e-011
426	-2.3405e-002	4.4184e-002	1.7e-002	-4.0151e-011
427	-2.2522e-002	4.464e-002	1.6e-002	3.7957e-011
428	2.2522e-002	4.464e-002	2.5e-002	-1.7038e-012
429	2.163e-002	4.5079e-002	2.1e-002	-1.1873e-012
430	-2.163e-002	4.5079e-002	2.9e-002	-7.8143e-012
431	1.9821e-002	4.5903e-002	1.7e-002	-3.7162e-012
432	-1.9821e-002	4.5904e-002	1.7e-002	6.4662e-012
433	-2.163e-002	4.5079e-002	2.5e-002	-1.2909e-011
434	-2.073e-002	4.55e-002	3.2e-002	-1.1425e-011
435	-1.8904e-002	4.6289e-002	1.8e-002	5.9294e-012
436	1.6111e-002	4.7333e-002	1.8e-002	-1.4866e-012
437	2.073e-002	4.55e-002	2.9e-002	-9.8329e-013
438	2.073e-002	4.55e-002	2.7e-002	-1.1374e-012
439	1.798e-002	4.6655e-002	1.9e-002	-2.0142e-012
440	1.8904e-002	4.6289e-002	2.1e-002	-2.1851e-012
441	1.8904e-002	4.6289e-002	2.6e-002	-6.2633e-013
442	9.3887e-003	4.9111e-002	2.1e-002	-1.0084e-012
443	1.798e-002	4.6655e-002	2.3e-002	-3.5379e-012
444	1.7049e-002	4.7003e-002	2.1e-002	-1.5071e-012
445	-9.3888e-003	4.9111e-002	2.8e-002	7.0235e-011
446	-7.4289e-003	4.9445e-002	2.8e-002	2.5564e-011
447	3.4769e-003	4.9879e-002	2.2e-002	1.0171e-012
448	1.4911e-003	4.9978e-002	2.2e-002	1.1932e-012
449	-4.9702e-004	4.9998e-002	2.2e-002	1.905e-012
450	-2.4844e-003	4.9938e-002	2.2e-002	2.4873e-012
451	-4.4678e-003	4.98e-002	2.2e-002	4.7121e-012
452	-6.4441e-003	4.9583e-002	2.2e-002	1.0306e-011
453	-8.4103e-003	4.9288e-002	2.2e-002	9.3653e-011
454	-1.0363e-002	4.8914e-002	2.2e-002	-6.6096e-011
455	-1.23e-002	4.8464e-002	2.2e-002	-6.471e-011
456	-1.4217e-002	4.7936e-002	2.8e-002	-7.453e-012
457	1.1334e-002	4.8699e-002	2.2e-002	5.2299e-014
458	8.4104e-003	4.9288e-002	2.3e-002	5.9691e-013
459	-1.1342e-002	4.8697e-002	2.6005e-002	1.2914e-010
460	-1.3261e-002	4.8209e-002	2.4e-002	-1.658e-011
461	-1.2313e-002	4.846e-002	2.5013e-002	-1.1988e-010
462	4.972e-004	4.9998e-002	2.5e-002	4.0461e-012
463	6.4443e-003	4.9583e-002	2.5e-002	-2.4756e-012
464	-3.4645e-002	3.6051e-002	4.9e-002	1.2964e-011
465	-3.3922e-002	3.6733e-002	4.9e-002	3.9549e-011
466	-3.3185e-002	3.74e-002	4.9e-002	-6.46e-011
467	-3.2435e-002	3.8053e-002	4.9e-002	-1.0959e-011
468	-3.1672e-002	3.869e-002	4.9e-002	4.6079e-012
469	-3.0896e-002	3.9312e-002	4.9e-002	1.4738e-011
470	-3.0108e-002	3.9918e-002	4.9e-002	-7.0815e-012
471	-2.9309e-002	4.0509e-002	4.9e-002	1.6853e-012
472	-2.8498e-002	4.1084e-002	4.9e-002	-4.7401e-012
473	-2.7675e-002	4.1642e-002	4.9e-002	-1.9946e-012
474	-2.6842e-002	4.2184e-002	4.9e-002	-5.4992e-013
475	-2.5998e-002	4.271e-002	4.9e-002	-1.3399e-012
476	-2.5143e-002	4.3218e-002	4.9e-002	-7.0713e-013
477	-2.4279e-002	4.371e-002	4.9e-002	-1.4918e-014
478	-2.3405e-002	4.4184e-002	4.9e-002	1.0743e-013
479	-2.2522e-002	4.464e-002	4.9e-002	7.3765e-013
480	-2.163e-002	4.5079e-002	4.9e-002	5.7549e-013
481	-2.073e-002	4.55e-002	4.9e-002	8.9196e-013
482	-1.9821e-002	4.5904e-002	4.9e-002	5.2939e-013
483	-1.8904e-002	4.6289e-002	4.9e-002	7.2186e-013
484	-1.798e-002	4.6655e-002	4.9e-002	3.3645e-013
485	-1.7049e-002	4.7003e-002	4.9e-002	4.8488e-013
486	-1.6111e-002	4.7333e-002	4.9e-002	1.5701e-013
487	-1.5167e-002	4.7644e-002	4.9e-002	3.3147e-013
488	-1.4217e-002	4.7936e-002	4.9e-002	4.9094e-014
489	-1.3261e-002	4.8209e-002	4.9e-002	2.5388e-013
490	-1.23e-002	4.8464e-002	4.9e-002	1.5747e-014
491	-1.1334e-002	4.8699e-002	4.9e-002	2.4609e-013
492	-1.0363e-002	4.8914e-002	4.9e-002	6.8639e-014
493	-9.3886e-003	4.9111e-002	4.9e-002	2.2707e-013
494	-8.4103e-003	4.9288e-002	4.9e-002	7.6058e-014
495	-7.4287e-003	4.9445e-002	4.9e-002	2.2795e-013
496	-6.4442e-003	4.9583e-002	4.9e-002	2.8192e-014
497	-5.4571e-003	4.9701e-002	4.9e-002	2.1678e-013
498	-4.4678e-003	4.98e-002	4.9e-002	1.2616e-013
499	-3.4768e-003	4.9879e-002	4.9e-002	2.0128e-013
500	-2.4844e-003	4.9938e-002	4.9e-002	7.6169e-014
501	-1.491e-003	4.9978e-002	4.9e-002	1.8868e-013
502	-4.9708e-004	4.9998e-002	4.9e-002	8.6425e-014
503	4.9709e-004	4.9998e-002	4.9e-002	1.8823e-013
504	1.491e-003	4.9978e-002	4.9e-002	9.0487e-014
505	2.4844e-003	4.9938e-002	4.9e-002	1.1777e-013
506	3.4768e-003	4.9879e-002	4.9e-002	1.0282e-013
507	4.4678e-003	4.98e-002	4.9e-002	1.1061e-013
508	5.4571e-003	4.9701e-002	4.9e-002	1.0818e-013
509	6.4442e-003	4.9583e-002	4.9e-002	1.039e-013
510	7.4287e-003	4.9445e-002	4.9e-002	6.7674e-014
511	8.4103e-003	4.9288e-002	4.9e-002	4.2782e-014
512	9.3886e-003	4.9111e-002	4.9e-002	5.0554e-014
513	1.0363e-002	4.8914e-002	4.9e-002	6.3136e-014
514	1.1334e-002	4.8699e-002	4.9e-002	1.0842e-013
515	1.23e-002	4.8464e-002	4.9e-002	1.8172e-014
516	1.3261e-002	4.8209e-002	4.9e-002	3.5917e-014
517	1.4217e-002	4.7936e-002	4.9e-002	-2.6125e-014
518	1.5167e-002	4.7644e-002	4.9e-002	8.0863e-014
519	1.6111e-002	4.7333e-002	4.9e-002	-5.7058e-015
520	1.7049e-002	4.7003e-002	4.9e-002	8.057e-014
521	1.798e-002	4.6655e-002	4.9e-002	-3.8648e-014
522	1.8904e-002	4.6289e-002	4.9e-002	8.2748e-014
523	1.9821e-002	4.5904e-002	4.9e-002	-5.0204e-014
524	2.073e-002	4.55e-002	4.9e-002	1.0279e-013
525	2.163e-002	4.5079e-002	4.9e-002	-3.7786e-014
526	2.2522e-002	4.464e-002	4.9e-002	1.3661e-013
527	2.3405e-002	4.4184e-002	4.9e-002	-1.8186e-014
528	2.4279e-002	4.371e-002	4.9e-002	1.738e-013
529	2.5143e-002	4.3218e-002	4.9e-002	1.8469e-014
530	2.5998e-002	4.271e-002	4.9e-002	2.4813e-013
531	2.6842e-002	4.2184e-002	4.9e-002	1.7542e-013
532	2.7675e-002	4.1642e-002	4.9e-002	1.6815e-013
533	2.8498e-002	4.1084e-002	4.9e-002	7.4527e-013
534	2.9309e-002	4.0509e-002	4.9e-002	7.6368e-013
535	3.0108e-002	3.9918e-002	4.9e-002	-2.0642e-013
536	3.0896e-002	3.9312e-002	4.9e-002	4.6356e-012
537	3.1672e-002	3.869e-002	4.9e-002	-1.7244e-012
538	3.2435e-002	3.8053e-002	4.9e-002	3.7641e-011
539	3.3185e-002	3.74e-002	4.9e-002	-1.1141e-010
540	3.3922e-002	3.6733e-002	4.9e-002	3.9235e-011
541	3.4645e-002	3.6051e-002	4.9e-002	4.0548e-011
542	3.4641e-002	3.6055e-002	4.7e-002	-1.8653e-010
543	3.4641e-002	3.6055e-002	4.6e-002	-7.3938e-011
544	3.4641e-002	3.6055e-002	4.5e-002	-3.0658e-011
545	3.4641e-002	3.6055e-002	4.4e-002	-1.6547e-011
546	3.4641e-002	3.6055e-002	4.3e-002	-1.1322e-011
547	3.4641e-002	3.6055e-002	4.2e-002	-8.0581e-012
548	3.4641e-002	3.6055e-002	4.1e-002	-4.8895e-012
549	3.4641e-002	3.6055e-002	4.e-002	-3.5794e-012
550	3.4641e-002	3.6055e-002	3.9e-002	-3.0839e-012
551	3.4641e-002	3.6055e-002	3.8e-002	-2.5648e-012
552	3.4641e-002	3.6055e-002	3.7e-002	-2.1726e-012
553	3.4641e-002	3.6055e-002	3.6e-002	-1.9318e-012
554	3.4641e-002	3.6055e-002	3.5e-002	-1.7364e-012
555	3.4641e-002	3.6055e-002	3.4e-002	-1.598e-012
556	3.4641e-002	3.6055e-002	3.3e-002	-1.5027e-012
557	3.4641e-002	3.6055e-002	3.2e-002	-1.4305e-012
558	3.4641e-002	3.6055e-002	3.1e-002	-1.3786e-012
559	3.4641e-002	3.6055e-002	3.e-002	-1.3392e-012
560	3.4641e-002	3.6055e-002	2.9e-002	-1.31e-012
561	3.4641e-002	3.6055e-002	2.8e-002	-1.2954e-012
562	3.4641e-002	3.6055e-002	2.7e-002	-1.2936e-012
563	3.4641e-002	3.6055e-002	2.6e-002	-1.2837e-012
564	3.4641e-002	3.6055e-002	2.5e-002	-1.2807e-012
565	3.4641e-002	3.6055e-002	2.4e-002	-1.3009e-012
566	3.4641e-002	3.6055e-002	2.3e-002	-1.307e-012
567	3.4641e-002	3.6055e-002	2.2e-002	-1.2985e-012
568	3.4641e-002	3.6055e-002	2.1e-002	-1.3036e-012
569	3.4641e-002	3.6055e-002	2.e-002	-1.3308e-012
570	3.4641e-002	3.6055e-002	1.9e-002	-1.3733e-012
571	3.4641e-002	3.6055e-002	1.8e-002	-1.4092e-012
572	3.4641e-002	3.6055e-002	1.7e-002	-1.4902e-012
573	3.4641e-002	3.6055e-002	1.6e-002	-1.6476e-012
574	3.4641e-002	3.6055e-002	1.5e-002	-1.8575e-012
575	3.4641e-002	3.6055e-002	1.4e-002	-2.1295e-012
576	3.4641e-002	3.6055e-002	1.3e-002	-2.3489e-012
577	3.4641e-002	3.6055e-002	1.2e-002	-3.0832e-012
578	3.4641e-002	3.6055e-002	1.1e-002	-3.7026e-012
579	3.4641e-002	3.6055e-002	1.e-002	-3.3658e-012
580	3.4641e-002	3.6055e-002	9.e-003	-3.4648e-012
581	3.4641e-002	3.6055e-002	8.e-003	-5.0748e-012
582	3.4641e-002	3.6055e-002	7.e-003	-1.1369e-011
583	3.4641e-002	3.6055e-002	6.e-003	-2.6042e-011
584	3.4641e-002	3.6055e-002	5.e-003	-2.0991e-011
585	3.4641e-002	3.6055e-002	3.e-003	-2.054e-011
586	3.4641e-002	3.6055e-002	2.e-003	-4.1718e-010
587	3.4641e-002	3.6055e-002	9.9999e-004	-4.9984e-010
588	3.3922e-002	3.6733e-002	9.9999e-004	-3.6535e-010
589	3.3185e-002	3.74e-002	1.e-003	2.6207e-010
590	3.2435e-002	3.8053e-002	1.e-003	-1.2464e-010
591	3.1672e-002	3.869e-002	1.e-003	6.017e-011
592	3.0896e-002	3.9312e-002	9.9999e-004	1.9092e-012
593	3.0108e-002	3.9918e-002	1.e-003	-2.6743e-012
594	2.9309e-002	4.0509e-002	9.9999e-004	4.5894e-013
595	2.8498e-002	4.1084e-002	1.e-003	2.4619e-013
596	2.7675e-002	4.1642e-002	9.9999e-004	-1.8039e-013
597	2.6842e-002	4.2184e-002	1.e-003	1.1595e-013
598	2.5998e-002	4.271e-002	9.9999e-004	3.6656e-015
599	2.5143e-002	4.3218e-002	1.e-003	-1.3153e-013
600	2.4279e-002	4.371e-002	9.9999e-004	-6.3282e-014
601	2.3405e-002	4.4184e-002	1.e-003	-1.4239e-013
602	2.2522e-002	4.464e-002	9.9999e-004	-9.5609e-015
603	2.163e-002	4.5079e-002	1.e-003	-2.1714e-014
604	2.073e-002	4.55e-002	9.9999e-004	7.3305e-014
605	1.9821e-002	4.5904e-002	1.e-003	1.6411e-014
606	1.8904e-002	4.6289e-002	9.9999e-004	6.0447e-014
607	1.798e-002	4.6655e-002	1.e-003	3.0311e-015
608	1.7049e-002	4.7003e-002	9.9999e-004	6.0389e-014
609	1.6111e-002	4.7333e-002	1.e-003	8.9072e-015
610	1.5167e-002	4.7644e-002	9.9999e-004	3.1157e-014
611	1.4217e-002	4.7936e-002	1.e-003	-6.1836e-014
612	1.3261e-002	4.8209e-002	9.9999e-004	-1.6076e-014
613	1.23e-002	4.8464e-002	1.e-003	-2.2483e-014
614	1.1334e-002	4.8699e-002	9.9999e-004	-1.9511e-015
615	1.0363e-002	4.8914e-002	1.e-003	-5.8928e-014
616	9.3886e-003	4.9111e-002	9.9999e-004	-3.3856e-014
617	8.4103e-003	4.9288e-002	1.e-003	-6.2163e-014
618	7.4287e-003	4.9445e-002	9.9999e-004	-2.4011e-014
619	6.4442e-003	4.9583e-002	1.e-003	-9.2505e-014
620	5.4571e-003	4.9701e-002	9.9999e-004	-3.9769e-014
621	4.4678e-003	4.98e-002	1.e-003	-2.9042e-014
622	3.4768e-003	4.9879e-002	9.9999e-004	-7.3195e-014
623	2.4844e-003	4.9938e-002	1.e-003	-1.2898e-013
624	1.491e-003	4.9978e-002	9.9999e-004	-6.1795e-014
625	4.9708e-004	4.9998e-002	1.e-003	-1.4346e-013
626	-4.9708e-004	4.9998e-002	9.9999e-004	-1.4921e-013
627	-1.491e-003	4.9978e-002	1.e-003	-9.2038e-014
628	-2.4844e-003	4.9938e-002	9.9999e-004	-1.6068e-013
629	-3.4768e-003	4.9879e-002	1.e-003	-2.4374e-013
630	-4.4678e-003	4.98e-002	9.9999e-004	-2.0581e-013
631	-5.4571e-003	4.9701e-002	1.e-003	-1.9884e-013
632	-6.4442e-003	4.9583e-002	9.9999e-004	-2.4544e-013
633	-7.4287e-003	4.9445e-002	1.e-003	-2.4448e-013
634	-8.4103e-003	4.9288e-002	9.9999e-004	-3.1766e-013
635	-9.3886e-003	4.9111e-002	1.e-003	-3.2636e-013
636	-1.0363e-002	4.8914e-002	9.9999e-004	-2.9261e-013
637	-1.1334e-002	4.8699e-002	1.e-003	-2.9021e-013
638	-1.23e-002	4.8464e-002	9.9999e-004	-3.467e-013
639	-1.3261e-002	4.8209e-002	1.e-003	-3.8494e-013
640	-1.4217e-002	4.7936e-002	9.9999e-004	-4.0607e-013
641	-1.5167e-002	4.7644e-002	1.e-003	-3.987e-013
642	-1.6111e-002	4.7333e-002	9.9999e-004	-4.7381e-013
643	-1.7049e-002	4.7003e-002	1.e-003	-4.7972e-013
644	-1.798e-002	4.6655e-002	9.9999e-004	-5.3383e-013
645	-1.8904e-002	4.6289e-002	1.e-003	-4.7028e-013
646	-1.9821e-002	4.5904e-002	9.9999e-004	-3.547e-013
647	-2.073e-002	4.55e-002	1.e-003	-3.7661e-014
648	-2.163e-002	4.5079e-002	9.9999e-004	3.5562e-013
649	-2.2522e-002	4.464e-002	1.e-003	7.7455e-013
650	-2.3405e-002	4.4184e-002	9.9999e-004	9.1909e-013
651	-2.4279e-002	4.371e-002	1.e-003	7.9201e-013
652	-2.5143e-002	4.3218e-002	9.9999e-004	1.1807e-012
653	-2.5998e-002	4.271e-002	1.e-003	1.422e-012
654	-2.6842e-002	4.2184e-002	9.9999e-004	4.6162e-013
655	-2.7675e-002	4.1642e-002	1.e-003	1.6585e-012
656	-2.8498e-002	4.1084e-002	9.9999e-004	4.2838e-012
657	-2.9309e-002	4.0509e-002	1.e-003	5.0381e-012
658	-3.0108e-002	3.9918e-002	9.9999e-004	3.7896e-012
659	-3.0896e-002	3.9312e-002	1.e-003	6.3491e-012
660	-3.1672e-002	3.869e-002	9.9999e-004	5.5398e-013
661	-3.2435e-002	3.8053e-002	1.e-003	4.0767e-011
662	-3.3185e-002	3.74e-002	1.e-003	-1.0759e-010
663	-3.3922e-002	3.6733e-002	1.e-003	4.4487e-011
664	-3.4645e-002	3.6051e-002	1.e-003	4.5439e-011
665	-3.4641e-002	3.6055e-002	3.e-003	-1.8397e-010
666	-3.4641e-002	3.6055e-002	4.e-003	-7.2496e-011
667	-3.4641e-002	3.6055e-002	5.e-003	-4.0361e-011
668	-3.4641e-002	3.6055e-002	6.e-003	-1.9038e-011
669	-3.4641e-002	3.6055e-002	7.e-003	-4.6245e-011
670	-3.4641e-002	3.6055e-002	8.e-003	-5.7286e-011
671	-3.4641e-002	3.6055e-002	9.e-003	-4.2783e-012
672	-3.4641e-002	3.6055e-002	1.e-002	1.1496e-011
673	-3.4641e-002	3.6055e-002	1.1e-002	-1.3229e-011
674	-3.4641e-002	3.6055e-002	1.2e-002	-4.5915e-012
675	-3.4641e-002	3.6055e-002	1.3e-002	3.8362e-011
676	-3.4641e-002	3.6055e-002	1.4e-002	-1.3483e-011
677	-3.4641e-002	3.6055e-002	1.5e-002	-2.3807e-011
678	-3.4641e-002	3.6055e-002	1.6e-002	1.2143e-011
679	-3.4641e-002	3.6055e-002	1.7e-002	4.8263e-013
680	-3.4641e-002	3.6055e-002	1.8e-002	-3.9225e-012
681	-3.4641e-002	3.6055e-002	1.9e-002	-9.5995e-012
682	-3.4641e-002	3.6055e-002	2.e-002	-1.2554e-011
683	-3.4641e-002	3.6055e-002	2.1e-002	-1.8464e-011
684	-3.4641e-002	3.6055e-002	2.2e-002	-1.9767e-011
685	-3.4641e-002	3.6055e-002	2.3e-002	-1.5744e-011
686	-3.4641e-002	3.6055e-002	2.4e-002	-5.0492e-012
687	-3.4641e-002	3.6055e-002	2.5e-002	9.1488e-012
688	-3.4641e-002	3.6055e-002	2.6e-002	2.3603e-011
689	-3.4641e-002	3.6055e-002	2.7e-002	2.7392e-011
690	-3.4641e-002	3.6055e-002	2.8e-002	2.3536e-011
691	-3.4641e-002	3.6055e-002	2.9e-002	1.838e-011
692	-3.4641e-002	3.6055e-002	3.e-002	9.9465e-012
693	-3.4641e-002	3.6055e-002	3.1e-002	4.7802e-012
694	-3.4641e-002	3.6055e-002	3.2e-002	9.4793e-013
695	-3.4641e-002	3.6055e-002	3.3e-002	-4.354e-012
696	-3.4641e-002	3.6055e-002	3.4e-002	-1.2033e-011
697	-3.4641e-002	3.6055e-002	3.5e-002	-6.1914e-012
698	-3.4641e-002	3.6055e-002	3.6e-002	-2.6216e-013
699	-3.4641e-002	3.6055e-002	3.7e-002	-2.2714e-011
700	-3.4641e-002	3.6055e-002	3.8e-002	-1.62e-011
701	-3.4641e-002	3.6055e-002	3.9e-002	-1.5784e-011
702	-3.4641e-002	3.6055e-002	4.e-002	-2.6255e-011
703	-3.4641e-002	3.6055e-002	4.1e-002	6.6046e-012
704	-3.4641e-002	3.6055e-002	4.2e-002	8.6914e-012
705	-3.4641e-002	3.6055e-002	4.3e-002	-1.3134e-011
706	-3.4641e-002	3.6055e-002	4.4e-002	-2.5014e-011
707	-3.4641e-002	3.6055e-002	4.5e-002	6.1743e-011
708	-3.4641e-002	3.6055e-002	4.6e-002	4.182e-011
709	-3.4641e-002	3.6055e-002	4.7e-002	-1.8433e-010
710	-3.4641e-002	3.6055e-002	4.8e-002	-1.5494e-010
711	3.3922e-002	3.6733e-002	2.e-003	-2.1567e-010
712	3.3185e-002	3.74e-002	2.e-003	2.823e-011
713	3.2435e-002	3.8053e-002	2.e-003	-7.7036e-011
714	3.1672e-002	3.869e-002	2.e-003	1.1121e-010
715	3.0896e-002	3.9312e-002	2.e-003	-3.8498e-011
716	3.0108e-002	3.9918e-002	2.e-003	1.1046e-011
717	2.9309e-002	4.0509e-002	2.e-003	-3.4807e-012
718	2.8498e-002	4.1084e-002	2.e-003	-7.8145e-014
719	2.7675e-002	4.1642e-002	2.e-003	4.6874e-013
720	2.6842e-002	4.2184e-002	2.e-003	4.747e-015
721	2.5998e-002	4.271e-002	2.e-003	-1.4165e-013
722	2.5143e-002	4.3218e-002	2.e-003	-2.5929e-013
723	2.4279e-002	4.371e-002	2.e-003	-3.1594e-013
724	2.3405e-002	4.4184e-002	2.e-003	-3.5822e-013
725	2.2522e-002	4.464e-002	2.e-003	4.9867e-014
726	2.163e-002	4.5079e-002	2.e-003	-1.0265e-013
727	2.073e-002	4.55e-002	2.e-003	2.1904e-013
728	1.9821e-002	4.5904e-002	2.e-003	-7.0386e-015
729	1.8904e-002	4.6289e-002	2.e-003	2.1246e-013
730	1.798e-002	4.6655e-002	2.e-003	-1.3457e-014
731	1.7049e-002	4.7003e-002	2.e-003	1.6161e-013
732	1.6111e-002	4.7333e-002	2.e-003	-6.6325e-014
733	1.5167e-002	4.7644e-002	2.e-003	8.1971e-014
734	1.4217e-002	4.7936e-002	2.e-003	-1.2035e-013
735	1.3261e-002	4.8209e-002	2.e-003	1.616e-014
736	1.23e-002	4.8464e-002	2.e-003	-1.469e-013
737	1.1334e-002	4.8699e-002	2.e-003	6.9299e-015
738	1.0363e-002	4.8914e-002	2.e-003	-1.3572e-013
739	9.3886e-003	4.9111e-002	2.e-003	-8.8484e-014
740	8.4103e-003	4.9288e-002	2.e-003	-1.7774e-013
741	7.4287e-003	4.9445e-002	2.e-003	-8.5068e-014
742	6.4441e-003	4.9583e-002	2.e-003	-1.8468e-013
743	5.4571e-003	4.9701e-002	2.e-003	-1.2293e-013
744	4.4678e-003	4.98e-002	2.e-003	-1.8716e-013
745	3.4768e-003	4.9879e-002	2.e-003	-1.898e-013
746	2.4844e-003	4.9938e-002	2.e-003	-2.7602e-013
747	1.491e-003	4.9978e-002	2.e-003	-2.8167e-013
748	4.9706e-004	4.9998e-002	2.e-003	-2.975e-013
749	-4.9709e-004	4.9998e-002	2.e-003	-3.6611e-013
750	-1.4911e-003	4.9978e-002	2.e-003	-3.7362e-013
751	-2.4844e-003	4.9938e-002	2.e-003	-4.7789e-013
752	-3.4768e-003	4.9879e-002	2.e-003	-4.9283e-013
753	-4.4678e-003	4.98e-002	2.e-003	-6.0282e-013
754	-5.4571e-003	4.9701e-002	2.e-003	-5.9503e-013
755	-6.4442e-003	4.9583e-002	2.e-003	-7.1898e-013
756	-7.4287e-003	4.9445e-002	2.e-003	-6.7663e-013
757	-8.4103e-003	4.9288e-002	2.e-003	-8.3688e-013
758	-9.3886e-003	4.9111e-002	2.e-003	-7.5407e-013
759	-1.0363e-002	4.8914e-002	2.e-003	-9.094e-013
760	-1.1334e-002	4.8699e-002	2.e-003	-7.6679e-013
761	-1.23e-002	4.8464e-002	2.e-003	-9.6998e-013
762	-1.3261e-002	4.8209e-002	2.e-003	-8.5624e-013
763	-1.4217e-002	4.7936e-002	2.e-003	-1.0732e-012
764	-1.5167e-002	4.7644e-002	2.e-003	-9.1323e-013
765	-1.6111e-002	4.7333e-002	2.e-003	-1.1904e-012
766	-1.7049e-002	4.7003e-002	2.e-003	-1.0464e-012
767	-1.798e-002	4.6655e-002	2.e-003	-1.2809e-012
768	-1.8904e-002	4.6289e-002	2.e-003	-8.9991e-013
769	-1.9821e-002	4.5904e-002	2.e-003	-7.6598e-013
770	-2.073e-002	4.55e-002	2.e-003	2.1338e-013
771	-2.163e-002	4.5079e-002	2.e-003	9.373e-013
772	-2.2522e-002	4.464e-002	2.e-003	2.44e-012
773	-2.3405e-002	4.4184e-002	2.e-003	2.565e-012
774	-2.4279e-002	4.371e-002	2.e-003	2.6905e-012
775	-2.5143e-002	4.3218e-002	2.e-003	1.3983e-012
776	-2.5998e-002	4.271e-002	2.e-003	4.8296e-012
777	-2.6842e-002	4.2184e-002	2.e-003	5.129e-012
778	-2.7675e-002	4.1642e-002	2.e-003	3.6862e-012
779	-2.8498e-002	4.1084e-002	2.e-003	9.397e-012
780	-2.9309e-002	4.0509e-002	2.e-003	9.5591e-012
781	-3.0108e-002	3.9918e-002	2.e-003	1.2693e-011
782	-3.0896e-002	3.9312e-002	2.e-003	8.8226e-012
783	-3.2435e-002	3.8053e-002	2.e-003	-9.3204e-012
784	-3.3185e-002	3.74e-002	2.e-003	6.5169e-011
785	-3.3922e-002	3.6733e-002	2.e-003	-1.8372e-010
786	-3.3922e-002	3.6733e-002	3.e-003	-1.9477e-010
787	-3.3922e-002	3.6733e-002	4.e-003	-6.3147e-011
788	-3.3922e-002	3.6733e-002	5.e-003	-2.3754e-011
789	-3.3922e-002	3.6733e-002	6.e-003	-5.3558e-011
790	-3.3922e-002	3.6733e-002	7.e-003	5.296e-011
791	-3.3922e-002	3.6733e-002	8.e-003	8.8961e-011
792	-3.3922e-002	3.6733e-002	9.e-003	-8.5886e-011
793	-3.3922e-002	3.6733e-002	1.e-002	-1.5256e-010
794	-3.3922e-002	3.6733e-002	1.1e-002	-7.3121e-011
795	-3.3922e-002	3.6733e-002	1.2e-002	-6.7012e-011
796	-3.3922e-002	3.6733e-002	1.3e-002	-1.4118e-010
797	-3.3922e-002	3.6733e-002	1.4e-002	6.9694e-011
798	-3.3922e-002	3.6733e-002	1.5e-002	1.3413e-010
799	-3.3922e-002	3.6733e-002	1.6e-002	-1.0717e-011
800	-3.3922e-002	3.6733e-002	1.7e-002	-1.7802e-011
801	-3.3922e-002	3.6733e-002	1.8e-002	1.9887e-012
802	-3.3922e-002	3.6733e-002	1.9e-002	1.0861e-011
803	-3.3922e-002	3.6733e-002	2.e-002	-3.5268e-012
804	-3.3922e-002	3.6733e-002	2.1e-002	-5.3637e-012
805	-3.3922e-002	3.6733e-002	2.2e-002	-8.1281e-012
806	-3.3922e-002	3.6733e-002	2.3e-002	-3.9456e-012
807	-3.3922e-002	3.6733e-002	2.4e-002	8.2305e-012
808	-3.3922e-002	3.6733e-002	2.5e-002	2.3088e-011
809	-3.3921e-002	3.6733e-002	2.6e-002	2.4678e-011
810	-3.3921e-002	3.6733e-002	2.7e-002	3.2814e-011
811	-3.3921e-002	3.6733e-002	2.8e-002	3.3437e-011
812	-3.3921e-002	3.6733e-002	2.9e-002	1.8232e-011
813	-3.3921e-002	3.6733e-002	3.e-002	1.4065e-011
814	-3.3921e-002	3.6733e-002	3.1e-002	3.5687e-012
815	-3.3921e-002	3.6734e-002	3.2e-002	-6.4198e-012
816	-3.3921e-002	3.6734e-002	3.3e-002	-6.6677e-013
817	-3.3921e-002	3.6734e-002	3.4e-002	1.0418e-011
818	-3.3921e-002	3.6734e-002	3.5e-002	-3.2243e-011
819	-3.3921e-002	3.6734e-002	3.6e-002	-5.6483e-011
820	-3.3921e-002	3.6734e-002	3.7e-002	1.981e-011
821	-3.3921e-002	3.6734e-002	3.8e-002	-2.243e-011
822	-3.3921e-002	3.6734e-002	3.9e-002	-3.3055e-011
823	-3.3921e-002	3.6734e-002	4.e-002	2.6526e-011
824	-3.3921e-002	3.6734e-002	4.1e-002	-5.7619e-011
825	-3.3921e-002	3.6734e-002	4.2e-002	-4.1541e-011
826	-3.392e-002	3.6734e-002	4.3e-002	3.2845e-011
827	-3.392e-002	3.6734e-002	4.4e-002	-2.8254e-012
828	-3.392e-002	3.6734e-002	4.5e-002	-2.094e-010
829	-3.392e-002	3.6735e-002	4.6e-002	-2.3566e-010
830	-3.392e-002	3.6735e-002	4.7e-002	-3.5066e-011
831	-3.392e-002	3.6735e-002	4.8e-002	-2.4767e-011
832	-3.3185e-002	3.74e-002	4.8e-002	-6.616e-011
833	-3.2435e-002	3.8053e-002	4.8e-002	-1.0152e-010
834	-3.1672e-002	3.869e-002	4.8e-002	1.2525e-010
835	-3.0896e-002	3.9312e-002	4.8e-002	-3.5342e-011
836	-3.0108e-002	3.9918e-002	4.8e-002	5.8412e-012
837	-2.9309e-002	4.0509e-002	4.8e-002	-5.8231e-012
838	-2.7675e-002	4.1642e-002	4.8e-002	-4.8072e-012
839	-2.5998e-002	4.271e-002	4.8e-002	-3.3854e-012
840	-2.4279e-002	4.371e-002	4.8e-002	-2.3861e-013
841	-2.2522e-002	4.464e-002	4.8e-002	1.7288e-012
842	-2.073e-002	4.55e-002	4.8e-002	2.096e-012
843	-1.8904e-002	4.6289e-002	4.8e-002	1.6407e-012
844	-1.7049e-002	4.7003e-002	4.8e-002	1.0814e-012
845	-1.5167e-002	4.7644e-002	4.8e-002	7.0355e-013
846	-1.3261e-002	4.8209e-002	4.8e-002	5.1091e-013
847	-1.1334e-002	4.8699e-002	4.8e-002	5.0575e-013
848	-9.3886e-003	4.9111e-002	4.8e-002	5.0404e-013
849	-7.4287e-003	4.9445e-002	4.8e-002	5.068e-013
850	-5.4571e-003	4.9701e-002	4.8e-002	5.1093e-013
851	-3.4768e-003	4.9879e-002	4.8e-002	4.9159e-013
852	-1.491e-003	4.9978e-002	4.8e-002	4.6873e-013
853	4.971e-004	4.9998e-002	4.8e-002	4.1891e-013
854	2.4844e-003	4.9938e-002	4.8e-002	3.6173e-013
855	4.4678e-003	4.98e-002	4.8e-002	3.3635e-013
856	6.4442e-003	4.9583e-002	4.8e-002	2.539e-013
857	8.4103e-003	4.9288e-002	4.8e-002	1.8557e-013
858	1.0363e-002	4.8914e-002	4.8e-002	1.8082e-013
859	1.23e-002	4.8464e-002	4.8e-002	1.0426e-013
860	1.4217e-002	4.7936e-002	4.8e-002	3.8692e-014
861	1.6111e-002	4.7333e-002	4.8e-002	4.3752e-014
862	1.798e-002	4.6655e-002	4.8e-002	5.2231e-015
863	1.9821e-002	4.5904e-002	4.8e-002	-5.4233e-015
864	2.163e-002	4.5079e-002	4.8e-002	2.8194e-014
865	2.3405e-002	4.4184e-002	4.8e-002	7.8427e-014
866	2.5143e-002	4.3218e-002	4.8e-002	1.5153e-013
867	2.6842e-002	4.2184e-002	4.8e-002	4.7366e-014
868	2.8498e-002	4.1084e-002	4.8e-002	1.469e-013
869	3.0108e-002	3.9918e-002	4.8e-002	2.7121e-012
870	3.1672e-002	3.869e-002	4.8e-002	1.6935e-011
871	3.2435e-002	3.8053e-002	4.8e-002	-1.7486e-011
872	3.3185e-002	3.74e-002	4.8e-002	5.6957e-011
873	3.3922e-002	3.6733e-002	4.8e-002	-1.9246e-010
874	3.3922e-002	3.6733e-002	4.7e-002	-2.0114e-010
875	3.3922e-002	3.6733e-002	4.6e-002	-6.7476e-011
876	3.3922e-002	3.6733e-002	4.5e-002	-3.4282e-011
877	3.3922e-002	3.6733e-002	4.4e-002	-2.2728e-011
878	3.3922e-002	3.6733e-002	4.3e-002	-1.4637e-011
879	3.3922e-002	3.6733e-002	4.2e-002	-9.2563e-012
880	3.3922e-002	3.6733e-002	4.1e-002	-6.8023e-012
881	3.3922e-002	3.6733e-002	4.e-002	-5.674e-012
882	3.3922e-002	3.6733e-002	3.9e-002	-3.6694e-012
883	3.3922e-002	3.6733e-002	3.8e-002	-2.6901e-012
884	3.3922e-002	3.6733e-002	3.7e-002	-2.1816e-012
885	3.3922e-002	3.6733e-002	3.6e-002	-1.6552e-012
886	3.3922e-002	3.6733e-002	3.5e-002	-1.3418e-012
887	3.3922e-002	3.6733e-002	3.4e-002	-1.1089e-012
888	3.3922e-002	3.6733e-002	3.3e-002	-8.8224e-013
889	3.3922e-002	3.6733e-002	3.2e-002	-7.5378e-013
890	3.3922e-002	3.6733e-002	3.1e-002	-6.8879e-013
891	3.3922e-002	3.6733e-002	3.e-002	-6.0394e-013
892	3.3922e-002	3.6733e-002	2.9e-002	-5.6585e-013
893	3.3922e-002	3.6733e-002	2.8e-002	-5.3287e-013
894	3.3922e-002	3.6733e-002	2.7e-002	-4.9984e-013
895	3.3922e-002	3.6733e-002	2.6e-002	-5.3861e-013
896	3.3922e-002	3.6733e-002	2.5e-002	-5.48e-013
897	3.3922e-002	3.6733e-002	2.4e-002	-5.299e-013
898	3.3922e-002	3.6733e-002	2.3e-002	-5.4949e-013
899	3.3922e-002	3.6733e-002	2.2e-002	-5.5691e-013
900	3.3922e-002	3.6733e-002	2.1e-002	-5.8648e-013
901	3.3922e-002	3.6733e-002	2.e-002	-6.3262e-013
902	3.3922e-002	3.6733e-002	1.9e-002	-6.616e-013
903	3.3922e-002	3.6733e-002	1.8e-002	-7.5216e-013
904	3.3921e-002	3.6733e-002	1.7e-002	-8.8663e-013
905	3.3921e-002	3.6733e-002	1.6e-002	-1.086e-012
906	3.3921e-002	3.6733e-002	1.5e-002	-1.4584e-012
907	3.3921e-002	3.6733e-002	1.4e-002	-1.9663e-012
908	3.3921e-002	3.6733e-002	1.3e-002	-2.7678e-012
909	3.3921e-002	3.6734e-002	1.2e-002	-3.5788e-012
910	3.3921e-002	3.6734e-002	1.1e-002	-4.5295e-012
911	3.3921e-002	3.6734e-002	1.e-002	-5.5986e-012
912	3.3921e-002	3.6734e-002	9.0001e-003	-6.9698e-012
913	3.3921e-002	3.6734e-002	8.0001e-003	-1.3354e-011
914	3.3921e-002	3.6734e-002	7.0001e-003	-9.1948e-012
915	3.3921e-002	3.6734e-002	6.0001e-003	-6.0066e-012
916	3.3921e-002	3.6734e-002	5.0001e-003	-7.7848e-011
917	3.3921e-002	3.6734e-002	4.0001e-003	-1.9863e-010
918	3.3921e-002	3.6734e-002	3.0001e-003	-1.7149e-010
919	-3.2435e-002	3.8053e-002	4.7e-002	-7.6534e-011
920	-3.1672e-002	3.869e-002	4.7e-002	1.121e-010
921	-3.0896e-002	3.9312e-002	4.7e-002	-3.7808e-011
922	-3.0108e-002	3.9919e-002	4.7e-002	8.3715e-012
923	-2.9309e-002	4.0509e-002	4.7e-002	-2.6622e-011
924	-2.8498e-002	4.1084e-002	4.7e-002	-1.7218e-012
925	-2.7675e-002	4.1642e-002	4.7e-002	-8.9332e-012
926	-2.6842e-002	4.2184e-002	4.7e-002	-5.6834e-012
927	-2.5998e-002	4.271e-002	4.7e-002	-5.2013e-012
928	-2.5143e-002	4.3218e-002	4.7e-002	-2.7531e-012
929	-2.4279e-002	4.371e-002	4.7e-002	-4.1305e-013
930	-2.3405e-002	4.4184e-002	4.7e-002	1.7507e-012
931	-2.2522e-002	4.464e-002	4.7e-002	2.9191e-012
932	-2.163e-002	4.5079e-002	4.7e-002	3.4824e-012
933	-2.073e-002	4.55e-002	4.7e-002	3.3762e-012
934	-1.9821e-002	4.5904e-002	4.7e-002	3.0826e-012
935	-1.8904e-002	4.6289e-002	4.7e-002	2.5169e-012
936	-1.798e-002	4.6655e-002	4.7e-002	2.0725e-012
937	-1.7049e-002	4.7003e-002	4.7e-002	1.5613e-012
938	-1.6111e-002	4.7333e-002	4.7e-002	1.254e-012
939	-1.5167e-002	4.7644e-002	4.7e-002	9.4413e-013
940	-1.4217e-002	4.7936e-002	4.7e-002	8.2329e-013
941	-1.3261e-002	4.8209e-002	4.7e-002	6.6526e-013
942	-1.23e-002	4.8464e-002	4.7e-002	7.0556e-013
943	-1.1334e-002	4.8699e-002	4.7e-002	6.7148e-013
944	-1.0363e-002	4.8914e-002	4.7e-002	7.4978e-013
945	-9.3886e-003	4.9111e-002	4.7e-002	7.3482e-013
946	-8.4103e-003	4.9288e-002	4.7e-002	7.8059e-013
947	-7.4287e-003	4.9445e-002	4.7e-002	7.8006e-013
948	-6.4441e-003	4.9583e-002	4.7e-002	8.5119e-013
949	-5.4571e-003	4.9701e-002	4.7e-002	8.0362e-013
950	-4.4678e-003	4.98e-002	4.7e-002	8.4089e-013
951	-3.4768e-003	4.9879e-002	4.7e-002	7.8436e-013
952	-2.4844e-003	4.9938e-002	4.7e-002	8.0688e-013
953	-1.4911e-003	4.9978e-002	4.7e-002	7.6024e-013
954	-4.9706e-004	4.9998e-002	4.7e-002	7.7197e-013
955	4.9706e-004	4.9998e-002	4.7e-002	7.1963e-013
956	1.4911e-003	4.9978e-002	4.7e-002	7.0058e-013
957	2.4844e-003	4.9938e-002	4.7e-002	6.5013e-013
958	3.4768e-003	4.9879e-002	4.7e-002	6.1312e-013
959	4.4678e-003	4.98e-002	4.7e-002	5.8451e-013
960	5.4571e-003	4.9701e-002	4.7e-002	5.4974e-013
961	6.4441e-003	4.9583e-002	4.7e-002	4.6823e-013
962	7.4287e-003	4.9445e-002	4.7e-002	4.5411e-013
963	8.4103e-003	4.9288e-002	4.7e-002	4.0442e-013
964	9.3886e-003	4.9111e-002	4.7e-002	3.6659e-013
965	1.0363e-002	4.8914e-002	4.7e-002	3.2757e-013
966	1.1334e-002	4.8699e-002	4.7e-002	2.7011e-013
967	1.23e-002	4.8464e-002	4.7e-002	2.4259e-013
968	1.3261e-002	4.8209e-002	4.7e-002	2.1477e-013
969	1.4217e-002	4.7936e-002	4.7e-002	1.678e-013
970	1.5167e-002	4.7644e-002	4.7e-002	1.5399e-013
971	1.6111e-002	4.7333e-002	4.7e-002	1.4767e-013
972	1.7049e-002	4.7003e-002	4.7e-002	1.1035e-013
973	1.798e-002	4.6655e-002	4.7e-002	1.237e-013
974	1.8904e-002	4.6289e-002	4.7e-002	1.1224e-013
975	1.9821e-002	4.5904e-002	4.7e-002	1.3377e-013
976	2.073e-002	4.55e-002	4.7e-002	1.4012e-013
977	2.163e-002	4.5079e-002	4.7e-002	2.0123e-013
978	2.2522e-002	4.464e-002	4.7e-002	2.2196e-013
979	2.3405e-002	4.4184e-002	4.7e-002	3.052e-013
980	2.4279e-002	4.371e-002	4.7e-002	3.4695e-013
981	2.5143e-002	4.3218e-002	4.7e-002	4.9147e-013
982	2.5998e-002	4.271e-002	4.7e-002	6.1312e-013
983	2.6842e-002	4.2184e-002	4.7e-002	7.2912e-013
984	2.7675e-002	4.1642e-002	4.7e-002	1.5176e-012
985	2.8498e-002	4.1084e-002	4.7e-002	9.1866e-013
986	2.9309e-002	4.0509e-002	4.7e-002	2.453e-012
987	3.0108e-002	3.9918e-002	4.7e-002	3.1754e-012
988	3.0896e-002	3.9312e-002	4.7e-002	1.9901e-012
989	3.1672e-002	3.869e-002	4.7e-002	7.1687e-012
990	3.2435e-002	3.8053e-002	4.7e-002	-1.5029e-011
991	3.3185e-002	3.74e-002	4.7e-002	4.8745e-011
992	3.3185e-002	3.74e-002	4.6e-002	-4.4468e-011
993	3.3185e-002	3.74e-002	4.5e-002	-3.5629e-011
994	3.3185e-002	3.74e-002	4.4e-002	-2.0896e-011
995	3.3185e-002	3.74e-002	4.3e-002	-1.0874e-011
996	3.3185e-002	3.74e-002	4.2e-002	-1.1491e-011
997	3.3185e-002	3.74e-002	4.1e-002	-1.0552e-011
998	3.3185e-002	3.74e-002	4.e-002	-6.1943e-012
999	3.3185e-002	3.74e-002	3.9e-002	-5.2703e-012
1000	3.3185e-002	3.74e-002	3.8e-002	-4.0574e-012
1001	3.3185e-002	3.74e-002	3.7e-002	-2.7904e-012
1002	3.3185e-002	3.74e-002	3.6e-002	-2.5051e-012
1003	3.3185e-002	3.74e-002	3.5e-002	-2.1995e-012
1004	3.3185e-002	3.74e-002	3.4e-002	-1.8175e-012
1005	3.3185e-002	3.74e-002	3.3e-002	-1.6025e-012
1006	3.3185e-002	3.74e-002	3.2e-002	-1.416e-012
1007	3.3185e-002	3.74e-002	3.1e-002	-1.2779e-012
1008	3.3185e-002	3.74e-002	3.e-002	-1.2216e-012
1009	3.3185e-002	3.74e-002	2.9e-002	-1.1518e-012
1010	3.3185e-002	3.74e-002	2.8e-002	-1.1002e-012
1011	3.3185e-002	3.74e-002	2.7e-002	-1.0923e-012
1012	3.3185e-002	3.74e-002	2.6e-002	-1.1092e-012
1013	3.3185e-002	3.74e-002	2.5e-002	-1.1455e-012
1014	3.3185e-002	3.74e-002	2.4e-002	-1.123e-012
1015	3.3185e-002	3.74e-002	2.3e-002	-1.1259e-012
1016	3.3185e-002	3.74e-002	2.2e-002	-1.2098e-012
1017	3.3185e-002	3.74e-002	2.1e-002	-1.2533e-012
1018	3.3185e-002	3.74e-002	2.e-002	-1.2638e-012
1019	3.3185e-002	3.74e-002	1.9e-002	-1.301e-012
1020	3.3186e-002	3.7399e-002	1.8e-002	-1.3962e-012
1021	3.3186e-002	3.7399e-002	1.7e-002	-1.5531e-012
1022	3.3186e-002	3.7399e-002	1.6e-002	-1.7824e-012
1023	3.3186e-002	3.7399e-002	1.5e-002	-2.153e-012
1024	3.3186e-002	3.7399e-002	1.4e-002	-2.8327e-012
1025	3.3186e-002	3.7399e-002	1.3e-002	-3.716e-012
1026	3.3186e-002	3.7399e-002	1.2e-002	-4.0169e-012
1027	3.3186e-002	3.7399e-002	1.1e-002	-3.8979e-012
1028	3.3186e-002	3.7399e-002	1.e-002	-6.6415e-012
1029	3.3186e-002	3.7399e-002	8.9999e-003	-9.7801e-012
1030	3.3186e-002	3.7399e-002	7.9999e-003	-5.1983e-012
1031	3.3187e-002	3.7399e-002	6.9999e-003	-3.905e-011
1032	3.3187e-002	3.7398e-002	5.9999e-003	-4.9892e-011
1033	3.3187e-002	3.7398e-002	4.9999e-003	4.678e-011
1034	3.3187e-002	3.7398e-002	3.9999e-003	-1.1418e-011
1035	3.3187e-002	3.7398e-002	3.e-003	-1.7059e-010
1036	3.2435e-002	3.8053e-002	3.e-003	1.1572e-010
1037	3.1672e-002	3.869e-002	3.e-003	-7.3248e-012
1038	3.0896e-002	3.9312e-002	3.e-003	-1.2894e-011
1039	3.0108e-002	3.9918e-002	3.e-003	5.9289e-012
1040	2.9309e-002	4.0509e-002	3.e-003	-8.9346e-012
1041	2.8498e-002	4.1084e-002	3.e-003	2.3309e-012
1042	2.7675e-002	4.1642e-002	3.e-003	4.2195e-013
1043	2.6842e-002	4.2184e-002	3.e-003	-1.6696e-013
1044	2.5998e-002	4.271e-002	3.e-003	-3.1858e-013
1045	2.5143e-002	4.3218e-002	3.e-003	-8.5625e-013
1046	2.4279e-002	4.371e-002	3.e-003	-6.033e-013
1047	2.3405e-002	4.4184e-002	3.e-003	-4.4084e-013
1048	2.2522e-002	4.464e-002	3.e-003	-4.3437e-014
1049	2.163e-002	4.5079e-002	3.e-003	-1.9203e-014
1050	2.073e-002	4.55e-002	3.e-003	2.3361e-013
1051	1.9821e-002	4.5904e-002	3.e-003	1.2283e-013
1052	1.8904e-002	4.6289e-002	3.e-003	2.3798e-013
1053	1.798e-002	4.6655e-002	3.e-003	7.3612e-014
1054	1.7049e-002	4.7003e-002	3.e-003	1.3219e-013
1055	1.6111e-002	4.7333e-002	3.e-003	-3.5075e-014
1056	1.5167e-002	4.7644e-002	3.e-003	1.678e-014
1057	1.4217e-002	4.7936e-002	3.e-003	-1.0186e-013
1058	1.3261e-002	4.8209e-002	3.e-003	-6.7951e-014
1059	1.23e-002	4.8464e-002	3.e-003	-1.8786e-013
1060	1.1334e-002	4.8699e-002	3.e-003	-1.1008e-013
1061	1.0363e-002	4.8914e-002	3.e-003	-2.0284e-013
1062	9.3886e-003	4.9111e-002	3.e-003	-2.0072e-013
1063	8.4103e-003	4.9288e-002	3.e-003	-2.6977e-013
1064	7.4287e-003	4.9445e-002	3.e-003	-2.3645e-013
1065	6.4442e-003	4.9583e-002	3.e-003	-2.8265e-013
1066	5.4571e-003	4.9701e-002	3.e-003	-3.2221e-013
1067	4.4678e-003	4.98e-002	3.e-003	-3.7621e-013
1068	3.4768e-003	4.9879e-002	3.e-003	-4.0365e-013
1069	2.4844e-003	4.9938e-002	3.e-003	-4.6103e-013
1070	1.491e-003	4.9978e-002	3.e-003	-5.5851e-013
1071	4.9708e-004	4.9998e-002	3.e-003	-5.848e-013
1072	-4.9707e-004	4.9998e-002	3.e-003	-6.845e-013
1073	-1.491e-003	4.9978e-002	3.e-003	-7.767e-013
1074	-2.4844e-003	4.9938e-002	3.e-003	-9.0462e-013
1075	-3.4768e-003	4.9879e-002	3.e-003	-9.3242e-013
1076	-4.4678e-003	4.98e-002	3.e-003	-1.1275e-012
1077	-5.4571e-003	4.9701e-002	3.e-003	-1.1844e-012
1078	-6.4442e-003	4.9583e-002	3.e-003	-1.3613e-012
1079	-7.4287e-003	4.9445e-002	3.e-003	-1.3563e-012
1080	-8.4103e-003	4.9288e-002	3.e-003	-1.497e-012
1081	-9.3886e-003	4.9111e-002	3.e-003	-1.4811e-012
1082	-1.0363e-002	4.8914e-002	3.e-003	-1.6342e-012
1083	-1.1334e-002	4.8699e-002	3.e-003	-1.5126e-012
1084	-1.23e-002	4.8464e-002	3.e-003	-1.6583e-012
1085	-1.3261e-002	4.8209e-002	3.e-003	-1.553e-012
1086	-1.4217e-002	4.7936e-002	3.e-003	-1.7095e-012
1087	-1.5167e-002	4.7644e-002	3.e-003	-1.5838e-012
1088	-1.6111e-002	4.7333e-002	3.e-003	-1.7733e-012
1089	-1.7049e-002	4.7003e-002	3.e-003	-1.6405e-012
1090	-1.798e-002	4.6655e-002	3.e-003	-1.737e-012
1091	-1.8904e-002	4.6289e-002	3.e-003	-1.2649e-012
1092	-1.9821e-002	4.5904e-002	3.e-003	-7.799e-013
1093	-2.073e-002	4.55e-002	3.e-003	6.4618e-013
1094	-2.163e-002	4.5079e-002	3.e-003	2.1166e-012
1095	-2.2522e-002	4.464e-002	3.e-003	3.9547e-012
1096	-2.3405e-002	4.4184e-002	3.e-003	6.0026e-012
1097	-2.4279e-002	4.371e-002	3.e-003	4.6015e-012
1098	-2.5143e-002	4.3218e-002	3.e-003	4.17e-012
1099	-2.5998e-002	4.271e-002	3.e-003	-1.7815e-012
1100	-2.6842e-002	4.2184e-002	3.e-003	3.1336e-011
1101	-2.7675e-002	4.1642e-002	3.e-003	2.8209e-011
1102	-2.8498e-002	4.1084e-002	3.e-003	-3.4969e-011
1103	-2.9309e-002	4.0509e-002	3.e-003	2.8585e-011
1104	-3.0108e-002	3.9918e-002	3.e-003	3.9947e-011
1105	-3.0896e-002	3.9312e-002	3.e-003	2.4034e-012
1106	-3.1672e-002	3.869e-002	3.e-003	2.0768e-011
1107	-3.2435e-002	3.8053e-002	3.e-003	-3.6542e-012
1108	-3.3185e-002	3.74e-002	3.e-003	6.2153e-011
1109	-3.3185e-002	3.74e-002	4.e-003	-3.6923e-011
1110	-3.3185e-002	3.74e-002	5.e-003	-1.5131e-011
1111	-3.3185e-002	3.74e-002	6.e-003	1.4244e-010
1112	-3.3185e-002	3.74e-002	7.e-003	5.1278e-011
1113	-3.3185e-002	3.74e-002	8.e-003	-1.3314e-010
1114	-3.3185e-002	3.74e-002	9.e-003	-1.9825e-010
1115	-3.3185e-002	3.74e-002	1.e-002	-1.5194e-010
1116	-3.3185e-002	3.74e-002	1.1e-002	-1.1304e-011
1117	-3.3185e-002	3.74e-002	1.2e-002	-6.2201e-012
1118	-3.3185e-002	3.74e-002	1.3e-002	1.0648e-010
1119	-3.3185e-002	3.74e-002	1.4e-002	-7.2826e-011
1120	-3.3185e-002	3.74e-002	1.5e-002	-2.1978e-010
1121	-3.3185e-002	3.74e-002	1.6e-002	-1.7222e-011
1122	-3.3185e-002	3.74e-002	1.7e-002	1.0205e-010
1123	-3.3185e-002	3.74e-002	1.8e-002	6.6127e-011
1124	-3.3185e-002	3.74e-002	1.9e-002	1.1726e-011
1125	-3.3185e-002	3.74e-002	2.e-002	3.1894e-011
1126	-3.3185e-002	3.74e-002	2.1e-002	2.2968e-011
1127	-3.3186e-002	3.7399e-002	2.2e-002	1.904e-011
1128	-3.3186e-002	3.7399e-002	2.3e-002	1.2581e-011
1129	-3.3186e-002	3.7399e-002	2.4e-002	6.8477e-012
1130	-3.3186e-002	3.7399e-002	2.5e-002	1.7736e-011
1131	-3.3186e-002	3.7399e-002	2.6e-002	6.0428e-011
1132	-3.3186e-002	3.7399e-002	2.7e-002	3.683e-011
1133	-3.3186e-002	3.7399e-002	2.8e-002	2.0865e-012
1134	-3.3186e-002	3.7399e-002	2.9e-002	1.116e-011
1135	-3.3186e-002	3.7399e-002	3.e-002	-9.9425e-012
1136	-3.3186e-002	3.7399e-002	3.1e-002	2.1146e-012
1137	-3.3187e-002	3.7399e-002	3.2e-002	1.8726e-011
1138	-3.3187e-002	3.7398e-002	3.3e-002	-2.5945e-011
1139	-3.3187e-002	3.7398e-002	3.4e-002	-4.6098e-011
1140	-3.3187e-002	3.7398e-002	3.5e-002	1.0793e-010
1141	-3.3187e-002	3.7398e-002	3.6e-002	1.3447e-010
1142	-3.3187e-002	3.7398e-002	3.7e-002	-1.5934e-010
1143	-3.3187e-002	3.7398e-002	3.8e-002	-1.2075e-010
1144	-3.3187e-002	3.7398e-002	3.9e-002	-1.3846e-010
1145	-3.3188e-002	3.7398e-002	4.e-002	-2.3899e-010
1146	-3.3188e-002	3.7398e-002	4.1e-002	1.6163e-010
1147	-3.3188e-002	3.7397e-002	4.2e-002	1.7566e-010
1148	-3.3188e-002	3.7397e-002	4.3e-002	-1.1941e-010
1149	-3.3188e-002	3.7397e-002	4.4e-002	-7.2591e-011
1150	-3.3188e-002	3.7397e-002	4.5e-002	8.9177e-011
1151	-3.3189e-002	3.7397e-002	4.6e-002	4.9804e-011
1152	3.2435e-002	3.8053e-002	4.6e-002	-8.2822e-013
1153	3.2435e-002	3.8053e-002	4.5e-002	-1.5521e-011
1154	3.2435e-002	3.8053e-002	4.4e-002	-2.1561e-011
1155	3.2435e-002	3.8053e-002	4.3e-002	-2.2061e-011
1156	3.2434e-002	3.8053e-002	4.1e-002	-4.5494e-012
1157	3.2434e-002	3.8053e-002	4.e-002	-5.8053e-012
1158	3.2434e-002	3.8053e-002	3.9e-002	-4.6749e-012
1159	3.2434e-002	3.8053e-002	3.8e-002	-4.4496e-012
1160	3.2434e-002	3.8053e-002	3.7e-002	-5.3059e-012
1161	3.2434e-002	3.8053e-002	3.6e-002	-4.4993e-012
1162	3.2434e-002	3.8053e-002	3.5e-002	-3.5077e-012
1163	3.2434e-002	3.8053e-002	3.4e-002	-3.2411e-012
1164	3.2434e-002	3.8053e-002	3.3e-002	-3.022e-012
1165	3.2434e-002	3.8053e-002	3.2e-002	-2.8463e-012
1166	3.2434e-002	3.8053e-002	3.1e-002	-2.6985e-012
1167	3.2434e-002	3.8053e-002	3.e-002	-2.6155e-012
1168	3.2434e-002	3.8053e-002	2.9e-002	-2.5646e-012
1169	3.2434e-002	3.8053e-002	2.8e-002	-2.5215e-012
1170	3.2434e-002	3.8053e-002	2.7e-002	-2.5296e-012
1171	3.2434e-002	3.8053e-002	2.6e-002	-2.5222e-012
1172	3.2434e-002	3.8053e-002	2.5e-002	-2.5308e-012
1173	3.2434e-002	3.8053e-002	2.4e-002	-2.5979e-012
1174	3.2434e-002	3.8053e-002	2.3e-002	-2.6215e-012
1175	3.2434e-002	3.8053e-002	2.2e-002	-2.6274e-012
1176	3.2434e-002	3.8053e-002	2.1e-002	-2.6807e-012
1177	3.2434e-002	3.8053e-002	2.e-002	-2.7558e-012
1178	3.2434e-002	3.8053e-002	1.9e-002	-2.8002e-012
1179	3.2434e-002	3.8053e-002	1.8e-002	-2.8362e-012
1180	3.2434e-002	3.8053e-002	1.7e-002	-2.9883e-012
1181	3.2433e-002	3.8054e-002	1.6e-002	-3.2475e-012
1182	3.2433e-002	3.8054e-002	1.5e-002	-3.5986e-012
1183	3.2433e-002	3.8054e-002	1.4e-002	-3.9785e-012
1184	3.2433e-002	3.8054e-002	1.3e-002	-4.3891e-012
1185	3.2433e-002	3.8054e-002	1.2e-002	-5.9592e-012
1186	3.2433e-002	3.8054e-002	1.1e-002	-8.1074e-012
1187	3.2433e-002	3.8054e-002	1.e-002	-7.0816e-012
1188	3.2433e-002	3.8054e-002	9.e-003	-1.0911e-011
1189	3.2433e-002	3.8054e-002	8.e-003	-1.7719e-011
1190	3.2433e-002	3.8054e-002	7.e-003	4.5917e-011
1191	3.2433e-002	3.8054e-002	5.0001e-003	-7.644e-011
1192	3.2433e-002	3.8054e-002	4.0001e-003	2.6971e-011
1193	3.1672e-002	3.869e-002	4.e-003	-5.7372e-011
1194	3.0896e-002	3.9312e-002	4.e-003	6.8727e-011
1195	3.0108e-002	3.9918e-002	4.e-003	-7.3827e-011
1196	2.9309e-002	4.0509e-002	4.e-003	2.6314e-011
1197	2.8498e-002	4.1084e-002	4.e-003	-4.6035e-012
1198	2.7675e-002	4.1642e-002	4.e-003	6.7692e-014
1199	2.6842e-002	4.2184e-002	4.e-003	-4.656e-013
1200	2.5998e-002	4.271e-002	4.e-003	-9.7879e-013
1201	2.5143e-002	4.3218e-002	4.e-003	-1.5949e-012
1202	2.3405e-002	4.4184e-002	4.e-003	-3.4994e-013
1203	2.163e-002	4.5079e-002	4.e-003	2.8943e-013
1204	1.9821e-002	4.5904e-002	4.e-003	4.0572e-013
1205	1.798e-002	4.6655e-002	4.e-003	2.6973e-013
1206	1.6111e-002	4.7333e-002	4.e-003	1.2116e-013
1207	1.4217e-002	4.7936e-002	4.e-003	-2.5495e-014
1208	1.23e-002	4.8464e-002	4.e-003	-1.2271e-013
1209	1.0363e-002	4.8914e-002	4.e-003	-2.4097e-013
1210	8.4103e-003	4.9288e-002	4.e-003	-3.158e-013
1211	6.4441e-003	4.9583e-002	4.e-003	-4.2078e-013
1212	4.4678e-003	4.98e-002	4.e-003	-5.6027e-013
1213	2.4844e-003	4.9938e-002	4.e-003	-7.2684e-013
1214	4.9706e-004	4.9998e-002	4.e-003	-9.8425e-013
1215	-1.4911e-003	4.9978e-002	4.e-003	-1.2571e-012
1216	-3.4768e-003	4.9879e-002	4.e-003	-1.5862e-012
1217	-5.4571e-003	4.9701e-002	4.e-003	-1.9537e-012
1218	-7.4287e-003	4.9445e-002	4.e-003	-2.2483e-012
1219	-9.3886e-003	4.9111e-002	4.e-003	-2.4416e-012
1220	-1.1334e-002	4.8699e-002	4.e-003	-2.4775e-012
1221	-1.3261e-002	4.8209e-002	4.e-003	-2.3699e-012
1222	-1.5167e-002	4.7644e-002	4.e-003	-2.217e-012
1223	-1.7049e-002	4.7003e-002	4.e-003	-1.991e-012
1224	-1.8904e-002	4.6289e-002	4.e-003	-1.254e-012
1225	-2.073e-002	4.55e-002	4.e-003	1.1683e-012
1226	-2.2522e-002	4.464e-002	4.e-003	5.8862e-012
1227	-2.4279e-002	4.371e-002	4.e-003	1.1953e-011
1228	-2.5998e-002	4.271e-002	4.e-003	5.7755e-012
1229	-2.7675e-002	4.1642e-002	4.e-003	3.646e-011
1230	-2.9309e-002	4.0509e-002	4.e-003	2.3044e-011
1231	-3.1672e-002	3.869e-002	4.e-003	1.9947e-011
1232	-3.2435e-002	3.8053e-002	4.e-003	1.7948e-011
1233	-3.2435e-002	3.8053e-002	5.e-003	-2.1798e-011
1234	-3.2435e-002	3.8053e-002	6.e-003	-1.2152e-010
1235	-3.2435e-002	3.8053e-002	7.e-003	-1.1351e-010
1236	-3.2428e-002	3.8058e-002	9.001e-003	2.177e-010
1237	-3.2427e-002	3.8059e-002	1.e-002	3.3531e-010
1238	-3.2426e-002	3.806e-002	1.0999e-002	-1.8079e-010
1239	-3.2428e-002	3.8058e-002	1.1996e-002	-2.8027e-011
1240	-3.2427e-002	3.8059e-002	1.2996e-002	2.5048e-011
1241	-3.2434e-002	3.8053e-002	1.4e-002	-2.7678e-010
1242	-3.2434e-002	3.8053e-002	1.5e-002	-1.3472e-010
1243	-3.2434e-002	3.8053e-002	1.6e-002	-5.2534e-011
1244	-3.2434e-002	3.8053e-002	1.7e-002	-1.5537e-010
1245	-3.2434e-002	3.8053e-002	1.8e-002	-3.6713e-011
1246	-3.2434e-002	3.8053e-002	1.9e-002	8.6861e-011
1247	-3.2434e-002	3.8053e-002	2.e-002	9.7625e-011
1248	-3.2434e-002	3.8053e-002	2.1e-002	1.5395e-010
1249	-3.2434e-002	3.8053e-002	2.2e-002	1.7465e-010
1250	-3.2434e-002	3.8053e-002	2.3e-002	1.8343e-010
1251	-3.2434e-002	3.8053e-002	2.4e-002	1.5796e-010
1252	-3.2434e-002	3.8053e-002	2.5e-002	3.9239e-011
1253	-3.2434e-002	3.8053e-002	2.6e-002	-1.5947e-010
1254	-3.2434e-002	3.8053e-002	2.7e-002	-1.1617e-010
1255	-3.2434e-002	3.8053e-002	2.8e-002	-1.4403e-012
1256	-3.2434e-002	3.8053e-002	2.9e-002	-2.1284e-011
1257	-3.2434e-002	3.8053e-002	3.e-002	6.9876e-012
1258	-3.2434e-002	3.8053e-002	3.1e-002	-5.8146e-011
1259	-3.2434e-002	3.8053e-002	3.2e-002	-9.3541e-011
1260	-3.2434e-002	3.8053e-002	3.3e-002	7.2072e-011
1261	-3.2434e-002	3.8053e-002	3.4e-002	1.0023e-010
1262	-3.2434e-002	3.8053e-002	3.5e-002	-2.2646e-010
1263	-3.2434e-002	3.8053e-002	3.6e-002	-2.8774e-010
1264	-3.2433e-002	3.8054e-002	3.7e-002	1.7361e-010
1265	-3.2433e-002	3.8054e-002	3.8e-002	8.2797e-011
1266	-3.2433e-002	3.8054e-002	3.9e-002	1.0803e-010
1267	-3.2433e-002	3.8054e-002	4.e-002	2.8976e-010
1268	-3.2433e-002	3.8054e-002	4.1e-002	-4.2718e-010
1269	-3.2433e-002	3.8054e-002	4.2e-002	-4.0581e-010
1270	-3.2433e-002	3.8054e-002	4.3e-002	2.9926e-010
1271	-3.2433e-002	3.8054e-002	4.4e-002	2.2784e-010
1272	-3.2433e-002	3.8054e-002	4.5e-002	1.3307e-011
1273	-3.2433e-002	3.8054e-002	4.6e-002	3.6591e-011
1274	-3.1672e-002	3.869e-002	4.6e-002	-6.5149e-011
1275	-3.0896e-002	3.9312e-002	4.6e-002	8.8384e-011
1276	-2.9309e-002	4.0509e-002	4.6e-002	1.896e-011
1277	-2.8498e-002	4.1084e-002	4.6e-002	-1.3225e-011
1278	-2.7675e-002	4.1642e-002	4.6e-002	-7.7414e-012
1279	-2.5998e-002	4.271e-002	4.6e-002	-6.993e-012
1280	-2.5143e-002	4.3218e-002	4.6e-002	-3.8878e-012
1281	-2.4279e-002	4.371e-002	4.6e-002	4.2615e-013
1282	-2.3405e-002	4.4184e-002	4.6e-002	3.272e-012
1283	-2.2522e-002	4.464e-002	4.6e-002	4.635e-012
1284	-2.163e-002	4.5079e-002	4.6e-002	5.1444e-012
1285	-2.073e-002	4.55e-002	4.6e-002	4.8367e-012
1286	-1.9821e-002	4.5904e-002	4.6e-002	4.3031e-012
1287	-1.8904e-002	4.6289e-002	4.6e-002	3.4755e-012
1288	-1.798e-002	4.6655e-002	4.6e-002	2.811e-012
1289	-1.7049e-002	4.7003e-002	4.6e-002	2.106e-012
1290	-1.6111e-002	4.7333e-002	4.6e-002	1.6918e-012
1291	-1.5167e-002	4.7644e-002	4.6e-002	1.2875e-012
1292	-1.4217e-002	4.7936e-002	4.6e-002	1.1462e-012
1293	-1.3261e-002	4.8209e-002	4.6e-002	9.9455e-013
1294	-1.23e-002	4.8464e-002	4.6e-002	1.0552e-012
1295	-1.1334e-002	4.8699e-002	4.6e-002	1.0266e-012
1296	-1.0363e-002	4.8914e-002	4.6e-002	1.1537e-012
1297	-9.3886e-003	4.9111e-002	4.6e-002	1.1431e-012
1298	-8.4103e-003	4.9288e-002	4.6e-002	1.2688e-012
1299	-7.4287e-003	4.9445e-002	4.6e-002	1.2533e-012
1300	-6.4442e-003	4.9583e-002	4.6e-002	1.3332e-012
1301	-5.4571e-003	4.9701e-002	4.6e-002	1.2903e-012
1302	-4.4678e-003	4.98e-002	4.6e-002	1.3704e-012
1303	-3.4768e-003	4.9879e-002	4.6e-002	1.2765e-012
1304	-2.4844e-003	4.9938e-002	4.6e-002	1.3365e-012
1305	-1.4911e-003	4.9978e-002	4.6e-002	1.2221e-012
1306	-4.9708e-004	4.9998e-002	4.6e-002	1.2424e-012
1307	4.9706e-004	4.9998e-002	4.6e-002	1.1661e-012
1308	1.491e-003	4.9978e-002	4.6e-002	1.1532e-012
1309	2.4844e-003	4.9938e-002	4.6e-002	1.0351e-012
1310	3.4768e-003	4.9879e-002	4.6e-002	1.0573e-012
1311	4.4678e-003	4.98e-002	4.6e-002	9.0507e-013
1312	5.4571e-003	4.9701e-002	4.6e-002	8.8904e-013
1313	6.4441e-003	4.9583e-002	4.6e-002	7.8105e-013
1314	7.4287e-003	4.9445e-002	4.6e-002	7.6338e-013
1315	8.4103e-003	4.9288e-002	4.6e-002	6.4777e-013
1316	9.3886e-003	4.9111e-002	4.6e-002	6.245e-013
1317	1.0363e-002	4.8914e-002	4.6e-002	4.7656e-013
1318	1.1334e-002	4.8699e-002	4.6e-002	4.8577e-013
1319	1.23e-002	4.8464e-002	4.6e-002	3.6983e-013
1320	1.3261e-002	4.8209e-002	4.6e-002	3.6768e-013
1321	1.4217e-002	4.7936e-002	4.6e-002	2.6964e-013
1322	1.5167e-002	4.7644e-002	4.6e-002	2.7185e-013
1323	1.6111e-002	4.7333e-002	4.6e-002	1.7701e-013
1324	1.7049e-002	4.7003e-002	4.6e-002	2.2806e-013
1325	1.798e-002	4.6655e-002	4.6e-002	1.5868e-013
1326	1.8904e-002	4.6289e-002	4.6e-002	1.998e-013
1327	1.9821e-002	4.5904e-002	4.6e-002	1.6893e-013
1328	2.073e-002	4.55e-002	4.6e-002	2.5132e-013
1329	2.163e-002	4.5079e-002	4.6e-002	2.4819e-013
1330	2.2522e-002	4.464e-002	4.6e-002	3.6353e-013
1331	2.3405e-002	4.4184e-002	4.6e-002	3.8325e-013
1332	2.4279e-002	4.371e-002	4.6e-002	5.2867e-013
1333	2.5143e-002	4.3218e-002	4.6e-002	5.8127e-013
1334	2.5998e-002	4.271e-002	4.6e-002	7.1936e-013
1335	2.6842e-002	4.2184e-002	4.6e-002	9.9778e-013
1336	2.7675e-002	4.1642e-002	4.6e-002	1.2317e-012
1337	2.8498e-002	4.1084e-002	4.6e-002	1.6897e-012
1338	3.0108e-002	3.9918e-002	4.6e-002	3.1507e-012
1339	3.0896e-002	3.9312e-002	4.6e-002	3.1946e-013
1340	3.1672e-002	3.869e-002	4.6e-002	-4.4846e-012
1341	3.1672e-002	3.869e-002	5.e-003	-1.0002e-011
1342	-3.1672e-002	3.869e-002	4.5e-002	-6.7714e-011
1343	-3.0896e-002	3.9312e-002	4.5e-002	3.9667e-011
1344	-3.0108e-002	3.9919e-002	4.5e-002	-1.1642e-010
1345	-2.9309e-002	4.0509e-002	4.5e-002	5.2585e-011
1346	-2.8498e-002	4.1084e-002	4.5e-002	-2.2367e-011
1347	-2.7675e-002	4.1642e-002	4.5e-002	-4.8714e-012
1348	-2.6842e-002	4.2184e-002	4.5e-002	-1.5199e-011
1349	-2.5998e-002	4.271e-002	4.5e-002	-1.1009e-011
1350	-2.5143e-002	4.3218e-002	4.5e-002	-2.9939e-012
1351	-2.4279e-002	4.371e-002	4.5e-002	2.218e-012
1352	-2.3405e-002	4.4184e-002	4.5e-002	5.1459e-012
1353	-2.2522e-002	4.464e-002	4.5e-002	6.3117e-012
1354	-2.163e-002	4.5079e-002	4.5e-002	6.6254e-012
1355	-2.073e-002	4.55e-002	4.5e-002	5.8767e-012
1356	-1.9821e-002	4.5904e-002	4.5e-002	5.1615e-012
1357	-1.8904e-002	4.6288e-002	4.5e-002	3.9837e-012
1358	-1.798e-002	4.6655e-002	4.5e-002	3.2317e-012
1359	-1.7049e-002	4.7003e-002	4.5e-002	2.3227e-012
1360	-1.6111e-002	4.7333e-002	4.5e-002	1.9388e-012
1361	-1.5167e-002	4.7644e-002	4.5e-002	1.4237e-012
1362	-1.4217e-002	4.7936e-002	4.5e-002	1.4025e-012
1363	-1.3261e-002	4.8209e-002	4.5e-002	1.2239e-012
1364	-1.23e-002	4.8464e-002	4.5e-002	1.3842e-012
1365	-1.1334e-002	4.8699e-002	4.5e-002	1.3737e-012
1366	-1.0363e-002	4.8914e-002	4.5e-002	1.5962e-012
1367	-9.3887e-003	4.9111e-002	4.5e-002	1.6036e-012
1368	-8.4103e-003	4.9288e-002	4.5e-002	1.8119e-012
1369	-7.4288e-003	4.9445e-002	4.5e-002	1.7794e-012
1370	-6.4442e-003	4.9583e-002	4.5e-002	1.8925e-012
1371	-5.4571e-003	4.9701e-002	4.5e-002	1.8695e-012
1372	-4.4678e-003	4.98e-002	4.5e-002	1.9395e-012
1373	-3.4769e-003	4.9879e-002	4.5e-002	1.8886e-012
1374	-2.4844e-003	4.9938e-002	4.5e-002	1.8627e-012
1375	-1.4911e-003	4.9978e-002	4.5e-002	1.8091e-012
1376	-4.9708e-004	4.9998e-002	4.5e-002	1.7899e-012
1377	4.9702e-004	4.9998e-002	4.5e-002	1.6927e-012
1378	1.491e-003	4.9978e-002	4.5e-002	1.633e-012
1379	2.4844e-003	4.9938e-002	4.5e-002	1.5513e-012
1380	3.4768e-003	4.9879e-002	4.5e-002	1.4656e-012
1381	4.4678e-003	4.98e-002	4.5e-002	1.3939e-012
1382	5.4571e-003	4.9701e-002	4.5e-002	1.2489e-012
1383	6.4441e-003	4.9583e-002	4.5e-002	1.1945e-012
1384	7.4287e-003	4.9445e-002	4.5e-002	1.0334e-012
1385	8.4103e-003	4.9288e-002	4.5e-002	9.88e-013
1386	9.3886e-003	4.9111e-002	4.5e-002	8.1558e-013
1387	1.0363e-002	4.8914e-002	4.5e-002	8.0022e-013
1388	1.1334e-002	4.8699e-002	4.5e-002	6.3083e-013
1389	1.23e-002	4.8464e-002	4.5e-002	6.0905e-013
1390	1.3261e-002	4.8209e-002	4.5e-002	4.3159e-013
1391	1.4217e-002	4.7936e-002	4.5e-002	4.9405e-013
1392	1.5167e-002	4.7644e-002	4.5e-002	2.8794e-013
1393	1.6111e-002	4.7333e-002	4.5e-002	3.5687e-013
1394	1.7049e-002	4.7003e-002	4.5e-002	2.0247e-013
1395	1.798e-002	4.6655e-002	4.5e-002	3.2419e-013
1396	1.8904e-002	4.6289e-002	4.5e-002	1.5275e-013
1397	1.9821e-002	4.5904e-002	4.5e-002	3.3852e-013
1398	2.073e-002	4.55e-002	4.5e-002	2.0415e-013
1399	2.163e-002	4.5079e-002	4.5e-002	4.3574e-013
1400	2.2522e-002	4.464e-002	4.5e-002	3.1756e-013
1401	2.3405e-002	4.4184e-002	4.5e-002	6.0405e-013
1402	2.4279e-002	4.371e-002	4.5e-002	4.9348e-013
1403	2.5143e-002	4.3218e-002	4.5e-002	7.6705e-013
1404	2.5998e-002	4.271e-002	4.5e-002	6.0389e-013
1405	2.6842e-002	4.2184e-002	4.5e-002	7.818e-013
1406	2.7675e-002	4.1642e-002	4.5e-002	1.8156e-012
1407	2.8498e-002	4.1084e-002	4.5e-002	5.0807e-013
1408	2.9309e-002	4.0509e-002	4.5e-002	-2.9693e-013
1409	3.0108e-002	3.9918e-002	4.5e-002	3.0788e-012
1410	3.0896e-002	3.9312e-002	4.5e-002	-4.2625e-012
1411	3.1672e-002	3.869e-002	4.5e-002	-4.8581e-012
1412	3.1672e-002	3.869e-002	4.4e-002	-8.3007e-012
1413	3.1672e-002	3.869e-002	4.3e-002	-9.482e-012
1414	3.1671e-002	3.869e-002	4.2e-002	-9.511e-012
1415	3.1671e-002	3.869e-002	4.1e-002	-7.7543e-012
1416	3.1671e-002	3.869e-002	4.e-002	-6.0103e-012
1417	3.1671e-002	3.869e-002	3.9e-002	-5.912e-012
1418	3.1671e-002	3.869e-002	3.7e-002	-1.7126e-012
1419	3.1671e-002	3.869e-002	3.5e-002	-2.1453e-012
1420	3.1671e-002	3.869e-002	3.3e-002	-1.4548e-012
1421	3.1671e-002	3.869e-002	3.1e-002	-1.3861e-012
1422	3.1671e-002	3.869e-002	2.9e-002	-1.2136e-012
1423	3.1671e-002	3.869e-002	2.7e-002	-1.1844e-012
1424	3.1671e-002	3.869e-002	2.5e-002	-1.2019e-012
1425	3.1671e-002	3.869e-002	2.3e-002	-1.3518e-012
1426	3.1671e-002	3.869e-002	2.1e-002	-1.3869e-012
1427	3.1671e-002	3.869e-002	1.9e-002	-1.4938e-012
1428	3.1671e-002	3.869e-002	1.7e-002	-1.6918e-012
1429	3.1671e-002	3.869e-002	1.5e-002	-2.0933e-012
1430	3.1671e-002	3.8691e-002	1.3e-002	-3.4419e-012
1431	3.1671e-002	3.8691e-002	1.2e-002	-4.6095e-012
1432	3.1671e-002	3.8691e-002	1.1e-002	-6.8939e-012
1433	3.1671e-002	3.8691e-002	1.e-002	-6.1779e-012
1434	3.1671e-002	3.8691e-002	9.0001e-003	5.8786e-012
1435	3.1671e-002	3.8691e-002	8.0001e-003	1.9415e-012
1436	3.167e-002	3.8691e-002	7.0001e-003	-6.717e-011
1437	3.167e-002	3.8691e-002	6.0001e-003	-7.0158e-011
1438	3.0896e-002	3.9312e-002	5.e-003	4.3677e-011
1439	3.0108e-002	3.9918e-002	5.e-003	-6.1872e-011
1440	2.9309e-002	4.0509e-002	5.e-003	2.6113e-011
1441	2.8498e-002	4.1084e-002	5.e-003	-1.0921e-011
1442	2.7675e-002	4.1642e-002	5.e-003	5.576e-013
1443	2.6842e-002	4.2184e-002	5.e-003	-1.8766e-012
1444	2.5998e-002	4.271e-002	5.e-003	-3.0711e-012
1445	2.5143e-002	4.3218e-002	5.e-003	-7.9493e-013
1446	2.4279e-002	4.371e-002	5.e-003	-1.2461e-012
1447	2.3405e-002	4.4184e-002	5.e-003	-4.173e-013
1448	2.2522e-002	4.464e-002	5.e-003	-2.0273e-013
1449	2.163e-002	4.5079e-002	5.e-003	3.0003e-013
1450	2.073e-002	4.55e-002	5.e-003	1.4034e-013
1451	1.9821e-002	4.5904e-002	5.e-003	3.5598e-013
1452	1.8904e-002	4.6288e-002	5.e-003	5.0443e-014
1453	1.798e-002	4.6655e-002	5.e-003	1.863e-013
1454	1.7049e-002	4.7003e-002	5.e-003	-1.0697e-013
1455	1.6111e-002	4.7333e-002	5.e-003	8.5943e-015
1456	1.5167e-002	4.7644e-002	5.e-003	-2.4631e-013
1457	1.4217e-002	4.7936e-002	5.e-003	-1.5858e-013
1458	1.3261e-002	4.8209e-002	5.e-003	-3.6708e-013
1459	1.23e-002	4.8464e-002	5.e-003	-2.6219e-013
1460	1.1334e-002	4.8699e-002	5.e-003	-4.6215e-013
1461	1.0363e-002	4.8914e-002	5.e-003	-3.8429e-013
1462	9.3887e-003	4.9111e-002	5.e-003	-5.5409e-013
1463	8.4103e-003	4.9288e-002	5.e-003	-4.8907e-013
1464	7.4288e-003	4.9445e-002	5.e-003	-6.4267e-013
1465	6.4442e-003	4.9583e-002	5.e-003	-6.5394e-013
1466	5.4571e-003	4.9701e-002	5.e-003	-7.6585e-013
1467	4.4678e-003	4.98e-002	5.e-003	-7.8452e-013
1468	3.4769e-003	4.9879e-002	5.e-003	-9.5238e-013
1469	2.4844e-003	4.9938e-002	5.e-003	-1.0445e-012
1470	1.4911e-003	4.9978e-002	5.e-003	-1.1728e-012
1471	4.9708e-004	4.9998e-002	5.e-003	-1.3391e-012
1472	-4.9702e-004	4.9998e-002	5.e-003	-1.5355e-012
1473	-1.491e-003	4.9978e-002	5.e-003	-1.7253e-012
1474	-2.4844e-003	4.9938e-002	5.e-003	-1.9102e-012
1475	-3.4768e-003	4.9879e-002	5.e-003	-2.1926e-012
1476	-4.4678e-003	4.98e-002	5.e-003	-2.3578e-012
1477	-5.4571e-003	4.9701e-002	5.e-003	-2.6552e-012
1478	-6.4441e-003	4.9583e-002	5.e-003	-2.7792e-012
1479	-7.4287e-003	4.9445e-002	5.e-003	-3.04e-012
1480	-8.4103e-003	4.9288e-002	5.e-003	-3.0821e-012
1481	-9.3886e-003	4.9111e-002	5.e-003	-3.2366e-012
1482	-1.0363e-002	4.8914e-002	5.e-003	-3.0905e-012
1483	-1.1334e-002	4.8699e-002	5.e-003	-3.1638e-012
1484	-1.23e-002	4.8464e-002	5.e-003	-2.8694e-012
1485	-1.3261e-002	4.8209e-002	5.e-003	-2.7832e-012
1486	-1.4217e-002	4.7936e-002	5.e-003	-2.3293e-012
1487	-1.5167e-002	4.7644e-002	5.e-003	-2.1923e-012
1488	-1.6111e-002	4.7333e-002	5.e-003	-1.6115e-012
1489	-1.7049e-002	4.7003e-002	5.e-003	-1.36e-012
1490	-1.798e-002	4.6655e-002	5.e-003	-5.5662e-013
1491	-1.8904e-002	4.6289e-002	5.e-003	3.9171e-014
1492	-1.9821e-002	4.5904e-002	5.e-003	1.4495e-012
1493	-2.073e-002	4.55e-002	5.e-003	2.9719e-012
1494	-2.163e-002	4.5079e-002	5.e-003	5.3345e-012
1495	-2.2522e-002	4.464e-002	5.e-003	9.23e-012
1496	-2.3405e-002	4.4184e-002	5.e-003	1.0099e-011
1497	-2.4279e-002	4.371e-002	5.e-003	-4.2933e-013
1498	-2.5143e-002	4.3218e-002	5.e-003	1.7416e-011
1499	-2.5998e-002	4.271e-002	5.e-003	7.6431e-011
1500	-2.6842e-002	4.2184e-002	5.e-003	-1.3551e-011
1501	-2.7673e-002	4.1644e-002	4.991e-003	6.4349e-012
1502	-2.8497e-002	4.1084e-002	4.9885e-003	1.2607e-010
1503	-2.931e-002	4.0509e-002	4.9913e-003	5.6591e-012
1504	-3.0108e-002	3.9919e-002	5.e-003	-4.5561e-011
1505	-3.1672e-002	3.869e-002	5.e-003	2.0549e-011
1506	-3.1672e-002	3.869e-002	6.e-003	-1.8088e-010
1507	-3.1672e-002	3.869e-002	7.e-003	-3.0337e-010
1508	-3.166e-002	3.8699e-002	8.0048e-003	2.1565e-010
1509	-3.1648e-002	3.8709e-002	9.0041e-003	2.8816e-010
1510	-3.1642e-002	3.8714e-002	9.998e-003	-9.1495e-011
1511	-3.1648e-002	3.8709e-002	1.099e-002	1.6792e-010
1512	-3.1656e-002	3.8702e-002	1.299e-002	-4.0907e-010
1513	-3.1666e-002	3.8695e-002	1.4996e-002	1.1997e-010
1514	-3.1671e-002	3.869e-002	1.7e-002	-3.664e-011
1515	-3.1671e-002	3.869e-002	1.9e-002	-5.9576e-011
1516	-3.1671e-002	3.869e-002	2.1e-002	2.4626e-010
1517	-3.1671e-002	3.869e-002	2.3e-002	-1.3527e-011
1518	-3.1671e-002	3.869e-002	2.5e-002	-1.2475e-011
1519	-3.1671e-002	3.869e-002	2.7e-002	-5.2859e-012
1520	-3.1671e-002	3.8691e-002	2.9e-002	3.6308e-011
1521	-3.1671e-002	3.8691e-002	3.1e-002	-5.9818e-011
1522	-3.1671e-002	3.8691e-002	3.3e-002	-1.3989e-011
1523	-3.1671e-002	3.8691e-002	3.5e-002	-1.0744e-010
1524	-3.1663e-002	3.8697e-002	3.7e-002	-5.8011e-011
1525	-3.1662e-002	3.8698e-002	3.8999e-002	1.5236e-010
1526	-3.167e-002	3.8691e-002	4.1e-002	2.0562e-010
1527	-3.167e-002	3.8691e-002	4.3e-002	-3.3848e-010
1528	-3.167e-002	3.8691e-002	4.4e-002	-2.8085e-010
1529	3.0896e-002	3.9312e-002	4.4e-002	-2.7411e-013
1530	3.0896e-002	3.9312e-002	4.3e-002	2.0046e-012
1531	3.0896e-002	3.9312e-002	4.2e-002	-4.3229e-012
1532	3.0896e-002	3.9312e-002	4.1e-002	-8.562e-012
1533	3.0896e-002	3.9312e-002	4.e-002	-6.8089e-012
1534	3.0896e-002	3.9312e-002	3.9e-002	-5.0611e-012
1535	3.0896e-002	3.9312e-002	3.8e-002	-4.7055e-012
1536	3.0896e-002	3.9312e-002	3.7e-002	-4.3642e-012
1537	3.0896e-002	3.9312e-002	3.6e-002	-2.8064e-012
1538	3.0896e-002	3.9312e-002	3.5e-002	-1.8088e-012
1539	3.0896e-002	3.9312e-002	3.4e-002	-2.206e-012
1540	3.0896e-002	3.9312e-002	3.3e-002	-2.3461e-012
1541	3.0896e-002	3.9312e-002	3.2e-002	-2.1164e-012
1542	3.0896e-002	3.9312e-002	3.1e-002	-2.2192e-012
1543	3.0896e-002	3.9312e-002	3.e-002	-2.3333e-012
1544	3.0896e-002	3.9312e-002	2.9e-002	-2.2323e-012
1545	3.0896e-002	3.9312e-002	2.8e-002	-2.2323e-012
1546	3.0896e-002	3.9312e-002	2.7e-002	-2.2429e-012
1547	3.0896e-002	3.9312e-002	2.6e-002	-2.2671e-012
1548	3.0897e-002	3.9312e-002	2.5e-002	-2.3257e-012
1549	3.0897e-002	3.9312e-002	2.4e-002	-2.3389e-012
1550	3.0897e-002	3.9312e-002	2.3e-002	-2.3932e-012
1551	3.0897e-002	3.9312e-002	2.2e-002	-2.4898e-012
1552	3.0897e-002	3.9311e-002	2.1e-002	-2.5195e-012
1553	3.0897e-002	3.9311e-002	2.e-002	-2.5158e-012
1554	3.0897e-002	3.9311e-002	1.9e-002	-2.5905e-012
1555	3.0897e-002	3.9311e-002	1.8e-002	-2.7121e-012
1556	3.0897e-002	3.9311e-002	1.7e-002	-2.7881e-012
1557	3.0897e-002	3.9311e-002	1.6e-002	-2.8896e-012
1558	3.0897e-002	3.9311e-002	1.5e-002	-3.0186e-012
1559	3.0897e-002	3.9311e-002	1.4e-002	-3.323e-012
1560	3.0897e-002	3.9311e-002	1.3e-002	-4.5396e-012
1561	3.0897e-002	3.9311e-002	1.2e-002	-3.7598e-012
1562	3.0897e-002	3.9311e-002	1.1e-002	-1.8959e-012
1563	3.0898e-002	3.9311e-002	1.e-002	-1.4855e-011
1564	3.0898e-002	3.9311e-002	9.e-003	-2.2644e-011
1565	3.0898e-002	3.9311e-002	8.e-003	-7.3205e-012
1566	3.0898e-002	3.9311e-002	7.e-003	-2.3192e-011
1567	3.0898e-002	3.9311e-002	6.e-003	-3.1002e-011
1568	3.0108e-002	3.9918e-002	6.e-003	8.5359e-011
1569	2.9309e-002	4.0509e-002	6.e-003	-5.7005e-011
1570	2.8498e-002	4.1084e-002	6.e-003	5.1117e-013
1571	2.7675e-002	4.1642e-002	6.e-003	-1.1795e-012
1572	2.6842e-002	4.2184e-002	6.e-003	-1.0109e-011
1573	2.5998e-002	4.271e-002	6.e-003	2.4135e-012
1574	2.5143e-002	4.3218e-002	6.e-003	-1.886e-012
1575	2.4279e-002	4.371e-002	6.e-003	-1.4254e-012
1576	2.3405e-002	4.4184e-002	6.e-003	-4.0066e-013
1577	2.2522e-002	4.464e-002	6.e-003	-3.496e-014
1578	2.163e-002	4.5079e-002	6.e-003	1.5569e-013
1579	2.073e-002	4.55e-002	6.e-003	1.968e-013
1580	1.9821e-002	4.5904e-002	6.e-003	1.1285e-013
1581	1.8904e-002	4.6289e-002	6.e-003	3.1498e-014
1582	1.798e-002	4.6655e-002	6.e-003	-6.5589e-014
1583	1.7049e-002	4.7003e-002	6.e-003	-1.3073e-013
1584	1.6111e-002	4.7333e-002	6.e-003	-2.2338e-013
1585	1.5167e-002	4.7644e-002	6.e-003	-2.9268e-013
1586	1.4217e-002	4.7936e-002	6.e-003	-3.7451e-013
1587	1.3261e-002	4.8209e-002	6.e-003	-4.2787e-013
1588	1.23e-002	4.8464e-002	6.e-003	-4.9417e-013
1589	1.1334e-002	4.8699e-002	6.e-003	-5.3196e-013
1590	1.0363e-002	4.8914e-002	6.e-003	-6.0375e-013
1591	9.3886e-003	4.9111e-002	6.e-003	-6.5802e-013
1592	8.4103e-003	4.9288e-002	6.e-003	-7.3058e-013
1593	7.4288e-003	4.9445e-002	6.e-003	-7.9899e-013
1594	6.4442e-003	4.9583e-002	6.e-003	-8.9136e-013
1595	5.4571e-003	4.9701e-002	6.e-003	-9.5812e-013
1596	4.4678e-003	4.98e-002	6.e-003	-1.0751e-012
1597	3.4769e-003	4.9879e-002	6.e-003	-1.2064e-012
1598	2.4844e-003	4.9938e-002	6.e-003	-1.3666e-012
1599	1.4911e-003	4.9978e-002	6.e-003	-1.5381e-012
1600	4.9707e-004	4.9998e-002	6.e-003	-1.7071e-012
1601	-4.9703e-004	4.9998e-002	6.e-003	-1.948e-012
1602	-1.4911e-003	4.9978e-002	6.e-003	-2.2104e-012
1603	-2.4844e-003	4.9938e-002	6.e-003	-2.4569e-012
1604	-3.4768e-003	4.9879e-002	6.e-003	-2.7681e-012
1605	-4.4678e-003	4.98e-002	6.e-003	-3.0653e-012
1606	-5.4571e-003	4.9701e-002	6.e-003	-3.3175e-012
1607	-6.4441e-003	4.9583e-002	6.e-003	-3.5855e-012
1608	-7.4287e-003	4.9445e-002	6.e-003	-3.808e-012
1609	-8.4103e-003	4.9288e-002	6.e-003	-3.9327e-012
1610	-9.3886e-003	4.9111e-002	6.e-003	-3.9783e-012
1611	-1.0363e-002	4.8914e-002	6.e-003	-3.9097e-012
1612	-1.1334e-002	4.8699e-002	6.e-003	-3.706e-012
1613	-1.23e-002	4.8464e-002	6.e-003	-3.3959e-012
1614	-1.3261e-002	4.8209e-002	6.e-003	-2.9387e-012
1615	-1.4217e-002	4.7936e-002	6.e-003	-2.3754e-012
1616	-1.5167e-002	4.7644e-002	6.e-003	-1.6823e-012
1617	-1.6111e-002	4.7333e-002	6.e-003	-8.7836e-013
1618	-1.7049e-002	4.7003e-002	6.e-003	8.3526e-014
1619	-1.798e-002	4.6655e-002	6.e-003	1.1855e-012
1620	-1.8904e-002	4.6289e-002	6.e-003	2.5158e-012
1621	-1.9821e-002	4.5904e-002	6.e-003	4.1653e-012
1622	-2.073e-002	4.55e-002	6.e-003	6.0113e-012
1623	-2.163e-002	4.5079e-002	6.e-003	9.1344e-012
1624	-2.2522e-002	4.464e-002	6.e-003	7.8139e-012
1625	-2.3405e-002	4.4184e-002	6.e-003	2.6108e-011
1626	-2.4279e-002	4.371e-002	6.e-003	-1.5512e-011
1627	-2.5143e-002	4.3218e-002	6.e-003	3.7762e-011
1628	-2.5998e-002	4.271e-002	6.e-003	9.9396e-011
1629	-2.6838e-002	4.2187e-002	5.9919e-003	-3.7703e-011
1630	-2.767e-002	4.1646e-002	5.9815e-003	-4.2506e-012
1631	-2.8495e-002	4.1086e-002	5.9722e-003	1.6811e-010
1632	-2.931e-002	4.0508e-002	5.9785e-003	8.3374e-011
1633	-3.0108e-002	3.9919e-002	6.e-003	-4.9849e-011
1634	-3.0896e-002	3.9312e-002	6.e-003	1.0737e-010
1635	-3.0896e-002	3.9312e-002	7.e-003	1.1463e-010
1636	-3.0878e-002	3.9326e-002	8.0003e-003	-1.5484e-010
1637	-3.0857e-002	3.9342e-002	9.0016e-003	-4.0866e-010
1638	-3.0853e-002	3.9345e-002	9.9957e-003	-3.2904e-011
1639	-3.0845e-002	3.9352e-002	1.0989e-002	2.0316e-010
1640	-3.0855e-002	3.9344e-002	1.1989e-002	-2.6269e-011
1641	-3.0862e-002	3.9339e-002	1.2989e-002	5.0216e-011
1642	-3.0868e-002	3.9334e-002	1.3993e-002	1.1602e-011
1643	-3.0874e-002	3.9329e-002	1.4994e-002	-2.9359e-011
1644	-3.088e-002	3.9324e-002	1.5993e-002	-4.1135e-011
1645	-3.0887e-002	3.9319e-002	1.6994e-002	6.8023e-011
1646	-3.0892e-002	3.9315e-002	1.7991e-002	3.3774e-010
1647	-3.09e-002	3.9309e-002	1.899e-002	1.6198e-010
1648	-3.0903e-002	3.9307e-002	1.9993e-002	-1.1675e-010
1649	-3.091e-002	3.9301e-002	2.0996e-002	-3.0997e-010
1650	-3.0909e-002	3.9302e-002	2.2002e-002	-1.9005e-010
1651	-3.0909e-002	3.9302e-002	2.3006e-002	-2.4956e-011
1652	-3.0902e-002	3.9307e-002	2.4007e-002	-5.7462e-011
1653	-3.0897e-002	3.9311e-002	2.5e-002	5.665e-011
1654	-3.0887e-002	3.9319e-002	2.6002e-002	1.9511e-010
1655	-3.0885e-002	3.932e-002	2.7001e-002	2.2032e-010
1656	-3.0885e-002	3.932e-002	2.7999e-002	2.6573e-012
1657	-3.0885e-002	3.932e-002	2.9e-002	-1.1276e-010
1658	-3.0885e-002	3.9321e-002	2.9999e-002	1.0305e-010
1659	-3.0884e-002	3.9322e-002	3.1e-002	1.9824e-010
1660	-3.0883e-002	3.9322e-002	3.1999e-002	-1.8365e-010
1661	-3.0889e-002	3.9318e-002	3.3e-002	-3.7283e-010
1662	-3.0886e-002	3.932e-002	3.4e-002	8.4444e-011
1663	-3.0884e-002	3.9322e-002	3.5e-002	3.1499e-010
1664	-3.0882e-002	3.9323e-002	3.6e-002	1.3226e-011
1665	-3.0879e-002	3.9325e-002	3.7e-002	-1.5569e-010
1666	-3.0877e-002	3.9327e-002	3.8e-002	-5.8266e-011
1667	-3.0875e-002	3.9329e-002	3.9e-002	-1.3704e-010
1668	-3.0879e-002	3.9325e-002	4.0995e-002	3.6271e-010
1669	-3.0887e-002	3.9319e-002	4.1995e-002	8.2868e-011
1670	-3.0899e-002	3.931e-002	4.3e-002	-3.0265e-010
1671	-3.0899e-002	3.931e-002	4.4e-002	-1.8504e-010
1672	-3.0108e-002	3.9919e-002	4.4e-002	2.3079e-010
1673	-2.9309e-002	4.0509e-002	4.4e-002	-9.8468e-011
1674	-2.8498e-002	4.1084e-002	4.4e-002	6.0587e-011
1675	-2.7675e-002	4.1642e-002	4.4e-002	-1.112e-011
1676	-2.6842e-002	4.2184e-002	4.4e-002	-4.3676e-011
1677	-2.5998e-002	4.271e-002	4.4e-002	-8.8731e-012
1678	-2.5143e-002	4.3218e-002	4.4e-002	-1.8217e-013
1679	-2.4279e-002	4.371e-002	4.4e-002	3.9472e-012
1680	-2.3405e-002	4.4184e-002	4.4e-002	6.9993e-012
1681	-2.2522e-002	4.464e-002	4.4e-002	7.4538e-012
1682	-2.163e-002	4.5079e-002	4.4e-002	7.4196e-012
1683	-2.073e-002	4.55e-002	4.4e-002	6.2672e-012
1684	-1.9821e-002	4.5904e-002	4.4e-002	5.2602e-012
1685	-1.8904e-002	4.6289e-002	4.4e-002	3.9193e-012
1686	-1.798e-002	4.6655e-002	4.4e-002	3.0679e-012
1687	-1.7049e-002	4.7003e-002	4.4e-002	2.1618e-012
1688	-1.6111e-002	4.7333e-002	4.4e-002	1.7917e-012
1689	-1.5167e-002	4.7644e-002	4.4e-002	1.3822e-012
1690	-1.4217e-002	4.7936e-002	4.4e-002	1.4388e-012
1691	-1.3261e-002	4.8209e-002	4.4e-002	1.3841e-012
1692	-1.23e-002	4.8464e-002	4.4e-002	1.629e-012
1693	-1.1334e-002	4.8699e-002	4.4e-002	1.7296e-012
1694	-1.0363e-002	4.8914e-002	4.4e-002	2.0226e-012
1695	-9.3886e-003	4.9111e-002	4.4e-002	2.135e-012
1696	-8.4103e-003	4.9288e-002	4.4e-002	2.3255e-012
1697	-7.4288e-003	4.9445e-002	4.4e-002	2.3813e-012
1698	-6.4442e-003	4.9583e-002	4.4e-002	2.5109e-012
1699	-5.4571e-003	4.9701e-002	4.4e-002	2.5112e-012
1700	-4.4678e-003	4.98e-002	4.4e-002	2.5358e-012
1701	-3.4769e-003	4.9879e-002	4.4e-002	2.5193e-012
1702	-2.4844e-003	4.9938e-002	4.4e-002	2.4874e-012
1703	-1.4911e-003	4.9978e-002	4.4e-002	2.4426e-012
1704	-4.9707e-004	4.9998e-002	4.4e-002	2.3568e-012
1705	4.9703e-004	4.9998e-002	4.4e-002	2.2954e-012
1706	1.4911e-003	4.9978e-002	4.4e-002	2.1778e-012
1707	2.4844e-003	4.9938e-002	4.4e-002	2.1181e-012
1708	3.4768e-003	4.9879e-002	4.4e-002	1.9342e-012
1709	4.4678e-003	4.98e-002	4.4e-002	1.891e-012
1710	5.4571e-003	4.9701e-002	4.4e-002	1.6764e-012
1711	6.4441e-003	4.9583e-002	4.4e-002	1.6083e-012
1712	7.4287e-003	4.9445e-002	4.4e-002	1.3834e-012
1713	8.4103e-003	4.9288e-002	4.4e-002	1.3288e-012
1714	9.3886e-003	4.9111e-002	4.4e-002	1.0732e-012
1715	1.0363e-002	4.8914e-002	4.4e-002	1.0982e-012
1716	1.1334e-002	4.8699e-002	4.4e-002	8.2339e-013
1717	1.23e-002	4.8464e-002	4.4e-002	8.2767e-013
1718	1.3261e-002	4.8209e-002	4.4e-002	5.7345e-013
1719	1.4217e-002	4.7936e-002	4.4e-002	6.4036e-013
1720	1.5167e-002	4.7644e-002	4.4e-002	3.7944e-013
1721	1.6111e-002	4.7333e-002	4.4e-002	4.9511e-013
1722	1.7049e-002	4.7003e-002	4.4e-002	2.352e-013
1723	1.798e-002	4.6655e-002	4.4e-002	3.9658e-013
1724	1.8904e-002	4.6289e-002	4.4e-002	1.794e-013
1725	1.9821e-002	4.5904e-002	4.4e-002	4.1292e-013
1726	2.073e-002	4.55e-002	4.4e-002	2.149e-013
1727	2.163e-002	4.5079e-002	4.4e-002	5.1525e-013
1728	2.2522e-002	4.464e-002	4.4e-002	3.3063e-013
1729	2.3405e-002	4.4184e-002	4.4e-002	6.7686e-013
1730	2.4279e-002	4.371e-002	4.4e-002	4.7339e-013
1731	2.5143e-002	4.3218e-002	4.4e-002	8.4789e-013
1732	2.5998e-002	4.271e-002	4.4e-002	4.8156e-013
1733	2.6842e-002	4.2184e-002	4.4e-002	2.5029e-013
1734	2.7675e-002	4.1642e-002	4.4e-002	2.2292e-012
1735	2.8497e-002	4.1084e-002	4.4e-002	-1.1593e-012
1736	2.9309e-002	4.0509e-002	4.4e-002	-1.4834e-012
1737	3.0108e-002	3.9918e-002	4.4e-002	-1.3442e-012
1738	3.0108e-002	3.9918e-002	7.0001e-003	4.8312e-011
1739	2.9309e-002	4.0509e-002	7.e-003	2.179e-012
1740	2.8498e-002	4.1084e-002	7.e-003	-8.788e-012
1741	2.7675e-002	4.1642e-002	7.e-003	-5.5987e-011
1742	2.6842e-002	4.2184e-002	7.e-003	2.6389e-011
1743	2.5998e-002	4.271e-002	7.e-003	-7.5435e-013
1744	2.5143e-002	4.3218e-002	7.e-003	-5.0224e-012
1745	2.4279e-002	4.371e-002	7.e-003	-4.6083e-013
1746	2.3405e-002	4.4184e-002	7.e-003	-5.8902e-013
1747	2.2522e-002	4.464e-002	7.e-003	-7.4411e-014
1748	2.163e-002	4.5079e-002	7.e-003	-1.1278e-013
1749	2.073e-002	4.55e-002	7.e-003	6.1955e-015
1750	1.9821e-002	4.5904e-002	7.e-003	-2.0211e-013
1751	1.8904e-002	4.6288e-002	7.e-003	-1.6195e-013
1752	1.798e-002	4.6655e-002	7.e-003	-3.4028e-013
1753	1.7049e-002	4.7003e-002	7.e-003	-2.9812e-013
1754	1.6111e-002	4.7333e-002	7.e-003	-4.5296e-013
1755	1.5167e-002	4.7644e-002	7.e-003	-4.397e-013
1756	1.4217e-002	4.7936e-002	7.e-003	-5.7712e-013
1757	1.3261e-002	4.8209e-002	7.e-003	-5.5574e-013
1758	1.23e-002	4.8464e-002	7.e-003	-6.9589e-013
1759	1.1334e-002	4.8699e-002	7.e-003	-6.8559e-013
1760	1.0363e-002	4.8914e-002	7.e-003	-8.0284e-013
1761	9.3887e-003	4.9111e-002	7.e-003	-7.9176e-013
1762	8.4103e-003	4.9288e-002	7.e-003	-9.4541e-013
1763	7.4288e-003	4.9445e-002	7.e-003	-9.7867e-013
1764	6.4442e-003	4.9583e-002	7.e-003	-1.1052e-012
1765	5.4571e-003	4.9701e-002	7.e-003	-1.1742e-012
1766	4.4678e-003	4.98e-002	7.e-003	-1.376e-012
1767	3.4769e-003	4.9879e-002	7.e-003	-1.4541e-012
1768	2.4844e-003	4.9938e-002	7.e-003	-1.661e-012
1769	1.4911e-003	4.9978e-002	7.e-003	-1.844e-012
1770	4.9709e-004	4.9998e-002	7.e-003	-2.0955e-012
1771	-4.9702e-004	4.9998e-002	7.e-003	-2.307e-012
1772	-1.491e-003	4.9978e-002	7.e-003	-2.6643e-012
1773	-2.4844e-003	4.9938e-002	7.e-003	-2.9609e-012
1774	-3.4768e-003	4.9879e-002	7.e-003	-3.3227e-012
1775	-4.4678e-003	4.98e-002	7.e-003	-3.65e-012
1776	-5.4571e-003	4.9701e-002	7.e-003	-3.9874e-012
1777	-6.4441e-003	4.9583e-002	7.e-003	-4.2936e-012
1778	-7.4287e-003	4.9445e-002	7.e-003	-4.5532e-012
1779	-8.4103e-003	4.9288e-002	7.e-003	-4.6715e-012
1780	-9.3886e-003	4.9111e-002	7.e-003	-4.6944e-012
1781	-1.0363e-002	4.8914e-002	7.e-003	-4.554e-012
1782	-1.1334e-002	4.8699e-002	7.e-003	-4.23e-012
1783	-1.23e-002	4.8464e-002	7.e-003	-3.6986e-012
1784	-1.3261e-002	4.8209e-002	7.e-003	-2.9887e-012
1785	-1.4217e-002	4.7936e-002	7.e-003	-2.0715e-012
1786	-1.5167e-002	4.7644e-002	7.e-003	-9.0736e-013
1787	-1.6111e-002	4.7333e-002	7.e-003	4.3292e-013
1788	-1.7049e-002	4.7003e-002	7.e-003	2.0472e-012
1789	-1.798e-002	4.6655e-002	7.e-003	3.8469e-012
1790	-1.8904e-002	4.6289e-002	7.e-003	5.9584e-012
1791	-1.9821e-002	4.5904e-002	7.e-003	8.303e-012
1792	-2.073e-002	4.55e-002	7.e-003	1.1224e-011
1793	-2.163e-002	4.5079e-002	7.e-003	1.3333e-011
1794	-2.2522e-002	4.464e-002	7.e-003	1.9222e-011
1795	-2.3405e-002	4.4184e-002	7.e-003	-3.9637e-013
1796	-2.4279e-002	4.371e-002	7.e-003	6.5836e-011
1797	-2.5143e-002	4.3218e-002	7.e-003	2.7464e-011
1798	-2.5992e-002	4.2713e-002	6.9929e-003	-1.4877e-011
1799	-2.6833e-002	4.219e-002	6.9778e-003	7.2139e-011
1800	-2.7665e-002	4.1649e-002	6.969e-003	6.2093e-012
1801	-2.8487e-002	4.1091e-002	6.9664e-003	1.3408e-010
1802	-2.9301e-002	4.0515e-002	6.9722e-003	-2.6293e-011
1803	-3.0104e-002	3.9922e-002	6.9927e-003	1.646e-010
1804	-3.0084e-002	3.9937e-002	7.9964e-003	-2.8286e-012
1805	-3.0065e-002	3.9951e-002	8.9889e-003	2.2817e-011
1806	-3.0047e-002	3.9965e-002	9.9867e-003	7.4646e-011
1807	-3.0043e-002	3.9968e-002	1.0988e-002	-2.7766e-010
1808	-3.0049e-002	3.9964e-002	1.1992e-002	-1.2027e-011
1809	-3.0054e-002	3.996e-002	1.2994e-002	9.4055e-011
1810	-3.0062e-002	3.9954e-002	1.3998e-002	-1.1657e-010
1811	-3.0068e-002	3.9949e-002	1.4995e-002	-1.6907e-010
1812	-3.008e-002	3.994e-002	1.5994e-002	4.1248e-011
1813	-3.0088e-002	3.9934e-002	1.6988e-002	2.503e-010
1814	-3.01e-002	3.9925e-002	1.7985e-002	1.4796e-010
1815	-3.0116e-002	3.9913e-002	1.8986e-002	8.1075e-011
1816	-3.0134e-002	3.9899e-002	1.9987e-002	-1.6428e-010
1817	-3.0148e-002	3.9889e-002	2.0995e-002	-2.2246e-010
1818	-3.015e-002	3.9887e-002	2.2008e-002	1.6454e-011
1819	-3.0137e-002	3.9897e-002	2.3015e-002	2.0599e-010
1820	-3.0126e-002	3.9905e-002	2.4016e-002	1.6555e-010
1821	-3.0108e-002	3.9919e-002	2.5012e-002	-2.2533e-013
1822	-3.0097e-002	3.9927e-002	2.6005e-002	-1.4686e-010
1823	-3.0086e-002	3.9935e-002	2.6998e-002	-5.396e-011
1824	-3.0087e-002	3.9935e-002	2.7998e-002	1.277e-010
1825	-3.0088e-002	3.9933e-002	2.8996e-002	1.0829e-011
1826	-3.0086e-002	3.9935e-002	3.e-002	-1.1252e-011
1827	-3.0083e-002	3.9937e-002	3.0997e-002	-1.377e-010
1828	-3.0091e-002	3.9932e-002	3.1997e-002	-1.2006e-010
1829	-3.0092e-002	3.9931e-002	3.2997e-002	1.7564e-010
1830	-3.0089e-002	3.9933e-002	3.3998e-002	1.0491e-010
1831	-3.0085e-002	3.9936e-002	3.4998e-002	-1.278e-010
1832	-3.009e-002	3.9932e-002	3.5997e-002	-7.7028e-011
1833	-3.0082e-002	3.9938e-002	3.6996e-002	1.7997e-010
1834	-3.0083e-002	3.9938e-002	3.7996e-002	-1.0572e-010
1835	-3.0083e-002	3.9937e-002	3.8995e-002	-4.4189e-011
1836	-3.0085e-002	3.9936e-002	3.9994e-002	2.8509e-010
1837	-3.0091e-002	3.9932e-002	4.0993e-002	-4.1064e-010
1838	-3.01e-002	3.9925e-002	4.1998e-002	-3.5916e-010
1839	-3.0108e-002	3.9919e-002	4.3e-002	3.6399e-010
1840	-2.9309e-002	4.0509e-002	4.3e-002	-1.1986e-010
1841	-2.8498e-002	4.1084e-002	4.3e-002	5.994e-011
1842	-2.6842e-002	4.2184e-002	4.3e-002	-7.8866e-011
1843	-2.5998e-002	4.271e-002	4.3e-002	7.8894e-012
1844	-2.5143e-002	4.3218e-002	4.3e-002	-1.9614e-012
1845	-2.4279e-002	4.371e-002	4.3e-002	6.4332e-012
1846	-2.3405e-002	4.4184e-002	4.3e-002	7.3254e-012
1847	-2.2522e-002	4.464e-002	4.3e-002	7.9154e-012
1848	-2.163e-002	4.5079e-002	4.3e-002	6.9411e-012
1849	-2.073e-002	4.55e-002	4.3e-002	5.7628e-012
1850	-1.9821e-002	4.5904e-002	4.3e-002	4.3307e-012
1851	-1.8904e-002	4.6288e-002	4.3e-002	3.1795e-012
1852	-1.798e-002	4.6655e-002	4.3e-002	2.1679e-012
1853	-1.7049e-002	4.7003e-002	4.3e-002	1.5825e-012
1854	-1.6111e-002	4.7333e-002	4.3e-002	1.1761e-012
1855	-1.5167e-002	4.7644e-002	4.3e-002	1.1567e-012
1856	-1.4217e-002	4.7936e-002	4.3e-002	1.1979e-012
1857	-1.3261e-002	4.8209e-002	4.3e-002	1.5037e-012
1858	-1.23e-002	4.8464e-002	4.3e-002	1.7587e-012
1859	-1.1334e-002	4.8699e-002	4.3e-002	2.1279e-012
1860	-1.0363e-002	4.8914e-002	4.3e-002	2.399e-012
1861	-9.3887e-003	4.9111e-002	4.3e-002	2.6953e-012
1862	-8.4103e-003	4.9288e-002	4.3e-002	2.8513e-012
1863	-7.4288e-003	4.9445e-002	4.3e-002	3.0518e-012
1864	-6.4442e-003	4.9583e-002	4.3e-002	3.1139e-012
1865	-5.4571e-003	4.9701e-002	4.3e-002	3.1846e-012
1866	-4.4678e-003	4.98e-002	4.3e-002	3.1535e-012
1867	-3.4769e-003	4.9879e-002	4.3e-002	3.1925e-012
1868	-2.4844e-003	4.9938e-002	4.3e-002	3.1575e-012
1869	-1.4911e-003	4.9978e-002	4.3e-002	3.0955e-012
1870	-4.971e-004	4.9998e-002	4.3e-002	2.9742e-012
1871	4.9702e-004	4.9998e-002	4.3e-002	2.9155e-012
1872	1.491e-003	4.9978e-002	4.3e-002	2.7986e-012
1873	2.4844e-003	4.9938e-002	4.3e-002	2.6745e-012
1874	3.4768e-003	4.9879e-002	4.3e-002	2.5057e-012
1875	4.4678e-003	4.98e-002	4.3e-002	2.3357e-012
1876	5.457e-003	4.9701e-002	4.3e-002	2.1823e-012
1877	6.4441e-003	4.9583e-002	4.3e-002	1.9932e-012
1878	7.4287e-003	4.9445e-002	4.3e-002	1.8075e-012
1879	8.4103e-003	4.9288e-002	4.3e-002	1.6372e-012
1880	9.3886e-003	4.9111e-002	4.3e-002	1.4599e-012
1881	1.0363e-002	4.8914e-002	4.3e-002	1.2692e-012
1882	1.1334e-002	4.8699e-002	4.3e-002	1.1166e-012
1883	1.23e-002	4.8464e-002	4.3e-002	9.724e-013
1884	1.3261e-002	4.8209e-002	4.3e-002	8.3439e-013
1885	1.4217e-002	4.7936e-002	4.3e-002	6.6716e-013
1886	1.5167e-002	4.7644e-002	4.3e-002	5.9767e-013
1887	1.6111e-002	4.7333e-002	4.3e-002	4.7695e-013
1888	1.7049e-002	4.7003e-002	4.3e-002	4.1086e-013
1889	1.798e-002	4.6655e-002	4.3e-002	3.1868e-013
1890	1.8904e-002	4.6289e-002	4.3e-002	3.381e-013
1891	1.9821e-002	4.5904e-002	4.3e-002	2.9775e-013
1892	2.073e-002	4.55e-002	4.3e-002	3.6512e-013
1893	2.163e-002	4.5079e-002	4.3e-002	3.5316e-013
1894	2.2522e-002	4.464e-002	4.3e-002	5.6032e-013
1895	2.3405e-002	4.4184e-002	4.3e-002	3.9418e-013
1896	2.4279e-002	4.371e-002	4.3e-002	7.036e-013
1897	2.5143e-002	4.3218e-002	4.3e-002	4.35e-013
1898	2.5998e-002	4.271e-002	4.3e-002	1.0889e-012
1899	2.6842e-002	4.2184e-002	4.3e-002	-7.05e-013
1900	2.7675e-002	4.1642e-002	4.3e-002	4.9533e-013
1901	2.8497e-002	4.1084e-002	4.3e-002	3.8021e-013
1902	2.9309e-002	4.0509e-002	4.3e-002	-3.1416e-012
1903	3.0108e-002	3.9918e-002	4.3e-002	-5.1462e-012
1904	3.0108e-002	3.9918e-002	4.2e-002	-4.8858e-012
1905	3.0108e-002	3.9918e-002	4.1e-002	-4.7594e-012
1906	3.0108e-002	3.9918e-002	4.e-002	-5.669e-012
1907	3.0109e-002	3.9918e-002	3.9e-002	-4.8495e-012
1908	3.0109e-002	3.9918e-002	3.8e-002	-2.8965e-012
1909	3.0109e-002	3.9918e-002	3.7e-002	-3.1764e-012
1910	3.0109e-002	3.9918e-002	3.6e-002	-3.7633e-012
1911	3.0109e-002	3.9918e-002	3.5e-002	-3.1851e-012
1912	3.0109e-002	3.9918e-002	3.4e-002	-2.6214e-012
1913	3.0109e-002	3.9918e-002	3.3e-002	-2.3989e-012
1914	3.0109e-002	3.9918e-002	3.2e-002	-2.8735e-012
1915	3.0109e-002	3.9918e-002	3.1e-002	-2.6827e-012
1916	3.0109e-002	3.9918e-002	3.e-002	-2.1489e-012
1917	3.0109e-002	3.9918e-002	2.9e-002	-2.1707e-012
1918	3.0109e-002	3.9918e-002	2.8e-002	-2.1678e-012
1919	3.0109e-002	3.9918e-002	2.7e-002	-2.1483e-012
1920	3.0109e-002	3.9918e-002	2.6e-002	-2.1813e-012
1921	3.0109e-002	3.9918e-002	2.5e-002	-2.2458e-012
1922	3.0109e-002	3.9918e-002	2.4e-002	-2.3168e-012
1923	3.0109e-002	3.9918e-002	2.3e-002	-2.3323e-012
1924	3.0109e-002	3.9918e-002	2.2e-002	-2.376e-012
1925	3.0109e-002	3.9918e-002	2.1e-002	-2.4627e-012
1926	3.0109e-002	3.9918e-002	2.e-002	-2.5545e-012
1927	3.0109e-002	3.9918e-002	1.9e-002	-2.6047e-012
1928	3.0109e-002	3.9918e-002	1.8e-002	-2.6504e-012
1929	3.0109e-002	3.9918e-002	1.7e-002	-2.7438e-012
1930	3.0109e-002	3.9918e-002	1.6e-002	-2.7865e-012
1931	3.0109e-002	3.9918e-002	1.5e-002	-3.0725e-012
1932	3.0109e-002	3.9918e-002	1.4e-002	-2.9476e-012
1933	3.0109e-002	3.9918e-002	1.3e-002	-2.082e-012
1934	3.0109e-002	3.9918e-002	1.2e-002	-9.8978e-012
1935	3.0109e-002	3.9918e-002	1.1e-002	-4.5885e-012
1936	3.0109e-002	3.9918e-002	1.e-002	3.6177e-011
1937	3.0109e-002	3.9918e-002	9.e-003	-3.0269e-013
1938	3.0109e-002	3.9918e-002	8.e-003	-6.2739e-011
1939	-2.9301e-002	4.0515e-002	4.1998e-002	2.7739e-010
1940	-2.8493e-002	4.1087e-002	4.2002e-002	-1.0182e-010
1941	-2.7675e-002	4.1642e-002	4.2e-002	-3.4105e-011
1942	-2.6842e-002	4.2184e-002	4.2e-002	1.4211e-011
1943	-2.5998e-002	4.271e-002	4.2e-002	-1.0756e-011
1944	-2.5143e-002	4.3218e-002	4.2e-002	4.3188e-012
1945	-2.4279e-002	4.371e-002	4.2e-002	4.5374e-012
1946	-2.3405e-002	4.4184e-002	4.2e-002	7.3055e-012
1947	-2.2522e-002	4.464e-002	4.2e-002	6.5539e-012
1948	-2.163e-002	4.5079e-002	4.2e-002	5.1634e-012
1949	-2.073e-002	4.55e-002	4.2e-002	4.0193e-012
1950	-1.9821e-002	4.5904e-002	4.2e-002	2.3955e-012
1951	-1.8904e-002	4.6288e-002	4.2e-002	1.5981e-012
1952	-1.798e-002	4.6655e-002	4.2e-002	6.2199e-013
1953	-1.7049e-002	4.7003e-002	4.2e-002	4.9931e-013
1954	-1.6111e-002	4.7333e-002	4.2e-002	2.2043e-013
1955	-1.5167e-002	4.7644e-002	4.2e-002	6.5225e-013
1956	-1.4217e-002	4.7936e-002	4.2e-002	8.2636e-013
1957	-1.3261e-002	4.8209e-002	4.2e-002	1.5063e-012
1958	-1.23e-002	4.8464e-002	4.2e-002	1.8684e-012
1959	-1.1334e-002	4.8699e-002	4.2e-002	2.512e-012
1960	-1.0363e-002	4.8914e-002	4.2e-002	2.7788e-012
1961	-9.3887e-003	4.9111e-002	4.2e-002	3.2632e-012
1962	-8.4103e-003	4.9288e-002	4.2e-002	3.4113e-012
1963	-7.4288e-003	4.9445e-002	4.2e-002	3.7013e-012
1964	-6.4442e-003	4.9583e-002	4.2e-002	3.7262e-012
1965	-5.4571e-003	4.9701e-002	4.2e-002	3.8554e-012
1966	-4.4678e-003	4.98e-002	4.2e-002	3.8405e-012
1967	-3.4769e-003	4.9879e-002	4.2e-002	3.8819e-012
1968	-2.4844e-003	4.9938e-002	4.2e-002	3.7982e-012
1969	-1.4911e-003	4.9978e-002	4.2e-002	3.7561e-012
1970	-4.9708e-004	4.9998e-002	4.2e-002	3.6823e-012
1971	4.9702e-004	4.9998e-002	4.2e-002	3.5437e-012
1972	1.491e-003	4.9978e-002	4.2e-002	3.4358e-012
1973	2.4844e-003	4.9938e-002	4.2e-002	3.2278e-012
1974	3.4768e-003	4.9879e-002	4.2e-002	3.0993e-012
1975	4.4678e-003	4.98e-002	4.2e-002	2.8197e-012
1976	5.4571e-003	4.9701e-002	4.2e-002	2.7042e-012
1977	6.4441e-003	4.9583e-002	4.2e-002	2.3757e-012
1978	7.4287e-003	4.9445e-002	4.2e-002	2.2592e-012
1979	8.4103e-003	4.9288e-002	4.2e-002	1.9205e-012
1980	9.3886e-003	4.9111e-002	4.2e-002	1.8498e-012
1981	1.0363e-002	4.8914e-002	4.2e-002	1.4554e-012
1982	1.1334e-002	4.8699e-002	4.2e-002	1.4447e-012
1983	1.23e-002	4.8464e-002	4.2e-002	1.0761e-012
1984	1.3261e-002	4.8209e-002	4.2e-002	1.0927e-012
1985	1.4217e-002	4.7936e-002	4.2e-002	7.118e-013
1986	1.5167e-002	4.7644e-002	4.2e-002	8.0725e-013
1987	1.6111e-002	4.7333e-002	4.2e-002	4.293e-013
1988	1.7049e-002	4.7003e-002	4.2e-002	5.8336e-013
1989	1.798e-002	4.6655e-002	4.2e-002	2.3422e-013
1990	1.8904e-002	4.6289e-002	4.2e-002	4.7103e-013
1991	1.9821e-002	4.5904e-002	4.2e-002	1.4212e-013
1992	2.073e-002	4.55e-002	4.2e-002	4.6549e-013
1993	2.163e-002	4.5079e-002	4.2e-002	1.7206e-013
1994	2.2522e-002	4.464e-002	4.2e-002	6.1326e-013
1995	2.3405e-002	4.4184e-002	4.2e-002	2.7105e-013
1996	2.4279e-002	4.371e-002	4.2e-002	5.6967e-013
1997	2.5143e-002	4.3218e-002	4.2e-002	3.514e-013
1998	2.5998e-002	4.271e-002	4.2e-002	8.0224e-013
1999	2.6842e-002	4.2184e-002	4.2e-002	3.9411e-013
2000	2.7675e-002	4.1642e-002	4.2e-002	-3.4969e-012
2001	2.8497e-002	4.1084e-002	4.2e-002	2.3949e-012
2002	2.9309e-002	4.0509e-002	4.2e-002	-2.9587e-012
2003	2.9309e-002	4.0509e-002	4.1e-002	-6.1943e-014
2004	2.9309e-002	4.0509e-002	4.e-002	1.9607e-012
2005	2.9309e-002	4.0509e-002	3.9e-002	1.6735e-012
2006	2.9309e-002	4.0509e-002	3.8e-002	-7.5194e-013
2007	2.9309e-002	4.0509e-002	3.7e-002	-1.4592e-012
2008	2.9309e-002	4.0509e-002	3.6e-002	-1.3783e-012
2009	2.9309e-002	4.0509e-002	3.5e-002	-2.3725e-012
2010	2.9309e-002	4.0509e-002	3.4e-002	-2.5729e-012
2011	2.9309e-002	4.0509e-002	3.3e-002	-2.1414e-012
2012	2.9309e-002	4.0509e-002	3.2e-002	-1.1875e-012
2013	2.9309e-002	4.0509e-002	3.e-002	-2.0729e-012
2014	2.9309e-002	4.0509e-002	2.8e-002	-2.0542e-012
2015	2.9309e-002	4.0509e-002	2.6e-002	-2.1418e-012
2016	2.9309e-002	4.0509e-002	2.4e-002	-2.2471e-012
2017	2.9309e-002	4.0509e-002	2.2e-002	-2.3405e-012
2018	2.9309e-002	4.0509e-002	2.e-002	-2.483e-012
2019	2.9309e-002	4.0509e-002	1.8e-002	-2.6036e-012
2020	2.9309e-002	4.0509e-002	1.6e-002	-2.766e-012
2021	2.9309e-002	4.0509e-002	1.4e-002	-2.7918e-012
2022	2.9309e-002	4.0509e-002	1.3e-002	-2.7963e-012
2023	2.931e-002	4.0509e-002	1.2e-002	3.3804e-012
2024	2.931e-002	4.0509e-002	1.1e-002	-4.602e-011
2025	2.931e-002	4.0509e-002	9.9999e-003	-1.0907e-010
2026	2.931e-002	4.0509e-002	8.9999e-003	4.9972e-012
2027	2.931e-002	4.0508e-002	7.9999e-003	1.1764e-010
2028	2.8498e-002	4.1084e-002	8.e-003	-7.8431e-011
2029	2.7675e-002	4.1642e-002	8.e-003	-5.8838e-011
2030	2.5998e-002	4.271e-002	8.e-003	-4.4833e-011
2031	2.4279e-002	4.371e-002	8.e-003	-3.2284e-012
2032	2.2522e-002	4.464e-002	8.e-003	-6.0076e-013
2033	2.073e-002	4.55e-002	8.e-003	-5.0129e-013
2034	1.8904e-002	4.6289e-002	8.e-003	-6.1419e-013
2035	1.7049e-002	4.7003e-002	8.e-003	-5.9681e-013
2036	1.5167e-002	4.7644e-002	8.e-003	-6.8475e-013
2037	1.3261e-002	4.8209e-002	8.e-003	-7.6523e-013
2038	1.1334e-002	4.8699e-002	8.e-003	-8.8581e-013
2039	9.3886e-003	4.9111e-002	8.e-003	-1.0169e-012
2040	7.4287e-003	4.9445e-002	8.e-003	-1.1754e-012
2041	5.4571e-003	4.9701e-002	8.e-003	-1.4258e-012
2042	3.4768e-003	4.9879e-002	8.e-003	-1.7294e-012
2043	1.4911e-003	4.9978e-002	8.e-003	-2.1425e-012
2044	-4.9704e-004	4.9998e-002	8.e-003	-2.6981e-012
2045	-2.4844e-003	4.9938e-002	8.e-003	-3.4067e-012
2046	-4.4678e-003	4.98e-002	8.e-003	-4.1756e-012
2047	-6.4441e-003	4.9583e-002	8.e-003	-4.9543e-012
2048	-8.4103e-003	4.9288e-002	8.e-003	-5.3487e-012
2049	-1.0363e-002	4.8914e-002	8.e-003	-5.1385e-012
2050	-1.23e-002	4.8464e-002	8.e-003	-3.9703e-012
2051	-1.4217e-002	4.7936e-002	8.e-003	-1.6522e-012
2052	-1.6111e-002	4.7333e-002	8.e-003	1.9483e-012
2053	-1.798e-002	4.6655e-002	8.e-003	6.878e-012
2054	-1.9821e-002	4.5904e-002	8.e-003	1.3263e-011
2055	-2.163e-002	4.5079e-002	8.e-003	1.9767e-011
2056	-2.3405e-002	4.4184e-002	8.e-003	-6.353e-013
2057	-2.5143e-002	4.3218e-002	8.e-003	4.6152e-011
2058	-2.682e-002	4.2198e-002	7.9663e-003	2.3367e-011
2059	-2.7651e-002	4.1659e-002	7.954e-003	7.3559e-011
2060	-2.8472e-002	4.1102e-002	7.9551e-003	1.1506e-011
2061	-2.9282e-002	4.0528e-002	7.9677e-003	1.0938e-010
2062	-2.926e-002	4.0545e-002	8.9743e-003	2.2336e-010
2063	-2.8451e-002	4.1116e-002	8.9602e-003	-1.8791e-010
2064	-2.9244e-002	4.0556e-002	9.9807e-003	-1.4515e-010
2065	-2.9243e-002	4.0557e-002	1.0988e-002	-1.8436e-010
2066	-2.9244e-002	4.0556e-002	1.1995e-002	-1.9938e-010
2067	-2.9247e-002	4.0553e-002	1.3e-002	-1.3486e-010
2068	-2.925e-002	4.0551e-002	1.4003e-002	1.1927e-010
2069	-2.9259e-002	4.0545e-002	1.4999e-002	2.5648e-010
2070	-2.9271e-002	4.0537e-002	1.5995e-002	1.991e-010
2071	-2.9307e-002	4.0511e-002	1.7993e-002	-1.4507e-010
2072	-2.9354e-002	4.0476e-002	2.0001e-002	2.4431e-010
2073	-2.9378e-002	4.0459e-002	2.2018e-002	-2.221e-010
2074	-2.9337e-002	4.0489e-002	2.4025e-002	1.1196e-010
2075	-2.9298e-002	4.0517e-002	2.6007e-002	3.3474e-011
2076	-2.9283e-002	4.0528e-002	2.7997e-002	-7.4624e-011
2077	-2.9284e-002	4.0527e-002	2.9996e-002	-2.3898e-010
2078	-2.9284e-002	4.0527e-002	3.0996e-002	-8.3713e-011
2079	-2.9284e-002	4.0527e-002	3.1995e-002	2.8287e-010
2080	-2.9286e-002	4.0526e-002	3.2995e-002	2.043e-010
2081	-2.9288e-002	4.0525e-002	3.3995e-002	-1.436e-010
2082	-2.9287e-002	4.0525e-002	3.4995e-002	-6.2904e-011
2083	-2.9286e-002	4.0526e-002	3.5995e-002	1.9989e-010
2084	-2.9286e-002	4.0525e-002	3.6995e-002	-1.4081e-010
2085	-2.9288e-002	4.0525e-002	3.7995e-002	1.523e-011
2086	-2.9289e-002	4.0523e-002	3.8995e-002	1.1864e-010
2087	-2.9293e-002	4.0521e-002	3.9998e-002	-4.0332e-010
2088	-2.9297e-002	4.0518e-002	4.0999e-002	2.1856e-011
2089	2.8497e-002	4.1084e-002	4.1e-002	-5.2752e-013
2090	2.7675e-002	4.1642e-002	4.1e-002	-4.0619e-012
2091	2.8497e-002	4.1084e-002	4.e-002	-4.0523e-012
2092	2.8497e-002	4.1084e-002	3.9e-002	-4.4222e-012
2093	2.8498e-002	4.1084e-002	3.8e-002	-2.2808e-012
2094	2.8498e-002	4.1084e-002	3.7e-002	-2.3476e-012
2095	2.8498e-002	4.1084e-002	3.6e-002	-5.1754e-012
2096	2.8498e-002	4.1084e-002	3.5e-002	-4.0303e-012
2097	2.8498e-002	4.1084e-002	3.4e-002	-2.4678e-012
2098	2.8498e-002	4.1083e-002	3.3e-002	-3.1513e-012
2099	2.8498e-002	4.1083e-002	3.2e-002	-3.0203e-012
2100	2.8498e-002	4.1083e-002	3.1e-002	-2.3971e-012
2101	2.8499e-002	4.1083e-002	3.e-002	-2.3676e-012
2102	2.8499e-002	4.1083e-002	2.9e-002	-2.7643e-012
2103	2.8499e-002	4.1083e-002	2.8e-002	-2.66e-012
2104	2.8499e-002	4.1083e-002	2.7e-002	-2.7217e-012
2105	2.8499e-002	4.1083e-002	2.6e-002	-2.8536e-012
2106	2.8499e-002	4.1083e-002	2.5e-002	-2.8077e-012
2107	2.8499e-002	4.1083e-002	2.4e-002	-2.876e-012
2108	2.8499e-002	4.1083e-002	2.3e-002	-2.9523e-012
2109	2.85e-002	4.1083e-002	2.2e-002	-3.0126e-012
2110	2.85e-002	4.1082e-002	2.1e-002	-3.0265e-012
2111	2.85e-002	4.1082e-002	2.e-002	-3.0564e-012
2112	2.85e-002	4.1082e-002	1.9e-002	-3.1333e-012
2113	2.85e-002	4.1082e-002	1.8e-002	-3.1995e-012
2114	2.85e-002	4.1082e-002	1.7e-002	-3.3003e-012
2115	2.85e-002	4.1082e-002	1.6e-002	-3.4468e-012
2116	2.85e-002	4.1082e-002	1.5e-002	-3.8783e-012
2117	2.85e-002	4.1082e-002	1.4e-002	-2.779e-012
2118	2.8501e-002	4.1082e-002	1.3e-002	-3.0731e-012
2119	2.8501e-002	4.1082e-002	1.2e-002	-1.26e-014
2120	2.8501e-002	4.1082e-002	1.1e-002	7.0367e-011
2121	2.8501e-002	4.1082e-002	9.9998e-003	7.8491e-011
2122	2.8501e-002	4.1082e-002	8.9998e-003	-5.4832e-011
2123	2.7675e-002	4.1642e-002	9.e-003	4.3637e-011
2124	2.6842e-002	4.2184e-002	9.e-003	2.0365e-011
2125	2.5998e-002	4.271e-002	9.e-003	-3.2981e-011
2126	2.5143e-002	4.3218e-002	9.e-003	4.6051e-012
2127	2.4279e-002	4.371e-002	9.e-003	-3.9129e-012
2128	2.3405e-002	4.4184e-002	9.e-003	-1.067e-012
2129	2.2522e-002	4.464e-002	9.e-003	-1.466e-012
2130	2.163e-002	4.5079e-002	9.e-003	-1.1938e-012
2131	2.073e-002	4.55e-002	9.e-003	-1.1605e-012
2132	1.9821e-002	4.5904e-002	9.e-003	-8.7667e-013
2133	1.8904e-002	4.6288e-002	9.e-003	-1.1397e-012
2134	1.798e-002	4.6655e-002	9.e-003	-7.8254e-013
2135	1.7049e-002	4.7003e-002	9.e-003	-1.0424e-012
2136	1.6111e-002	4.7333e-002	9.e-003	-8.8372e-013
2137	1.5167e-002	4.7644e-002	9.e-003	-1.026e-012
2138	1.4217e-002	4.7936e-002	9.e-003	-9.1113e-013
2139	1.3261e-002	4.8209e-002	9.e-003	-1.047e-012
2140	1.23e-002	4.8464e-002	9.e-003	-9.6059e-013
2141	1.1334e-002	4.8699e-002	9.e-003	-1.1093e-012
2142	1.0363e-002	4.8914e-002	9.e-003	-1.0795e-012
2143	9.3887e-003	4.9111e-002	9.e-003	-1.2337e-012
2144	8.4103e-003	4.9288e-002	9.e-003	-1.2313e-012
2145	7.4288e-003	4.9445e-002	9.e-003	-1.4094e-012
2146	6.4442e-003	4.9583e-002	9.e-003	-1.4545e-012
2147	5.4571e-003	4.9701e-002	9.e-003	-1.6415e-012
2148	4.4678e-003	4.98e-002	9.e-003	-1.7206e-012
2149	3.4769e-003	4.9879e-002	9.e-003	-1.9487e-012
2150	2.4844e-003	4.9938e-002	9.e-003	-2.1121e-012
2151	1.4911e-003	4.9978e-002	9.e-003	-2.3957e-012
2152	4.9709e-004	4.9998e-002	9.e-003	-2.6227e-012
2153	-4.9701e-004	4.9998e-002	9.e-003	-2.9607e-012
2154	-1.491e-003	4.9978e-002	9.e-003	-3.2785e-012
2155	-2.4843e-003	4.9938e-002	9.e-003	-3.6973e-012
2156	-3.4768e-003	4.9879e-002	9.e-003	-4.1072e-012
2157	-4.4678e-003	4.98e-002	9.e-003	-4.5575e-012
2158	-5.4571e-003	4.9701e-002	9.e-003	-5.0102e-012
2159	-6.4441e-003	4.9583e-002	9.e-003	-5.3995e-012
2160	-7.4287e-003	4.9445e-002	9.e-003	-5.7011e-012
2161	-8.4102e-003	4.9288e-002	9.e-003	-5.8459e-012
2162	-9.3886e-003	4.9111e-002	9.e-003	-5.8338e-012
2163	-1.0363e-002	4.8914e-002	9.e-003	-5.5486e-012
2164	-1.1334e-002	4.8699e-002	9.e-003	-5.0215e-012
2165	-1.23e-002	4.8464e-002	9.e-003	-4.0972e-012
2166	-1.3261e-002	4.8209e-002	9.e-003	-2.8581e-012
2167	-1.4217e-002	4.7936e-002	9.e-003	-1.1631e-012
2168	-1.5167e-002	4.7644e-002	9.e-003	8.6183e-013
2169	-1.6111e-002	4.7333e-002	9.e-003	3.4445e-012
2170	-1.7049e-002	4.7003e-002	9.e-003	6.3511e-012
2171	-1.798e-002	4.6655e-002	9.e-003	9.8764e-012
2172	-1.8904e-002	4.6289e-002	9.e-003	1.3752e-011
2173	-1.9821e-002	4.5904e-002	9.e-003	1.844e-011
2174	-2.073e-002	4.55e-002	9.e-003	2.3021e-011
2175	-2.163e-002	4.5079e-002	9.e-003	3.1031e-011
2176	-2.2522e-002	4.464e-002	9.e-003	3.0114e-011
2177	-2.3405e-002	4.4184e-002	9.e-003	7.1776e-011
2178	-2.4279e-002	4.371e-002	9.e-003	-3.9734e-012
2179	-2.5135e-002	4.3223e-002	8.9959e-003	7.1449e-011
2180	-2.5981e-002	4.272e-002	8.988e-003	4.8029e-011
2181	-2.6811e-002	4.2204e-002	8.9643e-003	-1.3555e-011
2182	-2.7638e-002	4.1667e-002	8.9609e-003	8.4999e-011
2183	-2.8438e-002	4.1125e-002	9.9704e-003	-4.4834e-011
2184	-2.8435e-002	4.1127e-002	1.0985e-002	1.1014e-011
2185	-2.8488e-002	4.109e-002	4.1002e-002	-2.8522e-011
2186	-2.7675e-002	4.1642e-002	4.1e-002	-5.1127e-012
2187	-2.6842e-002	4.2184e-002	4.1e-002	2.9367e-011
2188	-2.5998e-002	4.271e-002	4.1e-002	-2.7983e-012
2189	-2.5143e-002	4.3218e-002	4.1e-002	-1.9754e-012
2190	-2.4279e-002	4.371e-002	4.1e-002	5.1104e-012
2191	-2.3405e-002	4.4184e-002	4.1e-002	4.5634e-012
2192	-2.2522e-002	4.464e-002	4.1e-002	3.4879e-012
2193	-2.163e-002	4.5079e-002	4.1e-002	2.0906e-012
2194	-2.073e-002	4.55e-002	4.1e-002	9.5852e-013
2195	-1.9821e-002	4.5904e-002	4.1e-002	-3.755e-013
2196	-1.8904e-002	4.6288e-002	4.1e-002	-8.4074e-013
2197	-1.798e-002	4.6655e-002	4.1e-002	-1.3691e-012
2198	-1.7049e-002	4.7003e-002	4.1e-002	-1.0826e-012
2199	-1.6111e-002	4.7333e-002	4.1e-002	-9.1611e-013
2200	-1.5167e-002	4.7644e-002	4.1e-002	-1.0806e-013
2201	-1.4217e-002	4.7936e-002	4.1e-002	4.5743e-013
2202	-1.3261e-002	4.8209e-002	4.1e-002	1.4136e-012
2203	-1.23e-002	4.8464e-002	4.1e-002	2.0249e-012
2204	-1.1334e-002	4.8699e-002	4.1e-002	2.8305e-012
2205	-1.0363e-002	4.8914e-002	4.1e-002	3.239e-012
2206	-9.3887e-003	4.9111e-002	4.1e-002	3.8084e-012
2207	-8.4103e-003	4.9288e-002	4.1e-002	4.0105e-012
2208	-7.4288e-003	4.9445e-002	4.1e-002	4.3172e-012
2209	-6.4442e-003	4.9583e-002	4.1e-002	4.365e-012
2210	-5.4571e-003	4.9701e-002	4.1e-002	4.5361e-012
2211	-4.4678e-003	4.98e-002	4.1e-002	4.5205e-012
2212	-3.4769e-003	4.9879e-002	4.1e-002	4.5374e-012
2213	-2.4844e-003	4.9938e-002	4.1e-002	4.4803e-012
2214	-1.4911e-003	4.9978e-002	4.1e-002	4.4488e-012
2215	-4.971e-004	4.9998e-002	4.1e-002	4.3579e-012
2216	4.9702e-004	4.9998e-002	4.1e-002	4.226e-012
2217	1.491e-003	4.9978e-002	4.1e-002	4.0495e-012
2218	2.4844e-003	4.9938e-002	4.1e-002	3.8254e-012
2219	3.4768e-003	4.9879e-002	4.1e-002	3.6519e-012
2220	4.4678e-003	4.98e-002	4.1e-002	3.3738e-012
2221	5.457e-003	4.9701e-002	4.1e-002	3.157e-012
2222	6.4441e-003	4.9583e-002	4.1e-002	2.8243e-012
2223	7.4287e-003	4.9445e-002	4.1e-002	2.6552e-012
2224	8.4103e-003	4.9288e-002	4.1e-002	2.2672e-012
2225	9.3886e-003	4.9111e-002	4.1e-002	2.1296e-012
2226	1.0363e-002	4.8914e-002	4.1e-002	1.7512e-012
2227	1.1334e-002	4.8699e-002	4.1e-002	1.6624e-012
2228	1.23e-002	4.8464e-002	4.1e-002	1.278e-012
2229	1.3261e-002	4.8209e-002	4.1e-002	1.2277e-012
2230	1.4217e-002	4.7936e-002	4.1e-002	8.6817e-013
2231	1.5167e-002	4.7644e-002	4.1e-002	8.7196e-013
2232	1.6111e-002	4.7333e-002	4.1e-002	5.2273e-013
2233	1.7049e-002	4.7004e-002	4.1e-002	6.0316e-013
2234	1.798e-002	4.6655e-002	4.1e-002	2.719e-013
2235	1.8904e-002	4.6289e-002	4.1e-002	4.1558e-013
2236	1.9821e-002	4.5904e-002	4.1e-002	1.1944e-013
2237	2.073e-002	4.55e-002	4.1e-002	3.6504e-013
2238	2.163e-002	4.5079e-002	4.1e-002	9.5594e-014
2239	2.2522e-002	4.464e-002	4.1e-002	3.8509e-013
2240	2.3405e-002	4.4184e-002	4.1e-002	3.0222e-013
2241	2.4279e-002	4.371e-002	4.1e-002	2.5237e-013
2242	2.5143e-002	4.3218e-002	4.1e-002	3.9617e-013
2243	2.5998e-002	4.271e-002	4.1e-002	-4.1333e-013
2244	2.6842e-002	4.2184e-002	4.1e-002	1.8018e-012
2245	-2.7623e-002	4.1677e-002	1.0982e-002	1.0218e-010
2246	-2.8492e-002	4.1088e-002	4.e-002	-1.408e-011
2247	-2.8482e-002	4.1095e-002	3.9e-002	-1.6729e-010
2248	-2.8481e-002	4.1095e-002	3.7999e-002	1.2912e-010
2249	-2.848e-002	4.1096e-002	3.6998e-002	1.2432e-010
2250	-2.8478e-002	4.1097e-002	3.5998e-002	-1.5644e-010
2251	-2.8478e-002	4.1098e-002	3.4997e-002	9.3146e-011
2252	-2.8477e-002	4.1098e-002	3.3998e-002	1.4434e-010
2253	-2.8475e-002	4.11e-002	3.2998e-002	-1.5498e-010
2254	-2.8474e-002	4.11e-002	3.1998e-002	-1.644e-010
2255	-2.8472e-002	4.1101e-002	3.0999e-002	-4.6734e-012
2256	-2.8479e-002	4.1097e-002	2.9998e-002	4.5547e-011
2257	-2.8479e-002	4.1097e-002	2.8998e-002	8.5779e-011
2258	-2.8478e-002	4.1097e-002	2.7998e-002	-6.285e-011
2259	-2.8477e-002	4.1098e-002	2.6999e-002	-2.3841e-010
2260	-2.8492e-002	4.1088e-002	2.6012e-002	8.009e-011
2261	-2.8513e-002	4.1073e-002	2.5025e-002	1.2262e-010
2262	-2.8545e-002	4.1051e-002	2.4034e-002	-8.2459e-011
2263	-2.8581e-002	4.1026e-002	2.3037e-002	1.2017e-010
2264	-2.8603e-002	4.1011e-002	2.2033e-002	-9.3946e-011
2265	-2.8586e-002	4.1022e-002	2.1026e-002	-1.9973e-010
2266	-2.8559e-002	4.1041e-002	2.002e-002	9.3768e-011
2267	-2.8535e-002	4.1058e-002	1.9017e-002	1.3473e-010
2268	-2.85e-002	4.1082e-002	1.8011e-002	2.4635e-011
2269	-2.8475e-002	4.11e-002	1.7005e-002	-1.2804e-010
2270	-2.845e-002	4.1117e-002	1.6005e-002	-5.6182e-011
2271	-2.8433e-002	4.1128e-002	1.5007e-002	1.2991e-010
2272	-2.8428e-002	4.1132e-002	1.4009e-002	1.8558e-010
2273	-2.8431e-002	4.113e-002	1.3004e-002	8.4165e-011
2274	-2.8436e-002	4.1126e-002	1.1995e-002	-5.4256e-011
2275	-2.7622e-002	4.1677e-002	1.1991e-002	2.4462e-010
2276	-2.6802e-002	4.221e-002	9.9715e-003	1.0408e-010
2277	2.7675e-002	4.1642e-002	4.e-002	-2.6994e-012
2278	-2.68e-002	4.2211e-002	1.0979e-002	1.629e-010
2279	2.7675e-002	4.1642e-002	3.9e-002	-3.3966e-012
2280	2.7675e-002	4.1642e-002	3.8e-002	-5.1768e-012
2281	2.7675e-002	4.1643e-002	3.7e-002	-3.9914e-012
2282	2.7675e-002	4.1643e-002	3.6e-002	8.0387e-013
2283	2.7675e-002	4.1643e-002	3.5e-002	1.662e-013
2284	2.7675e-002	4.1643e-002	3.4e-002	-2.0153e-012
2285	2.7674e-002	4.1643e-002	3.3e-002	-1.4499e-012
2286	2.7674e-002	4.1643e-002	3.2e-002	-2.6202e-012
2287	2.7674e-002	4.1643e-002	3.1e-002	-3.1966e-012
2288	2.7674e-002	4.1643e-002	3.e-002	-2.4149e-012
2289	2.7674e-002	4.1643e-002	2.9e-002	-2.2195e-012
2290	2.7674e-002	4.1643e-002	2.8e-002	-2.618e-012
2291	2.7673e-002	4.1644e-002	2.7e-002	-2.6272e-012
2292	2.7673e-002	4.1644e-002	2.6e-002	-2.4634e-012
2293	2.7673e-002	4.1644e-002	2.5e-002	-2.4546e-012
2294	2.7673e-002	4.1644e-002	2.4e-002	-2.4313e-012
2295	2.7673e-002	4.1644e-002	2.3e-002	-2.4108e-012
2296	2.7672e-002	4.1644e-002	2.2e-002	-2.4152e-012
2297	2.7672e-002	4.1644e-002	2.1e-002	-2.4742e-012
2298	2.7672e-002	4.1644e-002	2.e-002	-2.5009e-012
2299	2.7672e-002	4.1645e-002	1.9e-002	-2.5108e-012
2300	2.7672e-002	4.1645e-002	1.8e-002	-2.5033e-012
2301	2.7672e-002	4.1645e-002	1.7e-002	-2.4078e-012
2302	2.7671e-002	4.1645e-002	1.6e-002	-2.1043e-012
2303	2.7671e-002	4.1645e-002	1.5e-002	-2.117e-012
2304	2.7671e-002	4.1645e-002	1.4e-002	-3.8022e-012
2305	2.7671e-002	4.1645e-002	1.3e-002	-2.7887e-012
2306	2.7671e-002	4.1645e-002	1.2e-002	3.2947e-012
2307	2.767e-002	4.1646e-002	1.1e-002	5.6195e-012
2308	2.767e-002	4.1646e-002	1.e-002	5.032e-011
2309	2.6842e-002	4.2184e-002	1.e-002	-9.1997e-011
2310	2.5998e-002	4.271e-002	1.e-002	3.9731e-011
2311	2.4279e-002	4.371e-002	1.e-002	3.4813e-013
2312	2.3405e-002	4.4184e-002	1.e-002	-3.2555e-012
2313	2.2522e-002	4.464e-002	1.e-002	-2.0651e-012
2314	2.163e-002	4.5079e-002	1.e-002	-1.8737e-012
2315	2.073e-002	4.55e-002	1.e-002	-1.6945e-012
2316	1.9821e-002	4.5904e-002	1.e-002	-1.5376e-012
2317	1.8904e-002	4.6289e-002	1.e-002	-1.2837e-012
2318	1.798e-002	4.6655e-002	1.e-002	-1.3981e-012
2319	1.7049e-002	4.7003e-002	1.e-002	-1.3409e-012
2320	1.6111e-002	4.7333e-002	1.e-002	-1.1414e-012
2321	1.5167e-002	4.7644e-002	1.e-002	-1.2245e-012
2322	1.4217e-002	4.7936e-002	1.e-002	-1.2498e-012
2323	1.3261e-002	4.8209e-002	1.e-002	-1.1557e-012
2324	1.23e-002	4.8464e-002	1.e-002	-1.1889e-012
2325	1.1334e-002	4.8699e-002	1.e-002	-1.2225e-012
2326	1.0363e-002	4.8914e-002	1.e-002	-1.3e-012
2327	9.3886e-003	4.9111e-002	1.e-002	-1.3505e-012
2328	8.4103e-003	4.9288e-002	1.e-002	-1.4202e-012
2329	7.4288e-003	4.9445e-002	1.e-002	-1.5456e-012
2330	6.4442e-003	4.9583e-002	1.e-002	-1.6302e-012
2331	5.4571e-003	4.9701e-002	1.e-002	-1.7618e-012
2332	4.4678e-003	4.98e-002	1.e-002	-1.9233e-012
2333	3.4769e-003	4.9879e-002	1.e-002	-2.0851e-012
2334	2.4844e-003	4.9938e-002	1.e-002	-2.287e-012
2335	1.4911e-003	4.9978e-002	1.e-002	-2.5154e-012
2336	4.9708e-004	4.9998e-002	1.e-002	-2.8246e-012
2337	-4.9703e-004	4.9998e-002	1.e-002	-3.0907e-012
2338	-1.491e-003	4.9978e-002	1.e-002	-3.4843e-012
2339	-2.4844e-003	4.9938e-002	1.e-002	-3.8613e-012
2340	-3.4768e-003	4.9879e-002	1.e-002	-4.3336e-012
2341	-4.4678e-003	4.98e-002	1.e-002	-4.7928e-012
2342	-5.4571e-003	4.9701e-002	1.e-002	-5.2915e-012
2343	-6.4441e-003	4.9583e-002	1.e-002	-5.6861e-012
2344	-7.4287e-003	4.9445e-002	1.e-002	-6.1142e-012
2345	-8.4103e-003	4.9288e-002	1.e-002	-6.2361e-012
2346	-9.3886e-003	4.9111e-002	1.e-002	-6.2562e-012
2347	-1.0363e-002	4.8914e-002	1.e-002	-5.9153e-012
2348	-1.1334e-002	4.8699e-002	1.e-002	-5.3453e-012
2349	-1.23e-002	4.8464e-002	1.e-002	-4.2432e-012
2350	-1.3261e-002	4.8209e-002	1.e-002	-2.8878e-012
2351	-1.4217e-002	4.7936e-002	1.e-002	-9.2415e-013
2352	-1.5167e-002	4.7644e-002	1.e-002	1.4012e-012
2353	-1.6111e-002	4.7333e-002	1.e-002	4.3999e-012
2354	-1.7049e-002	4.7003e-002	1.e-002	7.804e-012
2355	-1.798e-002	4.6655e-002	1.e-002	1.197e-011
2356	-1.8904e-002	4.6289e-002	1.e-002	1.6493e-011
2357	-1.9821e-002	4.5904e-002	1.e-002	2.189e-011
2358	-2.073e-002	4.55e-002	1.e-002	2.7365e-011
2359	-2.163e-002	4.5079e-002	1.e-002	3.5116e-011
2360	-2.2522e-002	4.464e-002	1.e-002	3.7976e-011
2361	-2.3405e-002	4.4184e-002	1.e-002	6.9213e-011
2362	-2.4279e-002	4.371e-002	1.e-002	3.0434e-011
2363	-2.5135e-002	4.3223e-002	9.9976e-003	4.7374e-011
2364	-2.5975e-002	4.2724e-002	9.9876e-003	2.7494e-011
2365	-2.7616e-002	4.1681e-002	1.3002e-002	7.2704e-011
2366	-2.7612e-002	4.1684e-002	1.4008e-002	-1.7777e-010
2367	-2.762e-002	4.1679e-002	1.5011e-002	-2.0357e-010
2368	-2.7637e-002	4.1668e-002	1.6015e-002	1.1793e-011
2369	-2.7662e-002	4.1651e-002	1.7025e-002	1.0031e-010
2370	-2.7693e-002	4.1631e-002	1.8032e-002	-6.7247e-011
2371	-2.7726e-002	4.1608e-002	1.9038e-002	-3.9647e-011
2372	-2.778e-002	4.1572e-002	2.1047e-002	8.4663e-011
2373	-2.7789e-002	4.1566e-002	2.205e-002	3.099e-010
2374	-2.7675e-002	4.1642e-002	4.e-002	1.1284e-010
2375	-2.6842e-002	4.2184e-002	4.e-002	2.928e-011
2376	-2.5998e-002	4.271e-002	4.e-002	-2.791e-011
2377	-2.5143e-002	4.3218e-002	4.e-002	3.2689e-012
2378	-2.4279e-002	4.371e-002	4.e-002	1.4737e-012
2379	-2.3405e-002	4.4184e-002	4.e-002	-2.6363e-014
2380	-2.2522e-002	4.464e-002	4.e-002	-9.5003e-013
2381	-2.163e-002	4.5079e-002	4.e-002	-2.0361e-012
2382	-2.073e-002	4.55e-002	4.e-002	-3.2195e-012
2383	-1.9821e-002	4.5904e-002	4.e-002	-3.6476e-012
2384	-1.8904e-002	4.6288e-002	4.e-002	-3.9236e-012
2385	-1.798e-002	4.6655e-002	4.e-002	-3.57e-012
2386	-1.7049e-002	4.7003e-002	4.e-002	-3.0203e-012
2387	-1.6111e-002	4.7333e-002	4.e-002	-2.0335e-012
2388	-1.5167e-002	4.7644e-002	4.e-002	-1.0315e-012
2389	-1.4217e-002	4.7936e-002	4.e-002	2.0103e-013
2390	-1.3261e-002	4.8209e-002	4.e-002	1.2534e-012
2391	-1.23e-002	4.8464e-002	4.e-002	2.3096e-012
2392	-1.1334e-002	4.8699e-002	4.e-002	3.1091e-012
2393	-1.0363e-002	4.8914e-002	4.e-002	3.8409e-012
2394	-9.3887e-003	4.9111e-002	4.e-002	4.2714e-012
2395	-8.4103e-003	4.9288e-002	4.e-002	4.6948e-012
2396	-7.4288e-003	4.9445e-002	4.e-002	4.8782e-012
2397	-6.4442e-003	4.9583e-002	4.e-002	5.0531e-012
2398	-5.4572e-003	4.9701e-002	4.e-002	5.1321e-012
2399	-4.4678e-003	4.98e-002	4.e-002	5.1979e-012
2400	-3.4769e-003	4.9879e-002	4.e-002	5.1952e-012
2401	-2.4844e-003	4.9938e-002	4.e-002	5.1904e-012
2402	-1.4911e-003	4.9978e-002	4.e-002	5.1274e-012
2403	-4.9707e-004	4.9998e-002	4.e-002	5.0379e-012
2404	4.9697e-004	4.9998e-002	4.e-002	4.8805e-012
2405	1.491e-003	4.9978e-002	4.e-002	4.6791e-012
2406	2.4843e-003	4.9938e-002	4.e-002	4.4454e-012
2407	3.4768e-003	4.9879e-002	4.e-002	4.1789e-012
2408	4.4677e-003	4.98e-002	4.e-002	3.9347e-012
2409	5.4571e-003	4.9701e-002	4.e-002	3.5784e-012
2410	6.4441e-003	4.9583e-002	4.e-002	3.2924e-012
2411	7.4287e-003	4.9445e-002	4.e-002	2.9801e-012
2412	8.4102e-003	4.9288e-002	4.e-002	2.6937e-012
2413	9.3886e-003	4.9111e-002	4.e-002	2.3169e-012
2414	1.0363e-002	4.8914e-002	4.e-002	2.1044e-012
2415	1.1334e-002	4.8699e-002	4.e-002	1.7679e-012
2416	1.23e-002	4.8464e-002	4.e-002	1.5586e-012
2417	1.3261e-002	4.8209e-002	4.e-002	1.2668e-012
2418	1.4217e-002	4.7936e-002	4.e-002	1.1061e-012
2419	1.5167e-002	4.7644e-002	4.e-002	8.2277e-013
2420	1.6111e-002	4.7333e-002	4.e-002	7.2813e-013
2421	1.7049e-002	4.7003e-002	4.e-002	4.8272e-013
2422	1.798e-002	4.6655e-002	4.e-002	4.2033e-013
2423	1.8904e-002	4.6289e-002	4.e-002	2.0101e-013
2424	1.9821e-002	4.5904e-002	4.e-002	2.2171e-013
2425	2.073e-002	4.55e-002	4.e-002	6.8655e-014
2426	2.163e-002	4.5079e-002	4.e-002	2.1383e-013
2427	2.2522e-002	4.464e-002	4.e-002	-1.5604e-013
2428	2.3405e-002	4.4184e-002	4.e-002	3.1571e-013
2429	2.4279e-002	4.371e-002	4.e-002	1.1248e-013
2430	2.5143e-002	4.3218e-002	4.e-002	3.7513e-013
2431	2.5998e-002	4.271e-002	4.e-002	-1.6919e-012
2432	2.6842e-002	4.2184e-002	4.e-002	2.2744e-012
2433	-2.7675e-002	4.1642e-002	3.9e-002	1.1192e-012
2434	-2.7667e-002	4.1648e-002	3.8e-002	-8.1755e-011
2435	-2.7666e-002	4.1648e-002	3.7e-002	3.2795e-011
2436	-2.7666e-002	4.1649e-002	3.6e-002	7.6079e-011
2437	-2.7665e-002	4.1649e-002	3.4999e-002	-2.2886e-011
2438	-2.7664e-002	4.165e-002	3.3999e-002	-5.3608e-011
2439	-2.7664e-002	4.165e-002	3.3e-002	1.1203e-011
2440	-2.7663e-002	4.1651e-002	3.2e-002	-9.4072e-011
2441	-2.7662e-002	4.1651e-002	3.1e-002	-1.1952e-010
2442	-2.7661e-002	4.1652e-002	3.e-002	1.8319e-011
2443	-2.766e-002	4.1652e-002	2.9e-002	-7.3046e-011
2444	-2.7659e-002	4.1653e-002	2.8e-002	-1.3089e-010
2445	-2.7665e-002	4.1649e-002	2.7005e-002	4.366e-011
2446	-2.767e-002	4.1646e-002	2.6012e-002	-6.6096e-011
2447	-2.7695e-002	4.1629e-002	2.5031e-002	-2.0138e-010
2448	-2.773e-002	4.1606e-002	2.4038e-002	-2.8398e-011
2449	-2.7762e-002	4.1585e-002	2.3044e-002	1.4954e-010
2450	2.6842e-002	4.2184e-002	1.1e-002	-6.4269e-011
2451	2.6842e-002	4.2184e-002	1.2e-002	-6.9102e-012
2452	2.6842e-002	4.2184e-002	1.3e-002	1.8939e-012
2453	2.6842e-002	4.2184e-002	1.4e-002	7.4348e-014
2454	2.6842e-002	4.2184e-002	1.5e-002	-2.4446e-012
2455	2.6842e-002	4.2184e-002	1.6e-002	-2.5246e-012
2456	2.6842e-002	4.2184e-002	1.7e-002	-2.2049e-012
2457	2.6842e-002	4.2184e-002	1.8e-002	-2.2476e-012
2458	2.6842e-002	4.2184e-002	1.9e-002	-2.2745e-012
2459	2.6842e-002	4.2184e-002	2.e-002	-2.3023e-012
2460	2.6842e-002	4.2184e-002	2.1e-002	-2.3001e-012
2461	2.6842e-002	4.2184e-002	2.2e-002	-2.2716e-012
2462	2.6842e-002	4.2184e-002	2.3e-002	-2.139e-012
2463	2.6842e-002	4.2184e-002	2.4e-002	-2.074e-012
2464	2.6842e-002	4.2184e-002	2.5e-002	-2.1225e-012
2465	2.6842e-002	4.2184e-002	2.6e-002	-1.7757e-012
2466	2.6842e-002	4.2184e-002	2.7e-002	-1.5916e-012
2467	2.6842e-002	4.2184e-002	2.8e-002	-2.0343e-012
2468	2.6842e-002	4.2184e-002	2.9e-002	-2.3976e-012
2469	2.6842e-002	4.2185e-002	3.e-002	-2.5243e-012
2470	2.6842e-002	4.2185e-002	3.1e-002	-1.9069e-012
2471	2.6841e-002	4.2185e-002	3.2e-002	-1.4471e-012
2472	2.6841e-002	4.2185e-002	3.3e-002	-1.6844e-012
2473	2.6841e-002	4.2185e-002	3.4e-002	-9.8156e-013
2474	2.6841e-002	4.2185e-002	3.5e-002	-3.2064e-013
2475	2.6841e-002	4.2185e-002	3.6e-002	-6.5027e-013
2476	2.5998e-002	4.271e-002	1.1e-002	3.081e-011
2477	2.5143e-002	4.3218e-002	1.1e-002	-5.4729e-012
2478	2.4279e-002	4.3709e-002	1.1e-002	-2.7297e-012
2479	2.3405e-002	4.4184e-002	1.1e-002	-2.6262e-012
2480	2.2522e-002	4.464e-002	1.1e-002	-2.8018e-012
2481	2.163e-002	4.5079e-002	1.1e-002	-2.437e-012
2482	2.073e-002	4.55e-002	1.1e-002	-2.1634e-012
2483	1.9821e-002	4.5904e-002	1.1e-002	-2.0131e-012
2484	1.8904e-002	4.6288e-002	1.1e-002	-1.3532e-012
2485	1.798e-002	4.6655e-002	1.1e-002	-2.0843e-012
2486	1.7049e-002	4.7003e-002	1.1e-002	-1.6549e-012
2487	1.6111e-002	4.7333e-002	1.1e-002	-1.2101e-012
2488	1.5167e-002	4.7644e-002	1.1e-002	-1.5869e-012
2489	1.4217e-002	4.7936e-002	1.1e-002	-1.4058e-012
2490	1.3261e-002	4.8209e-002	1.1e-002	-1.3004e-012
2491	1.23e-002	4.8464e-002	1.1e-002	-1.4011e-012
2492	1.1334e-002	4.8699e-002	1.1e-002	-1.3535e-012
2493	1.0363e-002	4.8914e-002	1.1e-002	-1.4539e-012
2494	9.3887e-003	4.9111e-002	1.1e-002	-1.4657e-012
2495	8.4103e-003	4.9288e-002	1.1e-002	-1.6002e-012
2496	7.4288e-003	4.9445e-002	1.1e-002	-1.6271e-012
2497	6.4442e-003	4.9583e-002	1.1e-002	-1.7811e-012
2498	5.4571e-003	4.9701e-002	1.1e-002	-1.8538e-012
2499	4.4678e-003	4.98e-002	1.1e-002	-2.0393e-012
2500	3.4769e-003	4.9879e-002	1.1e-002	-2.1901e-012
2501	2.4844e-003	4.9938e-002	1.1e-002	-2.4064e-012
2502	1.4911e-003	4.9978e-002	1.1e-002	-2.5692e-012
2503	4.971e-004	4.9998e-002	1.1e-002	-2.8887e-012
2504	-4.9702e-004	4.9998e-002	1.1e-002	-3.1764e-012
2505	-1.491e-003	4.9978e-002	1.1e-002	-3.5309e-012
2506	-2.4844e-003	4.9938e-002	1.1e-002	-3.8983e-012
2507	-3.4768e-003	4.9879e-002	1.1e-002	-4.3701e-012
2508	-4.4678e-003	4.98e-002	1.1e-002	-4.8734e-012
2509	-5.4571e-003	4.9701e-002	1.1e-002	-5.3844e-012
2510	-6.4441e-003	4.9583e-002	1.1e-002	-5.8509e-012
2511	-7.4287e-003	4.9445e-002	1.1e-002	-6.2781e-012
2512	-8.4103e-003	4.9288e-002	1.1e-002	-6.5191e-012
2513	-9.3886e-003	4.9111e-002	1.1e-002	-6.5271e-012
2514	-1.0363e-002	4.8914e-002	1.1e-002	-6.2325e-012
2515	-1.1334e-002	4.8699e-002	1.1e-002	-5.5472e-012
2516	-1.23e-002	4.8464e-002	1.1e-002	-4.5005e-012
2517	-1.3261e-002	4.8209e-002	1.1e-002	-2.9985e-012
2518	-1.4217e-002	4.7936e-002	1.1e-002	-1.0292e-012
2519	-1.5167e-002	4.7644e-002	1.1e-002	1.5163e-012
2520	-1.6111e-002	4.7333e-002	1.1e-002	4.5932e-012
2521	-1.7049e-002	4.7003e-002	1.1e-002	8.3391e-012
2522	-1.798e-002	4.6655e-002	1.1e-002	1.2641e-011
2523	-1.8904e-002	4.6289e-002	1.1e-002	1.7624e-011
2524	-1.9821e-002	4.5904e-002	1.1e-002	2.2953e-011
2525	-2.073e-002	4.55e-002	1.1e-002	2.9382e-011
2526	-2.163e-002	4.5079e-002	1.1e-002	3.3974e-011
2527	-2.2522e-002	4.464e-002	1.1e-002	4.6544e-011
2528	-2.3405e-002	4.4184e-002	1.1e-002	2.6676e-011
2529	-2.4279e-002	4.371e-002	1.1e-002	1.1238e-010
2530	-2.5134e-002	4.3224e-002	1.0997e-002	1.5352e-011
2531	-2.6799e-002	4.2211e-002	1.1987e-002	7.0037e-011
2532	-2.6798e-002	4.2212e-002	1.2996e-002	-4.0514e-011
2533	-2.6796e-002	4.2213e-002	1.4004e-002	-1.7423e-011
2534	-2.6799e-002	4.2212e-002	1.5012e-002	1.4616e-010
2535	-2.681e-002	4.2205e-002	1.6022e-002	7.1607e-011
2536	-2.6841e-002	4.2185e-002	1.7033e-002	-1.4718e-010
2537	-2.6867e-002	4.2168e-002	1.8041e-002	-3.5751e-011
2538	-2.6899e-002	4.2148e-002	1.9054e-002	-9.4421e-011
2539	-2.692e-002	4.2134e-002	2.0055e-002	2.0254e-011
2540	-2.6941e-002	4.2121e-002	2.1054e-002	3.4045e-010
2541	-2.6946e-002	4.2118e-002	2.2053e-002	1.3833e-010
2542	2.6842e-002	4.2184e-002	3.9e-002	2.2304e-012
2543	2.6842e-002	4.2184e-002	3.8e-002	-9.3807e-014
2544	2.6842e-002	4.2184e-002	3.7e-002	-1.3591e-012
2545	-2.6842e-002	4.2184e-002	3.9e-002	1.4132e-010
2546	-2.5998e-002	4.271e-002	3.9e-002	-6.8774e-011
2547	-2.5143e-002	4.3218e-002	3.9e-002	1.8296e-011
2548	-2.4279e-002	4.371e-002	3.9e-002	-8.1924e-012
2549	-2.3405e-002	4.4184e-002	3.9e-002	-3.9786e-012
2550	-2.2522e-002	4.464e-002	3.9e-002	-6.5062e-012
2551	-2.163e-002	4.5079e-002	3.9e-002	-6.9205e-012
2552	-2.073e-002	4.55e-002	3.9e-002	-7.4749e-012
2553	-1.9821e-002	4.5904e-002	3.9e-002	-7.4497e-012
2554	-1.8904e-002	4.6288e-002	3.9e-002	-6.8559e-012
2555	-1.798e-002	4.6655e-002	3.9e-002	-6.0425e-012
2556	-1.7049e-002	4.7003e-002	3.9e-002	-4.7478e-012
2557	-1.6111e-002	4.7333e-002	3.9e-002	-3.2449e-012
2558	-1.5167e-002	4.7644e-002	3.9e-002	-1.6822e-012
2559	-1.4217e-002	4.7936e-002	3.9e-002	-1.0806e-013
2560	-1.3261e-002	4.8209e-002	3.9e-002	1.3474e-012
2561	-1.23e-002	4.8464e-002	3.9e-002	2.5801e-012
2562	-1.1334e-002	4.8699e-002	3.9e-002	3.6007e-012
2563	-1.0363e-002	4.8914e-002	3.9e-002	4.3791e-012
2564	-9.3887e-003	4.9111e-002	3.9e-002	4.8874e-012
2565	-8.4103e-003	4.9288e-002	3.9e-002	5.2504e-012
2566	-7.4288e-003	4.9445e-002	3.9e-002	5.4923e-012
2567	-6.4442e-003	4.9583e-002	3.9e-002	5.6634e-012
2568	-5.4572e-003	4.9701e-002	3.9e-002	5.7384e-012
2569	-4.4678e-003	4.98e-002	3.9e-002	5.8337e-012
2570	-3.4769e-003	4.9879e-002	3.9e-002	5.8795e-012
2571	-2.4844e-003	4.9938e-002	3.9e-002	5.8616e-012
2572	-1.4912e-003	4.9978e-002	3.9e-002	5.8023e-012
2573	-4.971e-004	4.9998e-002	3.9e-002	5.7166e-012
2574	4.9697e-004	4.9998e-002	3.9e-002	5.4976e-012
2575	1.491e-003	4.9978e-002	3.9e-002	5.3182e-012
2576	2.4843e-003	4.9938e-002	3.9e-002	5.0361e-012
2577	3.4768e-003	4.9879e-002	3.9e-002	4.7498e-012
2578	4.4677e-003	4.98e-002	3.9e-002	4.392e-012
2579	5.457e-003	4.9701e-002	3.9e-002	4.0635e-012
2580	6.4441e-003	4.9583e-002	3.9e-002	3.6675e-012
2581	7.4287e-003	4.9445e-002	3.9e-002	3.3536e-012
2582	8.4102e-003	4.9288e-002	3.9e-002	2.9669e-012
2583	9.3886e-003	4.9111e-002	3.9e-002	2.6464e-012
2584	1.0363e-002	4.8914e-002	3.9e-002	2.2829e-012
2585	1.1334e-002	4.8699e-002	3.9e-002	1.992e-012
2586	1.23e-002	4.8464e-002	3.9e-002	1.6657e-012
2587	1.3261e-002	4.8209e-002	3.9e-002	1.4401e-012
2588	1.4217e-002	4.7936e-002	3.9e-002	1.1597e-012
2589	1.5167e-002	4.7644e-002	3.9e-002	9.7111e-013
2590	1.6111e-002	4.7333e-002	3.9e-002	7.0369e-013
2591	1.7049e-002	4.7003e-002	3.9e-002	5.5425e-013
2592	1.798e-002	4.6655e-002	3.9e-002	3.407e-013
2593	1.8904e-002	4.6289e-002	3.9e-002	2.3604e-013
2594	1.9821e-002	4.5904e-002	3.9e-002	5.702e-014
2595	2.073e-002	4.55e-002	3.9e-002	5.9411e-015
2596	2.163e-002	4.5079e-002	3.9e-002	3.9569e-014
2597	2.2522e-002	4.464e-002	3.9e-002	-3.0527e-013
2598	2.3405e-002	4.4184e-002	3.9e-002	2.6052e-014
2599	2.4279e-002	4.371e-002	3.9e-002	-4.0934e-013
2600	2.5143e-002	4.3218e-002	3.9e-002	8.9291e-013
2601	-2.5972e-002	4.2725e-002	1.0989e-002	5.6342e-012
2602	-2.6842e-002	4.2184e-002	3.8e-002	7.7988e-012
2603	-2.6842e-002	4.2184e-002	3.7e-002	-7.8849e-011
2604	-2.6842e-002	4.2184e-002	3.6e-002	5.0657e-012
2605	-2.6842e-002	4.2184e-002	3.5e-002	1.2771e-011
2606	-2.6842e-002	4.2184e-002	3.4e-002	-1.4521e-012
2607	-2.6842e-002	4.2184e-002	3.3e-002	-2.4659e-011
2608	-2.6842e-002	4.2184e-002	3.2e-002	4.3796e-011
2609	-2.6841e-002	4.2185e-002	3.1e-002	6.0102e-011
2610	-2.6841e-002	4.2185e-002	3.e-002	-8.3185e-011
2611	-2.6841e-002	4.2185e-002	2.9e-002	-1.9003e-010
2612	-2.6841e-002	4.2185e-002	2.8e-002	-8.9458e-011
2613	-2.6834e-002	4.219e-002	2.7e-002	1.4938e-011
2614	-2.6842e-002	4.2184e-002	2.6015e-002	-4.7912e-011
2615	-2.6868e-002	4.2168e-002	2.503e-002	-7.7445e-011
2616	-2.6898e-002	4.2149e-002	2.404e-002	-1.3488e-010
2617	2.5998e-002	4.271e-002	1.2e-002	-4.8778e-012
2618	2.5143e-002	4.3218e-002	1.2e-002	4.6804e-012
2619	2.3405e-002	4.4184e-002	1.2e-002	-2.5662e-012
2620	2.2522e-002	4.464e-002	1.2e-002	-2.7939e-012
2621	2.163e-002	4.5079e-002	1.2e-002	-2.4768e-012
2622	2.073e-002	4.55e-002	1.2e-002	-2.5416e-012
2623	1.9821e-002	4.5904e-002	1.2e-002	-2.1815e-012
2624	1.8904e-002	4.6289e-002	1.2e-002	-1.8443e-012
2625	1.798e-002	4.6655e-002	1.2e-002	-2.3595e-012
2626	1.7049e-002	4.7003e-002	1.2e-002	-1.6917e-012
2627	1.5167e-002	4.7644e-002	1.2e-002	-1.8478e-012
2628	1.4217e-002	4.7936e-002	1.2e-002	-1.3343e-012
2629	1.3261e-002	4.8209e-002	1.2e-002	-1.6022e-012
2630	1.23e-002	4.8464e-002	1.2e-002	-1.503e-012
2631	1.1334e-002	4.8699e-002	1.2e-002	-1.5416e-012
2632	1.0363e-002	4.8914e-002	1.2e-002	-1.5314e-012
2633	9.3886e-003	4.9111e-002	1.2e-002	-1.5965e-012
2634	8.4103e-003	4.9288e-002	1.2e-002	-1.6698e-012
2635	7.4287e-003	4.9445e-002	1.2e-002	-1.7402e-012
2636	6.4442e-003	4.9583e-002	1.2e-002	-1.8249e-012
2637	5.4571e-003	4.9701e-002	1.2e-002	-1.9508e-012
2638	4.4678e-003	4.98e-002	1.2e-002	-2.0794e-012
2639	3.4768e-003	4.9879e-002	1.2e-002	-2.2449e-012
2640	2.4844e-003	4.9938e-002	1.2e-002	-2.4138e-012
2641	1.4911e-003	4.9978e-002	1.2e-002	-2.6253e-012
2642	4.9708e-004	4.9998e-002	1.2e-002	-2.8359e-012
2643	-4.9704e-004	4.9998e-002	1.2e-002	-3.1463e-012
2644	-1.491e-003	4.9978e-002	1.2e-002	-3.4164e-012
2645	-2.4844e-003	4.9938e-002	1.2e-002	-3.8162e-012
2646	-3.4768e-003	4.9879e-002	1.2e-002	-4.2345e-012
2647	-4.4678e-003	4.98e-002	1.2e-002	-4.745e-012
2648	-5.4571e-003	4.9701e-002	1.2e-002	-5.2782e-012
2649	-6.4441e-003	4.9583e-002	1.2e-002	-5.8297e-012
2650	-7.4287e-003	4.9445e-002	1.2e-002	-6.2399e-012
2651	-8.4103e-003	4.9288e-002	1.2e-002	-6.6183e-012
2652	-9.3886e-003	4.9111e-002	1.2e-002	-6.6518e-012
2653	-1.0363e-002	4.8914e-002	1.2e-002	-6.3959e-012
2654	-1.1334e-002	4.8699e-002	1.2e-002	-5.7106e-012
2655	-1.23e-002	4.8464e-002	1.2e-002	-4.7476e-012
2656	-1.3261e-002	4.8209e-002	1.2e-002	-3.2499e-012
2657	-1.4217e-002	4.7936e-002	1.2e-002	-1.3644e-012
2658	-1.5167e-002	4.7644e-002	1.2e-002	1.0973e-012
2659	-1.6111e-002	4.7333e-002	1.2e-002	4.0385e-012
2660	-1.7049e-002	4.7003e-002	1.2e-002	7.7016e-012
2661	-1.798e-002	4.6655e-002	1.2e-002	1.1877e-011
2662	-1.8904e-002	4.6289e-002	1.2e-002	1.673e-011
2663	-1.9821e-002	4.5904e-002	1.2e-002	2.2025e-011
2664	-2.073e-002	4.55e-002	1.2e-002	2.7696e-011
2665	-2.163e-002	4.5079e-002	1.2e-002	3.4484e-011
2666	-2.2522e-002	4.464e-002	1.2e-002	3.9929e-011
2667	-2.3405e-002	4.4184e-002	1.2e-002	4.4063e-011
2668	-2.4279e-002	4.371e-002	1.2e-002	5.5592e-011
2669	-2.5132e-002	4.3225e-002	1.1996e-002	9.9119e-011
2670	-2.5971e-002	4.2726e-002	1.199e-002	4.4011e-011
2671	-2.5974e-002	4.2724e-002	1.299e-002	1.439e-010
2672	-2.5965e-002	4.273e-002	1.3995e-002	2.1682e-010
2673	-2.5971e-002	4.2726e-002	1.5008e-002	-2.2415e-012
2674	-2.5977e-002	4.2722e-002	1.6019e-002	-1.0612e-010
2675	-2.6009e-002	4.2703e-002	1.7025e-002	4.6396e-011
2676	-2.6031e-002	4.269e-002	1.8043e-002	3.5472e-011
2677	-2.6054e-002	4.2675e-002	1.9054e-002	1.0116e-010
2678	-2.6078e-002	4.2661e-002	2.0059e-002	-5.4514e-011
2679	-2.6086e-002	4.2656e-002	2.1057e-002	-2.7885e-010
2680	-2.6088e-002	4.2655e-002	2.2049e-002	2.9257e-011
2681	2.5998e-002	4.271e-002	3.8e-002	1.5182e-012
2682	2.5998e-002	4.271e-002	3.7e-002	1.9208e-012
2683	2.5997e-002	4.271e-002	3.6e-002	-3.6597e-012
2684	2.5997e-002	4.271e-002	3.4e-002	-2.011e-012
2685	2.5997e-002	4.271e-002	3.3e-002	-2.0947e-012
2686	2.5997e-002	4.271e-002	3.2e-002	-2.0007e-012
2687	2.5997e-002	4.271e-002	3.1e-002	-1.51e-012
2688	2.5997e-002	4.271e-002	3.e-002	-1.5821e-012
2689	2.5997e-002	4.271e-002	2.9e-002	-1.8293e-012
2690	2.5997e-002	4.271e-002	2.8e-002	-2.0492e-012
2691	2.5997e-002	4.271e-002	2.7e-002	-2.6147e-012
2692	2.5997e-002	4.271e-002	2.6e-002	-2.4604e-012
2693	2.5997e-002	4.271e-002	2.5e-002	-2.1624e-012
2694	2.5997e-002	4.271e-002	2.4e-002	-2.4749e-012
2695	2.5997e-002	4.271e-002	2.3e-002	-2.5936e-012
2696	2.5997e-002	4.271e-002	2.2e-002	-2.5128e-012
2697	2.5997e-002	4.271e-002	2.1e-002	-2.4772e-012
2698	2.5997e-002	4.271e-002	2.e-002	-2.4818e-012
2699	2.5997e-002	4.271e-002	1.9e-002	-2.4225e-012
2700	2.5997e-002	4.271e-002	1.8e-002	-2.3122e-012
2701	2.5997e-002	4.271e-002	1.7e-002	-2.2435e-012
2702	2.5997e-002	4.271e-002	1.6e-002	-1.2444e-012
2703	2.5997e-002	4.271e-002	1.5e-002	-3.2203e-014
2704	2.5997e-002	4.271e-002	1.4e-002	-9.9645e-013
2705	2.5998e-002	4.271e-002	1.3e-002	-3.4329e-012
2706	-2.5998e-002	4.271e-002	3.8e-002	4.454e-011
2707	-2.5143e-002	4.3218e-002	3.8e-002	-1.2792e-011
2708	-2.4279e-002	4.371e-002	3.8e-002	-4.6102e-012
2709	-2.3405e-002	4.4184e-002	3.8e-002	-1.019e-011
2710	-2.2522e-002	4.464e-002	3.8e-002	-1.1154e-011
2711	-2.163e-002	4.5079e-002	3.8e-002	-1.151e-011
2712	-2.073e-002	4.55e-002	3.8e-002	-1.1488e-011
2713	-1.9821e-002	4.5904e-002	3.8e-002	-1.0694e-011
2714	-1.8904e-002	4.6288e-002	3.8e-002	-9.916e-012
2715	-1.798e-002	4.6655e-002	3.8e-002	-7.8347e-012
2716	-1.7049e-002	4.7003e-002	3.8e-002	-6.4284e-012
2717	-1.6111e-002	4.7333e-002	3.8e-002	-4.0254e-012
2718	-1.5167e-002	4.7644e-002	3.8e-002	-2.2218e-012
2719	-1.4217e-002	4.7936e-002	3.8e-002	-3.74e-014
2720	-1.3261e-002	4.8209e-002	3.8e-002	1.4986e-012
2721	-1.23e-002	4.8464e-002	3.8e-002	3.1699e-012
2722	-1.1334e-002	4.8699e-002	3.8e-002	4.0797e-012
2723	-1.0363e-002	4.8914e-002	3.8e-002	5.0499e-012
2724	-9.3887e-003	4.9111e-002	3.8e-002	5.45e-012
2725	-8.4103e-003	4.9288e-002	3.8e-002	5.8923e-012
2726	-7.4289e-003	4.9445e-002	3.8e-002	5.9807e-012
2727	-6.4442e-003	4.9583e-002	3.8e-002	6.267e-012
2728	-5.4572e-003	4.9701e-002	3.8e-002	6.3034e-012
2729	-4.4678e-003	4.98e-002	3.8e-002	6.4818e-012
2730	-3.477e-003	4.9879e-002	3.8e-002	6.4702e-012
2731	-2.4844e-003	4.9938e-002	3.8e-002	6.5575e-012
2732	-1.4912e-003	4.9978e-002	3.8e-002	6.4851e-012
2733	-4.9709e-004	4.9998e-002	3.8e-002	6.3463e-012
2734	4.9693e-004	4.9998e-002	3.8e-002	6.1578e-012
2735	1.491e-003	4.9978e-002	3.8e-002	5.885e-012
2736	2.4843e-003	4.9938e-002	3.8e-002	5.6428e-012
2737	3.4768e-003	4.9879e-002	3.8e-002	5.2347e-012
2738	4.4677e-003	4.98e-002	3.8e-002	4.8875e-012
2739	5.4571e-003	4.9701e-002	3.8e-002	4.4242e-012
2740	6.444e-003	4.9583e-002	3.8e-002	4.136e-012
2741	7.4287e-003	4.9445e-002	3.8e-002	3.5671e-012
2742	8.4102e-003	4.9288e-002	3.8e-002	3.3048e-012
2743	9.3886e-003	4.9111e-002	3.8e-002	2.8071e-012
2744	1.0363e-002	4.8914e-002	3.8e-002	2.5761e-012
2745	1.1334e-002	4.8699e-002	3.8e-002	2.042e-012
2746	1.2299e-002	4.8464e-002	3.8e-002	1.9295e-012
2747	1.3261e-002	4.8209e-002	3.8e-002	1.4053e-012
2748	1.4217e-002	4.7936e-002	3.8e-002	1.3705e-012
2749	1.5167e-002	4.7644e-002	3.8e-002	8.8085e-013
2750	1.6111e-002	4.7333e-002	3.8e-002	9.0202e-013
2751	1.7049e-002	4.7003e-002	3.8e-002	4.0415e-013
2752	1.798e-002	4.6655e-002	3.8e-002	4.8479e-013
2753	1.8904e-002	4.6289e-002	3.8e-002	2.2722e-014
2754	1.9821e-002	4.5904e-002	3.8e-002	1.689e-013
2755	2.073e-002	4.55e-002	3.8e-002	-2.2988e-013
2756	2.163e-002	4.5079e-002	3.8e-002	-1.3668e-013
2757	2.2522e-002	4.464e-002	3.8e-002	-1.5814e-013
2758	2.3405e-002	4.4184e-002	3.8e-002	-2.6852e-013
2759	2.4279e-002	4.371e-002	3.8e-002	-8.4172e-013
2760	2.5143e-002	4.3218e-002	3.8e-002	-5.6071e-013
2761	-2.5998e-002	4.271e-002	3.7e-002	7.182e-011
2762	-2.5998e-002	4.271e-002	3.6e-002	5.1094e-012
2763	-2.5998e-002	4.271e-002	3.5e-002	3.429e-013
2764	-2.5998e-002	4.271e-002	3.4e-002	-5.4601e-012
2765	-2.5998e-002	4.271e-002	3.3e-002	1.3277e-012
2766	-2.5998e-002	4.271e-002	3.2e-002	-1.1611e-011
2767	-2.5998e-002	4.271e-002	3.1e-002	-3.514e-011
2768	-2.5998e-002	4.271e-002	3.e-002	-2.1812e-011
2769	-2.5998e-002	4.271e-002	2.9e-002	9.5895e-011
2770	-2.5998e-002	4.2709e-002	2.8e-002	-3.0511e-012
2771	-2.5998e-002	4.2709e-002	2.7e-002	-2.7544e-010
2772	-2.6e-002	4.2709e-002	2.6012e-002	-1.0287e-010
2773	-2.6019e-002	4.2697e-002	2.503e-002	3.0438e-011
2774	-2.6056e-002	4.2674e-002	2.404e-002	-2.9621e-011
2775	-2.6074e-002	4.2663e-002	2.3044e-002	1.5402e-010
2776	-2.5131e-002	4.3226e-002	1.2998e-002	1.2373e-010
2777	-2.5128e-002	4.3227e-002	1.3998e-002	-2.441e-011
2778	-2.5129e-002	4.3227e-002	1.5002e-002	-3.0196e-011
2779	-2.5139e-002	4.3221e-002	1.6008e-002	4.7283e-011
2780	-2.5153e-002	4.3213e-002	1.7021e-002	1.0043e-010
2781	-2.5175e-002	4.3199e-002	1.8028e-002	9.3424e-011
2782	-2.5193e-002	4.3189e-002	1.9041e-002	-4.6963e-011
2783	-2.5226e-002	4.317e-002	2.1052e-002	8.7386e-012
2784	-2.5216e-002	4.3176e-002	2.204e-002	-9.3432e-011
2785	-2.5205e-002	4.3182e-002	2.3032e-002	-7.1451e-011
2786	2.5143e-002	4.3218e-002	1.3e-002	-1.0245e-012
2787	2.4279e-002	4.371e-002	1.3e-002	4.0281e-013
2788	2.3405e-002	4.4184e-002	1.3e-002	-3.9958e-012
2789	2.2522e-002	4.464e-002	1.3e-002	-1.9138e-012
2790	2.163e-002	4.5079e-002	1.3e-002	-2.5066e-012
2791	2.073e-002	4.55e-002	1.3e-002	-2.4684e-012
2792	1.9821e-002	4.5903e-002	1.3e-002	-2.3028e-012
2793	1.8904e-002	4.6288e-002	1.3e-002	-2.4387e-012
2794	1.798e-002	4.6655e-002	1.3e-002	-2.3114e-012
2795	1.7049e-002	4.7003e-002	1.3e-002	-1.5704e-012
2796	1.6111e-002	4.7333e-002	1.3e-002	-2.1181e-012
2797	1.5167e-002	4.7644e-002	1.3e-002	-1.7955e-012
2798	1.4217e-002	4.7936e-002	1.3e-002	-1.3137e-012
2799	1.3261e-002	4.8209e-002	1.3e-002	-1.9172e-012
2800	1.23e-002	4.8464e-002	1.3e-002	-1.5551e-012
2801	1.1334e-002	4.8699e-002	1.3e-002	-1.6524e-012
2802	1.0363e-002	4.8914e-002	1.3e-002	-1.5998e-012
2803	9.3887e-003	4.9111e-002	1.3e-002	-1.7108e-012
2804	8.4103e-003	4.9288e-002	1.3e-002	-1.6705e-012
2805	7.4288e-003	4.9445e-002	1.3e-002	-1.8e-012
2806	6.4442e-003	4.9583e-002	1.3e-002	-1.8275e-012
2807	5.4571e-003	4.9701e-002	1.3e-002	-2.009e-012
2808	4.4678e-003	4.98e-002	1.3e-002	-2.0623e-012
2809	3.4769e-003	4.9879e-002	1.3e-002	-2.2385e-012
2810	2.4844e-003	4.9938e-002	1.3e-002	-2.3449e-012
2811	1.4911e-003	4.9978e-002	1.3e-002	-2.5896e-012
2812	4.971e-004	4.9998e-002	1.3e-002	-2.7234e-012
2813	-4.9702e-004	4.9998e-002	1.3e-002	-2.9626e-012
2814	-1.491e-003	4.9978e-002	1.3e-002	-3.2097e-012
2815	-2.4844e-003	4.9938e-002	1.3e-002	-3.5859e-012
2816	-3.4768e-003	4.9879e-002	1.3e-002	-3.9273e-012
2817	-4.4678e-003	4.98e-002	1.3e-002	-4.4107e-012
2818	-5.457e-003	4.9701e-002	1.3e-002	-4.9655e-012
2819	-6.4441e-003	4.9583e-002	1.3e-002	-5.5355e-012
2820	-7.4287e-003	4.9445e-002	1.3e-002	-6.0442e-012
2821	-8.4103e-003	4.9288e-002	1.3e-002	-6.4561e-012
2822	-9.3886e-003	4.9111e-002	1.3e-002	-6.595e-012
2823	-1.0363e-002	4.8914e-002	1.3e-002	-6.37e-012
2824	-1.1334e-002	4.8699e-002	1.3e-002	-5.7985e-012
2825	-1.23e-002	4.8464e-002	1.3e-002	-4.8419e-012
2826	-1.3261e-002	4.8209e-002	1.3e-002	-3.5344e-012
2827	-1.4217e-002	4.7936e-002	1.3e-002	-1.8041e-012
2828	-1.5167e-002	4.7644e-002	1.3e-002	2.6668e-013
2829	-1.6111e-002	4.7333e-002	1.3e-002	2.904e-012
2830	-1.7049e-002	4.7004e-002	1.3e-002	6.0327e-012
2831	-1.798e-002	4.6655e-002	1.3e-002	9.8758e-012
2832	-1.8904e-002	4.6289e-002	1.3e-002	1.4201e-011
2833	-1.9821e-002	4.5904e-002	1.3e-002	1.9189e-011
2834	-2.073e-002	4.55e-002	1.3e-002	2.4697e-011
2835	-2.163e-002	4.5079e-002	1.3e-002	3.1759e-011
2836	-2.2522e-002	4.464e-002	1.3e-002	4.1431e-011
2837	-2.3405e-002	4.4184e-002	1.3e-002	6.2863e-011
2838	-2.4279e-002	4.371e-002	1.3e-002	2.0609e-011
2839	2.5143e-002	4.3218e-002	3.7e-002	-1.7966e-012
2840	2.5143e-002	4.3218e-002	3.6e-002	-7.0977e-014
2841	2.5143e-002	4.3218e-002	3.5e-002	-5.7801e-013
2842	2.5143e-002	4.3218e-002	3.4e-002	-1.8249e-012
2843	2.5143e-002	4.3218e-002	3.3e-002	-1.1735e-012
2844	2.5143e-002	4.3218e-002	3.2e-002	-1.0384e-012
2845	2.5143e-002	4.3218e-002	3.1e-002	-1.4214e-012
2846	2.5143e-002	4.3218e-002	3.e-002	-1.71e-012
2847	2.5143e-002	4.3218e-002	2.9e-002	-1.9845e-012
2848	2.5143e-002	4.3218e-002	2.8e-002	-2.3692e-012
2849	2.5143e-002	4.3218e-002	2.7e-002	-2.5367e-012
2850	2.5143e-002	4.3218e-002	2.6e-002	-2.6014e-012
2851	2.5143e-002	4.3218e-002	2.5e-002	-2.5311e-012
2852	2.5143e-002	4.3218e-002	2.4e-002	-2.2552e-012
2853	2.5143e-002	4.3218e-002	2.3e-002	-2.0594e-012
2854	2.5143e-002	4.3218e-002	2.2e-002	-2.0713e-012
2855	2.5143e-002	4.3218e-002	2.1e-002	-2.1572e-012
2856	2.5143e-002	4.3218e-002	2.e-002	-2.1656e-012
2857	2.5143e-002	4.3218e-002	1.9e-002	-2.2346e-012
2858	2.5143e-002	4.3218e-002	1.8e-002	-2.0405e-012
2859	2.5143e-002	4.3218e-002	1.7e-002	-1.3967e-012
2860	2.5143e-002	4.3218e-002	1.6e-002	-2.2358e-012
2861	2.5143e-002	4.3218e-002	1.5e-002	-3.3125e-012
2862	2.5143e-002	4.3218e-002	1.4e-002	-2.7123e-012
2863	-2.5143e-002	4.3218e-002	3.7e-002	-1.3324e-011
2864	-2.4279e-002	4.371e-002	3.7e-002	-5.6891e-012
2865	-2.3405e-002	4.4184e-002	3.7e-002	-1.3186e-011
2866	-2.2522e-002	4.464e-002	3.7e-002	-1.4028e-011
2867	-2.163e-002	4.5079e-002	3.7e-002	-1.4871e-011
2868	-2.073e-002	4.55e-002	3.7e-002	-1.4678e-011
2869	-1.9821e-002	4.5904e-002	3.7e-002	-1.3316e-011
2870	-1.8904e-002	4.6288e-002	3.7e-002	-1.2059e-011
2871	-1.798e-002	4.6655e-002	3.7e-002	-9.1508e-012
2872	-1.7049e-002	4.7003e-002	3.7e-002	-7.5883e-012
2873	-1.6111e-002	4.7333e-002	3.7e-002	-4.329e-012
2874	-1.5167e-002	4.7644e-002	3.7e-002	-2.396e-012
2875	-1.4217e-002	4.7936e-002	3.7e-002	3.5088e-013
2876	-1.3261e-002	4.8209e-002	3.7e-002	1.9721e-012
2877	-1.23e-002	4.8464e-002	3.7e-002	3.8991e-012
2878	-1.1334e-002	4.8699e-002	3.7e-002	4.7453e-012
2879	-1.0363e-002	4.8914e-002	3.7e-002	5.7511e-012
2880	-9.3888e-003	4.9111e-002	3.7e-002	5.9958e-012
2881	-8.4103e-003	4.9288e-002	3.7e-002	6.491e-012
2882	-7.4289e-003	4.9445e-002	3.7e-002	6.4481e-012
2883	-6.4442e-003	4.9583e-002	3.7e-002	6.7815e-012
2884	-5.4572e-003	4.9701e-002	3.7e-002	6.8376e-012
2885	-4.4678e-003	4.98e-002	3.7e-002	7.0823e-012
2886	-3.477e-003	4.9879e-002	3.7e-002	7.0792e-012
2887	-2.4844e-003	4.9938e-002	3.7e-002	7.2243e-012
2888	-1.4912e-003	4.9978e-002	3.7e-002	7.1392e-012
2889	-4.971e-004	4.9998e-002	3.7e-002	6.9846e-012
2890	4.9691e-004	4.9998e-002	3.7e-002	6.8058e-012
2891	1.491e-003	4.9978e-002	3.7e-002	6.459e-012
2892	2.4842e-003	4.9938e-002	3.7e-002	6.1643e-012
2893	3.4768e-003	4.9879e-002	3.7e-002	5.667e-012
2894	4.4677e-003	4.98e-002	3.7e-002	5.3414e-012
2895	5.4571e-003	4.9701e-002	3.7e-002	4.7712e-012
2896	6.444e-003	4.9583e-002	3.7e-002	4.4773e-012
2897	7.4287e-003	4.9445e-002	3.7e-002	3.7986e-012
2898	8.4101e-003	4.9288e-002	3.7e-002	3.5958e-012
2899	9.3886e-003	4.9111e-002	3.7e-002	2.9288e-012
2900	1.0363e-002	4.8914e-002	3.7e-002	2.799e-012
2901	1.1334e-002	4.8699e-002	3.7e-002	2.1177e-012
2902	1.2299e-002	4.8464e-002	3.7e-002	2.0777e-012
2903	1.3261e-002	4.8209e-002	3.7e-002	1.4279e-012
2904	1.4216e-002	4.7936e-002	3.7e-002	1.4787e-012
2905	1.5167e-002	4.7644e-002	3.7e-002	8.2211e-013
2906	1.6111e-002	4.7333e-002	3.7e-002	1.0274e-012
2907	1.7049e-002	4.7003e-002	3.7e-002	3.433e-013
2908	1.798e-002	4.6655e-002	3.7e-002	5.6431e-013
2909	1.8904e-002	4.6289e-002	3.7e-002	-1.6682e-013
2910	1.9821e-002	4.5904e-002	3.7e-002	2.7179e-013
2911	2.073e-002	4.55e-002	3.7e-002	-4.1077e-013
2912	2.2522e-002	4.464e-002	3.7e-002	-3.8511e-013
2913	2.3405e-002	4.4184e-002	3.7e-002	-1.749e-013
2914	2.4279e-002	4.371e-002	3.7e-002	-7.1635e-013
2915	-2.5143e-002	4.3218e-002	3.6e-002	6.2924e-012
2916	-2.5143e-002	4.3218e-002	3.5e-002	-5.876e-013
2917	-2.5143e-002	4.3218e-002	3.4e-002	-1.9939e-012
2918	-2.5143e-002	4.3218e-002	3.3e-002	-6.3451e-012
2919	-2.5143e-002	4.3218e-002	3.2e-002	-8.9441e-012
2920	-2.5143e-002	4.3218e-002	3.1e-002	-1.054e-011
2921	-2.5143e-002	4.3218e-002	3.e-002	-1.2806e-011
2922	-2.5143e-002	4.3218e-002	2.9e-002	-8.2352e-011
2923	-2.5143e-002	4.3218e-002	2.8e-002	-6.1461e-011
2924	-2.5143e-002	4.3218e-002	2.7e-002	5.5212e-011
2925	-2.5143e-002	4.3218e-002	2.6e-002	-9.8719e-011
2926	-2.5156e-002	4.3211e-002	2.5015e-002	-9.3797e-011
2927	-2.5188e-002	4.3192e-002	2.4023e-002	7.4845e-011
2928	-2.4279e-002	4.371e-002	1.4e-002	6.0965e-011
2929	-2.4279e-002	4.371e-002	1.5e-002	6.6566e-011
2930	-2.4279e-002	4.371e-002	1.6e-002	5.2413e-011
2931	-2.4287e-002	4.3705e-002	1.7006e-002	2.2908e-011
2932	-2.4302e-002	4.3697e-002	1.802e-002	-2.2395e-011
2933	-2.4322e-002	4.3686e-002	1.9028e-002	-5.0196e-011
2934	-2.434e-002	4.3675e-002	2.003e-002	3.308e-011
2935	-2.4339e-002	4.3676e-002	2.1031e-002	7.928e-012
2936	2.4279e-002	4.3709e-002	1.4e-002	1.3238e-013
2937	2.3405e-002	4.4184e-002	1.4e-002	-2.3748e-012
2938	2.2522e-002	4.464e-002	1.4e-002	-2.9795e-012
2939	2.163e-002	4.5079e-002	1.4e-002	-1.8978e-012
2940	2.073e-002	4.55e-002	1.4e-002	-2.4107e-012
2941	1.9821e-002	4.5903e-002	1.4e-002	-2.3637e-012
2942	1.8904e-002	4.6289e-002	1.4e-002	-2.5918e-012
2943	1.798e-002	4.6655e-002	1.4e-002	-1.9591e-012
2944	1.6111e-002	4.7333e-002	1.4e-002	-1.8354e-012
2945	1.4217e-002	4.7936e-002	1.4e-002	-1.4945e-012
2946	1.3261e-002	4.8209e-002	1.4e-002	-1.9971e-012
2947	1.23e-002	4.8464e-002	1.4e-002	-1.5593e-012
2948	1.1334e-002	4.8699e-002	1.4e-002	-1.738e-012
2949	1.0363e-002	4.8914e-002	1.4e-002	-1.5899e-012
2950	9.3886e-003	4.9111e-002	1.4e-002	-1.7704e-012
2951	8.4103e-003	4.9288e-002	1.4e-002	-1.6501e-012
2952	7.4288e-003	4.9445e-002	1.4e-002	-1.8026e-012
2953	6.4442e-003	4.9583e-002	1.4e-002	-1.7927e-012
2954	5.4571e-003	4.9701e-002	1.4e-002	-1.9858e-012
2955	4.4678e-003	4.98e-002	1.4e-002	-2.0029e-012
2956	3.4769e-003	4.9879e-002	1.4e-002	-2.1535e-012
2957	2.4844e-003	4.9938e-002	1.4e-002	-2.2407e-012
2958	1.4911e-003	4.9978e-002	1.4e-002	-2.4173e-012
2959	4.9709e-004	4.9998e-002	1.4e-002	-2.5519e-012
2960	-4.9703e-004	4.9998e-002	1.4e-002	-2.7017e-012
2961	-1.491e-003	4.9978e-002	1.4e-002	-2.9439e-012
2962	-2.4844e-003	4.9938e-002	1.4e-002	-3.1248e-012
2963	-3.4768e-003	4.9879e-002	1.4e-002	-3.497e-012
2964	-4.4678e-003	4.98e-002	1.4e-002	-3.8573e-012
2965	-5.4571e-003	4.9701e-002	1.4e-002	-4.4438e-012
2966	-6.4441e-003	4.9583e-002	1.4e-002	-4.9409e-012
2967	-7.4287e-003	4.9445e-002	1.4e-002	-5.6556e-012
2968	-8.4103e-003	4.9288e-002	1.4e-002	-5.985e-012
2969	-9.3886e-003	4.9111e-002	1.4e-002	-6.364e-012
2970	-1.0363e-002	4.8914e-002	1.4e-002	-6.0612e-012
2971	-1.1334e-002	4.8699e-002	1.4e-002	-5.7185e-012
2972	-1.23e-002	4.8464e-002	1.4e-002	-4.625e-012
2973	-1.3261e-002	4.8209e-002	1.4e-002	-3.7022e-012
2974	-1.4217e-002	4.7936e-002	1.4e-002	-2.1193e-012
2975	-1.5167e-002	4.7644e-002	1.4e-002	-6.9814e-013
2976	-1.6111e-002	4.7333e-002	1.4e-002	1.5744e-012
2977	-1.7049e-002	4.7003e-002	1.4e-002	3.7904e-012
2978	-1.798e-002	4.6655e-002	1.4e-002	7.1541e-012
2979	-1.8904e-002	4.6289e-002	1.4e-002	1.0565e-011
2980	-1.9821e-002	4.5904e-002	1.4e-002	1.5611e-011
2981	-2.073e-002	4.55e-002	1.4e-002	2.0213e-011
2982	-2.163e-002	4.5079e-002	1.4e-002	2.9631e-011
2983	-2.2522e-002	4.464e-002	1.4e-002	3.8018e-011
2984	-2.3405e-002	4.4184e-002	1.4e-002	8.4708e-011
2985	2.4279e-002	4.371e-002	3.6e-002	-8.3169e-013
2986	2.4279e-002	4.371e-002	3.5e-002	-8.0244e-013
2987	2.4279e-002	4.371e-002	3.4e-002	-1.0012e-012
2988	2.4279e-002	4.371e-002	3.3e-002	-1.4765e-012
2989	2.4279e-002	4.371e-002	3.2e-002	-1.4682e-012
2990	2.4279e-002	4.371e-002	3.1e-002	-1.4721e-012
2991	2.4279e-002	4.371e-002	3.e-002	-1.6427e-012
2992	2.4279e-002	4.371e-002	2.9e-002	-1.6857e-012
2993	2.4279e-002	4.371e-002	2.8e-002	-1.3757e-012
2994	2.4279e-002	4.371e-002	2.7e-002	-1.2257e-012
2995	2.4279e-002	4.371e-002	2.6e-002	-1.5708e-012
2996	2.4279e-002	4.371e-002	2.5e-002	-1.8422e-012
2997	2.4279e-002	4.371e-002	2.4e-002	-1.7531e-012
2998	2.4279e-002	4.371e-002	2.3e-002	-1.6597e-012
2999	2.4279e-002	4.371e-002	2.2e-002	-1.7226e-012
3000	2.4279e-002	4.371e-002	2.1e-002	-1.8629e-012
3001	2.4279e-002	4.371e-002	2.e-002	-1.9059e-012
3002	2.4279e-002	4.3709e-002	1.9e-002	-1.8144e-012
3003	2.4279e-002	4.3709e-002	1.8e-002	-2.5076e-012
3004	2.4279e-002	4.3709e-002	1.7e-002	-3.5599e-012
3005	2.4279e-002	4.3709e-002	1.6e-002	-2.5342e-012
3006	2.4279e-002	4.3709e-002	1.5e-002	-8.6577e-013
3007	-2.4279e-002	4.371e-002	3.6e-002	-8.8849e-012
3008	-2.3405e-002	4.4184e-002	3.6e-002	-1.3129e-011
3009	-2.2522e-002	4.464e-002	3.6e-002	-1.4986e-011
3010	-2.163e-002	4.5079e-002	3.6e-002	-1.6898e-011
3011	-2.073e-002	4.55e-002	3.6e-002	-1.6335e-011
3012	-1.9821e-002	4.5904e-002	3.6e-002	-1.5289e-011
3013	-1.8904e-002	4.6288e-002	3.6e-002	-1.2571e-011
3014	-1.798e-002	4.6655e-002	3.6e-002	-1.0288e-011
3015	-1.7049e-002	4.7003e-002	3.6e-002	-7.5288e-012
3016	-1.6111e-002	4.7333e-002	3.6e-002	-4.5992e-012
3017	-1.5167e-002	4.7644e-002	3.6e-002	-1.5423e-012
3018	-1.4217e-002	4.7936e-002	3.6e-002	6.7893e-013
3019	-1.3261e-002	4.8209e-002	3.6e-002	3.1148e-012
3020	-1.23e-002	4.8464e-002	3.6e-002	4.4802e-012
3021	-1.1334e-002	4.8699e-002	3.6e-002	5.8069e-012
3022	-1.0363e-002	4.8914e-002	3.6e-002	6.2933e-012
3023	-9.3888e-003	4.9111e-002	3.6e-002	6.6982e-012
3024	-8.4104e-003	4.9288e-002	3.6e-002	6.769e-012
3025	-7.4289e-003	4.9445e-002	3.6e-002	7.032e-012
3026	-6.4442e-003	4.9583e-002	3.6e-002	7.1157e-012
3027	-5.4572e-003	4.9701e-002	3.6e-002	7.4091e-012
3028	-4.4679e-003	4.98e-002	3.6e-002	7.5615e-012
3029	-3.477e-003	4.9879e-002	3.6e-002	7.8087e-012
3030	-2.4845e-003	4.9938e-002	3.6e-002	7.8162e-012
3031	-1.4912e-003	4.9978e-002	3.6e-002	7.79e-012
3032	-4.9714e-004	4.9998e-002	3.6e-002	7.6279e-012
3033	4.9691e-004	4.9998e-002	3.6e-002	7.3791e-012
3034	1.491e-003	4.9978e-002	3.6e-002	7.025e-012
3035	2.4842e-003	4.9938e-002	3.6e-002	6.5776e-012
3036	3.4767e-003	4.9879e-002	3.6e-002	6.133e-012
3037	4.4676e-003	4.98e-002	3.6e-002	5.6278e-012
3038	5.457e-003	4.9701e-002	3.6e-002	5.1609e-012
3039	6.444e-003	4.9583e-002	3.6e-002	4.5911e-012
3040	7.4286e-003	4.9445e-002	3.6e-002	4.1822e-012
3041	8.4101e-003	4.9288e-002	3.6e-002	3.6277e-012
3042	9.3885e-003	4.9111e-002	3.6e-002	3.2532e-012
3043	1.0363e-002	4.8914e-002	3.6e-002	2.7176e-012
3044	1.1334e-002	4.8699e-002	3.6e-002	2.4141e-012
3045	1.2299e-002	4.8464e-002	3.6e-002	1.9019e-012
3046	1.3261e-002	4.8209e-002	3.6e-002	1.7061e-012
3047	1.4216e-002	4.7936e-002	3.6e-002	1.2399e-012
3048	1.5167e-002	4.7644e-002	3.6e-002	1.1082e-012
3049	1.6111e-002	4.7333e-002	3.6e-002	7.4195e-013
3050	1.7049e-002	4.7004e-002	3.6e-002	7.0851e-013
3051	1.798e-002	4.6655e-002	3.6e-002	1.9288e-013
3052	1.8904e-002	4.6289e-002	3.6e-002	1.3877e-013
3053	1.9821e-002	4.5904e-002	3.6e-002	-1.5638e-013
3054	2.073e-002	4.55e-002	3.6e-002	-4.6137e-014
3055	2.163e-002	4.5079e-002	3.6e-002	-3.4579e-013
3056	2.2522e-002	4.464e-002	3.6e-002	-5.2092e-013
3057	2.3405e-002	4.4184e-002	3.6e-002	-2.6609e-013
3058	-2.4289e-002	4.3704e-002	2.5003e-002	-4.7478e-011
3059	-2.4279e-002	4.3709e-002	3.5e-002	-5.9489e-012
3060	-2.4279e-002	4.3709e-002	3.4e-002	-7.6765e-012
3061	-2.4279e-002	4.3709e-002	3.3e-002	-9.3255e-012
3062	-2.4279e-002	4.3709e-002	3.2e-002	-1.2081e-011
3063	-2.4279e-002	4.3709e-002	3.1e-002	-1.4199e-011
3064	-2.4279e-002	4.3709e-002	3.e-002	-2.039e-011
3065	-2.4279e-002	4.3709e-002	2.9e-002	-1.2605e-012
3066	-2.4279e-002	4.3709e-002	2.8e-002	-2.1567e-012
3067	-2.428e-002	4.3709e-002	2.7e-002	-7.8942e-011
3068	-2.428e-002	4.3709e-002	2.6e-002	-7.0098e-011
3069	-2.3405e-002	4.4184e-002	1.5e-002	7.916e-011
3070	-2.3405e-002	4.4184e-002	1.6e-002	2.1855e-011
3071	-2.3416e-002	4.4178e-002	1.8004e-002	-3.4621e-011
3072	-2.3431e-002	4.417e-002	1.9014e-002	6.1375e-011
3073	-2.3441e-002	4.4164e-002	2.0016e-002	1.2123e-011
3074	-2.3447e-002	4.4161e-002	2.1016e-002	-8.5215e-011
3075	2.3405e-002	4.4184e-002	1.5e-002	-1.2191e-012
3076	2.2522e-002	4.464e-002	1.5e-002	-3.2204e-012
3077	2.163e-002	4.5079e-002	1.5e-002	-1.1695e-012
3078	2.073e-002	4.55e-002	1.5e-002	-2.7796e-012
3079	1.9821e-002	4.5903e-002	1.5e-002	-2.4057e-012
3080	1.8904e-002	4.6289e-002	1.5e-002	-2.3133e-012
3081	1.798e-002	4.6655e-002	1.5e-002	-1.9333e-012
3082	1.7049e-002	4.7003e-002	1.5e-002	-2.393e-012
3083	1.6111e-002	4.7333e-002	1.5e-002	-1.7331e-012
3084	1.5167e-002	4.7644e-002	1.5e-002	-1.7206e-012
3085	1.4217e-002	4.7936e-002	1.5e-002	-1.8845e-012
3086	1.3261e-002	4.8209e-002	1.5e-002	-1.6647e-012
3087	1.23e-002	4.8464e-002	1.5e-002	-1.7582e-012
3088	1.1334e-002	4.8699e-002	1.5e-002	-1.617e-012
3089	1.0363e-002	4.8914e-002	1.5e-002	-1.6106e-012
3090	9.3886e-003	4.9111e-002	1.5e-002	-1.6916e-012
3091	8.4103e-003	4.9288e-002	1.5e-002	-1.6379e-012
3092	7.4287e-003	4.9445e-002	1.5e-002	-1.7321e-012
3093	6.4442e-003	4.9583e-002	1.5e-002	-1.7579e-012
3094	5.4571e-003	4.9701e-002	1.5e-002	-1.8205e-012
3095	4.4678e-003	4.98e-002	1.5e-002	-1.9107e-012
3096	3.4768e-003	4.9879e-002	1.5e-002	-1.9826e-012
3097	2.4844e-003	4.9938e-002	1.5e-002	-2.1038e-012
3098	1.4911e-003	4.9978e-002	1.5e-002	-2.1668e-012
3099	4.9711e-004	4.9998e-002	1.5e-002	-2.3149e-012
3100	-4.9704e-004	4.9998e-002	1.5e-002	-2.3821e-012
3101	-1.491e-003	4.9978e-002	1.5e-002	-2.5293e-012
3102	-2.4844e-003	4.9938e-002	1.5e-002	-2.6001e-012
3103	-3.4768e-003	4.9879e-002	1.5e-002	-2.8865e-012
3104	-4.4678e-003	4.98e-002	1.5e-002	-3.1398e-012
3105	-5.457e-003	4.9701e-002	1.5e-002	-3.619e-012
3106	-6.4441e-003	4.9583e-002	1.5e-002	-4.1674e-012
3107	-7.4287e-003	4.9445e-002	1.5e-002	-4.8833e-012
3108	-8.4103e-003	4.9288e-002	1.5e-002	-5.3478e-012
3109	-9.3886e-003	4.9111e-002	1.5e-002	-5.7458e-012
3110	-1.0363e-002	4.8914e-002	1.5e-002	-5.584e-012
3111	-1.1334e-002	4.8699e-002	1.5e-002	-5.1158e-012
3112	-1.23e-002	4.8464e-002	1.5e-002	-4.1991e-012
3113	-1.3261e-002	4.8209e-002	1.5e-002	-3.3411e-012
3114	-1.4217e-002	4.7936e-002	1.5e-002	-2.2379e-012
3115	-1.5167e-002	4.7644e-002	1.5e-002	-1.2109e-012
3116	-1.6111e-002	4.7333e-002	1.5e-002	2.7419e-013
3117	-1.7049e-002	4.7004e-002	1.5e-002	1.8571e-012
3118	-1.798e-002	4.6655e-002	1.5e-002	4.2997e-012
3119	-1.8904e-002	4.6289e-002	1.5e-002	7.0118e-012
3120	-1.9821e-002	4.5904e-002	1.5e-002	1.1276e-011
3121	-2.073e-002	4.55e-002	1.5e-002	1.7237e-011
3122	-2.2522e-002	4.464e-002	1.5e-002	4.0554e-011
3123	2.3405e-002	4.4184e-002	3.5e-002	-7.2208e-013
3124	2.3405e-002	4.4184e-002	3.4e-002	-9.6551e-013
3125	2.3405e-002	4.4184e-002	3.3e-002	-1.1486e-012
3126	2.3405e-002	4.4184e-002	3.2e-002	-1.5559e-012
3127	2.3405e-002	4.4184e-002	3.1e-002	-1.5926e-012
3128	2.3405e-002	4.4184e-002	3.e-002	-1.3031e-012
3129	2.3405e-002	4.4184e-002	2.9e-002	-1.2239e-012
3130	2.3405e-002	4.4184e-002	2.8e-002	-1.6188e-012
3131	2.3405e-002	4.4184e-002	2.7e-002	-1.962e-012
3132	2.3405e-002	4.4184e-002	2.6e-002	-1.8251e-012
3133	2.3405e-002	4.4184e-002	2.5e-002	-1.716e-012
3134	2.3405e-002	4.4184e-002	2.4e-002	-1.8916e-012
3135	2.3405e-002	4.4184e-002	2.3e-002	-2.0928e-012
3136	2.3405e-002	4.4184e-002	2.2e-002	-2.0479e-012
3137	2.3405e-002	4.4184e-002	2.1e-002	-1.7961e-012
3138	2.3405e-002	4.4184e-002	2.e-002	-1.8691e-012
3139	2.3405e-002	4.4184e-002	1.9e-002	-2.0113e-012
3140	2.3405e-002	4.4184e-002	1.8e-002	-6.7546e-013
3141	2.3405e-002	4.4184e-002	1.7e-002	-2.8235e-013
3142	2.3406e-002	4.4183e-002	1.6e-002	-1.4237e-012
3143	-2.4324e-002	4.3684e-002	2.3019e-002	-1.8879e-011
3144	-2.4332e-002	4.368e-002	2.2025e-002	-8.246e-011
3145	-2.3405e-002	4.4184e-002	3.5e-002	-1.2681e-011
3146	-2.2522e-002	4.464e-002	3.5e-002	-1.5226e-011
3147	-2.163e-002	4.5079e-002	3.5e-002	-1.7143e-011
3148	-2.073e-002	4.55e-002	3.5e-002	-1.6981e-011
3149	-1.9821e-002	4.5904e-002	3.5e-002	-1.5147e-011
3150	-1.8904e-002	4.6288e-002	3.5e-002	-1.2829e-011
3151	-1.798e-002	4.6655e-002	3.5e-002	-1.0417e-011
3152	-1.7049e-002	4.7003e-002	3.5e-002	-6.3797e-012
3153	-1.6111e-002	4.7333e-002	3.5e-002	-4.5193e-012
3154	-1.5167e-002	4.7644e-002	3.5e-002	-1.0206e-013
3155	-1.4217e-002	4.7936e-002	3.5e-002	1.7912e-012
3156	-1.3261e-002	4.8209e-002	3.5e-002	3.7771e-012
3157	-1.23e-002	4.8464e-002	3.5e-002	5.7405e-012
3158	-1.1334e-002	4.8699e-002	3.5e-002	6.669e-012
3159	-1.0363e-002	4.8914e-002	3.5e-002	6.9602e-012
3160	-9.3888e-003	4.9111e-002	3.5e-002	7.2036e-012
3161	-8.4104e-003	4.9288e-002	3.5e-002	7.0859e-012
3162	-7.4289e-003	4.9445e-002	3.5e-002	7.3526e-012
3163	-6.4442e-003	4.9583e-002	3.5e-002	7.4806e-012
3164	-5.4572e-003	4.9701e-002	3.5e-002	7.8685e-012
3165	-4.4679e-003	4.98e-002	3.5e-002	8.1416e-012
3166	-3.477e-003	4.9879e-002	3.5e-002	8.4487e-012
3167	-2.4845e-003	4.9938e-002	3.5e-002	8.4826e-012
3168	-1.4912e-003	4.9978e-002	3.5e-002	8.4202e-012
3169	-4.9714e-004	4.9998e-002	3.5e-002	8.2395e-012
3170	4.9692e-004	4.9998e-002	3.5e-002	7.889e-012
3171	1.491e-003	4.9978e-002	3.5e-002	7.4807e-012
3172	2.4843e-003	4.9938e-002	3.5e-002	6.959e-012
3173	3.4767e-003	4.9879e-002	3.5e-002	6.5001e-012
3174	4.4677e-003	4.98e-002	3.5e-002	5.8673e-012
3175	5.457e-003	4.9701e-002	3.5e-002	5.3909e-012
3176	6.444e-003	4.9583e-002	3.5e-002	4.7786e-012
3177	7.4286e-003	4.9445e-002	3.5e-002	4.372e-012
3178	8.4102e-003	4.9288e-002	3.5e-002	3.7052e-012
3179	9.3885e-003	4.9111e-002	3.5e-002	3.3602e-012
3180	1.0363e-002	4.8914e-002	3.5e-002	2.7645e-012
3181	1.1334e-002	4.8699e-002	3.5e-002	2.4891e-012
3182	1.2299e-002	4.8464e-002	3.5e-002	1.9649e-012
3183	1.3261e-002	4.8209e-002	3.5e-002	1.611e-012
3184	1.4216e-002	4.7936e-002	3.5e-002	1.3035e-012
3185	1.5167e-002	4.7644e-002	3.5e-002	1.1183e-012
3186	1.6111e-002	4.7333e-002	3.5e-002	5.3363e-013
3187	1.7049e-002	4.7004e-002	3.5e-002	9.7727e-013
3188	1.798e-002	4.6655e-002	3.5e-002	4.4552e-014
3189	1.8904e-002	4.6289e-002	3.5e-002	1.0424e-013
3190	1.9821e-002	4.5904e-002	3.5e-002	-1.0657e-013
3191	2.073e-002	4.55e-002	3.5e-002	-2.4224e-014
3192	2.163e-002	4.5079e-002	3.5e-002	-5.1802e-013
3193	2.2522e-002	4.464e-002	3.5e-002	-4.6513e-013
3194	-2.3405e-002	4.4184e-002	3.4e-002	-1.1541e-011
3195	-2.3405e-002	4.4184e-002	3.3e-002	-1.2086e-011
3196	-2.3405e-002	4.4184e-002	3.2e-002	-1.253e-011
3197	-2.3405e-002	4.4184e-002	3.1e-002	-1.2795e-011
3198	-2.3405e-002	4.4184e-002	3.e-002	-9.2045e-012
3199	-2.3405e-002	4.4184e-002	2.9e-002	-1.1552e-011
3200	-2.3405e-002	4.4184e-002	2.8e-002	-1.9615e-011
3201	-2.3405e-002	4.4184e-002	2.7e-002	-2.5371e-011
3202	-2.3405e-002	4.4184e-002	2.6e-002	-6.073e-011
3203	-2.3405e-002	4.4184e-002	2.5e-002	-3.6585e-011
3204	-2.2522e-002	4.464e-002	1.7e-002	1.634e-011
3205	-2.2522e-002	4.464e-002	1.8e-002	-2.64e-012
3206	-2.2532e-002	4.4636e-002	1.9003e-002	-4.2423e-011
3207	-2.2535e-002	4.4634e-002	2.0005e-002	-3.0013e-011
3208	-2.2541e-002	4.4631e-002	2.1005e-002	3.4303e-011
3209	2.2522e-002	4.464e-002	1.6e-002	-6.537e-013
3210	2.163e-002	4.5079e-002	1.6e-002	-2.314e-012
3211	2.073e-002	4.55e-002	1.6e-002	-2.6927e-012
3212	1.9821e-002	4.5903e-002	1.6e-002	-2.709e-012
3213	1.8904e-002	4.6289e-002	1.6e-002	-2.003e-012
3214	1.798e-002	4.6655e-002	1.6e-002	-2.2208e-012
3215	1.7049e-002	4.7003e-002	1.6e-002	-1.5978e-012
3216	1.6111e-002	4.7333e-002	1.6e-002	-2.1535e-012
3217	1.5167e-002	4.7644e-002	1.6e-002	-1.6401e-012
3218	1.4217e-002	4.7936e-002	1.6e-002	-2.1207e-012
3219	1.3261e-002	4.8209e-002	1.6e-002	-1.3208e-012
3220	1.23e-002	4.8464e-002	1.6e-002	-1.855e-012
3221	1.1334e-002	4.8699e-002	1.6e-002	-1.4444e-012
3222	1.0363e-002	4.8914e-002	1.6e-002	-1.7055e-012
3223	9.3886e-003	4.9111e-002	1.6e-002	-1.4584e-012
3224	8.4104e-003	4.9288e-002	1.6e-002	-1.6379e-012
3225	7.4287e-003	4.9445e-002	1.6e-002	-1.5377e-012
3226	6.4442e-003	4.9583e-002	1.6e-002	-1.7234e-012
3227	5.4571e-003	4.9701e-002	1.6e-002	-1.5636e-012
3228	4.4679e-003	4.98e-002	1.6e-002	-1.7533e-012
3229	3.4768e-003	4.9879e-002	1.6e-002	-1.7542e-012
3230	2.4845e-003	4.9938e-002	1.6e-002	-1.8976e-012
3231	1.4911e-003	4.9978e-002	1.6e-002	-1.8813e-012
3232	4.9714e-004	4.9998e-002	1.6e-002	-1.9798e-012
3233	-4.9704e-004	4.9998e-002	1.6e-002	-2.0057e-012
3234	-1.491e-003	4.9978e-002	1.6e-002	-2.0043e-012
3235	-2.4844e-003	4.9938e-002	1.6e-002	-2.085e-012
3236	-3.4767e-003	4.9879e-002	1.6e-002	-2.1058e-012
3237	-4.4678e-003	4.98e-002	1.6e-002	-2.3234e-012
3238	-5.457e-003	4.9701e-002	1.6e-002	-2.5063e-012
3239	-6.4441e-003	4.9583e-002	1.6e-002	-3.2245e-012
3240	-7.4286e-003	4.9445e-002	1.6e-002	-3.6776e-012
3241	-8.4103e-003	4.9288e-002	1.6e-002	-4.5047e-012
3242	-9.3885e-003	4.9111e-002	1.6e-002	-4.7412e-012
3243	-1.0363e-002	4.8914e-002	1.6e-002	-4.7215e-012
3244	-1.1334e-002	4.8699e-002	1.6e-002	-4.0773e-012
3245	-1.23e-002	4.8464e-002	1.6e-002	-3.3563e-012
3246	-1.3261e-002	4.8209e-002	1.6e-002	-2.2538e-012
3247	-1.4217e-002	4.7936e-002	1.6e-002	-1.9283e-012
3248	-1.5167e-002	4.7644e-002	1.6e-002	-1.0352e-012
3249	-1.6111e-002	4.7333e-002	1.6e-002	-5.1402e-013
3250	-1.7049e-002	4.7004e-002	1.6e-002	7.9725e-013
3251	-1.798e-002	4.6655e-002	1.6e-002	2.2972e-012
3252	-1.8904e-002	4.6289e-002	1.6e-002	5.0258e-012
3253	-1.9821e-002	4.5904e-002	1.6e-002	7.0329e-012
3254	-2.073e-002	4.55e-002	1.6e-002	1.3449e-011
3255	-2.163e-002	4.5079e-002	1.6e-002	2.4659e-011
3256	2.2522e-002	4.464e-002	3.4e-002	-5.8814e-013
3257	2.2522e-002	4.464e-002	3.3e-002	-8.64e-013
3258	2.2522e-002	4.464e-002	3.2e-002	-1.0118e-012
3259	2.2522e-002	4.464e-002	3.1e-002	-1.1102e-012
3260	2.2522e-002	4.464e-002	3.e-002	-1.2013e-012
3261	2.2522e-002	4.464e-002	2.9e-002	-1.3546e-012
3262	2.2522e-002	4.464e-002	2.8e-002	-1.459e-012
3263	2.2522e-002	4.464e-002	2.7e-002	-1.4736e-012
3264	2.2522e-002	4.464e-002	2.6e-002	-1.6212e-012
3265	2.2522e-002	4.464e-002	2.4e-002	-1.6934e-012
3266	2.2522e-002	4.464e-002	2.3e-002	-1.6152e-012
3267	2.2522e-002	4.464e-002	2.2e-002	-1.4684e-012
3268	2.2522e-002	4.464e-002	2.1e-002	-1.6471e-012
3269	2.2522e-002	4.464e-002	2.e-002	-1.389e-012
3270	2.2522e-002	4.464e-002	1.9e-002	-1.3411e-012
3271	2.2522e-002	4.464e-002	1.8e-002	-2.3452e-012
3272	-2.2522e-002	4.464e-002	3.4e-002	-1.5055e-011
3273	-2.163e-002	4.5079e-002	3.4e-002	-1.6463e-011
3274	-2.073e-002	4.55e-002	3.4e-002	-1.6321e-011
3275	-1.9821e-002	4.5904e-002	3.4e-002	-1.3501e-011
3276	-1.8904e-002	4.6288e-002	3.4e-002	-1.2343e-011
3277	-1.798e-002	4.6655e-002	3.4e-002	-9.3285e-012
3278	-1.7049e-002	4.7003e-002	3.4e-002	-5.0092e-012
3279	-1.6111e-002	4.7333e-002	3.4e-002	-3.2603e-012
3280	-1.5167e-002	4.7644e-002	3.4e-002	1.287e-012
3281	-1.4217e-002	4.7936e-002	3.4e-002	3.2932e-012
3282	-1.3261e-002	4.8209e-002	3.4e-002	4.5985e-012
3283	-1.23e-002	4.8464e-002	3.4e-002	7.2045e-012
3284	-1.1334e-002	4.8699e-002	3.4e-002	7.4341e-012
3285	-1.0363e-002	4.8914e-002	3.4e-002	7.5582e-012
3286	-9.3888e-003	4.9111e-002	3.4e-002	7.4714e-012
3287	-8.4104e-003	4.9288e-002	3.4e-002	7.3862e-012
3288	-7.4289e-003	4.9445e-002	3.4e-002	7.4134e-012
3289	-6.4442e-003	4.9583e-002	3.4e-002	7.8789e-012
3290	-5.4573e-003	4.9701e-002	3.4e-002	8.3093e-012
3291	-4.4679e-003	4.98e-002	3.4e-002	8.817e-012
3292	-3.477e-003	4.9879e-002	3.4e-002	9.0471e-012
3293	-2.4845e-003	4.9938e-002	3.4e-002	9.1877e-012
3294	-1.4912e-003	4.9978e-002	3.4e-002	9.0333e-012
3295	-4.9717e-004	4.9998e-002	3.4e-002	8.7568e-012
3296	4.9687e-004	4.9998e-002	3.4e-002	8.3215e-012
3297	1.491e-003	4.9978e-002	3.4e-002	7.8516e-012
3298	2.4842e-003	4.9938e-002	3.4e-002	7.2652e-012
3299	3.4767e-003	4.9879e-002	3.4e-002	6.6947e-012
3300	4.4676e-003	4.98e-002	3.4e-002	6.0849e-012
3301	5.457e-003	4.9701e-002	3.4e-002	5.5129e-012
3302	6.444e-003	4.9583e-002	3.4e-002	4.929e-012
3303	7.4286e-003	4.9445e-002	3.4e-002	4.3721e-012
3304	8.4101e-003	4.9288e-002	3.4e-002	3.8267e-012
3305	9.3885e-003	4.9111e-002	3.4e-002	3.3107e-012
3306	1.0363e-002	4.8914e-002	3.4e-002	2.8543e-012
3307	1.1334e-002	4.8699e-002	3.4e-002	2.4397e-012
3308	1.2299e-002	4.8464e-002	3.4e-002	2.0356e-012
3309	1.3261e-002	4.8209e-002	3.4e-002	1.56e-012
3310	1.4216e-002	4.7936e-002	3.4e-002	1.2736e-012
3311	1.5167e-002	4.7644e-002	3.4e-002	1.0182e-012
3312	1.6111e-002	4.7333e-002	3.4e-002	4.3321e-013
3313	1.7049e-002	4.7004e-002	3.4e-002	1.1775e-012
3314	1.798e-002	4.6655e-002	3.4e-002	-9.5234e-014
3315	1.8904e-002	4.6289e-002	3.4e-002	-1.5046e-013
3316	1.9821e-002	4.5904e-002	3.4e-002	4.8882e-013
3317	2.073e-002	4.55e-002	3.4e-002	-6.529e-013
3318	2.163e-002	4.5079e-002	3.4e-002	-4.1937e-013
3319	-2.3417e-002	4.4177e-002	2.3998e-002	-6.0072e-012
3320	-2.343e-002	4.417e-002	2.3001e-002	-2.222e-011
3321	-2.3441e-002	4.4165e-002	2.2009e-002	-4.6055e-011
3322	-2.2522e-002	4.464e-002	3.3e-002	-1.407e-011
3323	-2.2522e-002	4.464e-002	3.2e-002	-1.3078e-011
3324	-2.2523e-002	4.464e-002	3.1e-002	-1.1126e-011
3325	-2.2523e-002	4.464e-002	3.e-002	-9.5364e-012
3326	-2.2523e-002	4.464e-002	2.9e-002	-9.0962e-012
3327	-2.2523e-002	4.464e-002	2.8e-002	-1.0218e-011
3328	-2.2523e-002	4.464e-002	2.7e-002	-2.2486e-012
3329	-2.2523e-002	4.464e-002	2.6e-002	-1.2951e-012
3330	-2.2523e-002	4.464e-002	2.5e-002	-6.6551e-011
3331	-2.2523e-002	4.464e-002	2.4e-002	-9.1411e-011
3332	-2.163e-002	4.5079e-002	1.7e-002	2.8713e-011
3333	-2.163e-002	4.5079e-002	1.8e-002	1.0907e-011
3334	-2.163e-002	4.5079e-002	1.9e-002	-1.1938e-011
3335	-2.163e-002	4.5079e-002	2.e-002	-1.1874e-011
3336	-2.1638e-002	4.5075e-002	2.1001e-002	-1.0219e-011
3337	2.163e-002	4.5079e-002	1.7e-002	-2.6518e-012
3338	2.073e-002	4.55e-002	1.7e-002	-1.6231e-012
3339	1.8904e-002	4.6289e-002	1.7e-002	-1.4097e-012
3340	1.798e-002	4.6655e-002	1.7e-002	-2.3993e-012
3341	1.7049e-002	4.7003e-002	1.7e-002	-1.1336e-012
3342	1.6111e-002	4.7333e-002	1.7e-002	-2.1488e-012
3343	1.5167e-002	4.7644e-002	1.7e-002	-2.2018e-012
3344	1.4217e-002	4.7936e-002	1.7e-002	-1.4819e-012
3345	1.3261e-002	4.8209e-002	1.7e-002	-1.2246e-012
3346	1.23e-002	4.8464e-002	1.7e-002	-2.1606e-012
3347	1.1334e-002	4.8699e-002	1.7e-002	-1.1795e-012
3348	1.0363e-002	4.8914e-002	1.7e-002	-1.4367e-012
3349	9.3886e-003	4.9111e-002	1.7e-002	-1.6398e-012
3350	8.4104e-003	4.9288e-002	1.7e-002	-1.2692e-012
3351	7.4287e-003	4.9445e-002	1.7e-002	-1.44e-012
3352	6.4442e-003	4.9583e-002	1.7e-002	-1.4639e-012
3353	5.4571e-003	4.9701e-002	1.7e-002	-1.4074e-012
3354	4.4679e-003	4.98e-002	1.7e-002	-1.4824e-012
3355	3.4768e-003	4.9879e-002	1.7e-002	-1.4949e-012
3356	2.4845e-003	4.9938e-002	1.7e-002	-1.5543e-012
3357	1.4911e-003	4.9978e-002	1.7e-002	-1.5794e-012
3358	4.9715e-004	4.9998e-002	1.7e-002	-1.5555e-012
3359	-4.9704e-004	4.9998e-002	1.7e-002	-1.5863e-012
3360	-1.491e-003	4.9978e-002	1.7e-002	-1.4817e-012
3361	-2.4844e-003	4.9938e-002	1.7e-002	-1.4731e-012
3362	-3.4767e-003	4.9879e-002	1.7e-002	-1.3135e-012
3363	-4.4678e-003	4.98e-002	1.7e-002	-1.3568e-012
3364	-5.457e-003	4.9701e-002	1.7e-002	-1.4457e-012
3365	-6.4441e-003	4.9583e-002	1.7e-002	-1.7851e-012
3366	-7.4286e-003	4.9445e-002	1.7e-002	-2.4393e-012
3367	-8.4103e-003	4.9288e-002	1.7e-002	-3.0107e-012
3368	-9.3885e-003	4.9111e-002	1.7e-002	-3.3279e-012
3369	-1.0363e-002	4.8914e-002	1.7e-002	-3.711e-012
3370	-1.1334e-002	4.8699e-002	1.7e-002	-2.3088e-012
3371	-1.23e-002	4.8464e-002	1.7e-002	-1.8163e-012
3372	-1.3261e-002	4.8209e-002	1.7e-002	-8.7891e-013
3373	-1.4217e-002	4.7936e-002	1.7e-002	-5.6674e-013
3374	-1.5167e-002	4.7644e-002	1.7e-002	-5.433e-013
3375	-1.6111e-002	4.7333e-002	1.7e-002	-3.6932e-013
3376	-1.7049e-002	4.7004e-002	1.7e-002	7.5128e-013
3377	-1.798e-002	4.6655e-002	1.7e-002	1.9986e-012
3378	-1.8904e-002	4.6289e-002	1.7e-002	5.1282e-012
3379	-2.073e-002	4.55e-002	1.7e-002	8.194e-012
3380	2.163e-002	4.5079e-002	3.3e-002	-5.9565e-013
3381	2.163e-002	4.5079e-002	3.2e-002	-8.639e-013
3382	2.163e-002	4.5079e-002	3.1e-002	-8.0269e-013
3383	2.163e-002	4.5079e-002	3.e-002	-9.3267e-013
3384	2.163e-002	4.5079e-002	2.9e-002	-1.0256e-012
3385	2.163e-002	4.5079e-002	2.8e-002	-9.4376e-013
3386	2.163e-002	4.5079e-002	2.7e-002	-1.1036e-012
3387	2.163e-002	4.5079e-002	2.6e-002	-1.3245e-012
3388	2.163e-002	4.5079e-002	2.5e-002	-1.4232e-012
3389	2.163e-002	4.5079e-002	2.4e-002	-1.4054e-012
3390	2.163e-002	4.5079e-002	2.3e-002	-1.4368e-012
3391	2.163e-002	4.5079e-002	2.2e-002	-1.6496e-012
3392	2.1631e-002	4.5079e-002	2.e-002	-1.6134e-012
3393	2.1631e-002	4.5079e-002	1.9e-002	-2.6723e-012
3394	2.1631e-002	4.5079e-002	1.8e-002	-2.3009e-012
3395	-2.2538e-002	4.4632e-002	2.2001e-002	2.7181e-011
3396	-2.2534e-002	4.4634e-002	2.3e-002	-3.1639e-011
3397	-2.163e-002	4.5079e-002	3.3e-002	-1.5269e-011
3398	-2.073e-002	4.55e-002	3.3e-002	-1.4211e-011
3399	-1.9821e-002	4.5903e-002	3.3e-002	-1.1802e-011
3400	-1.8904e-002	4.6288e-002	3.3e-002	-1.0044e-011
3401	-1.798e-002	4.6655e-002	3.3e-002	-6.9861e-012
3402	-1.7049e-002	4.7003e-002	3.3e-002	-3.9806e-012
3403	-1.6111e-002	4.7333e-002	3.3e-002	-7.5344e-013
3404	-1.5167e-002	4.7644e-002	3.3e-002	2.0605e-012
3405	-1.4217e-002	4.7936e-002	3.3e-002	4.7145e-012
3406	-1.3261e-002	4.8209e-002	3.3e-002	6.3687e-012
3407	-1.23e-002	4.8464e-002	3.3e-002	8.1991e-012
3408	-1.1334e-002	4.8699e-002	3.3e-002	8.1976e-012
3409	-1.0363e-002	4.8914e-002	3.3e-002	7.9335e-012
3410	-9.3888e-003	4.9111e-002	3.3e-002	7.6217e-012
3411	-8.4104e-003	4.9288e-002	3.3e-002	7.2822e-012
3412	-7.4289e-003	4.9445e-002	3.3e-002	7.599e-012
3413	-6.4442e-003	4.9583e-002	3.3e-002	8.1978e-012
3414	-5.4573e-003	4.9701e-002	3.3e-002	8.8841e-012
3415	-4.4679e-003	4.98e-002	3.3e-002	9.5099e-012
3416	-3.477e-003	4.9879e-002	3.3e-002	9.7633e-012
3417	-2.4845e-003	4.9938e-002	3.3e-002	9.7909e-012
3418	-1.4912e-003	4.9978e-002	3.3e-002	9.5883e-012
3419	-4.9717e-004	4.9998e-002	3.3e-002	9.1634e-012
3420	4.9688e-004	4.9998e-002	3.3e-002	8.6669e-012
3421	1.491e-003	4.9978e-002	3.3e-002	8.073e-012
3422	2.4842e-003	4.9938e-002	3.3e-002	7.4621e-012
3423	3.4767e-003	4.9879e-002	3.3e-002	6.776e-012
3424	4.4676e-003	4.98e-002	3.3e-002	6.2129e-012
3425	5.457e-003	4.9701e-002	3.3e-002	5.514e-012
3426	6.444e-003	4.9583e-002	3.3e-002	4.9579e-012
3427	7.4286e-003	4.9445e-002	3.3e-002	4.3056e-012
3428	8.4101e-003	4.9288e-002	3.3e-002	3.8634e-012
3429	9.3885e-003	4.9111e-002	3.3e-002	3.2517e-012
3430	1.0363e-002	4.8914e-002	3.3e-002	2.9245e-012
3431	1.1334e-002	4.8699e-002	3.3e-002	2.1504e-012
3432	1.2299e-002	4.8464e-002	3.3e-002	2.2537e-012
3433	1.3261e-002	4.8209e-002	3.3e-002	1.4577e-012
3434	1.4216e-002	4.7936e-002	3.3e-002	9.8318e-013
3435	1.5167e-002	4.7644e-002	3.3e-002	1.0768e-012
3436	1.6111e-002	4.7333e-002	3.3e-002	1.0491e-012
3437	1.7049e-002	4.7004e-002	3.3e-002	1.2677e-014
3438	1.798e-002	4.6655e-002	3.3e-002	3.6233e-013
3439	1.8904e-002	4.6289e-002	3.3e-002	1.328e-013
3440	1.9821e-002	4.5904e-002	3.3e-002	-2.7241e-013
3441	2.073e-002	4.55e-002	3.3e-002	-3.5616e-013
3442	-2.163e-002	4.5079e-002	3.2e-002	-1.2939e-011
3443	-2.163e-002	4.5079e-002	3.1e-002	-1.0394e-011
3444	-2.163e-002	4.5079e-002	3.e-002	-8.4752e-012
3445	-2.163e-002	4.5079e-002	2.8e-002	-6.8736e-012
3446	-2.163e-002	4.5079e-002	2.7e-002	-9.7094e-012
3447	-2.163e-002	4.5079e-002	2.6e-002	-1.1505e-011
3448	2.073e-002	4.55e-002	1.8e-002	-5.7061e-013
3449	1.9821e-002	4.5903e-002	1.8e-002	-2.2841e-012
3450	1.8904e-002	4.6289e-002	1.8e-002	-3.4043e-012
3451	1.798e-002	4.6655e-002	1.8e-002	-1.0418e-012
3452	1.7049e-002	4.7003e-002	1.8e-002	-1.9506e-012
3453	1.5167e-002	4.7644e-002	1.8e-002	-2.6402e-012
3454	1.4217e-002	4.7936e-002	1.8e-002	-6.8375e-013
3455	1.3261e-002	4.8209e-002	1.8e-002	-1.2547e-012
3456	1.23e-002	4.8464e-002	1.8e-002	-2.6744e-012
3457	1.1334e-002	4.8699e-002	1.8e-002	-7.6104e-013
3458	1.0363e-002	4.8914e-002	1.8e-002	-1.0663e-012
3459	9.3887e-003	4.9111e-002	1.8e-002	-1.6471e-012
3460	8.4104e-003	4.9288e-002	1.8e-002	-1.064e-012
3461	7.4288e-003	4.9445e-002	1.8e-002	-1.2086e-012
3462	6.4442e-003	4.9583e-002	1.8e-002	-1.0341e-012
3463	5.4571e-003	4.9701e-002	1.8e-002	-1.3454e-012
3464	4.4679e-003	4.98e-002	1.8e-002	-1.0859e-012
3465	3.4769e-003	4.9879e-002	1.8e-002	-1.1933e-012
3466	2.4845e-003	4.9938e-002	1.8e-002	-1.1428e-012
3467	1.4911e-003	4.9978e-002	1.8e-002	-1.1837e-012
3468	4.9716e-004	4.9998e-002	1.8e-002	-1.1046e-012
3469	-4.9701e-004	4.9998e-002	1.8e-002	-1.0698e-012
3470	-1.491e-003	4.9978e-002	1.8e-002	-9.7811e-013
3471	-2.4843e-003	4.9938e-002	1.8e-002	-7.8716e-013
3472	-3.4767e-003	4.9879e-002	1.8e-002	-6.3225e-013
3473	-4.4677e-003	4.98e-002	1.8e-002	-3.713e-013
3474	-5.457e-003	4.9701e-002	1.8e-002	-3.1926e-013
3475	-6.4441e-003	4.9583e-002	1.8e-002	-5.8334e-013
3476	-7.4286e-003	4.9445e-002	1.8e-002	-3.0676e-013
3477	-8.4102e-003	4.9288e-002	1.8e-002	-1.5004e-012
3478	-9.3885e-003	4.9111e-002	1.8e-002	-1.6899e-012
3479	-1.0363e-002	4.8914e-002	1.8e-002	-6.0699e-013
3480	-1.1334e-002	4.8699e-002	1.8e-002	-1.5461e-012
3481	-1.23e-002	4.8464e-002	1.8e-002	6.7857e-013
3482	-1.3261e-002	4.8209e-002	1.8e-002	1.4447e-012
3483	-1.4217e-002	4.7936e-002	1.8e-002	7.0521e-013
3484	-1.5167e-002	4.7644e-002	1.8e-002	6.5123e-013
3485	-1.6111e-002	4.7333e-002	1.8e-002	5.0821e-013
3486	-1.7049e-002	4.7004e-002	1.8e-002	1.2196e-012
3487	-1.798e-002	4.6655e-002	1.8e-002	3.0632e-012
3488	-1.9821e-002	4.5904e-002	1.8e-002	1.1459e-011
3489	-2.073e-002	4.55e-002	1.8e-002	8.9125e-012
3490	-2.073e-002	4.55e-002	1.9e-002	2.0975e-011
3491	-2.073e-002	4.55e-002	2.e-002	1.1776e-011
3492	-2.073e-002	4.55e-002	2.1e-002	-1.3114e-011
3493	-2.163e-002	4.5079e-002	2.2e-002	-2.0209e-011
3494	-2.163e-002	4.5079e-002	2.3e-002	-3.2955e-011
3495	-2.163e-002	4.5079e-002	2.4e-002	-2.927e-011
3496	2.073e-002	4.55e-002	3.2e-002	1.7274e-013
3497	2.073e-002	4.55e-002	3.1e-002	-5.5304e-013
3498	2.073e-002	4.55e-002	3.e-002	-9.9205e-013
3499	2.073e-002	4.55e-002	2.8e-002	-1.1693e-012
3500	2.073e-002	4.55e-002	2.6e-002	-1.0245e-012
3501	2.073e-002	4.55e-002	2.5e-002	-1.2284e-012
3502	2.073e-002	4.55e-002	2.4e-002	-1.52e-012
3503	2.0729e-002	4.55e-002	2.3e-002	-1.3955e-012
3504	2.0729e-002	4.55e-002	2.2e-002	-1.0366e-012
3505	2.0729e-002	4.55e-002	2.1e-002	-1.7898e-012
3506	2.0729e-002	4.55e-002	2.e-002	-2.612e-012
3507	2.0729e-002	4.55e-002	1.9e-002	-1.4231e-012
3508	-1.9821e-002	4.5903e-002	3.2e-002	-1.0054e-011
3509	-1.8904e-002	4.6288e-002	3.2e-002	-6.5724e-012
3510	-1.798e-002	4.6655e-002	3.2e-002	-3.9734e-012
3511	-1.7049e-002	4.7003e-002	3.2e-002	-2.1671e-012
3512	-1.6111e-002	4.7333e-002	3.2e-002	1.257e-012
3513	-1.5167e-002	4.7644e-002	3.2e-002	2.8952e-012
3514	-1.4217e-002	4.7936e-002	3.2e-002	6.4225e-012
3515	-1.3261e-002	4.8209e-002	3.2e-002	7.3578e-012
3516	-1.23e-002	4.8464e-002	3.2e-002	9.2703e-012
3517	-1.1334e-002	4.8699e-002	3.2e-002	8.8451e-012
3518	-1.0363e-002	4.8914e-002	3.2e-002	8.0843e-012
3519	-9.3888e-003	4.9111e-002	3.2e-002	7.2817e-012
3520	-8.4104e-003	4.9288e-002	3.2e-002	7.3559e-012
3521	-7.4289e-003	4.9445e-002	3.2e-002	7.7153e-012
3522	-6.4442e-003	4.9583e-002	3.2e-002	8.6954e-012
3523	-5.4573e-003	4.9701e-002	3.2e-002	9.5542e-012
3524	-4.4679e-003	4.98e-002	3.2e-002	1.0254e-011
3525	-3.477e-003	4.9879e-002	3.2e-002	1.0476e-011
3526	-2.4845e-003	4.9938e-002	3.2e-002	1.0331e-011
3527	-1.4912e-003	4.9978e-002	3.2e-002	9.9533e-012
3528	-4.9716e-004	4.9998e-002	3.2e-002	9.4627e-012
3529	4.9688e-004	4.9998e-002	3.2e-002	8.8463e-012
3530	1.491e-003	4.9978e-002	3.2e-002	8.1357e-012
3531	2.4842e-003	4.9938e-002	3.2e-002	7.5001e-012
3532	3.4767e-003	4.9879e-002	3.2e-002	6.7769e-012
3533	4.4676e-003	4.98e-002	3.2e-002	6.1472e-012
3534	5.457e-003	4.9701e-002	3.2e-002	5.4139e-012
3535	6.444e-003	4.9583e-002	3.2e-002	4.9042e-012
3536	7.4286e-003	4.9445e-002	3.2e-002	4.1859e-012
3537	8.4101e-003	4.9288e-002	3.2e-002	3.7865e-012
3538	9.3885e-003	4.9111e-002	3.2e-002	3.1146e-012
3539	1.0363e-002	4.8914e-002	3.2e-002	2.9477e-012
3540	1.1334e-002	4.8699e-002	3.2e-002	1.8997e-012
3541	1.2299e-002	4.8464e-002	3.2e-002	2.1627e-012
3542	1.3261e-002	4.8209e-002	3.2e-002	1.1407e-012
3543	1.4216e-002	4.7936e-002	3.2e-002	1.5399e-012
3544	1.5167e-002	4.7644e-002	3.2e-002	7.7961e-013
3545	1.6111e-002	4.7333e-002	3.2e-002	1.0981e-012
3546	1.7049e-002	4.7004e-002	3.2e-002	-7.1058e-013
3547	1.798e-002	4.6655e-002	3.2e-002	1.0002e-012
3548	1.8904e-002	4.6289e-002	3.2e-002	-1.0104e-013
3549	1.9821e-002	4.5904e-002	3.2e-002	-1.105e-012
3550	-2.073e-002	4.55e-002	3.1e-002	-8.9059e-012
3551	-2.073e-002	4.55e-002	3.e-002	-6.8652e-012
3552	-2.073e-002	4.55e-002	2.9e-002	-4.9322e-012
3553	-2.073e-002	4.55e-002	2.8e-002	-4.6643e-012
3554	-2.073e-002	4.55e-002	2.7e-002	-5.1755e-012
3555	-2.073e-002	4.55e-002	2.6e-002	-1.0806e-011
3556	-2.073e-002	4.55e-002	2.5e-002	-2.1325e-011
3557	-2.073e-002	4.55e-002	2.4e-002	-2.3927e-011
3558	-1.9821e-002	4.5904e-002	1.9e-002	9.5041e-012
3559	-1.9821e-002	4.5904e-002	2.e-002	1.2732e-011
3560	-1.9821e-002	4.5904e-002	2.1e-002	1.3028e-011
3561	-2.073e-002	4.55e-002	2.2e-002	-1.6187e-011
3562	-2.073e-002	4.55e-002	2.3e-002	-1.759e-011
3563	1.9821e-002	4.5903e-002	1.9e-002	6.7043e-013
3564	1.8904e-002	4.6289e-002	1.9e-002	-3.9476e-012
3565	1.7049e-002	4.7003e-002	1.9e-002	-2.0726e-012
3566	1.6111e-002	4.7333e-002	1.9e-002	-6.3357e-013
3567	1.5167e-002	4.7644e-002	1.9e-002	-1.906e-012
3568	1.4217e-002	4.7936e-002	1.9e-002	-1.7933e-012
3569	1.3261e-002	4.8209e-002	1.9e-002	-1.2428e-012
3570	1.23e-002	4.8464e-002	1.9e-002	-1.6921e-012
3571	1.1334e-002	4.8699e-002	1.9e-002	-8.6868e-013
3572	1.0363e-002	4.8914e-002	1.9e-002	-1.0995e-012
3573	9.3887e-003	4.9111e-002	1.9e-002	-1.0309e-012
3574	8.4104e-003	4.9288e-002	1.9e-002	-1.1713e-012
3575	7.4288e-003	4.9445e-002	1.9e-002	-8.2543e-013
3576	6.4442e-003	4.9583e-002	1.9e-002	-6.3887e-013
3577	5.4571e-003	4.9701e-002	1.9e-002	-9.6858e-013
3578	4.4679e-003	4.98e-002	1.9e-002	-8.8512e-013
3579	3.4769e-003	4.9879e-002	1.9e-002	-6.7454e-013
3580	2.4845e-003	4.9938e-002	1.9e-002	-7.3456e-013
3581	1.4911e-003	4.9978e-002	1.9e-002	-6.5438e-013
3582	4.9715e-004	4.9998e-002	1.9e-002	-6.1415e-013
3583	-4.9702e-004	4.9998e-002	1.9e-002	-4.9573e-013
3584	-1.491e-003	4.9978e-002	1.9e-002	-3.7984e-013
3585	-2.4844e-003	4.9938e-002	1.9e-002	-1.6468e-013
3586	-3.4767e-003	4.9879e-002	1.9e-002	6.8903e-014
3587	-4.4678e-003	4.98e-002	1.9e-002	1.8829e-013
3588	-5.457e-003	4.9701e-002	1.9e-002	8.2137e-013
3589	-6.4441e-003	4.9583e-002	1.9e-002	8.9034e-013
3590	-7.4286e-003	4.9445e-002	1.9e-002	-2.148e-013
3591	-8.4103e-003	4.9288e-002	1.9e-002	3.096e-012
3592	-9.3885e-003	4.9111e-002	1.9e-002	1.7828e-012
3593	-1.0363e-002	4.8914e-002	1.9e-002	-7.8595e-013
3594	-1.1334e-002	4.8699e-002	1.9e-002	3.8694e-012
3595	-1.23e-002	4.8464e-002	1.9e-002	2.4275e-012
3596	-1.3261e-002	4.8209e-002	1.9e-002	1.9374e-012
3597	-1.4217e-002	4.7936e-002	1.9e-002	3.4614e-012
3598	-1.5167e-002	4.7644e-002	1.9e-002	1.5527e-012
3599	-1.6111e-002	4.7333e-002	1.9e-002	1.9841e-012
3600	-1.7049e-002	4.7004e-002	1.9e-002	2.1337e-012
3601	-1.798e-002	4.6655e-002	1.9e-002	2.7638e-012
3602	-1.8904e-002	4.6289e-002	1.9e-002	9.1886e-012
3603	1.9821e-002	4.5904e-002	3.1e-002	-4.256e-013
3604	1.9821e-002	4.5904e-002	3.e-002	-2.4494e-013
3605	1.9821e-002	4.5904e-002	2.9e-002	-5.5207e-013
3606	1.9821e-002	4.5904e-002	2.8e-002	-5.974e-013
3607	1.9821e-002	4.5904e-002	2.7e-002	-7.21e-013
3608	1.9821e-002	4.5904e-002	2.6e-002	-8.9207e-013
3609	1.9821e-002	4.5904e-002	2.5e-002	-7.6748e-013
3610	1.9821e-002	4.5904e-002	2.4e-002	-1.0293e-012
3611	1.9821e-002	4.5904e-002	2.3e-002	-2.1184e-012
3612	1.9821e-002	4.5904e-002	2.2e-002	-2.3123e-012
3613	1.9821e-002	4.5904e-002	2.1e-002	-2.03e-012
3614	1.9821e-002	4.5904e-002	2.e-002	-3.9003e-013
3615	-1.9821e-002	4.5903e-002	3.1e-002	-6.9166e-012
3616	-1.8904e-002	4.6288e-002	3.1e-002	-3.946e-012
3617	-1.798e-002	4.6655e-002	3.1e-002	-4.4144e-013
3618	-1.7049e-002	4.7003e-002	3.1e-002	9.5983e-013
3619	-1.6111e-002	4.7333e-002	3.1e-002	1.6847e-012
3620	-1.5167e-002	4.7644e-002	3.1e-002	5.5505e-012
3621	-1.4217e-002	4.7936e-002	3.1e-002	6.5184e-012
3622	-1.3261e-002	4.8209e-002	3.1e-002	6.9885e-012
3623	-1.23e-002	4.8464e-002	3.1e-002	1.0055e-011
3624	-1.1334e-002	4.8699e-002	3.1e-002	9.5286e-012
3625	-1.0363e-002	4.8914e-002	3.1e-002	8.295e-012
3626	-9.3888e-003	4.9111e-002	3.1e-002	6.725e-012
3627	-8.4104e-003	4.9288e-002	3.1e-002	7.4272e-012
3628	-7.4289e-003	4.9445e-002	3.1e-002	8.3987e-012
3629	-6.4443e-003	4.9583e-002	3.1e-002	9.1758e-012
3630	-5.4573e-003	4.9701e-002	3.1e-002	1.0298e-011
3631	-4.4679e-003	4.98e-002	3.1e-002	1.1032e-011
3632	-3.477e-003	4.9879e-002	3.1e-002	1.0975e-011
3633	-2.4845e-003	4.9938e-002	3.1e-002	1.0731e-011
3634	-1.4912e-003	4.9978e-002	3.1e-002	1.0148e-011
3635	-4.972e-004	4.9998e-002	3.1e-002	9.5171e-012
3636	4.9688e-004	4.9998e-002	3.1e-002	8.8099e-012
3637	1.4909e-003	4.9978e-002	3.1e-002	8.0467e-012
3638	2.4842e-003	4.9938e-002	3.1e-002	7.3654e-012
3639	3.4767e-003	4.9879e-002	3.1e-002	6.6081e-012
3640	4.4676e-003	4.98e-002	3.1e-002	5.9551e-012
3641	5.4569e-003	4.9701e-002	3.1e-002	5.2559e-012
3642	6.444e-003	4.9583e-002	3.1e-002	4.6834e-012
3643	7.4286e-003	4.9445e-002	3.1e-002	4.0519e-012
3644	8.4101e-003	4.9288e-002	3.1e-002	3.5502e-012
3645	9.3885e-003	4.9111e-002	3.1e-002	2.9703e-012
3646	1.0363e-002	4.8914e-002	3.1e-002	2.6836e-012
3647	1.1334e-002	4.8699e-002	3.1e-002	2.0577e-012
3648	1.2299e-002	4.8464e-002	3.1e-002	1.3346e-012
3649	1.3261e-002	4.8209e-002	3.1e-002	1.5659e-012
3650	1.4216e-002	4.7936e-002	3.1e-002	1.8852e-012
3651	1.5167e-002	4.7644e-002	3.1e-002	1.2729e-013
3652	1.6111e-002	4.7333e-002	3.1e-002	4.2322e-013
3653	1.7049e-002	4.7004e-002	3.1e-002	6.9414e-013
3654	1.798e-002	4.6655e-002	3.1e-002	-1.3641e-013
3655	1.8904e-002	4.6289e-002	3.1e-002	-4.8127e-013
3656	-1.9821e-002	4.5903e-002	3.e-002	-3.7128e-012
3657	-1.9821e-002	4.5903e-002	2.9e-002	-2.4507e-012
3658	-1.9821e-002	4.5903e-002	2.8e-002	-1.8319e-012
3659	-1.9821e-002	4.5903e-002	2.7e-002	-3.3898e-012
3660	-1.9821e-002	4.5903e-002	2.6e-002	-7.1023e-012
3661	-1.9821e-002	4.5903e-002	2.5e-002	-1.0188e-011
3662	-1.9821e-002	4.5904e-002	2.2e-002	-1.3391e-011
3663	-1.9821e-002	4.5904e-002	2.3e-002	-2.6984e-011
3664	-1.9821e-002	4.5903e-002	2.4e-002	-1.7238e-011
3665	-1.8904e-002	4.6289e-002	2.e-002	5.7622e-012
3666	-1.8904e-002	4.6289e-002	2.1e-002	-8.5189e-013
3667	1.8904e-002	4.6289e-002	2.e-002	-5.0924e-013
3668	1.798e-002	4.6655e-002	2.e-002	-3.8973e-012
3669	1.7049e-002	4.7003e-002	2.e-002	-8.9386e-013
3670	1.6111e-002	4.7333e-002	2.e-002	-1.5628e-012
3671	1.5167e-002	4.7644e-002	2.e-002	-9.7845e-013
3672	1.4217e-002	4.7936e-002	2.e-002	-2.3307e-012
3673	1.3261e-002	4.8209e-002	2.e-002	-1.6306e-012
3674	1.23e-002	4.8464e-002	2.e-002	-2.8139e-013
3675	1.1334e-002	4.8699e-002	2.e-002	-9.943e-013
3676	1.0363e-002	4.8914e-002	2.e-002	-8.7907e-013
3677	9.3887e-003	4.9111e-002	2.e-002	-1.1778e-012
3678	8.4104e-003	4.9288e-002	2.e-002	-4.1955e-013
3679	7.4288e-003	4.9445e-002	2.e-002	-7.2278e-013
3680	6.4442e-003	4.9583e-002	2.e-002	-2.7101e-013
3681	5.4571e-003	4.9701e-002	2.e-002	-3.9339e-013
3682	4.4679e-003	4.98e-002	2.e-002	-6.2584e-013
3683	3.4769e-003	4.9879e-002	2.e-002	-4.0554e-014
3684	2.4845e-003	4.9938e-002	2.e-002	-3.4081e-013
3685	1.4911e-003	4.9978e-002	2.e-002	1.435e-014
3686	4.9717e-004	4.9998e-002	2.e-002	-4.415e-014
3687	-4.9701e-004	4.9998e-002	2.e-002	1.4867e-013
3688	-1.491e-003	4.9978e-002	2.e-002	2.9944e-013
3689	-2.4843e-003	4.9938e-002	2.e-002	5.1594e-013
3690	-3.4767e-003	4.9879e-002	2.e-002	7.2329e-013
3691	-4.4678e-003	4.98e-002	2.e-002	1.0848e-012
3692	-5.457e-003	4.9701e-002	2.e-002	-1.9528e-013
3693	-6.4441e-003	4.9583e-002	2.e-002	2.8472e-012
3694	-7.4286e-003	4.9445e-002	2.e-002	1.2985e-012
3695	-8.4102e-003	4.9288e-002	2.e-002	7.8371e-013
3696	-9.3885e-003	4.9111e-002	2.e-002	1.2079e-011
3697	-1.0363e-002	4.8914e-002	2.e-002	1.014e-011
3698	-1.1334e-002	4.8699e-002	2.e-002	8.674e-013
3699	-1.23e-002	4.8464e-002	2.e-002	-5.2248e-014
3700	-1.3261e-002	4.8209e-002	2.e-002	4.8215e-012
3701	-1.4217e-002	4.7936e-002	2.e-002	4.7875e-012
3702	-1.5167e-002	4.7644e-002	2.e-002	3.5484e-012
3703	-1.6111e-002	4.7333e-002	2.e-002	3.3503e-012
3704	-1.7049e-002	4.7004e-002	2.e-002	2.8492e-012
3705	-1.798e-002	4.6655e-002	2.e-002	3.6367e-012
3706	1.8904e-002	4.6289e-002	3.e-002	-3.5321e-013
3707	1.8904e-002	4.6289e-002	2.9e-002	-5.3278e-013
3708	1.8904e-002	4.6289e-002	2.8e-002	-5.4648e-013
3709	1.8904e-002	4.6289e-002	2.7e-002	-4.895e-013
3710	1.8904e-002	4.6289e-002	2.5e-002	-8.9621e-013
3711	1.8904e-002	4.6289e-002	2.4e-002	3.3985e-013
3712	1.8904e-002	4.6289e-002	2.3e-002	1.2056e-012
3713	1.8904e-002	4.6289e-002	2.2e-002	-2.3584e-012
3714	-1.8904e-002	4.6288e-002	3.e-002	-1.2172e-012
3715	-1.798e-002	4.6655e-002	3.e-002	2.0763e-012
3716	-1.7049e-002	4.7003e-002	3.e-002	4.8483e-012
3717	-1.6111e-002	4.7333e-002	3.e-002	5.0004e-012
3718	-1.5167e-002	4.7644e-002	3.e-002	4.8644e-012
3719	-1.4217e-002	4.7936e-002	3.e-002	5.2802e-012
3720	-1.3261e-002	4.8209e-002	3.e-002	8.0899e-012
3721	-1.23e-002	4.8464e-002	3.e-002	6.4575e-012
3722	-1.1334e-002	4.8699e-002	3.e-002	1.0583e-011
3723	-1.0363e-002	4.8914e-002	3.e-002	8.8759e-012
3724	-9.3888e-003	4.9111e-002	3.e-002	6.4166e-012
3725	-8.4105e-003	4.9288e-002	3.e-002	1.0442e-011
3726	-7.4289e-003	4.9445e-002	3.e-002	7.9197e-012
3727	-6.4443e-003	4.9583e-002	3.e-002	9.5695e-012
3728	-5.4573e-003	4.9701e-002	3.e-002	1.1167e-011
3729	-4.468e-003	4.98e-002	3.e-002	1.1337e-011
3730	-3.477e-003	4.9879e-002	3.e-002	1.1339e-011
3731	-2.4846e-003	4.9938e-002	3.e-002	1.0745e-011
3732	-1.4912e-003	4.9978e-002	3.e-002	1.0076e-011
3733	-4.9723e-004	4.9998e-002	3.e-002	9.303e-012
3734	4.9688e-004	4.9998e-002	3.e-002	8.5493e-012
3735	1.4909e-003	4.9978e-002	3.e-002	7.7744e-012
3736	2.4842e-003	4.9938e-002	3.e-002	7.0428e-012
3737	3.4767e-003	4.9879e-002	3.e-002	6.3265e-012
3738	4.4676e-003	4.98e-002	3.e-002	5.6318e-012
3739	5.4569e-003	4.9701e-002	3.e-002	4.9744e-012
3740	6.444e-003	4.9583e-002	3.e-002	4.3904e-012
3741	7.4286e-003	4.9445e-002	3.e-002	3.7443e-012
3742	8.4101e-003	4.9288e-002	3.e-002	3.3279e-012
3743	9.3884e-003	4.9111e-002	3.e-002	2.7015e-012
3744	1.0363e-002	4.8914e-002	3.e-002	2.3865e-012
3745	1.1333e-002	4.8699e-002	3.e-002	1.8727e-012
3746	1.2299e-002	4.8464e-002	3.e-002	1.3766e-012
3747	1.3261e-002	4.821e-002	3.e-002	1.3776e-012
3748	1.4216e-002	4.7936e-002	3.e-002	1.4603e-012
3749	1.5167e-002	4.7644e-002	3.e-002	5.2764e-014
3750	1.6111e-002	4.7333e-002	3.e-002	4.4907e-013
3751	1.7049e-002	4.7004e-002	3.e-002	7.2244e-013
3752	1.798e-002	4.6655e-002	3.e-002	-6.859e-013
3753	-1.8904e-002	4.6289e-002	2.9e-002	1.9802e-012
3754	-1.8904e-002	4.6289e-002	2.8e-002	1.9621e-012
3755	-1.8904e-002	4.6289e-002	2.7e-002	-3.6771e-013
3756	-1.8904e-002	4.6289e-002	2.6e-002	-3.8324e-012
3757	-1.8904e-002	4.6289e-002	2.5e-002	-8.8086e-012
3758	-1.8904e-002	4.6289e-002	2.2e-002	-2.8169e-013
3759	-1.8904e-002	4.6289e-002	2.3e-002	-5.3353e-012
3760	-1.8904e-002	4.6289e-002	2.4e-002	-1.125e-011
3761	-1.798e-002	4.6655e-002	2.1e-002	3.9783e-012
3762	1.798e-002	4.6655e-002	2.1e-002	1.389e-012
3763	1.6111e-002	4.7333e-002	2.1e-002	-5.012e-012
3764	1.5167e-002	4.7644e-002	2.1e-002	8.861e-013
3765	1.4217e-002	4.7936e-002	2.1e-002	-1.3495e-012
3766	1.3261e-002	4.8209e-002	2.1e-002	-1.8042e-012
3767	1.23e-002	4.8464e-002	2.1e-002	-4.3258e-013
3768	1.1334e-002	4.8699e-002	2.1e-002	-5.5336e-013
3769	1.0363e-002	4.8914e-002	2.1e-002	-5.9557e-013
3770	8.4104e-003	4.9288e-002	2.1e-002	3.1685e-013
3771	7.4288e-003	4.9445e-002	2.1e-002	-6.528e-013
3772	6.4442e-003	4.9583e-002	2.1e-002	2.0752e-013
3773	5.4571e-003	4.9701e-002	2.1e-002	1.2529e-013
3774	4.4679e-003	4.98e-002	2.1e-002	-1.9655e-013
3775	3.4769e-003	4.9879e-002	2.1e-002	5.3715e-013
3776	2.4845e-003	4.9938e-002	2.1e-002	2.5394e-013
3777	1.4911e-003	4.9978e-002	2.1e-002	8.0041e-013
3778	4.9716e-004	4.9998e-002	2.1e-002	6.0294e-013
3779	-4.9701e-004	4.9998e-002	2.1e-002	8.7742e-013
3780	-1.491e-003	4.9978e-002	2.1e-002	1.125e-012
3781	-2.4843e-003	4.9938e-002	2.1e-002	1.2417e-012
3782	-3.4767e-003	4.9879e-002	2.1e-002	1.7591e-012
3783	-4.4677e-003	4.98e-002	2.1e-002	1.4917e-012
3784	-5.457e-003	4.9701e-002	2.1e-002	2.7264e-012
3785	-6.4441e-003	4.9583e-002	2.1e-002	-9.6136e-012
3786	-7.4286e-003	4.9445e-002	2.1e-002	1.4337e-011
3787	-8.4102e-003	4.9288e-002	2.1e-002	-1.2689e-011
3788	-9.3885e-003	4.9111e-002	2.1e-002	2.0565e-011
3789	-1.0363e-002	4.8914e-002	2.1e-002	7.3888e-011
3790	-1.1334e-002	4.8699e-002	2.1e-002	-4.3162e-011
3791	-1.23e-002	4.8464e-002	2.1e-002	-1.9188e-011
3792	-1.3261e-002	4.8209e-002	2.1e-002	2.395e-011
3793	-1.4217e-002	4.7936e-002	2.1e-002	4.1202e-013
3794	-1.5167e-002	4.7644e-002	2.1e-002	1.0873e-011
3795	-1.6111e-002	4.7333e-002	2.1e-002	2.3829e-012
3796	-1.7049e-002	4.7004e-002	2.1e-002	4.8317e-012
3797	1.798e-002	4.6655e-002	2.9e-002	3.2711e-014
3798	1.798e-002	4.6655e-002	2.8e-002	-3.8724e-014
3799	1.798e-002	4.6655e-002	2.7e-002	-2.0142e-013
3800	1.798e-002	4.6655e-002	2.6e-002	-4.6263e-013
3801	1.798e-002	4.6655e-002	2.5e-002	-7.0851e-013
3802	1.798e-002	4.6655e-002	2.4e-002	-2.6659e-012
3803	1.798e-002	4.6655e-002	2.2e-002	1.866e-012
3804	-1.798e-002	4.6655e-002	2.9e-002	2.9076e-012
3805	-1.7049e-002	4.7003e-002	2.9e-002	6.9197e-012
3806	-1.6111e-002	4.7333e-002	2.9e-002	1.5248e-011
3807	-1.5167e-002	4.7644e-002	2.9e-002	6.0744e-012
3808	-1.4217e-002	4.7936e-002	2.9e-002	-4.5112e-013
3809	-1.3261e-002	4.8209e-002	2.9e-002	2.5975e-012
3810	-1.23e-002	4.8464e-002	2.9e-002	-5.6059e-012
3811	-1.1334e-002	4.8699e-002	2.9e-002	1.4405e-011
3812	-1.0363e-002	4.8914e-002	2.9e-002	2.0373e-011
3813	-9.3888e-003	4.9111e-002	2.9e-002	9.329e-012
3814	-8.4105e-003	4.9288e-002	2.9e-002	9.3131e-012
3815	-7.4289e-003	4.9445e-002	2.9e-002	5.3796e-012
3816	-6.4443e-003	4.9583e-002	2.9e-002	1.2876e-011
3817	-5.4573e-003	4.9701e-002	2.9e-002	8.7939e-012
3818	-4.468e-003	4.98e-002	2.9e-002	1.1858e-011
3819	-3.477e-003	4.9879e-002	2.9e-002	1.1412e-011
3820	-2.4846e-003	4.9938e-002	2.9e-002	1.028e-011
3821	-1.4912e-003	4.9978e-002	2.9e-002	9.6428e-012
3822	-4.9726e-004	4.9998e-002	2.9e-002	8.795e-012
3823	4.9689e-004	4.9998e-002	2.9e-002	8.0407e-012
3824	1.4909e-003	4.9978e-002	2.9e-002	7.4215e-012
3825	2.4842e-003	4.9938e-002	2.9e-002	6.5204e-012
3826	3.4766e-003	4.9879e-002	2.9e-002	5.8001e-012
3827	4.4676e-003	4.98e-002	2.9e-002	5.3155e-012
3828	5.4569e-003	4.9701e-002	2.9e-002	4.5816e-012
3829	6.444e-003	4.9583e-002	2.9e-002	3.9148e-012
3830	7.4285e-003	4.9445e-002	2.9e-002	3.4588e-012
3831	8.4101e-003	4.9288e-002	2.9e-002	2.9426e-012
3832	9.3884e-003	4.9111e-002	2.9e-002	2.5119e-012
3833	1.0363e-002	4.8914e-002	2.9e-002	2.0049e-012
3834	1.1333e-002	4.8699e-002	2.9e-002	1.4841e-012
3835	1.2299e-002	4.8464e-002	2.9e-002	1.8852e-012
3836	1.3261e-002	4.821e-002	2.9e-002	5.462e-013
3837	1.4216e-002	4.7936e-002	2.9e-002	5.8365e-013
3838	1.5167e-002	4.7644e-002	2.9e-002	1.2573e-012
3839	1.6111e-002	4.7333e-002	2.9e-002	-2.791e-013
3840	1.7049e-002	4.7004e-002	2.9e-002	2.8378e-014
3841	-1.798e-002	4.6655e-002	2.8e-002	3.1994e-012
3842	-1.798e-002	4.6655e-002	2.7e-002	9.0303e-013
3843	-1.798e-002	4.6655e-002	2.6e-002	-3.6644e-013
3844	-1.798e-002	4.6655e-002	2.5e-002	-1.0449e-012
3845	1.7049e-002	4.7003e-002	2.2e-002	-1.677e-012
3846	1.6111e-002	4.7333e-002	2.2e-002	-3.1267e-012
3847	1.5167e-002	4.7644e-002	2.2e-002	-1.2462e-012
3848	1.4217e-002	4.7936e-002	2.2e-002	5.7751e-014
3849	1.3261e-002	4.8209e-002	2.2e-002	-8.6704e-013
3850	1.23e-002	4.8464e-002	2.2e-002	-1.3745e-012
3851	1.0363e-002	4.8914e-002	2.2e-002	-2.1924e-013
3852	9.3887e-003	4.9111e-002	2.2e-002	-4.2678e-013
3853	8.4104e-003	4.9288e-002	2.2e-002	5.9222e-013
3854	7.4288e-003	4.9445e-002	2.2e-002	-6.9991e-013
3855	6.4442e-003	4.9583e-002	2.2e-002	1.337e-012
3856	5.4571e-003	4.9701e-002	2.2e-002	6.1004e-013
3857	4.4679e-003	4.98e-002	2.2e-002	-8.1102e-014
3858	2.4845e-003	4.9938e-002	2.2e-002	1.7231e-012
3859	4.9716e-004	4.9998e-002	2.2e-002	1.3015e-012
3860	-1.491e-003	4.9978e-002	2.2e-002	1.9796e-012
3861	-3.4767e-003	4.9879e-002	2.2e-002	2.0449e-012
3862	-5.457e-003	4.9701e-002	2.2e-002	9.089e-013
3863	-7.4286e-003	4.9445e-002	2.2e-002	-7.4574e-011
3864	-9.3885e-003	4.9111e-002	2.2e-002	5.1749e-011
3865	-1.1334e-002	4.8699e-002	2.2e-002	1.0197e-010
3866	-1.3261e-002	4.8209e-002	2.2e-002	-2.9455e-011
3867	-1.4217e-002	4.7936e-002	2.2e-002	4.9223e-011
3868	-1.5167e-002	4.7644e-002	2.2e-002	-5.9311e-012
3869	-1.6111e-002	4.7333e-002	2.2e-002	1.4941e-011
3870	-1.7049e-002	4.7004e-002	2.2e-002	2.6417e-012
3871	-1.798e-002	4.6655e-002	2.2e-002	1.3048e-012
3872	-1.798e-002	4.6655e-002	2.3e-002	-1.42e-012
3873	-1.798e-002	4.6655e-002	2.4e-002	-2.8956e-012
3874	1.7049e-002	4.7004e-002	2.8e-002	3.5218e-014
3875	1.7049e-002	4.7004e-002	2.7e-002	-6.3173e-013
3876	1.7049e-002	4.7004e-002	2.6e-002	4.5916e-014
3877	1.7049e-002	4.7004e-002	2.5e-002	1.9767e-013
3878	1.7049e-002	4.7004e-002	2.4e-002	-2.3371e-012
3879	1.7049e-002	4.7004e-002	2.3e-002	-2.3121e-012
3880	-1.7049e-002	4.7003e-002	2.8e-002	7.897e-012
3881	-1.6111e-002	4.7333e-002	2.8e-002	1.0459e-011
3882	-1.5167e-002	4.7644e-002	2.8e-002	4.9732e-011
3883	-1.3261e-002	4.8209e-002	2.8e-002	-7.5792e-011
3884	-1.23e-002	4.8464e-002	2.8e-002	5.2543e-011
3885	-1.1334e-002	4.8699e-002	2.8e-002	-2.4604e-011
3886	-1.0363e-002	4.8914e-002	2.8e-002	3.1813e-011
3887	-8.4106e-003	4.9288e-002	2.8e-002	-4.212e-011
3888	-6.4444e-003	4.9583e-002	2.8e-002	1.855e-012
3889	-5.4573e-003	4.9701e-002	2.8e-002	9.3072e-012
3890	-4.4681e-003	4.98e-002	2.8e-002	1.2309e-011
3891	-3.477e-003	4.9879e-002	2.8e-002	1.0028e-011
3892	-2.4846e-003	4.9938e-002	2.8e-002	9.9471e-012
3893	-1.4912e-003	4.9978e-002	2.8e-002	8.8108e-012
3894	-4.9731e-004	4.9998e-002	2.8e-002	7.9505e-012
3895	4.9689e-004	4.9998e-002	2.8e-002	7.43e-012
3896	1.4908e-003	4.9978e-002	2.8e-002	6.6882e-012
3897	2.4842e-003	4.9938e-002	2.8e-002	6.1525e-012
3898	3.4766e-003	4.9879e-002	2.8e-002	5.1686e-012
3899	4.4676e-003	4.98e-002	2.8e-002	4.5569e-012
3900	5.4568e-003	4.9701e-002	2.8e-002	4.1578e-012
3901	6.444e-003	4.9583e-002	2.8e-002	3.4913e-012
3902	7.4285e-003	4.9445e-002	2.8e-002	3.3985e-012
3903	8.4101e-003	4.9288e-002	2.8e-002	2.1236e-012
3904	9.3884e-003	4.9111e-002	2.8e-002	2.1211e-012
3905	1.0363e-002	4.8914e-002	2.8e-002	2.0037e-012
3906	1.1333e-002	4.8699e-002	2.8e-002	1.0149e-012
3907	1.2299e-002	4.8464e-002	2.8e-002	2.048e-012
3908	1.3261e-002	4.821e-002	2.8e-002	3.8855e-013
3909	1.4216e-002	4.7936e-002	2.8e-002	-7.5317e-013
3910	1.5167e-002	4.7644e-002	2.8e-002	1.8977e-012
3911	1.6111e-002	4.7333e-002	2.8e-002	-6.3145e-013
3912	-1.7049e-002	4.7003e-002	2.7e-002	8.5289e-012
3913	-1.7049e-002	4.7003e-002	2.6e-002	-4.5924e-012
3914	-1.7049e-002	4.7003e-002	2.5e-002	-9.332e-012
3915	-1.7049e-002	4.7003e-002	2.3e-002	4.9714e-012
3916	-1.7049e-002	4.7003e-002	2.4e-002	5.0753e-012
3917	1.6111e-002	4.7333e-002	2.3e-002	3.9336e-012
3918	1.5167e-002	4.7644e-002	2.3e-002	-4.2592e-012
3919	1.4217e-002	4.7936e-002	2.3e-002	-1.6091e-012
3920	1.3261e-002	4.8209e-002	2.3e-002	1.8127e-012
3921	1.23e-002	4.8464e-002	2.3e-002	-1.8175e-012
3922	1.1334e-002	4.8699e-002	2.3e-002	-2.115e-013
3923	1.0363e-002	4.8914e-002	2.3e-002	5.3302e-013
3924	9.3887e-003	4.9111e-002	2.3e-002	1.0789e-013
3925	7.4288e-003	4.9445e-002	2.3e-002	-3.7364e-013
3926	6.4443e-003	4.9583e-002	2.3e-002	2.2887e-012
3927	5.4571e-003	4.9701e-002	2.3e-002	1.5684e-012
3928	4.4679e-003	4.98e-002	2.3e-002	-8.4239e-013
3929	3.4769e-003	4.9879e-002	2.3e-002	2.9932e-012
3930	2.4845e-003	4.9938e-002	2.3e-002	2.6046e-012
3931	1.4911e-003	4.9978e-002	2.3e-002	9.4391e-013
3932	4.9718e-004	4.9998e-002	2.3e-002	2.8097e-012
3933	-4.9701e-004	4.9998e-002	2.3e-002	2.9092e-012
3934	-1.4909e-003	4.9978e-002	2.3e-002	2.8922e-012
3935	-2.4843e-003	4.9938e-002	2.3e-002	4.0872e-012
3936	-3.4767e-003	4.9879e-002	2.3e-002	3.1955e-012
3937	-4.4677e-003	4.98e-002	2.3e-002	6.7117e-012
3938	-5.457e-003	4.9701e-002	2.3e-002	2.157e-012
3939	-6.4441e-003	4.9583e-002	2.3e-002	3.2646e-011
3940	-7.4286e-003	4.9445e-002	2.3e-002	-7.3951e-011
3941	-8.4102e-003	4.9288e-002	2.3e-002	7.9456e-011
3942	-9.3885e-003	4.9111e-002	2.3e-002	7.6416e-011
3943	-1.0366e-002	4.8914e-002	2.3011e-002	-1.563e-010
3944	-1.1338e-002	4.8698e-002	2.3012e-002	1.0596e-010
3945	-1.23e-002	4.8464e-002	2.3e-002	1.0836e-010
3946	-1.3261e-002	4.8209e-002	2.3e-002	-1.2001e-010
3947	-1.4217e-002	4.7936e-002	2.3e-002	-1.2225e-011
3948	-1.5167e-002	4.7644e-002	2.3e-002	5.1241e-011
3949	-1.6111e-002	4.7333e-002	2.3e-002	-1.3281e-012
3950	1.6111e-002	4.7333e-002	2.7e-002	2.1954e-012
3951	1.6111e-002	4.7333e-002	2.6e-002	5.9148e-013
3952	1.6111e-002	4.7333e-002	2.5e-002	-4.8288e-012
3953	1.6111e-002	4.7333e-002	2.4e-002	3.1914e-013
3954	-1.6111e-002	4.7333e-002	2.7e-002	-9.4466e-012
3955	-1.5167e-002	4.7644e-002	2.7e-002	6.219e-011
3956	-1.4217e-002	4.7936e-002	2.7e-002	3.0938e-012
3957	-1.3261e-002	4.8209e-002	2.7e-002	-7.1652e-011
3958	-1.23e-002	4.8464e-002	2.7e-002	6.9502e-011
3959	-1.1334e-002	4.8699e-002	2.7e-002	-1.8026e-011
3960	-1.0363e-002	4.8914e-002	2.7e-002	-6.8943e-011
3961	-9.3888e-003	4.9111e-002	2.7e-002	1.1014e-010
3962	-8.4106e-003	4.9288e-002	2.7e-002	5.0963e-011
3963	-7.4289e-003	4.9445e-002	2.7e-002	-4.5431e-011
3964	-6.4443e-003	4.9583e-002	2.7e-002	9.8593e-012
3965	-5.4572e-003	4.9701e-002	2.7e-002	1.4657e-011
3966	-4.4681e-003	4.98e-002	2.7e-002	9.9726e-012
3967	-3.477e-003	4.9879e-002	2.7e-002	8.355e-012
3968	-2.4847e-003	4.9938e-002	2.7e-002	9.1589e-012
3969	-1.4912e-003	4.9978e-002	2.7e-002	7.721e-012
3970	-4.9732e-004	4.9998e-002	2.7e-002	7.3701e-012
3971	4.9689e-004	4.9998e-002	2.7e-002	6.6528e-012
3972	1.4908e-003	4.9978e-002	2.7e-002	4.9894e-012
3973	2.4842e-003	4.9938e-002	2.7e-002	5.6556e-012
3974	3.4766e-003	4.9879e-002	2.7e-002	7.0157e-012
3975	4.4676e-003	4.98e-002	2.7e-002	5.7398e-013
3976	5.4568e-003	4.9701e-002	2.7e-002	3.7517e-012
3977	6.444e-003	4.9583e-002	2.7e-002	5.6917e-012
3978	7.4285e-003	4.9445e-002	2.7e-002	5.3733e-013
3979	8.4101e-003	4.9288e-002	2.7e-002	3.6939e-012
3980	9.3884e-003	4.9111e-002	2.7e-002	-6.0216e-013
3981	1.0363e-002	4.8914e-002	2.7e-002	1.7191e-012
3982	1.1333e-002	4.8699e-002	2.7e-002	5.1627e-012
3983	1.2299e-002	4.8464e-002	2.7e-002	-4.1873e-012
3984	1.3261e-002	4.821e-002	2.7e-002	3.8046e-012
3985	1.4216e-002	4.7936e-002	2.7e-002	-1.5837e-013
3986	1.5167e-002	4.7644e-002	2.7e-002	-2.4251e-012
3987	-1.6111e-002	4.7333e-002	2.6e-002	1.3975e-011
3988	-1.6111e-002	4.7333e-002	2.5e-002	1.7615e-011
3989	-1.6111e-002	4.7333e-002	2.4e-002	-2.1029e-011
3990	1.5167e-002	4.7644e-002	2.4e-002	2.5991e-012
3991	1.4217e-002	4.7936e-002	2.4e-002	-3.7147e-012
3992	1.3261e-002	4.8209e-002	2.4e-002	-1.5165e-012
3993	1.23e-002	4.8464e-002	2.4e-002	5.3012e-012
3994	1.1334e-002	4.8699e-002	2.4e-002	-5.1114e-012
3995	1.0363e-002	4.8914e-002	2.4e-002	3.4446e-013
3996	9.3887e-003	4.9111e-002	2.4e-002	3.7292e-012
3997	8.4104e-003	4.9288e-002	2.4e-002	-1.7322e-012
3998	7.4288e-003	4.9445e-002	2.4e-002	3.7388e-012
3999	6.4443e-003	4.9583e-002	2.4e-002	-1.3217e-012
4000	5.4571e-003	4.9701e-002	2.4e-002	2.1793e-012
4001	4.468e-003	4.98e-002	2.4e-002	4.1591e-012
4002	3.4769e-003	4.9879e-002	2.4e-002	1.4273e-012
4003	2.4846e-003	4.9938e-002	2.4e-002	2.0877e-012
4004	1.4911e-003	4.9978e-002	2.4e-002	2.9669e-012
4005	4.9722e-004	4.9998e-002	2.4e-002	4.0668e-012
4006	-4.9702e-004	4.9998e-002	2.4e-002	3.3795e-012
4007	-1.4909e-003	4.9978e-002	2.4e-002	4.3662e-012
4008	-2.4844e-003	4.9938e-002	2.4e-002	4.8166e-012
4009	-3.4767e-003	4.9879e-002	2.4e-002	7.0753e-012
4010	-4.4678e-003	4.98e-002	2.4e-002	4.7008e-012
4011	-5.457e-003	4.9701e-002	2.4e-002	1.6711e-011
4012	-6.4441e-003	4.9583e-002	2.4e-002	-1.324e-011
4013	-7.4286e-003	4.9445e-002	2.4e-002	1.8816e-010
4014	-8.4103e-003	4.9288e-002	2.4e-002	-1.9686e-010
4015	-9.399e-003	4.9109e-002	2.4005e-002	-3.6341e-011
4016	-1.0373e-002	4.8912e-002	2.4013e-002	1.7218e-010
4017	-1.1345e-002	4.8696e-002	2.4013e-002	-1.7086e-010
4018	-1.2309e-002	4.8461e-002	2.4009e-002	2.1877e-010
4019	-1.4217e-002	4.7936e-002	2.4e-002	-1.0085e-010
4020	-1.5167e-002	4.7644e-002	2.4e-002	6.4008e-011
4021	1.5167e-002	4.7644e-002	2.6e-002	-3.6887e-012
4022	1.5167e-002	4.7644e-002	2.5e-002	3.9055e-012
4023	-1.5167e-002	4.7644e-002	2.6e-002	-8.5545e-011
4024	-1.4217e-002	4.7936e-002	2.6e-002	8.2698e-011
4025	-1.3269e-002	4.8207e-002	2.6003e-002	1.4822e-010
4026	-1.2311e-002	4.8461e-002	2.6008e-002	-1.7242e-010
4027	-1.0371e-002	4.8913e-002	2.6008e-002	-1.0238e-010
4028	-9.3888e-003	4.9111e-002	2.6e-002	-4.5594e-011
4029	-8.4106e-003	4.9288e-002	2.6e-002	1.9214e-010
4030	-7.429e-003	4.9445e-002	2.6e-002	-9.2214e-011
4031	-6.4442e-003	4.9583e-002	2.6e-002	4.1509e-011
4032	-5.4572e-003	4.9701e-002	2.6e-002	1.0194e-011
4033	-4.4681e-003	4.98e-002	2.6e-002	9.3163e-012
4034	-3.477e-003	4.9879e-002	2.6e-002	8.1977e-012
4035	-2.4847e-003	4.9938e-002	2.6e-002	7.1363e-012
4036	-1.4912e-003	4.9978e-002	2.6e-002	6.8259e-012
4037	-4.9733e-004	4.9998e-002	2.6e-002	6.5435e-012
4038	4.9691e-004	4.9998e-002	2.6e-002	5.0467e-012
4039	1.4908e-003	4.9978e-002	2.6e-002	5.0368e-012
4040	2.4842e-003	4.9938e-002	2.6e-002	4.3712e-012
4041	3.4766e-003	4.9879e-002	2.6e-002	4.7143e-012
4042	4.4676e-003	4.98e-002	2.6e-002	2.4867e-012
4043	5.4568e-003	4.9701e-002	2.6e-002	2.6183e-012
4044	6.444e-003	4.9583e-002	2.6e-002	4.0369e-012
4045	7.4285e-003	4.9445e-002	2.6e-002	3.7941e-013
4046	8.4102e-003	4.9288e-002	2.6e-002	3.7092e-012
4047	9.3884e-003	4.9111e-002	2.6e-002	-5.0779e-013
4048	1.0363e-002	4.8914e-002	2.6e-002	2.1079e-013
4049	1.1333e-002	4.8699e-002	2.6e-002	5.5169e-012
4050	1.2299e-002	4.8464e-002	2.6e-002	-4.8295e-012
4051	1.3261e-002	4.821e-002	2.6e-002	2.2429e-012
4052	1.4216e-002	4.7936e-002	2.6e-002	2.646e-012
4053	-1.5167e-002	4.7644e-002	2.5e-002	-1.0421e-010
4054	1.4217e-002	4.7936e-002	2.5e-002	6.0081e-013
4055	-1.4217e-002	4.7936e-002	2.5e-002	3.6691e-011
4056	-1.3271e-002	4.8207e-002	2.5003e-002	2.0162e-010
4057	1.3261e-002	4.8209e-002	2.5e-002	-4.784e-012
4058	1.23e-002	4.8464e-002	2.5e-002	6.6448e-012
4059	1.1334e-002	4.8699e-002	2.5e-002	-4.0451e-012
4060	1.0363e-002	4.8914e-002	2.5e-002	-4.581e-013
4061	9.3887e-003	4.9111e-002	2.5e-002	4.3487e-012
4062	8.4104e-003	4.9288e-002	2.5e-002	-1.0889e-012
4063	7.4288e-003	4.9445e-002	2.5e-002	5.2284e-012
4064	5.457e-003	4.9701e-002	2.5e-002	1.857e-012
4065	4.468e-003	4.98e-002	2.5e-002	8.803e-012
4066	3.4769e-003	4.9879e-002	2.5e-002	-8.0374e-013
4067	2.4845e-003	4.9938e-002	2.5e-002	2.635e-012
4068	1.4911e-003	4.9978e-002	2.5e-002	5.7261e-012
4069	-4.9702e-004	4.9998e-002	2.5e-002	4.6559e-012
4070	-1.4909e-003	4.9978e-002	2.5e-002	5.8852e-012
4071	-2.4844e-003	4.9938e-002	2.5e-002	5.3949e-012
4072	-3.4767e-003	4.9879e-002	2.5e-002	8.8781e-012
4073	-4.4677e-003	4.98e-002	2.5e-002	7.5636e-012
4074	-5.457e-003	4.9701e-002	2.5e-002	1.3771e-011
4075	-6.4441e-003	4.9583e-002	2.5e-002	1.394e-012
4076	-7.4285e-003	4.9445e-002	2.5e-002	1.5211e-010
4077	-8.4103e-003	4.9288e-002	2.5e-002	-7.6864e-011
4078	-9.3984e-003	4.9109e-002	2.5004e-002	-1.6248e-010
4079	-1.0377e-002	4.8911e-002	2.501e-002	1.8308e-010
4080	-1.1346e-002	4.8696e-002	2.5011e-002	-2.1744e-011"""
    writer = System.IO.StreamWriter(filePath, False)
    writer.WriteLine(fileContents)
    writer.Close()
    fileRef = task.RegisterFile(filePath)
    fileRefs.Add(fileRef)
    #region xy strain
    filePath = System.IO.Path.Combine(workingDirectory, "StrainXY.txt")
    fileContents = r"""Node Number	X Location (m)	Y Location (m)	Z Location (m)	Shear Elastic Strain (m/m)
1	-3.5355e-002	3.5355e-002	5.e-002	-4.6937e-005
2	3.5355e-002	3.5355e-002	5.e-002	4.6937e-005
3	-3.4645e-002	3.6051e-002	5.e-002	-4.687e-005
4	-3.3922e-002	3.6733e-002	5.e-002	-4.6701e-005
5	-3.3185e-002	3.74e-002	5.e-002	-4.646e-005
6	-3.2435e-002	3.8053e-002	5.e-002	-4.6146e-005
7	-3.1672e-002	3.869e-002	5.e-002	-4.5762e-005
8	-3.0896e-002	3.9312e-002	5.e-002	-4.5308e-005
9	-3.0108e-002	3.9918e-002	5.e-002	-4.4784e-005
10	-2.9309e-002	4.0509e-002	5.e-002	-4.4192e-005
11	-2.8498e-002	4.1084e-002	5.e-002	-4.3533e-005
12	-2.7675e-002	4.1642e-002	5.e-002	-4.2807e-005
13	-2.6842e-002	4.2184e-002	5.e-002	-4.2016e-005
14	-2.5998e-002	4.271e-002	5.e-002	-4.1162e-005
15	-2.5143e-002	4.3218e-002	5.e-002	-4.0246e-005
16	-2.4279e-002	4.371e-002	5.e-002	-3.9268e-005
17	-2.3405e-002	4.4184e-002	5.e-002	-3.8232e-005
18	-2.2522e-002	4.464e-002	5.e-002	-3.7138e-005
19	-2.163e-002	4.5079e-002	5.e-002	-3.5989e-005
20	-2.073e-002	4.55e-002	5.e-002	-3.4786e-005
21	-1.9821e-002	4.5904e-002	5.e-002	-3.3531e-005
22	-1.8904e-002	4.6289e-002	5.e-002	-3.2225e-005
23	-1.798e-002	4.6655e-002	5.e-002	-3.0872e-005
24	-1.7049e-002	4.7003e-002	5.e-002	-2.9472e-005
25	-1.6111e-002	4.7333e-002	5.e-002	-2.8029e-005
26	-1.5167e-002	4.7644e-002	5.e-002	-2.6545e-005
27	-1.4217e-002	4.7936e-002	5.e-002	-2.502e-005
28	-1.3261e-002	4.8209e-002	5.e-002	-2.3459e-005
29	-1.23e-002	4.8464e-002	5.e-002	-2.1863e-005
30	-1.1334e-002	4.8699e-002	5.e-002	-2.0235e-005
31	-1.0363e-002	4.8914e-002	5.e-002	-1.8577e-005
32	-9.3886e-003	4.9111e-002	5.e-002	-1.6891e-005
33	-8.4103e-003	4.9288e-002	5.e-002	-1.5181e-005
34	-7.4287e-003	4.9445e-002	5.e-002	-1.3448e-005
35	-6.4442e-003	4.9583e-002	5.e-002	-1.1695e-005
36	-5.4571e-003	4.9701e-002	5.e-002	-9.925e-006
37	-4.4678e-003	4.98e-002	5.e-002	-8.1404e-006
38	-3.4768e-003	4.9879e-002	5.e-002	-6.3439e-006
39	-2.4844e-003	4.9938e-002	5.e-002	-4.538e-006
40	-1.491e-003	4.9978e-002	5.e-002	-2.7255e-006
41	-4.9708e-004	4.9998e-002	5.e-002	-9.0894e-007
42	4.9708e-004	4.9998e-002	5.e-002	9.0895e-007
43	1.491e-003	4.9978e-002	5.e-002	2.7255e-006
44	2.4844e-003	4.9938e-002	5.e-002	4.538e-006
45	3.4768e-003	4.9879e-002	5.e-002	6.3439e-006
46	4.4678e-003	4.98e-002	5.e-002	8.1404e-006
47	5.4571e-003	4.9701e-002	5.e-002	9.925e-006
48	6.4442e-003	4.9583e-002	5.e-002	1.1695e-005
49	7.4287e-003	4.9445e-002	5.e-002	1.3448e-005
50	8.4103e-003	4.9288e-002	5.e-002	1.5181e-005
51	9.3886e-003	4.9111e-002	5.e-002	1.6891e-005
52	1.0363e-002	4.8914e-002	5.e-002	1.8577e-005
53	1.1334e-002	4.8699e-002	5.e-002	2.0235e-005
54	1.23e-002	4.8464e-002	5.e-002	2.1863e-005
55	1.3261e-002	4.8209e-002	5.e-002	2.3459e-005
56	1.4217e-002	4.7936e-002	5.e-002	2.502e-005
57	1.5167e-002	4.7644e-002	5.e-002	2.6545e-005
58	1.6111e-002	4.7333e-002	5.e-002	2.8029e-005
59	1.7049e-002	4.7003e-002	5.e-002	2.9472e-005
60	1.798e-002	4.6655e-002	5.e-002	3.0872e-005
61	1.8904e-002	4.6289e-002	5.e-002	3.2225e-005
62	1.9821e-002	4.5904e-002	5.e-002	3.3531e-005
63	2.073e-002	4.55e-002	5.e-002	3.4786e-005
64	2.163e-002	4.5079e-002	5.e-002	3.5989e-005
65	2.2522e-002	4.464e-002	5.e-002	3.7139e-005
66	2.3405e-002	4.4184e-002	5.e-002	3.8232e-005
67	2.4279e-002	4.371e-002	5.e-002	3.9268e-005
68	2.5143e-002	4.3218e-002	5.e-002	4.0246e-005
69	2.5998e-002	4.271e-002	5.e-002	4.1162e-005
70	2.6842e-002	4.2184e-002	5.e-002	4.2016e-005
71	2.7675e-002	4.1642e-002	5.e-002	4.2807e-005
72	2.8498e-002	4.1084e-002	5.e-002	4.3533e-005
73	2.9309e-002	4.0509e-002	5.e-002	4.4192e-005
74	3.0108e-002	3.9918e-002	5.e-002	4.4784e-005
75	3.0896e-002	3.9312e-002	5.e-002	4.5308e-005
76	3.1672e-002	3.869e-002	5.e-002	4.5762e-005
77	3.2435e-002	3.8053e-002	5.e-002	4.6147e-005
78	3.3185e-002	3.74e-002	5.e-002	4.646e-005
79	3.3922e-002	3.6733e-002	5.e-002	4.6701e-005
80	3.4645e-002	3.6051e-002	5.e-002	4.6871e-005
81	3.5355e-002	3.5355e-002	0.	4.6935e-005
82	3.5355e-002	3.5355e-002	4.9e-002	4.6936e-005
83	3.5355e-002	3.5355e-002	4.8e-002	4.6937e-005
84	3.5355e-002	3.5355e-002	4.7e-002	4.6937e-005
85	3.5355e-002	3.5355e-002	4.6e-002	4.6937e-005
86	3.5355e-002	3.5355e-002	4.5e-002	4.6937e-005
87	3.5355e-002	3.5355e-002	4.4e-002	4.6937e-005
88	3.5355e-002	3.5355e-002	4.3e-002	4.6937e-005
89	3.5355e-002	3.5355e-002	4.2e-002	4.6937e-005
90	3.5355e-002	3.5355e-002	4.1e-002	4.6937e-005
91	3.5355e-002	3.5355e-002	4.e-002	4.6937e-005
92	3.5355e-002	3.5355e-002	3.9e-002	4.6937e-005
93	3.5355e-002	3.5355e-002	3.8e-002	4.6937e-005
94	3.5355e-002	3.5355e-002	3.7e-002	4.6937e-005
95	3.5355e-002	3.5355e-002	3.6e-002	4.6937e-005
96	3.5355e-002	3.5355e-002	3.5e-002	4.6937e-005
97	3.5355e-002	3.5355e-002	3.4e-002	4.6937e-005
98	3.5355e-002	3.5355e-002	3.3e-002	4.6937e-005
99	3.5355e-002	3.5355e-002	3.2e-002	4.6937e-005
100	3.5355e-002	3.5355e-002	3.1e-002	4.6937e-005
101	3.5355e-002	3.5355e-002	3.e-002	4.6937e-005
102	3.5355e-002	3.5355e-002	2.9e-002	4.6937e-005
103	3.5355e-002	3.5355e-002	2.8e-002	4.6937e-005
104	3.5355e-002	3.5355e-002	2.7e-002	4.6937e-005
105	3.5355e-002	3.5355e-002	2.6e-002	4.6937e-005
106	3.5355e-002	3.5355e-002	2.5e-002	4.6937e-005
107	3.5355e-002	3.5355e-002	2.4e-002	4.6937e-005
108	3.5355e-002	3.5355e-002	2.3e-002	4.6937e-005
109	3.5355e-002	3.5355e-002	2.2e-002	4.6937e-005
110	3.5355e-002	3.5355e-002	2.1e-002	4.6937e-005
111	3.5355e-002	3.5355e-002	2.e-002	4.6937e-005
112	3.5355e-002	3.5355e-002	1.9e-002	4.6937e-005
113	3.5355e-002	3.5355e-002	1.8e-002	4.6937e-005
114	3.5355e-002	3.5355e-002	1.7e-002	4.6937e-005
115	3.5355e-002	3.5355e-002	1.6e-002	4.6937e-005
116	3.5355e-002	3.5355e-002	1.5e-002	4.6937e-005
117	3.5355e-002	3.5355e-002	1.4e-002	4.6937e-005
118	3.5355e-002	3.5355e-002	1.3e-002	4.6937e-005
119	3.5355e-002	3.5355e-002	1.2e-002	4.6937e-005
120	3.5355e-002	3.5355e-002	1.1e-002	4.6937e-005
121	3.5355e-002	3.5355e-002	1.e-002	4.6937e-005
122	3.5355e-002	3.5355e-002	9.e-003	4.6937e-005
123	3.5355e-002	3.5355e-002	8.e-003	4.6937e-005
124	3.5355e-002	3.5355e-002	7.e-003	4.6937e-005
125	3.5355e-002	3.5355e-002	6.e-003	4.6937e-005
126	3.5355e-002	3.5355e-002	5.e-003	4.6937e-005
127	3.5355e-002	3.5355e-002	4.e-003	4.6937e-005
128	3.5355e-002	3.5355e-002	3.e-003	4.6937e-005
129	3.5355e-002	3.5355e-002	2.e-003	4.6937e-005
130	3.5355e-002	3.5355e-002	1.e-003	4.6938e-005
131	-3.5355e-002	3.5355e-002	0.	-4.6937e-005
132	3.4645e-002	3.6051e-002	0.	4.6871e-005
133	3.3922e-002	3.6733e-002	0.	4.6702e-005
134	3.3185e-002	3.74e-002	0.	4.646e-005
135	3.2435e-002	3.8053e-002	0.	4.6147e-005
136	3.1672e-002	3.869e-002	0.	4.5763e-005
137	3.0896e-002	3.9312e-002	0.	4.5308e-005
138	3.0108e-002	3.9918e-002	0.	4.4784e-005
139	2.9309e-002	4.0509e-002	0.	4.4192e-005
140	2.8498e-002	4.1084e-002	0.	4.3533e-005
141	2.7675e-002	4.1642e-002	0.	4.2807e-005
142	2.6842e-002	4.2184e-002	0.	4.2016e-005
143	2.5998e-002	4.271e-002	0.	4.1162e-005
144	2.5143e-002	4.3218e-002	0.	4.0246e-005
145	2.4279e-002	4.371e-002	0.	3.9269e-005
146	2.3405e-002	4.4184e-002	0.	3.8232e-005
147	2.2522e-002	4.464e-002	0.	3.7139e-005
148	2.163e-002	4.5079e-002	0.	3.5989e-005
149	2.073e-002	4.55e-002	0.	3.4786e-005
150	1.9821e-002	4.5904e-002	0.	3.3531e-005
151	1.8904e-002	4.6289e-002	0.	3.2225e-005
152	1.798e-002	4.6655e-002	0.	3.0872e-005
153	1.7049e-002	4.7003e-002	0.	2.9473e-005
154	1.6111e-002	4.7333e-002	0.	2.8029e-005
155	1.5167e-002	4.7644e-002	0.	2.6545e-005
156	1.4217e-002	4.7936e-002	0.	2.502e-005
157	1.3261e-002	4.8209e-002	0.	2.3459e-005
158	1.23e-002	4.8464e-002	0.	2.1863e-005
159	1.1334e-002	4.8699e-002	0.	2.0235e-005
160	1.0363e-002	4.8914e-002	0.	1.8577e-005
161	9.3886e-003	4.9111e-002	0.	1.6891e-005
162	8.4103e-003	4.9288e-002	0.	1.5181e-005
163	7.4287e-003	4.9445e-002	0.	1.3448e-005
164	6.4442e-003	4.9583e-002	0.	1.1695e-005
165	5.4571e-003	4.9701e-002	0.	9.925e-006
166	4.4678e-003	4.98e-002	0.	8.1404e-006
167	3.4768e-003	4.9879e-002	0.	6.3439e-006
168	2.4844e-003	4.9938e-002	0.	4.538e-006
169	1.491e-003	4.9978e-002	0.	2.7255e-006
170	4.9708e-004	4.9998e-002	0.	9.0894e-007
171	-4.9708e-004	4.9998e-002	0.	-9.0895e-007
172	-1.491e-003	4.9978e-002	0.	-2.7255e-006
173	-2.4844e-003	4.9938e-002	0.	-4.538e-006
174	-3.4768e-003	4.9879e-002	0.	-6.3439e-006
175	-4.4678e-003	4.98e-002	0.	-8.1405e-006
176	-5.4571e-003	4.9701e-002	0.	-9.925e-006
177	-6.4442e-003	4.9583e-002	0.	-1.1695e-005
178	-7.4287e-003	4.9445e-002	0.	-1.3448e-005
179	-8.4103e-003	4.9288e-002	0.	-1.5181e-005
180	-9.3886e-003	4.9111e-002	0.	-1.6891e-005
181	-1.0363e-002	4.8914e-002	0.	-1.8577e-005
182	-1.1334e-002	4.8699e-002	0.	-2.0235e-005
183	-1.23e-002	4.8464e-002	0.	-2.1863e-005
184	-1.3261e-002	4.8209e-002	0.	-2.3459e-005
185	-1.4217e-002	4.7936e-002	0.	-2.502e-005
186	-1.5167e-002	4.7644e-002	0.	-2.6545e-005
187	-1.6111e-002	4.7333e-002	0.	-2.8029e-005
188	-1.7049e-002	4.7003e-002	0.	-2.9473e-005
189	-1.798e-002	4.6655e-002	0.	-3.0872e-005
190	-1.8904e-002	4.6289e-002	0.	-3.2225e-005
191	-1.9821e-002	4.5904e-002	0.	-3.3531e-005
192	-2.073e-002	4.55e-002	0.	-3.4786e-005
193	-2.163e-002	4.5079e-002	0.	-3.5989e-005
194	-2.2522e-002	4.464e-002	0.	-3.7139e-005
195	-2.3405e-002	4.4184e-002	0.	-3.8232e-005
196	-2.4279e-002	4.371e-002	0.	-3.9269e-005
197	-2.5143e-002	4.3218e-002	0.	-4.0246e-005
198	-2.5998e-002	4.271e-002	0.	-4.1162e-005
199	-2.6842e-002	4.2184e-002	0.	-4.2016e-005
200	-2.7675e-002	4.1642e-002	0.	-4.2807e-005
201	-2.8498e-002	4.1084e-002	0.	-4.3533e-005
202	-2.9309e-002	4.0509e-002	0.	-4.4192e-005
203	-3.0108e-002	3.9918e-002	0.	-4.4784e-005
204	-3.0896e-002	3.9312e-002	0.	-4.5308e-005
205	-3.1672e-002	3.869e-002	0.	-4.5763e-005
206	-3.2435e-002	3.8053e-002	0.	-4.6147e-005
207	-3.3185e-002	3.74e-002	0.	-4.646e-005
208	-3.3922e-002	3.6733e-002	0.	-4.6702e-005
209	-3.4645e-002	3.6051e-002	0.	-4.6871e-005
210	-3.5355e-002	3.5355e-002	1.e-003	-4.6937e-005
211	-3.5355e-002	3.5355e-002	2.e-003	-4.6937e-005
212	-3.5355e-002	3.5355e-002	3.e-003	-4.6937e-005
213	-3.5355e-002	3.5355e-002	4.e-003	-4.6937e-005
214	-3.5355e-002	3.5355e-002	5.e-003	-4.6937e-005
215	-3.5355e-002	3.5355e-002	6.e-003	-4.6937e-005
216	-3.5355e-002	3.5355e-002	7.e-003	-4.6937e-005
217	-3.5355e-002	3.5355e-002	8.e-003	-4.6937e-005
218	-3.5355e-002	3.5355e-002	9.e-003	-4.6937e-005
219	-3.5355e-002	3.5355e-002	1.e-002	-4.6937e-005
220	-3.5355e-002	3.5355e-002	1.1e-002	-4.6937e-005
221	-3.5355e-002	3.5355e-002	1.2e-002	-4.6937e-005
222	-3.5355e-002	3.5355e-002	1.3e-002	-4.6937e-005
223	-3.5355e-002	3.5355e-002	1.4e-002	-4.6937e-005
224	-3.5355e-002	3.5355e-002	1.5e-002	-4.6937e-005
225	-3.5355e-002	3.5355e-002	1.6e-002	-4.6937e-005
226	-3.5355e-002	3.5355e-002	1.7e-002	-4.6937e-005
227	-3.5355e-002	3.5355e-002	1.8e-002	-4.6937e-005
228	-3.5355e-002	3.5355e-002	1.9e-002	-4.6937e-005
229	-3.5355e-002	3.5355e-002	2.e-002	-4.6936e-005
230	-3.5355e-002	3.5355e-002	2.1e-002	-4.6936e-005
231	-3.5355e-002	3.5355e-002	2.2e-002	-4.6936e-005
232	-3.5355e-002	3.5355e-002	2.3e-002	-4.6937e-005
233	-3.5355e-002	3.5355e-002	2.4e-002	-4.6937e-005
234	-3.5355e-002	3.5355e-002	2.5e-002	-4.6937e-005
235	-3.5355e-002	3.5355e-002	2.6e-002	-4.6937e-005
236	-3.5355e-002	3.5355e-002	2.7e-002	-4.6937e-005
237	-3.5355e-002	3.5355e-002	2.8e-002	-4.6937e-005
238	-3.5355e-002	3.5355e-002	2.9e-002	-4.6937e-005
239	-3.5355e-002	3.5355e-002	3.e-002	-4.6937e-005
240	-3.5355e-002	3.5355e-002	3.1e-002	-4.6937e-005
241	-3.5355e-002	3.5355e-002	3.2e-002	-4.6937e-005
242	-3.5355e-002	3.5355e-002	3.3e-002	-4.6937e-005
243	-3.5355e-002	3.5355e-002	3.4e-002	-4.6937e-005
244	-3.5355e-002	3.5355e-002	3.5e-002	-4.6937e-005
245	-3.5355e-002	3.5355e-002	3.6e-002	-4.6937e-005
246	-3.5355e-002	3.5355e-002	3.7e-002	-4.6937e-005
247	-3.5355e-002	3.5355e-002	3.8e-002	-4.6937e-005
248	-3.5355e-002	3.5355e-002	3.9e-002	-4.6937e-005
249	-3.5355e-002	3.5355e-002	4.e-002	-4.6937e-005
250	-3.5355e-002	3.5355e-002	4.1e-002	-4.6937e-005
251	-3.5355e-002	3.5355e-002	4.2e-002	-4.6937e-005
252	-3.5355e-002	3.5355e-002	4.3e-002	-4.6937e-005
253	-3.5355e-002	3.5355e-002	4.4e-002	-4.6937e-005
254	-3.5355e-002	3.5355e-002	4.5e-002	-4.6937e-005
255	-3.5355e-002	3.5355e-002	4.6e-002	-4.6937e-005
256	-3.5355e-002	3.5355e-002	4.7e-002	-4.6937e-005
257	-3.5355e-002	3.5355e-002	4.8e-002	-4.6937e-005
258	-3.5355e-002	3.5355e-002	4.9e-002	-4.6936e-005
259	3.4641e-002	3.6055e-002	4.e-003	4.687e-005
260	-3.4641e-002	3.6055e-002	2.e-003	-4.687e-005
261	3.4641e-002	3.6055e-002	4.8e-002	4.687e-005
262	-2.8498e-002	4.1084e-002	4.8e-002	-4.3533e-005
263	-2.6842e-002	4.2184e-002	4.8e-002	-4.2016e-005
264	-2.5143e-002	4.3218e-002	4.8e-002	-4.0246e-005
265	-2.3405e-002	4.4184e-002	4.8e-002	-3.8232e-005
266	-2.163e-002	4.5079e-002	4.8e-002	-3.5989e-005
267	-1.9821e-002	4.5904e-002	4.8e-002	-3.3531e-005
268	-1.798e-002	4.6655e-002	4.8e-002	-3.0872e-005
269	-1.6111e-002	4.7333e-002	4.8e-002	-2.8029e-005
270	-1.4217e-002	4.7936e-002	4.8e-002	-2.502e-005
271	-1.23e-002	4.8464e-002	4.8e-002	-2.1863e-005
272	-1.0363e-002	4.8914e-002	4.8e-002	-1.8577e-005
273	-8.4103e-003	4.9288e-002	4.8e-002	-1.5181e-005
274	-6.4442e-003	4.9583e-002	4.8e-002	-1.1695e-005
275	-4.4678e-003	4.98e-002	4.8e-002	-8.1404e-006
276	-2.4844e-003	4.9938e-002	4.8e-002	-4.538e-006
277	-4.9707e-004	4.9998e-002	4.8e-002	-9.0893e-007
278	1.491e-003	4.9978e-002	4.8e-002	2.7255e-006
279	3.4768e-003	4.9879e-002	4.8e-002	6.3439e-006
280	5.4571e-003	4.9701e-002	4.8e-002	9.925e-006
281	7.4287e-003	4.9445e-002	4.8e-002	1.3448e-005
282	9.3886e-003	4.9111e-002	4.8e-002	1.6891e-005
283	1.1334e-002	4.8699e-002	4.8e-002	2.0235e-005
284	1.3261e-002	4.8209e-002	4.8e-002	2.3459e-005
285	1.5167e-002	4.7644e-002	4.8e-002	2.6545e-005
286	1.7049e-002	4.7003e-002	4.8e-002	2.9473e-005
287	1.8904e-002	4.6289e-002	4.8e-002	3.2225e-005
288	2.073e-002	4.55e-002	4.8e-002	3.4786e-005
289	2.2522e-002	4.464e-002	4.8e-002	3.7139e-005
290	2.4279e-002	4.371e-002	4.8e-002	3.9268e-005
291	2.5998e-002	4.271e-002	4.8e-002	4.1162e-005
292	2.7675e-002	4.1642e-002	4.8e-002	4.2807e-005
293	2.9309e-002	4.0509e-002	4.8e-002	4.4192e-005
294	3.0896e-002	3.9312e-002	4.8e-002	4.5308e-005
295	-3.1672e-002	3.869e-002	2.e-003	-4.5763e-005
296	-3.3185e-002	3.74e-002	4.7e-002	-4.646e-005
297	-3.0896e-002	3.9312e-002	4.e-003	-4.5308e-005
298	3.2433e-002	3.8054e-002	6.e-003	4.6146e-005
299	-3.0108e-002	3.9919e-002	4.6e-002	-4.4784e-005
300	-2.6842e-002	4.2184e-002	4.6e-002	-4.2016e-005
301	2.9309e-002	4.0509e-002	4.6e-002	4.4192e-005
302	2.4279e-002	4.371e-002	4.e-003	3.9269e-005
303	2.2522e-002	4.464e-002	4.e-003	3.7139e-005
304	2.073e-002	4.55e-002	4.e-003	3.4786e-005
305	1.8904e-002	4.6289e-002	4.e-003	3.2225e-005
306	1.7049e-002	4.7003e-002	4.e-003	2.9473e-005
307	1.5167e-002	4.7644e-002	4.e-003	2.6545e-005
308	1.3261e-002	4.8209e-002	4.e-003	2.3459e-005
309	1.1334e-002	4.8699e-002	4.e-003	2.0235e-005
310	9.3886e-003	4.9111e-002	4.e-003	1.6891e-005
311	7.4288e-003	4.9445e-002	4.e-003	1.3448e-005
312	5.4571e-003	4.9701e-002	4.e-003	9.925e-006
313	3.4768e-003	4.9879e-002	4.e-003	6.3439e-006
314	1.4911e-003	4.9978e-002	4.e-003	2.7255e-006
315	-4.9703e-004	4.9998e-002	4.e-003	-9.0892e-007
316	-2.4844e-003	4.9938e-002	4.e-003	-4.538e-006
317	-4.4678e-003	4.98e-002	4.e-003	-8.1404e-006
318	-6.4441e-003	4.9583e-002	4.e-003	-1.1695e-005
319	-8.4103e-003	4.9288e-002	4.e-003	-1.5181e-005
320	-1.0363e-002	4.8914e-002	4.e-003	-1.8577e-005
321	-1.23e-002	4.8464e-002	4.e-003	-2.1863e-005
322	-1.4217e-002	4.7936e-002	4.e-003	-2.502e-005
323	-1.6111e-002	4.7333e-002	4.e-003	-2.8029e-005
324	-1.798e-002	4.6655e-002	4.e-003	-3.0872e-005
325	-1.9821e-002	4.5904e-002	4.e-003	-3.3531e-005
326	-2.163e-002	4.5079e-002	4.e-003	-3.5989e-005
327	-2.3405e-002	4.4184e-002	4.e-003	-3.8232e-005
328	-2.5143e-002	4.3218e-002	4.e-003	-4.0246e-005
329	-2.6842e-002	4.2184e-002	4.e-003	-4.2016e-005
330	-2.8498e-002	4.1084e-002	4.e-003	-4.3532e-005
331	-3.0108e-002	3.9919e-002	4.e-003	-4.4784e-005
332	3.2435e-002	3.8053e-002	4.2e-002	4.6147e-005
333	-3.2435e-002	3.8053e-002	8.e-003	-4.6144e-005
334	-3.0896e-002	3.9312e-002	5.e-003	-4.5308e-005
335	3.1671e-002	3.869e-002	3.8e-002	4.5762e-005
336	3.1671e-002	3.869e-002	3.6e-002	4.5762e-005
337	3.1671e-002	3.869e-002	3.4e-002	4.5762e-005
338	3.1671e-002	3.869e-002	3.2e-002	4.5762e-005
339	3.1671e-002	3.869e-002	3.e-002	4.5762e-005
340	3.1671e-002	3.869e-002	2.8e-002	4.5762e-005
341	3.1671e-002	3.869e-002	2.6e-002	4.5762e-005
342	3.1671e-002	3.869e-002	2.4e-002	4.5762e-005
343	3.1671e-002	3.869e-002	2.2e-002	4.5762e-005
344	3.1671e-002	3.869e-002	2.e-002	4.5762e-005
345	3.1671e-002	3.869e-002	1.8e-002	4.5762e-005
346	3.1671e-002	3.869e-002	1.6e-002	4.5762e-005
347	3.1671e-002	3.8691e-002	1.4e-002	4.5762e-005
348	-3.1648e-002	3.8709e-002	1.1989e-002	-4.575e-005
349	-3.1662e-002	3.8698e-002	1.3993e-002	-4.5756e-005
350	-3.1667e-002	3.8694e-002	1.5998e-002	-4.5759e-005
351	-3.1671e-002	3.869e-002	1.8e-002	-4.5762e-005
352	-3.1671e-002	3.869e-002	2.e-002	-4.5763e-005
353	-3.1671e-002	3.869e-002	2.2e-002	-4.5764e-005
354	-3.1671e-002	3.869e-002	2.4e-002	-4.5763e-005
355	-3.1671e-002	3.869e-002	2.6e-002	-4.5762e-005
356	-3.1671e-002	3.869e-002	2.8e-002	-4.5761e-005
357	-3.1671e-002	3.8691e-002	3.e-002	-4.5761e-005
358	-3.1671e-002	3.8691e-002	3.2e-002	-4.5761e-005
359	-3.1671e-002	3.8691e-002	3.4e-002	-4.576e-005
360	-3.167e-002	3.8691e-002	3.6e-002	-4.5759e-005
361	-3.1662e-002	3.8698e-002	3.8e-002	-4.5757e-005
362	-3.1661e-002	3.8698e-002	3.9999e-002	-4.5758e-005
363	-3.167e-002	3.8691e-002	4.2e-002	-4.5761e-005
364	-3.0882e-002	3.9323e-002	3.9997e-002	-4.5298e-005
365	-2.7675e-002	4.1642e-002	4.3e-002	-4.2807e-005
366	2.9309e-002	4.0509e-002	3.1e-002	4.4192e-005
367	2.9309e-002	4.0509e-002	2.9e-002	4.4193e-005
368	2.9309e-002	4.0509e-002	2.7e-002	4.4193e-005
369	2.9309e-002	4.0509e-002	2.5e-002	4.4193e-005
370	2.9309e-002	4.0509e-002	2.3e-002	4.4193e-005
371	2.9309e-002	4.0509e-002	2.1e-002	4.4193e-005
372	2.9309e-002	4.0509e-002	1.9e-002	4.4193e-005
373	2.9309e-002	4.0509e-002	1.7e-002	4.4193e-005
374	2.9309e-002	4.0509e-002	1.5e-002	4.4193e-005
375	-2.9282e-002	4.0528e-002	1.6991e-002	-4.4175e-005
376	-2.933e-002	4.0494e-002	1.8993e-002	-4.4209e-005
377	-2.9371e-002	4.0464e-002	2.1007e-002	-4.4239e-005
378	-2.9362e-002	4.0471e-002	2.3027e-002	-4.4233e-005
379	-2.9318e-002	4.0502e-002	2.5019e-002	-4.42e-005
380	-2.9288e-002	4.0524e-002	2.6996e-002	-4.4178e-005
381	-2.9289e-002	4.0523e-002	2.8996e-002	-4.4176e-005
382	2.6842e-002	4.2184e-002	8.e-003	4.2016e-005
383	2.5143e-002	4.3218e-002	8.e-003	4.0246e-005
384	2.3405e-002	4.4184e-002	8.e-003	3.8232e-005
385	2.163e-002	4.5079e-002	8.e-003	3.5989e-005
386	1.9821e-002	4.5904e-002	8.e-003	3.3531e-005
387	1.798e-002	4.6655e-002	8.e-003	3.0872e-005
388	1.6111e-002	4.7333e-002	8.e-003	2.8029e-005
389	1.4217e-002	4.7936e-002	8.e-003	2.502e-005
390	1.23e-002	4.8464e-002	8.e-003	2.1863e-005
391	1.0363e-002	4.8914e-002	8.e-003	1.8577e-005
392	8.4103e-003	4.9288e-002	8.e-003	1.5181e-005
393	6.4442e-003	4.9583e-002	8.e-003	1.1695e-005
394	4.4678e-003	4.98e-002	8.e-003	8.1405e-006
395	2.4844e-003	4.9938e-002	8.e-003	4.5381e-006
396	4.9708e-004	4.9998e-002	8.e-003	9.0899e-007
397	-1.491e-003	4.9978e-002	8.e-003	-2.7254e-006
398	-3.4768e-003	4.9879e-002	8.e-003	-6.3439e-006
399	-5.4571e-003	4.9701e-002	8.e-003	-9.925e-006
400	-7.4287e-003	4.9445e-002	8.e-003	-1.3448e-005
401	-9.3886e-003	4.9111e-002	8.e-003	-1.6891e-005
402	-1.1334e-002	4.8699e-002	8.e-003	-2.0235e-005
403	-1.3261e-002	4.8209e-002	8.e-003	-2.3459e-005
404	-1.5167e-002	4.7644e-002	8.e-003	-2.6545e-005
405	-1.7049e-002	4.7003e-002	8.e-003	-2.9472e-005
406	-1.8904e-002	4.6289e-002	8.e-003	-3.2225e-005
407	-2.073e-002	4.55e-002	8.e-003	-3.4786e-005
408	-2.2522e-002	4.464e-002	8.e-003	-3.7139e-005
409	-2.4279e-002	4.371e-002	8.e-003	-3.9268e-005
410	-2.5987e-002	4.2716e-002	7.9923e-003	-4.1151e-005
411	-2.7627e-002	4.1674e-002	9.9688e-003	-4.2764e-005
412	-2.7752e-002	4.1591e-002	2.0041e-002	-4.2874e-005
413	-2.6933e-002	4.2126e-002	2.3051e-002	-4.2098e-005
414	2.5143e-002	4.3218e-002	1.e-002	4.0246e-005
415	2.5998e-002	4.271e-002	3.9e-002	4.1162e-005
416	1.6111e-002	4.7333e-002	1.2e-002	2.8029e-005
417	2.5997e-002	4.271e-002	3.5e-002	4.1162e-005
418	2.4279e-002	4.371e-002	1.2e-002	3.9269e-005
419	2.163e-002	4.5079e-002	3.7e-002	3.5989e-005
420	-2.522e-002	4.3174e-002	2.0056e-002	-4.0321e-005
421	1.7049e-002	4.7003e-002	1.4e-002	2.9473e-005
422	1.5167e-002	4.7644e-002	1.4e-002	2.6545e-005
423	-2.4309e-002	4.3693e-002	2.4013e-002	-3.93e-005
424	2.2522e-002	4.464e-002	1.7e-002	3.7139e-005
425	-2.163e-002	4.5079e-002	1.5e-002	-3.5989e-005
426	-2.3405e-002	4.4184e-002	1.7e-002	-3.8237e-005
427	-2.2522e-002	4.464e-002	1.6e-002	-3.7138e-005
428	2.2522e-002	4.464e-002	2.5e-002	3.7139e-005
429	2.163e-002	4.5079e-002	2.1e-002	3.5989e-005
430	-2.163e-002	4.5079e-002	2.9e-002	-3.5989e-005
431	1.9821e-002	4.5903e-002	1.7e-002	3.3531e-005
432	-1.9821e-002	4.5904e-002	1.7e-002	-3.353e-005
433	-2.163e-002	4.5079e-002	2.5e-002	-3.5989e-005
434	-2.073e-002	4.55e-002	3.2e-002	-3.4786e-005
435	-1.8904e-002	4.6289e-002	1.8e-002	-3.2225e-005
436	1.6111e-002	4.7333e-002	1.8e-002	2.8029e-005
437	2.073e-002	4.55e-002	2.9e-002	3.4786e-005
438	2.073e-002	4.55e-002	2.7e-002	3.4786e-005
439	1.798e-002	4.6655e-002	1.9e-002	3.0872e-005
440	1.8904e-002	4.6289e-002	2.1e-002	3.2225e-005
441	1.8904e-002	4.6289e-002	2.6e-002	3.2225e-005
442	9.3887e-003	4.9111e-002	2.1e-002	1.6891e-005
443	1.798e-002	4.6655e-002	2.3e-002	3.0872e-005
444	1.7049e-002	4.7003e-002	2.1e-002	2.9473e-005
445	-9.3888e-003	4.9111e-002	2.8e-002	-1.6891e-005
446	-7.4289e-003	4.9445e-002	2.8e-002	-1.3448e-005
447	3.4769e-003	4.9879e-002	2.2e-002	6.344e-006
448	1.4911e-003	4.9978e-002	2.2e-002	2.7256e-006
449	-4.9702e-004	4.9998e-002	2.2e-002	-9.0881e-007
450	-2.4844e-003	4.9938e-002	2.2e-002	-4.5379e-006
451	-4.4678e-003	4.98e-002	2.2e-002	-8.1403e-006
452	-6.4441e-003	4.9583e-002	2.2e-002	-1.1695e-005
453	-8.4103e-003	4.9288e-002	2.2e-002	-1.518e-005
454	-1.0363e-002	4.8914e-002	2.2e-002	-1.8578e-005
455	-1.23e-002	4.8464e-002	2.2e-002	-2.1863e-005
456	-1.4217e-002	4.7936e-002	2.8e-002	-2.5021e-005
457	1.1334e-002	4.8699e-002	2.2e-002	2.0235e-005
458	8.4104e-003	4.9288e-002	2.3e-002	1.5181e-005
459	-1.1342e-002	4.8697e-002	2.6005e-002	-2.0248e-005
460	-1.3261e-002	4.8209e-002	2.4e-002	-2.3465e-005
461	-1.2313e-002	4.846e-002	2.5013e-002	-2.1881e-005
462	4.972e-004	4.9998e-002	2.5e-002	9.0898e-007
463	6.4443e-003	4.9583e-002	2.5e-002	1.1695e-005
464	-3.4645e-002	3.6051e-002	4.9e-002	-4.687e-005
465	-3.3922e-002	3.6733e-002	4.9e-002	-4.6701e-005
466	-3.3185e-002	3.74e-002	4.9e-002	-4.646e-005
467	-3.2435e-002	3.8053e-002	4.9e-002	-4.6147e-005
468	-3.1672e-002	3.869e-002	4.9e-002	-4.5762e-005
469	-3.0896e-002	3.9312e-002	4.9e-002	-4.5308e-005
470	-3.0108e-002	3.9918e-002	4.9e-002	-4.4784e-005
471	-2.9309e-002	4.0509e-002	4.9e-002	-4.4192e-005
472	-2.8498e-002	4.1084e-002	4.9e-002	-4.3533e-005
473	-2.7675e-002	4.1642e-002	4.9e-002	-4.2807e-005
474	-2.6842e-002	4.2184e-002	4.9e-002	-4.2016e-005
475	-2.5998e-002	4.271e-002	4.9e-002	-4.1162e-005
476	-2.5143e-002	4.3218e-002	4.9e-002	-4.0246e-005
477	-2.4279e-002	4.371e-002	4.9e-002	-3.9268e-005
478	-2.3405e-002	4.4184e-002	4.9e-002	-3.8232e-005
479	-2.2522e-002	4.464e-002	4.9e-002	-3.7138e-005
480	-2.163e-002	4.5079e-002	4.9e-002	-3.5989e-005
481	-2.073e-002	4.55e-002	4.9e-002	-3.4786e-005
482	-1.9821e-002	4.5904e-002	4.9e-002	-3.3531e-005
483	-1.8904e-002	4.6289e-002	4.9e-002	-3.2225e-005
484	-1.798e-002	4.6655e-002	4.9e-002	-3.0872e-005
485	-1.7049e-002	4.7003e-002	4.9e-002	-2.9472e-005
486	-1.6111e-002	4.7333e-002	4.9e-002	-2.8029e-005
487	-1.5167e-002	4.7644e-002	4.9e-002	-2.6545e-005
488	-1.4217e-002	4.7936e-002	4.9e-002	-2.502e-005
489	-1.3261e-002	4.8209e-002	4.9e-002	-2.3459e-005
490	-1.23e-002	4.8464e-002	4.9e-002	-2.1863e-005
491	-1.1334e-002	4.8699e-002	4.9e-002	-2.0235e-005
492	-1.0363e-002	4.8914e-002	4.9e-002	-1.8577e-005
493	-9.3886e-003	4.9111e-002	4.9e-002	-1.6891e-005
494	-8.4103e-003	4.9288e-002	4.9e-002	-1.5181e-005
495	-7.4287e-003	4.9445e-002	4.9e-002	-1.3448e-005
496	-6.4442e-003	4.9583e-002	4.9e-002	-1.1695e-005
497	-5.4571e-003	4.9701e-002	4.9e-002	-9.925e-006
498	-4.4678e-003	4.98e-002	4.9e-002	-8.1404e-006
499	-3.4768e-003	4.9879e-002	4.9e-002	-6.3439e-006
500	-2.4844e-003	4.9938e-002	4.9e-002	-4.538e-006
501	-1.491e-003	4.9978e-002	4.9e-002	-2.7255e-006
502	-4.9708e-004	4.9998e-002	4.9e-002	-9.0893e-007
503	4.9709e-004	4.9998e-002	4.9e-002	9.0895e-007
504	1.491e-003	4.9978e-002	4.9e-002	2.7255e-006
505	2.4844e-003	4.9938e-002	4.9e-002	4.538e-006
506	3.4768e-003	4.9879e-002	4.9e-002	6.3439e-006
507	4.4678e-003	4.98e-002	4.9e-002	8.1405e-006
508	5.4571e-003	4.9701e-002	4.9e-002	9.925e-006
509	6.4442e-003	4.9583e-002	4.9e-002	1.1695e-005
510	7.4287e-003	4.9445e-002	4.9e-002	1.3448e-005
511	8.4103e-003	4.9288e-002	4.9e-002	1.5181e-005
512	9.3886e-003	4.9111e-002	4.9e-002	1.6891e-005
513	1.0363e-002	4.8914e-002	4.9e-002	1.8577e-005
514	1.1334e-002	4.8699e-002	4.9e-002	2.0235e-005
515	1.23e-002	4.8464e-002	4.9e-002	2.1863e-005
516	1.3261e-002	4.8209e-002	4.9e-002	2.3459e-005
517	1.4217e-002	4.7936e-002	4.9e-002	2.502e-005
518	1.5167e-002	4.7644e-002	4.9e-002	2.6545e-005
519	1.6111e-002	4.7333e-002	4.9e-002	2.8029e-005
520	1.7049e-002	4.7003e-002	4.9e-002	2.9472e-005
521	1.798e-002	4.6655e-002	4.9e-002	3.0872e-005
522	1.8904e-002	4.6289e-002	4.9e-002	3.2225e-005
523	1.9821e-002	4.5904e-002	4.9e-002	3.3531e-005
524	2.073e-002	4.55e-002	4.9e-002	3.4786e-005
525	2.163e-002	4.5079e-002	4.9e-002	3.5989e-005
526	2.2522e-002	4.464e-002	4.9e-002	3.7139e-005
527	2.3405e-002	4.4184e-002	4.9e-002	3.8232e-005
528	2.4279e-002	4.371e-002	4.9e-002	3.9268e-005
529	2.5143e-002	4.3218e-002	4.9e-002	4.0246e-005
530	2.5998e-002	4.271e-002	4.9e-002	4.1162e-005
531	2.6842e-002	4.2184e-002	4.9e-002	4.2016e-005
532	2.7675e-002	4.1642e-002	4.9e-002	4.2807e-005
533	2.8498e-002	4.1084e-002	4.9e-002	4.3533e-005
534	2.9309e-002	4.0509e-002	4.9e-002	4.4192e-005
535	3.0108e-002	3.9918e-002	4.9e-002	4.4784e-005
536	3.0896e-002	3.9312e-002	4.9e-002	4.5308e-005
537	3.1672e-002	3.869e-002	4.9e-002	4.5762e-005
538	3.2435e-002	3.8053e-002	4.9e-002	4.6147e-005
539	3.3185e-002	3.74e-002	4.9e-002	4.646e-005
540	3.3922e-002	3.6733e-002	4.9e-002	4.6701e-005
541	3.4645e-002	3.6051e-002	4.9e-002	4.687e-005
542	3.4641e-002	3.6055e-002	4.7e-002	4.687e-005
543	3.4641e-002	3.6055e-002	4.6e-002	4.687e-005
544	3.4641e-002	3.6055e-002	4.5e-002	4.687e-005
545	3.4641e-002	3.6055e-002	4.4e-002	4.687e-005
546	3.4641e-002	3.6055e-002	4.3e-002	4.687e-005
547	3.4641e-002	3.6055e-002	4.2e-002	4.687e-005
548	3.4641e-002	3.6055e-002	4.1e-002	4.687e-005
549	3.4641e-002	3.6055e-002	4.e-002	4.687e-005
550	3.4641e-002	3.6055e-002	3.9e-002	4.687e-005
551	3.4641e-002	3.6055e-002	3.8e-002	4.687e-005
552	3.4641e-002	3.6055e-002	3.7e-002	4.687e-005
553	3.4641e-002	3.6055e-002	3.6e-002	4.687e-005
554	3.4641e-002	3.6055e-002	3.5e-002	4.687e-005
555	3.4641e-002	3.6055e-002	3.4e-002	4.687e-005
556	3.4641e-002	3.6055e-002	3.3e-002	4.687e-005
557	3.4641e-002	3.6055e-002	3.2e-002	4.687e-005
558	3.4641e-002	3.6055e-002	3.1e-002	4.687e-005
559	3.4641e-002	3.6055e-002	3.e-002	4.687e-005
560	3.4641e-002	3.6055e-002	2.9e-002	4.687e-005
561	3.4641e-002	3.6055e-002	2.8e-002	4.687e-005
562	3.4641e-002	3.6055e-002	2.7e-002	4.687e-005
563	3.4641e-002	3.6055e-002	2.6e-002	4.687e-005
564	3.4641e-002	3.6055e-002	2.5e-002	4.687e-005
565	3.4641e-002	3.6055e-002	2.4e-002	4.687e-005
566	3.4641e-002	3.6055e-002	2.3e-002	4.687e-005
567	3.4641e-002	3.6055e-002	2.2e-002	4.687e-005
568	3.4641e-002	3.6055e-002	2.1e-002	4.687e-005
569	3.4641e-002	3.6055e-002	2.e-002	4.687e-005
570	3.4641e-002	3.6055e-002	1.9e-002	4.687e-005
571	3.4641e-002	3.6055e-002	1.8e-002	4.687e-005
572	3.4641e-002	3.6055e-002	1.7e-002	4.687e-005
573	3.4641e-002	3.6055e-002	1.6e-002	4.687e-005
574	3.4641e-002	3.6055e-002	1.5e-002	4.687e-005
575	3.4641e-002	3.6055e-002	1.4e-002	4.687e-005
576	3.4641e-002	3.6055e-002	1.3e-002	4.687e-005
577	3.4641e-002	3.6055e-002	1.2e-002	4.687e-005
578	3.4641e-002	3.6055e-002	1.1e-002	4.687e-005
579	3.4641e-002	3.6055e-002	1.e-002	4.687e-005
580	3.4641e-002	3.6055e-002	9.e-003	4.687e-005
581	3.4641e-002	3.6055e-002	8.e-003	4.687e-005
582	3.4641e-002	3.6055e-002	7.e-003	4.687e-005
583	3.4641e-002	3.6055e-002	6.e-003	4.687e-005
584	3.4641e-002	3.6055e-002	5.e-003	4.687e-005
585	3.4641e-002	3.6055e-002	3.e-003	4.687e-005
586	3.4641e-002	3.6055e-002	2.e-003	4.687e-005
587	3.4641e-002	3.6055e-002	9.9999e-004	4.687e-005
588	3.3922e-002	3.6733e-002	9.9999e-004	4.6701e-005
589	3.3185e-002	3.74e-002	1.e-003	4.646e-005
590	3.2435e-002	3.8053e-002	1.e-003	4.6147e-005
591	3.1672e-002	3.869e-002	1.e-003	4.5763e-005
592	3.0896e-002	3.9312e-002	9.9999e-004	4.5308e-005
593	3.0108e-002	3.9918e-002	1.e-003	4.4784e-005
594	2.9309e-002	4.0509e-002	9.9999e-004	4.4192e-005
595	2.8498e-002	4.1084e-002	1.e-003	4.3533e-005
596	2.7675e-002	4.1642e-002	9.9999e-004	4.2807e-005
597	2.6842e-002	4.2184e-002	1.e-003	4.2016e-005
598	2.5998e-002	4.271e-002	9.9999e-004	4.1162e-005
599	2.5143e-002	4.3218e-002	1.e-003	4.0246e-005
600	2.4279e-002	4.371e-002	9.9999e-004	3.9269e-005
601	2.3405e-002	4.4184e-002	1.e-003	3.8232e-005
602	2.2522e-002	4.464e-002	9.9999e-004	3.7139e-005
603	2.163e-002	4.5079e-002	1.e-003	3.5989e-005
604	2.073e-002	4.55e-002	9.9999e-004	3.4786e-005
605	1.9821e-002	4.5904e-002	1.e-003	3.3531e-005
606	1.8904e-002	4.6289e-002	9.9999e-004	3.2225e-005
607	1.798e-002	4.6655e-002	1.e-003	3.0872e-005
608	1.7049e-002	4.7003e-002	9.9999e-004	2.9473e-005
609	1.6111e-002	4.7333e-002	1.e-003	2.8029e-005
610	1.5167e-002	4.7644e-002	9.9999e-004	2.6545e-005
611	1.4217e-002	4.7936e-002	1.e-003	2.502e-005
612	1.3261e-002	4.8209e-002	9.9999e-004	2.3459e-005
613	1.23e-002	4.8464e-002	1.e-003	2.1863e-005
614	1.1334e-002	4.8699e-002	9.9999e-004	2.0235e-005
615	1.0363e-002	4.8914e-002	1.e-003	1.8577e-005
616	9.3886e-003	4.9111e-002	9.9999e-004	1.6891e-005
617	8.4103e-003	4.9288e-002	1.e-003	1.5181e-005
618	7.4287e-003	4.9445e-002	9.9999e-004	1.3448e-005
619	6.4442e-003	4.9583e-002	1.e-003	1.1695e-005
620	5.4571e-003	4.9701e-002	9.9999e-004	9.925e-006
621	4.4678e-003	4.98e-002	1.e-003	8.1404e-006
622	3.4768e-003	4.9879e-002	9.9999e-004	6.3439e-006
623	2.4844e-003	4.9938e-002	1.e-003	4.538e-006
624	1.491e-003	4.9978e-002	9.9999e-004	2.7255e-006
625	4.9708e-004	4.9998e-002	1.e-003	9.0893e-007
626	-4.9708e-004	4.9998e-002	9.9999e-004	-9.0896e-007
627	-1.491e-003	4.9978e-002	1.e-003	-2.7255e-006
628	-2.4844e-003	4.9938e-002	9.9999e-004	-4.5381e-006
629	-3.4768e-003	4.9879e-002	1.e-003	-6.3439e-006
630	-4.4678e-003	4.98e-002	9.9999e-004	-8.1405e-006
631	-5.4571e-003	4.9701e-002	1.e-003	-9.925e-006
632	-6.4442e-003	4.9583e-002	9.9999e-004	-1.1695e-005
633	-7.4287e-003	4.9445e-002	1.e-003	-1.3448e-005
634	-8.4103e-003	4.9288e-002	9.9999e-004	-1.5181e-005
635	-9.3886e-003	4.9111e-002	1.e-003	-1.6891e-005
636	-1.0363e-002	4.8914e-002	9.9999e-004	-1.8577e-005
637	-1.1334e-002	4.8699e-002	1.e-003	-2.0235e-005
638	-1.23e-002	4.8464e-002	9.9999e-004	-2.1863e-005
639	-1.3261e-002	4.8209e-002	1.e-003	-2.3459e-005
640	-1.4217e-002	4.7936e-002	9.9999e-004	-2.502e-005
641	-1.5167e-002	4.7644e-002	1.e-003	-2.6545e-005
642	-1.6111e-002	4.7333e-002	9.9999e-004	-2.8029e-005
643	-1.7049e-002	4.7003e-002	1.e-003	-2.9473e-005
644	-1.798e-002	4.6655e-002	9.9999e-004	-3.0872e-005
645	-1.8904e-002	4.6289e-002	1.e-003	-3.2225e-005
646	-1.9821e-002	4.5904e-002	9.9999e-004	-3.3531e-005
647	-2.073e-002	4.55e-002	1.e-003	-3.4786e-005
648	-2.163e-002	4.5079e-002	9.9999e-004	-3.5989e-005
649	-2.2522e-002	4.464e-002	1.e-003	-3.7139e-005
650	-2.3405e-002	4.4184e-002	9.9999e-004	-3.8232e-005
651	-2.4279e-002	4.371e-002	1.e-003	-3.9269e-005
652	-2.5143e-002	4.3218e-002	9.9999e-004	-4.0246e-005
653	-2.5998e-002	4.271e-002	1.e-003	-4.1162e-005
654	-2.6842e-002	4.2184e-002	9.9999e-004	-4.2016e-005
655	-2.7675e-002	4.1642e-002	1.e-003	-4.2807e-005
656	-2.8498e-002	4.1084e-002	9.9999e-004	-4.3533e-005
657	-2.9309e-002	4.0509e-002	1.e-003	-4.4192e-005
658	-3.0108e-002	3.9918e-002	9.9999e-004	-4.4784e-005
659	-3.0896e-002	3.9312e-002	1.e-003	-4.5308e-005
660	-3.1672e-002	3.869e-002	9.9999e-004	-4.5763e-005
661	-3.2435e-002	3.8053e-002	1.e-003	-4.6147e-005
662	-3.3185e-002	3.74e-002	1.e-003	-4.646e-005
663	-3.3922e-002	3.6733e-002	1.e-003	-4.6701e-005
664	-3.4645e-002	3.6051e-002	1.e-003	-4.687e-005
665	-3.4641e-002	3.6055e-002	3.e-003	-4.687e-005
666	-3.4641e-002	3.6055e-002	4.e-003	-4.687e-005
667	-3.4641e-002	3.6055e-002	5.e-003	-4.687e-005
668	-3.4641e-002	3.6055e-002	6.e-003	-4.687e-005
669	-3.4641e-002	3.6055e-002	7.e-003	-4.687e-005
670	-3.4641e-002	3.6055e-002	8.e-003	-4.687e-005
671	-3.4641e-002	3.6055e-002	9.e-003	-4.687e-005
672	-3.4641e-002	3.6055e-002	1.e-002	-4.687e-005
673	-3.4641e-002	3.6055e-002	1.1e-002	-4.687e-005
674	-3.4641e-002	3.6055e-002	1.2e-002	-4.687e-005
675	-3.4641e-002	3.6055e-002	1.3e-002	-4.687e-005
676	-3.4641e-002	3.6055e-002	1.4e-002	-4.687e-005
677	-3.4641e-002	3.6055e-002	1.5e-002	-4.687e-005
678	-3.4641e-002	3.6055e-002	1.6e-002	-4.687e-005
679	-3.4641e-002	3.6055e-002	1.7e-002	-4.687e-005
680	-3.4641e-002	3.6055e-002	1.8e-002	-4.687e-005
681	-3.4641e-002	3.6055e-002	1.9e-002	-4.687e-005
682	-3.4641e-002	3.6055e-002	2.e-002	-4.687e-005
683	-3.4641e-002	3.6055e-002	2.1e-002	-4.687e-005
684	-3.4641e-002	3.6055e-002	2.2e-002	-4.687e-005
685	-3.4641e-002	3.6055e-002	2.3e-002	-4.687e-005
686	-3.4641e-002	3.6055e-002	2.4e-002	-4.687e-005
687	-3.4641e-002	3.6055e-002	2.5e-002	-4.687e-005
688	-3.4641e-002	3.6055e-002	2.6e-002	-4.687e-005
689	-3.4641e-002	3.6055e-002	2.7e-002	-4.687e-005
690	-3.4641e-002	3.6055e-002	2.8e-002	-4.687e-005
691	-3.4641e-002	3.6055e-002	2.9e-002	-4.687e-005
692	-3.4641e-002	3.6055e-002	3.e-002	-4.687e-005
693	-3.4641e-002	3.6055e-002	3.1e-002	-4.687e-005
694	-3.4641e-002	3.6055e-002	3.2e-002	-4.687e-005
695	-3.4641e-002	3.6055e-002	3.3e-002	-4.687e-005
696	-3.4641e-002	3.6055e-002	3.4e-002	-4.687e-005
697	-3.4641e-002	3.6055e-002	3.5e-002	-4.687e-005
698	-3.4641e-002	3.6055e-002	3.6e-002	-4.687e-005
699	-3.4641e-002	3.6055e-002	3.7e-002	-4.687e-005
700	-3.4641e-002	3.6055e-002	3.8e-002	-4.687e-005
701	-3.4641e-002	3.6055e-002	3.9e-002	-4.687e-005
702	-3.4641e-002	3.6055e-002	4.e-002	-4.687e-005
703	-3.4641e-002	3.6055e-002	4.1e-002	-4.687e-005
704	-3.4641e-002	3.6055e-002	4.2e-002	-4.687e-005
705	-3.4641e-002	3.6055e-002	4.3e-002	-4.687e-005
706	-3.4641e-002	3.6055e-002	4.4e-002	-4.687e-005
707	-3.4641e-002	3.6055e-002	4.5e-002	-4.687e-005
708	-3.4641e-002	3.6055e-002	4.6e-002	-4.687e-005
709	-3.4641e-002	3.6055e-002	4.7e-002	-4.687e-005
710	-3.4641e-002	3.6055e-002	4.8e-002	-4.687e-005
711	3.3922e-002	3.6733e-002	2.e-003	4.6701e-005
712	3.3185e-002	3.74e-002	2.e-003	4.646e-005
713	3.2435e-002	3.8053e-002	2.e-003	4.6147e-005
714	3.1672e-002	3.869e-002	2.e-003	4.5763e-005
715	3.0896e-002	3.9312e-002	2.e-003	4.5308e-005
716	3.0108e-002	3.9918e-002	2.e-003	4.4784e-005
717	2.9309e-002	4.0509e-002	2.e-003	4.4192e-005
718	2.8498e-002	4.1084e-002	2.e-003	4.3533e-005
719	2.7675e-002	4.1642e-002	2.e-003	4.2807e-005
720	2.6842e-002	4.2184e-002	2.e-003	4.2016e-005
721	2.5998e-002	4.271e-002	2.e-003	4.1162e-005
722	2.5143e-002	4.3218e-002	2.e-003	4.0246e-005
723	2.4279e-002	4.371e-002	2.e-003	3.9269e-005
724	2.3405e-002	4.4184e-002	2.e-003	3.8232e-005
725	2.2522e-002	4.464e-002	2.e-003	3.7139e-005
726	2.163e-002	4.5079e-002	2.e-003	3.5989e-005
727	2.073e-002	4.55e-002	2.e-003	3.4786e-005
728	1.9821e-002	4.5904e-002	2.e-003	3.3531e-005
729	1.8904e-002	4.6289e-002	2.e-003	3.2225e-005
730	1.798e-002	4.6655e-002	2.e-003	3.0872e-005
731	1.7049e-002	4.7003e-002	2.e-003	2.9473e-005
732	1.6111e-002	4.7333e-002	2.e-003	2.8029e-005
733	1.5167e-002	4.7644e-002	2.e-003	2.6545e-005
734	1.4217e-002	4.7936e-002	2.e-003	2.502e-005
735	1.3261e-002	4.8209e-002	2.e-003	2.3459e-005
736	1.23e-002	4.8464e-002	2.e-003	2.1863e-005
737	1.1334e-002	4.8699e-002	2.e-003	2.0235e-005
738	1.0363e-002	4.8914e-002	2.e-003	1.8577e-005
739	9.3886e-003	4.9111e-002	2.e-003	1.6891e-005
740	8.4103e-003	4.9288e-002	2.e-003	1.5181e-005
741	7.4287e-003	4.9445e-002	2.e-003	1.3448e-005
742	6.4441e-003	4.9583e-002	2.e-003	1.1695e-005
743	5.4571e-003	4.9701e-002	2.e-003	9.925e-006
744	4.4678e-003	4.98e-002	2.e-003	8.1404e-006
745	3.4768e-003	4.9879e-002	2.e-003	6.3439e-006
746	2.4844e-003	4.9938e-002	2.e-003	4.538e-006
747	1.491e-003	4.9978e-002	2.e-003	2.7255e-006
748	4.9706e-004	4.9998e-002	2.e-003	9.0893e-007
749	-4.9709e-004	4.9998e-002	2.e-003	-9.0896e-007
750	-1.4911e-003	4.9978e-002	2.e-003	-2.7255e-006
751	-2.4844e-003	4.9938e-002	2.e-003	-4.5381e-006
752	-3.4768e-003	4.9879e-002	2.e-003	-6.3439e-006
753	-4.4678e-003	4.98e-002	2.e-003	-8.1405e-006
754	-5.4571e-003	4.9701e-002	2.e-003	-9.925e-006
755	-6.4442e-003	4.9583e-002	2.e-003	-1.1695e-005
756	-7.4287e-003	4.9445e-002	2.e-003	-1.3448e-005
757	-8.4103e-003	4.9288e-002	2.e-003	-1.5181e-005
758	-9.3886e-003	4.9111e-002	2.e-003	-1.6891e-005
759	-1.0363e-002	4.8914e-002	2.e-003	-1.8577e-005
760	-1.1334e-002	4.8699e-002	2.e-003	-2.0235e-005
761	-1.23e-002	4.8464e-002	2.e-003	-2.1863e-005
762	-1.3261e-002	4.8209e-002	2.e-003	-2.3459e-005
763	-1.4217e-002	4.7936e-002	2.e-003	-2.502e-005
764	-1.5167e-002	4.7644e-002	2.e-003	-2.6545e-005
765	-1.6111e-002	4.7333e-002	2.e-003	-2.8029e-005
766	-1.7049e-002	4.7003e-002	2.e-003	-2.9473e-005
767	-1.798e-002	4.6655e-002	2.e-003	-3.0872e-005
768	-1.8904e-002	4.6289e-002	2.e-003	-3.2225e-005
769	-1.9821e-002	4.5904e-002	2.e-003	-3.3531e-005
770	-2.073e-002	4.55e-002	2.e-003	-3.4786e-005
771	-2.163e-002	4.5079e-002	2.e-003	-3.5989e-005
772	-2.2522e-002	4.464e-002	2.e-003	-3.7139e-005
773	-2.3405e-002	4.4184e-002	2.e-003	-3.8232e-005
774	-2.4279e-002	4.371e-002	2.e-003	-3.9269e-005
775	-2.5143e-002	4.3218e-002	2.e-003	-4.0246e-005
776	-2.5998e-002	4.271e-002	2.e-003	-4.1162e-005
777	-2.6842e-002	4.2184e-002	2.e-003	-4.2016e-005
778	-2.7675e-002	4.1642e-002	2.e-003	-4.2807e-005
779	-2.8498e-002	4.1084e-002	2.e-003	-4.3533e-005
780	-2.9309e-002	4.0509e-002	2.e-003	-4.4192e-005
781	-3.0108e-002	3.9918e-002	2.e-003	-4.4784e-005
782	-3.0896e-002	3.9312e-002	2.e-003	-4.5308e-005
783	-3.2435e-002	3.8053e-002	2.e-003	-4.6147e-005
784	-3.3185e-002	3.74e-002	2.e-003	-4.646e-005
785	-3.3922e-002	3.6733e-002	2.e-003	-4.6701e-005
786	-3.3922e-002	3.6733e-002	3.e-003	-4.6701e-005
787	-3.3922e-002	3.6733e-002	4.e-003	-4.6701e-005
788	-3.3922e-002	3.6733e-002	5.e-003	-4.6701e-005
789	-3.3922e-002	3.6733e-002	6.e-003	-4.6701e-005
790	-3.3922e-002	3.6733e-002	7.e-003	-4.6701e-005
791	-3.3922e-002	3.6733e-002	8.e-003	-4.6701e-005
792	-3.3922e-002	3.6733e-002	9.e-003	-4.6701e-005
793	-3.3922e-002	3.6733e-002	1.e-002	-4.6701e-005
794	-3.3922e-002	3.6733e-002	1.1e-002	-4.6701e-005
795	-3.3922e-002	3.6733e-002	1.2e-002	-4.6701e-005
796	-3.3922e-002	3.6733e-002	1.3e-002	-4.6701e-005
797	-3.3922e-002	3.6733e-002	1.4e-002	-4.6701e-005
798	-3.3922e-002	3.6733e-002	1.5e-002	-4.6701e-005
799	-3.3922e-002	3.6733e-002	1.6e-002	-4.6701e-005
800	-3.3922e-002	3.6733e-002	1.7e-002	-4.6701e-005
801	-3.3922e-002	3.6733e-002	1.8e-002	-4.6701e-005
802	-3.3922e-002	3.6733e-002	1.9e-002	-4.6701e-005
803	-3.3922e-002	3.6733e-002	2.e-002	-4.6701e-005
804	-3.3922e-002	3.6733e-002	2.1e-002	-4.6701e-005
805	-3.3922e-002	3.6733e-002	2.2e-002	-4.6701e-005
806	-3.3922e-002	3.6733e-002	2.3e-002	-4.6701e-005
807	-3.3922e-002	3.6733e-002	2.4e-002	-4.6701e-005
808	-3.3922e-002	3.6733e-002	2.5e-002	-4.6701e-005
809	-3.3921e-002	3.6733e-002	2.6e-002	-4.6701e-005
810	-3.3921e-002	3.6733e-002	2.7e-002	-4.6701e-005
811	-3.3921e-002	3.6733e-002	2.8e-002	-4.6701e-005
812	-3.3921e-002	3.6733e-002	2.9e-002	-4.6701e-005
813	-3.3921e-002	3.6733e-002	3.e-002	-4.6701e-005
814	-3.3921e-002	3.6733e-002	3.1e-002	-4.6701e-005
815	-3.3921e-002	3.6734e-002	3.2e-002	-4.6701e-005
816	-3.3921e-002	3.6734e-002	3.3e-002	-4.6701e-005
817	-3.3921e-002	3.6734e-002	3.4e-002	-4.6701e-005
818	-3.3921e-002	3.6734e-002	3.5e-002	-4.6701e-005
819	-3.3921e-002	3.6734e-002	3.6e-002	-4.6701e-005
820	-3.3921e-002	3.6734e-002	3.7e-002	-4.6701e-005
821	-3.3921e-002	3.6734e-002	3.8e-002	-4.6701e-005
822	-3.3921e-002	3.6734e-002	3.9e-002	-4.6701e-005
823	-3.3921e-002	3.6734e-002	4.e-002	-4.6701e-005
824	-3.3921e-002	3.6734e-002	4.1e-002	-4.6701e-005
825	-3.3921e-002	3.6734e-002	4.2e-002	-4.6701e-005
826	-3.392e-002	3.6734e-002	4.3e-002	-4.6701e-005
827	-3.392e-002	3.6734e-002	4.4e-002	-4.6701e-005
828	-3.392e-002	3.6734e-002	4.5e-002	-4.6701e-005
829	-3.392e-002	3.6735e-002	4.6e-002	-4.6701e-005
830	-3.392e-002	3.6735e-002	4.7e-002	-4.6701e-005
831	-3.392e-002	3.6735e-002	4.8e-002	-4.6701e-005
832	-3.3185e-002	3.74e-002	4.8e-002	-4.646e-005
833	-3.2435e-002	3.8053e-002	4.8e-002	-4.6147e-005
834	-3.1672e-002	3.869e-002	4.8e-002	-4.5762e-005
835	-3.0896e-002	3.9312e-002	4.8e-002	-4.5308e-005
836	-3.0108e-002	3.9918e-002	4.8e-002	-4.4784e-005
837	-2.9309e-002	4.0509e-002	4.8e-002	-4.4192e-005
838	-2.7675e-002	4.1642e-002	4.8e-002	-4.2807e-005
839	-2.5998e-002	4.271e-002	4.8e-002	-4.1162e-005
840	-2.4279e-002	4.371e-002	4.8e-002	-3.9268e-005
841	-2.2522e-002	4.464e-002	4.8e-002	-3.7139e-005
842	-2.073e-002	4.55e-002	4.8e-002	-3.4786e-005
843	-1.8904e-002	4.6289e-002	4.8e-002	-3.2225e-005
844	-1.7049e-002	4.7003e-002	4.8e-002	-2.9472e-005
845	-1.5167e-002	4.7644e-002	4.8e-002	-2.6545e-005
846	-1.3261e-002	4.8209e-002	4.8e-002	-2.3459e-005
847	-1.1334e-002	4.8699e-002	4.8e-002	-2.0235e-005
848	-9.3886e-003	4.9111e-002	4.8e-002	-1.6891e-005
849	-7.4287e-003	4.9445e-002	4.8e-002	-1.3448e-005
850	-5.4571e-003	4.9701e-002	4.8e-002	-9.925e-006
851	-3.4768e-003	4.9879e-002	4.8e-002	-6.3439e-006
852	-1.491e-003	4.9978e-002	4.8e-002	-2.7255e-006
853	4.971e-004	4.9998e-002	4.8e-002	9.0896e-007
854	2.4844e-003	4.9938e-002	4.8e-002	4.538e-006
855	4.4678e-003	4.98e-002	4.8e-002	8.1405e-006
856	6.4442e-003	4.9583e-002	4.8e-002	1.1695e-005
857	8.4103e-003	4.9288e-002	4.8e-002	1.5181e-005
858	1.0363e-002	4.8914e-002	4.8e-002	1.8577e-005
859	1.23e-002	4.8464e-002	4.8e-002	2.1863e-005
860	1.4217e-002	4.7936e-002	4.8e-002	2.502e-005
861	1.6111e-002	4.7333e-002	4.8e-002	2.8029e-005
862	1.798e-002	4.6655e-002	4.8e-002	3.0872e-005
863	1.9821e-002	4.5904e-002	4.8e-002	3.3531e-005
864	2.163e-002	4.5079e-002	4.8e-002	3.5989e-005
865	2.3405e-002	4.4184e-002	4.8e-002	3.8232e-005
866	2.5143e-002	4.3218e-002	4.8e-002	4.0246e-005
867	2.6842e-002	4.2184e-002	4.8e-002	4.2016e-005
868	2.8498e-002	4.1084e-002	4.8e-002	4.3533e-005
869	3.0108e-002	3.9918e-002	4.8e-002	4.4784e-005
870	3.1672e-002	3.869e-002	4.8e-002	4.5762e-005
871	3.2435e-002	3.8053e-002	4.8e-002	4.6147e-005
872	3.3185e-002	3.74e-002	4.8e-002	4.646e-005
873	3.3922e-002	3.6733e-002	4.8e-002	4.6701e-005
874	3.3922e-002	3.6733e-002	4.7e-002	4.6701e-005
875	3.3922e-002	3.6733e-002	4.6e-002	4.6701e-005
876	3.3922e-002	3.6733e-002	4.5e-002	4.6701e-005
877	3.3922e-002	3.6733e-002	4.4e-002	4.6701e-005
878	3.3922e-002	3.6733e-002	4.3e-002	4.6701e-005
879	3.3922e-002	3.6733e-002	4.2e-002	4.6701e-005
880	3.3922e-002	3.6733e-002	4.1e-002	4.6701e-005
881	3.3922e-002	3.6733e-002	4.e-002	4.6701e-005
882	3.3922e-002	3.6733e-002	3.9e-002	4.6701e-005
883	3.3922e-002	3.6733e-002	3.8e-002	4.6701e-005
884	3.3922e-002	3.6733e-002	3.7e-002	4.6701e-005
885	3.3922e-002	3.6733e-002	3.6e-002	4.6701e-005
886	3.3922e-002	3.6733e-002	3.5e-002	4.6701e-005
887	3.3922e-002	3.6733e-002	3.4e-002	4.6701e-005
888	3.3922e-002	3.6733e-002	3.3e-002	4.6701e-005
889	3.3922e-002	3.6733e-002	3.2e-002	4.6701e-005
890	3.3922e-002	3.6733e-002	3.1e-002	4.6701e-005
891	3.3922e-002	3.6733e-002	3.e-002	4.6701e-005
892	3.3922e-002	3.6733e-002	2.9e-002	4.6701e-005
893	3.3922e-002	3.6733e-002	2.8e-002	4.6701e-005
894	3.3922e-002	3.6733e-002	2.7e-002	4.6701e-005
895	3.3922e-002	3.6733e-002	2.6e-002	4.6701e-005
896	3.3922e-002	3.6733e-002	2.5e-002	4.6701e-005
897	3.3922e-002	3.6733e-002	2.4e-002	4.6701e-005
898	3.3922e-002	3.6733e-002	2.3e-002	4.6701e-005
899	3.3922e-002	3.6733e-002	2.2e-002	4.6701e-005
900	3.3922e-002	3.6733e-002	2.1e-002	4.6701e-005
901	3.3922e-002	3.6733e-002	2.e-002	4.6701e-005
902	3.3922e-002	3.6733e-002	1.9e-002	4.6701e-005
903	3.3922e-002	3.6733e-002	1.8e-002	4.6701e-005
904	3.3921e-002	3.6733e-002	1.7e-002	4.6701e-005
905	3.3921e-002	3.6733e-002	1.6e-002	4.6701e-005
906	3.3921e-002	3.6733e-002	1.5e-002	4.6701e-005
907	3.3921e-002	3.6733e-002	1.4e-002	4.6701e-005
908	3.3921e-002	3.6733e-002	1.3e-002	4.6701e-005
909	3.3921e-002	3.6734e-002	1.2e-002	4.6701e-005
910	3.3921e-002	3.6734e-002	1.1e-002	4.6701e-005
911	3.3921e-002	3.6734e-002	1.e-002	4.6701e-005
912	3.3921e-002	3.6734e-002	9.0001e-003	4.6701e-005
913	3.3921e-002	3.6734e-002	8.0001e-003	4.6701e-005
914	3.3921e-002	3.6734e-002	7.0001e-003	4.6701e-005
915	3.3921e-002	3.6734e-002	6.0001e-003	4.6701e-005
916	3.3921e-002	3.6734e-002	5.0001e-003	4.6701e-005
917	3.3921e-002	3.6734e-002	4.0001e-003	4.6701e-005
918	3.3921e-002	3.6734e-002	3.0001e-003	4.6701e-005
919	-3.2435e-002	3.8053e-002	4.7e-002	-4.6146e-005
920	-3.1672e-002	3.869e-002	4.7e-002	-4.5762e-005
921	-3.0896e-002	3.9312e-002	4.7e-002	-4.5308e-005
922	-3.0108e-002	3.9919e-002	4.7e-002	-4.4784e-005
923	-2.9309e-002	4.0509e-002	4.7e-002	-4.4192e-005
924	-2.8498e-002	4.1084e-002	4.7e-002	-4.3533e-005
925	-2.7675e-002	4.1642e-002	4.7e-002	-4.2807e-005
926	-2.6842e-002	4.2184e-002	4.7e-002	-4.2016e-005
927	-2.5998e-002	4.271e-002	4.7e-002	-4.1162e-005
928	-2.5143e-002	4.3218e-002	4.7e-002	-4.0246e-005
929	-2.4279e-002	4.371e-002	4.7e-002	-3.9268e-005
930	-2.3405e-002	4.4184e-002	4.7e-002	-3.8232e-005
931	-2.2522e-002	4.464e-002	4.7e-002	-3.7139e-005
932	-2.163e-002	4.5079e-002	4.7e-002	-3.5989e-005
933	-2.073e-002	4.55e-002	4.7e-002	-3.4786e-005
934	-1.9821e-002	4.5904e-002	4.7e-002	-3.3531e-005
935	-1.8904e-002	4.6289e-002	4.7e-002	-3.2225e-005
936	-1.798e-002	4.6655e-002	4.7e-002	-3.0872e-005
937	-1.7049e-002	4.7003e-002	4.7e-002	-2.9472e-005
938	-1.6111e-002	4.7333e-002	4.7e-002	-2.8029e-005
939	-1.5167e-002	4.7644e-002	4.7e-002	-2.6545e-005
940	-1.4217e-002	4.7936e-002	4.7e-002	-2.502e-005
941	-1.3261e-002	4.8209e-002	4.7e-002	-2.3459e-005
942	-1.23e-002	4.8464e-002	4.7e-002	-2.1863e-005
943	-1.1334e-002	4.8699e-002	4.7e-002	-2.0235e-005
944	-1.0363e-002	4.8914e-002	4.7e-002	-1.8577e-005
945	-9.3886e-003	4.9111e-002	4.7e-002	-1.6891e-005
946	-8.4103e-003	4.9288e-002	4.7e-002	-1.5181e-005
947	-7.4287e-003	4.9445e-002	4.7e-002	-1.3448e-005
948	-6.4441e-003	4.9583e-002	4.7e-002	-1.1695e-005
949	-5.4571e-003	4.9701e-002	4.7e-002	-9.925e-006
950	-4.4678e-003	4.98e-002	4.7e-002	-8.1404e-006
951	-3.4768e-003	4.9879e-002	4.7e-002	-6.3439e-006
952	-2.4844e-003	4.9938e-002	4.7e-002	-4.538e-006
953	-1.4911e-003	4.9978e-002	4.7e-002	-2.7255e-006
954	-4.9706e-004	4.9998e-002	4.7e-002	-9.0894e-007
955	4.9706e-004	4.9998e-002	4.7e-002	9.0894e-007
956	1.4911e-003	4.9978e-002	4.7e-002	2.7255e-006
957	2.4844e-003	4.9938e-002	4.7e-002	4.538e-006
958	3.4768e-003	4.9879e-002	4.7e-002	6.3439e-006
959	4.4678e-003	4.98e-002	4.7e-002	8.1404e-006
960	5.4571e-003	4.9701e-002	4.7e-002	9.925e-006
961	6.4441e-003	4.9583e-002	4.7e-002	1.1695e-005
962	7.4287e-003	4.9445e-002	4.7e-002	1.3448e-005
963	8.4103e-003	4.9288e-002	4.7e-002	1.5181e-005
964	9.3886e-003	4.9111e-002	4.7e-002	1.6891e-005
965	1.0363e-002	4.8914e-002	4.7e-002	1.8577e-005
966	1.1334e-002	4.8699e-002	4.7e-002	2.0235e-005
967	1.23e-002	4.8464e-002	4.7e-002	2.1863e-005
968	1.3261e-002	4.8209e-002	4.7e-002	2.3459e-005
969	1.4217e-002	4.7936e-002	4.7e-002	2.502e-005
970	1.5167e-002	4.7644e-002	4.7e-002	2.6545e-005
971	1.6111e-002	4.7333e-002	4.7e-002	2.8029e-005
972	1.7049e-002	4.7003e-002	4.7e-002	2.9472e-005
973	1.798e-002	4.6655e-002	4.7e-002	3.0872e-005
974	1.8904e-002	4.6289e-002	4.7e-002	3.2225e-005
975	1.9821e-002	4.5904e-002	4.7e-002	3.3531e-005
976	2.073e-002	4.55e-002	4.7e-002	3.4786e-005
977	2.163e-002	4.5079e-002	4.7e-002	3.5989e-005
978	2.2522e-002	4.464e-002	4.7e-002	3.7139e-005
979	2.3405e-002	4.4184e-002	4.7e-002	3.8232e-005
980	2.4279e-002	4.371e-002	4.7e-002	3.9268e-005
981	2.5143e-002	4.3218e-002	4.7e-002	4.0246e-005
982	2.5998e-002	4.271e-002	4.7e-002	4.1162e-005
983	2.6842e-002	4.2184e-002	4.7e-002	4.2016e-005
984	2.7675e-002	4.1642e-002	4.7e-002	4.2807e-005
985	2.8498e-002	4.1084e-002	4.7e-002	4.3533e-005
986	2.9309e-002	4.0509e-002	4.7e-002	4.4192e-005
987	3.0108e-002	3.9918e-002	4.7e-002	4.4784e-005
988	3.0896e-002	3.9312e-002	4.7e-002	4.5308e-005
989	3.1672e-002	3.869e-002	4.7e-002	4.5762e-005
990	3.2435e-002	3.8053e-002	4.7e-002	4.6147e-005
991	3.3185e-002	3.74e-002	4.7e-002	4.646e-005
992	3.3185e-002	3.74e-002	4.6e-002	4.646e-005
993	3.3185e-002	3.74e-002	4.5e-002	4.646e-005
994	3.3185e-002	3.74e-002	4.4e-002	4.646e-005
995	3.3185e-002	3.74e-002	4.3e-002	4.646e-005
996	3.3185e-002	3.74e-002	4.2e-002	4.646e-005
997	3.3185e-002	3.74e-002	4.1e-002	4.646e-005
998	3.3185e-002	3.74e-002	4.e-002	4.646e-005
999	3.3185e-002	3.74e-002	3.9e-002	4.646e-005
1000	3.3185e-002	3.74e-002	3.8e-002	4.646e-005
1001	3.3185e-002	3.74e-002	3.7e-002	4.646e-005
1002	3.3185e-002	3.74e-002	3.6e-002	4.646e-005
1003	3.3185e-002	3.74e-002	3.5e-002	4.646e-005
1004	3.3185e-002	3.74e-002	3.4e-002	4.646e-005
1005	3.3185e-002	3.74e-002	3.3e-002	4.646e-005
1006	3.3185e-002	3.74e-002	3.2e-002	4.646e-005
1007	3.3185e-002	3.74e-002	3.1e-002	4.646e-005
1008	3.3185e-002	3.74e-002	3.e-002	4.646e-005
1009	3.3185e-002	3.74e-002	2.9e-002	4.646e-005
1010	3.3185e-002	3.74e-002	2.8e-002	4.646e-005
1011	3.3185e-002	3.74e-002	2.7e-002	4.646e-005
1012	3.3185e-002	3.74e-002	2.6e-002	4.646e-005
1013	3.3185e-002	3.74e-002	2.5e-002	4.646e-005
1014	3.3185e-002	3.74e-002	2.4e-002	4.646e-005
1015	3.3185e-002	3.74e-002	2.3e-002	4.646e-005
1016	3.3185e-002	3.74e-002	2.2e-002	4.646e-005
1017	3.3185e-002	3.74e-002	2.1e-002	4.646e-005
1018	3.3185e-002	3.74e-002	2.e-002	4.646e-005
1019	3.3185e-002	3.74e-002	1.9e-002	4.646e-005
1020	3.3186e-002	3.7399e-002	1.8e-002	4.646e-005
1021	3.3186e-002	3.7399e-002	1.7e-002	4.646e-005
1022	3.3186e-002	3.7399e-002	1.6e-002	4.646e-005
1023	3.3186e-002	3.7399e-002	1.5e-002	4.646e-005
1024	3.3186e-002	3.7399e-002	1.4e-002	4.646e-005
1025	3.3186e-002	3.7399e-002	1.3e-002	4.646e-005
1026	3.3186e-002	3.7399e-002	1.2e-002	4.646e-005
1027	3.3186e-002	3.7399e-002	1.1e-002	4.646e-005
1028	3.3186e-002	3.7399e-002	1.e-002	4.646e-005
1029	3.3186e-002	3.7399e-002	8.9999e-003	4.646e-005
1030	3.3186e-002	3.7399e-002	7.9999e-003	4.646e-005
1031	3.3187e-002	3.7399e-002	6.9999e-003	4.646e-005
1032	3.3187e-002	3.7398e-002	5.9999e-003	4.646e-005
1033	3.3187e-002	3.7398e-002	4.9999e-003	4.646e-005
1034	3.3187e-002	3.7398e-002	3.9999e-003	4.646e-005
1035	3.3187e-002	3.7398e-002	3.e-003	4.646e-005
1036	3.2435e-002	3.8053e-002	3.e-003	4.6147e-005
1037	3.1672e-002	3.869e-002	3.e-003	4.5763e-005
1038	3.0896e-002	3.9312e-002	3.e-003	4.5308e-005
1039	3.0108e-002	3.9918e-002	3.e-003	4.4784e-005
1040	2.9309e-002	4.0509e-002	3.e-003	4.4192e-005
1041	2.8498e-002	4.1084e-002	3.e-003	4.3533e-005
1042	2.7675e-002	4.1642e-002	3.e-003	4.2807e-005
1043	2.6842e-002	4.2184e-002	3.e-003	4.2016e-005
1044	2.5998e-002	4.271e-002	3.e-003	4.1162e-005
1045	2.5143e-002	4.3218e-002	3.e-003	4.0246e-005
1046	2.4279e-002	4.371e-002	3.e-003	3.9269e-005
1047	2.3405e-002	4.4184e-002	3.e-003	3.8232e-005
1048	2.2522e-002	4.464e-002	3.e-003	3.7139e-005
1049	2.163e-002	4.5079e-002	3.e-003	3.5989e-005
1050	2.073e-002	4.55e-002	3.e-003	3.4786e-005
1051	1.9821e-002	4.5904e-002	3.e-003	3.3531e-005
1052	1.8904e-002	4.6289e-002	3.e-003	3.2225e-005
1053	1.798e-002	4.6655e-002	3.e-003	3.0872e-005
1054	1.7049e-002	4.7003e-002	3.e-003	2.9473e-005
1055	1.6111e-002	4.7333e-002	3.e-003	2.8029e-005
1056	1.5167e-002	4.7644e-002	3.e-003	2.6545e-005
1057	1.4217e-002	4.7936e-002	3.e-003	2.502e-005
1058	1.3261e-002	4.8209e-002	3.e-003	2.3459e-005
1059	1.23e-002	4.8464e-002	3.e-003	2.1863e-005
1060	1.1334e-002	4.8699e-002	3.e-003	2.0235e-005
1061	1.0363e-002	4.8914e-002	3.e-003	1.8577e-005
1062	9.3886e-003	4.9111e-002	3.e-003	1.6891e-005
1063	8.4103e-003	4.9288e-002	3.e-003	1.5181e-005
1064	7.4287e-003	4.9445e-002	3.e-003	1.3448e-005
1065	6.4442e-003	4.9583e-002	3.e-003	1.1695e-005
1066	5.4571e-003	4.9701e-002	3.e-003	9.925e-006
1067	4.4678e-003	4.98e-002	3.e-003	8.1405e-006
1068	3.4768e-003	4.9879e-002	3.e-003	6.3439e-006
1069	2.4844e-003	4.9938e-002	3.e-003	4.538e-006
1070	1.491e-003	4.9978e-002	3.e-003	2.7255e-006
1071	4.9708e-004	4.9998e-002	3.e-003	9.0894e-007
1072	-4.9707e-004	4.9998e-002	3.e-003	-9.0895e-007
1073	-1.491e-003	4.9978e-002	3.e-003	-2.7255e-006
1074	-2.4844e-003	4.9938e-002	3.e-003	-4.538e-006
1075	-3.4768e-003	4.9879e-002	3.e-003	-6.3439e-006
1076	-4.4678e-003	4.98e-002	3.e-003	-8.1405e-006
1077	-5.4571e-003	4.9701e-002	3.e-003	-9.925e-006
1078	-6.4442e-003	4.9583e-002	3.e-003	-1.1695e-005
1079	-7.4287e-003	4.9445e-002	3.e-003	-1.3448e-005
1080	-8.4103e-003	4.9288e-002	3.e-003	-1.5181e-005
1081	-9.3886e-003	4.9111e-002	3.e-003	-1.6891e-005
1082	-1.0363e-002	4.8914e-002	3.e-003	-1.8577e-005
1083	-1.1334e-002	4.8699e-002	3.e-003	-2.0235e-005
1084	-1.23e-002	4.8464e-002	3.e-003	-2.1863e-005
1085	-1.3261e-002	4.8209e-002	3.e-003	-2.3459e-005
1086	-1.4217e-002	4.7936e-002	3.e-003	-2.502e-005
1087	-1.5167e-002	4.7644e-002	3.e-003	-2.6545e-005
1088	-1.6111e-002	4.7333e-002	3.e-003	-2.8029e-005
1089	-1.7049e-002	4.7003e-002	3.e-003	-2.9473e-005
1090	-1.798e-002	4.6655e-002	3.e-003	-3.0872e-005
1091	-1.8904e-002	4.6289e-002	3.e-003	-3.2225e-005
1092	-1.9821e-002	4.5904e-002	3.e-003	-3.3531e-005
1093	-2.073e-002	4.55e-002	3.e-003	-3.4786e-005
1094	-2.163e-002	4.5079e-002	3.e-003	-3.5989e-005
1095	-2.2522e-002	4.464e-002	3.e-003	-3.7139e-005
1096	-2.3405e-002	4.4184e-002	3.e-003	-3.8232e-005
1097	-2.4279e-002	4.371e-002	3.e-003	-3.9269e-005
1098	-2.5143e-002	4.3218e-002	3.e-003	-4.0246e-005
1099	-2.5998e-002	4.271e-002	3.e-003	-4.1162e-005
1100	-2.6842e-002	4.2184e-002	3.e-003	-4.2016e-005
1101	-2.7675e-002	4.1642e-002	3.e-003	-4.2807e-005
1102	-2.8498e-002	4.1084e-002	3.e-003	-4.3533e-005
1103	-2.9309e-002	4.0509e-002	3.e-003	-4.4192e-005
1104	-3.0108e-002	3.9918e-002	3.e-003	-4.4784e-005
1105	-3.0896e-002	3.9312e-002	3.e-003	-4.5308e-005
1106	-3.1672e-002	3.869e-002	3.e-003	-4.5762e-005
1107	-3.2435e-002	3.8053e-002	3.e-003	-4.6147e-005
1108	-3.3185e-002	3.74e-002	3.e-003	-4.646e-005
1109	-3.3185e-002	3.74e-002	4.e-003	-4.646e-005
1110	-3.3185e-002	3.74e-002	5.e-003	-4.646e-005
1111	-3.3185e-002	3.74e-002	6.e-003	-4.646e-005
1112	-3.3185e-002	3.74e-002	7.e-003	-4.646e-005
1113	-3.3185e-002	3.74e-002	8.e-003	-4.6459e-005
1114	-3.3185e-002	3.74e-002	9.e-003	-4.646e-005
1115	-3.3185e-002	3.74e-002	1.e-002	-4.6459e-005
1116	-3.3185e-002	3.74e-002	1.1e-002	-4.6459e-005
1117	-3.3185e-002	3.74e-002	1.2e-002	-4.6459e-005
1118	-3.3185e-002	3.74e-002	1.3e-002	-4.646e-005
1119	-3.3185e-002	3.74e-002	1.4e-002	-4.646e-005
1120	-3.3185e-002	3.74e-002	1.5e-002	-4.646e-005
1121	-3.3185e-002	3.74e-002	1.6e-002	-4.646e-005
1122	-3.3185e-002	3.74e-002	1.7e-002	-4.646e-005
1123	-3.3185e-002	3.74e-002	1.8e-002	-4.646e-005
1124	-3.3185e-002	3.74e-002	1.9e-002	-4.646e-005
1125	-3.3185e-002	3.74e-002	2.e-002	-4.646e-005
1126	-3.3185e-002	3.74e-002	2.1e-002	-4.646e-005
1127	-3.3186e-002	3.7399e-002	2.2e-002	-4.646e-005
1128	-3.3186e-002	3.7399e-002	2.3e-002	-4.646e-005
1129	-3.3186e-002	3.7399e-002	2.4e-002	-4.646e-005
1130	-3.3186e-002	3.7399e-002	2.5e-002	-4.646e-005
1131	-3.3186e-002	3.7399e-002	2.6e-002	-4.646e-005
1132	-3.3186e-002	3.7399e-002	2.7e-002	-4.646e-005
1133	-3.3186e-002	3.7399e-002	2.8e-002	-4.646e-005
1134	-3.3186e-002	3.7399e-002	2.9e-002	-4.646e-005
1135	-3.3186e-002	3.7399e-002	3.e-002	-4.646e-005
1136	-3.3186e-002	3.7399e-002	3.1e-002	-4.646e-005
1137	-3.3187e-002	3.7399e-002	3.2e-002	-4.646e-005
1138	-3.3187e-002	3.7398e-002	3.3e-002	-4.646e-005
1139	-3.3187e-002	3.7398e-002	3.4e-002	-4.646e-005
1140	-3.3187e-002	3.7398e-002	3.5e-002	-4.646e-005
1141	-3.3187e-002	3.7398e-002	3.6e-002	-4.646e-005
1142	-3.3187e-002	3.7398e-002	3.7e-002	-4.646e-005
1143	-3.3187e-002	3.7398e-002	3.8e-002	-4.646e-005
1144	-3.3187e-002	3.7398e-002	3.9e-002	-4.646e-005
1145	-3.3188e-002	3.7398e-002	4.e-002	-4.646e-005
1146	-3.3188e-002	3.7398e-002	4.1e-002	-4.646e-005
1147	-3.3188e-002	3.7397e-002	4.2e-002	-4.646e-005
1148	-3.3188e-002	3.7397e-002	4.3e-002	-4.646e-005
1149	-3.3188e-002	3.7397e-002	4.4e-002	-4.646e-005
1150	-3.3188e-002	3.7397e-002	4.5e-002	-4.646e-005
1151	-3.3189e-002	3.7397e-002	4.6e-002	-4.646e-005
1152	3.2435e-002	3.8053e-002	4.6e-002	4.6147e-005
1153	3.2435e-002	3.8053e-002	4.5e-002	4.6147e-005
1154	3.2435e-002	3.8053e-002	4.4e-002	4.6147e-005
1155	3.2435e-002	3.8053e-002	4.3e-002	4.6147e-005
1156	3.2434e-002	3.8053e-002	4.1e-002	4.6147e-005
1157	3.2434e-002	3.8053e-002	4.e-002	4.6147e-005
1158	3.2434e-002	3.8053e-002	3.9e-002	4.6147e-005
1159	3.2434e-002	3.8053e-002	3.8e-002	4.6147e-005
1160	3.2434e-002	3.8053e-002	3.7e-002	4.6147e-005
1161	3.2434e-002	3.8053e-002	3.6e-002	4.6147e-005
1162	3.2434e-002	3.8053e-002	3.5e-002	4.6147e-005
1163	3.2434e-002	3.8053e-002	3.4e-002	4.6147e-005
1164	3.2434e-002	3.8053e-002	3.3e-002	4.6147e-005
1165	3.2434e-002	3.8053e-002	3.2e-002	4.6147e-005
1166	3.2434e-002	3.8053e-002	3.1e-002	4.6147e-005
1167	3.2434e-002	3.8053e-002	3.e-002	4.6147e-005
1168	3.2434e-002	3.8053e-002	2.9e-002	4.6147e-005
1169	3.2434e-002	3.8053e-002	2.8e-002	4.6147e-005
1170	3.2434e-002	3.8053e-002	2.7e-002	4.6147e-005
1171	3.2434e-002	3.8053e-002	2.6e-002	4.6147e-005
1172	3.2434e-002	3.8053e-002	2.5e-002	4.6146e-005
1173	3.2434e-002	3.8053e-002	2.4e-002	4.6146e-005
1174	3.2434e-002	3.8053e-002	2.3e-002	4.6146e-005
1175	3.2434e-002	3.8053e-002	2.2e-002	4.6146e-005
1176	3.2434e-002	3.8053e-002	2.1e-002	4.6146e-005
1177	3.2434e-002	3.8053e-002	2.e-002	4.6146e-005
1178	3.2434e-002	3.8053e-002	1.9e-002	4.6146e-005
1179	3.2434e-002	3.8053e-002	1.8e-002	4.6146e-005
1180	3.2434e-002	3.8053e-002	1.7e-002	4.6146e-005
1181	3.2433e-002	3.8054e-002	1.6e-002	4.6146e-005
1182	3.2433e-002	3.8054e-002	1.5e-002	4.6146e-005
1183	3.2433e-002	3.8054e-002	1.4e-002	4.6146e-005
1184	3.2433e-002	3.8054e-002	1.3e-002	4.6146e-005
1185	3.2433e-002	3.8054e-002	1.2e-002	4.6146e-005
1186	3.2433e-002	3.8054e-002	1.1e-002	4.6146e-005
1187	3.2433e-002	3.8054e-002	1.e-002	4.6146e-005
1188	3.2433e-002	3.8054e-002	9.e-003	4.6146e-005
1189	3.2433e-002	3.8054e-002	8.e-003	4.6146e-005
1190	3.2433e-002	3.8054e-002	7.e-003	4.6146e-005
1191	3.2433e-002	3.8054e-002	5.0001e-003	4.6146e-005
1192	3.2433e-002	3.8054e-002	4.0001e-003	4.6147e-005
1193	3.1672e-002	3.869e-002	4.e-003	4.5762e-005
1194	3.0896e-002	3.9312e-002	4.e-003	4.5308e-005
1195	3.0108e-002	3.9918e-002	4.e-003	4.4784e-005
1196	2.9309e-002	4.0509e-002	4.e-003	4.4192e-005
1197	2.8498e-002	4.1084e-002	4.e-003	4.3533e-005
1198	2.7675e-002	4.1642e-002	4.e-003	4.2807e-005
1199	2.6842e-002	4.2184e-002	4.e-003	4.2016e-005
1200	2.5998e-002	4.271e-002	4.e-003	4.1162e-005
1201	2.5143e-002	4.3218e-002	4.e-003	4.0246e-005
1202	2.3405e-002	4.4184e-002	4.e-003	3.8232e-005
1203	2.163e-002	4.5079e-002	4.e-003	3.5989e-005
1204	1.9821e-002	4.5904e-002	4.e-003	3.3531e-005
1205	1.798e-002	4.6655e-002	4.e-003	3.0872e-005
1206	1.6111e-002	4.7333e-002	4.e-003	2.8029e-005
1207	1.4217e-002	4.7936e-002	4.e-003	2.502e-005
1208	1.23e-002	4.8464e-002	4.e-003	2.1863e-005
1209	1.0363e-002	4.8914e-002	4.e-003	1.8577e-005
1210	8.4103e-003	4.9288e-002	4.e-003	1.5181e-005
1211	6.4441e-003	4.9583e-002	4.e-003	1.1695e-005
1212	4.4678e-003	4.98e-002	4.e-003	8.1405e-006
1213	2.4844e-003	4.9938e-002	4.e-003	4.5381e-006
1214	4.9706e-004	4.9998e-002	4.e-003	9.0897e-007
1215	-1.4911e-003	4.9978e-002	4.e-003	-2.7255e-006
1216	-3.4768e-003	4.9879e-002	4.e-003	-6.3439e-006
1217	-5.4571e-003	4.9701e-002	4.e-003	-9.925e-006
1218	-7.4287e-003	4.9445e-002	4.e-003	-1.3448e-005
1219	-9.3886e-003	4.9111e-002	4.e-003	-1.6891e-005
1220	-1.1334e-002	4.8699e-002	4.e-003	-2.0235e-005
1221	-1.3261e-002	4.8209e-002	4.e-003	-2.3459e-005
1222	-1.5167e-002	4.7644e-002	4.e-003	-2.6545e-005
1223	-1.7049e-002	4.7003e-002	4.e-003	-2.9473e-005
1224	-1.8904e-002	4.6289e-002	4.e-003	-3.2225e-005
1225	-2.073e-002	4.55e-002	4.e-003	-3.4786e-005
1226	-2.2522e-002	4.464e-002	4.e-003	-3.7139e-005
1227	-2.4279e-002	4.371e-002	4.e-003	-3.9269e-005
1228	-2.5998e-002	4.271e-002	4.e-003	-4.1162e-005
1229	-2.7675e-002	4.1642e-002	4.e-003	-4.2807e-005
1230	-2.9309e-002	4.0509e-002	4.e-003	-4.4192e-005
1231	-3.1672e-002	3.869e-002	4.e-003	-4.5762e-005
1232	-3.2435e-002	3.8053e-002	4.e-003	-4.6147e-005
1233	-3.2435e-002	3.8053e-002	5.e-003	-4.6147e-005
1234	-3.2435e-002	3.8053e-002	6.e-003	-4.6146e-005
1235	-3.2435e-002	3.8053e-002	7.e-003	-4.6146e-005
1236	-3.2428e-002	3.8058e-002	9.001e-003	-4.6143e-005
1237	-3.2427e-002	3.8059e-002	1.e-002	-4.6142e-005
1238	-3.2426e-002	3.806e-002	1.0999e-002	-4.6142e-005
1239	-3.2428e-002	3.8058e-002	1.1996e-002	-4.6143e-005
1240	-3.2427e-002	3.8059e-002	1.2996e-002	-4.6144e-005
1241	-3.2434e-002	3.8053e-002	1.4e-002	-4.6145e-005
1242	-3.2434e-002	3.8053e-002	1.5e-002	-4.6146e-005
1243	-3.2434e-002	3.8053e-002	1.6e-002	-4.6146e-005
1244	-3.2434e-002	3.8053e-002	1.7e-002	-4.6146e-005
1245	-3.2434e-002	3.8053e-002	1.8e-002	-4.6146e-005
1246	-3.2434e-002	3.8053e-002	1.9e-002	-4.6146e-005
1247	-3.2434e-002	3.8053e-002	2.e-002	-4.6146e-005
1248	-3.2434e-002	3.8053e-002	2.1e-002	-4.6146e-005
1249	-3.2434e-002	3.8053e-002	2.2e-002	-4.6146e-005
1250	-3.2434e-002	3.8053e-002	2.3e-002	-4.6146e-005
1251	-3.2434e-002	3.8053e-002	2.4e-002	-4.6146e-005
1252	-3.2434e-002	3.8053e-002	2.5e-002	-4.6147e-005
1253	-3.2434e-002	3.8053e-002	2.6e-002	-4.6147e-005
1254	-3.2434e-002	3.8053e-002	2.7e-002	-4.6147e-005
1255	-3.2434e-002	3.8053e-002	2.8e-002	-4.6147e-005
1256	-3.2434e-002	3.8053e-002	2.9e-002	-4.6147e-005
1257	-3.2434e-002	3.8053e-002	3.e-002	-4.6147e-005
1258	-3.2434e-002	3.8053e-002	3.1e-002	-4.6147e-005
1259	-3.2434e-002	3.8053e-002	3.2e-002	-4.6147e-005
1260	-3.2434e-002	3.8053e-002	3.3e-002	-4.6147e-005
1261	-3.2434e-002	3.8053e-002	3.4e-002	-4.6147e-005
1262	-3.2434e-002	3.8053e-002	3.5e-002	-4.6146e-005
1263	-3.2434e-002	3.8053e-002	3.6e-002	-4.6146e-005
1264	-3.2433e-002	3.8054e-002	3.7e-002	-4.6146e-005
1265	-3.2433e-002	3.8054e-002	3.8e-002	-4.6146e-005
1266	-3.2433e-002	3.8054e-002	3.9e-002	-4.6145e-005
1267	-3.2433e-002	3.8054e-002	4.e-002	-4.6146e-005
1268	-3.2433e-002	3.8054e-002	4.1e-002	-4.6146e-005
1269	-3.2433e-002	3.8054e-002	4.2e-002	-4.6146e-005
1270	-3.2433e-002	3.8054e-002	4.3e-002	-4.6147e-005
1271	-3.2433e-002	3.8054e-002	4.4e-002	-4.6147e-005
1272	-3.2433e-002	3.8054e-002	4.5e-002	-4.6147e-005
1273	-3.2433e-002	3.8054e-002	4.6e-002	-4.6147e-005
1274	-3.1672e-002	3.869e-002	4.6e-002	-4.5762e-005
1275	-3.0896e-002	3.9312e-002	4.6e-002	-4.5308e-005
1276	-2.9309e-002	4.0509e-002	4.6e-002	-4.4192e-005
1277	-2.8498e-002	4.1084e-002	4.6e-002	-4.3533e-005
1278	-2.7675e-002	4.1642e-002	4.6e-002	-4.2807e-005
1279	-2.5998e-002	4.271e-002	4.6e-002	-4.1162e-005
1280	-2.5143e-002	4.3218e-002	4.6e-002	-4.0246e-005
1281	-2.4279e-002	4.371e-002	4.6e-002	-3.9268e-005
1282	-2.3405e-002	4.4184e-002	4.6e-002	-3.8232e-005
1283	-2.2522e-002	4.464e-002	4.6e-002	-3.7139e-005
1284	-2.163e-002	4.5079e-002	4.6e-002	-3.5989e-005
1285	-2.073e-002	4.55e-002	4.6e-002	-3.4786e-005
1286	-1.9821e-002	4.5904e-002	4.6e-002	-3.3531e-005
1287	-1.8904e-002	4.6289e-002	4.6e-002	-3.2225e-005
1288	-1.798e-002	4.6655e-002	4.6e-002	-3.0872e-005
1289	-1.7049e-002	4.7003e-002	4.6e-002	-2.9473e-005
1290	-1.6111e-002	4.7333e-002	4.6e-002	-2.8029e-005
1291	-1.5167e-002	4.7644e-002	4.6e-002	-2.6545e-005
1292	-1.4217e-002	4.7936e-002	4.6e-002	-2.502e-005
1293	-1.3261e-002	4.8209e-002	4.6e-002	-2.3459e-005
1294	-1.23e-002	4.8464e-002	4.6e-002	-2.1863e-005
1295	-1.1334e-002	4.8699e-002	4.6e-002	-2.0235e-005
1296	-1.0363e-002	4.8914e-002	4.6e-002	-1.8577e-005
1297	-9.3886e-003	4.9111e-002	4.6e-002	-1.6891e-005
1298	-8.4103e-003	4.9288e-002	4.6e-002	-1.5181e-005
1299	-7.4287e-003	4.9445e-002	4.6e-002	-1.3448e-005
1300	-6.4442e-003	4.9583e-002	4.6e-002	-1.1695e-005
1301	-5.4571e-003	4.9701e-002	4.6e-002	-9.925e-006
1302	-4.4678e-003	4.98e-002	4.6e-002	-8.1405e-006
1303	-3.4768e-003	4.9879e-002	4.6e-002	-6.3439e-006
1304	-2.4844e-003	4.9938e-002	4.6e-002	-4.5381e-006
1305	-1.4911e-003	4.9978e-002	4.6e-002	-2.7255e-006
1306	-4.9708e-004	4.9998e-002	4.6e-002	-9.0897e-007
1307	4.9706e-004	4.9998e-002	4.6e-002	9.0892e-007
1308	1.491e-003	4.9978e-002	4.6e-002	2.7255e-006
1309	2.4844e-003	4.9938e-002	4.6e-002	4.538e-006
1310	3.4768e-003	4.9879e-002	4.6e-002	6.3439e-006
1311	4.4678e-003	4.98e-002	4.6e-002	8.1404e-006
1312	5.4571e-003	4.9701e-002	4.6e-002	9.925e-006
1313	6.4441e-003	4.9583e-002	4.6e-002	1.1695e-005
1314	7.4287e-003	4.9445e-002	4.6e-002	1.3448e-005
1315	8.4103e-003	4.9288e-002	4.6e-002	1.5181e-005
1316	9.3886e-003	4.9111e-002	4.6e-002	1.6891e-005
1317	1.0363e-002	4.8914e-002	4.6e-002	1.8577e-005
1318	1.1334e-002	4.8699e-002	4.6e-002	2.0235e-005
1319	1.23e-002	4.8464e-002	4.6e-002	2.1863e-005
1320	1.3261e-002	4.8209e-002	4.6e-002	2.3459e-005
1321	1.4217e-002	4.7936e-002	4.6e-002	2.502e-005
1322	1.5167e-002	4.7644e-002	4.6e-002	2.6545e-005
1323	1.6111e-002	4.7333e-002	4.6e-002	2.8029e-005
1324	1.7049e-002	4.7003e-002	4.6e-002	2.9472e-005
1325	1.798e-002	4.6655e-002	4.6e-002	3.0872e-005
1326	1.8904e-002	4.6289e-002	4.6e-002	3.2225e-005
1327	1.9821e-002	4.5904e-002	4.6e-002	3.3531e-005
1328	2.073e-002	4.55e-002	4.6e-002	3.4786e-005
1329	2.163e-002	4.5079e-002	4.6e-002	3.5989e-005
1330	2.2522e-002	4.464e-002	4.6e-002	3.7139e-005
1331	2.3405e-002	4.4184e-002	4.6e-002	3.8232e-005
1332	2.4279e-002	4.371e-002	4.6e-002	3.9268e-005
1333	2.5143e-002	4.3218e-002	4.6e-002	4.0246e-005
1334	2.5998e-002	4.271e-002	4.6e-002	4.1162e-005
1335	2.6842e-002	4.2184e-002	4.6e-002	4.2016e-005
1336	2.7675e-002	4.1642e-002	4.6e-002	4.2807e-005
1337	2.8498e-002	4.1084e-002	4.6e-002	4.3533e-005
1338	3.0108e-002	3.9918e-002	4.6e-002	4.4784e-005
1339	3.0896e-002	3.9312e-002	4.6e-002	4.5308e-005
1340	3.1672e-002	3.869e-002	4.6e-002	4.5762e-005
1341	3.1672e-002	3.869e-002	5.e-003	4.5762e-005
1342	-3.1672e-002	3.869e-002	4.5e-002	-4.5762e-005
1343	-3.0896e-002	3.9312e-002	4.5e-002	-4.5308e-005
1344	-3.0108e-002	3.9919e-002	4.5e-002	-4.4784e-005
1345	-2.9309e-002	4.0509e-002	4.5e-002	-4.4192e-005
1346	-2.8498e-002	4.1084e-002	4.5e-002	-4.3533e-005
1347	-2.7675e-002	4.1642e-002	4.5e-002	-4.2807e-005
1348	-2.6842e-002	4.2184e-002	4.5e-002	-4.2016e-005
1349	-2.5998e-002	4.271e-002	4.5e-002	-4.1162e-005
1350	-2.5143e-002	4.3218e-002	4.5e-002	-4.0246e-005
1351	-2.4279e-002	4.371e-002	4.5e-002	-3.9269e-005
1352	-2.3405e-002	4.4184e-002	4.5e-002	-3.8232e-005
1353	-2.2522e-002	4.464e-002	4.5e-002	-3.7139e-005
1354	-2.163e-002	4.5079e-002	4.5e-002	-3.5989e-005
1355	-2.073e-002	4.55e-002	4.5e-002	-3.4786e-005
1356	-1.9821e-002	4.5904e-002	4.5e-002	-3.3531e-005
1357	-1.8904e-002	4.6288e-002	4.5e-002	-3.2225e-005
1358	-1.798e-002	4.6655e-002	4.5e-002	-3.0872e-005
1359	-1.7049e-002	4.7003e-002	4.5e-002	-2.9473e-005
1360	-1.6111e-002	4.7333e-002	4.5e-002	-2.8029e-005
1361	-1.5167e-002	4.7644e-002	4.5e-002	-2.6545e-005
1362	-1.4217e-002	4.7936e-002	4.5e-002	-2.502e-005
1363	-1.3261e-002	4.8209e-002	4.5e-002	-2.3459e-005
1364	-1.23e-002	4.8464e-002	4.5e-002	-2.1863e-005
1365	-1.1334e-002	4.8699e-002	4.5e-002	-2.0235e-005
1366	-1.0363e-002	4.8914e-002	4.5e-002	-1.8577e-005
1367	-9.3887e-003	4.9111e-002	4.5e-002	-1.6891e-005
1368	-8.4103e-003	4.9288e-002	4.5e-002	-1.5181e-005
1369	-7.4288e-003	4.9445e-002	4.5e-002	-1.3448e-005
1370	-6.4442e-003	4.9583e-002	4.5e-002	-1.1695e-005
1371	-5.4571e-003	4.9701e-002	4.5e-002	-9.925e-006
1372	-4.4678e-003	4.98e-002	4.5e-002	-8.1405e-006
1373	-3.4769e-003	4.9879e-002	4.5e-002	-6.3439e-006
1374	-2.4844e-003	4.9938e-002	4.5e-002	-4.5381e-006
1375	-1.4911e-003	4.9978e-002	4.5e-002	-2.7255e-006
1376	-4.9708e-004	4.9998e-002	4.5e-002	-9.0899e-007
1377	4.9702e-004	4.9998e-002	4.5e-002	9.089e-007
1378	1.491e-003	4.9978e-002	4.5e-002	2.7255e-006
1379	2.4844e-003	4.9938e-002	4.5e-002	4.538e-006
1380	3.4768e-003	4.9879e-002	4.5e-002	6.3439e-006
1381	4.4678e-003	4.98e-002	4.5e-002	8.1404e-006
1382	5.4571e-003	4.9701e-002	4.5e-002	9.925e-006
1383	6.4441e-003	4.9583e-002	4.5e-002	1.1695e-005
1384	7.4287e-003	4.9445e-002	4.5e-002	1.3448e-005
1385	8.4103e-003	4.9288e-002	4.5e-002	1.5181e-005
1386	9.3886e-003	4.9111e-002	4.5e-002	1.6891e-005
1387	1.0363e-002	4.8914e-002	4.5e-002	1.8577e-005
1388	1.1334e-002	4.8699e-002	4.5e-002	2.0235e-005
1389	1.23e-002	4.8464e-002	4.5e-002	2.1863e-005
1390	1.3261e-002	4.8209e-002	4.5e-002	2.3459e-005
1391	1.4217e-002	4.7936e-002	4.5e-002	2.502e-005
1392	1.5167e-002	4.7644e-002	4.5e-002	2.6545e-005
1393	1.6111e-002	4.7333e-002	4.5e-002	2.8029e-005
1394	1.7049e-002	4.7003e-002	4.5e-002	2.9472e-005
1395	1.798e-002	4.6655e-002	4.5e-002	3.0872e-005
1396	1.8904e-002	4.6289e-002	4.5e-002	3.2225e-005
1397	1.9821e-002	4.5904e-002	4.5e-002	3.3531e-005
1398	2.073e-002	4.55e-002	4.5e-002	3.4786e-005
1399	2.163e-002	4.5079e-002	4.5e-002	3.5989e-005
1400	2.2522e-002	4.464e-002	4.5e-002	3.7139e-005
1401	2.3405e-002	4.4184e-002	4.5e-002	3.8232e-005
1402	2.4279e-002	4.371e-002	4.5e-002	3.9268e-005
1403	2.5143e-002	4.3218e-002	4.5e-002	4.0246e-005
1404	2.5998e-002	4.271e-002	4.5e-002	4.1162e-005
1405	2.6842e-002	4.2184e-002	4.5e-002	4.2016e-005
1406	2.7675e-002	4.1642e-002	4.5e-002	4.2807e-005
1407	2.8498e-002	4.1084e-002	4.5e-002	4.3533e-005
1408	2.9309e-002	4.0509e-002	4.5e-002	4.4192e-005
1409	3.0108e-002	3.9918e-002	4.5e-002	4.4784e-005
1410	3.0896e-002	3.9312e-002	4.5e-002	4.5308e-005
1411	3.1672e-002	3.869e-002	4.5e-002	4.5762e-005
1412	3.1672e-002	3.869e-002	4.4e-002	4.5762e-005
1413	3.1672e-002	3.869e-002	4.3e-002	4.5762e-005
1414	3.1671e-002	3.869e-002	4.2e-002	4.5762e-005
1415	3.1671e-002	3.869e-002	4.1e-002	4.5762e-005
1416	3.1671e-002	3.869e-002	4.e-002	4.5762e-005
1417	3.1671e-002	3.869e-002	3.9e-002	4.5762e-005
1418	3.1671e-002	3.869e-002	3.7e-002	4.5762e-005
1419	3.1671e-002	3.869e-002	3.5e-002	4.5762e-005
1420	3.1671e-002	3.869e-002	3.3e-002	4.5762e-005
1421	3.1671e-002	3.869e-002	3.1e-002	4.5762e-005
1422	3.1671e-002	3.869e-002	2.9e-002	4.5762e-005
1423	3.1671e-002	3.869e-002	2.7e-002	4.5762e-005
1424	3.1671e-002	3.869e-002	2.5e-002	4.5762e-005
1425	3.1671e-002	3.869e-002	2.3e-002	4.5762e-005
1426	3.1671e-002	3.869e-002	2.1e-002	4.5762e-005
1427	3.1671e-002	3.869e-002	1.9e-002	4.5762e-005
1428	3.1671e-002	3.869e-002	1.7e-002	4.5762e-005
1429	3.1671e-002	3.869e-002	1.5e-002	4.5762e-005
1430	3.1671e-002	3.8691e-002	1.3e-002	4.5762e-005
1431	3.1671e-002	3.8691e-002	1.2e-002	4.5762e-005
1432	3.1671e-002	3.8691e-002	1.1e-002	4.5762e-005
1433	3.1671e-002	3.8691e-002	1.e-002	4.5762e-005
1434	3.1671e-002	3.8691e-002	9.0001e-003	4.5762e-005
1435	3.1671e-002	3.8691e-002	8.0001e-003	4.5762e-005
1436	3.167e-002	3.8691e-002	7.0001e-003	4.5762e-005
1437	3.167e-002	3.8691e-002	6.0001e-003	4.5762e-005
1438	3.0896e-002	3.9312e-002	5.e-003	4.5308e-005
1439	3.0108e-002	3.9918e-002	5.e-003	4.4784e-005
1440	2.9309e-002	4.0509e-002	5.e-003	4.4192e-005
1441	2.8498e-002	4.1084e-002	5.e-003	4.3533e-005
1442	2.7675e-002	4.1642e-002	5.e-003	4.2807e-005
1443	2.6842e-002	4.2184e-002	5.e-003	4.2016e-005
1444	2.5998e-002	4.271e-002	5.e-003	4.1162e-005
1445	2.5143e-002	4.3218e-002	5.e-003	4.0246e-005
1446	2.4279e-002	4.371e-002	5.e-003	3.9269e-005
1447	2.3405e-002	4.4184e-002	5.e-003	3.8232e-005
1448	2.2522e-002	4.464e-002	5.e-003	3.7139e-005
1449	2.163e-002	4.5079e-002	5.e-003	3.5989e-005
1450	2.073e-002	4.55e-002	5.e-003	3.4786e-005
1451	1.9821e-002	4.5904e-002	5.e-003	3.3531e-005
1452	1.8904e-002	4.6288e-002	5.e-003	3.2225e-005
1453	1.798e-002	4.6655e-002	5.e-003	3.0872e-005
1454	1.7049e-002	4.7003e-002	5.e-003	2.9473e-005
1455	1.6111e-002	4.7333e-002	5.e-003	2.8029e-005
1456	1.5167e-002	4.7644e-002	5.e-003	2.6545e-005
1457	1.4217e-002	4.7936e-002	5.e-003	2.502e-005
1458	1.3261e-002	4.8209e-002	5.e-003	2.3459e-005
1459	1.23e-002	4.8464e-002	5.e-003	2.1863e-005
1460	1.1334e-002	4.8699e-002	5.e-003	2.0235e-005
1461	1.0363e-002	4.8914e-002	5.e-003	1.8577e-005
1462	9.3887e-003	4.9111e-002	5.e-003	1.6891e-005
1463	8.4103e-003	4.9288e-002	5.e-003	1.5181e-005
1464	7.4288e-003	4.9445e-002	5.e-003	1.3448e-005
1465	6.4442e-003	4.9583e-002	5.e-003	1.1695e-005
1466	5.4571e-003	4.9701e-002	5.e-003	9.925e-006
1467	4.4678e-003	4.98e-002	5.e-003	8.1405e-006
1468	3.4769e-003	4.9879e-002	5.e-003	6.344e-006
1469	2.4844e-003	4.9938e-002	5.e-003	4.5381e-006
1470	1.4911e-003	4.9978e-002	5.e-003	2.7255e-006
1471	4.9708e-004	4.9998e-002	5.e-003	9.0899e-007
1472	-4.9702e-004	4.9998e-002	5.e-003	-9.089e-007
1473	-1.491e-003	4.9978e-002	5.e-003	-2.7255e-006
1474	-2.4844e-003	4.9938e-002	5.e-003	-4.538e-006
1475	-3.4768e-003	4.9879e-002	5.e-003	-6.3439e-006
1476	-4.4678e-003	4.98e-002	5.e-003	-8.1404e-006
1477	-5.4571e-003	4.9701e-002	5.e-003	-9.925e-006
1478	-6.4441e-003	4.9583e-002	5.e-003	-1.1695e-005
1479	-7.4287e-003	4.9445e-002	5.e-003	-1.3448e-005
1480	-8.4103e-003	4.9288e-002	5.e-003	-1.5181e-005
1481	-9.3886e-003	4.9111e-002	5.e-003	-1.6891e-005
1482	-1.0363e-002	4.8914e-002	5.e-003	-1.8577e-005
1483	-1.1334e-002	4.8699e-002	5.e-003	-2.0235e-005
1484	-1.23e-002	4.8464e-002	5.e-003	-2.1863e-005
1485	-1.3261e-002	4.8209e-002	5.e-003	-2.3459e-005
1486	-1.4217e-002	4.7936e-002	5.e-003	-2.502e-005
1487	-1.5167e-002	4.7644e-002	5.e-003	-2.6545e-005
1488	-1.6111e-002	4.7333e-002	5.e-003	-2.8029e-005
1489	-1.7049e-002	4.7003e-002	5.e-003	-2.9472e-005
1490	-1.798e-002	4.6655e-002	5.e-003	-3.0872e-005
1491	-1.8904e-002	4.6289e-002	5.e-003	-3.2225e-005
1492	-1.9821e-002	4.5904e-002	5.e-003	-3.3531e-005
1493	-2.073e-002	4.55e-002	5.e-003	-3.4786e-005
1494	-2.163e-002	4.5079e-002	5.e-003	-3.5989e-005
1495	-2.2522e-002	4.464e-002	5.e-003	-3.7139e-005
1496	-2.3405e-002	4.4184e-002	5.e-003	-3.8232e-005
1497	-2.4279e-002	4.371e-002	5.e-003	-3.9268e-005
1498	-2.5143e-002	4.3218e-002	5.e-003	-4.0246e-005
1499	-2.5998e-002	4.271e-002	5.e-003	-4.1162e-005
1500	-2.6842e-002	4.2184e-002	5.e-003	-4.2015e-005
1501	-2.7673e-002	4.1644e-002	4.991e-003	-4.2805e-005
1502	-2.8497e-002	4.1084e-002	4.9885e-003	-4.3532e-005
1503	-2.931e-002	4.0509e-002	4.9913e-003	-4.4192e-005
1504	-3.0108e-002	3.9919e-002	5.e-003	-4.4784e-005
1505	-3.1672e-002	3.869e-002	5.e-003	-4.5762e-005
1506	-3.1672e-002	3.869e-002	6.e-003	-4.5762e-005
1507	-3.1672e-002	3.869e-002	7.e-003	-4.576e-005
1508	-3.166e-002	3.8699e-002	8.0048e-003	-4.5756e-005
1509	-3.1648e-002	3.8709e-002	9.0041e-003	-4.5751e-005
1510	-3.1642e-002	3.8714e-002	9.998e-003	-4.5748e-005
1511	-3.1648e-002	3.8709e-002	1.099e-002	-4.5749e-005
1512	-3.1656e-002	3.8702e-002	1.299e-002	-4.5752e-005
1513	-3.1666e-002	3.8695e-002	1.4996e-002	-4.5758e-005
1514	-3.1671e-002	3.869e-002	1.7e-002	-4.5761e-005
1515	-3.1671e-002	3.869e-002	1.9e-002	-4.5762e-005
1516	-3.1671e-002	3.869e-002	2.1e-002	-4.5764e-005
1517	-3.1671e-002	3.869e-002	2.3e-002	-4.5763e-005
1518	-3.1671e-002	3.869e-002	2.5e-002	-4.5762e-005
1519	-3.1671e-002	3.869e-002	2.7e-002	-4.5761e-005
1520	-3.1671e-002	3.8691e-002	2.9e-002	-4.5761e-005
1521	-3.1671e-002	3.8691e-002	3.1e-002	-4.5761e-005
1522	-3.1671e-002	3.8691e-002	3.3e-002	-4.5761e-005
1523	-3.1671e-002	3.8691e-002	3.5e-002	-4.576e-005
1524	-3.1663e-002	3.8697e-002	3.7e-002	-4.5758e-005
1525	-3.1662e-002	3.8698e-002	3.8999e-002	-4.5757e-005
1526	-3.167e-002	3.8691e-002	4.1e-002	-4.576e-005
1527	-3.167e-002	3.8691e-002	4.3e-002	-4.5761e-005
1528	-3.167e-002	3.8691e-002	4.4e-002	-4.5762e-005
1529	3.0896e-002	3.9312e-002	4.4e-002	4.5308e-005
1530	3.0896e-002	3.9312e-002	4.3e-002	4.5308e-005
1531	3.0896e-002	3.9312e-002	4.2e-002	4.5308e-005
1532	3.0896e-002	3.9312e-002	4.1e-002	4.5308e-005
1533	3.0896e-002	3.9312e-002	4.e-002	4.5308e-005
1534	3.0896e-002	3.9312e-002	3.9e-002	4.5308e-005
1535	3.0896e-002	3.9312e-002	3.8e-002	4.5308e-005
1536	3.0896e-002	3.9312e-002	3.7e-002	4.5308e-005
1537	3.0896e-002	3.9312e-002	3.6e-002	4.5308e-005
1538	3.0896e-002	3.9312e-002	3.5e-002	4.5308e-005
1539	3.0896e-002	3.9312e-002	3.4e-002	4.5308e-005
1540	3.0896e-002	3.9312e-002	3.3e-002	4.5308e-005
1541	3.0896e-002	3.9312e-002	3.2e-002	4.5308e-005
1542	3.0896e-002	3.9312e-002	3.1e-002	4.5308e-005
1543	3.0896e-002	3.9312e-002	3.e-002	4.5308e-005
1544	3.0896e-002	3.9312e-002	2.9e-002	4.5308e-005
1545	3.0896e-002	3.9312e-002	2.8e-002	4.5308e-005
1546	3.0896e-002	3.9312e-002	2.7e-002	4.5308e-005
1547	3.0896e-002	3.9312e-002	2.6e-002	4.5308e-005
1548	3.0897e-002	3.9312e-002	2.5e-002	4.5308e-005
1549	3.0897e-002	3.9312e-002	2.4e-002	4.5308e-005
1550	3.0897e-002	3.9312e-002	2.3e-002	4.5308e-005
1551	3.0897e-002	3.9312e-002	2.2e-002	4.5308e-005
1552	3.0897e-002	3.9311e-002	2.1e-002	4.5308e-005
1553	3.0897e-002	3.9311e-002	2.e-002	4.5308e-005
1554	3.0897e-002	3.9311e-002	1.9e-002	4.5308e-005
1555	3.0897e-002	3.9311e-002	1.8e-002	4.5308e-005
1556	3.0897e-002	3.9311e-002	1.7e-002	4.5308e-005
1557	3.0897e-002	3.9311e-002	1.6e-002	4.5308e-005
1558	3.0897e-002	3.9311e-002	1.5e-002	4.5308e-005
1559	3.0897e-002	3.9311e-002	1.4e-002	4.5309e-005
1560	3.0897e-002	3.9311e-002	1.3e-002	4.5309e-005
1561	3.0897e-002	3.9311e-002	1.2e-002	4.5309e-005
1562	3.0897e-002	3.9311e-002	1.1e-002	4.5309e-005
1563	3.0898e-002	3.9311e-002	1.e-002	4.5309e-005
1564	3.0898e-002	3.9311e-002	9.e-003	4.5309e-005
1565	3.0898e-002	3.9311e-002	8.e-003	4.5309e-005
1566	3.0898e-002	3.9311e-002	7.e-003	4.5309e-005
1567	3.0898e-002	3.9311e-002	6.e-003	4.5308e-005
1568	3.0108e-002	3.9918e-002	6.e-003	4.4785e-005
1569	2.9309e-002	4.0509e-002	6.e-003	4.4192e-005
1570	2.8498e-002	4.1084e-002	6.e-003	4.3533e-005
1571	2.7675e-002	4.1642e-002	6.e-003	4.2807e-005
1572	2.6842e-002	4.2184e-002	6.e-003	4.2016e-005
1573	2.5998e-002	4.271e-002	6.e-003	4.1162e-005
1574	2.5143e-002	4.3218e-002	6.e-003	4.0246e-005
1575	2.4279e-002	4.371e-002	6.e-003	3.9269e-005
1576	2.3405e-002	4.4184e-002	6.e-003	3.8232e-005
1577	2.2522e-002	4.464e-002	6.e-003	3.7139e-005
1578	2.163e-002	4.5079e-002	6.e-003	3.5989e-005
1579	2.073e-002	4.55e-002	6.e-003	3.4786e-005
1580	1.9821e-002	4.5904e-002	6.e-003	3.3531e-005
1581	1.8904e-002	4.6289e-002	6.e-003	3.2225e-005
1582	1.798e-002	4.6655e-002	6.e-003	3.0872e-005
1583	1.7049e-002	4.7003e-002	6.e-003	2.9473e-005
1584	1.6111e-002	4.7333e-002	6.e-003	2.8029e-005
1585	1.5167e-002	4.7644e-002	6.e-003	2.6545e-005
1586	1.4217e-002	4.7936e-002	6.e-003	2.502e-005
1587	1.3261e-002	4.8209e-002	6.e-003	2.3459e-005
1588	1.23e-002	4.8464e-002	6.e-003	2.1863e-005
1589	1.1334e-002	4.8699e-002	6.e-003	2.0235e-005
1590	1.0363e-002	4.8914e-002	6.e-003	1.8577e-005
1591	9.3886e-003	4.9111e-002	6.e-003	1.6891e-005
1592	8.4103e-003	4.9288e-002	6.e-003	1.5181e-005
1593	7.4288e-003	4.9445e-002	6.e-003	1.3448e-005
1594	6.4442e-003	4.9583e-002	6.e-003	1.1695e-005
1595	5.4571e-003	4.9701e-002	6.e-003	9.9251e-006
1596	4.4678e-003	4.98e-002	6.e-003	8.1405e-006
1597	3.4769e-003	4.9879e-002	6.e-003	6.344e-006
1598	2.4844e-003	4.9938e-002	6.e-003	4.5381e-006
1599	1.4911e-003	4.9978e-002	6.e-003	2.7255e-006
1600	4.9707e-004	4.9998e-002	6.e-003	9.0899e-007
1601	-4.9703e-004	4.9998e-002	6.e-003	-9.089e-007
1602	-1.4911e-003	4.9978e-002	6.e-003	-2.7255e-006
1603	-2.4844e-003	4.9938e-002	6.e-003	-4.538e-006
1604	-3.4768e-003	4.9879e-002	6.e-003	-6.3439e-006
1605	-4.4678e-003	4.98e-002	6.e-003	-8.1404e-006
1606	-5.4571e-003	4.9701e-002	6.e-003	-9.925e-006
1607	-6.4441e-003	4.9583e-002	6.e-003	-1.1695e-005
1608	-7.4287e-003	4.9445e-002	6.e-003	-1.3448e-005
1609	-8.4103e-003	4.9288e-002	6.e-003	-1.5181e-005
1610	-9.3886e-003	4.9111e-002	6.e-003	-1.6891e-005
1611	-1.0363e-002	4.8914e-002	6.e-003	-1.8577e-005
1612	-1.1334e-002	4.8699e-002	6.e-003	-2.0235e-005
1613	-1.23e-002	4.8464e-002	6.e-003	-2.1863e-005
1614	-1.3261e-002	4.8209e-002	6.e-003	-2.3459e-005
1615	-1.4217e-002	4.7936e-002	6.e-003	-2.502e-005
1616	-1.5167e-002	4.7644e-002	6.e-003	-2.6545e-005
1617	-1.6111e-002	4.7333e-002	6.e-003	-2.8029e-005
1618	-1.7049e-002	4.7003e-002	6.e-003	-2.9472e-005
1619	-1.798e-002	4.6655e-002	6.e-003	-3.0872e-005
1620	-1.8904e-002	4.6289e-002	6.e-003	-3.2225e-005
1621	-1.9821e-002	4.5904e-002	6.e-003	-3.3531e-005
1622	-2.073e-002	4.55e-002	6.e-003	-3.4786e-005
1623	-2.163e-002	4.5079e-002	6.e-003	-3.5989e-005
1624	-2.2522e-002	4.464e-002	6.e-003	-3.7139e-005
1625	-2.3405e-002	4.4184e-002	6.e-003	-3.8232e-005
1626	-2.4279e-002	4.371e-002	6.e-003	-3.9268e-005
1627	-2.5143e-002	4.3218e-002	6.e-003	-4.0245e-005
1628	-2.5998e-002	4.271e-002	6.e-003	-4.116e-005
1629	-2.6838e-002	4.2187e-002	5.9919e-003	-4.2013e-005
1630	-2.767e-002	4.1646e-002	5.9815e-003	-4.2803e-005
1631	-2.8495e-002	4.1086e-002	5.9722e-003	-4.353e-005
1632	-2.931e-002	4.0508e-002	5.9785e-003	-4.4191e-005
1633	-3.0108e-002	3.9919e-002	6.e-003	-4.4783e-005
1634	-3.0896e-002	3.9312e-002	6.e-003	-4.5308e-005
1635	-3.0896e-002	3.9312e-002	7.e-003	-4.5304e-005
1636	-3.0878e-002	3.9326e-002	8.0003e-003	-4.5296e-005
1637	-3.0857e-002	3.9342e-002	9.0016e-003	-4.5287e-005
1638	-3.0853e-002	3.9345e-002	9.9957e-003	-4.5281e-005
1639	-3.0845e-002	3.9352e-002	1.0989e-002	-4.528e-005
1640	-3.0855e-002	3.9344e-002	1.1989e-002	-4.5282e-005
1641	-3.0862e-002	3.9339e-002	1.2989e-002	-4.5286e-005
1642	-3.0868e-002	3.9334e-002	1.3993e-002	-4.529e-005
1643	-3.0874e-002	3.9329e-002	1.4994e-002	-4.5294e-005
1644	-3.088e-002	3.9324e-002	1.5993e-002	-4.5298e-005
1645	-3.0887e-002	3.9319e-002	1.6994e-002	-4.5302e-005
1646	-3.0892e-002	3.9315e-002	1.7991e-002	-4.5306e-005
1647	-3.09e-002	3.9309e-002	1.899e-002	-4.531e-005
1648	-3.0903e-002	3.9307e-002	1.9993e-002	-4.5314e-005
1649	-3.091e-002	3.9301e-002	2.0996e-002	-4.5317e-005
1650	-3.0909e-002	3.9302e-002	2.2002e-002	-4.5317e-005
1651	-3.0909e-002	3.9302e-002	2.3006e-002	-4.5316e-005
1652	-3.0902e-002	3.9307e-002	2.4007e-002	-4.5312e-005
1653	-3.0897e-002	3.9311e-002	2.5e-002	-4.5308e-005
1654	-3.0887e-002	3.9319e-002	2.6002e-002	-4.5304e-005
1655	-3.0885e-002	3.932e-002	2.7001e-002	-4.5302e-005
1656	-3.0885e-002	3.932e-002	2.7999e-002	-4.5301e-005
1657	-3.0885e-002	3.932e-002	2.9e-002	-4.5301e-005
1658	-3.0885e-002	3.9321e-002	2.9999e-002	-4.5301e-005
1659	-3.0884e-002	3.9322e-002	3.1e-002	-4.5301e-005
1660	-3.0883e-002	3.9322e-002	3.1999e-002	-4.5301e-005
1661	-3.0889e-002	3.9318e-002	3.3e-002	-4.5302e-005
1662	-3.0886e-002	3.932e-002	3.4e-002	-4.5302e-005
1663	-3.0884e-002	3.9322e-002	3.5e-002	-4.5301e-005
1664	-3.0882e-002	3.9323e-002	3.6e-002	-4.5299e-005
1665	-3.0879e-002	3.9325e-002	3.7e-002	-4.5298e-005
1666	-3.0877e-002	3.9327e-002	3.8e-002	-4.5296e-005
1667	-3.0875e-002	3.9329e-002	3.9e-002	-4.5296e-005
1668	-3.0879e-002	3.9325e-002	4.0995e-002	-4.5301e-005
1669	-3.0887e-002	3.9319e-002	4.1995e-002	-4.5304e-005
1670	-3.0899e-002	3.931e-002	4.3e-002	-4.5307e-005
1671	-3.0899e-002	3.931e-002	4.4e-002	-4.5308e-005
1672	-3.0108e-002	3.9919e-002	4.4e-002	-4.4785e-005
1673	-2.9309e-002	4.0509e-002	4.4e-002	-4.4192e-005
1674	-2.8498e-002	4.1084e-002	4.4e-002	-4.3533e-005
1675	-2.7675e-002	4.1642e-002	4.4e-002	-4.2807e-005
1676	-2.6842e-002	4.2184e-002	4.4e-002	-4.2016e-005
1677	-2.5998e-002	4.271e-002	4.4e-002	-4.1162e-005
1678	-2.5143e-002	4.3218e-002	4.4e-002	-4.0246e-005
1679	-2.4279e-002	4.371e-002	4.4e-002	-3.9269e-005
1680	-2.3405e-002	4.4184e-002	4.4e-002	-3.8232e-005
1681	-2.2522e-002	4.464e-002	4.4e-002	-3.7139e-005
1682	-2.163e-002	4.5079e-002	4.4e-002	-3.5989e-005
1683	-2.073e-002	4.55e-002	4.4e-002	-3.4786e-005
1684	-1.9821e-002	4.5904e-002	4.4e-002	-3.3531e-005
1685	-1.8904e-002	4.6289e-002	4.4e-002	-3.2225e-005
1686	-1.798e-002	4.6655e-002	4.4e-002	-3.0872e-005
1687	-1.7049e-002	4.7003e-002	4.4e-002	-2.9473e-005
1688	-1.6111e-002	4.7333e-002	4.4e-002	-2.8029e-005
1689	-1.5167e-002	4.7644e-002	4.4e-002	-2.6545e-005
1690	-1.4217e-002	4.7936e-002	4.4e-002	-2.502e-005
1691	-1.3261e-002	4.8209e-002	4.4e-002	-2.3459e-005
1692	-1.23e-002	4.8464e-002	4.4e-002	-2.1863e-005
1693	-1.1334e-002	4.8699e-002	4.4e-002	-2.0235e-005
1694	-1.0363e-002	4.8914e-002	4.4e-002	-1.8577e-005
1695	-9.3886e-003	4.9111e-002	4.4e-002	-1.6891e-005
1696	-8.4103e-003	4.9288e-002	4.4e-002	-1.5181e-005
1697	-7.4288e-003	4.9445e-002	4.4e-002	-1.3448e-005
1698	-6.4442e-003	4.9583e-002	4.4e-002	-1.1695e-005
1699	-5.4571e-003	4.9701e-002	4.4e-002	-9.925e-006
1700	-4.4678e-003	4.98e-002	4.4e-002	-8.1405e-006
1701	-3.4769e-003	4.9879e-002	4.4e-002	-6.344e-006
1702	-2.4844e-003	4.9938e-002	4.4e-002	-4.5381e-006
1703	-1.4911e-003	4.9978e-002	4.4e-002	-2.7255e-006
1704	-4.9707e-004	4.9998e-002	4.4e-002	-9.0899e-007
1705	4.9703e-004	4.9998e-002	4.4e-002	9.089e-007
1706	1.4911e-003	4.9978e-002	4.4e-002	2.7254e-006
1707	2.4844e-003	4.9938e-002	4.4e-002	4.538e-006
1708	3.4768e-003	4.9879e-002	4.4e-002	6.3439e-006
1709	4.4678e-003	4.98e-002	4.4e-002	8.1404e-006
1710	5.4571e-003	4.9701e-002	4.4e-002	9.925e-006
1711	6.4441e-003	4.9583e-002	4.4e-002	1.1695e-005
1712	7.4287e-003	4.9445e-002	4.4e-002	1.3448e-005
1713	8.4103e-003	4.9288e-002	4.4e-002	1.5181e-005
1714	9.3886e-003	4.9111e-002	4.4e-002	1.6891e-005
1715	1.0363e-002	4.8914e-002	4.4e-002	1.8577e-005
1716	1.1334e-002	4.8699e-002	4.4e-002	2.0235e-005
1717	1.23e-002	4.8464e-002	4.4e-002	2.1863e-005
1718	1.3261e-002	4.8209e-002	4.4e-002	2.3459e-005
1719	1.4217e-002	4.7936e-002	4.4e-002	2.502e-005
1720	1.5167e-002	4.7644e-002	4.4e-002	2.6544e-005
1721	1.6111e-002	4.7333e-002	4.4e-002	2.8029e-005
1722	1.7049e-002	4.7003e-002	4.4e-002	2.9472e-005
1723	1.798e-002	4.6655e-002	4.4e-002	3.0872e-005
1724	1.8904e-002	4.6289e-002	4.4e-002	3.2225e-005
1725	1.9821e-002	4.5904e-002	4.4e-002	3.3531e-005
1726	2.073e-002	4.55e-002	4.4e-002	3.4786e-005
1727	2.163e-002	4.5079e-002	4.4e-002	3.5989e-005
1728	2.2522e-002	4.464e-002	4.4e-002	3.7139e-005
1729	2.3405e-002	4.4184e-002	4.4e-002	3.8232e-005
1730	2.4279e-002	4.371e-002	4.4e-002	3.9268e-005
1731	2.5143e-002	4.3218e-002	4.4e-002	4.0246e-005
1732	2.5998e-002	4.271e-002	4.4e-002	4.1162e-005
1733	2.6842e-002	4.2184e-002	4.4e-002	4.2016e-005
1734	2.7675e-002	4.1642e-002	4.4e-002	4.2807e-005
1735	2.8497e-002	4.1084e-002	4.4e-002	4.3533e-005
1736	2.9309e-002	4.0509e-002	4.4e-002	4.4192e-005
1737	3.0108e-002	3.9918e-002	4.4e-002	4.4784e-005
1738	3.0108e-002	3.9918e-002	7.0001e-003	4.4785e-005
1739	2.9309e-002	4.0509e-002	7.e-003	4.4192e-005
1740	2.8498e-002	4.1084e-002	7.e-003	4.3533e-005
1741	2.7675e-002	4.1642e-002	7.e-003	4.2807e-005
1742	2.6842e-002	4.2184e-002	7.e-003	4.2016e-005
1743	2.5998e-002	4.271e-002	7.e-003	4.1162e-005
1744	2.5143e-002	4.3218e-002	7.e-003	4.0246e-005
1745	2.4279e-002	4.371e-002	7.e-003	3.9269e-005
1746	2.3405e-002	4.4184e-002	7.e-003	3.8232e-005
1747	2.2522e-002	4.464e-002	7.e-003	3.7139e-005
1748	2.163e-002	4.5079e-002	7.e-003	3.5989e-005
1749	2.073e-002	4.55e-002	7.e-003	3.4786e-005
1750	1.9821e-002	4.5904e-002	7.e-003	3.3531e-005
1751	1.8904e-002	4.6288e-002	7.e-003	3.2225e-005
1752	1.798e-002	4.6655e-002	7.e-003	3.0872e-005
1753	1.7049e-002	4.7003e-002	7.e-003	2.9473e-005
1754	1.6111e-002	4.7333e-002	7.e-003	2.8029e-005
1755	1.5167e-002	4.7644e-002	7.e-003	2.6545e-005
1756	1.4217e-002	4.7936e-002	7.e-003	2.502e-005
1757	1.3261e-002	4.8209e-002	7.e-003	2.3459e-005
1758	1.23e-002	4.8464e-002	7.e-003	2.1863e-005
1759	1.1334e-002	4.8699e-002	7.e-003	2.0235e-005
1760	1.0363e-002	4.8914e-002	7.e-003	1.8577e-005
1761	9.3887e-003	4.9111e-002	7.e-003	1.6891e-005
1762	8.4103e-003	4.9288e-002	7.e-003	1.5181e-005
1763	7.4288e-003	4.9445e-002	7.e-003	1.3448e-005
1764	6.4442e-003	4.9583e-002	7.e-003	1.1695e-005
1765	5.4571e-003	4.9701e-002	7.e-003	9.9251e-006
1766	4.4678e-003	4.98e-002	7.e-003	8.1405e-006
1767	3.4769e-003	4.9879e-002	7.e-003	6.344e-006
1768	2.4844e-003	4.9938e-002	7.e-003	4.5381e-006
1769	1.4911e-003	4.9978e-002	7.e-003	2.7255e-006
1770	4.9709e-004	4.9998e-002	7.e-003	9.0899e-007
1771	-4.9702e-004	4.9998e-002	7.e-003	-9.089e-007
1772	-1.491e-003	4.9978e-002	7.e-003	-2.7255e-006
1773	-2.4844e-003	4.9938e-002	7.e-003	-4.538e-006
1774	-3.4768e-003	4.9879e-002	7.e-003	-6.3439e-006
1775	-4.4678e-003	4.98e-002	7.e-003	-8.1404e-006
1776	-5.4571e-003	4.9701e-002	7.e-003	-9.925e-006
1777	-6.4441e-003	4.9583e-002	7.e-003	-1.1695e-005
1778	-7.4287e-003	4.9445e-002	7.e-003	-1.3448e-005
1779	-8.4103e-003	4.9288e-002	7.e-003	-1.5181e-005
1780	-9.3886e-003	4.9111e-002	7.e-003	-1.6891e-005
1781	-1.0363e-002	4.8914e-002	7.e-003	-1.8577e-005
1782	-1.1334e-002	4.8699e-002	7.e-003	-2.0235e-005
1783	-1.23e-002	4.8464e-002	7.e-003	-2.1863e-005
1784	-1.3261e-002	4.8209e-002	7.e-003	-2.3459e-005
1785	-1.4217e-002	4.7936e-002	7.e-003	-2.502e-005
1786	-1.5167e-002	4.7644e-002	7.e-003	-2.6545e-005
1787	-1.6111e-002	4.7333e-002	7.e-003	-2.8029e-005
1788	-1.7049e-002	4.7003e-002	7.e-003	-2.9472e-005
1789	-1.798e-002	4.6655e-002	7.e-003	-3.0872e-005
1790	-1.8904e-002	4.6289e-002	7.e-003	-3.2225e-005
1791	-1.9821e-002	4.5904e-002	7.e-003	-3.3531e-005
1792	-2.073e-002	4.55e-002	7.e-003	-3.4786e-005
1793	-2.163e-002	4.5079e-002	7.e-003	-3.5989e-005
1794	-2.2522e-002	4.464e-002	7.e-003	-3.7139e-005
1795	-2.3405e-002	4.4184e-002	7.e-003	-3.8232e-005
1796	-2.4279e-002	4.371e-002	7.e-003	-3.9268e-005
1797	-2.5143e-002	4.3218e-002	7.e-003	-4.0244e-005
1798	-2.5992e-002	4.2713e-002	6.9929e-003	-4.1157e-005
1799	-2.6833e-002	4.219e-002	6.9778e-003	-4.2007e-005
1800	-2.7665e-002	4.1649e-002	6.969e-003	-4.2796e-005
1801	-2.8487e-002	4.1091e-002	6.9664e-003	-4.3523e-005
1802	-2.9301e-002	4.0515e-002	6.9722e-003	-4.4184e-005
1803	-3.0104e-002	3.9922e-002	6.9927e-003	-4.4779e-005
1804	-3.0084e-002	3.9937e-002	7.9964e-003	-4.4767e-005
1805	-3.0065e-002	3.9951e-002	8.9889e-003	-4.4755e-005
1806	-3.0047e-002	3.9965e-002	9.9867e-003	-4.4746e-005
1807	-3.0043e-002	3.9968e-002	1.0988e-002	-4.4742e-005
1808	-3.0049e-002	3.9964e-002	1.1992e-002	-4.4744e-005
1809	-3.0054e-002	3.996e-002	1.2994e-002	-4.4748e-005
1810	-3.0062e-002	3.9954e-002	1.3998e-002	-4.4753e-005
1811	-3.0068e-002	3.9949e-002	1.4995e-002	-4.4758e-005
1812	-3.008e-002	3.994e-002	1.5994e-002	-4.4764e-005
1813	-3.0088e-002	3.9934e-002	1.6988e-002	-4.4772e-005
1814	-3.01e-002	3.9925e-002	1.7985e-002	-4.4781e-005
1815	-3.0116e-002	3.9913e-002	1.8986e-002	-4.4792e-005
1816	-3.0134e-002	3.9899e-002	1.9987e-002	-4.4802e-005
1817	-3.0148e-002	3.9889e-002	2.0995e-002	-4.4809e-005
1818	-3.015e-002	3.9887e-002	2.2008e-002	-4.481e-005
1819	-3.0137e-002	3.9897e-002	2.3015e-002	-4.4805e-005
1820	-3.0126e-002	3.9905e-002	2.4016e-002	-4.4797e-005
1821	-3.0108e-002	3.9919e-002	2.5012e-002	-4.4787e-005
1822	-3.0097e-002	3.9927e-002	2.6005e-002	-4.4778e-005
1823	-3.0086e-002	3.9935e-002	2.6998e-002	-4.4773e-005
1824	-3.0087e-002	3.9935e-002	2.7998e-002	-4.4771e-005
1825	-3.0088e-002	3.9933e-002	2.8996e-002	-4.4771e-005
1826	-3.0086e-002	3.9935e-002	3.e-002	-4.477e-005
1827	-3.0083e-002	3.9937e-002	3.0997e-002	-4.477e-005
1828	-3.0091e-002	3.9932e-002	3.1997e-002	-4.4771e-005
1829	-3.0092e-002	3.9931e-002	3.2997e-002	-4.4773e-005
1830	-3.0089e-002	3.9933e-002	3.3998e-002	-4.4772e-005
1831	-3.0085e-002	3.9936e-002	3.4998e-002	-4.4771e-005
1832	-3.009e-002	3.9932e-002	3.5997e-002	-4.477e-005
1833	-3.0082e-002	3.9938e-002	3.6996e-002	-4.4769e-005
1834	-3.0083e-002	3.9938e-002	3.7996e-002	-4.4768e-005
1835	-3.0083e-002	3.9937e-002	3.8995e-002	-4.4769e-005
1836	-3.0085e-002	3.9936e-002	3.9994e-002	-4.4771e-005
1837	-3.0091e-002	3.9932e-002	4.0993e-002	-4.4774e-005
1838	-3.01e-002	3.9925e-002	4.1998e-002	-4.4779e-005
1839	-3.0108e-002	3.9919e-002	4.3e-002	-4.4783e-005
1840	-2.9309e-002	4.0509e-002	4.3e-002	-4.4191e-005
1841	-2.8498e-002	4.1084e-002	4.3e-002	-4.3532e-005
1842	-2.6842e-002	4.2184e-002	4.3e-002	-4.2016e-005
1843	-2.5998e-002	4.271e-002	4.3e-002	-4.1162e-005
1844	-2.5143e-002	4.3218e-002	4.3e-002	-4.0246e-005
1845	-2.4279e-002	4.371e-002	4.3e-002	-3.9269e-005
1846	-2.3405e-002	4.4184e-002	4.3e-002	-3.8232e-005
1847	-2.2522e-002	4.464e-002	4.3e-002	-3.7139e-005
1848	-2.163e-002	4.5079e-002	4.3e-002	-3.5989e-005
1849	-2.073e-002	4.55e-002	4.3e-002	-3.4786e-005
1850	-1.9821e-002	4.5904e-002	4.3e-002	-3.3531e-005
1851	-1.8904e-002	4.6288e-002	4.3e-002	-3.2225e-005
1852	-1.798e-002	4.6655e-002	4.3e-002	-3.0872e-005
1853	-1.7049e-002	4.7003e-002	4.3e-002	-2.9473e-005
1854	-1.6111e-002	4.7333e-002	4.3e-002	-2.8029e-005
1855	-1.5167e-002	4.7644e-002	4.3e-002	-2.6545e-005
1856	-1.4217e-002	4.7936e-002	4.3e-002	-2.502e-005
1857	-1.3261e-002	4.8209e-002	4.3e-002	-2.3459e-005
1858	-1.23e-002	4.8464e-002	4.3e-002	-2.1863e-005
1859	-1.1334e-002	4.8699e-002	4.3e-002	-2.0235e-005
1860	-1.0363e-002	4.8914e-002	4.3e-002	-1.8577e-005
1861	-9.3887e-003	4.9111e-002	4.3e-002	-1.6891e-005
1862	-8.4103e-003	4.9288e-002	4.3e-002	-1.5181e-005
1863	-7.4288e-003	4.9445e-002	4.3e-002	-1.3448e-005
1864	-6.4442e-003	4.9583e-002	4.3e-002	-1.1695e-005
1865	-5.4571e-003	4.9701e-002	4.3e-002	-9.9251e-006
1866	-4.4678e-003	4.98e-002	4.3e-002	-8.1405e-006
1867	-3.4769e-003	4.9879e-002	4.3e-002	-6.344e-006
1868	-2.4844e-003	4.9938e-002	4.3e-002	-4.5381e-006
1869	-1.4911e-003	4.9978e-002	4.3e-002	-2.7256e-006
1870	-4.971e-004	4.9998e-002	4.3e-002	-9.09e-007
1871	4.9702e-004	4.9998e-002	4.3e-002	9.0889e-007
1872	1.491e-003	4.9978e-002	4.3e-002	2.7254e-006
1873	2.4844e-003	4.9938e-002	4.3e-002	4.538e-006
1874	3.4768e-003	4.9879e-002	4.3e-002	6.3438e-006
1875	4.4678e-003	4.98e-002	4.3e-002	8.1404e-006
1876	5.457e-003	4.9701e-002	4.3e-002	9.9249e-006
1877	6.4441e-003	4.9583e-002	4.3e-002	1.1695e-005
1878	7.4287e-003	4.9445e-002	4.3e-002	1.3448e-005
1879	8.4103e-003	4.9288e-002	4.3e-002	1.5181e-005
1880	9.3886e-003	4.9111e-002	4.3e-002	1.6891e-005
1881	1.0363e-002	4.8914e-002	4.3e-002	1.8577e-005
1882	1.1334e-002	4.8699e-002	4.3e-002	2.0235e-005
1883	1.23e-002	4.8464e-002	4.3e-002	2.1863e-005
1884	1.3261e-002	4.8209e-002	4.3e-002	2.3459e-005
1885	1.4217e-002	4.7936e-002	4.3e-002	2.502e-005
1886	1.5167e-002	4.7644e-002	4.3e-002	2.6544e-005
1887	1.6111e-002	4.7333e-002	4.3e-002	2.8029e-005
1888	1.7049e-002	4.7003e-002	4.3e-002	2.9472e-005
1889	1.798e-002	4.6655e-002	4.3e-002	3.0872e-005
1890	1.8904e-002	4.6289e-002	4.3e-002	3.2225e-005
1891	1.9821e-002	4.5904e-002	4.3e-002	3.3531e-005
1892	2.073e-002	4.55e-002	4.3e-002	3.4786e-005
1893	2.163e-002	4.5079e-002	4.3e-002	3.5989e-005
1894	2.2522e-002	4.464e-002	4.3e-002	3.7139e-005
1895	2.3405e-002	4.4184e-002	4.3e-002	3.8232e-005
1896	2.4279e-002	4.371e-002	4.3e-002	3.9268e-005
1897	2.5143e-002	4.3218e-002	4.3e-002	4.0246e-005
1898	2.5998e-002	4.271e-002	4.3e-002	4.1162e-005
1899	2.6842e-002	4.2184e-002	4.3e-002	4.2016e-005
1900	2.7675e-002	4.1642e-002	4.3e-002	4.2807e-005
1901	2.8497e-002	4.1084e-002	4.3e-002	4.3533e-005
1902	2.9309e-002	4.0509e-002	4.3e-002	4.4192e-005
1903	3.0108e-002	3.9918e-002	4.3e-002	4.4784e-005
1904	3.0108e-002	3.9918e-002	4.2e-002	4.4784e-005
1905	3.0108e-002	3.9918e-002	4.1e-002	4.4784e-005
1906	3.0108e-002	3.9918e-002	4.e-002	4.4784e-005
1907	3.0109e-002	3.9918e-002	3.9e-002	4.4784e-005
1908	3.0109e-002	3.9918e-002	3.8e-002	4.4784e-005
1909	3.0109e-002	3.9918e-002	3.7e-002	4.4784e-005
1910	3.0109e-002	3.9918e-002	3.6e-002	4.4784e-005
1911	3.0109e-002	3.9918e-002	3.5e-002	4.4784e-005
1912	3.0109e-002	3.9918e-002	3.4e-002	4.4784e-005
1913	3.0109e-002	3.9918e-002	3.3e-002	4.4784e-005
1914	3.0109e-002	3.9918e-002	3.2e-002	4.4785e-005
1915	3.0109e-002	3.9918e-002	3.1e-002	4.4785e-005
1916	3.0109e-002	3.9918e-002	3.e-002	4.4785e-005
1917	3.0109e-002	3.9918e-002	2.9e-002	4.4785e-005
1918	3.0109e-002	3.9918e-002	2.8e-002	4.4785e-005
1919	3.0109e-002	3.9918e-002	2.7e-002	4.4785e-005
1920	3.0109e-002	3.9918e-002	2.6e-002	4.4785e-005
1921	3.0109e-002	3.9918e-002	2.5e-002	4.4785e-005
1922	3.0109e-002	3.9918e-002	2.4e-002	4.4785e-005
1923	3.0109e-002	3.9918e-002	2.3e-002	4.4785e-005
1924	3.0109e-002	3.9918e-002	2.2e-002	4.4785e-005
1925	3.0109e-002	3.9918e-002	2.1e-002	4.4785e-005
1926	3.0109e-002	3.9918e-002	2.e-002	4.4785e-005
1927	3.0109e-002	3.9918e-002	1.9e-002	4.4785e-005
1928	3.0109e-002	3.9918e-002	1.8e-002	4.4785e-005
1929	3.0109e-002	3.9918e-002	1.7e-002	4.4785e-005
1930	3.0109e-002	3.9918e-002	1.6e-002	4.4785e-005
1931	3.0109e-002	3.9918e-002	1.5e-002	4.4785e-005
1932	3.0109e-002	3.9918e-002	1.4e-002	4.4785e-005
1933	3.0109e-002	3.9918e-002	1.3e-002	4.4785e-005
1934	3.0109e-002	3.9918e-002	1.2e-002	4.4785e-005
1935	3.0109e-002	3.9918e-002	1.1e-002	4.4785e-005
1936	3.0109e-002	3.9918e-002	1.e-002	4.4785e-005
1937	3.0109e-002	3.9918e-002	9.e-003	4.4785e-005
1938	3.0109e-002	3.9918e-002	8.e-003	4.4785e-005
1939	-2.9301e-002	4.0515e-002	4.1998e-002	-4.4187e-005
1940	-2.8493e-002	4.1087e-002	4.2002e-002	-4.3529e-005
1941	-2.7675e-002	4.1642e-002	4.2e-002	-4.2806e-005
1942	-2.6842e-002	4.2184e-002	4.2e-002	-4.2016e-005
1943	-2.5998e-002	4.271e-002	4.2e-002	-4.1162e-005
1944	-2.5143e-002	4.3218e-002	4.2e-002	-4.0246e-005
1945	-2.4279e-002	4.371e-002	4.2e-002	-3.9269e-005
1946	-2.3405e-002	4.4184e-002	4.2e-002	-3.8232e-005
1947	-2.2522e-002	4.464e-002	4.2e-002	-3.7139e-005
1948	-2.163e-002	4.5079e-002	4.2e-002	-3.5989e-005
1949	-2.073e-002	4.55e-002	4.2e-002	-3.4786e-005
1950	-1.9821e-002	4.5904e-002	4.2e-002	-3.3531e-005
1951	-1.8904e-002	4.6288e-002	4.2e-002	-3.2225e-005
1952	-1.798e-002	4.6655e-002	4.2e-002	-3.0872e-005
1953	-1.7049e-002	4.7003e-002	4.2e-002	-2.9473e-005
1954	-1.6111e-002	4.7333e-002	4.2e-002	-2.8029e-005
1955	-1.5167e-002	4.7644e-002	4.2e-002	-2.6545e-005
1956	-1.4217e-002	4.7936e-002	4.2e-002	-2.502e-005
1957	-1.3261e-002	4.8209e-002	4.2e-002	-2.3459e-005
1958	-1.23e-002	4.8464e-002	4.2e-002	-2.1863e-005
1959	-1.1334e-002	4.8699e-002	4.2e-002	-2.0235e-005
1960	-1.0363e-002	4.8914e-002	4.2e-002	-1.8577e-005
1961	-9.3887e-003	4.9111e-002	4.2e-002	-1.6891e-005
1962	-8.4103e-003	4.9288e-002	4.2e-002	-1.5181e-005
1963	-7.4288e-003	4.9445e-002	4.2e-002	-1.3448e-005
1964	-6.4442e-003	4.9583e-002	4.2e-002	-1.1695e-005
1965	-5.4571e-003	4.9701e-002	4.2e-002	-9.9251e-006
1966	-4.4678e-003	4.98e-002	4.2e-002	-8.1405e-006
1967	-3.4769e-003	4.9879e-002	4.2e-002	-6.344e-006
1968	-2.4844e-003	4.9938e-002	4.2e-002	-4.5381e-006
1969	-1.4911e-003	4.9978e-002	4.2e-002	-2.7256e-006
1970	-4.9708e-004	4.9998e-002	4.2e-002	-9.0901e-007
1971	4.9702e-004	4.9998e-002	4.2e-002	9.0888e-007
1972	1.491e-003	4.9978e-002	4.2e-002	2.7254e-006
1973	2.4844e-003	4.9938e-002	4.2e-002	4.538e-006
1974	3.4768e-003	4.9879e-002	4.2e-002	6.3438e-006
1975	4.4678e-003	4.98e-002	4.2e-002	8.1404e-006
1976	5.4571e-003	4.9701e-002	4.2e-002	9.9249e-006
1977	6.4441e-003	4.9583e-002	4.2e-002	1.1695e-005
1978	7.4287e-003	4.9445e-002	4.2e-002	1.3448e-005
1979	8.4103e-003	4.9288e-002	4.2e-002	1.5181e-005
1980	9.3886e-003	4.9111e-002	4.2e-002	1.6891e-005
1981	1.0363e-002	4.8914e-002	4.2e-002	1.8577e-005
1982	1.1334e-002	4.8699e-002	4.2e-002	2.0235e-005
1983	1.23e-002	4.8464e-002	4.2e-002	2.1863e-005
1984	1.3261e-002	4.8209e-002	4.2e-002	2.3459e-005
1985	1.4217e-002	4.7936e-002	4.2e-002	2.502e-005
1986	1.5167e-002	4.7644e-002	4.2e-002	2.6544e-005
1987	1.6111e-002	4.7333e-002	4.2e-002	2.8029e-005
1988	1.7049e-002	4.7003e-002	4.2e-002	2.9472e-005
1989	1.798e-002	4.6655e-002	4.2e-002	3.0872e-005
1990	1.8904e-002	4.6289e-002	4.2e-002	3.2225e-005
1991	1.9821e-002	4.5904e-002	4.2e-002	3.3531e-005
1992	2.073e-002	4.55e-002	4.2e-002	3.4786e-005
1993	2.163e-002	4.5079e-002	4.2e-002	3.5989e-005
1994	2.2522e-002	4.464e-002	4.2e-002	3.7139e-005
1995	2.3405e-002	4.4184e-002	4.2e-002	3.8232e-005
1996	2.4279e-002	4.371e-002	4.2e-002	3.9268e-005
1997	2.5143e-002	4.3218e-002	4.2e-002	4.0246e-005
1998	2.5998e-002	4.271e-002	4.2e-002	4.1162e-005
1999	2.6842e-002	4.2184e-002	4.2e-002	4.2016e-005
2000	2.7675e-002	4.1642e-002	4.2e-002	4.2807e-005
2001	2.8497e-002	4.1084e-002	4.2e-002	4.3533e-005
2002	2.9309e-002	4.0509e-002	4.2e-002	4.4192e-005
2003	2.9309e-002	4.0509e-002	4.1e-002	4.4192e-005
2004	2.9309e-002	4.0509e-002	4.e-002	4.4192e-005
2005	2.9309e-002	4.0509e-002	3.9e-002	4.4192e-005
2006	2.9309e-002	4.0509e-002	3.8e-002	4.4192e-005
2007	2.9309e-002	4.0509e-002	3.7e-002	4.4192e-005
2008	2.9309e-002	4.0509e-002	3.6e-002	4.4192e-005
2009	2.9309e-002	4.0509e-002	3.5e-002	4.4192e-005
2010	2.9309e-002	4.0509e-002	3.4e-002	4.4192e-005
2011	2.9309e-002	4.0509e-002	3.3e-002	4.4192e-005
2012	2.9309e-002	4.0509e-002	3.2e-002	4.4192e-005
2013	2.9309e-002	4.0509e-002	3.e-002	4.4192e-005
2014	2.9309e-002	4.0509e-002	2.8e-002	4.4193e-005
2015	2.9309e-002	4.0509e-002	2.6e-002	4.4193e-005
2016	2.9309e-002	4.0509e-002	2.4e-002	4.4193e-005
2017	2.9309e-002	4.0509e-002	2.2e-002	4.4193e-005
2018	2.9309e-002	4.0509e-002	2.e-002	4.4193e-005
2019	2.9309e-002	4.0509e-002	1.8e-002	4.4193e-005
2020	2.9309e-002	4.0509e-002	1.6e-002	4.4193e-005
2021	2.9309e-002	4.0509e-002	1.4e-002	4.4193e-005
2022	2.9309e-002	4.0509e-002	1.3e-002	4.4193e-005
2023	2.931e-002	4.0509e-002	1.2e-002	4.4193e-005
2024	2.931e-002	4.0509e-002	1.1e-002	4.4193e-005
2025	2.931e-002	4.0509e-002	9.9999e-003	4.4193e-005
2026	2.931e-002	4.0509e-002	8.9999e-003	4.4193e-005
2027	2.931e-002	4.0508e-002	7.9999e-003	4.4193e-005
2028	2.8498e-002	4.1084e-002	8.e-003	4.3533e-005
2029	2.7675e-002	4.1642e-002	8.e-003	4.2807e-005
2030	2.5998e-002	4.271e-002	8.e-003	4.1162e-005
2031	2.4279e-002	4.371e-002	8.e-003	3.9269e-005
2032	2.2522e-002	4.464e-002	8.e-003	3.7139e-005
2033	2.073e-002	4.55e-002	8.e-003	3.4786e-005
2034	1.8904e-002	4.6289e-002	8.e-003	3.2225e-005
2035	1.7049e-002	4.7003e-002	8.e-003	2.9473e-005
2036	1.5167e-002	4.7644e-002	8.e-003	2.6545e-005
2037	1.3261e-002	4.8209e-002	8.e-003	2.3459e-005
2038	1.1334e-002	4.8699e-002	8.e-003	2.0235e-005
2039	9.3886e-003	4.9111e-002	8.e-003	1.6891e-005
2040	7.4287e-003	4.9445e-002	8.e-003	1.3448e-005
2041	5.4571e-003	4.9701e-002	8.e-003	9.9251e-006
2042	3.4768e-003	4.9879e-002	8.e-003	6.344e-006
2043	1.4911e-003	4.9978e-002	8.e-003	2.7255e-006
2044	-4.9704e-004	4.9998e-002	8.e-003	-9.089e-007
2045	-2.4844e-003	4.9938e-002	8.e-003	-4.538e-006
2046	-4.4678e-003	4.98e-002	8.e-003	-8.1404e-006
2047	-6.4441e-003	4.9583e-002	8.e-003	-1.1695e-005
2048	-8.4103e-003	4.9288e-002	8.e-003	-1.5181e-005
2049	-1.0363e-002	4.8914e-002	8.e-003	-1.8577e-005
2050	-1.23e-002	4.8464e-002	8.e-003	-2.1863e-005
2051	-1.4217e-002	4.7936e-002	8.e-003	-2.502e-005
2052	-1.6111e-002	4.7333e-002	8.e-003	-2.8029e-005
2053	-1.798e-002	4.6655e-002	8.e-003	-3.0872e-005
2054	-1.9821e-002	4.5904e-002	8.e-003	-3.3531e-005
2055	-2.163e-002	4.5079e-002	8.e-003	-3.5989e-005
2056	-2.3405e-002	4.4184e-002	8.e-003	-3.8232e-005
2057	-2.5143e-002	4.3218e-002	8.e-003	-4.0242e-005
2058	-2.682e-002	4.2198e-002	7.9663e-003	-4.1998e-005
2059	-2.7651e-002	4.1659e-002	7.954e-003	-4.2785e-005
2060	-2.8472e-002	4.1102e-002	7.9551e-003	-4.351e-005
2061	-2.9282e-002	4.0528e-002	7.9677e-003	-4.4171e-005
2062	-2.926e-002	4.0545e-002	8.9743e-003	-4.4157e-005
2063	-2.8451e-002	4.1116e-002	8.9602e-003	-4.3496e-005
2064	-2.9244e-002	4.0556e-002	9.9807e-003	-4.4146e-005
2065	-2.9243e-002	4.0557e-002	1.0988e-002	-4.4142e-005
2066	-2.9244e-002	4.0556e-002	1.1995e-002	-4.4143e-005
2067	-2.9247e-002	4.0553e-002	1.3e-002	-4.4145e-005
2068	-2.925e-002	4.0551e-002	1.4003e-002	-4.4148e-005
2069	-2.9259e-002	4.0545e-002	1.4999e-002	-4.4154e-005
2070	-2.9271e-002	4.0537e-002	1.5995e-002	-4.4163e-005
2071	-2.9307e-002	4.0511e-002	1.7993e-002	-4.4191e-005
2072	-2.9354e-002	4.0476e-002	2.0001e-002	-4.4226e-005
2073	-2.9378e-002	4.0459e-002	2.2018e-002	-4.4242e-005
2074	-2.9337e-002	4.0489e-002	2.4025e-002	-4.4217e-005
2075	-2.9298e-002	4.0517e-002	2.6007e-002	-4.4186e-005
2076	-2.9283e-002	4.0528e-002	2.7997e-002	-4.4176e-005
2077	-2.9284e-002	4.0527e-002	2.9996e-002	-4.4175e-005
2078	-2.9284e-002	4.0527e-002	3.0996e-002	-4.4174e-005
2079	-2.9284e-002	4.0527e-002	3.1995e-002	-4.4175e-005
2080	-2.9286e-002	4.0526e-002	3.2995e-002	-4.4176e-005
2081	-2.9288e-002	4.0525e-002	3.3995e-002	-4.4176e-005
2082	-2.9287e-002	4.0525e-002	3.4995e-002	-4.4175e-005
2083	-2.9286e-002	4.0526e-002	3.5995e-002	-4.4176e-005
2084	-2.9286e-002	4.0525e-002	3.6995e-002	-4.4175e-005
2085	-2.9288e-002	4.0525e-002	3.7995e-002	-4.4176e-005
2086	-2.9289e-002	4.0523e-002	3.8995e-002	-4.4178e-005
2087	-2.9293e-002	4.0521e-002	3.9998e-002	-4.418e-005
2088	-2.9297e-002	4.0518e-002	4.0999e-002	-4.4183e-005
2089	2.8497e-002	4.1084e-002	4.1e-002	4.3533e-005
2090	2.7675e-002	4.1642e-002	4.1e-002	4.2807e-005
2091	2.8497e-002	4.1084e-002	4.e-002	4.3533e-005
2092	2.8497e-002	4.1084e-002	3.9e-002	4.3533e-005
2093	2.8498e-002	4.1084e-002	3.8e-002	4.3533e-005
2094	2.8498e-002	4.1084e-002	3.7e-002	4.3533e-005
2095	2.8498e-002	4.1084e-002	3.6e-002	4.3533e-005
2096	2.8498e-002	4.1084e-002	3.5e-002	4.3533e-005
2097	2.8498e-002	4.1084e-002	3.4e-002	4.3533e-005
2098	2.8498e-002	4.1083e-002	3.3e-002	4.3533e-005
2099	2.8498e-002	4.1083e-002	3.2e-002	4.3533e-005
2100	2.8498e-002	4.1083e-002	3.1e-002	4.3533e-005
2101	2.8499e-002	4.1083e-002	3.e-002	4.3533e-005
2102	2.8499e-002	4.1083e-002	2.9e-002	4.3533e-005
2103	2.8499e-002	4.1083e-002	2.8e-002	4.3533e-005
2104	2.8499e-002	4.1083e-002	2.7e-002	4.3533e-005
2105	2.8499e-002	4.1083e-002	2.6e-002	4.3533e-005
2106	2.8499e-002	4.1083e-002	2.5e-002	4.3533e-005
2107	2.8499e-002	4.1083e-002	2.4e-002	4.3533e-005
2108	2.8499e-002	4.1083e-002	2.3e-002	4.3533e-005
2109	2.85e-002	4.1083e-002	2.2e-002	4.3533e-005
2110	2.85e-002	4.1082e-002	2.1e-002	4.3533e-005
2111	2.85e-002	4.1082e-002	2.e-002	4.3533e-005
2112	2.85e-002	4.1082e-002	1.9e-002	4.3533e-005
2113	2.85e-002	4.1082e-002	1.8e-002	4.3533e-005
2114	2.85e-002	4.1082e-002	1.7e-002	4.3533e-005
2115	2.85e-002	4.1082e-002	1.6e-002	4.3533e-005
2116	2.85e-002	4.1082e-002	1.5e-002	4.3533e-005
2117	2.85e-002	4.1082e-002	1.4e-002	4.3533e-005
2118	2.8501e-002	4.1082e-002	1.3e-002	4.3533e-005
2119	2.8501e-002	4.1082e-002	1.2e-002	4.3533e-005
2120	2.8501e-002	4.1082e-002	1.1e-002	4.3533e-005
2121	2.8501e-002	4.1082e-002	9.9998e-003	4.3534e-005
2122	2.8501e-002	4.1082e-002	8.9998e-003	4.3534e-005
2123	2.7675e-002	4.1642e-002	9.e-003	4.2807e-005
2124	2.6842e-002	4.2184e-002	9.e-003	4.2016e-005
2125	2.5998e-002	4.271e-002	9.e-003	4.1162e-005
2126	2.5143e-002	4.3218e-002	9.e-003	4.0246e-005
2127	2.4279e-002	4.371e-002	9.e-003	3.9269e-005
2128	2.3405e-002	4.4184e-002	9.e-003	3.8232e-005
2129	2.2522e-002	4.464e-002	9.e-003	3.7139e-005
2130	2.163e-002	4.5079e-002	9.e-003	3.5989e-005
2131	2.073e-002	4.55e-002	9.e-003	3.4786e-005
2132	1.9821e-002	4.5904e-002	9.e-003	3.3531e-005
2133	1.8904e-002	4.6288e-002	9.e-003	3.2225e-005
2134	1.798e-002	4.6655e-002	9.e-003	3.0872e-005
2135	1.7049e-002	4.7003e-002	9.e-003	2.9473e-005
2136	1.6111e-002	4.7333e-002	9.e-003	2.8029e-005
2137	1.5167e-002	4.7644e-002	9.e-003	2.6545e-005
2138	1.4217e-002	4.7936e-002	9.e-003	2.502e-005
2139	1.3261e-002	4.8209e-002	9.e-003	2.3459e-005
2140	1.23e-002	4.8464e-002	9.e-003	2.1863e-005
2141	1.1334e-002	4.8699e-002	9.e-003	2.0235e-005
2142	1.0363e-002	4.8914e-002	9.e-003	1.8577e-005
2143	9.3887e-003	4.9111e-002	9.e-003	1.6891e-005
2144	8.4103e-003	4.9288e-002	9.e-003	1.5181e-005
2145	7.4288e-003	4.9445e-002	9.e-003	1.3448e-005
2146	6.4442e-003	4.9583e-002	9.e-003	1.1695e-005
2147	5.4571e-003	4.9701e-002	9.e-003	9.9251e-006
2148	4.4678e-003	4.98e-002	9.e-003	8.1405e-006
2149	3.4769e-003	4.9879e-002	9.e-003	6.344e-006
2150	2.4844e-003	4.9938e-002	9.e-003	4.5381e-006
2151	1.4911e-003	4.9978e-002	9.e-003	2.7255e-006
2152	4.9709e-004	4.9998e-002	9.e-003	9.09e-007
2153	-4.9701e-004	4.9998e-002	9.e-003	-9.0889e-007
2154	-1.491e-003	4.9978e-002	9.e-003	-2.7254e-006
2155	-2.4843e-003	4.9938e-002	9.e-003	-4.538e-006
2156	-3.4768e-003	4.9879e-002	9.e-003	-6.3439e-006
2157	-4.4678e-003	4.98e-002	9.e-003	-8.1404e-006
2158	-5.4571e-003	4.9701e-002	9.e-003	-9.925e-006
2159	-6.4441e-003	4.9583e-002	9.e-003	-1.1695e-005
2160	-7.4287e-003	4.9445e-002	9.e-003	-1.3448e-005
2161	-8.4102e-003	4.9288e-002	9.e-003	-1.5181e-005
2162	-9.3886e-003	4.9111e-002	9.e-003	-1.6891e-005
2163	-1.0363e-002	4.8914e-002	9.e-003	-1.8577e-005
2164	-1.1334e-002	4.8699e-002	9.e-003	-2.0235e-005
2165	-1.23e-002	4.8464e-002	9.e-003	-2.1863e-005
2166	-1.3261e-002	4.8209e-002	9.e-003	-2.3459e-005
2167	-1.4217e-002	4.7936e-002	9.e-003	-2.502e-005
2168	-1.5167e-002	4.7644e-002	9.e-003	-2.6545e-005
2169	-1.6111e-002	4.7333e-002	9.e-003	-2.8029e-005
2170	-1.7049e-002	4.7003e-002	9.e-003	-2.9472e-005
2171	-1.798e-002	4.6655e-002	9.e-003	-3.0872e-005
2172	-1.8904e-002	4.6289e-002	9.e-003	-3.2225e-005
2173	-1.9821e-002	4.5904e-002	9.e-003	-3.3531e-005
2174	-2.073e-002	4.55e-002	9.e-003	-3.4786e-005
2175	-2.163e-002	4.5079e-002	9.e-003	-3.5989e-005
2176	-2.2522e-002	4.464e-002	9.e-003	-3.7139e-005
2177	-2.3405e-002	4.4184e-002	9.e-003	-3.8232e-005
2178	-2.4279e-002	4.371e-002	9.e-003	-3.9267e-005
2179	-2.5135e-002	4.3223e-002	8.9959e-003	-4.0238e-005
2180	-2.5981e-002	4.272e-002	8.988e-003	-4.1144e-005
2181	-2.6811e-002	4.2204e-002	8.9643e-003	-4.1988e-005
2182	-2.7638e-002	4.1667e-002	8.9609e-003	-4.2773e-005
2183	-2.8438e-002	4.1125e-002	9.9704e-003	-4.3486e-005
2184	-2.8435e-002	4.1127e-002	1.0985e-002	-4.3482e-005
2185	-2.8488e-002	4.109e-002	4.1002e-002	-4.3527e-005
2186	-2.7675e-002	4.1642e-002	4.1e-002	-4.2805e-005
2187	-2.6842e-002	4.2184e-002	4.1e-002	-4.2016e-005
2188	-2.5998e-002	4.271e-002	4.1e-002	-4.1162e-005
2189	-2.5143e-002	4.3218e-002	4.1e-002	-4.0246e-005
2190	-2.4279e-002	4.371e-002	4.1e-002	-3.9269e-005
2191	-2.3405e-002	4.4184e-002	4.1e-002	-3.8232e-005
2192	-2.2522e-002	4.464e-002	4.1e-002	-3.7139e-005
2193	-2.163e-002	4.5079e-002	4.1e-002	-3.5989e-005
2194	-2.073e-002	4.55e-002	4.1e-002	-3.4786e-005
2195	-1.9821e-002	4.5904e-002	4.1e-002	-3.3531e-005
2196	-1.8904e-002	4.6288e-002	4.1e-002	-3.2225e-005
2197	-1.798e-002	4.6655e-002	4.1e-002	-3.0872e-005
2198	-1.7049e-002	4.7003e-002	4.1e-002	-2.9473e-005
2199	-1.6111e-002	4.7333e-002	4.1e-002	-2.8029e-005
2200	-1.5167e-002	4.7644e-002	4.1e-002	-2.6545e-005
2201	-1.4217e-002	4.7936e-002	4.1e-002	-2.502e-005
2202	-1.3261e-002	4.8209e-002	4.1e-002	-2.3459e-005
2203	-1.23e-002	4.8464e-002	4.1e-002	-2.1863e-005
2204	-1.1334e-002	4.8699e-002	4.1e-002	-2.0235e-005
2205	-1.0363e-002	4.8914e-002	4.1e-002	-1.8577e-005
2206	-9.3887e-003	4.9111e-002	4.1e-002	-1.6891e-005
2207	-8.4103e-003	4.9288e-002	4.1e-002	-1.5181e-005
2208	-7.4288e-003	4.9445e-002	4.1e-002	-1.3448e-005
2209	-6.4442e-003	4.9583e-002	4.1e-002	-1.1695e-005
2210	-5.4571e-003	4.9701e-002	4.1e-002	-9.9251e-006
2211	-4.4678e-003	4.98e-002	4.1e-002	-8.1405e-006
2212	-3.4769e-003	4.9879e-002	4.1e-002	-6.344e-006
2213	-2.4844e-003	4.9938e-002	4.1e-002	-4.5381e-006
2214	-1.4911e-003	4.9978e-002	4.1e-002	-2.7256e-006
2215	-4.971e-004	4.9998e-002	4.1e-002	-9.0902e-007
2216	4.9702e-004	4.9998e-002	4.1e-002	9.0887e-007
2217	1.491e-003	4.9978e-002	4.1e-002	2.7254e-006
2218	2.4844e-003	4.9938e-002	4.1e-002	4.538e-006
2219	3.4768e-003	4.9879e-002	4.1e-002	6.3438e-006
2220	4.4678e-003	4.98e-002	4.1e-002	8.1404e-006
2221	5.457e-003	4.9701e-002	4.1e-002	9.9249e-006
2222	6.4441e-003	4.9583e-002	4.1e-002	1.1695e-005
2223	7.4287e-003	4.9445e-002	4.1e-002	1.3448e-005
2224	8.4103e-003	4.9288e-002	4.1e-002	1.5181e-005
2225	9.3886e-003	4.9111e-002	4.1e-002	1.6891e-005
2226	1.0363e-002	4.8914e-002	4.1e-002	1.8577e-005
2227	1.1334e-002	4.8699e-002	4.1e-002	2.0235e-005
2228	1.23e-002	4.8464e-002	4.1e-002	2.1863e-005
2229	1.3261e-002	4.8209e-002	4.1e-002	2.3459e-005
2230	1.4217e-002	4.7936e-002	4.1e-002	2.502e-005
2231	1.5167e-002	4.7644e-002	4.1e-002	2.6544e-005
2232	1.6111e-002	4.7333e-002	4.1e-002	2.8029e-005
2233	1.7049e-002	4.7004e-002	4.1e-002	2.9472e-005
2234	1.798e-002	4.6655e-002	4.1e-002	3.0872e-005
2235	1.8904e-002	4.6289e-002	4.1e-002	3.2225e-005
2236	1.9821e-002	4.5904e-002	4.1e-002	3.3531e-005
2237	2.073e-002	4.55e-002	4.1e-002	3.4786e-005
2238	2.163e-002	4.5079e-002	4.1e-002	3.5989e-005
2239	2.2522e-002	4.464e-002	4.1e-002	3.7139e-005
2240	2.3405e-002	4.4184e-002	4.1e-002	3.8232e-005
2241	2.4279e-002	4.371e-002	4.1e-002	3.9268e-005
2242	2.5143e-002	4.3218e-002	4.1e-002	4.0246e-005
2243	2.5998e-002	4.271e-002	4.1e-002	4.1162e-005
2244	2.6842e-002	4.2184e-002	4.1e-002	4.2016e-005
2245	-2.7623e-002	4.1677e-002	1.0982e-002	-4.276e-005
2246	-2.8492e-002	4.1088e-002	4.e-002	-4.3525e-005
2247	-2.8482e-002	4.1095e-002	3.9e-002	-4.3522e-005
2248	-2.8481e-002	4.1095e-002	3.7999e-002	-4.352e-005
2249	-2.848e-002	4.1096e-002	3.6998e-002	-4.3519e-005
2250	-2.8478e-002	4.1097e-002	3.5998e-002	-4.3518e-005
2251	-2.8478e-002	4.1098e-002	3.4997e-002	-4.3518e-005
2252	-2.8477e-002	4.1098e-002	3.3998e-002	-4.3517e-005
2253	-2.8475e-002	4.11e-002	3.2998e-002	-4.3516e-005
2254	-2.8474e-002	4.11e-002	3.1998e-002	-4.3515e-005
2255	-2.8472e-002	4.1101e-002	3.0999e-002	-4.3515e-005
2256	-2.8479e-002	4.1097e-002	2.9998e-002	-4.3516e-005
2257	-2.8479e-002	4.1097e-002	2.8998e-002	-4.3517e-005
2258	-2.8478e-002	4.1097e-002	2.7998e-002	-4.3517e-005
2259	-2.8477e-002	4.1098e-002	2.6999e-002	-4.352e-005
2260	-2.8492e-002	4.1088e-002	2.6012e-002	-4.353e-005
2261	-2.8513e-002	4.1073e-002	2.5025e-002	-4.3548e-005
2262	-2.8545e-002	4.1051e-002	2.4034e-002	-4.3571e-005
2263	-2.8581e-002	4.1026e-002	2.3037e-002	-4.3595e-005
2264	-2.8603e-002	4.1011e-002	2.2033e-002	-4.3608e-005
2265	-2.8586e-002	4.1022e-002	2.1026e-002	-4.3603e-005
2266	-2.8559e-002	4.1041e-002	2.002e-002	-4.3585e-005
2267	-2.8535e-002	4.1058e-002	1.9017e-002	-4.3562e-005
2268	-2.85e-002	4.1082e-002	1.8011e-002	-4.3538e-005
2269	-2.8475e-002	4.11e-002	1.7005e-002	-4.3516e-005
2270	-2.845e-002	4.1117e-002	1.6005e-002	-4.3498e-005
2271	-2.8433e-002	4.1128e-002	1.5007e-002	-4.3485e-005
2272	-2.8428e-002	4.1132e-002	1.4009e-002	-4.3479e-005
2273	-2.8431e-002	4.113e-002	1.3004e-002	-4.3479e-005
2274	-2.8436e-002	4.1126e-002	1.1995e-002	-4.3481e-005
2275	-2.7622e-002	4.1677e-002	1.1991e-002	-4.2758e-005
2276	-2.6802e-002	4.221e-002	9.9715e-003	-4.1981e-005
2277	2.7675e-002	4.1642e-002	4.e-002	4.2807e-005
2278	-2.68e-002	4.2211e-002	1.0979e-002	-4.1978e-005
2279	2.7675e-002	4.1642e-002	3.9e-002	4.2807e-005
2280	2.7675e-002	4.1642e-002	3.8e-002	4.2807e-005
2281	2.7675e-002	4.1643e-002	3.7e-002	4.2807e-005
2282	2.7675e-002	4.1643e-002	3.6e-002	4.2807e-005
2283	2.7675e-002	4.1643e-002	3.5e-002	4.2807e-005
2284	2.7675e-002	4.1643e-002	3.4e-002	4.2807e-005
2285	2.7674e-002	4.1643e-002	3.3e-002	4.2807e-005
2286	2.7674e-002	4.1643e-002	3.2e-002	4.2807e-005
2287	2.7674e-002	4.1643e-002	3.1e-002	4.2807e-005
2288	2.7674e-002	4.1643e-002	3.e-002	4.2807e-005
2289	2.7674e-002	4.1643e-002	2.9e-002	4.2807e-005
2290	2.7674e-002	4.1643e-002	2.8e-002	4.2807e-005
2291	2.7673e-002	4.1644e-002	2.7e-002	4.2806e-005
2292	2.7673e-002	4.1644e-002	2.6e-002	4.2806e-005
2293	2.7673e-002	4.1644e-002	2.5e-002	4.2806e-005
2294	2.7673e-002	4.1644e-002	2.4e-002	4.2806e-005
2295	2.7673e-002	4.1644e-002	2.3e-002	4.2806e-005
2296	2.7672e-002	4.1644e-002	2.2e-002	4.2806e-005
2297	2.7672e-002	4.1644e-002	2.1e-002	4.2806e-005
2298	2.7672e-002	4.1644e-002	2.e-002	4.2806e-005
2299	2.7672e-002	4.1645e-002	1.9e-002	4.2806e-005
2300	2.7672e-002	4.1645e-002	1.8e-002	4.2806e-005
2301	2.7672e-002	4.1645e-002	1.7e-002	4.2806e-005
2302	2.7671e-002	4.1645e-002	1.6e-002	4.2806e-005
2303	2.7671e-002	4.1645e-002	1.5e-002	4.2806e-005
2304	2.7671e-002	4.1645e-002	1.4e-002	4.2806e-005
2305	2.7671e-002	4.1645e-002	1.3e-002	4.2806e-005
2306	2.7671e-002	4.1645e-002	1.2e-002	4.2806e-005
2307	2.767e-002	4.1646e-002	1.1e-002	4.2805e-005
2308	2.767e-002	4.1646e-002	1.e-002	4.2806e-005
2309	2.6842e-002	4.2184e-002	1.e-002	4.2015e-005
2310	2.5998e-002	4.271e-002	1.e-002	4.1162e-005
2311	2.4279e-002	4.371e-002	1.e-002	3.9269e-005
2312	2.3405e-002	4.4184e-002	1.e-002	3.8232e-005
2313	2.2522e-002	4.464e-002	1.e-002	3.7139e-005
2314	2.163e-002	4.5079e-002	1.e-002	3.5989e-005
2315	2.073e-002	4.55e-002	1.e-002	3.4786e-005
2316	1.9821e-002	4.5904e-002	1.e-002	3.3531e-005
2317	1.8904e-002	4.6289e-002	1.e-002	3.2225e-005
2318	1.798e-002	4.6655e-002	1.e-002	3.0872e-005
2319	1.7049e-002	4.7003e-002	1.e-002	2.9473e-005
2320	1.6111e-002	4.7333e-002	1.e-002	2.8029e-005
2321	1.5167e-002	4.7644e-002	1.e-002	2.6545e-005
2322	1.4217e-002	4.7936e-002	1.e-002	2.502e-005
2323	1.3261e-002	4.8209e-002	1.e-002	2.3459e-005
2324	1.23e-002	4.8464e-002	1.e-002	2.1863e-005
2325	1.1334e-002	4.8699e-002	1.e-002	2.0235e-005
2326	1.0363e-002	4.8914e-002	1.e-002	1.8577e-005
2327	9.3886e-003	4.9111e-002	1.e-002	1.6891e-005
2328	8.4103e-003	4.9288e-002	1.e-002	1.5181e-005
2329	7.4288e-003	4.9445e-002	1.e-002	1.3448e-005
2330	6.4442e-003	4.9583e-002	1.e-002	1.1695e-005
2331	5.4571e-003	4.9701e-002	1.e-002	9.9251e-006
2332	4.4678e-003	4.98e-002	1.e-002	8.1405e-006
2333	3.4769e-003	4.9879e-002	1.e-002	6.344e-006
2334	2.4844e-003	4.9938e-002	1.e-002	4.5381e-006
2335	1.4911e-003	4.9978e-002	1.e-002	2.7256e-006
2336	4.9708e-004	4.9998e-002	1.e-002	9.09e-007
2337	-4.9703e-004	4.9998e-002	1.e-002	-9.0889e-007
2338	-1.491e-003	4.9978e-002	1.e-002	-2.7254e-006
2339	-2.4844e-003	4.9938e-002	1.e-002	-4.538e-006
2340	-3.4768e-003	4.9879e-002	1.e-002	-6.3439e-006
2341	-4.4678e-003	4.98e-002	1.e-002	-8.1404e-006
2342	-5.4571e-003	4.9701e-002	1.e-002	-9.925e-006
2343	-6.4441e-003	4.9583e-002	1.e-002	-1.1695e-005
2344	-7.4287e-003	4.9445e-002	1.e-002	-1.3448e-005
2345	-8.4103e-003	4.9288e-002	1.e-002	-1.5181e-005
2346	-9.3886e-003	4.9111e-002	1.e-002	-1.6891e-005
2347	-1.0363e-002	4.8914e-002	1.e-002	-1.8577e-005
2348	-1.1334e-002	4.8699e-002	1.e-002	-2.0235e-005
2349	-1.23e-002	4.8464e-002	1.e-002	-2.1863e-005
2350	-1.3261e-002	4.8209e-002	1.e-002	-2.3459e-005
2351	-1.4217e-002	4.7936e-002	1.e-002	-2.502e-005
2352	-1.5167e-002	4.7644e-002	1.e-002	-2.6544e-005
2353	-1.6111e-002	4.7333e-002	1.e-002	-2.8029e-005
2354	-1.7049e-002	4.7003e-002	1.e-002	-2.9472e-005
2355	-1.798e-002	4.6655e-002	1.e-002	-3.0872e-005
2356	-1.8904e-002	4.6289e-002	1.e-002	-3.2225e-005
2357	-1.9821e-002	4.5904e-002	1.e-002	-3.3531e-005
2358	-2.073e-002	4.55e-002	1.e-002	-3.4786e-005
2359	-2.163e-002	4.5079e-002	1.e-002	-3.5989e-005
2360	-2.2522e-002	4.464e-002	1.e-002	-3.7139e-005
2361	-2.3405e-002	4.4184e-002	1.e-002	-3.8232e-005
2362	-2.4279e-002	4.371e-002	1.e-002	-3.9266e-005
2363	-2.5135e-002	4.3223e-002	9.9976e-003	-4.0235e-005
2364	-2.5975e-002	4.2724e-002	9.9876e-003	-4.1139e-005
2365	-2.7616e-002	4.1681e-002	1.3002e-002	-4.2755e-005
2366	-2.7612e-002	4.1684e-002	1.4008e-002	-4.2754e-005
2367	-2.762e-002	4.1679e-002	1.5011e-002	-4.2759e-005
2368	-2.7637e-002	4.1668e-002	1.6015e-002	-4.2774e-005
2369	-2.7662e-002	4.1651e-002	1.7025e-002	-4.2796e-005
2370	-2.7693e-002	4.1631e-002	1.8032e-002	-4.2823e-005
2371	-2.7726e-002	4.1608e-002	1.9038e-002	-4.285e-005
2372	-2.778e-002	4.1572e-002	2.1047e-002	-4.2894e-005
2373	-2.7789e-002	4.1566e-002	2.205e-002	-4.2899e-005
2374	-2.7675e-002	4.1642e-002	4.e-002	-4.2805e-005
2375	-2.6842e-002	4.2184e-002	4.e-002	-4.2016e-005
2376	-2.5998e-002	4.271e-002	4.e-002	-4.1162e-005
2377	-2.5143e-002	4.3218e-002	4.e-002	-4.0246e-005
2378	-2.4279e-002	4.371e-002	4.e-002	-3.9269e-005
2379	-2.3405e-002	4.4184e-002	4.e-002	-3.8232e-005
2380	-2.2522e-002	4.464e-002	4.e-002	-3.7139e-005
2381	-2.163e-002	4.5079e-002	4.e-002	-3.5989e-005
2382	-2.073e-002	4.55e-002	4.e-002	-3.4786e-005
2383	-1.9821e-002	4.5904e-002	4.e-002	-3.3531e-005
2384	-1.8904e-002	4.6288e-002	4.e-002	-3.2225e-005
2385	-1.798e-002	4.6655e-002	4.e-002	-3.0872e-005
2386	-1.7049e-002	4.7003e-002	4.e-002	-2.9473e-005
2387	-1.6111e-002	4.7333e-002	4.e-002	-2.8029e-005
2388	-1.5167e-002	4.7644e-002	4.e-002	-2.6545e-005
2389	-1.4217e-002	4.7936e-002	4.e-002	-2.502e-005
2390	-1.3261e-002	4.8209e-002	4.e-002	-2.3459e-005
2391	-1.23e-002	4.8464e-002	4.e-002	-2.1863e-005
2392	-1.1334e-002	4.8699e-002	4.e-002	-2.0235e-005
2393	-1.0363e-002	4.8914e-002	4.e-002	-1.8577e-005
2394	-9.3887e-003	4.9111e-002	4.e-002	-1.6891e-005
2395	-8.4103e-003	4.9288e-002	4.e-002	-1.5181e-005
2396	-7.4288e-003	4.9445e-002	4.e-002	-1.3448e-005
2397	-6.4442e-003	4.9583e-002	4.e-002	-1.1695e-005
2398	-5.4572e-003	4.9701e-002	4.e-002	-9.9251e-006
2399	-4.4678e-003	4.98e-002	4.e-002	-8.1405e-006
2400	-3.4769e-003	4.9879e-002	4.e-002	-6.344e-006
2401	-2.4844e-003	4.9938e-002	4.e-002	-4.5381e-006
2402	-1.4911e-003	4.9978e-002	4.e-002	-2.7256e-006
2403	-4.9707e-004	4.9998e-002	4.e-002	-9.0904e-007
2404	4.9697e-004	4.9998e-002	4.e-002	9.0885e-007
2405	1.491e-003	4.9978e-002	4.e-002	2.7254e-006
2406	2.4843e-003	4.9938e-002	4.e-002	4.5379e-006
2407	3.4768e-003	4.9879e-002	4.e-002	6.3438e-006
2408	4.4677e-003	4.98e-002	4.e-002	8.1404e-006
2409	5.4571e-003	4.9701e-002	4.e-002	9.9249e-006
2410	6.4441e-003	4.9583e-002	4.e-002	1.1695e-005
2411	7.4287e-003	4.9445e-002	4.e-002	1.3448e-005
2412	8.4102e-003	4.9288e-002	4.e-002	1.518e-005
2413	9.3886e-003	4.9111e-002	4.e-002	1.6891e-005
2414	1.0363e-002	4.8914e-002	4.e-002	1.8577e-005
2415	1.1334e-002	4.8699e-002	4.e-002	2.0235e-005
2416	1.23e-002	4.8464e-002	4.e-002	2.1863e-005
2417	1.3261e-002	4.8209e-002	4.e-002	2.3459e-005
2418	1.4217e-002	4.7936e-002	4.e-002	2.502e-005
2419	1.5167e-002	4.7644e-002	4.e-002	2.6544e-005
2420	1.6111e-002	4.7333e-002	4.e-002	2.8029e-005
2421	1.7049e-002	4.7003e-002	4.e-002	2.9472e-005
2422	1.798e-002	4.6655e-002	4.e-002	3.0872e-005
2423	1.8904e-002	4.6289e-002	4.e-002	3.2225e-005
2424	1.9821e-002	4.5904e-002	4.e-002	3.3531e-005
2425	2.073e-002	4.55e-002	4.e-002	3.4786e-005
2426	2.163e-002	4.5079e-002	4.e-002	3.5989e-005
2427	2.2522e-002	4.464e-002	4.e-002	3.7139e-005
2428	2.3405e-002	4.4184e-002	4.e-002	3.8232e-005
2429	2.4279e-002	4.371e-002	4.e-002	3.9268e-005
2430	2.5143e-002	4.3218e-002	4.e-002	4.0246e-005
2431	2.5998e-002	4.271e-002	4.e-002	4.1162e-005
2432	2.6842e-002	4.2184e-002	4.e-002	4.2016e-005
2433	-2.7675e-002	4.1642e-002	3.9e-002	-4.2803e-005
2434	-2.7667e-002	4.1648e-002	3.8e-002	-4.28e-005
2435	-2.7666e-002	4.1648e-002	3.7e-002	-4.2799e-005
2436	-2.7666e-002	4.1649e-002	3.6e-002	-4.2798e-005
2437	-2.7665e-002	4.1649e-002	3.4999e-002	-4.2798e-005
2438	-2.7664e-002	4.165e-002	3.3999e-002	-4.2797e-005
2439	-2.7664e-002	4.165e-002	3.3e-002	-4.2797e-005
2440	-2.7663e-002	4.1651e-002	3.2e-002	-4.2796e-005
2441	-2.7662e-002	4.1651e-002	3.1e-002	-4.2796e-005
2442	-2.7661e-002	4.1652e-002	3.e-002	-4.2796e-005
2443	-2.766e-002	4.1652e-002	2.9e-002	-4.2796e-005
2444	-2.7659e-002	4.1653e-002	2.8e-002	-4.2796e-005
2445	-2.7665e-002	4.1649e-002	2.7005e-002	-4.2798e-005
2446	-2.767e-002	4.1646e-002	2.6012e-002	-4.2808e-005
2447	-2.7695e-002	4.1629e-002	2.5031e-002	-4.2828e-005
2448	-2.773e-002	4.1606e-002	2.4038e-002	-4.2856e-005
2449	-2.7762e-002	4.1585e-002	2.3044e-002	-4.2884e-005
2450	2.6842e-002	4.2184e-002	1.1e-002	4.2015e-005
2451	2.6842e-002	4.2184e-002	1.2e-002	4.2015e-005
2452	2.6842e-002	4.2184e-002	1.3e-002	4.2015e-005
2453	2.6842e-002	4.2184e-002	1.4e-002	4.2015e-005
2454	2.6842e-002	4.2184e-002	1.5e-002	4.2015e-005
2455	2.6842e-002	4.2184e-002	1.6e-002	4.2015e-005
2456	2.6842e-002	4.2184e-002	1.7e-002	4.2015e-005
2457	2.6842e-002	4.2184e-002	1.8e-002	4.2015e-005
2458	2.6842e-002	4.2184e-002	1.9e-002	4.2015e-005
2459	2.6842e-002	4.2184e-002	2.e-002	4.2016e-005
2460	2.6842e-002	4.2184e-002	2.1e-002	4.2016e-005
2461	2.6842e-002	4.2184e-002	2.2e-002	4.2016e-005
2462	2.6842e-002	4.2184e-002	2.3e-002	4.2016e-005
2463	2.6842e-002	4.2184e-002	2.4e-002	4.2016e-005
2464	2.6842e-002	4.2184e-002	2.5e-002	4.2016e-005
2465	2.6842e-002	4.2184e-002	2.6e-002	4.2016e-005
2466	2.6842e-002	4.2184e-002	2.7e-002	4.2016e-005
2467	2.6842e-002	4.2184e-002	2.8e-002	4.2016e-005
2468	2.6842e-002	4.2184e-002	2.9e-002	4.2016e-005
2469	2.6842e-002	4.2185e-002	3.e-002	4.2016e-005
2470	2.6842e-002	4.2185e-002	3.1e-002	4.2016e-005
2471	2.6841e-002	4.2185e-002	3.2e-002	4.2016e-005
2472	2.6841e-002	4.2185e-002	3.3e-002	4.2016e-005
2473	2.6841e-002	4.2185e-002	3.4e-002	4.2016e-005
2474	2.6841e-002	4.2185e-002	3.5e-002	4.2016e-005
2475	2.6841e-002	4.2185e-002	3.6e-002	4.2016e-005
2476	2.5998e-002	4.271e-002	1.1e-002	4.1162e-005
2477	2.5143e-002	4.3218e-002	1.1e-002	4.0246e-005
2478	2.4279e-002	4.3709e-002	1.1e-002	3.9269e-005
2479	2.3405e-002	4.4184e-002	1.1e-002	3.8232e-005
2480	2.2522e-002	4.464e-002	1.1e-002	3.7139e-005
2481	2.163e-002	4.5079e-002	1.1e-002	3.5989e-005
2482	2.073e-002	4.55e-002	1.1e-002	3.4786e-005
2483	1.9821e-002	4.5904e-002	1.1e-002	3.3531e-005
2484	1.8904e-002	4.6288e-002	1.1e-002	3.2225e-005
2485	1.798e-002	4.6655e-002	1.1e-002	3.0872e-005
2486	1.7049e-002	4.7003e-002	1.1e-002	2.9473e-005
2487	1.6111e-002	4.7333e-002	1.1e-002	2.8029e-005
2488	1.5167e-002	4.7644e-002	1.1e-002	2.6545e-005
2489	1.4217e-002	4.7936e-002	1.1e-002	2.502e-005
2490	1.3261e-002	4.8209e-002	1.1e-002	2.3459e-005
2491	1.23e-002	4.8464e-002	1.1e-002	2.1863e-005
2492	1.1334e-002	4.8699e-002	1.1e-002	2.0235e-005
2493	1.0363e-002	4.8914e-002	1.1e-002	1.8577e-005
2494	9.3887e-003	4.9111e-002	1.1e-002	1.6891e-005
2495	8.4103e-003	4.9288e-002	1.1e-002	1.5181e-005
2496	7.4288e-003	4.9445e-002	1.1e-002	1.3448e-005
2497	6.4442e-003	4.9583e-002	1.1e-002	1.1695e-005
2498	5.4571e-003	4.9701e-002	1.1e-002	9.9251e-006
2499	4.4678e-003	4.98e-002	1.1e-002	8.1405e-006
2500	3.4769e-003	4.9879e-002	1.1e-002	6.344e-006
2501	2.4844e-003	4.9938e-002	1.1e-002	4.5381e-006
2502	1.4911e-003	4.9978e-002	1.1e-002	2.7256e-006
2503	4.971e-004	4.9998e-002	1.1e-002	9.09e-007
2504	-4.9702e-004	4.9998e-002	1.1e-002	-9.0889e-007
2505	-1.491e-003	4.9978e-002	1.1e-002	-2.7254e-006
2506	-2.4844e-003	4.9938e-002	1.1e-002	-4.538e-006
2507	-3.4768e-003	4.9879e-002	1.1e-002	-6.3439e-006
2508	-4.4678e-003	4.98e-002	1.1e-002	-8.1404e-006
2509	-5.4571e-003	4.9701e-002	1.1e-002	-9.925e-006
2510	-6.4441e-003	4.9583e-002	1.1e-002	-1.1695e-005
2511	-7.4287e-003	4.9445e-002	1.1e-002	-1.3448e-005
2512	-8.4103e-003	4.9288e-002	1.1e-002	-1.5181e-005
2513	-9.3886e-003	4.9111e-002	1.1e-002	-1.6891e-005
2514	-1.0363e-002	4.8914e-002	1.1e-002	-1.8577e-005
2515	-1.1334e-002	4.8699e-002	1.1e-002	-2.0235e-005
2516	-1.23e-002	4.8464e-002	1.1e-002	-2.1863e-005
2517	-1.3261e-002	4.8209e-002	1.1e-002	-2.3459e-005
2518	-1.4217e-002	4.7936e-002	1.1e-002	-2.502e-005
2519	-1.5167e-002	4.7644e-002	1.1e-002	-2.6544e-005
2520	-1.6111e-002	4.7333e-002	1.1e-002	-2.8029e-005
2521	-1.7049e-002	4.7003e-002	1.1e-002	-2.9472e-005
2522	-1.798e-002	4.6655e-002	1.1e-002	-3.0872e-005
2523	-1.8904e-002	4.6289e-002	1.1e-002	-3.2225e-005
2524	-1.9821e-002	4.5904e-002	1.1e-002	-3.3531e-005
2525	-2.073e-002	4.55e-002	1.1e-002	-3.4786e-005
2526	-2.163e-002	4.5079e-002	1.1e-002	-3.5989e-005
2527	-2.2522e-002	4.464e-002	1.1e-002	-3.7139e-005
2528	-2.3405e-002	4.4184e-002	1.1e-002	-3.8232e-005
2529	-2.4279e-002	4.371e-002	1.1e-002	-3.9266e-005
2530	-2.5134e-002	4.3224e-002	1.0997e-002	-4.0233e-005
2531	-2.6799e-002	4.2211e-002	1.1987e-002	-4.1976e-005
2532	-2.6798e-002	4.2212e-002	1.2996e-002	-4.1974e-005
2533	-2.6796e-002	4.2213e-002	1.4004e-002	-4.1973e-005
2534	-2.6799e-002	4.2212e-002	1.5012e-002	-4.1977e-005
2535	-2.681e-002	4.2205e-002	1.6022e-002	-4.1991e-005
2536	-2.6841e-002	4.2185e-002	1.7033e-002	-4.2014e-005
2537	-2.6867e-002	4.2168e-002	1.8041e-002	-4.2042e-005
2538	-2.6899e-002	4.2148e-002	1.9054e-002	-4.2069e-005
2539	-2.692e-002	4.2134e-002	2.0055e-002	-4.2092e-005
2540	-2.6941e-002	4.2121e-002	2.1054e-002	-4.2109e-005
2541	-2.6946e-002	4.2118e-002	2.2053e-002	-4.2112e-005
2542	2.6842e-002	4.2184e-002	3.9e-002	4.2016e-005
2543	2.6842e-002	4.2184e-002	3.8e-002	4.2016e-005
2544	2.6842e-002	4.2184e-002	3.7e-002	4.2016e-005
2545	-2.6842e-002	4.2184e-002	3.9e-002	-4.2016e-005
2546	-2.5998e-002	4.271e-002	3.9e-002	-4.1162e-005
2547	-2.5143e-002	4.3218e-002	3.9e-002	-4.0246e-005
2548	-2.4279e-002	4.371e-002	3.9e-002	-3.9269e-005
2549	-2.3405e-002	4.4184e-002	3.9e-002	-3.8232e-005
2550	-2.2522e-002	4.464e-002	3.9e-002	-3.7139e-005
2551	-2.163e-002	4.5079e-002	3.9e-002	-3.5989e-005
2552	-2.073e-002	4.55e-002	3.9e-002	-3.4786e-005
2553	-1.9821e-002	4.5904e-002	3.9e-002	-3.3531e-005
2554	-1.8904e-002	4.6288e-002	3.9e-002	-3.2225e-005
2555	-1.798e-002	4.6655e-002	3.9e-002	-3.0872e-005
2556	-1.7049e-002	4.7003e-002	3.9e-002	-2.9473e-005
2557	-1.6111e-002	4.7333e-002	3.9e-002	-2.8029e-005
2558	-1.5167e-002	4.7644e-002	3.9e-002	-2.6545e-005
2559	-1.4217e-002	4.7936e-002	3.9e-002	-2.502e-005
2560	-1.3261e-002	4.8209e-002	3.9e-002	-2.3459e-005
2561	-1.23e-002	4.8464e-002	3.9e-002	-2.1863e-005
2562	-1.1334e-002	4.8699e-002	3.9e-002	-2.0235e-005
2563	-1.0363e-002	4.8914e-002	3.9e-002	-1.8577e-005
2564	-9.3887e-003	4.9111e-002	3.9e-002	-1.6891e-005
2565	-8.4103e-003	4.9288e-002	3.9e-002	-1.5181e-005
2566	-7.4288e-003	4.9445e-002	3.9e-002	-1.3448e-005
2567	-6.4442e-003	4.9583e-002	3.9e-002	-1.1695e-005
2568	-5.4572e-003	4.9701e-002	3.9e-002	-9.9251e-006
2569	-4.4678e-003	4.98e-002	3.9e-002	-8.1406e-006
2570	-3.4769e-003	4.9879e-002	3.9e-002	-6.344e-006
2571	-2.4844e-003	4.9938e-002	3.9e-002	-4.5382e-006
2572	-1.4912e-003	4.9978e-002	3.9e-002	-2.7256e-006
2573	-4.971e-004	4.9998e-002	3.9e-002	-9.0906e-007
2574	4.9697e-004	4.9998e-002	3.9e-002	9.0883e-007
2575	1.491e-003	4.9978e-002	3.9e-002	2.7254e-006
2576	2.4843e-003	4.9938e-002	3.9e-002	4.5379e-006
2577	3.4768e-003	4.9879e-002	3.9e-002	6.3438e-006
2578	4.4677e-003	4.98e-002	3.9e-002	8.1403e-006
2579	5.457e-003	4.9701e-002	3.9e-002	9.9249e-006
2580	6.4441e-003	4.9583e-002	3.9e-002	1.1695e-005
2581	7.4287e-003	4.9445e-002	3.9e-002	1.3448e-005
2582	8.4102e-003	4.9288e-002	3.9e-002	1.518e-005
2583	9.3886e-003	4.9111e-002	3.9e-002	1.6891e-005
2584	1.0363e-002	4.8914e-002	3.9e-002	1.8577e-005
2585	1.1334e-002	4.8699e-002	3.9e-002	2.0235e-005
2586	1.23e-002	4.8464e-002	3.9e-002	2.1863e-005
2587	1.3261e-002	4.8209e-002	3.9e-002	2.3459e-005
2588	1.4217e-002	4.7936e-002	3.9e-002	2.502e-005
2589	1.5167e-002	4.7644e-002	3.9e-002	2.6544e-005
2590	1.6111e-002	4.7333e-002	3.9e-002	2.8029e-005
2591	1.7049e-002	4.7003e-002	3.9e-002	2.9472e-005
2592	1.798e-002	4.6655e-002	3.9e-002	3.0872e-005
2593	1.8904e-002	4.6289e-002	3.9e-002	3.2225e-005
2594	1.9821e-002	4.5904e-002	3.9e-002	3.3531e-005
2595	2.073e-002	4.55e-002	3.9e-002	3.4786e-005
2596	2.163e-002	4.5079e-002	3.9e-002	3.5989e-005
2597	2.2522e-002	4.464e-002	3.9e-002	3.7138e-005
2598	2.3405e-002	4.4184e-002	3.9e-002	3.8232e-005
2599	2.4279e-002	4.371e-002	3.9e-002	3.9268e-005
2600	2.5143e-002	4.3218e-002	3.9e-002	4.0246e-005
2601	-2.5972e-002	4.2725e-002	1.0989e-002	-4.1136e-005
2602	-2.6842e-002	4.2184e-002	3.8e-002	-4.2015e-005
2603	-2.6842e-002	4.2184e-002	3.7e-002	-4.2014e-005
2604	-2.6842e-002	4.2184e-002	3.6e-002	-4.2014e-005
2605	-2.6842e-002	4.2184e-002	3.5e-002	-4.2014e-005
2606	-2.6842e-002	4.2184e-002	3.4e-002	-4.2014e-005
2607	-2.6842e-002	4.2184e-002	3.3e-002	-4.2014e-005
2608	-2.6842e-002	4.2184e-002	3.2e-002	-4.2014e-005
2609	-2.6841e-002	4.2185e-002	3.1e-002	-4.2013e-005
2610	-2.6841e-002	4.2185e-002	3.e-002	-4.2013e-005
2611	-2.6841e-002	4.2185e-002	2.9e-002	-4.2013e-005
2612	-2.6841e-002	4.2185e-002	2.8e-002	-4.2012e-005
2613	-2.6834e-002	4.219e-002	2.7e-002	-4.2012e-005
2614	-2.6842e-002	4.2184e-002	2.6015e-002	-4.2021e-005
2615	-2.6868e-002	4.2168e-002	2.503e-002	-4.2042e-005
2616	-2.6898e-002	4.2149e-002	2.404e-002	-4.2071e-005
2617	2.5998e-002	4.271e-002	1.2e-002	4.1162e-005
2618	2.5143e-002	4.3218e-002	1.2e-002	4.0246e-005
2619	2.3405e-002	4.4184e-002	1.2e-002	3.8232e-005
2620	2.2522e-002	4.464e-002	1.2e-002	3.7139e-005
2621	2.163e-002	4.5079e-002	1.2e-002	3.5989e-005
2622	2.073e-002	4.55e-002	1.2e-002	3.4786e-005
2623	1.9821e-002	4.5904e-002	1.2e-002	3.3531e-005
2624	1.8904e-002	4.6289e-002	1.2e-002	3.2225e-005
2625	1.798e-002	4.6655e-002	1.2e-002	3.0872e-005
2626	1.7049e-002	4.7003e-002	1.2e-002	2.9473e-005
2627	1.5167e-002	4.7644e-002	1.2e-002	2.6545e-005
2628	1.4217e-002	4.7936e-002	1.2e-002	2.502e-005
2629	1.3261e-002	4.8209e-002	1.2e-002	2.3459e-005
2630	1.23e-002	4.8464e-002	1.2e-002	2.1863e-005
2631	1.1334e-002	4.8699e-002	1.2e-002	2.0235e-005
2632	1.0363e-002	4.8914e-002	1.2e-002	1.8577e-005
2633	9.3886e-003	4.9111e-002	1.2e-002	1.6891e-005
2634	8.4103e-003	4.9288e-002	1.2e-002	1.5181e-005
2635	7.4287e-003	4.9445e-002	1.2e-002	1.3448e-005
2636	6.4442e-003	4.9583e-002	1.2e-002	1.1695e-005
2637	5.4571e-003	4.9701e-002	1.2e-002	9.9251e-006
2638	4.4678e-003	4.98e-002	1.2e-002	8.1405e-006
2639	3.4768e-003	4.9879e-002	1.2e-002	6.344e-006
2640	2.4844e-003	4.9938e-002	1.2e-002	4.5381e-006
2641	1.4911e-003	4.9978e-002	1.2e-002	2.7256e-006
2642	4.9708e-004	4.9998e-002	1.2e-002	9.09e-007
2643	-4.9704e-004	4.9998e-002	1.2e-002	-9.0889e-007
2644	-1.491e-003	4.9978e-002	1.2e-002	-2.7254e-006
2645	-2.4844e-003	4.9938e-002	1.2e-002	-4.538e-006
2646	-3.4768e-003	4.9879e-002	1.2e-002	-6.3439e-006
2647	-4.4678e-003	4.98e-002	1.2e-002	-8.1404e-006
2648	-5.4571e-003	4.9701e-002	1.2e-002	-9.9249e-006
2649	-6.4441e-003	4.9583e-002	1.2e-002	-1.1695e-005
2650	-7.4287e-003	4.9445e-002	1.2e-002	-1.3448e-005
2651	-8.4103e-003	4.9288e-002	1.2e-002	-1.5181e-005
2652	-9.3886e-003	4.9111e-002	1.2e-002	-1.6891e-005
2653	-1.0363e-002	4.8914e-002	1.2e-002	-1.8577e-005
2654	-1.1334e-002	4.8699e-002	1.2e-002	-2.0235e-005
2655	-1.23e-002	4.8464e-002	1.2e-002	-2.1863e-005
2656	-1.3261e-002	4.8209e-002	1.2e-002	-2.3459e-005
2657	-1.4217e-002	4.7936e-002	1.2e-002	-2.502e-005
2658	-1.5167e-002	4.7644e-002	1.2e-002	-2.6544e-005
2659	-1.6111e-002	4.7333e-002	1.2e-002	-2.8029e-005
2660	-1.7049e-002	4.7003e-002	1.2e-002	-2.9472e-005
2661	-1.798e-002	4.6655e-002	1.2e-002	-3.0872e-005
2662	-1.8904e-002	4.6289e-002	1.2e-002	-3.2225e-005
2663	-1.9821e-002	4.5904e-002	1.2e-002	-3.3531e-005
2664	-2.073e-002	4.55e-002	1.2e-002	-3.4786e-005
2665	-2.163e-002	4.5079e-002	1.2e-002	-3.5989e-005
2666	-2.2522e-002	4.464e-002	1.2e-002	-3.7139e-005
2667	-2.3405e-002	4.4184e-002	1.2e-002	-3.8232e-005
2668	-2.4279e-002	4.371e-002	1.2e-002	-3.9265e-005
2669	-2.5132e-002	4.3225e-002	1.1996e-002	-4.0233e-005
2670	-2.5971e-002	4.2726e-002	1.199e-002	-4.1135e-005
2671	-2.5974e-002	4.2724e-002	1.299e-002	-4.1133e-005
2672	-2.5965e-002	4.273e-002	1.3995e-002	-4.1132e-005
2673	-2.5971e-002	4.2726e-002	1.5008e-002	-4.1134e-005
2674	-2.5977e-002	4.2722e-002	1.6019e-002	-4.1147e-005
2675	-2.6009e-002	4.2703e-002	1.7025e-002	-4.1169e-005
2676	-2.6031e-002	4.269e-002	1.8043e-002	-4.1195e-005
2677	-2.6054e-002	4.2675e-002	1.9054e-002	-4.1219e-005
2678	-2.6078e-002	4.2661e-002	2.0059e-002	-4.1241e-005
2679	-2.6086e-002	4.2656e-002	2.1057e-002	-4.1252e-005
2680	-2.6088e-002	4.2655e-002	2.2049e-002	-4.1252e-005
2681	2.5998e-002	4.271e-002	3.8e-002	4.1162e-005
2682	2.5998e-002	4.271e-002	3.7e-002	4.1162e-005
2683	2.5997e-002	4.271e-002	3.6e-002	4.1162e-005
2684	2.5997e-002	4.271e-002	3.4e-002	4.1162e-005
2685	2.5997e-002	4.271e-002	3.3e-002	4.1162e-005
2686	2.5997e-002	4.271e-002	3.2e-002	4.1162e-005
2687	2.5997e-002	4.271e-002	3.1e-002	4.1162e-005
2688	2.5997e-002	4.271e-002	3.e-002	4.1162e-005
2689	2.5997e-002	4.271e-002	2.9e-002	4.1162e-005
2690	2.5997e-002	4.271e-002	2.8e-002	4.1162e-005
2691	2.5997e-002	4.271e-002	2.7e-002	4.1162e-005
2692	2.5997e-002	4.271e-002	2.6e-002	4.1162e-005
2693	2.5997e-002	4.271e-002	2.5e-002	4.1162e-005
2694	2.5997e-002	4.271e-002	2.4e-002	4.1162e-005
2695	2.5997e-002	4.271e-002	2.3e-002	4.1162e-005
2696	2.5997e-002	4.271e-002	2.2e-002	4.1162e-005
2697	2.5997e-002	4.271e-002	2.1e-002	4.1162e-005
2698	2.5997e-002	4.271e-002	2.e-002	4.1162e-005
2699	2.5997e-002	4.271e-002	1.9e-002	4.1162e-005
2700	2.5997e-002	4.271e-002	1.8e-002	4.1162e-005
2701	2.5997e-002	4.271e-002	1.7e-002	4.1162e-005
2702	2.5997e-002	4.271e-002	1.6e-002	4.1162e-005
2703	2.5997e-002	4.271e-002	1.5e-002	4.1162e-005
2704	2.5997e-002	4.271e-002	1.4e-002	4.1162e-005
2705	2.5998e-002	4.271e-002	1.3e-002	4.1162e-005
2706	-2.5998e-002	4.271e-002	3.8e-002	-4.1162e-005
2707	-2.5143e-002	4.3218e-002	3.8e-002	-4.0246e-005
2708	-2.4279e-002	4.371e-002	3.8e-002	-3.9269e-005
2709	-2.3405e-002	4.4184e-002	3.8e-002	-3.8232e-005
2710	-2.2522e-002	4.464e-002	3.8e-002	-3.7139e-005
2711	-2.163e-002	4.5079e-002	3.8e-002	-3.5989e-005
2712	-2.073e-002	4.55e-002	3.8e-002	-3.4786e-005
2713	-1.9821e-002	4.5904e-002	3.8e-002	-3.3531e-005
2714	-1.8904e-002	4.6288e-002	3.8e-002	-3.2225e-005
2715	-1.798e-002	4.6655e-002	3.8e-002	-3.0872e-005
2716	-1.7049e-002	4.7003e-002	3.8e-002	-2.9473e-005
2717	-1.6111e-002	4.7333e-002	3.8e-002	-2.8029e-005
2718	-1.5167e-002	4.7644e-002	3.8e-002	-2.6545e-005
2719	-1.4217e-002	4.7936e-002	3.8e-002	-2.5021e-005
2720	-1.3261e-002	4.8209e-002	3.8e-002	-2.3459e-005
2721	-1.23e-002	4.8464e-002	3.8e-002	-2.1863e-005
2722	-1.1334e-002	4.8699e-002	3.8e-002	-2.0235e-005
2723	-1.0363e-002	4.8914e-002	3.8e-002	-1.8577e-005
2724	-9.3887e-003	4.9111e-002	3.8e-002	-1.6891e-005
2725	-8.4103e-003	4.9288e-002	3.8e-002	-1.5181e-005
2726	-7.4289e-003	4.9445e-002	3.8e-002	-1.3448e-005
2727	-6.4442e-003	4.9583e-002	3.8e-002	-1.1695e-005
2728	-5.4572e-003	4.9701e-002	3.8e-002	-9.9251e-006
2729	-4.4678e-003	4.98e-002	3.8e-002	-8.1406e-006
2730	-3.477e-003	4.9879e-002	3.8e-002	-6.3441e-006
2731	-2.4844e-003	4.9938e-002	3.8e-002	-4.5382e-006
2732	-1.4912e-003	4.9978e-002	3.8e-002	-2.7256e-006
2733	-4.9709e-004	4.9998e-002	3.8e-002	-9.0909e-007
2734	4.9693e-004	4.9998e-002	3.8e-002	9.088e-007
2735	1.491e-003	4.9978e-002	3.8e-002	2.7254e-006
2736	2.4843e-003	4.9938e-002	3.8e-002	4.5379e-006
2737	3.4768e-003	4.9879e-002	3.8e-002	6.3438e-006
2738	4.4677e-003	4.98e-002	3.8e-002	8.1403e-006
2739	5.4571e-003	4.9701e-002	3.8e-002	9.9249e-006
2740	6.444e-003	4.9583e-002	3.8e-002	1.1695e-005
2741	7.4287e-003	4.9445e-002	3.8e-002	1.3448e-005
2742	8.4102e-003	4.9288e-002	3.8e-002	1.518e-005
2743	9.3886e-003	4.9111e-002	3.8e-002	1.6891e-005
2744	1.0363e-002	4.8914e-002	3.8e-002	1.8577e-005
2745	1.1334e-002	4.8699e-002	3.8e-002	2.0235e-005
2746	1.2299e-002	4.8464e-002	3.8e-002	2.1863e-005
2747	1.3261e-002	4.8209e-002	3.8e-002	2.3459e-005
2748	1.4217e-002	4.7936e-002	3.8e-002	2.502e-005
2749	1.5167e-002	4.7644e-002	3.8e-002	2.6544e-005
2750	1.6111e-002	4.7333e-002	3.8e-002	2.8029e-005
2751	1.7049e-002	4.7003e-002	3.8e-002	2.9472e-005
2752	1.798e-002	4.6655e-002	3.8e-002	3.0872e-005
2753	1.8904e-002	4.6289e-002	3.8e-002	3.2225e-005
2754	1.9821e-002	4.5904e-002	3.8e-002	3.353e-005
2755	2.073e-002	4.55e-002	3.8e-002	3.4786e-005
2756	2.163e-002	4.5079e-002	3.8e-002	3.5989e-005
2757	2.2522e-002	4.464e-002	3.8e-002	3.7138e-005
2758	2.3405e-002	4.4184e-002	3.8e-002	3.8232e-005
2759	2.4279e-002	4.371e-002	3.8e-002	3.9268e-005
2760	2.5143e-002	4.3218e-002	3.8e-002	4.0246e-005
2761	-2.5998e-002	4.271e-002	3.7e-002	-4.1162e-005
2762	-2.5998e-002	4.271e-002	3.6e-002	-4.1162e-005
2763	-2.5998e-002	4.271e-002	3.5e-002	-4.1162e-005
2764	-2.5998e-002	4.271e-002	3.4e-002	-4.1162e-005
2765	-2.5998e-002	4.271e-002	3.3e-002	-4.1162e-005
2766	-2.5998e-002	4.271e-002	3.2e-002	-4.1162e-005
2767	-2.5998e-002	4.271e-002	3.1e-002	-4.1162e-005
2768	-2.5998e-002	4.271e-002	3.e-002	-4.1162e-005
2769	-2.5998e-002	4.271e-002	2.9e-002	-4.1162e-005
2770	-2.5998e-002	4.2709e-002	2.8e-002	-4.1162e-005
2771	-2.5998e-002	4.2709e-002	2.7e-002	-4.1161e-005
2772	-2.6e-002	4.2709e-002	2.6012e-002	-4.1168e-005
2773	-2.6019e-002	4.2697e-002	2.503e-002	-4.1187e-005
2774	-2.6056e-002	4.2674e-002	2.404e-002	-4.1215e-005
2775	-2.6074e-002	4.2663e-002	2.3044e-002	-4.1239e-005
2776	-2.5131e-002	4.3226e-002	1.2998e-002	-4.0231e-005
2777	-2.5128e-002	4.3227e-002	1.3998e-002	-4.023e-005
2778	-2.5129e-002	4.3227e-002	1.5002e-002	-4.0232e-005
2779	-2.5139e-002	4.3221e-002	1.6008e-002	-4.024e-005
2780	-2.5153e-002	4.3213e-002	1.7021e-002	-4.0257e-005
2781	-2.5175e-002	4.3199e-002	1.8028e-002	-4.0278e-005
2782	-2.5193e-002	4.3189e-002	1.9041e-002	-4.0301e-005
2783	-2.5226e-002	4.317e-002	2.1052e-002	-4.0329e-005
2784	-2.5216e-002	4.3176e-002	2.204e-002	-4.0323e-005
2785	-2.5205e-002	4.3182e-002	2.3032e-002	-4.0311e-005
2786	2.5143e-002	4.3218e-002	1.3e-002	4.0246e-005
2787	2.4279e-002	4.371e-002	1.3e-002	3.9269e-005
2788	2.3405e-002	4.4184e-002	1.3e-002	3.8232e-005
2789	2.2522e-002	4.464e-002	1.3e-002	3.7139e-005
2790	2.163e-002	4.5079e-002	1.3e-002	3.5989e-005
2791	2.073e-002	4.55e-002	1.3e-002	3.4786e-005
2792	1.9821e-002	4.5903e-002	1.3e-002	3.3531e-005
2793	1.8904e-002	4.6288e-002	1.3e-002	3.2225e-005
2794	1.798e-002	4.6655e-002	1.3e-002	3.0872e-005
2795	1.7049e-002	4.7003e-002	1.3e-002	2.9473e-005
2796	1.6111e-002	4.7333e-002	1.3e-002	2.8029e-005
2797	1.5167e-002	4.7644e-002	1.3e-002	2.6545e-005
2798	1.4217e-002	4.7936e-002	1.3e-002	2.502e-005
2799	1.3261e-002	4.8209e-002	1.3e-002	2.3459e-005
2800	1.23e-002	4.8464e-002	1.3e-002	2.1863e-005
2801	1.1334e-002	4.8699e-002	1.3e-002	2.0235e-005
2802	1.0363e-002	4.8914e-002	1.3e-002	1.8577e-005
2803	9.3887e-003	4.9111e-002	1.3e-002	1.6891e-005
2804	8.4103e-003	4.9288e-002	1.3e-002	1.5181e-005
2805	7.4288e-003	4.9445e-002	1.3e-002	1.3448e-005
2806	6.4442e-003	4.9583e-002	1.3e-002	1.1695e-005
2807	5.4571e-003	4.9701e-002	1.3e-002	9.9251e-006
2808	4.4678e-003	4.98e-002	1.3e-002	8.1405e-006
2809	3.4769e-003	4.9879e-002	1.3e-002	6.344e-006
2810	2.4844e-003	4.9938e-002	1.3e-002	4.5381e-006
2811	1.4911e-003	4.9978e-002	1.3e-002	2.7256e-006
2812	4.971e-004	4.9998e-002	1.3e-002	9.0901e-007
2813	-4.9702e-004	4.9998e-002	1.3e-002	-9.0888e-007
2814	-1.491e-003	4.9978e-002	1.3e-002	-2.7254e-006
2815	-2.4844e-003	4.9938e-002	1.3e-002	-4.538e-006
2816	-3.4768e-003	4.9879e-002	1.3e-002	-6.3438e-006
2817	-4.4678e-003	4.98e-002	1.3e-002	-8.1404e-006
2818	-5.457e-003	4.9701e-002	1.3e-002	-9.9249e-006
2819	-6.4441e-003	4.9583e-002	1.3e-002	-1.1695e-005
2820	-7.4287e-003	4.9445e-002	1.3e-002	-1.3448e-005
2821	-8.4103e-003	4.9288e-002	1.3e-002	-1.5181e-005
2822	-9.3886e-003	4.9111e-002	1.3e-002	-1.6891e-005
2823	-1.0363e-002	4.8914e-002	1.3e-002	-1.8577e-005
2824	-1.1334e-002	4.8699e-002	1.3e-002	-2.0235e-005
2825	-1.23e-002	4.8464e-002	1.3e-002	-2.1863e-005
2826	-1.3261e-002	4.8209e-002	1.3e-002	-2.3459e-005
2827	-1.4217e-002	4.7936e-002	1.3e-002	-2.502e-005
2828	-1.5167e-002	4.7644e-002	1.3e-002	-2.6544e-005
2829	-1.6111e-002	4.7333e-002	1.3e-002	-2.8029e-005
2830	-1.7049e-002	4.7004e-002	1.3e-002	-2.9472e-005
2831	-1.798e-002	4.6655e-002	1.3e-002	-3.0872e-005
2832	-1.8904e-002	4.6289e-002	1.3e-002	-3.2225e-005
2833	-1.9821e-002	4.5904e-002	1.3e-002	-3.3531e-005
2834	-2.073e-002	4.55e-002	1.3e-002	-3.4786e-005
2835	-2.163e-002	4.5079e-002	1.3e-002	-3.5989e-005
2836	-2.2522e-002	4.464e-002	1.3e-002	-3.7138e-005
2837	-2.3405e-002	4.4184e-002	1.3e-002	-3.8232e-005
2838	-2.4279e-002	4.371e-002	1.3e-002	-3.9265e-005
2839	2.5143e-002	4.3218e-002	3.7e-002	4.0246e-005
2840	2.5143e-002	4.3218e-002	3.6e-002	4.0246e-005
2841	2.5143e-002	4.3218e-002	3.5e-002	4.0246e-005
2842	2.5143e-002	4.3218e-002	3.4e-002	4.0246e-005
2843	2.5143e-002	4.3218e-002	3.3e-002	4.0246e-005
2844	2.5143e-002	4.3218e-002	3.2e-002	4.0246e-005
2845	2.5143e-002	4.3218e-002	3.1e-002	4.0246e-005
2846	2.5143e-002	4.3218e-002	3.e-002	4.0246e-005
2847	2.5143e-002	4.3218e-002	2.9e-002	4.0246e-005
2848	2.5143e-002	4.3218e-002	2.8e-002	4.0246e-005
2849	2.5143e-002	4.3218e-002	2.7e-002	4.0246e-005
2850	2.5143e-002	4.3218e-002	2.6e-002	4.0246e-005
2851	2.5143e-002	4.3218e-002	2.5e-002	4.0246e-005
2852	2.5143e-002	4.3218e-002	2.4e-002	4.0246e-005
2853	2.5143e-002	4.3218e-002	2.3e-002	4.0246e-005
2854	2.5143e-002	4.3218e-002	2.2e-002	4.0246e-005
2855	2.5143e-002	4.3218e-002	2.1e-002	4.0246e-005
2856	2.5143e-002	4.3218e-002	2.e-002	4.0246e-005
2857	2.5143e-002	4.3218e-002	1.9e-002	4.0246e-005
2858	2.5143e-002	4.3218e-002	1.8e-002	4.0246e-005
2859	2.5143e-002	4.3218e-002	1.7e-002	4.0246e-005
2860	2.5143e-002	4.3218e-002	1.6e-002	4.0246e-005
2861	2.5143e-002	4.3218e-002	1.5e-002	4.0246e-005
2862	2.5143e-002	4.3218e-002	1.4e-002	4.0246e-005
2863	-2.5143e-002	4.3218e-002	3.7e-002	-4.0246e-005
2864	-2.4279e-002	4.371e-002	3.7e-002	-3.9269e-005
2865	-2.3405e-002	4.4184e-002	3.7e-002	-3.8232e-005
2866	-2.2522e-002	4.464e-002	3.7e-002	-3.7139e-005
2867	-2.163e-002	4.5079e-002	3.7e-002	-3.5989e-005
2868	-2.073e-002	4.55e-002	3.7e-002	-3.4786e-005
2869	-1.9821e-002	4.5904e-002	3.7e-002	-3.3531e-005
2870	-1.8904e-002	4.6288e-002	3.7e-002	-3.2225e-005
2871	-1.798e-002	4.6655e-002	3.7e-002	-3.0872e-005
2872	-1.7049e-002	4.7003e-002	3.7e-002	-2.9473e-005
2873	-1.6111e-002	4.7333e-002	3.7e-002	-2.8029e-005
2874	-1.5167e-002	4.7644e-002	3.7e-002	-2.6545e-005
2875	-1.4217e-002	4.7936e-002	3.7e-002	-2.5021e-005
2876	-1.3261e-002	4.8209e-002	3.7e-002	-2.3459e-005
2877	-1.23e-002	4.8464e-002	3.7e-002	-2.1863e-005
2878	-1.1334e-002	4.8699e-002	3.7e-002	-2.0235e-005
2879	-1.0363e-002	4.8914e-002	3.7e-002	-1.8577e-005
2880	-9.3888e-003	4.9111e-002	3.7e-002	-1.6891e-005
2881	-8.4103e-003	4.9288e-002	3.7e-002	-1.5181e-005
2882	-7.4289e-003	4.9445e-002	3.7e-002	-1.3448e-005
2883	-6.4442e-003	4.9583e-002	3.7e-002	-1.1695e-005
2884	-5.4572e-003	4.9701e-002	3.7e-002	-9.9252e-006
2885	-4.4678e-003	4.98e-002	3.7e-002	-8.1406e-006
2886	-3.477e-003	4.9879e-002	3.7e-002	-6.3441e-006
2887	-2.4844e-003	4.9938e-002	3.7e-002	-4.5382e-006
2888	-1.4912e-003	4.9978e-002	3.7e-002	-2.7257e-006
2889	-4.971e-004	4.9998e-002	3.7e-002	-9.0912e-007
2890	4.9691e-004	4.9998e-002	3.7e-002	9.0877e-007
2891	1.491e-003	4.9978e-002	3.7e-002	2.7253e-006
2892	2.4842e-003	4.9938e-002	3.7e-002	4.5379e-006
2893	3.4768e-003	4.9879e-002	3.7e-002	6.3437e-006
2894	4.4677e-003	4.98e-002	3.7e-002	8.1403e-006
2895	5.4571e-003	4.9701e-002	3.7e-002	9.9248e-006
2896	6.444e-003	4.9583e-002	3.7e-002	1.1695e-005
2897	7.4287e-003	4.9445e-002	3.7e-002	1.3448e-005
2898	8.4101e-003	4.9288e-002	3.7e-002	1.518e-005
2899	9.3886e-003	4.9111e-002	3.7e-002	1.6891e-005
2900	1.0363e-002	4.8914e-002	3.7e-002	1.8577e-005
2901	1.1334e-002	4.8699e-002	3.7e-002	2.0235e-005
2902	1.2299e-002	4.8464e-002	3.7e-002	2.1863e-005
2903	1.3261e-002	4.8209e-002	3.7e-002	2.3459e-005
2904	1.4216e-002	4.7936e-002	3.7e-002	2.502e-005
2905	1.5167e-002	4.7644e-002	3.7e-002	2.6544e-005
2906	1.6111e-002	4.7333e-002	3.7e-002	2.8029e-005
2907	1.7049e-002	4.7003e-002	3.7e-002	2.9472e-005
2908	1.798e-002	4.6655e-002	3.7e-002	3.0872e-005
2909	1.8904e-002	4.6289e-002	3.7e-002	3.2225e-005
2910	1.9821e-002	4.5904e-002	3.7e-002	3.353e-005
2911	2.073e-002	4.55e-002	3.7e-002	3.4786e-005
2912	2.2522e-002	4.464e-002	3.7e-002	3.7139e-005
2913	2.3405e-002	4.4184e-002	3.7e-002	3.8232e-005
2914	2.4279e-002	4.371e-002	3.7e-002	3.9268e-005
2915	-2.5143e-002	4.3218e-002	3.6e-002	-4.0246e-005
2916	-2.5143e-002	4.3218e-002	3.5e-002	-4.0246e-005
2917	-2.5143e-002	4.3218e-002	3.4e-002	-4.0246e-005
2918	-2.5143e-002	4.3218e-002	3.3e-002	-4.0246e-005
2919	-2.5143e-002	4.3218e-002	3.2e-002	-4.0246e-005
2920	-2.5143e-002	4.3218e-002	3.1e-002	-4.0246e-005
2921	-2.5143e-002	4.3218e-002	3.e-002	-4.0246e-005
2922	-2.5143e-002	4.3218e-002	2.9e-002	-4.0246e-005
2923	-2.5143e-002	4.3218e-002	2.8e-002	-4.0246e-005
2924	-2.5143e-002	4.3218e-002	2.7e-002	-4.0246e-005
2925	-2.5143e-002	4.3218e-002	2.6e-002	-4.025e-005
2926	-2.5156e-002	4.3211e-002	2.5015e-002	-4.0266e-005
2927	-2.5188e-002	4.3192e-002	2.4023e-002	-4.0291e-005
2928	-2.4279e-002	4.371e-002	1.4e-002	-3.9264e-005
2929	-2.4279e-002	4.371e-002	1.5e-002	-3.9265e-005
2930	-2.4279e-002	4.371e-002	1.6e-002	-3.9269e-005
2931	-2.4287e-002	4.3705e-002	1.7006e-002	-3.9278e-005
2932	-2.4302e-002	4.3697e-002	1.802e-002	-3.9295e-005
2933	-2.4322e-002	4.3686e-002	1.9028e-002	-3.9315e-005
2934	-2.434e-002	4.3675e-002	2.003e-002	-3.9331e-005
2935	-2.4339e-002	4.3676e-002	2.1031e-002	-3.9336e-005
2936	2.4279e-002	4.3709e-002	1.4e-002	3.9269e-005
2937	2.3405e-002	4.4184e-002	1.4e-002	3.8232e-005
2938	2.2522e-002	4.464e-002	1.4e-002	3.7139e-005
2939	2.163e-002	4.5079e-002	1.4e-002	3.5989e-005
2940	2.073e-002	4.55e-002	1.4e-002	3.4786e-005
2941	1.9821e-002	4.5903e-002	1.4e-002	3.3531e-005
2942	1.8904e-002	4.6289e-002	1.4e-002	3.2225e-005
2943	1.798e-002	4.6655e-002	1.4e-002	3.0872e-005
2944	1.6111e-002	4.7333e-002	1.4e-002	2.8029e-005
2945	1.4217e-002	4.7936e-002	1.4e-002	2.502e-005
2946	1.3261e-002	4.8209e-002	1.4e-002	2.3459e-005
2947	1.23e-002	4.8464e-002	1.4e-002	2.1863e-005
2948	1.1334e-002	4.8699e-002	1.4e-002	2.0235e-005
2949	1.0363e-002	4.8914e-002	1.4e-002	1.8577e-005
2950	9.3886e-003	4.9111e-002	1.4e-002	1.6891e-005
2951	8.4103e-003	4.9288e-002	1.4e-002	1.5181e-005
2952	7.4288e-003	4.9445e-002	1.4e-002	1.3448e-005
2953	6.4442e-003	4.9583e-002	1.4e-002	1.1695e-005
2954	5.4571e-003	4.9701e-002	1.4e-002	9.9251e-006
2955	4.4678e-003	4.98e-002	1.4e-002	8.1405e-006
2956	3.4769e-003	4.9879e-002	1.4e-002	6.344e-006
2957	2.4844e-003	4.9938e-002	1.4e-002	4.5381e-006
2958	1.4911e-003	4.9978e-002	1.4e-002	2.7256e-006
2959	4.9709e-004	4.9998e-002	1.4e-002	9.0901e-007
2960	-4.9703e-004	4.9998e-002	1.4e-002	-9.0888e-007
2961	-1.491e-003	4.9978e-002	1.4e-002	-2.7254e-006
2962	-2.4844e-003	4.9938e-002	1.4e-002	-4.538e-006
2963	-3.4768e-003	4.9879e-002	1.4e-002	-6.3438e-006
2964	-4.4678e-003	4.98e-002	1.4e-002	-8.1404e-006
2965	-5.4571e-003	4.9701e-002	1.4e-002	-9.9249e-006
2966	-6.4441e-003	4.9583e-002	1.4e-002	-1.1695e-005
2967	-7.4287e-003	4.9445e-002	1.4e-002	-1.3448e-005
2968	-8.4103e-003	4.9288e-002	1.4e-002	-1.5181e-005
2969	-9.3886e-003	4.9111e-002	1.4e-002	-1.6891e-005
2970	-1.0363e-002	4.8914e-002	1.4e-002	-1.8577e-005
2971	-1.1334e-002	4.8699e-002	1.4e-002	-2.0235e-005
2972	-1.23e-002	4.8464e-002	1.4e-002	-2.1863e-005
2973	-1.3261e-002	4.8209e-002	1.4e-002	-2.3459e-005
2974	-1.4217e-002	4.7936e-002	1.4e-002	-2.502e-005
2975	-1.5167e-002	4.7644e-002	1.4e-002	-2.6544e-005
2976	-1.6111e-002	4.7333e-002	1.4e-002	-2.8029e-005
2977	-1.7049e-002	4.7003e-002	1.4e-002	-2.9472e-005
2978	-1.798e-002	4.6655e-002	1.4e-002	-3.0872e-005
2979	-1.8904e-002	4.6289e-002	1.4e-002	-3.2225e-005
2980	-1.9821e-002	4.5904e-002	1.4e-002	-3.3531e-005
2981	-2.073e-002	4.55e-002	1.4e-002	-3.4786e-005
2982	-2.163e-002	4.5079e-002	1.4e-002	-3.5989e-005
2983	-2.2522e-002	4.464e-002	1.4e-002	-3.7138e-005
2984	-2.3405e-002	4.4184e-002	1.4e-002	-3.8232e-005
2985	2.4279e-002	4.371e-002	3.6e-002	3.9268e-005
2986	2.4279e-002	4.371e-002	3.5e-002	3.9268e-005
2987	2.4279e-002	4.371e-002	3.4e-002	3.9268e-005
2988	2.4279e-002	4.371e-002	3.3e-002	3.9268e-005
2989	2.4279e-002	4.371e-002	3.2e-002	3.9268e-005
2990	2.4279e-002	4.371e-002	3.1e-002	3.9268e-005
2991	2.4279e-002	4.371e-002	3.e-002	3.9268e-005
2992	2.4279e-002	4.371e-002	2.9e-002	3.9269e-005
2993	2.4279e-002	4.371e-002	2.8e-002	3.9269e-005
2994	2.4279e-002	4.371e-002	2.7e-002	3.9269e-005
2995	2.4279e-002	4.371e-002	2.6e-002	3.9269e-005
2996	2.4279e-002	4.371e-002	2.5e-002	3.9269e-005
2997	2.4279e-002	4.371e-002	2.4e-002	3.9269e-005
2998	2.4279e-002	4.371e-002	2.3e-002	3.9269e-005
2999	2.4279e-002	4.371e-002	2.2e-002	3.9269e-005
3000	2.4279e-002	4.371e-002	2.1e-002	3.9269e-005
3001	2.4279e-002	4.371e-002	2.e-002	3.9269e-005
3002	2.4279e-002	4.3709e-002	1.9e-002	3.9269e-005
3003	2.4279e-002	4.3709e-002	1.8e-002	3.9269e-005
3004	2.4279e-002	4.3709e-002	1.7e-002	3.9269e-005
3005	2.4279e-002	4.3709e-002	1.6e-002	3.9269e-005
3006	2.4279e-002	4.3709e-002	1.5e-002	3.9269e-005
3007	-2.4279e-002	4.371e-002	3.6e-002	-3.9269e-005
3008	-2.3405e-002	4.4184e-002	3.6e-002	-3.8232e-005
3009	-2.2522e-002	4.464e-002	3.6e-002	-3.7139e-005
3010	-2.163e-002	4.5079e-002	3.6e-002	-3.5989e-005
3011	-2.073e-002	4.55e-002	3.6e-002	-3.4786e-005
3012	-1.9821e-002	4.5904e-002	3.6e-002	-3.3531e-005
3013	-1.8904e-002	4.6288e-002	3.6e-002	-3.2225e-005
3014	-1.798e-002	4.6655e-002	3.6e-002	-3.0872e-005
3015	-1.7049e-002	4.7003e-002	3.6e-002	-2.9473e-005
3016	-1.6111e-002	4.7333e-002	3.6e-002	-2.803e-005
3017	-1.5167e-002	4.7644e-002	3.6e-002	-2.6545e-005
3018	-1.4217e-002	4.7936e-002	3.6e-002	-2.5021e-005
3019	-1.3261e-002	4.8209e-002	3.6e-002	-2.3459e-005
3020	-1.23e-002	4.8464e-002	3.6e-002	-2.1863e-005
3021	-1.1334e-002	4.8699e-002	3.6e-002	-2.0235e-005
3022	-1.0363e-002	4.8914e-002	3.6e-002	-1.8577e-005
3023	-9.3888e-003	4.9111e-002	3.6e-002	-1.6891e-005
3024	-8.4104e-003	4.9288e-002	3.6e-002	-1.5181e-005
3025	-7.4289e-003	4.9445e-002	3.6e-002	-1.3448e-005
3026	-6.4442e-003	4.9583e-002	3.6e-002	-1.1695e-005
3027	-5.4572e-003	4.9701e-002	3.6e-002	-9.9252e-006
3028	-4.4679e-003	4.98e-002	3.6e-002	-8.1406e-006
3029	-3.477e-003	4.9879e-002	3.6e-002	-6.3441e-006
3030	-2.4845e-003	4.9938e-002	3.6e-002	-4.5382e-006
3031	-1.4912e-003	4.9978e-002	3.6e-002	-2.7257e-006
3032	-4.9714e-004	4.9998e-002	3.6e-002	-9.0915e-007
3033	4.9691e-004	4.9998e-002	3.6e-002	9.0874e-007
3034	1.491e-003	4.9978e-002	3.6e-002	2.7253e-006
3035	2.4842e-003	4.9938e-002	3.6e-002	4.5378e-006
3036	3.4767e-003	4.9879e-002	3.6e-002	6.3437e-006
3037	4.4676e-003	4.98e-002	3.6e-002	8.1402e-006
3038	5.457e-003	4.9701e-002	3.6e-002	9.9248e-006
3039	6.444e-003	4.9583e-002	3.6e-002	1.1695e-005
3040	7.4286e-003	4.9445e-002	3.6e-002	1.3447e-005
3041	8.4101e-003	4.9288e-002	3.6e-002	1.518e-005
3042	9.3885e-003	4.9111e-002	3.6e-002	1.6891e-005
3043	1.0363e-002	4.8914e-002	3.6e-002	1.8577e-005
3044	1.1334e-002	4.8699e-002	3.6e-002	2.0235e-005
3045	1.2299e-002	4.8464e-002	3.6e-002	2.1863e-005
3046	1.3261e-002	4.8209e-002	3.6e-002	2.3459e-005
3047	1.4216e-002	4.7936e-002	3.6e-002	2.502e-005
3048	1.5167e-002	4.7644e-002	3.6e-002	2.6544e-005
3049	1.6111e-002	4.7333e-002	3.6e-002	2.8029e-005
3050	1.7049e-002	4.7004e-002	3.6e-002	2.9472e-005
3051	1.798e-002	4.6655e-002	3.6e-002	3.0872e-005
3052	1.8904e-002	4.6289e-002	3.6e-002	3.2225e-005
3053	1.9821e-002	4.5904e-002	3.6e-002	3.353e-005
3054	2.073e-002	4.55e-002	3.6e-002	3.4786e-005
3055	2.163e-002	4.5079e-002	3.6e-002	3.5989e-005
3056	2.2522e-002	4.464e-002	3.6e-002	3.7139e-005
3057	2.3405e-002	4.4184e-002	3.6e-002	3.8232e-005
3058	-2.4289e-002	4.3704e-002	2.5003e-002	-3.9282e-005
3059	-2.4279e-002	4.3709e-002	3.5e-002	-3.9269e-005
3060	-2.4279e-002	4.3709e-002	3.4e-002	-3.9269e-005
3061	-2.4279e-002	4.3709e-002	3.3e-002	-3.9269e-005
3062	-2.4279e-002	4.3709e-002	3.2e-002	-3.9269e-005
3063	-2.4279e-002	4.3709e-002	3.1e-002	-3.9269e-005
3064	-2.4279e-002	4.3709e-002	3.e-002	-3.9269e-005
3065	-2.4279e-002	4.3709e-002	2.9e-002	-3.9269e-005
3066	-2.4279e-002	4.3709e-002	2.8e-002	-3.9269e-005
3067	-2.428e-002	4.3709e-002	2.7e-002	-3.9269e-005
3068	-2.428e-002	4.3709e-002	2.6e-002	-3.9271e-005
3069	-2.3405e-002	4.4184e-002	1.5e-002	-3.8232e-005
3070	-2.3405e-002	4.4184e-002	1.6e-002	-3.8233e-005
3071	-2.3416e-002	4.4178e-002	1.8004e-002	-3.8247e-005
3072	-2.3431e-002	4.417e-002	1.9014e-002	-3.8262e-005
3073	-2.3441e-002	4.4164e-002	2.0016e-002	-3.8274e-005
3074	-2.3447e-002	4.4161e-002	2.1016e-002	-3.8278e-005
3075	2.3405e-002	4.4184e-002	1.5e-002	3.8232e-005
3076	2.2522e-002	4.464e-002	1.5e-002	3.7139e-005
3077	2.163e-002	4.5079e-002	1.5e-002	3.5989e-005
3078	2.073e-002	4.55e-002	1.5e-002	3.4786e-005
3079	1.9821e-002	4.5903e-002	1.5e-002	3.3531e-005
3080	1.8904e-002	4.6289e-002	1.5e-002	3.2225e-005
3081	1.798e-002	4.6655e-002	1.5e-002	3.0872e-005
3082	1.7049e-002	4.7003e-002	1.5e-002	2.9473e-005
3083	1.6111e-002	4.7333e-002	1.5e-002	2.8029e-005
3084	1.5167e-002	4.7644e-002	1.5e-002	2.6545e-005
3085	1.4217e-002	4.7936e-002	1.5e-002	2.502e-005
3086	1.3261e-002	4.8209e-002	1.5e-002	2.3459e-005
3087	1.23e-002	4.8464e-002	1.5e-002	2.1863e-005
3088	1.1334e-002	4.8699e-002	1.5e-002	2.0235e-005
3089	1.0363e-002	4.8914e-002	1.5e-002	1.8577e-005
3090	9.3886e-003	4.9111e-002	1.5e-002	1.6891e-005
3091	8.4103e-003	4.9288e-002	1.5e-002	1.5181e-005
3092	7.4287e-003	4.9445e-002	1.5e-002	1.3448e-005
3093	6.4442e-003	4.9583e-002	1.5e-002	1.1695e-005
3094	5.4571e-003	4.9701e-002	1.5e-002	9.9251e-006
3095	4.4678e-003	4.98e-002	1.5e-002	8.1405e-006
3096	3.4768e-003	4.9879e-002	1.5e-002	6.344e-006
3097	2.4844e-003	4.9938e-002	1.5e-002	4.5381e-006
3098	1.4911e-003	4.9978e-002	1.5e-002	2.7256e-006
3099	4.9711e-004	4.9998e-002	1.5e-002	9.0901e-007
3100	-4.9704e-004	4.9998e-002	1.5e-002	-9.0888e-007
3101	-1.491e-003	4.9978e-002	1.5e-002	-2.7254e-006
3102	-2.4844e-003	4.9938e-002	1.5e-002	-4.538e-006
3103	-3.4768e-003	4.9879e-002	1.5e-002	-6.3438e-006
3104	-4.4678e-003	4.98e-002	1.5e-002	-8.1404e-006
3105	-5.457e-003	4.9701e-002	1.5e-002	-9.9249e-006
3106	-6.4441e-003	4.9583e-002	1.5e-002	-1.1695e-005
3107	-7.4287e-003	4.9445e-002	1.5e-002	-1.3448e-005
3108	-8.4103e-003	4.9288e-002	1.5e-002	-1.5181e-005
3109	-9.3886e-003	4.9111e-002	1.5e-002	-1.6891e-005
3110	-1.0363e-002	4.8914e-002	1.5e-002	-1.8577e-005
3111	-1.1334e-002	4.8699e-002	1.5e-002	-2.0235e-005
3112	-1.23e-002	4.8464e-002	1.5e-002	-2.1863e-005
3113	-1.3261e-002	4.8209e-002	1.5e-002	-2.3459e-005
3114	-1.4217e-002	4.7936e-002	1.5e-002	-2.502e-005
3115	-1.5167e-002	4.7644e-002	1.5e-002	-2.6544e-005
3116	-1.6111e-002	4.7333e-002	1.5e-002	-2.8029e-005
3117	-1.7049e-002	4.7004e-002	1.5e-002	-2.9472e-005
3118	-1.798e-002	4.6655e-002	1.5e-002	-3.0872e-005
3119	-1.8904e-002	4.6289e-002	1.5e-002	-3.2225e-005
3120	-1.9821e-002	4.5904e-002	1.5e-002	-3.353e-005
3121	-2.073e-002	4.55e-002	1.5e-002	-3.4786e-005
3122	-2.2522e-002	4.464e-002	1.5e-002	-3.7138e-005
3123	2.3405e-002	4.4184e-002	3.5e-002	3.8232e-005
3124	2.3405e-002	4.4184e-002	3.4e-002	3.8232e-005
3125	2.3405e-002	4.4184e-002	3.3e-002	3.8232e-005
3126	2.3405e-002	4.4184e-002	3.2e-002	3.8232e-005
3127	2.3405e-002	4.4184e-002	3.1e-002	3.8232e-005
3128	2.3405e-002	4.4184e-002	3.e-002	3.8232e-005
3129	2.3405e-002	4.4184e-002	2.9e-002	3.8232e-005
3130	2.3405e-002	4.4184e-002	2.8e-002	3.8232e-005
3131	2.3405e-002	4.4184e-002	2.7e-002	3.8232e-005
3132	2.3405e-002	4.4184e-002	2.6e-002	3.8232e-005
3133	2.3405e-002	4.4184e-002	2.5e-002	3.8232e-005
3134	2.3405e-002	4.4184e-002	2.4e-002	3.8232e-005
3135	2.3405e-002	4.4184e-002	2.3e-002	3.8232e-005
3136	2.3405e-002	4.4184e-002	2.2e-002	3.8232e-005
3137	2.3405e-002	4.4184e-002	2.1e-002	3.8232e-005
3138	2.3405e-002	4.4184e-002	2.e-002	3.8232e-005
3139	2.3405e-002	4.4184e-002	1.9e-002	3.8232e-005
3140	2.3405e-002	4.4184e-002	1.8e-002	3.8232e-005
3141	2.3405e-002	4.4184e-002	1.7e-002	3.8232e-005
3142	2.3406e-002	4.4183e-002	1.6e-002	3.8232e-005
3143	-2.4324e-002	4.3684e-002	2.3019e-002	-3.9318e-005
3144	-2.4332e-002	4.368e-002	2.2025e-002	-3.933e-005
3145	-2.3405e-002	4.4184e-002	3.5e-002	-3.8232e-005
3146	-2.2522e-002	4.464e-002	3.5e-002	-3.7139e-005
3147	-2.163e-002	4.5079e-002	3.5e-002	-3.5989e-005
3148	-2.073e-002	4.55e-002	3.5e-002	-3.4786e-005
3149	-1.9821e-002	4.5904e-002	3.5e-002	-3.3531e-005
3150	-1.8904e-002	4.6288e-002	3.5e-002	-3.2225e-005
3151	-1.798e-002	4.6655e-002	3.5e-002	-3.0872e-005
3152	-1.7049e-002	4.7003e-002	3.5e-002	-2.9473e-005
3153	-1.6111e-002	4.7333e-002	3.5e-002	-2.803e-005
3154	-1.5167e-002	4.7644e-002	3.5e-002	-2.6545e-005
3155	-1.4217e-002	4.7936e-002	3.5e-002	-2.5021e-005
3156	-1.3261e-002	4.8209e-002	3.5e-002	-2.3459e-005
3157	-1.23e-002	4.8464e-002	3.5e-002	-2.1863e-005
3158	-1.1334e-002	4.8699e-002	3.5e-002	-2.0235e-005
3159	-1.0363e-002	4.8914e-002	3.5e-002	-1.8577e-005
3160	-9.3888e-003	4.9111e-002	3.5e-002	-1.6891e-005
3161	-8.4104e-003	4.9288e-002	3.5e-002	-1.5181e-005
3162	-7.4289e-003	4.9445e-002	3.5e-002	-1.3448e-005
3163	-6.4442e-003	4.9583e-002	3.5e-002	-1.1695e-005
3164	-5.4572e-003	4.9701e-002	3.5e-002	-9.9252e-006
3165	-4.4679e-003	4.98e-002	3.5e-002	-8.1407e-006
3166	-3.477e-003	4.9879e-002	3.5e-002	-6.3441e-006
3167	-2.4845e-003	4.9938e-002	3.5e-002	-4.5383e-006
3168	-1.4912e-003	4.9978e-002	3.5e-002	-2.7257e-006
3169	-4.9714e-004	4.9998e-002	3.5e-002	-9.0917e-007
3170	4.9692e-004	4.9998e-002	3.5e-002	9.0872e-007
3171	1.491e-003	4.9978e-002	3.5e-002	2.7253e-006
3172	2.4843e-003	4.9938e-002	3.5e-002	4.5378e-006
3173	3.4767e-003	4.9879e-002	3.5e-002	6.3437e-006
3174	4.4677e-003	4.98e-002	3.5e-002	8.1402e-006
3175	5.457e-003	4.9701e-002	3.5e-002	9.9248e-006
3176	6.444e-003	4.9583e-002	3.5e-002	1.1695e-005
3177	7.4286e-003	4.9445e-002	3.5e-002	1.3447e-005
3178	8.4102e-003	4.9288e-002	3.5e-002	1.518e-005
3179	9.3885e-003	4.9111e-002	3.5e-002	1.6891e-005
3180	1.0363e-002	4.8914e-002	3.5e-002	1.8577e-005
3181	1.1334e-002	4.8699e-002	3.5e-002	2.0235e-005
3182	1.2299e-002	4.8464e-002	3.5e-002	2.1863e-005
3183	1.3261e-002	4.8209e-002	3.5e-002	2.3459e-005
3184	1.4216e-002	4.7936e-002	3.5e-002	2.502e-005
3185	1.5167e-002	4.7644e-002	3.5e-002	2.6544e-005
3186	1.6111e-002	4.7333e-002	3.5e-002	2.8029e-005
3187	1.7049e-002	4.7004e-002	3.5e-002	2.9472e-005
3188	1.798e-002	4.6655e-002	3.5e-002	3.0872e-005
3189	1.8904e-002	4.6289e-002	3.5e-002	3.2225e-005
3190	1.9821e-002	4.5904e-002	3.5e-002	3.353e-005
3191	2.073e-002	4.55e-002	3.5e-002	3.4786e-005
3192	2.163e-002	4.5079e-002	3.5e-002	3.5989e-005
3193	2.2522e-002	4.464e-002	3.5e-002	3.7139e-005
3194	-2.3405e-002	4.4184e-002	3.4e-002	-3.8232e-005
3195	-2.3405e-002	4.4184e-002	3.3e-002	-3.8232e-005
3196	-2.3405e-002	4.4184e-002	3.2e-002	-3.8232e-005
3197	-2.3405e-002	4.4184e-002	3.1e-002	-3.8232e-005
3198	-2.3405e-002	4.4184e-002	3.e-002	-3.8232e-005
3199	-2.3405e-002	4.4184e-002	2.9e-002	-3.8232e-005
3200	-2.3405e-002	4.4184e-002	2.8e-002	-3.8232e-005
3201	-2.3405e-002	4.4184e-002	2.7e-002	-3.8232e-005
3202	-2.3405e-002	4.4184e-002	2.6e-002	-3.8233e-005
3203	-2.3405e-002	4.4184e-002	2.5e-002	-3.8238e-005
3204	-2.2522e-002	4.464e-002	1.7e-002	-3.7139e-005
3205	-2.2522e-002	4.464e-002	1.8e-002	-3.7144e-005
3206	-2.2532e-002	4.4636e-002	1.9003e-002	-3.7151e-005
3207	-2.2535e-002	4.4634e-002	2.0005e-002	-3.7159e-005
3208	-2.2541e-002	4.4631e-002	2.1005e-002	-3.7162e-005
3209	2.2522e-002	4.464e-002	1.6e-002	3.7139e-005
3210	2.163e-002	4.5079e-002	1.6e-002	3.5989e-005
3211	2.073e-002	4.55e-002	1.6e-002	3.4786e-005
3212	1.9821e-002	4.5903e-002	1.6e-002	3.3531e-005
3213	1.8904e-002	4.6289e-002	1.6e-002	3.2225e-005
3214	1.798e-002	4.6655e-002	1.6e-002	3.0872e-005
3215	1.7049e-002	4.7003e-002	1.6e-002	2.9473e-005
3216	1.6111e-002	4.7333e-002	1.6e-002	2.8029e-005
3217	1.5167e-002	4.7644e-002	1.6e-002	2.6545e-005
3218	1.4217e-002	4.7936e-002	1.6e-002	2.502e-005
3219	1.3261e-002	4.8209e-002	1.6e-002	2.3459e-005
3220	1.23e-002	4.8464e-002	1.6e-002	2.1863e-005
3221	1.1334e-002	4.8699e-002	1.6e-002	2.0235e-005
3222	1.0363e-002	4.8914e-002	1.6e-002	1.8577e-005
3223	9.3886e-003	4.9111e-002	1.6e-002	1.6891e-005
3224	8.4104e-003	4.9288e-002	1.6e-002	1.5181e-005
3225	7.4287e-003	4.9445e-002	1.6e-002	1.3448e-005
3226	6.4442e-003	4.9583e-002	1.6e-002	1.1695e-005
3227	5.4571e-003	4.9701e-002	1.6e-002	9.9251e-006
3228	4.4679e-003	4.98e-002	1.6e-002	8.1405e-006
3229	3.4768e-003	4.9879e-002	1.6e-002	6.344e-006
3230	2.4845e-003	4.9938e-002	1.6e-002	4.5381e-006
3231	1.4911e-003	4.9978e-002	1.6e-002	2.7256e-006
3232	4.9714e-004	4.9998e-002	1.6e-002	9.0903e-007
3233	-4.9704e-004	4.9998e-002	1.6e-002	-9.0886e-007
3234	-1.491e-003	4.9978e-002	1.6e-002	-2.7254e-006
3235	-2.4844e-003	4.9938e-002	1.6e-002	-4.538e-006
3236	-3.4767e-003	4.9879e-002	1.6e-002	-6.3438e-006
3237	-4.4678e-003	4.98e-002	1.6e-002	-8.1404e-006
3238	-5.457e-003	4.9701e-002	1.6e-002	-9.9249e-006
3239	-6.4441e-003	4.9583e-002	1.6e-002	-1.1695e-005
3240	-7.4286e-003	4.9445e-002	1.6e-002	-1.3448e-005
3241	-8.4103e-003	4.9288e-002	1.6e-002	-1.518e-005
3242	-9.3885e-003	4.9111e-002	1.6e-002	-1.6891e-005
3243	-1.0363e-002	4.8914e-002	1.6e-002	-1.8577e-005
3244	-1.1334e-002	4.8699e-002	1.6e-002	-2.0235e-005
3245	-1.23e-002	4.8464e-002	1.6e-002	-2.1863e-005
3246	-1.3261e-002	4.8209e-002	1.6e-002	-2.3459e-005
3247	-1.4217e-002	4.7936e-002	1.6e-002	-2.502e-005
3248	-1.5167e-002	4.7644e-002	1.6e-002	-2.6544e-005
3249	-1.6111e-002	4.7333e-002	1.6e-002	-2.8029e-005
3250	-1.7049e-002	4.7004e-002	1.6e-002	-2.9472e-005
3251	-1.798e-002	4.6655e-002	1.6e-002	-3.0872e-005
3252	-1.8904e-002	4.6289e-002	1.6e-002	-3.2225e-005
3253	-1.9821e-002	4.5904e-002	1.6e-002	-3.353e-005
3254	-2.073e-002	4.55e-002	1.6e-002	-3.4786e-005
3255	-2.163e-002	4.5079e-002	1.6e-002	-3.5989e-005
3256	2.2522e-002	4.464e-002	3.4e-002	3.7139e-005
3257	2.2522e-002	4.464e-002	3.3e-002	3.7139e-005
3258	2.2522e-002	4.464e-002	3.2e-002	3.7139e-005
3259	2.2522e-002	4.464e-002	3.1e-002	3.7139e-005
3260	2.2522e-002	4.464e-002	3.e-002	3.7139e-005
3261	2.2522e-002	4.464e-002	2.9e-002	3.7139e-005
3262	2.2522e-002	4.464e-002	2.8e-002	3.7139e-005
3263	2.2522e-002	4.464e-002	2.7e-002	3.7139e-005
3264	2.2522e-002	4.464e-002	2.6e-002	3.7139e-005
3265	2.2522e-002	4.464e-002	2.4e-002	3.7139e-005
3266	2.2522e-002	4.464e-002	2.3e-002	3.7139e-005
3267	2.2522e-002	4.464e-002	2.2e-002	3.7139e-005
3268	2.2522e-002	4.464e-002	2.1e-002	3.7139e-005
3269	2.2522e-002	4.464e-002	2.e-002	3.7139e-005
3270	2.2522e-002	4.464e-002	1.9e-002	3.7139e-005
3271	2.2522e-002	4.464e-002	1.8e-002	3.7139e-005
3272	-2.2522e-002	4.464e-002	3.4e-002	-3.7139e-005
3273	-2.163e-002	4.5079e-002	3.4e-002	-3.5989e-005
3274	-2.073e-002	4.55e-002	3.4e-002	-3.4786e-005
3275	-1.9821e-002	4.5904e-002	3.4e-002	-3.3531e-005
3276	-1.8904e-002	4.6288e-002	3.4e-002	-3.2225e-005
3277	-1.798e-002	4.6655e-002	3.4e-002	-3.0872e-005
3278	-1.7049e-002	4.7003e-002	3.4e-002	-2.9473e-005
3279	-1.6111e-002	4.7333e-002	3.4e-002	-2.803e-005
3280	-1.5167e-002	4.7644e-002	3.4e-002	-2.6545e-005
3281	-1.4217e-002	4.7936e-002	3.4e-002	-2.5021e-005
3282	-1.3261e-002	4.8209e-002	3.4e-002	-2.3459e-005
3283	-1.23e-002	4.8464e-002	3.4e-002	-2.1863e-005
3284	-1.1334e-002	4.8699e-002	3.4e-002	-2.0235e-005
3285	-1.0363e-002	4.8914e-002	3.4e-002	-1.8577e-005
3286	-9.3888e-003	4.9111e-002	3.4e-002	-1.6891e-005
3287	-8.4104e-003	4.9288e-002	3.4e-002	-1.5181e-005
3288	-7.4289e-003	4.9445e-002	3.4e-002	-1.3448e-005
3289	-6.4442e-003	4.9583e-002	3.4e-002	-1.1695e-005
3290	-5.4573e-003	4.9701e-002	3.4e-002	-9.9253e-006
3291	-4.4679e-003	4.98e-002	3.4e-002	-8.1407e-006
3292	-3.477e-003	4.9879e-002	3.4e-002	-6.3442e-006
3293	-2.4845e-003	4.9938e-002	3.4e-002	-4.5383e-006
3294	-1.4912e-003	4.9978e-002	3.4e-002	-2.7257e-006
3295	-4.9717e-004	4.9998e-002	3.4e-002	-9.092e-007
3296	4.9687e-004	4.9998e-002	3.4e-002	9.0869e-007
3297	1.491e-003	4.9978e-002	3.4e-002	2.7252e-006
3298	2.4842e-003	4.9938e-002	3.4e-002	4.5378e-006
3299	3.4767e-003	4.9879e-002	3.4e-002	6.3437e-006
3300	4.4676e-003	4.98e-002	3.4e-002	8.1402e-006
3301	5.457e-003	4.9701e-002	3.4e-002	9.9248e-006
3302	6.444e-003	4.9583e-002	3.4e-002	1.1695e-005
3303	7.4286e-003	4.9445e-002	3.4e-002	1.3447e-005
3304	8.4101e-003	4.9288e-002	3.4e-002	1.518e-005
3305	9.3885e-003	4.9111e-002	3.4e-002	1.6891e-005
3306	1.0363e-002	4.8914e-002	3.4e-002	1.8576e-005
3307	1.1334e-002	4.8699e-002	3.4e-002	2.0235e-005
3308	1.2299e-002	4.8464e-002	3.4e-002	2.1863e-005
3309	1.3261e-002	4.8209e-002	3.4e-002	2.3459e-005
3310	1.4216e-002	4.7936e-002	3.4e-002	2.502e-005
3311	1.5167e-002	4.7644e-002	3.4e-002	2.6544e-005
3312	1.6111e-002	4.7333e-002	3.4e-002	2.8029e-005
3313	1.7049e-002	4.7004e-002	3.4e-002	2.9472e-005
3314	1.798e-002	4.6655e-002	3.4e-002	3.0872e-005
3315	1.8904e-002	4.6289e-002	3.4e-002	3.2225e-005
3316	1.9821e-002	4.5904e-002	3.4e-002	3.353e-005
3317	2.073e-002	4.55e-002	3.4e-002	3.4786e-005
3318	2.163e-002	4.5079e-002	3.4e-002	3.5989e-005
3319	-2.3417e-002	4.4177e-002	2.3998e-002	-3.8249e-005
3320	-2.343e-002	4.417e-002	2.3001e-002	-3.8263e-005
3321	-2.3441e-002	4.4165e-002	2.2009e-002	-3.8274e-005
3322	-2.2522e-002	4.464e-002	3.3e-002	-3.7139e-005
3323	-2.2522e-002	4.464e-002	3.2e-002	-3.7139e-005
3324	-2.2523e-002	4.464e-002	3.1e-002	-3.7139e-005
3325	-2.2523e-002	4.464e-002	3.e-002	-3.7139e-005
3326	-2.2523e-002	4.464e-002	2.9e-002	-3.7139e-005
3327	-2.2523e-002	4.464e-002	2.8e-002	-3.7139e-005
3328	-2.2523e-002	4.464e-002	2.7e-002	-3.7139e-005
3329	-2.2523e-002	4.464e-002	2.6e-002	-3.7139e-005
3330	-2.2523e-002	4.464e-002	2.5e-002	-3.714e-005
3331	-2.2523e-002	4.464e-002	2.4e-002	-3.7145e-005
3332	-2.163e-002	4.5079e-002	1.7e-002	-3.5989e-005
3333	-2.163e-002	4.5079e-002	1.8e-002	-3.599e-005
3334	-2.163e-002	4.5079e-002	1.9e-002	-3.5992e-005
3335	-2.163e-002	4.5079e-002	2.e-002	-3.5995e-005
3336	-2.1638e-002	4.5075e-002	2.1001e-002	-3.5997e-005
3337	2.163e-002	4.5079e-002	1.7e-002	3.5989e-005
3338	2.073e-002	4.55e-002	1.7e-002	3.4786e-005
3339	1.8904e-002	4.6289e-002	1.7e-002	3.2225e-005
3340	1.798e-002	4.6655e-002	1.7e-002	3.0872e-005
3341	1.7049e-002	4.7003e-002	1.7e-002	2.9473e-005
3342	1.6111e-002	4.7333e-002	1.7e-002	2.8029e-005
3343	1.5167e-002	4.7644e-002	1.7e-002	2.6545e-005
3344	1.4217e-002	4.7936e-002	1.7e-002	2.502e-005
3345	1.3261e-002	4.8209e-002	1.7e-002	2.3459e-005
3346	1.23e-002	4.8464e-002	1.7e-002	2.1863e-005
3347	1.1334e-002	4.8699e-002	1.7e-002	2.0235e-005
3348	1.0363e-002	4.8914e-002	1.7e-002	1.8577e-005
3349	9.3886e-003	4.9111e-002	1.7e-002	1.6891e-005
3350	8.4104e-003	4.9288e-002	1.7e-002	1.5181e-005
3351	7.4287e-003	4.9445e-002	1.7e-002	1.3448e-005
3352	6.4442e-003	4.9583e-002	1.7e-002	1.1695e-005
3353	5.4571e-003	4.9701e-002	1.7e-002	9.9251e-006
3354	4.4679e-003	4.98e-002	1.7e-002	8.1406e-006
3355	3.4768e-003	4.9879e-002	1.7e-002	6.344e-006
3356	2.4845e-003	4.9938e-002	1.7e-002	4.5381e-006
3357	1.4911e-003	4.9978e-002	1.7e-002	2.7256e-006
3358	4.9715e-004	4.9998e-002	1.7e-002	9.0905e-007
3359	-4.9704e-004	4.9998e-002	1.7e-002	-9.0884e-007
3360	-1.491e-003	4.9978e-002	1.7e-002	-2.7254e-006
3361	-2.4844e-003	4.9938e-002	1.7e-002	-4.5379e-006
3362	-3.4767e-003	4.9879e-002	1.7e-002	-6.3438e-006
3363	-4.4678e-003	4.98e-002	1.7e-002	-8.1403e-006
3364	-5.457e-003	4.9701e-002	1.7e-002	-9.9249e-006
3365	-6.4441e-003	4.9583e-002	1.7e-002	-1.1695e-005
3366	-7.4286e-003	4.9445e-002	1.7e-002	-1.3448e-005
3367	-8.4103e-003	4.9288e-002	1.7e-002	-1.518e-005
3368	-9.3885e-003	4.9111e-002	1.7e-002	-1.6891e-005
3369	-1.0363e-002	4.8914e-002	1.7e-002	-1.8577e-005
3370	-1.1334e-002	4.8699e-002	1.7e-002	-2.0235e-005
3371	-1.23e-002	4.8464e-002	1.7e-002	-2.1863e-005
3372	-1.3261e-002	4.8209e-002	1.7e-002	-2.3459e-005
3373	-1.4217e-002	4.7936e-002	1.7e-002	-2.502e-005
3374	-1.5167e-002	4.7644e-002	1.7e-002	-2.6544e-005
3375	-1.6111e-002	4.7333e-002	1.7e-002	-2.8029e-005
3376	-1.7049e-002	4.7004e-002	1.7e-002	-2.9472e-005
3377	-1.798e-002	4.6655e-002	1.7e-002	-3.0872e-005
3378	-1.8904e-002	4.6289e-002	1.7e-002	-3.2225e-005
3379	-2.073e-002	4.55e-002	1.7e-002	-3.4786e-005
3380	2.163e-002	4.5079e-002	3.3e-002	3.5989e-005
3381	2.163e-002	4.5079e-002	3.2e-002	3.5989e-005
3382	2.163e-002	4.5079e-002	3.1e-002	3.5989e-005
3383	2.163e-002	4.5079e-002	3.e-002	3.5989e-005
3384	2.163e-002	4.5079e-002	2.9e-002	3.5989e-005
3385	2.163e-002	4.5079e-002	2.8e-002	3.5989e-005
3386	2.163e-002	4.5079e-002	2.7e-002	3.5989e-005
3387	2.163e-002	4.5079e-002	2.6e-002	3.5989e-005
3388	2.163e-002	4.5079e-002	2.5e-002	3.5989e-005
3389	2.163e-002	4.5079e-002	2.4e-002	3.5989e-005
3390	2.163e-002	4.5079e-002	2.3e-002	3.5989e-005
3391	2.163e-002	4.5079e-002	2.2e-002	3.5989e-005
3392	2.1631e-002	4.5079e-002	2.e-002	3.5989e-005
3393	2.1631e-002	4.5079e-002	1.9e-002	3.5989e-005
3394	2.1631e-002	4.5079e-002	1.8e-002	3.5989e-005
3395	-2.2538e-002	4.4632e-002	2.2001e-002	-3.716e-005
3396	-2.2534e-002	4.4634e-002	2.3e-002	-3.7152e-005
3397	-2.163e-002	4.5079e-002	3.3e-002	-3.5989e-005
3398	-2.073e-002	4.55e-002	3.3e-002	-3.4786e-005
3399	-1.9821e-002	4.5903e-002	3.3e-002	-3.3531e-005
3400	-1.8904e-002	4.6288e-002	3.3e-002	-3.2225e-005
3401	-1.798e-002	4.6655e-002	3.3e-002	-3.0872e-005
3402	-1.7049e-002	4.7003e-002	3.3e-002	-2.9473e-005
3403	-1.6111e-002	4.7333e-002	3.3e-002	-2.803e-005
3404	-1.5167e-002	4.7644e-002	3.3e-002	-2.6545e-005
3405	-1.4217e-002	4.7936e-002	3.3e-002	-2.5021e-005
3406	-1.3261e-002	4.8209e-002	3.3e-002	-2.3459e-005
3407	-1.23e-002	4.8464e-002	3.3e-002	-2.1863e-005
3408	-1.1334e-002	4.8699e-002	3.3e-002	-2.0235e-005
3409	-1.0363e-002	4.8914e-002	3.3e-002	-1.8577e-005
3410	-9.3888e-003	4.9111e-002	3.3e-002	-1.6891e-005
3411	-8.4104e-003	4.9288e-002	3.3e-002	-1.5181e-005
3412	-7.4289e-003	4.9445e-002	3.3e-002	-1.3448e-005
3413	-6.4442e-003	4.9583e-002	3.3e-002	-1.1695e-005
3414	-5.4573e-003	4.9701e-002	3.3e-002	-9.9253e-006
3415	-4.4679e-003	4.98e-002	3.3e-002	-8.1407e-006
3416	-3.477e-003	4.9879e-002	3.3e-002	-6.3442e-006
3417	-2.4845e-003	4.9938e-002	3.3e-002	-4.5383e-006
3418	-1.4912e-003	4.9978e-002	3.3e-002	-2.7258e-006
3419	-4.9717e-004	4.9998e-002	3.3e-002	-9.0921e-007
3420	4.9688e-004	4.9998e-002	3.3e-002	9.0868e-007
3421	1.491e-003	4.9978e-002	3.3e-002	2.7252e-006
3422	2.4842e-003	4.9938e-002	3.3e-002	4.5378e-006
3423	3.4767e-003	4.9879e-002	3.3e-002	6.3436e-006
3424	4.4676e-003	4.98e-002	3.3e-002	8.1402e-006
3425	5.457e-003	4.9701e-002	3.3e-002	9.9247e-006
3426	6.444e-003	4.9583e-002	3.3e-002	1.1695e-005
3427	7.4286e-003	4.9445e-002	3.3e-002	1.3447e-005
3428	8.4101e-003	4.9288e-002	3.3e-002	1.518e-005
3429	9.3885e-003	4.9111e-002	3.3e-002	1.6891e-005
3430	1.0363e-002	4.8914e-002	3.3e-002	1.8576e-005
3431	1.1334e-002	4.8699e-002	3.3e-002	2.0235e-005
3432	1.2299e-002	4.8464e-002	3.3e-002	2.1863e-005
3433	1.3261e-002	4.8209e-002	3.3e-002	2.3459e-005
3434	1.4216e-002	4.7936e-002	3.3e-002	2.502e-005
3435	1.5167e-002	4.7644e-002	3.3e-002	2.6544e-005
3436	1.6111e-002	4.7333e-002	3.3e-002	2.8029e-005
3437	1.7049e-002	4.7004e-002	3.3e-002	2.9472e-005
3438	1.798e-002	4.6655e-002	3.3e-002	3.0872e-005
3439	1.8904e-002	4.6289e-002	3.3e-002	3.2225e-005
3440	1.9821e-002	4.5904e-002	3.3e-002	3.353e-005
3441	2.073e-002	4.55e-002	3.3e-002	3.4786e-005
3442	-2.163e-002	4.5079e-002	3.2e-002	-3.5989e-005
3443	-2.163e-002	4.5079e-002	3.1e-002	-3.5989e-005
3444	-2.163e-002	4.5079e-002	3.e-002	-3.5989e-005
3445	-2.163e-002	4.5079e-002	2.8e-002	-3.5989e-005
3446	-2.163e-002	4.5079e-002	2.7e-002	-3.5989e-005
3447	-2.163e-002	4.5079e-002	2.6e-002	-3.5989e-005
3448	2.073e-002	4.55e-002	1.8e-002	3.4786e-005
3449	1.9821e-002	4.5903e-002	1.8e-002	3.3531e-005
3450	1.8904e-002	4.6289e-002	1.8e-002	3.2225e-005
3451	1.798e-002	4.6655e-002	1.8e-002	3.0872e-005
3452	1.7049e-002	4.7003e-002	1.8e-002	2.9473e-005
3453	1.5167e-002	4.7644e-002	1.8e-002	2.6545e-005
3454	1.4217e-002	4.7936e-002	1.8e-002	2.502e-005
3455	1.3261e-002	4.8209e-002	1.8e-002	2.3459e-005
3456	1.23e-002	4.8464e-002	1.8e-002	2.1863e-005
3457	1.1334e-002	4.8699e-002	1.8e-002	2.0235e-005
3458	1.0363e-002	4.8914e-002	1.8e-002	1.8577e-005
3459	9.3887e-003	4.9111e-002	1.8e-002	1.6891e-005
3460	8.4104e-003	4.9288e-002	1.8e-002	1.5181e-005
3461	7.4288e-003	4.9445e-002	1.8e-002	1.3448e-005
3462	6.4442e-003	4.9583e-002	1.8e-002	1.1695e-005
3463	5.4571e-003	4.9701e-002	1.8e-002	9.9251e-006
3464	4.4679e-003	4.98e-002	1.8e-002	8.1406e-006
3465	3.4769e-003	4.9879e-002	1.8e-002	6.344e-006
3466	2.4845e-003	4.9938e-002	1.8e-002	4.5382e-006
3467	1.4911e-003	4.9978e-002	1.8e-002	2.7256e-006
3468	4.9716e-004	4.9998e-002	1.8e-002	9.0907e-007
3469	-4.9701e-004	4.9998e-002	1.8e-002	-9.0882e-007
3470	-1.491e-003	4.9978e-002	1.8e-002	-2.7254e-006
3471	-2.4843e-003	4.9938e-002	1.8e-002	-4.5379e-006
3472	-3.4767e-003	4.9879e-002	1.8e-002	-6.3438e-006
3473	-4.4677e-003	4.98e-002	1.8e-002	-8.1403e-006
3474	-5.457e-003	4.9701e-002	1.8e-002	-9.9249e-006
3475	-6.4441e-003	4.9583e-002	1.8e-002	-1.1695e-005
3476	-7.4286e-003	4.9445e-002	1.8e-002	-1.3448e-005
3477	-8.4102e-003	4.9288e-002	1.8e-002	-1.518e-005
3478	-9.3885e-003	4.9111e-002	1.8e-002	-1.6891e-005
3479	-1.0363e-002	4.8914e-002	1.8e-002	-1.8577e-005
3480	-1.1334e-002	4.8699e-002	1.8e-002	-2.0235e-005
3481	-1.23e-002	4.8464e-002	1.8e-002	-2.1863e-005
3482	-1.3261e-002	4.8209e-002	1.8e-002	-2.3459e-005
3483	-1.4217e-002	4.7936e-002	1.8e-002	-2.502e-005
3484	-1.5167e-002	4.7644e-002	1.8e-002	-2.6544e-005
3485	-1.6111e-002	4.7333e-002	1.8e-002	-2.8029e-005
3486	-1.7049e-002	4.7004e-002	1.8e-002	-2.9472e-005
3487	-1.798e-002	4.6655e-002	1.8e-002	-3.0872e-005
3488	-1.9821e-002	4.5904e-002	1.8e-002	-3.3531e-005
3489	-2.073e-002	4.55e-002	1.8e-002	-3.4786e-005
3490	-2.073e-002	4.55e-002	1.9e-002	-3.4786e-005
3491	-2.073e-002	4.55e-002	2.e-002	-3.4787e-005
3492	-2.073e-002	4.55e-002	2.1e-002	-3.4787e-005
3493	-2.163e-002	4.5079e-002	2.2e-002	-3.5996e-005
3494	-2.163e-002	4.5079e-002	2.3e-002	-3.5992e-005
3495	-2.163e-002	4.5079e-002	2.4e-002	-3.599e-005
3496	2.073e-002	4.55e-002	3.2e-002	3.4786e-005
3497	2.073e-002	4.55e-002	3.1e-002	3.4786e-005
3498	2.073e-002	4.55e-002	3.e-002	3.4786e-005
3499	2.073e-002	4.55e-002	2.8e-002	3.4786e-005
3500	2.073e-002	4.55e-002	2.6e-002	3.4786e-005
3501	2.073e-002	4.55e-002	2.5e-002	3.4786e-005
3502	2.073e-002	4.55e-002	2.4e-002	3.4786e-005
3503	2.0729e-002	4.55e-002	2.3e-002	3.4786e-005
3504	2.0729e-002	4.55e-002	2.2e-002	3.4786e-005
3505	2.0729e-002	4.55e-002	2.1e-002	3.4786e-005
3506	2.0729e-002	4.55e-002	2.e-002	3.4786e-005
3507	2.0729e-002	4.55e-002	1.9e-002	3.4786e-005
3508	-1.9821e-002	4.5903e-002	3.2e-002	-3.3531e-005
3509	-1.8904e-002	4.6288e-002	3.2e-002	-3.2225e-005
3510	-1.798e-002	4.6655e-002	3.2e-002	-3.0872e-005
3511	-1.7049e-002	4.7003e-002	3.2e-002	-2.9473e-005
3512	-1.6111e-002	4.7333e-002	3.2e-002	-2.803e-005
3513	-1.5167e-002	4.7644e-002	3.2e-002	-2.6545e-005
3514	-1.4217e-002	4.7936e-002	3.2e-002	-2.5021e-005
3515	-1.3261e-002	4.8209e-002	3.2e-002	-2.3459e-005
3516	-1.23e-002	4.8464e-002	3.2e-002	-2.1863e-005
3517	-1.1334e-002	4.8699e-002	3.2e-002	-2.0235e-005
3518	-1.0363e-002	4.8914e-002	3.2e-002	-1.8577e-005
3519	-9.3888e-003	4.9111e-002	3.2e-002	-1.6891e-005
3520	-8.4104e-003	4.9288e-002	3.2e-002	-1.5181e-005
3521	-7.4289e-003	4.9445e-002	3.2e-002	-1.3448e-005
3522	-6.4442e-003	4.9583e-002	3.2e-002	-1.1695e-005
3523	-5.4573e-003	4.9701e-002	3.2e-002	-9.9253e-006
3524	-4.4679e-003	4.98e-002	3.2e-002	-8.1407e-006
3525	-3.477e-003	4.9879e-002	3.2e-002	-6.3442e-006
3526	-2.4845e-003	4.9938e-002	3.2e-002	-4.5383e-006
3527	-1.4912e-003	4.9978e-002	3.2e-002	-2.7258e-006
3528	-4.9716e-004	4.9998e-002	3.2e-002	-9.0921e-007
3529	4.9688e-004	4.9998e-002	3.2e-002	9.0868e-007
3530	1.491e-003	4.9978e-002	3.2e-002	2.7252e-006
3531	2.4842e-003	4.9938e-002	3.2e-002	4.5378e-006
3532	3.4767e-003	4.9879e-002	3.2e-002	6.3436e-006
3533	4.4676e-003	4.98e-002	3.2e-002	8.1402e-006
3534	5.457e-003	4.9701e-002	3.2e-002	9.9247e-006
3535	6.444e-003	4.9583e-002	3.2e-002	1.1695e-005
3536	7.4286e-003	4.9445e-002	3.2e-002	1.3447e-005
3537	8.4101e-003	4.9288e-002	3.2e-002	1.518e-005
3538	9.3885e-003	4.9111e-002	3.2e-002	1.6891e-005
3539	1.0363e-002	4.8914e-002	3.2e-002	1.8576e-005
3540	1.1334e-002	4.8699e-002	3.2e-002	2.0235e-005
3541	1.2299e-002	4.8464e-002	3.2e-002	2.1863e-005
3542	1.3261e-002	4.8209e-002	3.2e-002	2.3459e-005
3543	1.4216e-002	4.7936e-002	3.2e-002	2.502e-005
3544	1.5167e-002	4.7644e-002	3.2e-002	2.6544e-005
3545	1.6111e-002	4.7333e-002	3.2e-002	2.8029e-005
3546	1.7049e-002	4.7004e-002	3.2e-002	2.9472e-005
3547	1.798e-002	4.6655e-002	3.2e-002	3.0872e-005
3548	1.8904e-002	4.6289e-002	3.2e-002	3.2225e-005
3549	1.9821e-002	4.5904e-002	3.2e-002	3.353e-005
3550	-2.073e-002	4.55e-002	3.1e-002	-3.4786e-005
3551	-2.073e-002	4.55e-002	3.e-002	-3.4786e-005
3552	-2.073e-002	4.55e-002	2.9e-002	-3.4786e-005
3553	-2.073e-002	4.55e-002	2.8e-002	-3.4786e-005
3554	-2.073e-002	4.55e-002	2.7e-002	-3.4786e-005
3555	-2.073e-002	4.55e-002	2.6e-002	-3.4786e-005
3556	-2.073e-002	4.55e-002	2.5e-002	-3.4786e-005
3557	-2.073e-002	4.55e-002	2.4e-002	-3.4786e-005
3558	-1.9821e-002	4.5904e-002	1.9e-002	-3.3531e-005
3559	-1.9821e-002	4.5904e-002	2.e-002	-3.3531e-005
3560	-1.9821e-002	4.5904e-002	2.1e-002	-3.3531e-005
3561	-2.073e-002	4.55e-002	2.2e-002	-3.4787e-005
3562	-2.073e-002	4.55e-002	2.3e-002	-3.4786e-005
3563	1.9821e-002	4.5903e-002	1.9e-002	3.3531e-005
3564	1.8904e-002	4.6289e-002	1.9e-002	3.2225e-005
3565	1.7049e-002	4.7003e-002	1.9e-002	2.9473e-005
3566	1.6111e-002	4.7333e-002	1.9e-002	2.8029e-005
3567	1.5167e-002	4.7644e-002	1.9e-002	2.6545e-005
3568	1.4217e-002	4.7936e-002	1.9e-002	2.5021e-005
3569	1.3261e-002	4.8209e-002	1.9e-002	2.3459e-005
3570	1.23e-002	4.8464e-002	1.9e-002	2.1863e-005
3571	1.1334e-002	4.8699e-002	1.9e-002	2.0235e-005
3572	1.0363e-002	4.8914e-002	1.9e-002	1.8577e-005
3573	9.3887e-003	4.9111e-002	1.9e-002	1.6891e-005
3574	8.4104e-003	4.9288e-002	1.9e-002	1.5181e-005
3575	7.4288e-003	4.9445e-002	1.9e-002	1.3448e-005
3576	6.4442e-003	4.9583e-002	1.9e-002	1.1695e-005
3577	5.4571e-003	4.9701e-002	1.9e-002	9.9251e-006
3578	4.4679e-003	4.98e-002	1.9e-002	8.1406e-006
3579	3.4769e-003	4.9879e-002	1.9e-002	6.344e-006
3580	2.4845e-003	4.9938e-002	1.9e-002	4.5382e-006
3581	1.4911e-003	4.9978e-002	1.9e-002	2.7256e-006
3582	4.9715e-004	4.9998e-002	1.9e-002	9.0907e-007
3583	-4.9702e-004	4.9998e-002	1.9e-002	-9.0881e-007
3584	-1.491e-003	4.9978e-002	1.9e-002	-2.7254e-006
3585	-2.4844e-003	4.9938e-002	1.9e-002	-4.5379e-006
3586	-3.4767e-003	4.9879e-002	1.9e-002	-6.3438e-006
3587	-4.4678e-003	4.98e-002	1.9e-002	-8.1403e-006
3588	-5.457e-003	4.9701e-002	1.9e-002	-9.9249e-006
3589	-6.4441e-003	4.9583e-002	1.9e-002	-1.1695e-005
3590	-7.4286e-003	4.9445e-002	1.9e-002	-1.3448e-005
3591	-8.4103e-003	4.9288e-002	1.9e-002	-1.518e-005
3592	-9.3885e-003	4.9111e-002	1.9e-002	-1.6891e-005
3593	-1.0363e-002	4.8914e-002	1.9e-002	-1.8577e-005
3594	-1.1334e-002	4.8699e-002	1.9e-002	-2.0235e-005
3595	-1.23e-002	4.8464e-002	1.9e-002	-2.1863e-005
3596	-1.3261e-002	4.8209e-002	1.9e-002	-2.3459e-005
3597	-1.4217e-002	4.7936e-002	1.9e-002	-2.502e-005
3598	-1.5167e-002	4.7644e-002	1.9e-002	-2.6544e-005
3599	-1.6111e-002	4.7333e-002	1.9e-002	-2.8029e-005
3600	-1.7049e-002	4.7004e-002	1.9e-002	-2.9472e-005
3601	-1.798e-002	4.6655e-002	1.9e-002	-3.0872e-005
3602	-1.8904e-002	4.6289e-002	1.9e-002	-3.2225e-005
3603	1.9821e-002	4.5904e-002	3.1e-002	3.353e-005
3604	1.9821e-002	4.5904e-002	3.e-002	3.353e-005
3605	1.9821e-002	4.5904e-002	2.9e-002	3.353e-005
3606	1.9821e-002	4.5904e-002	2.8e-002	3.353e-005
3607	1.9821e-002	4.5904e-002	2.7e-002	3.353e-005
3608	1.9821e-002	4.5904e-002	2.6e-002	3.353e-005
3609	1.9821e-002	4.5904e-002	2.5e-002	3.353e-005
3610	1.9821e-002	4.5904e-002	2.4e-002	3.353e-005
3611	1.9821e-002	4.5904e-002	2.3e-002	3.353e-005
3612	1.9821e-002	4.5904e-002	2.2e-002	3.353e-005
3613	1.9821e-002	4.5904e-002	2.1e-002	3.353e-005
3614	1.9821e-002	4.5904e-002	2.e-002	3.353e-005
3615	-1.9821e-002	4.5903e-002	3.1e-002	-3.3531e-005
3616	-1.8904e-002	4.6288e-002	3.1e-002	-3.2225e-005
3617	-1.798e-002	4.6655e-002	3.1e-002	-3.0872e-005
3618	-1.7049e-002	4.7003e-002	3.1e-002	-2.9473e-005
3619	-1.6111e-002	4.7333e-002	3.1e-002	-2.803e-005
3620	-1.5167e-002	4.7644e-002	3.1e-002	-2.6545e-005
3621	-1.4217e-002	4.7936e-002	3.1e-002	-2.5021e-005
3622	-1.3261e-002	4.8209e-002	3.1e-002	-2.3459e-005
3623	-1.23e-002	4.8464e-002	3.1e-002	-2.1863e-005
3624	-1.1334e-002	4.8699e-002	3.1e-002	-2.0235e-005
3625	-1.0363e-002	4.8914e-002	3.1e-002	-1.8577e-005
3626	-9.3888e-003	4.9111e-002	3.1e-002	-1.6891e-005
3627	-8.4104e-003	4.9288e-002	3.1e-002	-1.5181e-005
3628	-7.4289e-003	4.9445e-002	3.1e-002	-1.3448e-005
3629	-6.4443e-003	4.9583e-002	3.1e-002	-1.1695e-005
3630	-5.4573e-003	4.9701e-002	3.1e-002	-9.9253e-006
3631	-4.4679e-003	4.98e-002	3.1e-002	-8.1407e-006
3632	-3.477e-003	4.9879e-002	3.1e-002	-6.3442e-006
3633	-2.4845e-003	4.9938e-002	3.1e-002	-4.5383e-006
3634	-1.4912e-003	4.9978e-002	3.1e-002	-2.7258e-006
3635	-4.972e-004	4.9998e-002	3.1e-002	-9.0923e-007
3636	4.9688e-004	4.9998e-002	3.1e-002	9.0866e-007
3637	1.4909e-003	4.9978e-002	3.1e-002	2.7252e-006
3638	2.4842e-003	4.9938e-002	3.1e-002	4.5378e-006
3639	3.4767e-003	4.9879e-002	3.1e-002	6.3436e-006
3640	4.4676e-003	4.98e-002	3.1e-002	8.1402e-006
3641	5.4569e-003	4.9701e-002	3.1e-002	9.9247e-006
3642	6.444e-003	4.9583e-002	3.1e-002	1.1695e-005
3643	7.4286e-003	4.9445e-002	3.1e-002	1.3447e-005
3644	8.4101e-003	4.9288e-002	3.1e-002	1.518e-005
3645	9.3885e-003	4.9111e-002	3.1e-002	1.6891e-005
3646	1.0363e-002	4.8914e-002	3.1e-002	1.8576e-005
3647	1.1334e-002	4.8699e-002	3.1e-002	2.0235e-005
3648	1.2299e-002	4.8464e-002	3.1e-002	2.1863e-005
3649	1.3261e-002	4.8209e-002	3.1e-002	2.3459e-005
3650	1.4216e-002	4.7936e-002	3.1e-002	2.502e-005
3651	1.5167e-002	4.7644e-002	3.1e-002	2.6544e-005
3652	1.6111e-002	4.7333e-002	3.1e-002	2.8029e-005
3653	1.7049e-002	4.7004e-002	3.1e-002	2.9472e-005
3654	1.798e-002	4.6655e-002	3.1e-002	3.0872e-005
3655	1.8904e-002	4.6289e-002	3.1e-002	3.2225e-005
3656	-1.9821e-002	4.5903e-002	3.e-002	-3.3531e-005
3657	-1.9821e-002	4.5903e-002	2.9e-002	-3.3531e-005
3658	-1.9821e-002	4.5903e-002	2.8e-002	-3.3531e-005
3659	-1.9821e-002	4.5903e-002	2.7e-002	-3.3531e-005
3660	-1.9821e-002	4.5903e-002	2.6e-002	-3.3531e-005
3661	-1.9821e-002	4.5903e-002	2.5e-002	-3.3531e-005
3662	-1.9821e-002	4.5904e-002	2.2e-002	-3.3531e-005
3663	-1.9821e-002	4.5904e-002	2.3e-002	-3.3531e-005
3664	-1.9821e-002	4.5903e-002	2.4e-002	-3.3531e-005
3665	-1.8904e-002	4.6289e-002	2.e-002	-3.2225e-005
3666	-1.8904e-002	4.6289e-002	2.1e-002	-3.2225e-005
3667	1.8904e-002	4.6289e-002	2.e-002	3.2225e-005
3668	1.798e-002	4.6655e-002	2.e-002	3.0872e-005
3669	1.7049e-002	4.7003e-002	2.e-002	2.9473e-005
3670	1.6111e-002	4.7333e-002	2.e-002	2.8029e-005
3671	1.5167e-002	4.7644e-002	2.e-002	2.6545e-005
3672	1.4217e-002	4.7936e-002	2.e-002	2.5021e-005
3673	1.3261e-002	4.8209e-002	2.e-002	2.3459e-005
3674	1.23e-002	4.8464e-002	2.e-002	2.1863e-005
3675	1.1334e-002	4.8699e-002	2.e-002	2.0235e-005
3676	1.0363e-002	4.8914e-002	2.e-002	1.8577e-005
3677	9.3887e-003	4.9111e-002	2.e-002	1.6891e-005
3678	8.4104e-003	4.9288e-002	2.e-002	1.5181e-005
3679	7.4288e-003	4.9445e-002	2.e-002	1.3448e-005
3680	6.4442e-003	4.9583e-002	2.e-002	1.1695e-005
3681	5.4571e-003	4.9701e-002	2.e-002	9.9251e-006
3682	4.4679e-003	4.98e-002	2.e-002	8.1406e-006
3683	3.4769e-003	4.9879e-002	2.e-002	6.344e-006
3684	2.4845e-003	4.9938e-002	2.e-002	4.5382e-006
3685	1.4911e-003	4.9978e-002	2.e-002	2.7256e-006
3686	4.9717e-004	4.9998e-002	2.e-002	9.0908e-007
3687	-4.9701e-004	4.9998e-002	2.e-002	-9.0881e-007
3688	-1.491e-003	4.9978e-002	2.e-002	-2.7254e-006
3689	-2.4843e-003	4.9938e-002	2.e-002	-4.5379e-006
3690	-3.4767e-003	4.9879e-002	2.e-002	-6.3438e-006
3691	-4.4678e-003	4.98e-002	2.e-002	-8.1403e-006
3692	-5.457e-003	4.9701e-002	2.e-002	-9.9249e-006
3693	-6.4441e-003	4.9583e-002	2.e-002	-1.1695e-005
3694	-7.4286e-003	4.9445e-002	2.e-002	-1.3448e-005
3695	-8.4102e-003	4.9288e-002	2.e-002	-1.518e-005
3696	-9.3885e-003	4.9111e-002	2.e-002	-1.6891e-005
3697	-1.0363e-002	4.8914e-002	2.e-002	-1.8577e-005
3698	-1.1334e-002	4.8699e-002	2.e-002	-2.0235e-005
3699	-1.23e-002	4.8464e-002	2.e-002	-2.1863e-005
3700	-1.3261e-002	4.8209e-002	2.e-002	-2.3459e-005
3701	-1.4217e-002	4.7936e-002	2.e-002	-2.502e-005
3702	-1.5167e-002	4.7644e-002	2.e-002	-2.6544e-005
3703	-1.6111e-002	4.7333e-002	2.e-002	-2.8029e-005
3704	-1.7049e-002	4.7004e-002	2.e-002	-2.9472e-005
3705	-1.798e-002	4.6655e-002	2.e-002	-3.0872e-005
3706	1.8904e-002	4.6289e-002	3.e-002	3.2225e-005
3707	1.8904e-002	4.6289e-002	2.9e-002	3.2225e-005
3708	1.8904e-002	4.6289e-002	2.8e-002	3.2225e-005
3709	1.8904e-002	4.6289e-002	2.7e-002	3.2225e-005
3710	1.8904e-002	4.6289e-002	2.5e-002	3.2225e-005
3711	1.8904e-002	4.6289e-002	2.4e-002	3.2225e-005
3712	1.8904e-002	4.6289e-002	2.3e-002	3.2225e-005
3713	1.8904e-002	4.6289e-002	2.2e-002	3.2225e-005
3714	-1.8904e-002	4.6288e-002	3.e-002	-3.2225e-005
3715	-1.798e-002	4.6655e-002	3.e-002	-3.0872e-005
3716	-1.7049e-002	4.7003e-002	3.e-002	-2.9473e-005
3717	-1.6111e-002	4.7333e-002	3.e-002	-2.803e-005
3718	-1.5167e-002	4.7644e-002	3.e-002	-2.6545e-005
3719	-1.4217e-002	4.7936e-002	3.e-002	-2.5021e-005
3720	-1.3261e-002	4.8209e-002	3.e-002	-2.3459e-005
3721	-1.23e-002	4.8464e-002	3.e-002	-2.1863e-005
3722	-1.1334e-002	4.8699e-002	3.e-002	-2.0235e-005
3723	-1.0363e-002	4.8914e-002	3.e-002	-1.8577e-005
3724	-9.3888e-003	4.9111e-002	3.e-002	-1.6891e-005
3725	-8.4105e-003	4.9288e-002	3.e-002	-1.5181e-005
3726	-7.4289e-003	4.9445e-002	3.e-002	-1.3448e-005
3727	-6.4443e-003	4.9583e-002	3.e-002	-1.1695e-005
3728	-5.4573e-003	4.9701e-002	3.e-002	-9.9253e-006
3729	-4.468e-003	4.98e-002	3.e-002	-8.1408e-006
3730	-3.477e-003	4.9879e-002	3.e-002	-6.3442e-006
3731	-2.4846e-003	4.9938e-002	3.e-002	-4.5384e-006
3732	-1.4912e-003	4.9978e-002	3.e-002	-2.7258e-006
3733	-4.9723e-004	4.9998e-002	3.e-002	-9.0926e-007
3734	4.9688e-004	4.9998e-002	3.e-002	9.0862e-007
3735	1.4909e-003	4.9978e-002	3.e-002	2.7252e-006
3736	2.4842e-003	4.9938e-002	3.e-002	4.5377e-006
3737	3.4767e-003	4.9879e-002	3.e-002	6.3436e-006
3738	4.4676e-003	4.98e-002	3.e-002	8.1401e-006
3739	5.4569e-003	4.9701e-002	3.e-002	9.9247e-006
3740	6.444e-003	4.9583e-002	3.e-002	1.1695e-005
3741	7.4286e-003	4.9445e-002	3.e-002	1.3447e-005
3742	8.4101e-003	4.9288e-002	3.e-002	1.518e-005
3743	9.3884e-003	4.9111e-002	3.e-002	1.6891e-005
3744	1.0363e-002	4.8914e-002	3.e-002	1.8576e-005
3745	1.1333e-002	4.8699e-002	3.e-002	2.0235e-005
3746	1.2299e-002	4.8464e-002	3.e-002	2.1863e-005
3747	1.3261e-002	4.821e-002	3.e-002	2.3459e-005
3748	1.4216e-002	4.7936e-002	3.e-002	2.502e-005
3749	1.5167e-002	4.7644e-002	3.e-002	2.6544e-005
3750	1.6111e-002	4.7333e-002	3.e-002	2.8029e-005
3751	1.7049e-002	4.7004e-002	3.e-002	2.9472e-005
3752	1.798e-002	4.6655e-002	3.e-002	3.0872e-005
3753	-1.8904e-002	4.6289e-002	2.9e-002	-3.2225e-005
3754	-1.8904e-002	4.6289e-002	2.8e-002	-3.2225e-005
3755	-1.8904e-002	4.6289e-002	2.7e-002	-3.2225e-005
3756	-1.8904e-002	4.6289e-002	2.6e-002	-3.2225e-005
3757	-1.8904e-002	4.6289e-002	2.5e-002	-3.2225e-005
3758	-1.8904e-002	4.6289e-002	2.2e-002	-3.2225e-005
3759	-1.8904e-002	4.6289e-002	2.3e-002	-3.2225e-005
3760	-1.8904e-002	4.6289e-002	2.4e-002	-3.2225e-005
3761	-1.798e-002	4.6655e-002	2.1e-002	-3.0872e-005
3762	1.798e-002	4.6655e-002	2.1e-002	3.0872e-005
3763	1.6111e-002	4.7333e-002	2.1e-002	2.8029e-005
3764	1.5167e-002	4.7644e-002	2.1e-002	2.6545e-005
3765	1.4217e-002	4.7936e-002	2.1e-002	2.5021e-005
3766	1.3261e-002	4.8209e-002	2.1e-002	2.3459e-005
3767	1.23e-002	4.8464e-002	2.1e-002	2.1863e-005
3768	1.1334e-002	4.8699e-002	2.1e-002	2.0235e-005
3769	1.0363e-002	4.8914e-002	2.1e-002	1.8577e-005
3770	8.4104e-003	4.9288e-002	2.1e-002	1.5181e-005
3771	7.4288e-003	4.9445e-002	2.1e-002	1.3448e-005
3772	6.4442e-003	4.9583e-002	2.1e-002	1.1695e-005
3773	5.4571e-003	4.9701e-002	2.1e-002	9.9251e-006
3774	4.4679e-003	4.98e-002	2.1e-002	8.1406e-006
3775	3.4769e-003	4.9879e-002	2.1e-002	6.344e-006
3776	2.4845e-003	4.9938e-002	2.1e-002	4.5382e-006
3777	1.4911e-003	4.9978e-002	2.1e-002	2.7256e-006
3778	4.9716e-004	4.9998e-002	2.1e-002	9.0908e-007
3779	-4.9701e-004	4.9998e-002	2.1e-002	-9.0881e-007
3780	-1.491e-003	4.9978e-002	2.1e-002	-2.7254e-006
3781	-2.4843e-003	4.9938e-002	2.1e-002	-4.5379e-006
3782	-3.4767e-003	4.9879e-002	2.1e-002	-6.3438e-006
3783	-4.4677e-003	4.98e-002	2.1e-002	-8.1403e-006
3784	-5.457e-003	4.9701e-002	2.1e-002	-9.9249e-006
3785	-6.4441e-003	4.9583e-002	2.1e-002	-1.1695e-005
3786	-7.4286e-003	4.9445e-002	2.1e-002	-1.3448e-005
3787	-8.4102e-003	4.9288e-002	2.1e-002	-1.518e-005
3788	-9.3885e-003	4.9111e-002	2.1e-002	-1.6891e-005
3789	-1.0363e-002	4.8914e-002	2.1e-002	-1.8577e-005
3790	-1.1334e-002	4.8699e-002	2.1e-002	-2.0235e-005
3791	-1.23e-002	4.8464e-002	2.1e-002	-2.1863e-005
3792	-1.3261e-002	4.8209e-002	2.1e-002	-2.3459e-005
3793	-1.4217e-002	4.7936e-002	2.1e-002	-2.502e-005
3794	-1.5167e-002	4.7644e-002	2.1e-002	-2.6544e-005
3795	-1.6111e-002	4.7333e-002	2.1e-002	-2.8029e-005
3796	-1.7049e-002	4.7004e-002	2.1e-002	-2.9472e-005
3797	1.798e-002	4.6655e-002	2.9e-002	3.0872e-005
3798	1.798e-002	4.6655e-002	2.8e-002	3.0872e-005
3799	1.798e-002	4.6655e-002	2.7e-002	3.0872e-005
3800	1.798e-002	4.6655e-002	2.6e-002	3.0872e-005
3801	1.798e-002	4.6655e-002	2.5e-002	3.0872e-005
3802	1.798e-002	4.6655e-002	2.4e-002	3.0872e-005
3803	1.798e-002	4.6655e-002	2.2e-002	3.0872e-005
3804	-1.798e-002	4.6655e-002	2.9e-002	-3.0872e-005
3805	-1.7049e-002	4.7003e-002	2.9e-002	-2.9473e-005
3806	-1.6111e-002	4.7333e-002	2.9e-002	-2.803e-005
3807	-1.5167e-002	4.7644e-002	2.9e-002	-2.6545e-005
3808	-1.4217e-002	4.7936e-002	2.9e-002	-2.5021e-005
3809	-1.3261e-002	4.8209e-002	2.9e-002	-2.3459e-005
3810	-1.23e-002	4.8464e-002	2.9e-002	-2.1864e-005
3811	-1.1334e-002	4.8699e-002	2.9e-002	-2.0235e-005
3812	-1.0363e-002	4.8914e-002	2.9e-002	-1.8577e-005
3813	-9.3888e-003	4.9111e-002	2.9e-002	-1.6891e-005
3814	-8.4105e-003	4.9288e-002	2.9e-002	-1.5181e-005
3815	-7.4289e-003	4.9445e-002	2.9e-002	-1.3448e-005
3816	-6.4443e-003	4.9583e-002	2.9e-002	-1.1695e-005
3817	-5.4573e-003	4.9701e-002	2.9e-002	-9.9253e-006
3818	-4.468e-003	4.98e-002	2.9e-002	-8.1408e-006
3819	-3.477e-003	4.9879e-002	2.9e-002	-6.3443e-006
3820	-2.4846e-003	4.9938e-002	2.9e-002	-4.5384e-006
3821	-1.4912e-003	4.9978e-002	2.9e-002	-2.7258e-006
3822	-4.9726e-004	4.9998e-002	2.9e-002	-9.0929e-007
3823	4.9689e-004	4.9998e-002	2.9e-002	9.086e-007
3824	1.4909e-003	4.9978e-002	2.9e-002	2.7252e-006
3825	2.4842e-003	4.9938e-002	2.9e-002	4.5377e-006
3826	3.4766e-003	4.9879e-002	2.9e-002	6.3436e-006
3827	4.4676e-003	4.98e-002	2.9e-002	8.1401e-006
3828	5.4569e-003	4.9701e-002	2.9e-002	9.9247e-006
3829	6.444e-003	4.9583e-002	2.9e-002	1.1695e-005
3830	7.4285e-003	4.9445e-002	2.9e-002	1.3447e-005
3831	8.4101e-003	4.9288e-002	2.9e-002	1.518e-005
3832	9.3884e-003	4.9111e-002	2.9e-002	1.6891e-005
3833	1.0363e-002	4.8914e-002	2.9e-002	1.8576e-005
3834	1.1333e-002	4.8699e-002	2.9e-002	2.0235e-005
3835	1.2299e-002	4.8464e-002	2.9e-002	2.1863e-005
3836	1.3261e-002	4.821e-002	2.9e-002	2.3459e-005
3837	1.4216e-002	4.7936e-002	2.9e-002	2.502e-005
3838	1.5167e-002	4.7644e-002	2.9e-002	2.6544e-005
3839	1.6111e-002	4.7333e-002	2.9e-002	2.8029e-005
3840	1.7049e-002	4.7004e-002	2.9e-002	2.9472e-005
3841	-1.798e-002	4.6655e-002	2.8e-002	-3.0872e-005
3842	-1.798e-002	4.6655e-002	2.7e-002	-3.0872e-005
3843	-1.798e-002	4.6655e-002	2.6e-002	-3.0872e-005
3844	-1.798e-002	4.6655e-002	2.5e-002	-3.0872e-005
3845	1.7049e-002	4.7003e-002	2.2e-002	2.9473e-005
3846	1.6111e-002	4.7333e-002	2.2e-002	2.8029e-005
3847	1.5167e-002	4.7644e-002	2.2e-002	2.6545e-005
3848	1.4217e-002	4.7936e-002	2.2e-002	2.502e-005
3849	1.3261e-002	4.8209e-002	2.2e-002	2.3459e-005
3850	1.23e-002	4.8464e-002	2.2e-002	2.1863e-005
3851	1.0363e-002	4.8914e-002	2.2e-002	1.8577e-005
3852	9.3887e-003	4.9111e-002	2.2e-002	1.6891e-005
3853	8.4104e-003	4.9288e-002	2.2e-002	1.5181e-005
3854	7.4288e-003	4.9445e-002	2.2e-002	1.3448e-005
3855	6.4442e-003	4.9583e-002	2.2e-002	1.1695e-005
3856	5.4571e-003	4.9701e-002	2.2e-002	9.9251e-006
3857	4.4679e-003	4.98e-002	2.2e-002	8.1406e-006
3858	2.4845e-003	4.9938e-002	2.2e-002	4.5382e-006
3859	4.9716e-004	4.9998e-002	2.2e-002	9.0908e-007
3860	-1.491e-003	4.9978e-002	2.2e-002	-2.7254e-006
3861	-3.4767e-003	4.9879e-002	2.2e-002	-6.3438e-006
3862	-5.457e-003	4.9701e-002	2.2e-002	-9.9249e-006
3863	-7.4286e-003	4.9445e-002	2.2e-002	-1.3448e-005
3864	-9.3885e-003	4.9111e-002	2.2e-002	-1.6891e-005
3865	-1.1334e-002	4.8699e-002	2.2e-002	-2.0236e-005
3866	-1.3261e-002	4.8209e-002	2.2e-002	-2.3459e-005
3867	-1.4217e-002	4.7936e-002	2.2e-002	-2.502e-005
3868	-1.5167e-002	4.7644e-002	2.2e-002	-2.6544e-005
3869	-1.6111e-002	4.7333e-002	2.2e-002	-2.8029e-005
3870	-1.7049e-002	4.7004e-002	2.2e-002	-2.9472e-005
3871	-1.798e-002	4.6655e-002	2.2e-002	-3.0872e-005
3872	-1.798e-002	4.6655e-002	2.3e-002	-3.0872e-005
3873	-1.798e-002	4.6655e-002	2.4e-002	-3.0872e-005
3874	1.7049e-002	4.7004e-002	2.8e-002	2.9472e-005
3875	1.7049e-002	4.7004e-002	2.7e-002	2.9472e-005
3876	1.7049e-002	4.7004e-002	2.6e-002	2.9472e-005
3877	1.7049e-002	4.7004e-002	2.5e-002	2.9472e-005
3878	1.7049e-002	4.7004e-002	2.4e-002	2.9472e-005
3879	1.7049e-002	4.7004e-002	2.3e-002	2.9473e-005
3880	-1.7049e-002	4.7003e-002	2.8e-002	-2.9473e-005
3881	-1.6111e-002	4.7333e-002	2.8e-002	-2.803e-005
3882	-1.5167e-002	4.7644e-002	2.8e-002	-2.6545e-005
3883	-1.3261e-002	4.8209e-002	2.8e-002	-2.3459e-005
3884	-1.23e-002	4.8464e-002	2.8e-002	-2.1864e-005
3885	-1.1334e-002	4.8699e-002	2.8e-002	-2.0235e-005
3886	-1.0363e-002	4.8914e-002	2.8e-002	-1.8577e-005
3887	-8.4106e-003	4.9288e-002	2.8e-002	-1.5181e-005
3888	-6.4444e-003	4.9583e-002	2.8e-002	-1.1695e-005
3889	-5.4573e-003	4.9701e-002	2.8e-002	-9.9254e-006
3890	-4.4681e-003	4.98e-002	2.8e-002	-8.1408e-006
3891	-3.477e-003	4.9879e-002	2.8e-002	-6.3443e-006
3892	-2.4846e-003	4.9938e-002	2.8e-002	-4.5384e-006
3893	-1.4912e-003	4.9978e-002	2.8e-002	-2.7259e-006
3894	-4.9731e-004	4.9998e-002	2.8e-002	-9.0932e-007
3895	4.9689e-004	4.9998e-002	2.8e-002	9.0857e-007
3896	1.4908e-003	4.9978e-002	2.8e-002	2.7251e-006
3897	2.4842e-003	4.9938e-002	2.8e-002	4.5377e-006
3898	3.4766e-003	4.9879e-002	2.8e-002	6.3435e-006
3899	4.4676e-003	4.98e-002	2.8e-002	8.1401e-006
3900	5.4568e-003	4.9701e-002	2.8e-002	9.9246e-006
3901	6.444e-003	4.9583e-002	2.8e-002	1.1695e-005
3902	7.4285e-003	4.9445e-002	2.8e-002	1.3447e-005
3903	8.4101e-003	4.9288e-002	2.8e-002	1.518e-005
3904	9.3884e-003	4.9111e-002	2.8e-002	1.6891e-005
3905	1.0363e-002	4.8914e-002	2.8e-002	1.8576e-005
3906	1.1333e-002	4.8699e-002	2.8e-002	2.0235e-005
3907	1.2299e-002	4.8464e-002	2.8e-002	2.1863e-005
3908	1.3261e-002	4.821e-002	2.8e-002	2.3459e-005
3909	1.4216e-002	4.7936e-002	2.8e-002	2.502e-005
3910	1.5167e-002	4.7644e-002	2.8e-002	2.6544e-005
3911	1.6111e-002	4.7333e-002	2.8e-002	2.8029e-005
3912	-1.7049e-002	4.7003e-002	2.7e-002	-2.9473e-005
3913	-1.7049e-002	4.7003e-002	2.6e-002	-2.9473e-005
3914	-1.7049e-002	4.7003e-002	2.5e-002	-2.9473e-005
3915	-1.7049e-002	4.7003e-002	2.3e-002	-2.9472e-005
3916	-1.7049e-002	4.7003e-002	2.4e-002	-2.9473e-005
3917	1.6111e-002	4.7333e-002	2.3e-002	2.8029e-005
3918	1.5167e-002	4.7644e-002	2.3e-002	2.6545e-005
3919	1.4217e-002	4.7936e-002	2.3e-002	2.502e-005
3920	1.3261e-002	4.8209e-002	2.3e-002	2.3459e-005
3921	1.23e-002	4.8464e-002	2.3e-002	2.1863e-005
3922	1.1334e-002	4.8699e-002	2.3e-002	2.0235e-005
3923	1.0363e-002	4.8914e-002	2.3e-002	1.8577e-005
3924	9.3887e-003	4.9111e-002	2.3e-002	1.6891e-005
3925	7.4288e-003	4.9445e-002	2.3e-002	1.3448e-005
3926	6.4443e-003	4.9583e-002	2.3e-002	1.1695e-005
3927	5.4571e-003	4.9701e-002	2.3e-002	9.9251e-006
3928	4.4679e-003	4.98e-002	2.3e-002	8.1406e-006
3929	3.4769e-003	4.9879e-002	2.3e-002	6.3441e-006
3930	2.4845e-003	4.9938e-002	2.3e-002	4.5382e-006
3931	1.4911e-003	4.9978e-002	2.3e-002	2.7257e-006
3932	4.9718e-004	4.9998e-002	2.3e-002	9.091e-007
3933	-4.9701e-004	4.9998e-002	2.3e-002	-9.0879e-007
3934	-1.4909e-003	4.9978e-002	2.3e-002	-2.7253e-006
3935	-2.4843e-003	4.9938e-002	2.3e-002	-4.5379e-006
3936	-3.4767e-003	4.9879e-002	2.3e-002	-6.3438e-006
3937	-4.4677e-003	4.98e-002	2.3e-002	-8.1403e-006
3938	-5.457e-003	4.9701e-002	2.3e-002	-9.9249e-006
3939	-6.4441e-003	4.9583e-002	2.3e-002	-1.1695e-005
3940	-7.4286e-003	4.9445e-002	2.3e-002	-1.3447e-005
3941	-8.4102e-003	4.9288e-002	2.3e-002	-1.5182e-005
3942	-9.3885e-003	4.9111e-002	2.3e-002	-1.6895e-005
3943	-1.0366e-002	4.8914e-002	2.3011e-002	-1.8583e-005
3944	-1.1338e-002	4.8698e-002	2.3012e-002	-2.0242e-005
3945	-1.23e-002	4.8464e-002	2.3e-002	-2.1867e-005
3946	-1.3261e-002	4.8209e-002	2.3e-002	-2.346e-005
3947	-1.4217e-002	4.7936e-002	2.3e-002	-2.502e-005
3948	-1.5167e-002	4.7644e-002	2.3e-002	-2.6544e-005
3949	-1.6111e-002	4.7333e-002	2.3e-002	-2.8029e-005
3950	1.6111e-002	4.7333e-002	2.7e-002	2.8029e-005
3951	1.6111e-002	4.7333e-002	2.6e-002	2.8029e-005
3952	1.6111e-002	4.7333e-002	2.5e-002	2.8029e-005
3953	1.6111e-002	4.7333e-002	2.4e-002	2.8029e-005
3954	-1.6111e-002	4.7333e-002	2.7e-002	-2.803e-005
3955	-1.5167e-002	4.7644e-002	2.7e-002	-2.6545e-005
3956	-1.4217e-002	4.7936e-002	2.7e-002	-2.5021e-005
3957	-1.3261e-002	4.8209e-002	2.7e-002	-2.3462e-005
3958	-1.23e-002	4.8464e-002	2.7e-002	-2.1868e-005
3959	-1.1334e-002	4.8699e-002	2.7e-002	-2.0239e-005
3960	-1.0363e-002	4.8914e-002	2.7e-002	-1.858e-005
3961	-9.3888e-003	4.9111e-002	2.7e-002	-1.6892e-005
3962	-8.4106e-003	4.9288e-002	2.7e-002	-1.5181e-005
3963	-7.4289e-003	4.9445e-002	2.7e-002	-1.3448e-005
3964	-6.4443e-003	4.9583e-002	2.7e-002	-1.1695e-005
3965	-5.4572e-003	4.9701e-002	2.7e-002	-9.9253e-006
3966	-4.4681e-003	4.98e-002	2.7e-002	-8.1408e-006
3967	-3.477e-003	4.9879e-002	2.7e-002	-6.3443e-006
3968	-2.4847e-003	4.9938e-002	2.7e-002	-4.5384e-006
3969	-1.4912e-003	4.9978e-002	2.7e-002	-2.7259e-006
3970	-4.9732e-004	4.9998e-002	2.7e-002	-9.0933e-007
3971	4.9689e-004	4.9998e-002	2.7e-002	9.0856e-007
3972	1.4908e-003	4.9978e-002	2.7e-002	2.7251e-006
3973	2.4842e-003	4.9938e-002	2.7e-002	4.5377e-006
3974	3.4766e-003	4.9879e-002	2.7e-002	6.3435e-006
3975	4.4676e-003	4.98e-002	2.7e-002	8.1401e-006
3976	5.4568e-003	4.9701e-002	2.7e-002	9.9246e-006
3977	6.444e-003	4.9583e-002	2.7e-002	1.1695e-005
3978	7.4285e-003	4.9445e-002	2.7e-002	1.3447e-005
3979	8.4101e-003	4.9288e-002	2.7e-002	1.518e-005
3980	9.3884e-003	4.9111e-002	2.7e-002	1.6891e-005
3981	1.0363e-002	4.8914e-002	2.7e-002	1.8576e-005
3982	1.1333e-002	4.8699e-002	2.7e-002	2.0235e-005
3983	1.2299e-002	4.8464e-002	2.7e-002	2.1863e-005
3984	1.3261e-002	4.821e-002	2.7e-002	2.3459e-005
3985	1.4216e-002	4.7936e-002	2.7e-002	2.502e-005
3986	1.5167e-002	4.7644e-002	2.7e-002	2.6544e-005
3987	-1.6111e-002	4.7333e-002	2.6e-002	-2.803e-005
3988	-1.6111e-002	4.7333e-002	2.5e-002	-2.803e-005
3989	-1.6111e-002	4.7333e-002	2.4e-002	-2.8029e-005
3990	1.5167e-002	4.7644e-002	2.4e-002	2.6545e-005
3991	1.4217e-002	4.7936e-002	2.4e-002	2.502e-005
3992	1.3261e-002	4.8209e-002	2.4e-002	2.3459e-005
3993	1.23e-002	4.8464e-002	2.4e-002	2.1863e-005
3994	1.1334e-002	4.8699e-002	2.4e-002	2.0235e-005
3995	1.0363e-002	4.8914e-002	2.4e-002	1.8577e-005
3996	9.3887e-003	4.9111e-002	2.4e-002	1.6891e-005
3997	8.4104e-003	4.9288e-002	2.4e-002	1.5181e-005
3998	7.4288e-003	4.9445e-002	2.4e-002	1.3448e-005
3999	6.4443e-003	4.9583e-002	2.4e-002	1.1695e-005
4000	5.4571e-003	4.9701e-002	2.4e-002	9.9251e-006
4001	4.468e-003	4.98e-002	2.4e-002	8.1406e-006
4002	3.4769e-003	4.9879e-002	2.4e-002	6.3441e-006
4003	2.4846e-003	4.9938e-002	2.4e-002	4.5382e-006
4004	1.4911e-003	4.9978e-002	2.4e-002	2.7257e-006
4005	4.9722e-004	4.9998e-002	2.4e-002	9.0911e-007
4006	-4.9702e-004	4.9998e-002	2.4e-002	-9.0878e-007
4007	-1.4909e-003	4.9978e-002	2.4e-002	-2.7253e-006
4008	-2.4844e-003	4.9938e-002	2.4e-002	-4.5379e-006
4009	-3.4767e-003	4.9879e-002	2.4e-002	-6.3437e-006
4010	-4.4678e-003	4.98e-002	2.4e-002	-8.1403e-006
4011	-5.457e-003	4.9701e-002	2.4e-002	-9.9249e-006
4012	-6.4441e-003	4.9583e-002	2.4e-002	-1.1695e-005
4013	-7.4286e-003	4.9445e-002	2.4e-002	-1.3447e-005
4014	-8.4103e-003	4.9288e-002	2.4e-002	-1.5184e-005
4015	-9.399e-003	4.9109e-002	2.4005e-002	-1.6902e-005
4016	-1.0373e-002	4.8912e-002	2.4013e-002	-1.8592e-005
4017	-1.1345e-002	4.8696e-002	2.4013e-002	-2.025e-005
4018	-1.2309e-002	4.8461e-002	2.4009e-002	-2.1875e-005
4019	-1.4217e-002	4.7936e-002	2.4e-002	-2.5021e-005
4020	-1.5167e-002	4.7644e-002	2.4e-002	-2.6545e-005
4021	1.5167e-002	4.7644e-002	2.6e-002	2.6544e-005
4022	1.5167e-002	4.7644e-002	2.5e-002	2.6544e-005
4023	-1.5167e-002	4.7644e-002	2.6e-002	-2.6545e-005
4024	-1.4217e-002	4.7936e-002	2.6e-002	-2.5023e-005
4025	-1.3269e-002	4.8207e-002	2.6003e-002	-2.3469e-005
4026	-1.2311e-002	4.8461e-002	2.6008e-002	-2.1877e-005
4027	-1.0371e-002	4.8913e-002	2.6008e-002	-1.8587e-005
4028	-9.3888e-003	4.9111e-002	2.6e-002	-1.6897e-005
4029	-8.4106e-003	4.9288e-002	2.6e-002	-1.5182e-005
4030	-7.429e-003	4.9445e-002	2.6e-002	-1.3448e-005
4031	-6.4442e-003	4.9583e-002	2.6e-002	-1.1695e-005
4032	-5.4572e-003	4.9701e-002	2.6e-002	-9.9252e-006
4033	-4.4681e-003	4.98e-002	2.6e-002	-8.1407e-006
4034	-3.477e-003	4.9879e-002	2.6e-002	-6.3442e-006
4035	-2.4847e-003	4.9938e-002	2.6e-002	-4.5383e-006
4036	-1.4912e-003	4.9978e-002	2.6e-002	-2.7257e-006
4037	-4.9733e-004	4.9998e-002	2.6e-002	-9.0919e-007
4038	4.9691e-004	4.9998e-002	2.6e-002	9.087e-007
4039	1.4908e-003	4.9978e-002	2.6e-002	2.7253e-006
4040	2.4842e-003	4.9938e-002	2.6e-002	4.5378e-006
4041	3.4766e-003	4.9879e-002	2.6e-002	6.3437e-006
4042	4.4676e-003	4.98e-002	2.6e-002	8.1402e-006
4043	5.4568e-003	4.9701e-002	2.6e-002	9.9247e-006
4044	6.444e-003	4.9583e-002	2.6e-002	1.1695e-005
4045	7.4285e-003	4.9445e-002	2.6e-002	1.3447e-005
4046	8.4102e-003	4.9288e-002	2.6e-002	1.518e-005
4047	9.3884e-003	4.9111e-002	2.6e-002	1.6891e-005
4048	1.0363e-002	4.8914e-002	2.6e-002	1.8576e-005
4049	1.1333e-002	4.8699e-002	2.6e-002	2.0235e-005
4050	1.2299e-002	4.8464e-002	2.6e-002	2.1863e-005
4051	1.3261e-002	4.821e-002	2.6e-002	2.3459e-005
4052	1.4216e-002	4.7936e-002	2.6e-002	2.502e-005
4053	-1.5167e-002	4.7644e-002	2.5e-002	-2.6545e-005
4054	1.4217e-002	4.7936e-002	2.5e-002	2.502e-005
4055	-1.4217e-002	4.7936e-002	2.5e-002	-2.5023e-005
4056	-1.3271e-002	4.8207e-002	2.5003e-002	-2.347e-005
4057	1.3261e-002	4.8209e-002	2.5e-002	2.3459e-005
4058	1.23e-002	4.8464e-002	2.5e-002	2.1863e-005
4059	1.1334e-002	4.8699e-002	2.5e-002	2.0235e-005
4060	1.0363e-002	4.8914e-002	2.5e-002	1.8577e-005
4061	9.3887e-003	4.9111e-002	2.5e-002	1.6891e-005
4062	8.4104e-003	4.9288e-002	2.5e-002	1.5181e-005
4063	7.4288e-003	4.9445e-002	2.5e-002	1.3448e-005
4064	5.457e-003	4.9701e-002	2.5e-002	9.925e-006
4065	4.468e-003	4.98e-002	2.5e-002	8.1405e-006
4066	3.4769e-003	4.9879e-002	2.5e-002	6.344e-006
4067	2.4845e-003	4.9938e-002	2.5e-002	4.5381e-006
4068	1.4911e-003	4.9978e-002	2.5e-002	2.7255e-006
4069	-4.9702e-004	4.9998e-002	2.5e-002	-9.0891e-007
4070	-1.4909e-003	4.9978e-002	2.5e-002	-2.7255e-006
4071	-2.4844e-003	4.9938e-002	2.5e-002	-4.538e-006
4072	-3.4767e-003	4.9879e-002	2.5e-002	-6.3439e-006
4073	-4.4677e-003	4.98e-002	2.5e-002	-8.1404e-006
4074	-5.457e-003	4.9701e-002	2.5e-002	-9.925e-006
4075	-6.4441e-003	4.9583e-002	2.5e-002	-1.1695e-005
4076	-7.4285e-003	4.9445e-002	2.5e-002	-1.3448e-005
4077	-8.4103e-003	4.9288e-002	2.5e-002	-1.5184e-005
4078	-9.3984e-003	4.9109e-002	2.5004e-002	-1.6902e-005
4079	-1.0377e-002	4.8911e-002	2.501e-002	-1.8594e-005
4080	-1.1346e-002	4.8696e-002	2.5011e-002	-2.0254e-005"""
    writer = System.IO.StreamWriter(filePath, False)
    writer.WriteLine(fileContents)
    writer.Close()
    fileRef = task.RegisterFile(filePath)
    fileRefs.Add(fileRef)
    #region xz strain
    filePath = System.IO.Path.Combine(workingDirectory, "StrainXZ.txt")
    fileContents = r"""Node Number	X Location (m)	Y Location (m)	Z Location (m)	Shear Elastic Strain (m/m)
1	-3.5355e-002	3.5355e-002	5.e-002	-2.575e-010
2	3.5355e-002	3.5355e-002	5.e-002	3.7543e-010
3	-3.4645e-002	3.6051e-002	5.e-002	-1.8671e-010
4	-3.3922e-002	3.6733e-002	5.e-002	1.6469e-011
5	-3.3185e-002	3.74e-002	5.e-002	9.4236e-011
6	-3.2435e-002	3.8053e-002	5.e-002	1.5407e-011
7	-3.1672e-002	3.869e-002	5.e-002	-1.1018e-011
8	-3.0896e-002	3.9312e-002	5.e-002	-7.5435e-012
9	-3.0108e-002	3.9918e-002	5.e-002	1.3767e-012
10	-2.9309e-002	4.0509e-002	5.e-002	2.3253e-012
11	-2.8498e-002	4.1084e-002	5.e-002	-1.8069e-012
12	-2.7675e-002	4.1642e-002	5.e-002	-4.315e-012
13	-2.6842e-002	4.2184e-002	5.e-002	-6.1053e-012
14	-2.5998e-002	4.271e-002	5.e-002	-7.7335e-012
15	-2.5143e-002	4.3218e-002	5.e-002	-8.8055e-012
16	-2.4279e-002	4.371e-002	5.e-002	-9.6057e-012
17	-2.3405e-002	4.4184e-002	5.e-002	-9.7701e-012
18	-2.2522e-002	4.464e-002	5.e-002	-9.4667e-012
19	-2.163e-002	4.5079e-002	5.e-002	-8.8265e-012
20	-2.073e-002	4.55e-002	5.e-002	-8.0307e-012
21	-1.9821e-002	4.5904e-002	5.e-002	-7.2034e-012
22	-1.8904e-002	4.6289e-002	5.e-002	-6.4361e-012
23	-1.798e-002	4.6655e-002	5.e-002	-5.8035e-012
24	-1.7049e-002	4.7003e-002	5.e-002	-5.301e-012
25	-1.6111e-002	4.7333e-002	5.e-002	-4.9159e-012
26	-1.5167e-002	4.7644e-002	5.e-002	-4.6334e-012
27	-1.4217e-002	4.7936e-002	5.e-002	-4.422e-012
28	-1.3261e-002	4.8209e-002	5.e-002	-4.2414e-012
29	-1.23e-002	4.8464e-002	5.e-002	-4.0695e-012
30	-1.1334e-002	4.8699e-002	5.e-002	-3.8996e-012
31	-1.0363e-002	4.8914e-002	5.e-002	-3.7507e-012
32	-9.3886e-003	4.9111e-002	5.e-002	-3.5666e-012
33	-8.4103e-003	4.9288e-002	5.e-002	-3.3707e-012
34	-7.4287e-003	4.9445e-002	5.e-002	-3.2094e-012
35	-6.4442e-003	4.9583e-002	5.e-002	-3.0397e-012
36	-5.4571e-003	4.9701e-002	5.e-002	-2.8366e-012
37	-4.4678e-003	4.98e-002	5.e-002	-2.6539e-012
38	-3.4768e-003	4.9879e-002	5.e-002	-2.4589e-012
39	-2.4844e-003	4.9938e-002	5.e-002	-2.2363e-012
40	-1.491e-003	4.9978e-002	5.e-002	-2.0491e-012
41	-4.9708e-004	4.9998e-002	5.e-002	-1.8775e-012
42	4.9708e-004	4.9998e-002	5.e-002	-1.6885e-012
43	1.491e-003	4.9978e-002	5.e-002	-1.5244e-012
44	2.4844e-003	4.9938e-002	5.e-002	-1.3493e-012
45	3.4768e-003	4.9879e-002	5.e-002	-1.1896e-012
46	4.4678e-003	4.98e-002	5.e-002	-1.0463e-012
47	5.4571e-003	4.9701e-002	5.e-002	-9.2443e-013
48	6.4442e-003	4.9583e-002	5.e-002	-7.7927e-013
49	7.4287e-003	4.9445e-002	5.e-002	-6.4284e-013
50	8.4103e-003	4.9288e-002	5.e-002	-5.609e-013
51	9.3886e-003	4.9111e-002	5.e-002	-4.7889e-013
52	1.0363e-002	4.8914e-002	5.e-002	-4.0638e-013
53	1.1334e-002	4.8699e-002	5.e-002	-3.3507e-013
54	1.23e-002	4.8464e-002	5.e-002	-2.4501e-013
55	1.3261e-002	4.8209e-002	5.e-002	-1.9305e-013
56	1.4217e-002	4.7936e-002	5.e-002	-1.5875e-013
57	1.5167e-002	4.7644e-002	5.e-002	-1.3955e-013
58	1.6111e-002	4.7333e-002	5.e-002	-1.1613e-013
59	1.7049e-002	4.7003e-002	5.e-002	-6.8386e-014
60	1.798e-002	4.6655e-002	5.e-002	-2.3133e-014
61	1.8904e-002	4.6289e-002	5.e-002	2.9972e-015
62	1.9821e-002	4.5904e-002	5.e-002	3.5652e-014
63	2.073e-002	4.55e-002	5.e-002	6.3987e-014
64	2.163e-002	4.5079e-002	5.e-002	1.0328e-013
65	2.2522e-002	4.464e-002	5.e-002	1.6212e-013
66	2.3405e-002	4.4184e-002	5.e-002	2.2999e-013
67	2.4279e-002	4.371e-002	5.e-002	3.1429e-013
68	2.5143e-002	4.3218e-002	5.e-002	4.4365e-013
69	2.5998e-002	4.271e-002	5.e-002	5.874e-013
70	2.6842e-002	4.2184e-002	5.e-002	9.33e-013
71	2.7675e-002	4.1642e-002	5.e-002	8.8964e-013
72	2.8498e-002	4.1084e-002	5.e-002	1.6628e-012
73	2.9309e-002	4.0509e-002	5.e-002	2.6876e-012
74	3.0108e-002	3.9918e-002	5.e-002	2.2469e-012
75	3.0896e-002	3.9312e-002	5.e-002	6.77e-012
76	3.1672e-002	3.869e-002	5.e-002	1.1894e-011
77	3.2435e-002	3.8053e-002	5.e-002	3.0413e-011
78	3.3185e-002	3.74e-002	5.e-002	-8.6201e-011
79	3.3922e-002	3.6733e-002	5.e-002	-8.5534e-011
80	3.4645e-002	3.6051e-002	5.e-002	2.1271e-010
81	3.5355e-002	3.5355e-002	0.	-2.073e-010
82	3.5355e-002	3.5355e-002	4.9e-002	3.5508e-010
83	3.5355e-002	3.5355e-002	4.8e-002	3.0783e-010
84	3.5355e-002	3.5355e-002	4.7e-002	1.2128e-010
85	3.5355e-002	3.5355e-002	4.6e-002	1.1798e-011
86	3.5355e-002	3.5355e-002	4.5e-002	9.0521e-011
87	3.5355e-002	3.5355e-002	4.4e-002	-4.5357e-011
88	3.5355e-002	3.5355e-002	4.3e-002	-9.0615e-011
89	3.5355e-002	3.5355e-002	4.2e-002	3.641e-011
90	3.5355e-002	3.5355e-002	4.1e-002	4.9994e-011
91	3.5355e-002	3.5355e-002	4.e-002	5.5968e-011
92	3.5355e-002	3.5355e-002	3.9e-002	5.5155e-011
93	3.5355e-002	3.5355e-002	3.8e-002	5.3077e-011
94	3.5355e-002	3.5355e-002	3.7e-002	5.1375e-011
95	3.5355e-002	3.5355e-002	3.6e-002	4.9862e-011
96	3.5355e-002	3.5355e-002	3.5e-002	4.8554e-011
97	3.5355e-002	3.5355e-002	3.4e-002	4.7343e-011
98	3.5355e-002	3.5355e-002	3.3e-002	4.6238e-011
99	3.5355e-002	3.5355e-002	3.2e-002	4.5182e-011
100	3.5355e-002	3.5355e-002	3.1e-002	4.4183e-011
101	3.5355e-002	3.5355e-002	3.e-002	4.3218e-011
102	3.5355e-002	3.5355e-002	2.9e-002	4.228e-011
103	3.5355e-002	3.5355e-002	2.8e-002	4.1363e-011
104	3.5355e-002	3.5355e-002	2.7e-002	4.0443e-011
105	3.5355e-002	3.5355e-002	2.6e-002	3.953e-011
106	3.5355e-002	3.5355e-002	2.5e-002	3.863e-011
107	3.5355e-002	3.5355e-002	2.4e-002	3.7716e-011
108	3.5355e-002	3.5355e-002	2.3e-002	3.679e-011
109	3.5355e-002	3.5355e-002	2.2e-002	3.5869e-011
110	3.5355e-002	3.5355e-002	2.1e-002	3.4947e-011
111	3.5355e-002	3.5355e-002	2.e-002	3.4023e-011
112	3.5355e-002	3.5355e-002	1.9e-002	3.3072e-011
113	3.5355e-002	3.5355e-002	1.8e-002	3.2091e-011
114	3.5355e-002	3.5355e-002	1.7e-002	3.1069e-011
115	3.5355e-002	3.5355e-002	1.6e-002	2.9956e-011
116	3.5355e-002	3.5355e-002	1.5e-002	2.8673e-011
117	3.5355e-002	3.5355e-002	1.4e-002	2.721e-011
118	3.5355e-002	3.5355e-002	1.3e-002	-1.6748e-011
119	3.5355e-002	3.5355e-002	1.2e-002	-1.5313e-011
120	3.5355e-002	3.5355e-002	1.1e-002	7.6173e-011
121	3.5355e-002	3.5355e-002	1.e-002	2.1842e-010
122	3.5355e-002	3.5355e-002	9.e-003	1.1955e-010
123	3.5355e-002	3.5355e-002	8.e-003	-6.3725e-011
124	3.5355e-002	3.5355e-002	7.e-003	-2.4415e-010
125	3.5355e-002	3.5355e-002	6.e-003	-3.5482e-010
126	3.5355e-002	3.5355e-002	5.e-003	-8.5354e-011
127	3.5355e-002	3.5355e-002	4.e-003	-8.5011e-011
128	3.5355e-002	3.5355e-002	3.e-003	-3.3437e-010
129	3.5355e-002	3.5355e-002	2.e-003	-3.6019e-010
130	3.5355e-002	3.5355e-002	1.e-003	-2.6623e-010
131	-3.5355e-002	3.5355e-002	0.	4.0868e-010
132	3.4645e-002	3.6051e-002	0.	-6.8772e-011
133	3.3922e-002	3.6733e-002	0.	2.127e-010
134	3.3185e-002	3.74e-002	0.	7.4034e-011
135	3.2435e-002	3.8053e-002	0.	-8.6219e-011
136	3.1672e-002	3.869e-002	0.	-2.573e-012
137	3.0896e-002	3.9312e-002	0.	-1.9007e-011
138	3.0108e-002	3.9918e-002	0.	1.6623e-012
139	2.9309e-002	4.0509e-002	0.	-7.3171e-013
140	2.8498e-002	4.1084e-002	0.	-9.2116e-013
141	2.7675e-002	4.1642e-002	0.	-6.0259e-013
142	2.6842e-002	4.2184e-002	0.	-5.764e-013
143	2.5998e-002	4.271e-002	0.	-5.175e-013
144	2.5143e-002	4.3218e-002	0.	-5.6546e-013
145	2.4279e-002	4.371e-002	0.	-7.0718e-013
146	2.3405e-002	4.4184e-002	0.	-8.2689e-013
147	2.2522e-002	4.464e-002	0.	-9.2433e-013
148	2.163e-002	4.5079e-002	0.	-9.7618e-013
149	2.073e-002	4.55e-002	0.	-9.6834e-013
150	1.9821e-002	4.5904e-002	0.	-9.2612e-013
151	1.8904e-002	4.6289e-002	0.	-8.7697e-013
152	1.798e-002	4.6655e-002	0.	-8.2543e-013
153	1.7049e-002	4.7003e-002	0.	-7.7292e-013
154	1.6111e-002	4.7333e-002	0.	-7.2792e-013
155	1.5167e-002	4.7644e-002	0.	-7.1872e-013
156	1.4217e-002	4.7936e-002	0.	-7.452e-013
157	1.3261e-002	4.8209e-002	0.	-7.7062e-013
158	1.23e-002	4.8464e-002	0.	-7.8166e-013
159	1.1334e-002	4.8699e-002	0.	-8.1624e-013
160	1.0363e-002	4.8914e-002	0.	-8.9046e-013
161	9.3886e-003	4.9111e-002	0.	-9.3598e-013
162	8.4103e-003	4.9288e-002	0.	-9.6315e-013
163	7.4287e-003	4.9445e-002	0.	-1.0449e-012
164	6.4442e-003	4.9583e-002	0.	-1.1272e-012
165	5.4571e-003	4.9701e-002	0.	-1.1763e-012
166	4.4678e-003	4.98e-002	0.	-1.2583e-012
167	3.4768e-003	4.9879e-002	0.	-1.363e-012
168	2.4844e-003	4.9938e-002	0.	-1.4408e-012
169	1.491e-003	4.9978e-002	0.	-1.5612e-012
170	4.9708e-004	4.9998e-002	0.	-1.7378e-012
171	-4.9708e-004	4.9998e-002	0.	-1.8947e-012
172	-1.491e-003	4.9978e-002	0.	-2.0761e-012
173	-2.4844e-003	4.9938e-002	0.	-2.2868e-012
174	-3.4768e-003	4.9879e-002	0.	-2.5202e-012
175	-4.4678e-003	4.98e-002	0.	-2.819e-012
176	-5.4571e-003	4.9701e-002	0.	-3.1236e-012
177	-6.4442e-003	4.9583e-002	0.	-3.3974e-012
178	-7.4287e-003	4.9445e-002	0.	-3.7277e-012
179	-8.4103e-003	4.9288e-002	0.	-4.1214e-012
180	-9.3886e-003	4.9111e-002	0.	-4.5111e-012
181	-1.0363e-002	4.8914e-002	0.	-4.9077e-012
182	-1.1334e-002	4.8699e-002	0.	-5.3189e-012
183	-1.23e-002	4.8464e-002	0.	-5.7345e-012
184	-1.3261e-002	4.8209e-002	0.	-6.1687e-012
185	-1.4217e-002	4.7936e-002	0.	-6.6441e-012
186	-1.5167e-002	4.7644e-002	0.	-7.1691e-012
187	-1.6111e-002	4.7333e-002	0.	-7.7322e-012
188	-1.7049e-002	4.7003e-002	0.	-8.3248e-012
189	-1.798e-002	4.6655e-002	0.	-8.9164e-012
190	-1.8904e-002	4.6289e-002	0.	-9.455e-012
191	-1.9821e-002	4.5904e-002	0.	-9.8144e-012
192	-2.073e-002	4.55e-002	0.	-9.7884e-012
193	-2.163e-002	4.5079e-002	0.	-9.2448e-012
194	-2.2522e-002	4.464e-002	0.	-8.1346e-012
195	-2.3405e-002	4.4184e-002	0.	-6.6748e-012
196	-2.4279e-002	4.371e-002	0.	-5.0948e-012
197	-2.5143e-002	4.3218e-002	0.	-3.2737e-012
198	-2.5998e-002	4.271e-002	0.	-2.4399e-012
199	-2.6842e-002	4.2184e-002	0.	-2.4685e-012
200	-2.7675e-002	4.1642e-002	0.	-1.2949e-012
201	-2.8498e-002	4.1084e-002	0.	8.964e-013
202	-2.9309e-002	4.0509e-002	0.	5.2803e-012
203	-3.0108e-002	3.9918e-002	0.	1.1326e-011
204	-3.0896e-002	3.9312e-002	0.	1.6431e-011
205	-3.1672e-002	3.869e-002	0.	2.2891e-011
206	-3.2435e-002	3.8053e-002	0.	4.6249e-011
207	-3.3185e-002	3.74e-002	0.	-6.861e-011
208	-3.3922e-002	3.6733e-002	0.	-6.2953e-011
209	-3.4645e-002	3.6051e-002	0.	2.4271e-010
210	-3.5355e-002	3.5355e-002	1.e-003	3.9667e-010
211	-3.5355e-002	3.5355e-002	2.e-003	3.5927e-010
212	-3.5355e-002	3.5355e-002	3.e-003	1.7823e-010
213	-3.5355e-002	3.5355e-002	4.e-003	6.6057e-011
214	-3.5355e-002	3.5355e-002	5.e-003	1.2188e-010
215	-3.5355e-002	3.5355e-002	6.e-003	-2.2295e-011
216	-3.5355e-002	3.5355e-002	7.e-003	-7.8675e-011
217	-3.5355e-002	3.5355e-002	8.e-003	-6.1522e-012
218	-3.5355e-002	3.5355e-002	9.e-003	-2.1877e-011
219	-3.5355e-002	3.5355e-002	1.e-002	5.8209e-012
220	-3.5355e-002	3.5355e-002	1.1e-002	2.2964e-011
221	-3.5355e-002	3.5355e-002	1.2e-002	2.5644e-011
222	-3.5355e-002	3.5355e-002	1.3e-002	5.1877e-011
223	-3.5355e-002	3.5355e-002	1.4e-002	7.3487e-011
224	-3.5355e-002	3.5355e-002	1.5e-002	6.0484e-011
225	-3.5355e-002	3.5355e-002	1.6e-002	5.7565e-011
226	-3.5355e-002	3.5355e-002	1.7e-002	6.16e-011
227	-3.5355e-002	3.5355e-002	1.8e-002	5.4388e-011
228	-3.5355e-002	3.5355e-002	1.9e-002	4.3508e-011
229	-3.5355e-002	3.5355e-002	2.e-002	2.8674e-011
230	-3.5355e-002	3.5355e-002	2.1e-002	8.6345e-012
231	-3.5355e-002	3.5355e-002	2.2e-002	-1.5702e-011
232	-3.5355e-002	3.5355e-002	2.3e-002	-3.8644e-011
233	-3.5355e-002	3.5355e-002	2.4e-002	-5.3159e-011
234	-3.5355e-002	3.5355e-002	2.5e-002	-5.3316e-011
235	-3.5355e-002	3.5355e-002	2.6e-002	-3.6891e-011
236	-3.5355e-002	3.5355e-002	2.7e-002	-9.6765e-012
237	-3.5355e-002	3.5355e-002	2.8e-002	1.7691e-011
238	-3.5355e-002	3.5355e-002	2.9e-002	4.0265e-011
239	-3.5355e-002	3.5355e-002	3.e-002	5.5323e-011
240	-3.5355e-002	3.5355e-002	3.1e-002	6.2854e-011
241	-3.5355e-002	3.5355e-002	3.2e-002	6.5806e-011
242	-3.5355e-002	3.5355e-002	3.3e-002	6.4412e-011
243	-3.5355e-002	3.5355e-002	3.4e-002	5.5662e-011
244	-3.5355e-002	3.5355e-002	3.5e-002	4.4294e-011
245	-3.5355e-002	3.5355e-002	3.6e-002	4.081e-011
246	-3.5355e-002	3.5355e-002	3.7e-002	3.131e-011
247	-3.5355e-002	3.5355e-002	3.8e-002	1.6046e-011
248	-3.5355e-002	3.5355e-002	3.9e-002	7.0672e-012
249	-3.5355e-002	3.5355e-002	4.e-002	-9.6754e-012
250	-3.5355e-002	3.5355e-002	4.1e-002	-1.4776e-011
251	-3.5355e-002	3.5355e-002	4.2e-002	4.482e-012
252	-3.5355e-002	3.5355e-002	4.3e-002	-3.1637e-011
253	-3.5355e-002	3.5355e-002	4.4e-002	-5.1948e-011
254	-3.5355e-002	3.5355e-002	4.5e-002	-2.7484e-010
255	-3.5355e-002	3.5355e-002	4.6e-002	-2.1521e-010
256	-3.5355e-002	3.5355e-002	4.7e-002	1.0721e-010
257	-3.5355e-002	3.5355e-002	4.8e-002	-6.1525e-011
258	-3.5355e-002	3.5355e-002	4.9e-002	-2.5005e-010
259	3.4641e-002	3.6055e-002	4.e-003	-1.1488e-010
260	-3.4641e-002	3.6055e-002	2.e-003	2.3885e-010
261	3.4641e-002	3.6055e-002	4.8e-002	1.8451e-010
262	-2.8498e-002	4.1084e-002	4.8e-002	-6.8068e-012
263	-2.6842e-002	4.2184e-002	4.8e-002	-1.7021e-011
264	-2.5143e-002	4.3218e-002	4.8e-002	-2.5278e-011
265	-2.3405e-002	4.4184e-002	4.8e-002	-2.724e-011
266	-2.163e-002	4.5079e-002	4.8e-002	-2.4658e-011
267	-1.9821e-002	4.5904e-002	4.8e-002	-2.0637e-011
268	-1.798e-002	4.6655e-002	4.8e-002	-1.7325e-011
269	-1.6111e-002	4.7333e-002	4.8e-002	-1.5202e-011
270	-1.4217e-002	4.7936e-002	4.8e-002	-1.3937e-011
271	-1.23e-002	4.8464e-002	4.8e-002	-1.2988e-011
272	-1.0363e-002	4.8914e-002	4.8e-002	-1.2098e-011
273	-8.4103e-003	4.9288e-002	4.8e-002	-1.1054e-011
274	-6.4442e-003	4.9583e-002	4.8e-002	-9.851e-012
275	-4.4678e-003	4.98e-002	4.8e-002	-8.5813e-012
276	-2.4844e-003	4.9938e-002	4.8e-002	-7.3229e-012
277	-4.9707e-004	4.9998e-002	4.8e-002	-6.0687e-012
278	1.491e-003	4.9978e-002	4.8e-002	-4.9136e-012
279	3.4768e-003	4.9879e-002	4.8e-002	-3.8131e-012
280	5.4571e-003	4.9701e-002	4.8e-002	-2.91e-012
281	7.4287e-003	4.9445e-002	4.8e-002	-2.0844e-012
282	9.3886e-003	4.9111e-002	4.8e-002	-1.4193e-012
283	1.1334e-002	4.8699e-002	4.8e-002	-9.264e-013
284	1.3261e-002	4.8209e-002	4.8e-002	-5.4327e-013
285	1.5167e-002	4.7644e-002	4.8e-002	-2.4455e-013
286	1.7049e-002	4.7003e-002	4.8e-002	-6.0518e-014
287	1.8904e-002	4.6289e-002	4.8e-002	9.7761e-014
288	2.073e-002	4.55e-002	4.8e-002	2.9493e-013
289	2.2522e-002	4.464e-002	4.8e-002	5.5527e-013
290	2.4279e-002	4.371e-002	4.8e-002	9.774e-013
291	2.5998e-002	4.271e-002	4.8e-002	1.6651e-012
292	2.7675e-002	4.1642e-002	4.8e-002	2.5195e-012
293	2.9309e-002	4.0509e-002	4.8e-002	5.3392e-012
294	3.0896e-002	3.9312e-002	4.8e-002	8.9541e-012
295	-3.1672e-002	3.869e-002	2.e-003	3.6667e-011
296	-3.3185e-002	3.74e-002	4.7e-002	2.1032e-010
297	-3.0896e-002	3.9312e-002	4.e-003	6.2219e-011
298	3.2433e-002	3.8054e-002	6.e-003	-1.497e-011
299	-3.0108e-002	3.9919e-002	4.6e-002	-2.082e-011
300	-2.6842e-002	4.2184e-002	4.6e-002	-2.5398e-011
301	2.9309e-002	4.0509e-002	4.6e-002	2.4386e-013
302	2.4279e-002	4.371e-002	4.e-003	-2.341e-012
303	2.2522e-002	4.464e-002	4.e-003	-2.87e-012
304	2.073e-002	4.55e-002	4.e-003	-2.8434e-012
305	1.8904e-002	4.6289e-002	4.e-003	-2.7696e-012
306	1.7049e-002	4.7003e-002	4.e-003	-2.8322e-012
307	1.5167e-002	4.7644e-002	4.e-003	-3.0219e-012
308	1.3261e-002	4.8209e-002	4.e-003	-3.3046e-012
309	1.1334e-002	4.8699e-002	4.e-003	-3.7002e-012
310	9.3886e-003	4.9111e-002	4.e-003	-4.1902e-012
311	7.4288e-003	4.9445e-002	4.e-003	-4.8053e-012
312	5.4571e-003	4.9701e-002	4.e-003	-5.5234e-012
313	3.4768e-003	4.9879e-002	4.e-003	-6.4494e-012
314	1.4911e-003	4.9978e-002	4.e-003	-7.5943e-012
315	-4.9703e-004	4.9998e-002	4.e-003	-9.0642e-012
316	-2.4844e-003	4.9938e-002	4.e-003	-1.0923e-011
317	-4.4678e-003	4.98e-002	4.e-003	-1.3214e-011
318	-6.4441e-003	4.9583e-002	4.e-003	-1.5944e-011
319	-8.4103e-003	4.9288e-002	4.e-003	-1.8933e-011
320	-1.0363e-002	4.8914e-002	4.e-003	-2.1935e-011
321	-1.23e-002	4.8464e-002	4.e-003	-2.4513e-011
322	-1.4217e-002	4.7936e-002	4.e-003	-2.6223e-011
323	-1.6111e-002	4.7333e-002	4.e-003	-2.6549e-011
324	-1.798e-002	4.6655e-002	4.e-003	-2.5155e-011
325	-1.9821e-002	4.5904e-002	4.e-003	-2.1666e-011
326	-2.163e-002	4.5079e-002	4.e-003	-1.5235e-011
327	-2.3405e-002	4.4184e-002	4.e-003	-6.5076e-012
328	-2.5143e-002	4.3218e-002	4.e-003	1.0878e-011
329	-2.6842e-002	4.2184e-002	4.e-003	3.4787e-011
330	-2.8498e-002	4.1084e-002	4.e-003	9.2205e-011
331	-3.0108e-002	3.9919e-002	4.e-003	7.2348e-011
332	3.2435e-002	3.8053e-002	4.2e-002	2.4227e-012
333	-3.2435e-002	3.8053e-002	8.e-003	-3.1804e-010
334	-3.0896e-002	3.9312e-002	5.e-003	1.0801e-010
335	3.1671e-002	3.869e-002	3.8e-002	2.8763e-012
336	3.1671e-002	3.869e-002	3.6e-002	3.4668e-012
337	3.1671e-002	3.869e-002	3.4e-002	4.5091e-012
338	3.1671e-002	3.869e-002	3.2e-002	5.1492e-012
339	3.1671e-002	3.869e-002	3.e-002	5.6073e-012
340	3.1671e-002	3.869e-002	2.8e-002	5.9819e-012
341	3.1671e-002	3.869e-002	2.6e-002	6.3587e-012
342	3.1671e-002	3.869e-002	2.4e-002	6.6182e-012
343	3.1671e-002	3.869e-002	2.2e-002	6.7945e-012
344	3.1671e-002	3.869e-002	2.e-002	6.9781e-012
345	3.1671e-002	3.869e-002	1.8e-002	7.3878e-012
346	3.1671e-002	3.869e-002	1.6e-002	8.1471e-012
347	3.1671e-002	3.8691e-002	1.4e-002	9.2976e-012
348	-3.1648e-002	3.8709e-002	1.1989e-002	-2.7152e-010
349	-3.1662e-002	3.8698e-002	1.3993e-002	-1.6511e-010
350	-3.1667e-002	3.8694e-002	1.5998e-002	2.7529e-011
351	-3.1671e-002	3.869e-002	1.8e-002	2.8748e-010
352	-3.1671e-002	3.869e-002	2.e-002	3.3979e-010
353	-3.1671e-002	3.869e-002	2.2e-002	-1.5431e-010
354	-3.1671e-002	3.869e-002	2.4e-002	-5.8223e-010
355	-3.1671e-002	3.869e-002	2.6e-002	-4.3743e-010
356	-3.1671e-002	3.869e-002	2.8e-002	-6.6612e-011
357	-3.1671e-002	3.8691e-002	3.e-002	4.811e-011
358	-3.1671e-002	3.8691e-002	3.2e-002	1.1137e-010
359	-3.1671e-002	3.8691e-002	3.4e-002	8.9714e-012
360	-3.167e-002	3.8691e-002	3.6e-002	1.8102e-010
361	-3.1662e-002	3.8698e-002	3.8e-002	8.4952e-011
362	-3.1661e-002	3.8698e-002	3.9999e-002	-1.8073e-010
363	-3.167e-002	3.8691e-002	4.2e-002	9.0381e-011
364	-3.0882e-002	3.9323e-002	3.9997e-002	-9.3819e-011
365	-2.7675e-002	4.1642e-002	4.3e-002	9.0591e-011
366	2.9309e-002	4.0509e-002	3.1e-002	-4.6619e-012
367	2.9309e-002	4.0509e-002	2.9e-002	-4.9296e-012
368	2.9309e-002	4.0509e-002	2.7e-002	-5.3826e-012
369	2.9309e-002	4.0509e-002	2.5e-002	-5.9293e-012
370	2.9309e-002	4.0509e-002	2.3e-002	-6.6784e-012
371	2.9309e-002	4.0509e-002	2.1e-002	-7.5012e-012
372	2.9309e-002	4.0509e-002	1.9e-002	-8.1081e-012
373	2.9309e-002	4.0509e-002	1.7e-002	-8.3699e-012
374	2.9309e-002	4.0509e-002	1.5e-002	-8.5101e-012
375	-2.9282e-002	4.0528e-002	1.6991e-002	-4.6145e-010
376	-2.933e-002	4.0494e-002	1.8993e-002	-4.5576e-010
377	-2.9371e-002	4.0464e-002	2.1007e-002	-1.5408e-010
378	-2.9362e-002	4.0471e-002	2.3027e-002	1.547e-010
379	-2.9318e-002	4.0502e-002	2.5019e-002	3.408e-010
380	-2.9288e-002	4.0524e-002	2.6996e-002	2.4207e-010
381	-2.9289e-002	4.0523e-002	2.8996e-002	1.1927e-010
382	2.6842e-002	4.2184e-002	8.e-003	-8.1152e-012
383	2.5143e-002	4.3218e-002	8.e-003	1.0091e-012
384	2.3405e-002	4.4184e-002	8.e-003	3.663e-012
385	2.163e-002	4.5079e-002	8.e-003	1.9698e-012
386	1.9821e-002	4.5904e-002	8.e-003	2.3586e-013
387	1.798e-002	4.6655e-002	8.e-003	-1.0797e-012
388	1.6111e-002	4.7333e-002	8.e-003	-2.138e-012
389	1.4217e-002	4.7936e-002	8.e-003	-3.0368e-012
390	1.23e-002	4.8464e-002	8.e-003	-3.7709e-012
391	1.0363e-002	4.8914e-002	8.e-003	-4.4477e-012
392	8.4103e-003	4.9288e-002	8.e-003	-5.1329e-012
393	6.4442e-003	4.9583e-002	8.e-003	-5.8695e-012
394	4.4678e-003	4.98e-002	8.e-003	-6.6505e-012
395	2.4844e-003	4.9938e-002	8.e-003	-7.5287e-012
396	4.9708e-004	4.9998e-002	8.e-003	-8.5581e-012
397	-1.491e-003	4.9978e-002	8.e-003	-9.7368e-012
398	-3.4768e-003	4.9879e-002	8.e-003	-1.1165e-011
399	-5.4571e-003	4.9701e-002	8.e-003	-1.2933e-011
400	-7.4287e-003	4.9445e-002	8.e-003	-1.5046e-011
401	-9.3886e-003	4.9111e-002	8.e-003	-1.7226e-011
402	-1.1334e-002	4.8699e-002	8.e-003	-1.893e-011
403	-1.3261e-002	4.8209e-002	8.e-003	-1.9293e-011
404	-1.5167e-002	4.7644e-002	8.e-003	-1.7083e-011
405	-1.7049e-002	4.7003e-002	8.e-003	-1.091e-011
406	-1.8904e-002	4.6289e-002	8.e-003	7.3362e-013
407	-2.073e-002	4.55e-002	8.e-003	2.0299e-011
408	-2.2522e-002	4.464e-002	8.e-003	6.3609e-011
409	-2.4279e-002	4.371e-002	8.e-003	4.5502e-011
410	-2.5987e-002	4.2716e-002	7.9923e-003	9.5666e-011
411	-2.7627e-002	4.1674e-002	9.9688e-003	2.0817e-010
412	-2.7752e-002	4.1591e-002	2.0041e-002	-4.901e-010
413	-2.6933e-002	4.2126e-002	2.3051e-002	1.4471e-010
414	2.5143e-002	4.3218e-002	1.e-002	-9.7934e-012
415	2.5998e-002	4.271e-002	3.9e-002	-1.6017e-012
416	1.6111e-002	4.7333e-002	1.2e-002	-1.2188e-012
417	2.5997e-002	4.271e-002	3.5e-002	-2.3097e-012
418	2.4279e-002	4.371e-002	1.2e-002	-1.7081e-013
419	2.163e-002	4.5079e-002	3.7e-002	1.1446e-012
420	-2.522e-002	4.3174e-002	2.0056e-002	-1.0604e-010
421	1.7049e-002	4.7003e-002	1.4e-002	-1.7028e-012
422	1.5167e-002	4.7644e-002	1.4e-002	-1.4215e-012
423	-2.4309e-002	4.3693e-002	2.4013e-002	8.1221e-011
424	2.2522e-002	4.464e-002	1.7e-002	3.618e-011
425	-2.163e-002	4.5079e-002	1.5e-002	2.0495e-012
426	-2.3405e-002	4.4184e-002	1.7e-002	2.4695e-011
427	-2.2522e-002	4.464e-002	1.6e-002	2.4075e-011
428	2.2522e-002	4.464e-002	2.5e-002	3.0225e-013
429	2.163e-002	4.5079e-002	2.1e-002	-8.0984e-013
430	-2.163e-002	4.5079e-002	2.9e-002	4.5794e-012
431	1.9821e-002	4.5903e-002	1.7e-002	-1.4257e-013
432	-1.9821e-002	4.5904e-002	1.7e-002	5.3137e-011
433	-2.163e-002	4.5079e-002	2.5e-002	9.2478e-011
434	-2.073e-002	4.55e-002	3.2e-002	-3.1483e-011
435	-1.8904e-002	4.6289e-002	1.8e-002	5.87e-011
436	1.6111e-002	4.7333e-002	1.8e-002	7.7188e-013
437	2.073e-002	4.55e-002	2.9e-002	1.5179e-012
438	2.073e-002	4.55e-002	2.7e-002	1.3006e-012
439	1.798e-002	4.6655e-002	1.9e-002	-3.4019e-013
440	1.8904e-002	4.6289e-002	2.1e-002	5.8597e-011
441	1.8904e-002	4.6289e-002	2.6e-002	9.8279e-013
442	9.3887e-003	4.9111e-002	2.1e-002	4.2529e-012
443	1.798e-002	4.6655e-002	2.3e-002	-2.3298e-012
444	1.7049e-002	4.7003e-002	2.1e-002	1.0885e-012
445	-9.3888e-003	4.9111e-002	2.8e-002	3.7918e-011
446	-7.4289e-003	4.9445e-002	2.8e-002	3.6839e-011
447	3.4769e-003	4.9879e-002	2.2e-002	1.0029e-011
448	1.4911e-003	4.9978e-002	2.2e-002	1.4222e-011
449	-4.9702e-004	4.9998e-002	2.2e-002	1.7121e-011
450	-2.4844e-003	4.9938e-002	2.2e-002	2.1261e-011
451	-4.4678e-003	4.98e-002	2.2e-002	2.6155e-011
452	-6.4441e-003	4.9583e-002	2.2e-002	4.244e-011
453	-8.4103e-003	4.9288e-002	2.2e-002	-1.5622e-011
454	-1.0363e-002	4.8914e-002	2.2e-002	8.1512e-011
455	-1.23e-002	4.8464e-002	2.2e-002	6.5771e-011
456	-1.4217e-002	4.7936e-002	2.8e-002	8.4092e-011
457	1.1334e-002	4.8699e-002	2.2e-002	2.355e-012
458	8.4104e-003	4.9288e-002	2.3e-002	6.1008e-012
459	-1.1342e-002	4.8697e-002	2.6005e-002	7.6703e-011
460	-1.3261e-002	4.8209e-002	2.4e-002	7.2291e-011
461	-1.2313e-002	4.846e-002	2.5013e-002	1.2615e-011
462	4.972e-004	4.9998e-002	2.5e-002	1.6857e-011
463	6.4443e-003	4.9583e-002	2.5e-002	-3.2313e-010
464	-3.4645e-002	3.6051e-002	4.9e-002	-2.0269e-010
465	-3.3922e-002	3.6733e-002	4.9e-002	2.5252e-011
466	-3.3185e-002	3.74e-002	4.9e-002	1.2592e-010
467	-3.2435e-002	3.8053e-002	4.9e-002	1.9231e-012
468	-3.1672e-002	3.869e-002	4.9e-002	-2.6024e-011
469	-3.0896e-002	3.9312e-002	4.9e-002	-1.3438e-012
470	-3.0108e-002	3.9918e-002	4.9e-002	2.8517e-012
471	-2.9309e-002	4.0509e-002	4.9e-002	4.2894e-013
472	-2.8498e-002	4.1084e-002	4.9e-002	-2.4222e-012
473	-2.7675e-002	4.1642e-002	4.9e-002	-7.9674e-012
474	-2.6842e-002	4.2184e-002	4.9e-002	-1.0089e-011
475	-2.5998e-002	4.271e-002	4.9e-002	-1.2707e-011
476	-2.5143e-002	4.3218e-002	4.9e-002	-1.4914e-011
477	-2.4279e-002	4.371e-002	4.9e-002	-1.6095e-011
478	-2.3405e-002	4.4184e-002	4.9e-002	-1.643e-011
479	-2.2522e-002	4.464e-002	4.9e-002	-1.5955e-011
480	-2.163e-002	4.5079e-002	4.9e-002	-1.494e-011
481	-2.073e-002	4.55e-002	4.9e-002	-1.3663e-011
482	-1.9821e-002	4.5904e-002	4.9e-002	-1.2344e-011
483	-1.8904e-002	4.6289e-002	4.9e-002	-1.1134e-011
484	-1.798e-002	4.6655e-002	4.9e-002	-1.012e-011
485	-1.7049e-002	4.7003e-002	4.9e-002	-9.3142e-012
486	-1.6111e-002	4.7333e-002	4.9e-002	-8.6934e-012
487	-1.5167e-002	4.7644e-002	4.9e-002	-8.2252e-012
488	-1.4217e-002	4.7936e-002	4.9e-002	-7.8638e-012
489	-1.3261e-002	4.8209e-002	4.9e-002	-7.5547e-012
490	-1.23e-002	4.8464e-002	4.9e-002	-7.2615e-012
491	-1.1334e-002	4.8699e-002	4.9e-002	-6.9906e-012
492	-1.0363e-002	4.8914e-002	4.9e-002	-6.7393e-012
493	-9.3886e-003	4.9111e-002	4.9e-002	-6.4435e-012
494	-8.4103e-003	4.9288e-002	4.9e-002	-6.1142e-012
495	-7.4287e-003	4.9445e-002	4.9e-002	-5.7991e-012
496	-6.4442e-003	4.9583e-002	4.9e-002	-5.455e-012
497	-5.4571e-003	4.9701e-002	4.9e-002	-5.0841e-012
498	-4.4678e-003	4.98e-002	4.9e-002	-4.7531e-012
499	-3.4768e-003	4.9879e-002	4.9e-002	-4.4205e-012
500	-2.4844e-003	4.9938e-002	4.9e-002	-4.0429e-012
501	-1.491e-003	4.9978e-002	4.9e-002	-3.689e-012
502	-4.9708e-004	4.9998e-002	4.9e-002	-3.3586e-012
503	4.9709e-004	4.9998e-002	4.9e-002	-3.0337e-012
504	1.491e-003	4.9978e-002	4.9e-002	-2.7304e-012
505	2.4844e-003	4.9938e-002	4.9e-002	-2.4187e-012
506	3.4768e-003	4.9879e-002	4.9e-002	-2.1183e-012
507	4.4678e-003	4.98e-002	4.9e-002	-1.8571e-012
508	5.4571e-003	4.9701e-002	4.9e-002	-1.6283e-012
509	6.4442e-003	4.9583e-002	4.9e-002	-1.3848e-012
510	7.4287e-003	4.9445e-002	4.9e-002	-1.1616e-012
511	8.4103e-003	4.9288e-002	4.9e-002	-9.9471e-013
512	9.3886e-003	4.9111e-002	4.9e-002	-8.1746e-013
513	1.0363e-002	4.8914e-002	4.9e-002	-6.6659e-013
514	1.1334e-002	4.8699e-002	4.9e-002	-5.5205e-013
515	1.23e-002	4.8464e-002	4.9e-002	-4.3407e-013
516	1.3261e-002	4.8209e-002	4.9e-002	-3.3319e-013
517	1.4217e-002	4.7936e-002	4.9e-002	-2.4159e-013
518	1.5167e-002	4.7644e-002	4.9e-002	-1.7502e-013
519	1.6111e-002	4.7333e-002	4.9e-002	-1.3123e-013
520	1.7049e-002	4.7003e-002	4.9e-002	-7.2574e-014
521	1.798e-002	4.6655e-002	4.9e-002	-1.8196e-014
522	1.8904e-002	4.6289e-002	4.9e-002	2.5937e-014
523	1.9821e-002	4.5904e-002	4.9e-002	8.3743e-014
524	2.073e-002	4.55e-002	4.9e-002	1.4577e-013
525	2.163e-002	4.5079e-002	4.9e-002	2.1043e-013
526	2.2522e-002	4.464e-002	4.9e-002	2.9954e-013
527	2.3405e-002	4.4184e-002	4.9e-002	4.2017e-013
528	2.4279e-002	4.371e-002	4.9e-002	5.7074e-013
529	2.5143e-002	4.3218e-002	4.9e-002	7.7789e-013
530	2.5998e-002	4.271e-002	4.9e-002	1.0005e-012
531	2.6842e-002	4.2184e-002	4.9e-002	1.5175e-012
532	2.7675e-002	4.1642e-002	4.9e-002	1.6548e-012
533	2.8498e-002	4.1084e-002	4.9e-002	2.6748e-012
534	2.9309e-002	4.0509e-002	4.9e-002	4.3015e-012
535	3.0108e-002	3.9918e-002	4.9e-002	3.2983e-012
536	3.0896e-002	3.9312e-002	4.9e-002	1.0253e-011
537	3.1672e-002	3.869e-002	4.9e-002	6.6991e-012
538	3.2435e-002	3.8053e-002	4.9e-002	4.0446e-011
539	3.3185e-002	3.74e-002	4.9e-002	-7.4918e-011
540	3.3922e-002	3.6733e-002	4.9e-002	-8.9075e-011
541	3.4645e-002	3.6051e-002	4.9e-002	2.0636e-010
542	3.4641e-002	3.6055e-002	4.7e-002	9.0767e-011
543	3.4641e-002	3.6055e-002	4.6e-002	2.3749e-011
544	3.4641e-002	3.6055e-002	4.5e-002	5.1485e-011
545	3.4641e-002	3.6055e-002	4.4e-002	-1.5806e-011
546	3.4641e-002	3.6055e-002	4.3e-002	-4.0541e-011
547	3.4641e-002	3.6055e-002	4.2e-002	2.2328e-011
548	3.4641e-002	3.6055e-002	4.1e-002	2.8845e-011
549	3.4641e-002	3.6055e-002	4.e-002	3.1344e-011
550	3.4641e-002	3.6055e-002	3.9e-002	3.0552e-011
551	3.4641e-002	3.6055e-002	3.8e-002	2.9441e-011
552	3.4641e-002	3.6055e-002	3.7e-002	2.861e-011
553	3.4641e-002	3.6055e-002	3.6e-002	2.7943e-011
554	3.4641e-002	3.6055e-002	3.5e-002	2.7476e-011
555	3.4641e-002	3.6055e-002	3.4e-002	2.71e-011
556	3.4641e-002	3.6055e-002	3.3e-002	2.6818e-011
557	3.4641e-002	3.6055e-002	3.2e-002	2.6599e-011
558	3.4641e-002	3.6055e-002	3.1e-002	2.6433e-011
559	3.4641e-002	3.6055e-002	3.e-002	2.6292e-011
560	3.4641e-002	3.6055e-002	2.9e-002	2.618e-011
561	3.4641e-002	3.6055e-002	2.8e-002	2.6091e-011
562	3.4641e-002	3.6055e-002	2.7e-002	2.5996e-011
563	3.4641e-002	3.6055e-002	2.6e-002	2.5907e-011
564	3.4641e-002	3.6055e-002	2.5e-002	2.5825e-011
565	3.4641e-002	3.6055e-002	2.4e-002	2.5728e-011
566	3.4641e-002	3.6055e-002	2.3e-002	2.5625e-011
567	3.4641e-002	3.6055e-002	2.2e-002	2.5522e-011
568	3.4641e-002	3.6055e-002	2.1e-002	2.5412e-011
569	3.4641e-002	3.6055e-002	2.e-002	2.5307e-011
570	3.4641e-002	3.6055e-002	1.9e-002	2.5185e-011
571	3.4641e-002	3.6055e-002	1.8e-002	2.5036e-011
572	3.4641e-002	3.6055e-002	1.7e-002	2.4861e-011
573	3.4641e-002	3.6055e-002	1.6e-002	2.4606e-011
574	3.4641e-002	3.6055e-002	1.5e-002	2.4205e-011
575	3.4641e-002	3.6055e-002	1.4e-002	2.3572e-011
576	3.4641e-002	3.6055e-002	1.3e-002	1.5017e-012
577	3.4641e-002	3.6055e-002	1.2e-002	2.0079e-012
578	3.4641e-002	3.6055e-002	1.1e-002	4.7308e-011
579	3.4641e-002	3.6055e-002	1.e-002	1.1756e-010
580	3.4641e-002	3.6055e-002	9.e-003	6.7155e-011
581	3.4641e-002	3.6055e-002	8.e-003	-2.6342e-011
582	3.4641e-002	3.6055e-002	7.e-003	-1.1773e-010
583	3.4641e-002	3.6055e-002	6.e-003	-1.6483e-010
584	3.4641e-002	3.6055e-002	5.e-003	-4.5647e-011
585	3.4641e-002	3.6055e-002	3.e-003	-3.1091e-010
586	3.4641e-002	3.6055e-002	2.e-003	-3.3309e-010
587	3.4641e-002	3.6055e-002	9.9999e-004	-1.8408e-010
588	3.3922e-002	3.6733e-002	9.9999e-004	1.5244e-010
589	3.3185e-002	3.74e-002	1.e-003	1.7355e-010
590	3.2435e-002	3.8053e-002	1.e-003	-6.1007e-011
591	3.1672e-002	3.869e-002	1.e-003	-3.2608e-011
592	3.0896e-002	3.9312e-002	9.9999e-004	-1.4835e-013
593	3.0108e-002	3.9918e-002	1.e-003	2.341e-013
594	2.9309e-002	4.0509e-002	9.9999e-004	-1.6462e-012
595	2.8498e-002	4.1084e-002	1.e-003	-7.0875e-013
596	2.7675e-002	4.1642e-002	9.9999e-004	-9.1908e-013
597	2.6842e-002	4.2184e-002	1.e-003	-8.2057e-013
598	2.5998e-002	4.271e-002	9.9999e-004	-7.3149e-013
599	2.5143e-002	4.3218e-002	1.e-003	-8.8767e-013
600	2.4279e-002	4.371e-002	9.9999e-004	-1.1106e-012
601	2.3405e-002	4.4184e-002	1.e-003	-1.368e-012
602	2.2522e-002	4.464e-002	9.9999e-004	-1.545e-012
603	2.163e-002	4.5079e-002	1.e-003	-1.6147e-012
604	2.073e-002	4.55e-002	9.9999e-004	-1.6085e-012
605	1.9821e-002	4.5904e-002	1.e-003	-1.5428e-012
606	1.8904e-002	4.6289e-002	9.9999e-004	-1.452e-012
607	1.798e-002	4.6655e-002	1.e-003	-1.3677e-012
608	1.7049e-002	4.7003e-002	9.9999e-004	-1.3084e-012
609	1.6111e-002	4.7333e-002	1.e-003	-1.2703e-012
610	1.5167e-002	4.7644e-002	9.9999e-004	-1.2679e-012
611	1.4217e-002	4.7936e-002	1.e-003	-1.2827e-012
612	1.3261e-002	4.8209e-002	9.9999e-004	-1.308e-012
613	1.23e-002	4.8464e-002	1.e-003	-1.3343e-012
614	1.1334e-002	4.8699e-002	9.9999e-004	-1.3994e-012
615	1.0363e-002	4.8914e-002	1.e-003	-1.5032e-012
616	9.3886e-003	4.9111e-002	9.9999e-004	-1.5815e-012
617	8.4103e-003	4.9288e-002	1.e-003	-1.6508e-012
618	7.4287e-003	4.9445e-002	9.9999e-004	-1.7838e-012
619	6.4442e-003	4.9583e-002	1.e-003	-1.9077e-012
620	5.4571e-003	4.9701e-002	9.9999e-004	-2.0167e-012
621	4.4678e-003	4.98e-002	1.e-003	-2.1787e-012
622	3.4768e-003	4.9879e-002	9.9999e-004	-2.3746e-012
623	2.4844e-003	4.9938e-002	1.e-003	-2.5462e-012
624	1.491e-003	4.9978e-002	9.9999e-004	-2.768e-012
625	4.9708e-004	4.9998e-002	1.e-003	-3.0434e-012
626	-4.9708e-004	4.9998e-002	9.9999e-004	-3.3286e-012
627	-1.491e-003	4.9978e-002	1.e-003	-3.663e-012
628	-2.4844e-003	4.9938e-002	9.9999e-004	-4.047e-012
629	-3.4768e-003	4.9879e-002	1.e-003	-4.457e-012
630	-4.4678e-003	4.98e-002	9.9999e-004	-4.9491e-012
631	-5.4571e-003	4.9701e-002	1.e-003	-5.485e-012
632	-6.4442e-003	4.9583e-002	9.9999e-004	-6.0314e-012
633	-7.4287e-003	4.9445e-002	1.e-003	-6.6322e-012
634	-8.4103e-003	4.9288e-002	9.9999e-004	-7.2997e-012
635	-9.3886e-003	4.9111e-002	1.e-003	-7.9553e-012
636	-1.0363e-002	4.8914e-002	9.9999e-004	-8.6288e-012
637	-1.1334e-002	4.8699e-002	1.e-003	-9.348e-012
638	-1.23e-002	4.8464e-002	9.9999e-004	-1.0077e-011
639	-1.3261e-002	4.8209e-002	1.e-003	-1.0789e-011
640	-1.4217e-002	4.7936e-002	9.9999e-004	-1.1527e-011
641	-1.5167e-002	4.7644e-002	1.e-003	-1.2317e-011
642	-1.6111e-002	4.7333e-002	9.9999e-004	-1.3153e-011
643	-1.7049e-002	4.7003e-002	1.e-003	-1.3995e-011
644	-1.798e-002	4.6655e-002	9.9999e-004	-1.4805e-011
645	-1.8904e-002	4.6289e-002	1.e-003	-1.5462e-011
646	-1.9821e-002	4.5904e-002	9.9999e-004	-1.5763e-011
647	-2.073e-002	4.55e-002	1.e-003	-1.5441e-011
648	-2.163e-002	4.5079e-002	9.9999e-004	-1.4223e-011
649	-2.2522e-002	4.464e-002	1.e-003	-1.2052e-011
650	-2.3405e-002	4.4184e-002	9.9999e-004	-9.2354e-012
651	-2.4279e-002	4.371e-002	1.e-003	-6.4225e-012
652	-2.5143e-002	4.3218e-002	9.9999e-004	-3.9789e-012
653	-2.5998e-002	4.271e-002	1.e-003	-1.4194e-012
654	-2.6842e-002	4.2184e-002	9.9999e-004	-5.0369e-013
655	-2.7675e-002	4.1642e-002	1.e-003	-7.2442e-013
656	-2.8498e-002	4.1084e-002	9.9999e-004	3.7657e-012
657	-2.9309e-002	4.0509e-002	1.e-003	1.2152e-011
658	-3.0108e-002	3.9918e-002	9.9999e-004	1.8806e-011
659	-3.0896e-002	3.9312e-002	1.e-003	2.81e-011
660	-3.1672e-002	3.869e-002	9.9999e-004	2.7255e-011
661	-3.2435e-002	3.8053e-002	1.e-003	6.6627e-011
662	-3.3185e-002	3.74e-002	1.e-003	-4.6082e-011
663	-3.3922e-002	3.6733e-002	1.e-003	-5.4514e-011
664	-3.4645e-002	3.6051e-002	1.e-003	2.4672e-010
665	-3.4641e-002	3.6055e-002	3.e-003	1.5056e-010
666	-3.4641e-002	3.6055e-002	4.e-003	8.0933e-011
667	-3.4641e-002	3.6055e-002	5.e-003	9.1752e-011
668	-3.4641e-002	3.6055e-002	6.e-003	-1.664e-012
669	-3.4641e-002	3.6055e-002	7.e-003	-4.6493e-011
670	-3.4641e-002	3.6055e-002	8.e-003	1.4581e-011
671	-3.4641e-002	3.6055e-002	9.e-003	1.8122e-011
672	-3.4641e-002	3.6055e-002	1.e-002	5.8439e-012
673	-3.4641e-002	3.6055e-002	1.1e-002	-1.606e-012
674	-3.4641e-002	3.6055e-002	1.2e-002	-3.6539e-012
675	-3.4641e-002	3.6055e-002	1.3e-002	-1.8916e-011
676	-3.4641e-002	3.6055e-002	1.4e-002	-1.2967e-011
677	-3.4641e-002	3.6055e-002	1.5e-002	3.6443e-011
678	-3.4641e-002	3.6055e-002	1.6e-002	6.3647e-011
679	-3.4641e-002	3.6055e-002	1.7e-002	5.0133e-011
680	-3.4641e-002	3.6055e-002	1.8e-002	3.6319e-011
681	-3.4641e-002	3.6055e-002	1.9e-002	2.9477e-011
682	-3.4641e-002	3.6055e-002	2.e-002	1.6835e-011
683	-3.4641e-002	3.6055e-002	2.1e-002	-3.716e-012
684	-3.4641e-002	3.6055e-002	2.2e-002	-2.863e-011
685	-3.4641e-002	3.6055e-002	2.3e-002	-5.3181e-011
686	-3.4641e-002	3.6055e-002	2.4e-002	-6.8161e-011
687	-3.4641e-002	3.6055e-002	2.5e-002	-6.5452e-011
688	-3.4641e-002	3.6055e-002	2.6e-002	-4.644e-011
689	-3.4641e-002	3.6055e-002	2.7e-002	-1.7223e-011
690	-3.4641e-002	3.6055e-002	2.8e-002	1.501e-011
691	-3.4641e-002	3.6055e-002	2.9e-002	3.996e-011
692	-3.4641e-002	3.6055e-002	3.e-002	5.5447e-011
693	-3.4641e-002	3.6055e-002	3.1e-002	6.3851e-011
694	-3.4641e-002	3.6055e-002	3.2e-002	6.476e-011
695	-3.4641e-002	3.6055e-002	3.3e-002	6.2214e-011
696	-3.4641e-002	3.6055e-002	3.4e-002	6.0184e-011
697	-3.4641e-002	3.6055e-002	3.5e-002	4.8286e-011
698	-3.4641e-002	3.6055e-002	3.6e-002	2.3765e-011
699	-3.4641e-002	3.6055e-002	3.7e-002	1.625e-011
700	-3.4641e-002	3.6055e-002	3.8e-002	1.9098e-011
701	-3.4641e-002	3.6055e-002	3.9e-002	8.9796e-012
702	-3.4641e-002	3.6055e-002	4.e-002	7.8872e-012
703	-3.4641e-002	3.6055e-002	4.1e-002	6.605e-012
704	-3.4641e-002	3.6055e-002	4.2e-002	-2.4991e-012
705	-3.4641e-002	3.6055e-002	4.3e-002	-9.7643e-012
706	-3.4641e-002	3.6055e-002	4.4e-002	-7.998e-012
707	-3.4641e-002	3.6055e-002	4.5e-002	-1.7216e-010
708	-3.4641e-002	3.6055e-002	4.6e-002	-2.4937e-010
709	-3.4641e-002	3.6055e-002	4.7e-002	-1.2746e-010
710	-3.4641e-002	3.6055e-002	4.8e-002	-1.591e-010
711	3.3922e-002	3.6733e-002	2.e-003	5.3601e-012
712	3.3185e-002	3.74e-002	2.e-003	2.316e-010
713	3.2435e-002	3.8053e-002	2.e-003	-1.3906e-011
714	3.1672e-002	3.869e-002	2.e-003	-4.0341e-011
715	3.0896e-002	3.9312e-002	2.e-003	3.733e-011
716	3.0108e-002	3.9918e-002	2.e-003	-6.8783e-012
717	2.9309e-002	4.0509e-002	2.e-003	2.0658e-012
718	2.8498e-002	4.1084e-002	2.e-003	-1.2915e-012
719	2.7675e-002	4.1642e-002	2.e-003	-1.0924e-012
720	2.6842e-002	4.2184e-002	2.e-003	-8.5848e-013
721	2.5998e-002	4.271e-002	2.e-003	-9.1005e-013
722	2.5143e-002	4.3218e-002	2.e-003	-1.3026e-012
723	2.4279e-002	4.371e-002	2.e-003	-1.7655e-012
724	2.3405e-002	4.4184e-002	2.e-003	-2.2839e-012
725	2.2522e-002	4.464e-002	2.e-003	-2.5232e-012
726	2.163e-002	4.5079e-002	2.e-003	-2.6084e-012
727	2.073e-002	4.55e-002	2.e-003	-2.5968e-012
728	1.9821e-002	4.5904e-002	2.e-003	-2.4987e-012
729	1.8904e-002	4.6289e-002	2.e-003	-2.3779e-012
730	1.798e-002	4.6655e-002	2.e-003	-2.2676e-012
731	1.7049e-002	4.7003e-002	2.e-003	-2.2052e-012
732	1.6111e-002	4.7333e-002	2.e-003	-2.1794e-012
733	1.5167e-002	4.7644e-002	2.e-003	-2.1936e-012
734	1.4217e-002	4.7936e-002	2.e-003	-2.2136e-012
735	1.3261e-002	4.8209e-002	2.e-003	-2.2636e-012
736	1.23e-002	4.8464e-002	2.e-003	-2.3313e-012
737	1.1334e-002	4.8699e-002	2.e-003	-2.4549e-012
738	1.0363e-002	4.8914e-002	2.e-003	-2.6037e-012
739	9.3886e-003	4.9111e-002	2.e-003	-2.7537e-012
740	8.4103e-003	4.9288e-002	2.e-003	-2.9061e-012
741	7.4287e-003	4.9445e-002	2.e-003	-3.115e-012
742	6.4441e-003	4.9583e-002	2.e-003	-3.3247e-012
743	5.4571e-003	4.9701e-002	2.e-003	-3.5638e-012
744	4.4678e-003	4.98e-002	2.e-003	-3.8556e-012
745	3.4768e-003	4.9879e-002	2.e-003	-4.1956e-012
746	2.4844e-003	4.9938e-002	2.e-003	-4.5339e-012
747	1.491e-003	4.9978e-002	2.e-003	-4.937e-012
748	4.9706e-004	4.9998e-002	2.e-003	-5.3905e-012
749	-4.9709e-004	4.9998e-002	2.e-003	-5.9181e-012
750	-1.4911e-003	4.9978e-002	2.e-003	-6.5092e-012
751	-2.4844e-003	4.9938e-002	2.e-003	-7.1742e-012
752	-3.4768e-003	4.9879e-002	2.e-003	-7.9064e-012
753	-4.4678e-003	4.98e-002	2.e-003	-8.7517e-012
754	-5.4571e-003	4.9701e-002	2.e-003	-9.6731e-012
755	-6.4442e-003	4.9583e-002	2.e-003	-1.0666e-011
756	-7.4287e-003	4.9445e-002	2.e-003	-1.1716e-011
757	-8.4103e-003	4.9288e-002	2.e-003	-1.2841e-011
758	-9.3886e-003	4.9111e-002	2.e-003	-1.3957e-011
759	-1.0363e-002	4.8914e-002	2.e-003	-1.5105e-011
760	-1.1334e-002	4.8699e-002	2.e-003	-1.6285e-011
761	-1.23e-002	4.8464e-002	2.e-003	-1.7444e-011
762	-1.3261e-002	4.8209e-002	2.e-003	-1.8544e-011
763	-1.4217e-002	4.7936e-002	2.e-003	-1.9626e-011
764	-1.5167e-002	4.7644e-002	2.e-003	-2.0689e-011
765	-1.6111e-002	4.7333e-002	2.e-003	-2.1755e-011
766	-1.7049e-002	4.7003e-002	2.e-003	-2.2744e-011
767	-1.798e-002	4.6655e-002	2.e-003	-2.3593e-011
768	-1.8904e-002	4.6289e-002	2.e-003	-2.4133e-011
769	-1.9821e-002	4.5904e-002	2.e-003	-2.41e-011
770	-2.073e-002	4.55e-002	2.e-003	-2.3124e-011
771	-2.163e-002	4.5079e-002	2.e-003	-2.0881e-011
772	-2.2522e-002	4.464e-002	2.e-003	-1.7007e-011
773	-2.3405e-002	4.4184e-002	2.e-003	-1.1989e-011
774	-2.4279e-002	4.371e-002	2.e-003	-7.1884e-012
775	-2.5143e-002	4.3218e-002	2.e-003	-3.925e-012
776	-2.5998e-002	4.271e-002	2.e-003	3.0166e-014
777	-2.6842e-002	4.2184e-002	2.e-003	6.9701e-012
778	-2.7675e-002	4.1642e-002	2.e-003	1.1978e-011
779	-2.8498e-002	4.1084e-002	2.e-003	1.4695e-011
780	-2.9309e-002	4.0509e-002	2.e-003	2.1062e-011
781	-3.0108e-002	3.9918e-002	2.e-003	3.2616e-011
782	-3.0896e-002	3.9312e-002	2.e-003	4.4292e-011
783	-3.2435e-002	3.8053e-002	2.e-003	7.4925e-011
784	-3.3185e-002	3.74e-002	2.e-003	-2.7855e-011
785	-3.3922e-002	3.6733e-002	2.e-003	-3.1435e-011
786	-3.3922e-002	3.6733e-002	3.e-003	2.4905e-011
787	-3.3922e-002	3.6733e-002	4.e-003	6.1062e-011
788	-3.3922e-002	3.6733e-002	5.e-003	4.7583e-011
789	-3.3922e-002	3.6733e-002	6.e-003	2.0331e-011
790	-3.3922e-002	3.6733e-002	7.e-003	-5.5885e-012
791	-3.3922e-002	3.6733e-002	8.e-003	-4.6528e-011
792	-3.3922e-002	3.6733e-002	9.e-003	-9.2438e-011
793	-3.3922e-002	3.6733e-002	1.e-002	-1.3209e-010
794	-3.3922e-002	3.6733e-002	1.1e-002	-9.5235e-011
795	-3.3922e-002	3.6733e-002	1.2e-002	-8.6684e-012
796	-3.3922e-002	3.6733e-002	1.3e-002	2.2793e-011
797	-3.3922e-002	3.6733e-002	1.4e-002	5.3716e-011
798	-3.3922e-002	3.6733e-002	1.5e-002	5.8079e-011
799	-3.3922e-002	3.6733e-002	1.6e-002	7.1815e-012
800	-3.3922e-002	3.6733e-002	1.7e-002	-6.4127e-012
801	-3.3922e-002	3.6733e-002	1.8e-002	2.0077e-011
802	-3.3922e-002	3.6733e-002	1.9e-002	1.8304e-011
803	-3.3922e-002	3.6733e-002	2.e-002	1.2217e-012
804	-3.3922e-002	3.6733e-002	2.1e-002	-2.3093e-011
805	-3.3922e-002	3.6733e-002	2.2e-002	-5.7413e-011
806	-3.3922e-002	3.6733e-002	2.3e-002	-9.5979e-011
807	-3.3922e-002	3.6733e-002	2.4e-002	-1.2548e-010
808	-3.3922e-002	3.6733e-002	2.5e-002	-1.2993e-010
809	-3.3921e-002	3.6733e-002	2.6e-002	-9.6617e-011
810	-3.3921e-002	3.6733e-002	2.7e-002	-4.3676e-011
811	-3.3921e-002	3.6733e-002	2.8e-002	-3.0102e-012
812	-3.3921e-002	3.6733e-002	2.9e-002	2.3243e-011
813	-3.3921e-002	3.6733e-002	3.e-002	3.6968e-011
814	-3.3921e-002	3.6733e-002	3.1e-002	4.1755e-011
815	-3.3921e-002	3.6734e-002	3.2e-002	4.9128e-011
816	-3.3921e-002	3.6734e-002	3.3e-002	4.6056e-011
817	-3.3921e-002	3.6734e-002	3.4e-002	2.4538e-011
818	-3.3921e-002	3.6734e-002	3.5e-002	2.3365e-011
819	-3.3921e-002	3.6734e-002	3.6e-002	5.5854e-011
820	-3.3921e-002	3.6734e-002	3.7e-002	5.4757e-011
821	-3.3921e-002	3.6734e-002	3.8e-002	2.0148e-011
822	-3.3921e-002	3.6734e-002	3.9e-002	-2.2324e-011
823	-3.3921e-002	3.6734e-002	4.e-002	-9.5629e-011
824	-3.3921e-002	3.6734e-002	4.1e-002	-1.0158e-010
825	-3.3921e-002	3.6734e-002	4.2e-002	-1.552e-011
826	-3.392e-002	3.6734e-002	4.3e-002	1.6596e-011
827	-3.392e-002	3.6734e-002	4.4e-002	-3.7583e-012
828	-3.392e-002	3.6734e-002	4.5e-002	1.9092e-012
829	-3.392e-002	3.6735e-002	4.6e-002	-1.5401e-011
830	-3.392e-002	3.6735e-002	4.7e-002	-1.1558e-011
831	-3.392e-002	3.6735e-002	4.8e-002	2.687e-011
832	-3.3185e-002	3.74e-002	4.8e-002	1.8554e-010
833	-3.2435e-002	3.8053e-002	4.8e-002	-3.4931e-011
834	-3.1672e-002	3.869e-002	4.8e-002	-3.8534e-011
835	-3.0896e-002	3.9312e-002	4.8e-002	2.3283e-011
836	-3.0108e-002	3.9918e-002	4.8e-002	-3.4102e-012
837	-2.9309e-002	4.0509e-002	4.8e-002	9.6612e-013
838	-2.7675e-002	4.1642e-002	4.8e-002	-1.571e-011
839	-2.5998e-002	4.271e-002	4.8e-002	-2.1154e-011
840	-2.4279e-002	4.371e-002	4.8e-002	-2.6766e-011
841	-2.2522e-002	4.464e-002	4.8e-002	-2.6333e-011
842	-2.073e-002	4.55e-002	4.8e-002	-2.2647e-011
843	-1.8904e-002	4.6289e-002	4.8e-002	-1.8837e-011
844	-1.7049e-002	4.7003e-002	4.8e-002	-1.6129e-011
845	-1.5167e-002	4.7644e-002	4.8e-002	-1.45e-011
846	-1.3261e-002	4.8209e-002	4.8e-002	-1.3453e-011
847	-1.1334e-002	4.8699e-002	4.8e-002	-1.255e-011
848	-9.3886e-003	4.9111e-002	4.8e-002	-1.1608e-011
849	-7.4287e-003	4.9445e-002	4.8e-002	-1.0479e-011
850	-5.4571e-003	4.9701e-002	4.8e-002	-9.2032e-012
851	-3.4768e-003	4.9879e-002	4.8e-002	-7.9744e-012
852	-1.491e-003	4.9978e-002	4.8e-002	-6.6878e-012
853	4.971e-004	4.9998e-002	4.8e-002	-5.4858e-012
854	2.4844e-003	4.9938e-002	4.8e-002	-4.3558e-012
855	4.4678e-003	4.98e-002	4.8e-002	-3.3445e-012
856	6.4442e-003	4.9583e-002	4.8e-002	-2.4822e-012
857	8.4103e-003	4.9288e-002	4.8e-002	-1.7522e-012
858	1.0363e-002	4.8914e-002	4.8e-002	-1.1435e-012
859	1.23e-002	4.8464e-002	4.8e-002	-7.3487e-013
860	1.4217e-002	4.7936e-002	4.8e-002	-3.7867e-013
861	1.6111e-002	4.7333e-002	4.8e-002	-1.5165e-013
862	1.798e-002	4.6655e-002	4.8e-002	1.343e-014
863	1.9821e-002	4.5904e-002	4.8e-002	1.899e-013
864	2.163e-002	4.5079e-002	4.8e-002	4.0698e-013
865	2.3405e-002	4.4184e-002	4.8e-002	7.368e-013
866	2.5143e-002	4.3218e-002	4.8e-002	1.2467e-012
867	2.6842e-002	4.2184e-002	4.8e-002	2.1868e-012
868	2.8498e-002	4.1084e-002	4.8e-002	3.7088e-012
869	3.0108e-002	3.9918e-002	4.8e-002	4.425e-012
870	3.1672e-002	3.869e-002	4.8e-002	-1.0654e-012
871	3.2435e-002	3.8053e-002	4.8e-002	3.0943e-011
872	3.3185e-002	3.74e-002	4.8e-002	-7.4368e-011
873	3.3922e-002	3.6733e-002	4.8e-002	-8.3279e-011
874	3.3922e-002	3.6733e-002	4.7e-002	-3.4831e-011
875	3.3922e-002	3.6733e-002	4.6e-002	6.1146e-012
876	3.3922e-002	3.6733e-002	4.5e-002	6.3822e-012
877	3.3922e-002	3.6733e-002	4.4e-002	5.1378e-012
878	3.3922e-002	3.6733e-002	4.3e-002	5.3317e-012
879	3.3922e-002	3.6733e-002	4.2e-002	4.7957e-012
880	3.3922e-002	3.6733e-002	4.1e-002	3.7163e-012
881	3.3922e-002	3.6733e-002	4.e-002	2.6368e-012
882	3.3922e-002	3.6733e-002	3.9e-002	1.9106e-012
883	3.3922e-002	3.6733e-002	3.8e-002	1.2856e-012
884	3.3922e-002	3.6733e-002	3.7e-002	8.3386e-013
885	3.3922e-002	3.6733e-002	3.6e-002	6.0178e-013
886	3.3922e-002	3.6733e-002	3.5e-002	3.9016e-013
887	3.3922e-002	3.6733e-002	3.4e-002	2.6912e-013
888	3.3922e-002	3.6733e-002	3.3e-002	2.0855e-013
889	3.3922e-002	3.6733e-002	3.2e-002	2.1054e-013
890	3.3922e-002	3.6733e-002	3.1e-002	2.5837e-013
891	3.3922e-002	3.6733e-002	3.e-002	3.2384e-013
892	3.3922e-002	3.6733e-002	2.9e-002	4.1695e-013
893	3.3922e-002	3.6733e-002	2.8e-002	5.2979e-013
894	3.3922e-002	3.6733e-002	2.7e-002	6.3912e-013
895	3.3922e-002	3.6733e-002	2.6e-002	7.5116e-013
896	3.3922e-002	3.6733e-002	2.5e-002	8.6314e-013
897	3.3922e-002	3.6733e-002	2.4e-002	9.6031e-013
898	3.3922e-002	3.6733e-002	2.3e-002	1.0515e-012
899	3.3922e-002	3.6733e-002	2.2e-002	1.1274e-012
900	3.3922e-002	3.6733e-002	2.1e-002	1.1875e-012
901	3.3922e-002	3.6733e-002	2.e-002	1.2694e-012
902	3.3922e-002	3.6733e-002	1.9e-002	1.362e-012
903	3.3922e-002	3.6733e-002	1.8e-002	1.4416e-012
904	3.3921e-002	3.6733e-002	1.7e-002	1.5278e-012
905	3.3921e-002	3.6733e-002	1.6e-002	1.5646e-012
906	3.3921e-002	3.6733e-002	1.5e-002	1.5052e-012
907	3.3921e-002	3.6733e-002	1.4e-002	1.2095e-012
908	3.3921e-002	3.6733e-002	1.3e-002	5.9493e-013
909	3.3921e-002	3.6734e-002	1.2e-002	-2.0888e-013
910	3.3921e-002	3.6734e-002	1.1e-002	-1.0037e-012
911	3.3921e-002	3.6734e-002	1.e-002	-2.4735e-012
912	3.3921e-002	3.6734e-002	9.0001e-003	-4.5346e-012
913	3.3921e-002	3.6734e-002	8.0001e-003	-4.3983e-012
914	3.3921e-002	3.6734e-002	7.0001e-003	-1.0462e-011
915	3.3921e-002	3.6734e-002	6.0001e-003	-1.3719e-011
916	3.3921e-002	3.6734e-002	5.0001e-003	-6.367e-012
917	3.3921e-002	3.6734e-002	4.0001e-003	-1.4622e-011
918	3.3921e-002	3.6734e-002	3.0001e-003	-5.3849e-011
919	-3.2435e-002	3.8053e-002	4.7e-002	-8.2671e-011
920	-3.1672e-002	3.869e-002	4.7e-002	-3.7311e-011
921	-3.0896e-002	3.9312e-002	4.7e-002	6.8128e-011
922	-3.0108e-002	3.9919e-002	4.7e-002	-1.4089e-011
923	-2.9309e-002	4.0509e-002	4.7e-002	-5.5296e-012
924	-2.8498e-002	4.1084e-002	4.7e-002	-1.8345e-011
925	-2.7675e-002	4.1642e-002	4.7e-002	-2.0124e-011
926	-2.6842e-002	4.2184e-002	4.7e-002	-2.239e-011
927	-2.5998e-002	4.271e-002	4.7e-002	-2.6744e-011
928	-2.5143e-002	4.3218e-002	4.7e-002	-3.1931e-011
929	-2.4279e-002	4.371e-002	4.7e-002	-3.3073e-011
930	-2.3405e-002	4.4184e-002	4.7e-002	-3.3115e-011
931	-2.2522e-002	4.464e-002	4.7e-002	-3.1565e-011
932	-2.163e-002	4.5079e-002	4.7e-002	-2.942e-011
933	-2.073e-002	4.55e-002	4.7e-002	-2.7122e-011
934	-1.9821e-002	4.5904e-002	4.7e-002	-2.4968e-011
935	-1.8904e-002	4.6289e-002	4.7e-002	-2.3127e-011
936	-1.798e-002	4.6655e-002	4.7e-002	-2.1624e-011
937	-1.7049e-002	4.7003e-002	4.7e-002	-2.0475e-011
938	-1.6111e-002	4.7333e-002	4.7e-002	-1.9597e-011
939	-1.5167e-002	4.7644e-002	4.7e-002	-1.8931e-011
940	-1.4217e-002	4.7936e-002	4.7e-002	-1.8369e-011
941	-1.3261e-002	4.8209e-002	4.7e-002	-1.7869e-011
942	-1.23e-002	4.8464e-002	4.7e-002	-1.7358e-011
943	-1.1334e-002	4.8699e-002	4.7e-002	-1.6837e-011
944	-1.0363e-002	4.8914e-002	4.7e-002	-1.6255e-011
945	-9.3886e-003	4.9111e-002	4.7e-002	-1.5622e-011
946	-8.4103e-003	4.9288e-002	4.7e-002	-1.4905e-011
947	-7.4287e-003	4.9445e-002	4.7e-002	-1.4153e-011
948	-6.4441e-003	4.9583e-002	4.7e-002	-1.3338e-011
949	-5.4571e-003	4.9701e-002	4.7e-002	-1.2502e-011
950	-4.4678e-003	4.98e-002	4.7e-002	-1.1645e-011
951	-3.4768e-003	4.9879e-002	4.7e-002	-1.0798e-011
952	-2.4844e-003	4.9938e-002	4.7e-002	-9.9262e-012
953	-1.4911e-003	4.9978e-002	4.7e-002	-9.0763e-012
954	-4.9706e-004	4.9998e-002	4.7e-002	-8.2345e-012
955	4.9706e-004	4.9998e-002	4.7e-002	-7.4355e-012
956	1.4911e-003	4.9978e-002	4.7e-002	-6.643e-012
957	2.4844e-003	4.9938e-002	4.7e-002	-5.8875e-012
958	3.4768e-003	4.9879e-002	4.7e-002	-5.1611e-012
959	4.4678e-003	4.98e-002	4.7e-002	-4.522e-012
960	5.4571e-003	4.9701e-002	4.7e-002	-3.906e-012
961	6.4441e-003	4.9583e-002	4.7e-002	-3.3277e-012
962	7.4287e-003	4.9445e-002	4.7e-002	-2.7843e-012
963	8.4103e-003	4.9288e-002	4.7e-002	-2.3176e-012
964	9.3886e-003	4.9111e-002	4.7e-002	-1.8779e-012
965	1.0363e-002	4.8914e-002	4.7e-002	-1.5031e-012
966	1.1334e-002	4.8699e-002	4.7e-002	-1.1894e-012
967	1.23e-002	4.8464e-002	4.7e-002	-9.1998e-013
968	1.3261e-002	4.8209e-002	4.7e-002	-6.5558e-013
969	1.4217e-002	4.7936e-002	4.7e-002	-4.5956e-013
970	1.5167e-002	4.7644e-002	4.7e-002	-2.8734e-013
971	1.6111e-002	4.7333e-002	4.7e-002	-1.4737e-013
972	1.7049e-002	4.7003e-002	4.7e-002	-2.6566e-014
973	1.798e-002	4.6655e-002	4.7e-002	6.9852e-014
974	1.8904e-002	4.6289e-002	4.7e-002	1.8422e-013
975	1.9821e-002	4.5904e-002	4.7e-002	2.8357e-013
976	2.073e-002	4.55e-002	4.7e-002	4.0673e-013
977	2.163e-002	4.5079e-002	4.7e-002	5.4425e-013
978	2.2522e-002	4.464e-002	4.7e-002	7.0978e-013
979	2.3405e-002	4.4184e-002	4.7e-002	8.981e-013
980	2.4279e-002	4.371e-002	4.7e-002	1.147e-012
981	2.5143e-002	4.3218e-002	4.7e-002	1.3425e-012
982	2.5998e-002	4.271e-002	4.7e-002	1.8108e-012
983	2.6842e-002	4.2184e-002	4.7e-002	1.8808e-012
984	2.7675e-002	4.1642e-002	4.7e-002	2.2465e-012
985	2.8498e-002	4.1084e-002	4.7e-002	3.0784e-012
986	2.9309e-002	4.0509e-002	4.7e-002	3.3627e-012
987	3.0108e-002	3.9918e-002	4.7e-002	2.6102e-012
988	3.0896e-002	3.9312e-002	4.7e-002	-4.837e-013
989	3.1672e-002	3.869e-002	4.7e-002	-6.34e-012
990	3.2435e-002	3.8053e-002	4.7e-002	-8.1857e-012
991	3.3185e-002	3.74e-002	4.7e-002	-6.8038e-011
992	3.3185e-002	3.74e-002	4.6e-002	-2.7176e-011
993	3.3185e-002	3.74e-002	4.5e-002	-2.4564e-012
994	3.3185e-002	3.74e-002	4.4e-002	1.7612e-013
995	3.3185e-002	3.74e-002	4.3e-002	9.1411e-013
996	3.3185e-002	3.74e-002	4.2e-002	-1.5553e-013
997	3.3185e-002	3.74e-002	4.1e-002	3.1591e-013
998	3.3185e-002	3.74e-002	4.e-002	1.1869e-012
999	3.3185e-002	3.74e-002	3.9e-002	1.1941e-012
1000	3.3185e-002	3.74e-002	3.8e-002	5.6094e-013
1001	3.3185e-002	3.74e-002	3.7e-002	-4.3546e-013
1002	3.3185e-002	3.74e-002	3.6e-002	-1.6456e-012
1003	3.3185e-002	3.74e-002	3.5e-002	-2.6786e-012
1004	3.3185e-002	3.74e-002	3.4e-002	-3.5214e-012
1005	3.3185e-002	3.74e-002	3.3e-002	-4.3948e-012
1006	3.3185e-002	3.74e-002	3.2e-002	-5.2298e-012
1007	3.3185e-002	3.74e-002	3.1e-002	-6.0419e-012
1008	3.3185e-002	3.74e-002	3.e-002	-6.8453e-012
1009	3.3185e-002	3.74e-002	2.9e-002	-7.6198e-012
1010	3.3185e-002	3.74e-002	2.8e-002	-8.3949e-012
1011	3.3185e-002	3.74e-002	2.7e-002	-9.1647e-012
1012	3.3185e-002	3.74e-002	2.6e-002	-9.9269e-012
1013	3.3185e-002	3.74e-002	2.5e-002	-1.0703e-011
1014	3.3185e-002	3.74e-002	2.4e-002	-1.1494e-011
1015	3.3185e-002	3.74e-002	2.3e-002	-1.2309e-011
1016	3.3185e-002	3.74e-002	2.2e-002	-1.3139e-011
1017	3.3185e-002	3.74e-002	2.1e-002	-1.3957e-011
1018	3.3185e-002	3.74e-002	2.e-002	-1.4759e-011
1019	3.3185e-002	3.74e-002	1.9e-002	-1.5541e-011
1020	3.3186e-002	3.7399e-002	1.8e-002	-1.6297e-011
1021	3.3186e-002	3.7399e-002	1.7e-002	-1.7014e-011
1022	3.3186e-002	3.7399e-002	1.6e-002	-1.7734e-011
1023	3.3186e-002	3.7399e-002	1.5e-002	-1.8501e-011
1024	3.3186e-002	3.7399e-002	1.4e-002	-1.9347e-011
1025	3.3186e-002	3.7399e-002	1.3e-002	-2.0377e-011
1026	3.3186e-002	3.7399e-002	1.2e-002	-2.1937e-011
1027	3.3186e-002	3.7399e-002	1.1e-002	-2.4114e-011
1028	3.3186e-002	3.7399e-002	1.e-002	-2.557e-011
1029	3.3186e-002	3.7399e-002	8.9999e-003	-2.8376e-011
1030	3.3186e-002	3.7399e-002	7.9999e-003	-2.9714e-011
1031	3.3187e-002	3.7399e-002	6.9999e-003	-1.7319e-011
1032	3.3187e-002	3.7398e-002	5.9999e-003	-1.3074e-012
1033	3.3187e-002	3.7398e-002	4.9999e-003	2.1402e-011
1034	3.3187e-002	3.7398e-002	3.9999e-003	7.6949e-011
1035	3.3187e-002	3.7398e-002	3.e-003	1.5241e-010
1036	3.2435e-002	3.8053e-002	3.e-003	-2.1568e-011
1037	3.1672e-002	3.869e-002	3.e-003	-7.0569e-012
1038	3.0896e-002	3.9312e-002	3.e-003	6.1423e-011
1039	3.0108e-002	3.9918e-002	3.e-003	-6.804e-012
1040	2.9309e-002	4.0509e-002	3.e-003	4.4789e-012
1041	2.8498e-002	4.1084e-002	3.e-003	-3.7178e-012
1042	2.7675e-002	4.1642e-002	3.e-003	5.7737e-013
1043	2.6842e-002	4.2184e-002	3.e-003	-1.9645e-014
1044	2.5998e-002	4.271e-002	3.e-003	-6.2631e-013
1045	2.5143e-002	4.3218e-002	3.e-003	-1.3952e-012
1046	2.4279e-002	4.371e-002	3.e-003	-2.1558e-012
1047	2.3405e-002	4.4184e-002	3.e-003	-2.7676e-012
1048	2.2522e-002	4.464e-002	3.e-003	-2.9327e-012
1049	2.163e-002	4.5079e-002	3.e-003	-3.02e-012
1050	2.073e-002	4.55e-002	3.e-003	-2.9916e-012
1051	1.9821e-002	4.5904e-002	3.e-003	-2.8841e-012
1052	1.8904e-002	4.6289e-002	3.e-003	-2.7983e-012
1053	1.798e-002	4.6655e-002	3.e-003	-2.7312e-012
1054	1.7049e-002	4.7003e-002	3.e-003	-2.7027e-012
1055	1.6111e-002	4.7333e-002	3.e-003	-2.6947e-012
1056	1.5167e-002	4.7644e-002	3.e-003	-2.7464e-012
1057	1.4217e-002	4.7936e-002	3.e-003	-2.8113e-012
1058	1.3261e-002	4.8209e-002	3.e-003	-2.9131e-012
1059	1.23e-002	4.8464e-002	3.e-003	-3.0309e-012
1060	1.1334e-002	4.8699e-002	3.e-003	-3.2081e-012
1061	1.0363e-002	4.8914e-002	3.e-003	-3.3921e-012
1062	9.3886e-003	4.9111e-002	3.e-003	-3.607e-012
1063	8.4103e-003	4.9288e-002	3.e-003	-3.8293e-012
1064	7.4287e-003	4.9445e-002	3.e-003	-4.101e-012
1065	6.4442e-003	4.9583e-002	3.e-003	-4.3816e-012
1066	5.4571e-003	4.9701e-002	3.e-003	-4.7225e-012
1067	4.4678e-003	4.98e-002	3.e-003	-5.1022e-012
1068	3.4768e-003	4.9879e-002	3.e-003	-5.5355e-012
1069	2.4844e-003	4.9938e-002	3.e-003	-5.9831e-012
1070	1.491e-003	4.9978e-002	3.e-003	-6.5212e-012
1071	4.9708e-004	4.9998e-002	3.e-003	-7.114e-012
1072	-4.9707e-004	4.9998e-002	3.e-003	-7.8135e-012
1073	-1.491e-003	4.9978e-002	3.e-003	-8.5766e-012
1074	-2.4844e-003	4.9938e-002	3.e-003	-9.4426e-012
1075	-3.4768e-003	4.9879e-002	3.e-003	-1.0405e-011
1076	-4.4678e-003	4.98e-002	3.e-003	-1.15e-011
1077	-5.4571e-003	4.9701e-002	3.e-003	-1.2671e-011
1078	-6.4442e-003	4.9583e-002	3.e-003	-1.3935e-011
1079	-7.4287e-003	4.9445e-002	3.e-003	-1.5259e-011
1080	-8.4103e-003	4.9288e-002	3.e-003	-1.667e-011
1081	-9.3886e-003	4.9111e-002	3.e-003	-1.8075e-011
1082	-1.0363e-002	4.8914e-002	3.e-003	-1.9497e-011
1083	-1.1334e-002	4.8699e-002	3.e-003	-2.086e-011
1084	-1.23e-002	4.8464e-002	3.e-003	-2.2148e-011
1085	-1.3261e-002	4.8209e-002	3.e-003	-2.332e-011
1086	-1.4217e-002	4.7936e-002	3.e-003	-2.4375e-011
1087	-1.5167e-002	4.7644e-002	3.e-003	-2.525e-011
1088	-1.6111e-002	4.7333e-002	3.e-003	-2.5972e-011
1089	-1.7049e-002	4.7003e-002	3.e-003	-2.6463e-011
1090	-1.798e-002	4.6655e-002	3.e-003	-2.6671e-011
1091	-1.8904e-002	4.6289e-002	3.e-003	-2.6459e-011
1092	-1.9821e-002	4.5904e-002	3.e-003	-2.5674e-011
1093	-2.073e-002	4.55e-002	3.e-003	-2.3938e-011
1094	-2.163e-002	4.5079e-002	3.e-003	-2.0958e-011
1095	-2.2522e-002	4.464e-002	3.e-003	-1.679e-011
1096	-2.3405e-002	4.4184e-002	3.e-003	-1.0448e-011
1097	-2.4279e-002	4.371e-002	3.e-003	-3.7582e-012
1098	-2.5143e-002	4.3218e-002	3.e-003	-1.7965e-013
1099	-2.5998e-002	4.271e-002	3.e-003	-2.8285e-012
1100	-2.6842e-002	4.2184e-002	3.e-003	1.9083e-011
1101	-2.7675e-002	4.1642e-002	3.e-003	6.1775e-011
1102	-2.8498e-002	4.1084e-002	3.e-003	3.9687e-011
1103	-2.9309e-002	4.0509e-002	3.e-003	1.094e-011
1104	-3.0108e-002	3.9918e-002	3.e-003	4.8328e-011
1105	-3.0896e-002	3.9312e-002	3.e-003	6.0887e-011
1106	-3.1672e-002	3.869e-002	3.e-003	4.3679e-011
1107	-3.2435e-002	3.8053e-002	3.e-003	4.372e-011
1108	-3.3185e-002	3.74e-002	3.e-003	-1.3085e-011
1109	-3.3185e-002	3.74e-002	4.e-003	2.9707e-011
1110	-3.3185e-002	3.74e-002	5.e-003	1.2363e-011
1111	-3.3185e-002	3.74e-002	6.e-003	-8.3058e-011
1112	-3.3185e-002	3.74e-002	7.e-003	-2.093e-010
1113	-3.3185e-002	3.74e-002	8.e-003	-3.1989e-010
1114	-3.3185e-002	3.74e-002	9.e-003	-3.1102e-010
1115	-3.3185e-002	3.74e-002	1.e-002	-1.535e-010
1116	-3.3185e-002	3.74e-002	1.1e-002	4.9996e-012
1117	-3.3185e-002	3.74e-002	1.2e-002	7.9628e-011
1118	-3.3185e-002	3.74e-002	1.3e-002	1.5927e-010
1119	-3.3185e-002	3.74e-002	1.4e-002	1.8384e-010
1120	-3.3185e-002	3.74e-002	1.5e-002	1.0871e-010
1121	-3.3185e-002	3.74e-002	1.6e-002	4.05e-011
1122	-3.3185e-002	3.74e-002	1.7e-002	5.615e-012
1123	-3.3185e-002	3.74e-002	1.8e-002	-2.046e-011
1124	-3.3185e-002	3.74e-002	1.9e-002	-4.1878e-011
1125	-3.3185e-002	3.74e-002	2.e-002	-5.6096e-011
1126	-3.3185e-002	3.74e-002	2.1e-002	-6.6335e-011
1127	-3.3186e-002	3.7399e-002	2.2e-002	-8.5908e-011
1128	-3.3186e-002	3.7399e-002	2.3e-002	-1.0262e-010
1129	-3.3186e-002	3.7399e-002	2.4e-002	-1.0179e-010
1130	-3.3186e-002	3.7399e-002	2.5e-002	-8.1825e-011
1131	-3.3186e-002	3.7399e-002	2.6e-002	-7.0275e-011
1132	-3.3186e-002	3.7399e-002	2.7e-002	-6.0285e-011
1133	-3.3186e-002	3.7399e-002	2.8e-002	-2.4939e-011
1134	-3.3186e-002	3.7399e-002	2.9e-002	9.3307e-012
1135	-3.3186e-002	3.7399e-002	3.e-002	2.8671e-011
1136	-3.3186e-002	3.7399e-002	3.1e-002	2.7928e-011
1137	-3.3187e-002	3.7399e-002	3.2e-002	2.3329e-012
1138	-3.3187e-002	3.7398e-002	3.3e-002	7.166e-013
1139	-3.3187e-002	3.7398e-002	3.4e-002	1.343e-011
1140	-3.3187e-002	3.7398e-002	3.5e-002	-3.4812e-011
1141	-3.3187e-002	3.7398e-002	3.6e-002	-1.316e-010
1142	-3.3187e-002	3.7398e-002	3.7e-002	-1.5248e-010
1143	-3.3187e-002	3.7398e-002	3.8e-002	-8.0798e-011
1144	-3.3187e-002	3.7398e-002	3.9e-002	-1.6485e-011
1145	-3.3188e-002	3.7398e-002	4.e-002	2.1452e-011
1146	-3.3188e-002	3.7398e-002	4.1e-002	-1.0219e-012
1147	-3.3188e-002	3.7397e-002	4.2e-002	-7.3832e-011
1148	-3.3188e-002	3.7397e-002	4.3e-002	-8.285e-011
1149	-3.3188e-002	3.7397e-002	4.4e-002	2.115e-011
1150	-3.3188e-002	3.7397e-002	4.5e-002	1.2151e-010
1151	-3.3189e-002	3.7397e-002	4.6e-002	1.7594e-010
1152	3.2435e-002	3.8053e-002	4.6e-002	-2.3172e-011
1153	3.2435e-002	3.8053e-002	4.5e-002	-1.2084e-011
1154	3.2435e-002	3.8053e-002	4.4e-002	-2.7838e-012
1155	3.2435e-002	3.8053e-002	4.3e-002	6.3392e-013
1156	3.2434e-002	3.8053e-002	4.1e-002	4.3058e-012
1157	3.2434e-002	3.8053e-002	4.e-002	4.9959e-012
1158	3.2434e-002	3.8053e-002	3.9e-002	4.6313e-012
1159	3.2434e-002	3.8053e-002	3.8e-002	4.1506e-012
1160	3.2434e-002	3.8053e-002	3.7e-002	4.2375e-012
1161	3.2434e-002	3.8053e-002	3.6e-002	4.6685e-012
1162	3.2434e-002	3.8053e-002	3.5e-002	4.981e-012
1163	3.2434e-002	3.8053e-002	3.4e-002	5.1437e-012
1164	3.2434e-002	3.8053e-002	3.3e-002	5.2602e-012
1165	3.2434e-002	3.8053e-002	3.2e-002	5.3648e-012
1166	3.2434e-002	3.8053e-002	3.1e-002	5.4282e-012
1167	3.2434e-002	3.8053e-002	3.e-002	5.4956e-012
1168	3.2434e-002	3.8053e-002	2.9e-002	5.581e-012
1169	3.2434e-002	3.8053e-002	2.8e-002	5.6711e-012
1170	3.2434e-002	3.8053e-002	2.7e-002	5.7664e-012
1171	3.2434e-002	3.8053e-002	2.6e-002	5.8657e-012
1172	3.2434e-002	3.8053e-002	2.5e-002	5.9358e-012
1173	3.2434e-002	3.8053e-002	2.4e-002	5.9829e-012
1174	3.2434e-002	3.8053e-002	2.3e-002	6.0085e-012
1175	3.2434e-002	3.8053e-002	2.2e-002	6.0093e-012
1176	3.2434e-002	3.8053e-002	2.1e-002	6.0355e-012
1177	3.2434e-002	3.8053e-002	2.e-002	6.094e-012
1178	3.2434e-002	3.8053e-002	1.9e-002	6.1792e-012
1179	3.2434e-002	3.8053e-002	1.8e-002	6.3168e-012
1180	3.2434e-002	3.8053e-002	1.7e-002	6.5132e-012
1181	3.2433e-002	3.8054e-002	1.6e-002	6.7735e-012
1182	3.2433e-002	3.8054e-002	1.5e-002	7.0857e-012
1183	3.2433e-002	3.8054e-002	1.4e-002	7.3292e-012
1184	3.2433e-002	3.8054e-002	1.3e-002	7.2548e-012
1185	3.2433e-002	3.8054e-002	1.2e-002	6.5611e-012
1186	3.2433e-002	3.8054e-002	1.1e-002	4.587e-012
1187	3.2433e-002	3.8054e-002	1.e-002	2.6527e-012
1188	3.2433e-002	3.8054e-002	9.e-003	5.9779e-012
1189	3.2433e-002	3.8054e-002	8.e-003	4.9985e-012
1190	3.2433e-002	3.8054e-002	7.e-003	-3.1762e-012
1191	3.2433e-002	3.8054e-002	5.0001e-003	-2.8362e-011
1192	3.2433e-002	3.8054e-002	4.0001e-003	-4.2219e-011
1193	3.1672e-002	3.869e-002	4.e-003	-1.2711e-012
1194	3.0896e-002	3.9312e-002	4.e-003	7.3169e-011
1195	3.0108e-002	3.9918e-002	4.e-003	2.3629e-012
1196	2.9309e-002	4.0509e-002	4.e-003	-8.5333e-012
1197	2.8498e-002	4.1084e-002	4.e-003	4.5947e-012
1198	2.7675e-002	4.1642e-002	4.e-003	2.6441e-012
1199	2.6842e-002	4.2184e-002	4.e-003	6.5024e-013
1200	2.5998e-002	4.271e-002	4.e-003	-1.8271e-014
1201	2.5143e-002	4.3218e-002	4.e-003	-1.303e-012
1202	2.3405e-002	4.4184e-002	4.e-003	-2.7097e-012
1203	2.163e-002	4.5079e-002	4.e-003	-2.8853e-012
1204	1.9821e-002	4.5904e-002	4.e-003	-2.7828e-012
1205	1.798e-002	4.6655e-002	4.e-003	-2.7802e-012
1206	1.6111e-002	4.7333e-002	4.e-003	-2.9023e-012
1207	1.4217e-002	4.7936e-002	4.e-003	-3.1495e-012
1208	1.23e-002	4.8464e-002	4.e-003	-3.4844e-012
1209	1.0363e-002	4.8914e-002	4.e-003	-3.9205e-012
1210	8.4103e-003	4.9288e-002	4.e-003	-4.4765e-012
1211	6.4441e-003	4.9583e-002	4.e-003	-5.1346e-012
1212	4.4678e-003	4.98e-002	4.e-003	-5.9616e-012
1213	2.4844e-003	4.9938e-002	4.e-003	-6.9732e-012
1214	4.9706e-004	4.9998e-002	4.e-003	-8.2805e-012
1215	-1.4911e-003	4.9978e-002	4.e-003	-9.9298e-012
1216	-3.4768e-003	4.9879e-002	4.e-003	-1.2004e-011
1217	-5.4571e-003	4.9701e-002	4.e-003	-1.4532e-011
1218	-7.4287e-003	4.9445e-002	4.e-003	-1.7404e-011
1219	-9.3886e-003	4.9111e-002	4.e-003	-2.0448e-011
1220	-1.1334e-002	4.8699e-002	4.e-003	-2.3299e-011
1221	-1.3261e-002	4.8209e-002	4.e-003	-2.5505e-011
1222	-1.5167e-002	4.7644e-002	4.e-003	-2.6573e-011
1223	-1.7049e-002	4.7003e-002	4.e-003	-2.6085e-011
1224	-1.8904e-002	4.6289e-002	4.e-003	-2.3692e-011
1225	-2.073e-002	4.55e-002	4.e-003	-1.9012e-011
1226	-2.2522e-002	4.464e-002	4.e-003	-1.0299e-011
1227	-2.4279e-002	4.371e-002	4.e-003	7.4859e-013
1228	-2.5998e-002	4.271e-002	4.e-003	3.828e-012
1229	-2.7675e-002	4.1642e-002	4.e-003	1.21e-010
1230	-2.9309e-002	4.0509e-002	4.e-003	2.8123e-011
1231	-3.1672e-002	3.869e-002	4.e-003	3.2668e-011
1232	-3.2435e-002	3.8053e-002	4.e-003	4.0765e-011
1233	-3.2435e-002	3.8053e-002	5.e-003	1.6415e-011
1234	-3.2435e-002	3.8053e-002	6.e-003	-7.8666e-011
1235	-3.2435e-002	3.8053e-002	7.e-003	-2.4226e-010
1236	-3.2428e-002	3.8058e-002	9.001e-003	-2.1458e-010
1237	-3.2427e-002	3.8059e-002	1.e-002	-7.8584e-011
1238	-3.2426e-002	3.806e-002	1.0999e-002	-3.1562e-011
1239	-3.2428e-002	3.8058e-002	1.1996e-002	-2.6801e-011
1240	-3.2427e-002	3.8059e-002	1.2996e-002	2.2273e-012
1241	-3.2434e-002	3.8053e-002	1.4e-002	-1.0189e-012
1242	-3.2434e-002	3.8053e-002	1.5e-002	3.0529e-011
1243	-3.2434e-002	3.8053e-002	1.6e-002	1.5748e-010
1244	-3.2434e-002	3.8053e-002	1.7e-002	2.04e-010
1245	-3.2434e-002	3.8053e-002	1.8e-002	1.3474e-010
1246	-3.2434e-002	3.8053e-002	1.9e-002	6.5019e-011
1247	-3.2434e-002	3.8053e-002	2.e-002	2.2865e-011
1248	-3.2434e-002	3.8053e-002	2.1e-002	3.8178e-012
1249	-3.2434e-002	3.8053e-002	2.2e-002	-3.6777e-011
1250	-3.2434e-002	3.8053e-002	2.3e-002	-1.6403e-010
1251	-3.2434e-002	3.8053e-002	2.4e-002	-2.7769e-010
1252	-3.2434e-002	3.8053e-002	2.5e-002	-2.9444e-010
1253	-3.2434e-002	3.8053e-002	2.6e-002	-2.2657e-010
1254	-3.2434e-002	3.8053e-002	2.7e-002	-1.2469e-010
1255	-3.2434e-002	3.8053e-002	2.8e-002	-4.7364e-011
1256	-3.2434e-002	3.8053e-002	2.9e-002	1.8239e-011
1257	-3.2434e-002	3.8053e-002	3.e-002	4.5403e-011
1258	-3.2434e-002	3.8053e-002	3.1e-002	3.0651e-011
1259	-3.2434e-002	3.8053e-002	3.2e-002	2.627e-011
1260	-3.2434e-002	3.8053e-002	3.3e-002	6.4318e-011
1261	-3.2434e-002	3.8053e-002	3.4e-002	4.0994e-011
1262	-3.2434e-002	3.8053e-002	3.5e-002	-6.5638e-011
1263	-3.2434e-002	3.8053e-002	3.6e-002	-1.6719e-010
1264	-3.2433e-002	3.8054e-002	3.7e-002	-1.314e-010
1265	-3.2433e-002	3.8054e-002	3.8e-002	-4.1372e-011
1266	-3.2433e-002	3.8054e-002	3.9e-002	-6.1451e-012
1267	-3.2433e-002	3.8054e-002	4.e-002	4.9863e-011
1268	-3.2433e-002	3.8054e-002	4.1e-002	1.0079e-010
1269	-3.2433e-002	3.8054e-002	4.2e-002	1.0911e-010
1270	-3.2433e-002	3.8054e-002	4.3e-002	1.1428e-010
1271	-3.2433e-002	3.8054e-002	4.4e-002	8.395e-011
1272	-3.2433e-002	3.8054e-002	4.5e-002	-3.0048e-011
1273	-3.2433e-002	3.8054e-002	4.6e-002	-1.0345e-010
1274	-3.1672e-002	3.869e-002	4.6e-002	-6.0971e-011
1275	-3.0896e-002	3.9312e-002	4.6e-002	1.0078e-010
1276	-2.9309e-002	4.0509e-002	4.6e-002	-3.912e-011
1277	-2.8498e-002	4.1084e-002	4.6e-002	-1.9882e-011
1278	-2.7675e-002	4.1642e-002	4.6e-002	-2.3317e-011
1279	-2.5998e-002	4.271e-002	4.6e-002	-2.9417e-011
1280	-2.5143e-002	4.3218e-002	4.6e-002	-3.4707e-011
1281	-2.4279e-002	4.371e-002	4.6e-002	-3.5146e-011
1282	-2.3405e-002	4.4184e-002	4.6e-002	-3.4032e-011
1283	-2.2522e-002	4.464e-002	4.6e-002	-3.1853e-011
1284	-2.163e-002	4.5079e-002	4.6e-002	-2.9561e-011
1285	-2.073e-002	4.55e-002	4.6e-002	-2.745e-011
1286	-1.9821e-002	4.5904e-002	4.6e-002	-2.567e-011
1287	-1.8904e-002	4.6289e-002	4.6e-002	-2.4286e-011
1288	-1.798e-002	4.6655e-002	4.6e-002	-2.3259e-011
1289	-1.7049e-002	4.7003e-002	4.6e-002	-2.254e-011
1290	-1.6111e-002	4.7333e-002	4.6e-002	-2.2027e-011
1291	-1.5167e-002	4.7644e-002	4.6e-002	-2.1643e-011
1292	-1.4217e-002	4.7936e-002	4.6e-002	-2.1281e-011
1293	-1.3261e-002	4.8209e-002	4.6e-002	-2.0919e-011
1294	-1.23e-002	4.8464e-002	4.6e-002	-2.0483e-011
1295	-1.1334e-002	4.8699e-002	4.6e-002	-1.9963e-011
1296	-1.0363e-002	4.8914e-002	4.6e-002	-1.9334e-011
1297	-9.3886e-003	4.9111e-002	4.6e-002	-1.8614e-011
1298	-8.4103e-003	4.9288e-002	4.6e-002	-1.7787e-011
1299	-7.4287e-003	4.9445e-002	4.6e-002	-1.6907e-011
1300	-6.4442e-003	4.9583e-002	4.6e-002	-1.5953e-011
1301	-5.4571e-003	4.9701e-002	4.6e-002	-1.4974e-011
1302	-4.4678e-003	4.98e-002	4.6e-002	-1.3952e-011
1303	-3.4768e-003	4.9879e-002	4.6e-002	-1.2931e-011
1304	-2.4844e-003	4.9938e-002	4.6e-002	-1.1897e-011
1305	-1.4911e-003	4.9978e-002	4.6e-002	-1.0877e-011
1306	-4.9708e-004	4.9998e-002	4.6e-002	-9.8659e-012
1307	4.9706e-004	4.9998e-002	4.6e-002	-8.8901e-012
1308	1.491e-003	4.9978e-002	4.6e-002	-7.9379e-012
1309	2.4844e-003	4.9938e-002	4.6e-002	-7.0392e-012
1310	3.4768e-003	4.9879e-002	4.6e-002	-6.1662e-012
1311	4.4678e-003	4.98e-002	4.6e-002	-5.3734e-012
1312	5.4571e-003	4.9701e-002	4.6e-002	-4.6087e-012
1313	6.4441e-003	4.9583e-002	4.6e-002	-3.9055e-012
1314	7.4287e-003	4.9445e-002	4.6e-002	-3.265e-012
1315	8.4103e-003	4.9288e-002	4.6e-002	-2.7111e-012
1316	9.3886e-003	4.9111e-002	4.6e-002	-2.1872e-012
1317	1.0363e-002	4.8914e-002	4.6e-002	-1.7273e-012
1318	1.1334e-002	4.8699e-002	4.6e-002	-1.3407e-012
1319	1.23e-002	4.8464e-002	4.6e-002	-1.0124e-012
1320	1.3261e-002	4.8209e-002	4.6e-002	-7.0002e-013
1321	1.4217e-002	4.7936e-002	4.6e-002	-4.6665e-013
1322	1.5167e-002	4.7644e-002	4.6e-002	-2.613e-013
1323	1.6111e-002	4.7333e-002	4.6e-002	-9.3576e-014
1324	1.7049e-002	4.7003e-002	4.6e-002	4.1559e-014
1325	1.798e-002	4.6655e-002	4.6e-002	1.5024e-013
1326	1.8904e-002	4.6289e-002	4.6e-002	2.6998e-013
1327	1.9821e-002	4.5904e-002	4.6e-002	3.6699e-013
1328	2.073e-002	4.55e-002	4.6e-002	4.841e-013
1329	2.163e-002	4.5079e-002	4.6e-002	6.0832e-013
1330	2.2522e-002	4.464e-002	4.6e-002	7.5769e-013
1331	2.3405e-002	4.4184e-002	4.6e-002	9.1986e-013
1332	2.4279e-002	4.371e-002	4.6e-002	1.1061e-012
1333	2.5143e-002	4.3218e-002	4.6e-002	1.2038e-012
1334	2.5998e-002	4.271e-002	4.6e-002	1.4894e-012
1335	2.6842e-002	4.2184e-002	4.6e-002	1.1186e-012
1336	2.7675e-002	4.1642e-002	4.6e-002	1.3506e-012
1337	2.8498e-002	4.1084e-002	4.6e-002	1.6129e-012
1338	3.0108e-002	3.9918e-002	4.6e-002	-1.2947e-012
1339	3.0896e-002	3.9312e-002	4.6e-002	-6.9212e-012
1340	3.1672e-002	3.869e-002	4.6e-002	-1.3535e-011
1341	3.1672e-002	3.869e-002	5.e-003	-2.9779e-011
1342	-3.1672e-002	3.869e-002	4.5e-002	-9.4553e-011
1343	-3.0896e-002	3.9312e-002	4.5e-002	5.4277e-011
1344	-3.0108e-002	3.9919e-002	4.5e-002	-6.2255e-011
1345	-2.9309e-002	4.0509e-002	4.5e-002	-8.6561e-011
1346	-2.8498e-002	4.1084e-002	4.5e-002	-1.0361e-012
1347	-2.7675e-002	4.1642e-002	4.5e-002	-1.6847e-011
1348	-2.6842e-002	4.2184e-002	4.5e-002	-1.7074e-011
1349	-2.5998e-002	4.271e-002	4.5e-002	-2.7537e-011
1350	-2.5143e-002	4.3218e-002	4.5e-002	-3.3023e-011
1351	-2.4279e-002	4.371e-002	4.5e-002	-3.1796e-011
1352	-2.3405e-002	4.4184e-002	4.5e-002	-2.9692e-011
1353	-2.2522e-002	4.464e-002	4.5e-002	-2.7488e-011
1354	-2.163e-002	4.5079e-002	4.5e-002	-2.563e-011
1355	-2.073e-002	4.55e-002	4.5e-002	-2.4275e-011
1356	-1.9821e-002	4.5904e-002	4.5e-002	-2.3393e-011
1357	-1.8904e-002	4.6288e-002	4.5e-002	-2.2932e-011
1358	-1.798e-002	4.6655e-002	4.5e-002	-2.2769e-011
1359	-1.7049e-002	4.7003e-002	4.5e-002	-2.2798e-011
1360	-1.6111e-002	4.7333e-002	4.5e-002	-2.2898e-011
1361	-1.5167e-002	4.7644e-002	4.5e-002	-2.2991e-011
1362	-1.4217e-002	4.7936e-002	4.5e-002	-2.2985e-011
1363	-1.3261e-002	4.8209e-002	4.5e-002	-2.2861e-011
1364	-1.23e-002	4.8464e-002	4.5e-002	-2.2576e-011
1365	-1.1334e-002	4.8699e-002	4.5e-002	-2.2123e-011
1366	-1.0363e-002	4.8914e-002	4.5e-002	-2.1491e-011
1367	-9.3887e-003	4.9111e-002	4.5e-002	-2.0727e-011
1368	-8.4103e-003	4.9288e-002	4.5e-002	-1.9842e-011
1369	-7.4288e-003	4.9445e-002	4.5e-002	-1.8873e-011
1370	-6.4442e-003	4.9583e-002	4.5e-002	-1.7819e-011
1371	-5.4571e-003	4.9701e-002	4.5e-002	-1.6724e-011
1372	-4.4678e-003	4.98e-002	4.5e-002	-1.558e-011
1373	-3.4769e-003	4.9879e-002	4.5e-002	-1.4437e-011
1374	-2.4844e-003	4.9938e-002	4.5e-002	-1.3293e-011
1375	-1.4911e-003	4.9978e-002	4.5e-002	-1.2153e-011
1376	-4.9708e-004	4.9998e-002	4.5e-002	-1.1018e-011
1377	4.9702e-004	4.9998e-002	4.5e-002	-9.9062e-012
1378	1.491e-003	4.9978e-002	4.5e-002	-8.8287e-012
1379	2.4844e-003	4.9938e-002	4.5e-002	-7.8185e-012
1380	3.4768e-003	4.9879e-002	4.5e-002	-6.8336e-012
1381	4.4678e-003	4.98e-002	4.5e-002	-5.9173e-012
1382	5.4571e-003	4.9701e-002	4.5e-002	-5.0557e-012
1383	6.4441e-003	4.9583e-002	4.5e-002	-4.2593e-012
1384	7.4287e-003	4.9445e-002	4.5e-002	-3.5395e-012
1385	8.4103e-003	4.9288e-002	4.5e-002	-2.9105e-012
1386	9.3886e-003	4.9111e-002	4.5e-002	-2.3247e-012
1387	1.0363e-002	4.8914e-002	4.5e-002	-1.8146e-012
1388	1.1334e-002	4.8699e-002	4.5e-002	-1.3698e-012
1389	1.23e-002	4.8464e-002	4.5e-002	-9.9501e-013
1390	1.3261e-002	4.8209e-002	4.5e-002	-6.6767e-013
1391	1.4217e-002	4.7936e-002	4.5e-002	-3.9922e-013
1392	1.5167e-002	4.7644e-002	4.5e-002	-1.7172e-013
1393	1.6111e-002	4.7333e-002	4.5e-002	8.3649e-016
1394	1.7049e-002	4.7003e-002	4.5e-002	1.4735e-013
1395	1.798e-002	4.6655e-002	4.5e-002	2.6071e-013
1396	1.8904e-002	4.6289e-002	4.5e-002	3.5601e-013
1397	1.9821e-002	4.5904e-002	4.5e-002	4.3232e-013
1398	2.073e-002	4.55e-002	4.5e-002	5.2161e-013
1399	2.163e-002	4.5079e-002	4.5e-002	6.1241e-013
1400	2.2522e-002	4.464e-002	4.5e-002	7.1221e-013
1401	2.3405e-002	4.4184e-002	4.5e-002	8.1354e-013
1402	2.4279e-002	4.371e-002	4.5e-002	9.2382e-013
1403	2.5143e-002	4.3218e-002	4.5e-002	9.4126e-013
1404	2.5998e-002	4.271e-002	4.5e-002	1.0236e-012
1405	2.6842e-002	4.2184e-002	4.5e-002	1.8841e-013
1406	2.7675e-002	4.1642e-002	4.5e-002	4.9176e-013
1407	2.8498e-002	4.1084e-002	4.5e-002	5.1443e-013
1408	2.9309e-002	4.0509e-002	4.5e-002	-3.4143e-012
1409	3.0108e-002	3.9918e-002	4.5e-002	-4.6097e-012
1410	3.0896e-002	3.9312e-002	4.5e-002	-8.4982e-012
1411	3.1672e-002	3.869e-002	4.5e-002	-1.6366e-011
1412	3.1672e-002	3.869e-002	4.4e-002	-1.0601e-011
1413	3.1672e-002	3.869e-002	4.3e-002	-2.8126e-012
1414	3.1671e-002	3.869e-002	4.2e-002	3.0434e-012
1415	3.1671e-002	3.869e-002	4.1e-002	5.2131e-012
1416	3.1671e-002	3.869e-002	4.e-002	4.4285e-012
1417	3.1671e-002	3.869e-002	3.9e-002	3.454e-012
1418	3.1671e-002	3.869e-002	3.7e-002	2.7931e-012
1419	3.1671e-002	3.869e-002	3.5e-002	4.0475e-012
1420	3.1671e-002	3.869e-002	3.3e-002	4.8847e-012
1421	3.1671e-002	3.869e-002	3.1e-002	5.4107e-012
1422	3.1671e-002	3.869e-002	2.9e-002	5.7739e-012
1423	3.1671e-002	3.869e-002	2.7e-002	6.1859e-012
1424	3.1671e-002	3.869e-002	2.5e-002	6.5017e-012
1425	3.1671e-002	3.869e-002	2.3e-002	6.7233e-012
1426	3.1671e-002	3.869e-002	2.1e-002	6.8604e-012
1427	3.1671e-002	3.869e-002	1.9e-002	7.1452e-012
1428	3.1671e-002	3.869e-002	1.7e-002	7.7132e-012
1429	3.1671e-002	3.869e-002	1.5e-002	8.7073e-012
1430	3.1671e-002	3.8691e-002	1.3e-002	9.4777e-012
1431	3.1671e-002	3.8691e-002	1.2e-002	9.3317e-012
1432	3.1671e-002	3.8691e-002	1.1e-002	1.0282e-011
1433	3.1671e-002	3.8691e-002	1.e-002	5.9166e-012
1434	3.1671e-002	3.8691e-002	9.0001e-003	9.4231e-013
1435	3.1671e-002	3.8691e-002	8.0001e-003	6.7231e-013
1436	3.167e-002	3.8691e-002	7.0001e-003	-1.205e-011
1437	3.167e-002	3.8691e-002	6.0001e-003	-3.8598e-011
1438	3.0896e-002	3.9312e-002	5.e-003	7.6642e-011
1439	3.0108e-002	3.9918e-002	5.e-003	1.9576e-011
1440	2.9309e-002	4.0509e-002	5.e-003	-1.2144e-011
1441	2.8498e-002	4.1084e-002	5.e-003	1.8332e-011
1442	2.7675e-002	4.1642e-002	5.e-003	-1.0968e-012
1443	2.6842e-002	4.2184e-002	5.e-003	2.7177e-012
1444	2.5998e-002	4.271e-002	5.e-003	-7.1825e-014
1445	2.5143e-002	4.3218e-002	5.e-003	-1.5045e-012
1446	2.4279e-002	4.371e-002	5.e-003	-1.8273e-012
1447	2.3405e-002	4.4184e-002	5.e-003	-2.1723e-012
1448	2.2522e-002	4.464e-002	5.e-003	-2.2943e-012
1449	2.163e-002	4.5079e-002	5.e-003	-2.2347e-012
1450	2.073e-002	4.55e-002	5.e-003	-2.2436e-012
1451	1.9821e-002	4.5904e-002	5.e-003	-2.2931e-012
1452	1.8904e-002	4.6288e-002	5.e-003	-2.4099e-012
1453	1.798e-002	4.6655e-002	5.e-003	-2.5561e-012
1454	1.7049e-002	4.7003e-002	5.e-003	-2.723e-012
1455	1.6111e-002	4.7333e-002	5.e-003	-2.9071e-012
1456	1.5167e-002	4.7644e-002	5.e-003	-3.1081e-012
1457	1.4217e-002	4.7936e-002	5.e-003	-3.3143e-012
1458	1.3261e-002	4.8209e-002	5.e-003	-3.5398e-012
1459	1.23e-002	4.8464e-002	5.e-003	-3.7803e-012
1460	1.1334e-002	4.8699e-002	5.e-003	-4.0238e-012
1461	1.0363e-002	4.8914e-002	5.e-003	-4.2891e-012
1462	9.3887e-003	4.9111e-002	5.e-003	-4.5975e-012
1463	8.4103e-003	4.9288e-002	5.e-003	-4.931e-012
1464	7.4288e-003	4.9445e-002	5.e-003	-5.2864e-012
1465	6.4442e-003	4.9583e-002	5.e-003	-5.654e-012
1466	5.4571e-003	4.9701e-002	5.e-003	-6.0728e-012
1467	4.4678e-003	4.98e-002	5.e-003	-6.5392e-012
1468	3.4769e-003	4.9879e-002	5.e-003	-7.0491e-012
1469	2.4844e-003	4.9938e-002	5.e-003	-7.6301e-012
1470	1.4911e-003	4.9978e-002	5.e-003	-8.2791e-012
1471	4.9708e-004	4.9998e-002	5.e-003	-8.9961e-012
1472	-4.9702e-004	4.9998e-002	5.e-003	-9.8067e-012
1473	-1.491e-003	4.9978e-002	5.e-003	-1.0704e-011
1474	-2.4844e-003	4.9938e-002	5.e-003	-1.1715e-011
1475	-3.4768e-003	4.9879e-002	5.e-003	-1.2826e-011
1476	-4.4678e-003	4.98e-002	5.e-003	-1.4051e-011
1477	-5.4571e-003	4.9701e-002	5.e-003	-1.5407e-011
1478	-6.4441e-003	4.9583e-002	5.e-003	-1.6856e-011
1479	-7.4287e-003	4.9445e-002	5.e-003	-1.8345e-011
1480	-8.4103e-003	4.9288e-002	5.e-003	-1.9871e-011
1481	-9.3886e-003	4.9111e-002	5.e-003	-2.1382e-011
1482	-1.0363e-002	4.8914e-002	5.e-003	-2.2801e-011
1483	-1.1334e-002	4.8699e-002	5.e-003	-2.4051e-011
1484	-1.23e-002	4.8464e-002	5.e-003	-2.5055e-011
1485	-1.3261e-002	4.8209e-002	5.e-003	-2.5714e-011
1486	-1.4217e-002	4.7936e-002	5.e-003	-2.5931e-011
1487	-1.5167e-002	4.7644e-002	5.e-003	-2.5604e-011
1488	-1.6111e-002	4.7333e-002	5.e-003	-2.4658e-011
1489	-1.7049e-002	4.7003e-002	5.e-003	-2.3022e-011
1490	-1.798e-002	4.6655e-002	5.e-003	-2.0656e-011
1491	-1.8904e-002	4.6289e-002	5.e-003	-1.7552e-011
1492	-1.9821e-002	4.5904e-002	5.e-003	-1.3774e-011
1493	-2.073e-002	4.55e-002	5.e-003	-9.3967e-012
1494	-2.163e-002	4.5079e-002	5.e-003	-4.833e-012
1495	-2.2522e-002	4.464e-002	5.e-003	2.0947e-012
1496	-2.3405e-002	4.4184e-002	5.e-003	9.4781e-012
1497	-2.4279e-002	4.371e-002	5.e-003	4.6596e-012
1498	-2.5143e-002	4.3218e-002	5.e-003	1.2908e-012
1499	-2.5998e-002	4.271e-002	5.e-003	3.4411e-011
1500	-2.6842e-002	4.2184e-002	5.e-003	8.3442e-011
1501	-2.7673e-002	4.1644e-002	4.991e-003	1.3095e-010
1502	-2.8497e-002	4.1084e-002	4.9885e-003	1.2509e-010
1503	-2.931e-002	4.0509e-002	4.9913e-003	1.1926e-010
1504	-3.0108e-002	3.9919e-002	5.e-003	1.5701e-010
1505	-3.1672e-002	3.869e-002	5.e-003	4.5294e-011
1506	-3.1672e-002	3.869e-002	6.e-003	1.4117e-010
1507	-3.1672e-002	3.869e-002	7.e-003	2.1265e-010
1508	-3.166e-002	3.8699e-002	8.0048e-003	1.5913e-010
1509	-3.1648e-002	3.8709e-002	9.0041e-003	1.4852e-011
1510	-3.1642e-002	3.8714e-002	9.998e-003	-1.8444e-010
1511	-3.1648e-002	3.8709e-002	1.099e-002	-3.0157e-010
1512	-3.1656e-002	3.8702e-002	1.299e-002	-2.0475e-010
1513	-3.1666e-002	3.8695e-002	1.4996e-002	-1.0762e-010
1514	-3.1671e-002	3.869e-002	1.7e-002	1.6348e-010
1515	-3.1671e-002	3.869e-002	1.9e-002	3.8184e-010
1516	-3.1671e-002	3.869e-002	2.1e-002	1.3632e-010
1517	-3.1671e-002	3.869e-002	2.3e-002	-4.1619e-010
1518	-3.1671e-002	3.869e-002	2.5e-002	-5.9547e-010
1519	-3.1671e-002	3.869e-002	2.7e-002	-2.1053e-010
1520	-3.1671e-002	3.8691e-002	2.9e-002	-5.2222e-012
1521	-3.1671e-002	3.8691e-002	3.1e-002	8.9822e-011
1522	-3.1671e-002	3.8691e-002	3.3e-002	6.0275e-011
1523	-3.1671e-002	3.8691e-002	3.5e-002	7.6885e-011
1524	-3.1663e-002	3.8697e-002	3.7e-002	1.994e-010
1525	-3.1662e-002	3.8698e-002	3.8999e-002	-7.8844e-011
1526	-3.167e-002	3.8691e-002	4.1e-002	-9.1458e-011
1527	-3.167e-002	3.8691e-002	4.3e-002	1.1609e-010
1528	-3.167e-002	3.8691e-002	4.4e-002	-1.159e-011
1529	3.0896e-002	3.9312e-002	4.4e-002	-7.9918e-012
1530	3.0896e-002	3.9312e-002	4.3e-002	-6.9818e-012
1531	3.0896e-002	3.9312e-002	4.2e-002	-5.7275e-012
1532	3.0896e-002	3.9312e-002	4.1e-002	-4.5425e-012
1533	3.0896e-002	3.9312e-002	4.e-002	-3.7972e-012
1534	3.0896e-002	3.9312e-002	3.9e-002	-3.8035e-012
1535	3.0896e-002	3.9312e-002	3.8e-002	-3.868e-012
1536	3.0896e-002	3.9312e-002	3.7e-002	-3.9096e-012
1537	3.0896e-002	3.9312e-002	3.6e-002	-4.2635e-012
1538	3.0896e-002	3.9312e-002	3.5e-002	-5.0132e-012
1539	3.0896e-002	3.9312e-002	3.4e-002	-5.6475e-012
1540	3.0896e-002	3.9312e-002	3.3e-002	-6.0525e-012
1541	3.0896e-002	3.9312e-002	3.2e-002	-6.5904e-012
1542	3.0896e-002	3.9312e-002	3.1e-002	-7.1901e-012
1543	3.0896e-002	3.9312e-002	3.e-002	-7.6363e-012
1544	3.0896e-002	3.9312e-002	2.9e-002	-7.9479e-012
1545	3.0896e-002	3.9312e-002	2.8e-002	-8.2565e-012
1546	3.0896e-002	3.9312e-002	2.7e-002	-8.5759e-012
1547	3.0896e-002	3.9312e-002	2.6e-002	-8.9334e-012
1548	3.0897e-002	3.9312e-002	2.5e-002	-9.3129e-012
1549	3.0897e-002	3.9312e-002	2.4e-002	-9.7516e-012
1550	3.0897e-002	3.9312e-002	2.3e-002	-1.0199e-011
1551	3.0897e-002	3.9312e-002	2.2e-002	-1.067e-011
1552	3.0897e-002	3.9311e-002	2.1e-002	-1.1138e-011
1553	3.0897e-002	3.9311e-002	2.e-002	-1.16e-011
1554	3.0897e-002	3.9311e-002	1.9e-002	-1.2003e-011
1555	3.0897e-002	3.9311e-002	1.8e-002	-1.2296e-011
1556	3.0897e-002	3.9311e-002	1.7e-002	-1.2474e-011
1557	3.0897e-002	3.9311e-002	1.6e-002	-1.2515e-011
1558	3.0897e-002	3.9311e-002	1.5e-002	-1.2455e-011
1559	3.0897e-002	3.9311e-002	1.4e-002	-1.2175e-011
1560	3.0897e-002	3.9311e-002	1.3e-002	-1.1061e-011
1561	3.0897e-002	3.9311e-002	1.2e-002	-1.2618e-011
1562	3.0897e-002	3.9311e-002	1.1e-002	-1.5444e-011
1563	3.0898e-002	3.9311e-002	1.e-002	-8.393e-012
1564	3.0898e-002	3.9311e-002	9.e-003	-3.4848e-012
1565	3.0898e-002	3.9311e-002	8.e-003	-7.8388e-012
1566	3.0898e-002	3.9311e-002	7.e-003	1.0988e-011
1567	3.0898e-002	3.9311e-002	6.e-003	5.2747e-011
1568	3.0108e-002	3.9918e-002	6.e-003	2.9235e-011
1569	2.9309e-002	4.0509e-002	6.e-003	-2.0996e-012
1570	2.8498e-002	4.1084e-002	6.e-003	1.9695e-011
1571	2.7675e-002	4.1642e-002	6.e-003	2.071e-012
1572	2.6842e-002	4.2184e-002	6.e-003	-1.894e-012
1573	2.5998e-002	4.271e-002	6.e-003	-3.3488e-012
1574	2.5143e-002	4.3218e-002	6.e-003	9.1255e-013
1575	2.4279e-002	4.371e-002	6.e-003	-6.1176e-013
1576	2.3405e-002	4.4184e-002	6.e-003	-1.0425e-012
1577	2.2522e-002	4.464e-002	6.e-003	-1.0058e-012
1578	2.163e-002	4.5079e-002	6.e-003	-1.0736e-012
1579	2.073e-002	4.55e-002	6.e-003	-1.2518e-012
1580	1.9821e-002	4.5904e-002	6.e-003	-1.5114e-012
1581	1.8904e-002	4.6289e-002	6.e-003	-1.8253e-012
1582	1.798e-002	4.6655e-002	6.e-003	-2.1512e-012
1583	1.7049e-002	4.7003e-002	6.e-003	-2.4579e-012
1584	1.6111e-002	4.7333e-002	6.e-003	-2.752e-012
1585	1.5167e-002	4.7644e-002	6.e-003	-3.0383e-012
1586	1.4217e-002	4.7936e-002	6.e-003	-3.3284e-012
1587	1.3261e-002	4.8209e-002	6.e-003	-3.6221e-012
1588	1.23e-002	4.8464e-002	6.e-003	-3.9158e-012
1589	1.1334e-002	4.8699e-002	6.e-003	-4.2051e-012
1590	1.0363e-002	4.8914e-002	6.e-003	-4.518e-012
1591	9.3886e-003	4.9111e-002	6.e-003	-4.8455e-012
1592	8.4103e-003	4.9288e-002	6.e-003	-5.1922e-012
1593	7.4288e-003	4.9445e-002	6.e-003	-5.5551e-012
1594	6.4442e-003	4.9583e-002	6.e-003	-5.9502e-012
1595	5.4571e-003	4.9701e-002	6.e-003	-6.3862e-012
1596	4.4678e-003	4.98e-002	6.e-003	-6.8633e-012
1597	3.4769e-003	4.9879e-002	6.e-003	-7.3779e-012
1598	2.4844e-003	4.9938e-002	6.e-003	-7.9592e-012
1599	1.4911e-003	4.9978e-002	6.e-003	-8.5852e-012
1600	4.9707e-004	4.9998e-002	6.e-003	-9.2697e-012
1601	-4.9703e-004	4.9998e-002	6.e-003	-1.0043e-011
1602	-1.4911e-003	4.9978e-002	6.e-003	-1.0914e-011
1603	-2.4844e-003	4.9938e-002	6.e-003	-1.1871e-011
1604	-3.4768e-003	4.9879e-002	6.e-003	-1.2936e-011
1605	-4.4678e-003	4.98e-002	6.e-003	-1.4107e-011
1606	-5.4571e-003	4.9701e-002	6.e-003	-1.539e-011
1607	-6.4441e-003	4.9583e-002	6.e-003	-1.6756e-011
1608	-7.4287e-003	4.9445e-002	6.e-003	-1.8181e-011
1609	-8.4103e-003	4.9288e-002	6.e-003	-1.9635e-011
1610	-9.3886e-003	4.9111e-002	6.e-003	-2.1059e-011
1611	-1.0363e-002	4.8914e-002	6.e-003	-2.2336e-011
1612	-1.1334e-002	4.8699e-002	6.e-003	-2.34e-011
1613	-1.23e-002	4.8464e-002	6.e-003	-2.4159e-011
1614	-1.3261e-002	4.8209e-002	6.e-003	-2.447e-011
1615	-1.4217e-002	4.7936e-002	6.e-003	-2.4192e-011
1616	-1.5167e-002	4.7644e-002	6.e-003	-2.3219e-011
1617	-1.6111e-002	4.7333e-002	6.e-003	-2.1407e-011
1618	-1.7049e-002	4.7003e-002	6.e-003	-1.8647e-011
1619	-1.798e-002	4.6655e-002	6.e-003	-1.4851e-011
1620	-1.8904e-002	4.6289e-002	6.e-003	-9.9891e-012
1621	-1.9821e-002	4.5904e-002	6.e-003	-4.047e-012
1622	-2.073e-002	4.55e-002	6.e-003	2.7666e-012
1623	-2.163e-002	4.5079e-002	6.e-003	1.0883e-011
1624	-2.2522e-002	4.464e-002	6.e-003	1.561e-011
1625	-2.3405e-002	4.4184e-002	6.e-003	3.5799e-011
1626	-2.4279e-002	4.371e-002	6.e-003	3.6842e-011
1627	-2.5143e-002	4.3218e-002	6.e-003	-1.5409e-011
1628	-2.5998e-002	4.271e-002	6.e-003	3.9947e-011
1629	-2.6838e-002	4.2187e-002	5.9919e-003	1.3504e-010
1630	-2.767e-002	4.1646e-002	5.9815e-003	1.2469e-010
1631	-2.8495e-002	4.1086e-002	5.9722e-003	1.6137e-010
1632	-2.931e-002	4.0508e-002	5.9785e-003	2.3685e-010
1633	-3.0108e-002	3.9919e-002	6.e-003	2.204e-010
1634	-3.0896e-002	3.9312e-002	6.e-003	2.1757e-010
1635	-3.0896e-002	3.9312e-002	7.e-003	3.0686e-010
1636	-3.0878e-002	3.9326e-002	8.0003e-003	3.4631e-010
1637	-3.0857e-002	3.9342e-002	9.0016e-003	2.7899e-010
1638	-3.0853e-002	3.9345e-002	9.9957e-003	1.6524e-010
1639	-3.0845e-002	3.9352e-002	1.0989e-002	1.8236e-011
1640	-3.0855e-002	3.9344e-002	1.1989e-002	-1.32e-010
1641	-3.0862e-002	3.9339e-002	1.2989e-002	-2.3085e-010
1642	-3.0868e-002	3.9334e-002	1.3993e-002	-2.5728e-010
1643	-3.0874e-002	3.9329e-002	1.4994e-002	-2.4947e-010
1644	-3.088e-002	3.9324e-002	1.5993e-002	-2.4367e-010
1645	-3.0887e-002	3.9319e-002	1.6994e-002	-1.59e-010
1646	-3.0892e-002	3.9315e-002	1.7991e-002	-1.1906e-011
1647	-3.09e-002	3.9309e-002	1.899e-002	1.1407e-010
1648	-3.0903e-002	3.9307e-002	1.9993e-002	1.1433e-010
1649	-3.091e-002	3.9301e-002	2.0996e-002	-5.5521e-011
1650	-3.0909e-002	3.9302e-002	2.2002e-002	-2.51e-010
1651	-3.0909e-002	3.9302e-002	2.3006e-002	-2.5137e-010
1652	-3.0902e-002	3.9307e-002	2.4007e-002	-1.6418e-010
1653	-3.0897e-002	3.9311e-002	2.5e-002	-1.1741e-010
1654	-3.0887e-002	3.9319e-002	2.6002e-002	-7.6171e-011
1655	-3.0885e-002	3.932e-002	2.7001e-002	-6.6879e-011
1656	-3.0885e-002	3.932e-002	2.7999e-002	-2.1767e-011
1657	-3.0885e-002	3.932e-002	2.9e-002	2.4929e-011
1658	-3.0885e-002	3.9321e-002	2.9999e-002	4.2674e-011
1659	-3.0884e-002	3.9322e-002	3.1e-002	2.1025e-011
1660	-3.0883e-002	3.9322e-002	3.1999e-002	1.708e-011
1661	-3.0889e-002	3.9318e-002	3.3e-002	3.6221e-011
1662	-3.0886e-002	3.932e-002	3.4e-002	1.0482e-010
1663	-3.0884e-002	3.9322e-002	3.5e-002	1.7767e-010
1664	-3.0882e-002	3.9323e-002	3.6e-002	1.5325e-010
1665	-3.0879e-002	3.9325e-002	3.7e-002	1.0676e-010
1666	-3.0877e-002	3.9327e-002	3.8e-002	4.4847e-011
1667	-3.0875e-002	3.9329e-002	3.9e-002	-4.4902e-011
1668	-3.0879e-002	3.9325e-002	4.0995e-002	-1.7418e-010
1669	-3.0887e-002	3.9319e-002	4.1995e-002	-3.1027e-010
1670	-3.0899e-002	3.931e-002	4.3e-002	-3.2134e-010
1671	-3.0899e-002	3.931e-002	4.4e-002	-1.3371e-010
1672	-3.0108e-002	3.9919e-002	4.4e-002	-1.4898e-010
1673	-2.9309e-002	4.0509e-002	4.4e-002	-7.556e-011
1674	-2.8498e-002	4.1084e-002	4.4e-002	-1.1824e-012
1675	-2.7675e-002	4.1642e-002	4.4e-002	2.497e-011
1676	-2.6842e-002	4.2184e-002	4.4e-002	6.3056e-012
1677	-2.5998e-002	4.271e-002	4.4e-002	-2.4828e-011
1678	-2.5143e-002	4.3218e-002	4.4e-002	-2.3935e-011
1679	-2.4279e-002	4.371e-002	4.4e-002	-2.1819e-011
1680	-2.3405e-002	4.4184e-002	4.4e-002	-2.0312e-011
1681	-2.2522e-002	4.464e-002	4.4e-002	-1.9005e-011
1682	-2.163e-002	4.5079e-002	4.4e-002	-1.8399e-011
1683	-2.073e-002	4.55e-002	4.4e-002	-1.841e-011
1684	-1.9821e-002	4.5904e-002	4.4e-002	-1.8935e-011
1685	-1.8904e-002	4.6289e-002	4.4e-002	-1.9785e-011
1686	-1.798e-002	4.6655e-002	4.4e-002	-2.0789e-011
1687	-1.7049e-002	4.7003e-002	4.4e-002	-2.18e-011
1688	-1.6111e-002	4.7333e-002	4.4e-002	-2.2684e-011
1689	-1.5167e-002	4.7644e-002	4.4e-002	-2.337e-011
1690	-1.4217e-002	4.7936e-002	4.4e-002	-2.3807e-011
1691	-1.3261e-002	4.8209e-002	4.4e-002	-2.3962e-011
1692	-1.23e-002	4.8464e-002	4.4e-002	-2.3859e-011
1693	-1.1334e-002	4.8699e-002	4.4e-002	-2.3497e-011
1694	-1.0363e-002	4.8914e-002	4.4e-002	-2.2896e-011
1695	-9.3886e-003	4.9111e-002	4.4e-002	-2.2115e-011
1696	-8.4103e-003	4.9288e-002	4.4e-002	-2.1192e-011
1697	-7.4288e-003	4.9445e-002	4.4e-002	-2.0158e-011
1698	-6.4442e-003	4.9583e-002	4.4e-002	-1.9044e-011
1699	-5.4571e-003	4.9701e-002	4.4e-002	-1.7875e-011
1700	-4.4678e-003	4.98e-002	4.4e-002	-1.6671e-011
1701	-3.4769e-003	4.9879e-002	4.4e-002	-1.5443e-011
1702	-2.4844e-003	4.9938e-002	4.4e-002	-1.4206e-011
1703	-1.4911e-003	4.9978e-002	4.4e-002	-1.2973e-011
1704	-4.9707e-004	4.9998e-002	4.4e-002	-1.1758e-011
1705	4.9703e-004	4.9998e-002	4.4e-002	-1.0564e-011
1706	1.4911e-003	4.9978e-002	4.4e-002	-9.3981e-012
1707	2.4844e-003	4.9938e-002	4.4e-002	-8.2831e-012
1708	3.4768e-003	4.9879e-002	4.4e-002	-7.2169e-012
1709	4.4678e-003	4.98e-002	4.4e-002	-6.2179e-012
1710	5.4571e-003	4.9701e-002	4.4e-002	-5.3013e-012
1711	6.4441e-003	4.9583e-002	4.4e-002	-4.4466e-012
1712	7.4287e-003	4.9445e-002	4.4e-002	-3.6663e-012
1713	8.4103e-003	4.9288e-002	4.4e-002	-2.9683e-012
1714	9.3886e-003	4.9111e-002	4.4e-002	-2.3415e-012
1715	1.0363e-002	4.8914e-002	4.4e-002	-1.792e-012
1716	1.1334e-002	4.8699e-002	4.4e-002	-1.3203e-012
1717	1.23e-002	4.8464e-002	4.4e-002	-9.2482e-013
1718	1.3261e-002	4.8209e-002	4.4e-002	-5.866e-013
1719	1.4217e-002	4.7936e-002	4.4e-002	-2.9185e-013
1720	1.5167e-002	4.7644e-002	4.4e-002	-6.1341e-014
1721	1.6111e-002	4.7333e-002	4.4e-002	1.075e-013
1722	1.7049e-002	4.7003e-002	4.4e-002	2.4509e-013
1723	1.798e-002	4.6655e-002	4.4e-002	3.4964e-013
1724	1.8904e-002	4.6289e-002	4.4e-002	4.0996e-013
1725	1.9821e-002	4.5904e-002	4.4e-002	4.5494e-013
1726	2.073e-002	4.55e-002	4.4e-002	4.9709e-013
1727	2.163e-002	4.5079e-002	4.4e-002	5.4133e-013
1728	2.2522e-002	4.464e-002	4.4e-002	5.821e-013
1729	2.3405e-002	4.4184e-002	4.4e-002	5.9035e-013
1730	2.4279e-002	4.371e-002	4.4e-002	6.0427e-013
1731	2.5143e-002	4.3218e-002	4.4e-002	5.7235e-013
1732	2.5998e-002	4.271e-002	4.4e-002	7.3979e-013
1733	2.6842e-002	4.2184e-002	4.4e-002	-1.1969e-012
1734	2.7675e-002	4.1642e-002	4.4e-002	-4.0859e-013
1735	2.8497e-002	4.1084e-002	4.4e-002	4.8376e-013
1736	2.9309e-002	4.0509e-002	4.4e-002	-5.8802e-012
1737	3.0108e-002	3.9918e-002	4.4e-002	-7.1837e-012
1738	3.0108e-002	3.9918e-002	7.0001e-003	1.8014e-011
1739	2.9309e-002	4.0509e-002	7.e-003	1.4977e-011
1740	2.8498e-002	4.1084e-002	7.e-003	2.7e-011
1741	2.7675e-002	4.1642e-002	7.e-003	-1.4846e-011
1742	2.6842e-002	4.2184e-002	7.e-003	-1.8052e-011
1743	2.5998e-002	4.271e-002	7.e-003	9.6437e-012
1744	2.5143e-002	4.3218e-002	7.e-003	5.2234e-012
1745	2.4279e-002	4.371e-002	7.e-003	9.2851e-013
1746	2.3405e-002	4.4184e-002	7.e-003	1.2605e-012
1747	2.2522e-002	4.464e-002	7.e-003	8.791e-013
1748	2.163e-002	4.5079e-002	7.e-003	4.7267e-013
1749	2.073e-002	4.55e-002	7.e-003	-5.9285e-014
1750	1.9821e-002	4.5904e-002	7.e-003	-5.9216e-013
1751	1.8904e-002	4.6288e-002	7.e-003	-1.1235e-012
1752	1.798e-002	4.6655e-002	7.e-003	-1.6163e-012
1753	1.7049e-002	4.7003e-002	7.e-003	-2.0673e-012
1754	1.6111e-002	4.7333e-002	7.e-003	-2.4764e-012
1755	1.5167e-002	4.7644e-002	7.e-003	-2.8591e-012
1756	1.4217e-002	4.7936e-002	7.e-003	-3.224e-012
1757	1.3261e-002	4.8209e-002	7.e-003	-3.5695e-012
1758	1.23e-002	4.8464e-002	7.e-003	-3.9031e-012
1759	1.1334e-002	4.8699e-002	7.e-003	-4.2278e-012
1760	1.0363e-002	4.8914e-002	7.e-003	-4.5607e-012
1761	9.3887e-003	4.9111e-002	7.e-003	-4.9046e-012
1762	8.4103e-003	4.9288e-002	7.e-003	-5.2582e-012
1763	7.4288e-003	4.9445e-002	7.e-003	-5.6247e-012
1764	6.4442e-003	4.9583e-002	7.e-003	-6.0237e-012
1765	5.4571e-003	4.9701e-002	7.e-003	-6.4466e-012
1766	4.4678e-003	4.98e-002	7.e-003	-6.898e-012
1767	3.4769e-003	4.9879e-002	7.e-003	-7.3833e-012
1768	2.4844e-003	4.9938e-002	7.e-003	-7.9154e-012
1769	1.4911e-003	4.9978e-002	7.e-003	-8.4922e-012
1770	4.9709e-004	4.9998e-002	7.e-003	-9.1082e-012
1771	-4.9702e-004	4.9998e-002	7.e-003	-9.7896e-012
1772	-1.491e-003	4.9978e-002	7.e-003	-1.0574e-011
1773	-2.4844e-003	4.9938e-002	7.e-003	-1.1423e-011
1774	-3.4768e-003	4.9879e-002	7.e-003	-1.2355e-011
1775	-4.4678e-003	4.98e-002	7.e-003	-1.3403e-011
1776	-5.4571e-003	4.9701e-002	7.e-003	-1.454e-011
1777	-6.4441e-003	4.9583e-002	7.e-003	-1.5757e-011
1778	-7.4287e-003	4.9445e-002	7.e-003	-1.7048e-011
1779	-8.4103e-003	4.9288e-002	7.e-003	-1.8352e-011
1780	-9.3886e-003	4.9111e-002	7.e-003	-1.9612e-011
1781	-1.0363e-002	4.8914e-002	7.e-003	-2.0724e-011
1782	-1.1334e-002	4.8699e-002	7.e-003	-2.1609e-011
1783	-1.23e-002	4.8464e-002	7.e-003	-2.2157e-011
1784	-1.3261e-002	4.8209e-002	7.e-003	-2.221e-011
1785	-1.4217e-002	4.7936e-002	7.e-003	-2.1604e-011
1786	-1.5167e-002	4.7644e-002	7.e-003	-2.0191e-011
1787	-1.6111e-002	4.7333e-002	7.e-003	-1.7801e-011
1788	-1.7049e-002	4.7003e-002	7.e-003	-1.4269e-011
1789	-1.798e-002	4.6655e-002	7.e-003	-9.4492e-012
1790	-1.8904e-002	4.6289e-002	7.e-003	-3.2389e-012
1791	-1.9821e-002	4.5904e-002	7.e-003	4.5861e-012
1792	-2.073e-002	4.55e-002	7.e-003	1.3971e-011
1793	-2.163e-002	4.5079e-002	7.e-003	2.6552e-011
1794	-2.2522e-002	4.464e-002	7.e-003	3.8347e-011
1795	-2.3405e-002	4.4184e-002	7.e-003	5.0353e-011
1796	-2.4279e-002	4.371e-002	7.e-003	5.3476e-011
1797	-2.5143e-002	4.3218e-002	7.e-003	2.014e-011
1798	-2.5992e-002	4.2713e-002	6.9929e-003	7.4401e-011
1799	-2.6833e-002	4.219e-002	6.9778e-003	1.5835e-010
1800	-2.7665e-002	4.1649e-002	6.969e-003	9.345e-011
1801	-2.8487e-002	4.1091e-002	6.9664e-003	2.2198e-010
1802	-2.9301e-002	4.0515e-002	6.9722e-003	3.7094e-010
1803	-3.0104e-002	3.9922e-002	6.9927e-003	2.3585e-010
1804	-3.0084e-002	3.9937e-002	7.9964e-003	3.4897e-010
1805	-3.0065e-002	3.9951e-002	8.9889e-003	4.9365e-010
1806	-3.0047e-002	3.9965e-002	9.9867e-003	5.0388e-010
1807	-3.0043e-002	3.9968e-002	1.0988e-002	3.3753e-010
1808	-3.0049e-002	3.9964e-002	1.1992e-002	2.2611e-011
1809	-3.0054e-002	3.996e-002	1.2994e-002	-3.2096e-010
1810	-3.0062e-002	3.9954e-002	1.3998e-002	-4.186e-010
1811	-3.0068e-002	3.9949e-002	1.4995e-002	-3.0636e-010
1812	-3.008e-002	3.994e-002	1.5994e-002	-2.6472e-010
1813	-3.0088e-002	3.9934e-002	1.6988e-002	-2.8045e-010
1814	-3.01e-002	3.9925e-002	1.7985e-002	-3.3387e-010
1815	-3.0116e-002	3.9913e-002	1.8986e-002	-3.9595e-010
1816	-3.0134e-002	3.9899e-002	1.9987e-002	-3.0557e-010
1817	-3.0148e-002	3.9889e-002	2.0995e-002	-9.0491e-011
1818	-3.015e-002	3.9887e-002	2.2008e-002	1.104e-010
1819	-3.0137e-002	3.9897e-002	2.3015e-002	1.3588e-010
1820	-3.0126e-002	3.9905e-002	2.4016e-002	1.6315e-010
1821	-3.0108e-002	3.9919e-002	2.5012e-002	2.2429e-010
1822	-3.0097e-002	3.9927e-002	2.6005e-002	2.2459e-010
1823	-3.0086e-002	3.9935e-002	2.6998e-002	1.8561e-010
1824	-3.0087e-002	3.9935e-002	2.7998e-002	1.5596e-010
1825	-3.0088e-002	3.9933e-002	2.8996e-002	7.585e-011
1826	-3.0086e-002	3.9935e-002	3.e-002	-7.1144e-011
1827	-3.0083e-002	3.9937e-002	3.0997e-002	-1.1956e-010
1828	-3.0091e-002	3.9932e-002	3.1997e-002	-1.8892e-011
1829	-3.0092e-002	3.9931e-002	3.2997e-002	1.0436e-010
1830	-3.0089e-002	3.9933e-002	3.3998e-002	1.1719e-010
1831	-3.0085e-002	3.9936e-002	3.4998e-002	7.3859e-011
1832	-3.009e-002	3.9932e-002	3.5997e-002	5.1325e-011
1833	-3.0082e-002	3.9938e-002	3.6996e-002	7.2721e-012
1834	-3.0083e-002	3.9938e-002	3.7996e-002	-2.8582e-011
1835	-3.0083e-002	3.9937e-002	3.8995e-002	-2.9547e-011
1836	-3.0085e-002	3.9936e-002	3.9994e-002	-1.2338e-010
1837	-3.0091e-002	3.9932e-002	4.0993e-002	-2.0946e-010
1838	-3.01e-002	3.9925e-002	4.1998e-002	-1.8223e-010
1839	-3.0108e-002	3.9919e-002	4.3e-002	-1.7592e-010
1840	-2.9309e-002	4.0509e-002	4.3e-002	-2.2504e-011
1841	-2.8498e-002	4.1084e-002	4.3e-002	-3.2702e-011
1842	-2.6842e-002	4.2184e-002	4.3e-002	1.7679e-011
1843	-2.5998e-002	4.271e-002	4.3e-002	-2.4732e-011
1844	-2.5143e-002	4.3218e-002	4.3e-002	-3.8287e-012
1845	-2.4279e-002	4.371e-002	4.3e-002	-7.5022e-012
1846	-2.3405e-002	4.4184e-002	4.3e-002	-7.0103e-012
1847	-2.2522e-002	4.464e-002	4.3e-002	-7.7265e-012
1848	-2.163e-002	4.5079e-002	4.3e-002	-9.0168e-012
1849	-2.073e-002	4.55e-002	4.3e-002	-1.0973e-011
1850	-1.9821e-002	4.5904e-002	4.3e-002	-1.3279e-011
1851	-1.8904e-002	4.6288e-002	4.3e-002	-1.5689e-011
1852	-1.798e-002	4.6655e-002	4.3e-002	-1.8017e-011
1853	-1.7049e-002	4.7003e-002	4.3e-002	-2.0092e-011
1854	-1.6111e-002	4.7333e-002	4.3e-002	-2.1802e-011
1855	-1.5167e-002	4.7644e-002	4.3e-002	-2.3107e-011
1856	-1.4217e-002	4.7936e-002	4.3e-002	-2.3981e-011
1857	-1.3261e-002	4.8209e-002	4.3e-002	-2.4415e-011
1858	-1.23e-002	4.8464e-002	4.3e-002	-2.4469e-011
1859	-1.1334e-002	4.8699e-002	4.3e-002	-2.4186e-011
1860	-1.0363e-002	4.8914e-002	4.3e-002	-2.3609e-011
1861	-9.3887e-003	4.9111e-002	4.3e-002	-2.2812e-011
1862	-8.4103e-003	4.9288e-002	4.3e-002	-2.186e-011
1863	-7.4288e-003	4.9445e-002	4.3e-002	-2.0796e-011
1864	-6.4442e-003	4.9583e-002	4.3e-002	-1.9648e-011
1865	-5.4571e-003	4.9701e-002	4.3e-002	-1.8439e-011
1866	-4.4678e-003	4.98e-002	4.3e-002	-1.72e-011
1867	-3.4769e-003	4.9879e-002	4.3e-002	-1.5918e-011
1868	-2.4844e-003	4.9938e-002	4.3e-002	-1.4621e-011
1869	-1.4911e-003	4.9978e-002	4.3e-002	-1.3334e-011
1870	-4.971e-004	4.9998e-002	4.3e-002	-1.2063e-011
1871	4.9702e-004	4.9998e-002	4.3e-002	-1.0811e-011
1872	1.491e-003	4.9978e-002	4.3e-002	-9.5867e-012
1873	2.4844e-003	4.9938e-002	4.3e-002	-8.407e-012
1874	3.4768e-003	4.9879e-002	4.3e-002	-7.2898e-012
1875	4.4678e-003	4.98e-002	4.3e-002	-6.2457e-012
1876	5.457e-003	4.9701e-002	4.3e-002	-5.275e-012
1877	6.4441e-003	4.9583e-002	4.3e-002	-4.3777e-012
1878	7.4287e-003	4.9445e-002	4.3e-002	-3.5746e-012
1879	8.4103e-003	4.9288e-002	4.3e-002	-2.8485e-012
1880	9.3886e-003	4.9111e-002	4.3e-002	-2.2036e-012
1881	1.0363e-002	4.8914e-002	4.3e-002	-1.6355e-012
1882	1.1334e-002	4.8699e-002	4.3e-002	-1.1476e-012
1883	1.23e-002	4.8464e-002	4.3e-002	-7.4422e-013
1884	1.3261e-002	4.8209e-002	4.3e-002	-4.0092e-013
1885	1.4217e-002	4.7936e-002	4.3e-002	-1.058e-013
1886	1.5167e-002	4.7644e-002	4.3e-002	1.2085e-013
1887	1.6111e-002	4.7333e-002	4.3e-002	2.8375e-013
1888	1.7049e-002	4.7003e-002	4.3e-002	3.9429e-013
1889	1.798e-002	4.6655e-002	4.3e-002	4.6555e-013
1890	1.8904e-002	4.6289e-002	4.3e-002	4.9637e-013
1891	1.9821e-002	4.5904e-002	4.3e-002	4.9784e-013
1892	2.073e-002	4.55e-002	4.3e-002	4.7453e-013
1893	2.163e-002	4.5079e-002	4.3e-002	4.2333e-013
1894	2.2522e-002	4.464e-002	4.3e-002	4.0615e-013
1895	2.3405e-002	4.4184e-002	4.3e-002	3.2637e-013
1896	2.4279e-002	4.371e-002	4.3e-002	2.3002e-013
1897	2.5143e-002	4.3218e-002	4.3e-002	3.4279e-014
1898	2.5998e-002	4.271e-002	4.3e-002	6.5963e-013
1899	2.6842e-002	4.2184e-002	4.3e-002	-1.883e-012
1900	2.7675e-002	4.1642e-002	4.3e-002	-1.4013e-012
1901	2.8497e-002	4.1084e-002	4.3e-002	7.9671e-013
1902	2.9309e-002	4.0509e-002	4.3e-002	-5.6017e-012
1903	3.0108e-002	3.9918e-002	4.3e-002	-9.0651e-012
1904	3.0108e-002	3.9918e-002	4.2e-002	-9.9801e-012
1905	3.0108e-002	3.9918e-002	4.1e-002	-9.2886e-012
1906	3.0108e-002	3.9918e-002	4.e-002	-6.2764e-012
1907	3.0109e-002	3.9918e-002	3.9e-002	-3.3994e-012
1908	3.0109e-002	3.9918e-002	3.8e-002	-1.6008e-012
1909	3.0109e-002	3.9918e-002	3.7e-002	-2.3956e-013
1910	3.0109e-002	3.9918e-002	3.6e-002	7.3517e-013
1911	3.0109e-002	3.9918e-002	3.5e-002	1.1853e-012
1912	3.0109e-002	3.9918e-002	3.4e-002	1.0128e-012
1913	3.0109e-002	3.9918e-002	3.3e-002	9.9712e-013
1914	3.0109e-002	3.9918e-002	3.2e-002	1.2657e-012
1915	3.0109e-002	3.9918e-002	3.1e-002	1.4788e-012
1916	3.0109e-002	3.9918e-002	3.e-002	1.6925e-012
1917	3.0109e-002	3.9918e-002	2.9e-002	1.8976e-012
1918	3.0109e-002	3.9918e-002	2.8e-002	2.0257e-012
1919	3.0109e-002	3.9918e-002	2.7e-002	2.1145e-012
1920	3.0109e-002	3.9918e-002	2.6e-002	2.1794e-012
1921	3.0109e-002	3.9918e-002	2.5e-002	2.213e-012
1922	3.0109e-002	3.9918e-002	2.4e-002	2.1759e-012
1923	3.0109e-002	3.9918e-002	2.3e-002	2.1159e-012
1924	3.0109e-002	3.9918e-002	2.2e-002	2.0308e-012
1925	3.0109e-002	3.9918e-002	2.1e-002	1.9631e-012
1926	3.0109e-002	3.9918e-002	2.e-002	1.9101e-012
1927	3.0109e-002	3.9918e-002	1.9e-002	1.9355e-012
1928	3.0109e-002	3.9918e-002	1.8e-002	2.0518e-012
1929	3.0109e-002	3.9918e-002	1.7e-002	2.2862e-012
1930	3.0109e-002	3.9918e-002	1.6e-002	2.6579e-012
1931	3.0109e-002	3.9918e-002	1.5e-002	3.2894e-012
1932	3.0109e-002	3.9918e-002	1.4e-002	3.9626e-012
1933	3.0109e-002	3.9918e-002	1.3e-002	5.7911e-012
1934	3.0109e-002	3.9918e-002	1.2e-002	1.0751e-011
1935	3.0109e-002	3.9918e-002	1.1e-002	-2.693e-012
1936	3.0109e-002	3.9918e-002	1.e-002	-3.4799e-011
1937	3.0109e-002	3.9918e-002	9.e-003	-4.1203e-011
1938	3.0109e-002	3.9918e-002	8.e-003	-1.0715e-011
1939	-2.9301e-002	4.0515e-002	4.1998e-002	-2.0211e-011
1940	-2.8493e-002	4.1087e-002	4.2002e-002	-1.3787e-011
1941	-2.7675e-002	4.1642e-002	4.2e-002	1.0644e-010
1942	-2.6842e-002	4.2184e-002	4.2e-002	3.7375e-011
1943	-2.5998e-002	4.271e-002	4.2e-002	-1.242e-011
1944	-2.5143e-002	4.3218e-002	4.2e-002	1.7598e-011
1945	-2.4279e-002	4.371e-002	4.2e-002	8.8623e-012
1946	-2.3405e-002	4.4184e-002	4.2e-002	7.5122e-012
1947	-2.2522e-002	4.464e-002	4.2e-002	4.569e-012
1948	-2.163e-002	4.5079e-002	4.2e-002	7.3008e-013
1949	-2.073e-002	4.55e-002	4.2e-002	-3.4143e-012
1950	-1.9821e-002	4.5904e-002	4.2e-002	-7.627e-012
1951	-1.8904e-002	4.6288e-002	4.2e-002	-1.1638e-011
1952	-1.798e-002	4.6655e-002	4.2e-002	-1.5238e-011
1953	-1.7049e-002	4.7003e-002	4.2e-002	-1.8303e-011
1954	-1.6111e-002	4.7333e-002	4.2e-002	-2.0751e-011
1955	-1.5167e-002	4.7644e-002	4.2e-002	-2.2574e-011
1956	-1.4217e-002	4.7936e-002	4.2e-002	-2.3779e-011
1957	-1.3261e-002	4.8209e-002	4.2e-002	-2.442e-011
1958	-1.23e-002	4.8464e-002	4.2e-002	-2.4564e-011
1959	-1.1334e-002	4.8699e-002	4.2e-002	-2.4315e-011
1960	-1.0363e-002	4.8914e-002	4.2e-002	-2.3735e-011
1961	-9.3887e-003	4.9111e-002	4.2e-002	-2.2912e-011
1962	-8.4103e-003	4.9288e-002	4.2e-002	-2.1935e-011
1963	-7.4288e-003	4.9445e-002	4.2e-002	-2.0862e-011
1964	-6.4442e-003	4.9583e-002	4.2e-002	-1.9685e-011
1965	-5.4571e-003	4.9701e-002	4.2e-002	-1.8455e-011
1966	-4.4678e-003	4.98e-002	4.2e-002	-1.7196e-011
1967	-3.4769e-003	4.9879e-002	4.2e-002	-1.5904e-011
1968	-2.4844e-003	4.9938e-002	4.2e-002	-1.4581e-011
1969	-1.4911e-003	4.9978e-002	4.2e-002	-1.3269e-011
1970	-4.9708e-004	4.9998e-002	4.2e-002	-1.1964e-011
1971	4.9702e-004	4.9998e-002	4.2e-002	-1.0677e-011
1972	1.491e-003	4.9978e-002	4.2e-002	-9.4114e-012
1973	2.4844e-003	4.9938e-002	4.2e-002	-8.2046e-012
1974	3.4768e-003	4.9879e-002	4.2e-002	-7.0568e-012
1975	4.4678e-003	4.98e-002	4.2e-002	-5.9966e-012
1976	5.4571e-003	4.9701e-002	4.2e-002	-4.9956e-012
1977	6.4441e-003	4.9583e-002	4.2e-002	-4.0775e-012
1978	7.4287e-003	4.9445e-002	4.2e-002	-3.271e-012
1979	8.4103e-003	4.9288e-002	4.2e-002	-2.5528e-012
1980	9.3886e-003	4.9111e-002	4.2e-002	-1.9056e-012
1981	1.0363e-002	4.8914e-002	4.2e-002	-1.3469e-012
1982	1.1334e-002	4.8699e-002	4.2e-002	-8.5993e-013
1983	1.23e-002	4.8464e-002	4.2e-002	-4.5348e-013
1984	1.3261e-002	4.8209e-002	4.2e-002	-1.1553e-013
1985	1.4217e-002	4.7936e-002	4.2e-002	1.4798e-013
1986	1.5167e-002	4.7644e-002	4.2e-002	3.6256e-013
1987	1.6111e-002	4.7333e-002	4.2e-002	5.1489e-013
1988	1.7049e-002	4.7003e-002	4.2e-002	6.0452e-013
1989	1.798e-002	4.6655e-002	4.2e-002	6.3573e-013
1990	1.8904e-002	4.6289e-002	4.2e-002	6.3218e-013
1991	1.9821e-002	4.5904e-002	4.2e-002	5.7802e-013
1992	2.073e-002	4.55e-002	4.2e-002	4.8498e-013
1993	2.163e-002	4.5079e-002	4.2e-002	2.9598e-013
1994	2.2522e-002	4.464e-002	4.2e-002	2.1319e-013
1995	2.3405e-002	4.4184e-002	4.2e-002	4.8013e-014
1996	2.4279e-002	4.371e-002	4.2e-002	-2.1699e-013
1997	2.5143e-002	4.3218e-002	4.2e-002	-6.7567e-013
1998	2.5998e-002	4.271e-002	4.2e-002	1.3922e-013
1999	2.6842e-002	4.2184e-002	4.2e-002	-1.3397e-012
2000	2.7675e-002	4.1642e-002	4.2e-002	-2.5169e-012
2001	2.8497e-002	4.1084e-002	4.2e-002	1.5392e-013
2002	2.9309e-002	4.0509e-002	4.2e-002	-3.8385e-012
2003	2.9309e-002	4.0509e-002	4.1e-002	-2.4621e-012
2004	2.9309e-002	4.0509e-002	4.e-002	-2.2895e-012
2005	2.9309e-002	4.0509e-002	3.9e-002	-3.1459e-012
2006	2.9309e-002	4.0509e-002	3.8e-002	-3.7468e-012
2007	2.9309e-002	4.0509e-002	3.7e-002	-3.7533e-012
2008	2.9309e-002	4.0509e-002	3.6e-002	-4.1235e-012
2009	2.9309e-002	4.0509e-002	3.5e-002	-4.4456e-012
2010	2.9309e-002	4.0509e-002	3.4e-002	-4.319e-012
2011	2.9309e-002	4.0509e-002	3.3e-002	-4.2341e-012
2012	2.9309e-002	4.0509e-002	3.2e-002	-4.4303e-012
2013	2.9309e-002	4.0509e-002	3.e-002	-4.7486e-012
2014	2.9309e-002	4.0509e-002	2.8e-002	-5.1617e-012
2015	2.9309e-002	4.0509e-002	2.6e-002	-5.6342e-012
2016	2.9309e-002	4.0509e-002	2.4e-002	-6.2583e-012
2017	2.9309e-002	4.0509e-002	2.2e-002	-7.0894e-012
2018	2.9309e-002	4.0509e-002	2.e-002	-7.8528e-012
2019	2.9309e-002	4.0509e-002	1.8e-002	-8.2792e-012
2020	2.9309e-002	4.0509e-002	1.6e-002	-8.35e-012
2021	2.9309e-002	4.0509e-002	1.4e-002	-7.9446e-012
2022	2.9309e-002	4.0509e-002	1.3e-002	-8.8252e-012
2023	2.931e-002	4.0509e-002	1.2e-002	4.9704e-013
2024	2.931e-002	4.0509e-002	1.1e-002	2.2493e-011
2025	2.931e-002	4.0509e-002	9.9999e-003	4.3035e-011
2026	2.931e-002	4.0509e-002	8.9999e-003	3.6447e-011
2027	2.931e-002	4.0508e-002	7.9999e-003	2.4741e-011
2028	2.8498e-002	4.1084e-002	8.e-003	4.5962e-011
2029	2.7675e-002	4.1642e-002	8.e-003	-5.9261e-011
2030	2.5998e-002	4.271e-002	8.e-003	4.3297e-011
2031	2.4279e-002	4.371e-002	8.e-003	5.4722e-012
2032	2.2522e-002	4.464e-002	8.e-003	2.9395e-012
2033	2.073e-002	4.55e-002	8.e-003	9.9495e-013
2034	1.8904e-002	4.6289e-002	8.e-003	-4.2688e-013
2035	1.7049e-002	4.7003e-002	8.e-003	-1.6169e-012
2036	1.5167e-002	4.7644e-002	8.e-003	-2.6145e-012
2037	1.3261e-002	4.8209e-002	8.e-003	-3.4183e-012
2038	1.1334e-002	4.8699e-002	8.e-003	-4.1145e-012
2039	9.3886e-003	4.9111e-002	8.e-003	-4.7827e-012
2040	7.4287e-003	4.9445e-002	8.e-003	-5.4943e-012
2041	5.4571e-003	4.9701e-002	8.e-003	-6.2534e-012
2042	3.4768e-003	4.9879e-002	8.e-003	-7.074e-012
2043	1.4911e-003	4.9978e-002	8.e-003	-8.0352e-012
2044	-4.9704e-004	4.9998e-002	8.e-003	-9.1078e-012
2045	-2.4844e-003	4.9938e-002	8.e-003	-1.042e-011
2046	-4.4678e-003	4.98e-002	8.e-003	-1.2011e-011
2047	-6.4441e-003	4.9583e-002	8.e-003	-1.3951e-011
2048	-8.4103e-003	4.9288e-002	8.e-003	-1.6153e-011
2049	-1.0363e-002	4.8914e-002	8.e-003	-1.8184e-011
2050	-1.23e-002	4.8464e-002	8.e-003	-1.9351e-011
2051	-1.4217e-002	4.7936e-002	8.e-003	-1.8591e-011
2052	-1.6111e-002	4.7333e-002	8.e-003	-1.4592e-011
2053	-1.798e-002	4.6655e-002	8.e-003	-5.8827e-012
2054	-1.9821e-002	4.5904e-002	8.e-003	8.9851e-012
2055	-2.163e-002	4.5079e-002	8.e-003	3.1991e-011
2056	-2.3405e-002	4.4184e-002	8.e-003	6.7238e-011
2057	-2.5143e-002	4.3218e-002	8.e-003	4.9147e-011
2058	-2.682e-002	4.2198e-002	7.9663e-003	1.6354e-010
2059	-2.7651e-002	4.1659e-002	7.954e-003	9.3633e-011
2060	-2.8472e-002	4.1102e-002	7.9551e-003	2.0846e-010
2061	-2.9282e-002	4.0528e-002	7.9677e-003	4.2631e-010
2062	-2.926e-002	4.0545e-002	8.9743e-003	3.6755e-010
2063	-2.8451e-002	4.1116e-002	8.9602e-003	1.8906e-010
2064	-2.9244e-002	4.0556e-002	9.9807e-003	2.9534e-010
2065	-2.9243e-002	4.0557e-002	1.0988e-002	2.1506e-010
2066	-2.9244e-002	4.0556e-002	1.1995e-002	2.0812e-011
2067	-2.9247e-002	4.0553e-002	1.3e-002	-1.7506e-010
2068	-2.925e-002	4.0551e-002	1.4003e-002	-2.2772e-010
2069	-2.9259e-002	4.0545e-002	1.4999e-002	-2.3845e-010
2070	-2.9271e-002	4.0537e-002	1.5995e-002	-3.3371e-010
2071	-2.9307e-002	4.0511e-002	1.7993e-002	-5.0904e-010
2072	-2.9354e-002	4.0476e-002	2.0001e-002	-3.366e-010
2073	-2.9378e-002	4.0459e-002	2.2018e-002	3.4357e-011
2074	-2.9337e-002	4.0489e-002	2.4025e-002	2.5096e-010
2075	-2.9298e-002	4.0517e-002	2.6007e-002	3.1292e-010
2076	-2.9283e-002	4.0528e-002	2.7997e-002	1.9849e-010
2077	-2.9284e-002	4.0527e-002	2.9996e-002	5.0773e-011
2078	-2.9284e-002	4.0527e-002	3.0996e-002	1.2834e-010
2079	-2.9284e-002	4.0527e-002	3.1995e-002	1.3886e-010
2080	-2.9286e-002	4.0526e-002	3.2995e-002	-6.5688e-012
2081	-2.9288e-002	4.0525e-002	3.3995e-002	-6.8019e-011
2082	-2.9287e-002	4.0525e-002	3.4995e-002	-2.6974e-011
2083	-2.9286e-002	4.0526e-002	3.5995e-002	1.8611e-011
2084	-2.9286e-002	4.0525e-002	3.6995e-002	-2.8223e-011
2085	-2.9288e-002	4.0525e-002	3.7995e-002	-9.0065e-011
2086	-2.9289e-002	4.0523e-002	3.8995e-002	-1.1214e-010
2087	-2.9293e-002	4.0521e-002	3.9998e-002	-1.3428e-010
2088	-2.9297e-002	4.0518e-002	4.0999e-002	-8.9736e-011
2089	2.8497e-002	4.1084e-002	4.1e-002	-1.6694e-012
2090	2.7675e-002	4.1642e-002	4.1e-002	-3.1327e-012
2091	2.8497e-002	4.1084e-002	4.e-002	-4.1403e-012
2092	2.8497e-002	4.1084e-002	3.9e-002	-6.9112e-012
2093	2.8498e-002	4.1084e-002	3.8e-002	-9.3799e-012
2094	2.8498e-002	4.1084e-002	3.7e-002	-1.0624e-011
2095	2.8498e-002	4.1084e-002	3.6e-002	-1.077e-011
2096	2.8498e-002	4.1084e-002	3.5e-002	-9.8743e-012
2097	2.8498e-002	4.1084e-002	3.4e-002	-8.3952e-012
2098	2.8498e-002	4.1083e-002	3.3e-002	-7.7079e-012
2099	2.8498e-002	4.1083e-002	3.2e-002	-7.9909e-012
2100	2.8498e-002	4.1083e-002	3.1e-002	-8.5898e-012
2101	2.8499e-002	4.1083e-002	3.e-002	-9.0462e-012
2102	2.8499e-002	4.1083e-002	2.9e-002	-9.3523e-012
2103	2.8499e-002	4.1083e-002	2.8e-002	-9.5277e-012
2104	2.8499e-002	4.1083e-002	2.7e-002	-9.6482e-012
2105	2.8499e-002	4.1083e-002	2.6e-002	-9.7596e-012
2106	2.8499e-002	4.1083e-002	2.5e-002	-9.8327e-012
2107	2.8499e-002	4.1083e-002	2.4e-002	-9.959e-012
2108	2.8499e-002	4.1083e-002	2.3e-002	-1.0164e-011
2109	2.85e-002	4.1083e-002	2.2e-002	-1.0312e-011
2110	2.85e-002	4.1082e-002	2.1e-002	-1.0443e-011
2111	2.85e-002	4.1082e-002	2.e-002	-1.0544e-011
2112	2.85e-002	4.1082e-002	1.9e-002	-1.0564e-011
2113	2.85e-002	4.1082e-002	1.8e-002	-1.0461e-011
2114	2.85e-002	4.1082e-002	1.7e-002	-1.0193e-011
2115	2.85e-002	4.1082e-002	1.6e-002	-9.7438e-012
2116	2.85e-002	4.1082e-002	1.5e-002	-9.3817e-012
2117	2.85e-002	4.1082e-002	1.4e-002	-9.2615e-012
2118	2.8501e-002	4.1082e-002	1.3e-002	-9.848e-012
2119	2.8501e-002	4.1082e-002	1.2e-002	-1.2674e-011
2120	2.8501e-002	4.1082e-002	1.1e-002	1.2301e-012
2121	2.8501e-002	4.1082e-002	9.9998e-003	4.0789e-011
2122	2.8501e-002	4.1082e-002	8.9998e-003	5.9682e-011
2123	2.7675e-002	4.1642e-002	9.e-003	-1.0781e-010
2124	2.6842e-002	4.2184e-002	9.e-003	9.9533e-012
2125	2.5998e-002	4.271e-002	9.e-003	6.1352e-011
2126	2.5143e-002	4.3218e-002	9.e-003	-1.068e-011
2127	2.4279e-002	4.371e-002	9.e-003	1.1456e-011
2128	2.3405e-002	4.4184e-002	9.e-003	4.3401e-012
2129	2.2522e-002	4.464e-002	9.e-003	4.2052e-012
2130	2.163e-002	4.5079e-002	9.e-003	2.6817e-012
2131	2.073e-002	4.55e-002	9.e-003	1.7085e-012
2132	1.9821e-002	4.5904e-002	9.e-003	9.7982e-013
2133	1.8904e-002	4.6288e-002	9.e-003	1.6224e-013
2134	1.798e-002	4.6655e-002	9.e-003	-6.8455e-013
2135	1.7049e-002	4.7003e-002	9.e-003	-1.2422e-012
2136	1.6111e-002	4.7333e-002	9.e-003	-1.8516e-012
2137	1.5167e-002	4.7644e-002	9.e-003	-2.3417e-012
2138	1.4217e-002	4.7936e-002	9.e-003	-2.7908e-012
2139	1.3261e-002	4.8209e-002	9.e-003	-3.1901e-012
2140	1.23e-002	4.8464e-002	9.e-003	-3.5403e-012
2141	1.1334e-002	4.8699e-002	9.e-003	-3.882e-012
2142	1.0363e-002	4.8914e-002	9.e-003	-4.208e-012
2143	9.3887e-003	4.9111e-002	9.e-003	-4.5156e-012
2144	8.4103e-003	4.9288e-002	9.e-003	-4.839e-012
2145	7.4288e-003	4.9445e-002	9.e-003	-5.1653e-012
2146	6.4442e-003	4.9583e-002	9.e-003	-5.4947e-012
2147	5.4571e-003	4.9701e-002	9.e-003	-5.8278e-012
2148	4.4678e-003	4.98e-002	9.e-003	-6.1704e-012
2149	3.4769e-003	4.9879e-002	9.e-003	-6.5171e-012
2150	2.4844e-003	4.9938e-002	9.e-003	-6.8675e-012
2151	1.4911e-003	4.9978e-002	9.e-003	-7.2544e-012
2152	4.9709e-004	4.9998e-002	9.e-003	-7.6459e-012
2153	-4.9701e-004	4.9998e-002	9.e-003	-8.0303e-012
2154	-1.491e-003	4.9978e-002	9.e-003	-8.4585e-012
2155	-2.4843e-003	4.9938e-002	9.e-003	-8.9341e-012
2156	-3.4768e-003	4.9879e-002	9.e-003	-9.464e-012
2157	-4.4678e-003	4.98e-002	9.e-003	-1.0047e-011
2158	-5.4571e-003	4.9701e-002	9.e-003	-1.0692e-011
2159	-6.4441e-003	4.9583e-002	9.e-003	-1.145e-011
2160	-7.4287e-003	4.9445e-002	9.e-003	-1.2297e-011
2161	-8.4102e-003	4.9288e-002	9.e-003	-1.318e-011
2162	-9.3886e-003	4.9111e-002	9.e-003	-1.4059e-011
2163	-1.0363e-002	4.8914e-002	9.e-003	-1.4867e-011
2164	-1.1334e-002	4.8699e-002	9.e-003	-1.5522e-011
2165	-1.23e-002	4.8464e-002	9.e-003	-1.5914e-011
2166	-1.3261e-002	4.8209e-002	9.e-003	-1.5902e-011
2167	-1.4217e-002	4.7936e-002	9.e-003	-1.5364e-011
2168	-1.5167e-002	4.7644e-002	9.e-003	-1.4163e-011
2169	-1.6111e-002	4.7333e-002	9.e-003	-1.2122e-011
2170	-1.7049e-002	4.7003e-002	9.e-003	-9.0563e-012
2171	-1.798e-002	4.6655e-002	9.e-003	-4.8189e-012
2172	-1.8904e-002	4.6289e-002	9.e-003	8.407e-013
2173	-1.9821e-002	4.5904e-002	9.e-003	7.8545e-012
2174	-2.073e-002	4.55e-002	9.e-003	1.767e-011
2175	-2.163e-002	4.5079e-002	9.e-003	2.6789e-011
2176	-2.2522e-002	4.464e-002	9.e-003	5.5808e-011
2177	-2.3405e-002	4.4184e-002	9.e-003	5.7545e-011
2178	-2.4279e-002	4.371e-002	9.e-003	2.9435e-011
2179	-2.5135e-002	4.3223e-002	8.9959e-003	4.7089e-011
2180	-2.5981e-002	4.272e-002	8.988e-003	9.4522e-011
2181	-2.6811e-002	4.2204e-002	8.9643e-003	1.3283e-010
2182	-2.7638e-002	4.1667e-002	8.9609e-003	1.4966e-010
2183	-2.8438e-002	4.1125e-002	9.9704e-003	2.4437e-010
2184	-2.8435e-002	4.1127e-002	1.0985e-002	2.6038e-010
2185	-2.8488e-002	4.109e-002	4.1002e-002	5.6217e-011
2186	-2.7675e-002	4.1642e-002	4.1e-002	9.4883e-011
2187	-2.6842e-002	4.2184e-002	4.1e-002	8.0736e-011
2188	-2.5998e-002	4.271e-002	4.1e-002	2.5894e-011
2189	-2.5143e-002	4.3218e-002	4.1e-002	3.2368e-011
2190	-2.4279e-002	4.371e-002	4.1e-002	2.3977e-011
2191	-2.3405e-002	4.4184e-002	4.1e-002	2.0595e-011
2192	-2.2522e-002	4.464e-002	4.1e-002	1.5171e-011
2193	-2.163e-002	4.5079e-002	4.1e-002	8.73e-012
2194	-2.073e-002	4.55e-002	4.1e-002	2.6328e-012
2195	-1.9821e-002	4.5904e-002	4.1e-002	-3.2804e-012
2196	-1.8904e-002	4.6288e-002	4.1e-002	-8.6276e-012
2197	-1.798e-002	4.6655e-002	4.1e-002	-1.3233e-011
2198	-1.7049e-002	4.7003e-002	4.1e-002	-1.7031e-011
2199	-1.6111e-002	4.7333e-002	4.1e-002	-1.9982e-011
2200	-1.5167e-002	4.7644e-002	4.1e-002	-2.2125e-011
2201	-1.4217e-002	4.7936e-002	4.1e-002	-2.3486e-011
2202	-1.3261e-002	4.8209e-002	4.1e-002	-2.4197e-011
2203	-1.23e-002	4.8464e-002	4.1e-002	-2.4328e-011
2204	-1.1334e-002	4.8699e-002	4.1e-002	-2.4033e-011
2205	-1.0363e-002	4.8914e-002	4.1e-002	-2.3398e-011
2206	-9.3887e-003	4.9111e-002	4.1e-002	-2.2537e-011
2207	-8.4103e-003	4.9288e-002	4.1e-002	-2.1513e-011
2208	-7.4288e-003	4.9445e-002	4.1e-002	-2.0418e-011
2209	-6.4442e-003	4.9583e-002	4.1e-002	-1.9231e-011
2210	-5.4571e-003	4.9701e-002	4.1e-002	-1.8024e-011
2211	-4.4678e-003	4.98e-002	4.1e-002	-1.6775e-011
2212	-3.4769e-003	4.9879e-002	4.1e-002	-1.55e-011
2213	-2.4844e-003	4.9938e-002	4.1e-002	-1.417e-011
2214	-1.4911e-003	4.9978e-002	4.1e-002	-1.2852e-011
2215	-4.971e-004	4.9998e-002	4.1e-002	-1.1528e-011
2216	4.9702e-004	4.9998e-002	4.1e-002	-1.023e-011
2217	1.491e-003	4.9978e-002	4.1e-002	-8.9431e-012
2218	2.4844e-003	4.9938e-002	4.1e-002	-7.7346e-012
2219	3.4768e-003	4.9879e-002	4.1e-002	-6.5779e-012
2220	4.4678e-003	4.98e-002	4.1e-002	-5.522e-012
2221	5.457e-003	4.9701e-002	4.1e-002	-4.5237e-012
2222	6.4441e-003	4.9583e-002	4.1e-002	-3.6291e-012
2223	7.4287e-003	4.9445e-002	4.1e-002	-2.827e-012
2224	8.4103e-003	4.9288e-002	4.1e-002	-2.1253e-012
2225	9.3886e-003	4.9111e-002	4.1e-002	-1.4849e-012
2226	1.0363e-002	4.8914e-002	4.1e-002	-9.622e-013
2227	1.1334e-002	4.8699e-002	4.1e-002	-5.0233e-013
2228	1.23e-002	4.8464e-002	4.1e-002	-1.1784e-013
2229	1.3261e-002	4.8209e-002	4.1e-002	2.0948e-013
2230	1.4217e-002	4.7936e-002	4.1e-002	4.4289e-013
2231	1.5167e-002	4.7644e-002	4.1e-002	6.3443e-013
2232	1.6111e-002	4.7333e-002	4.1e-002	7.5922e-013
2233	1.7049e-002	4.7004e-002	4.1e-002	8.3678e-013
2234	1.798e-002	4.6655e-002	4.1e-002	8.3701e-013
2235	1.8904e-002	4.6289e-002	4.1e-002	7.9058e-013
2236	1.9821e-002	4.5904e-002	4.1e-002	6.7243e-013
2237	2.073e-002	4.55e-002	4.1e-002	5.3152e-013
2238	2.163e-002	4.5079e-002	4.1e-002	2.7118e-013
2239	2.2522e-002	4.464e-002	4.1e-002	2.7182e-014
2240	2.3405e-002	4.4184e-002	4.1e-002	-1.561e-013
2241	2.4279e-002	4.371e-002	4.1e-002	-5.5521e-013
2242	2.5143e-002	4.3218e-002	4.1e-002	-1.0525e-012
2243	2.5998e-002	4.271e-002	4.1e-002	-9.3668e-013
2244	2.6842e-002	4.2184e-002	4.1e-002	-7.4922e-013
2245	-2.7623e-002	4.1677e-002	1.0982e-002	2.4427e-010
2246	-2.8492e-002	4.1088e-002	4.e-002	-4.4263e-012
2247	-2.8482e-002	4.1095e-002	3.9e-002	-1.392e-010
2248	-2.8481e-002	4.1095e-002	3.7999e-002	-1.5839e-010
2249	-2.848e-002	4.1096e-002	3.6998e-002	-9.1943e-011
2250	-2.8478e-002	4.1097e-002	3.5998e-002	-7.4086e-011
2251	-2.8478e-002	4.1098e-002	3.4997e-002	-8.4746e-011
2252	-2.8477e-002	4.1098e-002	3.3998e-002	-6.4331e-011
2253	-2.8475e-002	4.11e-002	3.2998e-002	-3.7483e-011
2254	-2.8474e-002	4.11e-002	3.1998e-002	7.1054e-011
2255	-2.8472e-002	4.1101e-002	3.0999e-002	1.7038e-010
2256	-2.8479e-002	4.1097e-002	2.9998e-002	1.9335e-010
2257	-2.8479e-002	4.1097e-002	2.8998e-002	2.0845e-010
2258	-2.8478e-002	4.1097e-002	2.7998e-002	2.2275e-010
2259	-2.8477e-002	4.1098e-002	2.6999e-002	2.7966e-010
2260	-2.8492e-002	4.1088e-002	2.6012e-002	4.3584e-010
2261	-2.8513e-002	4.1073e-002	2.5025e-002	5.9931e-010
2262	-2.8545e-002	4.1051e-002	2.4034e-002	6.1593e-010
2263	-2.8581e-002	4.1026e-002	2.3037e-002	3.3499e-010
2264	-2.8603e-002	4.1011e-002	2.2033e-002	-5.7145e-011
2265	-2.8586e-002	4.1022e-002	2.1026e-002	-3.224e-010
2266	-2.8559e-002	4.1041e-002	2.002e-002	-5.461e-010
2267	-2.8535e-002	4.1058e-002	1.9017e-002	-6.1793e-010
2268	-2.85e-002	4.1082e-002	1.8011e-002	-6.4237e-010
2269	-2.8475e-002	4.11e-002	1.7005e-002	-6.7709e-010
2270	-2.845e-002	4.1117e-002	1.6005e-002	-5.9863e-010
2271	-2.8433e-002	4.1128e-002	1.5007e-002	-3.4293e-010
2272	-2.8428e-002	4.1132e-002	1.4009e-002	-3.2233e-012
2273	-2.8431e-002	4.113e-002	1.3004e-002	1.8568e-010
2274	-2.8436e-002	4.1126e-002	1.1995e-002	2.2973e-010
2275	-2.7622e-002	4.1677e-002	1.1991e-002	2.067e-010
2276	-2.6802e-002	4.221e-002	9.9715e-003	9.4109e-011
2277	2.7675e-002	4.1642e-002	4.e-002	-1.5406e-012
2278	-2.68e-002	4.2211e-002	1.0979e-002	5.2405e-011
2279	2.7675e-002	4.1642e-002	3.9e-002	1.7395e-012
2280	2.7675e-002	4.1642e-002	3.8e-002	4.2263e-012
2281	2.7675e-002	4.1643e-002	3.7e-002	4.1243e-012
2282	2.7675e-002	4.1643e-002	3.6e-002	5.256e-012
2283	2.7675e-002	4.1643e-002	3.5e-002	8.0487e-012
2284	2.7675e-002	4.1643e-002	3.4e-002	9.4273e-012
2285	2.7674e-002	4.1643e-002	3.3e-002	1.0147e-011
2286	2.7674e-002	4.1643e-002	3.2e-002	1.0614e-011
2287	2.7674e-002	4.1643e-002	3.1e-002	1.1174e-011
2288	2.7674e-002	4.1643e-002	3.e-002	1.1336e-011
2289	2.7674e-002	4.1643e-002	2.9e-002	1.1263e-011
2290	2.7674e-002	4.1643e-002	2.8e-002	1.1357e-011
2291	2.7673e-002	4.1644e-002	2.7e-002	1.1829e-011
2292	2.7673e-002	4.1644e-002	2.6e-002	1.244e-011
2293	2.7673e-002	4.1644e-002	2.5e-002	1.2803e-011
2294	2.7673e-002	4.1644e-002	2.4e-002	1.3016e-011
2295	2.7673e-002	4.1644e-002	2.3e-002	1.3161e-011
2296	2.7672e-002	4.1644e-002	2.2e-002	1.3308e-011
2297	2.7672e-002	4.1644e-002	2.1e-002	1.3453e-011
2298	2.7672e-002	4.1644e-002	2.e-002	1.3624e-011
2299	2.7672e-002	4.1645e-002	1.9e-002	1.3857e-011
2300	2.7672e-002	4.1645e-002	1.8e-002	1.4173e-011
2301	2.7672e-002	4.1645e-002	1.7e-002	1.4677e-011
2302	2.7671e-002	4.1645e-002	1.6e-002	1.5139e-011
2303	2.7671e-002	4.1645e-002	1.5e-002	1.6106e-011
2304	2.7671e-002	4.1645e-002	1.4e-002	1.617e-011
2305	2.7671e-002	4.1645e-002	1.3e-002	1.9007e-011
2306	2.7671e-002	4.1645e-002	1.2e-002	5.855e-012
2307	2.767e-002	4.1646e-002	1.1e-002	-3.0457e-011
2308	2.767e-002	4.1646e-002	1.e-002	-9.3122e-011
2309	2.6842e-002	4.2184e-002	1.e-002	8.0806e-012
2310	2.5998e-002	4.271e-002	1.e-002	4.307e-011
2311	2.4279e-002	4.371e-002	1.e-002	9.5777e-012
2312	2.3405e-002	4.4184e-002	1.e-002	4.0199e-012
2313	2.2522e-002	4.464e-002	1.e-002	3.9122e-012
2314	2.163e-002	4.5079e-002	1.e-002	2.6876e-012
2315	2.073e-002	4.55e-002	1.e-002	1.7412e-012
2316	1.9821e-002	4.5904e-002	1.e-002	1.0806e-012
2317	1.8904e-002	4.6289e-002	1.e-002	3.7463e-013
2318	1.798e-002	4.6655e-002	1.e-002	-4.3516e-013
2319	1.7049e-002	4.7003e-002	1.e-002	-1.1076e-012
2320	1.6111e-002	4.7333e-002	1.e-002	-1.6796e-012
2321	1.5167e-002	4.7644e-002	1.e-002	-2.043e-012
2322	1.4217e-002	4.7936e-002	1.e-002	-2.5362e-012
2323	1.3261e-002	4.8209e-002	1.e-002	-2.9265e-012
2324	1.23e-002	4.8464e-002	1.e-002	-3.2252e-012
2325	1.1334e-002	4.8699e-002	1.e-002	-3.5388e-012
2326	1.0363e-002	4.8914e-002	1.e-002	-3.8349e-012
2327	9.3886e-003	4.9111e-002	1.e-002	-4.1213e-012
2328	8.4103e-003	4.9288e-002	1.e-002	-4.4009e-012
2329	7.4288e-003	4.9445e-002	1.e-002	-4.6758e-012
2330	6.4442e-003	4.9583e-002	1.e-002	-4.9535e-012
2331	5.4571e-003	4.9701e-002	1.e-002	-5.2142e-012
2332	4.4678e-003	4.98e-002	1.e-002	-5.474e-012
2333	3.4769e-003	4.9879e-002	1.e-002	-5.7267e-012
2334	2.4844e-003	4.9938e-002	1.e-002	-5.9668e-012
2335	1.4911e-003	4.9978e-002	1.e-002	-6.2029e-012
2336	4.9708e-004	4.9998e-002	1.e-002	-6.4332e-012
2337	-4.9703e-004	4.9998e-002	1.e-002	-6.6364e-012
2338	-1.491e-003	4.9978e-002	1.e-002	-6.8492e-012
2339	-2.4844e-003	4.9938e-002	1.e-002	-7.0772e-012
2340	-3.4768e-003	4.9879e-002	1.e-002	-7.3258e-012
2341	-4.4678e-003	4.98e-002	1.e-002	-7.6016e-012
2342	-5.4571e-003	4.9701e-002	1.e-002	-7.942e-012
2343	-6.4441e-003	4.9583e-002	1.e-002	-8.3868e-012
2344	-7.4287e-003	4.9445e-002	1.e-002	-8.9449e-012
2345	-8.4103e-003	4.9288e-002	1.e-002	-9.5648e-012
2346	-9.3886e-003	4.9111e-002	1.e-002	-1.0217e-011
2347	-1.0363e-002	4.8914e-002	1.e-002	-1.0869e-011
2348	-1.1334e-002	4.8699e-002	1.e-002	-1.1461e-011
2349	-1.23e-002	4.8464e-002	1.e-002	-1.188e-011
2350	-1.3261e-002	4.8209e-002	1.e-002	-1.2044e-011
2351	-1.4217e-002	4.7936e-002	1.e-002	-1.1886e-011
2352	-1.5167e-002	4.7644e-002	1.e-002	-1.132e-011
2353	-1.6111e-002	4.7333e-002	1.e-002	-1.0203e-011
2354	-1.7049e-002	4.7003e-002	1.e-002	-8.4193e-012
2355	-1.798e-002	4.6655e-002	1.e-002	-5.8545e-012
2356	-1.8904e-002	4.6289e-002	1.e-002	-2.4183e-012
2357	-1.9821e-002	4.5904e-002	1.e-002	1.9931e-012
2358	-2.073e-002	4.55e-002	1.e-002	7.2483e-012
2359	-2.163e-002	4.5079e-002	1.e-002	1.3931e-011
2360	-2.2522e-002	4.464e-002	1.e-002	1.9606e-011
2361	-2.3405e-002	4.4184e-002	1.e-002	1.6931e-011
2362	-2.4279e-002	4.371e-002	1.e-002	8.7821e-013
2363	-2.5135e-002	4.3223e-002	9.9976e-003	3.1707e-011
2364	-2.5975e-002	4.2724e-002	9.9876e-003	8.3405e-011
2365	-2.7616e-002	4.1681e-002	1.3002e-002	4.6178e-011
2366	-2.7612e-002	4.1684e-002	1.4008e-002	-1.826e-010
2367	-2.762e-002	4.1679e-002	1.5011e-002	-3.871e-010
2368	-2.7637e-002	4.1668e-002	1.6015e-002	-4.7502e-010
2369	-2.7662e-002	4.1651e-002	1.7025e-002	-5.143e-010
2370	-2.7693e-002	4.1631e-002	1.8032e-002	-5.7767e-010
2371	-2.7726e-002	4.1608e-002	1.9038e-002	-6.2629e-010
2372	-2.778e-002	4.1572e-002	2.1047e-002	-9.6735e-011
2373	-2.7789e-002	4.1566e-002	2.205e-002	2.1585e-010
2374	-2.7675e-002	4.1642e-002	4.e-002	8.5322e-011
2375	-2.6842e-002	4.2184e-002	4.e-002	1.1999e-010
2376	-2.5998e-002	4.271e-002	4.e-002	5.9547e-011
2377	-2.5143e-002	4.3218e-002	4.e-002	4.0179e-011
2378	-2.4279e-002	4.371e-002	4.e-002	3.4555e-011
2379	-2.3405e-002	4.4184e-002	4.e-002	2.9391e-011
2380	-2.2522e-002	4.464e-002	4.e-002	2.1175e-011
2381	-2.163e-002	4.5079e-002	4.e-002	1.3136e-011
2382	-2.073e-002	4.55e-002	4.e-002	5.6154e-012
2383	-1.9821e-002	4.5904e-002	4.e-002	-1.3836e-012
2384	-1.8904e-002	4.6288e-002	4.e-002	-7.4456e-012
2385	-1.798e-002	4.6655e-002	4.e-002	-1.2559e-011
2386	-1.7049e-002	4.7003e-002	4.e-002	-1.6699e-011
2387	-1.6111e-002	4.7333e-002	4.e-002	-1.9801e-011
2388	-1.5167e-002	4.7644e-002	4.e-002	-2.1977e-011
2389	-1.4217e-002	4.7936e-002	4.e-002	-2.3278e-011
2390	-1.3261e-002	4.8209e-002	4.e-002	-2.3872e-011
2391	-1.23e-002	4.8464e-002	4.e-002	-2.3851e-011
2392	-1.1334e-002	4.8699e-002	4.e-002	-2.3405e-011
2393	-1.0363e-002	4.8914e-002	4.e-002	-2.2639e-011
2394	-9.3887e-003	4.9111e-002	4.e-002	-2.1706e-011
2395	-8.4103e-003	4.9288e-002	4.e-002	-2.0641e-011
2396	-7.4288e-003	4.9445e-002	4.e-002	-1.9534e-011
2397	-6.4442e-003	4.9583e-002	4.e-002	-1.8372e-011
2398	-5.4572e-003	4.9701e-002	4.e-002	-1.7212e-011
2399	-4.4678e-003	4.98e-002	4.e-002	-1.5984e-011
2400	-3.4769e-003	4.9879e-002	4.e-002	-1.4727e-011
2401	-2.4844e-003	4.9938e-002	4.e-002	-1.3415e-011
2402	-1.4911e-003	4.9978e-002	4.e-002	-1.212e-011
2403	-4.9707e-004	4.9998e-002	4.e-002	-1.0794e-011
2404	4.9697e-004	4.9998e-002	4.e-002	-9.4945e-012
2405	1.491e-003	4.9978e-002	4.e-002	-8.2147e-012
2406	2.4843e-003	4.9938e-002	4.e-002	-7.0256e-012
2407	3.4768e-003	4.9879e-002	4.e-002	-5.8911e-012
2408	4.4677e-003	4.98e-002	4.e-002	-4.8474e-012
2409	5.4571e-003	4.9701e-002	4.e-002	-3.8699e-012
2410	6.4441e-003	4.9583e-002	4.e-002	-3.0364e-012
2411	7.4287e-003	4.9445e-002	4.e-002	-2.2664e-012
2412	8.4102e-003	4.9288e-002	4.e-002	-1.5878e-012
2413	9.3886e-003	4.9111e-002	4.e-002	-9.8643e-013
2414	1.0363e-002	4.8914e-002	4.e-002	-5.0819e-013
2415	1.1334e-002	4.8699e-002	4.e-002	-7.9176e-014
2416	1.23e-002	4.8464e-002	4.e-002	2.6003e-013
2417	1.3261e-002	4.8209e-002	4.e-002	5.4659e-013
2418	1.4217e-002	4.7936e-002	4.e-002	7.5274e-013
2419	1.5167e-002	4.7644e-002	4.e-002	9.2356e-013
2420	1.6111e-002	4.7333e-002	4.e-002	1.0197e-012
2421	1.7049e-002	4.7003e-002	4.e-002	1.0724e-012
2422	1.798e-002	4.6655e-002	4.e-002	1.0445e-012
2423	1.8904e-002	4.6289e-002	4.e-002	9.6901e-013
2424	1.9821e-002	4.5904e-002	4.e-002	8.0543e-013
2425	2.073e-002	4.55e-002	4.e-002	6.0976e-013
2426	2.163e-002	4.5079e-002	4.e-002	3.949e-013
2427	2.2522e-002	4.464e-002	4.e-002	9.0509e-015
2428	2.3405e-002	4.4184e-002	4.e-002	-3.3136e-013
2429	2.4279e-002	4.371e-002	4.e-002	-7.9479e-013
2430	2.5143e-002	4.3218e-002	4.e-002	-5.6255e-013
2431	2.5998e-002	4.271e-002	4.e-002	-1.7297e-012
2432	2.6842e-002	4.2184e-002	4.e-002	-2.0491e-013
2433	-2.7675e-002	4.1642e-002	3.9e-002	2.9533e-012
2434	-2.7667e-002	4.1648e-002	3.8e-002	-8.0861e-011
2435	-2.7666e-002	4.1648e-002	3.7e-002	-5.2678e-011
2436	-2.7666e-002	4.1649e-002	3.6e-002	-9.6182e-012
2437	-2.7665e-002	4.1649e-002	3.4999e-002	-3.2242e-012
2438	-2.7664e-002	4.165e-002	3.3999e-002	2.2899e-011
2439	-2.7664e-002	4.165e-002	3.3e-002	2.1028e-011
2440	-2.7663e-002	4.1651e-002	3.2e-002	-5.3668e-011
2441	-2.7662e-002	4.1651e-002	3.1e-002	-7.0627e-011
2442	-2.7661e-002	4.1652e-002	3.e-002	3.5641e-012
2443	-2.766e-002	4.1652e-002	2.9e-002	8.8311e-011
2444	-2.7659e-002	4.1653e-002	2.8e-002	1.8531e-010
2445	-2.7665e-002	4.1649e-002	2.7005e-002	2.8373e-010
2446	-2.767e-002	4.1646e-002	2.6012e-002	3.1812e-010
2447	-2.7695e-002	4.1629e-002	2.5031e-002	3.9478e-010
2448	-2.773e-002	4.1606e-002	2.4038e-002	4.7932e-010
2449	-2.7762e-002	4.1585e-002	2.3044e-002	3.9723e-010
2450	2.6842e-002	4.2184e-002	1.1e-002	1.0149e-013
2451	2.6842e-002	4.2184e-002	1.2e-002	-4.4656e-012
2452	2.6842e-002	4.2184e-002	1.3e-002	4.1602e-013
2453	2.6842e-002	4.2184e-002	1.4e-002	2.4782e-012
2454	2.6842e-002	4.2184e-002	1.5e-002	2.1421e-012
2455	2.6842e-002	4.2184e-002	1.6e-002	1.4805e-012
2456	2.6842e-002	4.2184e-002	1.7e-002	1.2307e-012
2457	2.6842e-002	4.2184e-002	1.8e-002	1.35e-012
2458	2.6842e-002	4.2184e-002	1.9e-002	1.512e-012
2459	2.6842e-002	4.2184e-002	2.e-002	1.7513e-012
2460	2.6842e-002	4.2184e-002	2.1e-002	2.0325e-012
2461	2.6842e-002	4.2184e-002	2.2e-002	2.3638e-012
2462	2.6842e-002	4.2184e-002	2.3e-002	2.7343e-012
2463	2.6842e-002	4.2184e-002	2.4e-002	3.0871e-012
2464	2.6842e-002	4.2184e-002	2.5e-002	3.3852e-012
2465	2.6842e-002	4.2184e-002	2.6e-002	3.5731e-012
2466	2.6842e-002	4.2184e-002	2.7e-002	3.4883e-012
2467	2.6842e-002	4.2184e-002	2.8e-002	3.5115e-012
2468	2.6842e-002	4.2184e-002	2.9e-002	3.5839e-012
2469	2.6842e-002	4.2185e-002	3.e-002	3.3409e-012
2470	2.6842e-002	4.2185e-002	3.1e-002	2.9374e-012
2471	2.6841e-002	4.2185e-002	3.2e-002	2.6218e-012
2472	2.6841e-002	4.2185e-002	3.3e-002	2.5845e-012
2473	2.6841e-002	4.2185e-002	3.4e-002	3.17e-012
2474	2.6841e-002	4.2185e-002	3.5e-002	4.6254e-012
2475	2.6841e-002	4.2185e-002	3.6e-002	4.6976e-012
2476	2.5998e-002	4.271e-002	1.1e-002	1.3349e-011
2477	2.5143e-002	4.3218e-002	1.1e-002	5.9212e-013
2478	2.4279e-002	4.3709e-002	1.1e-002	2.2735e-012
2479	2.3405e-002	4.4184e-002	1.1e-002	2.4978e-012
2480	2.2522e-002	4.464e-002	1.1e-002	2.4563e-012
2481	2.163e-002	4.5079e-002	1.1e-002	1.996e-012
2482	2.073e-002	4.55e-002	1.1e-002	1.2626e-012
2483	1.9821e-002	4.5904e-002	1.1e-002	5.4767e-013
2484	1.8904e-002	4.6288e-002	1.1e-002	2.0533e-013
2485	1.798e-002	4.6655e-002	1.1e-002	-3.033e-013
2486	1.7049e-002	4.7003e-002	1.1e-002	-1.2101e-012
2487	1.6111e-002	4.7333e-002	1.1e-002	-1.4967e-012
2488	1.5167e-002	4.7644e-002	1.1e-002	-1.7085e-012
2489	1.4217e-002	4.7936e-002	1.1e-002	-2.3185e-012
2490	1.3261e-002	4.8209e-002	1.1e-002	-2.5804e-012
2491	1.23e-002	4.8464e-002	1.1e-002	-2.8233e-012
2492	1.1334e-002	4.8699e-002	1.1e-002	-3.121e-012
2493	1.0363e-002	4.8914e-002	1.1e-002	-3.3695e-012
2494	9.3887e-003	4.9111e-002	1.1e-002	-3.6026e-012
2495	8.4103e-003	4.9288e-002	1.1e-002	-3.8164e-012
2496	7.4288e-003	4.9445e-002	1.1e-002	-4.0347e-012
2497	6.4442e-003	4.9583e-002	1.1e-002	-4.2436e-012
2498	5.4571e-003	4.9701e-002	1.1e-002	-4.4119e-012
2499	4.4678e-003	4.98e-002	1.1e-002	-4.5668e-012
2500	3.4769e-003	4.9879e-002	1.1e-002	-4.7096e-012
2501	2.4844e-003	4.9938e-002	1.1e-002	-4.8355e-012
2502	1.4911e-003	4.9978e-002	1.1e-002	-4.9215e-012
2503	4.971e-004	4.9998e-002	1.1e-002	-4.987e-012
2504	-4.9702e-004	4.9998e-002	1.1e-002	-5.0056e-012
2505	-1.491e-003	4.9978e-002	1.1e-002	-4.9832e-012
2506	-2.4844e-003	4.9938e-002	1.1e-002	-4.9292e-012
2507	-3.4768e-003	4.9879e-002	1.1e-002	-4.8501e-012
2508	-4.4678e-003	4.98e-002	1.1e-002	-4.7872e-012
2509	-5.4571e-003	4.9701e-002	1.1e-002	-4.7859e-012
2510	-6.4441e-003	4.9583e-002	1.1e-002	-4.864e-012
2511	-7.4287e-003	4.9445e-002	1.1e-002	-5.082e-012
2512	-8.4103e-003	4.9288e-002	1.1e-002	-5.4033e-012
2513	-9.3886e-003	4.9111e-002	1.1e-002	-5.7961e-012
2514	-1.0363e-002	4.8914e-002	1.1e-002	-6.2648e-012
2515	-1.1334e-002	4.8699e-002	1.1e-002	-6.7621e-012
2516	-1.23e-002	4.8464e-002	1.1e-002	-7.2047e-012
2517	-1.3261e-002	4.8209e-002	1.1e-002	-7.5823e-012
2518	-1.4217e-002	4.7936e-002	1.1e-002	-7.8849e-012
2519	-1.5167e-002	4.7644e-002	1.1e-002	-8.0888e-012
2520	-1.6111e-002	4.7333e-002	1.1e-002	-8.1416e-012
2521	-1.7049e-002	4.7003e-002	1.1e-002	-8.0064e-012
2522	-1.798e-002	4.6655e-002	1.1e-002	-7.6352e-012
2523	-1.8904e-002	4.6289e-002	1.1e-002	-6.9891e-012
2524	-1.9821e-002	4.5904e-002	1.1e-002	-6.1018e-012
2525	-2.073e-002	4.55e-002	1.1e-002	-4.8305e-012
2526	-2.163e-002	4.5079e-002	1.1e-002	-3.483e-012
2527	-2.2522e-002	4.464e-002	1.1e-002	-2.4776e-012
2528	-2.3405e-002	4.4184e-002	1.1e-002	-1.0194e-011
2529	-2.4279e-002	4.371e-002	1.1e-002	-1.9667e-011
2530	-2.5134e-002	4.3224e-002	1.0997e-002	3.0673e-011
2531	-2.6799e-002	4.2211e-002	1.1987e-002	-2.0832e-011
2532	-2.6798e-002	4.2212e-002	1.2996e-002	-1.3067e-010
2533	-2.6796e-002	4.2213e-002	1.4004e-002	-1.7611e-010
2534	-2.6799e-002	4.2212e-002	1.5012e-002	-2.0788e-010
2535	-2.681e-002	4.2205e-002	1.6022e-002	-2.8949e-010
2536	-2.6841e-002	4.2185e-002	1.7033e-002	-3.4723e-010
2537	-2.6867e-002	4.2168e-002	1.8041e-002	-3.9955e-010
2538	-2.6899e-002	4.2148e-002	1.9054e-002	-2.6573e-010
2539	-2.692e-002	4.2134e-002	2.0055e-002	-9.9919e-011
2540	-2.6941e-002	4.2121e-002	2.1054e-002	-3.4898e-011
2541	-2.6946e-002	4.2118e-002	2.2053e-002	5.548e-011
2542	2.6842e-002	4.2184e-002	3.9e-002	1.4557e-012
2543	2.6842e-002	4.2184e-002	3.8e-002	3.8993e-012
2544	2.6842e-002	4.2184e-002	3.7e-002	4.502e-012
2545	-2.6842e-002	4.2184e-002	3.9e-002	1.5886e-010
2546	-2.5998e-002	4.271e-002	3.9e-002	8.1914e-011
2547	-2.5143e-002	4.3218e-002	3.9e-002	2.2653e-011
2548	-2.4279e-002	4.371e-002	3.9e-002	4.1144e-011
2549	-2.3405e-002	4.4184e-002	3.9e-002	2.8517e-011
2550	-2.2522e-002	4.464e-002	3.9e-002	2.0833e-011
2551	-2.163e-002	4.5079e-002	3.9e-002	1.2124e-011
2552	-2.073e-002	4.55e-002	3.9e-002	4.529e-012
2553	-1.9821e-002	4.5904e-002	3.9e-002	-2.5242e-012
2554	-1.8904e-002	4.6288e-002	3.9e-002	-8.5526e-012
2555	-1.798e-002	4.6655e-002	3.9e-002	-1.3552e-011
2556	-1.7049e-002	4.7003e-002	3.9e-002	-1.7508e-011
2557	-1.6111e-002	4.7333e-002	3.9e-002	-2.0336e-011
2558	-1.5167e-002	4.7644e-002	3.9e-002	-2.2205e-011
2559	-1.4217e-002	4.7936e-002	3.9e-002	-2.3191e-011
2560	-1.3261e-002	4.8209e-002	3.9e-002	-2.3455e-011
2561	-1.23e-002	4.8464e-002	3.9e-002	-2.3138e-011
2562	-1.1334e-002	4.8699e-002	3.9e-002	-2.2462e-011
2563	-1.0363e-002	4.8914e-002	3.9e-002	-2.1512e-011
2564	-9.3887e-003	4.9111e-002	3.9e-002	-2.0469e-011
2565	-8.4103e-003	4.9288e-002	3.9e-002	-1.9378e-011
2566	-7.4288e-003	4.9445e-002	3.9e-002	-1.829e-011
2567	-6.4442e-003	4.9583e-002	3.9e-002	-1.7178e-011
2568	-5.4572e-003	4.9701e-002	3.9e-002	-1.6068e-011
2569	-4.4678e-003	4.98e-002	3.9e-002	-1.489e-011
2570	-3.4769e-003	4.9879e-002	3.9e-002	-1.367e-011
2571	-2.4844e-003	4.9938e-002	3.9e-002	-1.2393e-011
2572	-1.4912e-003	4.9978e-002	3.9e-002	-1.1122e-011
2573	-4.971e-004	4.9998e-002	3.9e-002	-9.7973e-012
2574	4.9697e-004	4.9998e-002	3.9e-002	-8.5166e-012
2575	1.491e-003	4.9978e-002	3.9e-002	-7.2764e-012
2576	2.4843e-003	4.9938e-002	3.9e-002	-6.1193e-012
2577	3.4768e-003	4.9879e-002	3.9e-002	-5.0252e-012
2578	4.4677e-003	4.98e-002	3.9e-002	-4.0174e-012
2579	5.457e-003	4.9701e-002	3.9e-002	-3.0889e-012
2580	6.4441e-003	4.9583e-002	3.9e-002	-2.324e-012
2581	7.4287e-003	4.9445e-002	3.9e-002	-1.6071e-012
2582	8.4102e-003	4.9288e-002	3.9e-002	-9.8161e-013
2583	9.3886e-003	4.9111e-002	3.9e-002	-4.5671e-013
2584	1.0363e-002	4.8914e-002	3.9e-002	-2.7365e-014
2585	1.1334e-002	4.8699e-002	3.9e-002	3.5906e-013
2586	1.23e-002	4.8464e-002	3.9e-002	6.4447e-013
2587	1.3261e-002	4.8209e-002	3.9e-002	8.8588e-013
2588	1.4217e-002	4.7936e-002	3.9e-002	1.0547e-012
2589	1.5167e-002	4.7644e-002	3.9e-002	1.1915e-012
2590	1.6111e-002	4.7333e-002	3.9e-002	1.2638e-012
2591	1.7049e-002	4.7003e-002	3.9e-002	1.2928e-012
2592	1.798e-002	4.6655e-002	3.9e-002	1.2449e-012
2593	1.8904e-002	4.6289e-002	3.9e-002	1.1597e-012
2594	1.9821e-002	4.5904e-002	3.9e-002	1.0048e-012
2595	2.073e-002	4.55e-002	3.9e-002	7.5029e-013
2596	2.163e-002	4.5079e-002	3.9e-002	5.9613e-013
2597	2.2522e-002	4.464e-002	3.9e-002	1.7111e-013
2598	2.3405e-002	4.4184e-002	3.9e-002	-2.2667e-013
2599	2.4279e-002	4.371e-002	3.9e-002	-1.0115e-012
2600	2.5143e-002	4.3218e-002	3.9e-002	1.4273e-013
2601	-2.5972e-002	4.2725e-002	1.0989e-002	3.1323e-011
2602	-2.6842e-002	4.2184e-002	3.8e-002	1.3112e-010
2603	-2.6842e-002	4.2184e-002	3.7e-002	4.4957e-011
2604	-2.6842e-002	4.2184e-002	3.6e-002	3.6824e-011
2605	-2.6842e-002	4.2184e-002	3.5e-002	5.5773e-011
2606	-2.6842e-002	4.2184e-002	3.4e-002	2.8881e-011
2607	-2.6842e-002	4.2184e-002	3.3e-002	4.7114e-012
2608	-2.6842e-002	4.2184e-002	3.2e-002	-7.3368e-012
2609	-2.6841e-002	4.2185e-002	3.1e-002	1.4119e-011
2610	-2.6841e-002	4.2185e-002	3.e-002	1.3719e-011
2611	-2.6841e-002	4.2185e-002	2.9e-002	-4.1489e-011
2612	-2.6841e-002	4.2185e-002	2.8e-002	1.698e-011
2613	-2.6834e-002	4.219e-002	2.7e-002	1.7946e-010
2614	-2.6842e-002	4.2184e-002	2.6015e-002	2.3851e-010
2615	-2.6868e-002	4.2168e-002	2.503e-002	1.8748e-010
2616	-2.6898e-002	4.2149e-002	2.404e-002	1.6907e-010
2617	2.5998e-002	4.271e-002	1.2e-002	-6.5575e-012
2618	2.5143e-002	4.3218e-002	1.2e-002	3.3069e-012
2619	2.3405e-002	4.4184e-002	1.2e-002	-2.2141e-013
2620	2.2522e-002	4.464e-002	1.2e-002	4.0553e-013
2621	2.163e-002	4.5079e-002	1.2e-002	4.4725e-013
2622	2.073e-002	4.55e-002	1.2e-002	5.7591e-013
2623	1.9821e-002	4.5904e-002	1.2e-002	-1.1677e-013
2624	1.8904e-002	4.6289e-002	1.2e-002	-1.1856e-013
2625	1.798e-002	4.6655e-002	1.2e-002	-4.3626e-013
2626	1.7049e-002	4.7003e-002	1.2e-002	-1.4505e-012
2627	1.5167e-002	4.7644e-002	1.2e-002	-1.4519e-012
2628	1.4217e-002	4.7936e-002	1.2e-002	-2.0916e-012
2629	1.3261e-002	4.8209e-002	1.2e-002	-2.1292e-012
2630	1.23e-002	4.8464e-002	1.2e-002	-2.4179e-012
2631	1.1334e-002	4.8699e-002	1.2e-002	-2.6531e-012
2632	1.0363e-002	4.8914e-002	1.2e-002	-2.8388e-012
2633	9.3886e-003	4.9111e-002	1.2e-002	-2.9961e-012
2634	8.4103e-003	4.9288e-002	1.2e-002	-3.1368e-012
2635	7.4287e-003	4.9445e-002	1.2e-002	-3.272e-012
2636	6.4442e-003	4.9583e-002	1.2e-002	-3.3846e-012
2637	5.4571e-003	4.9701e-002	1.2e-002	-3.4577e-012
2638	4.4678e-003	4.98e-002	1.2e-002	-3.5075e-012
2639	3.4768e-003	4.9879e-002	1.2e-002	-3.5354e-012
2640	2.4844e-003	4.9938e-002	1.2e-002	-3.5327e-012
2641	1.4911e-003	4.9978e-002	1.2e-002	-3.4667e-012
2642	4.9708e-004	4.9998e-002	1.2e-002	-3.3553e-012
2643	-4.9704e-004	4.9998e-002	1.2e-002	-3.1798e-012
2644	-1.491e-003	4.9978e-002	1.2e-002	-2.9126e-012
2645	-2.4844e-003	4.9938e-002	1.2e-002	-2.5752e-012
2646	-3.4768e-003	4.9879e-002	1.2e-002	-2.1785e-012
2647	-4.4678e-003	4.98e-002	1.2e-002	-1.7507e-012
2648	-5.4571e-003	4.9701e-002	1.2e-002	-1.358e-012
2649	-6.4441e-003	4.9583e-002	1.2e-002	-1.0334e-012
2650	-7.4287e-003	4.9445e-002	1.2e-002	-8.5033e-013
2651	-8.4103e-003	4.9288e-002	1.2e-002	-8.1921e-013
2652	-9.3886e-003	4.9111e-002	1.2e-002	-9.1667e-013
2653	-1.0363e-002	4.8914e-002	1.2e-002	-1.1407e-012
2654	-1.1334e-002	4.8699e-002	1.2e-002	-1.4532e-012
2655	-1.23e-002	4.8464e-002	1.2e-002	-1.8264e-012
2656	-1.3261e-002	4.8209e-002	1.2e-002	-2.3077e-012
2657	-1.4217e-002	4.7936e-002	1.2e-002	-2.9463e-012
2658	-1.5167e-002	4.7644e-002	1.2e-002	-3.8091e-012
2659	-1.6111e-002	4.7333e-002	1.2e-002	-4.9605e-012
2660	-1.7049e-002	4.7003e-002	1.2e-002	-6.4272e-012
2661	-1.798e-002	4.6655e-002	1.2e-002	-8.1917e-012
2662	-1.8904e-002	4.6289e-002	1.2e-002	-1.0185e-011
2663	-1.9821e-002	4.5904e-002	1.2e-002	-1.2475e-011
2664	-2.073e-002	4.55e-002	1.2e-002	-1.4152e-011
2665	-2.163e-002	4.5079e-002	1.2e-002	-1.6494e-011
2666	-2.2522e-002	4.464e-002	1.2e-002	-5.3949e-012
2667	-2.3405e-002	4.4184e-002	1.2e-002	-2.1767e-011
2668	-2.4279e-002	4.371e-002	1.2e-002	-2.9655e-011
2669	-2.5132e-002	4.3225e-002	1.1996e-002	6.1288e-011
2670	-2.5971e-002	4.2726e-002	1.199e-002	2.8493e-011
2671	-2.5974e-002	4.2724e-002	1.299e-002	4.2302e-011
2672	-2.5965e-002	4.273e-002	1.3995e-002	-4.0433e-011
2673	-2.5971e-002	4.2726e-002	1.5008e-002	-1.7351e-010
2674	-2.5977e-002	4.2722e-002	1.6019e-002	-3.0154e-010
2675	-2.6009e-002	4.2703e-002	1.7025e-002	-3.1793e-010
2676	-2.6031e-002	4.269e-002	1.8043e-002	-2.3212e-010
2677	-2.6054e-002	4.2675e-002	1.9054e-002	-1.216e-010
2678	-2.6078e-002	4.2661e-002	2.0059e-002	-6.3914e-011
2679	-2.6086e-002	4.2656e-002	2.1057e-002	-5.5382e-011
2680	-2.6088e-002	4.2655e-002	2.2049e-002	7.3443e-011
2681	2.5998e-002	4.271e-002	3.8e-002	-1.6905e-012
2682	2.5998e-002	4.271e-002	3.7e-002	-2.2325e-012
2683	2.5997e-002	4.271e-002	3.6e-002	-2.4497e-012
2684	2.5997e-002	4.271e-002	3.4e-002	-2.5059e-012
2685	2.5997e-002	4.271e-002	3.3e-002	-2.7941e-012
2686	2.5997e-002	4.271e-002	3.2e-002	-2.5587e-012
2687	2.5997e-002	4.271e-002	3.1e-002	-2.4926e-012
2688	2.5997e-002	4.271e-002	3.e-002	-2.4995e-012
2689	2.5997e-002	4.271e-002	2.9e-002	-2.5253e-012
2690	2.5997e-002	4.271e-002	2.8e-002	-2.839e-012
2691	2.5997e-002	4.271e-002	2.7e-002	-3.2606e-012
2692	2.5997e-002	4.271e-002	2.6e-002	-3.705e-012
2693	2.5997e-002	4.271e-002	2.5e-002	-4.2182e-012
2694	2.5997e-002	4.271e-002	2.4e-002	-4.7238e-012
2695	2.5997e-002	4.271e-002	2.3e-002	-5.0075e-012
2696	2.5997e-002	4.271e-002	2.2e-002	-5.2786e-012
2697	2.5997e-002	4.271e-002	2.1e-002	-5.5528e-012
2698	2.5997e-002	4.271e-002	2.e-002	-5.8245e-012
2699	2.5997e-002	4.271e-002	1.9e-002	-6.1019e-012
2700	2.5997e-002	4.271e-002	1.8e-002	-6.2717e-012
2701	2.5997e-002	4.271e-002	1.7e-002	-6.3108e-012
2702	2.5997e-002	4.271e-002	1.6e-002	-6.2195e-012
2703	2.5997e-002	4.271e-002	1.5e-002	-6.9596e-012
2704	2.5997e-002	4.271e-002	1.4e-002	-9.1448e-012
2705	2.5998e-002	4.271e-002	1.3e-002	-1.2948e-011
2706	-2.5998e-002	4.271e-002	3.8e-002	8.5759e-011
2707	-2.5143e-002	4.3218e-002	3.8e-002	2.7493e-014
2708	-2.4279e-002	4.371e-002	3.8e-002	3.1348e-011
2709	-2.3405e-002	4.4184e-002	3.8e-002	1.8447e-011
2710	-2.2522e-002	4.464e-002	3.8e-002	1.3197e-011
2711	-2.163e-002	4.5079e-002	3.8e-002	5.8806e-012
2712	-2.073e-002	4.55e-002	3.8e-002	-4.6732e-013
2713	-1.9821e-002	4.5904e-002	3.8e-002	-6.5609e-012
2714	-1.8904e-002	4.6288e-002	3.8e-002	-1.1832e-011
2715	-1.798e-002	4.6655e-002	3.8e-002	-1.6071e-011
2716	-1.7049e-002	4.7003e-002	3.8e-002	-1.9262e-011
2717	-1.6111e-002	4.7333e-002	3.8e-002	-2.1462e-011
2718	-1.5167e-002	4.7644e-002	3.8e-002	-2.2683e-011
2719	-1.4217e-002	4.7936e-002	3.8e-002	-2.3112e-011
2720	-1.3261e-002	4.8209e-002	3.8e-002	-2.2869e-011
2721	-1.23e-002	4.8464e-002	3.8e-002	-2.2132e-011
2722	-1.1334e-002	4.8699e-002	3.8e-002	-2.1131e-011
2723	-1.0363e-002	4.8914e-002	3.8e-002	-1.9987e-011
2724	-9.3887e-003	4.9111e-002	3.8e-002	-1.8833e-011
2725	-8.4103e-003	4.9288e-002	3.8e-002	-1.7721e-011
2726	-7.4289e-003	4.9445e-002	3.8e-002	-1.6685e-011
2727	-6.4442e-003	4.9583e-002	3.8e-002	-1.5663e-011
2728	-5.4572e-003	4.9701e-002	3.8e-002	-1.4627e-011
2729	-4.4678e-003	4.98e-002	3.8e-002	-1.3522e-011
2730	-3.477e-003	4.9879e-002	3.8e-002	-1.235e-011
2731	-2.4844e-003	4.9938e-002	3.8e-002	-1.1116e-011
2732	-1.4912e-003	4.9978e-002	3.8e-002	-9.8499e-012
2733	-4.9709e-004	4.9998e-002	3.8e-002	-8.5361e-012
2734	4.9693e-004	4.9998e-002	3.8e-002	-7.2827e-012
2735	1.491e-003	4.9978e-002	3.8e-002	-6.0962e-012
2736	2.4843e-003	4.9938e-002	3.8e-002	-4.9862e-012
2737	3.4768e-003	4.9879e-002	3.8e-002	-3.9596e-012
2738	4.4677e-003	4.98e-002	3.8e-002	-3.0302e-012
2739	5.4571e-003	4.9701e-002	3.8e-002	-2.1922e-012
2740	6.444e-003	4.9583e-002	3.8e-002	-1.4926e-012
2741	7.4287e-003	4.9445e-002	3.8e-002	-8.6138e-013
2742	8.4102e-003	4.9288e-002	3.8e-002	-3.2077e-013
2743	9.3886e-003	4.9111e-002	3.8e-002	1.248e-013
2744	1.0363e-002	4.8914e-002	3.8e-002	4.8786e-013
2745	1.1334e-002	4.8699e-002	3.8e-002	7.983e-013
2746	1.2299e-002	4.8464e-002	3.8e-002	1.0329e-012
2747	1.3261e-002	4.8209e-002	3.8e-002	1.2185e-012
2748	1.4217e-002	4.7936e-002	3.8e-002	1.3423e-012
2749	1.5167e-002	4.7644e-002	3.8e-002	1.4322e-012
2750	1.6111e-002	4.7333e-002	3.8e-002	1.4719e-012
2751	1.7049e-002	4.7003e-002	3.8e-002	1.4854e-012
2752	1.798e-002	4.6655e-002	3.8e-002	1.439e-012
2753	1.8904e-002	4.6289e-002	3.8e-002	1.3489e-012
2754	1.9821e-002	4.5904e-002	3.8e-002	1.2015e-012
2755	2.073e-002	4.55e-002	3.8e-002	1.0189e-012
2756	2.163e-002	4.5079e-002	3.8e-002	9.3451e-013
2757	2.2522e-002	4.464e-002	3.8e-002	4.2554e-013
2758	2.3405e-002	4.4184e-002	3.8e-002	2.9528e-013
2759	2.4279e-002	4.371e-002	3.8e-002	-5.2505e-013
2760	2.5143e-002	4.3218e-002	3.8e-002	2.8047e-013
2761	-2.5998e-002	4.271e-002	3.7e-002	5.1367e-011
2762	-2.5998e-002	4.271e-002	3.6e-002	1.2314e-011
2763	-2.5998e-002	4.271e-002	3.5e-002	3.7265e-013
2764	-2.5998e-002	4.271e-002	3.4e-002	-1.0588e-012
2765	-2.5998e-002	4.271e-002	3.3e-002	-1.083e-011
2766	-2.5998e-002	4.271e-002	3.2e-002	3.0812e-012
2767	-2.5998e-002	4.271e-002	3.1e-002	4.5969e-011
2768	-2.5998e-002	4.271e-002	3.e-002	4.6005e-011
2769	-2.5998e-002	4.271e-002	2.9e-002	3.4873e-011
2770	-2.5998e-002	4.2709e-002	2.8e-002	1.1503e-010
2771	-2.5998e-002	4.2709e-002	2.7e-002	1.9793e-010
2772	-2.6e-002	4.2709e-002	2.6012e-002	2.0116e-010
2773	-2.6019e-002	4.2697e-002	2.503e-002	1.4706e-010
2774	-2.6056e-002	4.2674e-002	2.404e-002	1.1683e-010
2775	-2.6074e-002	4.2663e-002	2.3044e-002	1.4954e-010
2776	-2.5131e-002	4.3226e-002	1.2998e-002	5.6778e-011
2777	-2.5128e-002	4.3227e-002	1.3998e-002	-2.5434e-011
2778	-2.5129e-002	4.3227e-002	1.5002e-002	-8.877e-011
2779	-2.5139e-002	4.3221e-002	1.6008e-002	-1.101e-010
2780	-2.5153e-002	4.3213e-002	1.7021e-002	-1.5216e-010
2781	-2.5175e-002	4.3199e-002	1.8028e-002	-1.6357e-010
2782	-2.5193e-002	4.3189e-002	1.9041e-002	-1.5333e-010
2783	-2.5226e-002	4.317e-002	2.1052e-002	3.66e-011
2784	-2.5216e-002	4.3176e-002	2.204e-002	1.8891e-010
2785	-2.5205e-002	4.3182e-002	2.3032e-002	1.9021e-010
2786	2.5143e-002	4.3218e-002	1.3e-002	2.9542e-013
2787	2.4279e-002	4.371e-002	1.3e-002	7.3836e-013
2788	2.3405e-002	4.4184e-002	1.3e-002	-1.5769e-012
2789	2.2522e-002	4.464e-002	1.3e-002	-1.3302e-012
2790	2.163e-002	4.5079e-002	1.3e-002	-7.9384e-013
2791	2.073e-002	4.55e-002	1.3e-002	-5.0622e-013
2792	1.9821e-002	4.5903e-002	1.3e-002	-9.2804e-013
2793	1.8904e-002	4.6288e-002	1.3e-002	-3.9497e-013
2794	1.798e-002	4.6655e-002	1.3e-002	-6.8462e-013
2795	1.7049e-002	4.7003e-002	1.3e-002	-1.6846e-012
2796	1.6111e-002	4.7333e-002	1.3e-002	-1.0279e-012
2797	1.5167e-002	4.7644e-002	1.3e-002	-1.3873e-012
2798	1.4217e-002	4.7936e-002	1.3e-002	-1.7641e-012
2799	1.3261e-002	4.8209e-002	1.3e-002	-1.64e-012
2800	1.23e-002	4.8464e-002	1.3e-002	-2.0475e-012
2801	1.1334e-002	4.8699e-002	1.3e-002	-2.103e-012
2802	1.0363e-002	4.8914e-002	1.3e-002	-2.2104e-012
2803	9.3887e-003	4.9111e-002	1.3e-002	-2.2799e-012
2804	8.4103e-003	4.9288e-002	1.3e-002	-2.3423e-012
2805	7.4288e-003	4.9445e-002	1.3e-002	-2.3768e-012
2806	6.4442e-003	4.9583e-002	1.3e-002	-2.3767e-012
2807	5.4571e-003	4.9701e-002	1.3e-002	-2.3496e-012
2808	4.4678e-003	4.98e-002	1.3e-002	-2.2974e-012
2809	3.4769e-003	4.9879e-002	1.3e-002	-2.2018e-012
2810	2.4844e-003	4.9938e-002	1.3e-002	-2.0576e-012
2811	1.4911e-003	4.9978e-002	1.3e-002	-1.8369e-012
2812	4.971e-004	4.9998e-002	1.3e-002	-1.5535e-012
2813	-4.9702e-004	4.9998e-002	1.3e-002	-1.1873e-012
2814	-1.491e-003	4.9978e-002	1.3e-002	-7.0099e-013
2815	-2.4844e-003	4.9938e-002	1.3e-002	-9.6369e-014
2816	-3.4768e-003	4.9879e-002	1.3e-002	6.1787e-013
2817	-4.4678e-003	4.98e-002	1.3e-002	1.4356e-012
2818	-5.457e-003	4.9701e-002	1.3e-002	2.2386e-012
2819	-6.4441e-003	4.9583e-002	1.3e-002	2.993e-012
2820	-7.4287e-003	4.9445e-002	1.3e-002	3.639e-012
2821	-8.4103e-003	4.9288e-002	1.3e-002	4.0959e-012
2822	-9.3886e-003	4.9111e-002	1.3e-002	4.3549e-012
2823	-1.0363e-002	4.8914e-002	1.3e-002	4.4586e-012
2824	-1.1334e-002	4.8699e-002	1.3e-002	4.4562e-012
2825	-1.23e-002	4.8464e-002	1.3e-002	4.3339e-012
2826	-1.3261e-002	4.8209e-002	1.3e-002	3.9881e-012
2827	-1.4217e-002	4.7936e-002	1.3e-002	3.324e-012
2828	-1.5167e-002	4.7644e-002	1.3e-002	2.1539e-012
2829	-1.6111e-002	4.7333e-002	1.3e-002	3.3588e-013
2830	-1.7049e-002	4.7004e-002	1.3e-002	-2.215e-012
2831	-1.798e-002	4.6655e-002	1.3e-002	-5.4953e-012
2832	-1.8904e-002	4.6289e-002	1.3e-002	-9.3689e-012
2833	-1.9821e-002	4.5904e-002	1.3e-002	-1.3604e-011
2834	-2.073e-002	4.55e-002	1.3e-002	-1.7466e-011
2835	-2.163e-002	4.5079e-002	1.3e-002	-2.0461e-011
2836	-2.2522e-002	4.464e-002	1.3e-002	-1.0856e-011
2837	-2.3405e-002	4.4184e-002	1.3e-002	-3.5163e-012
2838	-2.4279e-002	4.371e-002	1.3e-002	-1.1519e-011
2839	2.5143e-002	4.3218e-002	3.7e-002	2.7714e-013
2840	2.5143e-002	4.3218e-002	3.6e-002	1.5694e-013
2841	2.5143e-002	4.3218e-002	3.5e-002	5.6191e-013
2842	2.5143e-002	4.3218e-002	3.4e-002	1.5262e-012
2843	2.5143e-002	4.3218e-002	3.3e-002	1.8311e-012
2844	2.5143e-002	4.3218e-002	3.2e-002	1.9695e-012
2845	2.5143e-002	4.3218e-002	3.1e-002	2.0361e-012
2846	2.5143e-002	4.3218e-002	3.e-002	1.7903e-012
2847	2.5143e-002	4.3218e-002	2.9e-002	1.4639e-012
2848	2.5143e-002	4.3218e-002	2.8e-002	1.4456e-012
2849	2.5143e-002	4.3218e-002	2.7e-002	1.6866e-012
2850	2.5143e-002	4.3218e-002	2.6e-002	1.8368e-012
2851	2.5143e-002	4.3218e-002	2.5e-002	1.9304e-012
2852	2.5143e-002	4.3218e-002	2.4e-002	1.9502e-012
2853	2.5143e-002	4.3218e-002	2.3e-002	2.0157e-012
2854	2.5143e-002	4.3218e-002	2.2e-002	2.0309e-012
2855	2.5143e-002	4.3218e-002	2.1e-002	1.8631e-012
2856	2.5143e-002	4.3218e-002	2.e-002	1.6674e-012
2857	2.5143e-002	4.3218e-002	1.9e-002	1.6088e-012
2858	2.5143e-002	4.3218e-002	1.8e-002	1.4951e-012
2859	2.5143e-002	4.3218e-002	1.7e-002	1.106e-012
2860	2.5143e-002	4.3218e-002	1.6e-002	5.7699e-013
2861	2.5143e-002	4.3218e-002	1.5e-002	-1.0322e-012
2862	2.5143e-002	4.3218e-002	1.4e-002	-2.1016e-012
2863	-2.5143e-002	4.3218e-002	3.7e-002	-3.3139e-012
2864	-2.4279e-002	4.371e-002	3.7e-002	5.7724e-012
2865	-2.3405e-002	4.4184e-002	3.7e-002	3.8845e-012
2866	-2.2522e-002	4.464e-002	3.7e-002	3.3483e-013
2867	-2.163e-002	4.5079e-002	3.7e-002	-3.8787e-012
2868	-2.073e-002	4.55e-002	3.7e-002	-8.3694e-012
2869	-1.9821e-002	4.5904e-002	3.7e-002	-1.2804e-011
2870	-1.8904e-002	4.6288e-002	3.7e-002	-1.6762e-011
2871	-1.798e-002	4.6655e-002	3.7e-002	-1.9514e-011
2872	-1.7049e-002	4.7003e-002	3.7e-002	-2.1542e-011
2873	-1.6111e-002	4.7333e-002	3.7e-002	-2.2886e-011
2874	-1.5167e-002	4.7644e-002	3.7e-002	-2.3121e-011
2875	-1.4217e-002	4.7936e-002	3.7e-002	-2.2853e-011
2876	-1.3261e-002	4.8209e-002	3.7e-002	-2.1948e-011
2877	-1.23e-002	4.8464e-002	3.7e-002	-2.0706e-011
2878	-1.1334e-002	4.8699e-002	3.7e-002	-1.9327e-011
2879	-1.0363e-002	4.8914e-002	3.7e-002	-1.7985e-011
2880	-9.3888e-003	4.9111e-002	3.7e-002	-1.6753e-011
2881	-8.4103e-003	4.9288e-002	3.7e-002	-1.5686e-011
2882	-7.4289e-003	4.9445e-002	3.7e-002	-1.4753e-011
2883	-6.4442e-003	4.9583e-002	3.7e-002	-1.3863e-011
2884	-5.4572e-003	4.9701e-002	3.7e-002	-1.2913e-011
2885	-4.4678e-003	4.98e-002	3.7e-002	-1.1875e-011
2886	-3.477e-003	4.9879e-002	3.7e-002	-1.074e-011
2887	-2.4844e-003	4.9938e-002	3.7e-002	-9.5381e-012
2888	-1.4912e-003	4.9978e-002	3.7e-002	-8.2648e-012
2889	-4.971e-004	4.9998e-002	3.7e-002	-6.9969e-012
2890	4.9691e-004	4.9998e-002	3.7e-002	-5.7863e-012
2891	1.491e-003	4.9978e-002	3.7e-002	-4.6668e-012
2892	2.4842e-003	4.9938e-002	3.7e-002	-3.6261e-012
2893	3.4768e-003	4.9879e-002	3.7e-002	-2.693e-012
2894	4.4677e-003	4.98e-002	3.7e-002	-1.8716e-012
2895	5.4571e-003	4.9701e-002	3.7e-002	-1.1622e-012
2896	6.444e-003	4.9583e-002	3.7e-002	-5.4823e-013
2897	7.4287e-003	4.9445e-002	3.7e-002	-4.1402e-014
2898	8.4101e-003	4.9288e-002	3.7e-002	3.9737e-013
2899	9.3886e-003	4.9111e-002	3.7e-002	7.6811e-013
2900	1.0363e-002	4.8914e-002	3.7e-002	1.071e-012
2901	1.1334e-002	4.8699e-002	3.7e-002	1.2848e-012
2902	1.2299e-002	4.8464e-002	3.7e-002	1.437e-012
2903	1.3261e-002	4.8209e-002	3.7e-002	1.549e-012
2904	1.4216e-002	4.7936e-002	3.7e-002	1.6237e-012
2905	1.5167e-002	4.7644e-002	3.7e-002	1.649e-012
2906	1.6111e-002	4.7333e-002	3.7e-002	1.6773e-012
2907	1.7049e-002	4.7003e-002	3.7e-002	1.6891e-012
2908	1.798e-002	4.6655e-002	3.7e-002	1.6403e-012
2909	1.8904e-002	4.6289e-002	3.7e-002	1.5112e-012
2910	1.9821e-002	4.5904e-002	3.7e-002	1.3744e-012
2911	2.073e-002	4.55e-002	3.7e-002	1.2806e-012
2912	2.2522e-002	4.464e-002	3.7e-002	6.6426e-013
2913	2.3405e-002	4.4184e-002	3.7e-002	8.2401e-013
2914	2.4279e-002	4.371e-002	3.7e-002	6.0512e-013
2915	-2.5143e-002	4.3218e-002	3.6e-002	-8.5332e-012
2916	-2.5143e-002	4.3218e-002	3.5e-002	-1.8491e-011
2917	-2.5143e-002	4.3218e-002	3.4e-002	-2.5125e-011
2918	-2.5143e-002	4.3218e-002	3.3e-002	-2.5482e-011
2919	-2.5143e-002	4.3218e-002	3.2e-002	-2.114e-011
2920	-2.5143e-002	4.3218e-002	3.1e-002	-2.4139e-011
2921	-2.5143e-002	4.3218e-002	3.e-002	-1.2864e-011
2922	-2.5143e-002	4.3218e-002	2.9e-002	3.9919e-011
2923	-2.5143e-002	4.3218e-002	2.8e-002	1.0957e-010
2924	-2.5143e-002	4.3218e-002	2.7e-002	1.6763e-010
2925	-2.5143e-002	4.3218e-002	2.6e-002	1.6674e-010
2926	-2.5156e-002	4.3211e-002	2.5015e-002	1.2306e-010
2927	-2.5188e-002	4.3192e-002	2.4023e-002	1.0092e-010
2928	-2.4279e-002	4.371e-002	1.4e-002	1.8161e-011
2929	-2.4279e-002	4.371e-002	1.5e-002	5.673e-011
2930	-2.4279e-002	4.371e-002	1.6e-002	5.2343e-011
2931	-2.4287e-002	4.3705e-002	1.7006e-002	-4.1018e-011
2932	-2.4302e-002	4.3697e-002	1.802e-002	-9.5982e-011
2933	-2.4322e-002	4.3686e-002	1.9028e-002	-8.3078e-011
2934	-2.434e-002	4.3675e-002	2.003e-002	-1.3268e-011
2935	-2.4339e-002	4.3676e-002	2.1031e-002	3.6412e-011
2936	2.4279e-002	4.3709e-002	1.4e-002	-1.1005e-017
2937	2.3405e-002	4.4184e-002	1.4e-002	-1.0119e-012
2938	2.2522e-002	4.464e-002	1.4e-002	-2.5559e-012
2939	2.163e-002	4.5079e-002	1.4e-002	-1.6202e-012
2940	2.073e-002	4.55e-002	1.4e-002	-1.3758e-012
2941	1.9821e-002	4.5903e-002	1.4e-002	-1.6282e-012
2942	1.8904e-002	4.6289e-002	1.4e-002	-6.7612e-013
2943	1.798e-002	4.6655e-002	1.4e-002	-8.5834e-013
2944	1.6111e-002	4.7333e-002	1.4e-002	-9.653e-013
2945	1.4217e-002	4.7936e-002	1.4e-002	-1.4068e-012
2946	1.3261e-002	4.8209e-002	1.4e-002	-1.1465e-012
2947	1.23e-002	4.8464e-002	1.4e-002	-1.6473e-012
2948	1.1334e-002	4.8699e-002	1.4e-002	-1.4882e-012
2949	1.0363e-002	4.8914e-002	1.4e-002	-1.4717e-012
2950	9.3886e-003	4.9111e-002	1.4e-002	-1.4357e-012
2951	8.4103e-003	4.9288e-002	1.4e-002	-1.4184e-012
2952	7.4288e-003	4.9445e-002	1.4e-002	-1.338e-012
2953	6.4442e-003	4.9583e-002	1.4e-002	-1.2229e-012
2954	5.4571e-003	4.9701e-002	1.4e-002	-1.0807e-012
2955	4.4678e-003	4.98e-002	1.4e-002	-9.2655e-013
2956	3.4769e-003	4.9879e-002	1.4e-002	-6.9707e-013
2957	2.4844e-003	4.9938e-002	1.4e-002	-4.1121e-013
2958	1.4911e-003	4.9978e-002	1.4e-002	-5.2169e-014
2959	4.9709e-004	4.9998e-002	1.4e-002	3.604e-013
2960	-4.9703e-004	4.9998e-002	1.4e-002	9.0332e-013
2961	-1.491e-003	4.9978e-002	1.4e-002	1.5818e-012
2962	-2.4844e-003	4.9938e-002	1.4e-002	2.4296e-012
2963	-3.4768e-003	4.9879e-002	1.4e-002	3.4504e-012
2964	-4.4678e-003	4.98e-002	1.4e-002	4.6473e-012
2965	-5.4571e-003	4.9701e-002	1.4e-002	5.8745e-012
2966	-6.4441e-003	4.9583e-002	1.4e-002	7.1071e-012
2967	-7.4287e-003	4.9445e-002	1.4e-002	8.2493e-012
2968	-8.4103e-003	4.9288e-002	1.4e-002	9.1985e-012
2969	-9.3886e-003	4.9111e-002	1.4e-002	9.887e-012
2970	-1.0363e-002	4.8914e-002	1.4e-002	1.0427e-011
2971	-1.1334e-002	4.8699e-002	1.4e-002	1.0874e-011
2972	-1.23e-002	4.8464e-002	1.4e-002	1.123e-011
2973	-1.3261e-002	4.8209e-002	1.4e-002	1.135e-011
2974	-1.4217e-002	4.7936e-002	1.4e-002	1.1066e-011
2975	-1.5167e-002	4.7644e-002	1.4e-002	1.012e-011
2976	-1.6111e-002	4.7333e-002	1.4e-002	8.3351e-012
2977	-1.7049e-002	4.7003e-002	1.4e-002	5.5753e-012
2978	-1.798e-002	4.6655e-002	1.4e-002	1.8585e-012
2979	-1.8904e-002	4.6289e-002	1.4e-002	-2.7361e-012
2980	-1.9821e-002	4.5904e-002	1.4e-002	-7.5297e-012
2981	-2.073e-002	4.55e-002	1.4e-002	-1.2009e-011
2982	-2.163e-002	4.5079e-002	1.4e-002	-1.588e-011
2983	-2.2522e-002	4.464e-002	1.4e-002	-1.4861e-011
2984	-2.3405e-002	4.4184e-002	1.4e-002	9.9836e-012
2985	2.4279e-002	4.371e-002	3.6e-002	9.4562e-013
2986	2.4279e-002	4.371e-002	3.5e-002	4.6876e-013
2987	2.4279e-002	4.371e-002	3.4e-002	2.6988e-013
2988	2.4279e-002	4.371e-002	3.3e-002	1.959e-013
2989	2.4279e-002	4.371e-002	3.2e-002	5.6175e-014
2990	2.4279e-002	4.371e-002	3.1e-002	-1.0908e-013
2991	2.4279e-002	4.371e-002	3.e-002	-2.0042e-013
2992	2.4279e-002	4.371e-002	2.9e-002	-1.3533e-013
2993	2.4279e-002	4.371e-002	2.8e-002	-6.6143e-014
2994	2.4279e-002	4.371e-002	2.7e-002	-3.4729e-013
2995	2.4279e-002	4.371e-002	2.6e-002	-6.5402e-013
2996	2.4279e-002	4.371e-002	2.5e-002	-6.8355e-013
2997	2.4279e-002	4.371e-002	2.4e-002	-6.8023e-013
2998	2.4279e-002	4.371e-002	2.3e-002	-9.2294e-013
2999	2.4279e-002	4.371e-002	2.2e-002	-1.3149e-012
3000	2.4279e-00