import System
import clr
clr.AddReference("Ans.Core.Components")
import Ansys.Core.Components
clr.AddReference("Ans.UI.Toolkit")
clr.AddReference("Ans.UI.Toolkit.Base")
import Ansys.UI.Toolkit
clr.AddReference("Ans.Utilities")
import Ansys.Utilities

def licenseCheck(args):
    ExtAPI.Log.WriteMessage('Custom License Toolbar Button Clicked')
    #this snippet shows license validation when inside the running product
    wbCapability = Ansys.Core.Components.Validation.Capability.ANSYSLI_CAP_ANS_ACT
    isLicensed = Ansys.Core.Components.Validation.Validator.Check(wbCapability)
    mssg = "invalid"
    if isLicensed:
        mssg = "valid"
    Ansys.UI.Toolkit.MessageBox.Show(System.String.Format("Validator:  Capabiliy {0} is {1}!", str(wbCapability), mssg))
    #this snippet shows license validation when outside the running product
    installDir = ExtAPI.ExtensionManager.CurrentExtension.InstallDir
    licFilePath = System.IO.Path.Combine(installDir, "licenseoutput.xml")
    if System.IO.File.Exists(licFilePath):
        System.IO.File.Delete(licFilePath)
    awpRoot = Ansys.Utilities.ApplicationConfiguration.DefaultConfiguration.AwpRootEnvironmentVariableValue
    ansysFolder = System.IO.Path.Combine(awpRoot, "..")
    sharedFolder = System.IO.Path.Combine(ansysFolder, "Shared Files")
    licFolder = System.IO.Path.Combine(sharedFolder, "Licensing")
    licPlatformFolder = System.IO.Path.Combine(licFolder, "winx64")
    licutilPath = System.IO.Path.Combine(licPlatformFolder, "ansysli_util.exe")
    ExtAPI.ProcessUtils.Start(licutilPath, "-cap", str(wbCapability), "-getcapdef", licFilePath)
    mssg = "invalid"
    if System.IO.File.Exists(licFilePath):
        doc = System.Xml.XmlDocument()
        doc.Load(licFilePath)
        node = doc.SelectSingleNode("FEATURES")
        if node.ChildNodes.Count > 0:
            mssg = "valid"
        System.IO.File.Delete(licFilePath)
    Ansys.UI.Toolkit.MessageBox.Show(System.String.Format("LIC UTIL:  Capabiliy {0} is {1}!", str(wbCapability), mssg))
