﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Reflection;
using System.IO;

using Ansys.Core.Components.Validation;

namespace LicCheck
{
    public class MyValidator
    {
        private static List<string> _searchDirectories = new List<string>();

        public static bool CheckWB()
        {
            string awpRoot = Environment.GetEnvironmentVariable("AWP_ROOT180");
            string framework = Path.Combine(awpRoot, "Framework");
            string bin = Path.Combine(framework, "bin");
            string platform = Path.Combine(bin, "Win64");

            AddSearchDirectory(platform);
            AppDomain.CurrentDomain.AssemblyResolve += CurrentDomain_AssemblyResolve;
            bool valid = false;
            var capability = Capability.ANSYSLI_CAP_ANS_WB;
            try
            {
                valid = Validator.Check(capability);
            }
            catch (Exception e)
            {
                Console.Out.WriteLine(e.Message);
            }
            AppDomain.CurrentDomain.AssemblyResolve -= CurrentDomain_AssemblyResolve;
            return valid;
        }

        static System.Reflection.Assembly CurrentDomain_AssemblyResolve(object sender, ResolveEventArgs args)
        {
            string asm = args.Name.Split(",".ToCharArray())[0] + ".dll";
            Assembly myassembly = null;

            foreach (string asmname in LocateAssembly(asm))
            {
                try
                {
                    myassembly = Assembly.LoadFrom(asmname);
                }
                catch (Exception e)
                {
                    Console.WriteLine(e.Message);
                }
            }

            return myassembly;
        }

        private static List<string> LocateAssembly(string filename)
        {
            List<string> filelist = new List<string>();
            Console.WriteLine("FILENAME: " + filename);
            foreach (string dir in _searchDirectories)
            {
                string assempath = Path.Combine(dir, filename);
                if (File.Exists(assempath))
                    filelist.Add(assempath);
            }

            return filelist;
        }

        public static void AddSearchDirectory(string directory)
        {
            _searchDirectories.Add(directory);
        }
    }
}
