import clr
clr.AddReference("Ans.ParameterManager")
import Ansys.ParameterManager
import System
def update(task):
    numStepsCompleted = 0
    processedDPs = []
    reset(task)
    setupProperties = task.Properties["Optimization Setup"].Properties
    numTotalSteps = setupProperties["NumberOfSteps"].Value
    inputMin = setupProperties["Min"].Value
    inputMax = setupProperties["Max"].Value
    target = setupProperties["Target"].Value
    tolerance = setupProperties["Tolerance"].Value
    deleteDesignPointsAfterUpdate = setupProperties["DeleteDPs"].Value
    inputParamName = setupProperties["InputParam"].Value
    inputParam = Parameters.GetParameter(inputParamName)
    outputParamName = setupProperties["OutputParam"].Value
    outputParam = Parameters.GetParameter(outputParamName)
    while True:
        dpsToSolve = []
        if numStepsCompleted >= numTotalSteps:
            break
        else:
            runningDPs = []
            dp0 = Parameters.GetDesignPoint("0")
            param1 = Parameters.GetParameter("P1")
            if param1.IsOutput:
                param1 = Parameters.GetParameter("P2")
            numDPs = 10
            r = System.Random()
            for i in range(0, numDPs):
                dp = dp0.Duplicate()
                nextInputVal = 0
                validInputFound = False
                nextInputVal = r.NextDouble() * inputMax
                validInputFound = (nextInputVal >= inputMin)
                while validInputFound == False:
                    nextInputVal = r.NextDouble() * inputMax
                    validInputFound = nextInputVal >= inputMin
                dp.SetParameterExpression(param1, str(nextInputVal))
                runningDPs.append(dp)
            UpdateAllDesignPoints(DesignPoints=runningDPs)
            for dp in runningDPs:
                processedDPs.append(dp)
            numStepsCompleted = numStepsCompleted + 1
            resultProperties = task.Properties["Optimization Results"].Properties
            haveResultsBeenRecorded = resultProperties["ResultsRecorded"].Value
            currRecordedOutput = resultProperties["OptimizedOutput"].Value
            #inputParam = Parameters.GetAllParametersByUsage(Ansys.ParameterManager.Data.ParameterUsage.Input)[0]
            #outputParam = Parameters.GetAllParametersByUsage(Ansys.ParameterManager.Data.ParameterUsage.DirectOutput)[0]
            currLowestDiff = 0
            currLowestInput = 0
            currLowestOutput = 0
            for i in range(0, runningDPs.Count):
                designPoint = runningDPs[i]
                inputVal = designPoint.GetParameterValue(inputParam)
                outputVal = designPoint.GetParameterValue(outputParam)
                if str(outputVal).Contains("["):
                    outputVal = outputVal.Value
                if i == 0:
                    currLowestInput = inputVal
                    currLowestOutput = outputVal
                    currLowestDiff = System.Math.Abs(System.Math.Abs(target) - System.Math.Abs(outputVal))
                else:
                    tempDiff = System.Math.Abs(System.Math.Abs(target) - System.Math.Abs(outputVal))
                    if tempDiff < currLowestDiff:
                        currLowestDiff = tempDiff
                        currLowestInput = inputVal
                        currLowestOutput = outputVal
            updateVals = False
            if haveResultsBeenRecorded:
                currRecordedDiff = System.Math.Abs(System.Math.Abs(target) - System.Math.Abs(currRecordedOutput))
                if currLowestDiff < currRecordedDiff:
                    updateVals = True
            else:
                updateVals = True
            if updateVals:
                withinTolerance = False
                lowerBounds = target - System.Math.Abs((tolerance / 100.0) * target)
                upperBounds = target + System.Math.Abs((tolerance / 100.0) * target)
                if lowerBounds <= currLowestOutput and currLowestOutput <= upperBounds:
                    withinTolerance = True
                resultProperties["ResultsRecorded"].Value = True
                resultProperties["OptimizedOutput"].Value = currLowestOutput
                resultProperties["OptimizedInput"].Value = currLowestInput
                resultProperties["WithinTolerance"].Value = withinTolerance
    if deleteDesignPointsAfterUpdate:
        for dp in processedDPs:
            dp.Delete()
def reset(task):
    resultProperties = task.Properties["Optimization Results"].Properties
    resultProperties["OptimizedInput"].Value = 0.0
    resultProperties["OptimizedOutput"].Value = 0.0
    resultProperties["WithinTolerance"].Value = False
    resultProperties["ResultsRecorded"].Value = False
def activateInput(entity, property):
    property.Options.Clear()
    inputParameters = Parameters.GetAllParametersByUsage(Ansys.ParameterManager.Data.ParameterUsage.Input)
    for inputParameter in inputParameters:
        property.Options.Add(inputParameter.Name)
def activateOutput(entity, property):
    property.Options.Clear()
    outputParameters = Parameters.GetAllParametersByUsage(Ansys.ParameterManager.Data.ParameterUsage.DirectOutput)
    for outputParameter in outputParameters:
        property.Options.Add(outputParameter.Name)
