import System
import clr
clr.AddReference("Ans.Core")
import Ansys.Core
clr.AddReference("Ans.UI")
import Ansys.UI
clr.AddReference("Ans.UI.Toolkit")
clr.AddReference("Ans.UI.Toolkit.Base")
import Ansys.UI.Toolkit
import Ansys.UI.Toolkit.Base
import Ansys.UI.Toolkit.Drawing

def update(task):
    ExtAPI.Log.WriteMessage("Updating task " + task.Name)
def validate(entity, property):
    return True
def initialize(context):
    ExtAPI.Log.WriteMessage("Registering custom property action...")
    uiMgr = Ansys.UI.UIManager.Instance
    attributes = System.Collections.Generic.List[System.Attribute]()
    attr = Ansys.UI.Attributes.GuiOperationAttribute("Set password...")
    attributes.Add(attr)
    defineContext = uiMgr.CreateGuiDefineContext()
    try:
        defineContext.RegisterOperation(SetPasswordPropertyActionGuiOperation(), attributes)
    except:
        ExtAPI.Log.WriteWarning("Failed to register gui operation...")
    Ansys.UI.PropertyEditActionRegistry.RegisterAction("ACTObject", "SetPassword", clr.GetClrType(SetPasswordPropertyActionGuiOperation), Ansys.UI.PropertyEditActionRegistry.ActivationMode.HyperLink | Ansys.UI.PropertyEditActionRegistry.ActivationMode.WorksWithReadOnlyData)
def terminate(context):
    Ansys.UI.PropertyEditActionRegistry.RegisterAction("ACTObject", "SetPassword", clr.GetClrType(SetPasswordPropertyActionGuiOperation))
class SetPasswordPropertyActionGuiOperation(Ansys.UI.GuiOperation):
    def Invoke(self, context):
        selection = context.View.GetSingleUISelection[Ansys.Core.DataModel.ProjectSystem.DataContainerReference]()
        if selection == None:
            uiMgr = Ansys.UI.UIManager.Instance
            workspace = uiMgr.GetActiveWorkspace()
            view = workspace.GetView("ProjectSchematic")
            selection = view.GetSingleUISelection[Ansys.Core.DataModel.ProjectSystem.DataContainerReference]()
        dialog = SetPasswordDialog(selection)
        dialog.ShowDialog()
    def GuiItemCallBack(self, context):
        context.Visible = True
        context.Enabled = True
class SetPasswordDialog(Ansys.UI.Toolkit.Dialog):
    mainPanel = None
    userString = None
    container = None
    def __init__(self, container):
        self.container = container
        width = 300;
        height = 150;
        self.Text = "Set Password"
        self.Width = width
        self.Height = height
        self.MaximizeBox = False
        self.MinimumSize = Ansys.UI.Toolkit.Drawing.Size(width, height)
        self.MaximumSize = Ansys.UI.Toolkit.Drawing.Size(width, height)
        self.__BuildUI()
        self.SetControl(self.mainPanel)
    def __BuildUI(self):
        self.mainPanel = Ansys.UI.Toolkit.TableLayoutPanel()
        self.mainPanel.Rows.Add(Ansys.UI.Toolkit.TableLayoutSizeType.Absolute, 10)
        self.mainPanel.Rows.Add(Ansys.UI.Toolkit.TableLayoutSizeType.Absolute, 40)
        self.mainPanel.Rows.Add(Ansys.UI.Toolkit.TableLayoutSizeType.Absolute, 40)
        self.mainPanel.Columns.Add(Ansys.UI.Toolkit.TableLayoutSizeType.Percent, 33)
        self.mainPanel.Columns.Add(Ansys.UI.Toolkit.TableLayoutSizeType.Percent, 34)
        self.mainPanel.Columns.Add(Ansys.UI.Toolkit.TableLayoutSizeType.Percent, 33)
        l = Ansys.UI.Toolkit.Label("Password:")
        self.mainPanel.Controls.Add(l, 1, 0, 1, 1)
        self.userString = Ansys.UI.Toolkit.TextBox()
        self.userString.PasswordMask = True
        self.mainPanel.Controls.Add(self.userString, 1, 1, 1, 2)
        apply = Ansys.UI.Toolkit.Button("Apply")
        apply.Click += Ansys.UI.Toolkit.EventDelegate(self.apply_Click)
        self.mainPanel.Controls.Add(apply, 2, 0)
        cancel = Ansys.UI.Toolkit.Button("Cancel")
        cancel.Click += Ansys.UI.Toolkit.EventDelegate(self.cancel_Click)
        self.mainPanel.Controls.Add(cancel, 2, 2)
    def cancel_Click(self, sender, args):
        self.Close()
    def apply_Click(self, sender, args):
        context = Ansys.Core.Commands.CurrentContext.AsQueryContext
        dataRef = None
        dataType = 'ACTObject'
        with context.ContainerReadLock(self.container):
            dataRef = context.Project.GetDataReferencesByType(self.container, dataType)[0]
        if dataRef != None:
            Ansys.Core.Commands.Standard.SetEntityPropertyCommand.InvokeAndWait(dataRef, "Password", self.userString.Text)
        self.Close()
