import System

import clr
clr.AddReference("Ans.UI.Toolkit")
clr.AddReference("Ans.UI.Toolkit.Base")
import Ansys.UI.Toolkit
from Ansys.UI.Toolkit import *

def pruneProject(args):
    ExtAPI.Log.WriteMessage('Prune Project Button Clicked...')
    dialog = SystemSelector(ExtAPI)
    dialog.ShowDialog()
    for taskGroup in dialog.taskGroupsToDelete:
        taskGroup.Delete()
class SystemSelector(Dialog):
    mainPanel = None
    listPanel = None
    listBox1 = None
    listBox2 = None
    buttonToList1 = None
    buttonToList2 = None
    okButton = None
    label1 = None
    ExtAPI = None
    taskGroups = {}
    taskGroupsToDelete = []
    def __init__(self, ExtAPI):
        self.Location = Ansys.UI.Toolkit.Drawing.Point(100,100)
        self.Text = 'Select Systems'
        self.Size = Ansys.UI.Toolkit.Drawing.Size(500, 400)
        self.ExtAPI = ExtAPI
        self.__BuildUI()
    
    def __BuildUI(self):
        self.__BuildToolBar()
        self.__BuildListBox()
        self.__BuildDialog()
    
    def __ToolBarButtonClick(self, sender, args):
        self.ResetLists()
    
    def __BuildToolBar(self):
        toolBar = self.AddToolBar()
        toolBarButton = ToolBarButton("Reset Lists")
        toolBarButton.ToolBarButtonClick += ToolBarButtonClickEventDelegate(self.__ToolBarButtonClick)
        toolBar.Items.Add(toolBarButton)
    
    def __BuildListBox(self):
        self.listPanel = TableLayoutPanel()
        self.listPanel.Columns.Add(TableLayoutSizeType.Percent, 40)
        self.listPanel.Columns.Add(TableLayoutSizeType.Percent, 20)
        self.listPanel.Columns.Add(TableLayoutSizeType.Percent, 40)
        self.listPanel.Rows.Add(TableLayoutSizeType.Percent, 10)
        self.listPanel.Rows.Add(TableLayoutSizeType.Percent, 35)
        self.listPanel.Rows.Add(TableLayoutSizeType.Percent, 10)
        self.listPanel.Rows.Add(TableLayoutSizeType.Percent, 10)
        self.listPanel.Rows.Add(TableLayoutSizeType.Percent, 25)
        self.listPanel.Rows.Add(TableLayoutSizeType.Percent, 10)
        self.listBox1 = ListBox()
        self.listBox1.IsMultiSelectable = True
        self.listBox2 = ListBox()
        self.listBox2.IsMultiSelectable = True
        self.listPanel.Controls.Add(self.listBox1, 1, 0, 4, 1)
        self.listPanel.Controls.Add(self.listBox2, 1, 2, 4, 1)
        self.label1 = Label("Select systems to keep:")
        self.listPanel.Controls.Add(self.label1, 0, 0, 1, 3)
        self.buttonToList1 = Button("<<")
        self.buttonToList1.Click += EventDelegate(self.__List1Click)
        self.buttonToList2 = Button(">>")
        self.buttonToList2.Click += EventDelegate(self.__List2Click)
        self.listPanel.Controls.Add(self.buttonToList1, 2, 1)
        self.listPanel.Controls.Add(self.buttonToList2, 3, 1)
        self.okButton = Button("OK")
        self.okButton.Click += EventDelegate(self.__OKClick)
        self.listPanel.Controls.Add(self.okButton, 5, 1)
        self.__InitializeLists()
    
    def ResetLists(self):
        self.listBox1.ClearSelectedItems()
        self.listBox1.Items.Clear()
        self.listBox2.ClearSelectedItems()
        self.listBox2.Items.Clear()
        self.__InitializeLists()
    
    def __InitializeLists(self):
        self.taskGroups.Clear()
        self.taskGroupsToDelete.Clear()
        for taskGroup in ExtAPI.DataModel.TaskGroups:
            coord = taskGroup.Tasks[0].CoordinateId[0]
            name = taskGroup.Caption
            entry = coord + ": " + name
            self.taskGroups[entry] = taskGroup
            self.listBox1.Items.Add(entry)
        self.buttonToList1.Enabled = True
        self.buttonToList2.Enabled = True
    
    def __List1Click(self, sender, args):
        selectedItems = self.listBox2.SelectedItems
        self.listBox2.ClearSelectedItems()
        for item in selectedItems:
            self.listBox2.Items.Remove(item)
            self.listBox1.Items.Add(item)
        if self.listBox2.Items.Count == 0:
            self.buttonToList1.Enabled = False
        if self.listBox1.Items.Count > 0 and not self.buttonToList2.Enabled:
            self.buttonToList2.Enabled = True
    
    def __List2Click(self, sender, args):
        selectedItems = self.listBox1.SelectedItems
        self.listBox1.ClearSelectedItems()
        for item in selectedItems:
            self.listBox1.Items.Remove(item)
            self.listBox2.Items.Add(item)
        if self.listBox1.Items.Count == 0:
            self.buttonToList2.Enabled = False
        if self.listBox2.Items.Count > 0 and not self.buttonToList1.Enabled:
            self.buttonToList1.Enabled = True
    
    def __OKClick(self, sender, args):
        for entry in self.listBox1.Items:
            self.taskGroupsToDelete.append(self.taskGroups[entry.Text])
        self.Close()
    
    def __BuildDialog(self):
        self.mainPanel = TableLayoutPanel()
        self.mainPanel.Columns.Add(TableLayoutSizeType.Percent, 100)
        self.mainPanel.Rows.Add(TableLayoutSizeType.Percent, 100)
        self.mainPanel.Controls.Add(self.listPanel, 0, 0)
        self.SetControl(self.mainPanel)