import clr
clr.AddReference("Ans.Core")
from Ansys.Core.Units import *
def valid(entity, property):
    """ The pressure value must be less than 15.8."""
    value = property.Value
    if value == None:
        return False
    q = Quantity.Parse(str(value))
    if q.Value < 15.8:
        return True
    else:
        return False
def update(task):
    ExtAPI.Log.WriteMessage("Task updated...")
    for property in task.Properties:
        ExtAPI.Log.WriteMessage("Property '" + property.Name + "' value = " + str(property.Value) + " unit = " + str(property.UnitString))
