import time
import System

import clr
clr.AddReference('Ans.UI.Toolkit')
clr.AddReference('Ans.UI.Toolkit.Base')
clr.AddReference('Ans.UI')
clr.AddReference('Ans.Utilities')
clr.AddReference('Ans.Core')
import Ansys.UI.Toolkit
import Ansys.UI
import Ansys.Core
import Ansys.Utilities

def init(context):
    ExtAPI.Log.WriteMessage("Initializing SDKWrapper App...")
    #Check if this is the app's first run - if the SDK product has been loaded.
    loaded = ExtAPI.DataModel.Context.Session.AddinManager.HasAddin("Ansys.ScratchAddin.Addin")
    if loaded:
        return
    #the addin is not loaded.  We must install it at this time.
    rootInstall = Ansys.Utilities.ApplicationConfiguration.DefaultConfiguration.AwpRootEnvironmentVariableValue
    installDir = ExtAPI.ExtensionManager.CurrentExtension.InstallDir
    resourcesDir = System.IO.Path.Combine(installDir, 'resources')
    #first time running the app.
    res = Ansys.UI.Toolkit.MessageBox.Show(Ansys.UI.UIManager.Instance.MainWindow.Window, 
        'SDKWrapper has detected the first launch of this App.  Proceed with initialization?', 
        'SDKWrapper Setup', 
        Ansys.UI.Toolkit.MessageBoxType.Question, 
        Ansys.UI.Toolkit.MessageBoxButtons.YesNo)
    if res == Ansys.UI.Toolkit.DialogResult.Yes:
        #write out config file
        msg = 'Setup started: ' + time.strftime("%a, %d %b %Y %H:%M:%S +0000", time.gmtime())
        ExtAPI.Log.WriteMessage(msg)
        #THIS IS WHERE YOU WOULD INVOKE ROUTINES TO RUN YOUR INSTALLER...
        #IF YOU NEED TO COPY ANY FILES FROM THE RESOURCES DIRECTORY, DO THAT NOW
        #installerPath = ''
        #info = System.Diagnostics.ProcessStartInfo(installerPath)
        #p = System.Diagnostics.Process.Start(info)
        #p.WaitForExit()
        ExtAPI.Log.WriteMessage('SDKWrapper App Configuration - SUCCESS')
        res = Ansys.UI.Toolkit.MessageBox.Show(Ansys.UI.UIManager.Instance.MainWindow.Window, 
            'Please restart Workbench to finalize this configuration.', 
            'SDKWrapper Setup', 
            Ansys.UI.Toolkit.MessageBoxType.Info, 
            Ansys.UI.Toolkit.MessageBoxButtons.OK)
    else:
        msg = 'SDKWrapper App not configured!'
        ExtAPI.Log.WriteMessage(msg)
        Ansys.Core.Session.PublishMessage(None, Ansys.Core.Messaging.MessageType.Warning, 'SDKWrapper Setup', 'SDKWrapper App', msg, '')
    return
def terminate():
    ExtAPI.Log.WriteMessage("Terminating SDKWrapper App...")
