﻿using System;
using System.Collections.Generic;
using System.Text;

using Ansys.Core.DataModel.DataObjects;
using Ansys.Core.DataModel.ProjectSystem;
using Ansys.Core.Commands;

namespace Ansys.ScratchAddin.Commands
{
    [Command("CreateScratchComponent")]
    public partial class CreateScratchComponentCommand : ICommand
    {
        //The name of the container
        [Parameter]
        public string Name;

        //The created container for the component.
        [Parameter]
        public Output<DataContainerReference> CreatedContainer;

        #region ICommand Members

        public void Execute(IFullContext context)
        {
            //Create the component's container
            DataObjectContainer cont = new DataObjectContainer(Core.AddinConstants.ScratchContainer);

            //Add the container to the current project
            DataContainerReference contRef = context.Project.AddContainer(cont, Name, Addin.key);

            using (context.ContainerWriteLock(cont.ContainerReference))
            {
                Data.ScratchData producerObj = new Data.ScratchData("hello", cont);
            }

            //Set the return value to the created component container.
            Output.SetIfNotNull(CreatedContainer, contRef);
        }

        #endregion
    }
}
