﻿using System;
using System.Collections.Generic;
using System.Text;

using Ansys.Core.DataModel.ProjectSystem;
using Ansys.Core.DataModel;
using Ansys.Core.Commands;
using Ansys.ProjectSchematic;

namespace Ansys.ScratchAddin.Commands
{
    [Command("RefreshScratchComponent")]
    public partial class RefreshScratchComponentCommand : ICommand
    {
        /// <summary>
        /// The container that the refresh has been called on.
        /// </summary>
        [Parameter]
        public DataContainerReference Container;

        /// <summary>
        /// A list of upstream data containers that supply
        /// data to this cell (through a data transfer connection,
        /// etc.)
        /// </summary>
        [Parameter(IsOptional = true, Default = null)]
        public IEnumerable<DataContainerReference> UpstreamList;

        #region ICommand

        public void Execute(IFullContext context)
        {
            //nothing to do for this simple example...just signal refreshed.

            using (context.ContainerWriteLock(Container))
            {
                context.Project.SignalRefreshed(Container);
            }
        }

        #endregion
    }
}
