﻿using System;
using System.Collections.Generic;
using System.Text;

using Ansys.Core.DataModel.DataObjects;
using Ansys.Core.DataModel.ProjectSystem;
using Ansys.Core.DataModel;
using Ansys.Core.Commands;

namespace Ansys.ScratchAddin.Commands
{
    [Command("UpdateScratchComponent")]
    public partial class UpdateScratchComponentCommand : ICommand
    {
        [Parameter]
        public DataContainerReference Container;

        #region ICommand Members

        public void Execute(IFullContext context)
        {
            DataReference dr = null;
            double input = 0;
            using (context.ContainerReadLock(Container))
            {
                dr = context.Project.GetDataReferencesByType(Container, Core.AddinConstants.ScratchDataTypeString)[0];
                input = (double)context.Project.GetProperty(dr, "inValue");

            }
            using (context.ContainerWriteLock(Container))
            {
                context.Project.SetProperty(dr, "outValue", input * input);
                DataObjectContainer containerObj = context.Project.GetContainerObject(Container, Addin.key) as DataObjectContainer;
                containerObj.SignalOutputsGenerated();
            }
        }

        #endregion

    }
}
