﻿using System;
using System.Collections.Generic;
using System.Text;

using Ans.Core.Commands;

namespace Ansys.ASimExampleAddin.Data
{
    //class for testing!

    internal class DataTransferHelper
    {
        internal static Dictionary<string, object> ConvertTransferDataMapToPrimitives(ICommandContext context, Dictionary<string, TransferData> transferDataMap)
        {
            Dictionary<string, object> convertedDataMap = new Dictionary<string, object>();
            foreach (KeyValuePair<string, TransferData> pair in transferDataMap)
            {
                Dictionary<string, object> transferDataPrimitives = pair.Value.ConvertToDictionaryOfPrimitives(context);
                convertedDataMap.Add(pair.Key, (object)transferDataPrimitives);
            }
            return convertedDataMap;
        }

        internal static void ConvertToTransferDataMapFromPrimitives(ICommandContext context, Dictionary<string, object> convertedDataMap, Dictionary<string, TransferData> transferDataMap)
        {
            foreach (KeyValuePair<string, object> pair in convertedDataMap)
            {
                TransferData tempTransferData = new TransferData(pair.Key);
                tempTransferData.ConvertFromDictionaryOfPrimitives(context, pair.Value);
                transferDataMap.Add(pair.Key, tempTransferData);
            }
        }
    }
}
