﻿using System;
using System.Collections.Generic;
using System.Text;

using Ansys.Core.DataModel;
using Ansys.Core.DataModel.DataObjects;
using Ansys.Core.DataModel.ProjectSystem;
using Ansys.Core.DataSpecs;

namespace Ansys.ScratchAddin.Data
{
    [DataEntity(Core.AddinConstants.ScratchDataTypeString, Exposure = ExposureLevel.AnyUser)]
    public class ScratchData : DataObject
    {
        //An example input property
        [Spec(Label = "Integer Input", Group = "Inputs", Default = 1, Usage = SpecUsage.Input, Exposure = ExposureLevel.AnyUser, Access = SpecAccess.UserWritable)]
        public double inValue;

        //An example output property
        [Spec(Label = "Integer Sqaure Output", Group = "Output", Usage = SpecUsage.Output, Exposure = ExposureLevel.AnyUser, Access = SpecAccess.ReadOnly)]
        public double outValue;

        //constructor
        public ScratchData(string name, DataObjectContainer Container)
            : base(name, Container)
        {
        }

        public ScratchData()
            : this(null, null)
        {
        }
    }
}
