﻿using System;
using System.Collections.Generic;

using Ansys.UI.Toolkit;
using Ansys.UI.Toolkit.Drawing;
using Ansys.UI.Toolkit.Base;

namespace Ansys.ScratchAddin.Gui
{
    internal class ListViewExampleDialog : Dialog
    {
        private TableLayoutPanel mainPanel;
        private ListView listview;
        private Button addButton, removeButton;
        private TextBox xText, yText;
        private Dialog addDialog;

        public ListViewExampleDialog()
        {
            this.Location = new Point(100, 100);
            this.Text = "List View Example";
            this.Size = new Size(500, 300);
            BuildUI();
        }
        
        private void BuildUI()
        {
            mainPanel = new TableLayoutPanel();
            mainPanel.Columns.Add(TableLayoutSizeType.Percent, 50);
            mainPanel.Columns.Add(TableLayoutSizeType.Percent, 50);
            mainPanel.Rows.Add(TableLayoutSizeType.Percent, 90);
            mainPanel.Rows.Add(TableLayoutSizeType.Percent, 10);
            listview = new ListView();
            listview.Columns.Add("X");
            listview.Columns.Add("Y");
            listview.IsMultiSelectable = true;
            listview.AreColumnsReorderable = false;
            listview.IsHeaderClickable = true;
            listview.ContextMenuEventsEnabled = false;
            listview.AreLabelsEditable = false;
            listview.ColumnHeaderClick += new ListViewColumnHeaderClickEventDelegate(Header_Click);
            for(int i = 0; i < 5; i++)
            {
                ListViewItem item = new ListViewItem(i.ToString());
                item.SubItems.Add(i.ToString());
                listview.Items.Add(item);
            }
            mainPanel.Controls.Add(listview, 0, 0, 1, 2);
        
            addButton = new Button("Add Point");
            addButton.Click += new EventDelegate(addPoint);
            removeButton = new Button("Remove Point");
            removeButton.Click += new EventDelegate(removePoint);
            mainPanel.Controls.Add(addButton, 1, 0);
            mainPanel.Controls.Add(removeButton, 1, 1);
            this.SetControl(mainPanel);
        }
    
        private void addPoint(object sender, Ansys.UI.Toolkit.EventArgs args)
        {
            addDialog = new Dialog();
            TableLayoutPanel panel = new TableLayoutPanel();
            panel.Columns.Add(TableLayoutSizeType.Percent, 10);
            panel.Columns.Add(TableLayoutSizeType.Percent, 40);
            panel.Columns.Add(TableLayoutSizeType.Percent, 10);
            panel.Columns.Add(TableLayoutSizeType.Percent, 40);
            panel.Rows.Add(TableLayoutSizeType.Percent, 50);
            panel.Rows.Add(TableLayoutSizeType.Percent, 50);
            Label xLabel = new Label("X:");
            Label yLabel = new Label("Y:");
            xText = new TextBox();
            yText = new TextBox();
            panel.Controls.Add(xLabel, 0,0);
            panel.Controls.Add(yLabel, 0,2);
            panel.Controls.Add(xText, 0,1);
            panel.Controls.Add(yText, 0,3);
            addButton = new Button("Add");
            addButton.Click += new EventDelegate(addCoord);
            panel.Controls.Add(addButton, 1, 0, 1, 4);
            addDialog.SetControl(panel);
            addDialog.Text = "Add Coordinate:";
            addDialog.Size = new Size(250,150);
            addDialog.ShowDialog();
        }
    
        private void addCoord(object sender, Ansys.UI.Toolkit.EventArgs args)
        {
            ListViewItem item = new ListViewItem(xText.Text);
            item.SubItems.Add(yText.Text);
            listview.Items.Add(item);
            addDialog.Close();
        }
    
        private void removePoint(object sender, Ansys.UI.Toolkit.EventArgs args)
        {
            foreach(ListViewItem item in listview.SelectedItems)
            {
                listview.Items.Remove(item);
            }
        }
    
        private void Header_Click(object sender, ListViewColumnHeaderClickEventArgs args)
        {
            int colIndex = args.ColumnIndex;
            SortOrder order = SortOrder.None;
            if (listview.Sorting == SortOrder.Ascending)
            {
                order = SortOrder.Descending;
            }
            else
            {
                order = SortOrder.Ascending;
            }
            listview.Sorting = order;
            listview.Sort(colIndex, order);
        }
    }
}