﻿using System;
using System.Collections.Generic;

using Ansys.UI.Attributes;
using Ansys.UI.Interfaces;

namespace Ansys.ScratchAddin.Gui
{
    [GuiOperation("Example Toolbar Button", ImageName="ScratchImage")]
    [ToolbarButton("TabToolbar", Location = ToolbarItemBaseAttribute.ToolBarLocation.Main | ToolbarItemBaseAttribute.ToolBarLocation.TabToolbar)]
    [Visibility(AttributeOptions.InitialEnablingOn | AttributeOptions.InitialVisibilityOn)]
    [ApplicableView(TabSourceType = Ansys.UI.Views.TabContextView.ProjectTabName)]
    public class ShowMyDialogGuiOperation : IGuiOperation
    {
        public void Invoke(UI.GuiOperationContext context)
        {
            ListViewExampleDialog dialog = new ListViewExampleDialog();
            dialog.ShowDialog();
        }

        public void GuiItemCallBack(UI.GuiInformationContext context)
        {
            //not used.
        }
    }
}
